# Generated by Django 3.1.7 on 2021-03-18 09:17

from django.db import migrations, models
import django.db.models.deletion
import huscy.project_ethics.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('projects', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='Ethic',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('code', models.CharField(blank=True, default='', max_length=255)),
            ],
            options={
                'verbose_name': 'Ethic',
                'verbose_name_plural': 'Ethics',
                'ordering': ('-project', 'ethic_board__name'),
            },
        ),
        migrations.CreateModel(
            name='EthicBoard',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, unique=True)),
            ],
            options={
                'verbose_name': 'Ethic board',
                'verbose_name_plural': 'Ethic boards',
                'ordering': ('name',),
            },
        ),
        migrations.CreateModel(
            name='EthicFile',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('filetype', models.PositiveSmallIntegerField(choices=[(0, 'Proposal'), (1, 'Votum'), (2, 'Amendment')])),
                ('filehandle', models.FileField(upload_to=huscy.project_ethics.models.EthicFile.get_upload_path)),
                ('filename', models.CharField(max_length=255)),
                ('uploaded_at', models.DateTimeField(auto_now_add=True)),
                ('uploaded_by', models.CharField(editable=False, max_length=126)),
                ('ethic', models.ForeignKey(editable=False, on_delete=django.db.models.deletion.CASCADE, related_name='ethic_files', to='project_ethics.ethic')),
            ],
            options={
                'verbose_name': 'Ethic file',
                'verbose_name_plural': 'Ethic files',
                'ordering': ('-ethic__project', '-ethic', 'filename'),
            },
        ),
        migrations.AddField(
            model_name='ethic',
            name='ethic_board',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='project_ethics.ethicboard'),
        ),
        migrations.AddField(
            model_name='ethic',
            name='project',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='ethics', to='projects.project'),
        ),
        migrations.AlterUniqueTogether(
            name='ethic',
            unique_together={('project', 'ethic_board')},
        ),
    ]
