/*

 Copyright The Closure Library Authors.
 SPDX-License-Identifier: Apache-2.0
*/
var $jscomp = $jscomp || {};
$jscomp.scope = {};
$jscomp.arrayIteratorImpl = function(array) {
  var index = 0;
  return function() {
    return index < array.length ? {done:!1, value:array[index++], } : {done:!0};
  };
};
$jscomp.arrayIterator = function(array) {
  return {next:$jscomp.arrayIteratorImpl(array)};
};
$jscomp.ASSUME_ES5 = !1;
$jscomp.ASSUME_NO_NATIVE_MAP = !1;
$jscomp.ASSUME_NO_NATIVE_SET = !1;
$jscomp.SIMPLE_FROUND_POLYFILL = !1;
$jscomp.ISOLATE_POLYFILLS = !1;
$jscomp.defineProperty = $jscomp.ASSUME_ES5 || "function" == typeof Object.defineProperties ? Object.defineProperty : function(target, property, descriptor) {
  if (target == Array.prototype || target == Object.prototype) {
    return target;
  }
  target[property] = descriptor.value;
  return target;
};
$jscomp.getGlobal = function(passedInThis) {
  for (var possibleGlobals = ["object" == typeof globalThis && globalThis, passedInThis, "object" == typeof window && window, "object" == typeof self && self, "object" == typeof global && global, ], i = 0; i < possibleGlobals.length; ++i) {
    var maybeGlobal = possibleGlobals[i];
    if (maybeGlobal && maybeGlobal.Math == Math) {
      return maybeGlobal;
    }
  }
  return function() {
    throw Error("Cannot find global object");
  }();
};
$jscomp.global = $jscomp.getGlobal(this);
$jscomp.IS_SYMBOL_NATIVE = "function" === typeof Symbol && "symbol" === typeof Symbol("x");
$jscomp.TRUST_ES6_POLYFILLS = !$jscomp.ISOLATE_POLYFILLS || $jscomp.IS_SYMBOL_NATIVE;
$jscomp.polyfills = {};
$jscomp.propertyToPolyfillSymbol = {};
$jscomp.POLYFILL_PREFIX = "$jscp$";
var $jscomp$lookupPolyfilledValue = function(target, key) {
  var polyfilledKey = $jscomp.propertyToPolyfillSymbol[key];
  if (null == polyfilledKey) {
    return target[key];
  }
  var polyfill = target[polyfilledKey];
  return void 0 !== polyfill ? polyfill : target[key];
};
$jscomp.polyfill = function(target, polyfill, fromLang, toLang) {
  polyfill && ($jscomp.ISOLATE_POLYFILLS ? $jscomp.polyfillIsolated(target, polyfill, fromLang, toLang) : $jscomp.polyfillUnisolated(target, polyfill, fromLang, toLang));
};
$jscomp.polyfillUnisolated = function(target, polyfill, fromLang, toLang) {
  for (var obj = $jscomp.global, split = target.split("."), i = 0; i < split.length - 1; i++) {
    var key = split[i];
    key in obj || (obj[key] = {});
    obj = obj[key];
  }
  var property = split[split.length - 1], orig = obj[property], impl = polyfill(orig);
  impl != orig && null != impl && $jscomp.defineProperty(obj, property, {configurable:!0, writable:!0, value:impl});
};
$jscomp.polyfillIsolated = function(target, polyfill, fromLang, toLang) {
  var split = target.split("."), isNativeClass = 1 === split.length, root = split[0];
  var obj = !isNativeClass && root in $jscomp.polyfills ? $jscomp.polyfills : $jscomp.global;
  for (var i = 0; i < split.length - 1; i++) {
    var key = split[i];
    key in obj || (obj[key] = {});
    obj = obj[key];
  }
  var property = split[split.length - 1], nativeImpl = $jscomp.IS_SYMBOL_NATIVE && "es6" === fromLang ? obj[property] : null, impl = polyfill(nativeImpl);
  null != impl && (isNativeClass ? $jscomp.defineProperty($jscomp.polyfills, property, {configurable:!0, writable:!0, value:impl}) : impl !== nativeImpl && ($jscomp.propertyToPolyfillSymbol[property] = $jscomp.IS_SYMBOL_NATIVE ? $jscomp.global.Symbol(property) : $jscomp.POLYFILL_PREFIX + property, property = $jscomp.propertyToPolyfillSymbol[property], $jscomp.defineProperty(obj, property, {configurable:!0, writable:!0, value:impl})));
};
$jscomp.initSymbol = function() {
};
$jscomp.polyfill("Symbol", function(orig) {
  if (orig) {
    return orig;
  }
  var SymbolClass = function(id, opt_description) {
    this.$jscomp$symbol$id_ = id;
    $jscomp.defineProperty(this, "description", {configurable:!0, writable:!0, value:opt_description});
  };
  SymbolClass.prototype.toString = function() {
    return this.$jscomp$symbol$id_;
  };
  var counter = 0, symbolPolyfill = function(opt_description) {
    if (this instanceof symbolPolyfill) {
      throw new TypeError("Symbol is not a constructor");
    }
    return new SymbolClass("jscomp_symbol_" + (opt_description || "") + "_" + counter++, opt_description);
  };
  return symbolPolyfill;
}, "es6", "es3");
$jscomp.initSymbolIterator = function() {
};
$jscomp.polyfill("Symbol.iterator", function(orig) {
  if (orig) {
    return orig;
  }
  for (var symbolIterator = Symbol("Symbol.iterator"), arrayLikes = "Array Int8Array Uint8Array Uint8ClampedArray Int16Array Uint16Array Int32Array Uint32Array Float32Array Float64Array".split(" "), i = 0; i < arrayLikes.length; i++) {
    var ArrayLikeCtor = $jscomp.global[arrayLikes[i]];
    "function" === typeof ArrayLikeCtor && "function" != typeof ArrayLikeCtor.prototype[symbolIterator] && $jscomp.defineProperty(ArrayLikeCtor.prototype, symbolIterator, {configurable:!0, writable:!0, value:function() {
      return $jscomp.iteratorPrototype($jscomp.arrayIteratorImpl(this));
    }});
  }
  return symbolIterator;
}, "es6", "es3");
$jscomp.initSymbolAsyncIterator = function() {
};
$jscomp.iteratorPrototype = function(next) {
  var iterator = {next:next};
  iterator[Symbol.iterator] = function() {
    return this;
  };
  return iterator;
};
$jscomp.createTemplateTagFirstArg = function(arrayStrings) {
  return arrayStrings.raw = arrayStrings;
};
$jscomp.createTemplateTagFirstArgWithRaw = function(arrayStrings, rawArrayStrings) {
  arrayStrings.raw = rawArrayStrings;
  return arrayStrings;
};
$jscomp.makeIterator = function(iterable) {
  var iteratorFunction = "undefined" != typeof Symbol && Symbol.iterator && iterable[Symbol.iterator];
  return iteratorFunction ? iteratorFunction.call(iterable) : $jscomp.arrayIterator(iterable);
};
$jscomp.arrayFromIterator = function(iterator) {
  for (var i, arr = []; !(i = iterator.next()).done;) {
    arr.push(i.value);
  }
  return arr;
};
$jscomp.arrayFromIterable = function(iterable) {
  return iterable instanceof Array ? iterable : $jscomp.arrayFromIterator($jscomp.makeIterator(iterable));
};
$jscomp.objectCreate = $jscomp.ASSUME_ES5 || "function" == typeof Object.create ? Object.create : function(prototype) {
  var ctor = function() {
  };
  ctor.prototype = prototype;
  return new ctor;
};
$jscomp.getConstructImplementation = function() {
  function reflectConstructWorks() {
    function Base() {
    }
    new Base;
    Reflect.construct(Base, [], function Derived() {
    });
    return new Base instanceof Base;
  }
  if ($jscomp.TRUST_ES6_POLYFILLS && "undefined" != typeof Reflect && Reflect.construct) {
    if (reflectConstructWorks()) {
      return Reflect.construct;
    }
    var brokenConstruct = Reflect.construct;
    return function(target, argList, opt_newTarget) {
      var out = brokenConstruct(target, argList);
      opt_newTarget && Reflect.setPrototypeOf(out, opt_newTarget.prototype);
      return out;
    };
  }
  return function construct(target, argList, opt_newTarget) {
    void 0 === opt_newTarget && (opt_newTarget = target);
    var obj = $jscomp.objectCreate(opt_newTarget.prototype || Object.prototype);
    return Function.prototype.apply.call(target, obj, argList) || obj;
  };
};
$jscomp.construct = {valueOf:$jscomp.getConstructImplementation}.valueOf();
$jscomp.underscoreProtoCanBeSet = function() {
  var x = {a:!0}, y = {};
  try {
    return y.__proto__ = x, y.a;
  } catch (e) {
  }
  return !1;
};
$jscomp.setPrototypeOf = $jscomp.TRUST_ES6_POLYFILLS && "function" == typeof Object.setPrototypeOf ? Object.setPrototypeOf : $jscomp.underscoreProtoCanBeSet() ? function(target, proto) {
  target.__proto__ = proto;
  if (target.__proto__ !== proto) {
    throw new TypeError(target + " is not extensible");
  }
  return target;
} : null;
$jscomp.inherits = function(childCtor, parentCtor) {
  childCtor.prototype = $jscomp.objectCreate(parentCtor.prototype);
  childCtor.prototype.constructor = childCtor;
  if ($jscomp.setPrototypeOf) {
    var setPrototypeOf = $jscomp.setPrototypeOf;
    setPrototypeOf(childCtor, parentCtor);
  } else {
    for (var p in parentCtor) {
      if ("prototype" != p) {
        if (Object.defineProperties) {
          var descriptor = Object.getOwnPropertyDescriptor(parentCtor, p);
          descriptor && Object.defineProperty(childCtor, p, descriptor);
        } else {
          childCtor[p] = parentCtor[p];
        }
      }
    }
  }
  childCtor.superClass_ = parentCtor.prototype;
};
$jscomp.polyfill("Reflect.construct", function(orig) {
  return $jscomp.construct;
}, "es6", "es3");
$jscomp.polyfill("Reflect.setPrototypeOf", function(orig) {
  if (orig) {
    return orig;
  }
  if ($jscomp.setPrototypeOf) {
    var setPrototypeOf = $jscomp.setPrototypeOf;
    return function(target, proto) {
      try {
        return setPrototypeOf(target, proto), !0;
      } catch (e) {
        return !1;
      }
    };
  }
  return null;
}, "es6", "es5");
$jscomp.findInternal = function(array, callback, thisArg) {
  array instanceof String && (array = String(array));
  for (var len = array.length, i = 0; i < len; i++) {
    var value = array[i];
    if (callback.call(thisArg, value, i, array)) {
      return {i:i, v:value};
    }
  }
  return {i:-1, v:void 0};
};
$jscomp.polyfill("Array.prototype.find", function(orig) {
  return orig ? orig : function(callback, opt_thisArg) {
    return $jscomp.findInternal(this, callback, opt_thisArg).v;
  };
}, "es6", "es3");
$jscomp.checkStringArgs = function(thisArg, arg, func) {
  if (null == thisArg) {
    throw new TypeError("The 'this' value for String.prototype." + func + " must not be null or undefined");
  }
  if (arg instanceof RegExp) {
    throw new TypeError("First argument to String.prototype." + func + " must not be a regular expression");
  }
  return thisArg + "";
};
$jscomp.polyfill("String.prototype.endsWith", function(orig) {
  return orig ? orig : function(searchString, opt_position) {
    var string = $jscomp.checkStringArgs(this, searchString, "endsWith");
    searchString += "";
    void 0 === opt_position && (opt_position = string.length);
    for (var i = Math.max(0, Math.min(opt_position | 0, string.length)), j = searchString.length; 0 < j && 0 < i;) {
      if (string[--i] != searchString[--j]) {
        return !1;
      }
    }
    return 0 >= j;
  };
}, "es6", "es3");
$jscomp.polyfill("String.prototype.startsWith", function(orig) {
  return orig ? orig : function(searchString, opt_position) {
    var string = $jscomp.checkStringArgs(this, searchString, "startsWith");
    searchString += "";
    for (var strLen = string.length, searchLen = searchString.length, i = Math.max(0, Math.min(opt_position | 0, string.length)), j = 0; j < searchLen && i < strLen;) {
      if (string[i++] != searchString[j++]) {
        return !1;
      }
    }
    return j >= searchLen;
  };
}, "es6", "es3");
$jscomp.polyfill("String.prototype.repeat", function(orig) {
  return orig ? orig : function(copies) {
    var string = $jscomp.checkStringArgs(this, null, "repeat");
    if (0 > copies || 1342177279 < copies) {
      throw new RangeError("Invalid count value");
    }
    copies |= 0;
    for (var result = ""; copies;) {
      if (copies & 1 && (result += string), copies >>>= 1) {
        string += string;
      }
    }
    return result;
  };
}, "es6", "es3");
$jscomp.polyfill("Object.setPrototypeOf", function(orig) {
  return orig || $jscomp.setPrototypeOf;
}, "es6", "es5");
$jscomp.owns = function(obj, prop) {
  return Object.prototype.hasOwnProperty.call(obj, prop);
};
$jscomp.assign = $jscomp.TRUST_ES6_POLYFILLS && "function" == typeof Object.assign ? Object.assign : function(target, var_args) {
  for (var i = 1; i < arguments.length; i++) {
    var source = arguments[i];
    if (source) {
      for (var key in source) {
        $jscomp.owns(source, key) && (target[key] = source[key]);
      }
    }
  }
  return target;
};
$jscomp.polyfill("Object.assign", function(orig) {
  return orig || $jscomp.assign;
}, "es6", "es3");
$jscomp.FORCE_POLYFILL_PROMISE = !1;
$jscomp.polyfill("Promise", function(NativePromise) {
  function AsyncExecutor() {
    this.batch_ = null;
  }
  function isObject(value) {
    switch(typeof value) {
      case "object":
        return null != value;
      case "function":
        return !0;
      default:
        return !1;
    }
  }
  function resolvingPromise(opt_value) {
    return opt_value instanceof PolyfillPromise ? opt_value : new PolyfillPromise(function(resolve, reject) {
      resolve(opt_value);
    });
  }
  if (NativePromise && !$jscomp.FORCE_POLYFILL_PROMISE) {
    return NativePromise;
  }
  AsyncExecutor.prototype.asyncExecute = function(f) {
    if (null == this.batch_) {
      this.batch_ = [];
      var self = this;
      this.asyncExecuteFunction(function() {
        self.executeBatch_();
      });
    }
    this.batch_.push(f);
  };
  var nativeSetTimeout = $jscomp.global.setTimeout;
  AsyncExecutor.prototype.asyncExecuteFunction = function(f) {
    nativeSetTimeout(f, 0);
  };
  AsyncExecutor.prototype.executeBatch_ = function() {
    for (; this.batch_ && this.batch_.length;) {
      var executingBatch = this.batch_;
      this.batch_ = [];
      for (var i = 0; i < executingBatch.length; ++i) {
        var f = executingBatch[i];
        executingBatch[i] = null;
        try {
          f();
        } catch (error) {
          this.asyncThrow_(error);
        }
      }
    }
    this.batch_ = null;
  };
  AsyncExecutor.prototype.asyncThrow_ = function(exception) {
    this.asyncExecuteFunction(function() {
      throw exception;
    });
  };
  var PromiseState = {PENDING:0, FULFILLED:1, REJECTED:2}, PolyfillPromise = function(executor) {
    this.state_ = PromiseState.PENDING;
    this.result_ = void 0;
    this.onSettledCallbacks_ = [];
    var resolveAndReject = this.createResolveAndReject_();
    try {
      executor(resolveAndReject.resolve, resolveAndReject.reject);
    } catch (e) {
      resolveAndReject.reject(e);
    }
  };
  PolyfillPromise.prototype.createResolveAndReject_ = function() {
    function firstCallWins(method) {
      return function(x) {
        alreadyCalled || (alreadyCalled = !0, method.call(thisPromise, x));
      };
    }
    var thisPromise = this, alreadyCalled = !1;
    return {resolve:firstCallWins(this.resolveTo_), reject:firstCallWins(this.reject_)};
  };
  PolyfillPromise.prototype.resolveTo_ = function(value) {
    value === this ? this.reject_(new TypeError("A Promise cannot resolve to itself")) : value instanceof PolyfillPromise ? this.settleSameAsPromise_(value) : isObject(value) ? this.resolveToNonPromiseObj_(value) : this.fulfill_(value);
  };
  PolyfillPromise.prototype.resolveToNonPromiseObj_ = function(obj) {
    var thenMethod = void 0;
    try {
      thenMethod = obj.then;
    } catch (error) {
      this.reject_(error);
      return;
    }
    "function" == typeof thenMethod ? this.settleSameAsThenable_(thenMethod, obj) : this.fulfill_(obj);
  };
  PolyfillPromise.prototype.reject_ = function(reason) {
    this.settle_(PromiseState.REJECTED, reason);
  };
  PolyfillPromise.prototype.fulfill_ = function(value) {
    this.settle_(PromiseState.FULFILLED, value);
  };
  PolyfillPromise.prototype.settle_ = function(settledState, valueOrReason) {
    if (this.state_ != PromiseState.PENDING) {
      throw Error("Cannot settle(" + settledState + ", " + valueOrReason + "): Promise already settled in state" + this.state_);
    }
    this.state_ = settledState;
    this.result_ = valueOrReason;
    this.executeOnSettledCallbacks_();
  };
  PolyfillPromise.prototype.executeOnSettledCallbacks_ = function() {
    if (null != this.onSettledCallbacks_) {
      for (var i = 0; i < this.onSettledCallbacks_.length; ++i) {
        asyncExecutor.asyncExecute(this.onSettledCallbacks_[i]);
      }
      this.onSettledCallbacks_ = null;
    }
  };
  var asyncExecutor = new AsyncExecutor;
  PolyfillPromise.prototype.settleSameAsPromise_ = function(promise) {
    var methods = this.createResolveAndReject_();
    promise.callWhenSettled_(methods.resolve, methods.reject);
  };
  PolyfillPromise.prototype.settleSameAsThenable_ = function(thenMethod, thenable) {
    var methods = this.createResolveAndReject_();
    try {
      thenMethod.call(thenable, methods.resolve, methods.reject);
    } catch (error) {
      methods.reject(error);
    }
  };
  PolyfillPromise.prototype.then = function(onFulfilled, onRejected) {
    function createCallback(paramF, defaultF) {
      return "function" == typeof paramF ? function(x) {
        try {
          resolveChild(paramF(x));
        } catch (error) {
          rejectChild(error);
        }
      } : defaultF;
    }
    var resolveChild, rejectChild, childPromise = new PolyfillPromise(function(resolve, reject) {
      resolveChild = resolve;
      rejectChild = reject;
    });
    this.callWhenSettled_(createCallback(onFulfilled, resolveChild), createCallback(onRejected, rejectChild));
    return childPromise;
  };
  PolyfillPromise.prototype.catch = function(onRejected) {
    return this.then(void 0, onRejected);
  };
  PolyfillPromise.prototype.callWhenSettled_ = function(onFulfilled, onRejected) {
    function callback() {
      switch(thisPromise.state_) {
        case PromiseState.FULFILLED:
          onFulfilled(thisPromise.result_);
          break;
        case PromiseState.REJECTED:
          onRejected(thisPromise.result_);
          break;
        default:
          throw Error("Unexpected state: " + thisPromise.state_);
      }
    }
    var thisPromise = this;
    null == this.onSettledCallbacks_ ? asyncExecutor.asyncExecute(callback) : this.onSettledCallbacks_.push(callback);
  };
  PolyfillPromise.resolve = resolvingPromise;
  PolyfillPromise.reject = function(opt_reason) {
    return new PolyfillPromise(function(resolve, reject) {
      reject(opt_reason);
    });
  };
  PolyfillPromise.race = function(thenablesOrValues) {
    return new PolyfillPromise(function(resolve, reject) {
      for (var iterator = $jscomp.makeIterator(thenablesOrValues), iterRec = iterator.next(); !iterRec.done; iterRec = iterator.next()) {
        resolvingPromise(iterRec.value).callWhenSettled_(resolve, reject);
      }
    });
  };
  PolyfillPromise.all = function(thenablesOrValues) {
    var iterator = $jscomp.makeIterator(thenablesOrValues), iterRec = iterator.next();
    return iterRec.done ? resolvingPromise([]) : new PolyfillPromise(function(resolveAll, rejectAll) {
      function onFulfilled(i) {
        return function(ithResult) {
          resultsArray[i] = ithResult;
          unresolvedCount--;
          0 == unresolvedCount && resolveAll(resultsArray);
        };
      }
      var resultsArray = [], unresolvedCount = 0;
      do {
        resultsArray.push(void 0), unresolvedCount++, resolvingPromise(iterRec.value).callWhenSettled_(onFulfilled(resultsArray.length - 1), rejectAll), iterRec = iterator.next();
      } while (!iterRec.done);
    });
  };
  return PolyfillPromise;
}, "es6", "es3");
$jscomp.iteratorFromArray = function(array, transform) {
  array instanceof String && (array += "");
  var i = 0, iter = {next:function() {
    if (i < array.length) {
      var index = i++;
      return {value:transform(index, array[index]), done:!1};
    }
    iter.next = function() {
      return {done:!0, value:void 0};
    };
    return iter.next();
  }};
  iter[Symbol.iterator] = function() {
    return iter;
  };
  return iter;
};
$jscomp.polyfill("Array.prototype.keys", function(orig) {
  return orig ? orig : function() {
    return $jscomp.iteratorFromArray(this, function(i) {
      return i;
    });
  };
}, "es6", "es3");
$jscomp.polyfill("Object.entries", function(orig) {
  return orig ? orig : function(obj) {
    var result = [], key;
    for (key in obj) {
      $jscomp.owns(obj, key) && result.push([key, obj[key]]);
    }
    return result;
  };
}, "es8", "es3");
$jscomp.polyfill("Object.is", function(orig) {
  return orig ? orig : function(left, right) {
    return left === right ? 0 !== left || 1 / left === 1 / right : left !== left && right !== right;
  };
}, "es6", "es3");
$jscomp.polyfill("Array.prototype.includes", function(orig) {
  return orig ? orig : function(searchElement, opt_fromIndex) {
    var array = this;
    array instanceof String && (array = String(array));
    var len = array.length, i = opt_fromIndex || 0;
    for (0 > i && (i = Math.max(i + len, 0)); i < len; i++) {
      var element = array[i];
      if (element === searchElement || Object.is(element, searchElement)) {
        return !0;
      }
    }
    return !1;
  };
}, "es7", "es3");
$jscomp.polyfill("String.prototype.includes", function(orig) {
  return orig ? orig : function(searchString, opt_position) {
    return -1 !== $jscomp.checkStringArgs(this, searchString, "includes").indexOf(searchString, opt_position || 0);
  };
}, "es6", "es3");
$jscomp.polyfill("Array.prototype.values", function(orig) {
  return orig ? orig : function() {
    return $jscomp.iteratorFromArray(this, function(k, v) {
      return v;
    });
  };
}, "es8", "es3");
$jscomp.checkEs6ConformanceViaProxy = function() {
  try {
    var proxied = {}, proxy = Object.create(new $jscomp.global.Proxy(proxied, {get:function(target, key, receiver) {
      return target == proxied && "q" == key && receiver == proxy;
    }}));
    return !0 === proxy.q;
  } catch (err) {
    return !1;
  }
};
$jscomp.USE_PROXY_FOR_ES6_CONFORMANCE_CHECKS = !1;
$jscomp.ES6_CONFORMANCE = $jscomp.USE_PROXY_FOR_ES6_CONFORMANCE_CHECKS && $jscomp.checkEs6ConformanceViaProxy();
$jscomp.polyfill("WeakMap", function(NativeWeakMap) {
  function isConformant() {
    if (!NativeWeakMap || !Object.seal) {
      return !1;
    }
    try {
      var x = Object.seal({}), y = Object.seal({}), map = new NativeWeakMap([[x, 2], [y, 3]]);
      if (2 != map.get(x) || 3 != map.get(y)) {
        return !1;
      }
      map.delete(x);
      map.set(y, 4);
      return !map.has(x) && 4 == map.get(y);
    } catch (err) {
      return !1;
    }
  }
  function WeakMapMembership() {
  }
  function isValidKey(key) {
    var type = typeof key;
    return "object" === type && null !== key || "function" === type;
  }
  function insert(target) {
    if (!$jscomp.owns(target, prop)) {
      var obj = new WeakMapMembership;
      $jscomp.defineProperty(target, prop, {value:obj});
    }
  }
  function patch(name) {
    if (!$jscomp.ISOLATE_POLYFILLS) {
      var prev = Object[name];
      prev && (Object[name] = function(target) {
        if (target instanceof WeakMapMembership) {
          return target;
        }
        Object.isExtensible(target) && insert(target);
        return prev(target);
      });
    }
  }
  if ($jscomp.USE_PROXY_FOR_ES6_CONFORMANCE_CHECKS) {
    if (NativeWeakMap && $jscomp.ES6_CONFORMANCE) {
      return NativeWeakMap;
    }
  } else {
    if (isConformant()) {
      return NativeWeakMap;
    }
  }
  var prop = "$jscomp_hidden_" + Math.random();
  patch("freeze");
  patch("preventExtensions");
  patch("seal");
  var index = 0, PolyfillWeakMap = function(opt_iterable) {
    this.id_ = (index += Math.random() + 1).toString();
    if (opt_iterable) {
      for (var iter = $jscomp.makeIterator(opt_iterable), entry; !(entry = iter.next()).done;) {
        var item = entry.value;
        this.set(item[0], item[1]);
      }
    }
  };
  PolyfillWeakMap.prototype.set = function(key, value) {
    if (!isValidKey(key)) {
      throw Error("Invalid WeakMap key");
    }
    insert(key);
    if (!$jscomp.owns(key, prop)) {
      throw Error("WeakMap key fail: " + key);
    }
    key[prop][this.id_] = value;
    return this;
  };
  PolyfillWeakMap.prototype.get = function(key) {
    return isValidKey(key) && $jscomp.owns(key, prop) ? key[prop][this.id_] : void 0;
  };
  PolyfillWeakMap.prototype.has = function(key) {
    return isValidKey(key) && $jscomp.owns(key, prop) && $jscomp.owns(key[prop], this.id_);
  };
  PolyfillWeakMap.prototype.delete = function(key) {
    return isValidKey(key) && $jscomp.owns(key, prop) && $jscomp.owns(key[prop], this.id_) ? delete key[prop][this.id_] : !1;
  };
  return PolyfillWeakMap;
}, "es6", "es3");
$jscomp.MapEntry = function() {
};
$jscomp.polyfill("Map", function(NativeMap) {
  function isConformant() {
    if ($jscomp.ASSUME_NO_NATIVE_MAP || !NativeMap || "function" != typeof NativeMap || !NativeMap.prototype.entries || "function" != typeof Object.seal) {
      return !1;
    }
    try {
      var key = Object.seal({x:4}), map = new NativeMap($jscomp.makeIterator([[key, "s"]]));
      if ("s" != map.get(key) || 1 != map.size || map.get({x:4}) || map.set({x:4}, "t") != map || 2 != map.size) {
        return !1;
      }
      var iter = map.entries(), item = iter.next();
      if (item.done || item.value[0] != key || "s" != item.value[1]) {
        return !1;
      }
      item = iter.next();
      return item.done || 4 != item.value[0].x || "t" != item.value[1] || !iter.next().done ? !1 : !0;
    } catch (err) {
      return !1;
    }
  }
  if ($jscomp.USE_PROXY_FOR_ES6_CONFORMANCE_CHECKS) {
    if (NativeMap && $jscomp.ES6_CONFORMANCE) {
      return NativeMap;
    }
  } else {
    if (isConformant()) {
      return NativeMap;
    }
  }
  var idMap = new WeakMap, PolyfillMap = function(opt_iterable) {
    this.data_ = {};
    this.head_ = createHead();
    this.size = 0;
    if (opt_iterable) {
      for (var iter = $jscomp.makeIterator(opt_iterable), entry; !(entry = iter.next()).done;) {
        var item = entry.value;
        this.set(item[0], item[1]);
      }
    }
  };
  PolyfillMap.prototype.set = function(key, value) {
    key = 0 === key ? 0 : key;
    var r = maybeGetEntry(this, key);
    r.list || (r.list = this.data_[r.id] = []);
    r.entry ? r.entry.value = value : (r.entry = {next:this.head_, previous:this.head_.previous, head:this.head_, key:key, value:value, }, r.list.push(r.entry), this.head_.previous.next = r.entry, this.head_.previous = r.entry, this.size++);
    return this;
  };
  PolyfillMap.prototype.delete = function(key) {
    var r = maybeGetEntry(this, key);
    return r.entry && r.list ? (r.list.splice(r.index, 1), r.list.length || delete this.data_[r.id], r.entry.previous.next = r.entry.next, r.entry.next.previous = r.entry.previous, r.entry.head = null, this.size--, !0) : !1;
  };
  PolyfillMap.prototype.clear = function() {
    this.data_ = {};
    this.head_ = this.head_.previous = createHead();
    this.size = 0;
  };
  PolyfillMap.prototype.has = function(key) {
    return !!maybeGetEntry(this, key).entry;
  };
  PolyfillMap.prototype.get = function(key) {
    var entry = maybeGetEntry(this, key).entry;
    return entry && entry.value;
  };
  PolyfillMap.prototype.entries = function() {
    return makeIterator(this, function(entry) {
      return [entry.key, entry.value];
    });
  };
  PolyfillMap.prototype.keys = function() {
    return makeIterator(this, function(entry) {
      return entry.key;
    });
  };
  PolyfillMap.prototype.values = function() {
    return makeIterator(this, function(entry) {
      return entry.value;
    });
  };
  PolyfillMap.prototype.forEach = function(callback, opt_thisArg) {
    for (var iter = this.entries(), item; !(item = iter.next()).done;) {
      var entry = item.value;
      callback.call(opt_thisArg, entry[1], entry[0], this);
    }
  };
  PolyfillMap.prototype[Symbol.iterator] = PolyfillMap.prototype.entries;
  var maybeGetEntry = function(map, key) {
    var id = getId(key), list = map.data_[id];
    if (list && $jscomp.owns(map.data_, id)) {
      for (var index = 0; index < list.length; index++) {
        var entry = list[index];
        if (key !== key && entry.key !== entry.key || key === entry.key) {
          return {id:id, list:list, index:index, entry:entry};
        }
      }
    }
    return {id:id, list:list, index:-1, entry:void 0};
  }, makeIterator = function(map, func) {
    var entry = map.head_;
    return $jscomp.iteratorPrototype(function() {
      if (entry) {
        for (; entry.head != map.head_;) {
          entry = entry.previous;
        }
        for (; entry.next != entry.head;) {
          return entry = entry.next, {done:!1, value:func(entry)};
        }
        entry = null;
      }
      return {done:!0, value:void 0};
    });
  }, createHead = function() {
    var head = {};
    return head.previous = head.next = head.head = head;
  }, mapIndex = 0, getId = function(obj) {
    var type = obj && typeof obj;
    if ("object" == type || "function" == type) {
      if (!idMap.has(obj)) {
        var id = "" + ++mapIndex;
        idMap.set(obj, id);
        return id;
      }
      return idMap.get(obj);
    }
    return "p_" + obj;
  };
  return PolyfillMap;
}, "es6", "es3");
$jscomp.polyfill("Set", function(NativeSet) {
  function isConformant() {
    if ($jscomp.ASSUME_NO_NATIVE_SET || !NativeSet || "function" != typeof NativeSet || !NativeSet.prototype.entries || "function" != typeof Object.seal) {
      return !1;
    }
    try {
      var value = Object.seal({x:4}), set = new NativeSet($jscomp.makeIterator([value]));
      if (!set.has(value) || 1 != set.size || set.add(value) != set || 1 != set.size || set.add({x:4}) != set || 2 != set.size) {
        return !1;
      }
      var iter = set.entries(), item = iter.next();
      if (item.done || item.value[0] != value || item.value[1] != value) {
        return !1;
      }
      item = iter.next();
      return item.done || item.value[0] == value || 4 != item.value[0].x || item.value[1] != item.value[0] ? !1 : iter.next().done;
    } catch (err) {
      return !1;
    }
  }
  if ($jscomp.USE_PROXY_FOR_ES6_CONFORMANCE_CHECKS) {
    if (NativeSet && $jscomp.ES6_CONFORMANCE) {
      return NativeSet;
    }
  } else {
    if (isConformant()) {
      return NativeSet;
    }
  }
  var PolyfillSet = function(opt_iterable) {
    this.map_ = new Map;
    if (opt_iterable) {
      for (var iter = $jscomp.makeIterator(opt_iterable), entry; !(entry = iter.next()).done;) {
        this.add(entry.value);
      }
    }
    this.size = this.map_.size;
  };
  PolyfillSet.prototype.add = function(value) {
    value = 0 === value ? 0 : value;
    this.map_.set(value, value);
    this.size = this.map_.size;
    return this;
  };
  PolyfillSet.prototype.delete = function(value) {
    var result = this.map_.delete(value);
    this.size = this.map_.size;
    return result;
  };
  PolyfillSet.prototype.clear = function() {
    this.map_.clear();
    this.size = 0;
  };
  PolyfillSet.prototype.has = function(value) {
    return this.map_.has(value);
  };
  PolyfillSet.prototype.entries = function() {
    return this.map_.entries();
  };
  PolyfillSet.prototype.values = function() {
    return this.map_.values();
  };
  PolyfillSet.prototype.keys = PolyfillSet.prototype.values;
  PolyfillSet.prototype[Symbol.iterator] = PolyfillSet.prototype.values;
  PolyfillSet.prototype.forEach = function(callback, opt_thisArg) {
    var set = this;
    this.map_.forEach(function(value) {
      return callback.call(opt_thisArg, value, value, set);
    });
  };
  return PolyfillSet;
}, "es6", "es3");
$jscomp.polyfill("Object.values", function(orig) {
  return orig ? orig : function(obj) {
    var result = [], key;
    for (key in obj) {
      $jscomp.owns(obj, key) && result.push(obj[key]);
    }
    return result;
  };
}, "es8", "es3");
$jscomp.stringPadding = function(padString, padLength) {
  var padding = void 0 !== padString ? String(padString) : " ";
  return 0 < padLength && padding ? padding.repeat(Math.ceil(padLength / padding.length)).substring(0, padLength) : "";
};
$jscomp.polyfill("String.prototype.padStart", function(orig) {
  return orig ? orig : function(targetLength, opt_padString) {
    var string = $jscomp.checkStringArgs(this, null, "padStart");
    return $jscomp.stringPadding(opt_padString, targetLength - string.length) + string;
  };
}, "es8", "es3");
var goog = goog || {};
goog.global = this || self;
goog.exportPath_ = function(name, opt_object, opt_objectToExportTo) {
  var parts = name.split("."), cur = opt_objectToExportTo || goog.global;
  parts[0] in cur || "undefined" == typeof cur.execScript || cur.execScript("var " + parts[0]);
  for (var part; parts.length && (part = parts.shift());) {
    parts.length || void 0 === opt_object ? cur = cur[part] && cur[part] !== Object.prototype[part] ? cur[part] : cur[part] = {} : cur[part] = opt_object;
  }
};
goog.define = function(name, defaultValue) {
  var defines, uncompiledDefines;
  return defaultValue;
};
goog.FEATURESET_YEAR = 2012;
goog.DEBUG = !0;
goog.LOCALE = "en";
goog.TRUSTED_SITE = !0;
goog.DISALLOW_TEST_ONLY_CODE = !goog.DEBUG;
goog.ENABLE_CHROME_APP_SAFE_SCRIPT_LOADING = !1;
goog.provide = function(name) {
  if (goog.isInModuleLoader_()) {
    throw Error("goog.provide cannot be used within a module.");
  }
  goog.constructNamespace_(name);
};
goog.constructNamespace_ = function(name, opt_obj) {
  var namespace;
  goog.exportPath_(name, opt_obj);
};
goog.getScriptNonce = function(opt_window) {
  if (opt_window && opt_window != goog.global) {
    return goog.getScriptNonce_(opt_window.document);
  }
  null === goog.cspNonce_ && (goog.cspNonce_ = goog.getScriptNonce_(goog.global.document));
  return goog.cspNonce_;
};
goog.NONCE_PATTERN_ = /^[\w+/_-]+[=]{0,2}$/;
goog.cspNonce_ = null;
goog.getScriptNonce_ = function(doc) {
  var script = doc.querySelector && doc.querySelector("script[nonce]");
  if (script) {
    var nonce = script.nonce || script.getAttribute("nonce");
    if (nonce && goog.NONCE_PATTERN_.test(nonce)) {
      return nonce;
    }
  }
  return "";
};
goog.VALID_MODULE_RE_ = /^[a-zA-Z_$][a-zA-Z0-9._$]*$/;
goog.module = function(name) {
  if ("string" !== typeof name || !name || -1 == name.search(goog.VALID_MODULE_RE_)) {
    throw Error("Invalid module identifier");
  }
  if (!goog.isInGoogModuleLoader_()) {
    throw Error("Module " + name + " has been loaded incorrectly. Note, modules cannot be loaded as normal scripts. They require some kind of pre-processing step. You're likely trying to load a module via a script tag or as a part of a concatenated bundle without rewriting the module. For more info see: https://github.com/google/closure-library/wiki/goog.module:-an-ES6-module-like-alternative-to-goog.provide.");
  }
  if (goog.moduleLoaderState_.moduleName) {
    throw Error("goog.module may only be called once per module.");
  }
  goog.moduleLoaderState_.moduleName = name;
};
goog.module.get = function(name) {
  return goog.module.getInternal_(name);
};
goog.module.getInternal_ = function(name) {
  var ns;
  return null;
};
goog.ModuleType = {ES6:"es6", GOOG:"goog"};
goog.moduleLoaderState_ = null;
goog.isInModuleLoader_ = function() {
  return goog.isInGoogModuleLoader_() || goog.isInEs6ModuleLoader_();
};
goog.isInGoogModuleLoader_ = function() {
  return !!goog.moduleLoaderState_ && goog.moduleLoaderState_.type == goog.ModuleType.GOOG;
};
goog.isInEs6ModuleLoader_ = function() {
  if (goog.moduleLoaderState_ && goog.moduleLoaderState_.type == goog.ModuleType.ES6) {
    return !0;
  }
  var jscomp = goog.global.$jscomp;
  return jscomp ? "function" != typeof jscomp.getCurrentModulePath ? !1 : !!jscomp.getCurrentModulePath() : !1;
};
goog.module.declareLegacyNamespace = function() {
  goog.moduleLoaderState_.declareLegacyNamespace = !0;
};
goog.declareModuleId = function(namespace) {
  if (goog.moduleLoaderState_) {
    goog.moduleLoaderState_.moduleName = namespace;
  } else {
    var jscomp = goog.global.$jscomp;
    if (!jscomp || "function" != typeof jscomp.getCurrentModulePath) {
      throw Error('Module with namespace "' + namespace + '" has been loaded incorrectly.');
    }
    var exports = jscomp.require(jscomp.getCurrentModulePath());
    goog.loadedModules_[namespace] = {exports:exports, type:goog.ModuleType.ES6, moduleId:namespace};
  }
};
goog.setTestOnly = function(opt_message) {
  if (goog.DISALLOW_TEST_ONLY_CODE) {
    throw opt_message = opt_message || "", Error("Importing test-only code into non-debug environment" + (opt_message ? ": " + opt_message : "."));
  }
};
goog.forwardDeclare = function(name) {
};
goog.getObjectByName = function(name, opt_obj) {
  for (var parts = name.split("."), cur = opt_obj || goog.global, i = 0; i < parts.length; i++) {
    if (cur = cur[parts[i]], null == cur) {
      return null;
    }
  }
  return cur;
};
goog.addDependency = function(relPath, provides, requires, opt_loadFlags) {
};
goog.useStrictRequires = !1;
goog.ENABLE_DEBUG_LOADER = !0;
goog.logToConsole_ = function(msg) {
  goog.global.console && goog.global.console.error(msg);
};
goog.require = function(namespace) {
  var moduleLoaderState;
};
goog.requireType = function(namespace) {
  return {};
};
goog.basePath = "";
goog.nullFunction = function() {
};
goog.abstractMethod = function() {
  throw Error("unimplemented abstract method");
};
goog.addSingletonGetter = function(ctor) {
  ctor.instance_ = void 0;
  ctor.getInstance = function() {
    if (ctor.instance_) {
      return ctor.instance_;
    }
    goog.DEBUG && (goog.instantiatedSingletons_[goog.instantiatedSingletons_.length] = ctor);
    return ctor.instance_ = new ctor;
  };
};
goog.instantiatedSingletons_ = [];
goog.LOAD_MODULE_USING_EVAL = !0;
goog.SEAL_MODULE_EXPORTS = goog.DEBUG;
goog.loadedModules_ = {};
goog.DEPENDENCIES_ENABLED = !1;
goog.TRANSPILE = "detect";
goog.ASSUME_ES_MODULES_TRANSPILED = !1;
goog.TRANSPILE_TO_LANGUAGE = "";
goog.TRANSPILER = "transpile.js";
goog.hasBadLetScoping = null;
goog.useSafari10Workaround = function() {
  if (null == goog.hasBadLetScoping) {
    try {
      var hasBadLetScoping = !eval('"use strict";let x = 1; function f() { return typeof x; };f() == "number";');
    } catch (e) {
      hasBadLetScoping = !1;
    }
    goog.hasBadLetScoping = hasBadLetScoping;
  }
  return goog.hasBadLetScoping;
};
goog.workaroundSafari10EvalBug = function(moduleDef) {
  return "(function(){" + moduleDef + "\n;})();\n";
};
goog.loadModule = function(moduleDef) {
  var previousState = goog.moduleLoaderState_;
  try {
    goog.moduleLoaderState_ = {moduleName:"", declareLegacyNamespace:!1, type:goog.ModuleType.GOOG};
    if (goog.isFunction(moduleDef)) {
      var exports = moduleDef.call(void 0, {});
    } else {
      if ("string" === typeof moduleDef) {
        goog.useSafari10Workaround() && (moduleDef = goog.workaroundSafari10EvalBug(moduleDef)), exports = goog.loadModuleFromSource_.call(void 0, moduleDef);
      } else {
        throw Error("Invalid module definition");
      }
    }
    var moduleName = goog.moduleLoaderState_.moduleName;
    if ("string" === typeof moduleName && moduleName) {
      goog.moduleLoaderState_.declareLegacyNamespace ? goog.constructNamespace_(moduleName, exports) : goog.SEAL_MODULE_EXPORTS && Object.seal && "object" == typeof exports && null != exports && Object.seal(exports), goog.loadedModules_[moduleName] = {exports:exports, type:goog.ModuleType.GOOG, moduleId:goog.moduleLoaderState_.moduleName};
    } else {
      throw Error('Invalid module name "' + moduleName + '"');
    }
  } finally {
    goog.moduleLoaderState_ = previousState;
  }
};
goog.loadModuleFromSource_ = function(JSCompiler_OptimizeArgumentsArray_p0) {
  eval(JSCompiler_OptimizeArgumentsArray_p0);
  return {};
};
goog.normalizePath_ = function(path) {
  for (var components = path.split("/"), i = 0; i < components.length;) {
    "." == components[i] ? components.splice(i, 1) : i && ".." == components[i] && components[i - 1] && ".." != components[i - 1] ? components.splice(--i, 2) : i++;
  }
  return components.join("/");
};
goog.loadFileSync_ = function(src) {
  if (goog.global.CLOSURE_LOAD_FILE_SYNC) {
    return goog.global.CLOSURE_LOAD_FILE_SYNC(src);
  }
  try {
    var xhr = new goog.global.XMLHttpRequest;
    xhr.open("get", src, !1);
    xhr.send();
    return 0 == xhr.status || 200 == xhr.status ? xhr.responseText : null;
  } catch (err) {
    return null;
  }
};
goog.transpile_ = function(code$jscomp$0, path$jscomp$0, target) {
  var jscomp = goog.global.$jscomp;
  jscomp || (goog.global.$jscomp = jscomp = {});
  var transpile = jscomp.transpile;
  if (!transpile) {
    var transpilerPath = goog.basePath + goog.TRANSPILER, transpilerCode = goog.loadFileSync_(transpilerPath);
    if (transpilerCode) {
      (function() {
        (0,eval)(transpilerCode + "\n//# sourceURL=" + transpilerPath);
      }).call(goog.global);
      if (goog.global.$gwtExport && goog.global.$gwtExport.$jscomp && !goog.global.$gwtExport.$jscomp.transpile) {
        throw Error('The transpiler did not properly export the "transpile" method. $gwtExport: ' + JSON.stringify(goog.global.$gwtExport));
      }
      goog.global.$jscomp.transpile = goog.global.$gwtExport.$jscomp.transpile;
      jscomp = goog.global.$jscomp;
      transpile = jscomp.transpile;
    }
  }
  if (!transpile) {
    var suffix = " requires transpilation but no transpiler was found.";
    suffix += ' Please add "//javascript/closure:transpiler" as a data dependency to ensure it is included.';
    transpile = jscomp.transpile = function(code, path) {
      goog.logToConsole_(path + suffix);
      return code;
    };
  }
  return transpile(code$jscomp$0, path$jscomp$0, target);
};
goog.typeOf = function(value) {
  var s = typeof value;
  return "object" != s ? s : value ? Array.isArray(value) ? "array" : s : "null";
};
goog.isArray = function(val) {
  return Array.isArray(val);
};
goog.isArrayLike = function(val) {
  var type = goog.typeOf(val);
  return "array" == type || "object" == type && "number" == typeof val.length;
};
goog.isDateLike = function(val) {
  return goog.isObject(val) && "function" == typeof val.getFullYear;
};
goog.isFunction = function(val) {
  return "function" == goog.typeOf(val);
};
goog.isObject = function(val) {
  var type = typeof val;
  return "object" == type && null != val || "function" == type;
};
goog.getUid = function(obj) {
  return Object.prototype.hasOwnProperty.call(obj, goog.UID_PROPERTY_) && obj[goog.UID_PROPERTY_] || (obj[goog.UID_PROPERTY_] = ++goog.uidCounter_);
};
goog.hasUid = function(obj) {
  return !!obj[goog.UID_PROPERTY_];
};
goog.removeUid = function(obj) {
  null !== obj && "removeAttribute" in obj && obj.removeAttribute(goog.UID_PROPERTY_);
  try {
    delete obj[goog.UID_PROPERTY_];
  } catch (ex) {
  }
};
goog.UID_PROPERTY_ = "closure_uid_" + (1e9 * Math.random() >>> 0);
goog.uidCounter_ = 0;
goog.cloneObject = function(obj) {
  var type = goog.typeOf(obj);
  if ("object" == type || "array" == type) {
    if ("function" === typeof obj.clone) {
      return obj.clone();
    }
    var clone = "array" == type ? [] : {}, key;
    for (key in obj) {
      clone[key] = goog.cloneObject(obj[key]);
    }
    return clone;
  }
  return obj;
};
goog.bindNative_ = function(fn, selfObj, var_args) {
  return fn.call.apply(fn.bind, arguments);
};
goog.bindJs_ = function(fn, selfObj, var_args) {
  if (!fn) {
    throw Error();
  }
  if (2 < arguments.length) {
    var boundArgs = Array.prototype.slice.call(arguments, 2);
    return function() {
      var newArgs = Array.prototype.slice.call(arguments);
      Array.prototype.unshift.apply(newArgs, boundArgs);
      return fn.apply(selfObj, newArgs);
    };
  }
  return function() {
    return fn.apply(selfObj, arguments);
  };
};
goog.bind = function(fn, selfObj, var_args) {
  Function.prototype.bind && -1 != Function.prototype.bind.toString().indexOf("native code") ? goog.bind = goog.bindNative_ : goog.bind = goog.bindJs_;
  return goog.bind.apply(null, arguments);
};
goog.partial = function(fn, var_args) {
  var args = Array.prototype.slice.call(arguments, 1);
  return function() {
    var newArgs = args.slice();
    newArgs.push.apply(newArgs, arguments);
    return fn.apply(this, newArgs);
  };
};
goog.mixin = function(target, source) {
  for (var x in source) {
    target[x] = source[x];
  }
};
goog.now = goog.TRUSTED_SITE && Date.now || function() {
  return +new Date;
};
goog.globalEval = function(script) {
  (0,eval)(script);
};
goog.getCssName = function(className, opt_modifier) {
  if ("." == String(className).charAt(0)) {
    throw Error('className passed in goog.getCssName must not start with ".". You passed: ' + className);
  }
  var getMapping = function(cssName) {
    return goog.cssNameMapping_[cssName] || cssName;
  }, renameByParts = function(cssName) {
    for (var parts = cssName.split("-"), mapped = [], i = 0; i < parts.length; i++) {
      mapped.push(getMapping(parts[i]));
    }
    return mapped.join("-");
  };
  var rename = goog.cssNameMapping_ ? "BY_WHOLE" == goog.cssNameMappingStyle_ ? getMapping : renameByParts : function(a) {
    return a;
  };
  var result = opt_modifier ? className + "-" + rename(opt_modifier) : rename(className);
  return goog.global.CLOSURE_CSS_NAME_MAP_FN ? goog.global.CLOSURE_CSS_NAME_MAP_FN(result) : result;
};
goog.setCssNameMapping = function(mapping, opt_style) {
  goog.cssNameMapping_ = mapping;
  goog.cssNameMappingStyle_ = opt_style;
};
goog.getMsg = function(str, opt_values, opt_options) {
  opt_options && opt_options.html && (str = str.replace(/</g, "&lt;"));
  opt_values && (str = str.replace(/\{\$([^}]+)}/g, function(match, key) {
    return null != opt_values && key in opt_values ? opt_values[key] : match;
  }));
  return str;
};
goog.getMsgWithFallback = function(a, b) {
  return a;
};
goog.exportSymbol = function(publicPath, object, opt_objectToExportTo) {
  goog.exportPath_(publicPath, object, opt_objectToExportTo);
};
goog.exportProperty = function(object, publicName, symbol) {
  object[publicName] = symbol;
};
goog.inherits = function(childCtor, parentCtor) {
  function tempCtor() {
  }
  tempCtor.prototype = parentCtor.prototype;
  childCtor.superClass_ = parentCtor.prototype;
  childCtor.prototype = new tempCtor;
  childCtor.prototype.constructor = childCtor;
  childCtor.base = function(me, methodName, var_args) {
    for (var args = Array(arguments.length - 2), i = 2; i < arguments.length; i++) {
      args[i - 2] = arguments[i];
    }
    return parentCtor.prototype[methodName].apply(me, args);
  };
};
goog.scope = function(fn) {
  if (goog.isInModuleLoader_()) {
    throw Error("goog.scope is not supported within a module.");
  }
  fn.call(goog.global);
};
goog.defineClass = function(superClass, def) {
  var constructor = def.constructor, statics = def.statics;
  constructor && constructor != Object.prototype.constructor || (constructor = function() {
    throw Error("cannot instantiate an interface (no constructor defined).");
  });
  var cls = goog.defineClass.createSealingConstructor_(constructor, superClass);
  superClass && goog.inherits(cls, superClass);
  delete def.constructor;
  delete def.statics;
  goog.defineClass.applyProperties_(cls.prototype, def);
  null != statics && (statics instanceof Function ? statics(cls) : goog.defineClass.applyProperties_(cls, statics));
  return cls;
};
goog.defineClass.SEAL_CLASS_INSTANCES = goog.DEBUG;
goog.defineClass.createSealingConstructor_ = function(ctr, superClass) {
  return goog.defineClass.SEAL_CLASS_INSTANCES ? function() {
    var instance = ctr.apply(this, arguments) || this;
    instance[goog.UID_PROPERTY_] = instance[goog.UID_PROPERTY_];
    return instance;
  } : ctr;
};
goog.defineClass.OBJECT_PROTOTYPE_FIELDS_ = "constructor hasOwnProperty isPrototypeOf propertyIsEnumerable toLocaleString toString valueOf".split(" ");
goog.defineClass.applyProperties_ = function(target, source) {
  for (var key in source) {
    Object.prototype.hasOwnProperty.call(source, key) && (target[key] = source[key]);
  }
  for (var i = 0; i < goog.defineClass.OBJECT_PROTOTYPE_FIELDS_.length; i++) {
    key = goog.defineClass.OBJECT_PROTOTYPE_FIELDS_[i], Object.prototype.hasOwnProperty.call(source, key) && (target[key] = source[key]);
  }
};
goog.TRUSTED_TYPES_POLICY_NAME = "goog";
goog.identity_ = function(s) {
  return s;
};
goog.createTrustedTypesPolicy = function(name) {
  var policy = null, policyFactory = goog.global.trustedTypes;
  if (!policyFactory || !policyFactory.createPolicy) {
    return policy;
  }
  try {
    policy = policyFactory.createPolicy(name, {createHTML:goog.identity_, createScript:goog.identity_, createScriptURL:goog.identity_});
  } catch (e) {
    goog.logToConsole_(e.message);
  }
  return policy;
};
goog.disposable = {};
goog.disposable.IDisposable = function() {
};
goog.Disposable = function() {
  goog.Disposable.MONITORING_MODE != goog.Disposable.MonitoringMode.OFF && (goog.Disposable.INCLUDE_STACK_ON_CREATION && (this.creationStack = Error().stack), goog.Disposable.instances_[goog.getUid(this)] = this);
  this.disposed_ = this.disposed_;
  this.onDisposeCallbacks_ = this.onDisposeCallbacks_;
};
goog.Disposable.MonitoringMode = {OFF:0, PERMANENT:1, INTERACTIVE:2};
goog.Disposable.MONITORING_MODE = 0;
goog.Disposable.INCLUDE_STACK_ON_CREATION = !0;
goog.Disposable.instances_ = {};
goog.Disposable.getUndisposedObjects = function() {
  var ret = [], id;
  for (id in goog.Disposable.instances_) {
    goog.Disposable.instances_.hasOwnProperty(id) && ret.push(goog.Disposable.instances_[Number(id)]);
  }
  return ret;
};
goog.Disposable.clearUndisposedObjects = function() {
  goog.Disposable.instances_ = {};
};
goog.Disposable.prototype.disposed_ = !1;
goog.Disposable.prototype.isDisposed = function() {
  return this.disposed_;
};
goog.Disposable.prototype.getDisposed = goog.Disposable.prototype.isDisposed;
goog.Disposable.prototype.dispose = function() {
  if (!this.disposed_ && (this.disposed_ = !0, this.disposeInternal(), goog.Disposable.MONITORING_MODE != goog.Disposable.MonitoringMode.OFF)) {
    var uid = goog.getUid(this);
    if (goog.Disposable.MONITORING_MODE == goog.Disposable.MonitoringMode.PERMANENT && !goog.Disposable.instances_.hasOwnProperty(uid)) {
      throw Error(this + " did not call the goog.Disposable base constructor or was disposed of after a clearUndisposedObjects call");
    }
    if (goog.Disposable.MONITORING_MODE != goog.Disposable.MonitoringMode.OFF && this.onDisposeCallbacks_ && 0 < this.onDisposeCallbacks_.length) {
      throw Error(this + " did not empty its onDisposeCallbacks queue. This probably means it overrode dispose() or disposeInternal() without calling the superclass' method.");
    }
    delete goog.Disposable.instances_[uid];
  }
};
goog.Disposable.prototype.registerDisposable = function(disposable) {
  this.addOnDisposeCallback(goog.partial(goog.dispose, disposable));
};
goog.Disposable.prototype.addOnDisposeCallback = function(callback, opt_scope) {
  this.disposed_ ? void 0 !== opt_scope ? callback.call(opt_scope) : callback() : (this.onDisposeCallbacks_ || (this.onDisposeCallbacks_ = []), this.onDisposeCallbacks_.push(void 0 !== opt_scope ? goog.bind(callback, opt_scope) : callback));
};
goog.Disposable.prototype.disposeInternal = function() {
  if (this.onDisposeCallbacks_) {
    for (; this.onDisposeCallbacks_.length;) {
      this.onDisposeCallbacks_.shift()();
    }
  }
};
goog.Disposable.isDisposed = function(obj) {
  return obj && "function" == typeof obj.isDisposed ? obj.isDisposed() : !1;
};
goog.dispose = function(obj) {
  obj && "function" == typeof obj.dispose && obj.dispose();
};
goog.disposeAll = function(var_args) {
  for (var i = 0, len = arguments.length; i < len; ++i) {
    var disposable = arguments[i];
    goog.isArrayLike(disposable) ? goog.disposeAll.apply(null, disposable) : goog.dispose(disposable);
  }
};
goog.events = {};
goog.events.EventId = function(eventId) {
  this.id = eventId;
};
goog.events.EventId.prototype.toString = function() {
  return this.id;
};
goog.events.Event = function(type, opt_target) {
  this.type = type instanceof goog.events.EventId ? String(type) : type;
  this.currentTarget = this.target = opt_target;
  this.defaultPrevented = this.propagationStopped_ = !1;
};
goog.events.Event.prototype.hasPropagationStopped = function() {
  return this.propagationStopped_;
};
goog.events.Event.prototype.stopPropagation = function() {
  this.propagationStopped_ = !0;
};
goog.events.Event.prototype.preventDefault = function() {
  this.defaultPrevented = !0;
};
goog.events.Event.stopPropagation = function(e) {
  e.stopPropagation();
};
goog.events.Event.preventDefault = function(e) {
  e.preventDefault();
};
goog.debug = {};
goog.debug.Error = function(opt_msg) {
  if (Error.captureStackTrace) {
    Error.captureStackTrace(this, goog.debug.Error);
  } else {
    var stack = Error().stack;
    stack && (this.stack = stack);
  }
  opt_msg && (this.message = String(opt_msg));
  this.reportErrorToServer = !0;
};
goog.inherits(goog.debug.Error, Error);
goog.debug.Error.prototype.name = "CustomError";
goog.dom = {};
goog.dom.NodeType = {ELEMENT:1, ATTRIBUTE:2, TEXT:3, CDATA_SECTION:4, ENTITY_REFERENCE:5, ENTITY:6, PROCESSING_INSTRUCTION:7, COMMENT:8, DOCUMENT:9, DOCUMENT_TYPE:10, DOCUMENT_FRAGMENT:11, NOTATION:12};
goog.asserts = {};
goog.asserts.ENABLE_ASSERTS = goog.DEBUG;
goog.asserts.AssertionError = function(messagePattern, messageArgs) {
  goog.debug.Error.call(this, goog.asserts.subs_(messagePattern, messageArgs));
  this.messagePattern = messagePattern;
};
goog.inherits(goog.asserts.AssertionError, goog.debug.Error);
goog.asserts.AssertionError.prototype.name = "AssertionError";
goog.asserts.DEFAULT_ERROR_HANDLER = function(e) {
  throw e;
};
goog.asserts.errorHandler_ = goog.asserts.DEFAULT_ERROR_HANDLER;
goog.asserts.subs_ = function(pattern, subs) {
  for (var splitParts = pattern.split("%s"), returnString = "", subLast = splitParts.length - 1, i = 0; i < subLast; i++) {
    returnString += splitParts[i] + (i < subs.length ? subs[i] : "%s");
  }
  return returnString + splitParts[subLast];
};
goog.asserts.doAssertFailure_ = function(defaultMessage, defaultArgs, givenMessage, givenArgs) {
  var message = "Assertion failed";
  if (givenMessage) {
    message += ": " + givenMessage;
    var args = givenArgs;
  } else {
    defaultMessage && (message += ": " + defaultMessage, args = defaultArgs);
  }
  var e = new goog.asserts.AssertionError("" + message, args || []);
  goog.asserts.errorHandler_(e);
};
goog.asserts.setErrorHandler = function(errorHandler) {
  goog.asserts.ENABLE_ASSERTS && (goog.asserts.errorHandler_ = errorHandler);
};
goog.asserts.assert = function(condition, opt_message, var_args) {
  goog.asserts.ENABLE_ASSERTS && !condition && goog.asserts.doAssertFailure_("", null, opt_message, Array.prototype.slice.call(arguments, 2));
  return condition;
};
goog.asserts.assertExists = function(value, opt_message, var_args) {
  goog.asserts.ENABLE_ASSERTS && null == value && goog.asserts.doAssertFailure_("Expected to exist: %s.", [value], opt_message, Array.prototype.slice.call(arguments, 2));
  return value;
};
goog.asserts.fail = function(opt_message, var_args) {
  goog.asserts.ENABLE_ASSERTS && goog.asserts.errorHandler_(new goog.asserts.AssertionError("Failure" + (opt_message ? ": " + opt_message : ""), Array.prototype.slice.call(arguments, 1)));
};
goog.asserts.assertNumber = function(value, opt_message, var_args) {
  goog.asserts.ENABLE_ASSERTS && "number" !== typeof value && goog.asserts.doAssertFailure_("Expected number but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2));
  return value;
};
goog.asserts.assertString = function(value, opt_message, var_args) {
  goog.asserts.ENABLE_ASSERTS && "string" !== typeof value && goog.asserts.doAssertFailure_("Expected string but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2));
  return value;
};
goog.asserts.assertFunction = function(value, opt_message, var_args) {
  goog.asserts.ENABLE_ASSERTS && !goog.isFunction(value) && goog.asserts.doAssertFailure_("Expected function but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2));
  return value;
};
goog.asserts.assertObject = function(value, opt_message, var_args) {
  goog.asserts.ENABLE_ASSERTS && !goog.isObject(value) && goog.asserts.doAssertFailure_("Expected object but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2));
  return value;
};
goog.asserts.assertArray = function(value, opt_message, var_args) {
  goog.asserts.ENABLE_ASSERTS && !Array.isArray(value) && goog.asserts.doAssertFailure_("Expected array but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2));
  return value;
};
goog.asserts.assertBoolean = function(value, opt_message, var_args) {
  goog.asserts.ENABLE_ASSERTS && "boolean" !== typeof value && goog.asserts.doAssertFailure_("Expected boolean but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2));
  return value;
};
goog.asserts.assertElement = function(value, opt_message, var_args) {
  !goog.asserts.ENABLE_ASSERTS || goog.isObject(value) && value.nodeType == goog.dom.NodeType.ELEMENT || goog.asserts.doAssertFailure_("Expected Element but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2));
  return value;
};
goog.asserts.assertInstanceof = function(value, type, opt_message, var_args) {
  !goog.asserts.ENABLE_ASSERTS || value instanceof type || goog.asserts.doAssertFailure_("Expected instanceof %s but got %s.", [goog.asserts.getType_(type), goog.asserts.getType_(value)], opt_message, Array.prototype.slice.call(arguments, 3));
  return value;
};
goog.asserts.assertFinite = function(value, opt_message, var_args) {
  !goog.asserts.ENABLE_ASSERTS || "number" == typeof value && isFinite(value) || goog.asserts.doAssertFailure_("Expected %s to be a finite number but it is not.", [value], opt_message, Array.prototype.slice.call(arguments, 2));
  return value;
};
goog.asserts.assertObjectPrototypeIsIntact = function() {
  for (var key in Object.prototype) {
    goog.asserts.fail(key + " should not be enumerable in Object.prototype.");
  }
};
goog.asserts.getType_ = function(value) {
  return value instanceof Function ? value.displayName || value.name || "unknown type name" : value instanceof Object ? value.constructor.displayName || value.constructor.name || Object.prototype.toString.call(value) : null === value ? "null" : typeof value;
};
goog.debug.entryPointRegistry = {};
goog.debug.EntryPointMonitor = function() {
};
goog.debug.entryPointRegistry.refList_ = [];
goog.debug.entryPointRegistry.monitors_ = [];
goog.debug.entryPointRegistry.monitorsMayExist_ = !1;
goog.debug.entryPointRegistry.register = function(callback) {
  goog.debug.entryPointRegistry.refList_[goog.debug.entryPointRegistry.refList_.length] = callback;
  if (goog.debug.entryPointRegistry.monitorsMayExist_) {
    for (var monitors = goog.debug.entryPointRegistry.monitors_, i = 0; i < monitors.length; i++) {
      callback(goog.bind(monitors[i].wrap, monitors[i]));
    }
  }
};
goog.debug.entryPointRegistry.monitorAll = function(monitor) {
  goog.debug.entryPointRegistry.monitorsMayExist_ = !0;
  for (var transformer = goog.bind(monitor.wrap, monitor), i = 0; i < goog.debug.entryPointRegistry.refList_.length; i++) {
    goog.debug.entryPointRegistry.refList_[i](transformer);
  }
  goog.debug.entryPointRegistry.monitors_.push(monitor);
};
goog.debug.entryPointRegistry.unmonitorAllIfPossible = function(monitor) {
  var monitors = goog.debug.entryPointRegistry.monitors_;
  goog.asserts.assert(monitor == monitors[monitors.length - 1], "Only the most recent monitor can be unwrapped.");
  for (var transformer = goog.bind(monitor.unwrap, monitor), i = 0; i < goog.debug.entryPointRegistry.refList_.length; i++) {
    goog.debug.entryPointRegistry.refList_[i](transformer);
  }
  monitors.length--;
};
goog.array = {};
goog.NATIVE_ARRAY_PROTOTYPES = goog.TRUSTED_SITE;
goog.array.ASSUME_NATIVE_FUNCTIONS = 2012 < goog.FEATURESET_YEAR;
goog.array.peek = function(array) {
  return array[array.length - 1];
};
goog.array.last = goog.array.peek;
goog.array.indexOf = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || Array.prototype.indexOf) ? function(arr, obj, opt_fromIndex) {
  goog.asserts.assert(null != arr.length);
  return Array.prototype.indexOf.call(arr, obj, opt_fromIndex);
} : function(arr, obj, opt_fromIndex) {
  var fromIndex = null == opt_fromIndex ? 0 : 0 > opt_fromIndex ? Math.max(0, arr.length + opt_fromIndex) : opt_fromIndex;
  if ("string" === typeof arr) {
    return "string" !== typeof obj || 1 != obj.length ? -1 : arr.indexOf(obj, fromIndex);
  }
  for (var i = fromIndex; i < arr.length; i++) {
    if (i in arr && arr[i] === obj) {
      return i;
    }
  }
  return -1;
};
goog.array.lastIndexOf = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || Array.prototype.lastIndexOf) ? function(arr, obj, opt_fromIndex) {
  goog.asserts.assert(null != arr.length);
  return Array.prototype.lastIndexOf.call(arr, obj, null == opt_fromIndex ? arr.length - 1 : opt_fromIndex);
} : function(arr, obj, opt_fromIndex) {
  var fromIndex = null == opt_fromIndex ? arr.length - 1 : opt_fromIndex;
  0 > fromIndex && (fromIndex = Math.max(0, arr.length + fromIndex));
  if ("string" === typeof arr) {
    return "string" !== typeof obj || 1 != obj.length ? -1 : arr.lastIndexOf(obj, fromIndex);
  }
  for (var i = fromIndex; 0 <= i; i--) {
    if (i in arr && arr[i] === obj) {
      return i;
    }
  }
  return -1;
};
goog.array.forEach = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || Array.prototype.forEach) ? function(arr, f, opt_obj) {
  goog.asserts.assert(null != arr.length);
  Array.prototype.forEach.call(arr, f, opt_obj);
} : function(arr, f, opt_obj) {
  for (var l = arr.length, arr2 = "string" === typeof arr ? arr.split("") : arr, i = 0; i < l; i++) {
    i in arr2 && f.call(opt_obj, arr2[i], i, arr);
  }
};
goog.array.forEachRight = function(arr, f, opt_obj) {
  for (var l = arr.length, arr2 = "string" === typeof arr ? arr.split("") : arr, i = l - 1; 0 <= i; --i) {
    i in arr2 && f.call(opt_obj, arr2[i], i, arr);
  }
};
goog.array.filter = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || Array.prototype.filter) ? function(arr, f, opt_obj) {
  goog.asserts.assert(null != arr.length);
  return Array.prototype.filter.call(arr, f, opt_obj);
} : function(arr, f, opt_obj) {
  for (var l = arr.length, res = [], resLength = 0, arr2 = "string" === typeof arr ? arr.split("") : arr, i = 0; i < l; i++) {
    if (i in arr2) {
      var val = arr2[i];
      f.call(opt_obj, val, i, arr) && (res[resLength++] = val);
    }
  }
  return res;
};
goog.array.map = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || Array.prototype.map) ? function(arr, f, opt_obj) {
  goog.asserts.assert(null != arr.length);
  return Array.prototype.map.call(arr, f, opt_obj);
} : function(arr, f, opt_obj) {
  for (var l = arr.length, res = Array(l), arr2 = "string" === typeof arr ? arr.split("") : arr, i = 0; i < l; i++) {
    i in arr2 && (res[i] = f.call(opt_obj, arr2[i], i, arr));
  }
  return res;
};
goog.array.reduce = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || Array.prototype.reduce) ? function(arr, f, val, opt_obj) {
  goog.asserts.assert(null != arr.length);
  opt_obj && (f = goog.bind(f, opt_obj));
  return Array.prototype.reduce.call(arr, f, val);
} : function(arr, f, val$jscomp$0, opt_obj) {
  var rval = val$jscomp$0;
  goog.array.forEach(arr, function(val, index) {
    rval = f.call(opt_obj, rval, val, index, arr);
  });
  return rval;
};
goog.array.reduceRight = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || Array.prototype.reduceRight) ? function(arr, f, val, opt_obj) {
  goog.asserts.assert(null != arr.length);
  goog.asserts.assert(null != f);
  opt_obj && (f = goog.bind(f, opt_obj));
  return Array.prototype.reduceRight.call(arr, f, val);
} : function(arr, f, val$jscomp$0, opt_obj) {
  var rval = val$jscomp$0;
  goog.array.forEachRight(arr, function(val, index) {
    rval = f.call(opt_obj, rval, val, index, arr);
  });
  return rval;
};
goog.array.some = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || Array.prototype.some) ? function(arr, f, opt_obj) {
  goog.asserts.assert(null != arr.length);
  return Array.prototype.some.call(arr, f, opt_obj);
} : function(arr, f, opt_obj) {
  for (var l = arr.length, arr2 = "string" === typeof arr ? arr.split("") : arr, i = 0; i < l; i++) {
    if (i in arr2 && f.call(opt_obj, arr2[i], i, arr)) {
      return !0;
    }
  }
  return !1;
};
goog.array.every = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || Array.prototype.every) ? function(arr, f, opt_obj) {
  goog.asserts.assert(null != arr.length);
  return Array.prototype.every.call(arr, f, opt_obj);
} : function(arr, f, opt_obj) {
  for (var l = arr.length, arr2 = "string" === typeof arr ? arr.split("") : arr, i = 0; i < l; i++) {
    if (i in arr2 && !f.call(opt_obj, arr2[i], i, arr)) {
      return !1;
    }
  }
  return !0;
};
goog.array.count = function(arr$jscomp$0, f, opt_obj) {
  var count = 0;
  goog.array.forEach(arr$jscomp$0, function(element, index, arr) {
    f.call(opt_obj, element, index, arr) && ++count;
  }, opt_obj);
  return count;
};
goog.array.find = function(arr, f, opt_obj) {
  var i = goog.array.findIndex(arr, f, opt_obj);
  return 0 > i ? null : "string" === typeof arr ? arr.charAt(i) : arr[i];
};
goog.array.findIndex = function(arr, f, opt_obj) {
  for (var l = arr.length, arr2 = "string" === typeof arr ? arr.split("") : arr, i = 0; i < l; i++) {
    if (i in arr2 && f.call(opt_obj, arr2[i], i, arr)) {
      return i;
    }
  }
  return -1;
};
goog.array.findRight = function(arr, f, opt_obj) {
  var i = goog.array.findIndexRight(arr, f, opt_obj);
  return 0 > i ? null : "string" === typeof arr ? arr.charAt(i) : arr[i];
};
goog.array.findIndexRight = function(arr, f, opt_obj) {
  for (var l = arr.length, arr2 = "string" === typeof arr ? arr.split("") : arr, i = l - 1; 0 <= i; i--) {
    if (i in arr2 && f.call(opt_obj, arr2[i], i, arr)) {
      return i;
    }
  }
  return -1;
};
goog.array.contains = function(arr, obj) {
  return 0 <= goog.array.indexOf(arr, obj);
};
goog.array.isEmpty = function(arr) {
  return 0 == arr.length;
};
goog.array.clear = function(arr) {
  if (!Array.isArray(arr)) {
    for (var i = arr.length - 1; 0 <= i; i--) {
      delete arr[i];
    }
  }
  arr.length = 0;
};
goog.array.insert = function(arr, obj) {
  goog.array.contains(arr, obj) || arr.push(obj);
};
goog.array.insertAt = function(arr, obj, opt_i) {
  goog.array.splice(arr, opt_i, 0, obj);
};
goog.array.insertArrayAt = function(arr, elementsToAdd, opt_i) {
  goog.partial(goog.array.splice, arr, opt_i, 0).apply(null, elementsToAdd);
};
goog.array.insertBefore = function(arr, obj, opt_obj2) {
  var i;
  2 == arguments.length || 0 > (i = goog.array.indexOf(arr, opt_obj2)) ? arr.push(obj) : goog.array.insertAt(arr, obj, i);
};
goog.array.remove = function(arr, obj) {
  var i = goog.array.indexOf(arr, obj), rv;
  (rv = 0 <= i) && goog.array.removeAt(arr, i);
  return rv;
};
goog.array.removeLast = function(arr, obj) {
  var i = goog.array.lastIndexOf(arr, obj);
  return 0 <= i ? (goog.array.removeAt(arr, i), !0) : !1;
};
goog.array.removeAt = function(arr, i) {
  goog.asserts.assert(null != arr.length);
  return 1 == Array.prototype.splice.call(arr, i, 1).length;
};
goog.array.removeIf = function(arr, f, opt_obj) {
  var i = goog.array.findIndex(arr, f, opt_obj);
  return 0 <= i ? (goog.array.removeAt(arr, i), !0) : !1;
};
goog.array.removeAllIf = function(arr, f, opt_obj) {
  var removedCount = 0;
  goog.array.forEachRight(arr, function(val, index) {
    f.call(opt_obj, val, index, arr) && goog.array.removeAt(arr, index) && removedCount++;
  });
  return removedCount;
};
goog.array.concat = function(var_args) {
  return Array.prototype.concat.apply([], arguments);
};
goog.array.join = function(var_args) {
  return Array.prototype.concat.apply([], arguments);
};
goog.array.toArray = function(object) {
  var length = object.length;
  if (0 < length) {
    for (var rv = Array(length), i = 0; i < length; i++) {
      rv[i] = object[i];
    }
    return rv;
  }
  return [];
};
goog.array.clone = goog.array.toArray;
goog.array.extend = function(arr1, var_args) {
  for (var i = 1; i < arguments.length; i++) {
    var arr2 = arguments[i];
    if (goog.isArrayLike(arr2)) {
      var len1 = arr1.length || 0, len2 = arr2.length || 0;
      arr1.length = len1 + len2;
      for (var j = 0; j < len2; j++) {
        arr1[len1 + j] = arr2[j];
      }
    } else {
      arr1.push(arr2);
    }
  }
};
goog.array.splice = function(arr, index, howMany, var_args) {
  goog.asserts.assert(null != arr.length);
  return Array.prototype.splice.apply(arr, goog.array.slice(arguments, 1));
};
goog.array.slice = function(arr, start, opt_end) {
  goog.asserts.assert(null != arr.length);
  return 2 >= arguments.length ? Array.prototype.slice.call(arr, start) : Array.prototype.slice.call(arr, start, opt_end);
};
goog.array.removeDuplicates = function(arr, opt_rv, opt_hashFn) {
  for (var returnArray = opt_rv || arr, defaultHashFn = function(item) {
    return goog.isObject(item) ? "o" + goog.getUid(item) : (typeof item).charAt(0) + item;
  }, hashFn = opt_hashFn || defaultHashFn, seen = {}, cursorInsert = 0, cursorRead = 0; cursorRead < arr.length;) {
    var current = arr[cursorRead++], key = hashFn(current);
    Object.prototype.hasOwnProperty.call(seen, key) || (seen[key] = !0, returnArray[cursorInsert++] = current);
  }
  returnArray.length = cursorInsert;
};
goog.array.binarySearch = function(arr, target, opt_compareFn) {
  return goog.array.binarySearch_(arr, opt_compareFn || goog.array.defaultCompare, !1, target);
};
goog.array.binarySelect = function(arr, evaluator, opt_obj) {
  return goog.array.binarySearch_(arr, evaluator, !0, void 0, opt_obj);
};
goog.array.binarySearch_ = function(arr, compareFn, isEvaluator, opt_target, opt_selfObj) {
  for (var left = 0, right = arr.length, found; left < right;) {
    var middle = left + (right - left >>> 1);
    var compareResult = isEvaluator ? compareFn.call(opt_selfObj, arr[middle], middle, arr) : compareFn(opt_target, arr[middle]);
    0 < compareResult ? left = middle + 1 : (right = middle, found = !compareResult);
  }
  return found ? left : -left - 1;
};
goog.array.sort = function(arr, opt_compareFn) {
  arr.sort(opt_compareFn || goog.array.defaultCompare);
};
goog.array.stableSort = function(arr, opt_compareFn) {
  for (var compArr = Array(arr.length), i = 0; i < arr.length; i++) {
    compArr[i] = {index:i, value:arr[i]};
  }
  var valueCompareFn = opt_compareFn || goog.array.defaultCompare;
  goog.array.sort(compArr, function stableCompareFn(obj1, obj2) {
    return valueCompareFn(obj1.value, obj2.value) || obj1.index - obj2.index;
  });
  for (i = 0; i < arr.length; i++) {
    arr[i] = compArr[i].value;
  }
};
goog.array.sortByKey = function(arr, keyFn, opt_compareFn) {
  var keyCompareFn = opt_compareFn || goog.array.defaultCompare;
  goog.array.sort(arr, function(a, b) {
    return keyCompareFn(keyFn(a), keyFn(b));
  });
};
goog.array.sortObjectsByKey = function(arr, key, opt_compareFn) {
  goog.array.sortByKey(arr, function(obj) {
    return obj[key];
  }, opt_compareFn);
};
goog.array.isSorted = function(arr, opt_compareFn, opt_strict) {
  for (var compare = opt_compareFn || goog.array.defaultCompare, i = 1; i < arr.length; i++) {
    var compareResult = compare(arr[i - 1], arr[i]);
    if (0 < compareResult || 0 == compareResult && opt_strict) {
      return !1;
    }
  }
  return !0;
};
goog.array.equals = function(arr1, arr2, opt_equalsFn) {
  if (!goog.isArrayLike(arr1) || !goog.isArrayLike(arr2) || arr1.length != arr2.length) {
    return !1;
  }
  for (var l = arr1.length, equalsFn = opt_equalsFn || goog.array.defaultCompareEquality, i = 0; i < l; i++) {
    if (!equalsFn(arr1[i], arr2[i])) {
      return !1;
    }
  }
  return !0;
};
goog.array.compare3 = function(arr1, arr2, opt_compareFn) {
  for (var compare = opt_compareFn || goog.array.defaultCompare, l = Math.min(arr1.length, arr2.length), i = 0; i < l; i++) {
    var result = compare(arr1[i], arr2[i]);
    if (0 != result) {
      return result;
    }
  }
  return goog.array.defaultCompare(arr1.length, arr2.length);
};
goog.array.defaultCompare = function(a, b) {
  return a > b ? 1 : a < b ? -1 : 0;
};
goog.array.inverseDefaultCompare = function(a, b) {
  return -goog.array.defaultCompare(a, b);
};
goog.array.defaultCompareEquality = function(a, b) {
  return a === b;
};
goog.array.binaryInsert = function(array, value, opt_compareFn) {
  var index = goog.array.binarySearch(array, value, opt_compareFn);
  return 0 > index ? (goog.array.insertAt(array, value, -(index + 1)), !0) : !1;
};
goog.array.binaryRemove = function(array, value, opt_compareFn) {
  var index = goog.array.binarySearch(array, value, opt_compareFn);
  return 0 <= index ? goog.array.removeAt(array, index) : !1;
};
goog.array.bucket = function(array, sorter, opt_obj) {
  for (var buckets = {}, i = 0; i < array.length; i++) {
    var value = array[i], key = sorter.call(opt_obj, value, i, array);
    void 0 !== key && (buckets[key] || (buckets[key] = [])).push(value);
  }
  return buckets;
};
goog.array.toObject = function(arr, keyFunc, opt_obj) {
  var ret = {};
  goog.array.forEach(arr, function(element, index) {
    ret[keyFunc.call(opt_obj, element, index, arr)] = element;
  });
  return ret;
};
goog.array.range = function(startOrEnd, opt_end, opt_step) {
  var array = [], start = 0, end = startOrEnd, step = opt_step || 1;
  void 0 !== opt_end && (start = startOrEnd, end = opt_end);
  if (0 > step * (end - start)) {
    return [];
  }
  if (0 < step) {
    for (var i = start; i < end; i += step) {
      array.push(i);
    }
  } else {
    for (i = start; i > end; i += step) {
      array.push(i);
    }
  }
  return array;
};
goog.array.repeat = function(value, n) {
  for (var array = [], i = 0; i < n; i++) {
    array[i] = value;
  }
  return array;
};
goog.array.flatten = function(var_args) {
  for (var result = [], i = 0; i < arguments.length; i++) {
    var element = arguments[i];
    if (Array.isArray(element)) {
      for (var c = 0; c < element.length; c += 8192) {
        for (var chunk = goog.array.slice(element, c, c + 8192), recurseResult = goog.array.flatten.apply(null, chunk), r = 0; r < recurseResult.length; r++) {
          result.push(recurseResult[r]);
        }
      }
    } else {
      result.push(element);
    }
  }
  return result;
};
goog.array.rotate = function(array, n) {
  goog.asserts.assert(null != array.length);
  array.length && (n %= array.length, 0 < n ? Array.prototype.unshift.apply(array, array.splice(-n, n)) : 0 > n && Array.prototype.push.apply(array, array.splice(0, -n)));
  return array;
};
goog.array.moveItem = function(arr, fromIndex, toIndex) {
  goog.asserts.assert(0 <= fromIndex && fromIndex < arr.length);
  goog.asserts.assert(0 <= toIndex && toIndex < arr.length);
  var removedItems = Array.prototype.splice.call(arr, fromIndex, 1);
  Array.prototype.splice.call(arr, toIndex, 0, removedItems[0]);
};
goog.array.zip = function(var_args) {
  if (!arguments.length) {
    return [];
  }
  for (var result = [], minLen = arguments[0].length, i = 1; i < arguments.length; i++) {
    arguments[i].length < minLen && (minLen = arguments[i].length);
  }
  for (i = 0; i < minLen; i++) {
    for (var value = [], j = 0; j < arguments.length; j++) {
      value.push(arguments[j][i]);
    }
    result.push(value);
  }
  return result;
};
goog.array.shuffle = function(arr, opt_randFn) {
  for (var randFn = opt_randFn || Math.random, i = arr.length - 1; 0 < i; i--) {
    var j = Math.floor(randFn() * (i + 1)), tmp = arr[i];
    arr[i] = arr[j];
    arr[j] = tmp;
  }
};
goog.array.copyByIndex = function(arr, index_arr) {
  var result = [];
  goog.array.forEach(index_arr, function(index) {
    result.push(arr[index]);
  });
  return result;
};
goog.array.concatMap = function(arr, f, opt_obj) {
  return goog.array.concat.apply([], goog.array.map(arr, f, opt_obj));
};
goog.debug.errorcontext = {};
goog.debug.errorcontext.addErrorContext = function(err, contextKey, contextValue) {
  err[goog.debug.errorcontext.CONTEXT_KEY_] || (err[goog.debug.errorcontext.CONTEXT_KEY_] = {});
  err[goog.debug.errorcontext.CONTEXT_KEY_][contextKey] = contextValue;
};
goog.debug.errorcontext.getErrorContext = function(err) {
  return err[goog.debug.errorcontext.CONTEXT_KEY_] || {};
};
goog.debug.errorcontext.CONTEXT_KEY_ = "__closure__error__context__984382";
goog.string = {};
goog.string.internal = {};
goog.string.internal.startsWith = function(str, prefix) {
  return 0 == str.lastIndexOf(prefix, 0);
};
goog.string.internal.endsWith = function(str, suffix) {
  var l = str.length - suffix.length;
  return 0 <= l && str.indexOf(suffix, l) == l;
};
goog.string.internal.caseInsensitiveStartsWith = function(str, prefix) {
  return 0 == goog.string.internal.caseInsensitiveCompare(prefix, str.substr(0, prefix.length));
};
goog.string.internal.caseInsensitiveEndsWith = function(str, suffix) {
  return 0 == goog.string.internal.caseInsensitiveCompare(suffix, str.substr(str.length - suffix.length, suffix.length));
};
goog.string.internal.caseInsensitiveEquals = function(str1, str2) {
  return str1.toLowerCase() == str2.toLowerCase();
};
goog.string.internal.isEmptyOrWhitespace = function(str) {
  return /^[\s\xa0]*$/.test(str);
};
goog.string.internal.trim = goog.TRUSTED_SITE && String.prototype.trim ? function(str) {
  return str.trim();
} : function(str) {
  return /^[\s\xa0]*([\s\S]*?)[\s\xa0]*$/.exec(str)[1];
};
goog.string.internal.caseInsensitiveCompare = function(str1, str2) {
  var test1 = String(str1).toLowerCase(), test2 = String(str2).toLowerCase();
  return test1 < test2 ? -1 : test1 == test2 ? 0 : 1;
};
goog.string.internal.newLineToBr = function(str, opt_xml) {
  return str.replace(/(\r\n|\r|\n)/g, opt_xml ? "<br />" : "<br>");
};
goog.string.internal.htmlEscape = function(str, opt_isLikelyToContainHtmlChars) {
  if (opt_isLikelyToContainHtmlChars) {
    str = str.replace(goog.string.internal.AMP_RE_, "&amp;").replace(goog.string.internal.LT_RE_, "&lt;").replace(goog.string.internal.GT_RE_, "&gt;").replace(goog.string.internal.QUOT_RE_, "&quot;").replace(goog.string.internal.SINGLE_QUOTE_RE_, "&#39;").replace(goog.string.internal.NULL_RE_, "&#0;");
  } else {
    if (!goog.string.internal.ALL_RE_.test(str)) {
      return str;
    }
    -1 != str.indexOf("&") && (str = str.replace(goog.string.internal.AMP_RE_, "&amp;"));
    -1 != str.indexOf("<") && (str = str.replace(goog.string.internal.LT_RE_, "&lt;"));
    -1 != str.indexOf(">") && (str = str.replace(goog.string.internal.GT_RE_, "&gt;"));
    -1 != str.indexOf('"') && (str = str.replace(goog.string.internal.QUOT_RE_, "&quot;"));
    -1 != str.indexOf("'") && (str = str.replace(goog.string.internal.SINGLE_QUOTE_RE_, "&#39;"));
    -1 != str.indexOf("\x00") && (str = str.replace(goog.string.internal.NULL_RE_, "&#0;"));
  }
  return str;
};
goog.string.internal.AMP_RE_ = /&/g;
goog.string.internal.LT_RE_ = /</g;
goog.string.internal.GT_RE_ = />/g;
goog.string.internal.QUOT_RE_ = /"/g;
goog.string.internal.SINGLE_QUOTE_RE_ = /'/g;
goog.string.internal.NULL_RE_ = /\x00/g;
goog.string.internal.ALL_RE_ = /[\x00&<>"']/;
goog.string.internal.whitespaceEscape = function(str, opt_xml) {
  return goog.string.internal.newLineToBr(str.replace(/  /g, " &#160;"), opt_xml);
};
goog.string.internal.contains = function(str, subString) {
  return -1 != str.indexOf(subString);
};
goog.string.internal.caseInsensitiveContains = function(str, subString) {
  return goog.string.internal.contains(str.toLowerCase(), subString.toLowerCase());
};
goog.string.internal.compareVersions = function(version1, version2) {
  for (var order = 0, v1Subs = goog.string.internal.trim(String(version1)).split("."), v2Subs = goog.string.internal.trim(String(version2)).split("."), subCount = Math.max(v1Subs.length, v2Subs.length), subIdx = 0; 0 == order && subIdx < subCount; subIdx++) {
    var v1Sub = v1Subs[subIdx] || "", v2Sub = v2Subs[subIdx] || "";
    do {
      var v1Comp = /(\d*)(\D*)(.*)/.exec(v1Sub) || ["", "", "", ""], v2Comp = /(\d*)(\D*)(.*)/.exec(v2Sub) || ["", "", "", ""];
      if (0 == v1Comp[0].length && 0 == v2Comp[0].length) {
        break;
      }
      order = goog.string.internal.compareElements_(0 == v1Comp[1].length ? 0 : parseInt(v1Comp[1], 10), 0 == v2Comp[1].length ? 0 : parseInt(v2Comp[1], 10)) || goog.string.internal.compareElements_(0 == v1Comp[2].length, 0 == v2Comp[2].length) || goog.string.internal.compareElements_(v1Comp[2], v2Comp[2]);
      v1Sub = v1Comp[3];
      v2Sub = v2Comp[3];
    } while (0 == order);
  }
  return order;
};
goog.string.internal.compareElements_ = function(left, right) {
  return left < right ? -1 : left > right ? 1 : 0;
};
goog.labs = {};
goog.labs.userAgent = {};
goog.labs.userAgent.util = {};
goog.labs.userAgent.util.getNativeUserAgentString_ = function() {
  var navigator = goog.labs.userAgent.util.getNavigator_();
  if (navigator) {
    var userAgent = navigator.userAgent;
    if (userAgent) {
      return userAgent;
    }
  }
  return "";
};
goog.labs.userAgent.util.getNavigator_ = function() {
  return goog.global.navigator;
};
goog.labs.userAgent.util.userAgent_ = goog.labs.userAgent.util.getNativeUserAgentString_();
goog.labs.userAgent.util.setUserAgent = function(opt_userAgent) {
  goog.labs.userAgent.util.userAgent_ = opt_userAgent || goog.labs.userAgent.util.getNativeUserAgentString_();
};
goog.labs.userAgent.util.getUserAgent = function() {
  return goog.labs.userAgent.util.userAgent_;
};
goog.labs.userAgent.util.matchUserAgent = function(str) {
  return goog.string.internal.contains(goog.labs.userAgent.util.getUserAgent(), str);
};
goog.labs.userAgent.util.matchUserAgentIgnoreCase = function(str) {
  return goog.string.internal.caseInsensitiveContains(goog.labs.userAgent.util.getUserAgent(), str);
};
goog.labs.userAgent.util.extractVersionTuples = function(userAgent) {
  for (var versionRegExp = /(\w[\w ]+)\/([^\s]+)\s*(?:\((.*?)\))?/g, data = [], match; match = versionRegExp.exec(userAgent);) {
    data.push([match[1], match[2], match[3] || void 0]);
  }
  return data;
};
goog.object = {};
goog.object.is = function(v, v2) {
  return v === v2 ? 0 !== v || 1 / v === 1 / v2 : v !== v && v2 !== v2;
};
goog.object.forEach = function(obj, f, opt_obj) {
  for (var key in obj) {
    f.call(opt_obj, obj[key], key, obj);
  }
};
goog.object.filter = function(obj, f, opt_obj) {
  var res = {}, key;
  for (key in obj) {
    f.call(opt_obj, obj[key], key, obj) && (res[key] = obj[key]);
  }
  return res;
};
goog.object.map = function(obj, f, opt_obj) {
  var res = {}, key;
  for (key in obj) {
    res[key] = f.call(opt_obj, obj[key], key, obj);
  }
  return res;
};
goog.object.some = function(obj, f, opt_obj) {
  for (var key in obj) {
    if (f.call(opt_obj, obj[key], key, obj)) {
      return !0;
    }
  }
  return !1;
};
goog.object.every = function(obj, f, opt_obj) {
  for (var key in obj) {
    if (!f.call(opt_obj, obj[key], key, obj)) {
      return !1;
    }
  }
  return !0;
};
goog.object.getCount = function(obj) {
  var rv = 0, key;
  for (key in obj) {
    rv++;
  }
  return rv;
};
goog.object.getAnyKey = function(obj) {
  for (var key in obj) {
    return key;
  }
};
goog.object.getAnyValue = function(obj) {
  for (var key in obj) {
    return obj[key];
  }
};
goog.object.contains = function(obj, val) {
  return goog.object.containsValue(obj, val);
};
goog.object.getValues = function(obj) {
  var res = [], i = 0, key;
  for (key in obj) {
    res[i++] = obj[key];
  }
  return res;
};
goog.object.getKeys = function(obj) {
  var res = [], i = 0, key;
  for (key in obj) {
    res[i++] = key;
  }
  return res;
};
goog.object.getValueByKeys = function(obj, var_args) {
  for (var isArrayLike = goog.isArrayLike(var_args), keys = isArrayLike ? var_args : arguments, i = isArrayLike ? 0 : 1; i < keys.length; i++) {
    if (null == obj) {
      return;
    }
    obj = obj[keys[i]];
  }
  return obj;
};
goog.object.containsKey = function(obj, key) {
  return null !== obj && key in obj;
};
goog.object.containsValue = function(obj, val) {
  for (var key in obj) {
    if (obj[key] == val) {
      return !0;
    }
  }
  return !1;
};
goog.object.findKey = function(obj, f, opt_this) {
  for (var key in obj) {
    if (f.call(opt_this, obj[key], key, obj)) {
      return key;
    }
  }
};
goog.object.findValue = function(obj, f, opt_this) {
  var key = goog.object.findKey(obj, f, opt_this);
  return key && obj[key];
};
goog.object.isEmpty = function(obj) {
  for (var key in obj) {
    return !1;
  }
  return !0;
};
goog.object.clear = function(obj) {
  for (var i in obj) {
    delete obj[i];
  }
};
goog.object.remove = function(obj, key) {
  var rv;
  (rv = key in obj) && delete obj[key];
  return rv;
};
goog.object.add = function(obj, key, val) {
  if (null !== obj && key in obj) {
    throw Error('The object already contains the key "' + key + '"');
  }
  goog.object.set(obj, key, val);
};
goog.object.get = function(obj, key, opt_val) {
  return null !== obj && key in obj ? obj[key] : opt_val;
};
goog.object.set = function(obj, key, value) {
  obj[key] = value;
};
goog.object.setIfUndefined = function(obj, key, value) {
  return key in obj ? obj[key] : obj[key] = value;
};
goog.object.setWithReturnValueIfNotSet = function(obj, key, f) {
  if (key in obj) {
    return obj[key];
  }
  var val = f();
  return obj[key] = val;
};
goog.object.equals = function(a, b) {
  for (var k in a) {
    if (!(k in b) || a[k] !== b[k]) {
      return !1;
    }
  }
  for (var k$19 in b) {
    if (!(k$19 in a)) {
      return !1;
    }
  }
  return !0;
};
goog.object.clone = function(obj) {
  var res = {}, key;
  for (key in obj) {
    res[key] = obj[key];
  }
  return res;
};
goog.object.unsafeClone = function(obj) {
  var type = goog.typeOf(obj);
  if ("object" == type || "array" == type) {
    if (goog.isFunction(obj.clone)) {
      return obj.clone();
    }
    var clone = "array" == type ? [] : {}, key;
    for (key in obj) {
      clone[key] = goog.object.unsafeClone(obj[key]);
    }
    return clone;
  }
  return obj;
};
goog.object.transpose = function(obj) {
  var transposed = {}, key;
  for (key in obj) {
    transposed[obj[key]] = key;
  }
  return transposed;
};
goog.object.PROTOTYPE_FIELDS_ = "constructor hasOwnProperty isPrototypeOf propertyIsEnumerable toLocaleString toString valueOf".split(" ");
goog.object.extend = function(target, var_args) {
  for (var key, source, i = 1; i < arguments.length; i++) {
    source = arguments[i];
    for (key in source) {
      target[key] = source[key];
    }
    for (var j = 0; j < goog.object.PROTOTYPE_FIELDS_.length; j++) {
      key = goog.object.PROTOTYPE_FIELDS_[j], Object.prototype.hasOwnProperty.call(source, key) && (target[key] = source[key]);
    }
  }
};
goog.object.create = function(var_args) {
  var argLength = arguments.length;
  if (1 == argLength && Array.isArray(arguments[0])) {
    return goog.object.create.apply(null, arguments[0]);
  }
  if (argLength % 2) {
    throw Error("Uneven number of arguments");
  }
  for (var rv = {}, i = 0; i < argLength; i += 2) {
    rv[arguments[i]] = arguments[i + 1];
  }
  return rv;
};
goog.object.createSet = function(var_args) {
  var argLength = arguments.length;
  if (1 == argLength && Array.isArray(arguments[0])) {
    return goog.object.createSet.apply(null, arguments[0]);
  }
  for (var rv = {}, i = 0; i < argLength; i++) {
    rv[arguments[i]] = !0;
  }
  return rv;
};
goog.object.createImmutableView = function(obj) {
  var result = obj;
  Object.isFrozen && !Object.isFrozen(obj) && (result = Object.create(obj), Object.freeze(result));
  return result;
};
goog.object.isImmutableView = function(obj) {
  return !!Object.isFrozen && Object.isFrozen(obj);
};
goog.object.getAllPropertyNames = function(obj, opt_includeObjectPrototype, opt_includeFunctionPrototype) {
  if (!obj) {
    return [];
  }
  if (!Object.getOwnPropertyNames || !Object.getPrototypeOf) {
    return goog.object.getKeys(obj);
  }
  for (var visitedSet = {}, proto = obj; proto && (proto !== Object.prototype || opt_includeObjectPrototype) && (proto !== Function.prototype || opt_includeFunctionPrototype);) {
    for (var names = Object.getOwnPropertyNames(proto), i = 0; i < names.length; i++) {
      visitedSet[names[i]] = !0;
    }
    proto = Object.getPrototypeOf(proto);
  }
  return goog.object.getKeys(visitedSet);
};
goog.object.getSuperClass = function(constructor) {
  var proto = Object.getPrototypeOf(constructor.prototype);
  return proto && proto.constructor;
};
goog.labs.userAgent.browser = {};
goog.labs.userAgent.browser.matchOpera_ = function() {
  return goog.labs.userAgent.util.matchUserAgent("Opera");
};
goog.labs.userAgent.browser.matchIE_ = function() {
  return goog.labs.userAgent.util.matchUserAgent("Trident") || goog.labs.userAgent.util.matchUserAgent("MSIE");
};
goog.labs.userAgent.browser.matchEdgeHtml_ = function() {
  return goog.labs.userAgent.util.matchUserAgent("Edge");
};
goog.labs.userAgent.browser.matchEdgeChromium_ = function() {
  return goog.labs.userAgent.util.matchUserAgent("Edg/");
};
goog.labs.userAgent.browser.matchOperaChromium_ = function() {
  return goog.labs.userAgent.util.matchUserAgent("OPR");
};
goog.labs.userAgent.browser.matchFirefox_ = function() {
  return goog.labs.userAgent.util.matchUserAgent("Firefox") || goog.labs.userAgent.util.matchUserAgent("FxiOS");
};
goog.labs.userAgent.browser.matchSafari_ = function() {
  return goog.labs.userAgent.util.matchUserAgent("Safari") && !(goog.labs.userAgent.browser.matchChrome_() || goog.labs.userAgent.browser.matchCoast_() || goog.labs.userAgent.browser.matchOpera_() || goog.labs.userAgent.browser.matchEdgeHtml_() || goog.labs.userAgent.browser.matchEdgeChromium_() || goog.labs.userAgent.browser.matchOperaChromium_() || goog.labs.userAgent.browser.matchFirefox_() || goog.labs.userAgent.browser.isSilk() || goog.labs.userAgent.util.matchUserAgent("Android"));
};
goog.labs.userAgent.browser.matchCoast_ = function() {
  return goog.labs.userAgent.util.matchUserAgent("Coast");
};
goog.labs.userAgent.browser.matchIosWebview_ = function() {
  return (goog.labs.userAgent.util.matchUserAgent("iPad") || goog.labs.userAgent.util.matchUserAgent("iPhone")) && !goog.labs.userAgent.browser.matchSafari_() && !goog.labs.userAgent.browser.matchChrome_() && !goog.labs.userAgent.browser.matchCoast_() && !goog.labs.userAgent.browser.matchFirefox_() && goog.labs.userAgent.util.matchUserAgent("AppleWebKit");
};
goog.labs.userAgent.browser.matchChrome_ = function() {
  return (goog.labs.userAgent.util.matchUserAgent("Chrome") || goog.labs.userAgent.util.matchUserAgent("CriOS")) && !goog.labs.userAgent.browser.matchEdgeHtml_();
};
goog.labs.userAgent.browser.matchAndroidBrowser_ = function() {
  return goog.labs.userAgent.util.matchUserAgent("Android") && !(goog.labs.userAgent.browser.isChrome() || goog.labs.userAgent.browser.isFirefox() || goog.labs.userAgent.browser.isOpera() || goog.labs.userAgent.browser.isSilk());
};
goog.labs.userAgent.browser.isOpera = goog.labs.userAgent.browser.matchOpera_;
goog.labs.userAgent.browser.isIE = goog.labs.userAgent.browser.matchIE_;
goog.labs.userAgent.browser.isEdge = goog.labs.userAgent.browser.matchEdgeHtml_;
goog.labs.userAgent.browser.isEdgeChromium = goog.labs.userAgent.browser.matchEdgeChromium_;
goog.labs.userAgent.browser.isOperaChromium = goog.labs.userAgent.browser.matchOperaChromium_;
goog.labs.userAgent.browser.isFirefox = goog.labs.userAgent.browser.matchFirefox_;
goog.labs.userAgent.browser.isSafari = goog.labs.userAgent.browser.matchSafari_;
goog.labs.userAgent.browser.isCoast = goog.labs.userAgent.browser.matchCoast_;
goog.labs.userAgent.browser.isIosWebview = goog.labs.userAgent.browser.matchIosWebview_;
goog.labs.userAgent.browser.isChrome = goog.labs.userAgent.browser.matchChrome_;
goog.labs.userAgent.browser.isAndroidBrowser = goog.labs.userAgent.browser.matchAndroidBrowser_;
goog.labs.userAgent.browser.isSilk = function() {
  return goog.labs.userAgent.util.matchUserAgent("Silk");
};
goog.labs.userAgent.browser.getVersion = function() {
  function lookUpValueWithKeys(keys) {
    var key = goog.array.find(keys, versionMapHasKey);
    return versionMap[key] || "";
  }
  var userAgentString = goog.labs.userAgent.util.getUserAgent();
  if (goog.labs.userAgent.browser.isIE()) {
    return goog.labs.userAgent.browser.getIEVersion_(userAgentString);
  }
  var versionTuples = goog.labs.userAgent.util.extractVersionTuples(userAgentString), versionMap = {};
  goog.array.forEach(versionTuples, function(tuple) {
    versionMap[tuple[0]] = tuple[1];
  });
  var versionMapHasKey = goog.partial(goog.object.containsKey, versionMap);
  if (goog.labs.userAgent.browser.isOpera()) {
    return lookUpValueWithKeys(["Version", "Opera"]);
  }
  if (goog.labs.userAgent.browser.isEdge()) {
    return lookUpValueWithKeys(["Edge"]);
  }
  if (goog.labs.userAgent.browser.isEdgeChromium()) {
    return lookUpValueWithKeys(["Edg"]);
  }
  if (goog.labs.userAgent.browser.isChrome()) {
    return lookUpValueWithKeys(["Chrome", "CriOS", "HeadlessChrome"]);
  }
  var tuple = versionTuples[2];
  return tuple && tuple[1] || "";
};
goog.labs.userAgent.browser.isVersionOrHigher = function(version) {
  return 0 <= goog.string.internal.compareVersions(goog.labs.userAgent.browser.getVersion(), version);
};
goog.labs.userAgent.browser.getIEVersion_ = function(userAgent) {
  var rv = /rv: *([\d\.]*)/.exec(userAgent);
  if (rv && rv[1]) {
    return rv[1];
  }
  var version = "", msie = /MSIE +([\d\.]+)/.exec(userAgent);
  if (msie && msie[1]) {
    var tridentVersion = /Trident\/(\d.\d)/.exec(userAgent);
    if ("7.0" == msie[1]) {
      if (tridentVersion && tridentVersion[1]) {
        switch(tridentVersion[1]) {
          case "4.0":
            version = "8.0";
            break;
          case "5.0":
            version = "9.0";
            break;
          case "6.0":
            version = "10.0";
            break;
          case "7.0":
            version = "11.0";
        }
      } else {
        version = "7.0";
      }
    } else {
      version = msie[1];
    }
  }
  return version;
};
goog.dom.asserts = {};
goog.dom.asserts.assertIsLocation = function(o) {
  if (goog.asserts.ENABLE_ASSERTS) {
    var win = goog.dom.asserts.getWindow_(o);
    win && (!o || !(o instanceof win.Location) && o instanceof win.Element) && goog.asserts.fail("Argument is not a Location (or a non-Element mock); got: %s", goog.dom.asserts.debugStringForType_(o));
  }
  return o;
};
goog.dom.asserts.assertIsElementType_ = function(o, typename) {
  if (goog.asserts.ENABLE_ASSERTS) {
    var win = goog.dom.asserts.getWindow_(o);
    win && "undefined" != typeof win[typename] && (o && (o instanceof win[typename] || !(o instanceof win.Location || o instanceof win.Element)) || goog.asserts.fail("Argument is not a %s (or a non-Element, non-Location mock); got: %s", typename, goog.dom.asserts.debugStringForType_(o)));
  }
  return o;
};
goog.dom.asserts.assertIsHTMLAnchorElement = function(o) {
  return goog.dom.asserts.assertIsElementType_(o, "HTMLAnchorElement");
};
goog.dom.asserts.assertIsHTMLButtonElement = function(o) {
  return goog.dom.asserts.assertIsElementType_(o, "HTMLButtonElement");
};
goog.dom.asserts.assertIsHTMLLinkElement = function(o) {
  return goog.dom.asserts.assertIsElementType_(o, "HTMLLinkElement");
};
goog.dom.asserts.assertIsHTMLImageElement = function(o) {
  return goog.dom.asserts.assertIsElementType_(o, "HTMLImageElement");
};
goog.dom.asserts.assertIsHTMLAudioElement = function(o) {
  return goog.dom.asserts.assertIsElementType_(o, "HTMLAudioElement");
};
goog.dom.asserts.assertIsHTMLVideoElement = function(o) {
  return goog.dom.asserts.assertIsElementType_(o, "HTMLVideoElement");
};
goog.dom.asserts.assertIsHTMLInputElement = function(o) {
  return goog.dom.asserts.assertIsElementType_(o, "HTMLInputElement");
};
goog.dom.asserts.assertIsHTMLTextAreaElement = function(o) {
  return goog.dom.asserts.assertIsElementType_(o, "HTMLTextAreaElement");
};
goog.dom.asserts.assertIsHTMLCanvasElement = function(o) {
  return goog.dom.asserts.assertIsElementType_(o, "HTMLCanvasElement");
};
goog.dom.asserts.assertIsHTMLEmbedElement = function(o) {
  return goog.dom.asserts.assertIsElementType_(o, "HTMLEmbedElement");
};
goog.dom.asserts.assertIsHTMLFormElement = function(o) {
  return goog.dom.asserts.assertIsElementType_(o, "HTMLFormElement");
};
goog.dom.asserts.assertIsHTMLFrameElement = function(o) {
  return goog.dom.asserts.assertIsElementType_(o, "HTMLFrameElement");
};
goog.dom.asserts.assertIsHTMLIFrameElement = function(o) {
  return goog.dom.asserts.assertIsElementType_(o, "HTMLIFrameElement");
};
goog.dom.asserts.assertIsHTMLObjectElement = function(o) {
  return goog.dom.asserts.assertIsElementType_(o, "HTMLObjectElement");
};
goog.dom.asserts.assertIsHTMLScriptElement = function(o) {
  return goog.dom.asserts.assertIsElementType_(o, "HTMLScriptElement");
};
goog.dom.asserts.debugStringForType_ = function(value) {
  if (goog.isObject(value)) {
    try {
      return value.constructor.displayName || value.constructor.name || Object.prototype.toString.call(value);
    } catch (e) {
      return "<object could not be stringified>";
    }
  } else {
    return void 0 === value ? "undefined" : null === value ? "null" : typeof value;
  }
};
goog.dom.asserts.getWindow_ = function(o) {
  try {
    var doc = o && o.ownerDocument, win = doc && (doc.defaultView || doc.parentWindow);
    win = win || goog.global;
    if (win.Element && win.Location) {
      return win;
    }
  } catch (ex) {
  }
  return null;
};
goog.functions = {};
goog.functions.constant = function(retValue) {
  return function() {
    return retValue;
  };
};
goog.functions.FALSE = function() {
  return !1;
};
goog.functions.TRUE = function() {
  return !0;
};
goog.functions.NULL = function() {
  return null;
};
goog.functions.identity = function(opt_returnValue, var_args) {
  return opt_returnValue;
};
goog.functions.error = function(message) {
  return function() {
    throw Error(message);
  };
};
goog.functions.fail = function(err) {
  return function() {
    throw err;
  };
};
goog.functions.lock = function(f, opt_numArgs) {
  opt_numArgs = opt_numArgs || 0;
  return function() {
    return f.apply(this, Array.prototype.slice.call(arguments, 0, opt_numArgs));
  };
};
goog.functions.nth = function(n) {
  return function() {
    return arguments[n];
  };
};
goog.functions.partialRight = function(fn, var_args) {
  var rightArgs = Array.prototype.slice.call(arguments, 1);
  return function() {
    var newArgs = Array.prototype.slice.call(arguments);
    newArgs.push.apply(newArgs, rightArgs);
    return fn.apply(this, newArgs);
  };
};
goog.functions.withReturnValue = function(f, retValue) {
  return goog.functions.sequence(f, goog.functions.constant(retValue));
};
goog.functions.equalTo = function(value, opt_useLooseComparison) {
  return function(other) {
    return opt_useLooseComparison ? value == other : value === other;
  };
};
goog.functions.compose = function(fn, var_args) {
  var functions = arguments, length = functions.length;
  return function() {
    var result;
    length && (result = functions[length - 1].apply(this, arguments));
    for (var i = length - 2; 0 <= i; i--) {
      result = functions[i].call(this, result);
    }
    return result;
  };
};
goog.functions.sequence = function(var_args) {
  var functions = arguments, length = functions.length;
  return function() {
    for (var result, i = 0; i < length; i++) {
      result = functions[i].apply(this, arguments);
    }
    return result;
  };
};
goog.functions.and = function(var_args) {
  var functions = arguments, length = functions.length;
  return function() {
    for (var i = 0; i < length; i++) {
      if (!functions[i].apply(this, arguments)) {
        return !1;
      }
    }
    return !0;
  };
};
goog.functions.or = function(var_args) {
  var functions = arguments, length = functions.length;
  return function() {
    for (var i = 0; i < length; i++) {
      if (functions[i].apply(this, arguments)) {
        return !0;
      }
    }
    return !1;
  };
};
goog.functions.not = function(f) {
  return function() {
    return !f.apply(this, arguments);
  };
};
goog.functions.create = function(constructor, var_args) {
  var temp = function() {
  };
  temp.prototype = constructor.prototype;
  var obj = new temp;
  constructor.apply(obj, Array.prototype.slice.call(arguments, 1));
  return obj;
};
goog.functions.CACHE_RETURN_VALUE = !0;
goog.functions.cacheReturnValue = function(fn) {
  var called = !1, value;
  return function() {
    if (!goog.functions.CACHE_RETURN_VALUE) {
      return fn();
    }
    called || (value = fn(), called = !0);
    return value;
  };
};
goog.functions.once = function(f) {
  var inner = f;
  return function() {
    if (inner) {
      var tmp = inner;
      inner = null;
      tmp();
    }
  };
};
goog.functions.debounce = function(f, interval, opt_scope) {
  var timeout = 0;
  return function(var_args) {
    goog.global.clearTimeout(timeout);
    var args = arguments;
    timeout = goog.global.setTimeout(function() {
      f.apply(opt_scope, args);
    }, interval);
  };
};
goog.functions.throttle = function(f, interval, opt_scope) {
  var timeout = 0, shouldFire = !1, args = [], handleTimeout = function() {
    timeout = 0;
    shouldFire && (shouldFire = !1, fire());
  }, fire = function() {
    timeout = goog.global.setTimeout(handleTimeout, interval);
    f.apply(opt_scope, args);
  };
  return function(var_args) {
    args = arguments;
    timeout ? shouldFire = !0 : fire();
  };
};
goog.functions.rateLimit = function(f, interval, opt_scope) {
  var timeout = 0, handleTimeout = function() {
    timeout = 0;
  };
  return function(var_args) {
    timeout || (timeout = goog.global.setTimeout(handleTimeout, interval), f.apply(opt_scope, arguments));
  };
};
goog.dom.HtmlElement = function() {
};
goog.dom.TagName = function(tagName) {
  this.tagName_ = tagName;
};
goog.dom.TagName.prototype.toString = function() {
  return this.tagName_;
};
goog.dom.TagName.A = new goog.dom.TagName("A");
goog.dom.TagName.ABBR = new goog.dom.TagName("ABBR");
goog.dom.TagName.ACRONYM = new goog.dom.TagName("ACRONYM");
goog.dom.TagName.ADDRESS = new goog.dom.TagName("ADDRESS");
goog.dom.TagName.APPLET = new goog.dom.TagName("APPLET");
goog.dom.TagName.AREA = new goog.dom.TagName("AREA");
goog.dom.TagName.ARTICLE = new goog.dom.TagName("ARTICLE");
goog.dom.TagName.ASIDE = new goog.dom.TagName("ASIDE");
goog.dom.TagName.AUDIO = new goog.dom.TagName("AUDIO");
goog.dom.TagName.B = new goog.dom.TagName("B");
goog.dom.TagName.BASE = new goog.dom.TagName("BASE");
goog.dom.TagName.BASEFONT = new goog.dom.TagName("BASEFONT");
goog.dom.TagName.BDI = new goog.dom.TagName("BDI");
goog.dom.TagName.BDO = new goog.dom.TagName("BDO");
goog.dom.TagName.BIG = new goog.dom.TagName("BIG");
goog.dom.TagName.BLOCKQUOTE = new goog.dom.TagName("BLOCKQUOTE");
goog.dom.TagName.BODY = new goog.dom.TagName("BODY");
goog.dom.TagName.BR = new goog.dom.TagName("BR");
goog.dom.TagName.BUTTON = new goog.dom.TagName("BUTTON");
goog.dom.TagName.CANVAS = new goog.dom.TagName("CANVAS");
goog.dom.TagName.CAPTION = new goog.dom.TagName("CAPTION");
goog.dom.TagName.CENTER = new goog.dom.TagName("CENTER");
goog.dom.TagName.CITE = new goog.dom.TagName("CITE");
goog.dom.TagName.CODE = new goog.dom.TagName("CODE");
goog.dom.TagName.COL = new goog.dom.TagName("COL");
goog.dom.TagName.COLGROUP = new goog.dom.TagName("COLGROUP");
goog.dom.TagName.COMMAND = new goog.dom.TagName("COMMAND");
goog.dom.TagName.DATA = new goog.dom.TagName("DATA");
goog.dom.TagName.DATALIST = new goog.dom.TagName("DATALIST");
goog.dom.TagName.DD = new goog.dom.TagName("DD");
goog.dom.TagName.DEL = new goog.dom.TagName("DEL");
goog.dom.TagName.DETAILS = new goog.dom.TagName("DETAILS");
goog.dom.TagName.DFN = new goog.dom.TagName("DFN");
goog.dom.TagName.DIALOG = new goog.dom.TagName("DIALOG");
goog.dom.TagName.DIR = new goog.dom.TagName("DIR");
goog.dom.TagName.DIV = new goog.dom.TagName("DIV");
goog.dom.TagName.DL = new goog.dom.TagName("DL");
goog.dom.TagName.DT = new goog.dom.TagName("DT");
goog.dom.TagName.EM = new goog.dom.TagName("EM");
goog.dom.TagName.EMBED = new goog.dom.TagName("EMBED");
goog.dom.TagName.FIELDSET = new goog.dom.TagName("FIELDSET");
goog.dom.TagName.FIGCAPTION = new goog.dom.TagName("FIGCAPTION");
goog.dom.TagName.FIGURE = new goog.dom.TagName("FIGURE");
goog.dom.TagName.FONT = new goog.dom.TagName("FONT");
goog.dom.TagName.FOOTER = new goog.dom.TagName("FOOTER");
goog.dom.TagName.FORM = new goog.dom.TagName("FORM");
goog.dom.TagName.FRAME = new goog.dom.TagName("FRAME");
goog.dom.TagName.FRAMESET = new goog.dom.TagName("FRAMESET");
goog.dom.TagName.H1 = new goog.dom.TagName("H1");
goog.dom.TagName.H2 = new goog.dom.TagName("H2");
goog.dom.TagName.H3 = new goog.dom.TagName("H3");
goog.dom.TagName.H4 = new goog.dom.TagName("H4");
goog.dom.TagName.H5 = new goog.dom.TagName("H5");
goog.dom.TagName.H6 = new goog.dom.TagName("H6");
goog.dom.TagName.HEAD = new goog.dom.TagName("HEAD");
goog.dom.TagName.HEADER = new goog.dom.TagName("HEADER");
goog.dom.TagName.HGROUP = new goog.dom.TagName("HGROUP");
goog.dom.TagName.HR = new goog.dom.TagName("HR");
goog.dom.TagName.HTML = new goog.dom.TagName("HTML");
goog.dom.TagName.I = new goog.dom.TagName("I");
goog.dom.TagName.IFRAME = new goog.dom.TagName("IFRAME");
goog.dom.TagName.IMG = new goog.dom.TagName("IMG");
goog.dom.TagName.INPUT = new goog.dom.TagName("INPUT");
goog.dom.TagName.INS = new goog.dom.TagName("INS");
goog.dom.TagName.ISINDEX = new goog.dom.TagName("ISINDEX");
goog.dom.TagName.KBD = new goog.dom.TagName("KBD");
goog.dom.TagName.KEYGEN = new goog.dom.TagName("KEYGEN");
goog.dom.TagName.LABEL = new goog.dom.TagName("LABEL");
goog.dom.TagName.LEGEND = new goog.dom.TagName("LEGEND");
goog.dom.TagName.LI = new goog.dom.TagName("LI");
goog.dom.TagName.LINK = new goog.dom.TagName("LINK");
goog.dom.TagName.MAIN = new goog.dom.TagName("MAIN");
goog.dom.TagName.MAP = new goog.dom.TagName("MAP");
goog.dom.TagName.MARK = new goog.dom.TagName("MARK");
goog.dom.TagName.MATH = new goog.dom.TagName("MATH");
goog.dom.TagName.MENU = new goog.dom.TagName("MENU");
goog.dom.TagName.MENUITEM = new goog.dom.TagName("MENUITEM");
goog.dom.TagName.META = new goog.dom.TagName("META");
goog.dom.TagName.METER = new goog.dom.TagName("METER");
goog.dom.TagName.NAV = new goog.dom.TagName("NAV");
goog.dom.TagName.NOFRAMES = new goog.dom.TagName("NOFRAMES");
goog.dom.TagName.NOSCRIPT = new goog.dom.TagName("NOSCRIPT");
goog.dom.TagName.OBJECT = new goog.dom.TagName("OBJECT");
goog.dom.TagName.OL = new goog.dom.TagName("OL");
goog.dom.TagName.OPTGROUP = new goog.dom.TagName("OPTGROUP");
goog.dom.TagName.OPTION = new goog.dom.TagName("OPTION");
goog.dom.TagName.OUTPUT = new goog.dom.TagName("OUTPUT");
goog.dom.TagName.P = new goog.dom.TagName("P");
goog.dom.TagName.PARAM = new goog.dom.TagName("PARAM");
goog.dom.TagName.PICTURE = new goog.dom.TagName("PICTURE");
goog.dom.TagName.PRE = new goog.dom.TagName("PRE");
goog.dom.TagName.PROGRESS = new goog.dom.TagName("PROGRESS");
goog.dom.TagName.Q = new goog.dom.TagName("Q");
goog.dom.TagName.RP = new goog.dom.TagName("RP");
goog.dom.TagName.RT = new goog.dom.TagName("RT");
goog.dom.TagName.RTC = new goog.dom.TagName("RTC");
goog.dom.TagName.RUBY = new goog.dom.TagName("RUBY");
goog.dom.TagName.S = new goog.dom.TagName("S");
goog.dom.TagName.SAMP = new goog.dom.TagName("SAMP");
goog.dom.TagName.SCRIPT = new goog.dom.TagName("SCRIPT");
goog.dom.TagName.SECTION = new goog.dom.TagName("SECTION");
goog.dom.TagName.SELECT = new goog.dom.TagName("SELECT");
goog.dom.TagName.SMALL = new goog.dom.TagName("SMALL");
goog.dom.TagName.SOURCE = new goog.dom.TagName("SOURCE");
goog.dom.TagName.SPAN = new goog.dom.TagName("SPAN");
goog.dom.TagName.STRIKE = new goog.dom.TagName("STRIKE");
goog.dom.TagName.STRONG = new goog.dom.TagName("STRONG");
goog.dom.TagName.STYLE = new goog.dom.TagName("STYLE");
goog.dom.TagName.SUB = new goog.dom.TagName("SUB");
goog.dom.TagName.SUMMARY = new goog.dom.TagName("SUMMARY");
goog.dom.TagName.SUP = new goog.dom.TagName("SUP");
goog.dom.TagName.SVG = new goog.dom.TagName("SVG");
goog.dom.TagName.TABLE = new goog.dom.TagName("TABLE");
goog.dom.TagName.TBODY = new goog.dom.TagName("TBODY");
goog.dom.TagName.TD = new goog.dom.TagName("TD");
goog.dom.TagName.TEMPLATE = new goog.dom.TagName("TEMPLATE");
goog.dom.TagName.TEXTAREA = new goog.dom.TagName("TEXTAREA");
goog.dom.TagName.TFOOT = new goog.dom.TagName("TFOOT");
goog.dom.TagName.TH = new goog.dom.TagName("TH");
goog.dom.TagName.THEAD = new goog.dom.TagName("THEAD");
goog.dom.TagName.TIME = new goog.dom.TagName("TIME");
goog.dom.TagName.TITLE = new goog.dom.TagName("TITLE");
goog.dom.TagName.TR = new goog.dom.TagName("TR");
goog.dom.TagName.TRACK = new goog.dom.TagName("TRACK");
goog.dom.TagName.TT = new goog.dom.TagName("TT");
goog.dom.TagName.U = new goog.dom.TagName("U");
goog.dom.TagName.UL = new goog.dom.TagName("UL");
goog.dom.TagName.VAR = new goog.dom.TagName("VAR");
goog.dom.TagName.VIDEO = new goog.dom.TagName("VIDEO");
goog.dom.TagName.WBR = new goog.dom.TagName("WBR");
goog.dom.tags = {};
goog.dom.tags.VOID_TAGS_ = {area:!0, base:!0, br:!0, col:!0, command:!0, embed:!0, hr:!0, img:!0, input:!0, keygen:!0, link:!0, meta:!0, param:!0, source:!0, track:!0, wbr:!0};
goog.dom.tags.isVoidTag = function(tagName) {
  return !0 === goog.dom.tags.VOID_TAGS_[tagName];
};
goog.html = {};
goog.html.trustedtypes = {};
goog.html.trustedtypes.getPolicyPrivateDoNotAccessOrElse = function() {
  if (!goog.TRUSTED_TYPES_POLICY_NAME) {
    return null;
  }
  void 0 === goog.html.trustedtypes.cachedPolicy_ && (goog.html.trustedtypes.cachedPolicy_ = goog.createTrustedTypesPolicy(goog.TRUSTED_TYPES_POLICY_NAME + "#html"));
  return goog.html.trustedtypes.cachedPolicy_;
};
goog.string.TypedString = function() {
};
goog.string.Const = function(opt_token, opt_content) {
  this.stringConstValueWithSecurityContract__googStringSecurityPrivate_ = opt_token === goog.string.Const.GOOG_STRING_CONSTRUCTOR_TOKEN_PRIVATE_ && opt_content || "";
  this.STRING_CONST_TYPE_MARKER__GOOG_STRING_SECURITY_PRIVATE_ = goog.string.Const.TYPE_MARKER_;
};
goog.string.Const.prototype.implementsGoogStringTypedString = !0;
goog.string.Const.prototype.getTypedStringValue = function() {
  return this.stringConstValueWithSecurityContract__googStringSecurityPrivate_;
};
goog.DEBUG && (goog.string.Const.prototype.toString = function() {
  return "Const{" + this.stringConstValueWithSecurityContract__googStringSecurityPrivate_ + "}";
});
goog.string.Const.unwrap = function(stringConst) {
  if (stringConst instanceof goog.string.Const && stringConst.constructor === goog.string.Const && stringConst.STRING_CONST_TYPE_MARKER__GOOG_STRING_SECURITY_PRIVATE_ === goog.string.Const.TYPE_MARKER_) {
    return stringConst.stringConstValueWithSecurityContract__googStringSecurityPrivate_;
  }
  goog.asserts.fail("expected object of type Const, got '" + stringConst + "'");
  return "type_error:Const";
};
goog.string.Const.from = function(s) {
  return new goog.string.Const(goog.string.Const.GOOG_STRING_CONSTRUCTOR_TOKEN_PRIVATE_, s);
};
goog.string.Const.TYPE_MARKER_ = {};
goog.string.Const.GOOG_STRING_CONSTRUCTOR_TOKEN_PRIVATE_ = {};
goog.string.Const.EMPTY = goog.string.Const.from("");
goog.html.SafeScript = function() {
  this.privateDoNotAccessOrElseSafeScriptWrappedValue_ = "";
  this.SAFE_SCRIPT_TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_ = goog.html.SafeScript.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_;
};
goog.html.SafeScript.prototype.implementsGoogStringTypedString = !0;
goog.html.SafeScript.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_ = {};
goog.html.SafeScript.fromConstant = function(script) {
  var scriptString = goog.string.Const.unwrap(script);
  return 0 === scriptString.length ? goog.html.SafeScript.EMPTY : goog.html.SafeScript.createSafeScriptSecurityPrivateDoNotAccessOrElse(scriptString);
};
goog.html.SafeScript.fromConstantAndArgs = function(code, var_args) {
  for (var args = [], i = 1; i < arguments.length; i++) {
    args.push(goog.html.SafeScript.stringify_(arguments[i]));
  }
  return goog.html.SafeScript.createSafeScriptSecurityPrivateDoNotAccessOrElse("(" + goog.string.Const.unwrap(code) + ")(" + args.join(", ") + ");");
};
goog.html.SafeScript.fromJson = function(val) {
  return goog.html.SafeScript.createSafeScriptSecurityPrivateDoNotAccessOrElse(goog.html.SafeScript.stringify_(val));
};
goog.html.SafeScript.prototype.getTypedStringValue = function() {
  return this.privateDoNotAccessOrElseSafeScriptWrappedValue_.toString();
};
goog.DEBUG && (goog.html.SafeScript.prototype.toString = function() {
  return "SafeScript{" + this.privateDoNotAccessOrElseSafeScriptWrappedValue_ + "}";
});
goog.html.SafeScript.unwrap = function(safeScript) {
  return goog.html.SafeScript.unwrapTrustedScript(safeScript).toString();
};
goog.html.SafeScript.unwrapTrustedScript = function(safeScript) {
  if (safeScript instanceof goog.html.SafeScript && safeScript.constructor === goog.html.SafeScript && safeScript.SAFE_SCRIPT_TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_ === goog.html.SafeScript.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_) {
    return safeScript.privateDoNotAccessOrElseSafeScriptWrappedValue_;
  }
  goog.asserts.fail("expected object of type SafeScript, got '" + safeScript + "' of type " + goog.typeOf(safeScript));
  return "type_error:SafeScript";
};
goog.html.SafeScript.stringify_ = function(val) {
  return JSON.stringify(val).replace(/</g, "\\x3c");
};
goog.html.SafeScript.createSafeScriptSecurityPrivateDoNotAccessOrElse = function(script) {
  return (new goog.html.SafeScript).initSecurityPrivateDoNotAccessOrElse_(script);
};
goog.html.SafeScript.prototype.initSecurityPrivateDoNotAccessOrElse_ = function(script) {
  var policy = goog.html.trustedtypes.getPolicyPrivateDoNotAccessOrElse();
  this.privateDoNotAccessOrElseSafeScriptWrappedValue_ = policy ? policy.createScript(script) : script;
  return this;
};
goog.html.SafeScript.EMPTY = function() {
  return goog.html.SafeScript.createSafeScriptSecurityPrivateDoNotAccessOrElse("");
}();
goog.fs = {};
goog.fs.url = {};
goog.fs.url.createObjectUrl = function(obj) {
  return goog.fs.url.getUrlObject_().createObjectURL(obj);
};
goog.fs.url.revokeObjectUrl = function(url) {
  goog.fs.url.getUrlObject_().revokeObjectURL(url);
};
goog.fs.url.UrlObject_ = function() {
};
goog.fs.url.UrlObject_.prototype.createObjectURL = function(arg) {
};
goog.fs.url.UrlObject_.prototype.revokeObjectURL = function(s) {
};
goog.fs.url.getUrlObject_ = function() {
  var urlObject = goog.fs.url.findUrlObject_();
  if (null != urlObject) {
    return urlObject;
  }
  throw Error("This browser doesn't seem to support blob URLs");
};
goog.fs.url.findUrlObject_ = function() {
  return void 0 !== goog.global.URL && void 0 !== goog.global.URL.createObjectURL ? goog.global.URL : void 0 !== goog.global.webkitURL && void 0 !== goog.global.webkitURL.createObjectURL ? goog.global.webkitURL : void 0 !== goog.global.createObjectURL ? goog.global : null;
};
goog.fs.url.browserSupportsObjectUrls = function() {
  return null != goog.fs.url.findUrlObject_();
};
goog.fs.blob = {};
goog.fs.blob.getBlob = function(var_args) {
  var BlobBuilder = goog.global.BlobBuilder || goog.global.WebKitBlobBuilder;
  if (void 0 !== BlobBuilder) {
    for (var bb = new BlobBuilder, i = 0; i < arguments.length; i++) {
      bb.append(arguments[i]);
    }
    return bb.getBlob();
  }
  return goog.fs.blob.getBlobWithProperties(goog.array.toArray(arguments));
};
goog.fs.blob.getBlobWithProperties = function(parts, opt_type, opt_endings) {
  var BlobBuilder = goog.global.BlobBuilder || goog.global.WebKitBlobBuilder;
  if (void 0 !== BlobBuilder) {
    for (var bb = new BlobBuilder, i = 0; i < parts.length; i++) {
      bb.append(parts[i], opt_endings);
    }
    return bb.getBlob(opt_type);
  }
  if (void 0 !== goog.global.Blob) {
    var properties = {};
    opt_type && (properties.type = opt_type);
    opt_endings && (properties.endings = opt_endings);
    return new Blob(parts, properties);
  }
  throw Error("This browser doesn't seem to support creating Blobs");
};
goog.i18n = {};
goog.i18n.bidi = {};
goog.i18n.bidi.FORCE_RTL = !1;
goog.i18n.bidi.IS_RTL = goog.i18n.bidi.FORCE_RTL || ("ar" == goog.LOCALE.substring(0, 2).toLowerCase() || "fa" == goog.LOCALE.substring(0, 2).toLowerCase() || "he" == goog.LOCALE.substring(0, 2).toLowerCase() || "iw" == goog.LOCALE.substring(0, 2).toLowerCase() || "ps" == goog.LOCALE.substring(0, 2).toLowerCase() || "sd" == goog.LOCALE.substring(0, 2).toLowerCase() || "ug" == goog.LOCALE.substring(0, 2).toLowerCase() || "ur" == goog.LOCALE.substring(0, 2).toLowerCase() || "yi" == goog.LOCALE.substring(0, 
2).toLowerCase()) && (2 == goog.LOCALE.length || "-" == goog.LOCALE.substring(2, 3) || "_" == goog.LOCALE.substring(2, 3)) || 3 <= goog.LOCALE.length && "ckb" == goog.LOCALE.substring(0, 3).toLowerCase() && (3 == goog.LOCALE.length || "-" == goog.LOCALE.substring(3, 4) || "_" == goog.LOCALE.substring(3, 4)) || 7 <= goog.LOCALE.length && ("-" == goog.LOCALE.substring(2, 3) || "_" == goog.LOCALE.substring(2, 3)) && ("adlm" == goog.LOCALE.substring(3, 7).toLowerCase() || "arab" == goog.LOCALE.substring(3, 
7).toLowerCase() || "hebr" == goog.LOCALE.substring(3, 7).toLowerCase() || "nkoo" == goog.LOCALE.substring(3, 7).toLowerCase() || "rohg" == goog.LOCALE.substring(3, 7).toLowerCase() || "thaa" == goog.LOCALE.substring(3, 7).toLowerCase()) || 8 <= goog.LOCALE.length && ("-" == goog.LOCALE.substring(3, 4) || "_" == goog.LOCALE.substring(3, 4)) && ("adlm" == goog.LOCALE.substring(4, 8).toLowerCase() || "arab" == goog.LOCALE.substring(4, 8).toLowerCase() || "hebr" == goog.LOCALE.substring(4, 8).toLowerCase() || 
"nkoo" == goog.LOCALE.substring(4, 8).toLowerCase() || "rohg" == goog.LOCALE.substring(4, 8).toLowerCase() || "thaa" == goog.LOCALE.substring(4, 8).toLowerCase());
goog.i18n.bidi.Format = {LRE:"\u202a", RLE:"\u202b", PDF:"\u202c", LRM:"\u200e", RLM:"\u200f"};
goog.i18n.bidi.Dir = {LTR:1, RTL:-1, NEUTRAL:0};
goog.i18n.bidi.RIGHT = "right";
goog.i18n.bidi.LEFT = "left";
goog.i18n.bidi.I18N_RIGHT = goog.i18n.bidi.IS_RTL ? goog.i18n.bidi.LEFT : goog.i18n.bidi.RIGHT;
goog.i18n.bidi.I18N_LEFT = goog.i18n.bidi.IS_RTL ? goog.i18n.bidi.RIGHT : goog.i18n.bidi.LEFT;
goog.i18n.bidi.toDir = function(givenDir, opt_noNeutral) {
  return "number" == typeof givenDir ? 0 < givenDir ? goog.i18n.bidi.Dir.LTR : 0 > givenDir ? goog.i18n.bidi.Dir.RTL : opt_noNeutral ? null : goog.i18n.bidi.Dir.NEUTRAL : null == givenDir ? null : givenDir ? goog.i18n.bidi.Dir.RTL : goog.i18n.bidi.Dir.LTR;
};
goog.i18n.bidi.ltrChars_ = "A-Za-z\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u02b8\u0300-\u0590\u0900-\u1fff\u200e\u2c00-\ud801\ud804-\ud839\ud83c-\udbff\uf900-\ufb1c\ufe00-\ufe6f\ufefd-\uffff";
goog.i18n.bidi.rtlChars_ = "\u0591-\u06ef\u06fa-\u08ff\u200f\ud802-\ud803\ud83a-\ud83b\ufb1d-\ufdff\ufe70-\ufefc";
goog.i18n.bidi.htmlSkipReg_ = /<[^>]*>|&[^;]+;/g;
goog.i18n.bidi.stripHtmlIfNeeded_ = function(str, opt_isStripNeeded) {
  return opt_isStripNeeded ? str.replace(goog.i18n.bidi.htmlSkipReg_, "") : str;
};
goog.i18n.bidi.rtlCharReg_ = new RegExp("[" + goog.i18n.bidi.rtlChars_ + "]");
goog.i18n.bidi.ltrCharReg_ = new RegExp("[" + goog.i18n.bidi.ltrChars_ + "]");
goog.i18n.bidi.hasAnyRtl = function(str, opt_isHtml) {
  return goog.i18n.bidi.rtlCharReg_.test(goog.i18n.bidi.stripHtmlIfNeeded_(str, opt_isHtml));
};
goog.i18n.bidi.hasRtlChar = goog.i18n.bidi.hasAnyRtl;
goog.i18n.bidi.hasAnyLtr = function(str, opt_isHtml) {
  return goog.i18n.bidi.ltrCharReg_.test(goog.i18n.bidi.stripHtmlIfNeeded_(str, opt_isHtml));
};
goog.i18n.bidi.ltrRe_ = new RegExp("^[" + goog.i18n.bidi.ltrChars_ + "]");
goog.i18n.bidi.rtlRe_ = new RegExp("^[" + goog.i18n.bidi.rtlChars_ + "]");
goog.i18n.bidi.isRtlChar = function(str) {
  return goog.i18n.bidi.rtlRe_.test(str);
};
goog.i18n.bidi.isLtrChar = function(str) {
  return goog.i18n.bidi.ltrRe_.test(str);
};
goog.i18n.bidi.isNeutralChar = function(str) {
  return !goog.i18n.bidi.isLtrChar(str) && !goog.i18n.bidi.isRtlChar(str);
};
goog.i18n.bidi.ltrDirCheckRe_ = new RegExp("^[^" + goog.i18n.bidi.rtlChars_ + "]*[" + goog.i18n.bidi.ltrChars_ + "]");
goog.i18n.bidi.rtlDirCheckRe_ = new RegExp("^[^" + goog.i18n.bidi.ltrChars_ + "]*[" + goog.i18n.bidi.rtlChars_ + "]");
goog.i18n.bidi.startsWithRtl = function(str, opt_isHtml) {
  return goog.i18n.bidi.rtlDirCheckRe_.test(goog.i18n.bidi.stripHtmlIfNeeded_(str, opt_isHtml));
};
goog.i18n.bidi.isRtlText = goog.i18n.bidi.startsWithRtl;
goog.i18n.bidi.startsWithLtr = function(str, opt_isHtml) {
  return goog.i18n.bidi.ltrDirCheckRe_.test(goog.i18n.bidi.stripHtmlIfNeeded_(str, opt_isHtml));
};
goog.i18n.bidi.isLtrText = goog.i18n.bidi.startsWithLtr;
goog.i18n.bidi.isRequiredLtrRe_ = /^http:\/\/.*/;
goog.i18n.bidi.isNeutralText = function(str, opt_isHtml) {
  str = goog.i18n.bidi.stripHtmlIfNeeded_(str, opt_isHtml);
  return goog.i18n.bidi.isRequiredLtrRe_.test(str) || !goog.i18n.bidi.hasAnyLtr(str) && !goog.i18n.bidi.hasAnyRtl(str);
};
goog.i18n.bidi.ltrExitDirCheckRe_ = new RegExp("[" + goog.i18n.bidi.ltrChars_ + "][^" + goog.i18n.bidi.rtlChars_ + "]*$");
goog.i18n.bidi.rtlExitDirCheckRe_ = new RegExp("[" + goog.i18n.bidi.rtlChars_ + "][^" + goog.i18n.bidi.ltrChars_ + "]*$");
goog.i18n.bidi.endsWithLtr = function(str, opt_isHtml) {
  return goog.i18n.bidi.ltrExitDirCheckRe_.test(goog.i18n.bidi.stripHtmlIfNeeded_(str, opt_isHtml));
};
goog.i18n.bidi.isLtrExitText = goog.i18n.bidi.endsWithLtr;
goog.i18n.bidi.endsWithRtl = function(str, opt_isHtml) {
  return goog.i18n.bidi.rtlExitDirCheckRe_.test(goog.i18n.bidi.stripHtmlIfNeeded_(str, opt_isHtml));
};
goog.i18n.bidi.isRtlExitText = goog.i18n.bidi.endsWithRtl;
goog.i18n.bidi.rtlLocalesRe_ = /^(ar|ckb|dv|he|iw|fa|nqo|ps|sd|ug|ur|yi|.*[-_](Adlm|Arab|Hebr|Nkoo|Rohg|Thaa))(?!.*[-_](Latn|Cyrl)($|-|_))($|-|_)/i;
goog.i18n.bidi.isRtlLanguage = function(lang) {
  return goog.i18n.bidi.rtlLocalesRe_.test(lang);
};
goog.i18n.bidi.bracketGuardTextRe_ = /(\(.*?\)+)|(\[.*?\]+)|(\{.*?\}+)|(<.*?>+)/g;
goog.i18n.bidi.guardBracketInText = function(s, opt_isRtlContext) {
  var mark = (void 0 === opt_isRtlContext ? goog.i18n.bidi.hasAnyRtl(s) : opt_isRtlContext) ? goog.i18n.bidi.Format.RLM : goog.i18n.bidi.Format.LRM;
  return s.replace(goog.i18n.bidi.bracketGuardTextRe_, mark + "$&" + mark);
};
goog.i18n.bidi.enforceRtlInHtml = function(html) {
  return "<" == html.charAt(0) ? html.replace(/<\w+/, "$& dir=rtl") : "\n<span dir=rtl>" + html + "</span>";
};
goog.i18n.bidi.enforceRtlInText = function(text) {
  return goog.i18n.bidi.Format.RLE + text + goog.i18n.bidi.Format.PDF;
};
goog.i18n.bidi.enforceLtrInHtml = function(html) {
  return "<" == html.charAt(0) ? html.replace(/<\w+/, "$& dir=ltr") : "\n<span dir=ltr>" + html + "</span>";
};
goog.i18n.bidi.enforceLtrInText = function(text) {
  return goog.i18n.bidi.Format.LRE + text + goog.i18n.bidi.Format.PDF;
};
goog.i18n.bidi.dimensionsRe_ = /:\s*([.\d][.\w]*)\s+([.\d][.\w]*)\s+([.\d][.\w]*)\s+([.\d][.\w]*)/g;
goog.i18n.bidi.leftRe_ = /left/gi;
goog.i18n.bidi.rightRe_ = /right/gi;
goog.i18n.bidi.tempRe_ = /%%%%/g;
goog.i18n.bidi.mirrorCSS = function(cssStr) {
  return cssStr.replace(goog.i18n.bidi.dimensionsRe_, ":$1 $4 $3 $2").replace(goog.i18n.bidi.leftRe_, "%%%%").replace(goog.i18n.bidi.rightRe_, goog.i18n.bidi.LEFT).replace(goog.i18n.bidi.tempRe_, goog.i18n.bidi.RIGHT);
};
goog.i18n.bidi.doubleQuoteSubstituteRe_ = /([\u0591-\u05f2])"/g;
goog.i18n.bidi.singleQuoteSubstituteRe_ = /([\u0591-\u05f2])'/g;
goog.i18n.bidi.normalizeHebrewQuote = function(str) {
  return str.replace(goog.i18n.bidi.doubleQuoteSubstituteRe_, "$1\u05f4").replace(goog.i18n.bidi.singleQuoteSubstituteRe_, "$1\u05f3");
};
goog.i18n.bidi.wordSeparatorRe_ = /\s+/;
goog.i18n.bidi.hasNumeralsRe_ = /[\d\u06f0-\u06f9]/;
goog.i18n.bidi.rtlDetectionThreshold_ = 0.40;
goog.i18n.bidi.estimateDirection = function(str, opt_isHtml) {
  for (var rtlCount = 0, totalCount = 0, hasWeaklyLtr = !1, tokens = goog.i18n.bidi.stripHtmlIfNeeded_(str, opt_isHtml).split(goog.i18n.bidi.wordSeparatorRe_), i = 0; i < tokens.length; i++) {
    var token = tokens[i];
    goog.i18n.bidi.startsWithRtl(token) ? (rtlCount++, totalCount++) : goog.i18n.bidi.isRequiredLtrRe_.test(token) ? hasWeaklyLtr = !0 : goog.i18n.bidi.hasAnyLtr(token) ? totalCount++ : goog.i18n.bidi.hasNumeralsRe_.test(token) && (hasWeaklyLtr = !0);
  }
  return 0 == totalCount ? hasWeaklyLtr ? goog.i18n.bidi.Dir.LTR : goog.i18n.bidi.Dir.NEUTRAL : rtlCount / totalCount > goog.i18n.bidi.rtlDetectionThreshold_ ? goog.i18n.bidi.Dir.RTL : goog.i18n.bidi.Dir.LTR;
};
goog.i18n.bidi.detectRtlDirectionality = function(str, opt_isHtml) {
  return goog.i18n.bidi.estimateDirection(str, opt_isHtml) == goog.i18n.bidi.Dir.RTL;
};
goog.i18n.bidi.setElementDirAndAlign = function(element, dir) {
  element && (dir = goog.i18n.bidi.toDir(dir)) && (element.style.textAlign = dir == goog.i18n.bidi.Dir.RTL ? goog.i18n.bidi.RIGHT : goog.i18n.bidi.LEFT, element.dir = dir == goog.i18n.bidi.Dir.RTL ? "rtl" : "ltr");
};
goog.i18n.bidi.setElementDirByTextDirectionality = function(element, text) {
  switch(goog.i18n.bidi.estimateDirection(text)) {
    case goog.i18n.bidi.Dir.LTR:
      "ltr" !== element.dir && (element.dir = "ltr");
      break;
    case goog.i18n.bidi.Dir.RTL:
      "rtl" !== element.dir && (element.dir = "rtl");
      break;
    default:
      element.removeAttribute("dir");
  }
};
goog.i18n.bidi.DirectionalString = function() {
};
goog.html.TrustedResourceUrl = function(opt_token, opt_content) {
  this.privateDoNotAccessOrElseTrustedResourceUrlWrappedValue_ = opt_token === goog.html.TrustedResourceUrl.CONSTRUCTOR_TOKEN_PRIVATE_ && opt_content || "";
  this.TRUSTED_RESOURCE_URL_TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_ = goog.html.TrustedResourceUrl.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_;
};
goog.html.TrustedResourceUrl.prototype.implementsGoogStringTypedString = !0;
goog.html.TrustedResourceUrl.prototype.getTypedStringValue = function() {
  return this.privateDoNotAccessOrElseTrustedResourceUrlWrappedValue_.toString();
};
goog.html.TrustedResourceUrl.prototype.implementsGoogI18nBidiDirectionalString = !0;
goog.html.TrustedResourceUrl.prototype.getDirection = function() {
  return goog.i18n.bidi.Dir.LTR;
};
goog.html.TrustedResourceUrl.prototype.cloneWithParams = function(searchParams, opt_hashParams) {
  var url = goog.html.TrustedResourceUrl.unwrap(this), parts = goog.html.TrustedResourceUrl.URL_PARAM_PARSER_.exec(url), urlHash = parts[3] || "";
  return goog.html.TrustedResourceUrl.createTrustedResourceUrlSecurityPrivateDoNotAccessOrElse(parts[1] + goog.html.TrustedResourceUrl.stringifyParams_("?", parts[2] || "", searchParams) + goog.html.TrustedResourceUrl.stringifyParams_("#", urlHash, opt_hashParams));
};
goog.DEBUG && (goog.html.TrustedResourceUrl.prototype.toString = function() {
  return "TrustedResourceUrl{" + this.privateDoNotAccessOrElseTrustedResourceUrlWrappedValue_ + "}";
});
goog.html.TrustedResourceUrl.unwrap = function(trustedResourceUrl) {
  return goog.html.TrustedResourceUrl.unwrapTrustedScriptURL(trustedResourceUrl).toString();
};
goog.html.TrustedResourceUrl.unwrapTrustedScriptURL = function(trustedResourceUrl) {
  if (trustedResourceUrl instanceof goog.html.TrustedResourceUrl && trustedResourceUrl.constructor === goog.html.TrustedResourceUrl && trustedResourceUrl.TRUSTED_RESOURCE_URL_TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_ === goog.html.TrustedResourceUrl.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_) {
    return trustedResourceUrl.privateDoNotAccessOrElseTrustedResourceUrlWrappedValue_;
  }
  goog.asserts.fail("expected object of type TrustedResourceUrl, got '" + trustedResourceUrl + "' of type " + goog.typeOf(trustedResourceUrl));
  return "type_error:TrustedResourceUrl";
};
goog.html.TrustedResourceUrl.format = function(format, args) {
  var formatStr = goog.string.Const.unwrap(format);
  if (!goog.html.TrustedResourceUrl.BASE_URL_.test(formatStr)) {
    throw Error("Invalid TrustedResourceUrl format: " + formatStr);
  }
  var result = formatStr.replace(goog.html.TrustedResourceUrl.FORMAT_MARKER_, function(match, id) {
    if (!Object.prototype.hasOwnProperty.call(args, id)) {
      throw Error('Found marker, "' + id + '", in format string, "' + formatStr + '", but no valid label mapping found in args: ' + JSON.stringify(args));
    }
    var arg = args[id];
    return arg instanceof goog.string.Const ? goog.string.Const.unwrap(arg) : encodeURIComponent(String(arg));
  });
  return goog.html.TrustedResourceUrl.createTrustedResourceUrlSecurityPrivateDoNotAccessOrElse(result);
};
goog.html.TrustedResourceUrl.FORMAT_MARKER_ = /%{(\w+)}/g;
goog.html.TrustedResourceUrl.BASE_URL_ = /^((https:)?\/\/[0-9a-z.:[\]-]+\/|\/[^/\\]|[^:/\\%]+\/|[^:/\\%]*[?#]|about:blank#)/i;
goog.html.TrustedResourceUrl.URL_PARAM_PARSER_ = /^([^?#]*)(\?[^#]*)?(#[\s\S]*)?/;
goog.html.TrustedResourceUrl.formatWithParams = function(format, args, searchParams, opt_hashParams) {
  return goog.html.TrustedResourceUrl.format(format, args).cloneWithParams(searchParams, opt_hashParams);
};
goog.html.TrustedResourceUrl.fromConstant = function(url) {
  return goog.html.TrustedResourceUrl.createTrustedResourceUrlSecurityPrivateDoNotAccessOrElse(goog.string.Const.unwrap(url));
};
goog.html.TrustedResourceUrl.fromConstants = function(parts) {
  for (var unwrapped = "", i = 0; i < parts.length; i++) {
    unwrapped += goog.string.Const.unwrap(parts[i]);
  }
  return goog.html.TrustedResourceUrl.createTrustedResourceUrlSecurityPrivateDoNotAccessOrElse(unwrapped);
};
goog.html.TrustedResourceUrl.fromSafeScript = function(safeScript) {
  var blob = goog.fs.blob.getBlobWithProperties([goog.html.SafeScript.unwrap(safeScript)], "text/javascript"), url = goog.fs.url.createObjectUrl(blob);
  return goog.html.TrustedResourceUrl.createTrustedResourceUrlSecurityPrivateDoNotAccessOrElse(url);
};
goog.html.TrustedResourceUrl.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_ = {};
goog.html.TrustedResourceUrl.createTrustedResourceUrlSecurityPrivateDoNotAccessOrElse = function(url) {
  var policy = goog.html.trustedtypes.getPolicyPrivateDoNotAccessOrElse(), value = policy ? policy.createScriptURL(url) : url;
  return new goog.html.TrustedResourceUrl(goog.html.TrustedResourceUrl.CONSTRUCTOR_TOKEN_PRIVATE_, value);
};
goog.html.TrustedResourceUrl.stringifyParams_ = function(prefix, currentString, params) {
  if (null == params) {
    return currentString;
  }
  if ("string" === typeof params) {
    return params ? prefix + encodeURIComponent(params) : "";
  }
  for (var key in params) {
    for (var value = params[key], outputValues = Array.isArray(value) ? value : [value], i = 0; i < outputValues.length; i++) {
      var outputValue = outputValues[i];
      null != outputValue && (currentString || (currentString = prefix), currentString += (currentString.length > prefix.length ? "&" : "") + encodeURIComponent(key) + "=" + encodeURIComponent(String(outputValue)));
    }
  }
  return currentString;
};
goog.html.TrustedResourceUrl.CONSTRUCTOR_TOKEN_PRIVATE_ = {};
goog.html.SafeUrl = function(opt_token, opt_content) {
  this.privateDoNotAccessOrElseSafeUrlWrappedValue_ = opt_token === goog.html.SafeUrl.CONSTRUCTOR_TOKEN_PRIVATE_ && opt_content || "";
  this.SAFE_URL_TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_ = goog.html.SafeUrl.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_;
};
goog.html.SafeUrl.INNOCUOUS_STRING = "about:invalid#zClosurez";
goog.html.SafeUrl.prototype.implementsGoogStringTypedString = !0;
goog.html.SafeUrl.prototype.getTypedStringValue = function() {
  return this.privateDoNotAccessOrElseSafeUrlWrappedValue_.toString();
};
goog.html.SafeUrl.prototype.implementsGoogI18nBidiDirectionalString = !0;
goog.html.SafeUrl.prototype.getDirection = function() {
  return goog.i18n.bidi.Dir.LTR;
};
goog.DEBUG && (goog.html.SafeUrl.prototype.toString = function() {
  return "SafeUrl{" + this.privateDoNotAccessOrElseSafeUrlWrappedValue_ + "}";
});
goog.html.SafeUrl.unwrap = function(safeUrl) {
  if (safeUrl instanceof goog.html.SafeUrl && safeUrl.constructor === goog.html.SafeUrl && safeUrl.SAFE_URL_TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_ === goog.html.SafeUrl.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_) {
    return safeUrl.privateDoNotAccessOrElseSafeUrlWrappedValue_;
  }
  goog.asserts.fail("expected object of type SafeUrl, got '" + safeUrl + "' of type " + goog.typeOf(safeUrl));
  return "type_error:SafeUrl";
};
goog.html.SafeUrl.fromConstant = function(url) {
  return goog.html.SafeUrl.createSafeUrlSecurityPrivateDoNotAccessOrElse(goog.string.Const.unwrap(url));
};
goog.html.SAFE_MIME_TYPE_PATTERN_ = /^(?:audio\/(?:3gpp2|3gpp|aac|L16|midi|mp3|mp4|mpeg|oga|ogg|opus|x-m4a|x-matroska|x-wav|wav|webm)|font\/\w+|image\/(?:bmp|gif|jpeg|jpg|png|tiff|webp|x-icon)|text\/csv|video\/(?:mpeg|mp4|ogg|webm|quicktime|x-matroska))(?:;\w+=(?:\w+|"[\w;,= ]+"))*$/i;
goog.html.SafeUrl.isSafeMimeType = function(mimeType) {
  return goog.html.SAFE_MIME_TYPE_PATTERN_.test(mimeType);
};
goog.html.SafeUrl.fromBlob = function(blob) {
  var url = goog.html.SafeUrl.isSafeMimeType(blob.type) ? goog.fs.url.createObjectUrl(blob) : goog.html.SafeUrl.INNOCUOUS_STRING;
  return goog.html.SafeUrl.createSafeUrlSecurityPrivateDoNotAccessOrElse(url);
};
goog.html.SafeUrl.revokeObjectUrl = function(safeUrl) {
  var url = safeUrl.getTypedStringValue();
  url !== goog.html.SafeUrl.INNOCUOUS_STRING && goog.fs.url.revokeObjectUrl(url);
};
goog.html.SafeUrl.fromMediaSource = function(mediaSource) {
  goog.asserts.assert("MediaSource" in goog.global, "No support for MediaSource");
  var url = mediaSource instanceof MediaSource ? goog.fs.url.createObjectUrl(mediaSource) : goog.html.SafeUrl.INNOCUOUS_STRING;
  return goog.html.SafeUrl.createSafeUrlSecurityPrivateDoNotAccessOrElse(url);
};
goog.html.DATA_URL_PATTERN_ = /^data:(.*);base64,[a-z0-9+\/]+=*$/i;
goog.html.SafeUrl.fromDataUrl = function(dataUrl) {
  var filteredDataUrl = dataUrl.replace(/(%0A|%0D)/g, ""), match = filteredDataUrl.match(goog.html.DATA_URL_PATTERN_), valid = match && goog.html.SafeUrl.isSafeMimeType(match[1]);
  return goog.html.SafeUrl.createSafeUrlSecurityPrivateDoNotAccessOrElse(valid ? filteredDataUrl : goog.html.SafeUrl.INNOCUOUS_STRING);
};
goog.html.SafeUrl.fromTelUrl = function(telUrl) {
  goog.string.internal.caseInsensitiveStartsWith(telUrl, "tel:") || (telUrl = goog.html.SafeUrl.INNOCUOUS_STRING);
  return goog.html.SafeUrl.createSafeUrlSecurityPrivateDoNotAccessOrElse(telUrl);
};
goog.html.SIP_URL_PATTERN_ = /^sip[s]?:[+a-z0-9_.!$%&'*\/=^`{|}~-]+@([a-z0-9-]+\.)+[a-z0-9]{2,63}$/i;
goog.html.SafeUrl.fromSipUrl = function(sipUrl) {
  goog.html.SIP_URL_PATTERN_.test(decodeURIComponent(sipUrl)) || (sipUrl = goog.html.SafeUrl.INNOCUOUS_STRING);
  return goog.html.SafeUrl.createSafeUrlSecurityPrivateDoNotAccessOrElse(sipUrl);
};
goog.html.SafeUrl.fromFacebookMessengerUrl = function(facebookMessengerUrl) {
  goog.string.internal.caseInsensitiveStartsWith(facebookMessengerUrl, "fb-messenger://share") || (facebookMessengerUrl = goog.html.SafeUrl.INNOCUOUS_STRING);
  return goog.html.SafeUrl.createSafeUrlSecurityPrivateDoNotAccessOrElse(facebookMessengerUrl);
};
goog.html.SafeUrl.fromWhatsAppUrl = function(whatsAppUrl) {
  goog.string.internal.caseInsensitiveStartsWith(whatsAppUrl, "whatsapp://send") || (whatsAppUrl = goog.html.SafeUrl.INNOCUOUS_STRING);
  return goog.html.SafeUrl.createSafeUrlSecurityPrivateDoNotAccessOrElse(whatsAppUrl);
};
goog.html.SafeUrl.fromSmsUrl = function(smsUrl) {
  goog.string.internal.caseInsensitiveStartsWith(smsUrl, "sms:") && goog.html.SafeUrl.isSmsUrlBodyValid_(smsUrl) || (smsUrl = goog.html.SafeUrl.INNOCUOUS_STRING);
  return goog.html.SafeUrl.createSafeUrlSecurityPrivateDoNotAccessOrElse(smsUrl);
};
goog.html.SafeUrl.isSmsUrlBodyValid_ = function(smsUrl) {
  var hash = smsUrl.indexOf("#");
  0 < hash && (smsUrl = smsUrl.substring(0, hash));
  var bodyParams = smsUrl.match(/[?&]body=/gi);
  if (!bodyParams) {
    return !0;
  }
  if (1 < bodyParams.length) {
    return !1;
  }
  var bodyValue = smsUrl.match(/[?&]body=([^&]*)/)[1];
  if (!bodyValue) {
    return !0;
  }
  try {
    decodeURIComponent(bodyValue);
  } catch (error) {
    return !1;
  }
  return /^(?:[a-z0-9\-_.~]|%[0-9a-f]{2})+$/i.test(bodyValue);
};
goog.html.SafeUrl.fromSshUrl = function(sshUrl) {
  goog.string.internal.caseInsensitiveStartsWith(sshUrl, "ssh://") || (sshUrl = goog.html.SafeUrl.INNOCUOUS_STRING);
  return goog.html.SafeUrl.createSafeUrlSecurityPrivateDoNotAccessOrElse(sshUrl);
};
goog.html.SafeUrl.sanitizeChromeExtensionUrl = function(url, extensionId) {
  return goog.html.SafeUrl.sanitizeExtensionUrl_(/^chrome-extension:\/\/([^\/]+)\//, url, extensionId);
};
goog.html.SafeUrl.sanitizeFirefoxExtensionUrl = function(url, extensionId) {
  return goog.html.SafeUrl.sanitizeExtensionUrl_(/^moz-extension:\/\/([^\/]+)\//, url, extensionId);
};
goog.html.SafeUrl.sanitizeEdgeExtensionUrl = function(url, extensionId) {
  return goog.html.SafeUrl.sanitizeExtensionUrl_(/^ms-browser-extension:\/\/([^\/]+)\//, url, extensionId);
};
goog.html.SafeUrl.sanitizeExtensionUrl_ = function(scheme, url, extensionId) {
  var matches = scheme.exec(url);
  if (matches) {
    var extractedExtensionId = matches[1];
    -1 == (extensionId instanceof goog.string.Const ? [goog.string.Const.unwrap(extensionId)] : extensionId.map(function unwrap(x) {
      return goog.string.Const.unwrap(x);
    })).indexOf(extractedExtensionId) && (url = goog.html.SafeUrl.INNOCUOUS_STRING);
  } else {
    url = goog.html.SafeUrl.INNOCUOUS_STRING;
  }
  return goog.html.SafeUrl.createSafeUrlSecurityPrivateDoNotAccessOrElse(url);
};
goog.html.SafeUrl.fromTrustedResourceUrl = function(trustedResourceUrl) {
  return goog.html.SafeUrl.createSafeUrlSecurityPrivateDoNotAccessOrElse(goog.html.TrustedResourceUrl.unwrap(trustedResourceUrl));
};
goog.html.SAFE_URL_PATTERN_ = /^(?:(?:https?|mailto|ftp):|[^:/?#]*(?:[/?#]|$))/i;
goog.html.SafeUrl.SAFE_URL_PATTERN = goog.html.SAFE_URL_PATTERN_;
goog.html.SafeUrl.sanitize = function(url) {
  if (url instanceof goog.html.SafeUrl) {
    return url;
  }
  url = "object" == typeof url && url.implementsGoogStringTypedString ? url.getTypedStringValue() : String(url);
  goog.html.SAFE_URL_PATTERN_.test(url) || (url = goog.html.SafeUrl.INNOCUOUS_STRING);
  return goog.html.SafeUrl.createSafeUrlSecurityPrivateDoNotAccessOrElse(url);
};
goog.html.SafeUrl.sanitizeAssertUnchanged = function(url, opt_allowDataUrl) {
  if (url instanceof goog.html.SafeUrl) {
    return url;
  }
  url = "object" == typeof url && url.implementsGoogStringTypedString ? url.getTypedStringValue() : String(url);
  if (opt_allowDataUrl && /^data:/i.test(url)) {
    var safeUrl = goog.html.SafeUrl.fromDataUrl(url);
    if (safeUrl.getTypedStringValue() == url) {
      return safeUrl;
    }
  }
  goog.asserts.assert(goog.html.SAFE_URL_PATTERN_.test(url), "%s does not match the safe URL pattern", url) || (url = goog.html.SafeUrl.INNOCUOUS_STRING);
  return goog.html.SafeUrl.createSafeUrlSecurityPrivateDoNotAccessOrElse(url);
};
goog.html.SafeUrl.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_ = {};
goog.html.SafeUrl.createSafeUrlSecurityPrivateDoNotAccessOrElse = function(url) {
  return new goog.html.SafeUrl(goog.html.SafeUrl.CONSTRUCTOR_TOKEN_PRIVATE_, url);
};
goog.html.SafeUrl.ABOUT_BLANK = goog.html.SafeUrl.createSafeUrlSecurityPrivateDoNotAccessOrElse("about:blank");
goog.html.SafeUrl.CONSTRUCTOR_TOKEN_PRIVATE_ = {};
goog.html.SafeStyle = function() {
  this.privateDoNotAccessOrElseSafeStyleWrappedValue_ = "";
  this.SAFE_STYLE_TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_ = goog.html.SafeStyle.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_;
};
goog.html.SafeStyle.prototype.implementsGoogStringTypedString = !0;
goog.html.SafeStyle.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_ = {};
goog.html.SafeStyle.fromConstant = function(style) {
  var styleString = goog.string.Const.unwrap(style);
  if (0 === styleString.length) {
    return goog.html.SafeStyle.EMPTY;
  }
  goog.asserts.assert(goog.string.internal.endsWith(styleString, ";"), "Last character of style string is not ';': " + styleString);
  goog.asserts.assert(goog.string.internal.contains(styleString, ":"), "Style string must contain at least one ':', to specify a \"name: value\" pair: " + styleString);
  return goog.html.SafeStyle.createSafeStyleSecurityPrivateDoNotAccessOrElse(styleString);
};
goog.html.SafeStyle.prototype.getTypedStringValue = function() {
  return this.privateDoNotAccessOrElseSafeStyleWrappedValue_;
};
goog.DEBUG && (goog.html.SafeStyle.prototype.toString = function() {
  return "SafeStyle{" + this.privateDoNotAccessOrElseSafeStyleWrappedValue_ + "}";
});
goog.html.SafeStyle.unwrap = function(safeStyle) {
  if (safeStyle instanceof goog.html.SafeStyle && safeStyle.constructor === goog.html.SafeStyle && safeStyle.SAFE_STYLE_TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_ === goog.html.SafeStyle.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_) {
    return safeStyle.privateDoNotAccessOrElseSafeStyleWrappedValue_;
  }
  goog.asserts.fail("expected object of type SafeStyle, got '" + safeStyle + "' of type " + goog.typeOf(safeStyle));
  return "type_error:SafeStyle";
};
goog.html.SafeStyle.createSafeStyleSecurityPrivateDoNotAccessOrElse = function(style) {
  return (new goog.html.SafeStyle).initSecurityPrivateDoNotAccessOrElse_(style);
};
goog.html.SafeStyle.prototype.initSecurityPrivateDoNotAccessOrElse_ = function(style) {
  this.privateDoNotAccessOrElseSafeStyleWrappedValue_ = style;
  return this;
};
goog.html.SafeStyle.EMPTY = goog.html.SafeStyle.createSafeStyleSecurityPrivateDoNotAccessOrElse("");
goog.html.SafeStyle.INNOCUOUS_STRING = "zClosurez";
goog.html.SafeStyle.create = function(map) {
  var style = "", name;
  for (name in map) {
    if (!/^[-_a-zA-Z0-9]+$/.test(name)) {
      throw Error("Name allows only [-_a-zA-Z0-9], got: " + name);
    }
    var value = map[name];
    null != value && (value = Array.isArray(value) ? goog.array.map(value, goog.html.SafeStyle.sanitizePropertyValue_).join(" ") : goog.html.SafeStyle.sanitizePropertyValue_(value), style += name + ":" + value + ";");
  }
  return style ? goog.html.SafeStyle.createSafeStyleSecurityPrivateDoNotAccessOrElse(style) : goog.html.SafeStyle.EMPTY;
};
goog.html.SafeStyle.sanitizePropertyValue_ = function(value) {
  if (value instanceof goog.html.SafeUrl) {
    return 'url("' + goog.html.SafeUrl.unwrap(value).replace(/</g, "%3c").replace(/[\\"]/g, "\\$&") + '")';
  }
  var result = value instanceof goog.string.Const ? goog.string.Const.unwrap(value) : goog.html.SafeStyle.sanitizePropertyValueString_(String(value));
  if (/[{;}]/.test(result)) {
    throw new goog.asserts.AssertionError("Value does not allow [{;}], got: %s.", [result]);
  }
  return result;
};
goog.html.SafeStyle.sanitizePropertyValueString_ = function(value) {
  var valueWithoutFunctions = value.replace(goog.html.SafeStyle.FUNCTIONS_RE_, "$1").replace(goog.html.SafeStyle.FUNCTIONS_RE_, "$1").replace(goog.html.SafeStyle.URL_RE_, "url");
  if (goog.html.SafeStyle.VALUE_RE_.test(valueWithoutFunctions)) {
    if (goog.html.SafeStyle.COMMENT_RE_.test(value)) {
      return goog.asserts.fail("String value disallows comments, got: " + value), goog.html.SafeStyle.INNOCUOUS_STRING;
    }
    if (!goog.html.SafeStyle.hasBalancedQuotes_(value)) {
      return goog.asserts.fail("String value requires balanced quotes, got: " + value), goog.html.SafeStyle.INNOCUOUS_STRING;
    }
    if (!goog.html.SafeStyle.hasBalancedSquareBrackets_(value)) {
      return goog.asserts.fail("String value requires balanced square brackets and one identifier per pair of brackets, got: " + value), goog.html.SafeStyle.INNOCUOUS_STRING;
    }
  } else {
    return goog.asserts.fail("String value allows only " + goog.html.SafeStyle.VALUE_ALLOWED_CHARS_ + " and simple functions, got: " + value), goog.html.SafeStyle.INNOCUOUS_STRING;
  }
  return goog.html.SafeStyle.sanitizeUrl_(value);
};
goog.html.SafeStyle.hasBalancedQuotes_ = function(value) {
  for (var outsideSingle = !0, outsideDouble = !0, i = 0; i < value.length; i++) {
    var c = value.charAt(i);
    "'" == c && outsideDouble ? outsideSingle = !outsideSingle : '"' == c && outsideSingle && (outsideDouble = !outsideDouble);
  }
  return outsideSingle && outsideDouble;
};
goog.html.SafeStyle.hasBalancedSquareBrackets_ = function(value) {
  for (var outside = !0, tokenRe = /^[-_a-zA-Z0-9]$/, i = 0; i < value.length; i++) {
    var c = value.charAt(i);
    if ("]" == c) {
      if (outside) {
        return !1;
      }
      outside = !0;
    } else {
      if ("[" == c) {
        if (!outside) {
          return !1;
        }
        outside = !1;
      } else {
        if (!outside && !tokenRe.test(c)) {
          return !1;
        }
      }
    }
  }
  return outside;
};
goog.html.SafeStyle.VALUE_ALLOWED_CHARS_ = "[-,.\"'%_!# a-zA-Z0-9\\[\\]]";
goog.html.SafeStyle.VALUE_RE_ = new RegExp("^" + goog.html.SafeStyle.VALUE_ALLOWED_CHARS_ + "+$");
goog.html.SafeStyle.URL_RE_ = /\b(url\([ \t\n]*)('[ -&(-\[\]-~]*'|"[ !#-\[\]-~]*"|[!#-&*-\[\]-~]*)([ \t\n]*\))/g;
goog.html.SafeStyle.ALLOWED_FUNCTIONS_ = "calc cubic-bezier fit-content hsl hsla linear-gradient matrix minmax repeat rgb rgba (rotate|scale|translate)(X|Y|Z|3d)?".split(" ");
goog.html.SafeStyle.FUNCTIONS_RE_ = new RegExp("\\b(" + goog.html.SafeStyle.ALLOWED_FUNCTIONS_.join("|") + ")\\([-+*/0-9a-z.%\\[\\], ]+\\)", "g");
goog.html.SafeStyle.COMMENT_RE_ = /\/\*/;
goog.html.SafeStyle.sanitizeUrl_ = function(value) {
  return value.replace(goog.html.SafeStyle.URL_RE_, function(match$jscomp$0, before, url, after) {
    var quote = "";
    url = url.replace(/^(['"])(.*)\1$/, function(match, start, inside) {
      quote = start;
      return inside;
    });
    var sanitized = goog.html.SafeUrl.sanitize(url).getTypedStringValue();
    return before + quote + sanitized + quote + after;
  });
};
goog.html.SafeStyle.concat = function(var_args) {
  var style = "", addArgument = function(argument) {
    Array.isArray(argument) ? goog.array.forEach(argument, addArgument) : style += goog.html.SafeStyle.unwrap(argument);
  };
  goog.array.forEach(arguments, addArgument);
  return style ? goog.html.SafeStyle.createSafeStyleSecurityPrivateDoNotAccessOrElse(style) : goog.html.SafeStyle.EMPTY;
};
goog.html.SafeStyleSheet = function() {
  this.privateDoNotAccessOrElseSafeStyleSheetWrappedValue_ = "";
  this.SAFE_STYLE_SHEET_TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_ = goog.html.SafeStyleSheet.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_;
};
goog.html.SafeStyleSheet.prototype.implementsGoogStringTypedString = !0;
goog.html.SafeStyleSheet.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_ = {};
goog.html.SafeStyleSheet.createRule = function(selector, style) {
  if (goog.string.internal.contains(selector, "<")) {
    throw Error("Selector does not allow '<', got: " + selector);
  }
  var selectorToCheck = selector.replace(/('|")((?!\1)[^\r\n\f\\]|\\[\s\S])*\1/g, "");
  if (!/^[-_a-zA-Z0-9#.:* ,>+~[\]()=^$|]+$/.test(selectorToCheck)) {
    throw Error("Selector allows only [-_a-zA-Z0-9#.:* ,>+~[\\]()=^$|] and strings, got: " + selector);
  }
  if (!goog.html.SafeStyleSheet.hasBalancedBrackets_(selectorToCheck)) {
    throw Error("() and [] in selector must be balanced, got: " + selector);
  }
  style instanceof goog.html.SafeStyle || (style = goog.html.SafeStyle.create(style));
  var styleSheet = selector + "{" + goog.html.SafeStyle.unwrap(style).replace(/</g, "\\3C ") + "}";
  return goog.html.SafeStyleSheet.createSafeStyleSheetSecurityPrivateDoNotAccessOrElse(styleSheet);
};
goog.html.SafeStyleSheet.hasBalancedBrackets_ = function(s) {
  for (var brackets = {"(":")", "[":"]"}, expectedBrackets = [], i = 0; i < s.length; i++) {
    var ch = s[i];
    if (brackets[ch]) {
      expectedBrackets.push(brackets[ch]);
    } else {
      if (goog.object.contains(brackets, ch) && expectedBrackets.pop() != ch) {
        return !1;
      }
    }
  }
  return 0 == expectedBrackets.length;
};
goog.html.SafeStyleSheet.concat = function(var_args) {
  var result = "", addArgument = function(argument) {
    Array.isArray(argument) ? goog.array.forEach(argument, addArgument) : result += goog.html.SafeStyleSheet.unwrap(argument);
  };
  goog.array.forEach(arguments, addArgument);
  return goog.html.SafeStyleSheet.createSafeStyleSheetSecurityPrivateDoNotAccessOrElse(result);
};
goog.html.SafeStyleSheet.fromConstant = function(styleSheet) {
  var styleSheetString = goog.string.Const.unwrap(styleSheet);
  if (0 === styleSheetString.length) {
    return goog.html.SafeStyleSheet.EMPTY;
  }
  goog.asserts.assert(!goog.string.internal.contains(styleSheetString, "<"), "Forbidden '<' character in style sheet string: " + styleSheetString);
  return goog.html.SafeStyleSheet.createSafeStyleSheetSecurityPrivateDoNotAccessOrElse(styleSheetString);
};
goog.html.SafeStyleSheet.prototype.getTypedStringValue = function() {
  return this.privateDoNotAccessOrElseSafeStyleSheetWrappedValue_;
};
goog.DEBUG && (goog.html.SafeStyleSheet.prototype.toString = function() {
  return "SafeStyleSheet{" + this.privateDoNotAccessOrElseSafeStyleSheetWrappedValue_ + "}";
});
goog.html.SafeStyleSheet.unwrap = function(safeStyleSheet) {
  if (safeStyleSheet instanceof goog.html.SafeStyleSheet && safeStyleSheet.constructor === goog.html.SafeStyleSheet && safeStyleSheet.SAFE_STYLE_SHEET_TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_ === goog.html.SafeStyleSheet.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_) {
    return safeStyleSheet.privateDoNotAccessOrElseSafeStyleSheetWrappedValue_;
  }
  goog.asserts.fail("expected object of type SafeStyleSheet, got '" + safeStyleSheet + "' of type " + goog.typeOf(safeStyleSheet));
  return "type_error:SafeStyleSheet";
};
goog.html.SafeStyleSheet.createSafeStyleSheetSecurityPrivateDoNotAccessOrElse = function(styleSheet) {
  return (new goog.html.SafeStyleSheet).initSecurityPrivateDoNotAccessOrElse_(styleSheet);
};
goog.html.SafeStyleSheet.prototype.initSecurityPrivateDoNotAccessOrElse_ = function(styleSheet) {
  this.privateDoNotAccessOrElseSafeStyleSheetWrappedValue_ = styleSheet;
  return this;
};
goog.html.SafeStyleSheet.EMPTY = goog.html.SafeStyleSheet.createSafeStyleSheetSecurityPrivateDoNotAccessOrElse("");
goog.html.SafeHtml = function() {
  this.privateDoNotAccessOrElseSafeHtmlWrappedValue_ = "";
  this.SAFE_HTML_TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_ = goog.html.SafeHtml.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_;
  this.dir_ = null;
};
goog.html.SafeHtml.ENABLE_ERROR_MESSAGES = goog.DEBUG;
goog.html.SafeHtml.SUPPORT_STYLE_ATTRIBUTE = !0;
goog.html.SafeHtml.prototype.implementsGoogI18nBidiDirectionalString = !0;
goog.html.SafeHtml.prototype.getDirection = function() {
  return this.dir_;
};
goog.html.SafeHtml.prototype.implementsGoogStringTypedString = !0;
goog.html.SafeHtml.prototype.getTypedStringValue = function() {
  return this.privateDoNotAccessOrElseSafeHtmlWrappedValue_.toString();
};
goog.DEBUG && (goog.html.SafeHtml.prototype.toString = function() {
  return "SafeHtml{" + this.privateDoNotAccessOrElseSafeHtmlWrappedValue_ + "}";
});
goog.html.SafeHtml.unwrap = function(safeHtml) {
  return goog.html.SafeHtml.unwrapTrustedHTML(safeHtml).toString();
};
goog.html.SafeHtml.unwrapTrustedHTML = function(safeHtml) {
  if (safeHtml instanceof goog.html.SafeHtml && safeHtml.constructor === goog.html.SafeHtml && safeHtml.SAFE_HTML_TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_ === goog.html.SafeHtml.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_) {
    return safeHtml.privateDoNotAccessOrElseSafeHtmlWrappedValue_;
  }
  goog.asserts.fail("expected object of type SafeHtml, got '" + safeHtml + "' of type " + goog.typeOf(safeHtml));
  return "type_error:SafeHtml";
};
goog.html.SafeHtml.htmlEscape = function(textOrHtml) {
  if (textOrHtml instanceof goog.html.SafeHtml) {
    return textOrHtml;
  }
  var textIsObject = "object" == typeof textOrHtml, dir = null;
  textIsObject && textOrHtml.implementsGoogI18nBidiDirectionalString && (dir = textOrHtml.getDirection());
  return goog.html.SafeHtml.createSafeHtmlSecurityPrivateDoNotAccessOrElse(goog.string.internal.htmlEscape(textIsObject && textOrHtml.implementsGoogStringTypedString ? textOrHtml.getTypedStringValue() : String(textOrHtml)), dir);
};
goog.html.SafeHtml.htmlEscapePreservingNewlines = function(textOrHtml) {
  if (textOrHtml instanceof goog.html.SafeHtml) {
    return textOrHtml;
  }
  var html = goog.html.SafeHtml.htmlEscape(textOrHtml);
  return goog.html.SafeHtml.createSafeHtmlSecurityPrivateDoNotAccessOrElse(goog.string.internal.newLineToBr(goog.html.SafeHtml.unwrap(html)), html.getDirection());
};
goog.html.SafeHtml.htmlEscapePreservingNewlinesAndSpaces = function(textOrHtml) {
  if (textOrHtml instanceof goog.html.SafeHtml) {
    return textOrHtml;
  }
  var html = goog.html.SafeHtml.htmlEscape(textOrHtml);
  return goog.html.SafeHtml.createSafeHtmlSecurityPrivateDoNotAccessOrElse(goog.string.internal.whitespaceEscape(goog.html.SafeHtml.unwrap(html)), html.getDirection());
};
goog.html.SafeHtml.from = goog.html.SafeHtml.htmlEscape;
goog.html.SafeHtml.comment = function(text) {
  return goog.html.SafeHtml.createSafeHtmlSecurityPrivateDoNotAccessOrElse("\x3c!--" + goog.string.internal.htmlEscape(text) + "--\x3e", null);
};
goog.html.SafeHtml.VALID_NAMES_IN_TAG_ = /^[a-zA-Z0-9-]+$/;
goog.html.SafeHtml.URL_ATTRIBUTES_ = {action:!0, cite:!0, data:!0, formaction:!0, href:!0, manifest:!0, poster:!0, src:!0};
goog.html.SafeHtml.NOT_ALLOWED_TAG_NAMES_ = {APPLET:!0, BASE:!0, EMBED:!0, IFRAME:!0, LINK:!0, MATH:!0, META:!0, OBJECT:!0, SCRIPT:!0, STYLE:!0, SVG:!0, TEMPLATE:!0};
goog.html.SafeHtml.create = function(tagName, opt_attributes, opt_content) {
  goog.html.SafeHtml.verifyTagName(String(tagName));
  return goog.html.SafeHtml.createSafeHtmlTagSecurityPrivateDoNotAccessOrElse(String(tagName), opt_attributes, opt_content);
};
goog.html.SafeHtml.verifyTagName = function(tagName) {
  if (!goog.html.SafeHtml.VALID_NAMES_IN_TAG_.test(tagName)) {
    throw Error(goog.html.SafeHtml.ENABLE_ERROR_MESSAGES ? "Invalid tag name <" + tagName + ">." : "");
  }
  if (tagName.toUpperCase() in goog.html.SafeHtml.NOT_ALLOWED_TAG_NAMES_) {
    throw Error(goog.html.SafeHtml.ENABLE_ERROR_MESSAGES ? "Tag name <" + tagName + "> is not allowed for SafeHtml." : "");
  }
};
goog.html.SafeHtml.createIframe = function(opt_src, opt_srcdoc, opt_attributes, opt_content) {
  opt_src && goog.html.TrustedResourceUrl.unwrap(opt_src);
  var fixedAttributes = {};
  fixedAttributes.src = opt_src || null;
  fixedAttributes.srcdoc = opt_srcdoc && goog.html.SafeHtml.unwrap(opt_srcdoc);
  var attributes = goog.html.SafeHtml.combineAttributes(fixedAttributes, {sandbox:""}, opt_attributes);
  return goog.html.SafeHtml.createSafeHtmlTagSecurityPrivateDoNotAccessOrElse("iframe", attributes, opt_content);
};
goog.html.SafeHtml.createSandboxIframe = function(opt_src, opt_srcdoc, opt_attributes, opt_content) {
  if (!goog.html.SafeHtml.canUseSandboxIframe()) {
    throw Error(goog.html.SafeHtml.ENABLE_ERROR_MESSAGES ? "The browser does not support sandboxed iframes." : "");
  }
  var fixedAttributes = {};
  fixedAttributes.src = opt_src ? goog.html.SafeUrl.unwrap(goog.html.SafeUrl.sanitize(opt_src)) : null;
  fixedAttributes.srcdoc = opt_srcdoc || null;
  fixedAttributes.sandbox = "";
  var attributes = goog.html.SafeHtml.combineAttributes(fixedAttributes, {}, opt_attributes);
  return goog.html.SafeHtml.createSafeHtmlTagSecurityPrivateDoNotAccessOrElse("iframe", attributes, opt_content);
};
goog.html.SafeHtml.canUseSandboxIframe = function() {
  return goog.global.HTMLIFrameElement && "sandbox" in goog.global.HTMLIFrameElement.prototype;
};
goog.html.SafeHtml.createScriptSrc = function(src, opt_attributes) {
  goog.html.TrustedResourceUrl.unwrap(src);
  var attributes = goog.html.SafeHtml.combineAttributes({src:src}, {}, opt_attributes);
  return goog.html.SafeHtml.createSafeHtmlTagSecurityPrivateDoNotAccessOrElse("script", attributes);
};
goog.html.SafeHtml.createScript = function(script, opt_attributes) {
  for (var attr in opt_attributes) {
    var attrLower = attr.toLowerCase();
    if ("language" == attrLower || "src" == attrLower || "text" == attrLower || "type" == attrLower) {
      throw Error(goog.html.SafeHtml.ENABLE_ERROR_MESSAGES ? 'Cannot set "' + attrLower + '" attribute' : "");
    }
  }
  var content = "";
  script = goog.array.concat(script);
  for (var i = 0; i < script.length; i++) {
    content += goog.html.SafeScript.unwrap(script[i]);
  }
  var htmlContent = goog.html.SafeHtml.createSafeHtmlSecurityPrivateDoNotAccessOrElse(content, goog.i18n.bidi.Dir.NEUTRAL);
  return goog.html.SafeHtml.createSafeHtmlTagSecurityPrivateDoNotAccessOrElse("script", opt_attributes, htmlContent);
};
goog.html.SafeHtml.createStyle = function(styleSheet, opt_attributes) {
  var attributes = goog.html.SafeHtml.combineAttributes({type:"text/css"}, {}, opt_attributes), content = "";
  styleSheet = goog.array.concat(styleSheet);
  for (var i = 0; i < styleSheet.length; i++) {
    content += goog.html.SafeStyleSheet.unwrap(styleSheet[i]);
  }
  var htmlContent = goog.html.SafeHtml.createSafeHtmlSecurityPrivateDoNotAccessOrElse(content, goog.i18n.bidi.Dir.NEUTRAL);
  return goog.html.SafeHtml.createSafeHtmlTagSecurityPrivateDoNotAccessOrElse("style", attributes, htmlContent);
};
goog.html.SafeHtml.createMetaRefresh = function(url, opt_secs) {
  var unwrappedUrl = goog.html.SafeUrl.unwrap(goog.html.SafeUrl.sanitize(url));
  (goog.labs.userAgent.browser.isIE() || goog.labs.userAgent.browser.isEdge()) && goog.string.internal.contains(unwrappedUrl, ";") && (unwrappedUrl = "'" + unwrappedUrl.replace(/'/g, "%27") + "'");
  return goog.html.SafeHtml.createSafeHtmlTagSecurityPrivateDoNotAccessOrElse("meta", {"http-equiv":"refresh", content:(opt_secs || 0) + "; url=" + unwrappedUrl});
};
goog.html.SafeHtml.getAttrNameAndValue_ = function(tagName, name, value) {
  if (value instanceof goog.string.Const) {
    value = goog.string.Const.unwrap(value);
  } else {
    if ("style" == name.toLowerCase()) {
      if (goog.html.SafeHtml.SUPPORT_STYLE_ATTRIBUTE) {
        value = goog.html.SafeHtml.getStyleValue_(value);
      } else {
        throw Error(goog.html.SafeHtml.ENABLE_ERROR_MESSAGES ? 'Attribute "style" not supported.' : "");
      }
    } else {
      if (/^on/i.test(name)) {
        throw Error(goog.html.SafeHtml.ENABLE_ERROR_MESSAGES ? 'Attribute "' + name + '" requires goog.string.Const value, "' + value + '" given.' : "");
      }
      if (name.toLowerCase() in goog.html.SafeHtml.URL_ATTRIBUTES_) {
        if (value instanceof goog.html.TrustedResourceUrl) {
          value = goog.html.TrustedResourceUrl.unwrap(value);
        } else {
          if (value instanceof goog.html.SafeUrl) {
            value = goog.html.SafeUrl.unwrap(value);
          } else {
            if ("string" === typeof value) {
              value = goog.html.SafeUrl.sanitize(value).getTypedStringValue();
            } else {
              throw Error(goog.html.SafeHtml.ENABLE_ERROR_MESSAGES ? 'Attribute "' + name + '" on tag "' + tagName + '" requires goog.html.SafeUrl, goog.string.Const, or string, value "' + value + '" given.' : "");
            }
          }
        }
      }
    }
  }
  value.implementsGoogStringTypedString && (value = value.getTypedStringValue());
  goog.asserts.assert("string" === typeof value || "number" === typeof value, "String or number value expected, got " + typeof value + " with value: " + value);
  return name + '="' + goog.string.internal.htmlEscape(String(value)) + '"';
};
goog.html.SafeHtml.getStyleValue_ = function(value) {
  if (!goog.isObject(value)) {
    throw Error(goog.html.SafeHtml.ENABLE_ERROR_MESSAGES ? 'The "style" attribute requires goog.html.SafeStyle or map of style properties, ' + typeof value + " given: " + value : "");
  }
  value instanceof goog.html.SafeStyle || (value = goog.html.SafeStyle.create(value));
  return goog.html.SafeStyle.unwrap(value);
};
goog.html.SafeHtml.createWithDir = function(dir, tagName, opt_attributes, opt_content) {
  var html = goog.html.SafeHtml.create(tagName, opt_attributes, opt_content);
  html.dir_ = dir;
  return html;
};
goog.html.SafeHtml.join = function(separator, parts) {
  var separatorHtml = goog.html.SafeHtml.htmlEscape(separator), dir = separatorHtml.getDirection(), content = [], addArgument = function(argument) {
    if (Array.isArray(argument)) {
      goog.array.forEach(argument, addArgument);
    } else {
      var html = goog.html.SafeHtml.htmlEscape(argument);
      content.push(goog.html.SafeHtml.unwrap(html));
      var htmlDir = html.getDirection();
      dir == goog.i18n.bidi.Dir.NEUTRAL ? dir = htmlDir : htmlDir != goog.i18n.bidi.Dir.NEUTRAL && dir != htmlDir && (dir = null);
    }
  };
  goog.array.forEach(parts, addArgument);
  return goog.html.SafeHtml.createSafeHtmlSecurityPrivateDoNotAccessOrElse(content.join(goog.html.SafeHtml.unwrap(separatorHtml)), dir);
};
goog.html.SafeHtml.concat = function(var_args) {
  return goog.html.SafeHtml.join(goog.html.SafeHtml.EMPTY, Array.prototype.slice.call(arguments));
};
goog.html.SafeHtml.concatWithDir = function(dir, var_args) {
  var html = goog.html.SafeHtml.concat(goog.array.slice(arguments, 1));
  html.dir_ = dir;
  return html;
};
goog.html.SafeHtml.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_ = {};
goog.html.SafeHtml.createSafeHtmlSecurityPrivateDoNotAccessOrElse = function(html, dir) {
  return (new goog.html.SafeHtml).initSecurityPrivateDoNotAccessOrElse_(html, dir);
};
goog.html.SafeHtml.createSafeHtmlFromTrustedHtmlSecurityPrivateDoNotAccessOrElse = function(trustedHtml) {
  return (new goog.html.SafeHtml).initSecurityFromTrustedHtmlPrivateDoNotAccessOrElse_(trustedHtml, goog.i18n.bidi.Dir.NEUTRAL);
};
goog.html.SafeHtml.prototype.initSecurityPrivateDoNotAccessOrElse_ = function(html, dir) {
  var policy = goog.html.trustedtypes.getPolicyPrivateDoNotAccessOrElse();
  this.privateDoNotAccessOrElseSafeHtmlWrappedValue_ = policy ? policy.createHTML(html) : html;
  this.dir_ = dir;
  return this;
};
goog.html.SafeHtml.prototype.initSecurityFromTrustedHtmlPrivateDoNotAccessOrElse_ = function(trustedHtml, dir) {
  this.privateDoNotAccessOrElseSafeHtmlWrappedValue_ = trustedHtml;
  this.dir_ = dir;
  return this;
};
goog.html.SafeHtml.createSafeHtmlTagSecurityPrivateDoNotAccessOrElse = function(tagName, opt_attributes, opt_content) {
  var dir = null;
  var result = "<" + tagName + goog.html.SafeHtml.stringifyAttributes(tagName, opt_attributes);
  var content = opt_content;
  null == content ? content = [] : Array.isArray(content) || (content = [content]);
  if (goog.dom.tags.isVoidTag(tagName.toLowerCase())) {
    goog.asserts.assert(!content.length, "Void tag <" + tagName + "> does not allow content."), result += ">";
  } else {
    var html = goog.html.SafeHtml.concat(content);
    result += ">" + goog.html.SafeHtml.unwrap(html) + "</" + tagName + ">";
    dir = html.getDirection();
  }
  var dirAttribute = opt_attributes && opt_attributes.dir;
  dirAttribute && (dir = /^(ltr|rtl|auto)$/i.test(dirAttribute) ? goog.i18n.bidi.Dir.NEUTRAL : null);
  return goog.html.SafeHtml.createSafeHtmlSecurityPrivateDoNotAccessOrElse(result, dir);
};
goog.html.SafeHtml.stringifyAttributes = function(tagName, opt_attributes) {
  var result = "";
  if (opt_attributes) {
    for (var name in opt_attributes) {
      if (!goog.html.SafeHtml.VALID_NAMES_IN_TAG_.test(name)) {
        throw Error(goog.html.SafeHtml.ENABLE_ERROR_MESSAGES ? 'Invalid attribute name "' + name + '".' : "");
      }
      var value = opt_attributes[name];
      null != value && (result += " " + goog.html.SafeHtml.getAttrNameAndValue_(tagName, name, value));
    }
  }
  return result;
};
goog.html.SafeHtml.combineAttributes = function(fixedAttributes, defaultAttributes, opt_attributes) {
  var combinedAttributes = {}, name;
  for (name in fixedAttributes) {
    goog.asserts.assert(name.toLowerCase() == name, "Must be lower case"), combinedAttributes[name] = fixedAttributes[name];
  }
  for (name in defaultAttributes) {
    goog.asserts.assert(name.toLowerCase() == name, "Must be lower case"), combinedAttributes[name] = defaultAttributes[name];
  }
  if (opt_attributes) {
    for (name in opt_attributes) {
      var nameLower = name.toLowerCase();
      if (nameLower in fixedAttributes) {
        throw Error(goog.html.SafeHtml.ENABLE_ERROR_MESSAGES ? 'Cannot override "' + nameLower + '" attribute, got "' + name + '" with value "' + opt_attributes[name] + '"' : "");
      }
      nameLower in defaultAttributes && delete combinedAttributes[nameLower];
      combinedAttributes[name] = opt_attributes[name];
    }
  }
  return combinedAttributes;
};
goog.html.SafeHtml.DOCTYPE_HTML = function() {
  return goog.html.SafeHtml.createSafeHtmlSecurityPrivateDoNotAccessOrElse("<!DOCTYPE html>", goog.i18n.bidi.Dir.NEUTRAL);
}();
goog.html.SafeHtml.EMPTY = goog.html.SafeHtml.createSafeHtmlFromTrustedHtmlSecurityPrivateDoNotAccessOrElse(goog.global.trustedTypes && goog.global.trustedTypes.emptyHTML ? goog.global.trustedTypes.emptyHTML : "");
goog.html.SafeHtml.BR = function() {
  return goog.html.SafeHtml.createSafeHtmlSecurityPrivateDoNotAccessOrElse("<br>", goog.i18n.bidi.Dir.NEUTRAL);
}();
goog.html.uncheckedconversions = {};
goog.html.uncheckedconversions.safeHtmlFromStringKnownToSatisfyTypeContract = function(justification, html, opt_dir) {
  goog.asserts.assertString(goog.string.Const.unwrap(justification), "must provide justification");
  goog.asserts.assert(!goog.string.internal.isEmptyOrWhitespace(goog.string.Const.unwrap(justification)), "must provide non-empty justification");
  return goog.html.SafeHtml.createSafeHtmlSecurityPrivateDoNotAccessOrElse(html, opt_dir || null);
};
goog.html.uncheckedconversions.safeScriptFromStringKnownToSatisfyTypeContract = function(justification, script) {
  goog.asserts.assertString(goog.string.Const.unwrap(justification), "must provide justification");
  goog.asserts.assert(!goog.string.internal.isEmptyOrWhitespace(goog.string.Const.unwrap(justification)), "must provide non-empty justification");
  return goog.html.SafeScript.createSafeScriptSecurityPrivateDoNotAccessOrElse(script);
};
goog.html.uncheckedconversions.safeStyleFromStringKnownToSatisfyTypeContract = function(justification, style) {
  goog.asserts.assertString(goog.string.Const.unwrap(justification), "must provide justification");
  goog.asserts.assert(!goog.string.internal.isEmptyOrWhitespace(goog.string.Const.unwrap(justification)), "must provide non-empty justification");
  return goog.html.SafeStyle.createSafeStyleSecurityPrivateDoNotAccessOrElse(style);
};
goog.html.uncheckedconversions.safeStyleSheetFromStringKnownToSatisfyTypeContract = function(justification, styleSheet) {
  goog.asserts.assertString(goog.string.Const.unwrap(justification), "must provide justification");
  goog.asserts.assert(!goog.string.internal.isEmptyOrWhitespace(goog.string.Const.unwrap(justification)), "must provide non-empty justification");
  return goog.html.SafeStyleSheet.createSafeStyleSheetSecurityPrivateDoNotAccessOrElse(styleSheet);
};
goog.html.uncheckedconversions.safeUrlFromStringKnownToSatisfyTypeContract = function(justification, url) {
  goog.asserts.assertString(goog.string.Const.unwrap(justification), "must provide justification");
  goog.asserts.assert(!goog.string.internal.isEmptyOrWhitespace(goog.string.Const.unwrap(justification)), "must provide non-empty justification");
  return goog.html.SafeUrl.createSafeUrlSecurityPrivateDoNotAccessOrElse(url);
};
goog.html.uncheckedconversions.trustedResourceUrlFromStringKnownToSatisfyTypeContract = function(justification, url) {
  goog.asserts.assertString(goog.string.Const.unwrap(justification), "must provide justification");
  goog.asserts.assert(!goog.string.internal.isEmptyOrWhitespace(goog.string.Const.unwrap(justification)), "must provide non-empty justification");
  return goog.html.TrustedResourceUrl.createTrustedResourceUrlSecurityPrivateDoNotAccessOrElse(url);
};
goog.dom.safe = {};
goog.dom.safe.InsertAdjacentHtmlPosition = {AFTERBEGIN:"afterbegin", AFTEREND:"afterend", BEFOREBEGIN:"beforebegin", BEFOREEND:"beforeend"};
goog.dom.safe.insertAdjacentHtml = function(node, position, html) {
  node.insertAdjacentHTML(position, goog.html.SafeHtml.unwrapTrustedHTML(html));
};
goog.dom.safe.SET_INNER_HTML_DISALLOWED_TAGS_ = {MATH:!0, SCRIPT:!0, STYLE:!0, SVG:!0, TEMPLATE:!0};
goog.dom.safe.isInnerHtmlCleanupRecursive_ = goog.functions.cacheReturnValue(function() {
  if (goog.DEBUG && "undefined" === typeof document) {
    return !1;
  }
  var div = document.createElement("div"), childDiv = document.createElement("div");
  childDiv.appendChild(document.createElement("div"));
  div.appendChild(childDiv);
  if (goog.DEBUG && !div.firstChild) {
    return !1;
  }
  var innerChild = div.firstChild.firstChild;
  div.innerHTML = goog.html.SafeHtml.unwrapTrustedHTML(goog.html.SafeHtml.EMPTY);
  return !innerChild.parentElement;
});
goog.dom.safe.unsafeSetInnerHtmlDoNotUseOrElse = function(elem, html) {
  if (goog.dom.safe.isInnerHtmlCleanupRecursive_()) {
    for (; elem.lastChild;) {
      elem.removeChild(elem.lastChild);
    }
  }
  elem.innerHTML = goog.html.SafeHtml.unwrapTrustedHTML(html);
};
goog.dom.safe.setInnerHtml = function(elem, html) {
  if (goog.asserts.ENABLE_ASSERTS && goog.dom.safe.SET_INNER_HTML_DISALLOWED_TAGS_[elem.tagName.toUpperCase()]) {
    throw Error("goog.dom.safe.setInnerHtml cannot be used to set content of " + elem.tagName + ".");
  }
  goog.dom.safe.unsafeSetInnerHtmlDoNotUseOrElse(elem, html);
};
goog.dom.safe.setInnerHtmlFromConstant = function(element, constHtml) {
  goog.dom.safe.setInnerHtml(element, goog.html.uncheckedconversions.safeHtmlFromStringKnownToSatisfyTypeContract(goog.string.Const.from("Constant HTML to be immediatelly used."), goog.string.Const.unwrap(constHtml)));
};
goog.dom.safe.setOuterHtml = function(elem, html) {
  elem.outerHTML = goog.html.SafeHtml.unwrapTrustedHTML(html);
};
goog.dom.safe.setFormElementAction = function(form, url) {
  var safeUrl = url instanceof goog.html.SafeUrl ? url : goog.html.SafeUrl.sanitizeAssertUnchanged(url);
  goog.dom.asserts.assertIsHTMLFormElement(form).action = goog.html.SafeUrl.unwrap(safeUrl);
};
goog.dom.safe.setButtonFormAction = function(button, url) {
  var safeUrl = url instanceof goog.html.SafeUrl ? url : goog.html.SafeUrl.sanitizeAssertUnchanged(url);
  goog.dom.asserts.assertIsHTMLButtonElement(button).formAction = goog.html.SafeUrl.unwrap(safeUrl);
};
goog.dom.safe.setInputFormAction = function(input, url) {
  var safeUrl = url instanceof goog.html.SafeUrl ? url : goog.html.SafeUrl.sanitizeAssertUnchanged(url);
  goog.dom.asserts.assertIsHTMLInputElement(input).formAction = goog.html.SafeUrl.unwrap(safeUrl);
};
goog.dom.safe.setStyle = function(elem, style) {
  elem.style.cssText = goog.html.SafeStyle.unwrap(style);
};
goog.dom.safe.documentWrite = function(doc, html) {
  doc.write(goog.html.SafeHtml.unwrapTrustedHTML(html));
};
goog.dom.safe.setAnchorHref = function(anchor, url) {
  goog.dom.asserts.assertIsHTMLAnchorElement(anchor);
  var safeUrl = url instanceof goog.html.SafeUrl ? url : goog.html.SafeUrl.sanitizeAssertUnchanged(url);
  anchor.href = goog.html.SafeUrl.unwrap(safeUrl);
};
goog.dom.safe.setImageSrc = function(imageElement, url) {
  goog.dom.asserts.assertIsHTMLImageElement(imageElement);
  var safeUrl = url instanceof goog.html.SafeUrl ? url : goog.html.SafeUrl.sanitizeAssertUnchanged(url, /^data:image\//i.test(url));
  imageElement.src = goog.html.SafeUrl.unwrap(safeUrl);
};
goog.dom.safe.setAudioSrc = function(audioElement, url) {
  goog.dom.asserts.assertIsHTMLAudioElement(audioElement);
  var safeUrl = url instanceof goog.html.SafeUrl ? url : goog.html.SafeUrl.sanitizeAssertUnchanged(url, /^data:audio\//i.test(url));
  audioElement.src = goog.html.SafeUrl.unwrap(safeUrl);
};
goog.dom.safe.setVideoSrc = function(videoElement, url) {
  goog.dom.asserts.assertIsHTMLVideoElement(videoElement);
  var safeUrl = url instanceof goog.html.SafeUrl ? url : goog.html.SafeUrl.sanitizeAssertUnchanged(url, /^data:video\//i.test(url));
  videoElement.src = goog.html.SafeUrl.unwrap(safeUrl);
};
goog.dom.safe.setEmbedSrc = function(embed, url) {
  goog.dom.asserts.assertIsHTMLEmbedElement(embed);
  embed.src = goog.html.TrustedResourceUrl.unwrapTrustedScriptURL(url);
};
goog.dom.safe.setFrameSrc = function(frame, url) {
  goog.dom.asserts.assertIsHTMLFrameElement(frame);
  frame.src = goog.html.TrustedResourceUrl.unwrap(url);
};
goog.dom.safe.setIframeSrc = function(iframe, url) {
  goog.dom.asserts.assertIsHTMLIFrameElement(iframe);
  iframe.src = goog.html.TrustedResourceUrl.unwrap(url);
};
goog.dom.safe.setIframeSrcdoc = function(iframe, html) {
  goog.dom.asserts.assertIsHTMLIFrameElement(iframe);
  iframe.srcdoc = goog.html.SafeHtml.unwrapTrustedHTML(html);
};
goog.dom.safe.setLinkHrefAndRel = function(link, url, rel) {
  goog.dom.asserts.assertIsHTMLLinkElement(link);
  link.rel = rel;
  goog.string.internal.caseInsensitiveContains(rel, "stylesheet") ? (goog.asserts.assert(url instanceof goog.html.TrustedResourceUrl, 'URL must be TrustedResourceUrl because "rel" contains "stylesheet"'), link.href = goog.html.TrustedResourceUrl.unwrap(url)) : link.href = url instanceof goog.html.TrustedResourceUrl ? goog.html.TrustedResourceUrl.unwrap(url) : url instanceof goog.html.SafeUrl ? goog.html.SafeUrl.unwrap(url) : goog.html.SafeUrl.unwrap(goog.html.SafeUrl.sanitizeAssertUnchanged(url));
};
goog.dom.safe.setObjectData = function(object, url) {
  goog.dom.asserts.assertIsHTMLObjectElement(object);
  object.data = goog.html.TrustedResourceUrl.unwrapTrustedScriptURL(url);
};
goog.dom.safe.setScriptSrc = function(script, url) {
  goog.dom.asserts.assertIsHTMLScriptElement(script);
  script.src = goog.html.TrustedResourceUrl.unwrapTrustedScriptURL(url);
  goog.dom.safe.setNonceForScriptElement_(script);
};
goog.dom.safe.setScriptContent = function(script, content) {
  goog.dom.asserts.assertIsHTMLScriptElement(script);
  script.textContent = goog.html.SafeScript.unwrapTrustedScript(content);
  goog.dom.safe.setNonceForScriptElement_(script);
};
goog.dom.safe.setNonceForScriptElement_ = function(script) {
  var nonce = goog.getScriptNonce(script.ownerDocument && script.ownerDocument.defaultView);
  nonce && script.setAttribute("nonce", nonce);
};
goog.dom.safe.setLocationHref = function(loc, url) {
  goog.dom.asserts.assertIsLocation(loc);
  var safeUrl = url instanceof goog.html.SafeUrl ? url : goog.html.SafeUrl.sanitizeAssertUnchanged(url);
  loc.href = goog.html.SafeUrl.unwrap(safeUrl);
};
goog.dom.safe.assignLocation = function(loc, url) {
  goog.dom.asserts.assertIsLocation(loc);
  var safeUrl = url instanceof goog.html.SafeUrl ? url : goog.html.SafeUrl.sanitizeAssertUnchanged(url);
  loc.assign(goog.html.SafeUrl.unwrap(safeUrl));
};
goog.dom.safe.replaceLocation = function(loc, url) {
  var safeUrl = url instanceof goog.html.SafeUrl ? url : goog.html.SafeUrl.sanitizeAssertUnchanged(url);
  loc.replace(goog.html.SafeUrl.unwrap(safeUrl));
};
goog.dom.safe.openInWindow = function(url, opt_openerWin, opt_name, opt_specs, opt_replace) {
  var safeUrl = url instanceof goog.html.SafeUrl ? url : goog.html.SafeUrl.sanitizeAssertUnchanged(url);
  var win = opt_openerWin || goog.global, name = opt_name instanceof goog.string.Const ? goog.string.Const.unwrap(opt_name) : opt_name || "";
  return win.open(goog.html.SafeUrl.unwrap(safeUrl), name, opt_specs, opt_replace);
};
goog.dom.safe.parseFromStringHtml = function(parser, html) {
  return goog.dom.safe.parseFromString(parser, html, "text/html");
};
goog.dom.safe.parseFromString = function(parser, content, type) {
  return parser.parseFromString(goog.html.SafeHtml.unwrapTrustedHTML(content), type);
};
goog.dom.safe.createImageFromBlob = function(blob) {
  if (!/^image\/.*/g.test(blob.type)) {
    throw Error("goog.dom.safe.createImageFromBlob only accepts MIME type image/.*.");
  }
  var objectUrl = goog.global.URL.createObjectURL(blob), image = new goog.global.Image;
  image.onload = function() {
    goog.global.URL.revokeObjectURL(objectUrl);
  };
  goog.dom.safe.setImageSrc(image, goog.html.uncheckedconversions.safeUrlFromStringKnownToSatisfyTypeContract(goog.string.Const.from("Image blob URL."), objectUrl));
  return image;
};
goog.string.DETECT_DOUBLE_ESCAPING = !1;
goog.string.FORCE_NON_DOM_HTML_UNESCAPING = !1;
goog.string.Unicode = {NBSP:"\u00a0"};
goog.string.startsWith = goog.string.internal.startsWith;
goog.string.endsWith = goog.string.internal.endsWith;
goog.string.caseInsensitiveStartsWith = goog.string.internal.caseInsensitiveStartsWith;
goog.string.caseInsensitiveEndsWith = goog.string.internal.caseInsensitiveEndsWith;
goog.string.caseInsensitiveEquals = goog.string.internal.caseInsensitiveEquals;
goog.string.subs = function(str, var_args) {
  for (var splitParts = str.split("%s"), returnString = "", subsArguments = Array.prototype.slice.call(arguments, 1); subsArguments.length && 1 < splitParts.length;) {
    returnString += splitParts.shift() + subsArguments.shift();
  }
  return returnString + splitParts.join("%s");
};
goog.string.collapseWhitespace = function(str) {
  return str.replace(/[\s\xa0]+/g, " ").replace(/^\s+|\s+$/g, "");
};
goog.string.isEmptyOrWhitespace = goog.string.internal.isEmptyOrWhitespace;
goog.string.isEmptyString = function(str) {
  return 0 == str.length;
};
goog.string.isEmpty = goog.string.isEmptyOrWhitespace;
goog.string.isEmptyOrWhitespaceSafe = function(str) {
  return goog.string.isEmptyOrWhitespace(goog.string.makeSafe(str));
};
goog.string.isEmptySafe = goog.string.isEmptyOrWhitespaceSafe;
goog.string.isBreakingWhitespace = function(str) {
  return !/[^\t\n\r ]/.test(str);
};
goog.string.isAlpha = function(str) {
  return !/[^a-zA-Z]/.test(str);
};
goog.string.isNumeric = function(str) {
  return !/[^0-9]/.test(str);
};
goog.string.isAlphaNumeric = function(str) {
  return !/[^a-zA-Z0-9]/.test(str);
};
goog.string.isSpace = function(ch) {
  return " " == ch;
};
goog.string.isUnicodeChar = function(ch) {
  return 1 == ch.length && " " <= ch && "~" >= ch || "\u0080" <= ch && "\ufffd" >= ch;
};
goog.string.stripNewlines = function(str) {
  return str.replace(/(\r\n|\r|\n)+/g, " ");
};
goog.string.canonicalizeNewlines = function(str) {
  return str.replace(/(\r\n|\r|\n)/g, "\n");
};
goog.string.normalizeWhitespace = function(str) {
  return str.replace(/\xa0|\s/g, " ");
};
goog.string.normalizeSpaces = function(str) {
  return str.replace(/\xa0|[ \t]+/g, " ");
};
goog.string.collapseBreakingSpaces = function(str) {
  return str.replace(/[\t\r\n ]+/g, " ").replace(/^[\t\r\n ]+|[\t\r\n ]+$/g, "");
};
goog.string.trim = goog.string.internal.trim;
goog.string.trimLeft = function(str) {
  return str.replace(/^[\s\xa0]+/, "");
};
goog.string.trimRight = function(str) {
  return str.replace(/[\s\xa0]+$/, "");
};
goog.string.caseInsensitiveCompare = goog.string.internal.caseInsensitiveCompare;
goog.string.numberAwareCompare_ = function(str1, str2, tokenizerRegExp) {
  if (str1 == str2) {
    return 0;
  }
  if (!str1) {
    return -1;
  }
  if (!str2) {
    return 1;
  }
  for (var tokens1 = str1.toLowerCase().match(tokenizerRegExp), tokens2 = str2.toLowerCase().match(tokenizerRegExp), count = Math.min(tokens1.length, tokens2.length), i = 0; i < count; i++) {
    var a = tokens1[i], b = tokens2[i];
    if (a != b) {
      var num1 = parseInt(a, 10);
      if (!isNaN(num1)) {
        var num2 = parseInt(b, 10);
        if (!isNaN(num2) && num1 - num2) {
          return num1 - num2;
        }
      }
      return a < b ? -1 : 1;
    }
  }
  return tokens1.length != tokens2.length ? tokens1.length - tokens2.length : str1 < str2 ? -1 : 1;
};
goog.string.intAwareCompare = function(str1, str2) {
  return goog.string.numberAwareCompare_(str1, str2, /\d+|\D+/g);
};
goog.string.floatAwareCompare = function(str1, str2) {
  return goog.string.numberAwareCompare_(str1, str2, /\d+|\.\d+|\D+/g);
};
goog.string.numerateCompare = goog.string.floatAwareCompare;
goog.string.urlEncode = function(str) {
  return encodeURIComponent(String(str));
};
goog.string.urlDecode = function(str) {
  return decodeURIComponent(str.replace(/\+/g, " "));
};
goog.string.newLineToBr = goog.string.internal.newLineToBr;
goog.string.htmlEscape = function(str, opt_isLikelyToContainHtmlChars) {
  str = goog.string.internal.htmlEscape(str, opt_isLikelyToContainHtmlChars);
  goog.string.DETECT_DOUBLE_ESCAPING && (str = str.replace(goog.string.E_RE_, "&#101;"));
  return str;
};
goog.string.E_RE_ = /e/g;
goog.string.unescapeEntities = function(str) {
  return goog.string.contains(str, "&") ? !goog.string.FORCE_NON_DOM_HTML_UNESCAPING && "document" in goog.global ? goog.string.unescapeEntitiesUsingDom_(str) : goog.string.unescapePureXmlEntities_(str) : str;
};
goog.string.unescapeEntitiesWithDocument = function(str, document) {
  return goog.string.contains(str, "&") ? goog.string.unescapeEntitiesUsingDom_(str, document) : str;
};
goog.string.unescapeEntitiesUsingDom_ = function(str, opt_document) {
  var seen = {"&amp;":"&", "&lt;":"<", "&gt;":">", "&quot;":'"'};
  var div = opt_document ? opt_document.createElement("div") : goog.global.document.createElement("div");
  return str.replace(goog.string.HTML_ENTITY_PATTERN_, function(s, entity) {
    var value = seen[s];
    if (value) {
      return value;
    }
    if ("#" == entity.charAt(0)) {
      var n = Number("0" + entity.substr(1));
      isNaN(n) || (value = String.fromCharCode(n));
    }
    value || (goog.dom.safe.setInnerHtml(div, goog.html.uncheckedconversions.safeHtmlFromStringKnownToSatisfyTypeContract(goog.string.Const.from("Single HTML entity."), s + " ")), value = div.firstChild.nodeValue.slice(0, -1));
    return seen[s] = value;
  });
};
goog.string.unescapePureXmlEntities_ = function(str) {
  return str.replace(/&([^;]+);/g, function(s, entity) {
    switch(entity) {
      case "amp":
        return "&";
      case "lt":
        return "<";
      case "gt":
        return ">";
      case "quot":
        return '"';
      default:
        if ("#" == entity.charAt(0)) {
          var n = Number("0" + entity.substr(1));
          if (!isNaN(n)) {
            return String.fromCharCode(n);
          }
        }
        return s;
    }
  });
};
goog.string.HTML_ENTITY_PATTERN_ = /&([^;\s<&]+);?/g;
goog.string.whitespaceEscape = function(str, opt_xml) {
  return goog.string.newLineToBr(str.replace(/  /g, " &#160;"), opt_xml);
};
goog.string.preserveSpaces = function(str) {
  return str.replace(/(^|[\n ]) /g, "$1" + goog.string.Unicode.NBSP);
};
goog.string.stripQuotes = function(str, quoteChars) {
  for (var length = quoteChars.length, i = 0; i < length; i++) {
    var quoteChar = 1 == length ? quoteChars : quoteChars.charAt(i);
    if (str.charAt(0) == quoteChar && str.charAt(str.length - 1) == quoteChar) {
      return str.substring(1, str.length - 1);
    }
  }
  return str;
};
goog.string.truncate = function(str, chars, opt_protectEscapedCharacters) {
  opt_protectEscapedCharacters && (str = goog.string.unescapeEntities(str));
  str.length > chars && (str = str.substring(0, chars - 3) + "...");
  opt_protectEscapedCharacters && (str = goog.string.htmlEscape(str));
  return str;
};
goog.string.truncateMiddle = function(str, chars, opt_protectEscapedCharacters, opt_trailingChars) {
  opt_protectEscapedCharacters && (str = goog.string.unescapeEntities(str));
  if (opt_trailingChars && str.length > chars) {
    opt_trailingChars > chars && (opt_trailingChars = chars), str = str.substring(0, chars - opt_trailingChars) + "..." + str.substring(str.length - opt_trailingChars);
  } else {
    if (str.length > chars) {
      var half = Math.floor(chars / 2);
      str = str.substring(0, half + chars % 2) + "..." + str.substring(str.length - half);
    }
  }
  opt_protectEscapedCharacters && (str = goog.string.htmlEscape(str));
  return str;
};
goog.string.specialEscapeChars_ = {"\x00":"\\0", "\b":"\\b", "\f":"\\f", "\n":"\\n", "\r":"\\r", "\t":"\\t", "\x0B":"\\x0B", '"':'\\"', "\\":"\\\\", "<":"\\u003C"};
goog.string.jsEscapeCache_ = {"'":"\\'"};
goog.string.quote = function(s) {
  s = String(s);
  for (var sb = ['"'], i = 0; i < s.length; i++) {
    var ch = s.charAt(i), cc = ch.charCodeAt(0);
    sb[i + 1] = goog.string.specialEscapeChars_[ch] || (31 < cc && 127 > cc ? ch : goog.string.escapeChar(ch));
  }
  sb.push('"');
  return sb.join("");
};
goog.string.escapeString = function(str) {
  for (var sb = [], i = 0; i < str.length; i++) {
    sb[i] = goog.string.escapeChar(str.charAt(i));
  }
  return sb.join("");
};
goog.string.escapeChar = function(c) {
  if (c in goog.string.jsEscapeCache_) {
    return goog.string.jsEscapeCache_[c];
  }
  if (c in goog.string.specialEscapeChars_) {
    return goog.string.jsEscapeCache_[c] = goog.string.specialEscapeChars_[c];
  }
  var rv = c, cc = c.charCodeAt(0);
  if (31 < cc && 127 > cc) {
    rv = c;
  } else {
    if (256 > cc) {
      if (rv = "\\x", 16 > cc || 256 < cc) {
        rv += "0";
      }
    } else {
      rv = "\\u", 4096 > cc && (rv += "0");
    }
    rv += cc.toString(16).toUpperCase();
  }
  return goog.string.jsEscapeCache_[c] = rv;
};
goog.string.contains = goog.string.internal.contains;
goog.string.caseInsensitiveContains = goog.string.internal.caseInsensitiveContains;
goog.string.countOf = function(s, ss) {
  return s && ss ? s.split(ss).length - 1 : 0;
};
goog.string.removeAt = function(s, index, stringLength) {
  var resultStr = s;
  0 <= index && index < s.length && 0 < stringLength && (resultStr = s.substr(0, index) + s.substr(index + stringLength, s.length - index - stringLength));
  return resultStr;
};
goog.string.remove = function(str, substr) {
  return str.replace(substr, "");
};
goog.string.removeAll = function(s, ss) {
  var re = new RegExp(goog.string.regExpEscape(ss), "g");
  return s.replace(re, "");
};
goog.string.replaceAll = function(s, ss, replacement) {
  var re = new RegExp(goog.string.regExpEscape(ss), "g");
  return s.replace(re, replacement.replace(/\$/g, "$$$$"));
};
goog.string.regExpEscape = function(s) {
  return String(s).replace(/([-()\[\]{}+?*.$\^|,:#<!\\])/g, "\\$1").replace(/\x08/g, "\\x08");
};
goog.string.repeat = String.prototype.repeat ? function(string, length) {
  return string.repeat(length);
} : function(string, length) {
  return Array(length + 1).join(string);
};
goog.string.padNumber = function(num, length, opt_precision) {
  var s = void 0 !== opt_precision ? num.toFixed(opt_precision) : String(num), index = s.indexOf(".");
  -1 == index && (index = s.length);
  return goog.string.repeat("0", Math.max(0, length - index)) + s;
};
goog.string.makeSafe = function(obj) {
  return null == obj ? "" : String(obj);
};
goog.string.buildString = function(var_args) {
  return Array.prototype.join.call(arguments, "");
};
goog.string.getRandomString = function() {
  return Math.floor(2147483648 * Math.random()).toString(36) + Math.abs(Math.floor(2147483648 * Math.random()) ^ goog.now()).toString(36);
};
goog.string.compareVersions = goog.string.internal.compareVersions;
goog.string.hashCode = function(str) {
  for (var result = 0, i = 0; i < str.length; ++i) {
    result = 31 * result + str.charCodeAt(i) >>> 0;
  }
  return result;
};
goog.string.uniqueStringCounter_ = 2147483648 * Math.random() | 0;
goog.string.createUniqueString = function() {
  return "goog_" + goog.string.uniqueStringCounter_++;
};
goog.string.toNumber = function(str) {
  var num = Number(str);
  return 0 == num && goog.string.isEmptyOrWhitespace(str) ? NaN : num;
};
goog.string.isLowerCamelCase = function(str) {
  return /^[a-z]+([A-Z][a-z]*)*$/.test(str);
};
goog.string.isUpperCamelCase = function(str) {
  return /^([A-Z][a-z]*)+$/.test(str);
};
goog.string.toCamelCase = function(str) {
  return String(str).replace(/\-([a-z])/g, function(all, match) {
    return match.toUpperCase();
  });
};
goog.string.toSelectorCase = function(str) {
  return String(str).replace(/([A-Z])/g, "-$1").toLowerCase();
};
goog.string.toTitleCase = function(str, opt_delimiters) {
  var delimiters = "string" === typeof opt_delimiters ? goog.string.regExpEscape(opt_delimiters) : "\\s";
  return str.replace(new RegExp("(^" + (delimiters ? "|[" + delimiters + "]+" : "") + ")([a-z])", "g"), function(all, p1, p2) {
    return p1 + p2.toUpperCase();
  });
};
goog.string.capitalize = function(str) {
  return String(str.charAt(0)).toUpperCase() + String(str.substr(1)).toLowerCase();
};
goog.string.parseInt = function(value) {
  isFinite(value) && (value = String(value));
  return "string" === typeof value ? /^\s*-?0x/i.test(value) ? parseInt(value, 16) : parseInt(value, 10) : NaN;
};
goog.string.splitLimit = function(str, separator, limit) {
  for (var parts = str.split(separator), returnVal = []; 0 < limit && parts.length;) {
    returnVal.push(parts.shift()), limit--;
  }
  parts.length && returnVal.push(parts.join(separator));
  return returnVal;
};
goog.string.lastComponent = function(str, separators) {
  if (separators) {
    "string" == typeof separators && (separators = [separators]);
  } else {
    return str;
  }
  for (var lastSeparatorIndex = -1, i = 0; i < separators.length; i++) {
    if ("" != separators[i]) {
      var currentSeparatorIndex = str.lastIndexOf(separators[i]);
      currentSeparatorIndex > lastSeparatorIndex && (lastSeparatorIndex = currentSeparatorIndex);
    }
  }
  return -1 == lastSeparatorIndex ? str : str.slice(lastSeparatorIndex + 1);
};
goog.string.editDistance = function(a, b) {
  var v0 = [], v1 = [];
  if (a == b) {
    return 0;
  }
  if (!a.length || !b.length) {
    return Math.max(a.length, b.length);
  }
  for (var i = 0; i < b.length + 1; i++) {
    v0[i] = i;
  }
  for (i = 0; i < a.length; i++) {
    v1[0] = i + 1;
    for (var j = 0; j < b.length; j++) {
      v1[j + 1] = Math.min(v1[j] + 1, v0[j + 1] + 1, v0[j] + Number(a[i] != b[j]));
    }
    for (j = 0; j < v0.length; j++) {
      v0[j] = v1[j];
    }
  }
  return v1[b.length];
};
goog.labs.userAgent.engine = {};
goog.labs.userAgent.engine.isPresto = function() {
  return goog.labs.userAgent.util.matchUserAgent("Presto");
};
goog.labs.userAgent.engine.isTrident = function() {
  return goog.labs.userAgent.util.matchUserAgent("Trident") || goog.labs.userAgent.util.matchUserAgent("MSIE");
};
goog.labs.userAgent.engine.isEdge = function() {
  return goog.labs.userAgent.util.matchUserAgent("Edge");
};
goog.labs.userAgent.engine.isWebKit = function() {
  return goog.labs.userAgent.util.matchUserAgentIgnoreCase("WebKit") && !goog.labs.userAgent.engine.isEdge();
};
goog.labs.userAgent.engine.isGecko = function() {
  return goog.labs.userAgent.util.matchUserAgent("Gecko") && !goog.labs.userAgent.engine.isWebKit() && !goog.labs.userAgent.engine.isTrident() && !goog.labs.userAgent.engine.isEdge();
};
goog.labs.userAgent.engine.getVersion = function() {
  var userAgentString = goog.labs.userAgent.util.getUserAgent();
  if (userAgentString) {
    var tuples = goog.labs.userAgent.util.extractVersionTuples(userAgentString), engineTuple = goog.labs.userAgent.engine.getEngineTuple_(tuples);
    if (engineTuple) {
      return "Gecko" == engineTuple[0] ? goog.labs.userAgent.engine.getVersionForKey_(tuples, "Firefox") : engineTuple[1];
    }
    var browserTuple = tuples[0], info;
    if (browserTuple && (info = browserTuple[2])) {
      var match = /Trident\/([^\s;]+)/.exec(info);
      if (match) {
        return match[1];
      }
    }
  }
  return "";
};
goog.labs.userAgent.engine.getEngineTuple_ = function(tuples) {
  if (!goog.labs.userAgent.engine.isEdge()) {
    return tuples[1];
  }
  for (var i = 0; i < tuples.length; i++) {
    var tuple = tuples[i];
    if ("Edge" == tuple[0]) {
      return tuple;
    }
  }
};
goog.labs.userAgent.engine.isVersionOrHigher = function(version) {
  return 0 <= goog.string.compareVersions(goog.labs.userAgent.engine.getVersion(), version);
};
goog.labs.userAgent.engine.getVersionForKey_ = function(tuples, key) {
  var pair = goog.array.find(tuples, function(pair) {
    return key == pair[0];
  });
  return pair && pair[1] || "";
};
goog.labs.userAgent.platform = {};
goog.labs.userAgent.platform.isAndroid = function() {
  return goog.labs.userAgent.util.matchUserAgent("Android");
};
goog.labs.userAgent.platform.isIpod = function() {
  return goog.labs.userAgent.util.matchUserAgent("iPod");
};
goog.labs.userAgent.platform.isIphone = function() {
  return goog.labs.userAgent.util.matchUserAgent("iPhone") && !goog.labs.userAgent.util.matchUserAgent("iPod") && !goog.labs.userAgent.util.matchUserAgent("iPad");
};
goog.labs.userAgent.platform.isIpad = function() {
  return goog.labs.userAgent.util.matchUserAgent("iPad");
};
goog.labs.userAgent.platform.isIos = function() {
  return goog.labs.userAgent.platform.isIphone() || goog.labs.userAgent.platform.isIpad() || goog.labs.userAgent.platform.isIpod();
};
goog.labs.userAgent.platform.isMacintosh = function() {
  return goog.labs.userAgent.util.matchUserAgent("Macintosh");
};
goog.labs.userAgent.platform.isLinux = function() {
  return goog.labs.userAgent.util.matchUserAgent("Linux");
};
goog.labs.userAgent.platform.isWindows = function() {
  return goog.labs.userAgent.util.matchUserAgent("Windows");
};
goog.labs.userAgent.platform.isChromeOS = function() {
  return goog.labs.userAgent.util.matchUserAgent("CrOS");
};
goog.labs.userAgent.platform.isChromecast = function() {
  return goog.labs.userAgent.util.matchUserAgent("CrKey");
};
goog.labs.userAgent.platform.isKaiOS = function() {
  return goog.labs.userAgent.util.matchUserAgentIgnoreCase("KaiOS");
};
goog.labs.userAgent.platform.getVersion = function() {
  var userAgentString = goog.labs.userAgent.util.getUserAgent(), version = "";
  if (goog.labs.userAgent.platform.isWindows()) {
    var re = /Windows (?:NT|Phone) ([0-9.]+)/;
    var match = re.exec(userAgentString);
    version = match ? match[1] : "0.0";
  } else {
    goog.labs.userAgent.platform.isIos() ? (re = /(?:iPhone|iPod|iPad|CPU)\s+OS\s+(\S+)/, version = (match = re.exec(userAgentString)) && match[1].replace(/_/g, ".")) : goog.labs.userAgent.platform.isMacintosh() ? (re = /Mac OS X ([0-9_.]+)/, version = (match = re.exec(userAgentString)) ? match[1].replace(/_/g, ".") : "10") : goog.labs.userAgent.platform.isKaiOS() ? (re = /(?:KaiOS)\/(\S+)/i, version = (match = re.exec(userAgentString)) && match[1]) : goog.labs.userAgent.platform.isAndroid() ? (re = 
    /Android\s+([^\);]+)(\)|;)/, version = (match = re.exec(userAgentString)) && match[1]) : goog.labs.userAgent.platform.isChromeOS() && (re = /(?:CrOS\s+(?:i686|x86_64)\s+([0-9.]+))/, version = (match = re.exec(userAgentString)) && match[1]);
  }
  return version || "";
};
goog.labs.userAgent.platform.isVersionOrHigher = function(version) {
  return 0 <= goog.string.compareVersions(goog.labs.userAgent.platform.getVersion(), version);
};
goog.reflect = {};
goog.reflect.object = function(type, object) {
  return object;
};
goog.reflect.objectProperty = function(prop, object) {
  return prop;
};
goog.reflect.sinkValue = function(x) {
  goog.reflect.sinkValue[" "](x);
  return x;
};
goog.reflect.sinkValue[" "] = goog.nullFunction;
goog.reflect.canAccessProperty = function(obj, prop) {
  try {
    return goog.reflect.sinkValue(obj[prop]), !0;
  } catch (e) {
  }
  return !1;
};
goog.reflect.cache = function(cacheObj, key, valueFn, opt_keyFn) {
  var storedKey = opt_keyFn ? opt_keyFn(key) : key;
  return Object.prototype.hasOwnProperty.call(cacheObj, storedKey) ? cacheObj[storedKey] : cacheObj[storedKey] = valueFn(key);
};
goog.userAgent = {};
goog.userAgent.ASSUME_IE = !1;
goog.userAgent.ASSUME_EDGE = !1;
goog.userAgent.ASSUME_GECKO = !1;
goog.userAgent.ASSUME_WEBKIT = !1;
goog.userAgent.ASSUME_MOBILE_WEBKIT = !1;
goog.userAgent.ASSUME_OPERA = !1;
goog.userAgent.ASSUME_ANY_VERSION = !1;
goog.userAgent.BROWSER_KNOWN_ = goog.userAgent.ASSUME_IE || goog.userAgent.ASSUME_EDGE || goog.userAgent.ASSUME_GECKO || goog.userAgent.ASSUME_MOBILE_WEBKIT || goog.userAgent.ASSUME_WEBKIT || goog.userAgent.ASSUME_OPERA;
goog.userAgent.getUserAgentString = function() {
  return goog.labs.userAgent.util.getUserAgent();
};
goog.userAgent.getNavigatorTyped = function() {
  return goog.global.navigator || null;
};
goog.userAgent.getNavigator = function() {
  return goog.userAgent.getNavigatorTyped();
};
goog.userAgent.OPERA = goog.userAgent.BROWSER_KNOWN_ ? goog.userAgent.ASSUME_OPERA : goog.labs.userAgent.browser.isOpera();
goog.userAgent.IE = goog.userAgent.BROWSER_KNOWN_ ? goog.userAgent.ASSUME_IE : goog.labs.userAgent.browser.isIE();
goog.userAgent.EDGE = goog.userAgent.BROWSER_KNOWN_ ? goog.userAgent.ASSUME_EDGE : goog.labs.userAgent.engine.isEdge();
goog.userAgent.EDGE_OR_IE = goog.userAgent.EDGE || goog.userAgent.IE;
goog.userAgent.GECKO = goog.userAgent.BROWSER_KNOWN_ ? goog.userAgent.ASSUME_GECKO : goog.labs.userAgent.engine.isGecko();
goog.userAgent.WEBKIT = goog.userAgent.BROWSER_KNOWN_ ? goog.userAgent.ASSUME_WEBKIT || goog.userAgent.ASSUME_MOBILE_WEBKIT : goog.labs.userAgent.engine.isWebKit();
goog.userAgent.isMobile_ = function() {
  return goog.userAgent.WEBKIT && goog.labs.userAgent.util.matchUserAgent("Mobile");
};
goog.userAgent.MOBILE = goog.userAgent.ASSUME_MOBILE_WEBKIT || goog.userAgent.isMobile_();
goog.userAgent.SAFARI = goog.userAgent.WEBKIT;
goog.userAgent.determinePlatform_ = function() {
  var navigator = goog.userAgent.getNavigatorTyped();
  return navigator && navigator.platform || "";
};
goog.userAgent.PLATFORM = goog.userAgent.determinePlatform_();
goog.userAgent.ASSUME_MAC = !1;
goog.userAgent.ASSUME_WINDOWS = !1;
goog.userAgent.ASSUME_LINUX = !1;
goog.userAgent.ASSUME_X11 = !1;
goog.userAgent.ASSUME_ANDROID = !1;
goog.userAgent.ASSUME_IPHONE = !1;
goog.userAgent.ASSUME_IPAD = !1;
goog.userAgent.ASSUME_IPOD = !1;
goog.userAgent.ASSUME_KAIOS = !1;
goog.userAgent.PLATFORM_KNOWN_ = goog.userAgent.ASSUME_MAC || goog.userAgent.ASSUME_WINDOWS || goog.userAgent.ASSUME_LINUX || goog.userAgent.ASSUME_X11 || goog.userAgent.ASSUME_ANDROID || goog.userAgent.ASSUME_IPHONE || goog.userAgent.ASSUME_IPAD || goog.userAgent.ASSUME_IPOD;
goog.userAgent.MAC = goog.userAgent.PLATFORM_KNOWN_ ? goog.userAgent.ASSUME_MAC : goog.labs.userAgent.platform.isMacintosh();
goog.userAgent.WINDOWS = goog.userAgent.PLATFORM_KNOWN_ ? goog.userAgent.ASSUME_WINDOWS : goog.labs.userAgent.platform.isWindows();
goog.userAgent.isLegacyLinux_ = function() {
  return goog.labs.userAgent.platform.isLinux() || goog.labs.userAgent.platform.isChromeOS();
};
goog.userAgent.LINUX = goog.userAgent.PLATFORM_KNOWN_ ? goog.userAgent.ASSUME_LINUX : goog.userAgent.isLegacyLinux_();
goog.userAgent.isX11_ = function() {
  var navigator = goog.userAgent.getNavigatorTyped();
  return !!navigator && goog.string.contains(navigator.appVersion || "", "X11");
};
goog.userAgent.X11 = goog.userAgent.PLATFORM_KNOWN_ ? goog.userAgent.ASSUME_X11 : goog.userAgent.isX11_();
goog.userAgent.ANDROID = goog.userAgent.PLATFORM_KNOWN_ ? goog.userAgent.ASSUME_ANDROID : goog.labs.userAgent.platform.isAndroid();
goog.userAgent.IPHONE = goog.userAgent.PLATFORM_KNOWN_ ? goog.userAgent.ASSUME_IPHONE : goog.labs.userAgent.platform.isIphone();
goog.userAgent.IPAD = goog.userAgent.PLATFORM_KNOWN_ ? goog.userAgent.ASSUME_IPAD : goog.labs.userAgent.platform.isIpad();
goog.userAgent.IPOD = goog.userAgent.PLATFORM_KNOWN_ ? goog.userAgent.ASSUME_IPOD : goog.labs.userAgent.platform.isIpod();
goog.userAgent.IOS = goog.userAgent.PLATFORM_KNOWN_ ? goog.userAgent.ASSUME_IPHONE || goog.userAgent.ASSUME_IPAD || goog.userAgent.ASSUME_IPOD : goog.labs.userAgent.platform.isIos();
goog.userAgent.KAIOS = goog.userAgent.PLATFORM_KNOWN_ ? goog.userAgent.ASSUME_KAIOS : goog.labs.userAgent.platform.isKaiOS();
goog.userAgent.determineVersion_ = function() {
  var version = "", arr = goog.userAgent.getVersionRegexResult_();
  arr && (version = arr ? arr[1] : "");
  if (goog.userAgent.IE) {
    var docMode = goog.userAgent.getDocumentMode_();
    if (null != docMode && docMode > parseFloat(version)) {
      return String(docMode);
    }
  }
  return version;
};
goog.userAgent.getVersionRegexResult_ = function() {
  var userAgent = goog.userAgent.getUserAgentString();
  if (goog.userAgent.GECKO) {
    return /rv:([^\);]+)(\)|;)/.exec(userAgent);
  }
  if (goog.userAgent.EDGE) {
    return /Edge\/([\d\.]+)/.exec(userAgent);
  }
  if (goog.userAgent.IE) {
    return /\b(?:MSIE|rv)[: ]([^\);]+)(\)|;)/.exec(userAgent);
  }
  if (goog.userAgent.WEBKIT) {
    return /WebKit\/(\S+)/.exec(userAgent);
  }
  if (goog.userAgent.OPERA) {
    return /(?:Version)[ \/]?(\S+)/.exec(userAgent);
  }
};
goog.userAgent.getDocumentMode_ = function() {
  var doc = goog.global.document;
  return doc ? doc.documentMode : void 0;
};
goog.userAgent.VERSION = goog.userAgent.determineVersion_();
goog.userAgent.compare = function(v1, v2) {
  return goog.string.compareVersions(v1, v2);
};
goog.userAgent.isVersionOrHigherCache_ = {};
goog.userAgent.isVersionOrHigher = function(version) {
  return goog.userAgent.ASSUME_ANY_VERSION || goog.reflect.cache(goog.userAgent.isVersionOrHigherCache_, version, function() {
    return 0 <= goog.string.compareVersions(goog.userAgent.VERSION, version);
  });
};
goog.userAgent.isVersion = goog.userAgent.isVersionOrHigher;
goog.userAgent.isDocumentModeOrHigher = function(documentMode) {
  return Number(goog.userAgent.DOCUMENT_MODE) >= documentMode;
};
goog.userAgent.isDocumentMode = goog.userAgent.isDocumentModeOrHigher;
goog.userAgent.DOCUMENT_MODE = function() {
  if (goog.global.document && goog.userAgent.IE) {
    var documentMode = goog.userAgent.getDocumentMode_();
    return documentMode ? documentMode : parseInt(goog.userAgent.VERSION, 10) || void 0;
  }
}();
goog.debug.LOGGING_ENABLED = goog.DEBUG;
goog.debug.FORCE_SLOPPY_STACKS = !1;
goog.debug.catchErrors = function(logFunc, opt_cancel, opt_target) {
  var target = opt_target || goog.global, oldErrorHandler = target.onerror, retVal = !!opt_cancel;
  goog.userAgent.WEBKIT && !goog.userAgent.isVersionOrHigher("535.3") && (retVal = !retVal);
  target.onerror = function(message, url, line, opt_col, opt_error) {
    oldErrorHandler && oldErrorHandler(message, url, line, opt_col, opt_error);
    logFunc({message:message, fileName:url, line:line, lineNumber:line, col:opt_col, error:opt_error});
    return retVal;
  };
};
goog.debug.expose = function(obj, opt_showFn) {
  if ("undefined" == typeof obj) {
    return "undefined";
  }
  if (null == obj) {
    return "NULL";
  }
  var str = [], x;
  for (x in obj) {
    if (opt_showFn || !goog.isFunction(obj[x])) {
      var s = x + " = ";
      try {
        s += obj[x];
      } catch (e) {
        s += "*** " + e + " ***";
      }
      str.push(s);
    }
  }
  return str.join("\n");
};
goog.debug.deepExpose = function(obj$jscomp$0, opt_showFn) {
  var str$jscomp$0 = [], uidsToCleanup = [], ancestorUids = {}, helper = function(obj, space) {
    var nestspace = space + "  ", indentMultiline = function(str) {
      return str.replace(/\n/g, "\n" + space);
    };
    try {
      if (void 0 === obj) {
        str$jscomp$0.push("undefined");
      } else {
        if (null === obj) {
          str$jscomp$0.push("NULL");
        } else {
          if ("string" === typeof obj) {
            str$jscomp$0.push('"' + indentMultiline(obj) + '"');
          } else {
            if (goog.isFunction(obj)) {
              str$jscomp$0.push(indentMultiline(String(obj)));
            } else {
              if (goog.isObject(obj)) {
                goog.hasUid(obj) || uidsToCleanup.push(obj);
                var uid = goog.getUid(obj);
                if (ancestorUids[uid]) {
                  str$jscomp$0.push("*** reference loop detected (id=" + uid + ") ***");
                } else {
                  ancestorUids[uid] = !0;
                  str$jscomp$0.push("{");
                  for (var x in obj) {
                    if (opt_showFn || !goog.isFunction(obj[x])) {
                      str$jscomp$0.push("\n"), str$jscomp$0.push(nestspace), str$jscomp$0.push(x + " = "), helper(obj[x], nestspace);
                    }
                  }
                  str$jscomp$0.push("\n" + space + "}");
                  delete ancestorUids[uid];
                }
              } else {
                str$jscomp$0.push(obj);
              }
            }
          }
        }
      }
    } catch (e) {
      str$jscomp$0.push("*** " + e + " ***");
    }
  };
  helper(obj$jscomp$0, "");
  for (var i = 0; i < uidsToCleanup.length; i++) {
    goog.removeUid(uidsToCleanup[i]);
  }
  return str$jscomp$0.join("");
};
goog.debug.exposeArray = function(arr) {
  for (var str = [], i = 0; i < arr.length; i++) {
    Array.isArray(arr[i]) ? str.push(goog.debug.exposeArray(arr[i])) : str.push(arr[i]);
  }
  return "[ " + str.join(", ") + " ]";
};
goog.debug.normalizeErrorObject = function(err) {
  var href = goog.getObjectByName("window.location.href");
  null == err && (err = 'Unknown Error of type "null/undefined"');
  if ("string" === typeof err) {
    return {message:err, name:"Unknown error", lineNumber:"Not available", fileName:href, stack:"Not available"};
  }
  var threwError = !1;
  try {
    var lineNumber = err.lineNumber || err.line || "Not available";
  } catch (e) {
    lineNumber = "Not available", threwError = !0;
  }
  try {
    var fileName = err.fileName || err.filename || err.sourceURL || goog.global.$googDebugFname || href;
  } catch (e$20) {
    fileName = "Not available", threwError = !0;
  }
  if (!(!threwError && err.lineNumber && err.fileName && err.stack && err.message && err.name)) {
    var message = err.message;
    null == message && (message = err.constructor && err.constructor instanceof Function ? 'Unknown Error of type "' + (err.constructor.name ? err.constructor.name : goog.debug.getFunctionName(err.constructor)) + '"' : "Unknown Error of unknown type");
    return {message:message, name:err.name || "UnknownError", lineNumber:lineNumber, fileName:fileName, stack:err.stack || "Not available"};
  }
  return err;
};
goog.debug.enhanceError = function(err, opt_message) {
  if (err instanceof Error) {
    var error = err;
  } else {
    error = Error(err), Error.captureStackTrace && Error.captureStackTrace(error, goog.debug.enhanceError);
  }
  error.stack || (error.stack = goog.debug.getStacktrace(goog.debug.enhanceError));
  if (opt_message) {
    for (var x = 0; error["message" + x];) {
      ++x;
    }
    error["message" + x] = String(opt_message);
  }
  return error;
};
goog.debug.enhanceErrorWithContext = function(err, opt_context) {
  var error = goog.debug.enhanceError(err);
  if (opt_context) {
    for (var key in opt_context) {
      goog.debug.errorcontext.addErrorContext(error, key, opt_context[key]);
    }
  }
  return error;
};
goog.debug.getStacktraceSimple = function(opt_depth) {
  if (!goog.debug.FORCE_SLOPPY_STACKS) {
    var stack = goog.debug.getNativeStackTrace_(goog.debug.getStacktraceSimple);
    if (stack) {
      return stack;
    }
  }
  for (var sb = [], fn = arguments.callee.caller, depth = 0; fn && (!opt_depth || depth < opt_depth);) {
    sb.push(goog.debug.getFunctionName(fn));
    sb.push("()\n");
    try {
      fn = fn.caller;
    } catch (e) {
      sb.push("[exception trying to get caller]\n");
      break;
    }
    depth++;
    if (depth >= goog.debug.MAX_STACK_DEPTH) {
      sb.push("[...long stack...]");
      break;
    }
  }
  opt_depth && depth >= opt_depth ? sb.push("[...reached max depth limit...]") : sb.push("[end]");
  return sb.join("");
};
goog.debug.MAX_STACK_DEPTH = 50;
goog.debug.getNativeStackTrace_ = function(fn) {
  var tempErr = Error();
  if (Error.captureStackTrace) {
    return Error.captureStackTrace(tempErr, fn), String(tempErr.stack);
  }
  try {
    throw tempErr;
  } catch (e) {
    tempErr = e;
  }
  var stack = tempErr.stack;
  return stack ? String(stack) : null;
};
goog.debug.getStacktrace = function(fn) {
  var stack;
  goog.debug.FORCE_SLOPPY_STACKS || (stack = goog.debug.getNativeStackTrace_(fn || goog.debug.getStacktrace));
  stack || (stack = goog.debug.getStacktraceHelper_(fn || arguments.callee.caller, []));
  return stack;
};
goog.debug.getStacktraceHelper_ = function(fn, visited) {
  var sb = [];
  if (goog.array.contains(visited, fn)) {
    sb.push("[...circular reference...]");
  } else {
    if (fn && visited.length < goog.debug.MAX_STACK_DEPTH) {
      sb.push(goog.debug.getFunctionName(fn) + "(");
      for (var args = fn.arguments, i = 0; args && i < args.length; i++) {
        0 < i && sb.push(", ");
        var arg = args[i];
        switch(typeof arg) {
          case "object":
            var argDesc = arg ? "object" : "null";
            break;
          case "string":
            argDesc = arg;
            break;
          case "number":
            argDesc = String(arg);
            break;
          case "boolean":
            argDesc = arg ? "true" : "false";
            break;
          case "function":
            argDesc = (argDesc = goog.debug.getFunctionName(arg)) ? argDesc : "[fn]";
            break;
          default:
            argDesc = typeof arg;
        }
        40 < argDesc.length && (argDesc = argDesc.substr(0, 40) + "...");
        sb.push(argDesc);
      }
      visited.push(fn);
      sb.push(")\n");
      try {
        sb.push(goog.debug.getStacktraceHelper_(fn.caller, visited));
      } catch (e) {
        sb.push("[exception trying to get caller]\n");
      }
    } else {
      fn ? sb.push("[...long stack...]") : sb.push("[end]");
    }
  }
  return sb.join("");
};
goog.debug.getFunctionName = function(fn) {
  if (goog.debug.fnNameCache_[fn]) {
    return goog.debug.fnNameCache_[fn];
  }
  var functionSource = String(fn);
  if (!goog.debug.fnNameCache_[functionSource]) {
    var matches = /function\s+([^\(]+)/m.exec(functionSource);
    goog.debug.fnNameCache_[functionSource] = matches ? matches[1] : "[Anonymous]";
  }
  return goog.debug.fnNameCache_[functionSource];
};
goog.debug.makeWhitespaceVisible = function(string) {
  return string.replace(/ /g, "[_]").replace(/\f/g, "[f]").replace(/\n/g, "[n]\n").replace(/\r/g, "[r]").replace(/\t/g, "[t]");
};
goog.debug.runtimeType = function(value) {
  return value instanceof Function ? value.displayName || value.name || "unknown type name" : value instanceof Object ? value.constructor.displayName || value.constructor.name || Object.prototype.toString.call(value) : null === value ? "null" : typeof value;
};
goog.debug.fnNameCache_ = {};
goog.debug.freezeInternal_ = goog.DEBUG && Object.freeze || function(arg) {
  return arg;
};
goog.debug.freeze = function(arg) {
  return function() {
    return goog.debug.freezeInternal_(arg);
  }();
};
$jscomp.scope.purify = function(fn) {
  return {valueOf:fn}.valueOf();
};
goog.events.BrowserFeature = {HAS_W3C_BUTTON:!goog.userAgent.IE || goog.userAgent.isDocumentModeOrHigher(9), HAS_W3C_EVENT_SUPPORT:!goog.userAgent.IE || goog.userAgent.isDocumentModeOrHigher(9), SET_KEY_CODE_TO_PREVENT_DEFAULT:goog.userAgent.IE && !goog.userAgent.isVersionOrHigher("9"), HAS_NAVIGATOR_ONLINE_PROPERTY:!goog.userAgent.WEBKIT || goog.userAgent.isVersionOrHigher("528"), HAS_HTML5_NETWORK_EVENT_SUPPORT:goog.userAgent.GECKO && goog.userAgent.isVersionOrHigher("1.9b") || goog.userAgent.IE && 
goog.userAgent.isVersionOrHigher("8") || goog.userAgent.OPERA && goog.userAgent.isVersionOrHigher("9.5") || goog.userAgent.WEBKIT && goog.userAgent.isVersionOrHigher("528"), HTML5_NETWORK_EVENTS_FIRE_ON_BODY:goog.userAgent.GECKO && !goog.userAgent.isVersionOrHigher("8") || goog.userAgent.IE && !goog.userAgent.isVersionOrHigher("9"), TOUCH_ENABLED:"ontouchstart" in goog.global || !!(goog.global.document && document.documentElement && "ontouchstart" in document.documentElement) || !(!goog.global.navigator || 
!goog.global.navigator.maxTouchPoints && !goog.global.navigator.msMaxTouchPoints), POINTER_EVENTS:"PointerEvent" in goog.global, MSPOINTER_EVENTS:"MSPointerEvent" in goog.global && !(!goog.global.navigator || !goog.global.navigator.msPointerEnabled), PASSIVE_EVENTS:(0,$jscomp.scope.purify)(function() {
  if (!goog.global.addEventListener || !Object.defineProperty) {
    return !1;
  }
  var passive = !1, options = Object.defineProperty({}, "passive", {get:function() {
    passive = !0;
  }});
  try {
    goog.global.addEventListener("test", goog.nullFunction, options), goog.global.removeEventListener("test", goog.nullFunction, options);
  } catch (e) {
  }
  return passive;
})};
goog.events.getVendorPrefixedName_ = function(eventName) {
  return goog.userAgent.WEBKIT ? "webkit" + eventName : goog.userAgent.OPERA ? "o" + eventName.toLowerCase() : eventName.toLowerCase();
};
goog.events.EventType = {CLICK:"click", RIGHTCLICK:"rightclick", DBLCLICK:"dblclick", AUXCLICK:"auxclick", MOUSEDOWN:"mousedown", MOUSEUP:"mouseup", MOUSEOVER:"mouseover", MOUSEOUT:"mouseout", MOUSEMOVE:"mousemove", MOUSEENTER:"mouseenter", MOUSELEAVE:"mouseleave", MOUSECANCEL:"mousecancel", SELECTIONCHANGE:"selectionchange", SELECTSTART:"selectstart", WHEEL:"wheel", KEYPRESS:"keypress", KEYDOWN:"keydown", KEYUP:"keyup", BLUR:"blur", FOCUS:"focus", DEACTIVATE:"deactivate", FOCUSIN:"focusin", FOCUSOUT:"focusout", 
CHANGE:"change", RESET:"reset", SELECT:"select", SUBMIT:"submit", INPUT:"input", PROPERTYCHANGE:"propertychange", DRAGSTART:"dragstart", DRAG:"drag", DRAGENTER:"dragenter", DRAGOVER:"dragover", DRAGLEAVE:"dragleave", DROP:"drop", DRAGEND:"dragend", TOUCHSTART:"touchstart", TOUCHMOVE:"touchmove", TOUCHEND:"touchend", TOUCHCANCEL:"touchcancel", BEFOREUNLOAD:"beforeunload", CONSOLEMESSAGE:"consolemessage", CONTEXTMENU:"contextmenu", DEVICECHANGE:"devicechange", DEVICEMOTION:"devicemotion", DEVICEORIENTATION:"deviceorientation", 
DOMCONTENTLOADED:"DOMContentLoaded", ERROR:"error", HELP:"help", LOAD:"load", LOSECAPTURE:"losecapture", ORIENTATIONCHANGE:"orientationchange", READYSTATECHANGE:"readystatechange", RESIZE:"resize", SCROLL:"scroll", UNLOAD:"unload", CANPLAY:"canplay", CANPLAYTHROUGH:"canplaythrough", DURATIONCHANGE:"durationchange", EMPTIED:"emptied", ENDED:"ended", LOADEDDATA:"loadeddata", LOADEDMETADATA:"loadedmetadata", PAUSE:"pause", PLAY:"play", PLAYING:"playing", PROGRESS:"progress", RATECHANGE:"ratechange", 
SEEKED:"seeked", SEEKING:"seeking", STALLED:"stalled", SUSPEND:"suspend", TIMEUPDATE:"timeupdate", VOLUMECHANGE:"volumechange", WAITING:"waiting", SOURCEOPEN:"sourceopen", SOURCEENDED:"sourceended", SOURCECLOSED:"sourceclosed", ABORT:"abort", UPDATE:"update", UPDATESTART:"updatestart", UPDATEEND:"updateend", HASHCHANGE:"hashchange", PAGEHIDE:"pagehide", PAGESHOW:"pageshow", POPSTATE:"popstate", COPY:"copy", PASTE:"paste", CUT:"cut", BEFORECOPY:"beforecopy", BEFORECUT:"beforecut", BEFOREPASTE:"beforepaste", 
ONLINE:"online", OFFLINE:"offline", MESSAGE:"message", CONNECT:"connect", INSTALL:"install", ACTIVATE:"activate", FETCH:"fetch", FOREIGNFETCH:"foreignfetch", MESSAGEERROR:"messageerror", STATECHANGE:"statechange", UPDATEFOUND:"updatefound", CONTROLLERCHANGE:"controllerchange", ANIMATIONSTART:goog.events.getVendorPrefixedName_("AnimationStart"), ANIMATIONEND:goog.events.getVendorPrefixedName_("AnimationEnd"), ANIMATIONITERATION:goog.events.getVendorPrefixedName_("AnimationIteration"), TRANSITIONEND:goog.events.getVendorPrefixedName_("TransitionEnd"), 
POINTERDOWN:"pointerdown", POINTERUP:"pointerup", POINTERCANCEL:"pointercancel", POINTERMOVE:"pointermove", POINTEROVER:"pointerover", POINTEROUT:"pointerout", POINTERENTER:"pointerenter", POINTERLEAVE:"pointerleave", GOTPOINTERCAPTURE:"gotpointercapture", LOSTPOINTERCAPTURE:"lostpointercapture", MSGESTURECHANGE:"MSGestureChange", MSGESTUREEND:"MSGestureEnd", MSGESTUREHOLD:"MSGestureHold", MSGESTURESTART:"MSGestureStart", MSGESTURETAP:"MSGestureTap", MSGOTPOINTERCAPTURE:"MSGotPointerCapture", MSINERTIASTART:"MSInertiaStart", 
MSLOSTPOINTERCAPTURE:"MSLostPointerCapture", MSPOINTERCANCEL:"MSPointerCancel", MSPOINTERDOWN:"MSPointerDown", MSPOINTERENTER:"MSPointerEnter", MSPOINTERHOVER:"MSPointerHover", MSPOINTERLEAVE:"MSPointerLeave", MSPOINTERMOVE:"MSPointerMove", MSPOINTEROUT:"MSPointerOut", MSPOINTEROVER:"MSPointerOver", MSPOINTERUP:"MSPointerUp", TEXT:"text", TEXTINPUT:goog.userAgent.IE ? "textinput" : "textInput", COMPOSITIONSTART:"compositionstart", COMPOSITIONUPDATE:"compositionupdate", COMPOSITIONEND:"compositionend", 
BEFOREINPUT:"beforeinput", EXIT:"exit", LOADABORT:"loadabort", LOADCOMMIT:"loadcommit", LOADREDIRECT:"loadredirect", LOADSTART:"loadstart", LOADSTOP:"loadstop", RESPONSIVE:"responsive", SIZECHANGED:"sizechanged", UNRESPONSIVE:"unresponsive", VISIBILITYCHANGE:"visibilitychange", STORAGE:"storage", DOMSUBTREEMODIFIED:"DOMSubtreeModified", DOMNODEINSERTED:"DOMNodeInserted", DOMNODEREMOVED:"DOMNodeRemoved", DOMNODEREMOVEDFROMDOCUMENT:"DOMNodeRemovedFromDocument", DOMNODEINSERTEDINTODOCUMENT:"DOMNodeInsertedIntoDocument", 
DOMATTRMODIFIED:"DOMAttrModified", DOMCHARACTERDATAMODIFIED:"DOMCharacterDataModified", BEFOREPRINT:"beforeprint", AFTERPRINT:"afterprint", BEFOREINSTALLPROMPT:"beforeinstallprompt", APPINSTALLED:"appinstalled"};
goog.events.getPointerFallbackEventName_ = function(pointerEventName, msPointerEventName, fallbackEventName) {
  return goog.events.BrowserFeature.POINTER_EVENTS ? pointerEventName : goog.events.BrowserFeature.MSPOINTER_EVENTS ? msPointerEventName : fallbackEventName;
};
goog.events.PointerFallbackEventType = {POINTERDOWN:goog.events.getPointerFallbackEventName_(goog.events.EventType.POINTERDOWN, goog.events.EventType.MSPOINTERDOWN, goog.events.EventType.MOUSEDOWN), POINTERUP:goog.events.getPointerFallbackEventName_(goog.events.EventType.POINTERUP, goog.events.EventType.MSPOINTERUP, goog.events.EventType.MOUSEUP), POINTERCANCEL:goog.events.getPointerFallbackEventName_(goog.events.EventType.POINTERCANCEL, goog.events.EventType.MSPOINTERCANCEL, goog.events.EventType.MOUSECANCEL), 
POINTERMOVE:goog.events.getPointerFallbackEventName_(goog.events.EventType.POINTERMOVE, goog.events.EventType.MSPOINTERMOVE, goog.events.EventType.MOUSEMOVE), POINTEROVER:goog.events.getPointerFallbackEventName_(goog.events.EventType.POINTEROVER, goog.events.EventType.MSPOINTEROVER, goog.events.EventType.MOUSEOVER), POINTEROUT:goog.events.getPointerFallbackEventName_(goog.events.EventType.POINTEROUT, goog.events.EventType.MSPOINTEROUT, goog.events.EventType.MOUSEOUT), POINTERENTER:goog.events.getPointerFallbackEventName_(goog.events.EventType.POINTERENTER, 
goog.events.EventType.MSPOINTERENTER, goog.events.EventType.MOUSEENTER), POINTERLEAVE:goog.events.getPointerFallbackEventName_(goog.events.EventType.POINTERLEAVE, goog.events.EventType.MSPOINTERLEAVE, goog.events.EventType.MOUSELEAVE)};
goog.events.PointerTouchFallbackEventType = {POINTERDOWN:goog.events.getPointerFallbackEventName_(goog.events.EventType.POINTERDOWN, goog.events.EventType.MSPOINTERDOWN, goog.events.EventType.TOUCHSTART), POINTERUP:goog.events.getPointerFallbackEventName_(goog.events.EventType.POINTERUP, goog.events.EventType.MSPOINTERUP, goog.events.EventType.TOUCHEND), POINTERCANCEL:goog.events.getPointerFallbackEventName_(goog.events.EventType.POINTERCANCEL, goog.events.EventType.MSPOINTERCANCEL, goog.events.EventType.TOUCHCANCEL), 
POINTERMOVE:goog.events.getPointerFallbackEventName_(goog.events.EventType.POINTERMOVE, goog.events.EventType.MSPOINTERMOVE, goog.events.EventType.TOUCHMOVE)};
goog.events.PointerAsMouseEventType = {MOUSEDOWN:goog.events.PointerFallbackEventType.POINTERDOWN, MOUSEUP:goog.events.PointerFallbackEventType.POINTERUP, MOUSECANCEL:goog.events.PointerFallbackEventType.POINTERCANCEL, MOUSEMOVE:goog.events.PointerFallbackEventType.POINTERMOVE, MOUSEOVER:goog.events.PointerFallbackEventType.POINTEROVER, MOUSEOUT:goog.events.PointerFallbackEventType.POINTEROUT, MOUSEENTER:goog.events.PointerFallbackEventType.POINTERENTER, MOUSELEAVE:goog.events.PointerFallbackEventType.POINTERLEAVE};
goog.events.MouseAsMouseEventType = {MOUSEDOWN:goog.events.EventType.MOUSEDOWN, MOUSEUP:goog.events.EventType.MOUSEUP, MOUSECANCEL:goog.events.EventType.MOUSECANCEL, MOUSEMOVE:goog.events.EventType.MOUSEMOVE, MOUSEOVER:goog.events.EventType.MOUSEOVER, MOUSEOUT:goog.events.EventType.MOUSEOUT, MOUSEENTER:goog.events.EventType.MOUSEENTER, MOUSELEAVE:goog.events.EventType.MOUSELEAVE};
goog.events.PointerAsTouchEventType = {TOUCHCANCEL:goog.events.PointerTouchFallbackEventType.POINTERCANCEL, TOUCHEND:goog.events.PointerTouchFallbackEventType.POINTERUP, TOUCHMOVE:goog.events.PointerTouchFallbackEventType.POINTERMOVE, TOUCHSTART:goog.events.PointerTouchFallbackEventType.POINTERDOWN};
goog.events.USE_LAYER_XY_AS_OFFSET_XY = !1;
goog.events.BrowserEvent = function(opt_e, opt_currentTarget) {
  goog.events.Event.call(this, opt_e ? opt_e.type : "");
  this.relatedTarget = this.currentTarget = this.target = null;
  this.button = this.screenY = this.screenX = this.clientY = this.clientX = this.offsetY = this.offsetX = 0;
  this.key = "";
  this.charCode = this.keyCode = 0;
  this.metaKey = this.shiftKey = this.altKey = this.ctrlKey = !1;
  this.state = null;
  this.platformModifierKey = !1;
  this.pointerId = 0;
  this.pointerType = "";
  this.event_ = null;
  opt_e && this.init(opt_e, opt_currentTarget);
};
goog.inherits(goog.events.BrowserEvent, goog.events.Event);
goog.events.BrowserEvent.MouseButton = {LEFT:0, MIDDLE:1, RIGHT:2};
goog.events.BrowserEvent.PointerType = {MOUSE:"mouse", PEN:"pen", TOUCH:"touch"};
goog.events.BrowserEvent.IEButtonMap = goog.debug.freeze([1, 4, 2]);
goog.events.BrowserEvent.IE_BUTTON_MAP = goog.events.BrowserEvent.IEButtonMap;
goog.events.BrowserEvent.IE_POINTER_TYPE_MAP = goog.debug.freeze({2:goog.events.BrowserEvent.PointerType.TOUCH, 3:goog.events.BrowserEvent.PointerType.PEN, 4:goog.events.BrowserEvent.PointerType.MOUSE});
goog.events.BrowserEvent.prototype.init = function(e, opt_currentTarget) {
  var type = this.type = e.type, relevantTouch = e.changedTouches && e.changedTouches.length ? e.changedTouches[0] : null;
  this.target = e.target || e.srcElement;
  this.currentTarget = opt_currentTarget;
  var relatedTarget = e.relatedTarget;
  relatedTarget ? goog.userAgent.GECKO && (goog.reflect.canAccessProperty(relatedTarget, "nodeName") || (relatedTarget = null)) : type == goog.events.EventType.MOUSEOVER ? relatedTarget = e.fromElement : type == goog.events.EventType.MOUSEOUT && (relatedTarget = e.toElement);
  this.relatedTarget = relatedTarget;
  relevantTouch ? (this.clientX = void 0 !== relevantTouch.clientX ? relevantTouch.clientX : relevantTouch.pageX, this.clientY = void 0 !== relevantTouch.clientY ? relevantTouch.clientY : relevantTouch.pageY, this.screenX = relevantTouch.screenX || 0, this.screenY = relevantTouch.screenY || 0) : (goog.events.USE_LAYER_XY_AS_OFFSET_XY ? (this.offsetX = void 0 !== e.layerX ? e.layerX : e.offsetX, this.offsetY = void 0 !== e.layerY ? e.layerY : e.offsetY) : (this.offsetX = goog.userAgent.WEBKIT || void 0 !== 
  e.offsetX ? e.offsetX : e.layerX, this.offsetY = goog.userAgent.WEBKIT || void 0 !== e.offsetY ? e.offsetY : e.layerY), this.clientX = void 0 !== e.clientX ? e.clientX : e.pageX, this.clientY = void 0 !== e.clientY ? e.clientY : e.pageY, this.screenX = e.screenX || 0, this.screenY = e.screenY || 0);
  this.button = e.button;
  this.keyCode = e.keyCode || 0;
  this.key = e.key || "";
  this.charCode = e.charCode || ("keypress" == type ? e.keyCode : 0);
  this.ctrlKey = e.ctrlKey;
  this.altKey = e.altKey;
  this.shiftKey = e.shiftKey;
  this.metaKey = e.metaKey;
  this.platformModifierKey = goog.userAgent.MAC ? e.metaKey : e.ctrlKey;
  this.pointerId = e.pointerId || 0;
  this.pointerType = goog.events.BrowserEvent.getPointerType_(e);
  this.state = e.state;
  this.event_ = e;
  e.defaultPrevented && this.preventDefault();
};
goog.events.BrowserEvent.prototype.isButton = function(button) {
  return goog.events.BrowserFeature.HAS_W3C_BUTTON ? this.event_.button == button : "click" == this.type ? button == goog.events.BrowserEvent.MouseButton.LEFT : !!(this.event_.button & goog.events.BrowserEvent.IE_BUTTON_MAP[button]);
};
goog.events.BrowserEvent.prototype.isMouseActionButton = function() {
  return this.isButton(goog.events.BrowserEvent.MouseButton.LEFT) && !(goog.userAgent.MAC && this.ctrlKey);
};
goog.events.BrowserEvent.prototype.stopPropagation = function() {
  goog.events.BrowserEvent.superClass_.stopPropagation.call(this);
  this.event_.stopPropagation ? this.event_.stopPropagation() : this.event_.cancelBubble = !0;
};
goog.events.BrowserEvent.prototype.preventDefault = function() {
  goog.events.BrowserEvent.superClass_.preventDefault.call(this);
  var be = this.event_;
  if (be.preventDefault) {
    be.preventDefault();
  } else {
    if (be.returnValue = !1, goog.events.BrowserFeature.SET_KEY_CODE_TO_PREVENT_DEFAULT) {
      try {
        if (be.ctrlKey || 112 <= be.keyCode && 123 >= be.keyCode) {
          be.keyCode = -1;
        }
      } catch (ex) {
      }
    }
  }
};
goog.events.BrowserEvent.prototype.getBrowserEvent = function() {
  return this.event_;
};
goog.events.BrowserEvent.getPointerType_ = function(e) {
  return "string" === typeof e.pointerType ? e.pointerType : goog.events.BrowserEvent.IE_POINTER_TYPE_MAP[e.pointerType] || "";
};
goog.events.Listenable = function() {
};
goog.events.Listenable.IMPLEMENTED_BY_PROP = "closure_listenable_" + (1e6 * Math.random() | 0);
goog.events.Listenable.addImplementation = function(cls) {
  cls.prototype[goog.events.Listenable.IMPLEMENTED_BY_PROP] = !0;
};
goog.events.Listenable.isImplementedBy = function(obj) {
  return !(!obj || !obj[goog.events.Listenable.IMPLEMENTED_BY_PROP]);
};
goog.events.ListenableKey = function() {
};
goog.events.ListenableKey.counter_ = 0;
goog.events.ListenableKey.reserveKey = function() {
  return ++goog.events.ListenableKey.counter_;
};
goog.events.Listener = function(listener, proxy, src, type, capture, opt_handler) {
  goog.events.Listener.ENABLE_MONITORING && (this.creationStack = Error().stack);
  this.listener = listener;
  this.proxy = proxy;
  this.src = src;
  this.type = type;
  this.capture = !!capture;
  this.handler = opt_handler;
  this.key = goog.events.ListenableKey.reserveKey();
  this.removed = this.callOnce = !1;
};
goog.events.Listener.ENABLE_MONITORING = !1;
goog.events.Listener.prototype.markAsRemoved = function() {
  this.removed = !0;
  this.handler = this.src = this.proxy = this.listener = null;
};
goog.events.ListenerMap = function(src) {
  this.src = src;
  this.listeners = {};
  this.typeCount_ = 0;
};
goog.events.ListenerMap.prototype.getTypeCount = function() {
  return this.typeCount_;
};
goog.events.ListenerMap.prototype.getListenerCount = function() {
  var count = 0, type;
  for (type in this.listeners) {
    count += this.listeners[type].length;
  }
  return count;
};
goog.events.ListenerMap.prototype.add = function(type, listener, callOnce, opt_useCapture, opt_listenerScope) {
  var typeStr = type.toString(), listenerArray = this.listeners[typeStr];
  listenerArray || (listenerArray = this.listeners[typeStr] = [], this.typeCount_++);
  var index = goog.events.ListenerMap.findListenerIndex_(listenerArray, listener, opt_useCapture, opt_listenerScope);
  if (-1 < index) {
    var listenerObj = listenerArray[index];
    callOnce || (listenerObj.callOnce = !1);
  } else {
    listenerObj = new goog.events.Listener(listener, null, this.src, typeStr, !!opt_useCapture, opt_listenerScope), listenerObj.callOnce = callOnce, listenerArray.push(listenerObj);
  }
  return listenerObj;
};
goog.events.ListenerMap.prototype.remove = function(type, listener, opt_useCapture, opt_listenerScope) {
  var typeStr = type.toString();
  if (!(typeStr in this.listeners)) {
    return !1;
  }
  var listenerArray = this.listeners[typeStr], index = goog.events.ListenerMap.findListenerIndex_(listenerArray, listener, opt_useCapture, opt_listenerScope);
  return -1 < index ? (listenerArray[index].markAsRemoved(), goog.array.removeAt(listenerArray, index), 0 == listenerArray.length && (delete this.listeners[typeStr], this.typeCount_--), !0) : !1;
};
goog.events.ListenerMap.prototype.removeByKey = function(listener) {
  var type = listener.type;
  if (!(type in this.listeners)) {
    return !1;
  }
  var removed = goog.array.remove(this.listeners[type], listener);
  removed && (listener.markAsRemoved(), 0 == this.listeners[type].length && (delete this.listeners[type], this.typeCount_--));
  return removed;
};
goog.events.ListenerMap.prototype.removeAll = function(opt_type) {
  var typeStr = opt_type && opt_type.toString(), count = 0, type;
  for (type in this.listeners) {
    if (!typeStr || type == typeStr) {
      for (var listenerArray = this.listeners[type], i = 0; i < listenerArray.length; i++) {
        ++count, listenerArray[i].markAsRemoved();
      }
      delete this.listeners[type];
      this.typeCount_--;
    }
  }
  return count;
};
goog.events.ListenerMap.prototype.getListeners = function(type, capture) {
  var listenerArray = this.listeners[type.toString()], rv = [];
  if (listenerArray) {
    for (var i = 0; i < listenerArray.length; ++i) {
      var listenerObj = listenerArray[i];
      listenerObj.capture == capture && rv.push(listenerObj);
    }
  }
  return rv;
};
goog.events.ListenerMap.prototype.getListener = function(type, listener, capture, opt_listenerScope) {
  var listenerArray = this.listeners[type.toString()], i = -1;
  listenerArray && (i = goog.events.ListenerMap.findListenerIndex_(listenerArray, listener, capture, opt_listenerScope));
  return -1 < i ? listenerArray[i] : null;
};
goog.events.ListenerMap.prototype.hasListener = function(opt_type, opt_capture) {
  var hasType = void 0 !== opt_type, typeStr = hasType ? opt_type.toString() : "", hasCapture = void 0 !== opt_capture;
  return goog.object.some(this.listeners, function(listenerArray, type) {
    for (var i = 0; i < listenerArray.length; ++i) {
      if (!(hasType && listenerArray[i].type != typeStr || hasCapture && listenerArray[i].capture != opt_capture)) {
        return !0;
      }
    }
    return !1;
  });
};
goog.events.ListenerMap.findListenerIndex_ = function(listenerArray, listener, opt_useCapture, opt_listenerScope) {
  for (var i = 0; i < listenerArray.length; ++i) {
    var listenerObj = listenerArray[i];
    if (!listenerObj.removed && listenerObj.listener == listener && listenerObj.capture == !!opt_useCapture && listenerObj.handler == opt_listenerScope) {
      return i;
    }
  }
  return -1;
};
goog.events.LISTENER_MAP_PROP_ = "closure_lm_" + (1e6 * Math.random() | 0);
goog.events.onString_ = "on";
goog.events.onStringMap_ = {};
goog.events.CaptureSimulationMode = {OFF_AND_FAIL:0, OFF_AND_SILENT:1, ON:2};
goog.events.CAPTURE_SIMULATION_MODE = 2;
goog.events.listenerCountEstimate_ = 0;
goog.events.listen = function(src, type, listener, opt_options, opt_handler) {
  if (opt_options && opt_options.once) {
    return goog.events.listenOnce(src, type, listener, opt_options, opt_handler);
  }
  if (Array.isArray(type)) {
    for (var i = 0; i < type.length; i++) {
      goog.events.listen(src, type[i], listener, opt_options, opt_handler);
    }
    return null;
  }
  listener = goog.events.wrapListener(listener);
  return goog.events.Listenable.isImplementedBy(src) ? src.listen(type, listener, goog.isObject(opt_options) ? !!opt_options.capture : !!opt_options, opt_handler) : goog.events.listen_(src, type, listener, !1, opt_options, opt_handler);
};
goog.events.listen_ = function(src, type, listener, callOnce, opt_options, opt_handler) {
  if (!type) {
    throw Error("Invalid event type");
  }
  var capture = goog.isObject(opt_options) ? !!opt_options.capture : !!opt_options;
  if (capture && !goog.events.BrowserFeature.HAS_W3C_EVENT_SUPPORT) {
    if (goog.events.CAPTURE_SIMULATION_MODE == goog.events.CaptureSimulationMode.OFF_AND_FAIL) {
      return goog.asserts.fail("Can not register capture listener in IE8-."), null;
    }
    if (goog.events.CAPTURE_SIMULATION_MODE == goog.events.CaptureSimulationMode.OFF_AND_SILENT) {
      return null;
    }
  }
  var listenerMap = goog.events.getListenerMap_(src);
  listenerMap || (src[goog.events.LISTENER_MAP_PROP_] = listenerMap = new goog.events.ListenerMap(src));
  var listenerObj = listenerMap.add(type, listener, callOnce, capture, opt_handler);
  if (listenerObj.proxy) {
    return listenerObj;
  }
  var proxy = goog.events.getProxy();
  listenerObj.proxy = proxy;
  proxy.src = src;
  proxy.listener = listenerObj;
  if (src.addEventListener) {
    goog.events.BrowserFeature.PASSIVE_EVENTS || (opt_options = capture), void 0 === opt_options && (opt_options = !1), src.addEventListener(type.toString(), proxy, opt_options);
  } else {
    if (src.attachEvent) {
      src.attachEvent(goog.events.getOnString_(type.toString()), proxy);
    } else {
      if (src.addListener && src.removeListener) {
        goog.asserts.assert("change" === type, "MediaQueryList only has a change event"), src.addListener(proxy);
      } else {
        throw Error("addEventListener and attachEvent are unavailable.");
      }
    }
  }
  goog.events.listenerCountEstimate_++;
  return listenerObj;
};
goog.events.getProxy = function() {
  var proxyCallbackFunction = goog.events.handleBrowserEvent_, f = goog.events.BrowserFeature.HAS_W3C_EVENT_SUPPORT ? function(eventObject) {
    return proxyCallbackFunction.call(f.src, f.listener, eventObject);
  } : function(eventObject) {
    var v = proxyCallbackFunction.call(f.src, f.listener, eventObject);
    if (!v) {
      return v;
    }
  };
  return f;
};
goog.events.listenOnce = function(src, type, listener, opt_options, opt_handler) {
  if (Array.isArray(type)) {
    for (var i = 0; i < type.length; i++) {
      goog.events.listenOnce(src, type[i], listener, opt_options, opt_handler);
    }
    return null;
  }
  listener = goog.events.wrapListener(listener);
  return goog.events.Listenable.isImplementedBy(src) ? src.listenOnce(type, listener, goog.isObject(opt_options) ? !!opt_options.capture : !!opt_options, opt_handler) : goog.events.listen_(src, type, listener, !0, opt_options, opt_handler);
};
goog.events.listenWithWrapper = function(src, wrapper, listener, opt_capt, opt_handler) {
  wrapper.listen(src, listener, opt_capt, opt_handler);
};
goog.events.unlisten = function(src, type, listener, opt_options, opt_handler) {
  if (Array.isArray(type)) {
    for (var i = 0; i < type.length; i++) {
      goog.events.unlisten(src, type[i], listener, opt_options, opt_handler);
    }
    return null;
  }
  var capture = goog.isObject(opt_options) ? !!opt_options.capture : !!opt_options;
  listener = goog.events.wrapListener(listener);
  if (goog.events.Listenable.isImplementedBy(src)) {
    return src.unlisten(type, listener, capture, opt_handler);
  }
  if (!src) {
    return !1;
  }
  var listenerMap = goog.events.getListenerMap_(src);
  if (listenerMap) {
    var listenerObj = listenerMap.getListener(type, listener, capture, opt_handler);
    if (listenerObj) {
      return goog.events.unlistenByKey(listenerObj);
    }
  }
  return !1;
};
goog.events.unlistenByKey = function(key) {
  if ("number" === typeof key || !key || key.removed) {
    return !1;
  }
  var src = key.src;
  if (goog.events.Listenable.isImplementedBy(src)) {
    return src.unlistenByKey(key);
  }
  var type = key.type, proxy = key.proxy;
  src.removeEventListener ? src.removeEventListener(type, proxy, key.capture) : src.detachEvent ? src.detachEvent(goog.events.getOnString_(type), proxy) : src.addListener && src.removeListener && src.removeListener(proxy);
  goog.events.listenerCountEstimate_--;
  var listenerMap = goog.events.getListenerMap_(src);
  listenerMap ? (listenerMap.removeByKey(key), 0 == listenerMap.getTypeCount() && (listenerMap.src = null, src[goog.events.LISTENER_MAP_PROP_] = null)) : key.markAsRemoved();
  return !0;
};
goog.events.unlistenWithWrapper = function(src, wrapper, listener, opt_capt, opt_handler) {
  wrapper.unlisten(src, listener, opt_capt, opt_handler);
};
goog.events.removeAll = function(obj, opt_type) {
  if (!obj) {
    return 0;
  }
  if (goog.events.Listenable.isImplementedBy(obj)) {
    return obj.removeAllListeners(opt_type);
  }
  var listenerMap = goog.events.getListenerMap_(obj);
  if (!listenerMap) {
    return 0;
  }
  var count = 0, typeStr = opt_type && opt_type.toString(), type;
  for (type in listenerMap.listeners) {
    if (!typeStr || type == typeStr) {
      for (var listeners = listenerMap.listeners[type].concat(), i = 0; i < listeners.length; ++i) {
        goog.events.unlistenByKey(listeners[i]) && ++count;
      }
    }
  }
  return count;
};
goog.events.getListeners = function(obj, type, capture) {
  if (goog.events.Listenable.isImplementedBy(obj)) {
    return obj.getListeners(type, capture);
  }
  if (!obj) {
    return [];
  }
  var listenerMap = goog.events.getListenerMap_(obj);
  return listenerMap ? listenerMap.getListeners(type, capture) : [];
};
goog.events.getListener = function(src, type, listener, opt_capt, opt_handler) {
  listener = goog.events.wrapListener(listener);
  var capture = !!opt_capt;
  if (goog.events.Listenable.isImplementedBy(src)) {
    return src.getListener(type, listener, capture, opt_handler);
  }
  if (!src) {
    return null;
  }
  var listenerMap = goog.events.getListenerMap_(src);
  return listenerMap ? listenerMap.getListener(type, listener, capture, opt_handler) : null;
};
goog.events.hasListener = function(obj, opt_type, opt_capture) {
  if (goog.events.Listenable.isImplementedBy(obj)) {
    return obj.hasListener(opt_type, opt_capture);
  }
  var listenerMap = goog.events.getListenerMap_(obj);
  return !!listenerMap && listenerMap.hasListener(opt_type, opt_capture);
};
goog.events.expose = function(e) {
  var str = [], key;
  for (key in e) {
    e[key] && e[key].id ? str.push(key + " = " + e[key] + " (" + e[key].id + ")") : str.push(key + " = " + e[key]);
  }
  return str.join("\n");
};
goog.events.getOnString_ = function(type) {
  return type in goog.events.onStringMap_ ? goog.events.onStringMap_[type] : goog.events.onStringMap_[type] = goog.events.onString_ + type;
};
goog.events.fireListeners = function(obj, type, capture, eventObject) {
  return goog.events.Listenable.isImplementedBy(obj) ? obj.fireListeners(type, capture, eventObject) : goog.events.fireListeners_(obj, type, capture, eventObject);
};
goog.events.fireListeners_ = function(obj, type, capture, eventObject) {
  var retval = !0, listenerMap = goog.events.getListenerMap_(obj);
  if (listenerMap) {
    var listenerArray = listenerMap.listeners[type.toString()];
    if (listenerArray) {
      listenerArray = listenerArray.concat();
      for (var i = 0; i < listenerArray.length; i++) {
        var listener = listenerArray[i];
        if (listener && listener.capture == capture && !listener.removed) {
          var result = goog.events.fireListener(listener, eventObject);
          retval = retval && !1 !== result;
        }
      }
    }
  }
  return retval;
};
goog.events.fireListener = function(listener, eventObject) {
  var listenerFn = listener.listener, listenerHandler = listener.handler || listener.src;
  listener.callOnce && goog.events.unlistenByKey(listener);
  return listenerFn.call(listenerHandler, eventObject);
};
goog.events.getTotalListenerCount = function() {
  return goog.events.listenerCountEstimate_;
};
goog.events.dispatchEvent = function(src, e) {
  goog.asserts.assert(goog.events.Listenable.isImplementedBy(src), "Can not use goog.events.dispatchEvent with non-goog.events.Listenable instance.");
  return src.dispatchEvent(e);
};
goog.events.protectBrowserEventEntryPoint = function(errorHandler) {
  goog.events.handleBrowserEvent_ = errorHandler.protectEntryPoint(goog.events.handleBrowserEvent_);
};
goog.events.handleBrowserEvent_ = function(listener, opt_evt) {
  if (listener.removed) {
    return !0;
  }
  if (!goog.events.BrowserFeature.HAS_W3C_EVENT_SUPPORT) {
    var ieEvent = opt_evt || goog.getObjectByName("window.event"), evt = new goog.events.BrowserEvent(ieEvent, this), retval = !0;
    if (goog.events.CAPTURE_SIMULATION_MODE == goog.events.CaptureSimulationMode.ON) {
      if (!goog.events.isMarkedIeEvent_(ieEvent)) {
        goog.events.markIeEvent_(ieEvent);
        for (var ancestors = [], parent = evt.currentTarget; parent; parent = parent.parentNode) {
          ancestors.push(parent);
        }
        for (var type = listener.type, i = ancestors.length - 1; !evt.hasPropagationStopped() && 0 <= i; i--) {
          evt.currentTarget = ancestors[i];
          var result = goog.events.fireListeners_(ancestors[i], type, !0, evt);
          retval = retval && result;
        }
        for (i = 0; !evt.hasPropagationStopped() && i < ancestors.length; i++) {
          evt.currentTarget = ancestors[i], result = goog.events.fireListeners_(ancestors[i], type, !1, evt), retval = retval && result;
        }
      }
    } else {
      retval = goog.events.fireListener(listener, evt);
    }
    return retval;
  }
  return goog.events.fireListener(listener, new goog.events.BrowserEvent(opt_evt, this));
};
goog.events.markIeEvent_ = function(e) {
  var useReturnValue = !1;
  if (0 == e.keyCode) {
    try {
      e.keyCode = -1;
      return;
    } catch (ex) {
      useReturnValue = !0;
    }
  }
  if (useReturnValue || void 0 == e.returnValue) {
    e.returnValue = !0;
  }
};
goog.events.isMarkedIeEvent_ = function(e) {
  return 0 > e.keyCode || void 0 != e.returnValue;
};
goog.events.uniqueIdCounter_ = 0;
goog.events.getUniqueId = function(identifier) {
  return identifier + "_" + goog.events.uniqueIdCounter_++;
};
goog.events.getListenerMap_ = function(src) {
  var listenerMap = src[goog.events.LISTENER_MAP_PROP_];
  return listenerMap instanceof goog.events.ListenerMap ? listenerMap : null;
};
goog.events.LISTENER_WRAPPER_PROP_ = "__closure_events_fn_" + (1e9 * Math.random() >>> 0);
goog.events.wrapListener = function(listener) {
  goog.asserts.assert(listener, "Listener can not be null.");
  if (goog.isFunction(listener)) {
    return listener;
  }
  goog.asserts.assert(listener.handleEvent, "An object listener must have handleEvent method.");
  listener[goog.events.LISTENER_WRAPPER_PROP_] || (listener[goog.events.LISTENER_WRAPPER_PROP_] = function(e) {
    return listener.handleEvent(e);
  });
  return listener[goog.events.LISTENER_WRAPPER_PROP_];
};
goog.debug.entryPointRegistry.register(function(transformer) {
  goog.events.handleBrowserEvent_ = transformer(goog.events.handleBrowserEvent_);
});
goog.events.EventTarget = function() {
  goog.Disposable.call(this);
  this.eventTargetListeners_ = new goog.events.ListenerMap(this);
  this.actualEventTarget_ = this;
  this.parentEventTarget_ = null;
};
goog.inherits(goog.events.EventTarget, goog.Disposable);
goog.events.Listenable.addImplementation(goog.events.EventTarget);
goog.events.EventTarget.MAX_ANCESTORS_ = 1000;
goog.events.EventTarget.prototype.getParentEventTarget = function() {
  return this.parentEventTarget_;
};
goog.events.EventTarget.prototype.setParentEventTarget = function(parent) {
  this.parentEventTarget_ = parent;
};
goog.events.EventTarget.prototype.addEventListener = function(type, handler, opt_capture, opt_handlerScope) {
  goog.events.listen(this, type, handler, opt_capture, opt_handlerScope);
};
goog.events.EventTarget.prototype.removeEventListener = function(type, handler, opt_capture, opt_handlerScope) {
  goog.events.unlisten(this, type, handler, opt_capture, opt_handlerScope);
};
goog.events.EventTarget.prototype.dispatchEvent = function(e) {
  this.assertInitialized_();
  var ancestor = this.getParentEventTarget();
  if (ancestor) {
    var ancestorsTree = [];
    for (var ancestorCount = 1; ancestor; ancestor = ancestor.getParentEventTarget()) {
      ancestorsTree.push(ancestor), goog.asserts.assert(++ancestorCount < goog.events.EventTarget.MAX_ANCESTORS_, "infinite loop");
    }
  }
  return goog.events.EventTarget.dispatchEventInternal_(this.actualEventTarget_, e, ancestorsTree);
};
goog.events.EventTarget.prototype.disposeInternal = function() {
  goog.events.EventTarget.superClass_.disposeInternal.call(this);
  this.removeAllListeners();
  this.parentEventTarget_ = null;
};
goog.events.EventTarget.prototype.listen = function(type, listener, opt_useCapture, opt_listenerScope) {
  this.assertInitialized_();
  return this.eventTargetListeners_.add(String(type), listener, !1, opt_useCapture, opt_listenerScope);
};
goog.events.EventTarget.prototype.listenOnce = function(type, listener, opt_useCapture, opt_listenerScope) {
  return this.eventTargetListeners_.add(String(type), listener, !0, opt_useCapture, opt_listenerScope);
};
goog.events.EventTarget.prototype.unlisten = function(type, listener, opt_useCapture, opt_listenerScope) {
  return this.eventTargetListeners_.remove(String(type), listener, opt_useCapture, opt_listenerScope);
};
goog.events.EventTarget.prototype.unlistenByKey = function(key) {
  return this.eventTargetListeners_.removeByKey(key);
};
goog.events.EventTarget.prototype.removeAllListeners = function(opt_type) {
  return this.eventTargetListeners_ ? this.eventTargetListeners_.removeAll(opt_type) : 0;
};
goog.events.EventTarget.prototype.fireListeners = function(type, capture, eventObject) {
  var listenerArray = this.eventTargetListeners_.listeners[String(type)];
  if (!listenerArray) {
    return !0;
  }
  listenerArray = listenerArray.concat();
  for (var rv = !0, i = 0; i < listenerArray.length; ++i) {
    var listener = listenerArray[i];
    if (listener && !listener.removed && listener.capture == capture) {
      var listenerFn = listener.listener, listenerHandler = listener.handler || listener.src;
      listener.callOnce && this.unlistenByKey(listener);
      rv = !1 !== listenerFn.call(listenerHandler, eventObject) && rv;
    }
  }
  return rv && !eventObject.defaultPrevented;
};
goog.events.EventTarget.prototype.getListeners = function(type, capture) {
  return this.eventTargetListeners_.getListeners(String(type), capture);
};
goog.events.EventTarget.prototype.getListener = function(type, listener, capture, opt_listenerScope) {
  return this.eventTargetListeners_.getListener(String(type), listener, capture, opt_listenerScope);
};
goog.events.EventTarget.prototype.hasListener = function(opt_type, opt_capture) {
  return this.eventTargetListeners_.hasListener(void 0 !== opt_type ? String(opt_type) : void 0, opt_capture);
};
goog.events.EventTarget.prototype.setTargetForTesting = function(target) {
  this.actualEventTarget_ = target;
};
goog.events.EventTarget.prototype.assertInitialized_ = function() {
  goog.asserts.assert(this.eventTargetListeners_, "Event target is not initialized. Did you call the superclass (goog.events.EventTarget) constructor?");
};
goog.events.EventTarget.dispatchEventInternal_ = function(target, e, opt_ancestorsTree) {
  var type = e.type || e;
  if ("string" === typeof e) {
    e = new goog.events.Event(e, target);
  } else {
    if (e instanceof goog.events.Event) {
      e.target = e.target || target;
    } else {
      var oldEvent = e;
      e = new goog.events.Event(type, target);
      goog.object.extend(e, oldEvent);
    }
  }
  var rv = !0;
  if (opt_ancestorsTree) {
    for (var i = opt_ancestorsTree.length - 1; !e.hasPropagationStopped() && 0 <= i; i--) {
      var currentTarget = e.currentTarget = opt_ancestorsTree[i];
      rv = currentTarget.fireListeners(type, !0, e) && rv;
    }
  }
  e.hasPropagationStopped() || (currentTarget = e.currentTarget = target, rv = currentTarget.fireListeners(type, !0, e) && rv, e.hasPropagationStopped() || (rv = currentTarget.fireListeners(type, !1, e) && rv));
  if (opt_ancestorsTree) {
    for (i = 0; !e.hasPropagationStopped() && i < opt_ancestorsTree.length; i++) {
      currentTarget = e.currentTarget = opt_ancestorsTree[i], rv = currentTarget.fireListeners(type, !1, e) && rv;
    }
  }
  return rv;
};
goog.structs = {};
goog.structs.Collection = function() {
};
goog.math = {};
goog.math.randomInt = function(a) {
  return Math.floor(Math.random() * a);
};
goog.math.uniformRandom = function(a, b) {
  return a + Math.random() * (b - a);
};
goog.math.clamp = function(value, min, max) {
  return Math.min(Math.max(value, min), max);
};
goog.math.modulo = function(a, b) {
  var r = a % b;
  return 0 > r * b ? r + b : r;
};
goog.math.lerp = function(a, b, x) {
  return a + x * (b - a);
};
goog.math.nearlyEquals = function(a, b, opt_tolerance) {
  return Math.abs(a - b) <= (opt_tolerance || 0.000001);
};
goog.math.standardAngle = function(angle) {
  return goog.math.modulo(angle, 360);
};
goog.math.standardAngleInRadians = function(angle) {
  return goog.math.modulo(angle, 2 * Math.PI);
};
goog.math.toRadians = function(angleDegrees) {
  return angleDegrees * Math.PI / 180;
};
goog.math.toDegrees = function(angleRadians) {
  return 180 * angleRadians / Math.PI;
};
goog.math.angleDx = function(degrees, radius) {
  return radius * Math.cos(goog.math.toRadians(degrees));
};
goog.math.angleDy = function(degrees, radius) {
  return radius * Math.sin(goog.math.toRadians(degrees));
};
goog.math.angle = function(x1, y1, x2, y2) {
  return goog.math.standardAngle(goog.math.toDegrees(Math.atan2(y2 - y1, x2 - x1)));
};
goog.math.angleDifference = function(startAngle, endAngle) {
  var d = goog.math.standardAngle(endAngle) - goog.math.standardAngle(startAngle);
  180 < d ? d -= 360 : -180 >= d && (d = 360 + d);
  return d;
};
goog.math.sign = function(x) {
  return 0 < x ? 1 : 0 > x ? -1 : x;
};
goog.math.longestCommonSubsequence = function(array1, array2, opt_compareFn, opt_collectorFn) {
  for (var compare = opt_compareFn || function(a, b) {
    return a == b;
  }, collect = opt_collectorFn || function(i1, i2) {
    return array1[i1];
  }, length1 = array1.length, length2 = array2.length, arr = [], i = 0; i < length1 + 1; i++) {
    arr[i] = [], arr[i][0] = 0;
  }
  for (var j = 0; j < length2 + 1; j++) {
    arr[0][j] = 0;
  }
  for (i = 1; i <= length1; i++) {
    for (j = 1; j <= length2; j++) {
      compare(array1[i - 1], array2[j - 1]) ? arr[i][j] = arr[i - 1][j - 1] + 1 : arr[i][j] = Math.max(arr[i - 1][j], arr[i][j - 1]);
    }
  }
  var result = [];
  i = length1;
  for (j = length2; 0 < i && 0 < j;) {
    compare(array1[i - 1], array2[j - 1]) ? (result.unshift(collect(i - 1, j - 1)), i--, j--) : arr[i - 1][j] > arr[i][j - 1] ? i-- : j--;
  }
  return result;
};
goog.math.sum = function(var_args) {
  return goog.array.reduce(arguments, function(sum, value) {
    return sum + value;
  }, 0);
};
goog.math.average = function(var_args) {
  return goog.math.sum.apply(null, arguments) / arguments.length;
};
goog.math.sampleVariance = function(var_args) {
  var sampleSize = arguments.length;
  if (2 > sampleSize) {
    return 0;
  }
  var mean = goog.math.average.apply(null, arguments);
  return goog.math.sum.apply(null, goog.array.map(arguments, function(val) {
    return Math.pow(val - mean, 2);
  })) / (sampleSize - 1);
};
goog.math.standardDeviation = function(var_args) {
  return Math.sqrt(goog.math.sampleVariance.apply(null, arguments));
};
goog.math.isInt = function(num) {
  return isFinite(num) && 0 == num % 1;
};
goog.math.isFiniteNumber = function(num) {
  return isFinite(num);
};
goog.math.isNegativeZero = function(num) {
  return 0 == num && 0 > 1 / num;
};
goog.math.log10Floor = function(num) {
  if (0 < num) {
    var x = Math.round(Math.log(num) * Math.LOG10E);
    return x - (parseFloat("1e" + x) > num ? 1 : 0);
  }
  return 0 == num ? -Infinity : NaN;
};
goog.math.safeFloor = function(num, opt_epsilon) {
  goog.asserts.assert(void 0 === opt_epsilon || 0 < opt_epsilon);
  return Math.floor(num + (opt_epsilon || 2e-15));
};
goog.math.safeCeil = function(num, opt_epsilon) {
  goog.asserts.assert(void 0 === opt_epsilon || 0 < opt_epsilon);
  return Math.ceil(num - (opt_epsilon || 2e-15));
};
goog.iter = {};
goog.iter.StopIteration = "StopIteration" in goog.global ? goog.global.StopIteration : {message:"StopIteration", stack:""};
goog.iter.Iterator = function() {
};
goog.iter.Iterator.prototype.next = function() {
  throw goog.iter.StopIteration;
};
goog.iter.Iterator.prototype.__iterator__ = function(opt_keys) {
  return this;
};
goog.iter.toIterator = function(iterable) {
  if (iterable instanceof goog.iter.Iterator) {
    return iterable;
  }
  if ("function" == typeof iterable.__iterator__) {
    return iterable.__iterator__(!1);
  }
  if (goog.isArrayLike(iterable)) {
    var i = 0, newIter = new goog.iter.Iterator;
    newIter.next = function() {
      for (;;) {
        if (i >= iterable.length) {
          throw goog.iter.StopIteration;
        }
        if (i in iterable) {
          return iterable[i++];
        }
        i++;
      }
    };
    return newIter;
  }
  throw Error("Not implemented");
};
goog.iter.forEach = function(iterable, f, opt_obj) {
  if (goog.isArrayLike(iterable)) {
    try {
      goog.array.forEach(iterable, f, opt_obj);
    } catch (ex) {
      if (ex !== goog.iter.StopIteration) {
        throw ex;
      }
    }
  } else {
    iterable = goog.iter.toIterator(iterable);
    try {
      for (;;) {
        f.call(opt_obj, iterable.next(), void 0, iterable);
      }
    } catch (ex$21) {
      if (ex$21 !== goog.iter.StopIteration) {
        throw ex$21;
      }
    }
  }
};
goog.iter.filter = function(iterable, f, opt_obj) {
  var iterator = goog.iter.toIterator(iterable), newIter = new goog.iter.Iterator;
  newIter.next = function() {
    for (;;) {
      var val = iterator.next();
      if (f.call(opt_obj, val, void 0, iterator)) {
        return val;
      }
    }
  };
  return newIter;
};
goog.iter.filterFalse = function(iterable, f, opt_obj) {
  return goog.iter.filter(iterable, goog.functions.not(f), opt_obj);
};
goog.iter.range = function(startOrStop, opt_stop, opt_step) {
  var start = 0, stop = startOrStop, step = opt_step || 1;
  1 < arguments.length && (start = startOrStop, stop = +opt_stop);
  if (0 == step) {
    throw Error("Range step argument must not be zero");
  }
  var newIter = new goog.iter.Iterator;
  newIter.next = function() {
    if (0 < step && start >= stop || 0 > step && start <= stop) {
      throw goog.iter.StopIteration;
    }
    var rv = start;
    start += step;
    return rv;
  };
  return newIter;
};
goog.iter.join = function(iterable, deliminator) {
  return goog.iter.toArray(iterable).join(deliminator);
};
goog.iter.map = function(iterable, f, opt_obj) {
  var iterator = goog.iter.toIterator(iterable), newIter = new goog.iter.Iterator;
  newIter.next = function() {
    var val = iterator.next();
    return f.call(opt_obj, val, void 0, iterator);
  };
  return newIter;
};
goog.iter.reduce = function(iterable, f, val$jscomp$0, opt_obj) {
  var rval = val$jscomp$0;
  goog.iter.forEach(iterable, function(val) {
    rval = f.call(opt_obj, rval, val);
  });
  return rval;
};
goog.iter.some = function(iterable, f, opt_obj) {
  iterable = goog.iter.toIterator(iterable);
  try {
    for (;;) {
      if (f.call(opt_obj, iterable.next(), void 0, iterable)) {
        return !0;
      }
    }
  } catch (ex) {
    if (ex !== goog.iter.StopIteration) {
      throw ex;
    }
  }
  return !1;
};
goog.iter.every = function(iterable, f, opt_obj) {
  iterable = goog.iter.toIterator(iterable);
  try {
    for (;;) {
      if (!f.call(opt_obj, iterable.next(), void 0, iterable)) {
        return !1;
      }
    }
  } catch (ex) {
    if (ex !== goog.iter.StopIteration) {
      throw ex;
    }
  }
  return !0;
};
goog.iter.chain = function(var_args) {
  return goog.iter.chainFromIterable(arguments);
};
goog.iter.chainFromIterable = function(iterable) {
  var iterator = goog.iter.toIterator(iterable), iter = new goog.iter.Iterator, current = null;
  iter.next = function() {
    for (;;) {
      if (null == current) {
        var it = iterator.next();
        current = goog.iter.toIterator(it);
      }
      try {
        return current.next();
      } catch (ex) {
        if (ex !== goog.iter.StopIteration) {
          throw ex;
        }
        current = null;
      }
    }
  };
  return iter;
};
goog.iter.dropWhile = function(iterable, f, opt_obj) {
  var iterator = goog.iter.toIterator(iterable), newIter = new goog.iter.Iterator, dropping = !0;
  newIter.next = function() {
    for (;;) {
      var val = iterator.next();
      if (!dropping || !f.call(opt_obj, val, void 0, iterator)) {
        return dropping = !1, val;
      }
    }
  };
  return newIter;
};
goog.iter.takeWhile = function(iterable, f, opt_obj) {
  var iterator = goog.iter.toIterator(iterable), iter = new goog.iter.Iterator;
  iter.next = function() {
    var val = iterator.next();
    if (f.call(opt_obj, val, void 0, iterator)) {
      return val;
    }
    throw goog.iter.StopIteration;
  };
  return iter;
};
goog.iter.toArray = function(iterable) {
  if (goog.isArrayLike(iterable)) {
    return goog.array.toArray(iterable);
  }
  iterable = goog.iter.toIterator(iterable);
  var array = [];
  goog.iter.forEach(iterable, function(val) {
    array.push(val);
  });
  return array;
};
goog.iter.equals = function(iterable1, iterable2, opt_equalsFn) {
  var pairs = goog.iter.zipLongest({}, iterable1, iterable2), equalsFn = opt_equalsFn || goog.array.defaultCompareEquality;
  return goog.iter.every(pairs, function(pair) {
    return equalsFn(pair[0], pair[1]);
  });
};
goog.iter.nextOrValue = function(iterable, defaultValue) {
  try {
    return goog.iter.toIterator(iterable).next();
  } catch (e) {
    if (e != goog.iter.StopIteration) {
      throw e;
    }
    return defaultValue;
  }
};
goog.iter.product = function(var_args) {
  if (goog.array.some(arguments, function(arr) {
    return !arr.length;
  }) || !arguments.length) {
    return new goog.iter.Iterator;
  }
  var iter = new goog.iter.Iterator, arrays = arguments, indicies = goog.array.repeat(0, arrays.length);
  iter.next = function() {
    if (indicies) {
      for (var retVal = goog.array.map(indicies, function(valueIndex, arrayIndex) {
        return arrays[arrayIndex][valueIndex];
      }), i = indicies.length - 1; 0 <= i; i--) {
        goog.asserts.assert(indicies);
        if (indicies[i] < arrays[i].length - 1) {
          indicies[i]++;
          break;
        }
        if (0 == i) {
          indicies = null;
          break;
        }
        indicies[i] = 0;
      }
      return retVal;
    }
    throw goog.iter.StopIteration;
  };
  return iter;
};
goog.iter.cycle = function(iterable) {
  var baseIterator = goog.iter.toIterator(iterable), cache = [], cacheIndex = 0, iter = new goog.iter.Iterator, useCache = !1;
  iter.next = function() {
    var returnElement = null;
    if (!useCache) {
      try {
        return returnElement = baseIterator.next(), cache.push(returnElement), returnElement;
      } catch (e) {
        if (e != goog.iter.StopIteration || goog.array.isEmpty(cache)) {
          throw e;
        }
        useCache = !0;
      }
    }
    returnElement = cache[cacheIndex];
    cacheIndex = (cacheIndex + 1) % cache.length;
    return returnElement;
  };
  return iter;
};
goog.iter.count = function(opt_start, opt_step) {
  var counter = opt_start || 0, step = void 0 !== opt_step ? opt_step : 1, iter = new goog.iter.Iterator;
  iter.next = function() {
    var returnValue = counter;
    counter += step;
    return returnValue;
  };
  return iter;
};
goog.iter.repeat = function(value) {
  var iter = new goog.iter.Iterator;
  iter.next = goog.functions.constant(value);
  return iter;
};
goog.iter.accumulate = function(iterable) {
  var iterator = goog.iter.toIterator(iterable), total = 0, iter = new goog.iter.Iterator;
  iter.next = function() {
    return total += iterator.next();
  };
  return iter;
};
goog.iter.zip = function(var_args) {
  var args = arguments, iter = new goog.iter.Iterator;
  if (0 < args.length) {
    var iterators = goog.array.map(args, goog.iter.toIterator);
    iter.next = function() {
      return goog.array.map(iterators, function(it) {
        return it.next();
      });
    };
  }
  return iter;
};
goog.iter.zipLongest = function(fillValue, var_args) {
  var args = goog.array.slice(arguments, 1), iter = new goog.iter.Iterator;
  if (0 < args.length) {
    var iterators = goog.array.map(args, goog.iter.toIterator);
    iter.next = function() {
      var iteratorsHaveValues = !1, arr = goog.array.map(iterators, function(it) {
        try {
          var returnValue = it.next();
          iteratorsHaveValues = !0;
        } catch (ex) {
          if (ex !== goog.iter.StopIteration) {
            throw ex;
          }
          returnValue = fillValue;
        }
        return returnValue;
      });
      if (!iteratorsHaveValues) {
        throw goog.iter.StopIteration;
      }
      return arr;
    };
  }
  return iter;
};
goog.iter.compress = function(iterable, selectors) {
  var selectorIterator = goog.iter.toIterator(selectors);
  return goog.iter.filter(iterable, function() {
    return !!selectorIterator.next();
  });
};
goog.iter.GroupByIterator_ = function(iterable, opt_keyFunc) {
  this.iterator = goog.iter.toIterator(iterable);
  this.keyFunc = opt_keyFunc || goog.functions.identity;
};
goog.inherits(goog.iter.GroupByIterator_, goog.iter.Iterator);
goog.iter.GroupByIterator_.prototype.next = function() {
  for (; this.currentKey == this.targetKey;) {
    this.currentValue = this.iterator.next(), this.currentKey = this.keyFunc(this.currentValue);
  }
  this.targetKey = this.currentKey;
  return [this.currentKey, this.groupItems_(this.targetKey)];
};
goog.iter.GroupByIterator_.prototype.groupItems_ = function(targetKey) {
  for (var arr = []; this.currentKey == targetKey;) {
    arr.push(this.currentValue);
    try {
      this.currentValue = this.iterator.next();
    } catch (ex) {
      if (ex !== goog.iter.StopIteration) {
        throw ex;
      }
      break;
    }
    this.currentKey = this.keyFunc(this.currentValue);
  }
  return arr;
};
goog.iter.groupBy = function(iterable, opt_keyFunc) {
  return new goog.iter.GroupByIterator_(iterable, opt_keyFunc);
};
goog.iter.starMap = function(iterable, f, opt_obj) {
  var iterator = goog.iter.toIterator(iterable), iter = new goog.iter.Iterator;
  iter.next = function() {
    var args = goog.iter.toArray(iterator.next());
    return f.apply(opt_obj, goog.array.concat(args, void 0, iterator));
  };
  return iter;
};
goog.iter.tee = function(iterable, opt_num) {
  var iterator = goog.iter.toIterator(iterable), buffers = goog.array.map(goog.array.range("number" === typeof opt_num ? opt_num : 2), function() {
    return [];
  }), addNextIteratorValueToBuffers = function() {
    var val = iterator.next();
    goog.array.forEach(buffers, function(buffer) {
      buffer.push(val);
    });
  };
  return goog.array.map(buffers, function(buffer) {
    var iter = new goog.iter.Iterator;
    iter.next = function() {
      goog.array.isEmpty(buffer) && addNextIteratorValueToBuffers();
      goog.asserts.assert(!goog.array.isEmpty(buffer));
      return buffer.shift();
    };
    return iter;
  });
};
goog.iter.enumerate = function(iterable, opt_start) {
  return goog.iter.zip(goog.iter.count(opt_start), iterable);
};
goog.iter.limit = function(iterable, limitSize) {
  goog.asserts.assert(goog.math.isInt(limitSize) && 0 <= limitSize);
  var iterator = goog.iter.toIterator(iterable), iter = new goog.iter.Iterator, remaining = limitSize;
  iter.next = function() {
    if (0 < remaining--) {
      return iterator.next();
    }
    throw goog.iter.StopIteration;
  };
  return iter;
};
goog.iter.consume = function(iterable, count) {
  goog.asserts.assert(goog.math.isInt(count) && 0 <= count);
  for (var iterator = goog.iter.toIterator(iterable); 0 < count--;) {
    goog.iter.nextOrValue(iterator, null);
  }
  return iterator;
};
goog.iter.slice = function(iterable, start, opt_end) {
  goog.asserts.assert(goog.math.isInt(start) && 0 <= start);
  var iterator = goog.iter.consume(iterable, start);
  "number" === typeof opt_end && (goog.asserts.assert(goog.math.isInt(opt_end) && opt_end >= start), iterator = goog.iter.limit(iterator, opt_end - start));
  return iterator;
};
goog.iter.hasDuplicates_ = function(arr) {
  var deduped = [];
  goog.array.removeDuplicates(arr, deduped);
  return arr.length != deduped.length;
};
goog.iter.permutations = function(iterable, opt_length) {
  var elements = goog.iter.toArray(iterable), sets = goog.array.repeat(elements, "number" === typeof opt_length ? opt_length : elements.length), product = goog.iter.product.apply(void 0, sets);
  return goog.iter.filter(product, function(arr) {
    return !goog.iter.hasDuplicates_(arr);
  });
};
goog.iter.combinations = function(iterable, length) {
  function getIndexFromElements(index) {
    return elements[index];
  }
  var elements = goog.iter.toArray(iterable), indexes = goog.iter.range(elements.length), indexIterator = goog.iter.permutations(indexes, length), sortedIndexIterator = goog.iter.filter(indexIterator, function(arr) {
    return goog.array.isSorted(arr);
  }), iter = new goog.iter.Iterator;
  iter.next = function() {
    return goog.array.map(sortedIndexIterator.next(), getIndexFromElements);
  };
  return iter;
};
goog.iter.combinationsWithReplacement = function(iterable, length) {
  function getIndexFromElements(index) {
    return elements[index];
  }
  var elements = goog.iter.toArray(iterable), indexes = goog.array.range(elements.length), sets = goog.array.repeat(indexes, length), indexIterator = goog.iter.product.apply(void 0, sets), sortedIndexIterator = goog.iter.filter(indexIterator, function(arr) {
    return goog.array.isSorted(arr);
  }), iter = new goog.iter.Iterator;
  iter.next = function() {
    return goog.array.map(sortedIndexIterator.next(), getIndexFromElements);
  };
  return iter;
};
goog.structs.Map = function(opt_map, var_args) {
  this.map_ = {};
  this.keys_ = [];
  this.version_ = this.count_ = 0;
  var argLength = arguments.length;
  if (1 < argLength) {
    if (argLength % 2) {
      throw Error("Uneven number of arguments");
    }
    for (var i = 0; i < argLength; i += 2) {
      this.set(arguments[i], arguments[i + 1]);
    }
  } else {
    opt_map && this.addAll(opt_map);
  }
};
goog.structs.Map.prototype.getCount = function() {
  return this.count_;
};
goog.structs.Map.prototype.getValues = function() {
  this.cleanupKeysArray_();
  for (var rv = [], i = 0; i < this.keys_.length; i++) {
    rv.push(this.map_[this.keys_[i]]);
  }
  return rv;
};
goog.structs.Map.prototype.getKeys = function() {
  this.cleanupKeysArray_();
  return this.keys_.concat();
};
goog.structs.Map.prototype.containsKey = function(key) {
  return goog.structs.Map.hasKey_(this.map_, key);
};
goog.structs.Map.prototype.containsValue = function(val) {
  for (var i = 0; i < this.keys_.length; i++) {
    var key = this.keys_[i];
    if (goog.structs.Map.hasKey_(this.map_, key) && this.map_[key] == val) {
      return !0;
    }
  }
  return !1;
};
goog.structs.Map.prototype.equals = function(otherMap, opt_equalityFn) {
  if (this === otherMap) {
    return !0;
  }
  if (this.count_ != otherMap.getCount()) {
    return !1;
  }
  var equalityFn = opt_equalityFn || goog.structs.Map.defaultEquals;
  this.cleanupKeysArray_();
  for (var key, i = 0; key = this.keys_[i]; i++) {
    if (!equalityFn(this.get(key), otherMap.get(key))) {
      return !1;
    }
  }
  return !0;
};
goog.structs.Map.defaultEquals = function(a, b) {
  return a === b;
};
goog.structs.Map.prototype.isEmpty = function() {
  return 0 == this.count_;
};
goog.structs.Map.prototype.clear = function() {
  this.map_ = {};
  this.version_ = this.count_ = this.keys_.length = 0;
};
goog.structs.Map.prototype.remove = function(key) {
  return goog.structs.Map.hasKey_(this.map_, key) ? (delete this.map_[key], this.count_--, this.version_++, this.keys_.length > 2 * this.count_ && this.cleanupKeysArray_(), !0) : !1;
};
goog.structs.Map.prototype.cleanupKeysArray_ = function() {
  if (this.count_ != this.keys_.length) {
    for (var srcIndex = 0, destIndex = 0; srcIndex < this.keys_.length;) {
      var key = this.keys_[srcIndex];
      goog.structs.Map.hasKey_(this.map_, key) && (this.keys_[destIndex++] = key);
      srcIndex++;
    }
    this.keys_.length = destIndex;
  }
  if (this.count_ != this.keys_.length) {
    var seen = {};
    for (destIndex = srcIndex = 0; srcIndex < this.keys_.length;) {
      key = this.keys_[srcIndex], goog.structs.Map.hasKey_(seen, key) || (this.keys_[destIndex++] = key, seen[key] = 1), srcIndex++;
    }
    this.keys_.length = destIndex;
  }
};
goog.structs.Map.prototype.get = function(key, opt_val) {
  return goog.structs.Map.hasKey_(this.map_, key) ? this.map_[key] : opt_val;
};
goog.structs.Map.prototype.set = function(key, value) {
  goog.structs.Map.hasKey_(this.map_, key) || (this.count_++, this.keys_.push(key), this.version_++);
  this.map_[key] = value;
};
goog.structs.Map.prototype.addAll = function(map) {
  if (map instanceof goog.structs.Map) {
    for (var keys = map.getKeys(), i = 0; i < keys.length; i++) {
      this.set(keys[i], map.get(keys[i]));
    }
  } else {
    for (var key in map) {
      this.set(key, map[key]);
    }
  }
};
goog.structs.Map.prototype.forEach = function(f, opt_obj) {
  for (var keys = this.getKeys(), i = 0; i < keys.length; i++) {
    var key = keys[i], value = this.get(key);
    f.call(opt_obj, value, key, this);
  }
};
goog.structs.Map.prototype.clone = function() {
  return new goog.structs.Map(this);
};
goog.structs.Map.prototype.transpose = function() {
  for (var transposed = new goog.structs.Map, i = 0; i < this.keys_.length; i++) {
    var key = this.keys_[i];
    transposed.set(this.map_[key], key);
  }
  return transposed;
};
goog.structs.Map.prototype.toObject = function() {
  this.cleanupKeysArray_();
  for (var obj = {}, i = 0; i < this.keys_.length; i++) {
    var key = this.keys_[i];
    obj[key] = this.map_[key];
  }
  return obj;
};
goog.structs.Map.prototype.getKeyIterator = function() {
  return this.__iterator__(!0);
};
goog.structs.Map.prototype.getValueIterator = function() {
  return this.__iterator__(!1);
};
goog.structs.Map.prototype.__iterator__ = function(opt_keys) {
  this.cleanupKeysArray_();
  var i = 0, version = this.version_, selfObj = this, newIter = new goog.iter.Iterator;
  newIter.next = function() {
    if (version != selfObj.version_) {
      throw Error("The map has changed since the iterator was created");
    }
    if (i >= selfObj.keys_.length) {
      throw goog.iter.StopIteration;
    }
    var key = selfObj.keys_[i++];
    return opt_keys ? key : selfObj.map_[key];
  };
  return newIter;
};
goog.structs.Map.hasKey_ = function(obj, key) {
  return Object.prototype.hasOwnProperty.call(obj, key);
};
goog.structs.getCount = function(col) {
  return col.getCount && "function" == typeof col.getCount ? col.getCount() : goog.isArrayLike(col) || "string" === typeof col ? col.length : goog.object.getCount(col);
};
goog.structs.getValues = function(col) {
  if (col.getValues && "function" == typeof col.getValues) {
    return col.getValues();
  }
  if ("string" === typeof col) {
    return col.split("");
  }
  if (goog.isArrayLike(col)) {
    for (var rv = [], l = col.length, i = 0; i < l; i++) {
      rv.push(col[i]);
    }
    return rv;
  }
  return goog.object.getValues(col);
};
goog.structs.getKeys = function(col) {
  if (col.getKeys && "function" == typeof col.getKeys) {
    return col.getKeys();
  }
  if (!col.getValues || "function" != typeof col.getValues) {
    if (goog.isArrayLike(col) || "string" === typeof col) {
      for (var rv = [], l = col.length, i = 0; i < l; i++) {
        rv.push(i);
      }
      return rv;
    }
    return goog.object.getKeys(col);
  }
};
goog.structs.contains = function(col, val) {
  return col.contains && "function" == typeof col.contains ? col.contains(val) : col.containsValue && "function" == typeof col.containsValue ? col.containsValue(val) : goog.isArrayLike(col) || "string" === typeof col ? goog.array.contains(col, val) : goog.object.containsValue(col, val);
};
goog.structs.isEmpty = function(col) {
  return col.isEmpty && "function" == typeof col.isEmpty ? col.isEmpty() : goog.isArrayLike(col) || "string" === typeof col ? goog.array.isEmpty(col) : goog.object.isEmpty(col);
};
goog.structs.clear = function(col) {
  col.clear && "function" == typeof col.clear ? col.clear() : goog.isArrayLike(col) ? goog.array.clear(col) : goog.object.clear(col);
};
goog.structs.forEach = function(col, f, opt_obj) {
  if (col.forEach && "function" == typeof col.forEach) {
    col.forEach(f, opt_obj);
  } else {
    if (goog.isArrayLike(col) || "string" === typeof col) {
      goog.array.forEach(col, f, opt_obj);
    } else {
      for (var keys = goog.structs.getKeys(col), values = goog.structs.getValues(col), l = values.length, i = 0; i < l; i++) {
        f.call(opt_obj, values[i], keys && keys[i], col);
      }
    }
  }
};
goog.structs.filter = function(col, f, opt_obj) {
  if ("function" == typeof col.filter) {
    return col.filter(f, opt_obj);
  }
  if (goog.isArrayLike(col) || "string" === typeof col) {
    return goog.array.filter(col, f, opt_obj);
  }
  var keys = goog.structs.getKeys(col), values = goog.structs.getValues(col), l = values.length;
  if (keys) {
    var rv = {};
    for (var i = 0; i < l; i++) {
      f.call(opt_obj, values[i], keys[i], col) && (rv[keys[i]] = values[i]);
    }
  } else {
    for (rv = [], i = 0; i < l; i++) {
      f.call(opt_obj, values[i], void 0, col) && rv.push(values[i]);
    }
  }
  return rv;
};
goog.structs.map = function(col, f, opt_obj) {
  if ("function" == typeof col.map) {
    return col.map(f, opt_obj);
  }
  if (goog.isArrayLike(col) || "string" === typeof col) {
    return goog.array.map(col, f, opt_obj);
  }
  var keys = goog.structs.getKeys(col), values = goog.structs.getValues(col), l = values.length;
  if (keys) {
    var rv = {};
    for (var i = 0; i < l; i++) {
      rv[keys[i]] = f.call(opt_obj, values[i], keys[i], col);
    }
  } else {
    for (rv = [], i = 0; i < l; i++) {
      rv[i] = f.call(opt_obj, values[i], void 0, col);
    }
  }
  return rv;
};
goog.structs.some = function(col, f, opt_obj) {
  if ("function" == typeof col.some) {
    return col.some(f, opt_obj);
  }
  if (goog.isArrayLike(col) || "string" === typeof col) {
    return goog.array.some(col, f, opt_obj);
  }
  for (var keys = goog.structs.getKeys(col), values = goog.structs.getValues(col), l = values.length, i = 0; i < l; i++) {
    if (f.call(opt_obj, values[i], keys && keys[i], col)) {
      return !0;
    }
  }
  return !1;
};
goog.structs.every = function(col, f, opt_obj) {
  if ("function" == typeof col.every) {
    return col.every(f, opt_obj);
  }
  if (goog.isArrayLike(col) || "string" === typeof col) {
    return goog.array.every(col, f, opt_obj);
  }
  for (var keys = goog.structs.getKeys(col), values = goog.structs.getValues(col), l = values.length, i = 0; i < l; i++) {
    if (!f.call(opt_obj, values[i], keys && keys[i], col)) {
      return !1;
    }
  }
  return !0;
};
goog.structs.Set = function(opt_values) {
  this.map_ = new goog.structs.Map;
  opt_values && this.addAll(opt_values);
};
goog.structs.Set.getUid_ = goog.getUid;
goog.structs.Set.getKey_ = function(val) {
  var type = typeof val;
  return "object" == type && val || "function" == type ? "o" + goog.structs.Set.getUid_(val) : type.substr(0, 1) + val;
};
goog.structs.Set.prototype.getCount = function() {
  return this.map_.getCount();
};
goog.structs.Set.prototype.add = function(element) {
  this.map_.set(goog.structs.Set.getKey_(element), element);
};
goog.structs.Set.prototype.addAll = function(col) {
  for (var values = goog.structs.getValues(col), l = values.length, i = 0; i < l; i++) {
    this.add(values[i]);
  }
};
goog.structs.Set.prototype.removeAll = function(col) {
  for (var values = goog.structs.getValues(col), l = values.length, i = 0; i < l; i++) {
    this.remove(values[i]);
  }
};
goog.structs.Set.prototype.remove = function(element) {
  return this.map_.remove(goog.structs.Set.getKey_(element));
};
goog.structs.Set.prototype.clear = function() {
  this.map_.clear();
};
goog.structs.Set.prototype.isEmpty = function() {
  return this.map_.isEmpty();
};
goog.structs.Set.prototype.contains = function(element) {
  return this.map_.containsKey(goog.structs.Set.getKey_(element));
};
goog.structs.Set.prototype.containsAll = function(col) {
  return goog.structs.every(col, this.contains, this);
};
goog.structs.Set.prototype.intersection = function(col) {
  for (var result = new goog.structs.Set, values = goog.structs.getValues(col), i = 0; i < values.length; i++) {
    var value = values[i];
    this.contains(value) && result.add(value);
  }
  return result;
};
goog.structs.Set.prototype.difference = function(col) {
  var result = this.clone();
  result.removeAll(col);
  return result;
};
goog.structs.Set.prototype.getValues = function() {
  return this.map_.getValues();
};
goog.structs.Set.prototype.clone = function() {
  return new goog.structs.Set(this);
};
goog.structs.Set.prototype.equals = function(col) {
  return this.getCount() == goog.structs.getCount(col) && this.isSubsetOf(col);
};
goog.structs.Set.prototype.isSubsetOf = function(col) {
  var colCount = goog.structs.getCount(col);
  if (this.getCount() > colCount) {
    return !1;
  }
  !(col instanceof goog.structs.Set) && 5 < colCount && (col = new goog.structs.Set(col));
  return goog.structs.every(this, function(value) {
    return goog.structs.contains(col, value);
  });
};
goog.structs.Set.prototype.__iterator__ = function(opt_keys) {
  return this.map_.__iterator__(!1);
};
var ee = {AbstractOverlay:function(url, mapId, token, opt_init, opt_profiler) {
  goog.events.EventTarget.call(this);
  this.mapId = mapId;
  this.token = token;
  this.tilesLoading = [];
  this.tilesFailed = new goog.structs.Set;
  this.tileCounter = 0;
  this.url = url;
}};
goog.inherits(ee.AbstractOverlay, goog.events.EventTarget);
ee.AbstractOverlay.EventType = {TILE_LOADED:"tileevent"};
ee.AbstractOverlay.prototype.getTileId = function(coord, zoom) {
  var maxCoord = 1 << zoom, x = coord.x % maxCoord;
  0 > x && (x += maxCoord);
  return [this.mapId, zoom, x, coord.y].join("/");
};
ee.AbstractOverlay.prototype.getLoadingTilesCount = function() {
  return this.tilesLoading.length;
};
ee.AbstractOverlay.prototype.getFailedTilesCount = function() {
  return this.tilesFailed.getCount();
};
ee.TileEvent = function(count) {
  goog.events.Event.call(this, ee.AbstractOverlay.EventType.TILE_LOADED);
  this.count = count;
};
goog.inherits(ee.TileEvent, goog.events.Event);
var module$exports$tslib = {}, module$contents$tslib_extendStatics = Object.setPrototypeOf || {__proto__:[]} instanceof Array && function(d, b) {
  d.__proto__ = b;
} || function(d, b) {
  for (var p in b) {
    b.hasOwnProperty(p) && (d[p] = b[p]);
  }
};
module$exports$tslib.__extends = function(d, b) {
  function __() {
    this.constructor = d;
  }
  module$contents$tslib_extendStatics(d, b);
  d.prototype = null === b ? Object.create(b) : (__.prototype = b.prototype, new __);
};
module$exports$tslib.__assign = Object.assign || function(t) {
  for (var s, i = 1, n = arguments.length; i < n; i++) {
    s = arguments[i];
    for (var p in s) {
      Object.prototype.hasOwnProperty.call(s, p) && (t[p] = s[p]);
    }
  }
  return t;
};
module$exports$tslib.__rest = function(s, e) {
  var t = {}, p;
  for (p in s) {
    Object.prototype.hasOwnProperty.call(s, p) && 0 > e.indexOf(p) && (t[p] = s[p]);
  }
  if (null != s && "function" === typeof Object.getOwnPropertySymbols) {
    var i = 0;
    for (p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
      0 > e.indexOf(p[i]) && (t[p[i]] = s[p[i]]);
    }
  }
  return t;
};
module$exports$tslib.__decorate = function(decorators, target, key, desc) {
  var c = arguments.length, r = 3 > c ? target : null === desc ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
  if ("object" === typeof Reflect && Reflect && "function" === typeof Reflect.decorate) {
    r = Reflect.decorate(decorators, target, key, desc);
  } else {
    for (var i = decorators.length - 1; 0 <= i; i--) {
      if (d = decorators[i]) {
        r = (3 > c ? d(r) : 3 < c ? d(target, key, r) : d(target, key)) || r;
      }
    }
  }
  return 3 < c && r && Object.defineProperty(target, key, r), r;
};
module$exports$tslib.__metadata = function(metadataKey, metadataValue) {
  if ("object" === typeof Reflect && Reflect && "function" === typeof Reflect.metadata) {
    return Reflect.metadata(metadataKey, metadataValue);
  }
};
module$exports$tslib.__param = function(paramIndex, decorator) {
  return function(target, key) {
    decorator(target, key, paramIndex);
  };
};
module$exports$tslib.__awaiter = function(thisArg, _arguments, P, generator) {
  return new (P || (P = Promise))(function(resolve$jscomp$0, reject) {
    function fulfilled(value) {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    }
    function rejected(value) {
      try {
        step(generator["throw"](value));
      } catch (e) {
        reject(e);
      }
    }
    function step(result) {
      result.done ? resolve$jscomp$0(result.value) : (new P(function(resolve) {
        resolve(result.value);
      })).then(fulfilled, rejected);
    }
    step((generator = generator.apply(thisArg, _arguments)).next());
  });
};
module$exports$tslib.__generator = function(thisArg, body) {
  function verb(n) {
    return function(v) {
      return step([n, v]);
    };
  }
  function step(op) {
    if (f) {
      throw new TypeError("Generator is already executing.");
    }
    for (; _;) {
      try {
        if (f = 1, y && (t = y[op[0] & 2 ? "return" : op[0] ? "throw" : "next"]) && !(t = t.call(y, op[1])).done) {
          return t;
        }
        if (y = 0, t) {
          op = [0, t.value];
        }
        switch(op[0]) {
          case 0:
          case 1:
            t = op;
            break;
          case 4:
            return _.label++, {value:op[1], done:!1};
          case 5:
            _.label++;
            y = op[1];
            op = [0];
            continue;
          case 7:
            op = _.ops.pop();
            _.trys.pop();
            continue;
          default:
            if (!(t = _.trys, t = 0 < t.length && t[t.length - 1]) && (6 === op[0] || 2 === op[0])) {
              _ = 0;
              continue;
            }
            if (3 === op[0] && (!t || op[1] > t[0] && op[1] < t[3])) {
              _.label = op[1];
            } else {
              if (6 === op[0] && _.label < t[1]) {
                _.label = t[1], t = op;
              } else {
                if (t && _.label < t[2]) {
                  _.label = t[2], _.ops.push(op);
                } else {
                  t[2] && _.ops.pop();
                  _.trys.pop();
                  continue;
                }
              }
            }
        }
        op = body.call(thisArg, _);
      } catch (e) {
        op = [6, e], y = 0;
      } finally {
        f = t = 0;
      }
    }
    if (op[0] & 5) {
      throw op[1];
    }
    return {value:op[0] ? op[1] : void 0, done:!0};
  }
  var _ = {label:0, sent:function() {
    if (t[0] & 1) {
      throw t[1];
    }
    return t[1];
  }, trys:[], ops:[]}, f, y, t, g;
  return g = {next:verb(0), "throw":verb(1), "return":verb(2)}, "function" === typeof Symbol && (g[Symbol.iterator] = function() {
    return g;
  }), g;
};
module$exports$tslib.__exportStar = function(m, e) {
  for (var p in m) {
    e.hasOwnProperty(p) || (e[p] = m[p]);
  }
};
module$exports$tslib.__values = function(o) {
  var m = "function" === typeof Symbol && o[Symbol.iterator], i = 0;
  return m ? m.call(o) : {next:function() {
    o && i >= o.length && (o = void 0);
    return {value:o && o[i++], done:!o};
  }};
};
module$exports$tslib.__read = function(o, n) {
  var m = "function" === typeof Symbol && o[Symbol.iterator];
  if (!m) {
    return o;
  }
  var i = m.call(o), r, ar = [];
  try {
    for (; (void 0 === n || 0 < n--) && !(r = i.next()).done;) {
      ar.push(r.value);
    }
  } catch (error) {
    var e = {error:error};
  } finally {
    try {
      r && !r.done && (m = i["return"]) && m.call(i);
    } finally {
      if (e) {
        throw e.error;
      }
    }
  }
  return ar;
};
module$exports$tslib.__spread = function() {
  for (var ar = [], i = 0; i < arguments.length; i++) {
    ar = ar.concat(module$exports$tslib.__read(arguments[i]));
  }
  return ar;
};
module$exports$tslib.__await = function(v) {
  return this instanceof module$exports$tslib.__await ? (this.v = v, this) : new module$exports$tslib.__await(v);
};
module$exports$tslib.__asyncGenerator = function __asyncGenerator(thisArg, _arguments, generator) {
  function verb(n) {
    g[n] && (i[n] = function(v) {
      return new Promise(function(a, b) {
        1 < q.push([n, v, a, b]) || resume(n, v);
      });
    });
  }
  function resume(n, v) {
    try {
      step(g[n](v));
    } catch (e) {
      settle(q[0][3], e);
    }
  }
  function step(r) {
    r.value instanceof module$exports$tslib.__await ? Promise.resolve(r.value.v).then(fulfill, reject) : settle(q[0][2], r);
  }
  function fulfill(value) {
    resume("next", value);
  }
  function reject(value) {
    resume("throw", value);
  }
  function settle(f, v) {
    (f(v), q.shift(), q.length) && resume(q[0][0], q[0][1]);
  }
  if (!Symbol.asyncIterator) {
    throw new TypeError("Symbol.asyncIterator is not defined.");
  }
  var g = generator.apply(thisArg, _arguments || []), i, q = [];
  return i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function() {
    return this;
  }, i;
};
module$exports$tslib.__asyncDelegator = function(o) {
  function verb(n, f) {
    o[n] && (i[n] = function(v) {
      return (p = !p) ? {value:new module$exports$tslib.__await(o[n](v)), done:"return" === n} : f ? f(v) : v;
    });
  }
  var i, p;
  return i = {}, verb("next"), verb("throw", function(e) {
    throw e;
  }), verb("return"), i[Symbol.iterator] = function() {
    return i;
  }, i;
};
module$exports$tslib.__asyncValues = function(o) {
  if (!Symbol.asyncIterator) {
    throw new TypeError("Symbol.asyncIterator is not defined.");
  }
  var m = o[Symbol.asyncIterator];
  return m ? m.call(o) : "function" === typeof __values ? __values(o) : o[Symbol.iterator]();
};
module$exports$tslib.__makeTemplateObject = function(cooked, raw) {
  Object.defineProperty ? Object.defineProperty(cooked, "raw", {value:raw}) : cooked.raw = raw;
  return cooked;
};
module$exports$tslib.__classPrivateFieldGet = function(receiver, privateMap) {
  if (!privateMap.has(receiver)) {
    throw new TypeError("attempted to get private field on non-instance");
  }
  return privateMap.get(receiver);
};
module$exports$tslib.__classPrivateFieldSet = function(receiver, privateMap, value) {
  if (!privateMap.has(receiver)) {
    throw new TypeError("attempted to set private field on non-instance");
  }
  privateMap.set(receiver, value);
  return value;
};
var module$exports$eeapiclient$domain_object = {}, module$contents$eeapiclient$domain_object_module = module$contents$eeapiclient$domain_object_module || {id:"javascript/typescript/contrib/apiclient/core/domain_object.closure.js"};
module$exports$eeapiclient$domain_object.ObjectMapMetadata = function module$contents$eeapiclient$domain_object_ObjectMapMetadata() {
};
module$exports$eeapiclient$domain_object.ClassMetadata = function module$contents$eeapiclient$domain_object_ClassMetadata() {
};
var module$contents$eeapiclient$domain_object_NullClass = function() {
};
module$exports$eeapiclient$domain_object.NULL_VALUE = new module$contents$eeapiclient$domain_object_NullClass;
module$exports$eeapiclient$domain_object.ISerializable = function module$contents$eeapiclient$domain_object_ISerializable() {
};
function module$contents$eeapiclient$domain_object_buildClassMetadataFromPartial(partialClassMetadata) {
  return Object.assign({arrays:{}, descriptions:{}, keys:[], objectMaps:{}, objects:{}, enums:{}}, partialClassMetadata);
}
module$exports$eeapiclient$domain_object.buildClassMetadataFromPartial = module$contents$eeapiclient$domain_object_buildClassMetadataFromPartial;
module$exports$eeapiclient$domain_object.Serializable = function() {
  this.Serializable$values = {};
};
module$exports$eeapiclient$domain_object.Serializable.prototype.getClassMetadata = function() {
  return module$contents$eeapiclient$domain_object_buildClassMetadataFromPartial(this.getPartialClassMetadata());
};
module$exports$eeapiclient$domain_object.Serializable.prototype.Serializable$get = function(key) {
  return this.Serializable$values.hasOwnProperty(key) ? this.Serializable$values[key] : null;
};
module$exports$eeapiclient$domain_object.Serializable.prototype.Serializable$set = function(key, value) {
  this.Serializable$values[key] = value;
};
module$exports$eeapiclient$domain_object.Serializable.prototype.Serializable$has = function(key) {
  return null != this.Serializable$values[key];
};
module$exports$eeapiclient$domain_object.SerializableCtor = function module$contents$eeapiclient$domain_object_SerializableCtor() {
};
module$exports$eeapiclient$domain_object.clone = function module$contents$eeapiclient$domain_object_clone(serializable) {
  return module$contents$eeapiclient$domain_object_deserialize(serializable.getConstructor(), module$contents$eeapiclient$domain_object_serialize(serializable));
};
module$exports$eeapiclient$domain_object.isEmpty = function module$contents$eeapiclient$domain_object_isEmpty(serializable) {
  return !Object.keys(module$contents$eeapiclient$domain_object_serialize(serializable)).length;
};
function module$contents$eeapiclient$domain_object_serialize(serializable) {
  return module$contents$eeapiclient$domain_object_deepCopy(serializable, module$contents$eeapiclient$domain_object_serializeGetter, module$contents$eeapiclient$domain_object_serializeSetter, module$contents$eeapiclient$domain_object_serializeInstanciator);
}
module$exports$eeapiclient$domain_object.serialize = module$contents$eeapiclient$domain_object_serialize;
function module$contents$eeapiclient$domain_object_serializeGetter(key, obj) {
  return obj.Serializable$get(key);
}
function module$contents$eeapiclient$domain_object_serializeSetter(key, obj, value) {
  obj[key] = value;
}
function module$contents$eeapiclient$domain_object_serializeInstanciator(ctor) {
  return {};
}
function module$contents$eeapiclient$domain_object_deserialize(type, raw) {
  var result = new type;
  return null == raw ? result : module$contents$eeapiclient$domain_object_deepCopy(raw, module$contents$eeapiclient$domain_object_deserializeGetter, module$contents$eeapiclient$domain_object_deserializeSetter, module$contents$eeapiclient$domain_object_deserializeInstanciator, type);
}
module$exports$eeapiclient$domain_object.deserialize = module$contents$eeapiclient$domain_object_deserialize;
function module$contents$eeapiclient$domain_object_deserializeGetter(key, obj) {
  return obj[key];
}
function module$contents$eeapiclient$domain_object_deserializeSetter(key, obj, value) {
  obj.Serializable$set(key, value);
}
function module$contents$eeapiclient$domain_object_deserializeInstanciator(ctor) {
  if (null == ctor) {
    throw Error("Cannot deserialize, target constructor was null.");
  }
  return new ctor;
}
var module$contents$eeapiclient$domain_object_CopyValueGetter, module$contents$eeapiclient$domain_object_CopyValueSetter, module$contents$eeapiclient$domain_object_CopyConstructor, module$contents$eeapiclient$domain_object_CopyInstanciator;
function module$contents$eeapiclient$domain_object_deepCopy(source, valueGetter, valueSetter, copyInstanciator, targetConstructor) {
  for (var target = copyInstanciator(targetConstructor), metadata = module$contents$eeapiclient$domain_object_deepCopyMetadata(source, target), arrays = metadata.arrays || {}, objects = metadata.objects || {}, objectMaps = metadata.objectMaps || {}, $jscomp$loop$33 = {}, $jscomp$iter$4 = $jscomp.makeIterator(metadata.keys || []), $jscomp$key$key = $jscomp$iter$4.next(); !$jscomp$key$key.done; $jscomp$loop$33 = {$jscomp$loop$prop$mapMetadata$34:$jscomp$loop$33.$jscomp$loop$prop$mapMetadata$34}, 
  $jscomp$key$key = $jscomp$iter$4.next()) {
    var key = $jscomp$key$key.value, value = valueGetter(key, source);
    if (null != value) {
      var copy = void 0;
      arrays.hasOwnProperty(key) ? copy = module$contents$eeapiclient$domain_object_deepCopyValue(value, valueGetter, valueSetter, copyInstanciator, !0, !0, arrays[key]) : objects.hasOwnProperty(key) ? copy = module$contents$eeapiclient$domain_object_deepCopyValue(value, valueGetter, valueSetter, copyInstanciator, !1, !0, objects[key]) : objectMaps.hasOwnProperty(key) ? ($jscomp$loop$33.$jscomp$loop$prop$mapMetadata$34 = 
      objectMaps[key], copy = $jscomp$loop$33.$jscomp$loop$prop$mapMetadata$34.isPropertyArray ? value.map(function($jscomp$loop$33) {
        return function(v) {
          return module$contents$eeapiclient$domain_object_deepCopyObjectMap(v, $jscomp$loop$33.$jscomp$loop$prop$mapMetadata$34, valueGetter, valueSetter, copyInstanciator);
        };
      }($jscomp$loop$33)) : module$contents$eeapiclient$domain_object_deepCopyObjectMap(value, $jscomp$loop$33.$jscomp$loop$prop$mapMetadata$34, valueGetter, valueSetter, copyInstanciator)) : copy = Array.isArray(value) ? module$contents$eeapiclient$domain_object_deepCopyValue(value, valueGetter, valueSetter, copyInstanciator, !0, !1) : value instanceof module$contents$eeapiclient$domain_object_NullClass ? 
      null : value;
      valueSetter(key, target, copy);
    }
  }
  return target;
}
function module$contents$eeapiclient$domain_object_deepCopyObjectMap(value, mapMetadata, valueGetter, valueSetter, copyInstanciator) {
  for (var objMap = {}, $jscomp$iter$5 = $jscomp.makeIterator(Object.keys(value)), $jscomp$key$mapKey = $jscomp$iter$5.next(); !$jscomp$key$mapKey.done; $jscomp$key$mapKey = $jscomp$iter$5.next()) {
    var mapKey = $jscomp$key$mapKey.value, mapValue = value[mapKey];
    null != mapValue && (objMap[mapKey] = module$contents$eeapiclient$domain_object_deepCopyValue(mapValue, valueGetter, valueSetter, copyInstanciator, mapMetadata.isValueArray, mapMetadata.isSerializable, mapMetadata.ctor));
  }
  return objMap;
}
function module$contents$eeapiclient$domain_object_deepCopyValue(value, valueGetter, valueSetter, copyInstanciator, isArray, isRef, ctor) {
  if (isRef && null == ctor) {
    throw Error("Cannot deserialize a reference object without a constructor.");
  }
  return null == value ? value : isArray && isRef ? value.map(function(v) {
    return module$contents$eeapiclient$domain_object_deepCopy(v, valueGetter, valueSetter, copyInstanciator, ctor);
  }) : isArray && !isRef ? value.map(function(v) {
    return v;
  }) : !isArray && isRef ? module$contents$eeapiclient$domain_object_deepCopy(value, valueGetter, valueSetter, copyInstanciator, ctor) : value instanceof module$contents$eeapiclient$domain_object_NullClass ? null : "object" === typeof value ? JSON.parse(JSON.stringify(value)) : value;
}
function module$contents$eeapiclient$domain_object_deepCopyMetadata(source, target) {
  if (target instanceof module$exports$eeapiclient$domain_object.Serializable) {
    var metadata = target.getClassMetadata();
  } else {
    if (source instanceof module$exports$eeapiclient$domain_object.Serializable) {
      metadata = source.getClassMetadata();
    } else {
      throw Error("Cannot find ClassMetadata.");
    }
  }
  return metadata;
}
function module$contents$eeapiclient$domain_object_deepEquals(serializable1, serializable2) {
  var metadata1 = serializable1.getClassMetadata(), keys1 = metadata1.keys || [], arrays1 = metadata1.arrays || {}, objects1 = metadata1.objects || {}, objectMaps1 = metadata1.objectMaps || {}, metadata2 = serializable2.getClassMetadata(), arrays2 = metadata2.arrays || {}, objects2 = metadata2.objects || {}, objectMaps2 = metadata2.objectMaps || {};
  if (!(module$contents$eeapiclient$domain_object_sameKeys(keys1, metadata2.keys || []) && module$contents$eeapiclient$domain_object_sameKeys(arrays1, arrays2) && module$contents$eeapiclient$domain_object_sameKeys(objects1, objects2) && module$contents$eeapiclient$domain_object_sameKeys(objectMaps1, objectMaps2))) {
    return !1;
  }
  for (var $jscomp$loop$35 = {}, $jscomp$iter$6 = $jscomp.makeIterator(keys1), $jscomp$key$key = $jscomp$iter$6.next(); !$jscomp$key$key.done; $jscomp$loop$35 = {$jscomp$loop$prop$value2$36:$jscomp$loop$35.$jscomp$loop$prop$value2$36, $jscomp$loop$prop$mapMetadata$37:$jscomp$loop$35.$jscomp$loop$prop$mapMetadata$37}, $jscomp$key$key = $jscomp$iter$6.next()) {
    var key = $jscomp$key$key.value;
    if (serializable1.Serializable$has(key) !== serializable2.Serializable$has(key)) {
      return !1;
    }
    if (serializable1.Serializable$has(key)) {
      var value1 = serializable1.Serializable$get(key);
      $jscomp$loop$35.$jscomp$loop$prop$value2$36 = serializable2.Serializable$get(key);
      if (arrays1.hasOwnProperty(key)) {
        if (!module$contents$eeapiclient$domain_object_deepEqualsValue(value1, $jscomp$loop$35.$jscomp$loop$prop$value2$36, !0, !0)) {
          return !1;
        }
      } else {
        if (objects1.hasOwnProperty(key)) {
          if (!module$contents$eeapiclient$domain_object_deepEqualsValue(value1, $jscomp$loop$35.$jscomp$loop$prop$value2$36, !1, !0)) {
            return !1;
          }
        } else {
          if (objectMaps1.hasOwnProperty(key)) {
            if ($jscomp$loop$35.$jscomp$loop$prop$mapMetadata$37 = objectMaps1[key], $jscomp$loop$35.$jscomp$loop$prop$mapMetadata$37.isPropertyArray) {
              if (!module$contents$eeapiclient$domain_object_sameKeys(value1, $jscomp$loop$35.$jscomp$loop$prop$value2$36) || value1.some(function($jscomp$loop$35) {
                return function(v1, i) {
                  return !module$contents$eeapiclient$domain_object_deepEqualsObjectMap(v1, $jscomp$loop$35.$jscomp$loop$prop$value2$36[i], $jscomp$loop$35.$jscomp$loop$prop$mapMetadata$37);
                };
              }($jscomp$loop$35))) {
                return !1;
              }
            } else {
              if (!module$contents$eeapiclient$domain_object_deepEqualsObjectMap(value1, $jscomp$loop$35.$jscomp$loop$prop$value2$36, $jscomp$loop$35.$jscomp$loop$prop$mapMetadata$37)) {
                return !1;
              }
            }
          } else {
            if (Array.isArray(value1)) {
              if (!module$contents$eeapiclient$domain_object_deepEqualsValue(value1, $jscomp$loop$35.$jscomp$loop$prop$value2$36, !0, !1)) {
                return !1;
              }
            } else {
              if (!module$contents$eeapiclient$domain_object_deepEqualsValue(value1, $jscomp$loop$35.$jscomp$loop$prop$value2$36, !1, !1)) {
                return !1;
              }
            }
          }
        }
      }
    }
  }
  return !0;
}
module$exports$eeapiclient$domain_object.deepEquals = module$contents$eeapiclient$domain_object_deepEquals;
function module$contents$eeapiclient$domain_object_deepEqualsObjectMap(value1, value2, mapMetadata) {
  if (!module$contents$eeapiclient$domain_object_sameKeys(value1, value2)) {
    return !1;
  }
  for (var $jscomp$iter$7 = $jscomp.makeIterator(Object.keys(value1)), $jscomp$key$mapKey = $jscomp$iter$7.next(); !$jscomp$key$mapKey.done; $jscomp$key$mapKey = $jscomp$iter$7.next()) {
    var mapKey = $jscomp$key$mapKey.value;
    if (!module$contents$eeapiclient$domain_object_deepEqualsValue(value1[mapKey], value2[mapKey], mapMetadata.isValueArray, mapMetadata.isSerializable)) {
      return !1;
    }
  }
  return !0;
}
function module$contents$eeapiclient$domain_object_deepEqualsValue(value1, value2, isArray, isSerializable) {
  if (null == value1 && null == value2) {
    return !0;
  }
  if (isArray && isSerializable) {
    if (!module$contents$eeapiclient$domain_object_sameKeys(value1, value2) || value1.some(function(v1, i) {
      return !module$contents$eeapiclient$domain_object_deepEquals(v1, value2[i]);
    })) {
      return !1;
    }
  } else {
    if (isArray && !isSerializable) {
      if (!module$contents$eeapiclient$domain_object_sameKeys(value1, value2) || value1.some(function(v, i) {
        return v !== value2[i];
      })) {
        return !1;
      }
    } else {
      if ("object" === typeof value1) {
        if (JSON.stringify(value1) !== JSON.stringify(value2)) {
          return !1;
        }
      } else {
        if (value1 !== value2) {
          return !1;
        }
      }
    }
  }
  return !0;
}
function module$contents$eeapiclient$domain_object_sameKeys(a, b) {
  if (typeof a !== typeof b || Array.isArray(a) !== Array.isArray(b)) {
    throw Error("Types are not comparable.");
  }
  var aKeys = Object.keys(a), bKeys = Object.keys(b);
  if (aKeys.length !== bKeys.length) {
    return !1;
  }
  Array.isArray(a) || (aKeys.sort(), bKeys.sort());
  for (var i = 0; i < aKeys.length; i++) {
    if (aKeys[i] !== bKeys[i]) {
      return !1;
    }
  }
  return !0;
}
;goog.uri = {};
goog.uri.utils = {};
goog.uri.utils.CharCode_ = {AMPERSAND:38, EQUAL:61, HASH:35, QUESTION:63};
goog.uri.utils.buildFromEncodedParts = function(opt_scheme, opt_userInfo, opt_domain, opt_port, opt_path, opt_queryData, opt_fragment) {
  var out = "";
  opt_scheme && (out += opt_scheme + ":");
  opt_domain && (out += "//", opt_userInfo && (out += opt_userInfo + "@"), out += opt_domain, opt_port && (out += ":" + opt_port));
  opt_path && (out += opt_path);
  opt_queryData && (out += "?" + opt_queryData);
  opt_fragment && (out += "#" + opt_fragment);
  return out;
};
goog.uri.utils.splitRe_ = /^(?:([^:/?#.]+):)?(?:\/\/(?:([^\\/?#]*)@)?([^\\/?#]*?)(?::([0-9]+))?(?=[\\/?#]|$))?([^?#]+)?(?:\?([^#]*))?(?:#([\s\S]*))?$/;
goog.uri.utils.ComponentIndex = {SCHEME:1, USER_INFO:2, DOMAIN:3, PORT:4, PATH:5, QUERY_DATA:6, FRAGMENT:7};
goog.uri.utils.urlPackageSupportLoggingHandler_ = null;
goog.uri.utils.setUrlPackageSupportLoggingHandler = function(handler) {
  goog.uri.utils.urlPackageSupportLoggingHandler_ = handler;
};
goog.uri.utils.split = function(uri) {
  var result = uri.match(goog.uri.utils.splitRe_);
  goog.uri.utils.urlPackageSupportLoggingHandler_ && 0 <= ["http", "https", "ws", "wss", "ftp"].indexOf(result[goog.uri.utils.ComponentIndex.SCHEME]) && goog.uri.utils.urlPackageSupportLoggingHandler_(uri);
  return result;
};
goog.uri.utils.decodeIfPossible_ = function(uri, opt_preserveReserved) {
  return uri ? opt_preserveReserved ? decodeURI(uri) : decodeURIComponent(uri) : uri;
};
goog.uri.utils.getComponentByIndex_ = function(componentIndex, uri) {
  return goog.uri.utils.split(uri)[componentIndex] || null;
};
goog.uri.utils.getScheme = function(uri) {
  return goog.uri.utils.getComponentByIndex_(goog.uri.utils.ComponentIndex.SCHEME, uri);
};
goog.uri.utils.getEffectiveScheme = function(uri) {
  var scheme = goog.uri.utils.getScheme(uri);
  if (!scheme && goog.global.self && goog.global.self.location) {
    var protocol = goog.global.self.location.protocol;
    scheme = protocol.substr(0, protocol.length - 1);
  }
  return scheme ? scheme.toLowerCase() : "";
};
goog.uri.utils.getUserInfoEncoded = function(uri) {
  return goog.uri.utils.getComponentByIndex_(goog.uri.utils.ComponentIndex.USER_INFO, uri);
};
goog.uri.utils.getUserInfo = function(uri) {
  return goog.uri.utils.decodeIfPossible_(goog.uri.utils.getUserInfoEncoded(uri));
};
goog.uri.utils.getDomainEncoded = function(uri) {
  return goog.uri.utils.getComponentByIndex_(goog.uri.utils.ComponentIndex.DOMAIN, uri);
};
goog.uri.utils.getDomain = function(uri) {
  return goog.uri.utils.decodeIfPossible_(goog.uri.utils.getDomainEncoded(uri), !0);
};
goog.uri.utils.getPort = function(uri) {
  return Number(goog.uri.utils.getComponentByIndex_(goog.uri.utils.ComponentIndex.PORT, uri)) || null;
};
goog.uri.utils.getPathEncoded = function(uri) {
  return goog.uri.utils.getComponentByIndex_(goog.uri.utils.ComponentIndex.PATH, uri);
};
goog.uri.utils.getPath = function(uri) {
  return goog.uri.utils.decodeIfPossible_(goog.uri.utils.getPathEncoded(uri), !0);
};
goog.uri.utils.getQueryData = function(uri) {
  return goog.uri.utils.getComponentByIndex_(goog.uri.utils.ComponentIndex.QUERY_DATA, uri);
};
goog.uri.utils.getFragmentEncoded = function(uri) {
  var hashIndex = uri.indexOf("#");
  return 0 > hashIndex ? null : uri.substr(hashIndex + 1);
};
goog.uri.utils.setFragmentEncoded = function(uri, fragment) {
  return goog.uri.utils.removeFragment(uri) + (fragment ? "#" + fragment : "");
};
goog.uri.utils.getFragment = function(uri) {
  return goog.uri.utils.decodeIfPossible_(goog.uri.utils.getFragmentEncoded(uri));
};
goog.uri.utils.getHost = function(uri) {
  var pieces = goog.uri.utils.split(uri);
  return goog.uri.utils.buildFromEncodedParts(pieces[goog.uri.utils.ComponentIndex.SCHEME], pieces[goog.uri.utils.ComponentIndex.USER_INFO], pieces[goog.uri.utils.ComponentIndex.DOMAIN], pieces[goog.uri.utils.ComponentIndex.PORT]);
};
goog.uri.utils.getOrigin = function(uri) {
  var pieces = goog.uri.utils.split(uri);
  return goog.uri.utils.buildFromEncodedParts(pieces[goog.uri.utils.ComponentIndex.SCHEME], null, pieces[goog.uri.utils.ComponentIndex.DOMAIN], pieces[goog.uri.utils.ComponentIndex.PORT]);
};
goog.uri.utils.getPathAndAfter = function(uri) {
  var pieces = goog.uri.utils.split(uri);
  return goog.uri.utils.buildFromEncodedParts(null, null, null, null, pieces[goog.uri.utils.ComponentIndex.PATH], pieces[goog.uri.utils.ComponentIndex.QUERY_DATA], pieces[goog.uri.utils.ComponentIndex.FRAGMENT]);
};
goog.uri.utils.removeFragment = function(uri) {
  var hashIndex = uri.indexOf("#");
  return 0 > hashIndex ? uri : uri.substr(0, hashIndex);
};
goog.uri.utils.haveSameDomain = function(uri1, uri2) {
  var pieces1 = goog.uri.utils.split(uri1), pieces2 = goog.uri.utils.split(uri2);
  return pieces1[goog.uri.utils.ComponentIndex.DOMAIN] == pieces2[goog.uri.utils.ComponentIndex.DOMAIN] && pieces1[goog.uri.utils.ComponentIndex.SCHEME] == pieces2[goog.uri.utils.ComponentIndex.SCHEME] && pieces1[goog.uri.utils.ComponentIndex.PORT] == pieces2[goog.uri.utils.ComponentIndex.PORT];
};
goog.uri.utils.assertNoFragmentsOrQueries_ = function(uri) {
  goog.asserts.assert(0 > uri.indexOf("#") && 0 > uri.indexOf("?"), "goog.uri.utils: Fragment or query identifiers are not supported: [%s]", uri);
};
goog.uri.utils.parseQueryData = function(encodedQuery, callback) {
  if (encodedQuery) {
    for (var pairs = encodedQuery.split("&"), i = 0; i < pairs.length; i++) {
      var indexOfEquals = pairs[i].indexOf("="), name = null, value = null;
      0 <= indexOfEquals ? (name = pairs[i].substring(0, indexOfEquals), value = pairs[i].substring(indexOfEquals + 1)) : name = pairs[i];
      callback(name, value ? goog.string.urlDecode(value) : "");
    }
  }
};
goog.uri.utils.splitQueryData_ = function(uri) {
  var hashIndex = uri.indexOf("#");
  0 > hashIndex && (hashIndex = uri.length);
  var questionIndex = uri.indexOf("?");
  if (0 > questionIndex || questionIndex > hashIndex) {
    questionIndex = hashIndex;
    var queryData = "";
  } else {
    queryData = uri.substring(questionIndex + 1, hashIndex);
  }
  return [uri.substr(0, questionIndex), queryData, uri.substr(hashIndex)];
};
goog.uri.utils.joinQueryData_ = function(parts) {
  return parts[0] + (parts[1] ? "?" + parts[1] : "") + parts[2];
};
goog.uri.utils.appendQueryData_ = function(queryData, newData) {
  return newData ? queryData ? queryData + "&" + newData : newData : queryData;
};
goog.uri.utils.appendQueryDataToUri_ = function(uri, queryData) {
  if (!queryData) {
    return uri;
  }
  var parts = goog.uri.utils.splitQueryData_(uri);
  parts[1] = goog.uri.utils.appendQueryData_(parts[1], queryData);
  return goog.uri.utils.joinQueryData_(parts);
};
goog.uri.utils.appendKeyValuePairs_ = function(key, value, pairs) {
  goog.asserts.assertString(key);
  if (Array.isArray(value)) {
    goog.asserts.assertArray(value);
    for (var j = 0; j < value.length; j++) {
      goog.uri.utils.appendKeyValuePairs_(key, String(value[j]), pairs);
    }
  } else {
    null != value && pairs.push(key + ("" === value ? "" : "=" + goog.string.urlEncode(value)));
  }
};
goog.uri.utils.buildQueryData = function(keysAndValues, opt_startIndex) {
  goog.asserts.assert(0 == Math.max(keysAndValues.length - (opt_startIndex || 0), 0) % 2, "goog.uri.utils: Key/value lists must be even in length.");
  for (var params = [], i = opt_startIndex || 0; i < keysAndValues.length; i += 2) {
    goog.uri.utils.appendKeyValuePairs_(keysAndValues[i], keysAndValues[i + 1], params);
  }
  return params.join("&");
};
goog.uri.utils.buildQueryDataFromMap = function(map) {
  var params = [], key;
  for (key in map) {
    goog.uri.utils.appendKeyValuePairs_(key, map[key], params);
  }
  return params.join("&");
};
goog.uri.utils.appendParams = function(uri, var_args) {
  var queryData = 2 == arguments.length ? goog.uri.utils.buildQueryData(arguments[1], 0) : goog.uri.utils.buildQueryData(arguments, 1);
  return goog.uri.utils.appendQueryDataToUri_(uri, queryData);
};
goog.uri.utils.appendParamsFromMap = function(uri, map) {
  var queryData = goog.uri.utils.buildQueryDataFromMap(map);
  return goog.uri.utils.appendQueryDataToUri_(uri, queryData);
};
goog.uri.utils.appendParam = function(uri, key, opt_value) {
  var value = null != opt_value ? "=" + goog.string.urlEncode(opt_value) : "";
  return goog.uri.utils.appendQueryDataToUri_(uri, key + value);
};
goog.uri.utils.findParam_ = function(uri, startIndex, keyEncoded, hashOrEndIndex) {
  for (var index = startIndex, keyLength = keyEncoded.length; 0 <= (index = uri.indexOf(keyEncoded, index)) && index < hashOrEndIndex;) {
    var precedingChar = uri.charCodeAt(index - 1);
    if (precedingChar == goog.uri.utils.CharCode_.AMPERSAND || precedingChar == goog.uri.utils.CharCode_.QUESTION) {
      var followingChar = uri.charCodeAt(index + keyLength);
      if (!followingChar || followingChar == goog.uri.utils.CharCode_.EQUAL || followingChar == goog.uri.utils.CharCode_.AMPERSAND || followingChar == goog.uri.utils.CharCode_.HASH) {
        return index;
      }
    }
    index += keyLength + 1;
  }
  return -1;
};
goog.uri.utils.hashOrEndRe_ = /#|$/;
goog.uri.utils.hasParam = function(uri, keyEncoded) {
  return 0 <= goog.uri.utils.findParam_(uri, 0, keyEncoded, uri.search(goog.uri.utils.hashOrEndRe_));
};
goog.uri.utils.getParamValue = function(uri, keyEncoded) {
  var hashOrEndIndex = uri.search(goog.uri.utils.hashOrEndRe_), foundIndex = goog.uri.utils.findParam_(uri, 0, keyEncoded, hashOrEndIndex);
  if (0 > foundIndex) {
    return null;
  }
  var endPosition = uri.indexOf("&", foundIndex);
  if (0 > endPosition || endPosition > hashOrEndIndex) {
    endPosition = hashOrEndIndex;
  }
  foundIndex += keyEncoded.length + 1;
  return goog.string.urlDecode(uri.substr(foundIndex, endPosition - foundIndex));
};
goog.uri.utils.getParamValues = function(uri, keyEncoded) {
  for (var hashOrEndIndex = uri.search(goog.uri.utils.hashOrEndRe_), position = 0, foundIndex, result = []; 0 <= (foundIndex = goog.uri.utils.findParam_(uri, position, keyEncoded, hashOrEndIndex));) {
    position = uri.indexOf("&", foundIndex);
    if (0 > position || position > hashOrEndIndex) {
      position = hashOrEndIndex;
    }
    foundIndex += keyEncoded.length + 1;
    result.push(goog.string.urlDecode(uri.substr(foundIndex, position - foundIndex)));
  }
  return result;
};
goog.uri.utils.trailingQueryPunctuationRe_ = /[?&]($|#)/;
goog.uri.utils.removeParam = function(uri, keyEncoded) {
  for (var hashOrEndIndex = uri.search(goog.uri.utils.hashOrEndRe_), position = 0, foundIndex, buffer = []; 0 <= (foundIndex = goog.uri.utils.findParam_(uri, position, keyEncoded, hashOrEndIndex));) {
    buffer.push(uri.substring(position, foundIndex)), position = Math.min(uri.indexOf("&", foundIndex) + 1 || hashOrEndIndex, hashOrEndIndex);
  }
  buffer.push(uri.substr(position));
  return buffer.join("").replace(goog.uri.utils.trailingQueryPunctuationRe_, "$1");
};
goog.uri.utils.setParam = function(uri, keyEncoded, value) {
  return goog.uri.utils.appendParam(goog.uri.utils.removeParam(uri, keyEncoded), keyEncoded, value);
};
goog.uri.utils.setParamsFromMap = function(uri, params) {
  var parts = goog.uri.utils.splitQueryData_(uri), queryData = parts[1], buffer = [];
  queryData && goog.array.forEach(queryData.split("&"), function(pair) {
    var indexOfEquals = pair.indexOf("=");
    params.hasOwnProperty(0 <= indexOfEquals ? pair.substr(0, indexOfEquals) : pair) || buffer.push(pair);
  });
  parts[1] = goog.uri.utils.appendQueryData_(buffer.join("&"), goog.uri.utils.buildQueryDataFromMap(params));
  return goog.uri.utils.joinQueryData_(parts);
};
goog.uri.utils.appendPath = function(baseUri, path) {
  goog.uri.utils.assertNoFragmentsOrQueries_(baseUri);
  goog.string.endsWith(baseUri, "/") && (baseUri = baseUri.substr(0, baseUri.length - 1));
  goog.string.startsWith(path, "/") && (path = path.substr(1));
  return goog.string.buildString(baseUri, "/", path);
};
goog.uri.utils.setPath = function(uri, path) {
  goog.string.startsWith(path, "/") || (path = "/" + path);
  var parts = goog.uri.utils.split(uri);
  return goog.uri.utils.buildFromEncodedParts(parts[goog.uri.utils.ComponentIndex.SCHEME], parts[goog.uri.utils.ComponentIndex.USER_INFO], parts[goog.uri.utils.ComponentIndex.DOMAIN], parts[goog.uri.utils.ComponentIndex.PORT], path, parts[goog.uri.utils.ComponentIndex.QUERY_DATA], parts[goog.uri.utils.ComponentIndex.FRAGMENT]);
};
goog.uri.utils.StandardQueryParam = {RANDOM:"zx"};
goog.uri.utils.makeUnique = function(uri) {
  return goog.uri.utils.setParam(uri, goog.uri.utils.StandardQueryParam.RANDOM, goog.string.getRandomString());
};
goog.Uri = function(opt_uri, opt_ignoreCase) {
  this.domain_ = this.userInfo_ = this.scheme_ = "";
  this.port_ = null;
  this.fragment_ = this.path_ = "";
  this.ignoreCase_ = this.isReadOnly_ = !1;
  var m;
  opt_uri instanceof goog.Uri ? (this.ignoreCase_ = void 0 !== opt_ignoreCase ? opt_ignoreCase : opt_uri.getIgnoreCase(), this.setScheme(opt_uri.getScheme()), this.setUserInfo(opt_uri.getUserInfo()), this.setDomain(opt_uri.getDomain()), this.setPort(opt_uri.getPort()), this.setPath(opt_uri.getPath()), this.setQueryData(opt_uri.getQueryData().clone()), this.setFragment(opt_uri.getFragment())) : opt_uri && (m = goog.uri.utils.split(String(opt_uri))) ? (this.ignoreCase_ = !!opt_ignoreCase, this.setScheme(m[goog.uri.utils.ComponentIndex.SCHEME] || 
  "", !0), this.setUserInfo(m[goog.uri.utils.ComponentIndex.USER_INFO] || "", !0), this.setDomain(m[goog.uri.utils.ComponentIndex.DOMAIN] || "", !0), this.setPort(m[goog.uri.utils.ComponentIndex.PORT]), this.setPath(m[goog.uri.utils.ComponentIndex.PATH] || "", !0), this.setQueryData(m[goog.uri.utils.ComponentIndex.QUERY_DATA] || "", !0), this.setFragment(m[goog.uri.utils.ComponentIndex.FRAGMENT] || "", !0)) : (this.ignoreCase_ = !!opt_ignoreCase, this.queryData_ = new goog.Uri.QueryData(null, this.ignoreCase_));
};
goog.Uri.RANDOM_PARAM = goog.uri.utils.StandardQueryParam.RANDOM;
goog.Uri.prototype.toString = function() {
  var out = [], scheme = this.getScheme();
  scheme && out.push(goog.Uri.encodeSpecialChars_(scheme, goog.Uri.reDisallowedInSchemeOrUserInfo_, !0), ":");
  var domain = this.getDomain();
  if (domain || "file" == scheme) {
    out.push("//");
    var userInfo = this.getUserInfo();
    userInfo && out.push(goog.Uri.encodeSpecialChars_(userInfo, goog.Uri.reDisallowedInSchemeOrUserInfo_, !0), "@");
    out.push(goog.Uri.removeDoubleEncoding_(goog.string.urlEncode(domain)));
    var port = this.getPort();
    null != port && out.push(":", String(port));
  }
  var path = this.getPath();
  path && (this.hasDomain() && "/" != path.charAt(0) && out.push("/"), out.push(goog.Uri.encodeSpecialChars_(path, "/" == path.charAt(0) ? goog.Uri.reDisallowedInAbsolutePath_ : goog.Uri.reDisallowedInRelativePath_, !0)));
  var query = this.getEncodedQuery();
  query && out.push("?", query);
  var fragment = this.getFragment();
  fragment && out.push("#", goog.Uri.encodeSpecialChars_(fragment, goog.Uri.reDisallowedInFragment_));
  return out.join("");
};
goog.Uri.prototype.resolve = function(relativeUri) {
  var absoluteUri = this.clone(), overridden = relativeUri.hasScheme();
  overridden ? absoluteUri.setScheme(relativeUri.getScheme()) : overridden = relativeUri.hasUserInfo();
  overridden ? absoluteUri.setUserInfo(relativeUri.getUserInfo()) : overridden = relativeUri.hasDomain();
  overridden ? absoluteUri.setDomain(relativeUri.getDomain()) : overridden = relativeUri.hasPort();
  var path = relativeUri.getPath();
  if (overridden) {
    absoluteUri.setPort(relativeUri.getPort());
  } else {
    if (overridden = relativeUri.hasPath()) {
      if ("/" != path.charAt(0)) {
        if (this.hasDomain() && !this.hasPath()) {
          path = "/" + path;
        } else {
          var lastSlashIndex = absoluteUri.getPath().lastIndexOf("/");
          -1 != lastSlashIndex && (path = absoluteUri.getPath().substr(0, lastSlashIndex + 1) + path);
        }
      }
      path = goog.Uri.removeDotSegments(path);
    }
  }
  overridden ? absoluteUri.setPath(path) : overridden = relativeUri.hasQuery();
  overridden ? absoluteUri.setQueryData(relativeUri.getQueryData().clone()) : overridden = relativeUri.hasFragment();
  overridden && absoluteUri.setFragment(relativeUri.getFragment());
  return absoluteUri;
};
goog.Uri.prototype.clone = function() {
  return new goog.Uri(this);
};
goog.Uri.prototype.getScheme = function() {
  return this.scheme_;
};
goog.Uri.prototype.setScheme = function(newScheme, opt_decode) {
  this.enforceReadOnly();
  if (this.scheme_ = opt_decode ? goog.Uri.decodeOrEmpty_(newScheme, !0) : newScheme) {
    this.scheme_ = this.scheme_.replace(/:$/, "");
  }
  return this;
};
goog.Uri.prototype.hasScheme = function() {
  return !!this.scheme_;
};
goog.Uri.prototype.getUserInfo = function() {
  return this.userInfo_;
};
goog.Uri.prototype.setUserInfo = function(newUserInfo, opt_decode) {
  this.enforceReadOnly();
  this.userInfo_ = opt_decode ? goog.Uri.decodeOrEmpty_(newUserInfo) : newUserInfo;
  return this;
};
goog.Uri.prototype.hasUserInfo = function() {
  return !!this.userInfo_;
};
goog.Uri.prototype.getDomain = function() {
  return this.domain_;
};
goog.Uri.prototype.setDomain = function(newDomain, opt_decode) {
  this.enforceReadOnly();
  this.domain_ = opt_decode ? goog.Uri.decodeOrEmpty_(newDomain, !0) : newDomain;
  return this;
};
goog.Uri.prototype.hasDomain = function() {
  return !!this.domain_;
};
goog.Uri.prototype.getPort = function() {
  return this.port_;
};
goog.Uri.prototype.setPort = function(newPort) {
  this.enforceReadOnly();
  if (newPort) {
    newPort = Number(newPort);
    if (isNaN(newPort) || 0 > newPort) {
      throw Error("Bad port number " + newPort);
    }
    this.port_ = newPort;
  } else {
    this.port_ = null;
  }
  return this;
};
goog.Uri.prototype.hasPort = function() {
  return null != this.port_;
};
goog.Uri.prototype.getPath = function() {
  return this.path_;
};
goog.Uri.prototype.setPath = function(newPath, opt_decode) {
  this.enforceReadOnly();
  this.path_ = opt_decode ? goog.Uri.decodeOrEmpty_(newPath, !0) : newPath;
  return this;
};
goog.Uri.prototype.hasPath = function() {
  return !!this.path_;
};
goog.Uri.prototype.hasQuery = function() {
  return "" !== this.queryData_.toString();
};
goog.Uri.prototype.setQueryData = function(queryData, opt_decode) {
  this.enforceReadOnly();
  queryData instanceof goog.Uri.QueryData ? (this.queryData_ = queryData, this.queryData_.setIgnoreCase(this.ignoreCase_)) : (opt_decode || (queryData = goog.Uri.encodeSpecialChars_(queryData, goog.Uri.reDisallowedInQuery_)), this.queryData_ = new goog.Uri.QueryData(queryData, this.ignoreCase_));
  return this;
};
goog.Uri.prototype.setQuery = function(newQuery, opt_decode) {
  return this.setQueryData(newQuery, opt_decode);
};
goog.Uri.prototype.getEncodedQuery = function() {
  return this.queryData_.toString();
};
goog.Uri.prototype.getDecodedQuery = function() {
  return this.queryData_.toDecodedString();
};
goog.Uri.prototype.getQueryData = function() {
  return this.queryData_;
};
goog.Uri.prototype.getQuery = function() {
  return this.getEncodedQuery();
};
goog.Uri.prototype.setParameterValue = function(key, value) {
  this.enforceReadOnly();
  this.queryData_.set(key, value);
  return this;
};
goog.Uri.prototype.setParameterValues = function(key, values) {
  this.enforceReadOnly();
  Array.isArray(values) || (values = [String(values)]);
  this.queryData_.setValues(key, values);
  return this;
};
goog.Uri.prototype.getParameterValues = function(name) {
  return this.queryData_.getValues(name);
};
goog.Uri.prototype.getParameterValue = function(paramName) {
  return this.queryData_.get(paramName);
};
goog.Uri.prototype.getFragment = function() {
  return this.fragment_;
};
goog.Uri.prototype.setFragment = function(newFragment, opt_decode) {
  this.enforceReadOnly();
  this.fragment_ = opt_decode ? goog.Uri.decodeOrEmpty_(newFragment) : newFragment;
  return this;
};
goog.Uri.prototype.hasFragment = function() {
  return !!this.fragment_;
};
goog.Uri.prototype.hasSameDomainAs = function(uri2) {
  return (!this.hasDomain() && !uri2.hasDomain() || this.getDomain() == uri2.getDomain()) && (!this.hasPort() && !uri2.hasPort() || this.getPort() == uri2.getPort());
};
goog.Uri.prototype.makeUnique = function() {
  this.enforceReadOnly();
  this.setParameterValue(goog.Uri.RANDOM_PARAM, goog.string.getRandomString());
  return this;
};
goog.Uri.prototype.removeParameter = function(key) {
  this.enforceReadOnly();
  this.queryData_.remove(key);
  return this;
};
goog.Uri.prototype.setReadOnly = function(isReadOnly) {
  this.isReadOnly_ = isReadOnly;
  return this;
};
goog.Uri.prototype.isReadOnly = function() {
  return this.isReadOnly_;
};
goog.Uri.prototype.enforceReadOnly = function() {
  if (this.isReadOnly_) {
    throw Error("Tried to modify a read-only Uri");
  }
};
goog.Uri.prototype.setIgnoreCase = function(ignoreCase) {
  this.ignoreCase_ = ignoreCase;
  this.queryData_ && this.queryData_.setIgnoreCase(ignoreCase);
  return this;
};
goog.Uri.prototype.getIgnoreCase = function() {
  return this.ignoreCase_;
};
goog.Uri.parse = function(uri, opt_ignoreCase) {
  return uri instanceof goog.Uri ? uri.clone() : new goog.Uri(uri, opt_ignoreCase);
};
goog.Uri.create = function(opt_scheme, opt_userInfo, opt_domain, opt_port, opt_path, opt_query, opt_fragment, opt_ignoreCase) {
  var uri = new goog.Uri(null, opt_ignoreCase);
  opt_scheme && uri.setScheme(opt_scheme);
  opt_userInfo && uri.setUserInfo(opt_userInfo);
  opt_domain && uri.setDomain(opt_domain);
  opt_port && uri.setPort(opt_port);
  opt_path && uri.setPath(opt_path);
  opt_query && uri.setQueryData(opt_query);
  opt_fragment && uri.setFragment(opt_fragment);
  return uri;
};
goog.Uri.resolve = function(base, rel) {
  base instanceof goog.Uri || (base = goog.Uri.parse(base));
  rel instanceof goog.Uri || (rel = goog.Uri.parse(rel));
  return base.resolve(rel);
};
goog.Uri.removeDotSegments = function(path) {
  if (".." == path || "." == path) {
    return "";
  }
  if (goog.string.contains(path, "./") || goog.string.contains(path, "/.")) {
    for (var leadingSlash = goog.string.startsWith(path, "/"), segments = path.split("/"), out = [], pos = 0; pos < segments.length;) {
      var segment = segments[pos++];
      "." == segment ? leadingSlash && pos == segments.length && out.push("") : ".." == segment ? ((1 < out.length || 1 == out.length && "" != out[0]) && out.pop(), leadingSlash && pos == segments.length && out.push("")) : (out.push(segment), leadingSlash = !0);
    }
    return out.join("/");
  }
  return path;
};
goog.Uri.decodeOrEmpty_ = function(val, opt_preserveReserved) {
  return val ? opt_preserveReserved ? decodeURI(val.replace(/%25/g, "%2525")) : decodeURIComponent(val) : "";
};
goog.Uri.encodeSpecialChars_ = function(unescapedPart, extra, opt_removeDoubleEncoding) {
  if ("string" === typeof unescapedPart) {
    var encoded = encodeURI(unescapedPart).replace(extra, goog.Uri.encodeChar_);
    opt_removeDoubleEncoding && (encoded = goog.Uri.removeDoubleEncoding_(encoded));
    return encoded;
  }
  return null;
};
goog.Uri.encodeChar_ = function(ch) {
  var n = ch.charCodeAt(0);
  return "%" + (n >> 4 & 15).toString(16) + (n & 15).toString(16);
};
goog.Uri.removeDoubleEncoding_ = function(doubleEncodedString) {
  return doubleEncodedString.replace(/%25([0-9a-fA-F]{2})/g, "%$1");
};
goog.Uri.reDisallowedInSchemeOrUserInfo_ = /[#\/\?@]/g;
goog.Uri.reDisallowedInRelativePath_ = /[#\?:]/g;
goog.Uri.reDisallowedInAbsolutePath_ = /[#\?]/g;
goog.Uri.reDisallowedInQuery_ = /[#\?@]/g;
goog.Uri.reDisallowedInFragment_ = /#/g;
goog.Uri.haveSameDomain = function(uri1String, uri2String) {
  var pieces1 = goog.uri.utils.split(uri1String), pieces2 = goog.uri.utils.split(uri2String);
  return pieces1[goog.uri.utils.ComponentIndex.DOMAIN] == pieces2[goog.uri.utils.ComponentIndex.DOMAIN] && pieces1[goog.uri.utils.ComponentIndex.PORT] == pieces2[goog.uri.utils.ComponentIndex.PORT];
};
goog.Uri.QueryData = function(opt_query, opt_ignoreCase) {
  this.count_ = this.keyMap_ = null;
  this.encodedQuery_ = opt_query || null;
  this.ignoreCase_ = !!opt_ignoreCase;
};
goog.Uri.QueryData.prototype.ensureKeyMapInitialized_ = function() {
  if (!this.keyMap_ && (this.keyMap_ = new goog.structs.Map, this.count_ = 0, this.encodedQuery_)) {
    var self = this;
    goog.uri.utils.parseQueryData(this.encodedQuery_, function(name, value) {
      self.add(goog.string.urlDecode(name), value);
    });
  }
};
goog.Uri.QueryData.createFromMap = function(map, opt_ignoreCase) {
  var keys = goog.structs.getKeys(map);
  if ("undefined" == typeof keys) {
    throw Error("Keys are undefined");
  }
  for (var queryData = new goog.Uri.QueryData(null, opt_ignoreCase), values = goog.structs.getValues(map), i = 0; i < keys.length; i++) {
    var key = keys[i], value = values[i];
    Array.isArray(value) ? queryData.setValues(key, value) : queryData.add(key, value);
  }
  return queryData;
};
goog.Uri.QueryData.createFromKeysValues = function(keys, values, opt_ignoreCase) {
  if (keys.length != values.length) {
    throw Error("Mismatched lengths for keys/values");
  }
  for (var queryData = new goog.Uri.QueryData(null, opt_ignoreCase), i = 0; i < keys.length; i++) {
    queryData.add(keys[i], values[i]);
  }
  return queryData;
};
goog.Uri.QueryData.prototype.getCount = function() {
  this.ensureKeyMapInitialized_();
  return this.count_;
};
goog.Uri.QueryData.prototype.add = function(key, value) {
  this.ensureKeyMapInitialized_();
  this.invalidateCache_();
  key = this.getKeyName_(key);
  var values = this.keyMap_.get(key);
  values || this.keyMap_.set(key, values = []);
  values.push(value);
  this.count_ = goog.asserts.assertNumber(this.count_) + 1;
  return this;
};
goog.Uri.QueryData.prototype.remove = function(key) {
  this.ensureKeyMapInitialized_();
  key = this.getKeyName_(key);
  return this.keyMap_.containsKey(key) ? (this.invalidateCache_(), this.count_ = goog.asserts.assertNumber(this.count_) - this.keyMap_.get(key).length, this.keyMap_.remove(key)) : !1;
};
goog.Uri.QueryData.prototype.clear = function() {
  this.invalidateCache_();
  this.keyMap_ = null;
  this.count_ = 0;
};
goog.Uri.QueryData.prototype.isEmpty = function() {
  this.ensureKeyMapInitialized_();
  return 0 == this.count_;
};
goog.Uri.QueryData.prototype.containsKey = function(key) {
  this.ensureKeyMapInitialized_();
  key = this.getKeyName_(key);
  return this.keyMap_.containsKey(key);
};
goog.Uri.QueryData.prototype.containsValue = function(value) {
  var vals = this.getValues();
  return goog.array.contains(vals, value);
};
goog.Uri.QueryData.prototype.forEach = function(f, opt_scope) {
  this.ensureKeyMapInitialized_();
  this.keyMap_.forEach(function(values, key) {
    goog.array.forEach(values, function(value) {
      f.call(opt_scope, value, key, this);
    }, this);
  }, this);
};
goog.Uri.QueryData.prototype.getKeys = function() {
  this.ensureKeyMapInitialized_();
  for (var vals = this.keyMap_.getValues(), keys = this.keyMap_.getKeys(), rv = [], i = 0; i < keys.length; i++) {
    for (var val = vals[i], j = 0; j < val.length; j++) {
      rv.push(keys[i]);
    }
  }
  return rv;
};
goog.Uri.QueryData.prototype.getValues = function(opt_key) {
  this.ensureKeyMapInitialized_();
  var rv = [];
  if ("string" === typeof opt_key) {
    this.containsKey(opt_key) && (rv = goog.array.concat(rv, this.keyMap_.get(this.getKeyName_(opt_key))));
  } else {
    for (var values = this.keyMap_.getValues(), i = 0; i < values.length; i++) {
      rv = goog.array.concat(rv, values[i]);
    }
  }
  return rv;
};
goog.Uri.QueryData.prototype.set = function(key, value) {
  this.ensureKeyMapInitialized_();
  this.invalidateCache_();
  key = this.getKeyName_(key);
  this.containsKey(key) && (this.count_ = goog.asserts.assertNumber(this.count_) - this.keyMap_.get(key).length);
  this.keyMap_.set(key, [value]);
  this.count_ = goog.asserts.assertNumber(this.count_) + 1;
  return this;
};
goog.Uri.QueryData.prototype.get = function(key, opt_default) {
  if (!key) {
    return opt_default;
  }
  var values = this.getValues(key);
  return 0 < values.length ? String(values[0]) : opt_default;
};
goog.Uri.QueryData.prototype.setValues = function(key, values) {
  this.remove(key);
  0 < values.length && (this.invalidateCache_(), this.keyMap_.set(this.getKeyName_(key), goog.array.clone(values)), this.count_ = goog.asserts.assertNumber(this.count_) + values.length);
};
goog.Uri.QueryData.prototype.toString = function() {
  if (this.encodedQuery_) {
    return this.encodedQuery_;
  }
  if (!this.keyMap_) {
    return "";
  }
  for (var sb = [], keys = this.keyMap_.getKeys(), i = 0; i < keys.length; i++) {
    for (var key = keys[i], encodedKey = goog.string.urlEncode(key), val = this.getValues(key), j = 0; j < val.length; j++) {
      var param = encodedKey;
      "" !== val[j] && (param += "=" + goog.string.urlEncode(val[j]));
      sb.push(param);
    }
  }
  return this.encodedQuery_ = sb.join("&");
};
goog.Uri.QueryData.prototype.toDecodedString = function() {
  return goog.Uri.decodeOrEmpty_(this.toString());
};
goog.Uri.QueryData.prototype.invalidateCache_ = function() {
  this.encodedQuery_ = null;
};
goog.Uri.QueryData.prototype.filterKeys = function(keys) {
  this.ensureKeyMapInitialized_();
  this.keyMap_.forEach(function(value, key) {
    goog.array.contains(keys, key) || this.remove(key);
  }, this);
  return this;
};
goog.Uri.QueryData.prototype.clone = function() {
  var rv = new goog.Uri.QueryData;
  rv.encodedQuery_ = this.encodedQuery_;
  this.keyMap_ && (rv.keyMap_ = this.keyMap_.clone(), rv.count_ = this.count_);
  return rv;
};
goog.Uri.QueryData.prototype.getKeyName_ = function(arg) {
  var keyName = String(arg);
  this.ignoreCase_ && (keyName = keyName.toLowerCase());
  return keyName;
};
goog.Uri.QueryData.prototype.setIgnoreCase = function(ignoreCase) {
  ignoreCase && !this.ignoreCase_ && (this.ensureKeyMapInitialized_(), this.invalidateCache_(), this.keyMap_.forEach(function(value, key) {
    var lowerCase = key.toLowerCase();
    key != lowerCase && (this.remove(key), this.setValues(lowerCase, value));
  }, this));
  this.ignoreCase_ = ignoreCase;
};
goog.Uri.QueryData.prototype.extend = function(var_args) {
  for (var i = 0; i < arguments.length; i++) {
    goog.structs.forEach(arguments[i], function(value, key) {
      this.add(key, value);
    }, this);
  }
};
var module$exports$goog$net$rpc$HttpCors = {HTTP_HEADERS_PARAM_NAME:"$httpHeaders", HTTP_METHOD_PARAM_NAME:"$httpMethod", generateHttpHeadersOverwriteParam:function(headers) {
  var result = "";
  goog.object.forEach(headers, function(value, key) {
    result += key;
    result += ":";
    result += value;
    result += "\r\n";
  });
  return result;
}, generateEncodedHttpHeadersOverwriteParam:function(headers) {
  return goog.string.urlEncode(module$exports$goog$net$rpc$HttpCors.generateHttpHeadersOverwriteParam(headers));
}, setHttpHeadersWithOverwriteParam:function(url, urlParam, extraHeaders) {
  if (goog.object.isEmpty(extraHeaders)) {
    return url;
  }
  var httpHeaders = module$exports$goog$net$rpc$HttpCors.generateHttpHeadersOverwriteParam(extraHeaders);
  if ("string" === typeof url) {
    return goog.uri.utils.appendParam(url, goog.string.urlEncode(urlParam), httpHeaders);
  }
  url.setParameterValue(urlParam, httpHeaders);
  return url;
}};
var module$exports$eeapiclient$request_params = {}, module$contents$eeapiclient$request_params_module = module$contents$eeapiclient$request_params_module || {id:"javascript/typescript/contrib/apiclient/core/request_params.closure.js"};
module$exports$eeapiclient$request_params.HttpMethodEnum = function() {
};
module$exports$eeapiclient$request_params.HttpMethodEnum.isHttpMethod = function(method) {
  return method === module$exports$eeapiclient$request_params.HttpMethodEnum.GET || method === module$exports$eeapiclient$request_params.HttpMethodEnum.POST || method === module$exports$eeapiclient$request_params.HttpMethodEnum.PUT || method === module$exports$eeapiclient$request_params.HttpMethodEnum.PATCH || method === module$exports$eeapiclient$request_params.HttpMethodEnum.DELETE;
};
module$exports$eeapiclient$request_params.HttpMethodEnum.GET = "GET";
module$exports$eeapiclient$request_params.HttpMethodEnum.POST = "POST";
module$exports$eeapiclient$request_params.HttpMethodEnum.PUT = "PUT";
module$exports$eeapiclient$request_params.HttpMethodEnum.PATCH = "PATCH";
module$exports$eeapiclient$request_params.HttpMethodEnum.DELETE = "DELETE";
module$exports$eeapiclient$request_params.AuthType = {AUTO:"auto", NONE:"none", OAUTH2:"oauth2", FIRST_PARTY:"1p", };
module$exports$eeapiclient$request_params.StreamingType = {NONE:"NONE", CLIENT_SIDE:"CLIENT_SIDE", SERVER_SIDE:"SERVER_SIDE", BIDIRECTONAL:"BIDIRECTONAL", };
function module$contents$eeapiclient$request_params_MakeRequestParams() {
}
module$exports$eeapiclient$request_params.MakeRequestParams = module$contents$eeapiclient$request_params_MakeRequestParams;
function module$contents$eeapiclient$request_params_processParams(params) {
  if (null != params.queryParams) {
    var filteredQueryParams = {}, key;
    for (key in params.queryParams) {
      void 0 !== params.queryParams[key] && (filteredQueryParams[key] = params.queryParams[key]);
    }
    params.queryParams = filteredQueryParams;
  }
}
module$exports$eeapiclient$request_params.processParams = module$contents$eeapiclient$request_params_processParams;
function module$contents$eeapiclient$request_params_buildQueryParams(params, mapping) {
  for (var urlQueryParams = {}, $jscomp$iter$8 = $jscomp.makeIterator(Object.entries(mapping)), $jscomp$key$ = $jscomp$iter$8.next(); !$jscomp$key$.done; $jscomp$key$ = $jscomp$iter$8.next()) {
    var $jscomp$destructuring$var1 = $jscomp.makeIterator($jscomp$key$.value), jsName = $jscomp$destructuring$var1.next().value, urlQueryParamName = $jscomp$destructuring$var1.next().value;
    jsName in params && (urlQueryParams[urlQueryParamName] = params[jsName]);
  }
  return urlQueryParams;
}
module$exports$eeapiclient$request_params.buildQueryParams = module$contents$eeapiclient$request_params_buildQueryParams;
var module$contents$eeapiclient$request_params_simpleCorsAllowedHeaders = ["accept", "accept-language", "content-language"], module$contents$eeapiclient$request_params_simpleCorsAllowedMethods = ["GET", "HEAD", "POST"];
module$exports$eeapiclient$request_params.bypassCorsPreflight = function module$contents$eeapiclient$request_params_bypassCorsPreflight(params) {
  var safeHeaders = {}, unsafeHeaders = {}, hasUnsafeHeaders = !1, hasSafeHeaders = !1, hasContentType = !1;
  if (params.headers) {
    hasContentType = null != params.headers["Content-Type"];
    for (var $jscomp$iter$9 = $jscomp.makeIterator(Object.entries(params.headers)), $jscomp$key$ = $jscomp$iter$9.next(); !$jscomp$key$.done; $jscomp$key$ = $jscomp$iter$9.next()) {
      var $jscomp$destructuring$var3 = $jscomp.makeIterator($jscomp$key$.value), key = $jscomp$destructuring$var3.next().value, value = $jscomp$destructuring$var3.next().value;
      module$contents$eeapiclient$request_params_simpleCorsAllowedHeaders.includes(key) ? (safeHeaders[key] = value, hasSafeHeaders = !0) : (unsafeHeaders[key] = value, hasUnsafeHeaders = !0);
    }
  }
  if (null != params.body || "PUT" === params.httpMethod || "POST" === params.httpMethod) {
    hasContentType || (unsafeHeaders["Content-Type"] = "application/json", hasUnsafeHeaders = !0), safeHeaders["Content-Type"] = "text/plain", hasSafeHeaders = !0;
  }
  if (hasUnsafeHeaders) {
    var finalParam = (0,module$exports$goog$net$rpc$HttpCors.generateEncodedHttpHeadersOverwriteParam)(unsafeHeaders);
    module$contents$eeapiclient$request_params_addQueryParameter(params, module$exports$goog$net$rpc$HttpCors.HTTP_HEADERS_PARAM_NAME, finalParam);
  }
  hasSafeHeaders && (params.headers = safeHeaders);
  module$contents$eeapiclient$request_params_simpleCorsAllowedMethods.includes(params.httpMethod) || (module$contents$eeapiclient$request_params_addQueryParameter(params, module$exports$goog$net$rpc$HttpCors.HTTP_METHOD_PARAM_NAME, params.httpMethod), params.httpMethod = "POST");
};
function module$contents$eeapiclient$request_params_addQueryParameter(params, key, value) {
  if (params.queryParams) {
    params.queryParams[key] = value;
  } else {
    var $jscomp$compprop0 = {};
    params.queryParams = ($jscomp$compprop0[key] = value, $jscomp$compprop0);
  }
}
;var module$exports$eeapiclient$multipart_request = {}, module$contents$eeapiclient$multipart_request_module = module$contents$eeapiclient$multipart_request_module || {id:"javascript/typescript/contrib/apiclient/core/multipart_request.closure.js"};
module$exports$eeapiclient$multipart_request.MultipartRequest = function(files, _metadata) {
  this.files = files;
  this._metadata = _metadata;
  this._metadataPayload = "";
  this._boundary = Date.now().toString();
  _metadata && this.addMetadata(_metadata);
  this._payloadPromise = this.build();
};
module$exports$eeapiclient$multipart_request.MultipartRequest.prototype.addMetadata = function(metadata) {
  var json = metadata instanceof module$exports$eeapiclient$domain_object.Serializable ? module$contents$eeapiclient$domain_object_serialize(metadata) : metadata;
  this._metadataPayload += "Content-Type: application/json; charset=utf-8\r\n\r\n" + JSON.stringify(json) + ("\r\n--" + this._boundary + "\r\n");
};
module$exports$eeapiclient$multipart_request.MultipartRequest.prototype.build = function() {
  var $jscomp$this = this, payload = "--" + this.boundary + "\r\n";
  payload += this._metadataPayload;
  return Promise.all(this.files.map(function(f) {
    return $jscomp$this.encodeFile(f);
  })).then(function(filePayloads) {
    for (var $jscomp$iter$10 = $jscomp.makeIterator(filePayloads), $jscomp$key$filePayload = $jscomp$iter$10.next(); !$jscomp$key$filePayload.done; $jscomp$key$filePayload = $jscomp$iter$10.next()) {
      payload += $jscomp$key$filePayload.value;
    }
    return payload += "\r\n--" + $jscomp$this._boundary + "--";
  });
};
module$exports$eeapiclient$multipart_request.MultipartRequest.prototype.encodeFile = function(file) {
  return this.base64EncodeFile(file).then(function(base64Str) {
    return "Content-Type: " + file.type + "\r\nContent-Transfer-Encoding: base64\r\n\r\n" + base64Str;
  });
};
module$exports$eeapiclient$multipart_request.MultipartRequest.prototype.base64EncodeFile = function(file) {
  return new Promise(function(resolve, reject) {
    var reader = new FileReader;
    reader.onload = function(ev) {
      try {
        var file$22 = ev.target.result, toResolve = file$22.substr(file$22.indexOf(",") + 1);
        resolve(toResolve);
      } catch (e) {
        reject(e);
      }
    };
    reader.readAsDataURL(file);
  });
};
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$multipart_request.MultipartRequest.prototype, {boundary:{configurable:!0, enumerable:!0, get:function() {
  return this._boundary;
}}, metadata:{configurable:!0, enumerable:!0, get:function() {
  return this._metadata;
}}, payloadPromise:{configurable:!0, enumerable:!0, get:function() {
  return this._payloadPromise;
}}});
var module$exports$eeapiclient$api_client = {}, module$contents$eeapiclient$api_client_module = module$contents$eeapiclient$api_client_module || {id:"javascript/typescript/contrib/apiclient/core/api_client.closure.js"};
module$exports$eeapiclient$api_client.ApiClient = function() {
};
module$exports$eeapiclient$api_client.ApiClient.prototype.$validateParameter = function(param, pattern) {
  var paramStr = String(param);
  if (!pattern.test(paramStr)) {
    throw Error("parameter [" + paramStr + "] does not match pattern [" + pattern.toString() + "]");
  }
};
function module$contents$eeapiclient$api_client_toMakeRequestParams(requestParams) {
  var body = requestParams.body instanceof module$exports$eeapiclient$domain_object.Serializable ? module$contents$eeapiclient$domain_object_serialize(requestParams.body) : requestParams.body;
  return {path:requestParams.path, httpMethod:requestParams.httpMethod, methodId:requestParams.methodId, body:body, queryParams:requestParams.queryParams, streamingType:requestParams.streamingType && requestParams.streamingType};
}
module$exports$eeapiclient$api_client.toMakeRequestParams = module$contents$eeapiclient$api_client_toMakeRequestParams;
function module$contents$eeapiclient$api_client_toMultipartMakeRequestParams(requestParams) {
  if (!(requestParams.body instanceof module$exports$eeapiclient$multipart_request.MultipartRequest)) {
    throw Error(requestParams.path + " request must be a MultipartRequest");
  }
  var multipartRequest = requestParams.body;
  return multipartRequest.payloadPromise.then(function(body) {
    return {path:requestParams.path, httpMethod:requestParams.httpMethod, methodId:requestParams.methodId, queryParams:{uploadType:"multipart"}, headers:{"X-Goog-Upload-Protocol":"multipart", "Content-Type":"multipart/related; boundary=" + multipartRequest.boundary}, body:body, };
  });
}
module$exports$eeapiclient$api_client.toMultipartMakeRequestParams = module$contents$eeapiclient$api_client_toMultipartMakeRequestParams;
var module$exports$eeapiclient$api_request_hook = {}, module$contents$eeapiclient$api_request_hook_module = module$contents$eeapiclient$api_request_hook_module || {id:"javascript/typescript/contrib/apiclient/core/api_request_hook.closure.js"};
module$exports$eeapiclient$api_request_hook.ApiClientRequestHook = function module$contents$eeapiclient$api_request_hook_ApiClientRequestHook() {
};
module$exports$eeapiclient$api_request_hook.ApiClientHookFactory = function() {
};
module$exports$eeapiclient$api_request_hook.ApiClientHookFactoryCtor = function module$contents$eeapiclient$api_request_hook_ApiClientHookFactoryCtor() {
};
module$exports$eeapiclient$api_request_hook.DefaultApiClientHookFactory = function() {
};
module$exports$eeapiclient$api_request_hook.DefaultApiClientHookFactory.prototype.getRequestHook = function(requestParams) {
  return {onBeforeSend:function() {
  }, onSuccess:function(response) {
  }, onError:function(error) {
  }, };
};
function module$contents$eeapiclient$api_request_hook_getRequestHook(factory, requestParams) {
  if (null == factory) {
    return null;
  }
  var hook = factory.getRequestHook(requestParams);
  return null == hook ? null : hook;
}
module$exports$eeapiclient$api_request_hook.getRequestHook = module$contents$eeapiclient$api_request_hook_getRequestHook;
var module$exports$eeapiclient$promise_api_client = {}, module$contents$eeapiclient$promise_api_client_module = module$contents$eeapiclient$promise_api_client_module || {id:"javascript/typescript/contrib/apiclient/request_service/promise_api_client.closure.js"};
module$exports$eeapiclient$promise_api_client.PromiseApiClient = function(requestService, hookFactory) {
  this.requestService = requestService;
  this.hookFactory = void 0 === hookFactory ? null : hookFactory;
};
$jscomp.inherits(module$exports$eeapiclient$promise_api_client.PromiseApiClient, module$exports$eeapiclient$api_client.ApiClient);
module$exports$eeapiclient$promise_api_client.PromiseApiClient.prototype.$addHooksToRequest = function(requestParams, promise) {
  return null == module$contents$eeapiclient$api_request_hook_getRequestHook(this.hookFactory, requestParams) ? promise : promise.then(function(response) {
    return response;
  }, function(error) {
    throw error;
  });
};
module$exports$eeapiclient$promise_api_client.PromiseApiClient.prototype.$request = function(requestParams) {
  var responseCtor = requestParams.responseCtor || void 0;
  return this.$addHooksToRequest(requestParams, this.requestService.send(module$contents$eeapiclient$api_client_toMakeRequestParams(requestParams), responseCtor));
};
module$exports$eeapiclient$promise_api_client.PromiseApiClient.prototype.$uploadRequest = function(requestParams) {
  var $jscomp$this = this, responseCtor = requestParams.responseCtor || void 0;
  return this.$addHooksToRequest(requestParams, module$contents$eeapiclient$api_client_toMultipartMakeRequestParams(requestParams).then(function(params) {
    return $jscomp$this.requestService.send(params, responseCtor);
  }));
};
var module$exports$eeapiclient$ee_api_client = {}, module$contents$eeapiclient$ee_api_client_module = module$contents$eeapiclient$ee_api_client_module || {id:"geo/gestalt/client/javascript/ee_api_client.closure.js"};
module$exports$eeapiclient$ee_api_client.IAuditLogConfigLogTypeEnum = function module$contents$eeapiclient$ee_api_client_IAuditLogConfigLogTypeEnum() {
};
module$exports$eeapiclient$ee_api_client.AuditLogConfigLogTypeEnum = {ADMIN_READ:"ADMIN_READ", DATA_READ:"DATA_READ", DATA_WRITE:"DATA_WRITE", LOG_TYPE_UNSPECIFIED:"LOG_TYPE_UNSPECIFIED", values:function() {
  return [module$exports$eeapiclient$ee_api_client.AuditLogConfigLogTypeEnum.LOG_TYPE_UNSPECIFIED, module$exports$eeapiclient$ee_api_client.AuditLogConfigLogTypeEnum.ADMIN_READ, module$exports$eeapiclient$ee_api_client.AuditLogConfigLogTypeEnum.DATA_WRITE, module$exports$eeapiclient$ee_api_client.AuditLogConfigLogTypeEnum.DATA_READ];
}};
module$exports$eeapiclient$ee_api_client.IAuthorizationLoggingOptionsPermissionTypeEnum = function module$contents$eeapiclient$ee_api_client_IAuthorizationLoggingOptionsPermissionTypeEnum() {
};
module$exports$eeapiclient$ee_api_client.AuthorizationLoggingOptionsPermissionTypeEnum = {ADMIN_READ:"ADMIN_READ", ADMIN_WRITE:"ADMIN_WRITE", DATA_READ:"DATA_READ", DATA_WRITE:"DATA_WRITE", PERMISSION_TYPE_UNSPECIFIED:"PERMISSION_TYPE_UNSPECIFIED", values:function() {
  return [module$exports$eeapiclient$ee_api_client.AuthorizationLoggingOptionsPermissionTypeEnum.PERMISSION_TYPE_UNSPECIFIED, module$exports$eeapiclient$ee_api_client.AuthorizationLoggingOptionsPermissionTypeEnum.ADMIN_READ, module$exports$eeapiclient$ee_api_client.AuthorizationLoggingOptionsPermissionTypeEnum.ADMIN_WRITE, module$exports$eeapiclient$ee_api_client.AuthorizationLoggingOptionsPermissionTypeEnum.DATA_READ, 
  module$exports$eeapiclient$ee_api_client.AuthorizationLoggingOptionsPermissionTypeEnum.DATA_WRITE];
}};
module$exports$eeapiclient$ee_api_client.ICapabilitiesCapabilitiesEnum = function module$contents$eeapiclient$ee_api_client_ICapabilitiesCapabilitiesEnum() {
};
module$exports$eeapiclient$ee_api_client.CapabilitiesCapabilitiesEnum = {CAPABILITY_GROUP_UNSPECIFIED:"CAPABILITY_GROUP_UNSPECIFIED", CLOUD_ALPHA:"CLOUD_ALPHA", EXTERNAL:"EXTERNAL", INTERNAL:"INTERNAL", LIMITED:"LIMITED", PREAUTHORIZED:"PREAUTHORIZED", PREVIEW:"PREVIEW", PUBLIC:"PUBLIC", values:function() {
  return [module$exports$eeapiclient$ee_api_client.CapabilitiesCapabilitiesEnum.CAPABILITY_GROUP_UNSPECIFIED, module$exports$eeapiclient$ee_api_client.CapabilitiesCapabilitiesEnum.PUBLIC, module$exports$eeapiclient$ee_api_client.CapabilitiesCapabilitiesEnum.INTERNAL, module$exports$eeapiclient$ee_api_client.CapabilitiesCapabilitiesEnum.EXTERNAL, module$exports$eeapiclient$ee_api_client.CapabilitiesCapabilitiesEnum.LIMITED, 
  module$exports$eeapiclient$ee_api_client.CapabilitiesCapabilitiesEnum.PREAUTHORIZED, module$exports$eeapiclient$ee_api_client.CapabilitiesCapabilitiesEnum.PREVIEW, module$exports$eeapiclient$ee_api_client.CapabilitiesCapabilitiesEnum.CLOUD_ALPHA];
}};
module$exports$eeapiclient$ee_api_client.ICloudAuditOptionsLogNameEnum = function module$contents$eeapiclient$ee_api_client_ICloudAuditOptionsLogNameEnum() {
};
module$exports$eeapiclient$ee_api_client.CloudAuditOptionsLogNameEnum = {ADMIN_ACTIVITY:"ADMIN_ACTIVITY", DATA_ACCESS:"DATA_ACCESS", UNSPECIFIED_LOG_NAME:"UNSPECIFIED_LOG_NAME", values:function() {
  return [module$exports$eeapiclient$ee_api_client.CloudAuditOptionsLogNameEnum.UNSPECIFIED_LOG_NAME, module$exports$eeapiclient$ee_api_client.CloudAuditOptionsLogNameEnum.ADMIN_ACTIVITY, module$exports$eeapiclient$ee_api_client.CloudAuditOptionsLogNameEnum.DATA_ACCESS];
}};
module$exports$eeapiclient$ee_api_client.IComputePixelsRequestFileFormatEnum = function module$contents$eeapiclient$ee_api_client_IComputePixelsRequestFileFormatEnum() {
};
module$exports$eeapiclient$ee_api_client.ComputePixelsRequestFileFormatEnum = {AUTO_JPEG_PNG:"AUTO_JPEG_PNG", GEO_TIFF:"GEO_TIFF", IMAGE_FILE_FORMAT_UNSPECIFIED:"IMAGE_FILE_FORMAT_UNSPECIFIED", JPEG:"JPEG", MULTI_BAND_IMAGE_TILE:"MULTI_BAND_IMAGE_TILE", NPY:"NPY", PNG:"PNG", TF_RECORD_IMAGE:"TF_RECORD_IMAGE", ZIPPED_GEO_TIFF:"ZIPPED_GEO_TIFF", ZIPPED_GEO_TIFF_PER_BAND:"ZIPPED_GEO_TIFF_PER_BAND", values:function() {
  return [module$exports$eeapiclient$ee_api_client.ComputePixelsRequestFileFormatEnum.IMAGE_FILE_FORMAT_UNSPECIFIED, module$exports$eeapiclient$ee_api_client.ComputePixelsRequestFileFormatEnum.JPEG, module$exports$eeapiclient$ee_api_client.ComputePixelsRequestFileFormatEnum.PNG, module$exports$eeapiclient$ee_api_client.ComputePixelsRequestFileFormatEnum.AUTO_JPEG_PNG, module$exports$eeapiclient$ee_api_client.ComputePixelsRequestFileFormatEnum.NPY, 
  module$exports$eeapiclient$ee_api_client.ComputePixelsRequestFileFormatEnum.GEO_TIFF, module$exports$eeapiclient$ee_api_client.ComputePixelsRequestFileFormatEnum.TF_RECORD_IMAGE, module$exports$eeapiclient$ee_api_client.ComputePixelsRequestFileFormatEnum.MULTI_BAND_IMAGE_TILE, module$exports$eeapiclient$ee_api_client.ComputePixelsRequestFileFormatEnum.ZIPPED_GEO_TIFF, module$exports$eeapiclient$ee_api_client.ComputePixelsRequestFileFormatEnum.ZIPPED_GEO_TIFF_PER_BAND];
}};
module$exports$eeapiclient$ee_api_client.IConditionIamEnum = function module$contents$eeapiclient$ee_api_client_IConditionIamEnum() {
};
module$exports$eeapiclient$ee_api_client.ConditionIamEnum = {APPROVER:"APPROVER", ATTRIBUTION:"ATTRIBUTION", AUTHORITY:"AUTHORITY", CREDENTIALS_TYPE:"CREDENTIALS_TYPE", JUSTIFICATION_TYPE:"JUSTIFICATION_TYPE", NO_ATTR:"NO_ATTR", SECURITY_REALM:"SECURITY_REALM", values:function() {
  return [module$exports$eeapiclient$ee_api_client.ConditionIamEnum.NO_ATTR, module$exports$eeapiclient$ee_api_client.ConditionIamEnum.AUTHORITY, module$exports$eeapiclient$ee_api_client.ConditionIamEnum.ATTRIBUTION, module$exports$eeapiclient$ee_api_client.ConditionIamEnum.SECURITY_REALM, module$exports$eeapiclient$ee_api_client.ConditionIamEnum.APPROVER, module$exports$eeapiclient$ee_api_client.ConditionIamEnum.JUSTIFICATION_TYPE, 
  module$exports$eeapiclient$ee_api_client.ConditionIamEnum.CREDENTIALS_TYPE];
}};
module$exports$eeapiclient$ee_api_client.IConditionOpEnum = function module$contents$eeapiclient$ee_api_client_IConditionOpEnum() {
};
module$exports$eeapiclient$ee_api_client.ConditionOpEnum = {DISCHARGED:"DISCHARGED", EQUALS:"EQUALS", IN:"IN", NOT_EQUALS:"NOT_EQUALS", NOT_IN:"NOT_IN", NO_OP:"NO_OP", values:function() {
  return [module$exports$eeapiclient$ee_api_client.ConditionOpEnum.NO_OP, module$exports$eeapiclient$ee_api_client.ConditionOpEnum.EQUALS, module$exports$eeapiclient$ee_api_client.ConditionOpEnum.NOT_EQUALS, module$exports$eeapiclient$ee_api_client.ConditionOpEnum.IN, module$exports$eeapiclient$ee_api_client.ConditionOpEnum.NOT_IN, module$exports$eeapiclient$ee_api_client.ConditionOpEnum.DISCHARGED];
}};
module$exports$eeapiclient$ee_api_client.IConditionSysEnum = function module$contents$eeapiclient$ee_api_client_IConditionSysEnum() {
};
module$exports$eeapiclient$ee_api_client.ConditionSysEnum = {IP:"IP", NAME:"NAME", NO_ATTR:"NO_ATTR", REGION:"REGION", SERVICE:"SERVICE", values:function() {
  return [module$exports$eeapiclient$ee_api_client.ConditionSysEnum.NO_ATTR, module$exports$eeapiclient$ee_api_client.ConditionSysEnum.REGION, module$exports$eeapiclient$ee_api_client.ConditionSysEnum.SERVICE, module$exports$eeapiclient$ee_api_client.ConditionSysEnum.NAME, module$exports$eeapiclient$ee_api_client.ConditionSysEnum.IP];
}};
module$exports$eeapiclient$ee_api_client.IDataAccessOptionsLogModeEnum = function module$contents$eeapiclient$ee_api_client_IDataAccessOptionsLogModeEnum() {
};
module$exports$eeapiclient$ee_api_client.DataAccessOptionsLogModeEnum = {LOG_FAIL_CLOSED:"LOG_FAIL_CLOSED", LOG_MODE_UNSPECIFIED:"LOG_MODE_UNSPECIFIED", values:function() {
  return [module$exports$eeapiclient$ee_api_client.DataAccessOptionsLogModeEnum.LOG_MODE_UNSPECIFIED, module$exports$eeapiclient$ee_api_client.DataAccessOptionsLogModeEnum.LOG_FAIL_CLOSED];
}};
module$exports$eeapiclient$ee_api_client.IEarthEngineAssetTypeEnum = function module$contents$eeapiclient$ee_api_client_IEarthEngineAssetTypeEnum() {
};
module$exports$eeapiclient$ee_api_client.EarthEngineAssetTypeEnum = {FOLDER:"FOLDER", IMAGE:"IMAGE", IMAGE_COLLECTION:"IMAGE_COLLECTION", TABLE:"TABLE", TYPE_UNSPECIFIED:"TYPE_UNSPECIFIED", values:function() {
  return [module$exports$eeapiclient$ee_api_client.EarthEngineAssetTypeEnum.TYPE_UNSPECIFIED, module$exports$eeapiclient$ee_api_client.EarthEngineAssetTypeEnum.IMAGE, module$exports$eeapiclient$ee_api_client.EarthEngineAssetTypeEnum.IMAGE_COLLECTION, module$exports$eeapiclient$ee_api_client.EarthEngineAssetTypeEnum.TABLE, module$exports$eeapiclient$ee_api_client.EarthEngineAssetTypeEnum.FOLDER];
}};
module$exports$eeapiclient$ee_api_client.IEarthEngineMapFileFormatEnum = function module$contents$eeapiclient$ee_api_client_IEarthEngineMapFileFormatEnum() {
};
module$exports$eeapiclient$ee_api_client.EarthEngineMapFileFormatEnum = {AUTO_JPEG_PNG:"AUTO_JPEG_PNG", GEO_TIFF:"GEO_TIFF", IMAGE_FILE_FORMAT_UNSPECIFIED:"IMAGE_FILE_FORMAT_UNSPECIFIED", JPEG:"JPEG", MULTI_BAND_IMAGE_TILE:"MULTI_BAND_IMAGE_TILE", NPY:"NPY", PNG:"PNG", TF_RECORD_IMAGE:"TF_RECORD_IMAGE", ZIPPED_GEO_TIFF:"ZIPPED_GEO_TIFF", ZIPPED_GEO_TIFF_PER_BAND:"ZIPPED_GEO_TIFF_PER_BAND", values:function() {
  return [module$exports$eeapiclient$ee_api_client.EarthEngineMapFileFormatEnum.IMAGE_FILE_FORMAT_UNSPECIFIED, module$exports$eeapiclient$ee_api_client.EarthEngineMapFileFormatEnum.JPEG, module$exports$eeapiclient$ee_api_client.EarthEngineMapFileFormatEnum.PNG, module$exports$eeapiclient$ee_api_client.EarthEngineMapFileFormatEnum.AUTO_JPEG_PNG, module$exports$eeapiclient$ee_api_client.EarthEngineMapFileFormatEnum.NPY, 
  module$exports$eeapiclient$ee_api_client.EarthEngineMapFileFormatEnum.GEO_TIFF, module$exports$eeapiclient$ee_api_client.EarthEngineMapFileFormatEnum.TF_RECORD_IMAGE, module$exports$eeapiclient$ee_api_client.EarthEngineMapFileFormatEnum.MULTI_BAND_IMAGE_TILE, module$exports$eeapiclient$ee_api_client.EarthEngineMapFileFormatEnum.ZIPPED_GEO_TIFF, module$exports$eeapiclient$ee_api_client.EarthEngineMapFileFormatEnum.ZIPPED_GEO_TIFF_PER_BAND];
}};
module$exports$eeapiclient$ee_api_client.IExportVideoMapRequestVersionEnum = function module$contents$eeapiclient$ee_api_client_IExportVideoMapRequestVersionEnum() {
};
module$exports$eeapiclient$ee_api_client.ExportVideoMapRequestVersionEnum = {V1:"V1", V2:"V2", VERSION_UNSPECIFIED:"VERSION_UNSPECIFIED", values:function() {
  return [module$exports$eeapiclient$ee_api_client.ExportVideoMapRequestVersionEnum.VERSION_UNSPECIFIED, module$exports$eeapiclient$ee_api_client.ExportVideoMapRequestVersionEnum.V1, module$exports$eeapiclient$ee_api_client.ExportVideoMapRequestVersionEnum.V2];
}};
module$exports$eeapiclient$ee_api_client.IFilmstripThumbnailFileFormatEnum = function module$contents$eeapiclient$ee_api_client_IFilmstripThumbnailFileFormatEnum() {
};
module$exports$eeapiclient$ee_api_client.FilmstripThumbnailFileFormatEnum = {AUTO_JPEG_PNG:"AUTO_JPEG_PNG", GEO_TIFF:"GEO_TIFF", IMAGE_FILE_FORMAT_UNSPECIFIED:"IMAGE_FILE_FORMAT_UNSPECIFIED", JPEG:"JPEG", MULTI_BAND_IMAGE_TILE:"MULTI_BAND_IMAGE_TILE", NPY:"NPY", PNG:"PNG", TF_RECORD_IMAGE:"TF_RECORD_IMAGE", ZIPPED_GEO_TIFF:"ZIPPED_GEO_TIFF", ZIPPED_GEO_TIFF_PER_BAND:"ZIPPED_GEO_TIFF_PER_BAND", values:function() {
  return [module$exports$eeapiclient$ee_api_client.FilmstripThumbnailFileFormatEnum.IMAGE_FILE_FORMAT_UNSPECIFIED, module$exports$eeapiclient$ee_api_client.FilmstripThumbnailFileFormatEnum.JPEG, module$exports$eeapiclient$ee_api_client.FilmstripThumbnailFileFormatEnum.PNG, module$exports$eeapiclient$ee_api_client.FilmstripThumbnailFileFormatEnum.AUTO_JPEG_PNG, module$exports$eeapiclient$ee_api_client.FilmstripThumbnailFileFormatEnum.NPY, 
  module$exports$eeapiclient$ee_api_client.FilmstripThumbnailFileFormatEnum.GEO_TIFF, module$exports$eeapiclient$ee_api_client.FilmstripThumbnailFileFormatEnum.TF_RECORD_IMAGE, module$exports$eeapiclient$ee_api_client.FilmstripThumbnailFileFormatEnum.MULTI_BAND_IMAGE_TILE, module$exports$eeapiclient$ee_api_client.FilmstripThumbnailFileFormatEnum.ZIPPED_GEO_TIFF, module$exports$eeapiclient$ee_api_client.FilmstripThumbnailFileFormatEnum.ZIPPED_GEO_TIFF_PER_BAND];
}};
module$exports$eeapiclient$ee_api_client.IFilmstripThumbnailOrientationEnum = function module$contents$eeapiclient$ee_api_client_IFilmstripThumbnailOrientationEnum() {
};
module$exports$eeapiclient$ee_api_client.FilmstripThumbnailOrientationEnum = {HORIZONTAL:"HORIZONTAL", ORIENTATION_UNSPECIFIED:"ORIENTATION_UNSPECIFIED", VERTICAL:"VERTICAL", values:function() {
  return [module$exports$eeapiclient$ee_api_client.FilmstripThumbnailOrientationEnum.ORIENTATION_UNSPECIFIED, module$exports$eeapiclient$ee_api_client.FilmstripThumbnailOrientationEnum.HORIZONTAL, module$exports$eeapiclient$ee_api_client.FilmstripThumbnailOrientationEnum.VERTICAL];
}};
module$exports$eeapiclient$ee_api_client.IGcsDestinationPermissionsEnum = function module$contents$eeapiclient$ee_api_client_IGcsDestinationPermissionsEnum() {
};
module$exports$eeapiclient$ee_api_client.GcsDestinationPermissionsEnum = {DEFAULT_OBJECT_ACL:"DEFAULT_OBJECT_ACL", PUBLIC:"PUBLIC", TILE_PERMISSIONS_UNSPECIFIED:"TILE_PERMISSIONS_UNSPECIFIED", values:function() {
  return [module$exports$eeapiclient$ee_api_client.GcsDestinationPermissionsEnum.TILE_PERMISSIONS_UNSPECIFIED, module$exports$eeapiclient$ee_api_client.GcsDestinationPermissionsEnum.PUBLIC, module$exports$eeapiclient$ee_api_client.GcsDestinationPermissionsEnum.DEFAULT_OBJECT_ACL];
}};
module$exports$eeapiclient$ee_api_client.IGetPixelsRequestFileFormatEnum = function module$contents$eeapiclient$ee_api_client_IGetPixelsRequestFileFormatEnum() {
};
module$exports$eeapiclient$ee_api_client.GetPixelsRequestFileFormatEnum = {AUTO_JPEG_PNG:"AUTO_JPEG_PNG", GEO_TIFF:"GEO_TIFF", IMAGE_FILE_FORMAT_UNSPECIFIED:"IMAGE_FILE_FORMAT_UNSPECIFIED", JPEG:"JPEG", MULTI_BAND_IMAGE_TILE:"MULTI_BAND_IMAGE_TILE", NPY:"NPY", PNG:"PNG", TF_RECORD_IMAGE:"TF_RECORD_IMAGE", ZIPPED_GEO_TIFF:"ZIPPED_GEO_TIFF", ZIPPED_GEO_TIFF_PER_BAND:"ZIPPED_GEO_TIFF_PER_BAND", values:function() {
  return [module$exports$eeapiclient$ee_api_client.GetPixelsRequestFileFormatEnum.IMAGE_FILE_FORMAT_UNSPECIFIED, module$exports$eeapiclient$ee_api_client.GetPixelsRequestFileFormatEnum.JPEG, module$exports$eeapiclient$ee_api_client.GetPixelsRequestFileFormatEnum.PNG, module$exports$eeapiclient$ee_api_client.GetPixelsRequestFileFormatEnum.AUTO_JPEG_PNG, module$exports$eeapiclient$ee_api_client.GetPixelsRequestFileFormatEnum.NPY, 
  module$exports$eeapiclient$ee_api_client.GetPixelsRequestFileFormatEnum.GEO_TIFF, module$exports$eeapiclient$ee_api_client.GetPixelsRequestFileFormatEnum.TF_RECORD_IMAGE, module$exports$eeapiclient$ee_api_client.GetPixelsRequestFileFormatEnum.MULTI_BAND_IMAGE_TILE, module$exports$eeapiclient$ee_api_client.GetPixelsRequestFileFormatEnum.ZIPPED_GEO_TIFF, module$exports$eeapiclient$ee_api_client.GetPixelsRequestFileFormatEnum.ZIPPED_GEO_TIFF_PER_BAND];
}};
module$exports$eeapiclient$ee_api_client.IImageAssetExportOptionsPyramidingPolicyEnum = function module$contents$eeapiclient$ee_api_client_IImageAssetExportOptionsPyramidingPolicyEnum() {
};
module$exports$eeapiclient$ee_api_client.ImageAssetExportOptionsPyramidingPolicyEnum = {MAX:"MAX", MEAN:"MEAN", MIN:"MIN", MODE:"MODE", PYRAMIDING_POLICY_UNSPECIFIED:"PYRAMIDING_POLICY_UNSPECIFIED", SAMPLE:"SAMPLE", values:function() {
  return [module$exports$eeapiclient$ee_api_client.ImageAssetExportOptionsPyramidingPolicyEnum.PYRAMIDING_POLICY_UNSPECIFIED, module$exports$eeapiclient$ee_api_client.ImageAssetExportOptionsPyramidingPolicyEnum.MEAN, module$exports$eeapiclient$ee_api_client.ImageAssetExportOptionsPyramidingPolicyEnum.SAMPLE, module$exports$eeapiclient$ee_api_client.ImageAssetExportOptionsPyramidingPolicyEnum.MIN, 
  module$exports$eeapiclient$ee_api_client.ImageAssetExportOptionsPyramidingPolicyEnum.MAX, module$exports$eeapiclient$ee_api_client.ImageAssetExportOptionsPyramidingPolicyEnum.MODE];
}};
module$exports$eeapiclient$ee_api_client.IImageAssetExportOptionsPyramidingPolicyOverridesEnum = function module$contents$eeapiclient$ee_api_client_IImageAssetExportOptionsPyramidingPolicyOverridesEnum() {
};
module$exports$eeapiclient$ee_api_client.ImageAssetExportOptionsPyramidingPolicyOverridesEnum = {MAX:"MAX", MEAN:"MEAN", MIN:"MIN", MODE:"MODE", PYRAMIDING_POLICY_UNSPECIFIED:"PYRAMIDING_POLICY_UNSPECIFIED", SAMPLE:"SAMPLE", values:function() {
  return [module$exports$eeapiclient$ee_api_client.ImageAssetExportOptionsPyramidingPolicyOverridesEnum.PYRAMIDING_POLICY_UNSPECIFIED, module$exports$eeapiclient$ee_api_client.ImageAssetExportOptionsPyramidingPolicyOverridesEnum.MEAN, module$exports$eeapiclient$ee_api_client.ImageAssetExportOptionsPyramidingPolicyOverridesEnum.SAMPLE, module$exports$eeapiclient$ee_api_client.ImageAssetExportOptionsPyramidingPolicyOverridesEnum.MIN, 
  module$exports$eeapiclient$ee_api_client.ImageAssetExportOptionsPyramidingPolicyOverridesEnum.MAX, module$exports$eeapiclient$ee_api_client.ImageAssetExportOptionsPyramidingPolicyOverridesEnum.MODE];
}};
module$exports$eeapiclient$ee_api_client.IImageBandPyramidingPolicyEnum = function module$contents$eeapiclient$ee_api_client_IImageBandPyramidingPolicyEnum() {
};
module$exports$eeapiclient$ee_api_client.ImageBandPyramidingPolicyEnum = {MAX:"MAX", MEAN:"MEAN", MIN:"MIN", MODE:"MODE", PYRAMIDING_POLICY_UNSPECIFIED:"PYRAMIDING_POLICY_UNSPECIFIED", SAMPLE:"SAMPLE", values:function() {
  return [module$exports$eeapiclient$ee_api_client.ImageBandPyramidingPolicyEnum.PYRAMIDING_POLICY_UNSPECIFIED, module$exports$eeapiclient$ee_api_client.ImageBandPyramidingPolicyEnum.MEAN, module$exports$eeapiclient$ee_api_client.ImageBandPyramidingPolicyEnum.SAMPLE, module$exports$eeapiclient$ee_api_client.ImageBandPyramidingPolicyEnum.MIN, module$exports$eeapiclient$ee_api_client.ImageBandPyramidingPolicyEnum.MAX, 
  module$exports$eeapiclient$ee_api_client.ImageBandPyramidingPolicyEnum.MODE];
}};
module$exports$eeapiclient$ee_api_client.IImageFileExportOptionsFileFormatEnum = function module$contents$eeapiclient$ee_api_client_IImageFileExportOptionsFileFormatEnum() {
};
module$exports$eeapiclient$ee_api_client.ImageFileExportOptionsFileFormatEnum = {AUTO_JPEG_PNG:"AUTO_JPEG_PNG", GEO_TIFF:"GEO_TIFF", IMAGE_FILE_FORMAT_UNSPECIFIED:"IMAGE_FILE_FORMAT_UNSPECIFIED", JPEG:"JPEG", MULTI_BAND_IMAGE_TILE:"MULTI_BAND_IMAGE_TILE", NPY:"NPY", PNG:"PNG", TF_RECORD_IMAGE:"TF_RECORD_IMAGE", ZIPPED_GEO_TIFF:"ZIPPED_GEO_TIFF", ZIPPED_GEO_TIFF_PER_BAND:"ZIPPED_GEO_TIFF_PER_BAND", values:function() {
  return [module$exports$eeapiclient$ee_api_client.ImageFileExportOptionsFileFormatEnum.IMAGE_FILE_FORMAT_UNSPECIFIED, module$exports$eeapiclient$ee_api_client.ImageFileExportOptionsFileFormatEnum.JPEG, module$exports$eeapiclient$ee_api_client.ImageFileExportOptionsFileFormatEnum.PNG, module$exports$eeapiclient$ee_api_client.ImageFileExportOptionsFileFormatEnum.AUTO_JPEG_PNG, module$exports$eeapiclient$ee_api_client.ImageFileExportOptionsFileFormatEnum.NPY, 
  module$exports$eeapiclient$ee_api_client.ImageFileExportOptionsFileFormatEnum.GEO_TIFF, module$exports$eeapiclient$ee_api_client.ImageFileExportOptionsFileFormatEnum.TF_RECORD_IMAGE, module$exports$eeapiclient$ee_api_client.ImageFileExportOptionsFileFormatEnum.MULTI_BAND_IMAGE_TILE, module$exports$eeapiclient$ee_api_client.ImageFileExportOptionsFileFormatEnum.ZIPPED_GEO_TIFF, module$exports$eeapiclient$ee_api_client.ImageFileExportOptionsFileFormatEnum.ZIPPED_GEO_TIFF_PER_BAND];
}};
module$exports$eeapiclient$ee_api_client.IImageManifestPyramidingPolicyEnum = function module$contents$eeapiclient$ee_api_client_IImageManifestPyramidingPolicyEnum() {
};
module$exports$eeapiclient$ee_api_client.ImageManifestPyramidingPolicyEnum = {MAX:"MAX", MEAN:"MEAN", MIN:"MIN", MODE:"MODE", PYRAMIDING_POLICY_UNSPECIFIED:"PYRAMIDING_POLICY_UNSPECIFIED", SAMPLE:"SAMPLE", values:function() {
  return [module$exports$eeapiclient$ee_api_client.ImageManifestPyramidingPolicyEnum.PYRAMIDING_POLICY_UNSPECIFIED, module$exports$eeapiclient$ee_api_client.ImageManifestPyramidingPolicyEnum.MEAN, module$exports$eeapiclient$ee_api_client.ImageManifestPyramidingPolicyEnum.SAMPLE, module$exports$eeapiclient$ee_api_client.ImageManifestPyramidingPolicyEnum.MIN, module$exports$eeapiclient$ee_api_client.ImageManifestPyramidingPolicyEnum.MAX, 
  module$exports$eeapiclient$ee_api_client.ImageManifestPyramidingPolicyEnum.MODE];
}};
module$exports$eeapiclient$ee_api_client.IOperationMetadataStateEnum = function module$contents$eeapiclient$ee_api_client_IOperationMetadataStateEnum() {
};
module$exports$eeapiclient$ee_api_client.OperationMetadataStateEnum = {CANCELLED:"CANCELLED", CANCELLING:"CANCELLING", FAILED:"FAILED", PENDING:"PENDING", RUNNING:"RUNNING", STATE_UNSPECIFIED:"STATE_UNSPECIFIED", SUCCEEDED:"SUCCEEDED", values:function() {
  return [module$exports$eeapiclient$ee_api_client.OperationMetadataStateEnum.STATE_UNSPECIFIED, module$exports$eeapiclient$ee_api_client.OperationMetadataStateEnum.PENDING, module$exports$eeapiclient$ee_api_client.OperationMetadataStateEnum.RUNNING, module$exports$eeapiclient$ee_api_client.OperationMetadataStateEnum.CANCELLING, module$exports$eeapiclient$ee_api_client.OperationMetadataStateEnum.SUCCEEDED, 
  module$exports$eeapiclient$ee_api_client.OperationMetadataStateEnum.CANCELLED, module$exports$eeapiclient$ee_api_client.OperationMetadataStateEnum.FAILED];
}};
module$exports$eeapiclient$ee_api_client.IPixelDataTypePrecisionEnum = function module$contents$eeapiclient$ee_api_client_IPixelDataTypePrecisionEnum() {
};
module$exports$eeapiclient$ee_api_client.PixelDataTypePrecisionEnum = {DOUBLE:"DOUBLE", FLOAT:"FLOAT", INT:"INT", PRECISION_UNSPECIFIED:"PRECISION_UNSPECIFIED", values:function() {
  return [module$exports$eeapiclient$ee_api_client.PixelDataTypePrecisionEnum.PRECISION_UNSPECIFIED, module$exports$eeapiclient$ee_api_client.PixelDataTypePrecisionEnum.INT, module$exports$eeapiclient$ee_api_client.PixelDataTypePrecisionEnum.FLOAT, module$exports$eeapiclient$ee_api_client.PixelDataTypePrecisionEnum.DOUBLE];
}};
module$exports$eeapiclient$ee_api_client.IRuleActionEnum = function module$contents$eeapiclient$ee_api_client_IRuleActionEnum() {
};
module$exports$eeapiclient$ee_api_client.RuleActionEnum = {ALLOW:"ALLOW", ALLOW_WITH_LOG:"ALLOW_WITH_LOG", DENY:"DENY", DENY_WITH_LOG:"DENY_WITH_LOG", LOG:"LOG", NO_ACTION:"NO_ACTION", values:function() {
  return [module$exports$eeapiclient$ee_api_client.RuleActionEnum.NO_ACTION, module$exports$eeapiclient$ee_api_client.RuleActionEnum.ALLOW, module$exports$eeapiclient$ee_api_client.RuleActionEnum.ALLOW_WITH_LOG, module$exports$eeapiclient$ee_api_client.RuleActionEnum.DENY, module$exports$eeapiclient$ee_api_client.RuleActionEnum.DENY_WITH_LOG, module$exports$eeapiclient$ee_api_client.RuleActionEnum.LOG];
}};
module$exports$eeapiclient$ee_api_client.ITableFileExportOptionsFileFormatEnum = function module$contents$eeapiclient$ee_api_client_ITableFileExportOptionsFileFormatEnum() {
};
module$exports$eeapiclient$ee_api_client.TableFileExportOptionsFileFormatEnum = {CSV:"CSV", GEO_JSON:"GEO_JSON", KML:"KML", KMZ:"KMZ", SHP:"SHP", TABLE_FILE_FORMAT_UNSPECIFIED:"TABLE_FILE_FORMAT_UNSPECIFIED", TF_RECORD_TABLE:"TF_RECORD_TABLE", values:function() {
  return [module$exports$eeapiclient$ee_api_client.TableFileExportOptionsFileFormatEnum.TABLE_FILE_FORMAT_UNSPECIFIED, module$exports$eeapiclient$ee_api_client.TableFileExportOptionsFileFormatEnum.CSV, module$exports$eeapiclient$ee_api_client.TableFileExportOptionsFileFormatEnum.GEO_JSON, module$exports$eeapiclient$ee_api_client.TableFileExportOptionsFileFormatEnum.KML, module$exports$eeapiclient$ee_api_client.TableFileExportOptionsFileFormatEnum.KMZ, 
  module$exports$eeapiclient$ee_api_client.TableFileExportOptionsFileFormatEnum.SHP, module$exports$eeapiclient$ee_api_client.TableFileExportOptionsFileFormatEnum.TF_RECORD_TABLE];
}};
module$exports$eeapiclient$ee_api_client.ITableFileFormatEnum = function module$contents$eeapiclient$ee_api_client_ITableFileFormatEnum() {
};
module$exports$eeapiclient$ee_api_client.TableFileFormatEnum = {CSV:"CSV", GEO_JSON:"GEO_JSON", KML:"KML", KMZ:"KMZ", SHP:"SHP", TABLE_FILE_FORMAT_UNSPECIFIED:"TABLE_FILE_FORMAT_UNSPECIFIED", TF_RECORD_TABLE:"TF_RECORD_TABLE", values:function() {
  return [module$exports$eeapiclient$ee_api_client.TableFileFormatEnum.TABLE_FILE_FORMAT_UNSPECIFIED, module$exports$eeapiclient$ee_api_client.TableFileFormatEnum.CSV, module$exports$eeapiclient$ee_api_client.TableFileFormatEnum.GEO_JSON, module$exports$eeapiclient$ee_api_client.TableFileFormatEnum.KML, module$exports$eeapiclient$ee_api_client.TableFileFormatEnum.KMZ, 
  module$exports$eeapiclient$ee_api_client.TableFileFormatEnum.SHP, module$exports$eeapiclient$ee_api_client.TableFileFormatEnum.TF_RECORD_TABLE];
}};
module$exports$eeapiclient$ee_api_client.IThumbnailFileFormatEnum = function module$contents$eeapiclient$ee_api_client_IThumbnailFileFormatEnum() {
};
module$exports$eeapiclient$ee_api_client.ThumbnailFileFormatEnum = {AUTO_JPEG_PNG:"AUTO_JPEG_PNG", GEO_TIFF:"GEO_TIFF", IMAGE_FILE_FORMAT_UNSPECIFIED:"IMAGE_FILE_FORMAT_UNSPECIFIED", JPEG:"JPEG", MULTI_BAND_IMAGE_TILE:"MULTI_BAND_IMAGE_TILE", NPY:"NPY", PNG:"PNG", TF_RECORD_IMAGE:"TF_RECORD_IMAGE", ZIPPED_GEO_TIFF:"ZIPPED_GEO_TIFF", ZIPPED_GEO_TIFF_PER_BAND:"ZIPPED_GEO_TIFF_PER_BAND", values:function() {
  return [module$exports$eeapiclient$ee_api_client.ThumbnailFileFormatEnum.IMAGE_FILE_FORMAT_UNSPECIFIED, module$exports$eeapiclient$ee_api_client.ThumbnailFileFormatEnum.JPEG, module$exports$eeapiclient$ee_api_client.ThumbnailFileFormatEnum.PNG, module$exports$eeapiclient$ee_api_client.ThumbnailFileFormatEnum.AUTO_JPEG_PNG, module$exports$eeapiclient$ee_api_client.ThumbnailFileFormatEnum.NPY, 
  module$exports$eeapiclient$ee_api_client.ThumbnailFileFormatEnum.GEO_TIFF, module$exports$eeapiclient$ee_api_client.ThumbnailFileFormatEnum.TF_RECORD_IMAGE, module$exports$eeapiclient$ee_api_client.ThumbnailFileFormatEnum.MULTI_BAND_IMAGE_TILE, module$exports$eeapiclient$ee_api_client.ThumbnailFileFormatEnum.ZIPPED_GEO_TIFF, module$exports$eeapiclient$ee_api_client.ThumbnailFileFormatEnum.ZIPPED_GEO_TIFF_PER_BAND];
}};
module$exports$eeapiclient$ee_api_client.ITilesetBandPyramidingPolicyEnum = function module$contents$eeapiclient$ee_api_client_ITilesetBandPyramidingPolicyEnum() {
};
module$exports$eeapiclient$ee_api_client.TilesetBandPyramidingPolicyEnum = {MAX:"MAX", MEAN:"MEAN", MIN:"MIN", MODE:"MODE", PYRAMIDING_POLICY_UNSPECIFIED:"PYRAMIDING_POLICY_UNSPECIFIED", SAMPLE:"SAMPLE", values:function() {
  return [module$exports$eeapiclient$ee_api_client.TilesetBandPyramidingPolicyEnum.PYRAMIDING_POLICY_UNSPECIFIED, module$exports$eeapiclient$ee_api_client.TilesetBandPyramidingPolicyEnum.MEAN, module$exports$eeapiclient$ee_api_client.TilesetBandPyramidingPolicyEnum.SAMPLE, module$exports$eeapiclient$ee_api_client.TilesetBandPyramidingPolicyEnum.MIN, module$exports$eeapiclient$ee_api_client.TilesetBandPyramidingPolicyEnum.MAX, 
  module$exports$eeapiclient$ee_api_client.TilesetBandPyramidingPolicyEnum.MODE];
}};
module$exports$eeapiclient$ee_api_client.ITilesetDataTypeEnum = function module$contents$eeapiclient$ee_api_client_ITilesetDataTypeEnum() {
};
module$exports$eeapiclient$ee_api_client.TilesetDataTypeEnum = {DATA_TYPE_UNSPECIFIED:"DATA_TYPE_UNSPECIFIED", DOUBLE:"DOUBLE", FLOAT:"FLOAT", INT16:"INT16", INT32:"INT32", INT8:"INT8", UINT16:"UINT16", UINT32:"UINT32", UINT8:"UINT8", values:function() {
  return [module$exports$eeapiclient$ee_api_client.TilesetDataTypeEnum.DATA_TYPE_UNSPECIFIED, module$exports$eeapiclient$ee_api_client.TilesetDataTypeEnum.INT8, module$exports$eeapiclient$ee_api_client.TilesetDataTypeEnum.UINT8, module$exports$eeapiclient$ee_api_client.TilesetDataTypeEnum.INT16, module$exports$eeapiclient$ee_api_client.TilesetDataTypeEnum.UINT16, module$exports$eeapiclient$ee_api_client.TilesetDataTypeEnum.INT32, 
  module$exports$eeapiclient$ee_api_client.TilesetDataTypeEnum.UINT32, module$exports$eeapiclient$ee_api_client.TilesetDataTypeEnum.FLOAT, module$exports$eeapiclient$ee_api_client.TilesetDataTypeEnum.DOUBLE];
}};
module$exports$eeapiclient$ee_api_client.IVideoFileExportOptionsFileFormatEnum = function module$contents$eeapiclient$ee_api_client_IVideoFileExportOptionsFileFormatEnum() {
};
module$exports$eeapiclient$ee_api_client.VideoFileExportOptionsFileFormatEnum = {GIF:"GIF", MP4:"MP4", VIDEO_FILE_FORMAT_UNSPECIFIED:"VIDEO_FILE_FORMAT_UNSPECIFIED", VP9:"VP9", values:function() {
  return [module$exports$eeapiclient$ee_api_client.VideoFileExportOptionsFileFormatEnum.VIDEO_FILE_FORMAT_UNSPECIFIED, module$exports$eeapiclient$ee_api_client.VideoFileExportOptionsFileFormatEnum.MP4, module$exports$eeapiclient$ee_api_client.VideoFileExportOptionsFileFormatEnum.GIF, module$exports$eeapiclient$ee_api_client.VideoFileExportOptionsFileFormatEnum.VP9];
}};
module$exports$eeapiclient$ee_api_client.IVideoThumbnailFileFormatEnum = function module$contents$eeapiclient$ee_api_client_IVideoThumbnailFileFormatEnum() {
};
module$exports$eeapiclient$ee_api_client.VideoThumbnailFileFormatEnum = {GIF:"GIF", MP4:"MP4", VIDEO_FILE_FORMAT_UNSPECIFIED:"VIDEO_FILE_FORMAT_UNSPECIFIED", VP9:"VP9", values:function() {
  return [module$exports$eeapiclient$ee_api_client.VideoThumbnailFileFormatEnum.VIDEO_FILE_FORMAT_UNSPECIFIED, module$exports$eeapiclient$ee_api_client.VideoThumbnailFileFormatEnum.MP4, module$exports$eeapiclient$ee_api_client.VideoThumbnailFileFormatEnum.GIF, module$exports$eeapiclient$ee_api_client.VideoThumbnailFileFormatEnum.VP9];
}};
module$exports$eeapiclient$ee_api_client.AffineTransformParameters = function module$contents$eeapiclient$ee_api_client_AffineTransformParameters() {
};
module$exports$eeapiclient$ee_api_client.AffineTransform = function(parameters) {
  parameters = void 0 === parameters ? {} : parameters;
  module$exports$eeapiclient$domain_object.Serializable.call(this);
  this.Serializable$set("scaleX", null == parameters.scaleX ? null : parameters.scaleX);
  this.Serializable$set("shearX", null == parameters.shearX ? null : parameters.shearX);
  this.Serializable$set("translateX", null == parameters.translateX ? null : parameters.translateX);
  this.Serializable$set("shearY", null == parameters.shearY ? null : parameters.shearY);
  this.Serializable$set("scaleY", null == parameters.scaleY ? null : parameters.scaleY);
  this.Serializable$set("translateY", null == parameters.translateY ? null : parameters.translateY);
};
$jscomp.inherits(module$exports$eeapiclient$ee_api_client.AffineTransform, module$exports$eeapiclient$domain_object.Serializable);
module$exports$eeapiclient$ee_api_client.AffineTransform.prototype.getConstructor = function() {
  return module$exports$eeapiclient$ee_api_client.AffineTransform;
};
module$exports$eeapiclient$ee_api_client.AffineTransform.prototype.getPartialClassMetadata = function() {
  return {keys:"scaleX scaleY shearX shearY translateX translateY".split(" ")};
};
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.AffineTransform.prototype, {scaleX:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("scaleX") ? this.Serializable$get("scaleX") : null;
}, set:function(value) {
  this.Serializable$set("scaleX", value);
}}, scaleY:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("scaleY") ? this.Serializable$get("scaleY") : null;
}, set:function(value) {
  this.Serializable$set("scaleY", value);
}}, shearX:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("shearX") ? this.Serializable$get("shearX") : null;
}, set:function(value) {
  this.Serializable$set("shearX", value);
}}, shearY:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("shearY") ? this.Serializable$get("shearY") : null;
}, set:function(value) {
  this.Serializable$set("shearY", value);
}}, translateX:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("translateX") ? this.Serializable$get("translateX") : null;
}, set:function(value) {
  this.Serializable$set("translateX", value);
}}, translateY:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("translateY") ? this.Serializable$get("translateY") : null;
}, set:function(value) {
  this.Serializable$set("translateY", value);
}}});
module$exports$eeapiclient$ee_api_client.AlgorithmParameters = function module$contents$eeapiclient$ee_api_client_AlgorithmParameters() {
};
module$exports$eeapiclient$ee_api_client.Algorithm = function(parameters) {
  parameters = void 0 === parameters ? {} : parameters;
  module$exports$eeapiclient$domain_object.Serializable.call(this);
  this.Serializable$set("name", null == parameters.name ? null : parameters.name);
  this.Serializable$set("description", null == parameters.description ? null : parameters.description);
  this.Serializable$set("returnType", null == parameters.returnType ? null : parameters.returnType);
  this.Serializable$set("arguments", null == parameters.arguments ? null : parameters.arguments);
  this.Serializable$set("deprecated", null == parameters.deprecated ? null : parameters.deprecated);
  this.Serializable$set("deprecationReason", null == parameters.deprecationReason ? null : parameters.deprecationReason);
  this.Serializable$set("hidden", null == parameters.hidden ? null : parameters.hidden);
  this.Serializable$set("preview", null == parameters.preview ? null : parameters.preview);
  this.Serializable$set("sourceCodeUri", null == parameters.sourceCodeUri ? null : parameters.sourceCodeUri);
};
$jscomp.inherits(module$exports$eeapiclient$ee_api_client.Algorithm, module$exports$eeapiclient$domain_object.Serializable);
module$exports$eeapiclient$ee_api_client.Algorithm.prototype.getConstructor = function() {
  return module$exports$eeapiclient$ee_api_client.Algorithm;
};
module$exports$eeapiclient$ee_api_client.Algorithm.prototype.getPartialClassMetadata = function() {
  return {arrays:{arguments:module$exports$eeapiclient$ee_api_client.AlgorithmArgument}, keys:"arguments deprecated deprecationReason description hidden name preview returnType sourceCodeUri".split(" ")};
};
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.Algorithm.prototype, {arguments:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("arguments") ? this.Serializable$get("arguments") : null;
}, set:function(value) {
  this.Serializable$set("arguments", value);
}}, deprecated:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("deprecated") ? this.Serializable$get("deprecated") : null;
}, set:function(value) {
  this.Serializable$set("deprecated", value);
}}, deprecationReason:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("deprecationReason") ? this.Serializable$get("deprecationReason") : null;
}, set:function(value) {
  this.Serializable$set("deprecationReason", value);
}}, description:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("description") ? this.Serializable$get("description") : null;
}, set:function(value) {
  this.Serializable$set("description", value);
}}, hidden:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("hidden") ? this.Serializable$get("hidden") : null;
}, set:function(value) {
  this.Serializable$set("hidden", value);
}}, name:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("name") ? this.Serializable$get("name") : null;
}, set:function(value) {
  this.Serializable$set("name", value);
}}, preview:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("preview") ? this.Serializable$get("preview") : null;
}, set:function(value) {
  this.Serializable$set("preview", value);
}}, returnType:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("returnType") ? this.Serializable$get("returnType") : null;
}, set:function(value) {
  this.Serializable$set("returnType", value);
}}, sourceCodeUri:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("sourceCodeUri") ? this.Serializable$get("sourceCodeUri") : null;
}, set:function(value) {
  this.Serializable$set("sourceCodeUri", value);
}}});
module$exports$eeapiclient$ee_api_client.AlgorithmArgumentParameters = function module$contents$eeapiclient$ee_api_client_AlgorithmArgumentParameters() {
};
module$exports$eeapiclient$ee_api_client.AlgorithmArgument = function(parameters) {
  parameters = void 0 === parameters ? {} : parameters;
  module$exports$eeapiclient$domain_object.Serializable.call(this);
  this.Serializable$set("argumentName", null == parameters.argumentName ? null : parameters.argumentName);
  this.Serializable$set("type", null == parameters.type ? null : parameters.type);
  this.Serializable$set("description", null == parameters.description ? null : parameters.description);
  this.Serializable$set("optional", null == parameters.optional ? null : parameters.optional);
  this.Serializable$set("defaultValue", null == parameters.defaultValue ? null : parameters.defaultValue);
};
$jscomp.inherits(module$exports$eeapiclient$ee_api_client.AlgorithmArgument, module$exports$eeapiclient$domain_object.Serializable);
module$exports$eeapiclient$ee_api_client.AlgorithmArgument.prototype.getConstructor = function() {
  return module$exports$eeapiclient$ee_api_client.AlgorithmArgument;
};
module$exports$eeapiclient$ee_api_client.AlgorithmArgument.prototype.getPartialClassMetadata = function() {
  return {keys:["argumentName", "defaultValue", "description", "optional", "type"]};
};
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.AlgorithmArgument.prototype, {argumentName:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("argumentName") ? this.Serializable$get("argumentName") : null;
}, set:function(value) {
  this.Serializable$set("argumentName", value);
}}, defaultValue:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("defaultValue") ? this.Serializable$get("defaultValue") : null;
}, set:function(value) {
  this.Serializable$set("defaultValue", value);
}}, description:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("description") ? this.Serializable$get("description") : null;
}, set:function(value) {
  this.Serializable$set("description", value);
}}, optional:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("optional") ? this.Serializable$get("optional") : null;
}, set:function(value) {
  this.Serializable$set("optional", value);
}}, type:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("type") ? this.Serializable$get("type") : null;
}, set:function(value) {
  this.Serializable$set("type", value);
}}});
module$exports$eeapiclient$ee_api_client.ArrayValueParameters = function module$contents$eeapiclient$ee_api_client_ArrayValueParameters() {
};
module$exports$eeapiclient$ee_api_client.ArrayValue = function(parameters) {
  parameters = void 0 === parameters ? {} : parameters;
  module$exports$eeapiclient$domain_object.Serializable.call(this);
  this.Serializable$set("values", null == parameters.values ? null : parameters.values);
};
$jscomp.inherits(module$exports$eeapiclient$ee_api_client.ArrayValue, module$exports$eeapiclient$domain_object.Serializable);
module$exports$eeapiclient$ee_api_client.ArrayValue.prototype.getConstructor = function() {
  return module$exports$eeapiclient$ee_api_client.ArrayValue;
};
module$exports$eeapiclient$ee_api_client.ArrayValue.prototype.getPartialClassMetadata = function() {
  return {arrays:{values:module$exports$eeapiclient$ee_api_client.ValueNode}, keys:["values"]};
};
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.ArrayValue.prototype, {values:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("values") ? this.Serializable$get("values") : null;
}, set:function(value) {
  this.Serializable$set("values", value);
}}});
module$exports$eeapiclient$ee_api_client.AuditConfigParameters = function module$contents$eeapiclient$ee_api_client_AuditConfigParameters() {
};
module$exports$eeapiclient$ee_api_client.AuditConfig = function(parameters) {
  parameters = void 0 === parameters ? {} : parameters;
  module$exports$eeapiclient$domain_object.Serializable.call(this);
  this.Serializable$set("service", null == parameters.service ? null : parameters.service);
  this.Serializable$set("exemptedMembers", null == parameters.exemptedMembers ? null : parameters.exemptedMembers);
  this.Serializable$set("auditLogConfigs", null == parameters.auditLogConfigs ? null : parameters.auditLogConfigs);
};
$jscomp.inherits(module$exports$eeapiclient$ee_api_client.AuditConfig, module$exports$eeapiclient$domain_object.Serializable);
module$exports$eeapiclient$ee_api_client.AuditConfig.prototype.getConstructor = function() {
  return module$exports$eeapiclient$ee_api_client.AuditConfig;
};
module$exports$eeapiclient$ee_api_client.AuditConfig.prototype.getPartialClassMetadata = function() {
  return {arrays:{auditLogConfigs:module$exports$eeapiclient$ee_api_client.AuditLogConfig}, keys:["auditLogConfigs", "exemptedMembers", "service"]};
};
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.AuditConfig.prototype, {auditLogConfigs:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("auditLogConfigs") ? this.Serializable$get("auditLogConfigs") : null;
}, set:function(value) {
  this.Serializable$set("auditLogConfigs", value);
}}, exemptedMembers:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("exemptedMembers") ? this.Serializable$get("exemptedMembers") : null;
}, set:function(value) {
  this.Serializable$set("exemptedMembers", value);
}}, service:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("service") ? this.Serializable$get("service") : null;
}, set:function(value) {
  this.Serializable$set("service", value);
}}});
module$exports$eeapiclient$ee_api_client.AuditLogConfigParameters = function module$contents$eeapiclient$ee_api_client_AuditLogConfigParameters() {
};
module$exports$eeapiclient$ee_api_client.AuditLogConfig = function(parameters) {
  parameters = void 0 === parameters ? {} : parameters;
  module$exports$eeapiclient$domain_object.Serializable.call(this);
  this.Serializable$set("logType", null == parameters.logType ? null : parameters.logType);
  this.Serializable$set("exemptedMembers", null == parameters.exemptedMembers ? null : parameters.exemptedMembers);
  this.Serializable$set("ignoreChildExemptions", null == parameters.ignoreChildExemptions ? null : parameters.ignoreChildExemptions);
};
$jscomp.inherits(module$exports$eeapiclient$ee_api_client.AuditLogConfig, module$exports$eeapiclient$domain_object.Serializable);
module$exports$eeapiclient$ee_api_client.AuditLogConfig.prototype.getConstructor = function() {
  return module$exports$eeapiclient$ee_api_client.AuditLogConfig;
};
module$exports$eeapiclient$ee_api_client.AuditLogConfig.prototype.getPartialClassMetadata = function() {
  return {enums:{logType:module$exports$eeapiclient$ee_api_client.AuditLogConfigLogTypeEnum}, keys:["exemptedMembers", "ignoreChildExemptions", "logType"]};
};
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.AuditLogConfig.prototype, {exemptedMembers:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("exemptedMembers") ? this.Serializable$get("exemptedMembers") : null;
}, set:function(value) {
  this.Serializable$set("exemptedMembers", value);
}}, ignoreChildExemptions:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("ignoreChildExemptions") ? this.Serializable$get("ignoreChildExemptions") : null;
}, set:function(value) {
  this.Serializable$set("ignoreChildExemptions", value);
}}, logType:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("logType") ? this.Serializable$get("logType") : null;
}, set:function(value) {
  this.Serializable$set("logType", value);
}}});
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.AuditLogConfig, {LogType:{configurable:!0, enumerable:!0, get:function() {
  return module$exports$eeapiclient$ee_api_client.AuditLogConfigLogTypeEnum;
}}});
module$exports$eeapiclient$ee_api_client.AuthorizationLoggingOptionsParameters = function module$contents$eeapiclient$ee_api_client_AuthorizationLoggingOptionsParameters() {
};
module$exports$eeapiclient$ee_api_client.AuthorizationLoggingOptions = function(parameters) {
  parameters = void 0 === parameters ? {} : parameters;
  module$exports$eeapiclient$domain_object.Serializable.call(this);
  this.Serializable$set("permissionType", null == parameters.permissionType ? null : parameters.permissionType);
};
$jscomp.inherits(module$exports$eeapiclient$ee_api_client.AuthorizationLoggingOptions, module$exports$eeapiclient$domain_object.Serializable);
module$exports$eeapiclient$ee_api_client.AuthorizationLoggingOptions.prototype.getConstructor = function() {
  return module$exports$eeapiclient$ee_api_client.AuthorizationLoggingOptions;
};
module$exports$eeapiclient$ee_api_client.AuthorizationLoggingOptions.prototype.getPartialClassMetadata = function() {
  return {enums:{permissionType:module$exports$eeapiclient$ee_api_client.AuthorizationLoggingOptionsPermissionTypeEnum}, keys:["permissionType"]};
};
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.AuthorizationLoggingOptions.prototype, {permissionType:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("permissionType") ? this.Serializable$get("permissionType") : null;
}, set:function(value) {
  this.Serializable$set("permissionType", value);
}}});
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.AuthorizationLoggingOptions, {PermissionType:{configurable:!0, enumerable:!0, get:function() {
  return module$exports$eeapiclient$ee_api_client.AuthorizationLoggingOptionsPermissionTypeEnum;
}}});
module$exports$eeapiclient$ee_api_client.BindingParameters = function module$contents$eeapiclient$ee_api_client_BindingParameters() {
};
module$exports$eeapiclient$ee_api_client.Binding = function(parameters) {
  parameters = void 0 === parameters ? {} : parameters;
  module$exports$eeapiclient$domain_object.Serializable.call(this);
  this.Serializable$set("role", null == parameters.role ? null : parameters.role);
  this.Serializable$set("members", null == parameters.members ? null : parameters.members);
  this.Serializable$set("condition", null == parameters.condition ? null : parameters.condition);
};
$jscomp.inherits(module$exports$eeapiclient$ee_api_client.Binding, module$exports$eeapiclient$domain_object.Serializable);
module$exports$eeapiclient$ee_api_client.Binding.prototype.getConstructor = function() {
  return module$exports$eeapiclient$ee_api_client.Binding;
};
module$exports$eeapiclient$ee_api_client.Binding.prototype.getPartialClassMetadata = function() {
  return {keys:["condition", "members", "role"], objects:{condition:module$exports$eeapiclient$ee_api_client.Expr}};
};
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.Binding.prototype, {condition:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("condition") ? this.Serializable$get("condition") : null;
}, set:function(value) {
  this.Serializable$set("condition", value);
}}, members:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("members") ? this.Serializable$get("members") : null;
}, set:function(value) {
  this.Serializable$set("members", value);
}}, role:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("role") ? this.Serializable$get("role") : null;
}, set:function(value) {
  this.Serializable$set("role", value);
}}});
module$exports$eeapiclient$ee_api_client.CancelOperationRequestParameters = function module$contents$eeapiclient$ee_api_client_CancelOperationRequestParameters() {
};
module$exports$eeapiclient$ee_api_client.CancelOperationRequest = function(parameters) {
  parameters = void 0 === parameters ? {} : parameters;
  module$exports$eeapiclient$domain_object.Serializable.call(this);
};
$jscomp.inherits(module$exports$eeapiclient$ee_api_client.CancelOperationRequest, module$exports$eeapiclient$domain_object.Serializable);
module$exports$eeapiclient$ee_api_client.CancelOperationRequest.prototype.getConstructor = function() {
  return module$exports$eeapiclient$ee_api_client.CancelOperationRequest;
};
module$exports$eeapiclient$ee_api_client.CancelOperationRequest.prototype.getPartialClassMetadata = function() {
  return {keys:[]};
};
module$exports$eeapiclient$ee_api_client.CapabilitiesParameters = function module$contents$eeapiclient$ee_api_client_CapabilitiesParameters() {
};
module$exports$eeapiclient$ee_api_client.Capabilities = function(parameters) {
  parameters = void 0 === parameters ? {} : parameters;
  module$exports$eeapiclient$domain_object.Serializable.call(this);
  this.Serializable$set("capabilities", null == parameters.capabilities ? null : parameters.capabilities);
};
$jscomp.inherits(module$exports$eeapiclient$ee_api_client.Capabilities, module$exports$eeapiclient$domain_object.Serializable);
module$exports$eeapiclient$ee_api_client.Capabilities.prototype.getConstructor = function() {
  return module$exports$eeapiclient$ee_api_client.Capabilities;
};
module$exports$eeapiclient$ee_api_client.Capabilities.prototype.getPartialClassMetadata = function() {
  return {enums:{capabilities:module$exports$eeapiclient$ee_api_client.CapabilitiesCapabilitiesEnum}, keys:["capabilities"]};
};
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.Capabilities.prototype, {capabilities:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("capabilities") ? this.Serializable$get("capabilities") : null;
}, set:function(value) {
  this.Serializable$set("capabilities", value);
}}});
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.Capabilities, {Capabilities:{configurable:!0, enumerable:!0, get:function() {
  return module$exports$eeapiclient$ee_api_client.CapabilitiesCapabilitiesEnum;
}}});
module$exports$eeapiclient$ee_api_client.CloudAuditOptionsParameters = function module$contents$eeapiclient$ee_api_client_CloudAuditOptionsParameters() {
};
module$exports$eeapiclient$ee_api_client.CloudAuditOptions = function(parameters) {
  parameters = void 0 === parameters ? {} : parameters;
  module$exports$eeapiclient$domain_object.Serializable.call(this);
  this.Serializable$set("logName", null == parameters.logName ? null : parameters.logName);
  this.Serializable$set("authorizationLoggingOptions", null == parameters.authorizationLoggingOptions ? null : parameters.authorizationLoggingOptions);
};
$jscomp.inherits(module$exports$eeapiclient$ee_api_client.CloudAuditOptions, module$exports$eeapiclient$domain_object.Serializable);
module$exports$eeapiclient$ee_api_client.CloudAuditOptions.prototype.getConstructor = function() {
  return module$exports$eeapiclient$ee_api_client.CloudAuditOptions;
};
module$exports$eeapiclient$ee_api_client.CloudAuditOptions.prototype.getPartialClassMetadata = function() {
  return {enums:{logName:module$exports$eeapiclient$ee_api_client.CloudAuditOptionsLogNameEnum}, keys:["authorizationLoggingOptions", "logName"], objects:{authorizationLoggingOptions:module$exports$eeapiclient$ee_api_client.AuthorizationLoggingOptions}};
};
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.CloudAuditOptions.prototype, {authorizationLoggingOptions:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("authorizationLoggingOptions") ? this.Serializable$get("authorizationLoggingOptions") : null;
}, set:function(value) {
  this.Serializable$set("authorizationLoggingOptions", value);
}}, logName:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("logName") ? this.Serializable$get("logName") : null;
}, set:function(value) {
  this.Serializable$set("logName", value);
}}});
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.CloudAuditOptions, {LogName:{configurable:!0, enumerable:!0, get:function() {
  return module$exports$eeapiclient$ee_api_client.CloudAuditOptionsLogNameEnum;
}}});
module$exports$eeapiclient$ee_api_client.ComputeFeaturesRequestParameters = function module$contents$eeapiclient$ee_api_client_ComputeFeaturesRequestParameters() {
};
module$exports$eeapiclient$ee_api_client.ComputeFeaturesRequest = function(parameters) {
  parameters = void 0 === parameters ? {} : parameters;
  module$exports$eeapiclient$domain_object.Serializable.call(this);
  this.Serializable$set("expression", null == parameters.expression ? null : parameters.expression);
  this.Serializable$set("pageSize", null == parameters.pageSize ? null : parameters.pageSize);
  this.Serializable$set("pageToken", null == parameters.pageToken ? null : parameters.pageToken);
};
$jscomp.inherits(module$exports$eeapiclient$ee_api_client.ComputeFeaturesRequest, module$exports$eeapiclient$domain_object.Serializable);
module$exports$eeapiclient$ee_api_client.ComputeFeaturesRequest.prototype.getConstructor = function() {
  return module$exports$eeapiclient$ee_api_client.ComputeFeaturesRequest;
};
module$exports$eeapiclient$ee_api_client.ComputeFeaturesRequest.prototype.getPartialClassMetadata = function() {
  return {keys:["expression", "pageSize", "pageToken"], objects:{expression:module$exports$eeapiclient$ee_api_client.Expression}};
};
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.ComputeFeaturesRequest.prototype, {expression:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("expression") ? this.Serializable$get("expression") : null;
}, set:function(value) {
  this.Serializable$set("expression", value);
}}, pageSize:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("pageSize") ? this.Serializable$get("pageSize") : null;
}, set:function(value) {
  this.Serializable$set("pageSize", value);
}}, pageToken:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("pageToken") ? this.Serializable$get("pageToken") : null;
}, set:function(value) {
  this.Serializable$set("pageToken", value);
}}});
module$exports$eeapiclient$ee_api_client.ComputeFeaturesResponseParameters = function module$contents$eeapiclient$ee_api_client_ComputeFeaturesResponseParameters() {
};
module$exports$eeapiclient$ee_api_client.ComputeFeaturesResponse = function(parameters) {
  parameters = void 0 === parameters ? {} : parameters;
  module$exports$eeapiclient$domain_object.Serializable.call(this);
  this.Serializable$set("type", null == parameters.type ? null : parameters.type);
  this.Serializable$set("features", null == parameters.features ? null : parameters.features);
  this.Serializable$set("nextPageToken", null == parameters.nextPageToken ? null : parameters.nextPageToken);
};
$jscomp.inherits(module$exports$eeapiclient$ee_api_client.ComputeFeaturesResponse, module$exports$eeapiclient$domain_object.Serializable);
module$exports$eeapiclient$ee_api_client.ComputeFeaturesResponse.prototype.getConstructor = function() {
  return module$exports$eeapiclient$ee_api_client.ComputeFeaturesResponse;
};
module$exports$eeapiclient$ee_api_client.ComputeFeaturesResponse.prototype.getPartialClassMetadata = function() {
  return {arrays:{features:module$exports$eeapiclient$ee_api_client.Feature}, keys:["features", "nextPageToken", "type"]};
};
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.ComputeFeaturesResponse.prototype, {features:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("features") ? this.Serializable$get("features") : null;
}, set:function(value) {
  this.Serializable$set("features", value);
}}, nextPageToken:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("nextPageToken") ? this.Serializable$get("nextPageToken") : null;
}, set:function(value) {
  this.Serializable$set("nextPageToken", value);
}}, type:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("type") ? this.Serializable$get("type") : null;
}, set:function(value) {
  this.Serializable$set("type", value);
}}});
module$exports$eeapiclient$ee_api_client.ComputeImagesRequestParameters = function module$contents$eeapiclient$ee_api_client_ComputeImagesRequestParameters() {
};
module$exports$eeapiclient$ee_api_client.ComputeImagesRequest = function(parameters) {
  parameters = void 0 === parameters ? {} : parameters;
  module$exports$eeapiclient$domain_object.Serializable.call(this);
  this.Serializable$set("expression", null == parameters.expression ? null : parameters.expression);
  this.Serializable$set("pageSize", null == parameters.pageSize ? null : parameters.pageSize);
  this.Serializable$set("pageToken", null == parameters.pageToken ? null : parameters.pageToken);
};
$jscomp.inherits(module$exports$eeapiclient$ee_api_client.ComputeImagesRequest, module$exports$eeapiclient$domain_object.Serializable);
module$exports$eeapiclient$ee_api_client.ComputeImagesRequest.prototype.getConstructor = function() {
  return module$exports$eeapiclient$ee_api_client.ComputeImagesRequest;
};
module$exports$eeapiclient$ee_api_client.ComputeImagesRequest.prototype.getPartialClassMetadata = function() {
  return {keys:["expression", "pageSize", "pageToken"], objects:{expression:module$exports$eeapiclient$ee_api_client.Expression}};
};
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.ComputeImagesRequest.prototype, {expression:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("expression") ? this.Serializable$get("expression") : null;
}, set:function(value) {
  this.Serializable$set("expression", value);
}}, pageSize:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("pageSize") ? this.Serializable$get("pageSize") : null;
}, set:function(value) {
  this.Serializable$set("pageSize", value);
}}, pageToken:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("pageToken") ? this.Serializable$get("pageToken") : null;
}, set:function(value) {
  this.Serializable$set("pageToken", value);
}}});
module$exports$eeapiclient$ee_api_client.ComputeImagesResponseParameters = function module$contents$eeapiclient$ee_api_client_ComputeImagesResponseParameters() {
};
module$exports$eeapiclient$ee_api_client.ComputeImagesResponse = function(parameters) {
  parameters = void 0 === parameters ? {} : parameters;
  module$exports$eeapiclient$domain_object.Serializable.call(this);
  this.Serializable$set("images", null == parameters.images ? null : parameters.images);
  this.Serializable$set("nextPageToken", null == parameters.nextPageToken ? null : parameters.nextPageToken);
};
$jscomp.inherits(module$exports$eeapiclient$ee_api_client.ComputeImagesResponse, module$exports$eeapiclient$domain_object.Serializable);
module$exports$eeapiclient$ee_api_client.ComputeImagesResponse.prototype.getConstructor = function() {
  return module$exports$eeapiclient$ee_api_client.ComputeImagesResponse;
};
module$exports$eeapiclient$ee_api_client.ComputeImagesResponse.prototype.getPartialClassMetadata = function() {
  return {arrays:{images:module$exports$eeapiclient$ee_api_client.Image}, keys:["images", "nextPageToken"]};
};
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.ComputeImagesResponse.prototype, {images:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("images") ? this.Serializable$get("images") : null;
}, set:function(value) {
  this.Serializable$set("images", value);
}}, nextPageToken:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("nextPageToken") ? this.Serializable$get("nextPageToken") : null;
}, set:function(value) {
  this.Serializable$set("nextPageToken", value);
}}});
module$exports$eeapiclient$ee_api_client.ComputePixelsRequestParameters = function module$contents$eeapiclient$ee_api_client_ComputePixelsRequestParameters() {
};
module$exports$eeapiclient$ee_api_client.ComputePixelsRequest = function(parameters) {
  parameters = void 0 === parameters ? {} : parameters;
  module$exports$eeapiclient$domain_object.Serializable.call(this);
  this.Serializable$set("expression", null == parameters.expression ? null : parameters.expression);
  this.Serializable$set("fileFormat", null == parameters.fileFormat ? null : parameters.fileFormat);
  this.Serializable$set("grid", null == parameters.grid ? null : parameters.grid);
  this.Serializable$set("bandIds", null == parameters.bandIds ? null : parameters.bandIds);
  this.Serializable$set("visualizationOptions", null == parameters.visualizationOptions ? null : parameters.visualizationOptions);
};
$jscomp.inherits(module$exports$eeapiclient$ee_api_client.ComputePixelsRequest, module$exports$eeapiclient$domain_object.Serializable);
module$exports$eeapiclient$ee_api_client.ComputePixelsRequest.prototype.getConstructor = function() {
  return module$exports$eeapiclient$ee_api_client.ComputePixelsRequest;
};
module$exports$eeapiclient$ee_api_client.ComputePixelsRequest.prototype.getPartialClassMetadata = function() {
  return {enums:{fileFormat:module$exports$eeapiclient$ee_api_client.ComputePixelsRequestFileFormatEnum}, keys:["bandIds", "expression", "fileFormat", "grid", "visualizationOptions"], objects:{expression:module$exports$eeapiclient$ee_api_client.Expression, grid:module$exports$eeapiclient$ee_api_client.PixelGrid, visualizationOptions:module$exports$eeapiclient$ee_api_client.VisualizationOptions}};
};
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.ComputePixelsRequest.prototype, {bandIds:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("bandIds") ? this.Serializable$get("bandIds") : null;
}, set:function(value) {
  this.Serializable$set("bandIds", value);
}}, expression:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("expression") ? this.Serializable$get("expression") : null;
}, set:function(value) {
  this.Serializable$set("expression", value);
}}, fileFormat:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("fileFormat") ? this.Serializable$get("fileFormat") : null;
}, set:function(value) {
  this.Serializable$set("fileFormat", value);
}}, grid:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("grid") ? this.Serializable$get("grid") : null;
}, set:function(value) {
  this.Serializable$set("grid", value);
}}, visualizationOptions:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("visualizationOptions") ? this.Serializable$get("visualizationOptions") : null;
}, set:function(value) {
  this.Serializable$set("visualizationOptions", value);
}}});
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.ComputePixelsRequest, {FileFormat:{configurable:!0, enumerable:!0, get:function() {
  return module$exports$eeapiclient$ee_api_client.ComputePixelsRequestFileFormatEnum;
}}});
module$exports$eeapiclient$ee_api_client.ComputeValueRequestParameters = function module$contents$eeapiclient$ee_api_client_ComputeValueRequestParameters() {
};
module$exports$eeapiclient$ee_api_client.ComputeValueRequest = function(parameters) {
  parameters = void 0 === parameters ? {} : parameters;
  module$exports$eeapiclient$domain_object.Serializable.call(this);
  this.Serializable$set("expression", null == parameters.expression ? null : parameters.expression);
};
$jscomp.inherits(module$exports$eeapiclient$ee_api_client.ComputeValueRequest, module$exports$eeapiclient$domain_object.Serializable);
module$exports$eeapiclient$ee_api_client.ComputeValueRequest.prototype.getConstructor = function() {
  return module$exports$eeapiclient$ee_api_client.ComputeValueRequest;
};
module$exports$eeapiclient$ee_api_client.ComputeValueRequest.prototype.getPartialClassMetadata = function() {
  return {keys:["expression"], objects:{expression:module$exports$eeapiclient$ee_api_client.Expression}};
};
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.ComputeValueRequest.prototype, {expression:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("expression") ? this.Serializable$get("expression") : null;
}, set:function(value) {
  this.Serializable$set("expression", value);
}}});
module$exports$eeapiclient$ee_api_client.ComputeValueResponseParameters = function module$contents$eeapiclient$ee_api_client_ComputeValueResponseParameters() {
};
module$exports$eeapiclient$ee_api_client.ComputeValueResponse = function(parameters) {
  parameters = void 0 === parameters ? {} : parameters;
  module$exports$eeapiclient$domain_object.Serializable.call(this);
  this.Serializable$set("result", null == parameters.result ? null : parameters.result);
};
$jscomp.inherits(module$exports$eeapiclient$ee_api_client.ComputeValueResponse, module$exports$eeapiclient$domain_object.Serializable);
module$exports$eeapiclient$ee_api_client.ComputeValueResponse.prototype.getConstructor = function() {
  return module$exports$eeapiclient$ee_api_client.ComputeValueResponse;
};
module$exports$eeapiclient$ee_api_client.ComputeValueResponse.prototype.getPartialClassMetadata = function() {
  return {keys:["result"]};
};
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.ComputeValueResponse.prototype, {result:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("result") ? this.Serializable$get("result") : null;
}, set:function(value) {
  this.Serializable$set("result", value);
}}});
module$exports$eeapiclient$ee_api_client.ConditionParameters = function module$contents$eeapiclient$ee_api_client_ConditionParameters() {
};
module$exports$eeapiclient$ee_api_client.Condition = function(parameters) {
  parameters = void 0 === parameters ? {} : parameters;
  module$exports$eeapiclient$domain_object.Serializable.call(this);
  this.Serializable$set("iam", null == parameters.iam ? null : parameters.iam);
  this.Serializable$set("sys", null == parameters.sys ? null : parameters.sys);
  this.Serializable$set("svc", null == parameters.svc ? null : parameters.svc);
  this.Serializable$set("op", null == parameters.op ? null : parameters.op);
  this.Serializable$set("values", null == parameters.values ? null : parameters.values);
};
$jscomp.inherits(module$exports$eeapiclient$ee_api_client.Condition, module$exports$eeapiclient$domain_object.Serializable);
module$exports$eeapiclient$ee_api_client.Condition.prototype.getConstructor = function() {
  return module$exports$eeapiclient$ee_api_client.Condition;
};
module$exports$eeapiclient$ee_api_client.Condition.prototype.getPartialClassMetadata = function() {
  return {enums:{iam:module$exports$eeapiclient$ee_api_client.ConditionIamEnum, op:module$exports$eeapiclient$ee_api_client.ConditionOpEnum, sys:module$exports$eeapiclient$ee_api_client.ConditionSysEnum}, keys:["iam", "op", "svc", "sys", "values"]};
};
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.Condition.prototype, {iam:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("iam") ? this.Serializable$get("iam") : null;
}, set:function(value) {
  this.Serializable$set("iam", value);
}}, op:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("op") ? this.Serializable$get("op") : null;
}, set:function(value) {
  this.Serializable$set("op", value);
}}, svc:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("svc") ? this.Serializable$get("svc") : null;
}, set:function(value) {
  this.Serializable$set("svc", value);
}}, sys:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("sys") ? this.Serializable$get("sys") : null;
}, set:function(value) {
  this.Serializable$set("sys", value);
}}, values:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("values") ? this.Serializable$get("values") : null;
}, set:function(value) {
  this.Serializable$set("values", value);
}}});
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.Condition, {Iam:{configurable:!0, enumerable:!0, get:function() {
  return module$exports$eeapiclient$ee_api_client.ConditionIamEnum;
}}, Op:{configurable:!0, enumerable:!0, get:function() {
  return module$exports$eeapiclient$ee_api_client.ConditionOpEnum;
}}, Sys:{configurable:!0, enumerable:!0, get:function() {
  return module$exports$eeapiclient$ee_api_client.ConditionSysEnum;
}}});
module$exports$eeapiclient$ee_api_client.CopyAssetRequestParameters = function module$contents$eeapiclient$ee_api_client_CopyAssetRequestParameters() {
};
module$exports$eeapiclient$ee_api_client.CopyAssetRequest = function(parameters) {
  parameters = void 0 === parameters ? {} : parameters;
  module$exports$eeapiclient$domain_object.Serializable.call(this);
  this.Serializable$set("destinationName", null == parameters.destinationName ? null : parameters.destinationName);
  this.Serializable$set("overwrite", null == parameters.overwrite ? null : parameters.overwrite);
  this.Serializable$set("bandIds", null == parameters.bandIds ? null : parameters.bandIds);
};
$jscomp.inherits(module$exports$eeapiclient$ee_api_client.CopyAssetRequest, module$exports$eeapiclient$domain_object.Serializable);
module$exports$eeapiclient$ee_api_client.CopyAssetRequest.prototype.getConstructor = function() {
  return module$exports$eeapiclient$ee_api_client.CopyAssetRequest;
};
module$exports$eeapiclient$ee_api_client.CopyAssetRequest.prototype.getPartialClassMetadata = function() {
  return {keys:["bandIds", "destinationName", "overwrite"]};
};
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.CopyAssetRequest.prototype, {bandIds:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("bandIds") ? this.Serializable$get("bandIds") : null;
}, set:function(value) {
  this.Serializable$set("bandIds", value);
}}, destinationName:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("destinationName") ? this.Serializable$get("destinationName") : null;
}, set:function(value) {
  this.Serializable$set("destinationName", value);
}}, overwrite:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("overwrite") ? this.Serializable$get("overwrite") : null;
}, set:function(value) {
  this.Serializable$set("overwrite", value);
}}});
module$exports$eeapiclient$ee_api_client.CounterOptionsParameters = function module$contents$eeapiclient$ee_api_client_CounterOptionsParameters() {
};
module$exports$eeapiclient$ee_api_client.CounterOptions = function(parameters) {
  parameters = void 0 === parameters ? {} : parameters;
  module$exports$eeapiclient$domain_object.Serializable.call(this);
  this.Serializable$set("metric", null == parameters.metric ? null : parameters.metric);
  this.Serializable$set("field", null == parameters.field ? null : parameters.field);
  this.Serializable$set("customFields", null == parameters.customFields ? null : parameters.customFields);
};
$jscomp.inherits(module$exports$eeapiclient$ee_api_client.CounterOptions, module$exports$eeapiclient$domain_object.Serializable);
module$exports$eeapiclient$ee_api_client.CounterOptions.prototype.getConstructor = function() {
  return module$exports$eeapiclient$ee_api_client.CounterOptions;
};
module$exports$eeapiclient$ee_api_client.CounterOptions.prototype.getPartialClassMetadata = function() {
  return {arrays:{customFields:module$exports$eeapiclient$ee_api_client.CustomField}, keys:["customFields", "field", "metric"]};
};
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.CounterOptions.prototype, {customFields:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("customFields") ? this.Serializable$get("customFields") : null;
}, set:function(value) {
  this.Serializable$set("customFields", value);
}}, field:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("field") ? this.Serializable$get("field") : null;
}, set:function(value) {
  this.Serializable$set("field", value);
}}, metric:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("metric") ? this.Serializable$get("metric") : null;
}, set:function(value) {
  this.Serializable$set("metric", value);
}}});
module$exports$eeapiclient$ee_api_client.CustomFieldParameters = function module$contents$eeapiclient$ee_api_client_CustomFieldParameters() {
};
module$exports$eeapiclient$ee_api_client.CustomField = function(parameters) {
  parameters = void 0 === parameters ? {} : parameters;
  module$exports$eeapiclient$domain_object.Serializable.call(this);
  this.Serializable$set("name", null == parameters.name ? null : parameters.name);
  this.Serializable$set("value", null == parameters.value ? null : parameters.value);
};
$jscomp.inherits(module$exports$eeapiclient$ee_api_client.CustomField, module$exports$eeapiclient$domain_object.Serializable);
module$exports$eeapiclient$ee_api_client.CustomField.prototype.getConstructor = function() {
  return module$exports$eeapiclient$ee_api_client.CustomField;
};
module$exports$eeapiclient$ee_api_client.CustomField.prototype.getPartialClassMetadata = function() {
  return {keys:["name", "value"]};
};
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.CustomField.prototype, {name:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("name") ? this.Serializable$get("name") : null;
}, set:function(value) {
  this.Serializable$set("name", value);
}}, value:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("value") ? this.Serializable$get("value") : null;
}, set:function(value) {
  this.Serializable$set("value", value);
}}});
module$exports$eeapiclient$ee_api_client.DataAccessOptionsParameters = function module$contents$eeapiclient$ee_api_client_DataAccessOptionsParameters() {
};
module$exports$eeapiclient$ee_api_client.DataAccessOptions = function(parameters) {
  parameters = void 0 === parameters ? {} : parameters;
  module$exports$eeapiclient$domain_object.Serializable.call(this);
  this.Serializable$set("logMode", null == parameters.logMode ? null : parameters.logMode);
};
$jscomp.inherits(module$exports$eeapiclient$ee_api_client.DataAccessOptions, module$exports$eeapiclient$domain_object.Serializable);
module$exports$eeapiclient$ee_api_client.DataAccessOptions.prototype.getConstructor = function() {
  return module$exports$eeapiclient$ee_api_client.DataAccessOptions;
};
module$exports$eeapiclient$ee_api_client.DataAccessOptions.prototype.getPartialClassMetadata = function() {
  return {enums:{logMode:module$exports$eeapiclient$ee_api_client.DataAccessOptionsLogModeEnum}, keys:["logMode"]};
};
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.DataAccessOptions.prototype, {logMode:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("logMode") ? this.Serializable$get("logMode") : null;
}, set:function(value) {
  this.Serializable$set("logMode", value);
}}});
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.DataAccessOptions, {LogMode:{configurable:!0, enumerable:!0, get:function() {
  return module$exports$eeapiclient$ee_api_client.DataAccessOptionsLogModeEnum;
}}});
module$exports$eeapiclient$ee_api_client.DictionaryValueParameters = function module$contents$eeapiclient$ee_api_client_DictionaryValueParameters() {
};
module$exports$eeapiclient$ee_api_client.DictionaryValue = function(parameters) {
  parameters = void 0 === parameters ? {} : parameters;
  module$exports$eeapiclient$domain_object.Serializable.call(this);
  this.Serializable$set("values", null == parameters.values ? null : parameters.values);
};
$jscomp.inherits(module$exports$eeapiclient$ee_api_client.DictionaryValue, module$exports$eeapiclient$domain_object.Serializable);
module$exports$eeapiclient$ee_api_client.DictionaryValue.prototype.getConstructor = function() {
  return module$exports$eeapiclient$ee_api_client.DictionaryValue;
};
module$exports$eeapiclient$ee_api_client.DictionaryValue.prototype.getPartialClassMetadata = function() {
  return {keys:["values"], objectMaps:{values:{ctor:module$exports$eeapiclient$ee_api_client.ValueNode, isPropertyArray:!1, isSerializable:!0, isValueArray:!1}}};
};
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.DictionaryValue.prototype, {values:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("values") ? this.Serializable$get("values") : null;
}, set:function(value) {
  this.Serializable$set("values", value);
}}});
module$exports$eeapiclient$ee_api_client.DoubleRangeParameters = function module$contents$eeapiclient$ee_api_client_DoubleRangeParameters() {
};
module$exports$eeapiclient$ee_api_client.DoubleRange = function(parameters) {
  parameters = void 0 === parameters ? {} : parameters;
  module$exports$eeapiclient$domain_object.Serializable.call(this);
  this.Serializable$set("min", null == parameters.min ? null : parameters.min);
  this.Serializable$set("max", null == parameters.max ? null : parameters.max);
};
$jscomp.inherits(module$exports$eeapiclient$ee_api_client.DoubleRange, module$exports$eeapiclient$domain_object.Serializable);
module$exports$eeapiclient$ee_api_client.DoubleRange.prototype.getConstructor = function() {
  return module$exports$eeapiclient$ee_api_client.DoubleRange;
};
module$exports$eeapiclient$ee_api_client.DoubleRange.prototype.getPartialClassMetadata = function() {
  return {keys:["max", "min"]};
};
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.DoubleRange.prototype, {max:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("max") ? this.Serializable$get("max") : null;
}, set:function(value) {
  this.Serializable$set("max", value);
}}, min:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("min") ? this.Serializable$get("min") : null;
}, set:function(value) {
  this.Serializable$set("min", value);
}}});
module$exports$eeapiclient$ee_api_client.DriveDestinationParameters = function module$contents$eeapiclient$ee_api_client_DriveDestinationParameters() {
};
module$exports$eeapiclient$ee_api_client.DriveDestination = function(parameters) {
  parameters = void 0 === parameters ? {} : parameters;
  module$exports$eeapiclient$domain_object.Serializable.call(this);
  this.Serializable$set("folder", null == parameters.folder ? null : parameters.folder);
  this.Serializable$set("filenamePrefix", null == parameters.filenamePrefix ? null : parameters.filenamePrefix);
};
$jscomp.inherits(module$exports$eeapiclient$ee_api_client.DriveDestination, module$exports$eeapiclient$domain_object.Serializable);
module$exports$eeapiclient$ee_api_client.DriveDestination.prototype.getConstructor = function() {
  return module$exports$eeapiclient$ee_api_client.DriveDestination;
};
module$exports$eeapiclient$ee_api_client.DriveDestination.prototype.getPartialClassMetadata = function() {
  return {keys:["filenamePrefix", "folder"]};
};
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.DriveDestination.prototype, {filenamePrefix:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("filenamePrefix") ? this.Serializable$get("filenamePrefix") : null;
}, set:function(value) {
  this.Serializable$set("filenamePrefix", value);
}}, folder:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("folder") ? this.Serializable$get("folder") : null;
}, set:function(value) {
  this.Serializable$set("folder", value);
}}});
module$exports$eeapiclient$ee_api_client.EarthEngineAssetParameters = function module$contents$eeapiclient$ee_api_client_EarthEngineAssetParameters() {
};
module$exports$eeapiclient$ee_api_client.EarthEngineAsset = function(parameters) {
  parameters = void 0 === parameters ? {} : parameters;
  module$exports$eeapiclient$domain_object.Serializable.call(this);
  this.Serializable$set("type", null == parameters.type ? null : parameters.type);
  this.Serializable$set("name", null == parameters.name ? null : parameters.name);
  this.Serializable$set("id", null == parameters.id ? null : parameters.id);
  this.Serializable$set("updateTime", null == parameters.updateTime ? null : parameters.updateTime);
  this.Serializable$set("title", null == parameters.title ? null : parameters.title);
  this.Serializable$set("description", null == parameters.description ? null : parameters.description);
  this.Serializable$set("properties", null == parameters.properties ? null : parameters.properties);
  this.Serializable$set("startTime", null == parameters.startTime ? null : parameters.startTime);
  this.Serializable$set("endTime", null == parameters.endTime ? null : parameters.endTime);
  this.Serializable$set("geometry", null == parameters.geometry ? null : parameters.geometry);
  this.Serializable$set("bands", null == parameters.bands ? null : parameters.bands);
  this.Serializable$set("sizeBytes", null == parameters.sizeBytes ? null : parameters.sizeBytes);
  this.Serializable$set("quota", null == parameters.quota ? null : parameters.quota);
  this.Serializable$set("tilestoreEntry", null == parameters.tilestoreEntry ? null : parameters.tilestoreEntry);
  this.Serializable$set("gcsLocation", null == parameters.gcsLocation ? null : parameters.gcsLocation);
  this.Serializable$set("expression", null == parameters.expression ? null : parameters.expression);
};
$jscomp.inherits(module$exports$eeapiclient$ee_api_client.EarthEngineAsset, module$exports$eeapiclient$domain_object.Serializable);
module$exports$eeapiclient$ee_api_client.EarthEngineAsset.prototype.getConstructor = function() {
  return module$exports$eeapiclient$ee_api_client.EarthEngineAsset;
};
module$exports$eeapiclient$ee_api_client.EarthEngineAsset.prototype.getPartialClassMetadata = function() {
  return {arrays:{bands:module$exports$eeapiclient$ee_api_client.ImageBand}, enums:{type:module$exports$eeapiclient$ee_api_client.EarthEngineAssetTypeEnum}, keys:"bands description endTime expression gcsLocation geometry id name properties quota sizeBytes startTime tilestoreEntry title type updateTime".split(" "), objectMaps:{geometry:{ctor:null, isPropertyArray:!1, isSerializable:!1, isValueArray:!1}, properties:{ctor:null, isPropertyArray:!1, 
  isSerializable:!1, isValueArray:!1}}, objects:{expression:module$exports$eeapiclient$ee_api_client.Expression, gcsLocation:module$exports$eeapiclient$ee_api_client.GcsLocation, quota:module$exports$eeapiclient$ee_api_client.FolderQuota, tilestoreEntry:module$exports$eeapiclient$ee_api_client.TilestoreEntry}};
};
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.EarthEngineAsset.prototype, {bands:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("bands") ? this.Serializable$get("bands") : null;
}, set:function(value) {
  this.Serializable$set("bands", value);
}}, description:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("description") ? this.Serializable$get("description") : null;
}, set:function(value) {
  this.Serializable$set("description", value);
}}, endTime:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("endTime") ? this.Serializable$get("endTime") : null;
}, set:function(value) {
  this.Serializable$set("endTime", value);
}}, expression:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("expression") ? this.Serializable$get("expression") : null;
}, set:function(value) {
  this.Serializable$set("expression", value);
}}, gcsLocation:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("gcsLocation") ? this.Serializable$get("gcsLocation") : null;
}, set:function(value) {
  this.Serializable$set("gcsLocation", value);
}}, geometry:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("geometry") ? this.Serializable$get("geometry") : null;
}, set:function(value) {
  this.Serializable$set("geometry", value);
}}, id:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("id") ? this.Serializable$get("id") : null;
}, set:function(value) {
  this.Serializable$set("id", value);
}}, name:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("name") ? this.Serializable$get("name") : null;
}, set:function(value) {
  this.Serializable$set("name", value);
}}, properties:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("properties") ? this.Serializable$get("properties") : null;
}, set:function(value) {
  this.Serializable$set("properties", value);
}}, quota:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("quota") ? this.Serializable$get("quota") : null;
}, set:function(value) {
  this.Serializable$set("quota", value);
}}, sizeBytes:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("sizeBytes") ? this.Serializable$get("sizeBytes") : null;
}, set:function(value) {
  this.Serializable$set("sizeBytes", value);
}}, startTime:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("startTime") ? this.Serializable$get("startTime") : null;
}, set:function(value) {
  this.Serializable$set("startTime", value);
}}, tilestoreEntry:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("tilestoreEntry") ? this.Serializable$get("tilestoreEntry") : null;
}, set:function(value) {
  this.Serializable$set("tilestoreEntry", value);
}}, title:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("title") ? this.Serializable$get("title") : null;
}, set:function(value) {
  this.Serializable$set("title", value);
}}, type:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("type") ? this.Serializable$get("type") : null;
}, set:function(value) {
  this.Serializable$set("type", value);
}}, updateTime:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("updateTime") ? this.Serializable$get("updateTime") : null;
}, set:function(value) {
  this.Serializable$set("updateTime", value);
}}});
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.EarthEngineAsset, {Type:{configurable:!0, enumerable:!0, get:function() {
  return module$exports$eeapiclient$ee_api_client.EarthEngineAssetTypeEnum;
}}});
module$exports$eeapiclient$ee_api_client.EarthEngineDestinationParameters = function module$contents$eeapiclient$ee_api_client_EarthEngineDestinationParameters() {
};
module$exports$eeapiclient$ee_api_client.EarthEngineDestination = function(parameters) {
  parameters = void 0 === parameters ? {} : parameters;
  module$exports$eeapiclient$domain_object.Serializable.call(this);
  this.Serializable$set("name", null == parameters.name ? null : parameters.name);
};
$jscomp.inherits(module$exports$eeapiclient$ee_api_client.EarthEngineDestination, module$exports$eeapiclient$domain_object.Serializable);
module$exports$eeapiclient$ee_api_client.EarthEngineDestination.prototype.getConstructor = function() {
  return module$exports$eeapiclient$ee_api_client.EarthEngineDestination;
};
module$exports$eeapiclient$ee_api_client.EarthEngineDestination.prototype.getPartialClassMetadata = function() {
  return {keys:["name"]};
};
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.EarthEngineDestination.prototype, {name:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("name") ? this.Serializable$get("name") : null;
}, set:function(value) {
  this.Serializable$set("name", value);
}}});
module$exports$eeapiclient$ee_api_client.EarthEngineMapParameters = function module$contents$eeapiclient$ee_api_client_EarthEngineMapParameters() {
};
module$exports$eeapiclient$ee_api_client.EarthEngineMap = function(parameters) {
  parameters = void 0 === parameters ? {} : parameters;
  module$exports$eeapiclient$domain_object.Serializable.call(this);
  this.Serializable$set("name", null == parameters.name ? null : parameters.name);
  this.Serializable$set("expression", null == parameters.expression ? null : parameters.expression);
  this.Serializable$set("fileFormat", null == parameters.fileFormat ? null : parameters.fileFormat);
  this.Serializable$set("bandIds", null == parameters.bandIds ? null : parameters.bandIds);
  this.Serializable$set("visualizationOptions", null == parameters.visualizationOptions ? null : parameters.visualizationOptions);
};
$jscomp.inherits(module$exports$eeapiclient$ee_api_client.EarthEngineMap, module$exports$eeapiclient$domain_object.Serializable);
module$exports$eeapiclient$ee_api_client.EarthEngineMap.prototype.getConstructor = function() {
  return module$exports$eeapiclient$ee_api_client.EarthEngineMap;
};
module$exports$eeapiclient$ee_api_client.EarthEngineMap.prototype.getPartialClassMetadata = function() {
  return {enums:{fileFormat:module$exports$eeapiclient$ee_api_client.EarthEngineMapFileFormatEnum}, keys:["bandIds", "expression", "fileFormat", "name", "visualizationOptions"], objects:{expression:module$exports$eeapiclient$ee_api_client.Expression, visualizationOptions:module$exports$eeapiclient$ee_api_client.VisualizationOptions}};
};
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.EarthEngineMap.prototype, {bandIds:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("bandIds") ? this.Serializable$get("bandIds") : null;
}, set:function(value) {
  this.Serializable$set("bandIds", value);
}}, expression:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("expression") ? this.Serializable$get("expression") : null;
}, set:function(value) {
  this.Serializable$set("expression", value);
}}, fileFormat:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("fileFormat") ? this.Serializable$get("fileFormat") : null;
}, set:function(value) {
  this.Serializable$set("fileFormat", value);
}}, name:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("name") ? this.Serializable$get("name") : null;
}, set:function(value) {
  this.Serializable$set("name", value);
}}, visualizationOptions:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("visualizationOptions") ? this.Serializable$get("visualizationOptions") : null;
}, set:function(value) {
  this.Serializable$set("visualizationOptions", value);
}}});
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.EarthEngineMap, {FileFormat:{configurable:!0, enumerable:!0, get:function() {
  return module$exports$eeapiclient$ee_api_client.EarthEngineMapFileFormatEnum;
}}});
module$exports$eeapiclient$ee_api_client.EmptyParameters = function module$contents$eeapiclient$ee_api_client_EmptyParameters() {
};
module$exports$eeapiclient$ee_api_client.Empty = function(parameters) {
  parameters = void 0 === parameters ? {} : parameters;
  module$exports$eeapiclient$domain_object.Serializable.call(this);
};
$jscomp.inherits(module$exports$eeapiclient$ee_api_client.Empty, module$exports$eeapiclient$domain_object.Serializable);
module$exports$eeapiclient$ee_api_client.Empty.prototype.getConstructor = function() {
  return module$exports$eeapiclient$ee_api_client.Empty;
};
module$exports$eeapiclient$ee_api_client.Empty.prototype.getPartialClassMetadata = function() {
  return {keys:[]};
};
module$exports$eeapiclient$ee_api_client.ExportImageRequestParameters = function module$contents$eeapiclient$ee_api_client_ExportImageRequestParameters() {
};
module$exports$eeapiclient$ee_api_client.ExportImageRequest = function(parameters) {
  parameters = void 0 === parameters ? {} : parameters;
  module$exports$eeapiclient$domain_object.Serializable.call(this);
  this.Serializable$set("expression", null == parameters.expression ? null : parameters.expression);
  this.Serializable$set("description", null == parameters.description ? null : parameters.description);
  this.Serializable$set("fileExportOptions", null == parameters.fileExportOptions ? null : parameters.fileExportOptions);
  this.Serializable$set("assetExportOptions", null == parameters.assetExportOptions ? null : parameters.assetExportOptions);
  this.Serializable$set("maxPixels", null == parameters.maxPixels ? null : parameters.maxPixels);
  this.Serializable$set("grid", null == parameters.grid ? null : parameters.grid);
  this.Serializable$set("requestId", null == parameters.requestId ? null : parameters.requestId);
  this.Serializable$set("maxWorkerCount", null == parameters.maxWorkerCount ? null : parameters.maxWorkerCount);
};
$jscomp.inherits(module$exports$eeapiclient$ee_api_client.ExportImageRequest, module$exports$eeapiclient$domain_object.Serializable);
module$exports$eeapiclient$ee_api_client.ExportImageRequest.prototype.getConstructor = function() {
  return module$exports$eeapiclient$ee_api_client.ExportImageRequest;
};
module$exports$eeapiclient$ee_api_client.ExportImageRequest.prototype.getPartialClassMetadata = function() {
  return {keys:"assetExportOptions description expression fileExportOptions grid maxPixels maxWorkerCount requestId".split(" "), objects:{assetExportOptions:module$exports$eeapiclient$ee_api_client.ImageAssetExportOptions, expression:module$exports$eeapiclient$ee_api_client.Expression, fileExportOptions:module$exports$eeapiclient$ee_api_client.ImageFileExportOptions, grid:module$exports$eeapiclient$ee_api_client.PixelGrid}};
};
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.ExportImageRequest.prototype, {assetExportOptions:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("assetExportOptions") ? this.Serializable$get("assetExportOptions") : null;
}, set:function(value) {
  this.Serializable$set("assetExportOptions", value);
}}, description:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("description") ? this.Serializable$get("description") : null;
}, set:function(value) {
  this.Serializable$set("description", value);
}}, expression:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("expression") ? this.Serializable$get("expression") : null;
}, set:function(value) {
  this.Serializable$set("expression", value);
}}, fileExportOptions:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("fileExportOptions") ? this.Serializable$get("fileExportOptions") : null;
}, set:function(value) {
  this.Serializable$set("fileExportOptions", value);
}}, grid:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("grid") ? this.Serializable$get("grid") : null;
}, set:function(value) {
  this.Serializable$set("grid", value);
}}, maxPixels:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("maxPixels") ? this.Serializable$get("maxPixels") : null;
}, set:function(value) {
  this.Serializable$set("maxPixels", value);
}}, maxWorkerCount:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("maxWorkerCount") ? this.Serializable$get("maxWorkerCount") : null;
}, set:function(value) {
  this.Serializable$set("maxWorkerCount", value);
}}, requestId:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("requestId") ? this.Serializable$get("requestId") : null;
}, set:function(value) {
  this.Serializable$set("requestId", value);
}}});
module$exports$eeapiclient$ee_api_client.ExportMapRequestParameters = function module$contents$eeapiclient$ee_api_client_ExportMapRequestParameters() {
};
module$exports$eeapiclient$ee_api_client.ExportMapRequest = function(parameters) {
  parameters = void 0 === parameters ? {} : parameters;
  module$exports$eeapiclient$domain_object.Serializable.call(this);
  this.Serializable$set("expression", null == parameters.expression ? null : parameters.expression);
  this.Serializable$set("description", null == parameters.description ? null : parameters.description);
  this.Serializable$set("tileOptions", null == parameters.tileOptions ? null : parameters.tileOptions);
  this.Serializable$set("tileExportOptions", null == parameters.tileExportOptions ? null : parameters.tileExportOptions);
  this.Serializable$set("requestId", null == parameters.requestId ? null : parameters.requestId);
  this.Serializable$set("maxWorkerCount", null == parameters.maxWorkerCount ? null : parameters.maxWorkerCount);
};
$jscomp.inherits(module$exports$eeapiclient$ee_api_client.ExportMapRequest, module$exports$eeapiclient$domain_object.Serializable);
module$exports$eeapiclient$ee_api_client.ExportMapRequest.prototype.getConstructor = function() {
  return module$exports$eeapiclient$ee_api_client.ExportMapRequest;
};
module$exports$eeapiclient$ee_api_client.ExportMapRequest.prototype.getPartialClassMetadata = function() {
  return {keys:"description expression maxWorkerCount requestId tileExportOptions tileOptions".split(" "), objects:{expression:module$exports$eeapiclient$ee_api_client.Expression, tileExportOptions:module$exports$eeapiclient$ee_api_client.ImageFileExportOptions, tileOptions:module$exports$eeapiclient$ee_api_client.TileOptions}};
};
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.ExportMapRequest.prototype, {description:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("description") ? this.Serializable$get("description") : null;
}, set:function(value) {
  this.Serializable$set("description", value);
}}, expression:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("expression") ? this.Serializable$get("expression") : null;
}, set:function(value) {
  this.Serializable$set("expression", value);
}}, maxWorkerCount:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("maxWorkerCount") ? this.Serializable$get("maxWorkerCount") : null;
}, set:function(value) {
  this.Serializable$set("maxWorkerCount", value);
}}, requestId:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("requestId") ? this.Serializable$get("requestId") : null;
}, set:function(value) {
  this.Serializable$set("requestId", value);
}}, tileExportOptions:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("tileExportOptions") ? this.Serializable$get("tileExportOptions") : null;
}, set:function(value) {
  this.Serializable$set("tileExportOptions", value);
}}, tileOptions:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("tileOptions") ? this.Serializable$get("tileOptions") : null;
}, set:function(value) {
  this.Serializable$set("tileOptions", value);
}}});
module$exports$eeapiclient$ee_api_client.ExportTableRequestParameters = function module$contents$eeapiclient$ee_api_client_ExportTableRequestParameters() {
};
module$exports$eeapiclient$ee_api_client.ExportTableRequest = function(parameters) {
  parameters = void 0 === parameters ? {} : parameters;
  module$exports$eeapiclient$domain_object.Serializable.call(this);
  this.Serializable$set("expression", null == parameters.expression ? null : parameters.expression);
  this.Serializable$set("description", null == parameters.description ? null : parameters.description);
  this.Serializable$set("fileExportOptions", null == parameters.fileExportOptions ? null : parameters.fileExportOptions);
  this.Serializable$set("assetExportOptions", null == parameters.assetExportOptions ? null : parameters.assetExportOptions);
  this.Serializable$set("selectors", null == parameters.selectors ? null : parameters.selectors);
  this.Serializable$set("requestId", null == parameters.requestId ? null : parameters.requestId);
  this.Serializable$set("maxErrorMeters", null == parameters.maxErrorMeters ? null : parameters.maxErrorMeters);
  this.Serializable$set("maxWorkerCount", null == parameters.maxWorkerCount ? null : parameters.maxWorkerCount);
  this.Serializable$set("maxVertices", null == parameters.maxVertices ? null : parameters.maxVertices);
};
$jscomp.inherits(module$exports$eeapiclient$ee_api_client.ExportTableRequest, module$exports$eeapiclient$domain_object.Serializable);
module$exports$eeapiclient$ee_api_client.ExportTableRequest.prototype.getConstructor = function() {
  return module$exports$eeapiclient$ee_api_client.ExportTableRequest;
};
module$exports$eeapiclient$ee_api_client.ExportTableRequest.prototype.getPartialClassMetadata = function() {
  return {keys:"assetExportOptions description expression fileExportOptions maxErrorMeters maxVertices maxWorkerCount requestId selectors".split(" "), objects:{assetExportOptions:module$exports$eeapiclient$ee_api_client.TableAssetExportOptions, expression:module$exports$eeapiclient$ee_api_client.Expression, fileExportOptions:module$exports$eeapiclient$ee_api_client.TableFileExportOptions}};
};
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.ExportTableRequest.prototype, {assetExportOptions:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("assetExportOptions") ? this.Serializable$get("assetExportOptions") : null;
}, set:function(value) {
  this.Serializable$set("assetExportOptions", value);
}}, description:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("description") ? this.Serializable$get("description") : null;
}, set:function(value) {
  this.Serializable$set("description", value);
}}, expression:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("expression") ? this.Serializable$get("expression") : null;
}, set:function(value) {
  this.Serializable$set("expression", value);
}}, fileExportOptions:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("fileExportOptions") ? this.Serializable$get("fileExportOptions") : null;
}, set:function(value) {
  this.Serializable$set("fileExportOptions", value);
}}, maxErrorMeters:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("maxErrorMeters") ? this.Serializable$get("maxErrorMeters") : null;
}, set:function(value) {
  this.Serializable$set("maxErrorMeters", value);
}}, maxVertices:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("maxVertices") ? this.Serializable$get("maxVertices") : null;
}, set:function(value) {
  this.Serializable$set("maxVertices", value);
}}, maxWorkerCount:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("maxWorkerCount") ? this.Serializable$get("maxWorkerCount") : null;
}, set:function(value) {
  this.Serializable$set("maxWorkerCount", value);
}}, requestId:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("requestId") ? this.Serializable$get("requestId") : null;
}, set:function(value) {
  this.Serializable$set("requestId", value);
}}, selectors:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("selectors") ? this.Serializable$get("selectors") : null;
}, set:function(value) {
  this.Serializable$set("selectors", value);
}}});
module$exports$eeapiclient$ee_api_client.ExportVideoMapRequestParameters = function module$contents$eeapiclient$ee_api_client_ExportVideoMapRequestParameters() {
};
module$exports$eeapiclient$ee_api_client.ExportVideoMapRequest = function(parameters) {
  parameters = void 0 === parameters ? {} : parameters;
  module$exports$eeapiclient$domain_object.Serializable.call(this);
  this.Serializable$set("expression", null == parameters.expression ? null : parameters.expression);
  this.Serializable$set("description", null == parameters.description ? null : parameters.description);
  this.Serializable$set("videoOptions", null == parameters.videoOptions ? null : parameters.videoOptions);
  this.Serializable$set("tileOptions", null == parameters.tileOptions ? null : parameters.tileOptions);
  this.Serializable$set("tileExportOptions", null == parameters.tileExportOptions ? null : parameters.tileExportOptions);
  this.Serializable$set("requestId", null == parameters.requestId ? null : parameters.requestId);
  this.Serializable$set("version", null == parameters.version ? null : parameters.version);
  this.Serializable$set("maxWorkerCount", null == parameters.maxWorkerCount ? null : parameters.maxWorkerCount);
};
$jscomp.inherits(module$exports$eeapiclient$ee_api_client.ExportVideoMapRequest, module$exports$eeapiclient$domain_object.Serializable);
module$exports$eeapiclient$ee_api_client.ExportVideoMapRequest.prototype.getConstructor = function() {
  return module$exports$eeapiclient$ee_api_client.ExportVideoMapRequest;
};
module$exports$eeapiclient$ee_api_client.ExportVideoMapRequest.prototype.getPartialClassMetadata = function() {
  return {enums:{version:module$exports$eeapiclient$ee_api_client.ExportVideoMapRequestVersionEnum}, keys:"description expression maxWorkerCount requestId tileExportOptions tileOptions version videoOptions".split(" "), objects:{expression:module$exports$eeapiclient$ee_api_client.Expression, tileExportOptions:module$exports$eeapiclient$ee_api_client.VideoFileExportOptions, tileOptions:module$exports$eeapiclient$ee_api_client.TileOptions, 
  videoOptions:module$exports$eeapiclient$ee_api_client.VideoOptions}};
};
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.ExportVideoMapRequest.prototype, {description:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("description") ? this.Serializable$get("description") : null;
}, set:function(value) {
  this.Serializable$set("description", value);
}}, expression:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("expression") ? this.Serializable$get("expression") : null;
}, set:function(value) {
  this.Serializable$set("expression", value);
}}, maxWorkerCount:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("maxWorkerCount") ? this.Serializable$get("maxWorkerCount") : null;
}, set:function(value) {
  this.Serializable$set("maxWorkerCount", value);
}}, requestId:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("requestId") ? this.Serializable$get("requestId") : null;
}, set:function(value) {
  this.Serializable$set("requestId", value);
}}, tileExportOptions:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("tileExportOptions") ? this.Serializable$get("tileExportOptions") : null;
}, set:function(value) {
  this.Serializable$set("tileExportOptions", value);
}}, tileOptions:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("tileOptions") ? this.Serializable$get("tileOptions") : null;
}, set:function(value) {
  this.Serializable$set("tileOptions", value);
}}, version:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("version") ? this.Serializable$get("version") : null;
}, set:function(value) {
  this.Serializable$set("version", value);
}}, videoOptions:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("videoOptions") ? this.Serializable$get("videoOptions") : null;
}, set:function(value) {
  this.Serializable$set("videoOptions", value);
}}});
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.ExportVideoMapRequest, {Version:{configurable:!0, enumerable:!0, get:function() {
  return module$exports$eeapiclient$ee_api_client.ExportVideoMapRequestVersionEnum;
}}});
module$exports$eeapiclient$ee_api_client.ExportVideoRequestParameters = function module$contents$eeapiclient$ee_api_client_ExportVideoRequestParameters() {
};
module$exports$eeapiclient$ee_api_client.ExportVideoRequest = function(parameters) {
  parameters = void 0 === parameters ? {} : parameters;
  module$exports$eeapiclient$domain_object.Serializable.call(this);
  this.Serializable$set("expression", null == parameters.expression ? null : parameters.expression);
  this.Serializable$set("description", null == parameters.description ? null : parameters.description);
  this.Serializable$set("videoOptions", null == parameters.videoOptions ? null : parameters.videoOptions);
  this.Serializable$set("fileExportOptions", null == parameters.fileExportOptions ? null : parameters.fileExportOptions);
  this.Serializable$set("requestId", null == parameters.requestId ? null : parameters.requestId);
  this.Serializable$set("maxWorkerCount", null == parameters.maxWorkerCount ? null : parameters.maxWorkerCount);
};
$jscomp.inherits(module$exports$eeapiclient$ee_api_client.ExportVideoRequest, module$exports$eeapiclient$domain_object.Serializable);
module$exports$eeapiclient$ee_api_client.ExportVideoRequest.prototype.getConstructor = function() {
  return module$exports$eeapiclient$ee_api_client.ExportVideoRequest;
};
module$exports$eeapiclient$ee_api_client.ExportVideoRequest.prototype.getPartialClassMetadata = function() {
  return {keys:"description expression fileExportOptions maxWorkerCount requestId videoOptions".split(" "), objects:{expression:module$exports$eeapiclient$ee_api_client.Expression, fileExportOptions:module$exports$eeapiclient$ee_api_client.VideoFileExportOptions, videoOptions:module$exports$eeapiclient$ee_api_client.VideoOptions}};
};
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.ExportVideoRequest.prototype, {description:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("description") ? this.Serializable$get("description") : null;
}, set:function(value) {
  this.Serializable$set("description", value);
}}, expression:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("expression") ? this.Serializable$get("expression") : null;
}, set:function(value) {
  this.Serializable$set("expression", value);
}}, fileExportOptions:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("fileExportOptions") ? this.Serializable$get("fileExportOptions") : null;
}, set:function(value) {
  this.Serializable$set("fileExportOptions", value);
}}, maxWorkerCount:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("maxWorkerCount") ? this.Serializable$get("maxWorkerCount") : null;
}, set:function(value) {
  this.Serializable$set("maxWorkerCount", value);
}}, requestId:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("requestId") ? this.Serializable$get("requestId") : null;
}, set:function(value) {
  this.Serializable$set("requestId", value);
}}, videoOptions:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("videoOptions") ? this.Serializable$get("videoOptions") : null;
}, set:function(value) {
  this.Serializable$set("videoOptions", value);
}}});
module$exports$eeapiclient$ee_api_client.ExprParameters = function module$contents$eeapiclient$ee_api_client_ExprParameters() {
};
module$exports$eeapiclient$ee_api_client.Expr = function(parameters) {
  parameters = void 0 === parameters ? {} : parameters;
  module$exports$eeapiclient$domain_object.Serializable.call(this);
  this.Serializable$set("expression", null == parameters.expression ? null : parameters.expression);
  this.Serializable$set("title", null == parameters.title ? null : parameters.title);
  this.Serializable$set("description", null == parameters.description ? null : parameters.description);
  this.Serializable$set("location", null == parameters.location ? null : parameters.location);
};
$jscomp.inherits(module$exports$eeapiclient$ee_api_client.Expr, module$exports$eeapiclient$domain_object.Serializable);
module$exports$eeapiclient$ee_api_client.Expr.prototype.getConstructor = function() {
  return module$exports$eeapiclient$ee_api_client.Expr;
};
module$exports$eeapiclient$ee_api_client.Expr.prototype.getPartialClassMetadata = function() {
  return {keys:["description", "expression", "location", "title"]};
};
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.Expr.prototype, {description:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("description") ? this.Serializable$get("description") : null;
}, set:function(value) {
  this.Serializable$set("description", value);
}}, expression:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("expression") ? this.Serializable$get("expression") : null;
}, set:function(value) {
  this.Serializable$set("expression", value);
}}, location:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("location") ? this.Serializable$get("location") : null;
}, set:function(value) {
  this.Serializable$set("location", value);
}}, title:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("title") ? this.Serializable$get("title") : null;
}, set:function(value) {
  this.Serializable$set("title", value);
}}});
module$exports$eeapiclient$ee_api_client.ExpressionParameters = function module$contents$eeapiclient$ee_api_client_ExpressionParameters() {
};
module$exports$eeapiclient$ee_api_client.Expression = function(parameters) {
  parameters = void 0 === parameters ? {} : parameters;
  module$exports$eeapiclient$domain_object.Serializable.call(this);
  this.Serializable$set("values", null == parameters.values ? null : parameters.values);
  this.Serializable$set("result", null == parameters.result ? null : parameters.result);
};
$jscomp.inherits(module$exports$eeapiclient$ee_api_client.Expression, module$exports$eeapiclient$domain_object.Serializable);
module$exports$eeapiclient$ee_api_client.Expression.prototype.getConstructor = function() {
  return module$exports$eeapiclient$ee_api_client.Expression;
};
module$exports$eeapiclient$ee_api_client.Expression.prototype.getPartialClassMetadata = function() {
  return {keys:["result", "values"], objectMaps:{values:{ctor:module$exports$eeapiclient$ee_api_client.ValueNode, isPropertyArray:!1, isSerializable:!0, isValueArray:!1}}};
};
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.Expression.prototype, {result:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("result") ? this.Serializable$get("result") : null;
}, set:function(value) {
  this.Serializable$set("result", value);
}}, values:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("values") ? this.Serializable$get("values") : null;
}, set:function(value) {
  this.Serializable$set("values", value);
}}});
module$exports$eeapiclient$ee_api_client.FeatureParameters = function module$contents$eeapiclient$ee_api_client_FeatureParameters() {
};
module$exports$eeapiclient$ee_api_client.Feature = function(parameters) {
  parameters = void 0 === parameters ? {} : parameters;
  module$exports$eeapiclient$domain_object.Serializable.call(this);
  this.Serializable$set("type", null == parameters.type ? null : parameters.type);
  this.Serializable$set("geometry", null == parameters.geometry ? null : parameters.geometry);
  this.Serializable$set("properties", null == parameters.properties ? null : parameters.properties);
};
$jscomp.inherits(module$exports$eeapiclient$ee_api_client.Feature, module$exports$eeapiclient$domain_object.Serializable);
module$exports$eeapiclient$ee_api_client.Feature.prototype.getConstructor = function() {
  return module$exports$eeapiclient$ee_api_client.Feature;
};
module$exports$eeapiclient$ee_api_client.Feature.prototype.getPartialClassMetadata = function() {
  return {keys:["geometry", "properties", "type"]};
};
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.Feature.prototype, {geometry:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("geometry") ? this.Serializable$get("geometry") : null;
}, set:function(value) {
  this.Serializable$set("geometry", value);
}}, properties:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("properties") ? this.Serializable$get("properties") : null;
}, set:function(value) {
  this.Serializable$set("properties", value);
}}, type:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("type") ? this.Serializable$get("type") : null;
}, set:function(value) {
  this.Serializable$set("type", value);
}}});
module$exports$eeapiclient$ee_api_client.FilmstripThumbnailParameters = function module$contents$eeapiclient$ee_api_client_FilmstripThumbnailParameters() {
};
module$exports$eeapiclient$ee_api_client.FilmstripThumbnail = function(parameters) {
  parameters = void 0 === parameters ? {} : parameters;
  module$exports$eeapiclient$domain_object.Serializable.call(this);
  this.Serializable$set("name", null == parameters.name ? null : parameters.name);
  this.Serializable$set("expression", null == parameters.expression ? null : parameters.expression);
  this.Serializable$set("orientation", null == parameters.orientation ? null : parameters.orientation);
  this.Serializable$set("fileFormat", null == parameters.fileFormat ? null : parameters.fileFormat);
  this.Serializable$set("grid", null == parameters.grid ? null : parameters.grid);
};
$jscomp.inherits(module$exports$eeapiclient$ee_api_client.FilmstripThumbnail, module$exports$eeapiclient$domain_object.Serializable);
module$exports$eeapiclient$ee_api_client.FilmstripThumbnail.prototype.getConstructor = function() {
  return module$exports$eeapiclient$ee_api_client.FilmstripThumbnail;
};
module$exports$eeapiclient$ee_api_client.FilmstripThumbnail.prototype.getPartialClassMetadata = function() {
  return {enums:{fileFormat:module$exports$eeapiclient$ee_api_client.FilmstripThumbnailFileFormatEnum, orientation:module$exports$eeapiclient$ee_api_client.FilmstripThumbnailOrientationEnum}, keys:["expression", "fileFormat", "grid", "name", "orientation"], objects:{expression:module$exports$eeapiclient$ee_api_client.Expression, grid:module$exports$eeapiclient$ee_api_client.PixelGrid}};
};
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.FilmstripThumbnail.prototype, {expression:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("expression") ? this.Serializable$get("expression") : null;
}, set:function(value) {
  this.Serializable$set("expression", value);
}}, fileFormat:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("fileFormat") ? this.Serializable$get("fileFormat") : null;
}, set:function(value) {
  this.Serializable$set("fileFormat", value);
}}, grid:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("grid") ? this.Serializable$get("grid") : null;
}, set:function(value) {
  this.Serializable$set("grid", value);
}}, name:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("name") ? this.Serializable$get("name") : null;
}, set:function(value) {
  this.Serializable$set("name", value);
}}, orientation:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("orientation") ? this.Serializable$get("orientation") : null;
}, set:function(value) {
  this.Serializable$set("orientation", value);
}}});
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.FilmstripThumbnail, {FileFormat:{configurable:!0, enumerable:!0, get:function() {
  return module$exports$eeapiclient$ee_api_client.FilmstripThumbnailFileFormatEnum;
}}, Orientation:{configurable:!0, enumerable:!0, get:function() {
  return module$exports$eeapiclient$ee_api_client.FilmstripThumbnailOrientationEnum;
}}});
module$exports$eeapiclient$ee_api_client.FolderQuotaParameters = function module$contents$eeapiclient$ee_api_client_FolderQuotaParameters() {
};
module$exports$eeapiclient$ee_api_client.FolderQuota = function(parameters) {
  parameters = void 0 === parameters ? {} : parameters;
  module$exports$eeapiclient$domain_object.Serializable.call(this);
  this.Serializable$set("sizeBytes", null == parameters.sizeBytes ? null : parameters.sizeBytes);
  this.Serializable$set("maxSizeBytes", null == parameters.maxSizeBytes ? null : parameters.maxSizeBytes);
  this.Serializable$set("assetCount", null == parameters.assetCount ? null : parameters.assetCount);
  this.Serializable$set("maxAssetCount", null == parameters.maxAssetCount ? null : parameters.maxAssetCount);
};
$jscomp.inherits(module$exports$eeapiclient$ee_api_client.FolderQuota, module$exports$eeapiclient$domain_object.Serializable);
module$exports$eeapiclient$ee_api_client.FolderQuota.prototype.getConstructor = function() {
  return module$exports$eeapiclient$ee_api_client.FolderQuota;
};
module$exports$eeapiclient$ee_api_client.FolderQuota.prototype.getPartialClassMetadata = function() {
  return {keys:["assetCount", "maxAssetCount", "maxSizeBytes", "sizeBytes"]};
};
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.FolderQuota.prototype, {assetCount:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("assetCount") ? this.Serializable$get("assetCount") : null;
}, set:function(value) {
  this.Serializable$set("assetCount", value);
}}, maxAssetCount:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("maxAssetCount") ? this.Serializable$get("maxAssetCount") : null;
}, set:function(value) {
  this.Serializable$set("maxAssetCount", value);
}}, maxSizeBytes:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("maxSizeBytes") ? this.Serializable$get("maxSizeBytes") : null;
}, set:function(value) {
  this.Serializable$set("maxSizeBytes", value);
}}, sizeBytes:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("sizeBytes") ? this.Serializable$get("sizeBytes") : null;
}, set:function(value) {
  this.Serializable$set("sizeBytes", value);
}}});
module$exports$eeapiclient$ee_api_client.FunctionDefinitionParameters = function module$contents$eeapiclient$ee_api_client_FunctionDefinitionParameters() {
};
module$exports$eeapiclient$ee_api_client.FunctionDefinition = function(parameters) {
  parameters = void 0 === parameters ? {} : parameters;
  module$exports$eeapiclient$domain_object.Serializable.call(this);
  this.Serializable$set("argumentNames", null == parameters.argumentNames ? null : parameters.argumentNames);
  this.Serializable$set("body", null == parameters.body ? null : parameters.body);
};
$jscomp.inherits(module$exports$eeapiclient$ee_api_client.FunctionDefinition, module$exports$eeapiclient$domain_object.Serializable);
module$exports$eeapiclient$ee_api_client.FunctionDefinition.prototype.getConstructor = function() {
  return module$exports$eeapiclient$ee_api_client.FunctionDefinition;
};
module$exports$eeapiclient$ee_api_client.FunctionDefinition.prototype.getPartialClassMetadata = function() {
  return {keys:["argumentNames", "body"]};
};
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.FunctionDefinition.prototype, {argumentNames:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("argumentNames") ? this.Serializable$get("argumentNames") : null;
}, set:function(value) {
  this.Serializable$set("argumentNames", value);
}}, body:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("body") ? this.Serializable$get("body") : null;
}, set:function(value) {
  this.Serializable$set("body", value);
}}});
module$exports$eeapiclient$ee_api_client.FunctionInvocationParameters = function module$contents$eeapiclient$ee_api_client_FunctionInvocationParameters() {
};
module$exports$eeapiclient$ee_api_client.FunctionInvocation = function(parameters) {
  parameters = void 0 === parameters ? {} : parameters;
  module$exports$eeapiclient$domain_object.Serializable.call(this);
  this.Serializable$set("functionName", null == parameters.functionName ? null : parameters.functionName);
  this.Serializable$set("functionReference", null == parameters.functionReference ? null : parameters.functionReference);
  this.Serializable$set("arguments", null == parameters.arguments ? null : parameters.arguments);
};
$jscomp.inherits(module$exports$eeapiclient$ee_api_client.FunctionInvocation, module$exports$eeapiclient$domain_object.Serializable);
module$exports$eeapiclient$ee_api_client.FunctionInvocation.prototype.getConstructor = function() {
  return module$exports$eeapiclient$ee_api_client.FunctionInvocation;
};
module$exports$eeapiclient$ee_api_client.FunctionInvocation.prototype.getPartialClassMetadata = function() {
  return {keys:["arguments", "functionName", "functionReference"], objectMaps:{arguments:{ctor:module$exports$eeapiclient$ee_api_client.ValueNode, isPropertyArray:!1, isSerializable:!0, isValueArray:!1}}};
};
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.FunctionInvocation.prototype, {arguments:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("arguments") ? this.Serializable$get("arguments") : null;
}, set:function(value) {
  this.Serializable$set("arguments", value);
}}, functionName:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("functionName") ? this.Serializable$get("functionName") : null;
}, set:function(value) {
  this.Serializable$set("functionName", value);
}}, functionReference:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("functionReference") ? this.Serializable$get("functionReference") : null;
}, set:function(value) {
  this.Serializable$set("functionReference", value);
}}});
module$exports$eeapiclient$ee_api_client.GcsDestinationParameters = function module$contents$eeapiclient$ee_api_client_GcsDestinationParameters() {
};
module$exports$eeapiclient$ee_api_client.GcsDestination = function(parameters) {
  parameters = void 0 === parameters ? {} : parameters;
  module$exports$eeapiclient$domain_object.Serializable.call(this);
  this.Serializable$set("bucket", null == parameters.bucket ? null : parameters.bucket);
  this.Serializable$set("filenamePrefix", null == parameters.filenamePrefix ? null : parameters.filenamePrefix);
  this.Serializable$set("permissions", null == parameters.permissions ? null : parameters.permissions);
  this.Serializable$set("bucketCorsUris", null == parameters.bucketCorsUris ? null : parameters.bucketCorsUris);
};
$jscomp.inherits(module$exports$eeapiclient$ee_api_client.GcsDestination, module$exports$eeapiclient$domain_object.Serializable);
module$exports$eeapiclient$ee_api_client.GcsDestination.prototype.getConstructor = function() {
  return module$exports$eeapiclient$ee_api_client.GcsDestination;
};
module$exports$eeapiclient$ee_api_client.GcsDestination.prototype.getPartialClassMetadata = function() {
  return {enums:{permissions:module$exports$eeapiclient$ee_api_client.GcsDestinationPermissionsEnum}, keys:["bucket", "bucketCorsUris", "filenamePrefix", "permissions"]};
};
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.GcsDestination.prototype, {bucket:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("bucket") ? this.Serializable$get("bucket") : null;
}, set:function(value) {
  this.Serializable$set("bucket", value);
}}, bucketCorsUris:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("bucketCorsUris") ? this.Serializable$get("bucketCorsUris") : null;
}, set:function(value) {
  this.Serializable$set("bucketCorsUris", value);
}}, filenamePrefix:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("filenamePrefix") ? this.Serializable$get("filenamePrefix") : null;
}, set:function(value) {
  this.Serializable$set("filenamePrefix", value);
}}, permissions:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("permissions") ? this.Serializable$get("permissions") : null;
}, set:function(value) {
  this.Serializable$set("permissions", value);
}}});
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.GcsDestination, {Permissions:{configurable:!0, enumerable:!0, get:function() {
  return module$exports$eeapiclient$ee_api_client.GcsDestinationPermissionsEnum;
}}});
module$exports$eeapiclient$ee_api_client.GcsLocationParameters = function module$contents$eeapiclient$ee_api_client_GcsLocationParameters() {
};
module$exports$eeapiclient$ee_api_client.GcsLocation = function(parameters) {
  parameters = void 0 === parameters ? {} : parameters;
  module$exports$eeapiclient$domain_object.Serializable.call(this);
  this.Serializable$set("uris", null == parameters.uris ? null : parameters.uris);
};
$jscomp.inherits(module$exports$eeapiclient$ee_api_client.GcsLocation, module$exports$eeapiclient$domain_object.Serializable);
module$exports$eeapiclient$ee_api_client.GcsLocation.prototype.getConstructor = function() {
  return module$exports$eeapiclient$ee_api_client.GcsLocation;
};
module$exports$eeapiclient$ee_api_client.GcsLocation.prototype.getPartialClassMetadata = function() {
  return {keys:["uris"]};
};
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.GcsLocation.prototype, {uris:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("uris") ? this.Serializable$get("uris") : null;
}, set:function(value) {
  this.Serializable$set("uris", value);
}}});
module$exports$eeapiclient$ee_api_client.GeoTiffImageExportOptionsParameters = function module$contents$eeapiclient$ee_api_client_GeoTiffImageExportOptionsParameters() {
};
module$exports$eeapiclient$ee_api_client.GeoTiffImageExportOptions = function(parameters) {
  parameters = void 0 === parameters ? {} : parameters;
  module$exports$eeapiclient$domain_object.Serializable.call(this);
  this.Serializable$set("cloudOptimized", null == parameters.cloudOptimized ? null : parameters.cloudOptimized);
  this.Serializable$set("tileDimensions", null == parameters.tileDimensions ? null : parameters.tileDimensions);
  this.Serializable$set("skipEmptyFiles", null == parameters.skipEmptyFiles ? null : parameters.skipEmptyFiles);
};
$jscomp.inherits(module$exports$eeapiclient$ee_api_client.GeoTiffImageExportOptions, module$exports$eeapiclient$domain_object.Serializable);
module$exports$eeapiclient$ee_api_client.GeoTiffImageExportOptions.prototype.getConstructor = function() {
  return module$exports$eeapiclient$ee_api_client.GeoTiffImageExportOptions;
};
module$exports$eeapiclient$ee_api_client.GeoTiffImageExportOptions.prototype.getPartialClassMetadata = function() {
  return {keys:["cloudOptimized", "skipEmptyFiles", "tileDimensions"], objects:{tileDimensions:module$exports$eeapiclient$ee_api_client.GridDimensions}};
};
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.GeoTiffImageExportOptions.prototype, {cloudOptimized:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("cloudOptimized") ? this.Serializable$get("cloudOptimized") : null;
}, set:function(value) {
  this.Serializable$set("cloudOptimized", value);
}}, skipEmptyFiles:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("skipEmptyFiles") ? this.Serializable$get("skipEmptyFiles") : null;
}, set:function(value) {
  this.Serializable$set("skipEmptyFiles", value);
}}, tileDimensions:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("tileDimensions") ? this.Serializable$get("tileDimensions") : null;
}, set:function(value) {
  this.Serializable$set("tileDimensions", value);
}}});
module$exports$eeapiclient$ee_api_client.GetIamPolicyRequestParameters = function module$contents$eeapiclient$ee_api_client_GetIamPolicyRequestParameters() {
};
module$exports$eeapiclient$ee_api_client.GetIamPolicyRequest = function(parameters) {
  parameters = void 0 === parameters ? {} : parameters;
  module$exports$eeapiclient$domain_object.Serializable.call(this);
  this.Serializable$set("options", null == parameters.options ? null : parameters.options);
};
$jscomp.inherits(module$exports$eeapiclient$ee_api_client.GetIamPolicyRequest, module$exports$eeapiclient$domain_object.Serializable);
module$exports$eeapiclient$ee_api_client.GetIamPolicyRequest.prototype.getConstructor = function() {
  return module$exports$eeapiclient$ee_api_client.GetIamPolicyRequest;
};
module$exports$eeapiclient$ee_api_client.GetIamPolicyRequest.prototype.getPartialClassMetadata = function() {
  return {keys:["options"], objects:{options:module$exports$eeapiclient$ee_api_client.GetPolicyOptions}};
};
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.GetIamPolicyRequest.prototype, {options:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("options") ? this.Serializable$get("options") : null;
}, set:function(value) {
  this.Serializable$set("options", value);
}}});
module$exports$eeapiclient$ee_api_client.GetPixelsRequestParameters = function module$contents$eeapiclient$ee_api_client_GetPixelsRequestParameters() {
};
module$exports$eeapiclient$ee_api_client.GetPixelsRequest = function(parameters) {
  parameters = void 0 === parameters ? {} : parameters;
  module$exports$eeapiclient$domain_object.Serializable.call(this);
  this.Serializable$set("fileFormat", null == parameters.fileFormat ? null : parameters.fileFormat);
  this.Serializable$set("grid", null == parameters.grid ? null : parameters.grid);
  this.Serializable$set("region", null == parameters.region ? null : parameters.region);
  this.Serializable$set("bandIds", null == parameters.bandIds ? null : parameters.bandIds);
  this.Serializable$set("visualizationOptions", null == parameters.visualizationOptions ? null : parameters.visualizationOptions);
};
$jscomp.inherits(module$exports$eeapiclient$ee_api_client.GetPixelsRequest, module$exports$eeapiclient$domain_object.Serializable);
module$exports$eeapiclient$ee_api_client.GetPixelsRequest.prototype.getConstructor = function() {
  return module$exports$eeapiclient$ee_api_client.GetPixelsRequest;
};
module$exports$eeapiclient$ee_api_client.GetPixelsRequest.prototype.getPartialClassMetadata = function() {
  return {enums:{fileFormat:module$exports$eeapiclient$ee_api_client.GetPixelsRequestFileFormatEnum}, keys:["bandIds", "fileFormat", "grid", "region", "visualizationOptions"], objectMaps:{region:{ctor:null, isPropertyArray:!1, isSerializable:!1, isValueArray:!1}}, objects:{grid:module$exports$eeapiclient$ee_api_client.PixelGrid, visualizationOptions:module$exports$eeapiclient$ee_api_client.VisualizationOptions}};
};
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.GetPixelsRequest.prototype, {bandIds:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("bandIds") ? this.Serializable$get("bandIds") : null;
}, set:function(value) {
  this.Serializable$set("bandIds", value);
}}, fileFormat:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("fileFormat") ? this.Serializable$get("fileFormat") : null;
}, set:function(value) {
  this.Serializable$set("fileFormat", value);
}}, grid:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("grid") ? this.Serializable$get("grid") : null;
}, set:function(value) {
  this.Serializable$set("grid", value);
}}, region:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("region") ? this.Serializable$get("region") : null;
}, set:function(value) {
  this.Serializable$set("region", value);
}}, visualizationOptions:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("visualizationOptions") ? this.Serializable$get("visualizationOptions") : null;
}, set:function(value) {
  this.Serializable$set("visualizationOptions", value);
}}});
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.GetPixelsRequest, {FileFormat:{configurable:!0, enumerable:!0, get:function() {
  return module$exports$eeapiclient$ee_api_client.GetPixelsRequestFileFormatEnum;
}}});
module$exports$eeapiclient$ee_api_client.GetPolicyOptionsParameters = function module$contents$eeapiclient$ee_api_client_GetPolicyOptionsParameters() {
};
module$exports$eeapiclient$ee_api_client.GetPolicyOptions = function(parameters) {
  parameters = void 0 === parameters ? {} : parameters;
  module$exports$eeapiclient$domain_object.Serializable.call(this);
  this.Serializable$set("requestedPolicyVersion", null == parameters.requestedPolicyVersion ? null : parameters.requestedPolicyVersion);
};
$jscomp.inherits(module$exports$eeapiclient$ee_api_client.GetPolicyOptions, module$exports$eeapiclient$domain_object.Serializable);
module$exports$eeapiclient$ee_api_client.GetPolicyOptions.prototype.getConstructor = function() {
  return module$exports$eeapiclient$ee_api_client.GetPolicyOptions;
};
module$exports$eeapiclient$ee_api_client.GetPolicyOptions.prototype.getPartialClassMetadata = function() {
  return {keys:["requestedPolicyVersion"]};
};
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.GetPolicyOptions.prototype, {requestedPolicyVersion:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("requestedPolicyVersion") ? this.Serializable$get("requestedPolicyVersion") : null;
}, set:function(value) {
  this.Serializable$set("requestedPolicyVersion", value);
}}});
module$exports$eeapiclient$ee_api_client.GridDimensionsParameters = function module$contents$eeapiclient$ee_api_client_GridDimensionsParameters() {
};
module$exports$eeapiclient$ee_api_client.GridDimensions = function(parameters) {
  parameters = void 0 === parameters ? {} : parameters;
  module$exports$eeapiclient$domain_object.Serializable.call(this);
  this.Serializable$set("width", null == parameters.width ? null : parameters.width);
  this.Serializable$set("height", null == parameters.height ? null : parameters.height);
};
$jscomp.inherits(module$exports$eeapiclient$ee_api_client.GridDimensions, module$exports$eeapiclient$domain_object.Serializable);
module$exports$eeapiclient$ee_api_client.GridDimensions.prototype.getConstructor = function() {
  return module$exports$eeapiclient$ee_api_client.GridDimensions;
};
module$exports$eeapiclient$ee_api_client.GridDimensions.prototype.getPartialClassMetadata = function() {
  return {keys:["height", "width"]};
};
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.GridDimensions.prototype, {height:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("height") ? this.Serializable$get("height") : null;
}, set:function(value) {
  this.Serializable$set("height", value);
}}, width:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("width") ? this.Serializable$get("width") : null;
}, set:function(value) {
  this.Serializable$set("width", value);
}}});
module$exports$eeapiclient$ee_api_client.GridPointParameters = function module$contents$eeapiclient$ee_api_client_GridPointParameters() {
};
module$exports$eeapiclient$ee_api_client.GridPoint = function(parameters) {
  parameters = void 0 === parameters ? {} : parameters;
  module$exports$eeapiclient$domain_object.Serializable.call(this);
  this.Serializable$set("x", null == parameters.x ? null : parameters.x);
  this.Serializable$set("y", null == parameters.y ? null : parameters.y);
};
$jscomp.inherits(module$exports$eeapiclient$ee_api_client.GridPoint, module$exports$eeapiclient$domain_object.Serializable);
module$exports$eeapiclient$ee_api_client.GridPoint.prototype.getConstructor = function() {
  return module$exports$eeapiclient$ee_api_client.GridPoint;
};
module$exports$eeapiclient$ee_api_client.GridPoint.prototype.getPartialClassMetadata = function() {
  return {keys:["x", "y"]};
};
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.GridPoint.prototype, {x:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("x") ? this.Serializable$get("x") : null;
}, set:function(value) {
  this.Serializable$set("x", value);
}}, y:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("y") ? this.Serializable$get("y") : null;
}, set:function(value) {
  this.Serializable$set("y", value);
}}});
module$exports$eeapiclient$ee_api_client.HttpBodyParameters = function module$contents$eeapiclient$ee_api_client_HttpBodyParameters() {
};
module$exports$eeapiclient$ee_api_client.HttpBody = function(parameters) {
  parameters = void 0 === parameters ? {} : parameters;
  module$exports$eeapiclient$domain_object.Serializable.call(this);
  this.Serializable$set("contentType", null == parameters.contentType ? null : parameters.contentType);
  this.Serializable$set("data", null == parameters.data ? null : parameters.data);
  this.Serializable$set("extensions", null == parameters.extensions ? null : parameters.extensions);
};
$jscomp.inherits(module$exports$eeapiclient$ee_api_client.HttpBody, module$exports$eeapiclient$domain_object.Serializable);
module$exports$eeapiclient$ee_api_client.HttpBody.prototype.getConstructor = function() {
  return module$exports$eeapiclient$ee_api_client.HttpBody;
};
module$exports$eeapiclient$ee_api_client.HttpBody.prototype.getPartialClassMetadata = function() {
  return {keys:["contentType", "data", "extensions"], objectMaps:{extensions:{ctor:null, isPropertyArray:!0, isSerializable:!1, isValueArray:!1}}};
};
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.HttpBody.prototype, {contentType:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("contentType") ? this.Serializable$get("contentType") : null;
}, set:function(value) {
  this.Serializable$set("contentType", value);
}}, data:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("data") ? this.Serializable$get("data") : null;
}, set:function(value) {
  this.Serializable$set("data", value);
}}, extensions:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("extensions") ? this.Serializable$get("extensions") : null;
}, set:function(value) {
  this.Serializable$set("extensions", value);
}}});
module$exports$eeapiclient$ee_api_client.ImageParameters = function module$contents$eeapiclient$ee_api_client_ImageParameters() {
};
module$exports$eeapiclient$ee_api_client.Image = function(parameters) {
  parameters = void 0 === parameters ? {} : parameters;
  module$exports$eeapiclient$domain_object.Serializable.call(this);
  this.Serializable$set("name", null == parameters.name ? null : parameters.name);
  this.Serializable$set("id", null == parameters.id ? null : parameters.id);
  this.Serializable$set("updateTime", null == parameters.updateTime ? null : parameters.updateTime);
  this.Serializable$set("title", null == parameters.title ? null : parameters.title);
  this.Serializable$set("description", null == parameters.description ? null : parameters.description);
  this.Serializable$set("properties", null == parameters.properties ? null : parameters.properties);
  this.Serializable$set("startTime", null == parameters.startTime ? null : parameters.startTime);
  this.Serializable$set("endTime", null == parameters.endTime ? null : parameters.endTime);
  this.Serializable$set("geometry", null == parameters.geometry ? null : parameters.geometry);
  this.Serializable$set("bands", null == parameters.bands ? null : parameters.bands);
  this.Serializable$set("sizeBytes", null == parameters.sizeBytes ? null : parameters.sizeBytes);
};
$jscomp.inherits(module$exports$eeapiclient$ee_api_client.Image, module$exports$eeapiclient$domain_object.Serializable);
module$exports$eeapiclient$ee_api_client.Image.prototype.getConstructor = function() {
  return module$exports$eeapiclient$ee_api_client.Image;
};
module$exports$eeapiclient$ee_api_client.Image.prototype.getPartialClassMetadata = function() {
  return {arrays:{bands:module$exports$eeapiclient$ee_api_client.ImageBand}, keys:"bands description endTime geometry id name properties sizeBytes startTime title updateTime".split(" "), objectMaps:{geometry:{ctor:null, isPropertyArray:!1, isSerializable:!1, isValueArray:!1}, properties:{ctor:null, isPropertyArray:!1, isSerializable:!1, isValueArray:!1}}};
};
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.Image.prototype, {bands:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("bands") ? this.Serializable$get("bands") : null;
}, set:function(value) {
  this.Serializable$set("bands", value);
}}, description:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("description") ? this.Serializable$get("description") : null;
}, set:function(value) {
  this.Serializable$set("description", value);
}}, endTime:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("endTime") ? this.Serializable$get("endTime") : null;
}, set:function(value) {
  this.Serializable$set("endTime", value);
}}, geometry:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("geometry") ? this.Serializable$get("geometry") : null;
}, set:function(value) {
  this.Serializable$set("geometry", value);
}}, id:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("id") ? this.Serializable$get("id") : null;
}, set:function(value) {
  this.Serializable$set("id", value);
}}, name:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("name") ? this.Serializable$get("name") : null;
}, set:function(value) {
  this.Serializable$set("name", value);
}}, properties:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("properties") ? this.Serializable$get("properties") : null;
}, set:function(value) {
  this.Serializable$set("properties", value);
}}, sizeBytes:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("sizeBytes") ? this.Serializable$get("sizeBytes") : null;
}, set:function(value) {
  this.Serializable$set("sizeBytes", value);
}}, startTime:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("startTime") ? this.Serializable$get("startTime") : null;
}, set:function(value) {
  this.Serializable$set("startTime", value);
}}, title:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("title") ? this.Serializable$get("title") : null;
}, set:function(value) {
  this.Serializable$set("title", value);
}}, updateTime:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("updateTime") ? this.Serializable$get("updateTime") : null;
}, set:function(value) {
  this.Serializable$set("updateTime", value);
}}});
module$exports$eeapiclient$ee_api_client.ImageAssetExportOptionsParameters = function module$contents$eeapiclient$ee_api_client_ImageAssetExportOptionsParameters() {
};
module$exports$eeapiclient$ee_api_client.ImageAssetExportOptions = function(parameters) {
  parameters = void 0 === parameters ? {} : parameters;
  module$exports$eeapiclient$domain_object.Serializable.call(this);
  this.Serializable$set("earthEngineDestination", null == parameters.earthEngineDestination ? null : parameters.earthEngineDestination);
  this.Serializable$set("pyramidingPolicy", null == parameters.pyramidingPolicy ? null : parameters.pyramidingPolicy);
  this.Serializable$set("pyramidingPolicyOverrides", null == parameters.pyramidingPolicyOverrides ? null : parameters.pyramidingPolicyOverrides);
  this.Serializable$set("tileSize", null == parameters.tileSize ? null : parameters.tileSize);
};
$jscomp.inherits(module$exports$eeapiclient$ee_api_client.ImageAssetExportOptions, module$exports$eeapiclient$domain_object.Serializable);
module$exports$eeapiclient$ee_api_client.ImageAssetExportOptions.prototype.getConstructor = function() {
  return module$exports$eeapiclient$ee_api_client.ImageAssetExportOptions;
};
module$exports$eeapiclient$ee_api_client.ImageAssetExportOptions.prototype.getPartialClassMetadata = function() {
  return {enums:{pyramidingPolicy:module$exports$eeapiclient$ee_api_client.ImageAssetExportOptionsPyramidingPolicyEnum, pyramidingPolicyOverrides:module$exports$eeapiclient$ee_api_client.ImageAssetExportOptionsPyramidingPolicyOverridesEnum}, keys:["earthEngineDestination", "pyramidingPolicy", "pyramidingPolicyOverrides", "tileSize"], objectMaps:{pyramidingPolicyOverrides:{ctor:null, isPropertyArray:!1, isSerializable:!1, isValueArray:!1}}, objects:{earthEngineDestination:module$exports$eeapiclient$ee_api_client.EarthEngineDestination}};
};
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.ImageAssetExportOptions.prototype, {earthEngineDestination:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("earthEngineDestination") ? this.Serializable$get("earthEngineDestination") : null;
}, set:function(value) {
  this.Serializable$set("earthEngineDestination", value);
}}, pyramidingPolicy:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("pyramidingPolicy") ? this.Serializable$get("pyramidingPolicy") : null;
}, set:function(value) {
  this.Serializable$set("pyramidingPolicy", value);
}}, pyramidingPolicyOverrides:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("pyramidingPolicyOverrides") ? this.Serializable$get("pyramidingPolicyOverrides") : null;
}, set:function(value) {
  this.Serializable$set("pyramidingPolicyOverrides", value);
}}, tileSize:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("tileSize") ? this.Serializable$get("tileSize") : null;
}, set:function(value) {
  this.Serializable$set("tileSize", value);
}}});
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.ImageAssetExportOptions, {PyramidingPolicy:{configurable:!0, enumerable:!0, get:function() {
  return module$exports$eeapiclient$ee_api_client.ImageAssetExportOptionsPyramidingPolicyEnum;
}}, PyramidingPolicyOverrides:{configurable:!0, enumerable:!0, get:function() {
  return module$exports$eeapiclient$ee_api_client.ImageAssetExportOptionsPyramidingPolicyOverridesEnum;
}}});
module$exports$eeapiclient$ee_api_client.ImageBandParameters = function module$contents$eeapiclient$ee_api_client_ImageBandParameters() {
};
module$exports$eeapiclient$ee_api_client.ImageBand = function(parameters) {
  parameters = void 0 === parameters ? {} : parameters;
  module$exports$eeapiclient$domain_object.Serializable.call(this);
  this.Serializable$set("id", null == parameters.id ? null : parameters.id);
  this.Serializable$set("dataType", null == parameters.dataType ? null : parameters.dataType);
  this.Serializable$set("grid", null == parameters.grid ? null : parameters.grid);
  this.Serializable$set("pyramidingPolicy", null == parameters.pyramidingPolicy ? null : parameters.pyramidingPolicy);
  this.Serializable$set("tilesets", null == parameters.tilesets ? null : parameters.tilesets);
  this.Serializable$set("missingData", null == parameters.missingData ? null : parameters.missingData);
};
$jscomp.inherits(module$exports$eeapiclient$ee_api_client.ImageBand, module$exports$eeapiclient$domain_object.Serializable);
module$exports$eeapiclient$ee_api_client.ImageBand.prototype.getConstructor = function() {
  return module$exports$eeapiclient$ee_api_client.ImageBand;
};
module$exports$eeapiclient$ee_api_client.ImageBand.prototype.getPartialClassMetadata = function() {
  return {arrays:{tilesets:module$exports$eeapiclient$ee_api_client.TilestoreTileset}, enums:{pyramidingPolicy:module$exports$eeapiclient$ee_api_client.ImageBandPyramidingPolicyEnum}, keys:"dataType grid id missingData pyramidingPolicy tilesets".split(" "), objects:{dataType:module$exports$eeapiclient$ee_api_client.PixelDataType, grid:module$exports$eeapiclient$ee_api_client.PixelGrid, missingData:module$exports$eeapiclient$ee_api_client.MissingData}};
};
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.ImageBand.prototype, {dataType:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("dataType") ? this.Serializable$get("dataType") : null;
}, set:function(value) {
  this.Serializable$set("dataType", value);
}}, grid:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("grid") ? this.Serializable$get("grid") : null;
}, set:function(value) {
  this.Serializable$set("grid", value);
}}, id:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("id") ? this.Serializable$get("id") : null;
}, set:function(value) {
  this.Serializable$set("id", value);
}}, missingData:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("missingData") ? this.Serializable$get("missingData") : null;
}, set:function(value) {
  this.Serializable$set("missingData", value);
}}, pyramidingPolicy:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("pyramidingPolicy") ? this.Serializable$get("pyramidingPolicy") : null;
}, set:function(value) {
  this.Serializable$set("pyramidingPolicy", value);
}}, tilesets:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("tilesets") ? this.Serializable$get("tilesets") : null;
}, set:function(value) {
  this.Serializable$set("tilesets", value);
}}});
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.ImageBand, {PyramidingPolicy:{configurable:!0, enumerable:!0, get:function() {
  return module$exports$eeapiclient$ee_api_client.ImageBandPyramidingPolicyEnum;
}}});
module$exports$eeapiclient$ee_api_client.ImageFileExportOptionsParameters = function module$contents$eeapiclient$ee_api_client_ImageFileExportOptionsParameters() {
};
module$exports$eeapiclient$ee_api_client.ImageFileExportOptions = function(parameters) {
  parameters = void 0 === parameters ? {} : parameters;
  module$exports$eeapiclient$domain_object.Serializable.call(this);
  this.Serializable$set("fileFormat", null == parameters.fileFormat ? null : parameters.fileFormat);
  this.Serializable$set("driveDestination", null == parameters.driveDestination ? null : parameters.driveDestination);
  this.Serializable$set("gcsDestination", null == parameters.gcsDestination ? null : parameters.gcsDestination);
  this.Serializable$set("geoTiffOptions", null == parameters.geoTiffOptions ? null : parameters.geoTiffOptions);
  this.Serializable$set("tfRecordOptions", null == parameters.tfRecordOptions ? null : parameters.tfRecordOptions);
};
$jscomp.inherits(module$exports$eeapiclient$ee_api_client.ImageFileExportOptions, module$exports$eeapiclient$domain_object.Serializable);
module$exports$eeapiclient$ee_api_client.ImageFileExportOptions.prototype.getConstructor = function() {
  return module$exports$eeapiclient$ee_api_client.ImageFileExportOptions;
};
module$exports$eeapiclient$ee_api_client.ImageFileExportOptions.prototype.getPartialClassMetadata = function() {
  return {enums:{fileFormat:module$exports$eeapiclient$ee_api_client.ImageFileExportOptionsFileFormatEnum}, keys:["driveDestination", "fileFormat", "gcsDestination", "geoTiffOptions", "tfRecordOptions"], objects:{driveDestination:module$exports$eeapiclient$ee_api_client.DriveDestination, gcsDestination:module$exports$eeapiclient$ee_api_client.GcsDestination, geoTiffOptions:module$exports$eeapiclient$ee_api_client.GeoTiffImageExportOptions, 
  tfRecordOptions:module$exports$eeapiclient$ee_api_client.TfRecordImageExportOptions}};
};
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.ImageFileExportOptions.prototype, {driveDestination:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("driveDestination") ? this.Serializable$get("driveDestination") : null;
}, set:function(value) {
  this.Serializable$set("driveDestination", value);
}}, fileFormat:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("fileFormat") ? this.Serializable$get("fileFormat") : null;
}, set:function(value) {
  this.Serializable$set("fileFormat", value);
}}, gcsDestination:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("gcsDestination") ? this.Serializable$get("gcsDestination") : null;
}, set:function(value) {
  this.Serializable$set("gcsDestination", value);
}}, geoTiffOptions:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("geoTiffOptions") ? this.Serializable$get("geoTiffOptions") : null;
}, set:function(value) {
  this.Serializable$set("geoTiffOptions", value);
}}, tfRecordOptions:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("tfRecordOptions") ? this.Serializable$get("tfRecordOptions") : null;
}, set:function(value) {
  this.Serializable$set("tfRecordOptions", value);
}}});
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.ImageFileExportOptions, {FileFormat:{configurable:!0, enumerable:!0, get:function() {
  return module$exports$eeapiclient$ee_api_client.ImageFileExportOptionsFileFormatEnum;
}}});
module$exports$eeapiclient$ee_api_client.ImageManifestParameters = function module$contents$eeapiclient$ee_api_client_ImageManifestParameters() {
};
module$exports$eeapiclient$ee_api_client.ImageManifest = function(parameters) {
  parameters = void 0 === parameters ? {} : parameters;
  module$exports$eeapiclient$domain_object.Serializable.call(this);
  this.Serializable$set("name", null == parameters.name ? null : parameters.name);
  this.Serializable$set("properties", null == parameters.properties ? null : parameters.properties);
  this.Serializable$set("uriPrefix", null == parameters.uriPrefix ? null : parameters.uriPrefix);
  this.Serializable$set("tilesets", null == parameters.tilesets ? null : parameters.tilesets);
  this.Serializable$set("bands", null == parameters.bands ? null : parameters.bands);
  this.Serializable$set("maskBands", null == parameters.maskBands ? null : parameters.maskBands);
  this.Serializable$set("footprint", null == parameters.footprint ? null : parameters.footprint);
  this.Serializable$set("missingData", null == parameters.missingData ? null : parameters.missingData);
  this.Serializable$set("pyramidingPolicy", null == parameters.pyramidingPolicy ? null : parameters.pyramidingPolicy);
  this.Serializable$set("startTime", null == parameters.startTime ? null : parameters.startTime);
  this.Serializable$set("endTime", null == parameters.endTime ? null : parameters.endTime);
};
$jscomp.inherits(module$exports$eeapiclient$ee_api_client.ImageManifest, module$exports$eeapiclient$domain_object.Serializable);
module$exports$eeapiclient$ee_api_client.ImageManifest.prototype.getConstructor = function() {
  return module$exports$eeapiclient$ee_api_client.ImageManifest;
};
module$exports$eeapiclient$ee_api_client.ImageManifest.prototype.getPartialClassMetadata = function() {
  return {arrays:{bands:module$exports$eeapiclient$ee_api_client.TilesetBand, maskBands:module$exports$eeapiclient$ee_api_client.TilesetMaskBand, tilesets:module$exports$eeapiclient$ee_api_client.Tileset}, enums:{pyramidingPolicy:module$exports$eeapiclient$ee_api_client.ImageManifestPyramidingPolicyEnum}, keys:"bands endTime footprint maskBands missingData name properties pyramidingPolicy startTime tilesets uriPrefix".split(" "), 
  objectMaps:{properties:{ctor:null, isPropertyArray:!1, isSerializable:!1, isValueArray:!1}}, objects:{footprint:module$exports$eeapiclient$ee_api_client.PixelFootprint, missingData:module$exports$eeapiclient$ee_api_client.MissingData}};
};
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.ImageManifest.prototype, {bands:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("bands") ? this.Serializable$get("bands") : null;
}, set:function(value) {
  this.Serializable$set("bands", value);
}}, endTime:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("endTime") ? this.Serializable$get("endTime") : null;
}, set:function(value) {
  this.Serializable$set("endTime", value);
}}, footprint:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("footprint") ? this.Serializable$get("footprint") : null;
}, set:function(value) {
  this.Serializable$set("footprint", value);
}}, maskBands:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("maskBands") ? this.Serializable$get("maskBands") : null;
}, set:function(value) {
  this.Serializable$set("maskBands", value);
}}, missingData:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("missingData") ? this.Serializable$get("missingData") : null;
}, set:function(value) {
  this.Serializable$set("missingData", value);
}}, name:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("name") ? this.Serializable$get("name") : null;
}, set:function(value) {
  this.Serializable$set("name", value);
}}, properties:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("properties") ? this.Serializable$get("properties") : null;
}, set:function(value) {
  this.Serializable$set("properties", value);
}}, pyramidingPolicy:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("pyramidingPolicy") ? this.Serializable$get("pyramidingPolicy") : null;
}, set:function(value) {
  this.Serializable$set("pyramidingPolicy", value);
}}, startTime:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("startTime") ? this.Serializable$get("startTime") : null;
}, set:function(value) {
  this.Serializable$set("startTime", value);
}}, tilesets:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("tilesets") ? this.Serializable$get("tilesets") : null;
}, set:function(value) {
  this.Serializable$set("tilesets", value);
}}, uriPrefix:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("uriPrefix") ? this.Serializable$get("uriPrefix") : null;
}, set:function(value) {
  this.Serializable$set("uriPrefix", value);
}}});
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.ImageManifest, {PyramidingPolicy:{configurable:!0, enumerable:!0, get:function() {
  return module$exports$eeapiclient$ee_api_client.ImageManifestPyramidingPolicyEnum;
}}});
module$exports$eeapiclient$ee_api_client.ImageSourceParameters = function module$contents$eeapiclient$ee_api_client_ImageSourceParameters() {
};
module$exports$eeapiclient$ee_api_client.ImageSource = function(parameters) {
  parameters = void 0 === parameters ? {} : parameters;
  module$exports$eeapiclient$domain_object.Serializable.call(this);
  this.Serializable$set("uris", null == parameters.uris ? null : parameters.uris);
  this.Serializable$set("affineTransform", null == parameters.affineTransform ? null : parameters.affineTransform);
};
$jscomp.inherits(module$exports$eeapiclient$ee_api_client.ImageSource, module$exports$eeapiclient$domain_object.Serializable);
module$exports$eeapiclient$ee_api_client.ImageSource.prototype.getConstructor = function() {
  return module$exports$eeapiclient$ee_api_client.ImageSource;
};
module$exports$eeapiclient$ee_api_client.ImageSource.prototype.getPartialClassMetadata = function() {
  return {keys:["affineTransform", "uris"], objects:{affineTransform:module$exports$eeapiclient$ee_api_client.AffineTransform}};
};
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.ImageSource.prototype, {affineTransform:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("affineTransform") ? this.Serializable$get("affineTransform") : null;
}, set:function(value) {
  this.Serializable$set("affineTransform", value);
}}, uris:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("uris") ? this.Serializable$get("uris") : null;
}, set:function(value) {
  this.Serializable$set("uris", value);
}}});
module$exports$eeapiclient$ee_api_client.ImportImageRequestParameters = function module$contents$eeapiclient$ee_api_client_ImportImageRequestParameters() {
};
module$exports$eeapiclient$ee_api_client.ImportImageRequest = function(parameters) {
  parameters = void 0 === parameters ? {} : parameters;
  module$exports$eeapiclient$domain_object.Serializable.call(this);
  this.Serializable$set("imageManifest", null == parameters.imageManifest ? null : parameters.imageManifest);
  this.Serializable$set("description", null == parameters.description ? null : parameters.description);
  this.Serializable$set("overwrite", null == parameters.overwrite ? null : parameters.overwrite);
  this.Serializable$set("requestId", null == parameters.requestId ? null : parameters.requestId);
};
$jscomp.inherits(module$exports$eeapiclient$ee_api_client.ImportImageRequest, module$exports$eeapiclient$domain_object.Serializable);
module$exports$eeapiclient$ee_api_client.ImportImageRequest.prototype.getConstructor = function() {
  return module$exports$eeapiclient$ee_api_client.ImportImageRequest;
};
module$exports$eeapiclient$ee_api_client.ImportImageRequest.prototype.getPartialClassMetadata = function() {
  return {keys:["description", "imageManifest", "overwrite", "requestId"], objects:{imageManifest:module$exports$eeapiclient$ee_api_client.ImageManifest}};
};
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.ImportImageRequest.prototype, {description:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("description") ? this.Serializable$get("description") : null;
}, set:function(value) {
  this.Serializable$set("description", value);
}}, imageManifest:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("imageManifest") ? this.Serializable$get("imageManifest") : null;
}, set:function(value) {
  this.Serializable$set("imageManifest", value);
}}, overwrite:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("overwrite") ? this.Serializable$get("overwrite") : null;
}, set:function(value) {
  this.Serializable$set("overwrite", value);
}}, requestId:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("requestId") ? this.Serializable$get("requestId") : null;
}, set:function(value) {
  this.Serializable$set("requestId", value);
}}});
module$exports$eeapiclient$ee_api_client.ImportTableRequestParameters = function module$contents$eeapiclient$ee_api_client_ImportTableRequestParameters() {
};
module$exports$eeapiclient$ee_api_client.ImportTableRequest = function(parameters) {
  parameters = void 0 === parameters ? {} : parameters;
  module$exports$eeapiclient$domain_object.Serializable.call(this);
  this.Serializable$set("tableManifest", null == parameters.tableManifest ? null : parameters.tableManifest);
  this.Serializable$set("description", null == parameters.description ? null : parameters.description);
  this.Serializable$set("overwrite", null == parameters.overwrite ? null : parameters.overwrite);
  this.Serializable$set("requestId", null == parameters.requestId ? null : parameters.requestId);
};
$jscomp.inherits(module$exports$eeapiclient$ee_api_client.ImportTableRequest, module$exports$eeapiclient$domain_object.Serializable);
module$exports$eeapiclient$ee_api_client.ImportTableRequest.prototype.getConstructor = function() {
  return module$exports$eeapiclient$ee_api_client.ImportTableRequest;
};
module$exports$eeapiclient$ee_api_client.ImportTableRequest.prototype.getPartialClassMetadata = function() {
  return {keys:["description", "overwrite", "requestId", "tableManifest"], objects:{tableManifest:module$exports$eeapiclient$ee_api_client.TableManifest}};
};
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.ImportTableRequest.prototype, {description:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("description") ? this.Serializable$get("description") : null;
}, set:function(value) {
  this.Serializable$set("description", value);
}}, overwrite:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("overwrite") ? this.Serializable$get("overwrite") : null;
}, set:function(value) {
  this.Serializable$set("overwrite", value);
}}, requestId:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("requestId") ? this.Serializable$get("requestId") : null;
}, set:function(value) {
  this.Serializable$set("requestId", value);
}}, tableManifest:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("tableManifest") ? this.Serializable$get("tableManifest") : null;
}, set:function(value) {
  this.Serializable$set("tableManifest", value);
}}});
module$exports$eeapiclient$ee_api_client.LinkAssetRequestParameters = function module$contents$eeapiclient$ee_api_client_LinkAssetRequestParameters() {
};
module$exports$eeapiclient$ee_api_client.LinkAssetRequest = function(parameters) {
  parameters = void 0 === parameters ? {} : parameters;
  module$exports$eeapiclient$domain_object.Serializable.call(this);
  this.Serializable$set("destinationName", null == parameters.destinationName ? null : parameters.destinationName);
};
$jscomp.inherits(module$exports$eeapiclient$ee_api_client.LinkAssetRequest, module$exports$eeapiclient$domain_object.Serializable);
module$exports$eeapiclient$ee_api_client.LinkAssetRequest.prototype.getConstructor = function() {
  return module$exports$eeapiclient$ee_api_client.LinkAssetRequest;
};
module$exports$eeapiclient$ee_api_client.LinkAssetRequest.prototype.getPartialClassMetadata = function() {
  return {keys:["destinationName"]};
};
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.LinkAssetRequest.prototype, {destinationName:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("destinationName") ? this.Serializable$get("destinationName") : null;
}, set:function(value) {
  this.Serializable$set("destinationName", value);
}}});
module$exports$eeapiclient$ee_api_client.ListAlgorithmsResponseParameters = function module$contents$eeapiclient$ee_api_client_ListAlgorithmsResponseParameters() {
};
module$exports$eeapiclient$ee_api_client.ListAlgorithmsResponse = function(parameters) {
  parameters = void 0 === parameters ? {} : parameters;
  module$exports$eeapiclient$domain_object.Serializable.call(this);
  this.Serializable$set("algorithms", null == parameters.algorithms ? null : parameters.algorithms);
};
$jscomp.inherits(module$exports$eeapiclient$ee_api_client.ListAlgorithmsResponse, module$exports$eeapiclient$domain_object.Serializable);
module$exports$eeapiclient$ee_api_client.ListAlgorithmsResponse.prototype.getConstructor = function() {
  return module$exports$eeapiclient$ee_api_client.ListAlgorithmsResponse;
};
module$exports$eeapiclient$ee_api_client.ListAlgorithmsResponse.prototype.getPartialClassMetadata = function() {
  return {arrays:{algorithms:module$exports$eeapiclient$ee_api_client.Algorithm}, keys:["algorithms"]};
};
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.ListAlgorithmsResponse.prototype, {algorithms:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("algorithms") ? this.Serializable$get("algorithms") : null;
}, set:function(value) {
  this.Serializable$set("algorithms", value);
}}});
module$exports$eeapiclient$ee_api_client.ListAssetsResponseParameters = function module$contents$eeapiclient$ee_api_client_ListAssetsResponseParameters() {
};
module$exports$eeapiclient$ee_api_client.ListAssetsResponse = function(parameters) {
  parameters = void 0 === parameters ? {} : parameters;
  module$exports$eeapiclient$domain_object.Serializable.call(this);
  this.Serializable$set("assets", null == parameters.assets ? null : parameters.assets);
  this.Serializable$set("nextPageToken", null == parameters.nextPageToken ? null : parameters.nextPageToken);
};
$jscomp.inherits(module$exports$eeapiclient$ee_api_client.ListAssetsResponse, module$exports$eeapiclient$domain_object.Serializable);
module$exports$eeapiclient$ee_api_client.ListAssetsResponse.prototype.getConstructor = function() {
  return module$exports$eeapiclient$ee_api_client.ListAssetsResponse;
};
module$exports$eeapiclient$ee_api_client.ListAssetsResponse.prototype.getPartialClassMetadata = function() {
  return {arrays:{assets:module$exports$eeapiclient$ee_api_client.EarthEngineAsset}, keys:["assets", "nextPageToken"]};
};
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.ListAssetsResponse.prototype, {assets:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("assets") ? this.Serializable$get("assets") : null;
}, set:function(value) {
  this.Serializable$set("assets", value);
}}, nextPageToken:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("nextPageToken") ? this.Serializable$get("nextPageToken") : null;
}, set:function(value) {
  this.Serializable$set("nextPageToken", value);
}}});
module$exports$eeapiclient$ee_api_client.ListFeaturesResponseParameters = function module$contents$eeapiclient$ee_api_client_ListFeaturesResponseParameters() {
};
module$exports$eeapiclient$ee_api_client.ListFeaturesResponse = function(parameters) {
  parameters = void 0 === parameters ? {} : parameters;
  module$exports$eeapiclient$domain_object.Serializable.call(this);
  this.Serializable$set("type", null == parameters.type ? null : parameters.type);
  this.Serializable$set("features", null == parameters.features ? null : parameters.features);
  this.Serializable$set("nextPageToken", null == parameters.nextPageToken ? null : parameters.nextPageToken);
};
$jscomp.inherits(module$exports$eeapiclient$ee_api_client.ListFeaturesResponse, module$exports$eeapiclient$domain_object.Serializable);
module$exports$eeapiclient$ee_api_client.ListFeaturesResponse.prototype.getConstructor = function() {
  return module$exports$eeapiclient$ee_api_client.ListFeaturesResponse;
};
module$exports$eeapiclient$ee_api_client.ListFeaturesResponse.prototype.getPartialClassMetadata = function() {
  return {arrays:{features:module$exports$eeapiclient$ee_api_client.Feature}, keys:["features", "nextPageToken", "type"]};
};
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.ListFeaturesResponse.prototype, {features:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("features") ? this.Serializable$get("features") : null;
}, set:function(value) {
  this.Serializable$set("features", value);
}}, nextPageToken:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("nextPageToken") ? this.Serializable$get("nextPageToken") : null;
}, set:function(value) {
  this.Serializable$set("nextPageToken", value);
}}, type:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("type") ? this.Serializable$get("type") : null;
}, set:function(value) {
  this.Serializable$set("type", value);
}}});
module$exports$eeapiclient$ee_api_client.ListImagesResponseParameters = function module$contents$eeapiclient$ee_api_client_ListImagesResponseParameters() {
};
module$exports$eeapiclient$ee_api_client.ListImagesResponse = function(parameters) {
  parameters = void 0 === parameters ? {} : parameters;
  module$exports$eeapiclient$domain_object.Serializable.call(this);
  this.Serializable$set("images", null == parameters.images ? null : parameters.images);
  this.Serializable$set("nextPageToken", null == parameters.nextPageToken ? null : parameters.nextPageToken);
};
$jscomp.inherits(module$exports$eeapiclient$ee_api_client.ListImagesResponse, module$exports$eeapiclient$domain_object.Serializable);
module$exports$eeapiclient$ee_api_client.ListImagesResponse.prototype.getConstructor = function() {
  return module$exports$eeapiclient$ee_api_client.ListImagesResponse;
};
module$exports$eeapiclient$ee_api_client.ListImagesResponse.prototype.getPartialClassMetadata = function() {
  return {arrays:{images:module$exports$eeapiclient$ee_api_client.Image}, keys:["images", "nextPageToken"]};
};
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.ListImagesResponse.prototype, {images:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("images") ? this.Serializable$get("images") : null;
}, set:function(value) {
  this.Serializable$set("images", value);
}}, nextPageToken:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("nextPageToken") ? this.Serializable$get("nextPageToken") : null;
}, set:function(value) {
  this.Serializable$set("nextPageToken", value);
}}});
module$exports$eeapiclient$ee_api_client.ListOperationsResponseParameters = function module$contents$eeapiclient$ee_api_client_ListOperationsResponseParameters() {
};
module$exports$eeapiclient$ee_api_client.ListOperationsResponse = function(parameters) {
  parameters = void 0 === parameters ? {} : parameters;
  module$exports$eeapiclient$domain_object.Serializable.call(this);
  this.Serializable$set("operations", null == parameters.operations ? null : parameters.operations);
  this.Serializable$set("nextPageToken", null == parameters.nextPageToken ? null : parameters.nextPageToken);
};
$jscomp.inherits(module$exports$eeapiclient$ee_api_client.ListOperationsResponse, module$exports$eeapiclient$domain_object.Serializable);
module$exports$eeapiclient$ee_api_client.ListOperationsResponse.prototype.getConstructor = function() {
  return module$exports$eeapiclient$ee_api_client.ListOperationsResponse;
};
module$exports$eeapiclient$ee_api_client.ListOperationsResponse.prototype.getPartialClassMetadata = function() {
  return {arrays:{operations:module$exports$eeapiclient$ee_api_client.Operation}, keys:["nextPageToken", "operations"]};
};
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.ListOperationsResponse.prototype, {nextPageToken:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("nextPageToken") ? this.Serializable$get("nextPageToken") : null;
}, set:function(value) {
  this.Serializable$set("nextPageToken", value);
}}, operations:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("operations") ? this.Serializable$get("operations") : null;
}, set:function(value) {
  this.Serializable$set("operations", value);
}}});
module$exports$eeapiclient$ee_api_client.LogConfigParameters = function module$contents$eeapiclient$ee_api_client_LogConfigParameters() {
};
module$exports$eeapiclient$ee_api_client.LogConfig = function(parameters) {
  parameters = void 0 === parameters ? {} : parameters;
  module$exports$eeapiclient$domain_object.Serializable.call(this);
  this.Serializable$set("counter", null == parameters.counter ? null : parameters.counter);
  this.Serializable$set("dataAccess", null == parameters.dataAccess ? null : parameters.dataAccess);
  this.Serializable$set("cloudAudit", null == parameters.cloudAudit ? null : parameters.cloudAudit);
};
$jscomp.inherits(module$exports$eeapiclient$ee_api_client.LogConfig, module$exports$eeapiclient$domain_object.Serializable);
module$exports$eeapiclient$ee_api_client.LogConfig.prototype.getConstructor = function() {
  return module$exports$eeapiclient$ee_api_client.LogConfig;
};
module$exports$eeapiclient$ee_api_client.LogConfig.prototype.getPartialClassMetadata = function() {
  return {keys:["cloudAudit", "counter", "dataAccess"], objects:{cloudAudit:module$exports$eeapiclient$ee_api_client.CloudAuditOptions, counter:module$exports$eeapiclient$ee_api_client.CounterOptions, dataAccess:module$exports$eeapiclient$ee_api_client.DataAccessOptions}};
};
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.LogConfig.prototype, {cloudAudit:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("cloudAudit") ? this.Serializable$get("cloudAudit") : null;
}, set:function(value) {
  this.Serializable$set("cloudAudit", value);
}}, counter:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("counter") ? this.Serializable$get("counter") : null;
}, set:function(value) {
  this.Serializable$set("counter", value);
}}, dataAccess:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("dataAccess") ? this.Serializable$get("dataAccess") : null;
}, set:function(value) {
  this.Serializable$set("dataAccess", value);
}}});
module$exports$eeapiclient$ee_api_client.MissingDataParameters = function module$contents$eeapiclient$ee_api_client_MissingDataParameters() {
};
module$exports$eeapiclient$ee_api_client.MissingData = function(parameters) {
  parameters = void 0 === parameters ? {} : parameters;
  module$exports$eeapiclient$domain_object.Serializable.call(this);
  this.Serializable$set("values", null == parameters.values ? null : parameters.values);
};
$jscomp.inherits(module$exports$eeapiclient$ee_api_client.MissingData, module$exports$eeapiclient$domain_object.Serializable);
module$exports$eeapiclient$ee_api_client.MissingData.prototype.getConstructor = function() {
  return module$exports$eeapiclient$ee_api_client.MissingData;
};
module$exports$eeapiclient$ee_api_client.MissingData.prototype.getPartialClassMetadata = function() {
  return {keys:["values"]};
};
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.MissingData.prototype, {values:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("values") ? this.Serializable$get("values") : null;
}, set:function(value) {
  this.Serializable$set("values", value);
}}});
module$exports$eeapiclient$ee_api_client.MoveAssetRequestParameters = function module$contents$eeapiclient$ee_api_client_MoveAssetRequestParameters() {
};
module$exports$eeapiclient$ee_api_client.MoveAssetRequest = function(parameters) {
  parameters = void 0 === parameters ? {} : parameters;
  module$exports$eeapiclient$domain_object.Serializable.call(this);
  this.Serializable$set("destinationName", null == parameters.destinationName ? null : parameters.destinationName);
};
$jscomp.inherits(module$exports$eeapiclient$ee_api_client.MoveAssetRequest, module$exports$eeapiclient$domain_object.Serializable);
module$exports$eeapiclient$ee_api_client.MoveAssetRequest.prototype.getConstructor = function() {
  return module$exports$eeapiclient$ee_api_client.MoveAssetRequest;
};
module$exports$eeapiclient$ee_api_client.MoveAssetRequest.prototype.getPartialClassMetadata = function() {
  return {keys:["destinationName"]};
};
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.MoveAssetRequest.prototype, {destinationName:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("destinationName") ? this.Serializable$get("destinationName") : null;
}, set:function(value) {
  this.Serializable$set("destinationName", value);
}}});
module$exports$eeapiclient$ee_api_client.OperationParameters = function module$contents$eeapiclient$ee_api_client_OperationParameters() {
};
module$exports$eeapiclient$ee_api_client.Operation = function(parameters) {
  parameters = void 0 === parameters ? {} : parameters;
  module$exports$eeapiclient$domain_object.Serializable.call(this);
  this.Serializable$set("name", null == parameters.name ? null : parameters.name);
  this.Serializable$set("metadata", null == parameters.metadata ? null : parameters.metadata);
  this.Serializable$set("done", null == parameters.done ? null : parameters.done);
  this.Serializable$set("error", null == parameters.error ? null : parameters.error);
  this.Serializable$set("response", null == parameters.response ? null : parameters.response);
};
$jscomp.inherits(module$exports$eeapiclient$ee_api_client.Operation, module$exports$eeapiclient$domain_object.Serializable);
module$exports$eeapiclient$ee_api_client.Operation.prototype.getConstructor = function() {
  return module$exports$eeapiclient$ee_api_client.Operation;
};
module$exports$eeapiclient$ee_api_client.Operation.prototype.getPartialClassMetadata = function() {
  return {keys:["done", "error", "metadata", "name", "response"], objectMaps:{metadata:{ctor:null, isPropertyArray:!1, isSerializable:!1, isValueArray:!1}, response:{ctor:null, isPropertyArray:!1, isSerializable:!1, isValueArray:!1}}, objects:{error:module$exports$eeapiclient$ee_api_client.Status}};
};
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.Operation.prototype, {done:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("done") ? this.Serializable$get("done") : null;
}, set:function(value) {
  this.Serializable$set("done", value);
}}, error:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("error") ? this.Serializable$get("error") : null;
}, set:function(value) {
  this.Serializable$set("error", value);
}}, metadata:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("metadata") ? this.Serializable$get("metadata") : null;
}, set:function(value) {
  this.Serializable$set("metadata", value);
}}, name:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("name") ? this.Serializable$get("name") : null;
}, set:function(value) {
  this.Serializable$set("name", value);
}}, response:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("response") ? this.Serializable$get("response") : null;
}, set:function(value) {
  this.Serializable$set("response", value);
}}});
module$exports$eeapiclient$ee_api_client.OperationMetadataParameters = function module$contents$eeapiclient$ee_api_client_OperationMetadataParameters() {
};
module$exports$eeapiclient$ee_api_client.OperationMetadata = function(parameters) {
  parameters = void 0 === parameters ? {} : parameters;
  module$exports$eeapiclient$domain_object.Serializable.call(this);
  this.Serializable$set("state", null == parameters.state ? null : parameters.state);
  this.Serializable$set("description", null == parameters.description ? null : parameters.description);
  this.Serializable$set("type", null == parameters.type ? null : parameters.type);
  this.Serializable$set("priority", null == parameters.priority ? null : parameters.priority);
  this.Serializable$set("createTime", null == parameters.createTime ? null : parameters.createTime);
  this.Serializable$set("updateTime", null == parameters.updateTime ? null : parameters.updateTime);
  this.Serializable$set("startTime", null == parameters.startTime ? null : parameters.startTime);
  this.Serializable$set("endTime", null == parameters.endTime ? null : parameters.endTime);
  this.Serializable$set("scriptUri", null == parameters.scriptUri ? null : parameters.scriptUri);
  this.Serializable$set("destinationUris", null == parameters.destinationUris ? null : parameters.destinationUris);
};
$jscomp.inherits(module$exports$eeapiclient$ee_api_client.OperationMetadata, module$exports$eeapiclient$domain_object.Serializable);
module$exports$eeapiclient$ee_api_client.OperationMetadata.prototype.getConstructor = function() {
  return module$exports$eeapiclient$ee_api_client.OperationMetadata;
};
module$exports$eeapiclient$ee_api_client.OperationMetadata.prototype.getPartialClassMetadata = function() {
  return {enums:{state:module$exports$eeapiclient$ee_api_client.OperationMetadataStateEnum}, keys:"createTime description destinationUris endTime priority scriptUri startTime state type updateTime".split(" ")};
};
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.OperationMetadata.prototype, {createTime:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("createTime") ? this.Serializable$get("createTime") : null;
}, set:function(value) {
  this.Serializable$set("createTime", value);
}}, description:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("description") ? this.Serializable$get("description") : null;
}, set:function(value) {
  this.Serializable$set("description", value);
}}, destinationUris:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("destinationUris") ? this.Serializable$get("destinationUris") : null;
}, set:function(value) {
  this.Serializable$set("destinationUris", value);
}}, endTime:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("endTime") ? this.Serializable$get("endTime") : null;
}, set:function(value) {
  this.Serializable$set("endTime", value);
}}, priority:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("priority") ? this.Serializable$get("priority") : null;
}, set:function(value) {
  this.Serializable$set("priority", value);
}}, scriptUri:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("scriptUri") ? this.Serializable$get("scriptUri") : null;
}, set:function(value) {
  this.Serializable$set("scriptUri", value);
}}, startTime:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("startTime") ? this.Serializable$get("startTime") : null;
}, set:function(value) {
  this.Serializable$set("startTime", value);
}}, state:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("state") ? this.Serializable$get("state") : null;
}, set:function(value) {
  this.Serializable$set("state", value);
}}, type:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("type") ? this.Serializable$get("type") : null;
}, set:function(value) {
  this.Serializable$set("type", value);
}}, updateTime:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("updateTime") ? this.Serializable$get("updateTime") : null;
}, set:function(value) {
  this.Serializable$set("updateTime", value);
}}});
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.OperationMetadata, {State:{configurable:!0, enumerable:!0, get:function() {
  return module$exports$eeapiclient$ee_api_client.OperationMetadataStateEnum;
}}});
module$exports$eeapiclient$ee_api_client.PixelDataTypeParameters = function module$contents$eeapiclient$ee_api_client_PixelDataTypeParameters() {
};
module$exports$eeapiclient$ee_api_client.PixelDataType = function(parameters) {
  parameters = void 0 === parameters ? {} : parameters;
  module$exports$eeapiclient$domain_object.Serializable.call(this);
  this.Serializable$set("precision", null == parameters.precision ? null : parameters.precision);
  this.Serializable$set("range", null == parameters.range ? null : parameters.range);
  this.Serializable$set("dimensionsCount", null == parameters.dimensionsCount ? null : parameters.dimensionsCount);
};
$jscomp.inherits(module$exports$eeapiclient$ee_api_client.PixelDataType, module$exports$eeapiclient$domain_object.Serializable);
module$exports$eeapiclient$ee_api_client.PixelDataType.prototype.getConstructor = function() {
  return module$exports$eeapiclient$ee_api_client.PixelDataType;
};
module$exports$eeapiclient$ee_api_client.PixelDataType.prototype.getPartialClassMetadata = function() {
  return {enums:{precision:module$exports$eeapiclient$ee_api_client.PixelDataTypePrecisionEnum}, keys:["dimensionsCount", "precision", "range"], objects:{range:module$exports$eeapiclient$ee_api_client.DoubleRange}};
};
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.PixelDataType.prototype, {dimensionsCount:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("dimensionsCount") ? this.Serializable$get("dimensionsCount") : null;
}, set:function(value) {
  this.Serializable$set("dimensionsCount", value);
}}, precision:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("precision") ? this.Serializable$get("precision") : null;
}, set:function(value) {
  this.Serializable$set("precision", value);
}}, range:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("range") ? this.Serializable$get("range") : null;
}, set:function(value) {
  this.Serializable$set("range", value);
}}});
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.PixelDataType, {Precision:{configurable:!0, enumerable:!0, get:function() {
  return module$exports$eeapiclient$ee_api_client.PixelDataTypePrecisionEnum;
}}});
module$exports$eeapiclient$ee_api_client.PixelFootprintParameters = function module$contents$eeapiclient$ee_api_client_PixelFootprintParameters() {
};
module$exports$eeapiclient$ee_api_client.PixelFootprint = function(parameters) {
  parameters = void 0 === parameters ? {} : parameters;
  module$exports$eeapiclient$domain_object.Serializable.call(this);
  this.Serializable$set("points", null == parameters.points ? null : parameters.points);
  this.Serializable$set("bandId", null == parameters.bandId ? null : parameters.bandId);
};
$jscomp.inherits(module$exports$eeapiclient$ee_api_client.PixelFootprint, module$exports$eeapiclient$domain_object.Serializable);
module$exports$eeapiclient$ee_api_client.PixelFootprint.prototype.getConstructor = function() {
  return module$exports$eeapiclient$ee_api_client.PixelFootprint;
};
module$exports$eeapiclient$ee_api_client.PixelFootprint.prototype.getPartialClassMetadata = function() {
  return {arrays:{points:module$exports$eeapiclient$ee_api_client.GridPoint}, keys:["bandId", "points"]};
};
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.PixelFootprint.prototype, {bandId:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("bandId") ? this.Serializable$get("bandId") : null;
}, set:function(value) {
  this.Serializable$set("bandId", value);
}}, points:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("points") ? this.Serializable$get("points") : null;
}, set:function(value) {
  this.Serializable$set("points", value);
}}});
module$exports$eeapiclient$ee_api_client.PixelGridParameters = function module$contents$eeapiclient$ee_api_client_PixelGridParameters() {
};
module$exports$eeapiclient$ee_api_client.PixelGrid = function(parameters) {
  parameters = void 0 === parameters ? {} : parameters;
  module$exports$eeapiclient$domain_object.Serializable.call(this);
  this.Serializable$set("crsCode", null == parameters.crsCode ? null : parameters.crsCode);
  this.Serializable$set("crsWkt", null == parameters.crsWkt ? null : parameters.crsWkt);
  this.Serializable$set("dimensions", null == parameters.dimensions ? null : parameters.dimensions);
  this.Serializable$set("affineTransform", null == parameters.affineTransform ? null : parameters.affineTransform);
};
$jscomp.inherits(module$exports$eeapiclient$ee_api_client.PixelGrid, module$exports$eeapiclient$domain_object.Serializable);
module$exports$eeapiclient$ee_api_client.PixelGrid.prototype.getConstructor = function() {
  return module$exports$eeapiclient$ee_api_client.PixelGrid;
};
module$exports$eeapiclient$ee_api_client.PixelGrid.prototype.getPartialClassMetadata = function() {
  return {keys:["affineTransform", "crsCode", "crsWkt", "dimensions"], objects:{affineTransform:module$exports$eeapiclient$ee_api_client.AffineTransform, dimensions:module$exports$eeapiclient$ee_api_client.GridDimensions}};
};
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.PixelGrid.prototype, {affineTransform:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("affineTransform") ? this.Serializable$get("affineTransform") : null;
}, set:function(value) {
  this.Serializable$set("affineTransform", value);
}}, crsCode:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("crsCode") ? this.Serializable$get("crsCode") : null;
}, set:function(value) {
  this.Serializable$set("crsCode", value);
}}, crsWkt:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("crsWkt") ? this.Serializable$get("crsWkt") : null;
}, set:function(value) {
  this.Serializable$set("crsWkt", value);
}}, dimensions:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("dimensions") ? this.Serializable$get("dimensions") : null;
}, set:function(value) {
  this.Serializable$set("dimensions", value);
}}});
module$exports$eeapiclient$ee_api_client.PolicyParameters = function module$contents$eeapiclient$ee_api_client_PolicyParameters() {
};
module$exports$eeapiclient$ee_api_client.Policy = function(parameters) {
  parameters = void 0 === parameters ? {} : parameters;
  module$exports$eeapiclient$domain_object.Serializable.call(this);
  this.Serializable$set("version", null == parameters.version ? null : parameters.version);
  this.Serializable$set("bindings", null == parameters.bindings ? null : parameters.bindings);
  this.Serializable$set("auditConfigs", null == parameters.auditConfigs ? null : parameters.auditConfigs);
  this.Serializable$set("rules", null == parameters.rules ? null : parameters.rules);
  this.Serializable$set("etag", null == parameters.etag ? null : parameters.etag);
  this.Serializable$set("iamOwned", null == parameters.iamOwned ? null : parameters.iamOwned);
};
$jscomp.inherits(module$exports$eeapiclient$ee_api_client.Policy, module$exports$eeapiclient$domain_object.Serializable);
module$exports$eeapiclient$ee_api_client.Policy.prototype.getConstructor = function() {
  return module$exports$eeapiclient$ee_api_client.Policy;
};
module$exports$eeapiclient$ee_api_client.Policy.prototype.getPartialClassMetadata = function() {
  return {arrays:{auditConfigs:module$exports$eeapiclient$ee_api_client.AuditConfig, bindings:module$exports$eeapiclient$ee_api_client.Binding, rules:module$exports$eeapiclient$ee_api_client.Rule}, keys:"auditConfigs bindings etag iamOwned rules version".split(" ")};
};
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.Policy.prototype, {auditConfigs:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("auditConfigs") ? this.Serializable$get("auditConfigs") : null;
}, set:function(value) {
  this.Serializable$set("auditConfigs", value);
}}, bindings:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("bindings") ? this.Serializable$get("bindings") : null;
}, set:function(value) {
  this.Serializable$set("bindings", value);
}}, etag:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("etag") ? this.Serializable$get("etag") : null;
}, set:function(value) {
  this.Serializable$set("etag", value);
}}, iamOwned:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("iamOwned") ? this.Serializable$get("iamOwned") : null;
}, set:function(value) {
  this.Serializable$set("iamOwned", value);
}}, rules:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("rules") ? this.Serializable$get("rules") : null;
}, set:function(value) {
  this.Serializable$set("rules", value);
}}, version:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("version") ? this.Serializable$get("version") : null;
}, set:function(value) {
  this.Serializable$set("version", value);
}}});
module$exports$eeapiclient$ee_api_client.RuleParameters = function module$contents$eeapiclient$ee_api_client_RuleParameters() {
};
module$exports$eeapiclient$ee_api_client.Rule = function(parameters) {
  parameters = void 0 === parameters ? {} : parameters;
  module$exports$eeapiclient$domain_object.Serializable.call(this);
  this.Serializable$set("description", null == parameters.description ? null : parameters.description);
  this.Serializable$set("permissions", null == parameters.permissions ? null : parameters.permissions);
  this.Serializable$set("action", null == parameters.action ? null : parameters.action);
  this.Serializable$set("in", null == parameters.in ? null : parameters.in);
  this.Serializable$set("notIn", null == parameters.notIn ? null : parameters.notIn);
  this.Serializable$set("conditions", null == parameters.conditions ? null : parameters.conditions);
  this.Serializable$set("logConfig", null == parameters.logConfig ? null : parameters.logConfig);
};
$jscomp.inherits(module$exports$eeapiclient$ee_api_client.Rule, module$exports$eeapiclient$domain_object.Serializable);
module$exports$eeapiclient$ee_api_client.Rule.prototype.getConstructor = function() {
  return module$exports$eeapiclient$ee_api_client.Rule;
};
module$exports$eeapiclient$ee_api_client.Rule.prototype.getPartialClassMetadata = function() {
  return {arrays:{conditions:module$exports$eeapiclient$ee_api_client.Condition, logConfig:module$exports$eeapiclient$ee_api_client.LogConfig}, enums:{action:module$exports$eeapiclient$ee_api_client.RuleActionEnum}, keys:"action conditions description in logConfig notIn permissions".split(" ")};
};
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.Rule.prototype, {action:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("action") ? this.Serializable$get("action") : null;
}, set:function(value) {
  this.Serializable$set("action", value);
}}, conditions:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("conditions") ? this.Serializable$get("conditions") : null;
}, set:function(value) {
  this.Serializable$set("conditions", value);
}}, description:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("description") ? this.Serializable$get("description") : null;
}, set:function(value) {
  this.Serializable$set("description", value);
}}, in:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("in") ? this.Serializable$get("in") : null;
}, set:function(value) {
  this.Serializable$set("in", value);
}}, logConfig:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("logConfig") ? this.Serializable$get("logConfig") : null;
}, set:function(value) {
  this.Serializable$set("logConfig", value);
}}, notIn:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("notIn") ? this.Serializable$get("notIn") : null;
}, set:function(value) {
  this.Serializable$set("notIn", value);
}}, permissions:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("permissions") ? this.Serializable$get("permissions") : null;
}, set:function(value) {
  this.Serializable$set("permissions", value);
}}});
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.Rule, {Action:{configurable:!0, enumerable:!0, get:function() {
  return module$exports$eeapiclient$ee_api_client.RuleActionEnum;
}}});
module$exports$eeapiclient$ee_api_client.SetIamPolicyRequestParameters = function module$contents$eeapiclient$ee_api_client_SetIamPolicyRequestParameters() {
};
module$exports$eeapiclient$ee_api_client.SetIamPolicyRequest = function(parameters) {
  parameters = void 0 === parameters ? {} : parameters;
  module$exports$eeapiclient$domain_object.Serializable.call(this);
  this.Serializable$set("policy", null == parameters.policy ? null : parameters.policy);
  this.Serializable$set("updateMask", null == parameters.updateMask ? null : parameters.updateMask);
};
$jscomp.inherits(module$exports$eeapiclient$ee_api_client.SetIamPolicyRequest, module$exports$eeapiclient$domain_object.Serializable);
module$exports$eeapiclient$ee_api_client.SetIamPolicyRequest.prototype.getConstructor = function() {
  return module$exports$eeapiclient$ee_api_client.SetIamPolicyRequest;
};
module$exports$eeapiclient$ee_api_client.SetIamPolicyRequest.prototype.getPartialClassMetadata = function() {
  return {keys:["policy", "updateMask"], objects:{policy:module$exports$eeapiclient$ee_api_client.Policy}};
};
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.SetIamPolicyRequest.prototype, {policy:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("policy") ? this.Serializable$get("policy") : null;
}, set:function(value) {
  this.Serializable$set("policy", value);
}}, updateMask:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("updateMask") ? this.Serializable$get("updateMask") : null;
}, set:function(value) {
  this.Serializable$set("updateMask", value);
}}});
module$exports$eeapiclient$ee_api_client.StatusParameters = function module$contents$eeapiclient$ee_api_client_StatusParameters() {
};
module$exports$eeapiclient$ee_api_client.Status = function(parameters) {
  parameters = void 0 === parameters ? {} : parameters;
  module$exports$eeapiclient$domain_object.Serializable.call(this);
  this.Serializable$set("code", null == parameters.code ? null : parameters.code);
  this.Serializable$set("message", null == parameters.message ? null : parameters.message);
  this.Serializable$set("details", null == parameters.details ? null : parameters.details);
};
$jscomp.inherits(module$exports$eeapiclient$ee_api_client.Status, module$exports$eeapiclient$domain_object.Serializable);
module$exports$eeapiclient$ee_api_client.Status.prototype.getConstructor = function() {
  return module$exports$eeapiclient$ee_api_client.Status;
};
module$exports$eeapiclient$ee_api_client.Status.prototype.getPartialClassMetadata = function() {
  return {keys:["code", "details", "message"], objectMaps:{details:{ctor:null, isPropertyArray:!0, isSerializable:!1, isValueArray:!1}}};
};
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.Status.prototype, {code:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("code") ? this.Serializable$get("code") : null;
}, set:function(value) {
  this.Serializable$set("code", value);
}}, details:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("details") ? this.Serializable$get("details") : null;
}, set:function(value) {
  this.Serializable$set("details", value);
}}, message:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("message") ? this.Serializable$get("message") : null;
}, set:function(value) {
  this.Serializable$set("message", value);
}}});
module$exports$eeapiclient$ee_api_client.TableParameters = function module$contents$eeapiclient$ee_api_client_TableParameters() {
};
module$exports$eeapiclient$ee_api_client.Table = function(parameters) {
  parameters = void 0 === parameters ? {} : parameters;
  module$exports$eeapiclient$domain_object.Serializable.call(this);
  this.Serializable$set("name", null == parameters.name ? null : parameters.name);
  this.Serializable$set("expression", null == parameters.expression ? null : parameters.expression);
  this.Serializable$set("fileFormat", null == parameters.fileFormat ? null : parameters.fileFormat);
  this.Serializable$set("selectors", null == parameters.selectors ? null : parameters.selectors);
  this.Serializable$set("filename", null == parameters.filename ? null : parameters.filename);
};
$jscomp.inherits(module$exports$eeapiclient$ee_api_client.Table, module$exports$eeapiclient$domain_object.Serializable);
module$exports$eeapiclient$ee_api_client.Table.prototype.getConstructor = function() {
  return module$exports$eeapiclient$ee_api_client.Table;
};
module$exports$eeapiclient$ee_api_client.Table.prototype.getPartialClassMetadata = function() {
  return {enums:{fileFormat:module$exports$eeapiclient$ee_api_client.TableFileFormatEnum}, keys:["expression", "fileFormat", "filename", "name", "selectors"], objects:{expression:module$exports$eeapiclient$ee_api_client.Expression}};
};
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.Table.prototype, {expression:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("expression") ? this.Serializable$get("expression") : null;
}, set:function(value) {
  this.Serializable$set("expression", value);
}}, fileFormat:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("fileFormat") ? this.Serializable$get("fileFormat") : null;
}, set:function(value) {
  this.Serializable$set("fileFormat", value);
}}, filename:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("filename") ? this.Serializable$get("filename") : null;
}, set:function(value) {
  this.Serializable$set("filename", value);
}}, name:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("name") ? this.Serializable$get("name") : null;
}, set:function(value) {
  this.Serializable$set("name", value);
}}, selectors:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("selectors") ? this.Serializable$get("selectors") : null;
}, set:function(value) {
  this.Serializable$set("selectors", value);
}}});
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.Table, {FileFormat:{configurable:!0, enumerable:!0, get:function() {
  return module$exports$eeapiclient$ee_api_client.TableFileFormatEnum;
}}});
module$exports$eeapiclient$ee_api_client.TableAssetExportOptionsParameters = function module$contents$eeapiclient$ee_api_client_TableAssetExportOptionsParameters() {
};
module$exports$eeapiclient$ee_api_client.TableAssetExportOptions = function(parameters) {
  parameters = void 0 === parameters ? {} : parameters;
  module$exports$eeapiclient$domain_object.Serializable.call(this);
  this.Serializable$set("earthEngineDestination", null == parameters.earthEngineDestination ? null : parameters.earthEngineDestination);
};
$jscomp.inherits(module$exports$eeapiclient$ee_api_client.TableAssetExportOptions, module$exports$eeapiclient$domain_object.Serializable);
module$exports$eeapiclient$ee_api_client.TableAssetExportOptions.prototype.getConstructor = function() {
  return module$exports$eeapiclient$ee_api_client.TableAssetExportOptions;
};
module$exports$eeapiclient$ee_api_client.TableAssetExportOptions.prototype.getPartialClassMetadata = function() {
  return {keys:["earthEngineDestination"], objects:{earthEngineDestination:module$exports$eeapiclient$ee_api_client.EarthEngineDestination}};
};
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.TableAssetExportOptions.prototype, {earthEngineDestination:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("earthEngineDestination") ? this.Serializable$get("earthEngineDestination") : null;
}, set:function(value) {
  this.Serializable$set("earthEngineDestination", value);
}}});
module$exports$eeapiclient$ee_api_client.TableFileExportOptionsParameters = function module$contents$eeapiclient$ee_api_client_TableFileExportOptionsParameters() {
};
module$exports$eeapiclient$ee_api_client.TableFileExportOptions = function(parameters) {
  parameters = void 0 === parameters ? {} : parameters;
  module$exports$eeapiclient$domain_object.Serializable.call(this);
  this.Serializable$set("fileFormat", null == parameters.fileFormat ? null : parameters.fileFormat);
  this.Serializable$set("driveDestination", null == parameters.driveDestination ? null : parameters.driveDestination);
  this.Serializable$set("gcsDestination", null == parameters.gcsDestination ? null : parameters.gcsDestination);
};
$jscomp.inherits(module$exports$eeapiclient$ee_api_client.TableFileExportOptions, module$exports$eeapiclient$domain_object.Serializable);
module$exports$eeapiclient$ee_api_client.TableFileExportOptions.prototype.getConstructor = function() {
  return module$exports$eeapiclient$ee_api_client.TableFileExportOptions;
};
module$exports$eeapiclient$ee_api_client.TableFileExportOptions.prototype.getPartialClassMetadata = function() {
  return {enums:{fileFormat:module$exports$eeapiclient$ee_api_client.TableFileExportOptionsFileFormatEnum}, keys:["driveDestination", "fileFormat", "gcsDestination"], objects:{driveDestination:module$exports$eeapiclient$ee_api_client.DriveDestination, gcsDestination:module$exports$eeapiclient$ee_api_client.GcsDestination}};
};
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.TableFileExportOptions.prototype, {driveDestination:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("driveDestination") ? this.Serializable$get("driveDestination") : null;
}, set:function(value) {
  this.Serializable$set("driveDestination", value);
}}, fileFormat:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("fileFormat") ? this.Serializable$get("fileFormat") : null;
}, set:function(value) {
  this.Serializable$set("fileFormat", value);
}}, gcsDestination:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("gcsDestination") ? this.Serializable$get("gcsDestination") : null;
}, set:function(value) {
  this.Serializable$set("gcsDestination", value);
}}});
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.TableFileExportOptions, {FileFormat:{configurable:!0, enumerable:!0, get:function() {
  return module$exports$eeapiclient$ee_api_client.TableFileExportOptionsFileFormatEnum;
}}});
module$exports$eeapiclient$ee_api_client.TableManifestParameters = function module$contents$eeapiclient$ee_api_client_TableManifestParameters() {
};
module$exports$eeapiclient$ee_api_client.TableManifest = function(parameters) {
  parameters = void 0 === parameters ? {} : parameters;
  module$exports$eeapiclient$domain_object.Serializable.call(this);
  this.Serializable$set("name", null == parameters.name ? null : parameters.name);
  this.Serializable$set("properties", null == parameters.properties ? null : parameters.properties);
  this.Serializable$set("uriPrefix", null == parameters.uriPrefix ? null : parameters.uriPrefix);
  this.Serializable$set("sources", null == parameters.sources ? null : parameters.sources);
  this.Serializable$set("startTime", null == parameters.startTime ? null : parameters.startTime);
  this.Serializable$set("endTime", null == parameters.endTime ? null : parameters.endTime);
};
$jscomp.inherits(module$exports$eeapiclient$ee_api_client.TableManifest, module$exports$eeapiclient$domain_object.Serializable);
module$exports$eeapiclient$ee_api_client.TableManifest.prototype.getConstructor = function() {
  return module$exports$eeapiclient$ee_api_client.TableManifest;
};
module$exports$eeapiclient$ee_api_client.TableManifest.prototype.getPartialClassMetadata = function() {
  return {arrays:{sources:module$exports$eeapiclient$ee_api_client.TableSource}, keys:"endTime name properties sources startTime uriPrefix".split(" "), objectMaps:{properties:{ctor:null, isPropertyArray:!1, isSerializable:!1, isValueArray:!1}}};
};
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.TableManifest.prototype, {endTime:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("endTime") ? this.Serializable$get("endTime") : null;
}, set:function(value) {
  this.Serializable$set("endTime", value);
}}, name:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("name") ? this.Serializable$get("name") : null;
}, set:function(value) {
  this.Serializable$set("name", value);
}}, properties:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("properties") ? this.Serializable$get("properties") : null;
}, set:function(value) {
  this.Serializable$set("properties", value);
}}, sources:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("sources") ? this.Serializable$get("sources") : null;
}, set:function(value) {
  this.Serializable$set("sources", value);
}}, startTime:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("startTime") ? this.Serializable$get("startTime") : null;
}, set:function(value) {
  this.Serializable$set("startTime", value);
}}, uriPrefix:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("uriPrefix") ? this.Serializable$get("uriPrefix") : null;
}, set:function(value) {
  this.Serializable$set("uriPrefix", value);
}}});
module$exports$eeapiclient$ee_api_client.TableSourceParameters = function module$contents$eeapiclient$ee_api_client_TableSourceParameters() {
};
module$exports$eeapiclient$ee_api_client.TableSource = function(parameters) {
  parameters = void 0 === parameters ? {} : parameters;
  module$exports$eeapiclient$domain_object.Serializable.call(this);
  this.Serializable$set("uris", null == parameters.uris ? null : parameters.uris);
  this.Serializable$set("charset", null == parameters.charset ? null : parameters.charset);
  this.Serializable$set("maxErrorMeters", null == parameters.maxErrorMeters ? null : parameters.maxErrorMeters);
  this.Serializable$set("maxVertices", null == parameters.maxVertices ? null : parameters.maxVertices);
  this.Serializable$set("crs", null == parameters.crs ? null : parameters.crs);
  this.Serializable$set("geodesic", null == parameters.geodesic ? null : parameters.geodesic);
  this.Serializable$set("primaryGeometryColumn", null == parameters.primaryGeometryColumn ? null : parameters.primaryGeometryColumn);
  this.Serializable$set("xColumn", null == parameters.xColumn ? null : parameters.xColumn);
  this.Serializable$set("yColumn", null == parameters.yColumn ? null : parameters.yColumn);
  this.Serializable$set("dateFormat", null == parameters.dateFormat ? null : parameters.dateFormat);
  this.Serializable$set("csvDelimiter", null == parameters.csvDelimiter ? null : parameters.csvDelimiter);
  this.Serializable$set("csvQualifier", null == parameters.csvQualifier ? null : parameters.csvQualifier);
};
$jscomp.inherits(module$exports$eeapiclient$ee_api_client.TableSource, module$exports$eeapiclient$domain_object.Serializable);
module$exports$eeapiclient$ee_api_client.TableSource.prototype.getConstructor = function() {
  return module$exports$eeapiclient$ee_api_client.TableSource;
};
module$exports$eeapiclient$ee_api_client.TableSource.prototype.getPartialClassMetadata = function() {
  return {keys:"charset crs csvDelimiter csvQualifier dateFormat geodesic maxErrorMeters maxVertices primaryGeometryColumn uris xColumn yColumn".split(" ")};
};
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.TableSource.prototype, {charset:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("charset") ? this.Serializable$get("charset") : null;
}, set:function(value) {
  this.Serializable$set("charset", value);
}}, crs:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("crs") ? this.Serializable$get("crs") : null;
}, set:function(value) {
  this.Serializable$set("crs", value);
}}, csvDelimiter:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("csvDelimiter") ? this.Serializable$get("csvDelimiter") : null;
}, set:function(value) {
  this.Serializable$set("csvDelimiter", value);
}}, csvQualifier:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("csvQualifier") ? this.Serializable$get("csvQualifier") : null;
}, set:function(value) {
  this.Serializable$set("csvQualifier", value);
}}, dateFormat:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("dateFormat") ? this.Serializable$get("dateFormat") : null;
}, set:function(value) {
  this.Serializable$set("dateFormat", value);
}}, geodesic:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("geodesic") ? this.Serializable$get("geodesic") : null;
}, set:function(value) {
  this.Serializable$set("geodesic", value);
}}, maxErrorMeters:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("maxErrorMeters") ? this.Serializable$get("maxErrorMeters") : null;
}, set:function(value) {
  this.Serializable$set("maxErrorMeters", value);
}}, maxVertices:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("maxVertices") ? this.Serializable$get("maxVertices") : null;
}, set:function(value) {
  this.Serializable$set("maxVertices", value);
}}, primaryGeometryColumn:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("primaryGeometryColumn") ? this.Serializable$get("primaryGeometryColumn") : null;
}, set:function(value) {
  this.Serializable$set("primaryGeometryColumn", value);
}}, uris:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("uris") ? this.Serializable$get("uris") : null;
}, set:function(value) {
  this.Serializable$set("uris", value);
}}, xColumn:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("xColumn") ? this.Serializable$get("xColumn") : null;
}, set:function(value) {
  this.Serializable$set("xColumn", value);
}}, yColumn:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("yColumn") ? this.Serializable$get("yColumn") : null;
}, set:function(value) {
  this.Serializable$set("yColumn", value);
}}});
module$exports$eeapiclient$ee_api_client.TestIamPermissionsRequestParameters = function module$contents$eeapiclient$ee_api_client_TestIamPermissionsRequestParameters() {
};
module$exports$eeapiclient$ee_api_client.TestIamPermissionsRequest = function(parameters) {
  parameters = void 0 === parameters ? {} : parameters;
  module$exports$eeapiclient$domain_object.Serializable.call(this);
  this.Serializable$set("permissions", null == parameters.permissions ? null : parameters.permissions);
};
$jscomp.inherits(module$exports$eeapiclient$ee_api_client.TestIamPermissionsRequest, module$exports$eeapiclient$domain_object.Serializable);
module$exports$eeapiclient$ee_api_client.TestIamPermissionsRequest.prototype.getConstructor = function() {
  return module$exports$eeapiclient$ee_api_client.TestIamPermissionsRequest;
};
module$exports$eeapiclient$ee_api_client.TestIamPermissionsRequest.prototype.getPartialClassMetadata = function() {
  return {keys:["permissions"]};
};
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.TestIamPermissionsRequest.prototype, {permissions:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("permissions") ? this.Serializable$get("permissions") : null;
}, set:function(value) {
  this.Serializable$set("permissions", value);
}}});
module$exports$eeapiclient$ee_api_client.TestIamPermissionsResponseParameters = function module$contents$eeapiclient$ee_api_client_TestIamPermissionsResponseParameters() {
};
module$exports$eeapiclient$ee_api_client.TestIamPermissionsResponse = function(parameters) {
  parameters = void 0 === parameters ? {} : parameters;
  module$exports$eeapiclient$domain_object.Serializable.call(this);
  this.Serializable$set("permissions", null == parameters.permissions ? null : parameters.permissions);
};
$jscomp.inherits(module$exports$eeapiclient$ee_api_client.TestIamPermissionsResponse, module$exports$eeapiclient$domain_object.Serializable);
module$exports$eeapiclient$ee_api_client.TestIamPermissionsResponse.prototype.getConstructor = function() {
  return module$exports$eeapiclient$ee_api_client.TestIamPermissionsResponse;
};
module$exports$eeapiclient$ee_api_client.TestIamPermissionsResponse.prototype.getPartialClassMetadata = function() {
  return {keys:["permissions"]};
};
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.TestIamPermissionsResponse.prototype, {permissions:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("permissions") ? this.Serializable$get("permissions") : null;
}, set:function(value) {
  this.Serializable$set("permissions", value);
}}});
module$exports$eeapiclient$ee_api_client.TfRecordImageExportOptionsParameters = function module$contents$eeapiclient$ee_api_client_TfRecordImageExportOptionsParameters() {
};
module$exports$eeapiclient$ee_api_client.TfRecordImageExportOptions = function(parameters) {
  parameters = void 0 === parameters ? {} : parameters;
  module$exports$eeapiclient$domain_object.Serializable.call(this);
  this.Serializable$set("tileDimensions", null == parameters.tileDimensions ? null : parameters.tileDimensions);
  this.Serializable$set("marginDimensions", null == parameters.marginDimensions ? null : parameters.marginDimensions);
  this.Serializable$set("compress", null == parameters.compress ? null : parameters.compress);
  this.Serializable$set("maxSizeBytes", null == parameters.maxSizeBytes ? null : parameters.maxSizeBytes);
  this.Serializable$set("defaultValue", null == parameters.defaultValue ? null : parameters.defaultValue);
  this.Serializable$set("tensorDepths", null == parameters.tensorDepths ? null : parameters.tensorDepths);
  this.Serializable$set("sequenceData", null == parameters.sequenceData ? null : parameters.sequenceData);
  this.Serializable$set("collapseBands", null == parameters.collapseBands ? null : parameters.collapseBands);
  this.Serializable$set("maxMaskedRatio", null == parameters.maxMaskedRatio ? null : parameters.maxMaskedRatio);
};
$jscomp.inherits(module$exports$eeapiclient$ee_api_client.TfRecordImageExportOptions, module$exports$eeapiclient$domain_object.Serializable);
module$exports$eeapiclient$ee_api_client.TfRecordImageExportOptions.prototype.getConstructor = function() {
  return module$exports$eeapiclient$ee_api_client.TfRecordImageExportOptions;
};
module$exports$eeapiclient$ee_api_client.TfRecordImageExportOptions.prototype.getPartialClassMetadata = function() {
  return {keys:"collapseBands compress defaultValue marginDimensions maxMaskedRatio maxSizeBytes sequenceData tensorDepths tileDimensions".split(" "), objectMaps:{tensorDepths:{ctor:null, isPropertyArray:!1, isSerializable:!1, isValueArray:!1}}, objects:{marginDimensions:module$exports$eeapiclient$ee_api_client.GridDimensions, tileDimensions:module$exports$eeapiclient$ee_api_client.GridDimensions}};
};
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.TfRecordImageExportOptions.prototype, {collapseBands:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("collapseBands") ? this.Serializable$get("collapseBands") : null;
}, set:function(value) {
  this.Serializable$set("collapseBands", value);
}}, compress:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("compress") ? this.Serializable$get("compress") : null;
}, set:function(value) {
  this.Serializable$set("compress", value);
}}, defaultValue:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("defaultValue") ? this.Serializable$get("defaultValue") : null;
}, set:function(value) {
  this.Serializable$set("defaultValue", value);
}}, marginDimensions:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("marginDimensions") ? this.Serializable$get("marginDimensions") : null;
}, set:function(value) {
  this.Serializable$set("marginDimensions", value);
}}, maxMaskedRatio:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("maxMaskedRatio") ? this.Serializable$get("maxMaskedRatio") : null;
}, set:function(value) {
  this.Serializable$set("maxMaskedRatio", value);
}}, maxSizeBytes:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("maxSizeBytes") ? this.Serializable$get("maxSizeBytes") : null;
}, set:function(value) {
  this.Serializable$set("maxSizeBytes", value);
}}, sequenceData:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("sequenceData") ? this.Serializable$get("sequenceData") : null;
}, set:function(value) {
  this.Serializable$set("sequenceData", value);
}}, tensorDepths:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("tensorDepths") ? this.Serializable$get("tensorDepths") : null;
}, set:function(value) {
  this.Serializable$set("tensorDepths", value);
}}, tileDimensions:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("tileDimensions") ? this.Serializable$get("tileDimensions") : null;
}, set:function(value) {
  this.Serializable$set("tileDimensions", value);
}}});
module$exports$eeapiclient$ee_api_client.ThumbnailParameters = function module$contents$eeapiclient$ee_api_client_ThumbnailParameters() {
};
module$exports$eeapiclient$ee_api_client.Thumbnail = function(parameters) {
  parameters = void 0 === parameters ? {} : parameters;
  module$exports$eeapiclient$domain_object.Serializable.call(this);
  this.Serializable$set("name", null == parameters.name ? null : parameters.name);
  this.Serializable$set("expression", null == parameters.expression ? null : parameters.expression);
  this.Serializable$set("fileFormat", null == parameters.fileFormat ? null : parameters.fileFormat);
  this.Serializable$set("bandIds", null == parameters.bandIds ? null : parameters.bandIds);
  this.Serializable$set("visualizationOptions", null == parameters.visualizationOptions ? null : parameters.visualizationOptions);
  this.Serializable$set("grid", null == parameters.grid ? null : parameters.grid);
  this.Serializable$set("filenamePrefix", null == parameters.filenamePrefix ? null : parameters.filenamePrefix);
};
$jscomp.inherits(module$exports$eeapiclient$ee_api_client.Thumbnail, module$exports$eeapiclient$domain_object.Serializable);
module$exports$eeapiclient$ee_api_client.Thumbnail.prototype.getConstructor = function() {
  return module$exports$eeapiclient$ee_api_client.Thumbnail;
};
module$exports$eeapiclient$ee_api_client.Thumbnail.prototype.getPartialClassMetadata = function() {
  return {enums:{fileFormat:module$exports$eeapiclient$ee_api_client.ThumbnailFileFormatEnum}, keys:"bandIds expression fileFormat filenamePrefix grid name visualizationOptions".split(" "), objects:{expression:module$exports$eeapiclient$ee_api_client.Expression, grid:module$exports$eeapiclient$ee_api_client.PixelGrid, visualizationOptions:module$exports$eeapiclient$ee_api_client.VisualizationOptions}};
};
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.Thumbnail.prototype, {bandIds:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("bandIds") ? this.Serializable$get("bandIds") : null;
}, set:function(value) {
  this.Serializable$set("bandIds", value);
}}, expression:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("expression") ? this.Serializable$get("expression") : null;
}, set:function(value) {
  this.Serializable$set("expression", value);
}}, fileFormat:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("fileFormat") ? this.Serializable$get("fileFormat") : null;
}, set:function(value) {
  this.Serializable$set("fileFormat", value);
}}, filenamePrefix:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("filenamePrefix") ? this.Serializable$get("filenamePrefix") : null;
}, set:function(value) {
  this.Serializable$set("filenamePrefix", value);
}}, grid:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("grid") ? this.Serializable$get("grid") : null;
}, set:function(value) {
  this.Serializable$set("grid", value);
}}, name:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("name") ? this.Serializable$get("name") : null;
}, set:function(value) {
  this.Serializable$set("name", value);
}}, visualizationOptions:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("visualizationOptions") ? this.Serializable$get("visualizationOptions") : null;
}, set:function(value) {
  this.Serializable$set("visualizationOptions", value);
}}});
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.Thumbnail, {FileFormat:{configurable:!0, enumerable:!0, get:function() {
  return module$exports$eeapiclient$ee_api_client.ThumbnailFileFormatEnum;
}}});
module$exports$eeapiclient$ee_api_client.TileOptionsParameters = function module$contents$eeapiclient$ee_api_client_TileOptionsParameters() {
};
module$exports$eeapiclient$ee_api_client.TileOptions = function(parameters) {
  parameters = void 0 === parameters ? {} : parameters;
  module$exports$eeapiclient$domain_object.Serializable.call(this);
  this.Serializable$set("maxZoom", null == parameters.maxZoom ? null : parameters.maxZoom);
  this.Serializable$set("scale", null == parameters.scale ? null : parameters.scale);
  this.Serializable$set("minZoom", null == parameters.minZoom ? null : parameters.minZoom);
  this.Serializable$set("skipEmptyTiles", null == parameters.skipEmptyTiles ? null : parameters.skipEmptyTiles);
  this.Serializable$set("mapsApiKey", null == parameters.mapsApiKey ? null : parameters.mapsApiKey);
  this.Serializable$set("tileDimensions", null == parameters.tileDimensions ? null : parameters.tileDimensions);
  this.Serializable$set("stride", null == parameters.stride ? null : parameters.stride);
  this.Serializable$set("zoomSubset", null == parameters.zoomSubset ? null : parameters.zoomSubset);
};
$jscomp.inherits(module$exports$eeapiclient$ee_api_client.TileOptions, module$exports$eeapiclient$domain_object.Serializable);
module$exports$eeapiclient$ee_api_client.TileOptions.prototype.getConstructor = function() {
  return module$exports$eeapiclient$ee_api_client.TileOptions;
};
module$exports$eeapiclient$ee_api_client.TileOptions.prototype.getPartialClassMetadata = function() {
  return {keys:"mapsApiKey maxZoom minZoom scale skipEmptyTiles stride tileDimensions zoomSubset".split(" "), objects:{tileDimensions:module$exports$eeapiclient$ee_api_client.GridDimensions, zoomSubset:module$exports$eeapiclient$ee_api_client.ZoomSubset}};
};
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.TileOptions.prototype, {mapsApiKey:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("mapsApiKey") ? this.Serializable$get("mapsApiKey") : null;
}, set:function(value) {
  this.Serializable$set("mapsApiKey", value);
}}, maxZoom:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("maxZoom") ? this.Serializable$get("maxZoom") : null;
}, set:function(value) {
  this.Serializable$set("maxZoom", value);
}}, minZoom:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("minZoom") ? this.Serializable$get("minZoom") : null;
}, set:function(value) {
  this.Serializable$set("minZoom", value);
}}, scale:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("scale") ? this.Serializable$get("scale") : null;
}, set:function(value) {
  this.Serializable$set("scale", value);
}}, skipEmptyTiles:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("skipEmptyTiles") ? this.Serializable$get("skipEmptyTiles") : null;
}, set:function(value) {
  this.Serializable$set("skipEmptyTiles", value);
}}, stride:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("stride") ? this.Serializable$get("stride") : null;
}, set:function(value) {
  this.Serializable$set("stride", value);
}}, tileDimensions:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("tileDimensions") ? this.Serializable$get("tileDimensions") : null;
}, set:function(value) {
  this.Serializable$set("tileDimensions", value);
}}, zoomSubset:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("zoomSubset") ? this.Serializable$get("zoomSubset") : null;
}, set:function(value) {
  this.Serializable$set("zoomSubset", value);
}}});
module$exports$eeapiclient$ee_api_client.TilesetParameters = function module$contents$eeapiclient$ee_api_client_TilesetParameters() {
};
module$exports$eeapiclient$ee_api_client.Tileset = function(parameters) {
  parameters = void 0 === parameters ? {} : parameters;
  module$exports$eeapiclient$domain_object.Serializable.call(this);
  this.Serializable$set("id", null == parameters.id ? null : parameters.id);
  this.Serializable$set("sources", null == parameters.sources ? null : parameters.sources);
  this.Serializable$set("dataType", null == parameters.dataType ? null : parameters.dataType);
  this.Serializable$set("crs", null == parameters.crs ? null : parameters.crs);
  this.Serializable$set("subdatasetPrefix", null == parameters.subdatasetPrefix ? null : parameters.subdatasetPrefix);
  this.Serializable$set("subdatasetSuffix", null == parameters.subdatasetSuffix ? null : parameters.subdatasetSuffix);
};
$jscomp.inherits(module$exports$eeapiclient$ee_api_client.Tileset, module$exports$eeapiclient$domain_object.Serializable);
module$exports$eeapiclient$ee_api_client.Tileset.prototype.getConstructor = function() {
  return module$exports$eeapiclient$ee_api_client.Tileset;
};
module$exports$eeapiclient$ee_api_client.Tileset.prototype.getPartialClassMetadata = function() {
  return {arrays:{sources:module$exports$eeapiclient$ee_api_client.ImageSource}, enums:{dataType:module$exports$eeapiclient$ee_api_client.TilesetDataTypeEnum}, keys:"crs dataType id sources subdatasetPrefix subdatasetSuffix".split(" ")};
};
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.Tileset.prototype, {crs:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("crs") ? this.Serializable$get("crs") : null;
}, set:function(value) {
  this.Serializable$set("crs", value);
}}, dataType:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("dataType") ? this.Serializable$get("dataType") : null;
}, set:function(value) {
  this.Serializable$set("dataType", value);
}}, id:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("id") ? this.Serializable$get("id") : null;
}, set:function(value) {
  this.Serializable$set("id", value);
}}, sources:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("sources") ? this.Serializable$get("sources") : null;
}, set:function(value) {
  this.Serializable$set("sources", value);
}}, subdatasetPrefix:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("subdatasetPrefix") ? this.Serializable$get("subdatasetPrefix") : null;
}, set:function(value) {
  this.Serializable$set("subdatasetPrefix", value);
}}, subdatasetSuffix:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("subdatasetSuffix") ? this.Serializable$get("subdatasetSuffix") : null;
}, set:function(value) {
  this.Serializable$set("subdatasetSuffix", value);
}}});
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.Tileset, {DataType:{configurable:!0, enumerable:!0, get:function() {
  return module$exports$eeapiclient$ee_api_client.TilesetDataTypeEnum;
}}});
module$exports$eeapiclient$ee_api_client.TilesetBandParameters = function module$contents$eeapiclient$ee_api_client_TilesetBandParameters() {
};
module$exports$eeapiclient$ee_api_client.TilesetBand = function(parameters) {
  parameters = void 0 === parameters ? {} : parameters;
  module$exports$eeapiclient$domain_object.Serializable.call(this);
  this.Serializable$set("id", null == parameters.id ? null : parameters.id);
  this.Serializable$set("tilesetId", null == parameters.tilesetId ? null : parameters.tilesetId);
  this.Serializable$set("tilesetBandIndex", null == parameters.tilesetBandIndex ? null : parameters.tilesetBandIndex);
  this.Serializable$set("missingData", null == parameters.missingData ? null : parameters.missingData);
  this.Serializable$set("pyramidingPolicy", null == parameters.pyramidingPolicy ? null : parameters.pyramidingPolicy);
};
$jscomp.inherits(module$exports$eeapiclient$ee_api_client.TilesetBand, module$exports$eeapiclient$domain_object.Serializable);
module$exports$eeapiclient$ee_api_client.TilesetBand.prototype.getConstructor = function() {
  return module$exports$eeapiclient$ee_api_client.TilesetBand;
};
module$exports$eeapiclient$ee_api_client.TilesetBand.prototype.getPartialClassMetadata = function() {
  return {enums:{pyramidingPolicy:module$exports$eeapiclient$ee_api_client.TilesetBandPyramidingPolicyEnum}, keys:["id", "missingData", "pyramidingPolicy", "tilesetBandIndex", "tilesetId"], objects:{missingData:module$exports$eeapiclient$ee_api_client.MissingData}};
};
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.TilesetBand.prototype, {id:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("id") ? this.Serializable$get("id") : null;
}, set:function(value) {
  this.Serializable$set("id", value);
}}, missingData:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("missingData") ? this.Serializable$get("missingData") : null;
}, set:function(value) {
  this.Serializable$set("missingData", value);
}}, pyramidingPolicy:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("pyramidingPolicy") ? this.Serializable$get("pyramidingPolicy") : null;
}, set:function(value) {
  this.Serializable$set("pyramidingPolicy", value);
}}, tilesetBandIndex:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("tilesetBandIndex") ? this.Serializable$get("tilesetBandIndex") : null;
}, set:function(value) {
  this.Serializable$set("tilesetBandIndex", value);
}}, tilesetId:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("tilesetId") ? this.Serializable$get("tilesetId") : null;
}, set:function(value) {
  this.Serializable$set("tilesetId", value);
}}});
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.TilesetBand, {PyramidingPolicy:{configurable:!0, enumerable:!0, get:function() {
  return module$exports$eeapiclient$ee_api_client.TilesetBandPyramidingPolicyEnum;
}}});
module$exports$eeapiclient$ee_api_client.TilesetMaskBandParameters = function module$contents$eeapiclient$ee_api_client_TilesetMaskBandParameters() {
};
module$exports$eeapiclient$ee_api_client.TilesetMaskBand = function(parameters) {
  parameters = void 0 === parameters ? {} : parameters;
  module$exports$eeapiclient$domain_object.Serializable.call(this);
  this.Serializable$set("tilesetId", null == parameters.tilesetId ? null : parameters.tilesetId);
  this.Serializable$set("bandIds", null == parameters.bandIds ? null : parameters.bandIds);
};
$jscomp.inherits(module$exports$eeapiclient$ee_api_client.TilesetMaskBand, module$exports$eeapiclient$domain_object.Serializable);
module$exports$eeapiclient$ee_api_client.TilesetMaskBand.prototype.getConstructor = function() {
  return module$exports$eeapiclient$ee_api_client.TilesetMaskBand;
};
module$exports$eeapiclient$ee_api_client.TilesetMaskBand.prototype.getPartialClassMetadata = function() {
  return {keys:["bandIds", "tilesetId"]};
};
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.TilesetMaskBand.prototype, {bandIds:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("bandIds") ? this.Serializable$get("bandIds") : null;
}, set:function(value) {
  this.Serializable$set("bandIds", value);
}}, tilesetId:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("tilesetId") ? this.Serializable$get("tilesetId") : null;
}, set:function(value) {
  this.Serializable$set("tilesetId", value);
}}});
module$exports$eeapiclient$ee_api_client.TilestoreEntryParameters = function module$contents$eeapiclient$ee_api_client_TilestoreEntryParameters() {
};
module$exports$eeapiclient$ee_api_client.TilestoreEntry = function(parameters) {
  parameters = void 0 === parameters ? {} : parameters;
  module$exports$eeapiclient$domain_object.Serializable.call(this);
  this.Serializable$set("sources", null == parameters.sources ? null : parameters.sources);
  this.Serializable$set("pathPrefix", null == parameters.pathPrefix ? null : parameters.pathPrefix);
};
$jscomp.inherits(module$exports$eeapiclient$ee_api_client.TilestoreEntry, module$exports$eeapiclient$domain_object.Serializable);
module$exports$eeapiclient$ee_api_client.TilestoreEntry.prototype.getConstructor = function() {
  return module$exports$eeapiclient$ee_api_client.TilestoreEntry;
};
module$exports$eeapiclient$ee_api_client.TilestoreEntry.prototype.getPartialClassMetadata = function() {
  return {arrays:{sources:module$exports$eeapiclient$ee_api_client.TilestoreSource}, keys:["pathPrefix", "sources"]};
};
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.TilestoreEntry.prototype, {pathPrefix:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("pathPrefix") ? this.Serializable$get("pathPrefix") : null;
}, set:function(value) {
  this.Serializable$set("pathPrefix", value);
}}, sources:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("sources") ? this.Serializable$get("sources") : null;
}, set:function(value) {
  this.Serializable$set("sources", value);
}}});
module$exports$eeapiclient$ee_api_client.TilestoreSourceParameters = function module$contents$eeapiclient$ee_api_client_TilestoreSourceParameters() {
};
module$exports$eeapiclient$ee_api_client.TilestoreSource = function(parameters) {
  parameters = void 0 === parameters ? {} : parameters;
  module$exports$eeapiclient$domain_object.Serializable.call(this);
  this.Serializable$set("pathSuffix", null == parameters.pathSuffix ? null : parameters.pathSuffix);
  this.Serializable$set("headerSizeBytes", null == parameters.headerSizeBytes ? null : parameters.headerSizeBytes);
};
$jscomp.inherits(module$exports$eeapiclient$ee_api_client.TilestoreSource, module$exports$eeapiclient$domain_object.Serializable);
module$exports$eeapiclient$ee_api_client.TilestoreSource.prototype.getConstructor = function() {
  return module$exports$eeapiclient$ee_api_client.TilestoreSource;
};
module$exports$eeapiclient$ee_api_client.TilestoreSource.prototype.getPartialClassMetadata = function() {
  return {keys:["headerSizeBytes", "pathSuffix"]};
};
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.TilestoreSource.prototype, {headerSizeBytes:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("headerSizeBytes") ? this.Serializable$get("headerSizeBytes") : null;
}, set:function(value) {
  this.Serializable$set("headerSizeBytes", value);
}}, pathSuffix:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("pathSuffix") ? this.Serializable$get("pathSuffix") : null;
}, set:function(value) {
  this.Serializable$set("pathSuffix", value);
}}});
module$exports$eeapiclient$ee_api_client.TilestoreTilesetParameters = function module$contents$eeapiclient$ee_api_client_TilestoreTilesetParameters() {
};
module$exports$eeapiclient$ee_api_client.TilestoreTileset = function(parameters) {
  parameters = void 0 === parameters ? {} : parameters;
  module$exports$eeapiclient$domain_object.Serializable.call(this);
  this.Serializable$set("fileIndexes", null == parameters.fileIndexes ? null : parameters.fileIndexes);
  this.Serializable$set("firstTileIndex", null == parameters.firstTileIndex ? null : parameters.firstTileIndex);
  this.Serializable$set("tilesPerFile", null == parameters.tilesPerFile ? null : parameters.tilesPerFile);
};
$jscomp.inherits(module$exports$eeapiclient$ee_api_client.TilestoreTileset, module$exports$eeapiclient$domain_object.Serializable);
module$exports$eeapiclient$ee_api_client.TilestoreTileset.prototype.getConstructor = function() {
  return module$exports$eeapiclient$ee_api_client.TilestoreTileset;
};
module$exports$eeapiclient$ee_api_client.TilestoreTileset.prototype.getPartialClassMetadata = function() {
  return {keys:["fileIndexes", "firstTileIndex", "tilesPerFile"]};
};
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.TilestoreTileset.prototype, {fileIndexes:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("fileIndexes") ? this.Serializable$get("fileIndexes") : null;
}, set:function(value) {
  this.Serializable$set("fileIndexes", value);
}}, firstTileIndex:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("firstTileIndex") ? this.Serializable$get("firstTileIndex") : null;
}, set:function(value) {
  this.Serializable$set("firstTileIndex", value);
}}, tilesPerFile:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("tilesPerFile") ? this.Serializable$get("tilesPerFile") : null;
}, set:function(value) {
  this.Serializable$set("tilesPerFile", value);
}}});
module$exports$eeapiclient$ee_api_client.UpdateAssetRequestParameters = function module$contents$eeapiclient$ee_api_client_UpdateAssetRequestParameters() {
};
module$exports$eeapiclient$ee_api_client.UpdateAssetRequest = function(parameters) {
  parameters = void 0 === parameters ? {} : parameters;
  module$exports$eeapiclient$domain_object.Serializable.call(this);
  this.Serializable$set("asset", null == parameters.asset ? null : parameters.asset);
  this.Serializable$set("updateMask", null == parameters.updateMask ? null : parameters.updateMask);
};
$jscomp.inherits(module$exports$eeapiclient$ee_api_client.UpdateAssetRequest, module$exports$eeapiclient$domain_object.Serializable);
module$exports$eeapiclient$ee_api_client.UpdateAssetRequest.prototype.getConstructor = function() {
  return module$exports$eeapiclient$ee_api_client.UpdateAssetRequest;
};
module$exports$eeapiclient$ee_api_client.UpdateAssetRequest.prototype.getPartialClassMetadata = function() {
  return {keys:["asset", "updateMask"], objects:{asset:module$exports$eeapiclient$ee_api_client.EarthEngineAsset}};
};
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.UpdateAssetRequest.prototype, {asset:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("asset") ? this.Serializable$get("asset") : null;
}, set:function(value) {
  this.Serializable$set("asset", value);
}}, updateMask:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("updateMask") ? this.Serializable$get("updateMask") : null;
}, set:function(value) {
  this.Serializable$set("updateMask", value);
}}});
module$exports$eeapiclient$ee_api_client.ValueNodeParameters = function module$contents$eeapiclient$ee_api_client_ValueNodeParameters() {
};
module$exports$eeapiclient$ee_api_client.ValueNode = function(parameters) {
  parameters = void 0 === parameters ? {} : parameters;
  module$exports$eeapiclient$domain_object.Serializable.call(this);
  this.Serializable$set("constantValue", null == parameters.constantValue ? null : parameters.constantValue);
  this.Serializable$set("integerValue", null == parameters.integerValue ? null : parameters.integerValue);
  this.Serializable$set("bytesValue", null == parameters.bytesValue ? null : parameters.bytesValue);
  this.Serializable$set("arrayValue", null == parameters.arrayValue ? null : parameters.arrayValue);
  this.Serializable$set("dictionaryValue", null == parameters.dictionaryValue ? null : parameters.dictionaryValue);
  this.Serializable$set("functionDefinitionValue", null == parameters.functionDefinitionValue ? null : parameters.functionDefinitionValue);
  this.Serializable$set("functionInvocationValue", null == parameters.functionInvocationValue ? null : parameters.functionInvocationValue);
  this.Serializable$set("argumentReference", null == parameters.argumentReference ? null : parameters.argumentReference);
  this.Serializable$set("valueReference", null == parameters.valueReference ? null : parameters.valueReference);
};
$jscomp.inherits(module$exports$eeapiclient$ee_api_client.ValueNode, module$exports$eeapiclient$domain_object.Serializable);
module$exports$eeapiclient$ee_api_client.ValueNode.prototype.getConstructor = function() {
  return module$exports$eeapiclient$ee_api_client.ValueNode;
};
module$exports$eeapiclient$ee_api_client.ValueNode.prototype.getPartialClassMetadata = function() {
  return {keys:"argumentReference arrayValue bytesValue constantValue dictionaryValue functionDefinitionValue functionInvocationValue integerValue valueReference".split(" "), objects:{arrayValue:module$exports$eeapiclient$ee_api_client.ArrayValue, dictionaryValue:module$exports$eeapiclient$ee_api_client.DictionaryValue, functionDefinitionValue:module$exports$eeapiclient$ee_api_client.FunctionDefinition, functionInvocationValue:module$exports$eeapiclient$ee_api_client.FunctionInvocation}};
};
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.ValueNode.prototype, {argumentReference:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("argumentReference") ? this.Serializable$get("argumentReference") : null;
}, set:function(value) {
  this.Serializable$set("argumentReference", value);
}}, arrayValue:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("arrayValue") ? this.Serializable$get("arrayValue") : null;
}, set:function(value) {
  this.Serializable$set("arrayValue", value);
}}, bytesValue:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("bytesValue") ? this.Serializable$get("bytesValue") : null;
}, set:function(value) {
  this.Serializable$set("bytesValue", value);
}}, constantValue:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("constantValue") ? this.Serializable$get("constantValue") : null;
}, set:function(value) {
  this.Serializable$set("constantValue", value);
}}, dictionaryValue:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("dictionaryValue") ? this.Serializable$get("dictionaryValue") : null;
}, set:function(value) {
  this.Serializable$set("dictionaryValue", value);
}}, functionDefinitionValue:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("functionDefinitionValue") ? this.Serializable$get("functionDefinitionValue") : null;
}, set:function(value) {
  this.Serializable$set("functionDefinitionValue", value);
}}, functionInvocationValue:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("functionInvocationValue") ? this.Serializable$get("functionInvocationValue") : null;
}, set:function(value) {
  this.Serializable$set("functionInvocationValue", value);
}}, integerValue:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("integerValue") ? this.Serializable$get("integerValue") : null;
}, set:function(value) {
  this.Serializable$set("integerValue", value);
}}, valueReference:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("valueReference") ? this.Serializable$get("valueReference") : null;
}, set:function(value) {
  this.Serializable$set("valueReference", value);
}}});
module$exports$eeapiclient$ee_api_client.VideoFileExportOptionsParameters = function module$contents$eeapiclient$ee_api_client_VideoFileExportOptionsParameters() {
};
module$exports$eeapiclient$ee_api_client.VideoFileExportOptions = function(parameters) {
  parameters = void 0 === parameters ? {} : parameters;
  module$exports$eeapiclient$domain_object.Serializable.call(this);
  this.Serializable$set("fileFormat", null == parameters.fileFormat ? null : parameters.fileFormat);
  this.Serializable$set("driveDestination", null == parameters.driveDestination ? null : parameters.driveDestination);
  this.Serializable$set("gcsDestination", null == parameters.gcsDestination ? null : parameters.gcsDestination);
};
$jscomp.inherits(module$exports$eeapiclient$ee_api_client.VideoFileExportOptions, module$exports$eeapiclient$domain_object.Serializable);
module$exports$eeapiclient$ee_api_client.VideoFileExportOptions.prototype.getConstructor = function() {
  return module$exports$eeapiclient$ee_api_client.VideoFileExportOptions;
};
module$exports$eeapiclient$ee_api_client.VideoFileExportOptions.prototype.getPartialClassMetadata = function() {
  return {enums:{fileFormat:module$exports$eeapiclient$ee_api_client.VideoFileExportOptionsFileFormatEnum}, keys:["driveDestination", "fileFormat", "gcsDestination"], objects:{driveDestination:module$exports$eeapiclient$ee_api_client.DriveDestination, gcsDestination:module$exports$eeapiclient$ee_api_client.GcsDestination}};
};
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.VideoFileExportOptions.prototype, {driveDestination:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("driveDestination") ? this.Serializable$get("driveDestination") : null;
}, set:function(value) {
  this.Serializable$set("driveDestination", value);
}}, fileFormat:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("fileFormat") ? this.Serializable$get("fileFormat") : null;
}, set:function(value) {
  this.Serializable$set("fileFormat", value);
}}, gcsDestination:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("gcsDestination") ? this.Serializable$get("gcsDestination") : null;
}, set:function(value) {
  this.Serializable$set("gcsDestination", value);
}}});
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.VideoFileExportOptions, {FileFormat:{configurable:!0, enumerable:!0, get:function() {
  return module$exports$eeapiclient$ee_api_client.VideoFileExportOptionsFileFormatEnum;
}}});
module$exports$eeapiclient$ee_api_client.VideoOptionsParameters = function module$contents$eeapiclient$ee_api_client_VideoOptionsParameters() {
};
module$exports$eeapiclient$ee_api_client.VideoOptions = function(parameters) {
  parameters = void 0 === parameters ? {} : parameters;
  module$exports$eeapiclient$domain_object.Serializable.call(this);
  this.Serializable$set("framesPerSecond", null == parameters.framesPerSecond ? null : parameters.framesPerSecond);
  this.Serializable$set("maxFrames", null == parameters.maxFrames ? null : parameters.maxFrames);
  this.Serializable$set("maxPixelsPerFrame", null == parameters.maxPixelsPerFrame ? null : parameters.maxPixelsPerFrame);
};
$jscomp.inherits(module$exports$eeapiclient$ee_api_client.VideoOptions, module$exports$eeapiclient$domain_object.Serializable);
module$exports$eeapiclient$ee_api_client.VideoOptions.prototype.getConstructor = function() {
  return module$exports$eeapiclient$ee_api_client.VideoOptions;
};
module$exports$eeapiclient$ee_api_client.VideoOptions.prototype.getPartialClassMetadata = function() {
  return {keys:["framesPerSecond", "maxFrames", "maxPixelsPerFrame"]};
};
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.VideoOptions.prototype, {framesPerSecond:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("framesPerSecond") ? this.Serializable$get("framesPerSecond") : null;
}, set:function(value) {
  this.Serializable$set("framesPerSecond", value);
}}, maxFrames:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("maxFrames") ? this.Serializable$get("maxFrames") : null;
}, set:function(value) {
  this.Serializable$set("maxFrames", value);
}}, maxPixelsPerFrame:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("maxPixelsPerFrame") ? this.Serializable$get("maxPixelsPerFrame") : null;
}, set:function(value) {
  this.Serializable$set("maxPixelsPerFrame", value);
}}});
module$exports$eeapiclient$ee_api_client.VideoThumbnailParameters = function module$contents$eeapiclient$ee_api_client_VideoThumbnailParameters() {
};
module$exports$eeapiclient$ee_api_client.VideoThumbnail = function(parameters) {
  parameters = void 0 === parameters ? {} : parameters;
  module$exports$eeapiclient$domain_object.Serializable.call(this);
  this.Serializable$set("name", null == parameters.name ? null : parameters.name);
  this.Serializable$set("expression", null == parameters.expression ? null : parameters.expression);
  this.Serializable$set("videoOptions", null == parameters.videoOptions ? null : parameters.videoOptions);
  this.Serializable$set("fileFormat", null == parameters.fileFormat ? null : parameters.fileFormat);
  this.Serializable$set("grid", null == parameters.grid ? null : parameters.grid);
};
$jscomp.inherits(module$exports$eeapiclient$ee_api_client.VideoThumbnail, module$exports$eeapiclient$domain_object.Serializable);
module$exports$eeapiclient$ee_api_client.VideoThumbnail.prototype.getConstructor = function() {
  return module$exports$eeapiclient$ee_api_client.VideoThumbnail;
};
module$exports$eeapiclient$ee_api_client.VideoThumbnail.prototype.getPartialClassMetadata = function() {
  return {enums:{fileFormat:module$exports$eeapiclient$ee_api_client.VideoThumbnailFileFormatEnum}, keys:["expression", "fileFormat", "grid", "name", "videoOptions"], objects:{expression:module$exports$eeapiclient$ee_api_client.Expression, grid:module$exports$eeapiclient$ee_api_client.PixelGrid, videoOptions:module$exports$eeapiclient$ee_api_client.VideoOptions}};
};
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.VideoThumbnail.prototype, {expression:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("expression") ? this.Serializable$get("expression") : null;
}, set:function(value) {
  this.Serializable$set("expression", value);
}}, fileFormat:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("fileFormat") ? this.Serializable$get("fileFormat") : null;
}, set:function(value) {
  this.Serializable$set("fileFormat", value);
}}, grid:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("grid") ? this.Serializable$get("grid") : null;
}, set:function(value) {
  this.Serializable$set("grid", value);
}}, name:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("name") ? this.Serializable$get("name") : null;
}, set:function(value) {
  this.Serializable$set("name", value);
}}, videoOptions:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("videoOptions") ? this.Serializable$get("videoOptions") : null;
}, set:function(value) {
  this.Serializable$set("videoOptions", value);
}}});
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.VideoThumbnail, {FileFormat:{configurable:!0, enumerable:!0, get:function() {
  return module$exports$eeapiclient$ee_api_client.VideoThumbnailFileFormatEnum;
}}});
module$exports$eeapiclient$ee_api_client.VisualizationOptionsParameters = function module$contents$eeapiclient$ee_api_client_VisualizationOptionsParameters() {
};
module$exports$eeapiclient$ee_api_client.VisualizationOptions = function(parameters) {
  parameters = void 0 === parameters ? {} : parameters;
  module$exports$eeapiclient$domain_object.Serializable.call(this);
  this.Serializable$set("ranges", null == parameters.ranges ? null : parameters.ranges);
  this.Serializable$set("paletteColors", null == parameters.paletteColors ? null : parameters.paletteColors);
  this.Serializable$set("gamma", null == parameters.gamma ? null : parameters.gamma);
  this.Serializable$set("opacity", null == parameters.opacity ? null : parameters.opacity);
};
$jscomp.inherits(module$exports$eeapiclient$ee_api_client.VisualizationOptions, module$exports$eeapiclient$domain_object.Serializable);
module$exports$eeapiclient$ee_api_client.VisualizationOptions.prototype.getConstructor = function() {
  return module$exports$eeapiclient$ee_api_client.VisualizationOptions;
};
module$exports$eeapiclient$ee_api_client.VisualizationOptions.prototype.getPartialClassMetadata = function() {
  return {arrays:{ranges:module$exports$eeapiclient$ee_api_client.DoubleRange}, keys:["gamma", "opacity", "paletteColors", "ranges"]};
};
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.VisualizationOptions.prototype, {gamma:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("gamma") ? this.Serializable$get("gamma") : null;
}, set:function(value) {
  this.Serializable$set("gamma", value);
}}, opacity:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("opacity") ? this.Serializable$get("opacity") : null;
}, set:function(value) {
  this.Serializable$set("opacity", value);
}}, paletteColors:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("paletteColors") ? this.Serializable$get("paletteColors") : null;
}, set:function(value) {
  this.Serializable$set("paletteColors", value);
}}, ranges:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("ranges") ? this.Serializable$get("ranges") : null;
}, set:function(value) {
  this.Serializable$set("ranges", value);
}}});
module$exports$eeapiclient$ee_api_client.WaitOperationRequestParameters = function module$contents$eeapiclient$ee_api_client_WaitOperationRequestParameters() {
};
module$exports$eeapiclient$ee_api_client.WaitOperationRequest = function(parameters) {
  parameters = void 0 === parameters ? {} : parameters;
  module$exports$eeapiclient$domain_object.Serializable.call(this);
  this.Serializable$set("timeout", null == parameters.timeout ? null : parameters.timeout);
};
$jscomp.inherits(module$exports$eeapiclient$ee_api_client.WaitOperationRequest, module$exports$eeapiclient$domain_object.Serializable);
module$exports$eeapiclient$ee_api_client.WaitOperationRequest.prototype.getConstructor = function() {
  return module$exports$eeapiclient$ee_api_client.WaitOperationRequest;
};
module$exports$eeapiclient$ee_api_client.WaitOperationRequest.prototype.getPartialClassMetadata = function() {
  return {keys:["timeout"]};
};
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.WaitOperationRequest.prototype, {timeout:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("timeout") ? this.Serializable$get("timeout") : null;
}, set:function(value) {
  this.Serializable$set("timeout", value);
}}});
module$exports$eeapiclient$ee_api_client.ZoomSubsetParameters = function module$contents$eeapiclient$ee_api_client_ZoomSubsetParameters() {
};
module$exports$eeapiclient$ee_api_client.ZoomSubset = function(parameters) {
  parameters = void 0 === parameters ? {} : parameters;
  module$exports$eeapiclient$domain_object.Serializable.call(this);
  this.Serializable$set("min", null == parameters.min ? null : parameters.min);
  this.Serializable$set("max", null == parameters.max ? null : parameters.max);
};
$jscomp.inherits(module$exports$eeapiclient$ee_api_client.ZoomSubset, module$exports$eeapiclient$domain_object.Serializable);
module$exports$eeapiclient$ee_api_client.ZoomSubset.prototype.getConstructor = function() {
  return module$exports$eeapiclient$ee_api_client.ZoomSubset;
};
module$exports$eeapiclient$ee_api_client.ZoomSubset.prototype.getPartialClassMetadata = function() {
  return {keys:["max", "min"]};
};
$jscomp.global.Object.defineProperties(module$exports$eeapiclient$ee_api_client.ZoomSubset.prototype, {max:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("max") ? this.Serializable$get("max") : null;
}, set:function(value) {
  this.Serializable$set("max", value);
}}, min:{configurable:!0, enumerable:!0, get:function() {
  return this.Serializable$has("min") ? this.Serializable$get("min") : null;
}, set:function(value) {
  this.Serializable$set("min", value);
}}});
var module$contents$eeapiclient$ee_api_client_PARAM_MAP_0 = {$Xgafv:"$.xgafv", access_token:"access_token", alt:"alt", assetId:"assetId", callback:"callback", endTime:"endTime", fields:"fields", filter:"filter", key:"key", oauth_token:"oauth_token", overwrite:"overwrite", pageSize:"pageSize", pageToken:"pageToken", prettyPrint:"prettyPrint", quotaUser:"quotaUser", region:"region", startTime:"startTime", uploadType:"uploadType", upload_protocol:"upload_protocol", view:"view"};
module$exports$eeapiclient$ee_api_client.IProjectsAlgorithmsApiClient$XgafvEnum = function module$contents$eeapiclient$ee_api_client_IProjectsAlgorithmsApiClient$XgafvEnum() {
};
module$exports$eeapiclient$ee_api_client.ProjectsAlgorithmsApiClient$XgafvEnum = {1:"1", 2:"2", values:function() {
  return [module$exports$eeapiclient$ee_api_client.ProjectsAlgorithmsApiClient$XgafvEnum[1], module$exports$eeapiclient$ee_api_client.ProjectsAlgorithmsApiClient$XgafvEnum[2]];
}};
module$exports$eeapiclient$ee_api_client.IProjectsAlgorithmsApiClientAltEnum = function module$contents$eeapiclient$ee_api_client_IProjectsAlgorithmsApiClientAltEnum() {
};
module$exports$eeapiclient$ee_api_client.ProjectsAlgorithmsApiClientAltEnum = {JSON:"json", MEDIA:"media", PROTO:"proto", values:function() {
  return [module$exports$eeapiclient$ee_api_client.ProjectsAlgorithmsApiClientAltEnum.JSON, module$exports$eeapiclient$ee_api_client.ProjectsAlgorithmsApiClientAltEnum.MEDIA, module$exports$eeapiclient$ee_api_client.ProjectsAlgorithmsApiClientAltEnum.PROTO];
}};
module$exports$eeapiclient$ee_api_client.ProjectsAlgorithmsApiClientImpl = function(gapiVersion, gapiRequestService, apiClientHookFactory) {
  this.gapiVersion = gapiVersion;
  this.$apiClient = new module$exports$eeapiclient$promise_api_client.PromiseApiClient(gapiRequestService, void 0 === apiClientHookFactory ? null : apiClientHookFactory);
};
module$exports$eeapiclient$ee_api_client.ProjectsAlgorithmsApiClientImpl.prototype.list = function(project, namedParameters) {
  namedParameters = void 0 === namedParameters ? {} : namedParameters;
  this.$apiClient.$validateParameter(project, /^projects\/[^/]+$/);
  return this.$apiClient.$request({body:null, httpMethod:"GET", methodId:"earthengine.projects.algorithms.list", path:"/" + this.gapiVersion + "/" + project + "/algorithms", queryParams:module$contents$eeapiclient$request_params_buildQueryParams(namedParameters, module$contents$eeapiclient$ee_api_client_PARAM_MAP_0), responseCtor:module$exports$eeapiclient$ee_api_client.ListAlgorithmsResponse});
};
module$exports$eeapiclient$ee_api_client.ProjectsAlgorithmsApiClient = function() {
};
module$exports$eeapiclient$ee_api_client.IProjectsApiClient$XgafvEnum = function module$contents$eeapiclient$ee_api_client_IProjectsApiClient$XgafvEnum() {
};
module$exports$eeapiclient$ee_api_client.ProjectsApiClient$XgafvEnum = {1:"1", 2:"2", values:function() {
  return [module$exports$eeapiclient$ee_api_client.ProjectsApiClient$XgafvEnum[1], module$exports$eeapiclient$ee_api_client.ProjectsApiClient$XgafvEnum[2]];
}};
module$exports$eeapiclient$ee_api_client.IProjectsApiClientAltEnum = function module$contents$eeapiclient$ee_api_client_IProjectsApiClientAltEnum() {
};
module$exports$eeapiclient$ee_api_client.ProjectsApiClientAltEnum = {JSON:"json", MEDIA:"media", PROTO:"proto", values:function() {
  return [module$exports$eeapiclient$ee_api_client.ProjectsApiClientAltEnum.JSON, module$exports$eeapiclient$ee_api_client.ProjectsApiClientAltEnum.MEDIA, module$exports$eeapiclient$ee_api_client.ProjectsApiClientAltEnum.PROTO];
}};
module$exports$eeapiclient$ee_api_client.ProjectsApiClientImpl = function(gapiVersion, gapiRequestService, apiClientHookFactory) {
  this.gapiVersion = gapiVersion;
  this.$apiClient = new module$exports$eeapiclient$promise_api_client.PromiseApiClient(gapiRequestService, void 0 === apiClientHookFactory ? null : apiClientHookFactory);
};
module$exports$eeapiclient$ee_api_client.ProjectsApiClientImpl.prototype.getCapabilities = function(parent, namedParameters) {
  namedParameters = void 0 === namedParameters ? {} : namedParameters;
  this.$apiClient.$validateParameter(parent, /^projects\/[^/]+$/);
  return this.$apiClient.$request({body:null, httpMethod:"GET", methodId:"earthengine.projects.getCapabilities", path:"/" + this.gapiVersion + "/" + parent + "/capabilities", queryParams:module$contents$eeapiclient$request_params_buildQueryParams(namedParameters, module$contents$eeapiclient$ee_api_client_PARAM_MAP_0), responseCtor:module$exports$eeapiclient$ee_api_client.Capabilities});
};
module$exports$eeapiclient$ee_api_client.ProjectsApiClientImpl.prototype.listAssets = function(parent, namedParameters) {
  namedParameters = void 0 === namedParameters ? {} : namedParameters;
  this.$apiClient.$validateParameter(parent, /^projects\/[^/]+$/);
  return this.$apiClient.$request({body:null, httpMethod:"GET", methodId:"earthengine.projects.listAssets", path:"/" + this.gapiVersion + "/" + parent + ":listAssets", queryParams:module$contents$eeapiclient$request_params_buildQueryParams(namedParameters, module$contents$eeapiclient$ee_api_client_PARAM_MAP_0), responseCtor:module$exports$eeapiclient$ee_api_client.ListAssetsResponse});
};
module$exports$eeapiclient$ee_api_client.ProjectsApiClient = function() {
};
module$exports$eeapiclient$ee_api_client.IProjectsAssetsApiClient$XgafvEnum = function module$contents$eeapiclient$ee_api_client_IProjectsAssetsApiClient$XgafvEnum() {
};
module$exports$eeapiclient$ee_api_client.ProjectsAssetsApiClient$XgafvEnum = {1:"1", 2:"2", values:function() {
  return [module$exports$eeapiclient$ee_api_client.ProjectsAssetsApiClient$XgafvEnum[1], module$exports$eeapiclient$ee_api_client.ProjectsAssetsApiClient$XgafvEnum[2]];
}};
module$exports$eeapiclient$ee_api_client.IProjectsAssetsApiClientAltEnum = function module$contents$eeapiclient$ee_api_client_IProjectsAssetsApiClientAltEnum() {
};
module$exports$eeapiclient$ee_api_client.ProjectsAssetsApiClientAltEnum = {JSON:"json", MEDIA:"media", PROTO:"proto", values:function() {
  return [module$exports$eeapiclient$ee_api_client.ProjectsAssetsApiClientAltEnum.JSON, module$exports$eeapiclient$ee_api_client.ProjectsAssetsApiClientAltEnum.MEDIA, module$exports$eeapiclient$ee_api_client.ProjectsAssetsApiClientAltEnum.PROTO];
}};
module$exports$eeapiclient$ee_api_client.IProjectsAssetsApiClientViewEnum = function module$contents$eeapiclient$ee_api_client_IProjectsAssetsApiClientViewEnum() {
};
module$exports$eeapiclient$ee_api_client.ProjectsAssetsApiClientViewEnum = {BASIC:"BASIC", FULL:"FULL", IMAGE_VIEW_UNSPECIFIED:"IMAGE_VIEW_UNSPECIFIED", values:function() {
  return [module$exports$eeapiclient$ee_api_client.ProjectsAssetsApiClientViewEnum.IMAGE_VIEW_UNSPECIFIED, module$exports$eeapiclient$ee_api_client.ProjectsAssetsApiClientViewEnum.FULL, module$exports$eeapiclient$ee_api_client.ProjectsAssetsApiClientViewEnum.BASIC];
}};
module$exports$eeapiclient$ee_api_client.ProjectsAssetsApiClientImpl = function(gapiVersion, gapiRequestService, apiClientHookFactory) {
  this.gapiVersion = gapiVersion;
  this.$apiClient = new module$exports$eeapiclient$promise_api_client.PromiseApiClient(gapiRequestService, void 0 === apiClientHookFactory ? null : apiClientHookFactory);
};
module$exports$eeapiclient$ee_api_client.ProjectsAssetsApiClientImpl.prototype.copy = function(sourceName, $requestBody, namedParameters) {
  namedParameters = void 0 === namedParameters ? {} : namedParameters;
  this.$apiClient.$validateParameter(sourceName, /^projects\/[^/]+\/assets\/.*$/);
  return this.$apiClient.$request({body:$requestBody, httpMethod:"POST", methodId:"earthengine.projects.assets.copy", path:"/" + this.gapiVersion + "/" + sourceName + ":copy", queryParams:module$contents$eeapiclient$request_params_buildQueryParams(namedParameters, module$contents$eeapiclient$ee_api_client_PARAM_MAP_0), responseCtor:module$exports$eeapiclient$ee_api_client.EarthEngineAsset});
};
module$exports$eeapiclient$ee_api_client.ProjectsAssetsApiClientImpl.prototype.create = function(parent, $requestBody, namedParameters) {
  namedParameters = void 0 === namedParameters ? {} : namedParameters;
  this.$apiClient.$validateParameter(parent, /^projects\/[^/]+$/);
  return this.$apiClient.$request({body:$requestBody, httpMethod:"POST", methodId:"earthengine.projects.assets.create", path:"/" + this.gapiVersion + "/" + parent + "/assets", queryParams:module$contents$eeapiclient$request_params_buildQueryParams(namedParameters, module$contents$eeapiclient$ee_api_client_PARAM_MAP_0), responseCtor:module$exports$eeapiclient$ee_api_client.EarthEngineAsset});
};
module$exports$eeapiclient$ee_api_client.ProjectsAssetsApiClientImpl.prototype.delete = function(name, namedParameters) {
  namedParameters = void 0 === namedParameters ? {} : namedParameters;
  this.$apiClient.$validateParameter(name, /^projects\/[^/]+\/assets\/.*$/);
  return this.$apiClient.$request({body:null, httpMethod:"DELETE", methodId:"earthengine.projects.assets.delete", path:"/" + this.gapiVersion + "/" + name, queryParams:module$contents$eeapiclient$request_params_buildQueryParams(namedParameters, module$contents$eeapiclient$ee_api_client_PARAM_MAP_0), responseCtor:module$exports$eeapiclient$ee_api_client.Empty});
};
module$exports$eeapiclient$ee_api_client.ProjectsAssetsApiClientImpl.prototype.get = function(name, namedParameters) {
  namedParameters = void 0 === namedParameters ? {} : namedParameters;
  this.$apiClient.$validateParameter(name, /^projects\/[^/]+\/assets\/.*$/);
  return this.$apiClient.$request({body:null, httpMethod:"GET", methodId:"earthengine.projects.assets.get", path:"/" + this.gapiVersion + "/" + name, queryParams:module$contents$eeapiclient$request_params_buildQueryParams(namedParameters, module$contents$eeapiclient$ee_api_client_PARAM_MAP_0), responseCtor:module$exports$eeapiclient$ee_api_client.EarthEngineAsset});
};
module$exports$eeapiclient$ee_api_client.ProjectsAssetsApiClientImpl.prototype.getIamPolicy = function(resource, $requestBody, namedParameters) {
  namedParameters = void 0 === namedParameters ? {} : namedParameters;
  this.$apiClient.$validateParameter(resource, /^projects\/[^/]+\/assets\/.*$/);
  return this.$apiClient.$request({body:$requestBody, httpMethod:"POST", methodId:"earthengine.projects.assets.getIamPolicy", path:"/" + this.gapiVersion + "/" + resource + ":getIamPolicy", queryParams:module$contents$eeapiclient$request_params_buildQueryParams(namedParameters, module$contents$eeapiclient$ee_api_client_PARAM_MAP_0), responseCtor:module$exports$eeapiclient$ee_api_client.Policy});
};
module$exports$eeapiclient$ee_api_client.ProjectsAssetsApiClientImpl.prototype.getPixels = function(name, $requestBody, namedParameters) {
  namedParameters = void 0 === namedParameters ? {} : namedParameters;
  this.$apiClient.$validateParameter(name, /^projects\/[^/]+\/assets\/.*$/);
  return this.$apiClient.$request({body:$requestBody, httpMethod:"POST", methodId:"earthengine.projects.assets.getPixels", path:"/" + this.gapiVersion + "/" + name + ":getPixels", queryParams:module$contents$eeapiclient$request_params_buildQueryParams(namedParameters, module$contents$eeapiclient$ee_api_client_PARAM_MAP_0), responseCtor:module$exports$eeapiclient$ee_api_client.HttpBody});
};
module$exports$eeapiclient$ee_api_client.ProjectsAssetsApiClientImpl.prototype.link = function(sourceName, $requestBody, namedParameters) {
  namedParameters = void 0 === namedParameters ? {} : namedParameters;
  this.$apiClient.$validateParameter(sourceName, /^projects\/[^/]+\/assets\/.*$/);
  return this.$apiClient.$request({body:$requestBody, httpMethod:"POST", methodId:"earthengine.projects.assets.link", path:"/" + this.gapiVersion + "/" + sourceName + ":link", queryParams:module$contents$eeapiclient$request_params_buildQueryParams(namedParameters, module$contents$eeapiclient$ee_api_client_PARAM_MAP_0), responseCtor:module$exports$eeapiclient$ee_api_client.EarthEngineAsset});
};
module$exports$eeapiclient$ee_api_client.ProjectsAssetsApiClientImpl.prototype.listAssets = function(parent, namedParameters) {
  namedParameters = void 0 === namedParameters ? {} : namedParameters;
  this.$apiClient.$validateParameter(parent, /^projects\/[^/]+\/assets\/.*$/);
  return this.$apiClient.$request({body:null, httpMethod:"GET", methodId:"earthengine.projects.assets.listAssets", path:"/" + this.gapiVersion + "/" + parent + ":listAssets", queryParams:module$contents$eeapiclient$request_params_buildQueryParams(namedParameters, module$contents$eeapiclient$ee_api_client_PARAM_MAP_0), responseCtor:module$exports$eeapiclient$ee_api_client.ListAssetsResponse});
};
module$exports$eeapiclient$ee_api_client.ProjectsAssetsApiClientImpl.prototype.listFeatures = function(parent, namedParameters) {
  namedParameters = void 0 === namedParameters ? {} : namedParameters;
  this.$apiClient.$validateParameter(parent, /^projects\/[^/]+\/assets\/.*$/);
  return this.$apiClient.$request({body:null, httpMethod:"GET", methodId:"earthengine.projects.assets.listFeatures", path:"/" + this.gapiVersion + "/" + parent + ":listFeatures", queryParams:module$contents$eeapiclient$request_params_buildQueryParams(namedParameters, module$contents$eeapiclient$ee_api_client_PARAM_MAP_0), responseCtor:module$exports$eeapiclient$ee_api_client.ListFeaturesResponse});
};
module$exports$eeapiclient$ee_api_client.ProjectsAssetsApiClientImpl.prototype.listImages = function(parent, namedParameters) {
  namedParameters = void 0 === namedParameters ? {} : namedParameters;
  this.$apiClient.$validateParameter(parent, /^projects\/[^/]+\/assets\/.*$/);
  return this.$apiClient.$request({body:null, httpMethod:"GET", methodId:"earthengine.projects.assets.listImages", path:"/" + this.gapiVersion + "/" + parent + ":listImages", queryParams:module$contents$eeapiclient$request_params_buildQueryParams(namedParameters, module$contents$eeapiclient$ee_api_client_PARAM_MAP_0), responseCtor:module$exports$eeapiclient$ee_api_client.ListImagesResponse});
};
module$exports$eeapiclient$ee_api_client.ProjectsAssetsApiClientImpl.prototype.move = function(sourceName, $requestBody, namedParameters) {
  namedParameters = void 0 === namedParameters ? {} : namedParameters;
  this.$apiClient.$validateParameter(sourceName, /^projects\/[^/]+\/assets\/.*$/);
  return this.$apiClient.$request({body:$requestBody, httpMethod:"POST", methodId:"earthengine.projects.assets.move", path:"/" + this.gapiVersion + "/" + sourceName + ":move", queryParams:module$contents$eeapiclient$request_params_buildQueryParams(namedParameters, module$contents$eeapiclient$ee_api_client_PARAM_MAP_0), responseCtor:module$exports$eeapiclient$ee_api_client.EarthEngineAsset});
};
module$exports$eeapiclient$ee_api_client.ProjectsAssetsApiClientImpl.prototype.patch = function(name, $requestBody, namedParameters) {
  namedParameters = void 0 === namedParameters ? {} : namedParameters;
  this.$apiClient.$validateParameter(name, /^projects\/[^/]+\/assets\/.*$/);
  return this.$apiClient.$request({body:$requestBody, httpMethod:"PATCH", methodId:"earthengine.projects.assets.patch", path:"/" + this.gapiVersion + "/" + name, queryParams:module$contents$eeapiclient$request_params_buildQueryParams(namedParameters, module$contents$eeapiclient$ee_api_client_PARAM_MAP_0), responseCtor:module$exports$eeapiclient$ee_api_client.EarthEngineAsset});
};
module$exports$eeapiclient$ee_api_client.ProjectsAssetsApiClientImpl.prototype.setIamPolicy = function(resource, $requestBody, namedParameters) {
  namedParameters = void 0 === namedParameters ? {} : namedParameters;
  this.$apiClient.$validateParameter(resource, /^projects\/[^/]+\/assets\/.*$/);
  return this.$apiClient.$request({body:$requestBody, httpMethod:"POST", methodId:"earthengine.projects.assets.setIamPolicy", path:"/" + this.gapiVersion + "/" + resource + ":setIamPolicy", queryParams:module$contents$eeapiclient$request_params_buildQueryParams(namedParameters, module$contents$eeapiclient$ee_api_client_PARAM_MAP_0), responseCtor:module$exports$eeapiclient$ee_api_client.Policy});
};
module$exports$eeapiclient$ee_api_client.ProjectsAssetsApiClientImpl.prototype.testIamPermissions = function(resource, $requestBody, namedParameters) {
  namedParameters = void 0 === namedParameters ? {} : namedParameters;
  this.$apiClient.$validateParameter(resource, /^projects\/[^/]+\/assets\/.*$/);
  return this.$apiClient.$request({body:$requestBody, httpMethod:"POST", methodId:"earthengine.projects.assets.testIamPermissions", path:"/" + this.gapiVersion + "/" + resource + ":testIamPermissions", queryParams:module$contents$eeapiclient$request_params_buildQueryParams(namedParameters, module$contents$eeapiclient$ee_api_client_PARAM_MAP_0), responseCtor:module$exports$eeapiclient$ee_api_client.TestIamPermissionsResponse});
};
module$exports$eeapiclient$ee_api_client.ProjectsAssetsApiClient = function() {
};
module$exports$eeapiclient$ee_api_client.IProjectsFilmstripThumbnailsApiClient$XgafvEnum = function module$contents$eeapiclient$ee_api_client_IProjectsFilmstripThumbnailsApiClient$XgafvEnum() {
};
module$exports$eeapiclient$ee_api_client.ProjectsFilmstripThumbnailsApiClient$XgafvEnum = {1:"1", 2:"2", values:function() {
  return [module$exports$eeapiclient$ee_api_client.ProjectsFilmstripThumbnailsApiClient$XgafvEnum[1], module$exports$eeapiclient$ee_api_client.ProjectsFilmstripThumbnailsApiClient$XgafvEnum[2]];
}};
module$exports$eeapiclient$ee_api_client.IProjectsFilmstripThumbnailsApiClientAltEnum = function module$contents$eeapiclient$ee_api_client_IProjectsFilmstripThumbnailsApiClientAltEnum() {
};
module$exports$eeapiclient$ee_api_client.ProjectsFilmstripThumbnailsApiClientAltEnum = {JSON:"json", MEDIA:"media", PROTO:"proto", values:function() {
  return [module$exports$eeapiclient$ee_api_client.ProjectsFilmstripThumbnailsApiClientAltEnum.JSON, module$exports$eeapiclient$ee_api_client.ProjectsFilmstripThumbnailsApiClientAltEnum.MEDIA, module$exports$eeapiclient$ee_api_client.ProjectsFilmstripThumbnailsApiClientAltEnum.PROTO];
}};
module$exports$eeapiclient$ee_api_client.ProjectsFilmstripThumbnailsApiClientImpl = function(gapiVersion, gapiRequestService, apiClientHookFactory) {
  this.gapiVersion = gapiVersion;
  this.$apiClient = new module$exports$eeapiclient$promise_api_client.PromiseApiClient(gapiRequestService, void 0 === apiClientHookFactory ? null : apiClientHookFactory);
};
module$exports$eeapiclient$ee_api_client.ProjectsFilmstripThumbnailsApiClientImpl.prototype.create = function(parent, $requestBody, namedParameters) {
  namedParameters = void 0 === namedParameters ? {} : namedParameters;
  this.$apiClient.$validateParameter(parent, /^projects\/[^/]+$/);
  return this.$apiClient.$request({body:$requestBody, httpMethod:"POST", methodId:"earthengine.projects.filmstripThumbnails.create", path:"/" + this.gapiVersion + "/" + parent + "/filmstripThumbnails", queryParams:module$contents$eeapiclient$request_params_buildQueryParams(namedParameters, module$contents$eeapiclient$ee_api_client_PARAM_MAP_0), responseCtor:module$exports$eeapiclient$ee_api_client.FilmstripThumbnail});
};
module$exports$eeapiclient$ee_api_client.ProjectsFilmstripThumbnailsApiClientImpl.prototype.getPixels = function(name, namedParameters) {
  namedParameters = void 0 === namedParameters ? {} : namedParameters;
  this.$apiClient.$validateParameter(name, /^projects\/[^/]+\/filmstripThumbnails\/[^/]+$/);
  return this.$apiClient.$request({body:null, httpMethod:"GET", methodId:"earthengine.projects.filmstripThumbnails.getPixels", path:"/" + this.gapiVersion + "/" + name + ":getPixels", queryParams:module$contents$eeapiclient$request_params_buildQueryParams(namedParameters, module$contents$eeapiclient$ee_api_client_PARAM_MAP_0), responseCtor:module$exports$eeapiclient$ee_api_client.HttpBody});
};
module$exports$eeapiclient$ee_api_client.ProjectsFilmstripThumbnailsApiClient = function() {
};
module$exports$eeapiclient$ee_api_client.IProjectsImageApiClient$XgafvEnum = function module$contents$eeapiclient$ee_api_client_IProjectsImageApiClient$XgafvEnum() {
};
module$exports$eeapiclient$ee_api_client.ProjectsImageApiClient$XgafvEnum = {1:"1", 2:"2", values:function() {
  return [module$exports$eeapiclient$ee_api_client.ProjectsImageApiClient$XgafvEnum[1], module$exports$eeapiclient$ee_api_client.ProjectsImageApiClient$XgafvEnum[2]];
}};
module$exports$eeapiclient$ee_api_client.IProjectsImageApiClientAltEnum = function module$contents$eeapiclient$ee_api_client_IProjectsImageApiClientAltEnum() {
};
module$exports$eeapiclient$ee_api_client.ProjectsImageApiClientAltEnum = {JSON:"json", MEDIA:"media", PROTO:"proto", values:function() {
  return [module$exports$eeapiclient$ee_api_client.ProjectsImageApiClientAltEnum.JSON, module$exports$eeapiclient$ee_api_client.ProjectsImageApiClientAltEnum.MEDIA, module$exports$eeapiclient$ee_api_client.ProjectsImageApiClientAltEnum.PROTO];
}};
module$exports$eeapiclient$ee_api_client.ProjectsImageApiClientImpl = function(gapiVersion, gapiRequestService, apiClientHookFactory) {
  this.gapiVersion = gapiVersion;
  this.$apiClient = new module$exports$eeapiclient$promise_api_client.PromiseApiClient(gapiRequestService, void 0 === apiClientHookFactory ? null : apiClientHookFactory);
};
module$exports$eeapiclient$ee_api_client.ProjectsImageApiClientImpl.prototype.computePixels = function(project, $requestBody, namedParameters) {
  namedParameters = void 0 === namedParameters ? {} : namedParameters;
  this.$apiClient.$validateParameter(project, /^projects\/[^/]+$/);
  return this.$apiClient.$request({body:$requestBody, httpMethod:"POST", methodId:"earthengine.projects.image.computePixels", path:"/" + this.gapiVersion + "/" + project + "/image:computePixels", queryParams:module$contents$eeapiclient$request_params_buildQueryParams(namedParameters, module$contents$eeapiclient$ee_api_client_PARAM_MAP_0), responseCtor:module$exports$eeapiclient$ee_api_client.HttpBody});
};
module$exports$eeapiclient$ee_api_client.ProjectsImageApiClientImpl.prototype.export = function(project, $requestBody, namedParameters) {
  namedParameters = void 0 === namedParameters ? {} : namedParameters;
  this.$apiClient.$validateParameter(project, /^projects\/[^/]+$/);
  return this.$apiClient.$request({body:$requestBody, httpMethod:"POST", methodId:"earthengine.projects.image.export", path:"/" + this.gapiVersion + "/" + project + "/image:export", queryParams:module$contents$eeapiclient$request_params_buildQueryParams(namedParameters, module$contents$eeapiclient$ee_api_client_PARAM_MAP_0), responseCtor:module$exports$eeapiclient$ee_api_client.Operation});
};
module$exports$eeapiclient$ee_api_client.ProjectsImageApiClientImpl.prototype.import = function(project, $requestBody, namedParameters) {
  namedParameters = void 0 === namedParameters ? {} : namedParameters;
  this.$apiClient.$validateParameter(project, /^projects\/[^/]+$/);
  return this.$apiClient.$request({body:$requestBody, httpMethod:"POST", methodId:"earthengine.projects.image.import", path:"/" + this.gapiVersion + "/" + project + "/image:import", queryParams:module$contents$eeapiclient$request_params_buildQueryParams(namedParameters, module$contents$eeapiclient$ee_api_client_PARAM_MAP_0), responseCtor:module$exports$eeapiclient$ee_api_client.Operation});
};
module$exports$eeapiclient$ee_api_client.ProjectsImageApiClient = function() {
};
module$exports$eeapiclient$ee_api_client.IProjectsImageCollectionApiClient$XgafvEnum = function module$contents$eeapiclient$ee_api_client_IProjectsImageCollectionApiClient$XgafvEnum() {
};
module$exports$eeapiclient$ee_api_client.ProjectsImageCollectionApiClient$XgafvEnum = {1:"1", 2:"2", values:function() {
  return [module$exports$eeapiclient$ee_api_client.ProjectsImageCollectionApiClient$XgafvEnum[1], module$exports$eeapiclient$ee_api_client.ProjectsImageCollectionApiClient$XgafvEnum[2]];
}};
module$exports$eeapiclient$ee_api_client.IProjectsImageCollectionApiClientAltEnum = function module$contents$eeapiclient$ee_api_client_IProjectsImageCollectionApiClientAltEnum() {
};
module$exports$eeapiclient$ee_api_client.ProjectsImageCollectionApiClientAltEnum = {JSON:"json", MEDIA:"media", PROTO:"proto", values:function() {
  return [module$exports$eeapiclient$ee_api_client.ProjectsImageCollectionApiClientAltEnum.JSON, module$exports$eeapiclient$ee_api_client.ProjectsImageCollectionApiClientAltEnum.MEDIA, module$exports$eeapiclient$ee_api_client.ProjectsImageCollectionApiClientAltEnum.PROTO];
}};
module$exports$eeapiclient$ee_api_client.ProjectsImageCollectionApiClientImpl = function(gapiVersion, gapiRequestService, apiClientHookFactory) {
  this.gapiVersion = gapiVersion;
  this.$apiClient = new module$exports$eeapiclient$promise_api_client.PromiseApiClient(gapiRequestService, void 0 === apiClientHookFactory ? null : apiClientHookFactory);
};
module$exports$eeapiclient$ee_api_client.ProjectsImageCollectionApiClientImpl.prototype.computeImages = function(project, $requestBody, namedParameters) {
  namedParameters = void 0 === namedParameters ? {} : namedParameters;
  this.$apiClient.$validateParameter(project, /^projects\/[^/]+$/);
  return this.$apiClient.$request({body:$requestBody, httpMethod:"POST", methodId:"earthengine.projects.imageCollection.computeImages", path:"/" + this.gapiVersion + "/" + project + "/imageCollection:computeImages", queryParams:module$contents$eeapiclient$request_params_buildQueryParams(namedParameters, module$contents$eeapiclient$ee_api_client_PARAM_MAP_0), responseCtor:module$exports$eeapiclient$ee_api_client.ComputeImagesResponse});
};
module$exports$eeapiclient$ee_api_client.ProjectsImageCollectionApiClient = function() {
};
module$exports$eeapiclient$ee_api_client.IProjectsMapApiClient$XgafvEnum = function module$contents$eeapiclient$ee_api_client_IProjectsMapApiClient$XgafvEnum() {
};
module$exports$eeapiclient$ee_api_client.ProjectsMapApiClient$XgafvEnum = {1:"1", 2:"2", values:function() {
  return [module$exports$eeapiclient$ee_api_client.ProjectsMapApiClient$XgafvEnum[1], module$exports$eeapiclient$ee_api_client.ProjectsMapApiClient$XgafvEnum[2]];
}};
module$exports$eeapiclient$ee_api_client.IProjectsMapApiClientAltEnum = function module$contents$eeapiclient$ee_api_client_IProjectsMapApiClientAltEnum() {
};
module$exports$eeapiclient$ee_api_client.ProjectsMapApiClientAltEnum = {JSON:"json", MEDIA:"media", PROTO:"proto", values:function() {
  return [module$exports$eeapiclient$ee_api_client.ProjectsMapApiClientAltEnum.JSON, module$exports$eeapiclient$ee_api_client.ProjectsMapApiClientAltEnum.MEDIA, module$exports$eeapiclient$ee_api_client.ProjectsMapApiClientAltEnum.PROTO];
}};
module$exports$eeapiclient$ee_api_client.ProjectsMapApiClientImpl = function(gapiVersion, gapiRequestService, apiClientHookFactory) {
  this.gapiVersion = gapiVersion;
  this.$apiClient = new module$exports$eeapiclient$promise_api_client.PromiseApiClient(gapiRequestService, void 0 === apiClientHookFactory ? null : apiClientHookFactory);
};
module$exports$eeapiclient$ee_api_client.ProjectsMapApiClientImpl.prototype.export = function(project, $requestBody, namedParameters) {
  namedParameters = void 0 === namedParameters ? {} : namedParameters;
  this.$apiClient.$validateParameter(project, /^projects\/[^/]+$/);
  return this.$apiClient.$request({body:$requestBody, httpMethod:"POST", methodId:"earthengine.projects.map.export", path:"/" + this.gapiVersion + "/" + project + "/map:export", queryParams:module$contents$eeapiclient$request_params_buildQueryParams(namedParameters, module$contents$eeapiclient$ee_api_client_PARAM_MAP_0), responseCtor:module$exports$eeapiclient$ee_api_client.Operation});
};
module$exports$eeapiclient$ee_api_client.ProjectsMapApiClient = function() {
};
module$exports$eeapiclient$ee_api_client.IProjectsMapsApiClient$XgafvEnum = function module$contents$eeapiclient$ee_api_client_IProjectsMapsApiClient$XgafvEnum() {
};
module$exports$eeapiclient$ee_api_client.ProjectsMapsApiClient$XgafvEnum = {1:"1", 2:"2", values:function() {
  return [module$exports$eeapiclient$ee_api_client.ProjectsMapsApiClient$XgafvEnum[1], module$exports$eeapiclient$ee_api_client.ProjectsMapsApiClient$XgafvEnum[2]];
}};
module$exports$eeapiclient$ee_api_client.IProjectsMapsApiClientAltEnum = function module$contents$eeapiclient$ee_api_client_IProjectsMapsApiClientAltEnum() {
};
module$exports$eeapiclient$ee_api_client.ProjectsMapsApiClientAltEnum = {JSON:"json", MEDIA:"media", PROTO:"proto", values:function() {
  return [module$exports$eeapiclient$ee_api_client.ProjectsMapsApiClientAltEnum.JSON, module$exports$eeapiclient$ee_api_client.ProjectsMapsApiClientAltEnum.MEDIA, module$exports$eeapiclient$ee_api_client.ProjectsMapsApiClientAltEnum.PROTO];
}};
module$exports$eeapiclient$ee_api_client.ProjectsMapsApiClientImpl = function(gapiVersion, gapiRequestService, apiClientHookFactory) {
  this.gapiVersion = gapiVersion;
  this.$apiClient = new module$exports$eeapiclient$promise_api_client.PromiseApiClient(gapiRequestService, void 0 === apiClientHookFactory ? null : apiClientHookFactory);
};
module$exports$eeapiclient$ee_api_client.ProjectsMapsApiClientImpl.prototype.create = function(parent, $requestBody, namedParameters) {
  namedParameters = void 0 === namedParameters ? {} : namedParameters;
  this.$apiClient.$validateParameter(parent, /^projects\/[^/]+$/);
  return this.$apiClient.$request({body:$requestBody, httpMethod:"POST", methodId:"earthengine.projects.maps.create", path:"/" + this.gapiVersion + "/" + parent + "/maps", queryParams:module$contents$eeapiclient$request_params_buildQueryParams(namedParameters, module$contents$eeapiclient$ee_api_client_PARAM_MAP_0), responseCtor:module$exports$eeapiclient$ee_api_client.EarthEngineMap});
};
module$exports$eeapiclient$ee_api_client.ProjectsMapsApiClient = function() {
};
module$exports$eeapiclient$ee_api_client.IProjectsMapsTilesApiClient$XgafvEnum = function module$contents$eeapiclient$ee_api_client_IProjectsMapsTilesApiClient$XgafvEnum() {
};
module$exports$eeapiclient$ee_api_client.ProjectsMapsTilesApiClient$XgafvEnum = {1:"1", 2:"2", values:function() {
  return [module$exports$eeapiclient$ee_api_client.ProjectsMapsTilesApiClient$XgafvEnum[1], module$exports$eeapiclient$ee_api_client.ProjectsMapsTilesApiClient$XgafvEnum[2]];
}};
module$exports$eeapiclient$ee_api_client.IProjectsMapsTilesApiClientAltEnum = function module$contents$eeapiclient$ee_api_client_IProjectsMapsTilesApiClientAltEnum() {
};
module$exports$eeapiclient$ee_api_client.ProjectsMapsTilesApiClientAltEnum = {JSON:"json", MEDIA:"media", PROTO:"proto", values:function() {
  return [module$exports$eeapiclient$ee_api_client.ProjectsMapsTilesApiClientAltEnum.JSON, module$exports$eeapiclient$ee_api_client.ProjectsMapsTilesApiClientAltEnum.MEDIA, module$exports$eeapiclient$ee_api_client.ProjectsMapsTilesApiClientAltEnum.PROTO];
}};
module$exports$eeapiclient$ee_api_client.ProjectsMapsTilesApiClientImpl = function(gapiVersion, gapiRequestService, apiClientHookFactory) {
  this.gapiVersion = gapiVersion;
  this.$apiClient = new module$exports$eeapiclient$promise_api_client.PromiseApiClient(gapiRequestService, void 0 === apiClientHookFactory ? null : apiClientHookFactory);
};
module$exports$eeapiclient$ee_api_client.ProjectsMapsTilesApiClientImpl.prototype.get = function(parent, zoom, x, y, namedParameters) {
  namedParameters = void 0 === namedParameters ? {} : namedParameters;
  this.$apiClient.$validateParameter(parent, /^projects\/[^/]+\/maps\/[^/]+$/);
  return this.$apiClient.$request({body:null, httpMethod:"GET", methodId:"earthengine.projects.maps.tiles.get", path:"/" + this.gapiVersion + "/" + parent + "/tiles/" + zoom + "/" + x + "/" + y, queryParams:module$contents$eeapiclient$request_params_buildQueryParams(namedParameters, module$contents$eeapiclient$ee_api_client_PARAM_MAP_0), responseCtor:module$exports$eeapiclient$ee_api_client.HttpBody});
};
module$exports$eeapiclient$ee_api_client.ProjectsMapsTilesApiClient = function() {
};
module$exports$eeapiclient$ee_api_client.IProjectsOperationsApiClient$XgafvEnum = function module$contents$eeapiclient$ee_api_client_IProjectsOperationsApiClient$XgafvEnum() {
};
module$exports$eeapiclient$ee_api_client.ProjectsOperationsApiClient$XgafvEnum = {1:"1", 2:"2", values:function() {
  return [module$exports$eeapiclient$ee_api_client.ProjectsOperationsApiClient$XgafvEnum[1], module$exports$eeapiclient$ee_api_client.ProjectsOperationsApiClient$XgafvEnum[2]];
}};
module$exports$eeapiclient$ee_api_client.IProjectsOperationsApiClientAltEnum = function module$contents$eeapiclient$ee_api_client_IProjectsOperationsApiClientAltEnum() {
};
module$exports$eeapiclient$ee_api_client.ProjectsOperationsApiClientAltEnum = {JSON:"json", MEDIA:"media", PROTO:"proto", values:function() {
  return [module$exports$eeapiclient$ee_api_client.ProjectsOperationsApiClientAltEnum.JSON, module$exports$eeapiclient$ee_api_client.ProjectsOperationsApiClientAltEnum.MEDIA, module$exports$eeapiclient$ee_api_client.ProjectsOperationsApiClientAltEnum.PROTO];
}};
module$exports$eeapiclient$ee_api_client.ProjectsOperationsApiClientImpl = function(gapiVersion, gapiRequestService, apiClientHookFactory) {
  this.gapiVersion = gapiVersion;
  this.$apiClient = new module$exports$eeapiclient$promise_api_client.PromiseApiClient(gapiRequestService, void 0 === apiClientHookFactory ? null : apiClientHookFactory);
};
module$exports$eeapiclient$ee_api_client.ProjectsOperationsApiClientImpl.prototype.cancel = function(name, $requestBody, namedParameters) {
  namedParameters = void 0 === namedParameters ? {} : namedParameters;
  this.$apiClient.$validateParameter(name, /^projects\/[^/]+\/operations\/.*$/);
  return this.$apiClient.$request({body:$requestBody, httpMethod:"POST", methodId:"earthengine.projects.operations.cancel", path:"/" + this.gapiVersion + "/" + name + ":cancel", queryParams:module$contents$eeapiclient$request_params_buildQueryParams(namedParameters, module$contents$eeapiclient$ee_api_client_PARAM_MAP_0), responseCtor:module$exports$eeapiclient$ee_api_client.Empty});
};
module$exports$eeapiclient$ee_api_client.ProjectsOperationsApiClientImpl.prototype.delete = function(name, namedParameters) {
  namedParameters = void 0 === namedParameters ? {} : namedParameters;
  this.$apiClient.$validateParameter(name, /^projects\/[^/]+\/operations\/.*$/);
  return this.$apiClient.$request({body:null, httpMethod:"DELETE", methodId:"earthengine.projects.operations.delete", path:"/" + this.gapiVersion + "/" + name, queryParams:module$contents$eeapiclient$request_params_buildQueryParams(namedParameters, module$contents$eeapiclient$ee_api_client_PARAM_MAP_0), responseCtor:module$exports$eeapiclient$ee_api_client.Empty});
};
module$exports$eeapiclient$ee_api_client.ProjectsOperationsApiClientImpl.prototype.get = function(name, namedParameters) {
  namedParameters = void 0 === namedParameters ? {} : namedParameters;
  this.$apiClient.$validateParameter(name, /^projects\/[^/]+\/operations\/.*$/);
  return this.$apiClient.$request({body:null, httpMethod:"GET", methodId:"earthengine.projects.operations.get", path:"/" + this.gapiVersion + "/" + name, queryParams:module$contents$eeapiclient$request_params_buildQueryParams(namedParameters, module$contents$eeapiclient$ee_api_client_PARAM_MAP_0), responseCtor:module$exports$eeapiclient$ee_api_client.Operation});
};
module$exports$eeapiclient$ee_api_client.ProjectsOperationsApiClientImpl.prototype.list = function(name, namedParameters) {
  namedParameters = void 0 === namedParameters ? {} : namedParameters;
  this.$apiClient.$validateParameter(name, /^projects\/[^/]+$/);
  return this.$apiClient.$request({body:null, httpMethod:"GET", methodId:"earthengine.projects.operations.list", path:"/" + this.gapiVersion + "/" + name + "/operations", queryParams:module$contents$eeapiclient$request_params_buildQueryParams(namedParameters, module$contents$eeapiclient$ee_api_client_PARAM_MAP_0), responseCtor:module$exports$eeapiclient$ee_api_client.ListOperationsResponse});
};
module$exports$eeapiclient$ee_api_client.ProjectsOperationsApiClientImpl.prototype.wait = function(name, $requestBody, namedParameters) {
  namedParameters = void 0 === namedParameters ? {} : namedParameters;
  this.$apiClient.$validateParameter(name, /^projects\/[^/]+\/operations\/.*$/);
  return this.$apiClient.$request({body:$requestBody, httpMethod:"POST", methodId:"earthengine.projects.operations.wait", path:"/" + this.gapiVersion + "/" + name + ":wait", queryParams:module$contents$eeapiclient$request_params_buildQueryParams(namedParameters, module$contents$eeapiclient$ee_api_client_PARAM_MAP_0), responseCtor:module$exports$eeapiclient$ee_api_client.Operation});
};
module$exports$eeapiclient$ee_api_client.ProjectsOperationsApiClient = function() {
};
module$exports$eeapiclient$ee_api_client.IProjectsTableApiClient$XgafvEnum = function module$contents$eeapiclient$ee_api_client_IProjectsTableApiClient$XgafvEnum() {
};
module$exports$eeapiclient$ee_api_client.ProjectsTableApiClient$XgafvEnum = {1:"1", 2:"2", values:function() {
  return [module$exports$eeapiclient$ee_api_client.ProjectsTableApiClient$XgafvEnum[1], module$exports$eeapiclient$ee_api_client.ProjectsTableApiClient$XgafvEnum[2]];
}};
module$exports$eeapiclient$ee_api_client.IProjectsTableApiClientAltEnum = function module$contents$eeapiclient$ee_api_client_IProjectsTableApiClientAltEnum() {
};
module$exports$eeapiclient$ee_api_client.ProjectsTableApiClientAltEnum = {JSON:"json", MEDIA:"media", PROTO:"proto", values:function() {
  return [module$exports$eeapiclient$ee_api_client.ProjectsTableApiClientAltEnum.JSON, module$exports$eeapiclient$ee_api_client.ProjectsTableApiClientAltEnum.MEDIA, module$exports$eeapiclient$ee_api_client.ProjectsTableApiClientAltEnum.PROTO];
}};
module$exports$eeapiclient$ee_api_client.ProjectsTableApiClientImpl = function(gapiVersion, gapiRequestService, apiClientHookFactory) {
  this.gapiVersion = gapiVersion;
  this.$apiClient = new module$exports$eeapiclient$promise_api_client.PromiseApiClient(gapiRequestService, void 0 === apiClientHookFactory ? null : apiClientHookFactory);
};
module$exports$eeapiclient$ee_api_client.ProjectsTableApiClientImpl.prototype.computeFeatures = function(project, $requestBody, namedParameters) {
  namedParameters = void 0 === namedParameters ? {} : namedParameters;
  this.$apiClient.$validateParameter(project, /^projects\/[^/]+$/);
  return this.$apiClient.$request({body:$requestBody, httpMethod:"POST", methodId:"earthengine.projects.table.computeFeatures", path:"/" + this.gapiVersion + "/" + project + "/table:computeFeatures", queryParams:module$contents$eeapiclient$request_params_buildQueryParams(namedParameters, module$contents$eeapiclient$ee_api_client_PARAM_MAP_0), responseCtor:module$exports$eeapiclient$ee_api_client.ComputeFeaturesResponse});
};
module$exports$eeapiclient$ee_api_client.ProjectsTableApiClientImpl.prototype.export = function(project, $requestBody, namedParameters) {
  namedParameters = void 0 === namedParameters ? {} : namedParameters;
  this.$apiClient.$validateParameter(project, /^projects\/[^/]+$/);
  return this.$apiClient.$request({body:$requestBody, httpMethod:"POST", methodId:"earthengine.projects.table.export", path:"/" + this.gapiVersion + "/" + project + "/table:export", queryParams:module$contents$eeapiclient$request_params_buildQueryParams(namedParameters, module$contents$eeapiclient$ee_api_client_PARAM_MAP_0), responseCtor:module$exports$eeapiclient$ee_api_client.Operation});
};
module$exports$eeapiclient$ee_api_client.ProjectsTableApiClientImpl.prototype.import = function(project, $requestBody, namedParameters) {
  namedParameters = void 0 === namedParameters ? {} : namedParameters;
  this.$apiClient.$validateParameter(project, /^projects\/[^/]+$/);
  return this.$apiClient.$request({body:$requestBody, httpMethod:"POST", methodId:"earthengine.projects.table.import", path:"/" + this.gapiVersion + "/" + project + "/table:import", queryParams:module$contents$eeapiclient$request_params_buildQueryParams(namedParameters, module$contents$eeapiclient$ee_api_client_PARAM_MAP_0), responseCtor:module$exports$eeapiclient$ee_api_client.Operation});
};
module$exports$eeapiclient$ee_api_client.ProjectsTableApiClient = function() {
};
module$exports$eeapiclient$ee_api_client.IProjectsTablesApiClient$XgafvEnum = function module$contents$eeapiclient$ee_api_client_IProjectsTablesApiClient$XgafvEnum() {
};
module$exports$eeapiclient$ee_api_client.ProjectsTablesApiClient$XgafvEnum = {1:"1", 2:"2", values:function() {
  return [module$exports$eeapiclient$ee_api_client.ProjectsTablesApiClient$XgafvEnum[1], module$exports$eeapiclient$ee_api_client.ProjectsTablesApiClient$XgafvEnum[2]];
}};
module$exports$eeapiclient$ee_api_client.IProjectsTablesApiClientAltEnum = function module$contents$eeapiclient$ee_api_client_IProjectsTablesApiClientAltEnum() {
};
module$exports$eeapiclient$ee_api_client.ProjectsTablesApiClientAltEnum = {JSON:"json", MEDIA:"media", PROTO:"proto", values:function() {
  return [module$exports$eeapiclient$ee_api_client.ProjectsTablesApiClientAltEnum.JSON, module$exports$eeapiclient$ee_api_client.ProjectsTablesApiClientAltEnum.MEDIA, module$exports$eeapiclient$ee_api_client.ProjectsTablesApiClientAltEnum.PROTO];
}};
module$exports$eeapiclient$ee_api_client.ProjectsTablesApiClientImpl = function(gapiVersion, gapiRequestService, apiClientHookFactory) {
  this.gapiVersion = gapiVersion;
  this.$apiClient = new module$exports$eeapiclient$promise_api_client.PromiseApiClient(gapiRequestService, void 0 === apiClientHookFactory ? null : apiClientHookFactory);
};
module$exports$eeapiclient$ee_api_client.ProjectsTablesApiClientImpl.prototype.create = function(parent, $requestBody, namedParameters) {
  namedParameters = void 0 === namedParameters ? {} : namedParameters;
  this.$apiClient.$validateParameter(parent, /^projects\/[^/]+$/);
  return this.$apiClient.$request({body:$requestBody, httpMethod:"POST", methodId:"earthengine.projects.tables.create", path:"/" + this.gapiVersion + "/" + parent + "/tables", queryParams:module$contents$eeapiclient$request_params_buildQueryParams(namedParameters, module$contents$eeapiclient$ee_api_client_PARAM_MAP_0), responseCtor:module$exports$eeapiclient$ee_api_client.Table});
};
module$exports$eeapiclient$ee_api_client.ProjectsTablesApiClientImpl.prototype.getFeatures = function(name, namedParameters) {
  namedParameters = void 0 === namedParameters ? {} : namedParameters;
  this.$apiClient.$validateParameter(name, /^projects\/[^/]+\/tables\/[^/]+$/);
  return this.$apiClient.$request({body:null, httpMethod:"GET", methodId:"earthengine.projects.tables.getFeatures", path:"/" + this.gapiVersion + "/" + name + ":getFeatures", queryParams:module$contents$eeapiclient$request_params_buildQueryParams(namedParameters, module$contents$eeapiclient$ee_api_client_PARAM_MAP_0), responseCtor:module$exports$eeapiclient$ee_api_client.HttpBody});
};
module$exports$eeapiclient$ee_api_client.ProjectsTablesApiClient = function() {
};
module$exports$eeapiclient$ee_api_client.IProjectsThumbnailsApiClient$XgafvEnum = function module$contents$eeapiclient$ee_api_client_IProjectsThumbnailsApiClient$XgafvEnum() {
};
module$exports$eeapiclient$ee_api_client.ProjectsThumbnailsApiClient$XgafvEnum = {1:"1", 2:"2", values:function() {
  return [module$exports$eeapiclient$ee_api_client.ProjectsThumbnailsApiClient$XgafvEnum[1], module$exports$eeapiclient$ee_api_client.ProjectsThumbnailsApiClient$XgafvEnum[2]];
}};
module$exports$eeapiclient$ee_api_client.IProjectsThumbnailsApiClientAltEnum = function module$contents$eeapiclient$ee_api_client_IProjectsThumbnailsApiClientAltEnum() {
};
module$exports$eeapiclient$ee_api_client.ProjectsThumbnailsApiClientAltEnum = {JSON:"json", MEDIA:"media", PROTO:"proto", values:function() {
  return [module$exports$eeapiclient$ee_api_client.ProjectsThumbnailsApiClientAltEnum.JSON, module$exports$eeapiclient$ee_api_client.ProjectsThumbnailsApiClientAltEnum.MEDIA, module$exports$eeapiclient$ee_api_client.ProjectsThumbnailsApiClientAltEnum.PROTO];
}};
module$exports$eeapiclient$ee_api_client.ProjectsThumbnailsApiClientImpl = function(gapiVersion, gapiRequestService, apiClientHookFactory) {
  this.gapiVersion = gapiVersion;
  this.$apiClient = new module$exports$eeapiclient$promise_api_client.PromiseApiClient(gapiRequestService, void 0 === apiClientHookFactory ? null : apiClientHookFactory);
};
module$exports$eeapiclient$ee_api_client.ProjectsThumbnailsApiClientImpl.prototype.create = function(parent, $requestBody, namedParameters) {
  namedParameters = void 0 === namedParameters ? {} : namedParameters;
  this.$apiClient.$validateParameter(parent, /^projects\/[^/]+$/);
  return this.$apiClient.$request({body:$requestBody, httpMethod:"POST", methodId:"earthengine.projects.thumbnails.create", path:"/" + this.gapiVersion + "/" + parent + "/thumbnails", queryParams:module$contents$eeapiclient$request_params_buildQueryParams(namedParameters, module$contents$eeapiclient$ee_api_client_PARAM_MAP_0), responseCtor:module$exports$eeapiclient$ee_api_client.Thumbnail});
};
module$exports$eeapiclient$ee_api_client.ProjectsThumbnailsApiClientImpl.prototype.getPixels = function(name, namedParameters) {
  namedParameters = void 0 === namedParameters ? {} : namedParameters;
  this.$apiClient.$validateParameter(name, /^projects\/[^/]+\/thumbnails\/[^/]+$/);
  return this.$apiClient.$request({body:null, httpMethod:"GET", methodId:"earthengine.projects.thumbnails.getPixels", path:"/" + this.gapiVersion + "/" + name + ":getPixels", queryParams:module$contents$eeapiclient$request_params_buildQueryParams(namedParameters, module$contents$eeapiclient$ee_api_client_PARAM_MAP_0), responseCtor:module$exports$eeapiclient$ee_api_client.HttpBody});
};
module$exports$eeapiclient$ee_api_client.ProjectsThumbnailsApiClient = function() {
};
module$exports$eeapiclient$ee_api_client.IProjectsValueApiClient$XgafvEnum = function module$contents$eeapiclient$ee_api_client_IProjectsValueApiClient$XgafvEnum() {
};
module$exports$eeapiclient$ee_api_client.ProjectsValueApiClient$XgafvEnum = {1:"1", 2:"2", values:function() {
  return [module$exports$eeapiclient$ee_api_client.ProjectsValueApiClient$XgafvEnum[1], module$exports$eeapiclient$ee_api_client.ProjectsValueApiClient$XgafvEnum[2]];
}};
module$exports$eeapiclient$ee_api_client.IProjectsValueApiClientAltEnum = function module$contents$eeapiclient$ee_api_client_IProjectsValueApiClientAltEnum() {
};
module$exports$eeapiclient$ee_api_client.ProjectsValueApiClientAltEnum = {JSON:"json", MEDIA:"media", PROTO:"proto", values:function() {
  return [module$exports$eeapiclient$ee_api_client.ProjectsValueApiClientAltEnum.JSON, module$exports$eeapiclient$ee_api_client.ProjectsValueApiClientAltEnum.MEDIA, module$exports$eeapiclient$ee_api_client.ProjectsValueApiClientAltEnum.PROTO];
}};
module$exports$eeapiclient$ee_api_client.ProjectsValueApiClientImpl = function(gapiVersion, gapiRequestService, apiClientHookFactory) {
  this.gapiVersion = gapiVersion;
  this.$apiClient = new module$exports$eeapiclient$promise_api_client.PromiseApiClient(gapiRequestService, void 0 === apiClientHookFactory ? null : apiClientHookFactory);
};
module$exports$eeapiclient$ee_api_client.ProjectsValueApiClientImpl.prototype.compute = function(project, $requestBody, namedParameters) {
  namedParameters = void 0 === namedParameters ? {} : namedParameters;
  this.$apiClient.$validateParameter(project, /^projects\/[^/]+$/);
  return this.$apiClient.$request({body:$requestBody, httpMethod:"POST", methodId:"earthengine.projects.value.compute", path:"/" + this.gapiVersion + "/" + project + "/value:compute", queryParams:module$contents$eeapiclient$request_params_buildQueryParams(namedParameters, module$contents$eeapiclient$ee_api_client_PARAM_MAP_0), responseCtor:module$exports$eeapiclient$ee_api_client.ComputeValueResponse});
};
module$exports$eeapiclient$ee_api_client.ProjectsValueApiClient = function() {
};
module$exports$eeapiclient$ee_api_client.IProjectsVideoApiClient$XgafvEnum = function module$contents$eeapiclient$ee_api_client_IProjectsVideoApiClient$XgafvEnum() {
};
module$exports$eeapiclient$ee_api_client.ProjectsVideoApiClient$XgafvEnum = {1:"1", 2:"2", values:function() {
  return [module$exports$eeapiclient$ee_api_client.ProjectsVideoApiClient$XgafvEnum[1], module$exports$eeapiclient$ee_api_client.ProjectsVideoApiClient$XgafvEnum[2]];
}};
module$exports$eeapiclient$ee_api_client.IProjectsVideoApiClientAltEnum = function module$contents$eeapiclient$ee_api_client_IProjectsVideoApiClientAltEnum() {
};
module$exports$eeapiclient$ee_api_client.ProjectsVideoApiClientAltEnum = {JSON:"json", MEDIA:"media", PROTO:"proto", values:function() {
  return [module$exports$eeapiclient$ee_api_client.ProjectsVideoApiClientAltEnum.JSON, module$exports$eeapiclient$ee_api_client.ProjectsVideoApiClientAltEnum.MEDIA, module$exports$eeapiclient$ee_api_client.ProjectsVideoApiClientAltEnum.PROTO];
}};
module$exports$eeapiclient$ee_api_client.ProjectsVideoApiClientImpl = function(gapiVersion, gapiRequestService, apiClientHookFactory) {
  this.gapiVersion = gapiVersion;
  this.$apiClient = new module$exports$eeapiclient$promise_api_client.PromiseApiClient(gapiRequestService, void 0 === apiClientHookFactory ? null : apiClientHookFactory);
};
module$exports$eeapiclient$ee_api_client.ProjectsVideoApiClientImpl.prototype.export = function(project, $requestBody, namedParameters) {
  namedParameters = void 0 === namedParameters ? {} : namedParameters;
  this.$apiClient.$validateParameter(project, /^projects\/[^/]+$/);
  return this.$apiClient.$request({body:$requestBody, httpMethod:"POST", methodId:"earthengine.projects.video.export", path:"/" + this.gapiVersion + "/" + project + "/video:export", queryParams:module$contents$eeapiclient$request_params_buildQueryParams(namedParameters, module$contents$eeapiclient$ee_api_client_PARAM_MAP_0), responseCtor:module$exports$eeapiclient$ee_api_client.Operation});
};
module$exports$eeapiclient$ee_api_client.ProjectsVideoApiClient = function() {
};
module$exports$eeapiclient$ee_api_client.IProjectsVideoMapApiClient$XgafvEnum = function module$contents$eeapiclient$ee_api_client_IProjectsVideoMapApiClient$XgafvEnum() {
};
module$exports$eeapiclient$ee_api_client.ProjectsVideoMapApiClient$XgafvEnum = {1:"1", 2:"2", values:function() {
  return [module$exports$eeapiclient$ee_api_client.ProjectsVideoMapApiClient$XgafvEnum[1], module$exports$eeapiclient$ee_api_client.ProjectsVideoMapApiClient$XgafvEnum[2]];
}};
module$exports$eeapiclient$ee_api_client.IProjectsVideoMapApiClientAltEnum = function module$contents$eeapiclient$ee_api_client_IProjectsVideoMapApiClientAltEnum() {
};
module$exports$eeapiclient$ee_api_client.ProjectsVideoMapApiClientAltEnum = {JSON:"json", MEDIA:"media", PROTO:"proto", values:function() {
  return [module$exports$eeapiclient$ee_api_client.ProjectsVideoMapApiClientAltEnum.JSON, module$exports$eeapiclient$ee_api_client.ProjectsVideoMapApiClientAltEnum.MEDIA, module$exports$eeapiclient$ee_api_client.ProjectsVideoMapApiClientAltEnum.PROTO];
}};
module$exports$eeapiclient$ee_api_client.ProjectsVideoMapApiClientImpl = function(gapiVersion, gapiRequestService, apiClientHookFactory) {
  this.gapiVersion = gapiVersion;
  this.$apiClient = new module$exports$eeapiclient$promise_api_client.PromiseApiClient(gapiRequestService, void 0 === apiClientHookFactory ? null : apiClientHookFactory);
};
module$exports$eeapiclient$ee_api_client.ProjectsVideoMapApiClientImpl.prototype.export = function(project, $requestBody, namedParameters) {
  namedParameters = void 0 === namedParameters ? {} : namedParameters;
  this.$apiClient.$validateParameter(project, /^projects\/[^/]+$/);
  return this.$apiClient.$request({body:$requestBody, httpMethod:"POST", methodId:"earthengine.projects.videoMap.export", path:"/" + this.gapiVersion + "/" + project + "/videoMap:export", queryParams:module$contents$eeapiclient$request_params_buildQueryParams(namedParameters, module$contents$eeapiclient$ee_api_client_PARAM_MAP_0), responseCtor:module$exports$eeapiclient$ee_api_client.Operation});
};
module$exports$eeapiclient$ee_api_client.ProjectsVideoMapApiClient = function() {
};
module$exports$eeapiclient$ee_api_client.IProjectsVideoThumbnailsApiClient$XgafvEnum = function module$contents$eeapiclient$ee_api_client_IProjectsVideoThumbnailsApiClient$XgafvEnum() {
};
module$exports$eeapiclient$ee_api_client.ProjectsVideoThumbnailsApiClient$XgafvEnum = {1:"1", 2:"2", values:function() {
  return [module$exports$eeapiclient$ee_api_client.ProjectsVideoThumbnailsApiClient$XgafvEnum[1], module$exports$eeapiclient$ee_api_client.ProjectsVideoThumbnailsApiClient$XgafvEnum[2]];
}};
module$exports$eeapiclient$ee_api_client.IProjectsVideoThumbnailsApiClientAltEnum = function module$contents$eeapiclient$ee_api_client_IProjectsVideoThumbnailsApiClientAltEnum() {
};
module$exports$eeapiclient$ee_api_client.ProjectsVideoThumbnailsApiClientAltEnum = {JSON:"json", MEDIA:"media", PROTO:"proto", values:function() {
  return [module$exports$eeapiclient$ee_api_client.ProjectsVideoThumbnailsApiClientAltEnum.JSON, module$exports$eeapiclient$ee_api_client.ProjectsVideoThumbnailsApiClientAltEnum.MEDIA, module$exports$eeapiclient$ee_api_client.ProjectsVideoThumbnailsApiClientAltEnum.PROTO];
}};
module$exports$eeapiclient$ee_api_client.ProjectsVideoThumbnailsApiClientImpl = function(gapiVersion, gapiRequestService, apiClientHookFactory) {
  this.gapiVersion = gapiVersion;
  this.$apiClient = new module$exports$eeapiclient$promise_api_client.PromiseApiClient(gapiRequestService, void 0 === apiClientHookFactory ? null : apiClientHookFactory);
};
module$exports$eeapiclient$ee_api_client.ProjectsVideoThumbnailsApiClientImpl.prototype.create = function(parent, $requestBody, namedParameters) {
  namedParameters = void 0 === namedParameters ? {} : namedParameters;
  this.$apiClient.$validateParameter(parent, /^projects\/[^/]+$/);
  return this.$apiClient.$request({body:$requestBody, httpMethod:"POST", methodId:"earthengine.projects.videoThumbnails.create", path:"/" + this.gapiVersion + "/" + parent + "/videoThumbnails", queryParams:module$contents$eeapiclient$request_params_buildQueryParams(namedParameters, module$contents$eeapiclient$ee_api_client_PARAM_MAP_0), responseCtor:module$exports$eeapiclient$ee_api_client.VideoThumbnail});
};
module$exports$eeapiclient$ee_api_client.ProjectsVideoThumbnailsApiClientImpl.prototype.getPixels = function(name, namedParameters) {
  namedParameters = void 0 === namedParameters ? {} : namedParameters;
  this.$apiClient.$validateParameter(name, /^projects\/[^/]+\/videoThumbnails\/[^/]+$/);
  return this.$apiClient.$request({body:null, httpMethod:"GET", methodId:"earthengine.projects.videoThumbnails.getPixels", path:"/" + this.gapiVersion + "/" + name + ":getPixels", queryParams:module$contents$eeapiclient$request_params_buildQueryParams(namedParameters, module$contents$eeapiclient$ee_api_client_PARAM_MAP_0), responseCtor:module$exports$eeapiclient$ee_api_client.HttpBody});
};
module$exports$eeapiclient$ee_api_client.ProjectsVideoThumbnailsApiClient = function() {
};
ee.api = module$exports$eeapiclient$ee_api_client;
var module$exports$eeapiclient$promise_request_service = {}, module$contents$eeapiclient$promise_request_service_module = module$contents$eeapiclient$promise_request_service_module || {id:"javascript/typescript/contrib/apiclient/request_service/promise_request_service.closure.js"};
module$exports$eeapiclient$promise_request_service.PromiseRequestService = function() {
};
module$exports$eeapiclient$promise_request_service.PromiseRequestService.prototype.send = function(params, responseCtor) {
  module$contents$eeapiclient$request_params_processParams(params);
  return this.makeRequest(params).then(function(response) {
    return responseCtor ? module$contents$eeapiclient$domain_object_deserialize(responseCtor, response) : response;
  });
};
goog.async = {};
goog.async.FreeList = function(create, reset, limit) {
  this.limit_ = limit;
  this.create_ = create;
  this.reset_ = reset;
  this.occupants_ = 0;
  this.head_ = null;
};
goog.async.FreeList.prototype.get = function() {
  if (0 < this.occupants_) {
    this.occupants_--;
    var item = this.head_;
    this.head_ = item.next;
    item.next = null;
  } else {
    item = this.create_();
  }
  return item;
};
goog.async.FreeList.prototype.put = function(item) {
  this.reset_(item);
  this.occupants_ < this.limit_ && (this.occupants_++, item.next = this.head_, this.head_ = item);
};
goog.async.FreeList.prototype.occupants = function() {
  return this.occupants_;
};
goog.dom.BrowserFeature = {};
goog.dom.BrowserFeature.ASSUME_NO_OFFSCREEN_CANVAS = !1;
goog.dom.BrowserFeature.ASSUME_OFFSCREEN_CANVAS = !1;
goog.dom.BrowserFeature.detectOffscreenCanvas_ = function(contextName) {
  try {
    return !!(new self.OffscreenCanvas(0, 0)).getContext(contextName);
  } catch (ex) {
  }
  return !1;
};
goog.dom.BrowserFeature.OFFSCREEN_CANVAS_2D = !goog.dom.BrowserFeature.ASSUME_NO_OFFSCREEN_CANVAS && (goog.dom.BrowserFeature.ASSUME_OFFSCREEN_CANVAS || goog.dom.BrowserFeature.detectOffscreenCanvas_("2d"));
goog.dom.BrowserFeature.CAN_ADD_NAME_OR_TYPE_ATTRIBUTES = !goog.userAgent.IE || goog.userAgent.isDocumentModeOrHigher(9);
goog.dom.BrowserFeature.CAN_USE_CHILDREN_ATTRIBUTE = !goog.userAgent.GECKO && !goog.userAgent.IE || goog.userAgent.IE && goog.userAgent.isDocumentModeOrHigher(9) || goog.userAgent.GECKO && goog.userAgent.isVersionOrHigher("1.9.1");
goog.dom.BrowserFeature.CAN_USE_INNER_TEXT = goog.userAgent.IE && !goog.userAgent.isVersionOrHigher("9");
goog.dom.BrowserFeature.CAN_USE_PARENT_ELEMENT_PROPERTY = goog.userAgent.IE || goog.userAgent.OPERA || goog.userAgent.WEBKIT;
goog.dom.BrowserFeature.INNER_HTML_NEEDS_SCOPED_ELEMENT = goog.userAgent.IE;
goog.dom.BrowserFeature.LEGACY_IE_RANGES = goog.userAgent.IE && !goog.userAgent.isDocumentModeOrHigher(9);
goog.math.Coordinate = function(opt_x, opt_y) {
  this.x = void 0 !== opt_x ? opt_x : 0;
  this.y = void 0 !== opt_y ? opt_y : 0;
};
goog.math.Coordinate.prototype.clone = function() {
  return new goog.math.Coordinate(this.x, this.y);
};
goog.DEBUG && (goog.math.Coordinate.prototype.toString = function() {
  return "(" + this.x + ", " + this.y + ")";
});
goog.math.Coordinate.prototype.equals = function(other) {
  return other instanceof goog.math.Coordinate && goog.math.Coordinate.equals(this, other);
};
goog.math.Coordinate.equals = function(a, b) {
  return a == b ? !0 : a && b ? a.x == b.x && a.y == b.y : !1;
};
goog.math.Coordinate.distance = function(a, b) {
  var dx = a.x - b.x, dy = a.y - b.y;
  return Math.sqrt(dx * dx + dy * dy);
};
goog.math.Coordinate.magnitude = function(a) {
  return Math.sqrt(a.x * a.x + a.y * a.y);
};
goog.math.Coordinate.azimuth = function(a) {
  return goog.math.angle(0, 0, a.x, a.y);
};
goog.math.Coordinate.squaredDistance = function(a, b) {
  var dx = a.x - b.x, dy = a.y - b.y;
  return dx * dx + dy * dy;
};
goog.math.Coordinate.difference = function(a, b) {
  return new goog.math.Coordinate(a.x - b.x, a.y - b.y);
};
goog.math.Coordinate.sum = function(a, b) {
  return new goog.math.Coordinate(a.x + b.x, a.y + b.y);
};
goog.math.Coordinate.prototype.ceil = function() {
  this.x = Math.ceil(this.x);
  this.y = Math.ceil(this.y);
  return this;
};
goog.math.Coordinate.prototype.floor = function() {
  this.x = Math.floor(this.x);
  this.y = Math.floor(this.y);
  return this;
};
goog.math.Coordinate.prototype.round = function() {
  this.x = Math.round(this.x);
  this.y = Math.round(this.y);
  return this;
};
goog.math.Coordinate.prototype.translate = function(tx, opt_ty) {
  tx instanceof goog.math.Coordinate ? (this.x += tx.x, this.y += tx.y) : (this.x += Number(tx), "number" === typeof opt_ty && (this.y += opt_ty));
  return this;
};
goog.math.Coordinate.prototype.scale = function(sx, opt_sy) {
  var sy;
  this.x *= sx;
  this.y *= "number" === typeof opt_sy ? opt_sy : sx;
  return this;
};
goog.math.Coordinate.prototype.rotateRadians = function(radians, opt_center) {
  var center = opt_center || new goog.math.Coordinate(0, 0), x = this.x, y = this.y, cos = Math.cos(radians), sin = Math.sin(radians);
  this.x = (x - center.x) * cos - (y - center.y) * sin + center.x;
  this.y = (x - center.x) * sin + (y - center.y) * cos + center.y;
};
goog.math.Coordinate.prototype.rotateDegrees = function(degrees, opt_center) {
  this.rotateRadians(goog.math.toRadians(degrees), opt_center);
};
goog.math.Size = function(width, height) {
  this.width = width;
  this.height = height;
};
goog.math.Size.equals = function(a, b) {
  return a == b ? !0 : a && b ? a.width == b.width && a.height == b.height : !1;
};
goog.math.Size.prototype.clone = function() {
  return new goog.math.Size(this.width, this.height);
};
goog.DEBUG && (goog.math.Size.prototype.toString = function() {
  return "(" + this.width + " x " + this.height + ")";
});
goog.math.Size.prototype.getLongest = function() {
  return Math.max(this.width, this.height);
};
goog.math.Size.prototype.getShortest = function() {
  return Math.min(this.width, this.height);
};
goog.math.Size.prototype.area = function() {
  return this.width * this.height;
};
goog.math.Size.prototype.perimeter = function() {
  return 2 * (this.width + this.height);
};
goog.math.Size.prototype.aspectRatio = function() {
  return this.width / this.height;
};
goog.math.Size.prototype.isEmpty = function() {
  return !this.area();
};
goog.math.Size.prototype.ceil = function() {
  this.width = Math.ceil(this.width);
  this.height = Math.ceil(this.height);
  return this;
};
goog.math.Size.prototype.fitsInside = function(target) {
  return this.width <= target.width && this.height <= target.height;
};
goog.math.Size.prototype.floor = function() {
  this.width = Math.floor(this.width);
  this.height = Math.floor(this.height);
  return this;
};
goog.math.Size.prototype.round = function() {
  this.width = Math.round(this.width);
  this.height = Math.round(this.height);
  return this;
};
goog.math.Size.prototype.scale = function(sx, opt_sy) {
  var sy;
  this.width *= sx;
  this.height *= "number" === typeof opt_sy ? opt_sy : sx;
  return this;
};
goog.math.Size.prototype.scaleToCover = function(target) {
  var s = this.aspectRatio() <= target.aspectRatio() ? target.width / this.width : target.height / this.height;
  return this.scale(s);
};
goog.math.Size.prototype.scaleToFit = function(target) {
  var s = this.aspectRatio() > target.aspectRatio() ? target.width / this.width : target.height / this.height;
  return this.scale(s);
};
goog.dom.ASSUME_QUIRKS_MODE = !1;
goog.dom.ASSUME_STANDARDS_MODE = !1;
goog.dom.COMPAT_MODE_KNOWN_ = goog.dom.ASSUME_QUIRKS_MODE || goog.dom.ASSUME_STANDARDS_MODE;
goog.dom.getDomHelper = function(opt_element) {
  return opt_element ? new goog.dom.DomHelper(goog.dom.getOwnerDocument(opt_element)) : goog.dom.defaultDomHelper_ || (goog.dom.defaultDomHelper_ = new goog.dom.DomHelper);
};
goog.dom.getDocument = function() {
  return document;
};
goog.dom.getElement = function(element) {
  return goog.dom.getElementHelper_(document, element);
};
goog.dom.getElementHelper_ = function(doc, element) {
  return "string" === typeof element ? doc.getElementById(element) : element;
};
goog.dom.getRequiredElement = function(id) {
  return goog.dom.getRequiredElementHelper_(document, id);
};
goog.dom.getRequiredElementHelper_ = function(doc, id) {
  goog.asserts.assertString(id);
  var element = goog.dom.getElementHelper_(doc, id);
  return element = goog.asserts.assertElement(element, "No element found with id: " + id);
};
goog.dom.$ = goog.dom.getElement;
goog.dom.getElementsByTagName = function(tagName, opt_parent) {
  return (opt_parent || document).getElementsByTagName(String(tagName));
};
goog.dom.getElementsByTagNameAndClass = function(opt_tag, opt_class, opt_el) {
  return goog.dom.getElementsByTagNameAndClass_(document, opt_tag, opt_class, opt_el);
};
goog.dom.getElementByTagNameAndClass = function(opt_tag, opt_class, opt_el) {
  return goog.dom.getElementByTagNameAndClass_(document, opt_tag, opt_class, opt_el);
};
goog.dom.getElementsByClass = function(className, opt_el) {
  var parent = opt_el || document;
  return goog.dom.canUseQuerySelector_(parent) ? parent.querySelectorAll("." + className) : goog.dom.getElementsByTagNameAndClass_(document, "*", className, opt_el);
};
goog.dom.getElementByClass = function(className, opt_el) {
  var parent = opt_el || document, retVal = null;
  return (retVal = parent.getElementsByClassName ? parent.getElementsByClassName(className)[0] : goog.dom.getElementByTagNameAndClass_(document, "*", className, opt_el)) || null;
};
goog.dom.getRequiredElementByClass = function(className, opt_root) {
  var retValue = goog.dom.getElementByClass(className, opt_root);
  return goog.asserts.assert(retValue, "No element found with className: " + className);
};
goog.dom.canUseQuerySelector_ = function(parent) {
  return !(!parent.querySelectorAll || !parent.querySelector);
};
goog.dom.getElementsByTagNameAndClass_ = function(doc, opt_tag, opt_class, opt_el) {
  var parent = opt_el || doc, tagName = opt_tag && "*" != opt_tag ? String(opt_tag).toUpperCase() : "";
  if (goog.dom.canUseQuerySelector_(parent) && (tagName || opt_class)) {
    return parent.querySelectorAll(tagName + (opt_class ? "." + opt_class : ""));
  }
  if (opt_class && parent.getElementsByClassName) {
    var els = parent.getElementsByClassName(opt_class);
    if (tagName) {
      for (var arrayLike = {}, len = 0, i = 0, el; el = els[i]; i++) {
        tagName == el.nodeName && (arrayLike[len++] = el);
      }
      arrayLike.length = len;
      return arrayLike;
    }
    return els;
  }
  els = parent.getElementsByTagName(tagName || "*");
  if (opt_class) {
    arrayLike = {};
    for (i = len = 0; el = els[i]; i++) {
      var className = el.className;
      "function" == typeof className.split && goog.array.contains(className.split(/\s+/), opt_class) && (arrayLike[len++] = el);
    }
    arrayLike.length = len;
    return arrayLike;
  }
  return els;
};
goog.dom.getElementByTagNameAndClass_ = function(doc, opt_tag, opt_class, opt_el) {
  var parent = opt_el || doc, tag = opt_tag && "*" != opt_tag ? String(opt_tag).toUpperCase() : "";
  return goog.dom.canUseQuerySelector_(parent) && (tag || opt_class) ? parent.querySelector(tag + (opt_class ? "." + opt_class : "")) : goog.dom.getElementsByTagNameAndClass_(doc, opt_tag, opt_class, opt_el)[0] || null;
};
goog.dom.$$ = goog.dom.getElementsByTagNameAndClass;
goog.dom.setProperties = function(element, properties) {
  goog.object.forEach(properties, function(val, key) {
    val && "object" == typeof val && val.implementsGoogStringTypedString && (val = val.getTypedStringValue());
    "style" == key ? element.style.cssText = val : "class" == key ? element.className = val : "for" == key ? element.htmlFor = val : goog.dom.DIRECT_ATTRIBUTE_MAP_.hasOwnProperty(key) ? element.setAttribute(goog.dom.DIRECT_ATTRIBUTE_MAP_[key], val) : goog.string.startsWith(key, "aria-") || goog.string.startsWith(key, "data-") ? element.setAttribute(key, val) : element[key] = val;
  });
};
goog.dom.DIRECT_ATTRIBUTE_MAP_ = {cellpadding:"cellPadding", cellspacing:"cellSpacing", colspan:"colSpan", frameborder:"frameBorder", height:"height", maxlength:"maxLength", nonce:"nonce", role:"role", rowspan:"rowSpan", type:"type", usemap:"useMap", valign:"vAlign", width:"width"};
goog.dom.getViewportSize = function(opt_window) {
  return goog.dom.getViewportSize_(opt_window || window);
};
goog.dom.getViewportSize_ = function(win) {
  var doc = win.document, el = goog.dom.isCss1CompatMode_(doc) ? doc.documentElement : doc.body;
  return new goog.math.Size(el.clientWidth, el.clientHeight);
};
goog.dom.getDocumentHeight = function() {
  return goog.dom.getDocumentHeight_(window);
};
goog.dom.getDocumentHeightForWindow = function(win) {
  return goog.dom.getDocumentHeight_(win);
};
goog.dom.getDocumentHeight_ = function(win) {
  var doc = win.document, height = 0;
  if (doc) {
    var body = doc.body, docEl = doc.documentElement;
    if (!docEl || !body) {
      return 0;
    }
    var vh = goog.dom.getViewportSize_(win).height;
    if (goog.dom.isCss1CompatMode_(doc) && docEl.scrollHeight) {
      height = docEl.scrollHeight != vh ? docEl.scrollHeight : docEl.offsetHeight;
    } else {
      var sh = docEl.scrollHeight, oh = docEl.offsetHeight;
      docEl.clientHeight != oh && (sh = body.scrollHeight, oh = body.offsetHeight);
      height = sh > vh ? sh > oh ? sh : oh : sh < oh ? sh : oh;
    }
  }
  return height;
};
goog.dom.getPageScroll = function(opt_window) {
  return goog.dom.getDomHelper((opt_window || goog.global || window).document).getDocumentScroll();
};
goog.dom.getDocumentScroll = function() {
  return goog.dom.getDocumentScroll_(document);
};
goog.dom.getDocumentScroll_ = function(doc) {
  var el = goog.dom.getDocumentScrollElement_(doc), win = goog.dom.getWindow_(doc);
  return goog.userAgent.IE && goog.userAgent.isVersionOrHigher("10") && win.pageYOffset != el.scrollTop ? new goog.math.Coordinate(el.scrollLeft, el.scrollTop) : new goog.math.Coordinate(win.pageXOffset || el.scrollLeft, win.pageYOffset || el.scrollTop);
};
goog.dom.getDocumentScrollElement = function() {
  return goog.dom.getDocumentScrollElement_(document);
};
goog.dom.getDocumentScrollElement_ = function(doc) {
  return doc.scrollingElement ? doc.scrollingElement : !goog.userAgent.WEBKIT && goog.dom.isCss1CompatMode_(doc) ? doc.documentElement : doc.body || doc.documentElement;
};
goog.dom.getWindow = function(opt_doc) {
  return opt_doc ? goog.dom.getWindow_(opt_doc) : window;
};
goog.dom.getWindow_ = function(doc) {
  return doc.parentWindow || doc.defaultView;
};
goog.dom.createDom = function(tagName, opt_attributes, var_args) {
  return goog.dom.createDom_(document, arguments);
};
goog.dom.createDom_ = function(doc, args) {
  var tagName = String(args[0]), attributes = args[1];
  if (!goog.dom.BrowserFeature.CAN_ADD_NAME_OR_TYPE_ATTRIBUTES && attributes && (attributes.name || attributes.type)) {
    var tagNameArr = ["<", tagName];
    attributes.name && tagNameArr.push(' name="', goog.string.htmlEscape(attributes.name), '"');
    if (attributes.type) {
      tagNameArr.push(' type="', goog.string.htmlEscape(attributes.type), '"');
      var clone = {};
      goog.object.extend(clone, attributes);
      delete clone.type;
      attributes = clone;
    }
    tagNameArr.push(">");
    tagName = tagNameArr.join("");
  }
  var element = goog.dom.createElement_(doc, tagName);
  attributes && ("string" === typeof attributes ? element.className = attributes : Array.isArray(attributes) ? element.className = attributes.join(" ") : goog.dom.setProperties(element, attributes));
  2 < args.length && goog.dom.append_(doc, element, args, 2);
  return element;
};
goog.dom.append_ = function(doc, parent, args, startIndex) {
  function childHandler(child) {
    child && parent.appendChild("string" === typeof child ? doc.createTextNode(child) : child);
  }
  for (var i = startIndex; i < args.length; i++) {
    var arg = args[i];
    goog.isArrayLike(arg) && !goog.dom.isNodeLike(arg) ? goog.array.forEach(goog.dom.isNodeList(arg) ? goog.array.toArray(arg) : arg, childHandler) : childHandler(arg);
  }
};
goog.dom.$dom = goog.dom.createDom;
goog.dom.createElement = function(name) {
  return goog.dom.createElement_(document, name);
};
goog.dom.createElement_ = function(doc, name) {
  name = String(name);
  "application/xhtml+xml" === doc.contentType && (name = name.toLowerCase());
  return doc.createElement(name);
};
goog.dom.createTextNode = function(content) {
  return document.createTextNode(String(content));
};
goog.dom.createTable = function(rows, columns, opt_fillWithNbsp) {
  return goog.dom.createTable_(document, rows, columns, !!opt_fillWithNbsp);
};
goog.dom.createTable_ = function(doc, rows, columns, fillWithNbsp) {
  for (var table = goog.dom.createElement_(doc, "TABLE"), tbody = table.appendChild(goog.dom.createElement_(doc, "TBODY")), i = 0; i < rows; i++) {
    for (var tr = goog.dom.createElement_(doc, "TR"), j = 0; j < columns; j++) {
      var td = goog.dom.createElement_(doc, "TD");
      fillWithNbsp && goog.dom.setTextContent(td, goog.string.Unicode.NBSP);
      tr.appendChild(td);
    }
    tbody.appendChild(tr);
  }
  return table;
};
goog.dom.constHtmlToNode = function(var_args) {
  var stringArray = goog.array.map(arguments, goog.string.Const.unwrap), safeHtml = goog.html.uncheckedconversions.safeHtmlFromStringKnownToSatisfyTypeContract(goog.string.Const.from("Constant HTML string, that gets turned into a Node later, so it will be automatically balanced."), stringArray.join(""));
  return goog.dom.safeHtmlToNode(safeHtml);
};
goog.dom.safeHtmlToNode = function(html) {
  return goog.dom.safeHtmlToNode_(document, html);
};
goog.dom.safeHtmlToNode_ = function(doc, html) {
  var tempDiv = goog.dom.createElement_(doc, "DIV");
  goog.dom.BrowserFeature.INNER_HTML_NEEDS_SCOPED_ELEMENT ? (goog.dom.safe.setInnerHtml(tempDiv, goog.html.SafeHtml.concat(goog.html.SafeHtml.BR, html)), tempDiv.removeChild(goog.asserts.assert(tempDiv.firstChild))) : goog.dom.safe.setInnerHtml(tempDiv, html);
  return goog.dom.childrenToNode_(doc, tempDiv);
};
goog.dom.childrenToNode_ = function(doc, tempDiv) {
  if (1 == tempDiv.childNodes.length) {
    return tempDiv.removeChild(goog.asserts.assert(tempDiv.firstChild));
  }
  for (var fragment = doc.createDocumentFragment(); tempDiv.firstChild;) {
    fragment.appendChild(tempDiv.firstChild);
  }
  return fragment;
};
goog.dom.isCss1CompatMode = function() {
  return goog.dom.isCss1CompatMode_(document);
};
goog.dom.isCss1CompatMode_ = function(doc) {
  return goog.dom.COMPAT_MODE_KNOWN_ ? goog.dom.ASSUME_STANDARDS_MODE : "CSS1Compat" == doc.compatMode;
};
goog.dom.canHaveChildren = function(node) {
  if (node.nodeType != goog.dom.NodeType.ELEMENT) {
    return !1;
  }
  switch(node.tagName) {
    case "APPLET":
    case "AREA":
    case "BASE":
    case "BR":
    case "COL":
    case "COMMAND":
    case "EMBED":
    case "FRAME":
    case "HR":
    case "IMG":
    case "INPUT":
    case "IFRAME":
    case "ISINDEX":
    case "KEYGEN":
    case "LINK":
    case "NOFRAMES":
    case "NOSCRIPT":
    case "META":
    case "OBJECT":
    case "PARAM":
    case "SCRIPT":
    case "SOURCE":
    case "STYLE":
    case "TRACK":
    case "WBR":
      return !1;
  }
  return !0;
};
goog.dom.appendChild = function(parent, child) {
  goog.asserts.assert(null != parent && null != child, "goog.dom.appendChild expects non-null arguments");
  parent.appendChild(child);
};
goog.dom.append = function(parent, var_args) {
  goog.dom.append_(goog.dom.getOwnerDocument(parent), parent, arguments, 1);
};
goog.dom.removeChildren = function(node) {
  for (var child; child = node.firstChild;) {
    node.removeChild(child);
  }
};
goog.dom.insertSiblingBefore = function(newNode, refNode) {
  goog.asserts.assert(null != newNode && null != refNode, "goog.dom.insertSiblingBefore expects non-null arguments");
  refNode.parentNode && refNode.parentNode.insertBefore(newNode, refNode);
};
goog.dom.insertSiblingAfter = function(newNode, refNode) {
  goog.asserts.assert(null != newNode && null != refNode, "goog.dom.insertSiblingAfter expects non-null arguments");
  refNode.parentNode && refNode.parentNode.insertBefore(newNode, refNode.nextSibling);
};
goog.dom.insertChildAt = function(parent, child, index) {
  goog.asserts.assert(null != parent, "goog.dom.insertChildAt expects a non-null parent");
  parent.insertBefore(child, parent.childNodes[index] || null);
};
goog.dom.removeNode = function(node) {
  return node && node.parentNode ? node.parentNode.removeChild(node) : null;
};
goog.dom.replaceNode = function(newNode, oldNode) {
  goog.asserts.assert(null != newNode && null != oldNode, "goog.dom.replaceNode expects non-null arguments");
  var parent = oldNode.parentNode;
  parent && parent.replaceChild(newNode, oldNode);
};
goog.dom.flattenElement = function(element) {
  var child, parent = element.parentNode;
  if (parent && parent.nodeType != goog.dom.NodeType.DOCUMENT_FRAGMENT) {
    if (element.removeNode) {
      return element.removeNode(!1);
    }
    for (; child = element.firstChild;) {
      parent.insertBefore(child, element);
    }
    return goog.dom.removeNode(element);
  }
};
goog.dom.getChildren = function(element) {
  return goog.dom.BrowserFeature.CAN_USE_CHILDREN_ATTRIBUTE && void 0 != element.children ? element.children : goog.array.filter(element.childNodes, function(node) {
    return node.nodeType == goog.dom.NodeType.ELEMENT;
  });
};
goog.dom.getFirstElementChild = function(node) {
  return void 0 !== node.firstElementChild ? node.firstElementChild : goog.dom.getNextElementNode_(node.firstChild, !0);
};
goog.dom.getLastElementChild = function(node) {
  return void 0 !== node.lastElementChild ? node.lastElementChild : goog.dom.getNextElementNode_(node.lastChild, !1);
};
goog.dom.getNextElementSibling = function(node) {
  return void 0 !== node.nextElementSibling ? node.nextElementSibling : goog.dom.getNextElementNode_(node.nextSibling, !0);
};
goog.dom.getPreviousElementSibling = function(node) {
  return void 0 !== node.previousElementSibling ? node.previousElementSibling : goog.dom.getNextElementNode_(node.previousSibling, !1);
};
goog.dom.getNextElementNode_ = function(node, forward) {
  for (; node && node.nodeType != goog.dom.NodeType.ELEMENT;) {
    node = forward ? node.nextSibling : node.previousSibling;
  }
  return node;
};
goog.dom.getNextNode = function(node) {
  if (!node) {
    return null;
  }
  if (node.firstChild) {
    return node.firstChild;
  }
  for (; node && !node.nextSibling;) {
    node = node.parentNode;
  }
  return node ? node.nextSibling : null;
};
goog.dom.getPreviousNode = function(node) {
  if (!node) {
    return null;
  }
  if (!node.previousSibling) {
    return node.parentNode;
  }
  for (node = node.previousSibling; node && node.lastChild;) {
    node = node.lastChild;
  }
  return node;
};
goog.dom.isNodeLike = function(obj) {
  return goog.isObject(obj) && 0 < obj.nodeType;
};
goog.dom.isElement = function(obj) {
  return goog.isObject(obj) && obj.nodeType == goog.dom.NodeType.ELEMENT;
};
goog.dom.isWindow = function(obj) {
  return goog.isObject(obj) && obj.window == obj;
};
goog.dom.getParentElement = function(element) {
  var parent;
  if (goog.dom.BrowserFeature.CAN_USE_PARENT_ELEMENT_PROPERTY && !(goog.userAgent.IE && goog.userAgent.isVersionOrHigher("9") && !goog.userAgent.isVersionOrHigher("10") && goog.global.SVGElement && element instanceof goog.global.SVGElement) && (parent = element.parentElement)) {
    return parent;
  }
  parent = element.parentNode;
  return goog.dom.isElement(parent) ? parent : null;
};
goog.dom.contains = function(parent, descendant) {
  if (!parent || !descendant) {
    return !1;
  }
  if (parent.contains && descendant.nodeType == goog.dom.NodeType.ELEMENT) {
    return parent == descendant || parent.contains(descendant);
  }
  if ("undefined" != typeof parent.compareDocumentPosition) {
    return parent == descendant || !!(parent.compareDocumentPosition(descendant) & 16);
  }
  for (; descendant && parent != descendant;) {
    descendant = descendant.parentNode;
  }
  return descendant == parent;
};
goog.dom.compareNodeOrder = function(node1, node2) {
  if (node1 == node2) {
    return 0;
  }
  if (node1.compareDocumentPosition) {
    return node1.compareDocumentPosition(node2) & 2 ? 1 : -1;
  }
  if (goog.userAgent.IE && !goog.userAgent.isDocumentModeOrHigher(9)) {
    if (node1.nodeType == goog.dom.NodeType.DOCUMENT) {
      return -1;
    }
    if (node2.nodeType == goog.dom.NodeType.DOCUMENT) {
      return 1;
    }
  }
  if ("sourceIndex" in node1 || node1.parentNode && "sourceIndex" in node1.parentNode) {
    var isElement1 = node1.nodeType == goog.dom.NodeType.ELEMENT, isElement2 = node2.nodeType == goog.dom.NodeType.ELEMENT;
    if (isElement1 && isElement2) {
      return node1.sourceIndex - node2.sourceIndex;
    }
    var parent1 = node1.parentNode, parent2 = node2.parentNode;
    return parent1 == parent2 ? goog.dom.compareSiblingOrder_(node1, node2) : !isElement1 && goog.dom.contains(parent1, node2) ? -1 * goog.dom.compareParentsDescendantNodeIe_(node1, node2) : !isElement2 && goog.dom.contains(parent2, node1) ? goog.dom.compareParentsDescendantNodeIe_(node2, node1) : (isElement1 ? node1.sourceIndex : parent1.sourceIndex) - (isElement2 ? node2.sourceIndex : parent2.sourceIndex);
  }
  var doc = goog.dom.getOwnerDocument(node1);
  var range1 = doc.createRange();
  range1.selectNode(node1);
  range1.collapse(!0);
  var range2 = doc.createRange();
  range2.selectNode(node2);
  range2.collapse(!0);
  return range1.compareBoundaryPoints(goog.global.Range.START_TO_END, range2);
};
goog.dom.compareParentsDescendantNodeIe_ = function(textNode, node) {
  var parent = textNode.parentNode;
  if (parent == node) {
    return -1;
  }
  for (var sibling = node; sibling.parentNode != parent;) {
    sibling = sibling.parentNode;
  }
  return goog.dom.compareSiblingOrder_(sibling, textNode);
};
goog.dom.compareSiblingOrder_ = function(node1, node2) {
  for (var s = node2; s = s.previousSibling;) {
    if (s == node1) {
      return -1;
    }
  }
  return 1;
};
goog.dom.findCommonAncestor = function(var_args) {
  var i, count = arguments.length;
  if (!count) {
    return null;
  }
  if (1 == count) {
    return arguments[0];
  }
  var paths = [], minLength = Infinity;
  for (i = 0; i < count; i++) {
    for (var ancestors = [], node = arguments[i]; node;) {
      ancestors.unshift(node), node = node.parentNode;
    }
    paths.push(ancestors);
    minLength = Math.min(minLength, ancestors.length);
  }
  var output = null;
  for (i = 0; i < minLength; i++) {
    for (var first = paths[0][i], j = 1; j < count; j++) {
      if (first != paths[j][i]) {
        return output;
      }
    }
    output = first;
  }
  return output;
};
goog.dom.isInDocument = function(node) {
  return 16 == (node.ownerDocument.compareDocumentPosition(node) & 16);
};
goog.dom.getOwnerDocument = function(node) {
  goog.asserts.assert(node, "Node cannot be null or undefined.");
  return node.nodeType == goog.dom.NodeType.DOCUMENT ? node : node.ownerDocument || node.document;
};
goog.dom.getFrameContentDocument = function(frame) {
  return frame.contentDocument || frame.contentWindow.document;
};
goog.dom.getFrameContentWindow = function(frame) {
  try {
    return frame.contentWindow || (frame.contentDocument ? goog.dom.getWindow(frame.contentDocument) : null);
  } catch (e) {
  }
  return null;
};
goog.dom.setTextContent = function(node, text) {
  goog.asserts.assert(null != node, "goog.dom.setTextContent expects a non-null value for node");
  if ("textContent" in node) {
    node.textContent = text;
  } else {
    if (node.nodeType == goog.dom.NodeType.TEXT) {
      node.data = String(text);
    } else {
      if (node.firstChild && node.firstChild.nodeType == goog.dom.NodeType.TEXT) {
        for (; node.lastChild != node.firstChild;) {
          node.removeChild(goog.asserts.assert(node.lastChild));
        }
        node.firstChild.data = String(text);
      } else {
        goog.dom.removeChildren(node);
        var doc = goog.dom.getOwnerDocument(node);
        node.appendChild(doc.createTextNode(String(text)));
      }
    }
  }
};
goog.dom.getOuterHtml = function(element) {
  goog.asserts.assert(null !== element, "goog.dom.getOuterHtml expects a non-null value for element");
  if ("outerHTML" in element) {
    return element.outerHTML;
  }
  var doc = goog.dom.getOwnerDocument(element), div = goog.dom.createElement_(doc, "DIV");
  div.appendChild(element.cloneNode(!0));
  return div.innerHTML;
};
goog.dom.findNode = function(root, p) {
  var rv = [];
  return goog.dom.findNodes_(root, p, rv, !0) ? rv[0] : void 0;
};
goog.dom.findNodes = function(root, p) {
  var rv = [];
  goog.dom.findNodes_(root, p, rv, !1);
  return rv;
};
goog.dom.findNodes_ = function(root, p, rv, findOne) {
  if (null != root) {
    for (var child = root.firstChild; child;) {
      if (p(child) && (rv.push(child), findOne) || goog.dom.findNodes_(child, p, rv, findOne)) {
        return !0;
      }
      child = child.nextSibling;
    }
  }
  return !1;
};
goog.dom.findElement = function(root, pred) {
  for (var stack = goog.dom.getChildrenReverse_(root); 0 < stack.length;) {
    var next = stack.pop();
    if (pred(next)) {
      return next;
    }
    for (var c = next.lastElementChild; c; c = c.previousElementSibling) {
      stack.push(c);
    }
  }
  return null;
};
goog.dom.findElements = function(root, pred) {
  for (var result = [], stack = goog.dom.getChildrenReverse_(root); 0 < stack.length;) {
    var next = stack.pop();
    pred(next) && result.push(next);
    for (var c = next.lastElementChild; c; c = c.previousElementSibling) {
      stack.push(c);
    }
  }
  return result;
};
goog.dom.getChildrenReverse_ = function(node) {
  if (node.nodeType == goog.dom.NodeType.DOCUMENT) {
    return [node.documentElement];
  }
  for (var children = [], c = node.lastElementChild; c; c = c.previousElementSibling) {
    children.push(c);
  }
  return children;
};
goog.dom.TAGS_TO_IGNORE_ = {SCRIPT:1, STYLE:1, HEAD:1, IFRAME:1, OBJECT:1};
goog.dom.PREDEFINED_TAG_VALUES_ = {IMG:" ", BR:"\n"};
goog.dom.isFocusableTabIndex = function(element) {
  return goog.dom.hasSpecifiedTabIndex_(element) && goog.dom.isTabIndexFocusable_(element);
};
goog.dom.setFocusableTabIndex = function(element, enable) {
  enable ? element.tabIndex = 0 : (element.tabIndex = -1, element.removeAttribute("tabIndex"));
};
goog.dom.isFocusable = function(element) {
  var focusable;
  return (focusable = goog.dom.nativelySupportsFocus_(element) ? !element.disabled && (!goog.dom.hasSpecifiedTabIndex_(element) || goog.dom.isTabIndexFocusable_(element)) : goog.dom.isFocusableTabIndex(element)) && goog.userAgent.IE ? goog.dom.hasNonZeroBoundingRect_(element) : focusable;
};
goog.dom.hasSpecifiedTabIndex_ = function(element) {
  if (goog.userAgent.IE && !goog.userAgent.isVersionOrHigher("9")) {
    var attrNode = element.getAttributeNode("tabindex");
    return null != attrNode && attrNode.specified;
  }
  return element.hasAttribute("tabindex");
};
goog.dom.isTabIndexFocusable_ = function(element) {
  var index = element.tabIndex;
  return "number" === typeof index && 0 <= index && 32768 > index;
};
goog.dom.nativelySupportsFocus_ = function(element) {
  return "A" == element.tagName && element.hasAttribute("href") || "INPUT" == element.tagName || "TEXTAREA" == element.tagName || "SELECT" == element.tagName || "BUTTON" == element.tagName;
};
goog.dom.hasNonZeroBoundingRect_ = function(element) {
  var rect = !goog.isFunction(element.getBoundingClientRect) || goog.userAgent.IE && null == element.parentElement ? {height:element.offsetHeight, width:element.offsetWidth} : element.getBoundingClientRect();
  return null != rect && 0 < rect.height && 0 < rect.width;
};
goog.dom.getTextContent = function(node) {
  if (goog.dom.BrowserFeature.CAN_USE_INNER_TEXT && null !== node && "innerText" in node) {
    var textContent = goog.string.canonicalizeNewlines(node.innerText);
  } else {
    var buf = [];
    goog.dom.getTextContent_(node, buf, !0);
    textContent = buf.join("");
  }
  textContent = textContent.replace(/ \xAD /g, " ").replace(/\xAD/g, "");
  textContent = textContent.replace(/\u200B/g, "");
  goog.dom.BrowserFeature.CAN_USE_INNER_TEXT || (textContent = textContent.replace(/ +/g, " "));
  " " != textContent && (textContent = textContent.replace(/^\s*/, ""));
  return textContent;
};
goog.dom.getRawTextContent = function(node) {
  var buf = [];
  goog.dom.getTextContent_(node, buf, !1);
  return buf.join("");
};
goog.dom.getTextContent_ = function(node, buf, normalizeWhitespace) {
  if (!(node.nodeName in goog.dom.TAGS_TO_IGNORE_)) {
    if (node.nodeType == goog.dom.NodeType.TEXT) {
      normalizeWhitespace ? buf.push(String(node.nodeValue).replace(/(\r\n|\r|\n)/g, "")) : buf.push(node.nodeValue);
    } else {
      if (node.nodeName in goog.dom.PREDEFINED_TAG_VALUES_) {
        buf.push(goog.dom.PREDEFINED_TAG_VALUES_[node.nodeName]);
      } else {
        for (var child = node.firstChild; child;) {
          goog.dom.getTextContent_(child, buf, normalizeWhitespace), child = child.nextSibling;
        }
      }
    }
  }
};
goog.dom.getNodeTextLength = function(node) {
  return goog.dom.getTextContent(node).length;
};
goog.dom.getNodeTextOffset = function(node, opt_offsetParent) {
  for (var root = opt_offsetParent || goog.dom.getOwnerDocument(node).body, buf = []; node && node != root;) {
    for (var cur = node; cur = cur.previousSibling;) {
      buf.unshift(goog.dom.getTextContent(cur));
    }
    node = node.parentNode;
  }
  return goog.string.trimLeft(buf.join("")).replace(/ +/g, " ").length;
};
goog.dom.getNodeAtOffset = function(parent, offset, opt_result) {
  for (var stack = [parent], pos = 0, cur = null; 0 < stack.length && pos < offset;) {
    if (cur = stack.pop(), !(cur.nodeName in goog.dom.TAGS_TO_IGNORE_)) {
      if (cur.nodeType == goog.dom.NodeType.TEXT) {
        var text = cur.nodeValue.replace(/(\r\n|\r|\n)/g, "").replace(/ +/g, " ");
        pos += text.length;
      } else {
        if (cur.nodeName in goog.dom.PREDEFINED_TAG_VALUES_) {
          pos += goog.dom.PREDEFINED_TAG_VALUES_[cur.nodeName].length;
        } else {
          for (var i = cur.childNodes.length - 1; 0 <= i; i--) {
            stack.push(cur.childNodes[i]);
          }
        }
      }
    }
  }
  goog.isObject(opt_result) && (opt_result.remainder = cur ? cur.nodeValue.length + offset - pos - 1 : 0, opt_result.node = cur);
  return cur;
};
goog.dom.isNodeList = function(val) {
  if (val && "number" == typeof val.length) {
    if (goog.isObject(val)) {
      return "function" == typeof val.item || "string" == typeof val.item;
    }
    if (goog.isFunction(val)) {
      return "function" == typeof val.item;
    }
  }
  return !1;
};
goog.dom.getAncestorByTagNameAndClass = function(element, opt_tag, opt_class, opt_maxSearchSteps) {
  if (!opt_tag && !opt_class) {
    return null;
  }
  var tagName = opt_tag ? String(opt_tag).toUpperCase() : null;
  return goog.dom.getAncestor(element, function(node) {
    return (!tagName || node.nodeName == tagName) && (!opt_class || "string" === typeof node.className && goog.array.contains(node.className.split(/\s+/), opt_class));
  }, !0, opt_maxSearchSteps);
};
goog.dom.getAncestorByClass = function(element, className, opt_maxSearchSteps) {
  return goog.dom.getAncestorByTagNameAndClass(element, null, className, opt_maxSearchSteps);
};
goog.dom.getAncestor = function(element, matcher, opt_includeNode, opt_maxSearchSteps) {
  element && !opt_includeNode && (element = element.parentNode);
  for (var steps = 0; element && (null == opt_maxSearchSteps || steps <= opt_maxSearchSteps);) {
    goog.asserts.assert("parentNode" != element.name);
    if (matcher(element)) {
      return element;
    }
    element = element.parentNode;
    steps++;
  }
  return null;
};
goog.dom.getActiveElement = function(doc) {
  try {
    var activeElement = doc && doc.activeElement;
    return activeElement && activeElement.nodeName ? activeElement : null;
  } catch (e) {
    return null;
  }
};
goog.dom.getPixelRatio = function() {
  var win = goog.dom.getWindow();
  return void 0 !== win.devicePixelRatio ? win.devicePixelRatio : win.matchMedia ? goog.dom.matchesPixelRatio_(3) || goog.dom.matchesPixelRatio_(2) || goog.dom.matchesPixelRatio_(1.5) || goog.dom.matchesPixelRatio_(1) || .75 : 1;
};
goog.dom.matchesPixelRatio_ = function(pixelRatio) {
  return goog.dom.getWindow().matchMedia("(min-resolution: " + pixelRatio + "dppx),(min--moz-device-pixel-ratio: " + pixelRatio + "),(min-resolution: " + 96 * pixelRatio + "dpi)").matches ? pixelRatio : 0;
};
goog.dom.getCanvasContext2D = function(canvas) {
  return canvas.getContext("2d");
};
goog.dom.DomHelper = function(opt_document) {
  this.document_ = opt_document || goog.global.document || document;
};
goog.dom.DomHelper.prototype.getDomHelper = goog.dom.getDomHelper;
goog.dom.DomHelper.prototype.setDocument = function(document) {
  this.document_ = document;
};
goog.dom.DomHelper.prototype.getDocument = function() {
  return this.document_;
};
goog.dom.DomHelper.prototype.getElement = function(element) {
  return goog.dom.getElementHelper_(this.document_, element);
};
goog.dom.DomHelper.prototype.getRequiredElement = function(id) {
  return goog.dom.getRequiredElementHelper_(this.document_, id);
};
goog.dom.DomHelper.prototype.$ = goog.dom.DomHelper.prototype.getElement;
goog.dom.DomHelper.prototype.getElementsByTagName = function(tagName, opt_parent) {
  return (opt_parent || this.document_).getElementsByTagName(String(tagName));
};
goog.dom.DomHelper.prototype.getElementsByTagNameAndClass = function(opt_tag, opt_class, opt_el) {
  return goog.dom.getElementsByTagNameAndClass_(this.document_, opt_tag, opt_class, opt_el);
};
goog.dom.DomHelper.prototype.getElementByTagNameAndClass = function(opt_tag, opt_class, opt_el) {
  return goog.dom.getElementByTagNameAndClass_(this.document_, opt_tag, opt_class, opt_el);
};
goog.dom.DomHelper.prototype.getElementsByClass = function(className, opt_el) {
  return goog.dom.getElementsByClass(className, opt_el || this.document_);
};
goog.dom.DomHelper.prototype.getElementByClass = function(className, opt_el) {
  return goog.dom.getElementByClass(className, opt_el || this.document_);
};
goog.dom.DomHelper.prototype.getRequiredElementByClass = function(className, opt_root) {
  return goog.dom.getRequiredElementByClass(className, opt_root || this.document_);
};
goog.dom.DomHelper.prototype.$$ = goog.dom.DomHelper.prototype.getElementsByTagNameAndClass;
goog.dom.DomHelper.prototype.setProperties = goog.dom.setProperties;
goog.dom.DomHelper.prototype.getViewportSize = function(opt_window) {
  return goog.dom.getViewportSize(opt_window || this.getWindow());
};
goog.dom.DomHelper.prototype.getDocumentHeight = function() {
  return goog.dom.getDocumentHeight_(this.getWindow());
};
goog.dom.DomHelper.prototype.createDom = function(tagName, opt_attributes, var_args) {
  return goog.dom.createDom_(this.document_, arguments);
};
goog.dom.DomHelper.prototype.$dom = goog.dom.DomHelper.prototype.createDom;
goog.dom.DomHelper.prototype.createElement = function(name) {
  return goog.dom.createElement_(this.document_, name);
};
goog.dom.DomHelper.prototype.createTextNode = function(content) {
  return this.document_.createTextNode(String(content));
};
goog.dom.DomHelper.prototype.createTable = function(rows, columns, opt_fillWithNbsp) {
  return goog.dom.createTable_(this.document_, rows, columns, !!opt_fillWithNbsp);
};
goog.dom.DomHelper.prototype.safeHtmlToNode = function(html) {
  return goog.dom.safeHtmlToNode_(this.document_, html);
};
goog.dom.DomHelper.prototype.isCss1CompatMode = function() {
  return goog.dom.isCss1CompatMode_(this.document_);
};
goog.dom.DomHelper.prototype.getWindow = function() {
  return goog.dom.getWindow_(this.document_);
};
goog.dom.DomHelper.prototype.getDocumentScrollElement = function() {
  return goog.dom.getDocumentScrollElement_(this.document_);
};
goog.dom.DomHelper.prototype.getDocumentScroll = function() {
  return goog.dom.getDocumentScroll_(this.document_);
};
goog.dom.DomHelper.prototype.getActiveElement = function(opt_doc) {
  return goog.dom.getActiveElement(opt_doc || this.document_);
};
goog.dom.DomHelper.prototype.appendChild = goog.dom.appendChild;
goog.dom.DomHelper.prototype.append = goog.dom.append;
goog.dom.DomHelper.prototype.canHaveChildren = goog.dom.canHaveChildren;
goog.dom.DomHelper.prototype.removeChildren = goog.dom.removeChildren;
goog.dom.DomHelper.prototype.insertSiblingBefore = goog.dom.insertSiblingBefore;
goog.dom.DomHelper.prototype.insertSiblingAfter = goog.dom.insertSiblingAfter;
goog.dom.DomHelper.prototype.insertChildAt = goog.dom.insertChildAt;
goog.dom.DomHelper.prototype.removeNode = goog.dom.removeNode;
goog.dom.DomHelper.prototype.replaceNode = goog.dom.replaceNode;
goog.dom.DomHelper.prototype.flattenElement = goog.dom.flattenElement;
goog.dom.DomHelper.prototype.getChildren = goog.dom.getChildren;
goog.dom.DomHelper.prototype.getFirstElementChild = goog.dom.getFirstElementChild;
goog.dom.DomHelper.prototype.getLastElementChild = goog.dom.getLastElementChild;
goog.dom.DomHelper.prototype.getNextElementSibling = goog.dom.getNextElementSibling;
goog.dom.DomHelper.prototype.getPreviousElementSibling = goog.dom.getPreviousElementSibling;
goog.dom.DomHelper.prototype.getNextNode = goog.dom.getNextNode;
goog.dom.DomHelper.prototype.getPreviousNode = goog.dom.getPreviousNode;
goog.dom.DomHelper.prototype.isNodeLike = goog.dom.isNodeLike;
goog.dom.DomHelper.prototype.isElement = goog.dom.isElement;
goog.dom.DomHelper.prototype.isWindow = goog.dom.isWindow;
goog.dom.DomHelper.prototype.getParentElement = goog.dom.getParentElement;
goog.dom.DomHelper.prototype.contains = goog.dom.contains;
goog.dom.DomHelper.prototype.compareNodeOrder = goog.dom.compareNodeOrder;
goog.dom.DomHelper.prototype.findCommonAncestor = goog.dom.findCommonAncestor;
goog.dom.DomHelper.prototype.getOwnerDocument = goog.dom.getOwnerDocument;
goog.dom.DomHelper.prototype.getFrameContentDocument = goog.dom.getFrameContentDocument;
goog.dom.DomHelper.prototype.getFrameContentWindow = goog.dom.getFrameContentWindow;
goog.dom.DomHelper.prototype.setTextContent = goog.dom.setTextContent;
goog.dom.DomHelper.prototype.getOuterHtml = goog.dom.getOuterHtml;
goog.dom.DomHelper.prototype.findNode = goog.dom.findNode;
goog.dom.DomHelper.prototype.findNodes = goog.dom.findNodes;
goog.dom.DomHelper.prototype.isFocusableTabIndex = goog.dom.isFocusableTabIndex;
goog.dom.DomHelper.prototype.setFocusableTabIndex = goog.dom.setFocusableTabIndex;
goog.dom.DomHelper.prototype.isFocusable = goog.dom.isFocusable;
goog.dom.DomHelper.prototype.getTextContent = goog.dom.getTextContent;
goog.dom.DomHelper.prototype.getNodeTextLength = goog.dom.getNodeTextLength;
goog.dom.DomHelper.prototype.getNodeTextOffset = goog.dom.getNodeTextOffset;
goog.dom.DomHelper.prototype.getNodeAtOffset = goog.dom.getNodeAtOffset;
goog.dom.DomHelper.prototype.isNodeList = goog.dom.isNodeList;
goog.dom.DomHelper.prototype.getAncestorByTagNameAndClass = goog.dom.getAncestorByTagNameAndClass;
goog.dom.DomHelper.prototype.getAncestorByClass = goog.dom.getAncestorByClass;
goog.dom.DomHelper.prototype.getAncestor = goog.dom.getAncestor;
goog.dom.DomHelper.prototype.getCanvasContext2D = goog.dom.getCanvasContext2D;
goog.async.throwException = function(exception) {
  goog.global.setTimeout(function() {
    throw exception;
  }, 0);
};
goog.async.nextTick = function(callback, opt_context, opt_useSetImmediate) {
  var cb = callback;
  opt_context && (cb = goog.bind(callback, opt_context));
  cb = goog.async.nextTick.wrapCallback_(cb);
  goog.isFunction(goog.global.setImmediate) && (opt_useSetImmediate || goog.async.nextTick.useSetImmediate_()) ? goog.global.setImmediate(cb) : (goog.async.nextTick.setImmediate_ || (goog.async.nextTick.setImmediate_ = goog.async.nextTick.getSetImmediateEmulator_()), goog.async.nextTick.setImmediate_(cb));
};
goog.async.nextTick.useSetImmediate_ = function() {
  return goog.global.Window && goog.global.Window.prototype && !goog.labs.userAgent.browser.isEdge() && goog.global.Window.prototype.setImmediate == goog.global.setImmediate ? !1 : !0;
};
goog.async.nextTick.getSetImmediateEmulator_ = function() {
  var Channel = goog.global.MessageChannel;
  "undefined" === typeof Channel && "undefined" !== typeof window && window.postMessage && window.addEventListener && !goog.labs.userAgent.engine.isPresto() && (Channel = function() {
    var iframe = goog.dom.createElement("IFRAME");
    iframe.style.display = "none";
    document.documentElement.appendChild(iframe);
    var win = iframe.contentWindow, doc = win.document;
    doc.open();
    doc.close();
    var message = "callImmediate" + Math.random(), origin = "file:" == win.location.protocol ? "*" : win.location.protocol + "//" + win.location.host, onmessage = goog.bind(function(e) {
      if (("*" == origin || e.origin == origin) && e.data == message) {
        this.port1.onmessage();
      }
    }, this);
    win.addEventListener("message", onmessage, !1);
    this.port1 = {};
    this.port2 = {postMessage:function() {
      win.postMessage(message, origin);
    }};
  });
  if ("undefined" !== typeof Channel && !goog.labs.userAgent.browser.isIE()) {
    var channel = new Channel, head = {}, tail = head;
    channel.port1.onmessage = function() {
      if (void 0 !== head.next) {
        head = head.next;
        var cb = head.cb;
        head.cb = null;
        cb();
      }
    };
    return function(cb) {
      tail.next = {cb:cb};
      tail = tail.next;
      channel.port2.postMessage(0);
    };
  }
  return function(cb) {
    goog.global.setTimeout(cb, 0);
  };
};
goog.async.nextTick.wrapCallback_ = goog.functions.identity;
goog.debug.entryPointRegistry.register(function(transformer) {
  goog.async.nextTick.wrapCallback_ = transformer;
});
goog.async.WorkQueue = function() {
  this.workTail_ = this.workHead_ = null;
};
goog.async.WorkQueue.DEFAULT_MAX_UNUSED = 100;
goog.async.WorkQueue.freelist_ = new goog.async.FreeList(function() {
  return new goog.async.WorkItem;
}, function(item) {
  item.reset();
}, goog.async.WorkQueue.DEFAULT_MAX_UNUSED);
goog.async.WorkQueue.prototype.add = function(fn, scope) {
  var item = this.getUnusedItem_();
  item.set(fn, scope);
  this.workTail_ ? this.workTail_.next = item : (goog.asserts.assert(!this.workHead_), this.workHead_ = item);
  this.workTail_ = item;
};
goog.async.WorkQueue.prototype.remove = function() {
  var item = null;
  this.workHead_ && (item = this.workHead_, this.workHead_ = this.workHead_.next, this.workHead_ || (this.workTail_ = null), item.next = null);
  return item;
};
goog.async.WorkQueue.prototype.returnUnused = function(item) {
  goog.async.WorkQueue.freelist_.put(item);
};
goog.async.WorkQueue.prototype.getUnusedItem_ = function() {
  return goog.async.WorkQueue.freelist_.get();
};
goog.async.WorkItem = function() {
  this.next = this.scope = this.fn = null;
};
goog.async.WorkItem.prototype.set = function(fn, scope) {
  this.fn = fn;
  this.scope = scope;
  this.next = null;
};
goog.async.WorkItem.prototype.reset = function() {
  this.next = this.scope = this.fn = null;
};
goog.ASSUME_NATIVE_PROMISE = !1;
goog.async.run = function(callback, opt_context) {
  goog.async.run.schedule_ || goog.async.run.initializeRunner_();
  goog.async.run.workQueueScheduled_ || (goog.async.run.schedule_(), goog.async.run.workQueueScheduled_ = !0);
  goog.async.run.workQueue_.add(callback, opt_context);
};
goog.async.run.initializeRunner_ = function() {
  if (goog.ASSUME_NATIVE_PROMISE || goog.global.Promise && goog.global.Promise.resolve) {
    var promise = goog.global.Promise.resolve(void 0);
    goog.async.run.schedule_ = function() {
      promise.then(goog.async.run.processWorkQueue);
    };
  } else {
    goog.async.run.schedule_ = function() {
      goog.async.nextTick(goog.async.run.processWorkQueue);
    };
  }
};
goog.async.run.forceNextTick = function(opt_realSetTimeout) {
  goog.async.run.schedule_ = function() {
    goog.async.nextTick(goog.async.run.processWorkQueue);
    opt_realSetTimeout && opt_realSetTimeout(goog.async.run.processWorkQueue);
  };
};
goog.async.run.workQueueScheduled_ = !1;
goog.async.run.workQueue_ = new goog.async.WorkQueue;
goog.DEBUG && (goog.async.run.resetQueue = function() {
  goog.async.run.workQueueScheduled_ = !1;
  goog.async.run.workQueue_ = new goog.async.WorkQueue;
});
goog.async.run.processWorkQueue = function() {
  for (var item = null; item = goog.async.run.workQueue_.remove();) {
    try {
      item.fn.call(item.scope);
    } catch (e) {
      goog.async.throwException(e);
    }
    goog.async.run.workQueue_.returnUnused(item);
  }
  goog.async.run.workQueueScheduled_ = !1;
};
goog.promise = {};
goog.promise.Resolver = function() {
};
goog.Thenable = function() {
};
goog.Thenable.prototype.then = function(opt_onFulfilled, opt_onRejected, opt_context) {
};
goog.Thenable.IMPLEMENTED_BY_PROP = "$goog_Thenable";
goog.Thenable.addImplementation = function(ctor) {
  ctor.prototype[goog.Thenable.IMPLEMENTED_BY_PROP] = !0;
};
goog.Thenable.isImplementedBy = function(object) {
  if (!object) {
    return !1;
  }
  try {
    return !!object[goog.Thenable.IMPLEMENTED_BY_PROP];
    return !!object.$goog_Thenable;
  } catch (e) {
    return !1;
  }
};
goog.Promise = function(resolver, opt_context) {
  this.state_ = goog.Promise.State_.PENDING;
  this.result_ = void 0;
  this.callbackEntriesTail_ = this.callbackEntries_ = this.parent_ = null;
  this.executing_ = !1;
  0 < goog.Promise.UNHANDLED_REJECTION_DELAY ? this.unhandledRejectionId_ = 0 : 0 == goog.Promise.UNHANDLED_REJECTION_DELAY && (this.hadUnhandledRejection_ = !1);
  goog.Promise.LONG_STACK_TRACES && (this.stack_ = [], this.addStackTrace_(Error("created")), this.currentStep_ = 0);
  if (resolver != goog.nullFunction) {
    try {
      var self = this;
      resolver.call(opt_context, function(value) {
        self.resolve_(goog.Promise.State_.FULFILLED, value);
      }, function(reason) {
        if (goog.DEBUG && !(reason instanceof goog.Promise.CancellationError)) {
          try {
            if (reason instanceof Error) {
              throw reason;
            }
            throw Error("Promise rejected.");
          } catch (e) {
          }
        }
        self.resolve_(goog.Promise.State_.REJECTED, reason);
      });
    } catch (e) {
      this.resolve_(goog.Promise.State_.REJECTED, e);
    }
  }
};
goog.Promise.LONG_STACK_TRACES = !1;
goog.Promise.UNHANDLED_REJECTION_DELAY = 0;
goog.Promise.State_ = {PENDING:0, BLOCKED:1, FULFILLED:2, REJECTED:3};
goog.Promise.CallbackEntry_ = function() {
  this.next = this.context = this.onRejected = this.onFulfilled = this.child = null;
  this.always = !1;
};
goog.Promise.CallbackEntry_.prototype.reset = function() {
  this.context = this.onRejected = this.onFulfilled = this.child = null;
  this.always = !1;
};
goog.Promise.DEFAULT_MAX_UNUSED = 100;
goog.Promise.freelist_ = new goog.async.FreeList(function() {
  return new goog.Promise.CallbackEntry_;
}, function(item) {
  item.reset();
}, goog.Promise.DEFAULT_MAX_UNUSED);
goog.Promise.getCallbackEntry_ = function(onFulfilled, onRejected, context) {
  var entry = goog.Promise.freelist_.get();
  entry.onFulfilled = onFulfilled;
  entry.onRejected = onRejected;
  entry.context = context;
  return entry;
};
goog.Promise.returnEntry_ = function(entry) {
  goog.Promise.freelist_.put(entry);
};
goog.Promise.resolve = function(opt_value) {
  if (opt_value instanceof goog.Promise) {
    return opt_value;
  }
  var promise = new goog.Promise(goog.nullFunction);
  promise.resolve_(goog.Promise.State_.FULFILLED, opt_value);
  return promise;
};
goog.Promise.reject = function(opt_reason) {
  return new goog.Promise(function(resolve, reject) {
    reject(opt_reason);
  });
};
goog.Promise.resolveThen_ = function(value, onFulfilled, onRejected) {
  goog.Promise.maybeThen_(value, onFulfilled, onRejected, null) || goog.async.run(goog.partial(onFulfilled, value));
};
goog.Promise.race = function(promises) {
  return new goog.Promise(function(resolve, reject) {
    promises.length || resolve(void 0);
    for (var i = 0, promise; i < promises.length; i++) {
      promise = promises[i], goog.Promise.resolveThen_(promise, resolve, reject);
    }
  });
};
goog.Promise.all = function(promises) {
  return new goog.Promise(function(resolve, reject) {
    var toFulfill = promises.length, values = [];
    if (toFulfill) {
      for (var onFulfill = function(index, value) {
        toFulfill--;
        values[index] = value;
        0 == toFulfill && resolve(values);
      }, onReject = function(reason) {
        reject(reason);
      }, i = 0, promise; i < promises.length; i++) {
        promise = promises[i], goog.Promise.resolveThen_(promise, goog.partial(onFulfill, i), onReject);
      }
    } else {
      resolve(values);
    }
  });
};
goog.Promise.allSettled = function(promises) {
  return new goog.Promise(function(resolve, reject) {
    var toSettle = promises.length, results = [];
    if (toSettle) {
      for (var onSettled = function(index, fulfilled, result) {
        toSettle--;
        results[index] = fulfilled ? {fulfilled:!0, value:result} : {fulfilled:!1, reason:result};
        0 == toSettle && resolve(results);
      }, i = 0, promise; i < promises.length; i++) {
        promise = promises[i], goog.Promise.resolveThen_(promise, goog.partial(onSettled, i, !0), goog.partial(onSettled, i, !1));
      }
    } else {
      resolve(results);
    }
  });
};
goog.Promise.firstFulfilled = function(promises) {
  return new goog.Promise(function(resolve, reject) {
    var toReject = promises.length, reasons = [];
    if (toReject) {
      for (var onFulfill = function(value) {
        resolve(value);
      }, onReject = function(index, reason) {
        toReject--;
        reasons[index] = reason;
        0 == toReject && reject(reasons);
      }, i = 0, promise; i < promises.length; i++) {
        promise = promises[i], goog.Promise.resolveThen_(promise, onFulfill, goog.partial(onReject, i));
      }
    } else {
      resolve(void 0);
    }
  });
};
goog.Promise.withResolver = function() {
  var resolve, reject, promise = new goog.Promise(function(rs, rj) {
    resolve = rs;
    reject = rj;
  });
  return new goog.Promise.Resolver_(promise, resolve, reject);
};
goog.Promise.prototype.then = function(opt_onFulfilled, opt_onRejected, opt_context) {
  null != opt_onFulfilled && goog.asserts.assertFunction(opt_onFulfilled, "opt_onFulfilled should be a function.");
  null != opt_onRejected && goog.asserts.assertFunction(opt_onRejected, "opt_onRejected should be a function. Did you pass opt_context as the second argument instead of the third?");
  goog.Promise.LONG_STACK_TRACES && this.addStackTrace_(Error("then"));
  return this.addChildPromise_(goog.isFunction(opt_onFulfilled) ? opt_onFulfilled : null, goog.isFunction(opt_onRejected) ? opt_onRejected : null, opt_context);
};
goog.Thenable.addImplementation(goog.Promise);
goog.Promise.prototype.thenVoid = function(opt_onFulfilled, opt_onRejected, opt_context) {
  null != opt_onFulfilled && goog.asserts.assertFunction(opt_onFulfilled, "opt_onFulfilled should be a function.");
  null != opt_onRejected && goog.asserts.assertFunction(opt_onRejected, "opt_onRejected should be a function. Did you pass opt_context as the second argument instead of the third?");
  goog.Promise.LONG_STACK_TRACES && this.addStackTrace_(Error("then"));
  this.addCallbackEntry_(goog.Promise.getCallbackEntry_(opt_onFulfilled || goog.nullFunction, opt_onRejected || null, opt_context));
};
goog.Promise.prototype.thenAlways = function(onSettled, opt_context) {
  goog.Promise.LONG_STACK_TRACES && this.addStackTrace_(Error("thenAlways"));
  var entry = goog.Promise.getCallbackEntry_(onSettled, onSettled, opt_context);
  entry.always = !0;
  this.addCallbackEntry_(entry);
  return this;
};
goog.Promise.prototype.thenCatch = function(onRejected, opt_context) {
  goog.Promise.LONG_STACK_TRACES && this.addStackTrace_(Error("thenCatch"));
  return this.addChildPromise_(null, onRejected, opt_context);
};
goog.Promise.prototype.cancel = function(opt_message) {
  if (this.state_ == goog.Promise.State_.PENDING) {
    var err = new goog.Promise.CancellationError(opt_message);
    goog.async.run(function() {
      this.cancelInternal_(err);
    }, this);
  }
};
goog.Promise.prototype.cancelInternal_ = function(err) {
  this.state_ == goog.Promise.State_.PENDING && (this.parent_ ? (this.parent_.cancelChild_(this, err), this.parent_ = null) : this.resolve_(goog.Promise.State_.REJECTED, err));
};
goog.Promise.prototype.cancelChild_ = function(childPromise, err) {
  if (this.callbackEntries_) {
    for (var childCount = 0, childEntry = null, beforeChildEntry = null, entry = this.callbackEntries_; entry && (entry.always || (childCount++, entry.child == childPromise && (childEntry = entry), !(childEntry && 1 < childCount))); entry = entry.next) {
      childEntry || (beforeChildEntry = entry);
    }
    childEntry && (this.state_ == goog.Promise.State_.PENDING && 1 == childCount ? this.cancelInternal_(err) : (beforeChildEntry ? this.removeEntryAfter_(beforeChildEntry) : this.popEntry_(), this.executeCallback_(childEntry, goog.Promise.State_.REJECTED, err)));
  }
};
goog.Promise.prototype.addCallbackEntry_ = function(callbackEntry) {
  this.hasEntry_() || this.state_ != goog.Promise.State_.FULFILLED && this.state_ != goog.Promise.State_.REJECTED || this.scheduleCallbacks_();
  this.queueEntry_(callbackEntry);
};
goog.Promise.prototype.addChildPromise_ = function(onFulfilled, onRejected, opt_context) {
  var callbackEntry = goog.Promise.getCallbackEntry_(null, null, null);
  callbackEntry.child = new goog.Promise(function(resolve, reject) {
    callbackEntry.onFulfilled = onFulfilled ? function(value) {
      try {
        var result = onFulfilled.call(opt_context, value);
        resolve(result);
      } catch (err) {
        reject(err);
      }
    } : resolve;
    callbackEntry.onRejected = onRejected ? function(reason) {
      try {
        var result = onRejected.call(opt_context, reason);
        void 0 === result && reason instanceof goog.Promise.CancellationError ? reject(reason) : resolve(result);
      } catch (err) {
        reject(err);
      }
    } : reject;
  });
  callbackEntry.child.parent_ = this;
  this.addCallbackEntry_(callbackEntry);
  return callbackEntry.child;
};
goog.Promise.prototype.unblockAndFulfill_ = function(value) {
  goog.asserts.assert(this.state_ == goog.Promise.State_.BLOCKED);
  this.state_ = goog.Promise.State_.PENDING;
  this.resolve_(goog.Promise.State_.FULFILLED, value);
};
goog.Promise.prototype.unblockAndReject_ = function(reason) {
  goog.asserts.assert(this.state_ == goog.Promise.State_.BLOCKED);
  this.state_ = goog.Promise.State_.PENDING;
  this.resolve_(goog.Promise.State_.REJECTED, reason);
};
goog.Promise.prototype.resolve_ = function(state, x) {
  this.state_ == goog.Promise.State_.PENDING && (this === x && (state = goog.Promise.State_.REJECTED, x = new TypeError("Promise cannot resolve to itself")), this.state_ = goog.Promise.State_.BLOCKED, goog.Promise.maybeThen_(x, this.unblockAndFulfill_, this.unblockAndReject_, this) || (this.result_ = x, this.state_ = state, this.parent_ = null, this.scheduleCallbacks_(), state != goog.Promise.State_.REJECTED || x instanceof goog.Promise.CancellationError || goog.Promise.addUnhandledRejection_(this, 
  x)));
};
goog.Promise.maybeThen_ = function(value, onFulfilled, onRejected, context) {
  if (value instanceof goog.Promise) {
    return value.thenVoid(onFulfilled, onRejected, context), !0;
  }
  if (goog.Thenable.isImplementedBy(value)) {
    return value.then(onFulfilled, onRejected, context), !0;
  }
  if (goog.isObject(value)) {
    try {
      var then = value.then;
      if (goog.isFunction(then)) {
        return goog.Promise.tryThen_(value, then, onFulfilled, onRejected, context), !0;
      }
    } catch (e) {
      return onRejected.call(context, e), !0;
    }
  }
  return !1;
};
goog.Promise.tryThen_ = function(thenable, then, onFulfilled, onRejected, context) {
  var called = !1, resolve = function(value) {
    called || (called = !0, onFulfilled.call(context, value));
  }, reject = function(reason) {
    called || (called = !0, onRejected.call(context, reason));
  };
  try {
    then.call(thenable, resolve, reject);
  } catch (e) {
    reject(e);
  }
};
goog.Promise.prototype.scheduleCallbacks_ = function() {
  this.executing_ || (this.executing_ = !0, goog.async.run(this.executeCallbacks_, this));
};
goog.Promise.prototype.hasEntry_ = function() {
  return !!this.callbackEntries_;
};
goog.Promise.prototype.queueEntry_ = function(entry) {
  goog.asserts.assert(null != entry.onFulfilled);
  this.callbackEntriesTail_ ? this.callbackEntriesTail_.next = entry : this.callbackEntries_ = entry;
  this.callbackEntriesTail_ = entry;
};
goog.Promise.prototype.popEntry_ = function() {
  var entry = null;
  this.callbackEntries_ && (entry = this.callbackEntries_, this.callbackEntries_ = entry.next, entry.next = null);
  this.callbackEntries_ || (this.callbackEntriesTail_ = null);
  null != entry && goog.asserts.assert(null != entry.onFulfilled);
  return entry;
};
goog.Promise.prototype.removeEntryAfter_ = function(previous) {
  goog.asserts.assert(this.callbackEntries_);
  goog.asserts.assert(null != previous);
  previous.next == this.callbackEntriesTail_ && (this.callbackEntriesTail_ = previous);
  previous.next = previous.next.next;
};
goog.Promise.prototype.executeCallbacks_ = function() {
  for (var entry = null; entry = this.popEntry_();) {
    goog.Promise.LONG_STACK_TRACES && this.currentStep_++, this.executeCallback_(entry, this.state_, this.result_);
  }
  this.executing_ = !1;
};
goog.Promise.prototype.executeCallback_ = function(callbackEntry, state, result) {
  state == goog.Promise.State_.REJECTED && callbackEntry.onRejected && !callbackEntry.always && this.removeUnhandledRejection_();
  if (callbackEntry.child) {
    callbackEntry.child.parent_ = null, goog.Promise.invokeCallback_(callbackEntry, state, result);
  } else {
    try {
      callbackEntry.always ? callbackEntry.onFulfilled.call(callbackEntry.context) : goog.Promise.invokeCallback_(callbackEntry, state, result);
    } catch (err) {
      goog.Promise.handleRejection_.call(null, err);
    }
  }
  goog.Promise.returnEntry_(callbackEntry);
};
goog.Promise.invokeCallback_ = function(callbackEntry, state, result) {
  state == goog.Promise.State_.FULFILLED ? callbackEntry.onFulfilled.call(callbackEntry.context, result) : callbackEntry.onRejected && callbackEntry.onRejected.call(callbackEntry.context, result);
};
goog.Promise.prototype.addStackTrace_ = function(err) {
  if (goog.Promise.LONG_STACK_TRACES && "string" === typeof err.stack) {
    var trace = err.stack.split("\n", 4)[3], message = err.message;
    message += Array(11 - message.length).join(" ");
    this.stack_.push(message + trace);
  }
};
goog.Promise.prototype.appendLongStack_ = function(err) {
  if (goog.Promise.LONG_STACK_TRACES && err && "string" === typeof err.stack && this.stack_.length) {
    for (var longTrace = ["Promise trace:"], promise = this; promise; promise = promise.parent_) {
      for (var i = this.currentStep_; 0 <= i; i--) {
        longTrace.push(promise.stack_[i]);
      }
      longTrace.push("Value: [" + (promise.state_ == goog.Promise.State_.REJECTED ? "REJECTED" : "FULFILLED") + "] <" + String(promise.result_) + ">");
    }
    err.stack += "\n\n" + longTrace.join("\n");
  }
};
goog.Promise.prototype.removeUnhandledRejection_ = function() {
  if (0 < goog.Promise.UNHANDLED_REJECTION_DELAY) {
    for (var p = this; p && p.unhandledRejectionId_; p = p.parent_) {
      goog.global.clearTimeout(p.unhandledRejectionId_), p.unhandledRejectionId_ = 0;
    }
  } else {
    if (0 == goog.Promise.UNHANDLED_REJECTION_DELAY) {
      for (p = this; p && p.hadUnhandledRejection_; p = p.parent_) {
        p.hadUnhandledRejection_ = !1;
      }
    }
  }
};
goog.Promise.addUnhandledRejection_ = function(promise, reason) {
  0 < goog.Promise.UNHANDLED_REJECTION_DELAY ? promise.unhandledRejectionId_ = goog.global.setTimeout(function() {
    promise.appendLongStack_(reason);
    goog.Promise.handleRejection_.call(null, reason);
  }, goog.Promise.UNHANDLED_REJECTION_DELAY) : 0 == goog.Promise.UNHANDLED_REJECTION_DELAY && (promise.hadUnhandledRejection_ = !0, goog.async.run(function() {
    promise.hadUnhandledRejection_ && (promise.appendLongStack_(reason), goog.Promise.handleRejection_.call(null, reason));
  }));
};
goog.Promise.handleRejection_ = goog.async.throwException;
goog.Promise.setUnhandledRejectionHandler = function(handler) {
  goog.Promise.handleRejection_ = handler;
};
goog.Promise.CancellationError = function(opt_message) {
  goog.debug.Error.call(this, opt_message);
};
goog.inherits(goog.Promise.CancellationError, goog.debug.Error);
goog.Promise.CancellationError.prototype.name = "cancel";
goog.Promise.Resolver_ = function(promise, resolve, reject) {
  this.promise = promise;
  this.resolve = resolve;
  this.reject = reject;
};
goog.Timer = function(opt_interval, opt_timerObject) {
  goog.events.EventTarget.call(this);
  this.interval_ = opt_interval || 1;
  this.timerObject_ = opt_timerObject || goog.Timer.defaultTimerObject;
  this.boundTick_ = goog.bind(this.tick_, this);
  this.last_ = goog.now();
};
goog.inherits(goog.Timer, goog.events.EventTarget);
goog.Timer.MAX_TIMEOUT_ = 2147483647;
goog.Timer.INVALID_TIMEOUT_ID_ = -1;
goog.Timer.prototype.enabled = !1;
goog.Timer.defaultTimerObject = goog.global;
goog.Timer.intervalScale = 0.8;
goog.Timer.prototype.timer_ = null;
goog.Timer.prototype.getInterval = function() {
  return this.interval_;
};
goog.Timer.prototype.setInterval = function(interval) {
  this.interval_ = interval;
  this.timer_ && this.enabled ? (this.stop(), this.start()) : this.timer_ && this.stop();
};
goog.Timer.prototype.tick_ = function() {
  if (this.enabled) {
    var elapsed = goog.now() - this.last_;
    0 < elapsed && elapsed < this.interval_ * goog.Timer.intervalScale ? this.timer_ = this.timerObject_.setTimeout(this.boundTick_, this.interval_ - elapsed) : (this.timer_ && (this.timerObject_.clearTimeout(this.timer_), this.timer_ = null), this.dispatchTick(), this.enabled && (this.stop(), this.start()));
  }
};
goog.Timer.prototype.dispatchTick = function() {
  this.dispatchEvent(goog.Timer.TICK);
};
goog.Timer.prototype.start = function() {
  this.enabled = !0;
  this.timer_ || (this.timer_ = this.timerObject_.setTimeout(this.boundTick_, this.interval_), this.last_ = goog.now());
};
goog.Timer.prototype.stop = function() {
  this.enabled = !1;
  this.timer_ && (this.timerObject_.clearTimeout(this.timer_), this.timer_ = null);
};
goog.Timer.prototype.disposeInternal = function() {
  goog.Timer.superClass_.disposeInternal.call(this);
  this.stop();
  delete this.timerObject_;
};
goog.Timer.TICK = "tick";
goog.Timer.callOnce = function(listener, opt_delay, opt_handler) {
  if (goog.isFunction(listener)) {
    opt_handler && (listener = goog.bind(listener, opt_handler));
  } else {
    if (listener && "function" == typeof listener.handleEvent) {
      listener = goog.bind(listener.handleEvent, listener);
    } else {
      throw Error("Invalid listener argument");
    }
  }
  return Number(opt_delay) > goog.Timer.MAX_TIMEOUT_ ? goog.Timer.INVALID_TIMEOUT_ID_ : goog.Timer.defaultTimerObject.setTimeout(listener, opt_delay || 0);
};
goog.Timer.clear = function(timerId) {
  goog.Timer.defaultTimerObject.clearTimeout(timerId);
};
goog.Timer.promise = function(delay, opt_result) {
  var timerKey = null;
  return (new goog.Promise(function(resolve, reject) {
    timerKey = goog.Timer.callOnce(function() {
      resolve(opt_result);
    }, delay);
    timerKey == goog.Timer.INVALID_TIMEOUT_ID_ && reject(Error("Failed to schedule timer."));
  })).thenCatch(function(error) {
    goog.Timer.clear(timerKey);
    throw error;
  });
};
var module$contents$goog$async$Throttle_Throttle = function(listener, interval, handler) {
  goog.Disposable.call(this);
  this.listener_ = null != handler ? listener.bind(handler) : listener;
  this.interval_ = interval;
  this.args_ = null;
  this.shouldFire_ = !1;
  this.pauseCount_ = 0;
  this.timer_ = null;
};
$jscomp.inherits(module$contents$goog$async$Throttle_Throttle, goog.Disposable);
module$contents$goog$async$Throttle_Throttle.prototype.fire = function(var_args) {
  this.args_ = arguments;
  this.timer_ || this.pauseCount_ ? this.shouldFire_ = !0 : this.doAction_();
};
module$contents$goog$async$Throttle_Throttle.prototype.stop = function() {
  this.timer_ && (goog.Timer.clear(this.timer_), this.timer_ = null, this.shouldFire_ = !1, this.args_ = null);
};
module$contents$goog$async$Throttle_Throttle.prototype.pause = function() {
  this.pauseCount_++;
};
module$contents$goog$async$Throttle_Throttle.prototype.resume = function() {
  this.pauseCount_--;
  this.pauseCount_ || !this.shouldFire_ || this.timer_ || (this.shouldFire_ = !1, this.doAction_());
};
module$contents$goog$async$Throttle_Throttle.prototype.disposeInternal = function() {
  goog.Disposable.prototype.disposeInternal.call(this);
  this.stop();
};
module$contents$goog$async$Throttle_Throttle.prototype.onTimer_ = function() {
  this.timer_ = null;
  this.shouldFire_ && !this.pauseCount_ && (this.shouldFire_ = !1, this.doAction_());
};
module$contents$goog$async$Throttle_Throttle.prototype.doAction_ = function() {
  var $jscomp$this = this;
  this.timer_ = goog.Timer.callOnce(function() {
    return $jscomp$this.onTimer_();
  }, this.interval_);
  var args = this.args_;
  this.args_ = null;
  this.listener_.apply(null, args);
};
goog.async.Throttle = module$contents$goog$async$Throttle_Throttle;
/*
 Portions of this code are from MochiKit, received by
 The Closure Authors under the MIT license. All other code is Copyright
 2005-2009 The Closure Authors. All Rights Reserved.
*/
goog.async.Deferred = function(opt_onCancelFunction, opt_defaultScope) {
  this.sequence_ = [];
  this.onCancelFunction_ = opt_onCancelFunction;
  this.defaultScope_ = opt_defaultScope || null;
  this.hadError_ = this.fired_ = !1;
  this.result_ = void 0;
  this.silentlyCanceled_ = this.blocking_ = this.blocked_ = !1;
  this.unhandledErrorId_ = 0;
  this.parent_ = null;
  this.branches_ = 0;
  if (goog.async.Deferred.LONG_STACK_TRACES && (this.constructorStack_ = null, Error.captureStackTrace)) {
    var target = {stack:""};
    Error.captureStackTrace(target, goog.async.Deferred);
    "string" == typeof target.stack && (this.constructorStack_ = target.stack.replace(/^[^\n]*\n/, ""));
  }
};
goog.async.Deferred.STRICT_ERRORS = !1;
goog.async.Deferred.LONG_STACK_TRACES = !1;
goog.async.Deferred.prototype.cancel = function(opt_deepCancel) {
  if (this.hasFired()) {
    this.result_ instanceof goog.async.Deferred && this.result_.cancel();
  } else {
    if (this.parent_) {
      var parent = this.parent_;
      delete this.parent_;
      opt_deepCancel ? parent.cancel(opt_deepCancel) : parent.branchCancel_();
    }
    this.onCancelFunction_ ? this.onCancelFunction_.call(this.defaultScope_, this) : this.silentlyCanceled_ = !0;
    this.hasFired() || this.errback(new goog.async.Deferred.CanceledError(this));
  }
};
goog.async.Deferred.prototype.branchCancel_ = function() {
  this.branches_--;
  0 >= this.branches_ && this.cancel();
};
goog.async.Deferred.prototype.continue_ = function(isSuccess, res) {
  this.blocked_ = !1;
  this.updateResult_(isSuccess, res);
};
goog.async.Deferred.prototype.updateResult_ = function(isSuccess, res) {
  this.fired_ = !0;
  this.result_ = res;
  this.hadError_ = !isSuccess;
  this.fire_();
};
goog.async.Deferred.prototype.check_ = function() {
  if (this.hasFired()) {
    if (!this.silentlyCanceled_) {
      throw new goog.async.Deferred.AlreadyCalledError(this);
    }
    this.silentlyCanceled_ = !1;
  }
};
goog.async.Deferred.prototype.callback = function(opt_result) {
  this.check_();
  this.assertNotDeferred_(opt_result);
  this.updateResult_(!0, opt_result);
};
goog.async.Deferred.prototype.errback = function(opt_result) {
  this.check_();
  this.assertNotDeferred_(opt_result);
  this.makeStackTraceLong_(opt_result);
  this.updateResult_(!1, opt_result);
};
goog.async.Deferred.prototype.makeStackTraceLong_ = function(error) {
  goog.async.Deferred.LONG_STACK_TRACES && this.constructorStack_ && goog.isObject(error) && error.stack && /^[^\n]+(\n   [^\n]+)+/.test(error.stack) && (error.stack = error.stack + "\nDEFERRED OPERATION:\n" + this.constructorStack_);
};
goog.async.Deferred.prototype.assertNotDeferred_ = function(obj) {
  goog.asserts.assert(!(obj instanceof goog.async.Deferred), "An execution sequence may not be initiated with a blocking Deferred.");
};
goog.async.Deferred.prototype.addCallback = function(cb, opt_scope) {
  return this.addCallbacks(cb, null, opt_scope);
};
goog.async.Deferred.prototype.addErrback = function(eb, opt_scope) {
  return this.addCallbacks(null, eb, opt_scope);
};
goog.async.Deferred.prototype.addBoth = function(f, opt_scope) {
  return this.addCallbacks(f, f, opt_scope);
};
goog.async.Deferred.prototype.addFinally = function(f, opt_scope) {
  return this.addCallbacks(f, function(err) {
    var result = f.call(this, err);
    if (void 0 === result) {
      throw err;
    }
    return result;
  }, opt_scope);
};
goog.async.Deferred.prototype.addCallbacks = function(cb, eb, opt_scope) {
  goog.asserts.assert(!this.blocking_, "Blocking Deferreds can not be re-used");
  this.sequence_.push([cb, eb, opt_scope]);
  this.hasFired() && this.fire_();
  return this;
};
goog.async.Deferred.prototype.then = function(opt_onFulfilled, opt_onRejected, opt_context) {
  var resolve, reject, promise = new goog.Promise(function(res, rej) {
    resolve = res;
    reject = rej;
  });
  this.addCallbacks(resolve, function(reason) {
    reason instanceof goog.async.Deferred.CanceledError ? promise.cancel() : reject(reason);
  });
  return promise.then(opt_onFulfilled, opt_onRejected, opt_context);
};
goog.Thenable.addImplementation(goog.async.Deferred);
goog.async.Deferred.prototype.chainDeferred = function(otherDeferred) {
  this.addCallbacks(otherDeferred.callback, otherDeferred.errback, otherDeferred);
  return this;
};
goog.async.Deferred.prototype.awaitDeferred = function(otherDeferred) {
  return otherDeferred instanceof goog.async.Deferred ? this.addCallback(goog.bind(otherDeferred.branch, otherDeferred)) : this.addCallback(function() {
    return otherDeferred;
  });
};
goog.async.Deferred.prototype.branch = function(opt_propagateCancel) {
  var d = new goog.async.Deferred;
  this.chainDeferred(d);
  opt_propagateCancel && (d.parent_ = this, this.branches_++);
  return d;
};
goog.async.Deferred.prototype.hasFired = function() {
  return this.fired_;
};
goog.async.Deferred.prototype.isError = function(res) {
  return res instanceof Error;
};
goog.async.Deferred.prototype.hasErrback_ = function() {
  return goog.array.some(this.sequence_, function(sequenceRow) {
    return goog.isFunction(sequenceRow[1]);
  });
};
goog.async.Deferred.prototype.getLastValueForMigration = function() {
  return this.hasFired() && !this.hadError_ ? this.result_ : void 0;
};
goog.async.Deferred.prototype.fire_ = function() {
  this.unhandledErrorId_ && this.hasFired() && this.hasErrback_() && (goog.async.Deferred.unscheduleError_(this.unhandledErrorId_), this.unhandledErrorId_ = 0);
  this.parent_ && (this.parent_.branches_--, delete this.parent_);
  for (var res = this.result_, unhandledException = !1, isNewlyBlocked = !1; this.sequence_.length && !this.blocked_;) {
    var sequenceEntry = this.sequence_.shift(), callback = sequenceEntry[0], errback = sequenceEntry[1], scope = sequenceEntry[2], f = this.hadError_ ? errback : callback;
    if (f) {
      try {
        var ret = f.call(scope || this.defaultScope_, res);
        void 0 !== ret && (this.hadError_ = this.hadError_ && (ret == res || this.isError(ret)), this.result_ = res = ret);
        if (goog.Thenable.isImplementedBy(res) || "function" === typeof goog.global.Promise && res instanceof goog.global.Promise) {
          this.blocked_ = isNewlyBlocked = !0;
        }
      } catch (ex) {
        res = ex, this.hadError_ = !0, this.makeStackTraceLong_(res), this.hasErrback_() || (unhandledException = !0);
      }
    }
  }
  this.result_ = res;
  if (isNewlyBlocked) {
    var onCallback = goog.bind(this.continue_, this, !0), onErrback = goog.bind(this.continue_, this, !1);
    res instanceof goog.async.Deferred ? (res.addCallbacks(onCallback, onErrback), res.blocking_ = !0) : res.then(onCallback, onErrback);
  } else {
    !goog.async.Deferred.STRICT_ERRORS || !this.isError(res) || res instanceof goog.async.Deferred.CanceledError || (unhandledException = this.hadError_ = !0);
  }
  unhandledException && (this.unhandledErrorId_ = goog.async.Deferred.scheduleError_(res));
};
goog.async.Deferred.succeed = function(opt_result) {
  var d = new goog.async.Deferred;
  d.callback(opt_result);
  return d;
};
goog.async.Deferred.fromPromise = function(promise) {
  var d = new goog.async.Deferred;
  promise.then(function(value) {
    d.callback(value);
  }, function(error) {
    d.errback(error);
  });
  return d;
};
goog.async.Deferred.fail = function(res) {
  var d = new goog.async.Deferred;
  d.errback(res);
  return d;
};
goog.async.Deferred.canceled = function() {
  var d = new goog.async.Deferred;
  d.cancel();
  return d;
};
goog.async.Deferred.when = function(value, callback, opt_scope) {
  return value instanceof goog.async.Deferred ? value.branch(!0).addCallback(callback, opt_scope) : goog.async.Deferred.succeed(value).addCallback(callback, opt_scope);
};
goog.async.Deferred.AlreadyCalledError = function(deferred) {
  goog.debug.Error.call(this);
  this.deferred = deferred;
};
goog.inherits(goog.async.Deferred.AlreadyCalledError, goog.debug.Error);
goog.async.Deferred.AlreadyCalledError.prototype.message = "Deferred has already fired";
goog.async.Deferred.AlreadyCalledError.prototype.name = "AlreadyCalledError";
goog.async.Deferred.CanceledError = function(deferred) {
  goog.debug.Error.call(this);
  this.deferred = deferred;
};
goog.inherits(goog.async.Deferred.CanceledError, goog.debug.Error);
goog.async.Deferred.CanceledError.prototype.message = "Deferred was canceled";
goog.async.Deferred.CanceledError.prototype.name = "CanceledError";
goog.async.Deferred.Error_ = function(error) {
  this.id_ = goog.global.setTimeout(goog.bind(this.throwError, this), 0);
  this.error_ = error;
};
goog.async.Deferred.Error_.prototype.throwError = function() {
  goog.asserts.assert(goog.async.Deferred.errorMap_[this.id_], "Cannot throw an error that is not scheduled.");
  delete goog.async.Deferred.errorMap_[this.id_];
  throw this.error_;
};
goog.async.Deferred.Error_.prototype.resetTimer = function() {
  goog.global.clearTimeout(this.id_);
};
goog.async.Deferred.errorMap_ = {};
goog.async.Deferred.scheduleError_ = function(error) {
  var deferredError = new goog.async.Deferred.Error_(error);
  goog.async.Deferred.errorMap_[deferredError.id_] = deferredError;
  return deferredError.id_;
};
goog.async.Deferred.unscheduleError_ = function(id) {
  var error = goog.async.Deferred.errorMap_[id];
  error && (error.resetTimer(), delete goog.async.Deferred.errorMap_[id]);
};
goog.async.Deferred.assertNoErrors = function() {
  var map = goog.async.Deferred.errorMap_, key;
  for (key in map) {
    var error = map[key];
    error.resetTimer();
    error.throwError();
  }
};
goog.net = {};
goog.net.jsloader = {};
goog.net.jsloader.GLOBAL_VERIFY_OBJS_ = "closure_verification";
goog.net.jsloader.DEFAULT_TIMEOUT = 5000;
goog.net.jsloader.scriptsToLoad_ = [];
goog.net.jsloader.safeLoadMany = function(trustedUris, opt_options) {
  if (!trustedUris.length) {
    return goog.async.Deferred.succeed(null);
  }
  var isAnotherModuleLoading = goog.net.jsloader.scriptsToLoad_.length;
  goog.array.extend(goog.net.jsloader.scriptsToLoad_, trustedUris);
  if (isAnotherModuleLoading) {
    return goog.net.jsloader.scriptLoadingDeferred_;
  }
  trustedUris = goog.net.jsloader.scriptsToLoad_;
  var popAndLoadNextScript = function() {
    var trustedUri = trustedUris.shift(), deferred = goog.net.jsloader.safeLoad(trustedUri, opt_options);
    trustedUris.length && deferred.addBoth(popAndLoadNextScript);
    return deferred;
  };
  goog.net.jsloader.scriptLoadingDeferred_ = popAndLoadNextScript();
  return goog.net.jsloader.scriptLoadingDeferred_;
};
goog.net.jsloader.safeLoad = function(trustedUri, opt_options) {
  var options = opt_options || {}, doc = options.document || document, uri = goog.html.TrustedResourceUrl.unwrap(trustedUri), script = goog.dom.createElement("SCRIPT"), request = {script_:script, timeout_:void 0}, deferred = new goog.async.Deferred(goog.net.jsloader.cancel_, request), timeout = null, timeoutDuration = null != options.timeout ? options.timeout : goog.net.jsloader.DEFAULT_TIMEOUT;
  0 < timeoutDuration && (timeout = window.setTimeout(function() {
    goog.net.jsloader.cleanup_(script, !0);
    deferred.errback(new goog.net.jsloader.Error(goog.net.jsloader.ErrorCode.TIMEOUT, "Timeout reached for loading script " + uri));
  }, timeoutDuration), request.timeout_ = timeout);
  script.onload = script.onreadystatechange = function() {
    script.readyState && "loaded" != script.readyState && "complete" != script.readyState || (goog.net.jsloader.cleanup_(script, options.cleanupWhenDone || !1, timeout), deferred.callback(null));
  };
  script.onerror = function() {
    goog.net.jsloader.cleanup_(script, !0, timeout);
    deferred.errback(new goog.net.jsloader.Error(goog.net.jsloader.ErrorCode.LOAD_ERROR, "Error while loading script " + uri));
  };
  var properties = options.attributes || {};
  goog.object.extend(properties, {type:"text/javascript", charset:"UTF-8"});
  goog.dom.setProperties(script, properties);
  goog.dom.safe.setScriptSrc(script, trustedUri);
  goog.net.jsloader.getScriptParentElement_(doc).appendChild(script);
  return deferred;
};
goog.net.jsloader.safeLoadAndVerify = function(trustedUri, verificationObjName, options) {
  goog.global[goog.net.jsloader.GLOBAL_VERIFY_OBJS_] || (goog.global[goog.net.jsloader.GLOBAL_VERIFY_OBJS_] = {});
  var verifyObjs = goog.global[goog.net.jsloader.GLOBAL_VERIFY_OBJS_], uri = goog.html.TrustedResourceUrl.unwrap(trustedUri);
  if (void 0 !== verifyObjs[verificationObjName]) {
    return goog.async.Deferred.fail(new goog.net.jsloader.Error(goog.net.jsloader.ErrorCode.VERIFY_OBJECT_ALREADY_EXISTS, "Verification object " + verificationObjName + " already defined."));
  }
  var sendDeferred = goog.net.jsloader.safeLoad(trustedUri, options), deferred = new goog.async.Deferred(goog.bind(sendDeferred.cancel, sendDeferred));
  sendDeferred.addCallback(function() {
    var result = verifyObjs[verificationObjName];
    void 0 !== result ? (deferred.callback(result), delete verifyObjs[verificationObjName]) : deferred.errback(new goog.net.jsloader.Error(goog.net.jsloader.ErrorCode.VERIFY_ERROR, "Script " + uri + " loaded, but verification object " + verificationObjName + " was not defined."));
  });
  sendDeferred.addErrback(function(error) {
    void 0 !== verifyObjs[verificationObjName] && delete verifyObjs[verificationObjName];
    deferred.errback(error);
  });
  return deferred;
};
goog.net.jsloader.getScriptParentElement_ = function(doc) {
  var headElements = goog.dom.getElementsByTagName("HEAD", doc);
  return !headElements || goog.array.isEmpty(headElements) ? doc.documentElement : headElements[0];
};
goog.net.jsloader.cancel_ = function() {
  if (this && this.script_) {
    var scriptNode = this.script_;
    scriptNode && "SCRIPT" == scriptNode.tagName && goog.net.jsloader.cleanup_(scriptNode, !0, this.timeout_);
  }
};
goog.net.jsloader.cleanup_ = function(scriptNode, removeScriptNode, opt_timeout) {
  null != opt_timeout && goog.global.clearTimeout(opt_timeout);
  scriptNode.onload = goog.nullFunction;
  scriptNode.onerror = goog.nullFunction;
  scriptNode.onreadystatechange = goog.nullFunction;
  removeScriptNode && window.setTimeout(function() {
    goog.dom.removeNode(scriptNode);
  }, 0);
};
goog.net.jsloader.ErrorCode = {LOAD_ERROR:0, TIMEOUT:1, VERIFY_ERROR:2, VERIFY_OBJECT_ALREADY_EXISTS:3, };
goog.net.jsloader.Error = function(code, opt_message) {
  var msg = "Jsloader error (code #" + code + ")";
  opt_message && (msg += ": " + opt_message);
  goog.debug.Error.call(this, msg);
  this.code = code;
};
goog.inherits(goog.net.jsloader.Error, goog.debug.Error);
goog.json = {};
goog.json.USE_NATIVE_JSON = !1;
goog.json.TRY_NATIVE_JSON = !1;
goog.json.isValid = function(s) {
  return /^\s*$/.test(s) ? !1 : /^[\],:{}\s\u2028\u2029]*$/.test(s.replace(/\\["\\\/bfnrtu]/g, "@").replace(/(?:"[^"\\\n\r\u2028\u2029\x00-\x08\x0a-\x1f]*"|true|false|null|-?\d+(?:\.\d*)?(?:[eE][+\-]?\d+)?)[\s\u2028\u2029]*(?=:|,|]|}|$)/g, "]").replace(/(?:^|:|,)(?:[\s\u2028\u2029]*\[)+/g, ""));
};
goog.json.errorLogger_ = goog.nullFunction;
goog.json.setErrorLogger = function(errorLogger) {
  goog.json.errorLogger_ = errorLogger;
};
goog.json.parse = goog.json.USE_NATIVE_JSON ? goog.global.JSON.parse : function(s) {
  if (goog.json.TRY_NATIVE_JSON) {
    try {
      return goog.global.JSON.parse(s);
    } catch (ex) {
      var error = ex;
    }
  }
  var o = String(s);
  if (goog.json.isValid(o)) {
    try {
      var result = eval("(" + o + ")");
      error && goog.json.errorLogger_("Invalid JSON: " + o, error);
      return result;
    } catch (ex$23) {
    }
  }
  throw Error("Invalid JSON string: " + o);
};
goog.json.serialize = goog.json.USE_NATIVE_JSON ? goog.global.JSON.stringify : function(object, opt_replacer) {
  return (new goog.json.Serializer(opt_replacer)).serialize(object);
};
goog.json.Serializer = function(opt_replacer) {
  this.replacer_ = opt_replacer;
};
goog.json.Serializer.prototype.serialize = function(object) {
  var sb = [];
  this.serializeInternal(object, sb);
  return sb.join("");
};
goog.json.Serializer.prototype.serializeInternal = function(object, sb) {
  if (null == object) {
    sb.push("null");
  } else {
    if ("object" == typeof object) {
      if (Array.isArray(object)) {
        this.serializeArray(object, sb);
        return;
      }
      if (object instanceof String || object instanceof Number || object instanceof Boolean) {
        object = object.valueOf();
      } else {
        this.serializeObject_(object, sb);
        return;
      }
    }
    switch(typeof object) {
      case "string":
        this.serializeString_(object, sb);
        break;
      case "number":
        this.serializeNumber_(object, sb);
        break;
      case "boolean":
        sb.push(String(object));
        break;
      case "function":
        sb.push("null");
        break;
      default:
        throw Error("Unknown type: " + typeof object);
    }
  }
};
goog.json.Serializer.charToJsonCharCache_ = {'"':'\\"', "\\":"\\\\", "/":"\\/", "\b":"\\b", "\f":"\\f", "\n":"\\n", "\r":"\\r", "\t":"\\t", "\x0B":"\\u000b"};
goog.json.Serializer.charsToReplace_ = /\uffff/.test("\uffff") ? /[\\"\x00-\x1f\x7f-\uffff]/g : /[\\"\x00-\x1f\x7f-\xff]/g;
goog.json.Serializer.prototype.serializeString_ = function(s, sb) {
  sb.push('"', s.replace(goog.json.Serializer.charsToReplace_, function(c) {
    var rv = goog.json.Serializer.charToJsonCharCache_[c];
    rv || (rv = "\\u" + (c.charCodeAt(0) | 65536).toString(16).substr(1), goog.json.Serializer.charToJsonCharCache_[c] = rv);
    return rv;
  }), '"');
};
goog.json.Serializer.prototype.serializeNumber_ = function(n, sb) {
  sb.push(isFinite(n) && !isNaN(n) ? String(n) : "null");
};
goog.json.Serializer.prototype.serializeArray = function(arr, sb) {
  var l = arr.length;
  sb.push("[");
  for (var sep = "", i = 0; i < l; i++) {
    sb.push(sep);
    var value = arr[i];
    this.serializeInternal(this.replacer_ ? this.replacer_.call(arr, String(i), value) : value, sb);
    sep = ",";
  }
  sb.push("]");
};
goog.json.Serializer.prototype.serializeObject_ = function(obj, sb) {
  sb.push("{");
  var sep = "", key;
  for (key in obj) {
    if (Object.prototype.hasOwnProperty.call(obj, key)) {
      var value = obj[key];
      "function" != typeof value && (sb.push(sep), this.serializeString_(key, sb), sb.push(":"), this.serializeInternal(this.replacer_ ? this.replacer_.call(obj, key, value) : value, sb), sep = ",");
    }
  }
  sb.push("}");
};
goog.json.hybrid = {};
goog.json.hybrid.stringify = goog.json.USE_NATIVE_JSON ? goog.global.JSON.stringify : function(obj) {
  if (goog.global.JSON) {
    try {
      return goog.global.JSON.stringify(obj);
    } catch (e) {
    }
  }
  return goog.json.serialize(obj);
};
goog.json.hybrid.parse_ = function(jsonString, fallbackParser) {
  if (goog.global.JSON) {
    try {
      var obj = goog.global.JSON.parse(jsonString);
      goog.asserts.assert("object" == typeof obj);
      return obj;
    } catch (e) {
    }
  }
  return fallbackParser(jsonString);
};
goog.json.hybrid.parse = goog.json.USE_NATIVE_JSON ? goog.global.JSON.parse : function(jsonString) {
  return goog.json.hybrid.parse_(jsonString, goog.json.parse);
};
goog.debug.LogRecord = function(level, msg, loggerName, opt_time, opt_sequenceNumber) {
  this.reset(level, msg, loggerName, opt_time, opt_sequenceNumber);
};
goog.debug.LogRecord.prototype.sequenceNumber_ = 0;
goog.debug.LogRecord.prototype.exception_ = null;
goog.debug.LogRecord.ENABLE_SEQUENCE_NUMBERS = !0;
goog.debug.LogRecord.nextSequenceNumber_ = 0;
goog.debug.LogRecord.prototype.reset = function(level, msg, loggerName, opt_time, opt_sequenceNumber) {
  goog.debug.LogRecord.ENABLE_SEQUENCE_NUMBERS && (this.sequenceNumber_ = "number" == typeof opt_sequenceNumber ? opt_sequenceNumber : goog.debug.LogRecord.nextSequenceNumber_++);
  this.time_ = opt_time || goog.now();
  this.level_ = level;
  this.msg_ = msg;
  this.loggerName_ = loggerName;
  delete this.exception_;
};
goog.debug.LogRecord.prototype.getLoggerName = function() {
  return this.loggerName_;
};
goog.debug.LogRecord.prototype.getException = function() {
  return this.exception_;
};
goog.debug.LogRecord.prototype.setException = function(exception) {
  this.exception_ = exception;
};
goog.debug.LogRecord.prototype.setLoggerName = function(loggerName) {
  this.loggerName_ = loggerName;
};
goog.debug.LogRecord.prototype.getLevel = function() {
  return this.level_;
};
goog.debug.LogRecord.prototype.setLevel = function(level) {
  this.level_ = level;
};
goog.debug.LogRecord.prototype.getMessage = function() {
  return this.msg_;
};
goog.debug.LogRecord.prototype.setMessage = function(msg) {
  this.msg_ = msg;
};
goog.debug.LogRecord.prototype.getMillis = function() {
  return this.time_;
};
goog.debug.LogRecord.prototype.setMillis = function(time) {
  this.time_ = time;
};
goog.debug.LogRecord.prototype.getSequenceNumber = function() {
  return this.sequenceNumber_;
};
goog.debug.LogBuffer = function() {
  goog.asserts.assert(goog.debug.LogBuffer.isBufferingEnabled(), "Cannot use goog.debug.LogBuffer without defining goog.debug.LogBuffer.CAPACITY.");
  this.clear();
};
goog.debug.LogBuffer.getInstance = function() {
  goog.debug.LogBuffer.instance_ || (goog.debug.LogBuffer.instance_ = new goog.debug.LogBuffer);
  return goog.debug.LogBuffer.instance_;
};
goog.debug.LogBuffer.CAPACITY = 0;
goog.debug.LogBuffer.prototype.addRecord = function(level, msg, loggerName) {
  var curIndex = (this.curIndex_ + 1) % goog.debug.LogBuffer.CAPACITY;
  this.curIndex_ = curIndex;
  if (this.isFull_) {
    var ret = this.buffer_[curIndex];
    ret.reset(level, msg, loggerName);
    return ret;
  }
  this.isFull_ = curIndex == goog.debug.LogBuffer.CAPACITY - 1;
  return this.buffer_[curIndex] = new goog.debug.LogRecord(level, msg, loggerName);
};
goog.debug.LogBuffer.isBufferingEnabled = function() {
  return 0 < goog.debug.LogBuffer.CAPACITY;
};
goog.debug.LogBuffer.prototype.clear = function() {
  this.buffer_ = Array(goog.debug.LogBuffer.CAPACITY);
  this.curIndex_ = -1;
  this.isFull_ = !1;
};
goog.debug.LogBuffer.prototype.forEachRecord = function(func) {
  var buffer = this.buffer_;
  if (buffer[0]) {
    var curIndex = this.curIndex_, i = this.isFull_ ? curIndex : -1;
    do {
      i = (i + 1) % goog.debug.LogBuffer.CAPACITY, func(buffer[i]);
    } while (i != curIndex);
  }
};
goog.debug.Logger = function(name) {
  this.name_ = name;
  this.handlers_ = this.children_ = this.level_ = this.parent_ = null;
};
goog.debug.Logger.ROOT_LOGGER_NAME = "";
goog.debug.Logger.ENABLE_HIERARCHY = !0;
goog.debug.Logger.ENABLE_PROFILER_LOGGING = !1;
goog.debug.Logger.ENABLE_HIERARCHY || (goog.debug.Logger.rootHandlers_ = []);
goog.debug.Logger.Level = function(name, value) {
  this.name = name;
  this.value = value;
};
goog.debug.Logger.Level.prototype.toString = function() {
  return this.name;
};
goog.debug.Logger.Level.OFF = new goog.debug.Logger.Level("OFF", Infinity);
goog.debug.Logger.Level.SHOUT = new goog.debug.Logger.Level("SHOUT", 1200);
goog.debug.Logger.Level.SEVERE = new goog.debug.Logger.Level("SEVERE", 1000);
goog.debug.Logger.Level.WARNING = new goog.debug.Logger.Level("WARNING", 900);
goog.debug.Logger.Level.INFO = new goog.debug.Logger.Level("INFO", 800);
goog.debug.Logger.Level.CONFIG = new goog.debug.Logger.Level("CONFIG", 700);
goog.debug.Logger.Level.FINE = new goog.debug.Logger.Level("FINE", 500);
goog.debug.Logger.Level.FINER = new goog.debug.Logger.Level("FINER", 400);
goog.debug.Logger.Level.FINEST = new goog.debug.Logger.Level("FINEST", 300);
goog.debug.Logger.Level.ALL = new goog.debug.Logger.Level("ALL", 0);
goog.debug.Logger.Level.PREDEFINED_LEVELS = [goog.debug.Logger.Level.OFF, goog.debug.Logger.Level.SHOUT, goog.debug.Logger.Level.SEVERE, goog.debug.Logger.Level.WARNING, goog.debug.Logger.Level.INFO, goog.debug.Logger.Level.CONFIG, goog.debug.Logger.Level.FINE, goog.debug.Logger.Level.FINER, goog.debug.Logger.Level.FINEST, goog.debug.Logger.Level.ALL];
goog.debug.Logger.Level.predefinedLevelsCache_ = null;
goog.debug.Logger.Level.createPredefinedLevelsCache_ = function() {
  goog.debug.Logger.Level.predefinedLevelsCache_ = {};
  for (var i = 0, level; level = goog.debug.Logger.Level.PREDEFINED_LEVELS[i]; i++) {
    goog.debug.Logger.Level.predefinedLevelsCache_[level.value] = level, goog.debug.Logger.Level.predefinedLevelsCache_[level.name] = level;
  }
};
goog.debug.Logger.Level.getPredefinedLevel = function(name) {
  goog.debug.Logger.Level.predefinedLevelsCache_ || goog.debug.Logger.Level.createPredefinedLevelsCache_();
  return goog.debug.Logger.Level.predefinedLevelsCache_[name] || null;
};
goog.debug.Logger.Level.getPredefinedLevelByValue = function(value) {
  goog.debug.Logger.Level.predefinedLevelsCache_ || goog.debug.Logger.Level.createPredefinedLevelsCache_();
  if (value in goog.debug.Logger.Level.predefinedLevelsCache_) {
    return goog.debug.Logger.Level.predefinedLevelsCache_[value];
  }
  for (var i = 0; i < goog.debug.Logger.Level.PREDEFINED_LEVELS.length; ++i) {
    var level = goog.debug.Logger.Level.PREDEFINED_LEVELS[i];
    if (level.value <= value) {
      return level;
    }
  }
  return null;
};
goog.debug.Logger.getLogger = function(name) {
  return goog.debug.LogManager.getLogger(name);
};
goog.debug.Logger.logToProfilers = function(msg) {
  if (goog.debug.Logger.ENABLE_PROFILER_LOGGING) {
    var msWriteProfilerMark = goog.global.msWriteProfilerMark;
    if (msWriteProfilerMark) {
      msWriteProfilerMark(msg);
    } else {
      var console = goog.global.console;
      console && console.timeStamp && console.timeStamp(msg);
    }
  }
};
goog.debug.Logger.prototype.getName = function() {
  return this.name_;
};
goog.debug.Logger.prototype.addHandler = function(handler) {
  goog.debug.LOGGING_ENABLED && (goog.debug.Logger.ENABLE_HIERARCHY ? (this.handlers_ || (this.handlers_ = []), this.handlers_.push(handler)) : (goog.asserts.assert(!this.name_, "Cannot call addHandler on a non-root logger when goog.debug.Logger.ENABLE_HIERARCHY is false."), goog.debug.Logger.rootHandlers_.push(handler)));
};
goog.debug.Logger.prototype.removeHandler = function(handler) {
  if (goog.debug.LOGGING_ENABLED) {
    var handlers = goog.debug.Logger.ENABLE_HIERARCHY ? this.handlers_ : goog.debug.Logger.rootHandlers_;
    return !!handlers && goog.array.remove(handlers, handler);
  }
  return !1;
};
goog.debug.Logger.prototype.getParent = function() {
  return this.parent_;
};
goog.debug.Logger.prototype.getChildren = function() {
  this.children_ || (this.children_ = {});
  return this.children_;
};
goog.debug.Logger.prototype.setLevel = function(level) {
  goog.debug.LOGGING_ENABLED && (goog.debug.Logger.ENABLE_HIERARCHY ? this.level_ = level : (goog.asserts.assert(!this.name_, "Cannot call setLevel() on a non-root logger when goog.debug.Logger.ENABLE_HIERARCHY is false."), goog.debug.Logger.rootLevel_ = level));
};
goog.debug.Logger.prototype.getLevel = function() {
  return goog.debug.LOGGING_ENABLED ? this.level_ : goog.debug.Logger.Level.OFF;
};
goog.debug.Logger.prototype.getEffectiveLevel = function() {
  if (!goog.debug.LOGGING_ENABLED) {
    return goog.debug.Logger.Level.OFF;
  }
  if (!goog.debug.Logger.ENABLE_HIERARCHY) {
    return goog.debug.Logger.rootLevel_;
  }
  if (this.level_) {
    return this.level_;
  }
  if (this.parent_) {
    return this.parent_.getEffectiveLevel();
  }
  goog.asserts.fail("Root logger has no level set.");
  return null;
};
goog.debug.Logger.prototype.isLoggable = function(level) {
  return goog.debug.LOGGING_ENABLED && level.value >= this.getEffectiveLevel().value;
};
goog.debug.Logger.prototype.log = function(level, msg, opt_exception) {
  goog.debug.LOGGING_ENABLED && this.isLoggable(level) && (goog.isFunction(msg) && (msg = msg()), this.doLogRecord_(this.getLogRecord(level, msg, opt_exception)));
};
goog.debug.Logger.prototype.getLogRecord = function(level, msg, opt_exception) {
  var logRecord = goog.debug.LogBuffer.isBufferingEnabled() ? goog.debug.LogBuffer.getInstance().addRecord(level, msg, this.name_) : new goog.debug.LogRecord(level, String(msg), this.name_);
  opt_exception && logRecord.setException(opt_exception);
  return logRecord;
};
goog.debug.Logger.prototype.shout = function(msg, opt_exception) {
  goog.debug.LOGGING_ENABLED && this.log(goog.debug.Logger.Level.SHOUT, msg, opt_exception);
};
goog.debug.Logger.prototype.severe = function(msg, opt_exception) {
  goog.debug.LOGGING_ENABLED && this.log(goog.debug.Logger.Level.SEVERE, msg, opt_exception);
};
goog.debug.Logger.prototype.warning = function(msg, opt_exception) {
  goog.debug.LOGGING_ENABLED && this.log(goog.debug.Logger.Level.WARNING, msg, opt_exception);
};
goog.debug.Logger.prototype.info = function(msg, opt_exception) {
  goog.debug.LOGGING_ENABLED && this.log(goog.debug.Logger.Level.INFO, msg, opt_exception);
};
goog.debug.Logger.prototype.config = function(msg, opt_exception) {
  goog.debug.LOGGING_ENABLED && this.log(goog.debug.Logger.Level.CONFIG, msg, opt_exception);
};
goog.debug.Logger.prototype.fine = function(msg, opt_exception) {
  goog.debug.LOGGING_ENABLED && this.log(goog.debug.Logger.Level.FINE, msg, opt_exception);
};
goog.debug.Logger.prototype.finer = function(msg, opt_exception) {
  goog.debug.LOGGING_ENABLED && this.log(goog.debug.Logger.Level.FINER, msg, opt_exception);
};
goog.debug.Logger.prototype.finest = function(msg, opt_exception) {
  goog.debug.LOGGING_ENABLED && this.log(goog.debug.Logger.Level.FINEST, msg, opt_exception);
};
goog.debug.Logger.prototype.logRecord = function(logRecord) {
  goog.debug.LOGGING_ENABLED && this.isLoggable(logRecord.getLevel()) && this.doLogRecord_(logRecord);
};
goog.debug.Logger.prototype.doLogRecord_ = function(logRecord) {
  goog.debug.Logger.ENABLE_PROFILER_LOGGING && goog.debug.Logger.logToProfilers("log:" + logRecord.getMessage());
  if (goog.debug.Logger.ENABLE_HIERARCHY) {
    for (var target = this; target;) {
      target.callPublish_(logRecord), target = target.getParent();
    }
  } else {
    for (var i = 0, handler; handler = goog.debug.Logger.rootHandlers_[i++];) {
      handler(logRecord);
    }
  }
};
goog.debug.Logger.prototype.callPublish_ = function(logRecord) {
  if (this.handlers_) {
    for (var i = 0, handler; handler = this.handlers_[i]; i++) {
      handler(logRecord);
    }
  }
};
goog.debug.Logger.prototype.setParent_ = function(parent) {
  this.parent_ = parent;
};
goog.debug.Logger.prototype.addChild_ = function(name, logger) {
  this.getChildren()[name] = logger;
};
goog.debug.LogManager = {};
goog.debug.LogManager.loggers_ = {};
goog.debug.LogManager.rootLogger_ = null;
goog.debug.LogManager.initialize = function() {
  goog.debug.LogManager.rootLogger_ || (goog.debug.LogManager.rootLogger_ = new goog.debug.Logger(goog.debug.Logger.ROOT_LOGGER_NAME), goog.debug.LogManager.loggers_[goog.debug.Logger.ROOT_LOGGER_NAME] = goog.debug.LogManager.rootLogger_, goog.debug.LogManager.rootLogger_.setLevel(goog.debug.Logger.Level.CONFIG));
};
goog.debug.LogManager.getLoggers = function() {
  return goog.debug.LogManager.loggers_;
};
goog.debug.LogManager.getRoot = function() {
  goog.debug.LogManager.initialize();
  return goog.debug.LogManager.rootLogger_;
};
goog.debug.LogManager.getLogger = function(name) {
  goog.debug.LogManager.initialize();
  return goog.debug.LogManager.loggers_[name] || goog.debug.LogManager.createLogger_(name);
};
goog.debug.LogManager.createFunctionForCatchErrors = function(opt_logger) {
  return function(info) {
    (opt_logger || goog.debug.LogManager.getRoot()).severe("Error: " + info.message + " (" + info.fileName + " @ Line: " + info.line + ")");
  };
};
goog.debug.LogManager.createLogger_ = function(name) {
  var logger = new goog.debug.Logger(name);
  if (goog.debug.Logger.ENABLE_HIERARCHY) {
    var lastDotIndex = name.lastIndexOf("."), leafName = name.substr(lastDotIndex + 1), parentLogger = goog.debug.LogManager.getLogger(name.substr(0, lastDotIndex));
    parentLogger.addChild_(leafName, logger);
    logger.setParent_(parentLogger);
  }
  return goog.debug.LogManager.loggers_[name] = logger;
};
goog.log = {};
goog.log.ENABLED = goog.debug.LOGGING_ENABLED;
goog.log.ROOT_LOGGER_NAME = goog.debug.Logger.ROOT_LOGGER_NAME;
goog.log.Logger = goog.debug.Logger;
goog.log.Level = goog.debug.Logger.Level;
goog.log.LogRecord = goog.debug.LogRecord;
goog.log.getLogger = function(name, opt_level) {
  if (goog.log.ENABLED) {
    var logger = goog.debug.LogManager.getLogger(name);
    opt_level && logger && logger.setLevel(opt_level);
    return logger;
  }
  return null;
};
goog.log.addHandler = function(logger, handler) {
  goog.log.ENABLED && logger && logger.addHandler(handler);
};
goog.log.removeHandler = function(logger, handler) {
  return goog.log.ENABLED && logger ? logger.removeHandler(handler) : !1;
};
goog.log.log = function(logger, level, msg, opt_exception) {
  goog.log.ENABLED && logger && logger.log(level, msg, opt_exception);
};
goog.log.error = function(logger, msg, opt_exception) {
  goog.log.ENABLED && logger && logger.severe(msg, opt_exception);
};
goog.log.warning = function(logger, msg, opt_exception) {
  goog.log.ENABLED && logger && logger.warning(msg, opt_exception);
};
goog.log.info = function(logger, msg, opt_exception) {
  goog.log.ENABLED && logger && logger.info(msg, opt_exception);
};
goog.log.fine = function(logger, msg, opt_exception) {
  goog.log.ENABLED && logger && logger.fine(msg, opt_exception);
};
goog.net.ErrorCode = {NO_ERROR:0, ACCESS_DENIED:1, FILE_NOT_FOUND:2, FF_SILENT_ERROR:3, CUSTOM_ERROR:4, EXCEPTION:5, HTTP_ERROR:6, ABORT:7, TIMEOUT:8, OFFLINE:9, };
goog.net.ErrorCode.getDebugMessage = function(errorCode) {
  switch(errorCode) {
    case goog.net.ErrorCode.NO_ERROR:
      return "No Error";
    case goog.net.ErrorCode.ACCESS_DENIED:
      return "Access denied to content document";
    case goog.net.ErrorCode.FILE_NOT_FOUND:
      return "File not found";
    case goog.net.ErrorCode.FF_SILENT_ERROR:
      return "Firefox silently errored";
    case goog.net.ErrorCode.CUSTOM_ERROR:
      return "Application custom error";
    case goog.net.ErrorCode.EXCEPTION:
      return "An exception occurred";
    case goog.net.ErrorCode.HTTP_ERROR:
      return "Http response at 400 or 500 level";
    case goog.net.ErrorCode.ABORT:
      return "Request was aborted";
    case goog.net.ErrorCode.TIMEOUT:
      return "Request timed out";
    case goog.net.ErrorCode.OFFLINE:
      return "The resource is not available offline";
    default:
      return "Unrecognized error code";
  }
};
goog.net.EventType = {COMPLETE:"complete", SUCCESS:"success", ERROR:"error", ABORT:"abort", READY:"ready", READY_STATE_CHANGE:"readystatechange", TIMEOUT:"timeout", INCREMENTAL_DATA:"incrementaldata", PROGRESS:"progress", DOWNLOAD_PROGRESS:"downloadprogress", UPLOAD_PROGRESS:"uploadprogress", };
goog.net.HttpStatus = {CONTINUE:100, SWITCHING_PROTOCOLS:101, OK:200, CREATED:201, ACCEPTED:202, NON_AUTHORITATIVE_INFORMATION:203, NO_CONTENT:204, RESET_CONTENT:205, PARTIAL_CONTENT:206, MULTI_STATUS:207, MULTIPLE_CHOICES:300, MOVED_PERMANENTLY:301, FOUND:302, SEE_OTHER:303, NOT_MODIFIED:304, USE_PROXY:305, TEMPORARY_REDIRECT:307, PERMANENT_REDIRECT:308, BAD_REQUEST:400, UNAUTHORIZED:401, PAYMENT_REQUIRED:402, FORBIDDEN:403, NOT_FOUND:404, METHOD_NOT_ALLOWED:405, NOT_ACCEPTABLE:406, PROXY_AUTHENTICATION_REQUIRED:407, 
REQUEST_TIMEOUT:408, CONFLICT:409, GONE:410, LENGTH_REQUIRED:411, PRECONDITION_FAILED:412, REQUEST_ENTITY_TOO_LARGE:413, REQUEST_URI_TOO_LONG:414, UNSUPPORTED_MEDIA_TYPE:415, REQUEST_RANGE_NOT_SATISFIABLE:416, EXPECTATION_FAILED:417, UNPROCESSABLE_ENTITY:422, LOCKED:423, FAILED_DEPENDENCY:424, PRECONDITION_REQUIRED:428, TOO_MANY_REQUESTS:429, REQUEST_HEADER_FIELDS_TOO_LARGE:431, INTERNAL_SERVER_ERROR:500, NOT_IMPLEMENTED:501, BAD_GATEWAY:502, SERVICE_UNAVAILABLE:503, GATEWAY_TIMEOUT:504, HTTP_VERSION_NOT_SUPPORTED:505, 
INSUFFICIENT_STORAGE:507, NETWORK_AUTHENTICATION_REQUIRED:511, QUIRK_IE_NO_CONTENT:1223, };
goog.net.HttpStatus.isSuccess = function(status) {
  switch(status) {
    case goog.net.HttpStatus.OK:
    case goog.net.HttpStatus.CREATED:
    case goog.net.HttpStatus.ACCEPTED:
    case goog.net.HttpStatus.NO_CONTENT:
    case goog.net.HttpStatus.PARTIAL_CONTENT:
    case goog.net.HttpStatus.NOT_MODIFIED:
    case goog.net.HttpStatus.QUIRK_IE_NO_CONTENT:
      return !0;
    default:
      return !1;
  }
};
goog.net.XhrLike = function() {
};
goog.net.XhrLike.prototype.open = function(method, url, opt_async, opt_user, opt_password) {
};
goog.net.XhrLike.prototype.send = function(opt_data) {
};
goog.net.XhrLike.prototype.abort = function() {
};
goog.net.XhrLike.prototype.setRequestHeader = function(header, value) {
};
goog.net.XhrLike.prototype.getResponseHeader = function(header) {
};
goog.net.XhrLike.prototype.getAllResponseHeaders = function() {
};
goog.net.XmlHttpFactory = function() {
};
goog.net.XmlHttpFactory.prototype.cachedOptions_ = null;
goog.net.XmlHttpFactory.prototype.getOptions = function() {
  return this.cachedOptions_ || (this.cachedOptions_ = this.internalGetOptions());
};
goog.net.WrapperXmlHttpFactory = function(xhrFactory, optionsFactory) {
  this.xhrFactory_ = xhrFactory;
  this.optionsFactory_ = optionsFactory;
};
goog.inherits(goog.net.WrapperXmlHttpFactory, goog.net.XmlHttpFactory);
goog.net.WrapperXmlHttpFactory.prototype.createInstance = function() {
  return this.xhrFactory_();
};
goog.net.WrapperXmlHttpFactory.prototype.getOptions = function() {
  return this.optionsFactory_();
};
goog.net.XmlHttp = function() {
  return goog.net.XmlHttp.factory_.createInstance();
};
goog.net.XmlHttp.ASSUME_NATIVE_XHR = !1;
goog.net.XmlHttpDefines = {};
goog.net.XmlHttpDefines.ASSUME_NATIVE_XHR = !1;
goog.net.XmlHttp.getOptions = function() {
  return goog.net.XmlHttp.factory_.getOptions();
};
goog.net.XmlHttp.OptionType = {USE_NULL_FUNCTION:0, LOCAL_REQUEST_ERROR:1, };
goog.net.XmlHttp.ReadyState = {UNINITIALIZED:0, LOADING:1, LOADED:2, INTERACTIVE:3, COMPLETE:4, };
goog.net.XmlHttp.setFactory = function(factory, optionsFactory) {
  goog.net.XmlHttp.setGlobalFactory(new goog.net.WrapperXmlHttpFactory(goog.asserts.assert(factory), goog.asserts.assert(optionsFactory)));
};
goog.net.XmlHttp.setGlobalFactory = function(factory) {
  goog.net.XmlHttp.factory_ = factory;
};
goog.net.DefaultXmlHttpFactory = function() {
};
goog.inherits(goog.net.DefaultXmlHttpFactory, goog.net.XmlHttpFactory);
goog.net.DefaultXmlHttpFactory.prototype.createInstance = function() {
  var progId = this.getProgId_();
  return progId ? new ActiveXObject(progId) : new XMLHttpRequest;
};
goog.net.DefaultXmlHttpFactory.prototype.internalGetOptions = function() {
  var options = {};
  this.getProgId_() && (options[goog.net.XmlHttp.OptionType.USE_NULL_FUNCTION] = !0, options[goog.net.XmlHttp.OptionType.LOCAL_REQUEST_ERROR] = !0);
  return options;
};
goog.net.DefaultXmlHttpFactory.prototype.getProgId_ = function() {
  if (goog.net.XmlHttp.ASSUME_NATIVE_XHR || goog.net.XmlHttpDefines.ASSUME_NATIVE_XHR) {
    return "";
  }
  if (!this.ieProgId_ && "undefined" == typeof XMLHttpRequest && "undefined" != typeof ActiveXObject) {
    for (var ACTIVE_X_IDENTS = ["MSXML2.XMLHTTP.6.0", "MSXML2.XMLHTTP.3.0", "MSXML2.XMLHTTP", "Microsoft.XMLHTTP", ], i = 0; i < ACTIVE_X_IDENTS.length; i++) {
      var candidate = ACTIVE_X_IDENTS[i];
      try {
        return new ActiveXObject(candidate), this.ieProgId_ = candidate;
      } catch (e) {
      }
    }
    throw Error("Could not create ActiveXObject. ActiveX might be disabled, or MSXML might not be installed");
  }
  return this.ieProgId_;
};
goog.net.XmlHttp.setGlobalFactory(new goog.net.DefaultXmlHttpFactory);
goog.net.XhrIo = function(opt_xmlHttpFactory) {
  goog.events.EventTarget.call(this);
  this.headers = new goog.structs.Map;
  this.xmlHttpFactory_ = opt_xmlHttpFactory || null;
  this.active_ = !1;
  this.xhrOptions_ = this.xhr_ = null;
  this.lastMethod_ = this.lastUri_ = "";
  this.lastErrorCode_ = goog.net.ErrorCode.NO_ERROR;
  this.lastError_ = "";
  this.inAbort_ = this.inOpen_ = this.inSend_ = this.errorDispatched_ = !1;
  this.timeoutInterval_ = 0;
  this.timeoutId_ = null;
  this.responseType_ = goog.net.XhrIo.ResponseType.DEFAULT;
  this.useXhr2Timeout_ = this.progressEventsEnabled_ = this.withCredentials_ = !1;
};
goog.inherits(goog.net.XhrIo, goog.events.EventTarget);
goog.net.XhrIo.ResponseType = {DEFAULT:"", TEXT:"text", DOCUMENT:"document", BLOB:"blob", ARRAY_BUFFER:"arraybuffer", };
goog.net.XhrIo.prototype.logger_ = goog.log.getLogger("goog.net.XhrIo");
goog.net.XhrIo.CONTENT_TYPE_HEADER = "Content-Type";
goog.net.XhrIo.CONTENT_TRANSFER_ENCODING = "Content-Transfer-Encoding";
goog.net.XhrIo.HTTP_SCHEME_PATTERN = /^https?$/i;
goog.net.XhrIo.METHODS_WITH_FORM_DATA = ["POST", "PUT"];
goog.net.XhrIo.FORM_CONTENT_TYPE = "application/x-www-form-urlencoded;charset=utf-8";
goog.net.XhrIo.XHR2_TIMEOUT_ = "timeout";
goog.net.XhrIo.XHR2_ON_TIMEOUT_ = "ontimeout";
goog.net.XhrIo.sendInstances_ = [];
goog.net.XhrIo.send = function(url, opt_callback, opt_method, opt_content, opt_headers, opt_timeoutInterval, opt_withCredentials) {
  var x = new goog.net.XhrIo;
  goog.net.XhrIo.sendInstances_.push(x);
  opt_callback && x.listen(goog.net.EventType.COMPLETE, opt_callback);
  x.listenOnce(goog.net.EventType.READY, x.cleanupSend_);
  opt_timeoutInterval && x.setTimeoutInterval(opt_timeoutInterval);
  opt_withCredentials && x.setWithCredentials(opt_withCredentials);
  x.send(url, opt_method, opt_content, opt_headers);
  return x;
};
goog.net.XhrIo.cleanup = function() {
  for (var instances = goog.net.XhrIo.sendInstances_; instances.length;) {
    instances.pop().dispose();
  }
};
goog.net.XhrIo.protectEntryPoints = function(errorHandler) {
  goog.net.XhrIo.prototype.onReadyStateChangeEntryPoint_ = errorHandler.protectEntryPoint(goog.net.XhrIo.prototype.onReadyStateChangeEntryPoint_);
};
goog.net.XhrIo.prototype.cleanupSend_ = function() {
  this.dispose();
  goog.array.remove(goog.net.XhrIo.sendInstances_, this);
};
goog.net.XhrIo.prototype.getTimeoutInterval = function() {
  return this.timeoutInterval_;
};
goog.net.XhrIo.prototype.setTimeoutInterval = function(ms) {
  this.timeoutInterval_ = Math.max(0, ms);
};
goog.net.XhrIo.prototype.setResponseType = function(type) {
  this.responseType_ = type;
};
goog.net.XhrIo.prototype.getResponseType = function() {
  return this.responseType_;
};
goog.net.XhrIo.prototype.setWithCredentials = function(withCredentials) {
  this.withCredentials_ = withCredentials;
};
goog.net.XhrIo.prototype.getWithCredentials = function() {
  return this.withCredentials_;
};
goog.net.XhrIo.prototype.setProgressEventsEnabled = function(enabled) {
  this.progressEventsEnabled_ = enabled;
};
goog.net.XhrIo.prototype.getProgressEventsEnabled = function() {
  return this.progressEventsEnabled_;
};
goog.net.XhrIo.prototype.send = function(url, opt_method, opt_content, opt_headers) {
  if (this.xhr_) {
    throw Error("[goog.net.XhrIo] Object is active with another request=" + this.lastUri_ + "; newUri=" + url);
  }
  var method = opt_method ? opt_method.toUpperCase() : "GET";
  this.lastUri_ = url;
  this.lastError_ = "";
  this.lastErrorCode_ = goog.net.ErrorCode.NO_ERROR;
  this.lastMethod_ = method;
  this.errorDispatched_ = !1;
  this.active_ = !0;
  this.xhr_ = this.createXhr();
  this.xhrOptions_ = this.xmlHttpFactory_ ? this.xmlHttpFactory_.getOptions() : goog.net.XmlHttp.getOptions();
  this.xhr_.onreadystatechange = goog.bind(this.onReadyStateChange_, this);
  this.getProgressEventsEnabled() && "onprogress" in this.xhr_ && (this.xhr_.onprogress = goog.bind(function(e) {
    this.onProgressHandler_(e, !0);
  }, this), this.xhr_.upload && (this.xhr_.upload.onprogress = goog.bind(this.onProgressHandler_, this)));
  try {
    goog.log.fine(this.logger_, this.formatMsg_("Opening Xhr")), this.inOpen_ = !0, this.xhr_.open(method, String(url), !0), this.inOpen_ = !1;
  } catch (err) {
    goog.log.fine(this.logger_, this.formatMsg_("Error opening Xhr: " + err.message));
    this.error_(goog.net.ErrorCode.EXCEPTION, err);
    return;
  }
  var content = opt_content || "", headers = this.headers.clone();
  opt_headers && goog.structs.forEach(opt_headers, function(value, key) {
    headers.set(key, value);
  });
  var contentTypeKey = goog.array.find(headers.getKeys(), goog.net.XhrIo.isContentTypeHeader_), contentIsFormData = goog.global.FormData && content instanceof goog.global.FormData;
  !goog.array.contains(goog.net.XhrIo.METHODS_WITH_FORM_DATA, method) || contentTypeKey || contentIsFormData || headers.set(goog.net.XhrIo.CONTENT_TYPE_HEADER, goog.net.XhrIo.FORM_CONTENT_TYPE);
  headers.forEach(function(value, key) {
    this.xhr_.setRequestHeader(key, value);
  }, this);
  this.responseType_ && (this.xhr_.responseType = this.responseType_);
  "withCredentials" in this.xhr_ && this.xhr_.withCredentials !== this.withCredentials_ && (this.xhr_.withCredentials = this.withCredentials_);
  try {
    this.cleanUpTimeoutTimer_(), 0 < this.timeoutInterval_ && (this.useXhr2Timeout_ = goog.net.XhrIo.shouldUseXhr2Timeout_(this.xhr_), goog.log.fine(this.logger_, this.formatMsg_("Will abort after " + this.timeoutInterval_ + "ms if incomplete, xhr2 " + this.useXhr2Timeout_)), this.useXhr2Timeout_ ? (this.xhr_[goog.net.XhrIo.XHR2_TIMEOUT_] = this.timeoutInterval_, this.xhr_[goog.net.XhrIo.XHR2_ON_TIMEOUT_] = goog.bind(this.timeout_, this)) : this.timeoutId_ = goog.Timer.callOnce(this.timeout_, this.timeoutInterval_, 
    this)), goog.log.fine(this.logger_, this.formatMsg_("Sending request")), this.inSend_ = !0, this.xhr_.send(content), this.inSend_ = !1;
  } catch (err$24) {
    goog.log.fine(this.logger_, this.formatMsg_("Send error: " + err$24.message)), this.error_(goog.net.ErrorCode.EXCEPTION, err$24);
  }
};
goog.net.XhrIo.shouldUseXhr2Timeout_ = function(xhr) {
  return goog.userAgent.IE && goog.userAgent.isVersionOrHigher(9) && "number" === typeof xhr[goog.net.XhrIo.XHR2_TIMEOUT_] && void 0 !== xhr[goog.net.XhrIo.XHR2_ON_TIMEOUT_];
};
goog.net.XhrIo.isContentTypeHeader_ = function(header) {
  return goog.string.caseInsensitiveEquals(goog.net.XhrIo.CONTENT_TYPE_HEADER, header);
};
goog.net.XhrIo.prototype.createXhr = function() {
  return this.xmlHttpFactory_ ? this.xmlHttpFactory_.createInstance() : goog.net.XmlHttp();
};
goog.net.XhrIo.prototype.timeout_ = function() {
  "undefined" != typeof goog && this.xhr_ && (this.lastError_ = "Timed out after " + this.timeoutInterval_ + "ms, aborting", this.lastErrorCode_ = goog.net.ErrorCode.TIMEOUT, goog.log.fine(this.logger_, this.formatMsg_(this.lastError_)), this.dispatchEvent(goog.net.EventType.TIMEOUT), this.abort(goog.net.ErrorCode.TIMEOUT));
};
goog.net.XhrIo.prototype.error_ = function(errorCode, err) {
  this.active_ = !1;
  this.xhr_ && (this.inAbort_ = !0, this.xhr_.abort(), this.inAbort_ = !1);
  this.lastError_ = err;
  this.lastErrorCode_ = errorCode;
  this.dispatchErrors_();
  this.cleanUpXhr_();
};
goog.net.XhrIo.prototype.dispatchErrors_ = function() {
  this.errorDispatched_ || (this.errorDispatched_ = !0, this.dispatchEvent(goog.net.EventType.COMPLETE), this.dispatchEvent(goog.net.EventType.ERROR));
};
goog.net.XhrIo.prototype.abort = function(opt_failureCode) {
  this.xhr_ && this.active_ && (goog.log.fine(this.logger_, this.formatMsg_("Aborting")), this.active_ = !1, this.inAbort_ = !0, this.xhr_.abort(), this.inAbort_ = !1, this.lastErrorCode_ = opt_failureCode || goog.net.ErrorCode.ABORT, this.dispatchEvent(goog.net.EventType.COMPLETE), this.dispatchEvent(goog.net.EventType.ABORT), this.cleanUpXhr_());
};
goog.net.XhrIo.prototype.disposeInternal = function() {
  this.xhr_ && (this.active_ && (this.active_ = !1, this.inAbort_ = !0, this.xhr_.abort(), this.inAbort_ = !1), this.cleanUpXhr_(!0));
  goog.net.XhrIo.superClass_.disposeInternal.call(this);
};
goog.net.XhrIo.prototype.onReadyStateChange_ = function() {
  if (!this.isDisposed()) {
    if (this.inOpen_ || this.inSend_ || this.inAbort_) {
      this.onReadyStateChangeHelper_();
    } else {
      this.onReadyStateChangeEntryPoint_();
    }
  }
};
goog.net.XhrIo.prototype.onReadyStateChangeEntryPoint_ = function() {
  this.onReadyStateChangeHelper_();
};
goog.net.XhrIo.prototype.onReadyStateChangeHelper_ = function() {
  if (this.active_ && "undefined" != typeof goog) {
    if (this.xhrOptions_[goog.net.XmlHttp.OptionType.LOCAL_REQUEST_ERROR] && this.getReadyState() == goog.net.XmlHttp.ReadyState.COMPLETE && 2 == this.getStatus()) {
      goog.log.fine(this.logger_, this.formatMsg_("Local request error detected and ignored"));
    } else {
      if (this.inSend_ && this.getReadyState() == goog.net.XmlHttp.ReadyState.COMPLETE) {
        goog.Timer.callOnce(this.onReadyStateChange_, 0, this);
      } else {
        if (this.dispatchEvent(goog.net.EventType.READY_STATE_CHANGE), this.isComplete()) {
          goog.log.fine(this.logger_, this.formatMsg_("Request complete"));
          this.active_ = !1;
          try {
            this.isSuccess() ? (this.dispatchEvent(goog.net.EventType.COMPLETE), this.dispatchEvent(goog.net.EventType.SUCCESS)) : (this.lastErrorCode_ = goog.net.ErrorCode.HTTP_ERROR, this.lastError_ = this.getStatusText() + " [" + this.getStatus() + "]", this.dispatchErrors_());
          } finally {
            this.cleanUpXhr_();
          }
        }
      }
    }
  }
};
goog.net.XhrIo.prototype.onProgressHandler_ = function(e, opt_isDownload) {
  goog.asserts.assert(e.type === goog.net.EventType.PROGRESS, "goog.net.EventType.PROGRESS is of the same type as raw XHR progress.");
  this.dispatchEvent(goog.net.XhrIo.buildProgressEvent_(e, goog.net.EventType.PROGRESS));
  this.dispatchEvent(goog.net.XhrIo.buildProgressEvent_(e, opt_isDownload ? goog.net.EventType.DOWNLOAD_PROGRESS : goog.net.EventType.UPLOAD_PROGRESS));
};
goog.net.XhrIo.buildProgressEvent_ = function(e, eventType) {
  return {type:eventType, lengthComputable:e.lengthComputable, loaded:e.loaded, total:e.total, };
};
goog.net.XhrIo.prototype.cleanUpXhr_ = function(opt_fromDispose) {
  if (this.xhr_) {
    this.cleanUpTimeoutTimer_();
    var xhr = this.xhr_, clearedOnReadyStateChange = this.xhrOptions_[goog.net.XmlHttp.OptionType.USE_NULL_FUNCTION] ? goog.nullFunction : null;
    this.xhrOptions_ = this.xhr_ = null;
    opt_fromDispose || this.dispatchEvent(goog.net.EventType.READY);
    try {
      xhr.onreadystatechange = clearedOnReadyStateChange;
    } catch (e) {
      goog.log.error(this.logger_, "Problem encountered resetting onreadystatechange: " + e.message);
    }
  }
};
goog.net.XhrIo.prototype.cleanUpTimeoutTimer_ = function() {
  this.xhr_ && this.useXhr2Timeout_ && (this.xhr_[goog.net.XhrIo.XHR2_ON_TIMEOUT_] = null);
  this.timeoutId_ && (goog.Timer.clear(this.timeoutId_), this.timeoutId_ = null);
};
goog.net.XhrIo.prototype.isActive = function() {
  return !!this.xhr_;
};
goog.net.XhrIo.prototype.isComplete = function() {
  return this.getReadyState() == goog.net.XmlHttp.ReadyState.COMPLETE;
};
goog.net.XhrIo.prototype.isSuccess = function() {
  var status = this.getStatus();
  return goog.net.HttpStatus.isSuccess(status) || 0 === status && !this.isLastUriEffectiveSchemeHttp_();
};
goog.net.XhrIo.prototype.isLastUriEffectiveSchemeHttp_ = function() {
  var scheme = goog.uri.utils.getEffectiveScheme(String(this.lastUri_));
  return goog.net.XhrIo.HTTP_SCHEME_PATTERN.test(scheme);
};
goog.net.XhrIo.prototype.getReadyState = function() {
  return this.xhr_ ? this.xhr_.readyState : goog.net.XmlHttp.ReadyState.UNINITIALIZED;
};
goog.net.XhrIo.prototype.getStatus = function() {
  try {
    return this.getReadyState() > goog.net.XmlHttp.ReadyState.LOADED ? this.xhr_.status : -1;
  } catch (e) {
    return -1;
  }
};
goog.net.XhrIo.prototype.getStatusText = function() {
  try {
    return this.getReadyState() > goog.net.XmlHttp.ReadyState.LOADED ? this.xhr_.statusText : "";
  } catch (e) {
    return goog.log.fine(this.logger_, "Can not get status: " + e.message), "";
  }
};
goog.net.XhrIo.prototype.getLastUri = function() {
  return String(this.lastUri_);
};
goog.net.XhrIo.prototype.getResponseText = function() {
  try {
    return this.xhr_ ? this.xhr_.responseText : "";
  } catch (e) {
    return goog.log.fine(this.logger_, "Can not get responseText: " + e.message), "";
  }
};
goog.net.XhrIo.prototype.getResponseBody = function() {
  try {
    if (this.xhr_ && "responseBody" in this.xhr_) {
      return this.xhr_.responseBody;
    }
  } catch (e) {
    goog.log.fine(this.logger_, "Can not get responseBody: " + e.message);
  }
  return null;
};
goog.net.XhrIo.prototype.getResponseXml = function() {
  try {
    return this.xhr_ ? this.xhr_.responseXML : null;
  } catch (e) {
    return goog.log.fine(this.logger_, "Can not get responseXML: " + e.message), null;
  }
};
goog.net.XhrIo.prototype.getResponseJson = function(opt_xssiPrefix) {
  if (this.xhr_) {
    var responseText = this.xhr_.responseText;
    opt_xssiPrefix && 0 == responseText.indexOf(opt_xssiPrefix) && (responseText = responseText.substring(opt_xssiPrefix.length));
    return goog.json.hybrid.parse(responseText);
  }
};
goog.net.XhrIo.prototype.getResponse = function() {
  try {
    if (!this.xhr_) {
      return null;
    }
    if ("response" in this.xhr_) {
      return this.xhr_.response;
    }
    switch(this.responseType_) {
      case goog.net.XhrIo.ResponseType.DEFAULT:
      case goog.net.XhrIo.ResponseType.TEXT:
        return this.xhr_.responseText;
      case goog.net.XhrIo.ResponseType.ARRAY_BUFFER:
        if ("mozResponseArrayBuffer" in this.xhr_) {
          return this.xhr_.mozResponseArrayBuffer;
        }
    }
    goog.log.error(this.logger_, "Response type " + this.responseType_ + " is not supported on this browser");
    return null;
  } catch (e) {
    return goog.log.fine(this.logger_, "Can not get response: " + e.message), null;
  }
};
goog.net.XhrIo.prototype.getResponseHeader = function(key) {
  if (this.xhr_ && this.isComplete()) {
    var value = this.xhr_.getResponseHeader(key);
    return null === value ? void 0 : value;
  }
};
goog.net.XhrIo.prototype.getAllResponseHeaders = function() {
  return this.xhr_ && this.isComplete() ? this.xhr_.getAllResponseHeaders() || "" : "";
};
goog.net.XhrIo.prototype.getResponseHeaders = function() {
  for (var headersObject = {}, headersArray = this.getAllResponseHeaders().split("\r\n"), i = 0; i < headersArray.length; i++) {
    if (!goog.string.isEmptyOrWhitespace(headersArray[i])) {
      var keyValue = goog.string.splitLimit(headersArray[i], ":", 1), key = keyValue[0], value = keyValue[1];
      if ("string" === typeof value) {
        value = value.trim();
        var values$jscomp$0 = headersObject[key] || [];
        headersObject[key] = values$jscomp$0;
        values$jscomp$0.push(value);
      }
    }
  }
  return goog.object.map(headersObject, function(values) {
    return values.join(", ");
  });
};
goog.net.XhrIo.prototype.getStreamingResponseHeader = function(key) {
  return this.xhr_ ? this.xhr_.getResponseHeader(key) : null;
};
goog.net.XhrIo.prototype.getAllStreamingResponseHeaders = function() {
  return this.xhr_ ? this.xhr_.getAllResponseHeaders() : "";
};
goog.net.XhrIo.prototype.getLastErrorCode = function() {
  return this.lastErrorCode_;
};
goog.net.XhrIo.prototype.getLastError = function() {
  return "string" === typeof this.lastError_ ? this.lastError_ : String(this.lastError_);
};
goog.net.XhrIo.prototype.formatMsg_ = function(msg) {
  return msg + " [" + this.lastMethod_ + " " + this.lastUri_ + " " + this.getStatus() + "]";
};
goog.debug.entryPointRegistry.register(function(transformer) {
  goog.net.XhrIo.prototype.onReadyStateChangeEntryPoint_ = transformer(goog.net.XhrIo.prototype.onReadyStateChangeEntryPoint_);
});
ee.apiclient = {};
var module$contents$ee$apiclient_apiclient = {}, module$contents$ee$apiclient_LEGACY_DOWNLOAD_REGEX = /^\/(table).*/;
ee.apiclient.VERSION = "v1alpha";
ee.apiclient.API_CLIENT_VERSION = "0.1.226";
ee.apiclient.NULL_VALUE = module$exports$eeapiclient$domain_object.NULL_VALUE;
ee.apiclient.PromiseRequestService = module$exports$eeapiclient$promise_request_service.PromiseRequestService;
ee.apiclient.MakeRequestParams = module$contents$eeapiclient$request_params_MakeRequestParams;
ee.apiclient.deserialize = module$contents$eeapiclient$domain_object_deserialize;
ee.apiclient.serialize = module$contents$eeapiclient$domain_object_serialize;
var module$contents$ee$apiclient_Call = function(callback, retries) {
  module$contents$ee$apiclient_apiclient.initialize();
  this.callback = callback;
  this.requestService = new module$contents$ee$apiclient_EERequestService(!callback, retries);
};
module$contents$ee$apiclient_Call.prototype.handle = function(response) {
  var $jscomp$this = this;
  response instanceof Promise ? this.callback && response.then(function(result) {
    return $jscomp$this.callback(result);
  }).catch(function(error) {
    return $jscomp$this.callback(void 0, error);
  }) : response.then(function(result) {
    response = result;
  });
  return response;
};
module$contents$ee$apiclient_Call.prototype.projectsPath = function() {
  return "projects/" + module$contents$ee$apiclient_apiclient.getProject();
};
module$contents$ee$apiclient_Call.prototype.algorithms = function() {
  return new module$exports$eeapiclient$ee_api_client.ProjectsAlgorithmsApiClientImpl("v1alpha", this.requestService);
};
module$contents$ee$apiclient_Call.prototype.projects = function() {
  return new module$exports$eeapiclient$ee_api_client.ProjectsApiClientImpl("v1alpha", this.requestService);
};
module$contents$ee$apiclient_Call.prototype.assets = function() {
  return new module$exports$eeapiclient$ee_api_client.ProjectsAssetsApiClientImpl("v1alpha", this.requestService);
};
module$contents$ee$apiclient_Call.prototype.operations = function() {
  return new module$exports$eeapiclient$ee_api_client.ProjectsOperationsApiClientImpl("v1alpha", this.requestService);
};
module$contents$ee$apiclient_Call.prototype.value = function() {
  return new module$exports$eeapiclient$ee_api_client.ProjectsValueApiClientImpl("v1alpha", this.requestService);
};
module$contents$ee$apiclient_Call.prototype.maps = function() {
  return new module$exports$eeapiclient$ee_api_client.ProjectsMapsApiClientImpl("v1alpha", this.requestService);
};
module$contents$ee$apiclient_Call.prototype.map = function() {
  return new module$exports$eeapiclient$ee_api_client.ProjectsMapApiClientImpl("v1alpha", this.requestService);
};
module$contents$ee$apiclient_Call.prototype.image = function() {
  return new module$exports$eeapiclient$ee_api_client.ProjectsImageApiClientImpl("v1alpha", this.requestService);
};
module$contents$ee$apiclient_Call.prototype.table = function() {
  return new module$exports$eeapiclient$ee_api_client.ProjectsTableApiClientImpl("v1alpha", this.requestService);
};
module$contents$ee$apiclient_Call.prototype.tables = function() {
  return new module$exports$eeapiclient$ee_api_client.ProjectsTablesApiClientImpl("v1alpha", this.requestService);
};
module$contents$ee$apiclient_Call.prototype.video = function() {
  return new module$exports$eeapiclient$ee_api_client.ProjectsVideoApiClientImpl("v1alpha", this.requestService);
};
module$contents$ee$apiclient_Call.prototype.videoMap = function() {
  return new module$exports$eeapiclient$ee_api_client.ProjectsVideoMapApiClientImpl("v1alpha", this.requestService);
};
module$contents$ee$apiclient_Call.prototype.thumbnails = function() {
  return new module$exports$eeapiclient$ee_api_client.ProjectsThumbnailsApiClientImpl("v1alpha", this.requestService);
};
module$contents$ee$apiclient_Call.prototype.videoThumbnails = function() {
  return new module$exports$eeapiclient$ee_api_client.ProjectsVideoThumbnailsApiClientImpl("v1alpha", this.requestService);
};
module$contents$ee$apiclient_Call.prototype.filmstripThumbnails = function() {
  return new module$exports$eeapiclient$ee_api_client.ProjectsFilmstripThumbnailsApiClientImpl("v1alpha", this.requestService);
};
var module$contents$ee$apiclient_EERequestService = function(sync, retries) {
  this.sync = sync = void 0 === sync ? !1 : sync;
  this.retries = null != retries ? retries : sync ? module$contents$ee$apiclient_apiclient.MAX_SYNC_RETRIES_ : module$contents$ee$apiclient_apiclient.MAX_ASYNC_RETRIES_;
};
$jscomp.inherits(module$contents$ee$apiclient_EERequestService, module$exports$eeapiclient$promise_request_service.PromiseRequestService);
module$contents$ee$apiclient_EERequestService.prototype.send = function(params, responseCtor) {
  var $jscomp$this = this;
  module$contents$eeapiclient$request_params_processParams(params);
  var path = params.path || "", url = module$contents$ee$apiclient_apiclient.getSafeApiUrl() + path, args = module$contents$ee$apiclient_apiclient.makeRequest_(params.queryParams || {}), body = params.body ? JSON.stringify(params.body) : void 0;
  if (this.sync) {
    var raw = module$contents$ee$apiclient_apiclient.send(url, args, void 0, params.httpMethod, body, this.retries), value$25 = responseCtor ? module$contents$eeapiclient$domain_object_deserialize(responseCtor, raw) : raw, thenable = function(v) {
      return {then:function(f) {
        return thenable(f(v));
      }};
    };
    return thenable(value$25);
  }
  return (new Promise(function(resolve, reject) {
    module$contents$ee$apiclient_apiclient.send(url, args, function(value, error) {
      error ? reject(error) : resolve(value);
    }, params.httpMethod, body, $jscomp$this.retries);
  })).then(function(r) {
    return responseCtor ? module$contents$eeapiclient$domain_object_deserialize(responseCtor, r) : r;
  });
};
module$contents$ee$apiclient_EERequestService.prototype.makeRequest = function(params) {
};
var module$contents$ee$apiclient_BatchCall = function(callback) {
  module$contents$ee$apiclient_Call.call(this, callback);
  this.requestService = new module$contents$ee$apiclient_BatchRequestService;
};
$jscomp.inherits(module$contents$ee$apiclient_BatchCall, module$contents$ee$apiclient_Call);
module$contents$ee$apiclient_BatchCall.prototype.send = function(parts, getResponse) {
  var $jscomp$this = this, batchUrl = module$contents$ee$apiclient_apiclient.getSafeApiUrl() + "/batch", body = parts.map(function($jscomp$destructuring$var4) {
    var $jscomp$destructuring$var5 = $jscomp.makeIterator($jscomp$destructuring$var4), id = $jscomp$destructuring$var5.next().value, $jscomp$destructuring$var6 = $jscomp.makeIterator($jscomp$destructuring$var5.next().value), partBody = $jscomp$destructuring$var6.next().value, ctor = $jscomp$destructuring$var6.next().value;
    return "--batch_EARTHENGINE_batch\r\nContent-Type: application/http\r\nContent-Transfer-Encoding: binary\r\nMIME-Version: 1.0\r\nContent-ID: <" + id + ">\r\n\r\n" + partBody + "\r\n";
  }).join("") + "--batch_EARTHENGINE_batch--\r\n", deserializeResponses = function(response) {
    var result = {};
    parts.forEach(function($jscomp$destructuring$var7) {
      var $jscomp$destructuring$var8 = $jscomp.makeIterator($jscomp$destructuring$var7), id = $jscomp$destructuring$var8.next().value, $jscomp$destructuring$var9 = $jscomp.makeIterator($jscomp$destructuring$var8.next().value), partBody = $jscomp$destructuring$var9.next().value, ctor = $jscomp$destructuring$var9.next().value;
      null != response[id] && (result[id] = module$contents$eeapiclient$domain_object_deserialize(ctor, response[id]));
    });
    return getResponse ? getResponse(result) : result;
  };
  return this.callback ? (module$contents$ee$apiclient_apiclient.send(batchUrl, null, function(result, err) {
    return $jscomp$this.callback(err ? result : deserializeResponses(result), err);
  }, "multipart/mixed; boundary=batch_EARTHENGINE_batch", body), null) : deserializeResponses(module$contents$ee$apiclient_apiclient.send(batchUrl, null, void 0, "multipart/mixed; boundary=batch_EARTHENGINE_batch", body));
};
var module$contents$ee$apiclient_BatchRequestService = function() {
};
$jscomp.inherits(module$contents$ee$apiclient_BatchRequestService, module$exports$eeapiclient$promise_request_service.PromiseRequestService);
module$contents$ee$apiclient_BatchRequestService.prototype.send = function(params, responseCtor) {
  var request = [params.httpMethod + " " + params.path + " HTTP/1.1"];
  request.push("Content-Type: application/json; charset=utf-8");
  var authToken = module$contents$ee$apiclient_apiclient.getAuthToken();
  null != authToken && request.push("Authorization: " + authToken);
  var body = params.body ? JSON.stringify(params.body) : "";
  return [request.join("\r\n") + "\r\n\r\n" + body, responseCtor];
};
module$contents$ee$apiclient_BatchRequestService.prototype.makeRequest = function(params) {
};
module$contents$ee$apiclient_apiclient.parseBatchReply = function(contentType, responseText, handle) {
  for (var boundary = contentType.split("; boundary=")[1], $jscomp$iter$11 = $jscomp.makeIterator(responseText.split("--" + boundary)), $jscomp$key$part = $jscomp$iter$11.next(); !$jscomp$key$part.done; $jscomp$key$part = $jscomp$iter$11.next()) {
    var groups = $jscomp$key$part.value.split("\r\n\r\n");
    if (!(3 > groups.length)) {
      var id = groups[0].match(/\r\nContent-ID: <response-([^>]*)>/)[1], status = Number(groups[1].match(/^HTTP\S*\s(\d+)\s/)[1]), text = groups.slice(2).join("\r\n\r\n");
      handle(id, status, text);
    }
  }
};
module$contents$ee$apiclient_apiclient.setApiKey = function(apiKey) {
  module$contents$ee$apiclient_apiclient.cloudApiKey_ = apiKey;
};
module$contents$ee$apiclient_apiclient.getApiKey = function() {
  return module$contents$ee$apiclient_apiclient.cloudApiKey_;
};
module$contents$ee$apiclient_apiclient.DEFAULT_PROJECT_ = "earthengine-legacy";
module$contents$ee$apiclient_apiclient.setProject = function(project) {
  module$contents$ee$apiclient_apiclient.project_ = project;
};
module$contents$ee$apiclient_apiclient.getProject = function() {
  return module$contents$ee$apiclient_apiclient.project_;
};
module$contents$ee$apiclient_apiclient.setCloudApiEnabled = function(enable) {
  module$contents$ee$apiclient_apiclient.cloudApiEnabled_ = enable;
};
module$contents$ee$apiclient_apiclient.getCloudApiEnabled = function() {
  return module$contents$ee$apiclient_apiclient.cloudApiEnabled_;
};
module$contents$ee$apiclient_apiclient.getSafeApiUrl = function() {
  var url = module$contents$ee$apiclient_apiclient.apiBaseUrl_.replace(/\/api$/, "");
  return "window" in goog.global && !url.match(/^https?:\/\/content-/) ? url.replace(/^(https?:\/\/)(.*\.googleapis\.com)$/, "$1content-$2") : url;
};
module$contents$ee$apiclient_apiclient.setAuthToken = function(clientId, tokenType, accessToken, expiresIn, extraScopes, callback, updateAuthLibrary) {
  var scopes = [module$contents$ee$apiclient_apiclient.AUTH_SCOPE_];
  module$contents$ee$apiclient_apiclient.cloudApiEnabled_ && scopes.push(module$contents$ee$apiclient_apiclient.CLOUD_PLATFORM_SCOPE_);
  extraScopes && (goog.array.extend(scopes, extraScopes), goog.array.removeDuplicates(scopes));
  module$contents$ee$apiclient_apiclient.authClientId_ = clientId;
  module$contents$ee$apiclient_apiclient.authScopes_ = scopes;
  var tokenObject = {token_type:tokenType, access_token:accessToken, state:scopes.join(" "), expires_in:expiresIn};
  module$contents$ee$apiclient_apiclient.handleAuthResult_(void 0, void 0, tokenObject);
  !1 === updateAuthLibrary ? callback && callback() : module$contents$ee$apiclient_apiclient.ensureAuthLibLoaded_(function() {
    goog.global.gapi.auth.setToken(tokenObject);
    callback && callback();
  });
};
module$contents$ee$apiclient_apiclient.refreshAuthToken = function(success, error, onImmediateFailed) {
  if (module$contents$ee$apiclient_apiclient.isAuthTokenRefreshingEnabled_()) {
    var authArgs = {client_id:String(module$contents$ee$apiclient_apiclient.authClientId_), immediate:!0, scope:module$contents$ee$apiclient_apiclient.authScopes_.join(" ")};
    module$contents$ee$apiclient_apiclient.authTokenRefresher_(authArgs, function(result) {
      if ("immediate_failed" == result.error && onImmediateFailed) {
        onImmediateFailed();
      } else {
        if (module$contents$ee$apiclient_apiclient.cloudApiEnabled_ && "window" in goog.global) {
          try {
            module$contents$ee$apiclient_apiclient.ensureAuthLibLoaded_(function() {
              try {
                goog.global.gapi.auth.setToken(result), module$contents$ee$apiclient_apiclient.handleAuthResult_(success, error, result);
              } catch (e) {
                error(e.toString());
              }
            });
          } catch (e) {
            error(e.toString());
          }
        } else {
          module$contents$ee$apiclient_apiclient.handleAuthResult_(success, error, result);
        }
      }
    });
  }
};
module$contents$ee$apiclient_apiclient.setAuthTokenRefresher = function(refresher) {
  module$contents$ee$apiclient_apiclient.authTokenRefresher_ = refresher;
};
module$contents$ee$apiclient_apiclient.getAuthToken = function() {
  module$contents$ee$apiclient_apiclient.authTokenExpiration_ && 0 <= goog.now() - module$contents$ee$apiclient_apiclient.authTokenExpiration_ && module$contents$ee$apiclient_apiclient.clearAuthToken();
  return module$contents$ee$apiclient_apiclient.authToken_;
};
module$contents$ee$apiclient_apiclient.clearAuthToken = function() {
  module$contents$ee$apiclient_apiclient.authToken_ = null;
  module$contents$ee$apiclient_apiclient.authTokenExpiration_ = null;
};
module$contents$ee$apiclient_apiclient.getAuthClientId = function() {
  return module$contents$ee$apiclient_apiclient.authClientId_;
};
module$contents$ee$apiclient_apiclient.getAuthScopes = function() {
  return module$contents$ee$apiclient_apiclient.authScopes_;
};
module$contents$ee$apiclient_apiclient.setAuthClient = function(clientId, scopes) {
  module$contents$ee$apiclient_apiclient.authClientId_ = clientId;
  module$contents$ee$apiclient_apiclient.authScopes_ = scopes;
};
module$contents$ee$apiclient_apiclient.setAppIdToken = function(token) {
  module$contents$ee$apiclient_apiclient.appIdToken_ = token;
};
module$contents$ee$apiclient_apiclient.initialize = function(apiBaseUrl, tileBaseUrl, xsrfToken) {
  null != apiBaseUrl ? module$contents$ee$apiclient_apiclient.apiBaseUrl_ = apiBaseUrl : module$contents$ee$apiclient_apiclient.initialized_ || (module$contents$ee$apiclient_apiclient.apiBaseUrl_ = module$contents$ee$apiclient_apiclient.DEFAULT_API_BASE_URL_);
  null != tileBaseUrl ? module$contents$ee$apiclient_apiclient.tileBaseUrl_ = tileBaseUrl : module$contents$ee$apiclient_apiclient.initialized_ || (module$contents$ee$apiclient_apiclient.tileBaseUrl_ = module$contents$ee$apiclient_apiclient.DEFAULT_TILE_BASE_URL_);
  void 0 !== xsrfToken && (module$contents$ee$apiclient_apiclient.xsrfToken_ = xsrfToken);
  module$contents$ee$apiclient_apiclient.cloudApiEnabled_ && module$contents$ee$apiclient_apiclient.setProject(module$contents$ee$apiclient_apiclient.getProject() || module$contents$ee$apiclient_apiclient.DEFAULT_PROJECT_);
  module$contents$ee$apiclient_apiclient.initialized_ = !0;
};
module$contents$ee$apiclient_apiclient.reset = function() {
  module$contents$ee$apiclient_apiclient.apiBaseUrl_ = null;
  module$contents$ee$apiclient_apiclient.tileBaseUrl_ = null;
  module$contents$ee$apiclient_apiclient.xsrfToken_ = null;
  module$contents$ee$apiclient_apiclient.initialized_ = !1;
};
module$contents$ee$apiclient_apiclient.setDeadline = function(milliseconds) {
  module$contents$ee$apiclient_apiclient.deadlineMs_ = milliseconds;
};
module$contents$ee$apiclient_apiclient.setParamAugmenter = function(augmenter) {
  module$contents$ee$apiclient_apiclient.paramAugmenter_ = augmenter || goog.functions.identity;
};
module$contents$ee$apiclient_apiclient.getApiBaseUrl = function() {
  return module$contents$ee$apiclient_apiclient.apiBaseUrl_;
};
module$contents$ee$apiclient_apiclient.getTileBaseUrl = function() {
  return module$contents$ee$apiclient_apiclient.tileBaseUrl_;
};
module$contents$ee$apiclient_apiclient.getXsrfToken = function() {
  return module$contents$ee$apiclient_apiclient.xsrfToken_;
};
module$contents$ee$apiclient_apiclient.isInitialized = function() {
  return module$contents$ee$apiclient_apiclient.initialized_;
};
module$contents$ee$apiclient_apiclient.send = function(path, params, callback, method, body, retries) {
  module$contents$ee$apiclient_apiclient.initialize();
  var profileHookAtCallTime = module$contents$ee$apiclient_apiclient.profileHook_, contentType = "application/x-www-form-urlencoded";
  body && (contentType = "application/json", method && method.startsWith("multipart") && (contentType = method, method = "POST"));
  method = method || "POST";
  var headers = {"Content-Type":contentType, }, forceLegacyApi = module$contents$ee$apiclient_LEGACY_DOWNLOAD_REGEX.test(path);
  if (module$contents$ee$apiclient_apiclient.getCloudApiEnabled() && !forceLegacyApi) {
    var version = "0.1.226";
    "0.1.226" === version && (version = "latest");
    headers[module$contents$ee$apiclient_apiclient.API_CLIENT_VERSION_HEADER] = "ee-js/" + version;
  }
  var authToken = module$contents$ee$apiclient_apiclient.getAuthToken();
  if (null != authToken) {
    headers.Authorization = authToken;
  } else {
    if (callback && module$contents$ee$apiclient_apiclient.isAuthTokenRefreshingEnabled_()) {
      return module$contents$ee$apiclient_apiclient.refreshAuthToken(function() {
        module$contents$ee$apiclient_apiclient.withProfiling(profileHookAtCallTime, function() {
          module$contents$ee$apiclient_apiclient.send(path, params, callback, method);
        });
      }), null;
    }
  }
  params = params ? params.clone() : new goog.Uri.QueryData;
  null != module$contents$ee$apiclient_apiclient.cloudApiKey_ && params.add("key", module$contents$ee$apiclient_apiclient.cloudApiKey_);
  module$contents$ee$apiclient_apiclient.cloudApiEnabled_ ? (profileHookAtCallTime && (headers[module$contents$ee$apiclient_apiclient.PROFILE_REQUEST_HEADER] = "1"), module$contents$ee$apiclient_apiclient.getProject() && module$contents$ee$apiclient_apiclient.getProject() !== module$contents$ee$apiclient_apiclient.DEFAULT_PROJECT_ && !forceLegacyApi && (headers[module$contents$ee$apiclient_apiclient.USER_PROJECT_OVERRIDE_HEADER_] = module$contents$ee$apiclient_apiclient.getProject())) : profileHookAtCallTime && 
  params.add("profiling", "1");
  params = module$contents$ee$apiclient_apiclient.paramAugmenter_(params, path);
  null != module$contents$ee$apiclient_apiclient.xsrfToken_ && (headers["X-XSRF-Token"] = module$contents$ee$apiclient_apiclient.xsrfToken_);
  null != module$contents$ee$apiclient_apiclient.appIdToken_ && (headers[module$contents$ee$apiclient_apiclient.APP_ID_TOKEN_HEADER_] = module$contents$ee$apiclient_apiclient.appIdToken_);
  var requestData = body || null, paramString = params ? params.toString() : "";
  "POST" === method && void 0 === body ? requestData = paramString : goog.string.isEmptyOrWhitespace(paramString) || (path += goog.string.contains(path, "?") ? "&" : "?", path += paramString);
  var url = path.startsWith("/") ? module$contents$ee$apiclient_apiclient.apiBaseUrl_ + path : path;
  if (callback) {
    return module$contents$ee$apiclient_apiclient.requestQueue_.push(module$contents$ee$apiclient_apiclient.buildAsyncRequest_(url, callback, method, requestData, headers, retries)), module$contents$ee$apiclient_apiclient.RequestThrottle_.fire(), null;
  }
  for (var setRequestHeader = function(value, key) {
    this.setRequestHeader && this.setRequestHeader(key, value);
  }, xmlHttp, retryCount = 0, maxRetries = null != retries ? retries : module$contents$ee$apiclient_apiclient.MAX_SYNC_RETRIES_;;) {
    xmlHttp = (0,goog.net.XmlHttp)();
    xmlHttp.open(method, url, !1);
    goog.object.forEach(headers, setRequestHeader, xmlHttp);
    xmlHttp.send(requestData);
    if (429 != xmlHttp.status || retryCount > maxRetries) {
      break;
    }
    retryCount++;
  }
  return module$contents$ee$apiclient_apiclient.handleResponse_(xmlHttp.status, function getResponseHeaderSafe(header) {
    try {
      return xmlHttp.getResponseHeader(header);
    } catch (e) {
      return null;
    }
  }, xmlHttp.responseText, profileHookAtCallTime, void 0, url, method);
};
module$contents$ee$apiclient_apiclient.buildAsyncRequest_ = function(url, callback, method, content, headers, retries) {
  var retryCount = 0, request = {url:url, method:method, content:content, headers:headers}, profileHookAtCallTime = module$contents$ee$apiclient_apiclient.profileHook_, maxRetries = null != retries ? retries : module$contents$ee$apiclient_apiclient.MAX_ASYNC_RETRIES_;
  request.callback = function(e) {
    var xhrIo = e.target;
    return 429 == xhrIo.getStatus() && retryCount < maxRetries ? (retryCount++, setTimeout(function() {
      module$contents$ee$apiclient_apiclient.requestQueue_.push(request);
      module$contents$ee$apiclient_apiclient.RequestThrottle_.fire();
    }, module$contents$ee$apiclient_apiclient.calculateRetryWait_(retryCount)), null) : module$contents$ee$apiclient_apiclient.handleResponse_(xhrIo.getStatus(), goog.bind(xhrIo.getResponseHeader, xhrIo), xhrIo.getResponseText(), profileHookAtCallTime, callback, url, method);
  };
  return request;
};
module$contents$ee$apiclient_apiclient.withProfiling = function(hook, body, thisObject) {
  var saved = module$contents$ee$apiclient_apiclient.profileHook_;
  try {
    return module$contents$ee$apiclient_apiclient.profileHook_ = hook, body.call(thisObject);
  } finally {
    module$contents$ee$apiclient_apiclient.profileHook_ = saved;
  }
};
module$contents$ee$apiclient_apiclient.handleResponse_ = function(status$jscomp$0, getResponseHeader, responseText, profileHook, callback, url, method) {
  var profileId = profileHook ? getResponseHeader(module$contents$ee$apiclient_apiclient.PROFILE_HEADER) : "";
  profileId && profileHook && profileHook(profileId);
  var getData = function(response) {
    return module$contents$ee$apiclient_apiclient.cloudApiEnabled_ ? response : response.data;
  }, parseJson = function(body) {
    try {
      var response = JSON.parse(body);
      return goog.isObject(response) && "error" in response && "message" in response.error ? response.error.message : {parsed:response};
    } catch (e) {
      return "Invalid JSON: " + body;
    }
  }, statusError = function(status) {
    if (0 === status) {
      return "Failed to contact Earth Engine servers. Please check your connection, firewall, or browser extension settings.";
    }
    if (200 > status || 300 <= status) {
      return "Server returned HTTP code: " + status + " for " + method + " " + url;
    }
  }, errorMessage, typeHeader = getResponseHeader("Content-Type") || "application/json", contentType = typeHeader.replace(/;.*/, "");
  if ("application/json" === contentType || "text/json" === contentType) {
    var response$jscomp$0 = parseJson(responseText);
    if (response$jscomp$0.parsed) {
      var data = getData(response$jscomp$0.parsed);
      void 0 === data && (errorMessage = "Malformed response: " + responseText);
    } else {
      errorMessage = response$jscomp$0;
    }
  } else {
    if ("multipart/mixed" === contentType) {
      data = {};
      var errors = [];
      module$contents$ee$apiclient_apiclient.parseBatchReply(typeHeader, responseText, function(id, status, text) {
        var response = parseJson(text);
        response.parsed && (data[id] = getData(response.parsed));
        var error = (response.parsed ? "" : response) || statusError(status);
        error && errors.push(id + ": " + error);
      });
      errors.length && (errorMessage = errors.join("\n"));
    } else {
      var typeError = "Response was unexpectedly not JSON, but " + contentType;
    }
  }
  errorMessage = errorMessage || statusError(status$jscomp$0) || typeError;
  if (callback) {
    return callback(data, errorMessage), null;
  }
  if (!errorMessage) {
    return data;
  }
  throw Error(errorMessage);
};
module$contents$ee$apiclient_apiclient.ensureAuthLibLoaded_ = function(callback) {
  var done = function() {
    goog.global.gapi.config.update("client/cors", !0);
    module$contents$ee$apiclient_apiclient.authTokenRefresher_ || module$contents$ee$apiclient_apiclient.setAuthTokenRefresher(goog.global.gapi.auth.authorize);
    callback();
  };
  if (goog.isObject(goog.global.gapi) && goog.isObject(goog.global.gapi.auth) && "function" === typeof goog.global.gapi.auth.authorize) {
    done();
  } else {
    for (var callbackName = goog.now().toString(36); callbackName in goog.global;) {
      callbackName += "_";
    }
    goog.global[callbackName] = function() {
      delete goog.global[callbackName];
      done();
    };
    goog.net.jsloader.safeLoad(goog.html.TrustedResourceUrl.format(module$contents$ee$apiclient_apiclient.AUTH_LIBRARY_URL_, {onload:callbackName}));
  }
};
module$contents$ee$apiclient_apiclient.handleAuthResult_ = function(success, error, result) {
  if (result.access_token) {
    var token = result.token_type + " " + result.access_token;
    if (result.expires_in || 0 === result.expires_in) {
      var expiresInMs = 900 * result.expires_in, timeout = setTimeout(module$contents$ee$apiclient_apiclient.refreshAuthToken, 0.9 * expiresInMs);
      void 0 !== timeout.unref && timeout.unref();
      module$contents$ee$apiclient_apiclient.authTokenExpiration_ = goog.now() + expiresInMs;
    }
    module$contents$ee$apiclient_apiclient.authToken_ = token;
    success && success();
  } else {
    error && error(result.error || "Unknown error.");
  }
};
module$contents$ee$apiclient_apiclient.makeRequest_ = function(params) {
  for (var request = new goog.Uri.QueryData, $jscomp$iter$12 = $jscomp.makeIterator(Object.entries(params)), $jscomp$key$ = $jscomp$iter$12.next(); !$jscomp$key$.done; $jscomp$key$ = $jscomp$iter$12.next()) {
    var $jscomp$destructuring$var11 = $jscomp.makeIterator($jscomp$key$.value), name = $jscomp$destructuring$var11.next().value, item = $jscomp$destructuring$var11.next().value;
    request.set(name, item);
  }
  return request;
};
module$contents$ee$apiclient_apiclient.setupMockSend = function(calls) {
  function getResponse(url, method, data) {
    url = url.replace(apiBaseUrl, "").replace("v1alpha/projects/" + module$contents$ee$apiclient_apiclient.DEFAULT_PROJECT_ + "/", "");
    if (url in calls) {
      var response = calls[url];
    } else {
      throw Error(url + " mock response not specified");
    }
    "function" === typeof response && (response = response(url, method, data));
    "string" === typeof response && (response = {text:response, status:200, contentType:"application/json; charset=utf-8"});
    if ("string" !== typeof response.text) {
      throw Error(url + " mock response missing/invalid text");
    }
    if ("number" !== typeof response.status && "function" !== typeof response.status) {
      throw Error(url + " mock response missing/invalid status");
    }
    return response;
  }
  calls = calls ? goog.object.clone(calls) : {};
  var apiBaseUrl;
  goog.net.XhrIo.send = function(url, callback, method, data) {
    apiBaseUrl = apiBaseUrl || module$contents$ee$apiclient_apiclient.apiBaseUrl_;
    var responseData = getResponse(url, method, data), e = new function() {
      this.target = {};
    };
    e.target.getResponseText = function() {
      return responseData.text;
    };
    e.target.getStatus = "function" === typeof responseData.status ? responseData.status : function() {
      return responseData.status;
    };
    e.target.getResponseHeader = function(header) {
      return "Content-Type" === header ? responseData.contentType : null;
    };
    setTimeout(goog.bind(callback, e, e), 0);
    return new goog.net.XhrIo;
  };
  var fakeXmlHttp = function() {
  };
  fakeXmlHttp.prototype.open = function(method, urlIn) {
    apiBaseUrl = apiBaseUrl || module$contents$ee$apiclient_apiclient.apiBaseUrl_;
    this.url = urlIn;
    this.method = method;
  };
  fakeXmlHttp.prototype.setRequestHeader = function() {
  };
  fakeXmlHttp.prototype.getResponseHeader = function(header) {
    return "Content-Type" === header ? this.contentType_ || null : null;
  };
  fakeXmlHttp.prototype.send = function(data) {
    var responseData = getResponse(this.url, this.method, data);
    this.responseText = responseData.text;
    this.status = "function" === typeof responseData.status ? responseData.status() : responseData.status;
    this.contentType_ = responseData.contentType;
  };
  goog.net.XmlHttp.setGlobalFactory({createInstance:function() {
    return new fakeXmlHttp;
  }, getOptions:function() {
    return {};
  }});
};
module$contents$ee$apiclient_apiclient.isAuthTokenRefreshingEnabled_ = function() {
  return !(!module$contents$ee$apiclient_apiclient.authTokenRefresher_ || !module$contents$ee$apiclient_apiclient.authClientId_);
};
module$contents$ee$apiclient_apiclient.calculateRetryWait_ = function(retryCount) {
  return Math.min(module$contents$ee$apiclient_apiclient.MAX_RETRY_WAIT_, Math.pow(2, retryCount) * module$contents$ee$apiclient_apiclient.BASE_RETRY_WAIT_);
};
module$contents$ee$apiclient_apiclient.sleep_ = function(timeInMs) {
  for (var end = (new Date).getTime() + timeInMs; (new Date).getTime() < end;) {
  }
};
module$contents$ee$apiclient_apiclient.NetworkRequest_ = function() {
};
module$contents$ee$apiclient_apiclient.requestQueue_ = [];
module$contents$ee$apiclient_apiclient.REQUEST_THROTTLE_INTERVAL_MS_ = 350;
module$contents$ee$apiclient_apiclient.RequestThrottle_ = new module$contents$goog$async$Throttle_Throttle(function() {
  var request = module$contents$ee$apiclient_apiclient.requestQueue_.shift();
  request && goog.net.XhrIo.send(request.url, request.callback, request.method, request.content, request.headers, module$contents$ee$apiclient_apiclient.deadlineMs_);
  goog.array.isEmpty(module$contents$ee$apiclient_apiclient.requestQueue_) || module$contents$ee$apiclient_apiclient.RequestThrottle_.fire();
}, module$contents$ee$apiclient_apiclient.REQUEST_THROTTLE_INTERVAL_MS_);
module$contents$ee$apiclient_apiclient.apiBaseUrl_ = null;
module$contents$ee$apiclient_apiclient.tileBaseUrl_ = null;
module$contents$ee$apiclient_apiclient.xsrfToken_ = null;
module$contents$ee$apiclient_apiclient.appIdToken_ = null;
module$contents$ee$apiclient_apiclient.paramAugmenter_ = goog.functions.identity;
module$contents$ee$apiclient_apiclient.authToken_ = null;
module$contents$ee$apiclient_apiclient.authTokenExpiration_ = null;
module$contents$ee$apiclient_apiclient.authClientId_ = null;
module$contents$ee$apiclient_apiclient.authScopes_ = [];
module$contents$ee$apiclient_apiclient.authTokenRefresher_ = null;
module$contents$ee$apiclient_apiclient.AUTH_SCOPE_ = "https://www.googleapis.com/auth/earthengine";
module$contents$ee$apiclient_apiclient.CLOUD_PLATFORM_SCOPE_ = "https://www.googleapis.com/auth/cloud-platform";
module$contents$ee$apiclient_apiclient.AUTH_LIBRARY_URL_ = goog.string.Const.from("https://apis.google.com/js/client.js?onload=%{onload}");
module$contents$ee$apiclient_apiclient.STORAGE_SCOPE_ = "https://www.googleapis.com/auth/devstorage.read_write";
module$contents$ee$apiclient_apiclient.cloudApiKey_ = null;
module$contents$ee$apiclient_apiclient.cloudApiEnabled_ = !0;
module$contents$ee$apiclient_apiclient.initialized_ = !1;
module$contents$ee$apiclient_apiclient.deadlineMs_ = 0;
module$contents$ee$apiclient_apiclient.profileHook_ = null;
module$contents$ee$apiclient_apiclient.BASE_RETRY_WAIT_ = 1000;
module$contents$ee$apiclient_apiclient.MAX_RETRY_WAIT_ = 120000;
module$contents$ee$apiclient_apiclient.MAX_ASYNC_RETRIES_ = 10;
module$contents$ee$apiclient_apiclient.MAX_SYNC_RETRIES_ = 5;
module$contents$ee$apiclient_apiclient.APP_ID_TOKEN_HEADER_ = "X-Earth-Engine-App-ID-Token";
module$contents$ee$apiclient_apiclient.PROFILE_HEADER = "X-Earth-Engine-Computation-Profile";
module$contents$ee$apiclient_apiclient.PROFILE_REQUEST_HEADER = "X-Earth-Engine-Computation-Profile";
module$contents$ee$apiclient_apiclient.USER_PROJECT_OVERRIDE_HEADER_ = "X-Goog-User-Project";
module$contents$ee$apiclient_apiclient.API_CLIENT_VERSION_HEADER = "x-goog-api-client";
module$contents$ee$apiclient_apiclient.DEFAULT_API_BASE_URL_ = "https://earthengine.googleapis.com/api";
module$contents$ee$apiclient_apiclient.DEFAULT_TILE_BASE_URL_ = "https://earthengine.googleapis.com";
module$contents$ee$apiclient_apiclient.AuthArgs = function() {
};
module$contents$ee$apiclient_apiclient.AuthResponse = function() {
};
ee.apiclient.Call = module$contents$ee$apiclient_Call;
ee.apiclient.BatchCall = module$contents$ee$apiclient_BatchCall;
ee.apiclient.setApiKey = module$contents$ee$apiclient_apiclient.setApiKey;
ee.apiclient.getApiKey = module$contents$ee$apiclient_apiclient.getApiKey;
ee.apiclient.setProject = module$contents$ee$apiclient_apiclient.setProject;
ee.apiclient.getProject = module$contents$ee$apiclient_apiclient.getProject;
ee.apiclient.setCloudApiEnabled = module$contents$ee$apiclient_apiclient.setCloudApiEnabled;
ee.apiclient.getCloudApiEnabled = module$contents$ee$apiclient_apiclient.getCloudApiEnabled;
ee.apiclient.DEFAULT_PROJECT = module$contents$ee$apiclient_apiclient.DEFAULT_PROJECT_;
ee.apiclient.PROFILE_HEADER = module$contents$ee$apiclient_apiclient.PROFILE_HEADER;
ee.apiclient.PROFILE_REQUEST_HEADER = module$contents$ee$apiclient_apiclient.PROFILE_REQUEST_HEADER;
ee.apiclient.API_CLIENT_VERSION_HEADER = module$contents$ee$apiclient_apiclient.API_CLIENT_VERSION_HEADER;
ee.apiclient.send = module$contents$ee$apiclient_apiclient.send;
ee.apiclient.AUTH_SCOPE = module$contents$ee$apiclient_apiclient.AUTH_SCOPE_;
ee.apiclient.CLOUD_PLATFORM_SCOPE = module$contents$ee$apiclient_apiclient.CLOUD_PLATFORM_SCOPE_;
ee.apiclient.STORAGE_SCOPE = module$contents$ee$apiclient_apiclient.STORAGE_SCOPE_;
ee.apiclient.makeRequest = module$contents$ee$apiclient_apiclient.makeRequest_;
ee.apiclient.reset = module$contents$ee$apiclient_apiclient.reset;
ee.apiclient.initialize = module$contents$ee$apiclient_apiclient.initialize;
ee.apiclient.setDeadline = module$contents$ee$apiclient_apiclient.setDeadline;
ee.apiclient.isInitialized = module$contents$ee$apiclient_apiclient.isInitialized;
ee.apiclient.ensureAuthLibLoaded = module$contents$ee$apiclient_apiclient.ensureAuthLibLoaded_;
ee.apiclient.handleAuthResult = module$contents$ee$apiclient_apiclient.handleAuthResult_;
ee.apiclient.refreshAuthToken = module$contents$ee$apiclient_apiclient.refreshAuthToken;
ee.apiclient.setAuthClient = module$contents$ee$apiclient_apiclient.setAuthClient;
ee.apiclient.getAuthScopes = module$contents$ee$apiclient_apiclient.getAuthScopes;
ee.apiclient.getAuthClientId = module$contents$ee$apiclient_apiclient.getAuthClientId;
ee.apiclient.getAuthToken = module$contents$ee$apiclient_apiclient.getAuthToken;
ee.apiclient.setAuthToken = module$contents$ee$apiclient_apiclient.setAuthToken;
ee.apiclient.clearAuthToken = module$contents$ee$apiclient_apiclient.clearAuthToken;
ee.apiclient.setAuthTokenRefresher = module$contents$ee$apiclient_apiclient.setAuthTokenRefresher;
ee.apiclient.setAppIdToken = module$contents$ee$apiclient_apiclient.setAppIdToken;
ee.apiclient.setupMockSend = module$contents$ee$apiclient_apiclient.setupMockSend;
ee.apiclient.setParamAugmenter = module$contents$ee$apiclient_apiclient.setParamAugmenter;
ee.apiclient.withProfiling = module$contents$ee$apiclient_apiclient.withProfiling;
ee.apiclient.getApiBaseUrl = module$contents$ee$apiclient_apiclient.getApiBaseUrl;
ee.apiclient.getTileBaseUrl = module$contents$ee$apiclient_apiclient.getTileBaseUrl;
ee.apiclient.AuthArgs = module$contents$ee$apiclient_apiclient.AuthArgs;
ee.apiclient.AuthResponse = module$contents$ee$apiclient_apiclient.AuthResponse;
ee.apiclient.RequestThrottle = module$contents$ee$apiclient_apiclient.RequestThrottle_;
ee.apiclient.calculateRetryWait = module$contents$ee$apiclient_apiclient.calculateRetryWait_;
ee.apiclient.MAX_ASYNC_RETRIES = module$contents$ee$apiclient_apiclient.MAX_ASYNC_RETRIES_;
ee.apiclient.REQUEST_THROTTLE_INTERVAL_MS = module$contents$ee$apiclient_apiclient.REQUEST_THROTTLE_INTERVAL_MS_;
ee.apiclient.isAuthTokenRefreshingEnabled = module$contents$ee$apiclient_apiclient.isAuthTokenRefreshingEnabled_;
goog.exportSymbol("ee.api.ListAssetsResponse", module$exports$eeapiclient$ee_api_client.ListAssetsResponse);
goog.exportSymbol("ee.api.EarthEngineAsset", module$exports$eeapiclient$ee_api_client.EarthEngineAsset);
goog.exportSymbol("ee.api.ListImagesResponse", module$exports$eeapiclient$ee_api_client.ListImagesResponse);
goog.exportSymbol("ee.api.Image", module$exports$eeapiclient$ee_api_client.Image);
goog.exportSymbol("ee.api.Operation", module$exports$eeapiclient$ee_api_client.Operation);
ee.Encodable = function() {
};
ee.rpc_node = {};
ee.rpc_node.constant = function(obj) {
  if (void 0 === obj || null === obj) {
    obj = module$exports$eeapiclient$domain_object.NULL_VALUE;
  }
  return new module$exports$eeapiclient$ee_api_client.ValueNode({constantValue:obj});
};
ee.rpc_node.reference = function(ref) {
  return new module$exports$eeapiclient$ee_api_client.ValueNode({valueReference:ref});
};
ee.rpc_node.array = function(values) {
  return new module$exports$eeapiclient$ee_api_client.ValueNode({arrayValue:new module$exports$eeapiclient$ee_api_client.ArrayValue({values:values})});
};
ee.rpc_node.dictionary = function(values) {
  return new module$exports$eeapiclient$ee_api_client.ValueNode({dictionaryValue:new module$exports$eeapiclient$ee_api_client.DictionaryValue({values:values})});
};
ee.rpc_node.functionByName = function(name, args) {
  return new module$exports$eeapiclient$ee_api_client.ValueNode({functionInvocationValue:new module$exports$eeapiclient$ee_api_client.FunctionInvocation({functionName:name, arguments:args})});
};
ee.rpc_node.functionByReference = function(ref, args) {
  return new module$exports$eeapiclient$ee_api_client.ValueNode({functionInvocationValue:new module$exports$eeapiclient$ee_api_client.FunctionInvocation({functionReference:ref, arguments:args})});
};
ee.rpc_node.functionDefinition = function(argumentNames, body) {
  return new module$exports$eeapiclient$ee_api_client.ValueNode({functionDefinitionValue:new module$exports$eeapiclient$ee_api_client.FunctionDefinition({argumentNames:argumentNames, body:body})});
};
ee.rpc_node.argumentReference = function(ref) {
  return new module$exports$eeapiclient$ee_api_client.ValueNode({argumentReference:ref});
};
ee.rpc_convert = {};
ee.rpc_convert.fileFormat = function(format) {
  if (!format) {
    return "AUTO_JPEG_PNG";
  }
  var upper = format.toUpperCase();
  switch(upper) {
    case "JPG":
      return "JPEG";
    case "AUTO":
      return "AUTO_JPEG_PNG";
    case "TIF":
    case "TIFF":
    case "GEOTIF":
    case "GEOTIFF":
      return "GEO_TIFF";
    case "TF_RECORD":
    case "TFRECORD":
      return "TF_RECORD_IMAGE";
    case "NUMPY":
      return "NPY";
    case "ZIPPED_TIF":
    case "ZIPPED_TIFF":
    case "ZIPPED_GEOTIF":
    case "ZIPPED_GEOTIFF":
      return "ZIPPED_GEO_TIFF";
    case "ZIPPED_TIF_PER_BAND":
    case "ZIPPED_TIFF_PER_BAND":
    case "ZIPPED_GEOTIF_PER_BAND":
    case "ZIPPED_GEOTIFF_PER_BAND":
      return "ZIPPED_GEO_TIFF_PER_BAND";
    default:
      return upper;
  }
};
ee.rpc_convert.tableFileFormat = function(format) {
  if (!format) {
    return "CSV";
  }
  var upper = format.toUpperCase();
  switch(upper) {
    case "TF_RECORD":
    case "TFRECORD":
      return "TF_RECORD_TABLE";
    case "JSON":
    case "GEOJSON":
      return "GEO_JSON";
    default:
      return upper;
  }
};
ee.rpc_convert.orientation = function(orientation) {
  if (!orientation) {
    return "VERTICAL";
  }
  var upper = orientation.toUpperCase();
  if ("HORIZONTAL" !== upper || "VERTICAL" !== upper) {
    throw Error('Orientation must be "horizontal" or "vertical"');
  }
  return upper;
};
ee.rpc_convert.bandList = function(bands) {
  if (!bands) {
    return [];
  }
  if ("string" === typeof bands) {
    return bands.split(",");
  }
  if (Array.isArray(bands)) {
    return bands;
  }
  throw Error("Invalid band list " + bands);
};
ee.rpc_convert.visualizationOptions = function(params) {
  var result = new module$exports$eeapiclient$ee_api_client.VisualizationOptions, hasResult = !1;
  if ("palette" in params) {
    var pal = params.palette;
    result.paletteColors = "string" === typeof pal ? pal.split(",") : pal;
    hasResult = !0;
  }
  var ranges = [];
  if ("gain" in params || "bias" in params) {
    if ("min" in params || "max" in params) {
      throw Error("Gain and bias can't be specified with min and max");
    }
    var valueRange = result.paletteColors ? result.paletteColors.length - 1 : 255;
    ranges = ee.rpc_convert.pairedValues(params, "bias", "gain").map(function(pair) {
      var min = -pair.bias / pair.gain;
      return {min:min, max:valueRange / pair.gain + min};
    });
  } else {
    if ("min" in params || "max" in params) {
      ranges = ee.rpc_convert.pairedValues(params, "min", "max");
    }
  }
  0 !== ranges.length && (result.ranges = ranges.map(function(range) {
    return new module$exports$eeapiclient$ee_api_client.DoubleRange(range);
  }), hasResult = !0);
  var gammas = ee.rpc_convert.csvToNumbers(params.gamma);
  if (1 < gammas.length) {
    throw Error("Only one gamma value is supported");
  }
  1 === gammas.length && (result.gamma = gammas[0], hasResult = !0);
  return hasResult ? result : null;
};
ee.rpc_convert.csvToNumbers = function(csv) {
  return csv ? csv.split(",").map(Number) : [];
};
ee.rpc_convert.pairedValues = function(obj, a, b) {
  var aValues = ee.rpc_convert.csvToNumbers(obj[a]), bValues = ee.rpc_convert.csvToNumbers(obj[b]);
  if (0 === aValues.length) {
    return bValues.map(function(value) {
      var $jscomp$compprop1 = {};
      return $jscomp$compprop1[a] = 0, $jscomp$compprop1[b] = value, $jscomp$compprop1;
    });
  }
  if (0 === bValues.length) {
    return aValues.map(function(value) {
      var $jscomp$compprop2 = {};
      return $jscomp$compprop2[a] = value, $jscomp$compprop2[b] = 1, $jscomp$compprop2;
    });
  }
  if (aValues.length !== bValues.length) {
    throw Error("Length of " + a + " and " + b + " must match.");
  }
  return aValues.map(function(value, index) {
    var $jscomp$compprop3 = {};
    return $jscomp$compprop3[a] = value, $jscomp$compprop3[b] = bValues[index], $jscomp$compprop3;
  });
};
ee.rpc_convert.algorithms = function(result) {
  for (var convertArgument = function(argument) {
    var internalArgument = {};
    internalArgument.description = argument.description || "";
    internalArgument.type = argument.type || "";
    null != argument.argumentName && (internalArgument.name = argument.argumentName);
    void 0 !== argument.defaultValue && (internalArgument["default"] = argument.defaultValue);
    null != argument.optional && (internalArgument.optional = argument.optional);
    return internalArgument;
  }, convertAlgorithm = function(algorithm) {
    var internalAlgorithm = {};
    internalAlgorithm.args = (algorithm.arguments || []).map(convertArgument);
    internalAlgorithm.description = algorithm.description || "";
    internalAlgorithm.returns = algorithm.returnType || "";
    null != algorithm.hidden && (internalAlgorithm.hidden = algorithm.hidden);
    algorithm.preview && (internalAlgorithm.preview = algorithm.preview);
    algorithm.deprecated && (internalAlgorithm.deprecated = algorithm.deprecationReason);
    algorithm.sourceCodeUri && (internalAlgorithm.sourceCodeUri = algorithm.sourceCodeUri);
    return internalAlgorithm;
  }, internalAlgorithms = {}, $jscomp$iter$13 = $jscomp.makeIterator(result.algorithms || []), $jscomp$key$algorithm = $jscomp$iter$13.next(); !$jscomp$key$algorithm.done; $jscomp$key$algorithm = $jscomp$iter$13.next()) {
    var algorithm$jscomp$0 = $jscomp$key$algorithm.value, name = algorithm$jscomp$0.name.replace(/^algorithms\//, "");
    internalAlgorithms[name] = convertAlgorithm(algorithm$jscomp$0);
  }
  return internalAlgorithms;
};
ee.rpc_convert.DEFAULT_PROJECT = "earthengine-legacy";
ee.rpc_convert.PUBLIC_PROJECT = "earthengine-public";
ee.rpc_convert.PROJECT_ID_RE = /^projects\/((?:\w+(?:[\w\-]+\.[\w\-]+)*?\.\w+:)?[a-z][a-z0-9\-]{4,28}[a-z0-9])\/.+/;
ee.rpc_convert.CLOUD_ASSET_ID_RE = /^projects\/((?:\w+(?:[\w\-]+\.[\w\-]+)*?\.\w+:)?[a-z][a-z0-9\-]{4,28}[a-z0-9])\/assets\/(.*)$/;
ee.rpc_convert.CLOUD_ASSET_ROOT_RE = /^projects\/((?:\w+(?:[\w\-]+\.[\w\-]+)*?\.\w+:)?[a-z][a-z0-9\-]{4,28}[a-z0-9])\/assets\/?$/;
ee.rpc_convert.projectIdFromPath = function(path) {
  var matches = ee.rpc_convert.PROJECT_ID_RE.exec(path);
  return matches ? matches[1] : ee.rpc_convert.DEFAULT_PROJECT;
};
ee.rpc_convert.projectParentFromPath = function(path) {
  return "projects/" + ee.rpc_convert.projectIdFromPath(path);
};
ee.rpc_convert.assetIdToAssetName = function(param) {
  return ee.rpc_convert.CLOUD_ASSET_ID_RE.exec(param) ? param : /^(users|projects)\/.*/.exec(param) ? "projects/" + ee.rpc_convert.DEFAULT_PROJECT + "/assets/" + param : "projects/" + ee.rpc_convert.PUBLIC_PROJECT + "/assets/" + param;
};
ee.rpc_convert.assetNameToAssetId = function(name) {
  var parts = name.split("/"), isLegacyProject = function(id) {
    return [ee.rpc_convert.DEFAULT_PROJECT, ee.rpc_convert.PUBLIC_PROJECT].includes(id);
  };
  return "projects" === parts[0] && "assets" === parts[2] && isLegacyProject(parts[1]) ? parts.slice(3).join("/") : name;
};
ee.rpc_convert.assetTypeForCreate = function(param) {
  switch(param) {
    case "ImageCollection":
      return "IMAGE_COLLECTION";
    case "Folder":
      return "FOLDER";
    default:
      return param;
  }
};
ee.rpc_convert.listAssetsToGetList = function(result) {
  return (result.assets || []).map(ee.rpc_convert.assetToLegacyResult);
};
ee.rpc_convert.listImagesToGetList = function(result) {
  return (result.images || []).map(ee.rpc_convert.imageToLegacyResult);
};
ee.rpc_convert.assetTypeToLegacyAssetType = function(type) {
  switch(type) {
    case "ALGORITHM":
      return "Algorithm";
    case "FOLDER":
      return "Folder";
    case "IMAGE":
      return "Image";
    case "IMAGE_COLLECTION":
      return "ImageCollection";
    case "TABLE":
      return "Table";
    default:
      return "Unknown";
  }
};
ee.rpc_convert.legacyAssetTypeToAssetType = function(type) {
  switch(type) {
    case "Algorithm":
      return "ALGORITHM";
    case "Folder":
      return "FOLDER";
    case "Image":
      return "IMAGE";
    case "ImageCollection":
      return "IMAGE_COLLECTION";
    case "Table":
      return "TABLE";
    default:
      return "UNKNOWN";
  }
};
ee.rpc_convert.assetToLegacyResult = function(result) {
  var asset = ee.rpc_convert.makeLegacyAsset_(ee.rpc_convert.assetTypeToLegacyAssetType(result.type), result.name), properties = Object.assign({}, result.properties || {});
  result.sizeBytes && (properties["system:asset_size"] = Number(result.sizeBytes));
  result.startTime && (properties["system:time_start"] = Date.parse(result.startTime));
  result.endTime && (properties["system:time_end"] = Date.parse(result.endTime));
  result.geometry && (properties["system:footprint"] = result.geometry);
  "string" === typeof result.title && (properties["system:title"] = result.title);
  "string" === typeof result.description && (properties["system:description"] = result.description);
  result.updateTime && (asset.version = 1000 * Date.parse(result.updateTime));
  asset.properties = properties;
  result.bands && (asset.bands = result.bands.map(function(band) {
    var legacyBand = {id:band.id, crs:band.grid.crsCode, dimensions:void 0, crs_transform:void 0, };
    if (band.grid) {
      if (null != band.grid.affineTransform) {
        var affine = band.grid.affineTransform;
        legacyBand.crs_transform = [affine.scaleX || 0, affine.shearX || 0, affine.translateX || 0, affine.shearY || 0, affine.scaleY || 0, affine.translateY || 0, ];
      }
      null != band.grid.dimensions && (legacyBand.dimensions = [band.grid.dimensions.width, band.grid.dimensions.height]);
    }
    if (band.dataType) {
      var dataType = {type:"PixelType"};
      dataType.precision = (band.dataType.precision || "").toLowerCase();
      band.dataType.range && (dataType.min = band.dataType.range.min || 0, dataType.max = band.dataType.range.max);
      legacyBand.data_type = dataType;
    }
    return legacyBand;
  }));
  return asset;
};
ee.rpc_convert.legacyPropertiesToAssetUpdate = function(legacyProperties) {
  var asset = new module$exports$eeapiclient$ee_api_client.EarthEngineAsset, toTimestamp = function(msec) {
    return (new Date(Number(msec))).toISOString();
  }, properties = Object.assign({}, legacyProperties), value, extractValue = function(key) {
    value = properties[key];
    delete properties[key];
    return value;
  };
  extractValue("system:asset_size") && (asset.sizeBytes = String(value));
  extractValue("system:time_start") && (asset.startTime = toTimestamp(value));
  extractValue("system:time_end") && (asset.endTime = toTimestamp(value));
  extractValue("system:footprint") && (asset.geometry = value);
  "string" === typeof extractValue("system:title") && (asset.title = value);
  "string" === typeof extractValue("system:description") && (asset.description = value);
  asset.properties = properties;
  return asset;
};
ee.rpc_convert.imageToLegacyResult = function(result) {
  return ee.rpc_convert.makeLegacyAsset_("Image", result.name);
};
ee.rpc_convert.makeLegacyAsset_ = function(type, name) {
  var legacyAsset = {};
  legacyAsset.type = type;
  null != name && (legacyAsset.id = ee.rpc_convert.assetNameToAssetId(name));
  return legacyAsset;
};
ee.rpc_convert.getListToListImages = function(param) {
  var imagesRequest = {}, toTimestamp = function(msec) {
    return (new Date(msec)).toISOString();
  };
  param.num && (imagesRequest.pageSize = param.num);
  param.starttime && (imagesRequest.startTime = toTimestamp(param.starttime));
  param.endtime && (imagesRequest.endTime = toTimestamp(param.endtime));
  param.bbox && (imagesRequest.region = ee.rpc_convert.boundingBoxToGeoJson(param.bbox));
  param.region && (imagesRequest.region = param.region);
  param.bbox && param.region && console.warn("Multiple request parameters converted to region");
  for (var allKeys = "id num starttime endtime bbox region".split(" "), $jscomp$iter$14 = $jscomp.makeIterator(Object.keys(param).filter(function(k) {
    return !allKeys.includes(k);
  })), $jscomp$key$key = $jscomp$iter$14.next(); !$jscomp$key$key.done; $jscomp$key$key = $jscomp$iter$14.next()) {
    console.warn("Unrecognized key " + $jscomp$key$key.value + " ignored");
  }
  imagesRequest.fields = "assets(type,path)";
  return imagesRequest;
};
ee.rpc_convert.boundingBoxToGeoJson = function(bbox) {
  return '{"type":"Polygon","coordinates":[[[' + [[0, 1], [2, 1], [2, 3], [0, 3], [0, 1]].map(function(i) {
    return bbox[i[0]] + "," + bbox[i[1]];
  }).join("],[") + "]]]}";
};
ee.rpc_convert.iamPolicyToAcl = function(result) {
  var bindingMap = {};
  (result.bindings || []).forEach(function(binding) {
    bindingMap[binding.role] = binding.members;
  });
  var groups = new Set, toAcl = function(member) {
    var email = member.replace(/^group:|^user:|^serviceAccount:/, "");
    member.startsWith("group:") && groups.add(email);
    return email;
  }, readersWithAll = bindingMap["roles/viewer"] || [], readers = readersWithAll.filter(function(reader) {
    return "allUsers" !== reader;
  }), internalAcl = {owners:(bindingMap["roles/owner"] || []).map(toAcl), writers:(bindingMap["roles/editor"] || []).map(toAcl), readers:readers.map(toAcl), };
  0 < groups.size && (internalAcl.groups = groups);
  readersWithAll.length != readers.length && (internalAcl.all_users_can_read = !0);
  return internalAcl;
};
ee.rpc_convert.aclToIamPolicy = function(acls) {
  var isGroup = function(email) {
    return acls.groups && acls.groups.has(email);
  }, isServiceAccount = function(email) {
    return email.match(/[@|\.]gserviceaccount\.com$/);
  }, asMembers = function(aclName) {
    return (acls[aclName] || []).map(function(email) {
      var prefix = "user:";
      isGroup(email) ? prefix = "group:" : isServiceAccount(email) && (prefix = "serviceAccount:");
      return prefix + email;
    });
  }, all = acls.all_users_can_read ? ["allUsers"] : [], bindings = [{role:"roles/owner", members:asMembers("owners")}, {role:"roles/viewer", members:asMembers("readers").concat(all)}, {role:"roles/editor", members:asMembers("writers")}, ].map(function(params) {
    return new module$exports$eeapiclient$ee_api_client.Binding(params);
  });
  return new module$exports$eeapiclient$ee_api_client.Policy({bindings:bindings.filter(function(binding) {
    return binding.members.length;
  }), etag:null, });
};
ee.rpc_convert.taskIdToOperationName = function(param) {
  return "projects/" + ee.rpc_convert.DEFAULT_PROJECT + "/operations/" + param;
};
ee.rpc_convert.operationNameToTaskId = function(result) {
  var found = /^.*operations\/(.*)$/.exec(result);
  return found ? found[1] : result;
};
ee.rpc_convert.operationToTask = function(result) {
  var internalTask = {}, assignTimestamp = function(field, timestamp) {
    null != timestamp && (internalTask[field] = Date.parse(timestamp));
  }, convertState = function(state) {
    switch(state) {
      case "PENDING":
        return "READY";
      case "RUNNING":
        return "RUNNING";
      case "CANCELLING":
        return "CANCEL_REQUESTED";
      case "SUCCEEDED":
        return "COMPLETED";
      case "CANCELLED":
        return "CANCELLED";
      case "FAILED":
        return "FAILED";
      default:
        return "UNKNOWN";
    }
  }, metadata = module$contents$eeapiclient$domain_object_deserialize(module$exports$eeapiclient$ee_api_client.OperationMetadata, result.metadata || {});
  null != metadata.description && (internalTask.description = metadata.description);
  null != metadata.state && (internalTask.state = convertState(metadata.state));
  assignTimestamp("creation_timestamp_ms", metadata.createTime);
  assignTimestamp("update_timestamp_ms", metadata.updateTime);
  assignTimestamp("start_timestamp_ms", metadata.startTime);
  result.done && null != result.error && (internalTask.error_message = result.error.message);
  null != result.name && (internalTask.id = ee.rpc_convert.operationNameToTaskId(result.name), internalTask.name = result.name);
  internalTask.task_type = metadata.type || "UNKNOWN";
  internalTask.output_url = metadata.destinationUris;
  internalTask.source_url = metadata.scriptUri;
  return internalTask;
};
ee.rpc_convert.operationToProcessingResponse = function(operation) {
  var result = {started:"OK"};
  operation.name && (result.taskId = ee.rpc_convert.operationNameToTaskId(operation.name), result.name = operation.name);
  operation.error && (result.note = operation.error.message);
  return result;
};
ee.rpc_convert.sourcePathsToUris = function(source) {
  return source.primaryPath ? [source.primaryPath].concat($jscomp.arrayFromIterable(source.additionalPaths || [])) : null;
};
ee.rpc_convert.toImageManifest = function(params) {
  var convertImageSource = function(source) {
    var apiSource = module$contents$eeapiclient$domain_object_deserialize(module$exports$eeapiclient$ee_api_client.ImageSource, source);
    apiSource.uris = ee.rpc_convert.sourcePathsToUris(source);
    return apiSource;
  }, manifest = module$contents$eeapiclient$domain_object_deserialize(module$exports$eeapiclient$ee_api_client.ImageManifest, params);
  manifest.name = ee.rpc_convert.assetIdToAssetName(params.id);
  manifest.tilesets = (params.tilesets || []).map(function(tileset) {
    var apiTileset = module$contents$eeapiclient$domain_object_deserialize(module$exports$eeapiclient$ee_api_client.Tileset, tileset);
    apiTileset.sources = (tileset.sources || []).map(convertImageSource);
    return apiTileset;
  });
  manifest.bands = (params.bands || []).map(function(band) {
    var apiBand = module$contents$eeapiclient$domain_object_deserialize(module$exports$eeapiclient$ee_api_client.TilesetBand, band);
    apiBand.missingData = ee.rpc_convert.toOnePlatformMissingData(band.missingData);
    return apiBand;
  });
  manifest.missingData = ee.rpc_convert.toOnePlatformMissingData(params.missingData);
  manifest.maskBands = goog.array.flatten((params.tilesets || []).map(ee.rpc_convert.toOnePlatformMaskBands));
  manifest.pyramidingPolicy = params.pyramidingPolicy || null;
  if (params.properties) {
    var properties = Object.assign({}, params.properties), toTimestamp = function(msec) {
      return (new Date(Number(msec))).toISOString();
    }, value, extractValue = function(key) {
      value = properties[key];
      delete properties[key];
      return value;
    };
    extractValue("system:time_start") && (manifest.startTime = toTimestamp(value));
    extractValue("system:time_end") && (manifest.endTime = toTimestamp(value));
    manifest.properties = properties;
  }
  return manifest;
};
ee.rpc_convert.toOnePlatformMaskBands = function(tileset) {
  var maskBands = [];
  if (!Array.isArray(tileset.fileBands)) {
    return maskBands;
  }
  var convertMaskConfig = function(maskConfig) {
    var bandIds = [];
    null != maskConfig && Array.isArray(maskConfig.bandId) && (bandIds = maskConfig.bandId.map(function(bandId) {
      return bandId || "";
    }));
    return new module$exports$eeapiclient$ee_api_client.TilesetMaskBand({tilesetId:tileset.id || "", bandIds:bandIds});
  };
  tileset.fileBands.forEach(function(fileBand) {
    fileBand.maskForAllBands ? maskBands.push(convertMaskConfig(null)) : null != fileBand.maskForBands && maskBands.push(convertMaskConfig(fileBand.maskForBands));
  });
  return maskBands;
};
ee.rpc_convert.toTableManifest = function(params) {
  var manifest = module$contents$eeapiclient$domain_object_deserialize(module$exports$eeapiclient$ee_api_client.TableManifest, params);
  manifest.name = ee.rpc_convert.assetIdToAssetName(params.id);
  manifest.sources = (params.sources || []).map(function(source) {
    var apiSource = module$contents$eeapiclient$domain_object_deserialize(module$exports$eeapiclient$ee_api_client.TableSource, source);
    apiSource.uris = ee.rpc_convert.sourcePathsToUris(source);
    source.maxError && (apiSource.maxErrorMeters = source.maxError);
    return apiSource;
  });
  if (params.properties) {
    var properties = Object.assign({}, params.properties), toTimestamp = function(msec) {
      return (new Date(Number(msec))).toISOString();
    }, value, extractValue = function(key) {
      value = properties[key];
      delete properties[key];
      return value;
    };
    extractValue("system:time_start") && (manifest.startTime = toTimestamp(value));
    extractValue("system:time_end") && (manifest.endTime = toTimestamp(value));
    manifest.properties = properties;
  }
  return manifest;
};
ee.rpc_convert.toOnePlatformMissingData = function(params) {
  if (null == params) {
    return null;
  }
  var missingData = new module$exports$eeapiclient$ee_api_client.MissingData({values:[]});
  null != params.value && "number" === typeof params.value && missingData.values.push(params.value);
  Array.isArray(params.values) && params.values.map(function(value) {
    "number" === typeof value && missingData.values.push(value);
  });
  return goog.array.isEmpty(missingData.values) ? null : missingData;
};
goog.crypt = {};
goog.crypt.Hash = function() {
  this.blockSize = -1;
};
goog.crypt.Md5 = function() {
  goog.crypt.Hash.call(this);
  this.blockSize = 64;
  this.chain_ = Array(4);
  this.block_ = Array(this.blockSize);
  this.totalLength_ = this.blockLength_ = 0;
  this.reset();
};
goog.inherits(goog.crypt.Md5, goog.crypt.Hash);
goog.crypt.Md5.prototype.reset = function() {
  this.chain_[0] = 1732584193;
  this.chain_[1] = 4023233417;
  this.chain_[2] = 2562383102;
  this.chain_[3] = 271733878;
  this.totalLength_ = this.blockLength_ = 0;
};
goog.crypt.Md5.prototype.compress_ = function(buf, opt_offset) {
  opt_offset || (opt_offset = 0);
  var X = Array(16);
  if ("string" === typeof buf) {
    for (var i = 0; 16 > i; ++i) {
      X[i] = buf.charCodeAt(opt_offset++) | buf.charCodeAt(opt_offset++) << 8 | buf.charCodeAt(opt_offset++) << 16 | buf.charCodeAt(opt_offset++) << 24;
    }
  } else {
    for (i = 0; 16 > i; ++i) {
      X[i] = buf[opt_offset++] | buf[opt_offset++] << 8 | buf[opt_offset++] << 16 | buf[opt_offset++] << 24;
    }
  }
  var A = this.chain_[0], B = this.chain_[1], C = this.chain_[2], D = this.chain_[3], sum = 0;
  sum = A + (D ^ B & (C ^ D)) + X[0] + 3614090360 & 4294967295;
  A = B + (sum << 7 & 4294967295 | sum >>> 25);
  sum = D + (C ^ A & (B ^ C)) + X[1] + 3905402710 & 4294967295;
  D = A + (sum << 12 & 4294967295 | sum >>> 20);
  sum = C + (B ^ D & (A ^ B)) + X[2] + 606105819 & 4294967295;
  C = D + (sum << 17 & 4294967295 | sum >>> 15);
  sum = B + (A ^ C & (D ^ A)) + X[3] + 3250441966 & 4294967295;
  B = C + (sum << 22 & 4294967295 | sum >>> 10);
  sum = A + (D ^ B & (C ^ D)) + X[4] + 4118548399 & 4294967295;
  A = B + (sum << 7 & 4294967295 | sum >>> 25);
  sum = D + (C ^ A & (B ^ C)) + X[5] + 1200080426 & 4294967295;
  D = A + (sum << 12 & 4294967295 | sum >>> 20);
  sum = C + (B ^ D & (A ^ B)) + X[6] + 2821735955 & 4294967295;
  C = D + (sum << 17 & 4294967295 | sum >>> 15);
  sum = B + (A ^ C & (D ^ A)) + X[7] + 4249261313 & 4294967295;
  B = C + (sum << 22 & 4294967295 | sum >>> 10);
  sum = A + (D ^ B & (C ^ D)) + X[8] + 1770035416 & 4294967295;
  A = B + (sum << 7 & 4294967295 | sum >>> 25);
  sum = D + (C ^ A & (B ^ C)) + X[9] + 2336552879 & 4294967295;
  D = A + (sum << 12 & 4294967295 | sum >>> 20);
  sum = C + (B ^ D & (A ^ B)) + X[10] + 4294925233 & 4294967295;
  C = D + (sum << 17 & 4294967295 | sum >>> 15);
  sum = B + (A ^ C & (D ^ A)) + X[11] + 2304563134 & 4294967295;
  B = C + (sum << 22 & 4294967295 | sum >>> 10);
  sum = A + (D ^ B & (C ^ D)) + X[12] + 1804603682 & 4294967295;
  A = B + (sum << 7 & 4294967295 | sum >>> 25);
  sum = D + (C ^ A & (B ^ C)) + X[13] + 4254626195 & 4294967295;
  D = A + (sum << 12 & 4294967295 | sum >>> 20);
  sum = C + (B ^ D & (A ^ B)) + X[14] + 2792965006 & 4294967295;
  C = D + (sum << 17 & 4294967295 | sum >>> 15);
  sum = B + (A ^ C & (D ^ A)) + X[15] + 1236535329 & 4294967295;
  B = C + (sum << 22 & 4294967295 | sum >>> 10);
  sum = A + (C ^ D & (B ^ C)) + X[1] + 4129170786 & 4294967295;
  A = B + (sum << 5 & 4294967295 | sum >>> 27);
  sum = D + (B ^ C & (A ^ B)) + X[6] + 3225465664 & 4294967295;
  D = A + (sum << 9 & 4294967295 | sum >>> 23);
  sum = C + (A ^ B & (D ^ A)) + X[11] + 643717713 & 4294967295;
  C = D + (sum << 14 & 4294967295 | sum >>> 18);
  sum = B + (D ^ A & (C ^ D)) + X[0] + 3921069994 & 4294967295;
  B = C + (sum << 20 & 4294967295 | sum >>> 12);
  sum = A + (C ^ D & (B ^ C)) + X[5] + 3593408605 & 4294967295;
  A = B + (sum << 5 & 4294967295 | sum >>> 27);
  sum = D + (B ^ C & (A ^ B)) + X[10] + 38016083 & 4294967295;
  D = A + (sum << 9 & 4294967295 | sum >>> 23);
  sum = C + (A ^ B & (D ^ A)) + X[15] + 3634488961 & 4294967295;
  C = D + (sum << 14 & 4294967295 | sum >>> 18);
  sum = B + (D ^ A & (C ^ D)) + X[4] + 3889429448 & 4294967295;
  B = C + (sum << 20 & 4294967295 | sum >>> 12);
  sum = A + (C ^ D & (B ^ C)) + X[9] + 568446438 & 4294967295;
  A = B + (sum << 5 & 4294967295 | sum >>> 27);
  sum = D + (B ^ C & (A ^ B)) + X[14] + 3275163606 & 4294967295;
  D = A + (sum << 9 & 4294967295 | sum >>> 23);
  sum = C + (A ^ B & (D ^ A)) + X[3] + 4107603335 & 4294967295;
  C = D + (sum << 14 & 4294967295 | sum >>> 18);
  sum = B + (D ^ A & (C ^ D)) + X[8] + 1163531501 & 4294967295;
  B = C + (sum << 20 & 4294967295 | sum >>> 12);
  sum = A + (C ^ D & (B ^ C)) + X[13] + 2850285829 & 4294967295;
  A = B + (sum << 5 & 4294967295 | sum >>> 27);
  sum = D + (B ^ C & (A ^ B)) + X[2] + 4243563512 & 4294967295;
  D = A + (sum << 9 & 4294967295 | sum >>> 23);
  sum = C + (A ^ B & (D ^ A)) + X[7] + 1735328473 & 4294967295;
  C = D + (sum << 14 & 4294967295 | sum >>> 18);
  sum = B + (D ^ A & (C ^ D)) + X[12] + 2368359562 & 4294967295;
  B = C + (sum << 20 & 4294967295 | sum >>> 12);
  sum = A + (B ^ C ^ D) + X[5] + 4294588738 & 4294967295;
  A = B + (sum << 4 & 4294967295 | sum >>> 28);
  sum = D + (A ^ B ^ C) + X[8] + 2272392833 & 4294967295;
  D = A + (sum << 11 & 4294967295 | sum >>> 21);
  sum = C + (D ^ A ^ B) + X[11] + 1839030562 & 4294967295;
  C = D + (sum << 16 & 4294967295 | sum >>> 16);
  sum = B + (C ^ D ^ A) + X[14] + 4259657740 & 4294967295;
  B = C + (sum << 23 & 4294967295 | sum >>> 9);
  sum = A + (B ^ C ^ D) + X[1] + 2763975236 & 4294967295;
  A = B + (sum << 4 & 4294967295 | sum >>> 28);
  sum = D + (A ^ B ^ C) + X[4] + 1272893353 & 4294967295;
  D = A + (sum << 11 & 4294967295 | sum >>> 21);
  sum = C + (D ^ A ^ B) + X[7] + 4139469664 & 4294967295;
  C = D + (sum << 16 & 4294967295 | sum >>> 16);
  sum = B + (C ^ D ^ A) + X[10] + 3200236656 & 4294967295;
  B = C + (sum << 23 & 4294967295 | sum >>> 9);
  sum = A + (B ^ C ^ D) + X[13] + 681279174 & 4294967295;
  A = B + (sum << 4 & 4294967295 | sum >>> 28);
  sum = D + (A ^ B ^ C) + X[0] + 3936430074 & 4294967295;
  D = A + (sum << 11 & 4294967295 | sum >>> 21);
  sum = C + (D ^ A ^ B) + X[3] + 3572445317 & 4294967295;
  C = D + (sum << 16 & 4294967295 | sum >>> 16);
  sum = B + (C ^ D ^ A) + X[6] + 76029189 & 4294967295;
  B = C + (sum << 23 & 4294967295 | sum >>> 9);
  sum = A + (B ^ C ^ D) + X[9] + 3654602809 & 4294967295;
  A = B + (sum << 4 & 4294967295 | sum >>> 28);
  sum = D + (A ^ B ^ C) + X[12] + 3873151461 & 4294967295;
  D = A + (sum << 11 & 4294967295 | sum >>> 21);
  sum = C + (D ^ A ^ B) + X[15] + 530742520 & 4294967295;
  C = D + (sum << 16 & 4294967295 | sum >>> 16);
  sum = B + (C ^ D ^ A) + X[2] + 3299628645 & 4294967295;
  B = C + (sum << 23 & 4294967295 | sum >>> 9);
  sum = A + (C ^ (B | ~D)) + X[0] + 4096336452 & 4294967295;
  A = B + (sum << 6 & 4294967295 | sum >>> 26);
  sum = D + (B ^ (A | ~C)) + X[7] + 1126891415 & 4294967295;
  D = A + (sum << 10 & 4294967295 | sum >>> 22);
  sum = C + (A ^ (D | ~B)) + X[14] + 2878612391 & 4294967295;
  C = D + (sum << 15 & 4294967295 | sum >>> 17);
  sum = B + (D ^ (C | ~A)) + X[5] + 4237533241 & 4294967295;
  B = C + (sum << 21 & 4294967295 | sum >>> 11);
  sum = A + (C ^ (B | ~D)) + X[12] + 1700485571 & 4294967295;
  A = B + (sum << 6 & 4294967295 | sum >>> 26);
  sum = D + (B ^ (A | ~C)) + X[3] + 2399980690 & 4294967295;
  D = A + (sum << 10 & 4294967295 | sum >>> 22);
  sum = C + (A ^ (D | ~B)) + X[10] + 4293915773 & 4294967295;
  C = D + (sum << 15 & 4294967295 | sum >>> 17);
  sum = B + (D ^ (C | ~A)) + X[1] + 2240044497 & 4294967295;
  B = C + (sum << 21 & 4294967295 | sum >>> 11);
  sum = A + (C ^ (B | ~D)) + X[8] + 1873313359 & 4294967295;
  A = B + (sum << 6 & 4294967295 | sum >>> 26);
  sum = D + (B ^ (A | ~C)) + X[15] + 4264355552 & 4294967295;
  D = A + (sum << 10 & 4294967295 | sum >>> 22);
  sum = C + (A ^ (D | ~B)) + X[6] + 2734768916 & 4294967295;
  C = D + (sum << 15 & 4294967295 | sum >>> 17);
  sum = B + (D ^ (C | ~A)) + X[13] + 1309151649 & 4294967295;
  B = C + (sum << 21 & 4294967295 | sum >>> 11);
  sum = A + (C ^ (B | ~D)) + X[4] + 4149444226 & 4294967295;
  A = B + (sum << 6 & 4294967295 | sum >>> 26);
  sum = D + (B ^ (A | ~C)) + X[11] + 3174756917 & 4294967295;
  D = A + (sum << 10 & 4294967295 | sum >>> 22);
  sum = C + (A ^ (D | ~B)) + X[2] + 718787259 & 4294967295;
  C = D + (sum << 15 & 4294967295 | sum >>> 17);
  sum = B + (D ^ (C | ~A)) + X[9] + 3951481745 & 4294967295;
  this.chain_[0] = this.chain_[0] + A & 4294967295;
  this.chain_[1] = this.chain_[1] + (C + (sum << 21 & 4294967295 | sum >>> 11)) & 4294967295;
  this.chain_[2] = this.chain_[2] + C & 4294967295;
  this.chain_[3] = this.chain_[3] + D & 4294967295;
};
goog.crypt.Md5.prototype.update = function(bytes, opt_length) {
  void 0 === opt_length && (opt_length = bytes.length);
  for (var lengthMinusBlock = opt_length - this.blockSize, block = this.block_, blockLength = this.blockLength_, i = 0; i < opt_length;) {
    if (0 == blockLength) {
      for (; i <= lengthMinusBlock;) {
        this.compress_(bytes, i), i += this.blockSize;
      }
    }
    if ("string" === typeof bytes) {
      for (; i < opt_length;) {
        if (block[blockLength++] = bytes.charCodeAt(i++), blockLength == this.blockSize) {
          this.compress_(block);
          blockLength = 0;
          break;
        }
      }
    } else {
      for (; i < opt_length;) {
        if (block[blockLength++] = bytes[i++], blockLength == this.blockSize) {
          this.compress_(block);
          blockLength = 0;
          break;
        }
      }
    }
  }
  this.blockLength_ = blockLength;
  this.totalLength_ += opt_length;
};
goog.crypt.Md5.prototype.digest = function() {
  var pad = Array((56 > this.blockLength_ ? this.blockSize : 2 * this.blockSize) - this.blockLength_);
  pad[0] = 128;
  for (var i = 1; i < pad.length - 8; ++i) {
    pad[i] = 0;
  }
  var totalBits = 8 * this.totalLength_;
  for (i = pad.length - 8; i < pad.length; ++i) {
    pad[i] = totalBits & 255, totalBits /= 256;
  }
  this.update(pad);
  var digest = Array(16), n = 0;
  for (i = 0; 4 > i; ++i) {
    for (var j = 0; 32 > j; j += 8) {
      digest[n++] = this.chain_[i] >>> j & 255;
    }
  }
  return digest;
};
ee.Serializer = function(opt_isCompound) {
  this.HASH_KEY = "__ee_hash__";
  this.isCompound_ = !1 !== opt_isCompound;
  this.scope_ = [];
  this.encoded_ = {};
  this.withHashes_ = [];
  this.hashes_ = new WeakMap;
};
goog.exportSymbol("ee.Serializer", ee.Serializer);
ee.Serializer.jsonSerializer_ = new goog.json.Serializer;
ee.Serializer.hash_ = new goog.crypt.Md5;
ee.Serializer.encode = function(obj, opt_isCompound) {
  return (new ee.Serializer(void 0 !== opt_isCompound ? opt_isCompound : !0)).encode_(obj);
};
ee.Serializer.toJSON = function(obj) {
  return ee.Serializer.jsonSerializer_.serialize(ee.Serializer.encode(obj));
};
ee.Serializer.toReadableJSON = function(obj) {
  return ee.Serializer.stringify(ee.Serializer.encode(obj, !1));
};
ee.Serializer.stringify = function(encoded) {
  return "JSON" in goog.global ? goog.global.JSON.stringify(encoded, null, "  ") : ee.Serializer.jsonSerializer_.serialize(encoded);
};
ee.Serializer.prototype.encode_ = function(object) {
  var value = this.encodeValue_(object);
  this.isCompound_ && (value = goog.isObject(value) && "ValueRef" == value.type && 1 == this.scope_.length ? this.scope_[0][1] : {type:"CompoundValue", scope:this.scope_, value:value}, this.scope_ = [], goog.array.forEach(this.withHashes_, goog.bind(function(obj) {
    delete obj[this.HASH_KEY];
  }, this)), this.withHashes_ = [], this.encoded_ = {});
  return value;
};
ee.Serializer.prototype.encodeValue_ = function(object) {
  if (void 0 === object) {
    throw Error("Can't encode an undefined value.");
  }
  var hash = goog.isObject(object) ? object[this.HASH_KEY] : null;
  if (this.isCompound_ && null != hash && this.encoded_[hash]) {
    return {type:"ValueRef", value:this.encoded_[hash]};
  }
  if (null === object || "boolean" === typeof object || "number" === typeof object || "string" === typeof object) {
    return object;
  }
  if (goog.isDateLike(object)) {
    return {type:"Invocation", functionName:"Date", arguments:{value:Math.floor(object.getTime())}};
  }
  if (object instanceof ee.Encodable) {
    var result = object.encode(goog.bind(this.encodeValue_, this));
    if (!(Array.isArray(result) || goog.isObject(result) && "ArgumentRef" != result.type)) {
      return result;
    }
  } else {
    if (Array.isArray(object)) {
      result = goog.array.map(object, function(element) {
        return this.encodeValue_(element);
      }, this);
    } else {
      if (goog.isObject(object) && "function" !== typeof object) {
        var encodedObject = goog.object.map(object, function(element) {
          if ("function" !== typeof element) {
            return this.encodeValue_(element);
          }
        }, this);
        goog.object.remove(encodedObject, this.HASH_KEY);
        result = {type:"Dictionary", value:encodedObject};
      } else {
        throw Error("Can't encode object: " + object);
      }
    }
  }
  if (this.isCompound_) {
    hash = ee.Serializer.computeHash(result);
    if (this.encoded_[hash]) {
      var name = this.encoded_[hash];
    } else {
      name = String(this.scope_.length), this.scope_.push([name, result]), this.encoded_[hash] = name;
    }
    object[this.HASH_KEY] = hash;
    this.withHashes_.push(object);
    return {type:"ValueRef", value:name};
  }
  return result;
};
ee.Serializer.computeHash = function(obj) {
  ee.Serializer.hash_.reset();
  ee.Serializer.hash_.update(ee.Serializer.jsonSerializer_.serialize(obj));
  return ee.Serializer.hash_.digest().toString();
};
ee.Serializer.encodeCloudApi = function(obj) {
  return ee.apiclient.serialize(ee.Serializer.encodeCloudApiExpression(obj));
};
ee.Serializer.encodeCloudApiExpression = function(obj) {
  return (new ee.Serializer(!0)).encodeForCloudApi_(obj);
};
ee.Serializer.encodeCloudApiPretty = function(obj) {
  var encoded = (new ee.Serializer(!1)).encodeForCloudApi_(obj), values = encoded.values, walkObject = function(object) {
    if (!goog.isObject(object)) {
      return object;
    }
    for (var ret = Array.isArray(object) ? [] : {}, isNode = object instanceof Object.getPrototypeOf(module$exports$eeapiclient$ee_api_client.ValueNode), $jscomp$iter$15 = $jscomp.makeIterator(Object.entries(isNode ? object.Serializable$values : object)), $jscomp$key$ = $jscomp$iter$15.next(); !$jscomp$key$.done; $jscomp$key$ = $jscomp$iter$15.next()) {
      var $jscomp$destructuring$var13 = $jscomp.makeIterator($jscomp$key$.value), key = $jscomp$destructuring$var13.next().value, val = $jscomp$destructuring$var13.next().value;
      isNode ? null !== val && (ret[key] = "functionDefinitionValue" === key && null != val.body ? {argumentNames:val.argumentNames, body:walkObject(values[val.body])} : "functionInvocationValue" === key && null != val.functionReference ? {arguments:goog.object.map(val.arguments, walkObject), functionReference:walkObject(values[val.functionReference])} : "constantValue" === key ? val === module$exports$eeapiclient$domain_object.NULL_VALUE ? null : val : walkObject(val)) : 
      ret[key] = walkObject(val);
    }
    return ret;
  };
  return encoded.result && walkObject(values[encoded.result]);
};
ee.Serializer.toCloudApiJSON = function(obj) {
  return ee.Serializer.jsonSerializer_.serialize(ee.Serializer.encodeCloudApi(obj));
};
ee.Serializer.toReadableCloudApiJSON = function(obj) {
  return ee.Serializer.stringify(ee.Serializer.encodeCloudApiPretty(obj));
};
ee.Serializer.prototype.encodeForCloudApi_ = function(obj) {
  try {
    var result = this.makeCloudApiReference_(obj);
    return (new ExpressionOptimizer(result, this.scope_, this.isCompound_)).optimize();
  } finally {
    this.hashes_ = new WeakMap, this.encoded_ = {}, this.scope_ = [];
  }
};
ee.Serializer.prototype.makeCloudApiReference_ = function(obj) {
  var $jscomp$this = this, makeRef = function(result) {
    var hash = ee.Serializer.computeHash(result);
    if ($jscomp$this.encoded_[hash]) {
      return $jscomp$this.encoded_[hash];
    }
    var name = String($jscomp$this.scope_.length);
    $jscomp$this.scope_.push([name, result]);
    $jscomp$this.encoded_[hash] = name;
    goog.isObject(obj) && $jscomp$this.hashes_.set(obj, hash);
    return name;
  };
  if (goog.isObject(obj) && this.encoded_[this.hashes_.get(obj)]) {
    return this.encoded_[this.hashes_.get(obj)];
  }
  if (null === obj || "boolean" === typeof obj || "string" === typeof obj || "number" === typeof obj) {
    return makeRef(ee.rpc_node.constant(obj));
  }
  if (goog.isDateLike(obj)) {
    return makeRef(ee.rpc_node.functionByName("Date", {value:ee.rpc_node.constant(Math.floor(obj.getTime()))}));
  }
  if (obj instanceof ee.Encodable) {
    return makeRef(obj.encodeCloudValue(function(x) {
      return $jscomp$this.makeCloudApiReference_(x);
    }));
  }
  if (Array.isArray(obj)) {
    return makeRef(ee.rpc_node.array(obj.map(function(x) {
      return ee.rpc_node.reference($jscomp$this.makeCloudApiReference_(x));
    })));
  }
  if (goog.isObject(obj) && "function" !== typeof obj) {
    var values = {};
    Object.keys(obj).sort().forEach(function(k) {
      values[k] = ee.rpc_node.reference($jscomp$this.makeCloudApiReference_(obj[k]));
    });
    return makeRef(ee.rpc_node.dictionary(values));
  }
  throw Error("Can't encode object: " + obj);
};
var ExpressionOptimizer = function(rootReference, values, isCompound) {
  var $jscomp$this = this;
  this.rootReference = rootReference;
  this.values = {};
  values.forEach(function(tuple) {
    return $jscomp$this.values[tuple[0]] = tuple[1];
  });
  this.referenceCounts = isCompound ? this.countReferences() : null;
  this.optimizedValues = {};
  this.referenceMap = {};
  this.nextMappedRef = 0;
};
ExpressionOptimizer.prototype.optimize = function() {
  var result = this.optimizeReference(this.rootReference);
  return new module$exports$eeapiclient$ee_api_client.Expression({result:result, values:this.optimizedValues, });
};
ExpressionOptimizer.prototype.optimizeReference = function(ref) {
  if (ref in this.referenceMap) {
    return this.referenceMap[ref];
  }
  var mappedRef = String(this.nextMappedRef++);
  this.referenceMap[ref] = mappedRef;
  this.optimizedValues[mappedRef] = this.optimizeValue(this.values[ref], 0);
  return mappedRef;
};
ExpressionOptimizer.prototype.optimizeValue = function(value, depth) {
  var $jscomp$this = this, isConst = function(v) {
    return null !== v.constantValue;
  }, serializeConst = function(v) {
    return v === module$exports$eeapiclient$domain_object.NULL_VALUE ? null : v;
  };
  if (isConst(value) || null != value.integerValue || null != value.bytesValue || null != value.argumentReference) {
    return value;
  }
  if (null != value.valueReference) {
    var val = this.values[value.valueReference];
    return null === this.referenceCounts || 50 > depth && 1 === this.referenceCounts[value.valueReference] ? this.optimizeValue(val, depth) : ExpressionOptimizer.isAlwaysLiftable(val) ? val : ee.rpc_node.reference(this.optimizeReference(value.valueReference));
  }
  if (null != value.arrayValue) {
    var arr = value.arrayValue.values.map(function(v) {
      return $jscomp$this.optimizeValue(v, depth + 3);
    });
    return arr.every(isConst) ? ee.rpc_node.constant(arr.map(function(v) {
      return serializeConst(v.constantValue);
    })) : ee.rpc_node.array(arr);
  }
  if (null != value.dictionaryValue) {
    for (var values = {}, constantValues = {}, $jscomp$iter$16 = $jscomp.makeIterator(Object.entries(value.dictionaryValue.values || {})), $jscomp$key$ = $jscomp$iter$16.next(); !$jscomp$key$.done; $jscomp$key$ = $jscomp$iter$16.next()) {
      var $jscomp$destructuring$var15 = $jscomp.makeIterator($jscomp$key$.value), k = $jscomp$destructuring$var15.next().value, v$jscomp$0 = $jscomp$destructuring$var15.next().value;
      values[k] = this.optimizeValue(v$jscomp$0, depth + 3);
      null !== constantValues && isConst(values[k]) ? constantValues[k] = serializeConst(values[k].constantValue) : constantValues = null;
    }
    return null !== constantValues ? ee.rpc_node.constant(constantValues) : ee.rpc_node.dictionary(values);
  }
  if (null != value.functionDefinitionValue) {
    var def = value.functionDefinitionValue;
    return ee.rpc_node.functionDefinition(def.argumentNames || [], this.optimizeReference(def.body || ""));
  }
  if (null != value.functionInvocationValue) {
    for (var inv = value.functionInvocationValue, args = {}, $jscomp$iter$17 = $jscomp.makeIterator(Object.keys(inv.arguments || {})), $jscomp$key$k = $jscomp$iter$17.next(); !$jscomp$key$k.done; $jscomp$key$k = $jscomp$iter$17.next()) {
      var k$26 = $jscomp$key$k.value;
      args[k$26] = this.optimizeValue(inv.arguments[k$26], depth + 3);
    }
    return inv.functionName ? ee.rpc_node.functionByName(inv.functionName, args) : ee.rpc_node.functionByReference(this.optimizeReference(inv.functionReference || ""), args);
  }
  throw Error("Can't optimize value: " + value);
};
ExpressionOptimizer.isAlwaysLiftable = function(value) {
  var constant = value.constantValue;
  return null !== constant ? constant === module$exports$eeapiclient$domain_object.NULL_VALUE || "number" === typeof constant || "boolean" === typeof constant : null != value.argumentReference;
};
ExpressionOptimizer.prototype.countReferences = function() {
  var $jscomp$this = this, counts = {}, visitReference = function(reference) {
    counts[reference] ? counts[reference]++ : (counts[reference] = 1, visitValue($jscomp$this.values[reference]));
  }, visitValue = function(value) {
    if (null != value.arrayValue) {
      value.arrayValue.values.forEach(visitValue);
    } else {
      if (null != value.dictionaryValue) {
        Object.values(value.dictionaryValue.values).forEach(visitValue);
      } else {
        if (null != value.functionDefinitionValue) {
          visitReference(value.functionDefinitionValue.body);
        } else {
          if (null != value.functionInvocationValue) {
            var inv = value.functionInvocationValue;
            null != inv.functionReference && visitReference(inv.functionReference);
            Object.values(inv.arguments).forEach(visitValue);
          } else {
            null != value.valueReference && visitReference(value.valueReference);
          }
        }
      }
    }
  };
  visitReference(this.rootReference);
  return counts;
};
ee.rpc_convert_batch = {};
ee.rpc_convert_batch.ExportDestination = {DRIVE:"DRIVE", GCS:"GOOGLE_CLOUD_STORAGE", ASSET:"ASSET", };
ee.rpc_convert_batch.taskToExportImageRequest = function(params) {
  if (null == params.element) {
    throw Error('"element" not found in params ' + params);
  }
  var result = new module$exports$eeapiclient$ee_api_client.ExportImageRequest({expression:ee.Serializer.encodeCloudApiExpression(params.element), description:stringOrNull_(params.description), fileExportOptions:null, assetExportOptions:null, grid:null, maxPixels:stringOrNull_(params.maxPixels), requestId:stringOrNull_(params.id), maxWorkerCount:numberOrNull_(params.maxWorkers)}), destination = ee.rpc_convert_batch.guessDestination_(params);
  switch(destination) {
    case ee.rpc_convert_batch.ExportDestination.GCS:
    case ee.rpc_convert_batch.ExportDestination.DRIVE:
      result.fileExportOptions = ee.rpc_convert_batch.buildImageFileExportOptions_(params, destination);
      break;
    case ee.rpc_convert_batch.ExportDestination.ASSET:
      result.assetExportOptions = ee.rpc_convert_batch.buildImageAssetExportOptions_(params);
      break;
    default:
      throw Error('Export destination "' + destination + '" unknown');
  }
  return result;
};
ee.rpc_convert_batch.taskToExportTableRequest = function(params) {
  if (null == params.element) {
    throw Error('"element" not found in params ' + params);
  }
  var selectors = params.selectors || null;
  null != selectors && "string" === typeof selectors && (selectors = selectors.split(","));
  var result = new module$exports$eeapiclient$ee_api_client.ExportTableRequest({expression:ee.Serializer.encodeCloudApiExpression(params.element), description:stringOrNull_(params.description), fileExportOptions:null, assetExportOptions:null, selectors:selectors, maxErrorMeters:numberOrNull_(params.maxErrorMeters), requestId:stringOrNull_(params.id), maxWorkerCount:numberOrNull_(params.maxWorkers)}), destination = ee.rpc_convert_batch.guessDestination_(params);
  switch(destination) {
    case ee.rpc_convert_batch.ExportDestination.GCS:
    case ee.rpc_convert_batch.ExportDestination.DRIVE:
      result.fileExportOptions = ee.rpc_convert_batch.buildTableFileExportOptions_(params, destination);
      break;
    case ee.rpc_convert_batch.ExportDestination.ASSET:
      result.assetExportOptions = ee.rpc_convert_batch.buildTableAssetExportOptions_(params);
      break;
    default:
      throw Error('Export destination "' + destination + '" unknown');
  }
  return result;
};
ee.rpc_convert_batch.taskToExportVideoRequest = function(params) {
  if (null == params.element) {
    throw Error('"element" not found in params ' + params);
  }
  var result = new module$exports$eeapiclient$ee_api_client.ExportVideoRequest({expression:ee.Serializer.encodeCloudApiExpression(params.element), description:stringOrNull_(params.description), videoOptions:ee.rpc_convert_batch.buildVideoOptions_(params), fileExportOptions:null, requestId:stringOrNull_(params.id), maxWorkerCount:numberOrNull_(params.maxWorkers)});
  result.fileExportOptions = ee.rpc_convert_batch.buildVideoFileExportOptions_(params, ee.rpc_convert_batch.guessDestination_(params));
  return result;
};
ee.rpc_convert_batch.taskToExportMapRequest = function(params) {
  if (null == params.element) {
    throw Error('"element" not found in params ' + params);
  }
  return new module$exports$eeapiclient$ee_api_client.ExportMapRequest({expression:ee.Serializer.encodeCloudApiExpression(params.element), description:stringOrNull_(params.description), tileOptions:ee.rpc_convert_batch.buildTileOptions_(params), tileExportOptions:ee.rpc_convert_batch.buildImageFileExportOptions_(params, ee.rpc_convert_batch.ExportDestination.GCS), requestId:stringOrNull_(params.id), maxWorkerCount:numberOrNull_(params.maxWorkers)});
};
ee.rpc_convert_batch.taskToExportVideoMapRequest = function(params) {
  if (null == params.element) {
    throw Error('"element" not found in params ' + params);
  }
  return new module$exports$eeapiclient$ee_api_client.ExportVideoMapRequest({expression:ee.Serializer.encodeCloudApiExpression(params.element), description:stringOrNull_(params.description), videoOptions:ee.rpc_convert_batch.buildVideoMapOptions_(params), tileOptions:ee.rpc_convert_batch.buildTileOptions_(params), tileExportOptions:ee.rpc_convert_batch.buildVideoFileExportOptions_(params, ee.rpc_convert_batch.ExportDestination.GCS), requestId:stringOrNull_(params.id), version:stringOrNull_(params.version), 
  maxWorkerCount:numberOrNull_(params.maxWorkers)});
};
function stringOrNull_(value) {
  return null != value ? String(value) : null;
}
function numberOrNull_(value) {
  return null != value ? Number(value) : null;
}
ee.rpc_convert_batch.guessDestination_ = function(params) {
  var destination = ee.rpc_convert_batch.ExportDestination.DRIVE;
  if (null == params) {
    return destination;
  }
  null != params.outputBucket || null != params.outputPrefix ? destination = ee.rpc_convert_batch.ExportDestination.GCS : null != params.assetId && (destination = ee.rpc_convert_batch.ExportDestination.ASSET);
  return destination;
};
ee.rpc_convert_batch.buildGeoTiffFormatOptions_ = function(params) {
  if (params.fileDimensions && params.tiffFileDimensions) {
    throw Error('Export cannot set both "fileDimensions" and "tiffFileDimensions".');
  }
  return new module$exports$eeapiclient$ee_api_client.GeoTiffImageExportOptions({cloudOptimized:!!params.tiffCloudOptimized, skipEmptyFiles:!!params.tiffSkipEmptyFiles, tileDimensions:ee.rpc_convert_batch.buildGridDimensions_(params.fileDimensions || params.tiffFileDimensions), });
};
ee.rpc_convert_batch.buildTfRecordFormatOptions_ = function(params) {
  var tfRecordOptions = new module$exports$eeapiclient$ee_api_client.TfRecordImageExportOptions({compress:!!params.tfrecordCompressed, maxSizeBytes:stringOrNull_(params.tfrecordMaxFileSize), sequenceData:!!params.tfrecordSequenceData, collapseBands:!!params.tfrecordCollapseBands, maxMaskedRatio:numberOrNull_(params.tfrecordMaskedThreshold), defaultValue:numberOrNull_(params.tfrecordDefaultValue), tileDimensions:ee.rpc_convert_batch.buildGridDimensions_(params.tfrecordPatchDimensions), 
  marginDimensions:ee.rpc_convert_batch.buildGridDimensions_(params.tfrecordKernelSize), tensorDepths:null, }), tensorDepths = params.tfrecordTensorDepths;
  if (null != tensorDepths) {
    if (goog.isObject(tensorDepths)) {
      var result = {};
      goog.object.forEach(tensorDepths, function(v, k) {
        if ("string" !== typeof k || "number" !== typeof v) {
          throw Error('"tensorDepths" option must be an object of type Object<string, number>');
        }
        result[k] = v;
      });
      tfRecordOptions.tensorDepths = result;
    } else {
      throw Error('"tensorDepths" option needs to have the form Object<string, number>.');
    }
  }
  return tfRecordOptions;
};
ee.rpc_convert_batch.buildImageFileExportOptions_ = function(params, destination) {
  var result = new module$exports$eeapiclient$ee_api_client.ImageFileExportOptions({gcsDestination:null, driveDestination:null, geoTiffOptions:null, tfRecordOptions:null, fileFormat:ee.rpc_convert.fileFormat(params.fileFormat), });
  "GEO_TIFF" === result.fileFormat ? result.geoTiffOptions = ee.rpc_convert_batch.buildGeoTiffFormatOptions_(params) : "TF_RECORD_IMAGE" === result.fileFormat && (result.tfRecordOptions = ee.rpc_convert_batch.buildTfRecordFormatOptions_(params));
  destination === ee.rpc_convert_batch.ExportDestination.GCS ? result.gcsDestination = ee.rpc_convert_batch.buildGcsDestination_(params) : result.driveDestination = ee.rpc_convert_batch.buildDriveDestination_(params);
  return result;
};
ee.rpc_convert_batch.buildImageAssetExportOptions_ = function(params) {
  var allPolicies = params.pyramidingPolicy || {};
  try {
    allPolicies = JSON.parse(allPolicies);
  } catch ($jscomp$unused$catch) {
  }
  var defaultPyramidingPolicy = "PYRAMIDING_POLICY_UNSPECIFIED";
  "string" === typeof allPolicies ? (defaultPyramidingPolicy = allPolicies, allPolicies = {}) : allPolicies[".default"] && (defaultPyramidingPolicy = allPolicies[".default"], delete allPolicies[".default"]);
  return new module$exports$eeapiclient$ee_api_client.ImageAssetExportOptions({earthEngineDestination:ee.rpc_convert_batch.buildEarthEngineDestination_(params), pyramidingPolicy:defaultPyramidingPolicy, pyramidingPolicyOverrides:goog.object.isEmpty(allPolicies) ? null : allPolicies, });
};
ee.rpc_convert_batch.buildTableFileExportOptions_ = function(params, destination) {
  var result = new module$exports$eeapiclient$ee_api_client.TableFileExportOptions({gcsDestination:null, driveDestination:null, fileFormat:ee.rpc_convert.tableFileFormat(params.fileFormat), });
  destination === ee.rpc_convert_batch.ExportDestination.GCS ? result.gcsDestination = ee.rpc_convert_batch.buildGcsDestination_(params) : result.driveDestination = ee.rpc_convert_batch.buildDriveDestination_(params);
  return result;
};
ee.rpc_convert_batch.buildTableAssetExportOptions_ = function(params) {
  return new module$exports$eeapiclient$ee_api_client.TableAssetExportOptions({earthEngineDestination:ee.rpc_convert_batch.buildEarthEngineDestination_(params)});
};
ee.rpc_convert_batch.buildVideoFileExportOptions_ = function(params, destination) {
  var result = new module$exports$eeapiclient$ee_api_client.VideoFileExportOptions({gcsDestination:null, driveDestination:null, fileFormat:"MP4", });
  destination === ee.rpc_convert_batch.ExportDestination.GCS ? result.gcsDestination = ee.rpc_convert_batch.buildGcsDestination_(params) : result.driveDestination = ee.rpc_convert_batch.buildDriveDestination_(params);
  return result;
};
ee.rpc_convert_batch.buildVideoOptions_ = function(params) {
  return new module$exports$eeapiclient$ee_api_client.VideoOptions({framesPerSecond:numberOrNull_(params.framesPerSecond), maxFrames:numberOrNull_(params.maxFrames), maxPixelsPerFrame:stringOrNull_(params.maxPixels), });
};
ee.rpc_convert_batch.buildVideoMapOptions_ = function(params) {
  return new module$exports$eeapiclient$ee_api_client.VideoOptions({framesPerSecond:numberOrNull_(params.framesPerSecond), maxFrames:numberOrNull_(params.maxFrames), maxPixelsPerFrame:null, });
};
ee.rpc_convert_batch.buildTileOptions_ = function(params) {
  return new module$exports$eeapiclient$ee_api_client.TileOptions({maxZoom:numberOrNull_(params.maxZoom), scale:numberOrNull_(params.scale), minZoom:numberOrNull_(params.minZoom), skipEmptyTiles:!!params.skipEmptyTiles, mapsApiKey:stringOrNull_(params.mapsApiKey), tileDimensions:ee.rpc_convert_batch.buildGridDimensions_(params.tileDimensions), stride:numberOrNull_(params.stride), zoomSubset:ee.rpc_convert_batch.buildZoomSubset_(numberOrNull_(params.minTimeMachineZoomSubset), 
  numberOrNull_(params.maxTimeMachineZoomSubset)), });
};
ee.rpc_convert_batch.buildZoomSubset_ = function(min, max) {
  if (null == min && null == max) {
    return null;
  }
  var result = new module$exports$eeapiclient$ee_api_client.ZoomSubset({min:0, max:null});
  null != min && (result.min = min);
  result.max = max;
  return result;
};
ee.rpc_convert_batch.buildGridDimensions_ = function(dimensions) {
  if (null == dimensions) {
    return null;
  }
  var result = new module$exports$eeapiclient$ee_api_client.GridDimensions({height:0, width:0});
  "string" === typeof dimensions && (-1 !== dimensions.indexOf("x") ? dimensions = dimensions.split("x").map(Number) : -1 !== dimensions.indexOf(",") && (dimensions = dimensions.split(",").map(Number)));
  if (Array.isArray(dimensions)) {
    if (2 === dimensions.length) {
      result.height = dimensions[0], result.width = dimensions[1];
    } else {
      if (1 === dimensions.length) {
        result.height = dimensions[0], result.width = dimensions[0];
      } else {
        throw Error("Unable to construct grid from dimensions: " + dimensions);
      }
    }
  } else {
    if ("number" !== typeof dimensions || isNaN(dimensions)) {
      if (goog.isObject(dimensions) && null != dimensions.height && null != dimensions.width) {
        result.height = dimensions.height, result.width = dimensions.width;
      } else {
        throw Error("Unable to construct grid from dimensions: " + dimensions);
      }
    } else {
      result.height = dimensions, result.width = dimensions;
    }
  }
  return result;
};
ee.rpc_convert_batch.buildGcsDestination_ = function(params) {
  var permissions = null;
  null != params.writePublicTiles && (permissions = params.writePublicTiles ? "PUBLIC" : "DEFAULT_OBJECT_ACL");
  return new module$exports$eeapiclient$ee_api_client.GcsDestination({bucket:stringOrNull_(params.outputBucket), filenamePrefix:stringOrNull_(params.outputPrefix), bucketCorsUris:params.bucketCorsUris || null, permissions:permissions, });
};
ee.rpc_convert_batch.buildDriveDestination_ = function(params) {
  return new module$exports$eeapiclient$ee_api_client.DriveDestination({folder:stringOrNull_(params.driveFolder), filenamePrefix:stringOrNull_(params.driveFileNamePrefix), });
};
ee.rpc_convert_batch.buildEarthEngineDestination_ = function(params) {
  return new module$exports$eeapiclient$ee_api_client.EarthEngineDestination({name:ee.rpc_convert.assetIdToAssetName(params.assetId)});
};
var jspb = {}, module$contents$jspb$ConstBinaryMessage_ConstBinaryMessage = function() {
};
module$contents$jspb$ConstBinaryMessage_ConstBinaryMessage.prototype.toDebugString = function() {
};
module$contents$jspb$ConstBinaryMessage_ConstBinaryMessage.prototype.toDebugStringInternal = function(indentLevel) {
};
jspb.ConstBinaryMessage = module$contents$jspb$ConstBinaryMessage_ConstBinaryMessage;
jspb.BinaryMessage = function() {
};
jspb.ScalarFieldType = void 0;
jspb.RepeatedFieldType = void 0;
jspb.AnyFieldType = void 0;
jspb.BinaryConstants = {};
var module$contents$jspb$BinaryConstants_FieldType = {INVALID:-1, DOUBLE:1, FLOAT:2, INT64:3, UINT64:4, INT32:5, FIXED64:6, FIXED32:7, BOOL:8, STRING:9, GROUP:10, MESSAGE:11, BYTES:12, UINT32:13, ENUM:14, SFIXED32:15, SFIXED64:16, SINT32:17, SINT64:18, }, module$contents$jspb$BinaryConstants_WireType = {INVALID:-1, VARINT:0, FIXED64:1, DELIMITED:2, START_GROUP:3, END_GROUP:4, FIXED32:5};
function module$contents$jspb$BinaryConstants_FieldTypeToWireType(fieldType) {
  switch(fieldType) {
    case module$contents$jspb$BinaryConstants_FieldType.INT32:
    case module$contents$jspb$BinaryConstants_FieldType.INT64:
    case module$contents$jspb$BinaryConstants_FieldType.UINT32:
    case module$contents$jspb$BinaryConstants_FieldType.UINT64:
    case module$contents$jspb$BinaryConstants_FieldType.SINT32:
    case module$contents$jspb$BinaryConstants_FieldType.SINT64:
    case module$contents$jspb$BinaryConstants_FieldType.BOOL:
    case module$contents$jspb$BinaryConstants_FieldType.ENUM:
      return module$contents$jspb$BinaryConstants_WireType.VARINT;
    case module$contents$jspb$BinaryConstants_FieldType.DOUBLE:
    case module$contents$jspb$BinaryConstants_FieldType.FIXED64:
    case module$contents$jspb$BinaryConstants_FieldType.SFIXED64:
      return module$contents$jspb$BinaryConstants_WireType.FIXED64;
    case module$contents$jspb$BinaryConstants_FieldType.STRING:
    case module$contents$jspb$BinaryConstants_FieldType.MESSAGE:
    case module$contents$jspb$BinaryConstants_FieldType.BYTES:
      return module$contents$jspb$BinaryConstants_WireType.DELIMITED;
    case module$contents$jspb$BinaryConstants_FieldType.FLOAT:
    case module$contents$jspb$BinaryConstants_FieldType.FIXED32:
    case module$contents$jspb$BinaryConstants_FieldType.SFIXED32:
      return module$contents$jspb$BinaryConstants_WireType.FIXED32;
    default:
      return module$contents$jspb$BinaryConstants_WireType.INVALID;
  }
}
jspb.BinaryConstants.FieldType = module$contents$jspb$BinaryConstants_FieldType;
jspb.BinaryConstants.FieldTypeToWireType = module$contents$jspb$BinaryConstants_FieldTypeToWireType;
jspb.BinaryConstants.FLOAT32_EPS = 1.401298464324817e-45;
jspb.BinaryConstants.FLOAT32_MIN = 1.1754943508222875e-38;
jspb.BinaryConstants.FLOAT32_MAX = 3.4028234663852886e+38;
jspb.BinaryConstants.FLOAT64_EPS = 5e-324;
jspb.BinaryConstants.FLOAT64_MIN = 2.2250738585072014e-308;
jspb.BinaryConstants.FLOAT64_MAX = 1.7976931348623157e+308;
jspb.BinaryConstants.INVALID_FIELD_NUMBER = -1;
jspb.BinaryConstants.TWO_TO_20 = 1048576;
jspb.BinaryConstants.TWO_TO_23 = 8388608;
jspb.BinaryConstants.TWO_TO_31 = 2147483648;
jspb.BinaryConstants.TWO_TO_32 = 4294967296;
jspb.BinaryConstants.TWO_TO_52 = 4503599627370496;
jspb.BinaryConstants.TWO_TO_63 = 9223372036854775808;
jspb.BinaryConstants.TWO_TO_64 = 18446744073709551616;
jspb.BinaryConstants.WireType = module$contents$jspb$BinaryConstants_WireType;
jspb.BinaryConstants.ZERO_HASH = "\x00\x00\x00\x00\x00\x00\x00\x00";
jspb.ByteSource = void 0;
goog.crypt.stringToByteArray = function(str) {
  for (var output = [], p = 0, i = 0; i < str.length; i++) {
    var c = str.charCodeAt(i);
    255 < c && (output[p++] = c & 255, c >>= 8);
    output[p++] = c;
  }
  return output;
};
goog.crypt.byteArrayToString = function(bytes) {
  if (8192 >= bytes.length) {
    return String.fromCharCode.apply(null, bytes);
  }
  for (var str = "", i = 0; i < bytes.length; i += 8192) {
    var chunk = goog.array.slice(bytes, i, i + 8192);
    str += String.fromCharCode.apply(null, chunk);
  }
  return str;
};
goog.crypt.byteArrayToHex = function(array, opt_separator) {
  return goog.array.map(array, function(numByte) {
    var hexByte = numByte.toString(16);
    return 1 < hexByte.length ? hexByte : "0" + hexByte;
  }).join(opt_separator || "");
};
goog.crypt.hexToByteArray = function(hexString) {
  goog.asserts.assert(0 == hexString.length % 2, "Key string length must be multiple of 2");
  for (var arr = [], i = 0; i < hexString.length; i += 2) {
    arr.push(parseInt(hexString.substring(i, i + 2), 16));
  }
  return arr;
};
goog.crypt.stringToUtf8ByteArray = function(str) {
  for (var out = [], p = 0, i = 0; i < str.length; i++) {
    var c = str.charCodeAt(i);
    128 > c ? out[p++] = c : (2048 > c ? out[p++] = c >> 6 | 192 : (55296 == (c & 64512) && i + 1 < str.length && 56320 == (str.charCodeAt(i + 1) & 64512) ? (c = 65536 + ((c & 1023) << 10) + (str.charCodeAt(++i) & 1023), out[p++] = c >> 18 | 240, out[p++] = c >> 12 & 63 | 128) : out[p++] = c >> 12 | 224, out[p++] = c >> 6 & 63 | 128), out[p++] = c & 63 | 128);
  }
  return out;
};
goog.crypt.utf8ByteArrayToString = function(bytes) {
  for (var out = [], pos = 0, c = 0; pos < bytes.length;) {
    var c1 = bytes[pos++];
    if (128 > c1) {
      out[c++] = String.fromCharCode(c1);
    } else {
      if (191 < c1 && 224 > c1) {
        var c2 = bytes[pos++];
        out[c++] = String.fromCharCode((c1 & 31) << 6 | c2 & 63);
      } else {
        if (239 < c1 && 365 > c1) {
          c2 = bytes[pos++];
          var c3 = bytes[pos++], c4 = bytes[pos++], u = ((c1 & 7) << 18 | (c2 & 63) << 12 | (c3 & 63) << 6 | c4 & 63) - 65536;
          out[c++] = String.fromCharCode(55296 + (u >> 10));
          out[c++] = String.fromCharCode(56320 + (u & 1023));
        } else {
          c2 = bytes[pos++], c3 = bytes[pos++], out[c++] = String.fromCharCode((c1 & 15) << 12 | (c2 & 63) << 6 | c3 & 63);
        }
      }
    }
  }
  return out.join("");
};
goog.crypt.xorByteArray = function(bytes1, bytes2) {
  goog.asserts.assert(bytes1.length == bytes2.length, "XOR array lengths must match");
  for (var result = [], i = 0; i < bytes1.length; i++) {
    result.push(bytes1[i] ^ bytes2[i]);
  }
  return result;
};
jspb.utils = {};
var module$contents$jspb$utils_split64Low = 0, module$contents$jspb$utils_split64High = 0;
function module$contents$jspb$utils_splitUint64(value) {
  var lowBits = value >>> 0, highBits = Math.floor((value - lowBits) / 4294967296) >>> 0;
  module$contents$jspb$utils_split64Low = lowBits;
  module$contents$jspb$utils_split64High = highBits;
}
function module$contents$jspb$utils_splitInt64(value) {
  var sign = 0 > value;
  value = Math.abs(value);
  var lowBits = value >>> 0, highBits = Math.floor((value - lowBits) / 4294967296);
  highBits >>>= 0;
  sign && (highBits = ~highBits >>> 0, lowBits = (~lowBits >>> 0) + 1, 4294967295 < lowBits && (lowBits = 0, highBits++, 4294967295 < highBits && (highBits = 0)));
  module$contents$jspb$utils_split64Low = lowBits;
  module$contents$jspb$utils_split64High = highBits;
}
function module$contents$jspb$utils_splitZigzag64(value) {
  var sign = 0 > value;
  value = 2 * Math.abs(value);
  module$contents$jspb$utils_splitUint64(value);
  var lowBits = module$contents$jspb$utils_split64Low, highBits = module$contents$jspb$utils_split64High;
  sign && (0 == lowBits ? 0 == highBits ? highBits = lowBits = 4294967295 : (highBits--, lowBits = 4294967295) : lowBits--);
  module$contents$jspb$utils_split64Low = lowBits;
  module$contents$jspb$utils_split64High = highBits;
}
function module$contents$jspb$utils_splitFloat32(value) {
  var sign = 0 > value ? 1 : 0;
  value = sign ? -value : value;
  if (0 === value) {
    0 < 1 / value ? module$contents$jspb$utils_split64Low = module$contents$jspb$utils_split64High = 0 : (module$contents$jspb$utils_split64High = 0, module$contents$jspb$utils_split64Low = 2147483648);
  } else {
    if (isNaN(value)) {
      module$contents$jspb$utils_split64High = 0, module$contents$jspb$utils_split64Low = 2147483647;
    } else {
      if (3.4028234663852886e+38 < value) {
        module$contents$jspb$utils_split64High = 0, module$contents$jspb$utils_split64Low = (sign << 31 | 2139095040) >>> 0;
      } else {
        if (1.1754943508222875e-38 > value) {
          var mant = Math.round(value / Math.pow(2, -149));
          module$contents$jspb$utils_split64High = 0;
          module$contents$jspb$utils_split64Low = (sign << 31 | mant) >>> 0;
        } else {
          var exp = Math.floor(Math.log(value) / Math.LN2);
          mant = value * Math.pow(2, -exp);
          mant = Math.round(8388608 * mant) & 8388607;
          module$contents$jspb$utils_split64High = 0;
          module$contents$jspb$utils_split64Low = (sign << 31 | exp + 127 << 23 | mant) >>> 0;
        }
      }
    }
  }
}
function module$contents$jspb$utils_splitFloat64(value) {
  var sign = 0 > value ? 1 : 0;
  value = sign ? -value : value;
  if (0 === value) {
    module$contents$jspb$utils_split64High = 0 < 1 / value ? 0 : 2147483648, module$contents$jspb$utils_split64Low = 0;
  } else {
    if (isNaN(value)) {
      module$contents$jspb$utils_split64High = 2147483647, module$contents$jspb$utils_split64Low = 4294967295;
    } else {
      if (1.7976931348623157e+308 < value) {
        module$contents$jspb$utils_split64High = (sign << 31 | 2146435072) >>> 0, module$contents$jspb$utils_split64Low = 0;
      } else {
        if (2.2250738585072014e-308 > value) {
          var mant = value / Math.pow(2, -1074), mantHigh;
          module$contents$jspb$utils_split64High = (sign << 31 | mant / 4294967296) >>> 0;
          module$contents$jspb$utils_split64Low = mant >>> 0;
        } else {
          var x = value, exp = 0;
          if (2 <= x) {
            for (; 2 <= x && 1023 > exp;) {
              exp++, x /= 2;
            }
          } else {
            for (; 1 > x && -1022 < exp;) {
              x *= 2, exp--;
            }
          }
          mant = value * Math.pow(2, -exp);
          var mantLow;
          module$contents$jspb$utils_split64High = (sign << 31 | exp + 1023 << 20 | 1048576 * mant & 1048575) >>> 0;
          module$contents$jspb$utils_split64Low = 4503599627370496 * mant >>> 0;
        }
      }
    }
  }
}
function module$contents$jspb$utils_splitHash64(hash) {
  var e = hash.charCodeAt(4), f = hash.charCodeAt(5), g = hash.charCodeAt(6), h = hash.charCodeAt(7);
  module$contents$jspb$utils_split64Low = hash.charCodeAt(0) + (hash.charCodeAt(1) << 8) + (hash.charCodeAt(2) << 16) + (hash.charCodeAt(3) << 24) >>> 0;
  module$contents$jspb$utils_split64High = e + (f << 8) + (g << 16) + (h << 24) >>> 0;
}
function module$contents$jspb$utils_joinUint64(bitsLow, bitsHigh) {
  return 4294967296 * bitsHigh + (bitsLow >>> 0);
}
function module$contents$jspb$utils_joinInt64(bitsLow, bitsHigh) {
  var sign = bitsHigh & 2147483648;
  sign && (bitsLow = ~bitsLow + 1 >>> 0, bitsHigh = ~bitsHigh >>> 0, 0 == bitsLow && (bitsHigh = bitsHigh + 1 >>> 0));
  var result = module$contents$jspb$utils_joinUint64(bitsLow, bitsHigh);
  return sign ? -result : result;
}
function module$contents$jspb$utils_toZigzag64(bitsLow, bitsHigh, convert) {
  var signFlipMask = bitsHigh >> 31;
  return convert(bitsLow << 1 ^ signFlipMask, (bitsHigh << 1 | bitsLow >>> 31) ^ signFlipMask);
}
function module$contents$jspb$utils_joinZigzag64(bitsLow, bitsHigh) {
  return module$contents$jspb$utils_fromZigzag64(bitsLow, bitsHigh, module$contents$jspb$utils_joinInt64);
}
function module$contents$jspb$utils_fromZigzag64(bitsLow, bitsHigh, convert) {
  var signFlipMask = -(bitsLow & 1);
  return convert((bitsLow >>> 1 | bitsHigh << 31) ^ signFlipMask, bitsHigh >>> 1 ^ signFlipMask);
}
function module$contents$jspb$utils_joinFloat32(bitsLow, bitsHigh) {
  var sign = 2 * (bitsLow >> 31) + 1, exp = bitsLow >>> 23 & 255, mant = bitsLow & 8388607;
  return 255 == exp ? mant ? NaN : Infinity * sign : 0 == exp ? sign * Math.pow(2, -149) * mant : sign * Math.pow(2, exp - 150) * (mant + Math.pow(2, 23));
}
function module$contents$jspb$utils_joinFloat64(bitsLow, bitsHigh) {
  var sign = 2 * (bitsHigh >> 31) + 1, exp = bitsHigh >>> 20 & 2047, mant = 4294967296 * (bitsHigh & 1048575) + bitsLow;
  return 2047 == exp ? mant ? NaN : Infinity * sign : 0 == exp ? sign * Math.pow(2, -1074) * mant : sign * Math.pow(2, exp - 1075) * (mant + 4503599627370496);
}
function module$contents$jspb$utils_joinHash64(bitsLow, bitsHigh) {
  return String.fromCharCode(bitsLow >>> 0 & 255, bitsLow >>> 8 & 255, bitsLow >>> 16 & 255, bitsLow >>> 24 & 255, bitsHigh >>> 0 & 255, bitsHigh >>> 8 & 255, bitsHigh >>> 16 & 255, bitsHigh >>> 24 & 255);
}
function module$contents$jspb$utils_joinUnsignedDecimalString(bitsLow, bitsHigh) {
  function decimalFrom1e7(digit1e7, needLeadingZeros) {
    var partial = digit1e7 ? String(digit1e7) : "";
    return needLeadingZeros ? "0000000".slice(partial.length) + partial : partial;
  }
  if (2097151 >= bitsHigh) {
    return "" + (4294967296 * bitsHigh + bitsLow);
  }
  var mid = (bitsLow >>> 24 | bitsHigh << 8) >>> 0 & 16777215, high = bitsHigh >> 16 & 65535, digitA = (bitsLow & 16777215) + 6777216 * mid + 6710656 * high, digitB = mid + 8147497 * high, digitC = 2 * high;
  10000000 <= digitA && (digitB += Math.floor(digitA / 10000000), digitA %= 10000000);
  10000000 <= digitB && (digitC += Math.floor(digitB / 10000000), digitB %= 10000000);
  return decimalFrom1e7(digitC, 0) + decimalFrom1e7(digitB, digitC) + decimalFrom1e7(digitA, 1);
}
function module$contents$jspb$utils_joinSignedDecimalString(bitsLow, bitsHigh) {
  var negative = bitsHigh & 2147483648;
  negative && (bitsLow = ~bitsLow + 1 >>> 0, bitsHigh = ~bitsHigh + (0 == bitsLow ? 1 : 0) >>> 0);
  var result = module$contents$jspb$utils_joinUnsignedDecimalString(bitsLow, bitsHigh);
  return negative ? "-" + result : result;
}
function module$contents$jspb$utils_hash64ToDecimalString(hash, signed) {
  module$contents$jspb$utils_splitHash64(hash);
  var bitsLow = module$contents$jspb$utils_split64Low, bitsHigh = module$contents$jspb$utils_split64High;
  return signed ? module$contents$jspb$utils_joinSignedDecimalString(bitsLow, bitsHigh) : module$contents$jspb$utils_joinUnsignedDecimalString(bitsLow, bitsHigh);
}
function module$contents$jspb$utils_decimalStringToHash64(dec) {
  function muladd(m, c) {
    for (var i = 0; 8 > i && (1 !== m || 0 < c); i++) {
      var r = m * resultBytes[i] + c;
      resultBytes[i] = r & 255;
      c = r >>> 8;
    }
  }
  function neg() {
    for (var i = 0; 8 > i; i++) {
      resultBytes[i] = ~resultBytes[i] & 255;
    }
  }
  (0,goog.asserts.assert)(0 < dec.length);
  var minus = !1;
  "-" === dec[0] && (minus = !0, dec = dec.slice(1));
  for (var resultBytes = [0, 0, 0, 0, 0, 0, 0, 0], i$jscomp$0 = 0; i$jscomp$0 < dec.length; i$jscomp$0++) {
    muladd(10, dec.charCodeAt(i$jscomp$0) - 48);
  }
  minus && (neg(), muladd(1, 1));
  return goog.crypt.byteArrayToString(resultBytes);
}
function module$contents$jspb$utils_splitDecimalString(value) {
  module$contents$jspb$utils_splitHash64(module$contents$jspb$utils_decimalStringToHash64(value));
}
function module$contents$jspb$utils_toHexDigit_(nibble) {
  return String.fromCharCode(10 > nibble ? 48 + nibble : 87 + nibble);
}
function module$contents$jspb$utils_fromHexCharCode_(hexCharCode) {
  return 97 <= hexCharCode ? hexCharCode - 97 + 10 : hexCharCode - 48;
}
function module$contents$jspb$utils_countFixedFields_(buffer, start, end, tag, stride) {
  var count = 0, cursor = start;
  if (128 > tag) {
    for (; cursor < end && buffer[cursor++] == tag;) {
      count++, cursor += stride;
    }
  } else {
    for (; cursor < end;) {
      for (var temp = tag; 128 < temp;) {
        if (buffer[cursor++] != (temp & 127 | 128)) {
          return count;
        }
        temp >>= 7;
      }
      if (buffer[cursor++] != temp) {
        break;
      }
      count++;
      cursor += stride;
    }
  }
  return count;
}
function module$contents$jspb$utils_byteSourceToUint8Array(data) {
  if (data.constructor === Uint8Array) {
    return data;
  }
  if (data.constructor === ArrayBuffer) {
    return new Uint8Array(data);
  }
  if (data.constructor === Array) {
    return new Uint8Array(data);
  }
  if (data.constructor === String) {
    return goog.crypt.base64.decodeStringToUint8Array(data);
  }
  (0,goog.asserts.fail)("Type not convertible to Uint8Array.");
  return new Uint8Array(0);
}
function module$contents$jspb$utils_getSplit64Low() {
  return module$contents$jspb$utils_split64Low;
}
function module$contents$jspb$utils_getSplit64High() {
  return module$contents$jspb$utils_split64High;
}
jspb.utils.byteSourceToUint8Array = module$contents$jspb$utils_byteSourceToUint8Array;
jspb.utils.countDelimitedFields = function module$contents$jspb$utils_countDelimitedFields(buffer, start, end, field) {
  for (var count = 0, cursor = start, tag = 8 * field + module$contents$jspb$BinaryConstants_WireType.DELIMITED; cursor < end;) {
    for (var temp = tag; 128 < temp;) {
      if (buffer[cursor++] != (temp & 127 | 128)) {
        return count;
      }
      temp >>= 7;
    }
    if (buffer[cursor++] != temp) {
      break;
    }
    count++;
    for (var length = 0, shift = 1; temp = buffer[cursor++], length += (temp & 127) * shift, shift *= 128, 0 != (temp & 128);) {
    }
    cursor += length;
  }
  return count;
};
jspb.utils.countFixed32Fields = function module$contents$jspb$utils_countFixed32Fields(buffer, start, end, field) {
  return module$contents$jspb$utils_countFixedFields_(buffer, start, end, 8 * field + module$contents$jspb$BinaryConstants_WireType.FIXED32, 4);
};
jspb.utils.countFixed64Fields = function module$contents$jspb$utils_countFixed64Fields(buffer, start, end, field) {
  return module$contents$jspb$utils_countFixedFields_(buffer, start, end, 8 * field + module$contents$jspb$BinaryConstants_WireType.FIXED64, 8);
};
jspb.utils.countVarintFields = function module$contents$jspb$utils_countVarintFields(buffer, start, end, field) {
  var count = 0, cursor = start, tag = 8 * field + module$contents$jspb$BinaryConstants_WireType.VARINT;
  if (128 > tag) {
    for (; cursor < end && buffer[cursor++] == tag;) {
      for (count++;;) {
        var x = buffer[cursor++];
        if (0 == (x & 128)) {
          break;
        }
      }
    }
  } else {
    for (; cursor < end;) {
      for (var temp = tag; 128 < temp;) {
        if (buffer[cursor] != (temp & 127 | 128)) {
          return count;
        }
        cursor++;
        temp >>= 7;
      }
      if (buffer[cursor++] != temp) {
        break;
      }
      for (count++; x = buffer[cursor++], 0 != (x & 128);) {
      }
    }
  }
  return count;
};
jspb.utils.countVarints = function module$contents$jspb$utils_countVarints(buffer, start, end) {
  for (var count = 0, i = start; i < end; i++) {
    count += buffer[i] >> 7;
  }
  return end - start - count;
};
jspb.utils.debugBytesToTextFormat = function module$contents$jspb$utils_debugBytesToTextFormat(byteSource) {
  var s = '"';
  if (byteSource) {
    for (var bytes = module$contents$jspb$utils_byteSourceToUint8Array(byteSource), i = 0; i < bytes.length; i++) {
      s += "\\x", 16 > bytes[i] && (s += "0"), s += bytes[i].toString(16);
    }
  }
  return s + '"';
};
jspb.utils.debugScalarToTextFormat = function module$contents$jspb$utils_debugScalarToTextFormat(scalar) {
  return "string" === typeof scalar ? goog.string.quote(scalar) : scalar.toString();
};
jspb.utils.decimalStringToHash64 = module$contents$jspb$utils_decimalStringToHash64;
jspb.utils.DIGITS = "0123456789abcdef".split("");
jspb.utils.fromZigzag64 = module$contents$jspb$utils_fromZigzag64;
jspb.utils.hash64ArrayToDecimalStrings = function module$contents$jspb$utils_hash64ArrayToDecimalStrings(hashes, signed) {
  for (var result = Array(hashes.length), i = 0; i < hashes.length; i++) {
    result[i] = module$contents$jspb$utils_hash64ToDecimalString(hashes[i], signed);
  }
  return result;
};
jspb.utils.hash64ToDecimalString = module$contents$jspb$utils_hash64ToDecimalString;
jspb.utils.hash64ToHexString = function module$contents$jspb$utils_hash64ToHexString(hash) {
  var temp = Array(18);
  temp[0] = "0";
  temp[1] = "x";
  for (var i = 0; 8 > i; i++) {
    var c = hash.charCodeAt(7 - i);
    temp[2 * i + 2] = module$contents$jspb$utils_toHexDigit_(c >> 4);
    temp[2 * i + 3] = module$contents$jspb$utils_toHexDigit_(c & 15);
  }
  return temp.join("");
};
jspb.utils.hash64ToNumber = function module$contents$jspb$utils_hash64ToNumber(hash, signed) {
  module$contents$jspb$utils_splitHash64(hash);
  var bitsLow = module$contents$jspb$utils_split64Low, bitsHigh = module$contents$jspb$utils_split64High;
  return signed ? module$contents$jspb$utils_joinInt64(bitsLow, bitsHigh) : module$contents$jspb$utils_joinUint64(bitsLow, bitsHigh);
};
jspb.utils.hexStringToHash64 = function module$contents$jspb$utils_hexStringToHash64(hex) {
  hex = hex.toLowerCase();
  (0,goog.asserts.assert)(18 == hex.length);
  (0,goog.asserts.assert)("0" == hex[0]);
  (0,goog.asserts.assert)("x" == hex[1]);
  for (var result = "", i = 0; 8 > i; i++) {
    result = String.fromCharCode(16 * module$contents$jspb$utils_fromHexCharCode_(hex.charCodeAt(2 * i + 2)) + module$contents$jspb$utils_fromHexCharCode_(hex.charCodeAt(2 * i + 3))) + result;
  }
  return result;
};
jspb.utils.joinFloat64 = module$contents$jspb$utils_joinFloat64;
jspb.utils.joinFloat32 = module$contents$jspb$utils_joinFloat32;
jspb.utils.joinHash64 = module$contents$jspb$utils_joinHash64;
jspb.utils.joinInt64 = module$contents$jspb$utils_joinInt64;
jspb.utils.joinSignedDecimalString = module$contents$jspb$utils_joinSignedDecimalString;
jspb.utils.joinUint64 = module$contents$jspb$utils_joinUint64;
jspb.utils.joinUnsignedDecimalString = module$contents$jspb$utils_joinUnsignedDecimalString;
jspb.utils.joinZigzag64 = module$contents$jspb$utils_joinZigzag64;
jspb.utils.numberToHash64 = function module$contents$jspb$utils_numberToHash64(value) {
  module$contents$jspb$utils_splitInt64(value);
  return module$contents$jspb$utils_joinHash64(module$contents$jspb$utils_split64Low, module$contents$jspb$utils_split64High);
};
jspb.utils.splitDecimalString = module$contents$jspb$utils_splitDecimalString;
jspb.utils.splitHash64 = module$contents$jspb$utils_splitHash64;
jspb.utils.splitFloat64 = module$contents$jspb$utils_splitFloat64;
jspb.utils.splitFloat32 = module$contents$jspb$utils_splitFloat32;
jspb.utils.splitZigzag64 = module$contents$jspb$utils_splitZigzag64;
jspb.utils.splitInt64 = module$contents$jspb$utils_splitInt64;
jspb.utils.splitUint64 = module$contents$jspb$utils_splitUint64;
jspb.utils.getSplit64Low = module$contents$jspb$utils_getSplit64Low;
jspb.utils.getSplit64High = module$contents$jspb$utils_getSplit64High;
jspb.utils.stringToByteArray = function module$contents$jspb$utils_stringToByteArray(str) {
  for (var arr = new Uint8Array(str.length), i = 0; i < str.length; i++) {
    var codepoint = str.charCodeAt(i);
    if (255 < codepoint) {
      throw Error("Conversion error: string contains codepoint outside of byte range");
    }
    arr[i] = codepoint;
  }
  return arr;
};
jspb.utils.toZigzag64 = module$contents$jspb$utils_toZigzag64;
var module$contents$jspb$BinaryDecoder_BinaryDecoder = function(bytes, start, length) {
  this.bytes_ = null;
  this.cursor_ = this.end_ = this.start_ = 0;
  this.error_ = !1;
  bytes && this.setBlock(bytes, start, length);
};
module$contents$jspb$BinaryDecoder_BinaryDecoder.alloc = function(bytes, start, length) {
  if (module$contents$jspb$BinaryDecoder_BinaryDecoder.instanceCache_.length) {
    var newDecoder = module$contents$jspb$BinaryDecoder_BinaryDecoder.instanceCache_.pop();
    bytes && newDecoder.setBlock(bytes, start, length);
    return newDecoder;
  }
  return new module$contents$jspb$BinaryDecoder_BinaryDecoder(bytes, start, length);
};
module$contents$jspb$BinaryDecoder_BinaryDecoder.prototype.free = function() {
  this.clear();
  100 > module$contents$jspb$BinaryDecoder_BinaryDecoder.instanceCache_.length && module$contents$jspb$BinaryDecoder_BinaryDecoder.instanceCache_.push(this);
};
module$contents$jspb$BinaryDecoder_BinaryDecoder.prototype.clone = function() {
  return module$contents$jspb$BinaryDecoder_BinaryDecoder.alloc(this.bytes_, this.start_, this.end_ - this.start_);
};
module$contents$jspb$BinaryDecoder_BinaryDecoder.prototype.clear = function() {
  this.bytes_ = null;
  this.cursor_ = this.end_ = this.start_ = 0;
  this.error_ = !1;
};
module$contents$jspb$BinaryDecoder_BinaryDecoder.prototype.getBuffer = function() {
  return this.bytes_;
};
module$contents$jspb$BinaryDecoder_BinaryDecoder.prototype.setBlock = function(data, start, length) {
  this.bytes_ = module$contents$jspb$utils_byteSourceToUint8Array(data);
  this.start_ = void 0 !== start ? start : 0;
  this.end_ = void 0 !== length ? this.start_ + length : this.bytes_.length;
  this.cursor_ = this.start_;
};
module$contents$jspb$BinaryDecoder_BinaryDecoder.prototype.getEnd = function() {
  return this.end_;
};
module$contents$jspb$BinaryDecoder_BinaryDecoder.prototype.setEnd = function(end) {
  this.end_ = end;
};
module$contents$jspb$BinaryDecoder_BinaryDecoder.prototype.reset = function() {
  this.cursor_ = this.start_;
};
module$contents$jspb$BinaryDecoder_BinaryDecoder.prototype.getCursor = function() {
  return this.cursor_;
};
module$contents$jspb$BinaryDecoder_BinaryDecoder.prototype.setCursor = function(cursor) {
  this.cursor_ = cursor;
};
module$contents$jspb$BinaryDecoder_BinaryDecoder.prototype.advance = function(count) {
  this.cursor_ += count;
  goog.asserts.assert(this.cursor_ <= this.end_);
};
module$contents$jspb$BinaryDecoder_BinaryDecoder.prototype.atEnd = function() {
  return this.cursor_ == this.end_;
};
module$contents$jspb$BinaryDecoder_BinaryDecoder.prototype.pastEnd = function() {
  return this.cursor_ > this.end_;
};
module$contents$jspb$BinaryDecoder_BinaryDecoder.prototype.getError = function() {
  return this.error_ || 0 > this.cursor_ || this.cursor_ > this.end_;
};
module$contents$jspb$BinaryDecoder_BinaryDecoder.prototype.readSplitVarint64 = function(convert) {
  for (var temp = 128, lowBits = 0, highBits = 0, i = 0; 4 > i && 128 <= temp; i++) {
    temp = this.bytes_[this.cursor_++], lowBits |= (temp & 127) << 7 * i;
  }
  128 <= temp && (temp = this.bytes_[this.cursor_++], lowBits |= (temp & 127) << 28, highBits |= (temp & 127) >> 4);
  if (128 <= temp) {
    for (i = 0; 5 > i && 128 <= temp; i++) {
      temp = this.bytes_[this.cursor_++], highBits |= (temp & 127) << 7 * i + 3;
    }
  }
  if (128 > temp) {
    return convert(lowBits >>> 0, highBits >>> 0);
  }
  goog.asserts.fail("Failed to read varint, encoding is invalid.");
  this.error_ = !0;
};
module$contents$jspb$BinaryDecoder_BinaryDecoder.prototype.readSplitZigzagVarint64 = function(convert) {
  return this.readSplitVarint64(function(low, high) {
    return module$contents$jspb$utils_fromZigzag64(low, high, convert);
  });
};
module$contents$jspb$BinaryDecoder_BinaryDecoder.prototype.readSplitFixed64 = function(convert) {
  var bytes = this.bytes_, cursor = this.cursor_;
  this.cursor_ += 8;
  for (var lowBits = 0, highBits = 0, i = cursor + 7; i >= cursor; i--) {
    lowBits = lowBits << 8 | bytes[i], highBits = highBits << 8 | bytes[i + 4];
  }
  return convert(lowBits, highBits);
};
module$contents$jspb$BinaryDecoder_BinaryDecoder.prototype.skipVarint = function() {
  for (; this.bytes_[this.cursor_] & 128;) {
    this.cursor_++;
  }
  this.cursor_++;
};
module$contents$jspb$BinaryDecoder_BinaryDecoder.prototype.unskipVarint = function(value) {
  for (; 128 < value;) {
    this.cursor_--, value >>>= 7;
  }
  this.cursor_--;
};
module$contents$jspb$BinaryDecoder_BinaryDecoder.prototype.readUnsignedVarint32 = function() {
  var bytes = this.bytes_;
  var temp = bytes[this.cursor_ + 0];
  var x = temp & 127;
  if (128 > temp) {
    return this.cursor_ += 1, goog.asserts.assert(this.cursor_ <= this.end_), x;
  }
  temp = bytes[this.cursor_ + 1];
  x |= (temp & 127) << 7;
  if (128 > temp) {
    return this.cursor_ += 2, goog.asserts.assert(this.cursor_ <= this.end_), x;
  }
  temp = bytes[this.cursor_ + 2];
  x |= (temp & 127) << 14;
  if (128 > temp) {
    return this.cursor_ += 3, goog.asserts.assert(this.cursor_ <= this.end_), x;
  }
  temp = bytes[this.cursor_ + 3];
  x |= (temp & 127) << 21;
  if (128 > temp) {
    return this.cursor_ += 4, goog.asserts.assert(this.cursor_ <= this.end_), x;
  }
  temp = bytes[this.cursor_ + 4];
  x |= (temp & 15) << 28;
  if (128 > temp) {
    return this.cursor_ += 5, goog.asserts.assert(this.cursor_ <= this.end_), x >>> 0;
  }
  this.cursor_ += 5;
  128 <= bytes[this.cursor_++] && 128 <= bytes[this.cursor_++] && 128 <= bytes[this.cursor_++] && 128 <= bytes[this.cursor_++] && 128 <= bytes[this.cursor_++] && goog.asserts.assert(!1);
  goog.asserts.assert(this.cursor_ <= this.end_);
  return x;
};
module$contents$jspb$BinaryDecoder_BinaryDecoder.prototype.readSignedVarint32 = function() {
  return this.readUnsignedVarint32();
};
module$contents$jspb$BinaryDecoder_BinaryDecoder.prototype.readUnsignedVarint32String = function() {
  return this.readUnsignedVarint32().toString();
};
module$contents$jspb$BinaryDecoder_BinaryDecoder.prototype.readSignedVarint32String = function() {
  return this.readSignedVarint32().toString();
};
module$contents$jspb$BinaryDecoder_BinaryDecoder.prototype.readZigzagVarint32 = function() {
  var result = this.readUnsignedVarint32();
  return result >>> 1 ^ -(result & 1);
};
module$contents$jspb$BinaryDecoder_BinaryDecoder.prototype.readUnsignedVarint64 = function() {
  return this.readSplitVarint64(module$contents$jspb$utils_joinUint64);
};
module$contents$jspb$BinaryDecoder_BinaryDecoder.prototype.readUnsignedVarint64String = function() {
  return this.readSplitVarint64(module$contents$jspb$utils_joinUnsignedDecimalString);
};
module$contents$jspb$BinaryDecoder_BinaryDecoder.prototype.readSignedVarint64 = function() {
  return this.readSplitVarint64(module$contents$jspb$utils_joinInt64);
};
module$contents$jspb$BinaryDecoder_BinaryDecoder.prototype.readSignedVarint64String = function() {
  return this.readSplitVarint64(module$contents$jspb$utils_joinSignedDecimalString);
};
module$contents$jspb$BinaryDecoder_BinaryDecoder.prototype.readZigzagVarint64 = function() {
  return this.readSplitVarint64(module$contents$jspb$utils_joinZigzag64);
};
module$contents$jspb$BinaryDecoder_BinaryDecoder.prototype.readZigzagVarint64String = function() {
  return this.readSplitZigzagVarint64(module$contents$jspb$utils_joinSignedDecimalString);
};
module$contents$jspb$BinaryDecoder_BinaryDecoder.prototype.readUint8 = function() {
  var a = this.bytes_[this.cursor_ + 0];
  this.cursor_ += 1;
  goog.asserts.assert(this.cursor_ <= this.end_);
  return a;
};
module$contents$jspb$BinaryDecoder_BinaryDecoder.prototype.readUint16 = function() {
  var a = this.bytes_[this.cursor_ + 0], b = this.bytes_[this.cursor_ + 1];
  this.cursor_ += 2;
  goog.asserts.assert(this.cursor_ <= this.end_);
  return a << 0 | b << 8;
};
module$contents$jspb$BinaryDecoder_BinaryDecoder.prototype.readUint32 = function() {
  var a = this.bytes_[this.cursor_ + 0], b = this.bytes_[this.cursor_ + 1], c = this.bytes_[this.cursor_ + 2], d = this.bytes_[this.cursor_ + 3];
  this.cursor_ += 4;
  goog.asserts.assert(this.cursor_ <= this.end_);
  return (a << 0 | b << 8 | c << 16 | d << 24) >>> 0;
};
module$contents$jspb$BinaryDecoder_BinaryDecoder.prototype.readUint64 = function() {
  var bitsLow = this.readUint32(), bitsHigh = this.readUint32();
  return module$contents$jspb$utils_joinUint64(bitsLow, bitsHigh);
};
module$contents$jspb$BinaryDecoder_BinaryDecoder.prototype.readUint64String = function() {
  var bitsLow = this.readUint32(), bitsHigh = this.readUint32();
  return module$contents$jspb$utils_joinUnsignedDecimalString(bitsLow, bitsHigh);
};
module$contents$jspb$BinaryDecoder_BinaryDecoder.prototype.readInt8 = function() {
  var a = this.bytes_[this.cursor_ + 0];
  this.cursor_ += 1;
  goog.asserts.assert(this.cursor_ <= this.end_);
  return a << 24 >> 24;
};
module$contents$jspb$BinaryDecoder_BinaryDecoder.prototype.readInt16 = function() {
  var a = this.bytes_[this.cursor_ + 0], b = this.bytes_[this.cursor_ + 1];
  this.cursor_ += 2;
  goog.asserts.assert(this.cursor_ <= this.end_);
  return (a << 0 | b << 8) << 16 >> 16;
};
module$contents$jspb$BinaryDecoder_BinaryDecoder.prototype.readInt32 = function() {
  var a = this.bytes_[this.cursor_ + 0], b = this.bytes_[this.cursor_ + 1], c = this.bytes_[this.cursor_ + 2], d = this.bytes_[this.cursor_ + 3];
  this.cursor_ += 4;
  goog.asserts.assert(this.cursor_ <= this.end_);
  return a << 0 | b << 8 | c << 16 | d << 24;
};
module$contents$jspb$BinaryDecoder_BinaryDecoder.prototype.readInt64 = function() {
  var bitsLow = this.readUint32(), bitsHigh = this.readUint32();
  return module$contents$jspb$utils_joinInt64(bitsLow, bitsHigh);
};
module$contents$jspb$BinaryDecoder_BinaryDecoder.prototype.readInt64String = function() {
  var bitsLow = this.readUint32(), bitsHigh = this.readUint32();
  return module$contents$jspb$utils_joinSignedDecimalString(bitsLow, bitsHigh);
};
module$contents$jspb$BinaryDecoder_BinaryDecoder.prototype.readFloat = function() {
  var bitsLow = this.readUint32();
  return module$contents$jspb$utils_joinFloat32(bitsLow, 0);
};
module$contents$jspb$BinaryDecoder_BinaryDecoder.prototype.readDouble = function() {
  var bitsLow = this.readUint32(), bitsHigh = this.readUint32();
  return module$contents$jspb$utils_joinFloat64(bitsLow, bitsHigh);
};
module$contents$jspb$BinaryDecoder_BinaryDecoder.prototype.readBool = function() {
  return !!this.bytes_[this.cursor_++];
};
module$contents$jspb$BinaryDecoder_BinaryDecoder.prototype.readEnum = function() {
  return this.readSignedVarint32();
};
module$contents$jspb$BinaryDecoder_BinaryDecoder.prototype.readString = function(length) {
  for (var bytes = this.bytes_, cursor = this.cursor_, end = cursor + length, codeUnits = [], result = ""; cursor < end;) {
    var c = bytes[cursor++];
    if (128 > c) {
      codeUnits.push(c);
    } else {
      if (192 > c) {
        continue;
      } else {
        if (224 > c) {
          var c2 = bytes[cursor++];
          codeUnits.push((c & 31) << 6 | c2 & 63);
        } else {
          if (240 > c) {
            c2 = bytes[cursor++];
            var c3 = bytes[cursor++];
            codeUnits.push((c & 15) << 12 | (c2 & 63) << 6 | c3 & 63);
          } else {
            if (248 > c) {
              c2 = bytes[cursor++];
              c3 = bytes[cursor++];
              var c4 = bytes[cursor++], codepoint = (c & 7) << 18 | (c2 & 63) << 12 | (c3 & 63) << 6 | c4 & 63;
              codepoint -= 65536;
              codeUnits.push((codepoint >> 10 & 1023) + 55296, (codepoint & 1023) + 56320);
            }
          }
        }
      }
    }
    8192 <= codeUnits.length && (result += String.fromCharCode.apply(null, codeUnits), codeUnits.length = 0);
  }
  result += goog.crypt.byteArrayToString(codeUnits);
  this.cursor_ = cursor;
  return result;
};
module$contents$jspb$BinaryDecoder_BinaryDecoder.prototype.readStringWithLength = function() {
  var length = this.readUnsignedVarint32();
  return this.readString(length);
};
module$contents$jspb$BinaryDecoder_BinaryDecoder.prototype.readBytes = function(length) {
  if (0 > length || this.cursor_ + length > this.bytes_.length) {
    return this.error_ = !0, goog.asserts.fail("Invalid byte length!"), new Uint8Array(0);
  }
  var result = this.bytes_.subarray(this.cursor_, this.cursor_ + length);
  this.cursor_ += length;
  goog.asserts.assert(this.cursor_ <= this.end_);
  return result;
};
module$contents$jspb$BinaryDecoder_BinaryDecoder.resetInstanceCache = function() {
  module$contents$jspb$BinaryDecoder_BinaryDecoder.instanceCache_ = [];
};
module$contents$jspb$BinaryDecoder_BinaryDecoder.getInstanceCache = function() {
  return module$contents$jspb$BinaryDecoder_BinaryDecoder.instanceCache_;
};
module$contents$jspb$BinaryDecoder_BinaryDecoder.instanceCache_ = [];
jspb.BinaryDecoder = module$contents$jspb$BinaryDecoder_BinaryDecoder;
var module$contents$jspb$BinaryReader_BinaryReader = function(bytes, start, length) {
  this.decoder_ = module$contents$jspb$BinaryDecoder_BinaryDecoder.alloc(bytes, start, length);
  this.fieldCursor_ = this.decoder_.getCursor();
  this.nextField_ = -1;
  this.nextWireType_ = module$contents$jspb$BinaryConstants_WireType.INVALID;
  this.error_ = !1;
  this.readCallbacks_ = null;
};
module$contents$jspb$BinaryReader_BinaryReader.alloc = function(bytes, start, length) {
  if (module$contents$jspb$BinaryReader_BinaryReader.instanceCache_.length) {
    var newReader = module$contents$jspb$BinaryReader_BinaryReader.instanceCache_.pop();
    bytes && newReader.decoder_.setBlock(bytes, start, length);
    return newReader;
  }
  return new module$contents$jspb$BinaryReader_BinaryReader(bytes, start, length);
};
module$contents$jspb$BinaryReader_BinaryReader.prototype.free = function() {
  this.decoder_.clear();
  this.nextField_ = -1;
  this.nextWireType_ = module$contents$jspb$BinaryConstants_WireType.INVALID;
  this.error_ = !1;
  this.readCallbacks_ = null;
  100 > module$contents$jspb$BinaryReader_BinaryReader.instanceCache_.length && module$contents$jspb$BinaryReader_BinaryReader.instanceCache_.push(this);
};
module$contents$jspb$BinaryReader_BinaryReader.prototype.getFieldCursor = function() {
  return this.fieldCursor_;
};
module$contents$jspb$BinaryReader_BinaryReader.prototype.getCursor = function() {
  return this.decoder_.getCursor();
};
module$contents$jspb$BinaryReader_BinaryReader.prototype.getBuffer = function() {
  return this.decoder_.getBuffer();
};
module$contents$jspb$BinaryReader_BinaryReader.prototype.getFieldNumber = function() {
  return this.nextField_;
};
module$contents$jspb$BinaryReader_BinaryReader.prototype.getWireType = function() {
  return this.nextWireType_;
};
module$contents$jspb$BinaryReader_BinaryReader.prototype.isEndGroup = function() {
  return this.nextWireType_ == module$contents$jspb$BinaryConstants_WireType.END_GROUP;
};
module$contents$jspb$BinaryReader_BinaryReader.prototype.getError = function() {
  return this.error_ || this.decoder_.getError();
};
module$contents$jspb$BinaryReader_BinaryReader.prototype.setBlock = function(bytes, start, length) {
  this.decoder_.setBlock(bytes, start, length);
  this.nextField_ = -1;
  this.nextWireType_ = module$contents$jspb$BinaryConstants_WireType.INVALID;
};
module$contents$jspb$BinaryReader_BinaryReader.prototype.reset = function() {
  this.decoder_.reset();
  this.nextField_ = -1;
  this.nextWireType_ = module$contents$jspb$BinaryConstants_WireType.INVALID;
};
module$contents$jspb$BinaryReader_BinaryReader.prototype.advance = function(count) {
  this.decoder_.advance(count);
};
module$contents$jspb$BinaryReader_BinaryReader.prototype.nextField = function() {
  if (this.decoder_.atEnd()) {
    return !1;
  }
  if (this.getError()) {
    return goog.asserts.fail("Decoder hit an error"), !1;
  }
  this.fieldCursor_ = this.decoder_.getCursor();
  var header = this.decoder_.readUnsignedVarint32(), nextField = header >>> 3, nextWireType = header & 7;
  if (nextWireType != module$contents$jspb$BinaryConstants_WireType.VARINT && nextWireType != module$contents$jspb$BinaryConstants_WireType.FIXED32 && nextWireType != module$contents$jspb$BinaryConstants_WireType.FIXED64 && nextWireType != module$contents$jspb$BinaryConstants_WireType.DELIMITED && nextWireType != module$contents$jspb$BinaryConstants_WireType.START_GROUP && nextWireType != module$contents$jspb$BinaryConstants_WireType.END_GROUP) {
    return goog.asserts.fail("Invalid wire type: %s (at position %s)", nextWireType, this.fieldCursor_), this.error_ = !0, !1;
  }
  this.nextField_ = nextField;
  this.nextWireType_ = nextWireType;
  return !0;
};
module$contents$jspb$BinaryReader_BinaryReader.prototype.unskipHeader = function() {
  this.decoder_.unskipVarint(this.nextField_ << 3 | this.nextWireType_);
};
module$contents$jspb$BinaryReader_BinaryReader.prototype.skipMatchingFields = function() {
  var field = this.nextField_;
  for (this.unskipHeader(); this.nextField() && this.getFieldNumber() == field;) {
    this.skipField();
  }
  this.decoder_.atEnd() || this.unskipHeader();
};
module$contents$jspb$BinaryReader_BinaryReader.prototype.skipVarintField = function() {
  this.nextWireType_ != module$contents$jspb$BinaryConstants_WireType.VARINT ? (goog.asserts.fail("Invalid wire type for skipVarintField"), this.skipField()) : this.decoder_.skipVarint();
};
module$contents$jspb$BinaryReader_BinaryReader.prototype.skipDelimitedField = function() {
  if (this.nextWireType_ != module$contents$jspb$BinaryConstants_WireType.DELIMITED) {
    goog.asserts.fail("Invalid wire type for skipDelimitedField"), this.skipField();
  } else {
    var length = this.decoder_.readUnsignedVarint32();
    this.decoder_.advance(length);
  }
};
module$contents$jspb$BinaryReader_BinaryReader.prototype.skipFixed32Field = function() {
  this.nextWireType_ != module$contents$jspb$BinaryConstants_WireType.FIXED32 ? (goog.asserts.fail("Invalid wire type for skipFixed32Field"), this.skipField()) : this.decoder_.advance(4);
};
module$contents$jspb$BinaryReader_BinaryReader.prototype.skipFixed64Field = function() {
  this.nextWireType_ != module$contents$jspb$BinaryConstants_WireType.FIXED64 ? (goog.asserts.fail("Invalid wire type for skipFixed64Field"), this.skipField()) : this.decoder_.advance(8);
};
module$contents$jspb$BinaryReader_BinaryReader.prototype.skipGroup = function() {
  var previousField = this.nextField_;
  do {
    if (!this.nextField()) {
      goog.asserts.fail("Unmatched start-group tag: stream EOF");
      this.error_ = !0;
      break;
    }
    if (this.nextWireType_ == module$contents$jspb$BinaryConstants_WireType.END_GROUP) {
      this.nextField_ != previousField && (goog.asserts.fail("Unmatched end-group tag"), this.error_ = !0);
      break;
    }
    this.skipField();
  } while (1);
};
module$contents$jspb$BinaryReader_BinaryReader.prototype.skipField = function() {
  switch(this.nextWireType_) {
    case module$contents$jspb$BinaryConstants_WireType.VARINT:
      this.skipVarintField();
      break;
    case module$contents$jspb$BinaryConstants_WireType.FIXED64:
      this.skipFixed64Field();
      break;
    case module$contents$jspb$BinaryConstants_WireType.DELIMITED:
      this.skipDelimitedField();
      break;
    case module$contents$jspb$BinaryConstants_WireType.FIXED32:
      this.skipFixed32Field();
      break;
    case module$contents$jspb$BinaryConstants_WireType.START_GROUP:
      this.skipGroup();
      break;
    default:
      this.error_ = !0, goog.asserts.fail("Invalid wire encoding for field.");
  }
};
module$contents$jspb$BinaryReader_BinaryReader.prototype.registerReadCallback = function(callbackName, callback) {
  null === this.readCallbacks_ && (this.readCallbacks_ = {});
  goog.asserts.assert(!this.readCallbacks_[callbackName]);
  this.readCallbacks_[callbackName] = callback;
};
module$contents$jspb$BinaryReader_BinaryReader.prototype.runReadCallback = function(callbackName) {
  goog.asserts.assert(null !== this.readCallbacks_);
  var callback = this.readCallbacks_[callbackName];
  goog.asserts.assert(callback);
  return callback(this);
};
module$contents$jspb$BinaryReader_BinaryReader.prototype.readAny = function(fieldType) {
  this.nextWireType_ = module$contents$jspb$BinaryConstants_FieldTypeToWireType(fieldType);
  switch(fieldType) {
    case module$contents$jspb$BinaryConstants_FieldType.DOUBLE:
      return this.readDouble();
    case module$contents$jspb$BinaryConstants_FieldType.FLOAT:
      return this.readFloat();
    case module$contents$jspb$BinaryConstants_FieldType.INT64:
      return this.readInt64();
    case module$contents$jspb$BinaryConstants_FieldType.UINT64:
      return this.readUint64();
    case module$contents$jspb$BinaryConstants_FieldType.INT32:
      return this.readInt32();
    case module$contents$jspb$BinaryConstants_FieldType.FIXED64:
      return this.readFixed64();
    case module$contents$jspb$BinaryConstants_FieldType.FIXED32:
      return this.readFixed32();
    case module$contents$jspb$BinaryConstants_FieldType.BOOL:
      return this.readBool();
    case module$contents$jspb$BinaryConstants_FieldType.STRING:
      return this.readString();
    case module$contents$jspb$BinaryConstants_FieldType.GROUP:
      goog.asserts.fail("Group field type not supported in readAny()");
    case module$contents$jspb$BinaryConstants_FieldType.MESSAGE:
      goog.asserts.fail("Message field type not supported in readAny()");
    case module$contents$jspb$BinaryConstants_FieldType.BYTES:
      return this.readBytes();
    case module$contents$jspb$BinaryConstants_FieldType.UINT32:
      return this.readUint32();
    case module$contents$jspb$BinaryConstants_FieldType.ENUM:
      return this.readEnum();
    case module$contents$jspb$BinaryConstants_FieldType.SFIXED32:
      return this.readSfixed32();
    case module$contents$jspb$BinaryConstants_FieldType.SFIXED64:
      return this.readSfixed64();
    case module$contents$jspb$BinaryConstants_FieldType.SINT32:
      return this.readSint32();
    case module$contents$jspb$BinaryConstants_FieldType.SINT64:
      return this.readSint64();
    default:
      goog.asserts.fail("Invalid field type in readAny()");
  }
  return 0;
};
module$contents$jspb$BinaryReader_BinaryReader.prototype.readMessage = function(message, reader) {
  goog.asserts.assert(this.nextWireType_ == module$contents$jspb$BinaryConstants_WireType.DELIMITED);
  var oldEnd = this.decoder_.getEnd(), length = this.decoder_.readUnsignedVarint32(), newEnd = this.decoder_.getCursor() + length;
  this.decoder_.setEnd(newEnd);
  reader(message, this);
  this.decoder_.setCursor(newEnd);
  this.decoder_.setEnd(oldEnd);
};
module$contents$jspb$BinaryReader_BinaryReader.prototype.readGroup = function(field, message, reader) {
  goog.asserts.assert(this.nextWireType_ == module$contents$jspb$BinaryConstants_WireType.START_GROUP);
  goog.asserts.assert(this.nextField_ == field);
  reader(message, this);
  this.error_ || this.nextWireType_ == module$contents$jspb$BinaryConstants_WireType.END_GROUP || (goog.asserts.fail("Group submessage did not end with an END_GROUP tag"), this.error_ = !0);
};
module$contents$jspb$BinaryReader_BinaryReader.prototype.getFieldDecoder = function() {
  goog.asserts.assert(this.nextWireType_ == module$contents$jspb$BinaryConstants_WireType.DELIMITED);
  var length = this.decoder_.readUnsignedVarint32(), start = this.decoder_.getCursor(), end = start + length, innerDecoder = module$contents$jspb$BinaryDecoder_BinaryDecoder.alloc(this.decoder_.getBuffer(), start, length);
  this.decoder_.setCursor(end);
  return innerDecoder;
};
module$contents$jspb$BinaryReader_BinaryReader.prototype.readInt32 = function() {
  goog.asserts.assert(this.nextWireType_ == module$contents$jspb$BinaryConstants_WireType.VARINT);
  return this.decoder_.readSignedVarint32();
};
module$contents$jspb$BinaryReader_BinaryReader.prototype.readInt32String = function() {
  goog.asserts.assert(this.nextWireType_ == module$contents$jspb$BinaryConstants_WireType.VARINT);
  return this.decoder_.readSignedVarint32String();
};
module$contents$jspb$BinaryReader_BinaryReader.prototype.readInt64 = function() {
  goog.asserts.assert(this.nextWireType_ == module$contents$jspb$BinaryConstants_WireType.VARINT);
  return this.decoder_.readSignedVarint64();
};
module$contents$jspb$BinaryReader_BinaryReader.prototype.readInt64String = function() {
  goog.asserts.assert(this.nextWireType_ == module$contents$jspb$BinaryConstants_WireType.VARINT);
  return this.decoder_.readSignedVarint64String();
};
module$contents$jspb$BinaryReader_BinaryReader.prototype.readUint32 = function() {
  goog.asserts.assert(this.nextWireType_ == module$contents$jspb$BinaryConstants_WireType.VARINT);
  return this.decoder_.readUnsignedVarint32();
};
module$contents$jspb$BinaryReader_BinaryReader.prototype.readUint32String = function() {
  goog.asserts.assert(this.nextWireType_ == module$contents$jspb$BinaryConstants_WireType.VARINT);
  return this.decoder_.readUnsignedVarint32String();
};
module$contents$jspb$BinaryReader_BinaryReader.prototype.readUint64 = function() {
  goog.asserts.assert(this.nextWireType_ == module$contents$jspb$BinaryConstants_WireType.VARINT);
  return this.decoder_.readUnsignedVarint64();
};
module$contents$jspb$BinaryReader_BinaryReader.prototype.readUint64String = function() {
  goog.asserts.assert(this.nextWireType_ == module$contents$jspb$BinaryConstants_WireType.VARINT);
  return this.decoder_.readUnsignedVarint64String();
};
module$contents$jspb$BinaryReader_BinaryReader.prototype.readSint32 = function() {
  goog.asserts.assert(this.nextWireType_ == module$contents$jspb$BinaryConstants_WireType.VARINT);
  return this.decoder_.readZigzagVarint32();
};
module$contents$jspb$BinaryReader_BinaryReader.prototype.readSint64 = function() {
  goog.asserts.assert(this.nextWireType_ == module$contents$jspb$BinaryConstants_WireType.VARINT);
  return this.decoder_.readZigzagVarint64();
};
module$contents$jspb$BinaryReader_BinaryReader.prototype.readSint64String = function() {
  goog.asserts.assert(this.nextWireType_ == module$contents$jspb$BinaryConstants_WireType.VARINT);
  return this.decoder_.readZigzagVarint64String();
};
module$contents$jspb$BinaryReader_BinaryReader.prototype.readFixed32 = function() {
  goog.asserts.assert(this.nextWireType_ == module$contents$jspb$BinaryConstants_WireType.FIXED32);
  return this.decoder_.readUint32();
};
module$contents$jspb$BinaryReader_BinaryReader.prototype.readFixed64 = function() {
  goog.asserts.assert(this.nextWireType_ == module$contents$jspb$BinaryConstants_WireType.FIXED64);
  return this.decoder_.readUint64();
};
module$contents$jspb$BinaryReader_BinaryReader.prototype.readFixed64String = function() {
  goog.asserts.assert(this.nextWireType_ == module$contents$jspb$BinaryConstants_WireType.FIXED64);
  return this.decoder_.readUint64String();
};
module$contents$jspb$BinaryReader_BinaryReader.prototype.readSfixed32 = function() {
  goog.asserts.assert(this.nextWireType_ == module$contents$jspb$BinaryConstants_WireType.FIXED32);
  return this.decoder_.readInt32();
};
module$contents$jspb$BinaryReader_BinaryReader.prototype.readSfixed32String = function() {
  goog.asserts.assert(this.nextWireType_ == module$contents$jspb$BinaryConstants_WireType.FIXED32);
  return this.decoder_.readInt32().toString();
};
module$contents$jspb$BinaryReader_BinaryReader.prototype.readSfixed64 = function() {
  goog.asserts.assert(this.nextWireType_ == module$contents$jspb$BinaryConstants_WireType.FIXED64);
  return this.decoder_.readInt64();
};
module$contents$jspb$BinaryReader_BinaryReader.prototype.readSfixed64String = function() {
  goog.asserts.assert(this.nextWireType_ == module$contents$jspb$BinaryConstants_WireType.FIXED64);
  return this.decoder_.readInt64String();
};
module$contents$jspb$BinaryReader_BinaryReader.prototype.readFloat = function() {
  goog.asserts.assert(this.nextWireType_ == module$contents$jspb$BinaryConstants_WireType.FIXED32);
  return this.decoder_.readFloat();
};
module$contents$jspb$BinaryReader_BinaryReader.prototype.readDouble = function() {
  goog.asserts.assert(this.nextWireType_ == module$contents$jspb$BinaryConstants_WireType.FIXED64);
  return this.decoder_.readDouble();
};
module$contents$jspb$BinaryReader_BinaryReader.prototype.readBool = function() {
  goog.asserts.assert(this.nextWireType_ == module$contents$jspb$BinaryConstants_WireType.VARINT);
  return !!this.decoder_.readUnsignedVarint32();
};
module$contents$jspb$BinaryReader_BinaryReader.prototype.readEnum = function() {
  goog.asserts.assert(this.nextWireType_ == module$contents$jspb$BinaryConstants_WireType.VARINT);
  return this.decoder_.readSignedVarint64();
};
module$contents$jspb$BinaryReader_BinaryReader.prototype.readString = function() {
  goog.asserts.assert(this.nextWireType_ == module$contents$jspb$BinaryConstants_WireType.DELIMITED);
  var length = this.decoder_.readUnsignedVarint32();
  return this.decoder_.readString(length);
};
module$contents$jspb$BinaryReader_BinaryReader.prototype.readBytes = function() {
  goog.asserts.assert(this.nextWireType_ == module$contents$jspb$BinaryConstants_WireType.DELIMITED);
  var length = this.decoder_.readUnsignedVarint32();
  return this.decoder_.readBytes(length);
};
module$contents$jspb$BinaryReader_BinaryReader.prototype.readSplitVarint64 = function(convert) {
  goog.asserts.assert(this.nextWireType_ == module$contents$jspb$BinaryConstants_WireType.VARINT);
  return this.decoder_.readSplitVarint64(convert);
};
module$contents$jspb$BinaryReader_BinaryReader.prototype.readSplitZigzagVarint64 = function(convert) {
  goog.asserts.assert(this.nextWireType_ == module$contents$jspb$BinaryConstants_WireType.VARINT);
  return this.decoder_.readSplitVarint64(function(lowBits, highBits) {
    return module$contents$jspb$utils_fromZigzag64(lowBits, highBits, convert);
  });
};
module$contents$jspb$BinaryReader_BinaryReader.prototype.readSplitFixed64 = function(convert) {
  goog.asserts.assert(this.nextWireType_ == module$contents$jspb$BinaryConstants_WireType.FIXED64);
  return this.decoder_.readSplitFixed64(convert);
};
module$contents$jspb$BinaryReader_BinaryReader.prototype.readPackedField_ = function(decodeMethod) {
  goog.asserts.assert(this.nextWireType_ == module$contents$jspb$BinaryConstants_WireType.DELIMITED);
  for (var length = this.decoder_.readUnsignedVarint32(), end = this.decoder_.getCursor() + length, result = []; this.decoder_.getCursor() < end;) {
    result.push(decodeMethod.call(this.decoder_));
  }
  return result;
};
module$contents$jspb$BinaryReader_BinaryReader.prototype.readPackedInt32 = function() {
  return this.readPackedField_(this.decoder_.readSignedVarint32);
};
module$contents$jspb$BinaryReader_BinaryReader.prototype.readPackedInt32String = function() {
  return this.readPackedField_(this.decoder_.readSignedVarint32String);
};
module$contents$jspb$BinaryReader_BinaryReader.prototype.readPackedInt64 = function() {
  return this.readPackedField_(this.decoder_.readSignedVarint64);
};
module$contents$jspb$BinaryReader_BinaryReader.prototype.readPackedInt64String = function() {
  return this.readPackedField_(this.decoder_.readSignedVarint64String);
};
module$contents$jspb$BinaryReader_BinaryReader.prototype.readPackedUint32 = function() {
  return this.readPackedField_(this.decoder_.readUnsignedVarint32);
};
module$contents$jspb$BinaryReader_BinaryReader.prototype.readPackedUint32String = function() {
  return this.readPackedField_(this.decoder_.readUnsignedVarint32String);
};
module$contents$jspb$BinaryReader_BinaryReader.prototype.readPackedUint64 = function() {
  return this.readPackedField_(this.decoder_.readUnsignedVarint64);
};
module$contents$jspb$BinaryReader_BinaryReader.prototype.readPackedUint64String = function() {
  return this.readPackedField_(this.decoder_.readUnsignedVarint64String);
};
module$contents$jspb$BinaryReader_BinaryReader.prototype.readPackedSint32 = function() {
  return this.readPackedField_(this.decoder_.readZigzagVarint32);
};
module$contents$jspb$BinaryReader_BinaryReader.prototype.readPackedSint64 = function() {
  return this.readPackedField_(this.decoder_.readZigzagVarint64);
};
module$contents$jspb$BinaryReader_BinaryReader.prototype.readPackedSint64String = function() {
  return this.readPackedField_(this.decoder_.readZigzagVarint64String);
};
module$contents$jspb$BinaryReader_BinaryReader.prototype.readPackedFixed32 = function() {
  return this.readPackedField_(this.decoder_.readUint32);
};
module$contents$jspb$BinaryReader_BinaryReader.prototype.readPackedFixed64 = function() {
  return this.readPackedField_(this.decoder_.readUint64);
};
module$contents$jspb$BinaryReader_BinaryReader.prototype.readPackedFixed64String = function() {
  return this.readPackedField_(this.decoder_.readUint64String);
};
module$contents$jspb$BinaryReader_BinaryReader.prototype.readPackedSfixed32 = function() {
  return this.readPackedField_(this.decoder_.readInt32);
};
module$contents$jspb$BinaryReader_BinaryReader.prototype.readPackedSfixed64 = function() {
  return this.readPackedField_(this.decoder_.readInt64);
};
module$contents$jspb$BinaryReader_BinaryReader.prototype.readPackedSfixed64String = function() {
  return this.readPackedField_(this.decoder_.readInt64String);
};
module$contents$jspb$BinaryReader_BinaryReader.prototype.readPackedFloat = function() {
  return this.readPackedField_(this.decoder_.readFloat);
};
module$contents$jspb$BinaryReader_BinaryReader.prototype.readPackedDouble = function() {
  return this.readPackedField_(this.decoder_.readDouble);
};
module$contents$jspb$BinaryReader_BinaryReader.prototype.readPackedBool = function() {
  return this.readPackedField_(this.decoder_.readBool);
};
module$contents$jspb$BinaryReader_BinaryReader.prototype.readPackedEnum = function() {
  return this.readPackedField_(this.decoder_.readEnum);
};
module$contents$jspb$BinaryReader_BinaryReader.resetInstanceCache = function() {
  module$contents$jspb$BinaryReader_BinaryReader.instanceCache_ = [];
};
module$contents$jspb$BinaryReader_BinaryReader.getInstanceCache = function() {
  return module$contents$jspb$BinaryReader_BinaryReader.instanceCache_;
};
module$contents$jspb$BinaryReader_BinaryReader.instanceCache_ = [];
jspb.BinaryReader = module$contents$jspb$BinaryReader_BinaryReader;
jspb.arith = {};
jspb.arith.UInt64 = function(lo, hi) {
  this.lo = lo;
  this.hi = hi;
};
jspb.arith.UInt64.prototype.cmp = function(other) {
  return this.hi < other.hi || this.hi == other.hi && this.lo < other.lo ? -1 : this.hi == other.hi && this.lo == other.lo ? 0 : 1;
};
jspb.arith.UInt64.prototype.rightShift = function() {
  return new jspb.arith.UInt64((this.lo >>> 1 | (this.hi & 1) << 31) >>> 0, this.hi >>> 1 >>> 0);
};
jspb.arith.UInt64.prototype.leftShift = function() {
  return new jspb.arith.UInt64(this.lo << 1 >>> 0, (this.hi << 1 | this.lo >>> 31) >>> 0);
};
jspb.arith.UInt64.prototype.msb = function() {
  return !!(this.hi & 2147483648);
};
jspb.arith.UInt64.prototype.lsb = function() {
  return !!(this.lo & 1);
};
jspb.arith.UInt64.prototype.zero = function() {
  return 0 == this.lo && 0 == this.hi;
};
jspb.arith.UInt64.prototype.add = function(other) {
  return new jspb.arith.UInt64((this.lo + other.lo & 4294967295) >>> 0 >>> 0, ((this.hi + other.hi & 4294967295) >>> 0) + (4294967296 <= this.lo + other.lo ? 1 : 0) >>> 0);
};
jspb.arith.UInt64.prototype.sub = function(other) {
  return new jspb.arith.UInt64((this.lo - other.lo & 4294967295) >>> 0 >>> 0, ((this.hi - other.hi & 4294967295) >>> 0) - (0 > this.lo - other.lo ? 1 : 0) >>> 0);
};
jspb.arith.UInt64.mul32x32 = function(a, b) {
  for (var aLow = a & 65535, aHigh = a >>> 16, bLow = b & 65535, bHigh = b >>> 16, productLow = aLow * bLow + 65536 * (aLow * bHigh & 65535) + 65536 * (aHigh * bLow & 65535), productHigh = aHigh * bHigh + (aLow * bHigh >>> 16) + (aHigh * bLow >>> 16); 4294967296 <= productLow;) {
    productLow -= 4294967296, productHigh += 1;
  }
  return new jspb.arith.UInt64(productLow >>> 0, productHigh >>> 0);
};
jspb.arith.UInt64.prototype.mul = function(a) {
  var lo = jspb.arith.UInt64.mul32x32(this.lo, a), hi = jspb.arith.UInt64.mul32x32(this.hi, a);
  hi.hi = hi.lo;
  hi.lo = 0;
  return lo.add(hi);
};
jspb.arith.UInt64.prototype.div = function(_divisor) {
  if (0 == _divisor) {
    return [];
  }
  for (var quotient = new jspb.arith.UInt64(0, 0), remainder = new jspb.arith.UInt64(this.lo, this.hi), divisor = new jspb.arith.UInt64(_divisor, 0), unit = new jspb.arith.UInt64(1, 0); !divisor.msb();) {
    divisor = divisor.leftShift(), unit = unit.leftShift();
  }
  for (; !unit.zero();) {
    0 >= divisor.cmp(remainder) && (quotient = quotient.add(unit), remainder = remainder.sub(divisor)), divisor = divisor.rightShift(), unit = unit.rightShift();
  }
  return [quotient, remainder];
};
jspb.arith.UInt64.prototype.toString = function() {
  for (var result = "", num = this; !num.zero();) {
    var divResult = num.div(10), quotient = divResult[0];
    result = divResult[1].lo + result;
    num = quotient;
  }
  "" == result && (result = "0");
  return result;
};
jspb.arith.UInt64.fromString = function(s) {
  for (var result = new jspb.arith.UInt64(0, 0), digit64 = new jspb.arith.UInt64(0, 0), i = 0; i < s.length; i++) {
    if ("0" > s[i] || "9" < s[i]) {
      return null;
    }
    digit64.lo = parseInt(s[i], 10);
    result = result.mul(10).add(digit64);
  }
  return result;
};
jspb.arith.UInt64.prototype.clone = function() {
  return new jspb.arith.UInt64(this.lo, this.hi);
};
jspb.arith.Int64 = function(lo, hi) {
  this.lo = lo;
  this.hi = hi;
};
jspb.arith.Int64.prototype.add = function(other) {
  return new jspb.arith.Int64((this.lo + other.lo & 4294967295) >>> 0 >>> 0, ((this.hi + other.hi & 4294967295) >>> 0) + (4294967296 <= this.lo + other.lo ? 1 : 0) >>> 0);
};
jspb.arith.Int64.prototype.sub = function(other) {
  return new jspb.arith.Int64((this.lo - other.lo & 4294967295) >>> 0 >>> 0, ((this.hi - other.hi & 4294967295) >>> 0) - (0 > this.lo - other.lo ? 1 : 0) >>> 0);
};
jspb.arith.Int64.prototype.clone = function() {
  return new jspb.arith.Int64(this.lo, this.hi);
};
jspb.arith.Int64.prototype.toString = function() {
  var sign = 0 != (this.hi & 2147483648), num = new jspb.arith.UInt64(this.lo, this.hi);
  sign && (num = (new jspb.arith.UInt64(0, 0)).sub(num));
  return (sign ? "-" : "") + num.toString();
};
jspb.arith.Int64.fromString = function(s) {
  var hasNegative = 0 < s.length && "-" == s[0];
  hasNegative && (s = s.substring(1));
  var num = jspb.arith.UInt64.fromString(s);
  if (null === num) {
    return null;
  }
  hasNegative && (num = (new jspb.arith.UInt64(0, 0)).sub(num));
  return new jspb.arith.Int64(num.lo, num.hi);
};
jspb.BinaryEncoder = function() {
  this.buffer_ = [];
};
jspb.BinaryEncoder.prototype.length = function() {
  return this.buffer_.length;
};
jspb.BinaryEncoder.prototype.end = function() {
  var buffer = this.buffer_;
  this.buffer_ = [];
  return buffer;
};
jspb.BinaryEncoder.prototype.writeSplitVarint64 = function(lowBits, highBits) {
  goog.asserts.assert(lowBits == Math.floor(lowBits));
  goog.asserts.assert(highBits == Math.floor(highBits));
  goog.asserts.assert(0 <= lowBits && 4294967296 > lowBits);
  for (goog.asserts.assert(0 <= highBits && 4294967296 > highBits); 0 < highBits || 127 < lowBits;) {
    this.buffer_.push(lowBits & 127 | 128), lowBits = (lowBits >>> 7 | highBits << 25) >>> 0, highBits >>>= 7;
  }
  this.buffer_.push(lowBits);
};
jspb.BinaryEncoder.prototype.writeSplitFixed64 = function(lowBits, highBits) {
  goog.asserts.assert(lowBits == Math.floor(lowBits));
  goog.asserts.assert(highBits == Math.floor(highBits));
  goog.asserts.assert(0 <= lowBits && 4294967296 > lowBits);
  goog.asserts.assert(0 <= highBits && 4294967296 > highBits);
  this.writeUint32(lowBits);
  this.writeUint32(highBits);
};
jspb.BinaryEncoder.prototype.writeSplitZigzagVarint64 = function(lowBits, highBits) {
  var self = this;
  module$contents$jspb$utils_toZigzag64(lowBits, highBits, function(lo, hi) {
    self.writeSplitVarint64(lo >>> 0, hi >>> 0);
  });
};
jspb.BinaryEncoder.prototype.writeUnsignedVarint32 = function(value) {
  goog.asserts.assert(value == Math.floor(value));
  for (goog.asserts.assert(0 <= value && 4294967296 > value); 127 < value;) {
    this.buffer_.push(value & 127 | 128), value >>>= 7;
  }
  this.buffer_.push(value);
};
jspb.BinaryEncoder.prototype.writeSignedVarint32 = function(value) {
  goog.asserts.assert(value == Math.floor(value));
  goog.asserts.assert(-2147483648 <= value && 2147483648 > value);
  if (0 <= value) {
    this.writeUnsignedVarint32(value);
  } else {
    for (var i = 0; 9 > i; i++) {
      this.buffer_.push(value & 127 | 128), value >>= 7;
    }
    this.buffer_.push(1);
  }
};
jspb.BinaryEncoder.prototype.writeUnsignedVarint64 = function(value) {
  goog.asserts.assert(value == Math.floor(value));
  goog.asserts.assert(0 <= value && 18446744073709551616 > value);
  module$contents$jspb$utils_splitInt64(value);
  this.writeSplitVarint64(module$contents$jspb$utils_getSplit64Low(), module$contents$jspb$utils_getSplit64High());
};
jspb.BinaryEncoder.prototype.writeSignedVarint64 = function(value) {
  goog.asserts.assert(value == Math.floor(value));
  goog.asserts.assert(-9223372036854775808 <= value && 9223372036854775808 > value);
  module$contents$jspb$utils_splitInt64(value);
  this.writeSplitVarint64(module$contents$jspb$utils_getSplit64Low(), module$contents$jspb$utils_getSplit64High());
};
jspb.BinaryEncoder.prototype.writeZigzagVarint32 = function(value) {
  goog.asserts.assert(value == Math.floor(value));
  goog.asserts.assert(-2147483648 <= value && 2147483648 > value);
  this.writeUnsignedVarint32((value << 1 ^ value >> 31) >>> 0);
};
jspb.BinaryEncoder.prototype.writeZigzagVarint64 = function(value) {
  goog.asserts.assert(value == Math.floor(value));
  goog.asserts.assert(-9223372036854775808 <= value && 9223372036854775808 > value);
  module$contents$jspb$utils_splitZigzag64(value);
  this.writeSplitVarint64(module$contents$jspb$utils_getSplit64Low(), module$contents$jspb$utils_getSplit64High());
};
jspb.BinaryEncoder.prototype.writeZigzagVarint64String = function(value) {
  var self = this;
  module$contents$jspb$utils_splitDecimalString(value);
  module$contents$jspb$utils_toZigzag64(module$contents$jspb$utils_getSplit64Low(), module$contents$jspb$utils_getSplit64High(), function(lo, hi) {
    self.writeSplitVarint64(lo >>> 0, hi >>> 0);
  });
};
jspb.BinaryEncoder.prototype.writeUint8 = function(value) {
  goog.asserts.assert(value == Math.floor(value));
  goog.asserts.assert(0 <= value && 256 > value);
  this.buffer_.push(value >>> 0 & 255);
};
jspb.BinaryEncoder.prototype.writeUint16 = function(value) {
  goog.asserts.assert(value == Math.floor(value));
  goog.asserts.assert(0 <= value && 65536 > value);
  this.buffer_.push(value >>> 0 & 255);
  this.buffer_.push(value >>> 8 & 255);
};
jspb.BinaryEncoder.prototype.writeUint32 = function(value) {
  goog.asserts.assert(value == Math.floor(value));
  goog.asserts.assert(0 <= value && 4294967296 > value);
  this.buffer_.push(value >>> 0 & 255);
  this.buffer_.push(value >>> 8 & 255);
  this.buffer_.push(value >>> 16 & 255);
  this.buffer_.push(value >>> 24 & 255);
};
jspb.BinaryEncoder.prototype.writeUint64 = function(value) {
  goog.asserts.assert(value == Math.floor(value));
  goog.asserts.assert(0 <= value && 18446744073709551616 > value);
  module$contents$jspb$utils_splitUint64(value);
  this.writeUint32(module$contents$jspb$utils_getSplit64Low());
  this.writeUint32(module$contents$jspb$utils_getSplit64High());
};
jspb.BinaryEncoder.prototype.writeInt8 = function(value) {
  goog.asserts.assert(value == Math.floor(value));
  goog.asserts.assert(-128 <= value && 128 > value);
  this.buffer_.push(value >>> 0 & 255);
};
jspb.BinaryEncoder.prototype.writeInt16 = function(value) {
  goog.asserts.assert(value == Math.floor(value));
  goog.asserts.assert(-32768 <= value && 32768 > value);
  this.buffer_.push(value >>> 0 & 255);
  this.buffer_.push(value >>> 8 & 255);
};
jspb.BinaryEncoder.prototype.writeInt32 = function(value) {
  goog.asserts.assert(value == Math.floor(value));
  goog.asserts.assert(-2147483648 <= value && 2147483648 > value);
  this.buffer_.push(value >>> 0 & 255);
  this.buffer_.push(value >>> 8 & 255);
  this.buffer_.push(value >>> 16 & 255);
  this.buffer_.push(value >>> 24 & 255);
};
jspb.BinaryEncoder.prototype.writeInt64 = function(value) {
  goog.asserts.assert(value == Math.floor(value));
  goog.asserts.assert(-9223372036854775808 <= value && 9223372036854775808 > value);
  module$contents$jspb$utils_splitInt64(value);
  this.writeSplitFixed64(module$contents$jspb$utils_getSplit64Low(), module$contents$jspb$utils_getSplit64High());
};
jspb.BinaryEncoder.prototype.writeInt64String = function(value) {
  goog.asserts.assert(value == Math.floor(value));
  goog.asserts.assert(-9223372036854775808 <= +value && 9223372036854775808 > +value);
  module$contents$jspb$utils_splitDecimalString(value);
  this.writeSplitFixed64(module$contents$jspb$utils_getSplit64Low(), module$contents$jspb$utils_getSplit64High());
};
jspb.BinaryEncoder.prototype.writeFloat = function(value) {
  goog.asserts.assert(Infinity === value || -Infinity === value || isNaN(value) || -3.4028234663852886E38 <= value && 3.4028234663852886e+38 >= value);
  module$contents$jspb$utils_splitFloat32(value);
  this.writeUint32(module$contents$jspb$utils_getSplit64Low());
};
jspb.BinaryEncoder.prototype.writeDouble = function(value) {
  goog.asserts.assert(Infinity === value || -Infinity === value || isNaN(value) || -1.7976931348623157E308 <= value && 1.7976931348623157e+308 >= value);
  module$contents$jspb$utils_splitFloat64(value);
  this.writeUint32(module$contents$jspb$utils_getSplit64Low());
  this.writeUint32(module$contents$jspb$utils_getSplit64High());
};
jspb.BinaryEncoder.prototype.writeBool = function(value) {
  goog.asserts.assert("boolean" === typeof value || "number" === typeof value);
  this.buffer_.push(value ? 1 : 0);
};
jspb.BinaryEncoder.prototype.writeEnum = function(value) {
  goog.asserts.assert(value == Math.floor(value));
  goog.asserts.assert(-2147483648 <= value && 2147483648 > value);
  this.writeSignedVarint32(value);
};
jspb.BinaryEncoder.prototype.writeBytes = function(bytes) {
  this.buffer_.push.apply(this.buffer_, bytes);
};
jspb.BinaryEncoder.prototype.writeString = function(value) {
  for (var oldLength = this.buffer_.length, i = 0; i < value.length; i++) {
    var c = value.charCodeAt(i);
    if (128 > c) {
      this.buffer_.push(c);
    } else {
      if (2048 > c) {
        this.buffer_.push(c >> 6 | 192), this.buffer_.push(c & 63 | 128);
      } else {
        if (65536 > c) {
          if (55296 <= c && 56319 >= c && i + 1 < value.length) {
            var second = value.charCodeAt(i + 1);
            56320 <= second && 57343 >= second && (c = 1024 * (c - 55296) + second - 56320 + 65536, this.buffer_.push(c >> 18 | 240), this.buffer_.push(c >> 12 & 63 | 128), this.buffer_.push(c >> 6 & 63 | 128), this.buffer_.push(c & 63 | 128), i++);
          } else {
            this.buffer_.push(c >> 12 | 224), this.buffer_.push(c >> 6 & 63 | 128), this.buffer_.push(c & 63 | 128);
          }
        }
      }
    }
  }
  return this.buffer_.length - oldLength;
};
goog.userAgent.product = {};
goog.userAgent.product.ASSUME_FIREFOX = !1;
goog.userAgent.product.ASSUME_IPHONE = !1;
goog.userAgent.product.ASSUME_IPAD = !1;
goog.userAgent.product.ASSUME_ANDROID = !1;
goog.userAgent.product.ASSUME_CHROME = !1;
goog.userAgent.product.ASSUME_SAFARI = !1;
goog.userAgent.product.PRODUCT_KNOWN_ = goog.userAgent.ASSUME_IE || goog.userAgent.ASSUME_EDGE || goog.userAgent.ASSUME_OPERA || goog.userAgent.product.ASSUME_FIREFOX || goog.userAgent.product.ASSUME_IPHONE || goog.userAgent.product.ASSUME_IPAD || goog.userAgent.product.ASSUME_ANDROID || goog.userAgent.product.ASSUME_CHROME || goog.userAgent.product.ASSUME_SAFARI;
goog.userAgent.product.OPERA = goog.userAgent.OPERA;
goog.userAgent.product.IE = goog.userAgent.IE;
goog.userAgent.product.EDGE = goog.userAgent.EDGE;
goog.userAgent.product.FIREFOX = goog.userAgent.product.PRODUCT_KNOWN_ ? goog.userAgent.product.ASSUME_FIREFOX : goog.labs.userAgent.browser.isFirefox();
goog.userAgent.product.isIphoneOrIpod_ = function() {
  return goog.labs.userAgent.platform.isIphone() || goog.labs.userAgent.platform.isIpod();
};
goog.userAgent.product.IPHONE = goog.userAgent.product.PRODUCT_KNOWN_ ? goog.userAgent.product.ASSUME_IPHONE : goog.userAgent.product.isIphoneOrIpod_();
goog.userAgent.product.IPAD = goog.userAgent.product.PRODUCT_KNOWN_ ? goog.userAgent.product.ASSUME_IPAD : goog.labs.userAgent.platform.isIpad();
goog.userAgent.product.ANDROID = goog.userAgent.product.PRODUCT_KNOWN_ ? goog.userAgent.product.ASSUME_ANDROID : goog.labs.userAgent.browser.isAndroidBrowser();
goog.userAgent.product.CHROME = goog.userAgent.product.PRODUCT_KNOWN_ ? goog.userAgent.product.ASSUME_CHROME : goog.labs.userAgent.browser.isChrome();
goog.userAgent.product.isSafariDesktop_ = function() {
  return goog.labs.userAgent.browser.isSafari() && !goog.labs.userAgent.platform.isIos();
};
goog.userAgent.product.SAFARI = goog.userAgent.product.PRODUCT_KNOWN_ ? goog.userAgent.product.ASSUME_SAFARI : goog.userAgent.product.isSafariDesktop_();
goog.crypt.base64 = {};
goog.crypt.base64.DEFAULT_ALPHABET_COMMON_ = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
goog.crypt.base64.ENCODED_VALS = goog.crypt.base64.DEFAULT_ALPHABET_COMMON_ + "+/=";
goog.crypt.base64.ENCODED_VALS_WEBSAFE = goog.crypt.base64.DEFAULT_ALPHABET_COMMON_ + "-_.";
goog.crypt.base64.Alphabet = {DEFAULT:0, NO_PADDING:1, WEBSAFE:2, WEBSAFE_DOT_PADDING:3, WEBSAFE_NO_PADDING:4, };
goog.crypt.base64.paddingChars_ = "=.";
goog.crypt.base64.isPadding_ = function(char) {
  return goog.string.contains(goog.crypt.base64.paddingChars_, char);
};
goog.crypt.base64.byteToCharMaps_ = {};
goog.crypt.base64.charToByteMap_ = null;
goog.crypt.base64.ASSUME_NATIVE_SUPPORT_ = goog.userAgent.GECKO || goog.userAgent.WEBKIT && !goog.userAgent.product.SAFARI || goog.userAgent.OPERA;
goog.crypt.base64.HAS_NATIVE_ENCODE_ = goog.crypt.base64.ASSUME_NATIVE_SUPPORT_ || "function" == typeof goog.global.btoa;
goog.crypt.base64.HAS_NATIVE_DECODE_ = goog.crypt.base64.ASSUME_NATIVE_SUPPORT_ || !goog.userAgent.product.SAFARI && !goog.userAgent.IE && "function" == typeof goog.global.atob;
goog.crypt.base64.encodeByteArray = function(input, alphabet) {
  goog.asserts.assert(goog.isArrayLike(input), "encodeByteArray takes an array as a parameter");
  void 0 === alphabet && (alphabet = goog.crypt.base64.Alphabet.DEFAULT);
  goog.crypt.base64.init_();
  for (var byteToCharMap = goog.crypt.base64.byteToCharMaps_[alphabet], output = [], i = 0; i < input.length; i += 3) {
    var byte1 = input[i], haveByte2 = i + 1 < input.length, byte2 = haveByte2 ? input[i + 1] : 0, haveByte3 = i + 2 < input.length, byte3 = haveByte3 ? input[i + 2] : 0, outByte1 = byte1 >> 2, outByte2 = (byte1 & 3) << 4 | byte2 >> 4, outByte3 = (byte2 & 15) << 2 | byte3 >> 6, outByte4 = byte3 & 63;
    haveByte3 || (outByte4 = 64, haveByte2 || (outByte3 = 64));
    output.push(byteToCharMap[outByte1], byteToCharMap[outByte2], byteToCharMap[outByte3] || "", byteToCharMap[outByte4] || "");
  }
  return output.join("");
};
goog.crypt.base64.encodeString = function(input, alphabet) {
  return goog.crypt.base64.HAS_NATIVE_ENCODE_ && !alphabet ? goog.global.btoa(input) : goog.crypt.base64.encodeByteArray(goog.crypt.stringToByteArray(input), alphabet);
};
goog.crypt.base64.decodeString = function(input, useCustomDecoder) {
  if (goog.crypt.base64.HAS_NATIVE_DECODE_ && !useCustomDecoder) {
    return goog.global.atob(input);
  }
  var output = "";
  goog.crypt.base64.decodeStringInternal_(input, function pushByte(b) {
    output += String.fromCharCode(b);
  });
  return output;
};
goog.crypt.base64.decodeStringToByteArray = function(input, opt_ignored) {
  var output = [];
  goog.crypt.base64.decodeStringInternal_(input, function pushByte(b) {
    output.push(b);
  });
  return output;
};
goog.crypt.base64.decodeStringToUint8Array = function(input) {
  goog.asserts.assert(!goog.userAgent.IE || goog.userAgent.isVersionOrHigher("10"), "Browser does not support typed arrays");
  var len = input.length, approxByteLength = 3 * len / 4;
  approxByteLength % 3 ? approxByteLength = Math.floor(approxByteLength) : goog.crypt.base64.isPadding_(input[len - 1]) && (approxByteLength = goog.crypt.base64.isPadding_(input[len - 2]) ? approxByteLength - 2 : approxByteLength - 1);
  var output = new Uint8Array(approxByteLength), outLen = 0;
  goog.crypt.base64.decodeStringInternal_(input, function pushByte(b) {
    output[outLen++] = b;
  });
  return output.subarray(0, outLen);
};
goog.crypt.base64.decodeStringInternal_ = function(input, pushByte) {
  function getByte(default_val) {
    for (; nextCharIndex < input.length;) {
      var ch = input.charAt(nextCharIndex++), b = goog.crypt.base64.charToByteMap_[ch];
      if (null != b) {
        return b;
      }
      if (!goog.string.isEmptyOrWhitespace(ch)) {
        throw Error("Unknown base64 encoding at char: " + ch);
      }
    }
    return default_val;
  }
  goog.crypt.base64.init_();
  for (var nextCharIndex = 0;;) {
    var byte1 = getByte(-1), byte2 = getByte(0), byte3 = getByte(64), byte4 = getByte(64);
    if (64 === byte4 && -1 === byte1) {
      break;
    }
    pushByte(byte1 << 2 | byte2 >> 4);
    64 != byte3 && (pushByte(byte2 << 4 & 240 | byte3 >> 2), 64 != byte4 && pushByte(byte3 << 6 & 192 | byte4));
  }
};
goog.crypt.base64.init_ = function() {
  if (!goog.crypt.base64.charToByteMap_) {
    goog.crypt.base64.charToByteMap_ = {};
    for (var commonChars = goog.crypt.base64.DEFAULT_ALPHABET_COMMON_.split(""), specialChars = ["+/=", "+/", "-_=", "-_.", "-_", ], i = 0; 5 > i; i++) {
      var chars = commonChars.concat(specialChars[i].split(""));
      goog.crypt.base64.byteToCharMaps_[i] = chars;
      for (var j = 0; j < chars.length; j++) {
        var char = chars[j], existingByte = goog.crypt.base64.charToByteMap_[char];
        void 0 === existingByte ? goog.crypt.base64.charToByteMap_[char] = j : goog.asserts.assert(existingByte === j);
      }
    }
  }
};
jspb.BinaryWriter = function() {
  this.blocks_ = [];
  this.totalLength_ = 0;
  this.encoder_ = new jspb.BinaryEncoder;
  this.bookmarks_ = [];
};
jspb.BinaryWriter.prototype.appendUint8Array_ = function(arr) {
  var temp = this.encoder_.end();
  this.blocks_.push(temp);
  this.blocks_.push(arr);
  this.totalLength_ += temp.length + arr.length;
};
jspb.BinaryWriter.prototype.beginDelimited_ = function(field) {
  this.writeFieldHeader_(field, module$contents$jspb$BinaryConstants_WireType.DELIMITED);
  var bookmark = this.encoder_.end();
  this.blocks_.push(bookmark);
  this.totalLength_ += bookmark.length;
  bookmark.push(this.totalLength_);
  return bookmark;
};
jspb.BinaryWriter.prototype.endDelimited_ = function(bookmark) {
  var oldLength = bookmark.pop(), messageLength = this.totalLength_ + this.encoder_.length() - oldLength;
  for (goog.asserts.assert(0 <= messageLength); 127 < messageLength;) {
    bookmark.push(messageLength & 127 | 128), messageLength >>>= 7, this.totalLength_++;
  }
  bookmark.push(messageLength);
  this.totalLength_++;
};
jspb.BinaryWriter.prototype.writeSerializedMessage = function(bytes, start, end) {
  this.appendUint8Array_(bytes.subarray(start, end));
};
jspb.BinaryWriter.prototype.maybeWriteSerializedMessage = function(bytes, start, end) {
  null != bytes && null != start && null != end && this.writeSerializedMessage(bytes, start, end);
};
jspb.BinaryWriter.prototype.reset = function() {
  this.blocks_ = [];
  this.encoder_.end();
  this.totalLength_ = 0;
  this.bookmarks_ = [];
};
jspb.BinaryWriter.prototype.getResultBuffer = function() {
  goog.asserts.assert(0 == this.bookmarks_.length);
  for (var flat = new Uint8Array(this.totalLength_ + this.encoder_.length()), blocks = this.blocks_, blockCount = blocks.length, offset = 0, i = 0; i < blockCount; i++) {
    var block = blocks[i];
    flat.set(block, offset);
    offset += block.length;
  }
  var tail = this.encoder_.end();
  flat.set(tail, offset);
  offset += tail.length;
  goog.asserts.assert(offset == flat.length);
  this.blocks_ = [flat];
  return flat;
};
jspb.BinaryWriter.prototype.getResultBase64String = function(alphabet) {
  return goog.crypt.base64.encodeByteArray(this.getResultBuffer(), alphabet);
};
jspb.BinaryWriter.prototype.beginSubMessage = function(field) {
  this.bookmarks_.push(this.beginDelimited_(field));
};
jspb.BinaryWriter.prototype.endSubMessage = function() {
  goog.asserts.assert(0 <= this.bookmarks_.length);
  this.endDelimited_(this.bookmarks_.pop());
};
jspb.BinaryWriter.prototype.writeFieldHeader_ = function(field, wireType) {
  goog.asserts.assert(1 <= field && field == Math.floor(field));
  this.encoder_.writeUnsignedVarint32(8 * field + wireType);
};
jspb.BinaryWriter.prototype.writeAny = function(fieldType, field, value) {
  switch(fieldType) {
    case module$contents$jspb$BinaryConstants_FieldType.DOUBLE:
      this.writeDouble(field, value);
      break;
    case module$contents$jspb$BinaryConstants_FieldType.FLOAT:
      this.writeFloat(field, value);
      break;
    case module$contents$jspb$BinaryConstants_FieldType.INT64:
      this.writeInt64(field, value);
      break;
    case module$contents$jspb$BinaryConstants_FieldType.UINT64:
      this.writeUint64(field, value);
      break;
    case module$contents$jspb$BinaryConstants_FieldType.INT32:
      this.writeInt32(field, value);
      break;
    case module$contents$jspb$BinaryConstants_FieldType.FIXED64:
      this.writeFixed64(field, value);
      break;
    case module$contents$jspb$BinaryConstants_FieldType.FIXED32:
      this.writeFixed32(field, value);
      break;
    case module$contents$jspb$BinaryConstants_FieldType.BOOL:
      this.writeBool(field, value);
      break;
    case module$contents$jspb$BinaryConstants_FieldType.STRING:
      this.writeString(field, value);
      break;
    case module$contents$jspb$BinaryConstants_FieldType.GROUP:
      goog.asserts.fail("Group field type not supported in writeAny()");
      break;
    case module$contents$jspb$BinaryConstants_FieldType.MESSAGE:
      goog.asserts.fail("Message field type not supported in writeAny()");
      break;
    case module$contents$jspb$BinaryConstants_FieldType.BYTES:
      this.writeBytes(field, value);
      break;
    case module$contents$jspb$BinaryConstants_FieldType.UINT32:
      this.writeUint32(field, value);
      break;
    case module$contents$jspb$BinaryConstants_FieldType.ENUM:
      this.writeEnum(field, value);
      break;
    case module$contents$jspb$BinaryConstants_FieldType.SFIXED32:
      this.writeSfixed32(field, value);
      break;
    case module$contents$jspb$BinaryConstants_FieldType.SFIXED64:
      this.writeSfixed64(field, value);
      break;
    case module$contents$jspb$BinaryConstants_FieldType.SINT32:
      this.writeSint32(field, value);
      break;
    case module$contents$jspb$BinaryConstants_FieldType.SINT64:
      this.writeSint64(field, value);
      break;
    default:
      goog.asserts.fail("Invalid field type in writeAny()");
  }
};
jspb.BinaryWriter.prototype.writeUnsignedVarint32_ = function(field, value) {
  null != value && (this.writeFieldHeader_(field, module$contents$jspb$BinaryConstants_WireType.VARINT), this.encoder_.writeUnsignedVarint32(value));
};
jspb.BinaryWriter.prototype.writeSignedVarint32_ = function(field, value) {
  null != value && (this.writeFieldHeader_(field, module$contents$jspb$BinaryConstants_WireType.VARINT), this.encoder_.writeSignedVarint32(value));
};
jspb.BinaryWriter.prototype.writeUnsignedVarint64_ = function(field, value) {
  null != value && (this.writeFieldHeader_(field, module$contents$jspb$BinaryConstants_WireType.VARINT), this.encoder_.writeUnsignedVarint64(value));
};
jspb.BinaryWriter.prototype.writeSignedVarint64_ = function(field, value) {
  null != value && (this.writeFieldHeader_(field, module$contents$jspb$BinaryConstants_WireType.VARINT), this.encoder_.writeSignedVarint64(value));
};
jspb.BinaryWriter.prototype.writeZigzagVarint32_ = function(field, value) {
  null != value && (this.writeFieldHeader_(field, module$contents$jspb$BinaryConstants_WireType.VARINT), this.encoder_.writeZigzagVarint32(value));
};
jspb.BinaryWriter.prototype.writeZigzagVarint64_ = function(field, value) {
  null != value && (this.writeFieldHeader_(field, module$contents$jspb$BinaryConstants_WireType.VARINT), this.encoder_.writeZigzagVarint64(value));
};
jspb.BinaryWriter.prototype.writeZigzagVarint64String_ = function(field, value) {
  null != value && (this.writeFieldHeader_(field, module$contents$jspb$BinaryConstants_WireType.VARINT), this.encoder_.writeZigzagVarint64String(value));
};
jspb.BinaryWriter.prototype.writeInt32 = function(field, value) {
  null != value && (goog.asserts.assert(-2147483648 <= value && 2147483648 > value), this.writeSignedVarint32_(field, value));
};
jspb.BinaryWriter.prototype.writeInt32String = function(field, value) {
  if (null != value) {
    var intValue = parseInt(value, 10);
    goog.asserts.assert(-2147483648 <= intValue && 2147483648 > intValue);
    this.writeSignedVarint32_(field, intValue);
  }
};
jspb.BinaryWriter.prototype.writeInt64 = function(field, value) {
  null != value && (goog.asserts.assert(-9223372036854775808 <= value && 9223372036854775808 > value), this.writeSignedVarint64_(field, value));
};
jspb.BinaryWriter.prototype.writeInt64String = function(field, value) {
  if (null != value) {
    var num = jspb.arith.Int64.fromString(value);
    this.writeFieldHeader_(field, module$contents$jspb$BinaryConstants_WireType.VARINT);
    this.encoder_.writeSplitVarint64(num.lo, num.hi);
  }
};
jspb.BinaryWriter.prototype.writeUint32 = function(field, value) {
  null != value && (goog.asserts.assert(0 <= value && 4294967296 > value), this.writeUnsignedVarint32_(field, value));
};
jspb.BinaryWriter.prototype.writeUint32String = function(field, value) {
  if (null != value) {
    var intValue = parseInt(value, 10);
    goog.asserts.assert(0 <= intValue && 4294967296 > intValue);
    this.writeUnsignedVarint32_(field, intValue);
  }
};
jspb.BinaryWriter.prototype.writeUint64 = function(field, value) {
  null != value && (goog.asserts.assert(0 <= value && 18446744073709551616 > value), this.writeUnsignedVarint64_(field, value));
};
jspb.BinaryWriter.prototype.writeUint64String = function(field, value) {
  if (null != value) {
    var num = jspb.arith.UInt64.fromString(value);
    this.writeFieldHeader_(field, module$contents$jspb$BinaryConstants_WireType.VARINT);
    this.encoder_.writeSplitVarint64(num.lo, num.hi);
  }
};
jspb.BinaryWriter.prototype.writeSint32 = function(field, value) {
  null != value && (goog.asserts.assert(-2147483648 <= value && 2147483648 > value), this.writeZigzagVarint32_(field, value));
};
jspb.BinaryWriter.prototype.writeSint64 = function(field, value) {
  null != value && (goog.asserts.assert(-9223372036854775808 <= value && 9223372036854775808 > value), this.writeZigzagVarint64_(field, value));
};
jspb.BinaryWriter.prototype.writeSint64String = function(field, value) {
  null != value && this.writeZigzagVarint64String_(field, value);
};
jspb.BinaryWriter.prototype.writeFixed32 = function(field, value) {
  null != value && (goog.asserts.assert(0 <= value && 4294967296 > value), this.writeFieldHeader_(field, module$contents$jspb$BinaryConstants_WireType.FIXED32), this.encoder_.writeUint32(value));
};
jspb.BinaryWriter.prototype.writeFixed64 = function(field, value) {
  null != value && (goog.asserts.assert(0 <= value && 18446744073709551616 > value), this.writeFieldHeader_(field, module$contents$jspb$BinaryConstants_WireType.FIXED64), this.encoder_.writeUint64(value));
};
jspb.BinaryWriter.prototype.writeFixed64String = function(field, value) {
  if (null != value) {
    var num = jspb.arith.UInt64.fromString(value);
    this.writeFieldHeader_(field, module$contents$jspb$BinaryConstants_WireType.FIXED64);
    this.encoder_.writeSplitFixed64(num.lo, num.hi);
  }
};
jspb.BinaryWriter.prototype.writeSfixed32 = function(field, value) {
  null != value && (goog.asserts.assert(-2147483648 <= value && 2147483648 > value), this.writeFieldHeader_(field, module$contents$jspb$BinaryConstants_WireType.FIXED32), this.encoder_.writeInt32(value));
};
jspb.BinaryWriter.prototype.writeSfixed64 = function(field, value) {
  null != value && (goog.asserts.assert(-9223372036854775808 <= value && 9223372036854775808 > value), this.writeFieldHeader_(field, module$contents$jspb$BinaryConstants_WireType.FIXED64), this.encoder_.writeInt64(value));
};
jspb.BinaryWriter.prototype.writeSfixed64String = function(field, value) {
  if (null != value) {
    var num = jspb.arith.Int64.fromString(value);
    this.writeFieldHeader_(field, module$contents$jspb$BinaryConstants_WireType.FIXED64);
    this.encoder_.writeSplitFixed64(num.lo, num.hi);
  }
};
jspb.BinaryWriter.prototype.writeFloat = function(field, value) {
  null != value && (this.writeFieldHeader_(field, module$contents$jspb$BinaryConstants_WireType.FIXED32), this.encoder_.writeFloat(value));
};
jspb.BinaryWriter.prototype.writeDouble = function(field, value) {
  null != value && (this.writeFieldHeader_(field, module$contents$jspb$BinaryConstants_WireType.FIXED64), this.encoder_.writeDouble(value));
};
jspb.BinaryWriter.prototype.writeBool = function(field, value) {
  null != value && (goog.asserts.assert("boolean" === typeof value || "number" === typeof value), this.writeFieldHeader_(field, module$contents$jspb$BinaryConstants_WireType.VARINT), this.encoder_.writeBool(value));
};
jspb.BinaryWriter.prototype.writeEnum = function(field, value) {
  null != value && (goog.asserts.assert(-2147483648 <= value && 2147483648 > value), this.writeFieldHeader_(field, module$contents$jspb$BinaryConstants_WireType.VARINT), this.encoder_.writeSignedVarint32(value));
};
jspb.BinaryWriter.prototype.writeString = function(field, value) {
  if (null != value) {
    var bookmark = this.beginDelimited_(field);
    this.encoder_.writeString(value);
    this.endDelimited_(bookmark);
  }
};
jspb.BinaryWriter.prototype.writeBytes = function(field, value) {
  if (null != value) {
    var bytes = module$contents$jspb$utils_byteSourceToUint8Array(value);
    this.writeFieldHeader_(field, module$contents$jspb$BinaryConstants_WireType.DELIMITED);
    this.encoder_.writeUnsignedVarint32(bytes.length);
    this.appendUint8Array_(bytes);
  }
};
jspb.BinaryWriter.prototype.writeMessage = function(field, value, writerCallback) {
  if (null != value) {
    var bookmark = this.beginDelimited_(field);
    writerCallback(value, this);
    this.endDelimited_(bookmark);
  }
};
jspb.BinaryWriter.prototype.writeMessageSet = function(field, value, writerCallback) {
  if (null != value) {
    this.writeFieldHeader_(1, module$contents$jspb$BinaryConstants_WireType.START_GROUP);
    this.writeFieldHeader_(2, module$contents$jspb$BinaryConstants_WireType.VARINT);
    this.encoder_.writeSignedVarint32(field);
    var bookmark = this.beginDelimited_(3);
    writerCallback(value, this);
    this.endDelimited_(bookmark);
    this.writeFieldHeader_(1, module$contents$jspb$BinaryConstants_WireType.END_GROUP);
  }
};
jspb.BinaryWriter.prototype.writeGroup = function(field, value, writerCallback) {
  null != value && (this.writeFieldHeader_(field, module$contents$jspb$BinaryConstants_WireType.START_GROUP), writerCallback(value, this), this.writeFieldHeader_(field, module$contents$jspb$BinaryConstants_WireType.END_GROUP));
};
jspb.BinaryWriter.prototype.writeSplitFixed64 = function(field, lowBits, highBits) {
  this.writeFieldHeader_(field, module$contents$jspb$BinaryConstants_WireType.FIXED64);
  this.encoder_.writeSplitFixed64(lowBits, highBits);
};
jspb.BinaryWriter.prototype.writeSplitVarint64 = function(field, lowBits, highBits) {
  this.writeFieldHeader_(field, module$contents$jspb$BinaryConstants_WireType.VARINT);
  this.encoder_.writeSplitVarint64(lowBits, highBits);
};
jspb.BinaryWriter.prototype.writeSplitZigzagVarint64 = function(field, lowBits, highBits) {
  this.writeFieldHeader_(field, module$contents$jspb$BinaryConstants_WireType.VARINT);
  this.encoder_.writeSplitZigzagVarint64(lowBits >>> 0, highBits >>> 0);
};
jspb.BinaryWriter.prototype.writeRepeatedInt32 = function(field, value) {
  if (null != value) {
    for (var i = 0; i < value.length; i++) {
      this.writeSignedVarint32_(field, value[i]);
    }
  }
};
jspb.BinaryWriter.prototype.writeRepeatedInt32String = function(field, value) {
  if (null != value) {
    for (var i = 0; i < value.length; i++) {
      this.writeInt32String(field, value[i]);
    }
  }
};
jspb.BinaryWriter.prototype.writeRepeatedInt64 = function(field, value) {
  if (null != value) {
    for (var i = 0; i < value.length; i++) {
      this.writeSignedVarint64_(field, value[i]);
    }
  }
};
jspb.BinaryWriter.prototype.writeRepeatedSplitFixed64 = function(field, value, lo, hi) {
  if (null != value) {
    for (var i = 0; i < value.length; i++) {
      this.writeSplitFixed64(field, lo(value[i]), hi(value[i]));
    }
  }
};
jspb.BinaryWriter.prototype.writeRepeatedSplitVarint64 = function(field, value, lo, hi) {
  if (null != value) {
    for (var i = 0; i < value.length; i++) {
      this.writeSplitVarint64(field, lo(value[i]), hi(value[i]));
    }
  }
};
jspb.BinaryWriter.prototype.writeRepeatedSplitZigzagVarint64 = function(field, value, lo, hi) {
  if (null != value) {
    for (var i = 0; i < value.length; i++) {
      this.writeSplitZigzagVarint64(field, lo(value[i]), hi(value[i]));
    }
  }
};
jspb.BinaryWriter.prototype.writeRepeatedInt64String = function(field, value) {
  if (null != value) {
    for (var i = 0; i < value.length; i++) {
      this.writeInt64String(field, value[i]);
    }
  }
};
jspb.BinaryWriter.prototype.writeRepeatedUint32 = function(field, value) {
  if (null != value) {
    for (var i = 0; i < value.length; i++) {
      this.writeUnsignedVarint32_(field, value[i]);
    }
  }
};
jspb.BinaryWriter.prototype.writeRepeatedUint32String = function(field, value) {
  if (null != value) {
    for (var i = 0; i < value.length; i++) {
      this.writeUint32String(field, value[i]);
    }
  }
};
jspb.BinaryWriter.prototype.writeRepeatedUint64 = function(field, value) {
  if (null != value) {
    for (var i = 0; i < value.length; i++) {
      this.writeUnsignedVarint64_(field, value[i]);
    }
  }
};
jspb.BinaryWriter.prototype.writeRepeatedUint64String = function(field, value) {
  if (null != value) {
    for (var i = 0; i < value.length; i++) {
      this.writeUint64String(field, value[i]);
    }
  }
};
jspb.BinaryWriter.prototype.writeRepeatedSint32 = function(field, value) {
  if (null != value) {
    for (var i = 0; i < value.length; i++) {
      this.writeZigzagVarint32_(field, value[i]);
    }
  }
};
jspb.BinaryWriter.prototype.writeRepeatedSint64 = function(field, value) {
  if (null != value) {
    for (var i = 0; i < value.length; i++) {
      this.writeZigzagVarint64_(field, value[i]);
    }
  }
};
jspb.BinaryWriter.prototype.writeRepeatedSint64String = function(field, value) {
  if (null != value) {
    for (var i = 0; i < value.length; i++) {
      this.writeZigzagVarint64String_(field, value[i]);
    }
  }
};
jspb.BinaryWriter.prototype.writeRepeatedFixed32 = function(field, value) {
  if (null != value) {
    for (var i = 0; i < value.length; i++) {
      this.writeFixed32(field, value[i]);
    }
  }
};
jspb.BinaryWriter.prototype.writeRepeatedFixed64 = function(field, value) {
  if (null != value) {
    for (var i = 0; i < value.length; i++) {
      this.writeFixed64(field, value[i]);
    }
  }
};
jspb.BinaryWriter.prototype.writeRepeatedFixed64String = function(field, value) {
  if (null != value) {
    for (var i = 0; i < value.length; i++) {
      this.writeFixed64String(field, value[i]);
    }
  }
};
jspb.BinaryWriter.prototype.writeRepeatedSfixed32 = function(field, value) {
  if (null != value) {
    for (var i = 0; i < value.length; i++) {
      this.writeSfixed32(field, value[i]);
    }
  }
};
jspb.BinaryWriter.prototype.writeRepeatedSfixed64 = function(field, value) {
  if (null != value) {
    for (var i = 0; i < value.length; i++) {
      this.writeSfixed64(field, value[i]);
    }
  }
};
jspb.BinaryWriter.prototype.writeRepeatedSfixed64String = function(field, value) {
  if (null != value) {
    for (var i = 0; i < value.length; i++) {
      this.writeSfixed64String(field, value[i]);
    }
  }
};
jspb.BinaryWriter.prototype.writeRepeatedFloat = function(field, value) {
  if (null != value) {
    for (var i = 0; i < value.length; i++) {
      this.writeFloat(field, value[i]);
    }
  }
};
jspb.BinaryWriter.prototype.writeRepeatedDouble = function(field, value) {
  if (null != value) {
    for (var i = 0; i < value.length; i++) {
      this.writeDouble(field, value[i]);
    }
  }
};
jspb.BinaryWriter.prototype.writeRepeatedBool = function(field, value) {
  if (null != value) {
    for (var i = 0; i < value.length; i++) {
      this.writeBool(field, value[i]);
    }
  }
};
jspb.BinaryWriter.prototype.writeRepeatedEnum = function(field, value) {
  if (null != value) {
    for (var i = 0; i < value.length; i++) {
      this.writeEnum(field, value[i]);
    }
  }
};
jspb.BinaryWriter.prototype.writeRepeatedString = function(field, value) {
  if (null != value) {
    for (var i = 0; i < value.length; i++) {
      this.writeString(field, value[i]);
    }
  }
};
jspb.BinaryWriter.prototype.writeRepeatedBytes = function(field, value) {
  if (null != value) {
    for (var i = 0; i < value.length; i++) {
      this.writeBytes(field, value[i]);
    }
  }
};
jspb.BinaryWriter.prototype.writeRepeatedMessage = function(field, value, writerCallback) {
  if (null != value) {
    for (var i = 0; i < value.length; i++) {
      var bookmark = this.beginDelimited_(field);
      writerCallback(value[i], this);
      this.endDelimited_(bookmark);
    }
  }
};
jspb.BinaryWriter.prototype.writeRepeatedGroup = function(field, value, writerCallback) {
  if (null != value) {
    for (var i = 0; i < value.length; i++) {
      this.writeFieldHeader_(field, module$contents$jspb$BinaryConstants_WireType.START_GROUP), writerCallback(value[i], this), this.writeFieldHeader_(field, module$contents$jspb$BinaryConstants_WireType.END_GROUP);
    }
  }
};
jspb.BinaryWriter.prototype.writePackedInt32 = function(field, value) {
  if (null != value && value.length) {
    for (var bookmark = this.beginDelimited_(field), i = 0; i < value.length; i++) {
      this.encoder_.writeSignedVarint32(value[i]);
    }
    this.endDelimited_(bookmark);
  }
};
jspb.BinaryWriter.prototype.writePackedInt32String = function(field, value) {
  if (null != value && value.length) {
    for (var bookmark = this.beginDelimited_(field), i = 0; i < value.length; i++) {
      this.encoder_.writeSignedVarint32(parseInt(value[i], 10));
    }
    this.endDelimited_(bookmark);
  }
};
jspb.BinaryWriter.prototype.writePackedInt64 = function(field, value) {
  if (null != value && value.length) {
    for (var bookmark = this.beginDelimited_(field), i = 0; i < value.length; i++) {
      this.encoder_.writeSignedVarint64(value[i]);
    }
    this.endDelimited_(bookmark);
  }
};
jspb.BinaryWriter.prototype.writePackedSplitFixed64 = function(field, value, lo, hi) {
  if (null != value) {
    for (var bookmark = this.beginDelimited_(field), i = 0; i < value.length; i++) {
      this.encoder_.writeSplitFixed64(lo(value[i]), hi(value[i]));
    }
    this.endDelimited_(bookmark);
  }
};
jspb.BinaryWriter.prototype.writePackedSplitVarint64 = function(field, value, lo, hi) {
  if (null != value) {
    for (var bookmark = this.beginDelimited_(field), i = 0; i < value.length; i++) {
      this.encoder_.writeSplitVarint64(lo(value[i]), hi(value[i]));
    }
    this.endDelimited_(bookmark);
  }
};
jspb.BinaryWriter.prototype.writePackedSplitZigzagVarint64 = function(field, value, lo, hi) {
  if (null != value) {
    for (var bookmark = this.beginDelimited_(field), encoder = this.encoder_, i = 0; i < value.length; i++) {
      encoder.writeSplitZigzagVarint64(lo(value[i]), hi(value[i]));
    }
    this.endDelimited_(bookmark);
  }
};
jspb.BinaryWriter.prototype.writePackedInt64String = function(field, value) {
  if (null != value && value.length) {
    for (var bookmark = this.beginDelimited_(field), i = 0; i < value.length; i++) {
      var num = jspb.arith.Int64.fromString(value[i]);
      this.encoder_.writeSplitVarint64(num.lo, num.hi);
    }
    this.endDelimited_(bookmark);
  }
};
jspb.BinaryWriter.prototype.writePackedUint32 = function(field, value) {
  if (null != value && value.length) {
    for (var bookmark = this.beginDelimited_(field), i = 0; i < value.length; i++) {
      this.encoder_.writeUnsignedVarint32(value[i]);
    }
    this.endDelimited_(bookmark);
  }
};
jspb.BinaryWriter.prototype.writePackedUint32String = function(field, value) {
  if (null != value && value.length) {
    for (var bookmark = this.beginDelimited_(field), i = 0; i < value.length; i++) {
      this.encoder_.writeUnsignedVarint32(parseInt(value[i], 10));
    }
    this.endDelimited_(bookmark);
  }
};
jspb.BinaryWriter.prototype.writePackedUint64 = function(field, value) {
  if (null != value && value.length) {
    for (var bookmark = this.beginDelimited_(field), i = 0; i < value.length; i++) {
      this.encoder_.writeUnsignedVarint64(value[i]);
    }
    this.endDelimited_(bookmark);
  }
};
jspb.BinaryWriter.prototype.writePackedUint64String = function(field, value) {
  if (null != value && value.length) {
    for (var bookmark = this.beginDelimited_(field), i = 0; i < value.length; i++) {
      var num = jspb.arith.UInt64.fromString(value[i]);
      this.encoder_.writeSplitVarint64(num.lo, num.hi);
    }
    this.endDelimited_(bookmark);
  }
};
jspb.BinaryWriter.prototype.writePackedSint32 = function(field, value) {
  if (null != value && value.length) {
    for (var bookmark = this.beginDelimited_(field), i = 0; i < value.length; i++) {
      this.encoder_.writeZigzagVarint32(value[i]);
    }
    this.endDelimited_(bookmark);
  }
};
jspb.BinaryWriter.prototype.writePackedSint64 = function(field, value) {
  if (null != value && value.length) {
    for (var bookmark = this.beginDelimited_(field), i = 0; i < value.length; i++) {
      this.encoder_.writeZigzagVarint64(value[i]);
    }
    this.endDelimited_(bookmark);
  }
};
jspb.BinaryWriter.prototype.writePackedSint64String = function(field, value) {
  if (null != value && value.length) {
    for (var bookmark = this.beginDelimited_(field), i = 0; i < value.length; i++) {
      this.encoder_.writeZigzagVarint64String(value[i]);
    }
    this.endDelimited_(bookmark);
  }
};
jspb.BinaryWriter.prototype.writePackedFixed32 = function(field, value) {
  if (null != value && value.length) {
    this.writeFieldHeader_(field, module$contents$jspb$BinaryConstants_WireType.DELIMITED);
    this.encoder_.writeUnsignedVarint32(4 * value.length);
    for (var i = 0; i < value.length; i++) {
      this.encoder_.writeUint32(value[i]);
    }
  }
};
jspb.BinaryWriter.prototype.writePackedFixed64 = function(field, value) {
  if (null != value && value.length) {
    this.writeFieldHeader_(field, module$contents$jspb$BinaryConstants_WireType.DELIMITED);
    this.encoder_.writeUnsignedVarint32(8 * value.length);
    for (var i = 0; i < value.length; i++) {
      this.encoder_.writeUint64(value[i]);
    }
  }
};
jspb.BinaryWriter.prototype.writePackedFixed64String = function(field, value) {
  if (null != value && value.length) {
    this.writeFieldHeader_(field, module$contents$jspb$BinaryConstants_WireType.DELIMITED);
    this.encoder_.writeUnsignedVarint32(8 * value.length);
    for (var i = 0; i < value.length; i++) {
      var num = jspb.arith.UInt64.fromString(value[i]);
      this.encoder_.writeSplitFixed64(num.lo, num.hi);
    }
  }
};
jspb.BinaryWriter.prototype.writePackedSfixed32 = function(field, value) {
  if (null != value && value.length) {
    this.writeFieldHeader_(field, module$contents$jspb$BinaryConstants_WireType.DELIMITED);
    this.encoder_.writeUnsignedVarint32(4 * value.length);
    for (var i = 0; i < value.length; i++) {
      this.encoder_.writeInt32(value[i]);
    }
  }
};
jspb.BinaryWriter.prototype.writePackedSfixed64 = function(field, value) {
  if (null != value && value.length) {
    this.writeFieldHeader_(field, module$contents$jspb$BinaryConstants_WireType.DELIMITED);
    this.encoder_.writeUnsignedVarint32(8 * value.length);
    for (var i = 0; i < value.length; i++) {
      this.encoder_.writeInt64(value[i]);
    }
  }
};
jspb.BinaryWriter.prototype.writePackedSfixed64String = function(field, value) {
  if (null != value && value.length) {
    this.writeFieldHeader_(field, module$contents$jspb$BinaryConstants_WireType.DELIMITED);
    this.encoder_.writeUnsignedVarint32(8 * value.length);
    for (var i = 0; i < value.length; i++) {
      this.encoder_.writeInt64String(value[i]);
    }
  }
};
jspb.BinaryWriter.prototype.writePackedFloat = function(field, value) {
  if (null != value && value.length) {
    this.writeFieldHeader_(field, module$contents$jspb$BinaryConstants_WireType.DELIMITED);
    this.encoder_.writeUnsignedVarint32(4 * value.length);
    for (var i = 0; i < value.length; i++) {
      this.encoder_.writeFloat(value[i]);
    }
  }
};
jspb.BinaryWriter.prototype.writePackedDouble = function(field, value) {
  if (null != value && value.length) {
    this.writeFieldHeader_(field, module$contents$jspb$BinaryConstants_WireType.DELIMITED);
    this.encoder_.writeUnsignedVarint32(8 * value.length);
    for (var i = 0; i < value.length; i++) {
      this.encoder_.writeDouble(value[i]);
    }
  }
};
jspb.BinaryWriter.prototype.writePackedBool = function(field, value) {
  if (null != value && value.length) {
    this.writeFieldHeader_(field, module$contents$jspb$BinaryConstants_WireType.DELIMITED);
    this.encoder_.writeUnsignedVarint32(value.length);
    for (var i = 0; i < value.length; i++) {
      this.encoder_.writeBool(value[i]);
    }
  }
};
jspb.BinaryWriter.prototype.writePackedEnum = function(field, value) {
  if (null != value && value.length) {
    for (var bookmark = this.beginDelimited_(field), i = 0; i < value.length; i++) {
      this.encoder_.writeEnum(value[i]);
    }
    this.endDelimited_(bookmark);
  }
};
var module$contents$jspb$Map_Map = function(arr, valueCtor) {
  this.arr_ = arr;
  this.valueCtor_ = valueCtor;
  this.map_ = {};
  this.arrClean = !0;
  0 < this.arr_.length && this.loadFromArray_();
};
module$contents$jspb$Map_Map.prototype.loadFromArray_ = function() {
  for (var i = 0; i < this.arr_.length; i++) {
    var record = this.arr_[i], key = record[0];
    this.map_[key.toString()] = new module$contents$jspb$Map_Entry_(key, record[1]);
  }
  this.arrClean = !0;
};
module$contents$jspb$Map_Map.prototype.toArray = function() {
  if (this.arrClean) {
    if (this.valueCtor_) {
      var m = this.map_, p;
      for (p in m) {
        if (Object.prototype.hasOwnProperty.call(m, p)) {
          var valueWrapper = m[p].valueWrapper;
          valueWrapper && valueWrapper.toArray();
        }
      }
    }
  } else {
    this.arr_.length = 0;
    var strKeys = this.stringKeys_();
    strKeys.sort();
    for (var i = 0; i < strKeys.length; i++) {
      var entry = this.map_[strKeys[i]];
      (valueWrapper = entry.valueWrapper) && valueWrapper.toArray();
      this.arr_.push([entry.key, entry.value]);
    }
    this.arrClean = !0;
  }
  return this.arr_;
};
module$contents$jspb$Map_Map.prototype.toObject = function(includeInstance, valueToObject) {
  for (var rawArray = this.toArray(), entries = [], i = 0; i < rawArray.length; i++) {
    var entry = this.map_[rawArray[i][0].toString()];
    this.wrapEntry_(entry);
    var valueWrapper = entry.valueWrapper;
    valueWrapper ? (goog.asserts.assert(valueToObject), entries.push([entry.key, valueToObject(includeInstance, valueWrapper)])) : entries.push([e