from collections.abc import ByteString
from enum import IntEnum
from typing import Any
from uuid import UUID

class HeaderType(IntEnum):
    BOOL_TRUE: int
    BOOL_FALSE: int
    BYTE: int
    INT16: int
    INT32: int
    INT64: int
    BYTE_BUF: int
    STRING: int
    TIMESTAMP: int
    UUID: int
    def __format__(self, format_spec: str) -> str: ...

class Header:
    def __init__(self, name: str, value: Any, header_type: HeaderType) -> None: ...
    @classmethod
    def from_bool(cls, name: str, value: bool) -> Header: ...
    @classmethod
    def from_byte(cls, name: str, value: int) -> Header: ...
    @classmethod
    def from_int16(cls, name: str, value: int) -> Header: ...
    @classmethod
    def from_int32(cls, name: str, value: int) -> Header: ...
    @classmethod
    def from_int64(cls, name: str, value: int) -> Header: ...
    @classmethod
    def from_byte_buf(cls, name: str, value: ByteString) -> Header: ...
    @classmethod
    def from_string(cls, name: str, value: str) -> Header: ...
    @classmethod
    def from_timestamp(cls, name: str, value: int) -> Header: ...
    @classmethod
    def from_uuid(cls, name: str, value: UUID) -> Header: ...
    @property
    def name(self) -> str: ...
    @property
    def type(self) -> HeaderType: ...
    @property
    def value(self) -> Any: ...
    def value_as_bool(self) -> bool: ...
    def value_as_byte(self) -> int: ...
    def value_as_int16(self) -> int: ...
    def value_as_int32(self) -> int: ...
    def value_as_int64(self) -> int: ...
    def value_as_byte_buf(self) -> ByteString: ...
    def value_as_string(self) -> str: ...
    def value_as_timestamp(self) -> int: ...
    def value_as_uuid(self) -> UUID: ...
