"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegTesting = void 0;
const aws_cdk_lib_1 = require("aws-cdk-lib");
const index_1 = require("./index");
class IntegTesting {
    constructor() {
        const app = new aws_cdk_lib_1.App();
        const env = {
            region: process.env.CDK_DEFAULT_REGION,
            account: process.env.CDK_DEFAULT_ACCOUNT,
        };
        const stack = new aws_cdk_lib_1.Stack(app, 'cdk-kubesphere-integ', { env });
        // create a default KubeSphere on a new Amazon EKS cluster
        new index_1.KubeSphere(stack, 'KubeSphere', {
            appStore: true,
            nodegroupOptions: {
                capacityType: aws_cdk_lib_1.aws_eks.CapacityType.SPOT,
                instanceTypes: [
                    new aws_cdk_lib_1.aws_ec2.InstanceType('t3.large'),
                    new aws_cdk_lib_1.aws_ec2.InstanceType('m5.large'),
                    new aws_cdk_lib_1.aws_ec2.InstanceType('c5.large'),
                ],
                desiredSize: 3,
            },
        });
        this.stack = [stack];
    }
}
exports.IntegTesting = IntegTesting;
new IntegTesting();
//# sourceMappingURL=data:application/json;base64,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