# Generated by Django 3.2.10 on 2021-12-16 13:16

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import model_utils.fields
import nobinobi_child.models
import phonenumber_field.modelfields


class Migration(migrations.Migration):

    dependencies = [
        ('auth', '0012_alter_user_first_name_max_length'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('nobinobi_staff', '0010_auto_20201029_1500'),
        ('nobinobi_child', '0004_add_organisation_to_classroom'),
    ]

    operations = [
        migrations.AlterModelOptions(
            name='absencegroup',
            options={'ordering': ('name',), 'verbose_name': 'Absence group', 'verbose_name_plural': 'Absence groups'},
        ),
        migrations.AlterModelOptions(
            name='absencetype',
            options={'ordering': ('order', 'group', 'name'), 'verbose_name': 'Absence type', 'verbose_name_plural': 'Absence types'},
        ),
        migrations.AlterModelOptions(
            name='address',
            options={'ordering': ('country', 'zip', 'city', 'street'), 'verbose_name': 'Address', 'verbose_name_plural': 'Addresses'},
        ),
        migrations.AlterModelOptions(
            name='agegroup',
            options={'ordering': ('order', 'name'), 'verbose_name': 'Age group', 'verbose_name_plural': 'Age groups'},
        ),
        migrations.AlterModelOptions(
            name='allergy',
            options={'ordering': ('name',), 'verbose_name': 'Allergy', 'verbose_name_plural': 'Allergies'},
        ),
        migrations.AlterModelOptions(
            name='child',
            options={'ordering': ('last_name', 'first_name', 'created'), 'verbose_name': 'Child', 'verbose_name_plural': 'Children'},
        ),
        migrations.AlterModelOptions(
            name='childspecificneed',
            options={'ordering': ('child',), 'verbose_name': 'Child specific need', 'verbose_name_plural': 'Children specific needs'},
        ),
        migrations.AlterModelOptions(
            name='childtocontact',
            options={'ordering': ('order', 'child'), 'verbose_name': 'Child to contact', 'verbose_name_plural': 'Children to contacts'},
        ),
        migrations.AlterModelOptions(
            name='childtoperiod',
            options={'ordering': ('start_date', 'end_date', 'child', 'period'), 'verbose_name': 'Child to period', 'verbose_name_plural': 'Children to periods'},
        ),
        migrations.AlterModelOptions(
            name='classroom',
            options={'ordering': ('order', 'name'), 'verbose_name': 'Classroom', 'verbose_name_plural': 'Classrooms'},
        ),
        migrations.AlterModelOptions(
            name='classroomdayoff',
            options={'ordering': ('weekday',), 'verbose_name': 'Classroom day off', 'verbose_name_plural': 'Classrooms days off'},
        ),
        migrations.AlterModelOptions(
            name='foodrestriction',
            options={'ordering': ('name',), 'verbose_name': 'Food restriction', 'verbose_name_plural': 'Food restrictions'},
        ),
        migrations.AlterModelOptions(
            name='informationoftheday',
            options={'ordering': ('start_date', 'end_date'), 'verbose_name': 'Information of the day', 'verbose_name_plural': 'Informations of the day'},
        ),
        migrations.AlterModelOptions(
            name='language',
            options={'ordering': ('name', 'created'), 'verbose_name': 'Language', 'verbose_name_plural': 'Languages'},
        ),
        migrations.AlterModelOptions(
            name='logchangeclassroom',
            options={'ordering': ('date',), 'verbose_name': 'Log change classroom', 'verbose_name_plural': 'Logs changed classrooms'},
        ),
        migrations.AlterModelOptions(
            name='period',
            options={'ordering': ('weekday', 'order', 'name'), 'verbose_name': 'Period', 'verbose_name_plural': 'Periods'},
        ),
        migrations.AlterField(
            model_name='absence',
            name='child',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='nobinobi_child.child', verbose_name='Child'),
        ),
        migrations.AlterField(
            model_name='absence',
            name='end_date',
            field=models.DateTimeField(verbose_name='End date'),
        ),
        migrations.AlterField(
            model_name='absence',
            name='start_date',
            field=models.DateTimeField(verbose_name='Start date'),
        ),
        migrations.AlterField(
            model_name='absencegroup',
            name='name',
            field=models.CharField(max_length=50, verbose_name='Name'),
        ),
        migrations.AlterField(
            model_name='absencetype',
            name='group',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='nobinobi_child.absencegroup', verbose_name='Group'),
        ),
        migrations.AlterField(
            model_name='absencetype',
            name='name',
            field=models.CharField(max_length=50, verbose_name='Name'),
        ),
        migrations.AlterField(
            model_name='absencetype',
            name='order',
            field=models.PositiveIntegerField(verbose_name='Order'),
        ),
        migrations.AlterField(
            model_name='address',
            name='city',
            field=models.CharField(max_length=50, verbose_name='City'),
        ),
        migrations.AlterField(
            model_name='address',
            name='country',
            field=models.CharField(default='Switzerland', max_length=50, verbose_name='Country'),
        ),
        migrations.AlterField(
            model_name='address',
            name='street',
            field=models.CharField(max_length=100, verbose_name='Street'),
        ),
        migrations.AlterField(
            model_name='address',
            name='zip',
            field=models.PositiveIntegerField(verbose_name='ZIP'),
        ),
        migrations.AlterField(
            model_name='agegroup',
            name='end_date',
            field=models.DateField(verbose_name='End date'),
        ),
        migrations.AlterField(
            model_name='agegroup',
            name='from_date',
            field=models.DateField(verbose_name='From date'),
        ),
        migrations.AlterField(
            model_name='agegroup',
            name='name',
            field=models.CharField(max_length=50, verbose_name='Name'),
        ),
        migrations.AlterField(
            model_name='agegroup',
            name='order',
            field=models.PositiveIntegerField(unique=True, verbose_name='Order'),
        ),
        migrations.AlterField(
            model_name='allergy',
            name='name',
            field=models.CharField(max_length=50, verbose_name='Name'),
        ),
        migrations.AlterField(
            model_name='child',
            name='age_group',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='nobinobi_child.agegroup', verbose_name='Age group'),
        ),
        migrations.AlterField(
            model_name='child',
            name='birth_date',
            field=models.DateField(blank=True, null=True, verbose_name='Birth date'),
        ),
        migrations.AlterField(
            model_name='child',
            name='classroom',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='classroom', to='nobinobi_child.classroom', verbose_name='Classroom'),
        ),
        migrations.AlterField(
            model_name='child',
            name='comment',
            field=models.CharField(blank=True, max_length=255, null=True, verbose_name='Comment'),
        ),
        migrations.AlterField(
            model_name='child',
            name='date_next_classroom',
            field=models.DateField(blank=True, null=True, verbose_name='Date next classroom'),
        ),
        migrations.AlterField(
            model_name='child',
            name='first_name',
            field=models.CharField(max_length=100, verbose_name='First name'),
        ),
        migrations.AlterField(
            model_name='child',
            name='food_restrictions',
            field=models.ManyToManyField(blank=True, related_name='food_restrictions', to='nobinobi_child.FoodRestriction', verbose_name='Food restrictions'),
        ),
        migrations.AlterField(
            model_name='child',
            name='gender',
            field=model_utils.fields.StatusField(choices=[(0, 'dummy')], default='boy', max_length=100, no_check_for_status=True, null=True, verbose_name='Gender'),
        ),
        migrations.AlterField(
            model_name='child',
            name='languages',
            field=models.ManyToManyField(blank=True, related_name='languages', to='nobinobi_child.Language', verbose_name='Languages'),
        ),
        migrations.AlterField(
            model_name='child',
            name='last_name',
            field=models.CharField(max_length=100, verbose_name='Last name'),
        ),
        migrations.AlterField(
            model_name='child',
            name='next_classroom',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='next_classroom', to='nobinobi_child.classroom', verbose_name='Next classroom'),
        ),
        migrations.AlterField(
            model_name='child',
            name='periods',
            field=models.ManyToManyField(blank=True, related_name='periods', through='nobinobi_child.ChildToPeriod', to='nobinobi_child.Period', verbose_name='Periods'),
        ),
        migrations.AlterField(
            model_name='child',
            name='picture',
            field=models.ImageField(blank=True, null=True, upload_to=nobinobi_child.models.Child.upload_picture_child, verbose_name='Picture'),
        ),
        migrations.AlterField(
            model_name='child',
            name='red_list',
            field=models.CharField(blank=True, max_length=255, null=True, verbose_name='Red list'),
        ),
        migrations.AlterField(
            model_name='child',
            name='renewal_date',
            field=models.DateField(blank=True, null=True, verbose_name='Renewal date'),
        ),
        migrations.AlterField(
            model_name='child',
            name='staff',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='nobinobi_staff.staff', verbose_name='Staff'),
        ),
        migrations.AlterField(
            model_name='child',
            name='usual_name',
            field=models.CharField(max_length=100, unique=True, verbose_name='Usual name'),
        ),
        migrations.AlterField(
            model_name='childspecificneed',
            name='attachment',
            field=models.FileField(blank=True, null=True, upload_to=nobinobi_child.models.ChildSpecificNeed.upload_attachment_child, verbose_name='Attachment'),
        ),
        migrations.AlterField(
            model_name='childspecificneed',
            name='child',
            field=models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, to='nobinobi_child.child', verbose_name='Child'),
        ),
        migrations.AlterField(
            model_name='childspecificneed',
            name='ihp',
            field=models.BooleanField(default=True, verbose_name='Individual home project'),
        ),
        migrations.AlterField(
            model_name='childspecificneed',
            name='measure_take',
            field=model_utils.fields.SplitField(no_excerpt_field=True, verbose_name='Measure to take'),
        ),
        migrations.AlterField(
            model_name='childspecificneed',
            name='problem',
            field=model_utils.fields.SplitField(no_excerpt_field=True, verbose_name='Problem'),
        ),
        migrations.AlterField(
            model_name='childtocontact',
            name='child',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='nobinobi_child.child', verbose_name='Child'),
        ),
        migrations.AlterField(
            model_name='childtocontact',
            name='link_with_child',
            field=models.CharField(help_text='Type contact: Example Father, Mother ...', max_length=50, verbose_name='Link with child'),
        ),
        migrations.AlterField(
            model_name='childtocontact',
            name='order',
            field=models.PositiveIntegerField(verbose_name='Order'),
        ),
        migrations.AlterField(
            model_name='childtoperiod',
            name='child',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='nobinobi_child.child', verbose_name='Child'),
        ),
        migrations.AlterField(
            model_name='childtoperiod',
            name='end_date',
            field=models.DateField(verbose_name='End date'),
        ),
        migrations.AlterField(
            model_name='childtoperiod',
            name='period',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='nobinobi_child.period', verbose_name='Period'),
        ),
        migrations.AlterField(
            model_name='childtoperiod',
            name='start_date',
            field=models.DateField(verbose_name='Start date'),
        ),
        migrations.AlterField(
            model_name='classroom',
            name='allowed_group_login',
            field=models.ManyToManyField(blank=True, related_name='classroom_group_login', to='auth.Group', verbose_name='Allowed group login'),
        ),
        migrations.AlterField(
            model_name='classroom',
            name='allowed_login',
            field=models.ManyToManyField(blank=True, related_name='classroom_login', to=settings.AUTH_USER_MODEL, verbose_name='Allowed login'),
        ),
        migrations.AlterField(
            model_name='classroom',
            name='capacity',
            field=models.PositiveIntegerField(default=20, verbose_name='Capacity'),
        ),
        migrations.AlterField(
            model_name='classroom',
            name='name',
            field=models.CharField(max_length=50, unique=True, verbose_name='Name'),
        ),
        migrations.AlterField(
            model_name='classroom',
            name='order',
            field=models.PositiveIntegerField(unique=True, verbose_name='Order'),
        ),
        migrations.AlterField(
            model_name='classroomdayoff',
            name='classrooms',
            field=models.ManyToManyField(to='nobinobi_child.Classroom', verbose_name='Classroom'),
        ),
        migrations.AlterField(
            model_name='classroomdayoff',
            name='weekday',
            field=models.IntegerField(choices=[(1, 'Monday'), (2, 'Tuesday'), (3, 'Wednesday'), (4, 'Thursday'), (5, 'Friday'), (6, 'Saturday'), (7, 'Sunday')], verbose_name='Weekday'),
        ),
        migrations.AlterField(
            model_name='contact',
            name='address',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, to='nobinobi_child.address', verbose_name='Address'),
        ),
        migrations.AlterField(
            model_name='contact',
            name='email',
            field=models.EmailField(blank=True, max_length=254, null=True, verbose_name='Email'),
        ),
        migrations.AlterField(
            model_name='contact',
            name='first_name',
            field=models.CharField(max_length=100, verbose_name='First name'),
        ),
        migrations.AlterField(
            model_name='contact',
            name='function',
            field=models.CharField(blank=True, max_length=100, null=True, verbose_name='Function'),
        ),
        migrations.AlterField(
            model_name='contact',
            name='last_name',
            field=models.CharField(max_length=100, verbose_name='Last name'),
        ),
        migrations.AlterField(
            model_name='contact',
            name='mobile_phone',
            field=phonenumber_field.modelfields.PhoneNumberField(blank=True, max_length=128, null=True, region=None, verbose_name='Mobile phone'),
        ),
        migrations.AlterField(
            model_name='contact',
            name='phone',
            field=phonenumber_field.modelfields.PhoneNumberField(max_length=128, region=None, verbose_name='Phone'),
        ),
        migrations.AlterField(
            model_name='contact',
            name='professional_phone',
            field=phonenumber_field.modelfields.PhoneNumberField(blank=True, max_length=128, null=True, region=None, verbose_name='Professional phone'),
        ),
        migrations.AlterField(
            model_name='foodrestriction',
            name='name',
            field=models.CharField(max_length=50, verbose_name='Name'),
        ),
        migrations.AlterField(
            model_name='informationoftheday',
            name='classrooms',
            field=models.ManyToManyField(related_name='classrooms', to='nobinobi_child.Classroom', verbose_name='Classroom'),
        ),
        migrations.AlterField(
            model_name='informationoftheday',
            name='content',
            field=model_utils.fields.SplitField(no_excerpt_field=True, verbose_name='Content'),
        ),
        migrations.AlterField(
            model_name='informationoftheday',
            name='end_date',
            field=models.DateTimeField(verbose_name='End date'),
        ),
        migrations.AlterField(
            model_name='informationoftheday',
            name='start_date',
            field=models.DateTimeField(verbose_name='Start date'),
        ),
        migrations.AlterField(
            model_name='informationoftheday',
            name='title',
            field=models.CharField(max_length=50, verbose_name='Title'),
        ),
        migrations.AlterField(
            model_name='language',
            name='name',
            field=models.CharField(max_length=50, unique=True, verbose_name='Name'),
        ),
        migrations.AlterField(
            model_name='logchangeclassroom',
            name='child',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='nobinobi_child.child', verbose_name='Child'),
        ),
        migrations.AlterField(
            model_name='logchangeclassroom',
            name='classroom',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='log_change_classroom', to='nobinobi_child.classroom', verbose_name='Classroom'),
        ),
        migrations.AlterField(
            model_name='logchangeclassroom',
            name='next_classroom',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='log_change_next_classroom', to='nobinobi_child.classroom', verbose_name='Next classroom'),
        ),
        migrations.AlterField(
            model_name='period',
            name='end_time',
            field=models.TimeField(null=True, verbose_name='End time'),
        ),
        migrations.AlterField(
            model_name='period',
            name='max_child',
            field=models.PositiveIntegerField(blank=True, null=True, verbose_name='Max child'),
        ),
        migrations.AlterField(
            model_name='period',
            name='name',
            field=models.CharField(max_length=50, verbose_name='Name'),
        ),
        migrations.AlterField(
            model_name='period',
            name='order',
            field=models.PositiveIntegerField(verbose_name='Order'),
        ),
        migrations.AlterField(
            model_name='period',
            name='start_time',
            field=models.TimeField(null=True, verbose_name='Start time'),
        ),
        migrations.AlterField(
            model_name='period',
            name='weekday',
            field=models.IntegerField(choices=[(1, 'Monday'), (2, 'Tuesday'), (3, 'Wednesday'), (4, 'Thursday'), (5, 'Friday'), (6, 'Saturday'), (7, 'Sunday')], verbose_name='Weekday'),
        ),
    ]
