# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Dict, List, Mapping, Optional, Tuple, Union
from . import _utilities, _tables

__all__ = ['ProjectHook']


class ProjectHook(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enable_ssl_verification: Optional[pulumi.Input[bool]] = None,
                 issues_events: Optional[pulumi.Input[bool]] = None,
                 job_events: Optional[pulumi.Input[bool]] = None,
                 merge_requests_events: Optional[pulumi.Input[bool]] = None,
                 note_events: Optional[pulumi.Input[bool]] = None,
                 pipeline_events: Optional[pulumi.Input[bool]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 push_events: Optional[pulumi.Input[bool]] = None,
                 tag_push_events: Optional[pulumi.Input[bool]] = None,
                 token: Optional[pulumi.Input[str]] = None,
                 url: Optional[pulumi.Input[str]] = None,
                 wiki_page_events: Optional[pulumi.Input[bool]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        ## # gitlab\_project\_hook

        This resource allows you to create and manage hooks for your GitLab projects.
        For further information on hooks, consult the [gitlab
        documentation](https://docs.gitlab.com/ce/user/project/integrations/webhooks.html).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gitlab as gitlab

        example = gitlab.ProjectHook("example",
            merge_requests_events=True,
            project="example/hooked",
            url="https://example.com/hook/example")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] enable_ssl_verification: Enable ssl verification when invoking
               the hook.
        :param pulumi.Input[bool] issues_events: Invoke the hook for issues events.
        :param pulumi.Input[bool] job_events: Invoke the hook for job events.
        :param pulumi.Input[bool] merge_requests_events: Invoke the hook for merge requests.
        :param pulumi.Input[bool] note_events: Invoke the hook for notes events.
        :param pulumi.Input[bool] pipeline_events: Invoke the hook for pipeline events.
        :param pulumi.Input[str] project: The name or id of the project to add the hook to.
        :param pulumi.Input[bool] push_events: Invoke the hook for push events.
        :param pulumi.Input[bool] tag_push_events: Invoke the hook for tag push events.
        :param pulumi.Input[str] token: A token to present when invoking the hook.
        :param pulumi.Input[str] url: The url of the hook to invoke.
        :param pulumi.Input[bool] wiki_page_events: Invoke the hook for wiki page events.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['enable_ssl_verification'] = enable_ssl_verification
            __props__['issues_events'] = issues_events
            __props__['job_events'] = job_events
            __props__['merge_requests_events'] = merge_requests_events
            __props__['note_events'] = note_events
            __props__['pipeline_events'] = pipeline_events
            if project is None:
                raise TypeError("Missing required property 'project'")
            __props__['project'] = project
            __props__['push_events'] = push_events
            __props__['tag_push_events'] = tag_push_events
            __props__['token'] = token
            if url is None:
                raise TypeError("Missing required property 'url'")
            __props__['url'] = url
            __props__['wiki_page_events'] = wiki_page_events
        super(ProjectHook, __self__).__init__(
            'gitlab:index/projectHook:ProjectHook',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            enable_ssl_verification: Optional[pulumi.Input[bool]] = None,
            issues_events: Optional[pulumi.Input[bool]] = None,
            job_events: Optional[pulumi.Input[bool]] = None,
            merge_requests_events: Optional[pulumi.Input[bool]] = None,
            note_events: Optional[pulumi.Input[bool]] = None,
            pipeline_events: Optional[pulumi.Input[bool]] = None,
            project: Optional[pulumi.Input[str]] = None,
            push_events: Optional[pulumi.Input[bool]] = None,
            tag_push_events: Optional[pulumi.Input[bool]] = None,
            token: Optional[pulumi.Input[str]] = None,
            url: Optional[pulumi.Input[str]] = None,
            wiki_page_events: Optional[pulumi.Input[bool]] = None) -> 'ProjectHook':
        """
        Get an existing ProjectHook resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] enable_ssl_verification: Enable ssl verification when invoking
               the hook.
        :param pulumi.Input[bool] issues_events: Invoke the hook for issues events.
        :param pulumi.Input[bool] job_events: Invoke the hook for job events.
        :param pulumi.Input[bool] merge_requests_events: Invoke the hook for merge requests.
        :param pulumi.Input[bool] note_events: Invoke the hook for notes events.
        :param pulumi.Input[bool] pipeline_events: Invoke the hook for pipeline events.
        :param pulumi.Input[str] project: The name or id of the project to add the hook to.
        :param pulumi.Input[bool] push_events: Invoke the hook for push events.
        :param pulumi.Input[bool] tag_push_events: Invoke the hook for tag push events.
        :param pulumi.Input[str] token: A token to present when invoking the hook.
        :param pulumi.Input[str] url: The url of the hook to invoke.
        :param pulumi.Input[bool] wiki_page_events: Invoke the hook for wiki page events.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["enable_ssl_verification"] = enable_ssl_verification
        __props__["issues_events"] = issues_events
        __props__["job_events"] = job_events
        __props__["merge_requests_events"] = merge_requests_events
        __props__["note_events"] = note_events
        __props__["pipeline_events"] = pipeline_events
        __props__["project"] = project
        __props__["push_events"] = push_events
        __props__["tag_push_events"] = tag_push_events
        __props__["token"] = token
        __props__["url"] = url
        __props__["wiki_page_events"] = wiki_page_events
        return ProjectHook(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="enableSslVerification")
    def enable_ssl_verification(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable ssl verification when invoking
        the hook.
        """
        return pulumi.get(self, "enable_ssl_verification")

    @property
    @pulumi.getter(name="issuesEvents")
    def issues_events(self) -> pulumi.Output[Optional[bool]]:
        """
        Invoke the hook for issues events.
        """
        return pulumi.get(self, "issues_events")

    @property
    @pulumi.getter(name="jobEvents")
    def job_events(self) -> pulumi.Output[Optional[bool]]:
        """
        Invoke the hook for job events.
        """
        return pulumi.get(self, "job_events")

    @property
    @pulumi.getter(name="mergeRequestsEvents")
    def merge_requests_events(self) -> pulumi.Output[Optional[bool]]:
        """
        Invoke the hook for merge requests.
        """
        return pulumi.get(self, "merge_requests_events")

    @property
    @pulumi.getter(name="noteEvents")
    def note_events(self) -> pulumi.Output[Optional[bool]]:
        """
        Invoke the hook for notes events.
        """
        return pulumi.get(self, "note_events")

    @property
    @pulumi.getter(name="pipelineEvents")
    def pipeline_events(self) -> pulumi.Output[Optional[bool]]:
        """
        Invoke the hook for pipeline events.
        """
        return pulumi.get(self, "pipeline_events")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The name or id of the project to add the hook to.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="pushEvents")
    def push_events(self) -> pulumi.Output[Optional[bool]]:
        """
        Invoke the hook for push events.
        """
        return pulumi.get(self, "push_events")

    @property
    @pulumi.getter(name="tagPushEvents")
    def tag_push_events(self) -> pulumi.Output[Optional[bool]]:
        """
        Invoke the hook for tag push events.
        """
        return pulumi.get(self, "tag_push_events")

    @property
    @pulumi.getter
    def token(self) -> pulumi.Output[Optional[str]]:
        """
        A token to present when invoking the hook.
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter
    def url(self) -> pulumi.Output[str]:
        """
        The url of the hook to invoke.
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter(name="wikiPageEvents")
    def wiki_page_events(self) -> pulumi.Output[Optional[bool]]:
        """
        Invoke the hook for wiki page events.
        """
        return pulumi.get(self, "wiki_page_events")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

