# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Dict, List, Mapping, Optional, Tuple, Union
from . import _utilities, _tables

__all__ = ['ServiceJira']


class ServiceJira(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 comment_on_event_enabled: Optional[pulumi.Input[bool]] = None,
                 commit_events: Optional[pulumi.Input[bool]] = None,
                 jira_issue_transition_id: Optional[pulumi.Input[str]] = None,
                 merge_requests_events: Optional[pulumi.Input[bool]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 project_key: Optional[pulumi.Input[str]] = None,
                 url: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Create a ServiceJira resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] comment_on_event_enabled: Enable comments inside Jira issues on each GitLab event (commit / merge request)
        :param pulumi.Input[bool] commit_events: Enable notifications for commit events
        :param pulumi.Input[str] jira_issue_transition_id: The ID of a transition that moves issues to a closed state. You can find this number under the JIRA workflow administration (Administration > Issues > Workflows) by selecting View under Operations of the desired workflow of your project. By default, this ID is set to 2.
        :param pulumi.Input[bool] merge_requests_events: Enable notifications for merge request events
        :param pulumi.Input[str] password: The password of the user created to be used with GitLab/JIRA.
        :param pulumi.Input[str] project: ID of the project you want to activate integration on.
        :param pulumi.Input[str] project_key: The short identifier for your JIRA project, all uppercase, e.g., PROJ.
        :param pulumi.Input[str] url: The URL to the JIRA project which is being linked to this GitLab project. For example, https://jira.example.com.
        :param pulumi.Input[str] username: The username of the user created to be used with GitLab/JIRA.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['comment_on_event_enabled'] = comment_on_event_enabled
            __props__['commit_events'] = commit_events
            __props__['jira_issue_transition_id'] = jira_issue_transition_id
            __props__['merge_requests_events'] = merge_requests_events
            if password is None:
                raise TypeError("Missing required property 'password'")
            __props__['password'] = password
            if project is None:
                raise TypeError("Missing required property 'project'")
            __props__['project'] = project
            __props__['project_key'] = project_key
            if url is None:
                raise TypeError("Missing required property 'url'")
            __props__['url'] = url
            if username is None:
                raise TypeError("Missing required property 'username'")
            __props__['username'] = username
            __props__['active'] = None
            __props__['created_at'] = None
            __props__['title'] = None
            __props__['updated_at'] = None
        super(ServiceJira, __self__).__init__(
            'gitlab:index/serviceJira:ServiceJira',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            active: Optional[pulumi.Input[bool]] = None,
            comment_on_event_enabled: Optional[pulumi.Input[bool]] = None,
            commit_events: Optional[pulumi.Input[bool]] = None,
            created_at: Optional[pulumi.Input[str]] = None,
            jira_issue_transition_id: Optional[pulumi.Input[str]] = None,
            merge_requests_events: Optional[pulumi.Input[bool]] = None,
            password: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None,
            project_key: Optional[pulumi.Input[str]] = None,
            title: Optional[pulumi.Input[str]] = None,
            updated_at: Optional[pulumi.Input[str]] = None,
            url: Optional[pulumi.Input[str]] = None,
            username: Optional[pulumi.Input[str]] = None) -> 'ServiceJira':
        """
        Get an existing ServiceJira resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] comment_on_event_enabled: Enable comments inside Jira issues on each GitLab event (commit / merge request)
        :param pulumi.Input[bool] commit_events: Enable notifications for commit events
        :param pulumi.Input[str] jira_issue_transition_id: The ID of a transition that moves issues to a closed state. You can find this number under the JIRA workflow administration (Administration > Issues > Workflows) by selecting View under Operations of the desired workflow of your project. By default, this ID is set to 2.
        :param pulumi.Input[bool] merge_requests_events: Enable notifications for merge request events
        :param pulumi.Input[str] password: The password of the user created to be used with GitLab/JIRA.
        :param pulumi.Input[str] project: ID of the project you want to activate integration on.
        :param pulumi.Input[str] project_key: The short identifier for your JIRA project, all uppercase, e.g., PROJ.
        :param pulumi.Input[str] url: The URL to the JIRA project which is being linked to this GitLab project. For example, https://jira.example.com.
        :param pulumi.Input[str] username: The username of the user created to be used with GitLab/JIRA.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["active"] = active
        __props__["comment_on_event_enabled"] = comment_on_event_enabled
        __props__["commit_events"] = commit_events
        __props__["created_at"] = created_at
        __props__["jira_issue_transition_id"] = jira_issue_transition_id
        __props__["merge_requests_events"] = merge_requests_events
        __props__["password"] = password
        __props__["project"] = project
        __props__["project_key"] = project_key
        __props__["title"] = title
        __props__["updated_at"] = updated_at
        __props__["url"] = url
        __props__["username"] = username
        return ServiceJira(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def active(self) -> pulumi.Output[bool]:
        return pulumi.get(self, "active")

    @property
    @pulumi.getter(name="commentOnEventEnabled")
    def comment_on_event_enabled(self) -> pulumi.Output[bool]:
        """
        Enable comments inside Jira issues on each GitLab event (commit / merge request)
        """
        return pulumi.get(self, "comment_on_event_enabled")

    @property
    @pulumi.getter(name="commitEvents")
    def commit_events(self) -> pulumi.Output[bool]:
        """
        Enable notifications for commit events
        """
        return pulumi.get(self, "commit_events")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[str]:
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="jiraIssueTransitionId")
    def jira_issue_transition_id(self) -> pulumi.Output[Optional[str]]:
        """
        The ID of a transition that moves issues to a closed state. You can find this number under the JIRA workflow administration (Administration > Issues > Workflows) by selecting View under Operations of the desired workflow of your project. By default, this ID is set to 2.
        """
        return pulumi.get(self, "jira_issue_transition_id")

    @property
    @pulumi.getter(name="mergeRequestsEvents")
    def merge_requests_events(self) -> pulumi.Output[bool]:
        """
        Enable notifications for merge request events
        """
        return pulumi.get(self, "merge_requests_events")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[str]:
        """
        The password of the user created to be used with GitLab/JIRA.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        ID of the project you want to activate integration on.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="projectKey")
    def project_key(self) -> pulumi.Output[Optional[str]]:
        """
        The short identifier for your JIRA project, all uppercase, e.g., PROJ.
        """
        return pulumi.get(self, "project_key")

    @property
    @pulumi.getter
    def title(self) -> pulumi.Output[str]:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[str]:
        return pulumi.get(self, "updated_at")

    @property
    @pulumi.getter
    def url(self) -> pulumi.Output[str]:
        """
        The URL to the JIRA project which is being linked to this GitLab project. For example, https://jira.example.com.
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter
    def username(self) -> pulumi.Output[str]:
        """
        The username of the user created to be used with GitLab/JIRA.
        """
        return pulumi.get(self, "username")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

