# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Dict, List, Mapping, Optional, Tuple, Union
from . import _utilities, _tables

__all__ = ['ServicePipelinesEmail']


class ServicePipelinesEmail(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 branches_to_be_notified: Optional[pulumi.Input[str]] = None,
                 notify_only_broken_pipelines: Optional[pulumi.Input[bool]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 recipients: Optional[pulumi.Input[List[pulumi.Input[str]]]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Create a ServicePipelinesEmail resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] branches_to_be_notified: Branches to send notifications for. Valid options are `all`, `default`, `protected`, and `default_and_protected`. Default is `default`
        :param pulumi.Input[bool] notify_only_broken_pipelines: Notify only broken pipelines. Default is true.
        :param pulumi.Input[str] project: ID of the project you want to activate integration on.
        :param pulumi.Input[List[pulumi.Input[str]]] recipients: ) email addresses where notifications are sent.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['branches_to_be_notified'] = branches_to_be_notified
            __props__['notify_only_broken_pipelines'] = notify_only_broken_pipelines
            if project is None:
                raise TypeError("Missing required property 'project'")
            __props__['project'] = project
            if recipients is None:
                raise TypeError("Missing required property 'recipients'")
            __props__['recipients'] = recipients
        super(ServicePipelinesEmail, __self__).__init__(
            'gitlab:index/servicePipelinesEmail:ServicePipelinesEmail',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            branches_to_be_notified: Optional[pulumi.Input[str]] = None,
            notify_only_broken_pipelines: Optional[pulumi.Input[bool]] = None,
            project: Optional[pulumi.Input[str]] = None,
            recipients: Optional[pulumi.Input[List[pulumi.Input[str]]]] = None) -> 'ServicePipelinesEmail':
        """
        Get an existing ServicePipelinesEmail resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] branches_to_be_notified: Branches to send notifications for. Valid options are `all`, `default`, `protected`, and `default_and_protected`. Default is `default`
        :param pulumi.Input[bool] notify_only_broken_pipelines: Notify only broken pipelines. Default is true.
        :param pulumi.Input[str] project: ID of the project you want to activate integration on.
        :param pulumi.Input[List[pulumi.Input[str]]] recipients: ) email addresses where notifications are sent.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["branches_to_be_notified"] = branches_to_be_notified
        __props__["notify_only_broken_pipelines"] = notify_only_broken_pipelines
        __props__["project"] = project
        __props__["recipients"] = recipients
        return ServicePipelinesEmail(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="branchesToBeNotified")
    def branches_to_be_notified(self) -> pulumi.Output[Optional[str]]:
        """
        Branches to send notifications for. Valid options are `all`, `default`, `protected`, and `default_and_protected`. Default is `default`
        """
        return pulumi.get(self, "branches_to_be_notified")

    @property
    @pulumi.getter(name="notifyOnlyBrokenPipelines")
    def notify_only_broken_pipelines(self) -> pulumi.Output[Optional[bool]]:
        """
        Notify only broken pipelines. Default is true.
        """
        return pulumi.get(self, "notify_only_broken_pipelines")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        ID of the project you want to activate integration on.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def recipients(self) -> pulumi.Output[List[str]]:
        """
        ) email addresses where notifications are sent.
        """
        return pulumi.get(self, "recipients")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

