"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const codepipeline = require("@aws-cdk/aws-codepipeline");
const iam = require("@aws-cdk/aws-iam");
const action_1 = require("../action");
const common_1 = require("../common");
/**
 * A CodePipeline source action for BitBucket.
 *
 * @experimental
 */
class BitBucketSourceAction extends action_1.Action {
    constructor(props) {
        super({
            ...props,
            category: codepipeline.ActionCategory.SOURCE,
            owner: 'AWS',
            provider: 'CodeStarSourceConnection',
            artifactBounds: common_1.sourceArtifactBounds(),
            outputs: [props.output],
        });
        this.props = props;
    }
    bound(_scope, _stage, options) {
        var _a;
        // https://docs.aws.amazon.com/codepipeline/latest/userguide/security-iam.html#how-to-update-role-new-services
        options.role.addToPolicy(new iam.PolicyStatement({
            actions: [
                'codestar-connections:UseConnection',
            ],
            resources: [
                this.props.connectionArn,
            ],
        }));
        // the action needs to write the output to the pipeline bucket
        options.bucket.grantReadWrite(options.role);
        return {
            configuration: {
                ConnectionArn: this.props.connectionArn,
                FullRepositoryId: `${this.props.owner}/${this.props.repo}`,
                BranchName: (_a = this.props.branch) !== null && _a !== void 0 ? _a : 'master',
                OutputArtifactFormat: this.props.codeBuildCloneOutput === true
                    ? 'CODEBUILD_CLONE_REF'
                    : undefined,
            },
        };
    }
}
exports.BitBucketSourceAction = BitBucketSourceAction;
//# sourceMappingURL=data:application/json;base64,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