"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const codedeploy = require("@aws-cdk/aws-codedeploy");
const codepipeline = require("@aws-cdk/aws-codepipeline");
const s3 = require("@aws-cdk/aws-s3");
const cdk = require("@aws-cdk/core");
const cpactions = require("../lib");
const app = new cdk.App();
const stack = new cdk.Stack(app, 'aws-cdk-codepipeline-codedeploy');
const application = new codedeploy.ServerApplication(stack, 'CodeDeployApplication', {
    applicationName: 'IntegTestDeployApp',
});
const deploymentConfig = new codedeploy.ServerDeploymentConfig(stack, 'CustomDeployConfig', {
    minimumHealthyHosts: codedeploy.MinimumHealthyHosts.count(0),
});
const deploymentGroup = new codedeploy.ServerDeploymentGroup(stack, 'CodeDeployGroup', {
    application,
    deploymentGroupName: 'IntegTestDeploymentGroup',
    deploymentConfig,
});
const bucket = new s3.Bucket(stack, 'CodeDeployPipelineIntegTest', {
    versioned: true,
    removalPolicy: cdk.RemovalPolicy.DESTROY,
});
const pipeline = new codepipeline.Pipeline(stack, 'Pipeline', {
    artifactBucket: bucket,
});
const sourceStage = pipeline.addStage({ stageName: 'Source' });
const sourceOutput = new codepipeline.Artifact('SourceOutput');
const sourceAction = new cpactions.S3SourceAction({
    actionName: 'S3Source',
    bucketKey: 'application.zip',
    output: sourceOutput,
    bucket,
});
sourceStage.addAction(sourceAction);
const deployStage = pipeline.addStage({ stageName: 'Deploy' });
deployStage.addAction(new cpactions.CodeDeployServerDeployAction({
    actionName: 'CodeDeploy',
    deploymentGroup,
    input: sourceOutput,
}));
app.synth();
//# sourceMappingURL=data:application/json;base64,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