#pragma once
#include <stdint.h>
#include <string>
using namespace std;

#pragma pack(8)

/// Ű汾ŵַ
#define ISTONE_VERSION_LEN 16
/// 汾
typedef char ISTONEVersionType[ISTONE_VERSION_LEN];

/// ûID
#define ISTONE_USERID_LEN 16
/// û볤
#define ISTONE_USER_PW_LEN 32
/// յĳ
#define ISTONE_TRADING_DAY_LEN 9
/// ʱĳ
#define ISTONE_TIMESTAMP_LEN 9

/// ĳ
#define ISTONE_EXCHANGE_LEN 16
/// ֤ȯĳ
#define ISTONE_TICKER_LEN 16
/// ֤ȯƵĳ
#define ISTONE_TICKER_NAME_LEN 64

/// رŵĳ
#define ISTONE_LOCAL_ORDER_LEN         11
/// ŵĳ
#define ISTONE_ORDER_EXCH_LEN          17
/// ɽִбŵĳ
#define ISTONE_EXEC_ID_LEN             18
/// Ա볤
#define ISTONE_BRANCH_PBU_LEN          7

/////////////////////////////////////////////////////////////////////////
		///@brief ISTONE_USERS_TYPE ϵͳû
		/////////////////////////////////////////////////////////////////////////
typedef enum ISTONE_USERS_TYPE
{
	ISTONE_USERS_EXTERNAL = 1,	///<ⲿû
	ISTONE_USERS_OPERATOER,		///<Ա
	ISTONE_USERS_AUDITOR		///<Ա
}ISTONE_USERS_TYPE;

/////////////////////////////////////////////////////////////////////////
///@brief ISTONE_LOG_LEVEL־
/////////////////////////////////////////////////////////////////////////
typedef enum ISTONE_LOG_LEVEL {
	ISTONE_LOG_LEVEL_FATAL, ///<ش󼶱
	ISTONE_LOG_LEVEL_ERROR, ///<󼶱
	ISTONE_LOG_LEVEL_WARNING, ///<漶
	ISTONE_LOG_LEVEL_INFO,   ///<info
	ISTONE_LOG_LEVEL_DEBUG,  ///<debug
	ISTONE_LOG_LEVEL_TRACE   ///<trace
}ISTONE_LOG_LEVEL;

/////////////////////////////////////////////////////////////////////////
///@brief ISTONE_PROTOCOL_TYPEͨѶЭ鷽ʽ
/////////////////////////////////////////////////////////////////////////
typedef enum ISTONE_PROTOCOL_TYPE
{
	ISTONE_PROTOCOL_TCP = 1,	///<TCPʽ
	ISTONE_PROTOCOL_UDP		///<UDPʽ(ӿ֧)
}ISTONE_PROTOCOL_TYPE;

/////////////////////////////////////////////////////////////////////////
///@brief ISTONE_EXCHANGE_TYPEǽ
/////////////////////////////////////////////////////////////////////////
typedef enum ISTONE_EXCHANGE_TYPE
{
	ISTONE_EXCHANGE_SH = 1,	///<֤
	ISTONE_EXCHANGE_SZ = 2,		///<֤
	ISTONE_EXCHANGE_UNKNOWN	///<ڵĽ
}ISTONE_EXCHANGE_TYPE;

//////////////////////////////////////////////////////////////////////////
///@brief ISTONE_MARKET_TYPEг
//////////////////////////////////////////////////////////////////////////
typedef enum ISTONE_MARKET_TYPE
{
	ISTONE_MKT_INIT = 0,///<ʼֵδ֪
	ISTONE_MKT_SZ_A = 1,///<A
	ISTONE_MKT_SH_A,    ///<ϺA
	ISTONE_MKT_UNKNOWN   ///<δ֪г
}ISTONE_MARKET_TYPE;

/////////////////////////////////////////////////////////////////////////
///@brief ISTONE_TICKER_STATUS_TYPEǼ۸
/////////////////////////////////////////////////////////////////////////
typedef enum ISTONE_TICKER_STATUS_TYPE
{
	ISTONE_INSTRUMENT_STATUS_OPEN = 1,
	ISTONE_INSTRUMENT_STATUS_CLOSE = 2,

}ISTONE_TICKER_STATUS_TYPE;

/////////////////////////////////////////////////////////////////////////
///@brief ISTONE_PRICE_TYPEǼ۸
/////////////////////////////////////////////////////////////////////////
typedef enum ISTONE_PRICE_TYPE
{
	ISTONE_PRICE_LIMIT = 1,           ///<޼۵- /  / ȨͨƱҵ⣬ҵʹôͣ
	ISTONE_PRICE_BEST_OR_CANCEL,      ///<ʱɽʣתм۵- / Ȩ
	ISTONE_PRICE_BEST5_OR_LIMIT,      ///<嵵ʱɽʣת޼ۣм۵-
	ISTONE_PRICE_BEST5_OR_CANCEL,     ///<5ʱɽʣתм۵-
	ISTONE_PRICE_ALL_OR_CANCEL,       ///<ȫɽ,м۵- / Ȩ
	ISTONE_PRICE_FORWARD_BEST,        ///<ţм۵-
	ISTONE_PRICE_REVERSE_BEST_LIMIT,  ///<Էʣת޼ۣм۵- / Ȩ
	ISTONE_PRICE_LIMIT_OR_CANCEL,	   ///<Ȩ޼걨FOK
	ISTONE_PRICE_TYPE_UNKNOWN,		   ///<δ֪Ч۸
}ISTONE_PRICE_TYPE;

/////////////////////////////////////////////////////////////////////////
///@brief ISTONE_SIDE_TYPE
/////////////////////////////////////////////////////////////////////////
typedef uint8_t ISTONE_SIDE_TYPE;

///¹깺ETFɣýеƷ
#define ISTONE_SIDE_BUY            1
///عETFýеƷ
#define ISTONE_SIDE_SELL           2
///깺
#define ISTONE_SIDE_PURCHASE       7
///
#define ISTONE_SIDE_REDEMPTION     8
///
#define ISTONE_SIDE_SPLIT          9
///ϲ
#define ISTONE_SIDE_MERGE          10
///İ֮sideıңݲ֧
#define ISTONE_SIDE_COVER          11
///İ֮sideӦƽʶΪ/ӦƽʶΪƽ
#define ISTONE_SIDE_FREEZE         12
/// 
#define ISTONE_SIDE_MARGIN_TRADE	21
/// ȯ
#define ISTONE_SIDE_SHORT_SELL		22
/// ȯ
#define ISTONE_SIDE_REPAY_MARGIN	23
/// ȯȯ
#define ISTONE_SIDE_REPAY_STOCK	24
/// ֽ𻹿ͨЭ飬ͲѯЭ飩
//#define ISTONE_SIDE_CASH_REPAY_MARGIN	25
/// ȯȯ
#define ISTONE_SIDE_STOCK_REPAY_STOCK	26
/// ȯת
#define ISTONE_SIDE_SURSTK_TRANS       27
/// Ʒת
#define ISTONE_SIDE_GRTSTK_TRANSIN     28
/// Ʒת
#define ISTONE_SIDE_GRTSTK_TRANSOUT    29

///δ֪Ч
#define ISTONE_SIDE_UNKNOWN        30



/////////////////////////////////////////////////////////////////////////
///@brief ISTONE_POSITION_EFFECT_TYPEǿƽʶ
/////////////////////////////////////////////////////////////////////////
typedef uint8_t ISTONE_POSITION_EFFECT_TYPE;

/// ʼֵδֵ֪ƽʶֻ
#define ISTONE_POSITION_EFFECT_INIT                0
/// 
#define ISTONE_POSITION_EFFECT_OPEN                1
/// ƽ
#define ISTONE_POSITION_EFFECT_CLOSE               2
/// ǿƽ
#define ISTONE_POSITION_EFFECT_FORCECLOSE          3
/// ƽ
#define ISTONE_POSITION_EFFECT_CLOSETODAY          4
/// ƽ
#define ISTONE_POSITION_EFFECT_CLOSEYESTERDAY      5
/// ǿ
#define ISTONE_POSITION_EFFECT_FORCEOFF            6
/// ǿƽ
#define ISTONE_POSITION_EFFECT_LOCALFORCECLOSE     7
/// ҵ׷ǿƽ
#define ISTONE_POSITION_EFFECT_CREDIT_FORCE_COVER  8
/// ҵ峥ǿƽ
#define ISTONE_POSITION_EFFECT_CREDIT_FORCE_CLEAR  9
/// ҵԼǿƽ
#define ISTONE_POSITION_EFFECT_CREDIT_FORCE_DEBT   10
/// ҵǿƽ
#define ISTONE_POSITION_EFFECT_CREDIT_FORCE_UNCOND 11
/// δ֪Ŀƽʶ
#define ISTONE_POSITION_EFFECT_UNKNOWN             12


/////////////////////////////////////////////////////////////////////////
///@brief ISTONE_ORDER_ACTION_STATUS_TYPEǱ״̬
/////////////////////////////////////////////////////////////////////////
typedef enum ISTONE_ORDER_ACTION_STATUS_TYPE
{
	ISTONE_ORDER_ACTION_STATUS_SUBMITTED = 1,	///<Ѿύ
	ISTONE_ORDER_ACTION_STATUS_ACCEPTED,		///<Ѿ
	ISTONE_ORDER_ACTION_STATUS_REJECTED		///<Ѿܾ
}ISTONE_ORDER_ACTION_STATUS_TYPE;

/////////////////////////////////////////////////////////////////////////
///@brief ISTONE_ORDER_STATUS_TYPEǱ״̬
/////////////////////////////////////////////////////////////////////////
typedef enum ISTONE_ORDER_STATUS_TYPE
{
	ISTONE_ORDER_STATUS_INIT = 0,///<ʼ
	ISTONE_ORDER_STATUS_ALLTRADED = 1,           ///<ȫɽ
	ISTONE_ORDER_STATUS_PARTTRADEDQUEUEING,  ///<ֳɽ
	ISTONE_ORDER_STATUS_PARTTRADEDNOTQUEUEING, ///<ֳ
	ISTONE_ORDER_STATUS_NOTRADEQUEUEING,   ///<δɽ
	ISTONE_ORDER_STATUS_CANCELED,  ///<ѳ
	ISTONE_ORDER_STATUS_REJECTED,  ///<Ѿܾ
	ISTONE_ORDER_STATUS_UNKNOWN  ///<δ֪״̬
}ISTONE_ORDER_STATUS_TYPE;

/////////////////////////////////////////////////////////////////////////
///@brief ISTONE_ORDER_SUBMIT_STATUS_TYPEǱύ״̬
/////////////////////////////////////////////////////////////////////////
typedef enum ISTONE_ORDER_SUBMIT_STATUS_TYPE
{
	ISTONE_ORDER_SUBMIT_STATUS_INSERT_SUBMITTED = 1, ///<Ѿύ
	ISTONE_ORDER_SUBMIT_STATUS_INSERT_ACCEPTED,///<Ѿ
	ISTONE_ORDER_SUBMIT_STATUS_INSERT_REJECTED,///<Ѿܾ
	ISTONE_ORDER_SUBMIT_STATUS_CANCEL_SUBMITTED,///<Ѿύ
	ISTONE_ORDER_SUBMIT_STATUS_CANCEL_REJECTED,///<Ѿܾ
	ISTONE_ORDER_SUBMIT_STATUS_CANCEL_ACCEPTED ///<Ѿ
}ISTONE_ORDER_SUBMIT_STATUS_TYPE;


/////////////////////////////////////////////////////////////////////////
///@brief ISTONE_TE_RESUME_TYPEǹӦɽرشʽ
/////////////////////////////////////////////////////////////////////////
typedef enum ISTONE_TE_RESUME_TYPE
{
	ISTONE_TERT_RESTART = 0,	///<ӱտʼش
	ISTONE_TERT_RESUME,		///<Ӵϴյδ֧֣
	ISTONE_TERT_QUICK			///<ֻ͵¼Ӧɽر
}ISTONE_TE_RESUME_TYPE;


//////////////////////////////////////////////////////////////////////////
///@brief ETF_REPLACE_TYPEֽʶ
//////////////////////////////////////////////////////////////////////////
typedef enum ETF_REPLACE_TYPE
{
	ERT_CASH_FORBIDDEN = 0,             ///<ֹֽ
	ERT_CASH_OPTIONAL,                  ///<ֽ
	ERT_CASH_MUST,                      ///<ֽ
	ERT_CASH_RECOMPUTE_INTER_SZ,        ///<˲ֽ
	ERT_CASH_MUST_INTER_SZ,             ///<бֽ
	ERT_CASH_RECOMPUTE_INTER_OTHER,     ///<ǻгɷ֤ȯ˲ֽ
	ERT_CASH_MUST_INTER_OTHER,          ///<ʾǻгɷ֤ȯֽ
	EPT_INVALID                         ///<Чֵ
}ETF_REPLACE_TYPE;


//////////////////////////////////////////////////////////////////////////
///@brief ISTONE_TICKER_TYPE֤ȯ
//////////////////////////////////////////////////////////////////////////
typedef enum ISTONE_TICKER_TYPE
{
	ISTONE_TICKER_TYPE_SPOT = 1,            ///<ͨƱ<ծȯ<
	ISTONE_TICKER_TYPE_INDEX = 2,           ///<ָ
	ISTONE_TICKER_TYPE_OPTION = 4,          ///<Ȩ
	ISTONE_TICKER_TYPE_UNKNOWN              ///<δ֪

}ISTONE_TICKER_TYPE;

//////////////////////////////////////////////////////////////////////////
///@brief ISTONE_TICKER_TYPE֤ȯ
//////////////////////////////////////////////////////////////////////////
typedef enum ISTONE_SECURITY_TYPE
{
	ISTONE_SECURITY_TYPE_STOCK,			///<ͨƱ
	ISTONE_SECURITY_TYPE_FUND,			///<
	ISTONE_SECURITY_TYPE_BOND,			///<ծȯ
	ISTONE_SECURITY_TYPE_INDEX,         ///<ָ
	ISTONE_SECURITY_TYPE_OPTION,        ///<Ȩ
	ISTONE_SECURITY_TYPE_UNKNOWN        ///<δ֪

}ISTONE_SECURITY_TYPE;

//////////////////////////////////////////////////////////////////////////
///@brief ISTONE_BUSINESS_TYPE֤ȯҵ
//////////////////////////////////////////////////////////////////////////
typedef enum ISTONE_BUSINESS_TYPE
{
	ISTONE_BUSINESS_TYPE_CASH = 0,            ///<ͨƱҵ񣨹ƱETFȣ
	ISTONE_BUSINESS_TYPE_IPOS,                ///<¹깺ҵ񣨶Ӧprice typeѡ޼ͣ
	ISTONE_BUSINESS_TYPE_REPO,                ///<عҵ ( Ӧprice typeΪ޼ۣsideΪ )
	ISTONE_BUSINESS_TYPE_ETF,                 ///<ETFҵ
	ISTONE_BUSINESS_TYPE_MARGIN,              ///<ȯҵδ֧֣
	ISTONE_BUSINESS_TYPE_DESIGNATION,         ///<תйܣδ֧֣
	ISTONE_BUSINESS_TYPE_ALLOTMENT,		   ///<ҵ񣨶Ӧprice typeѡ޼,sideΪ
	ISTONE_BUSINESS_TYPE_STRUCTURED_FUND_PURCHASE_REDEMPTION,	   ///<ּҵ
	ISTONE_BUSINESS_TYPE_STRUCTURED_FUND_SPLIT_MERGE,	   ///<ֺּϲҵ
	ISTONE_BUSINESS_TYPE_MONEY_FUND,		   ///<һҵδ֧֣
	ISTONE_BUSINESS_TYPE_OPTION,              ///<Ȩҵ
	ISTONE_BUSINESS_TYPE_EXECUTE,             ///<Ȩ
	ISTONE_BUSINESS_TYPE_FREEZE,              ///<ݲ֧
	ISTONE_BUSINESS_TYPE_UNKNOWN              ///<δ֪

}ISTONE_BUSINESS_TYPE;

//////////////////////////////////////////////////////////////////////////
///@brief ISTONE_ACCOUNT_TYPE˻
//////////////////////////////////////////////////////////////////////////
typedef enum ISTONE_ACCOUNT_TYPE
{
	ISTONE_ACCOUNT_NORMAL = 0,	///<ͨ˻
	ISTONE_ACCOUNT_CREDIT,		///<˻
	ISTONE_ACCOUNT_DERIVE,		///<Ʒ˻
	ISTONE_ACCOUNT_UNKNOWN		///<δ֪˻
}ISTONE_ACCOUNT_TYPE;


/////////////////////////////////////////////////////////////////////////
///@brief ISTONE_FUND_TRANSFER_TYPEʽת
/////////////////////////////////////////////////////////////////////////
typedef enum ISTONE_FUND_TRANSFER_TYPE
{
	ISTONE_FUND_TRANSFER_OUT = 0,		///<ת XTPת̨
	ISTONE_FUND_TRANSFER_IN,	        ///<ת ӹ̨תXTP
	ISTONE_FUND_INTER_TRANSFER_OUT,    ///<ڵת ӱXTPڵ1תԶXTPڵ2XTP֮仮ֻܿ˻ûʹ
	ISTONE_FUND_INTER_TRANSFER_IN,     ///<ڵת ӶԶXTPڵ2ת뵽XTPڵ1XTP֮仮ֻܿ˻ûʹ
	ISTONE_FUND_TRANSFER_UNKNOWN		///<δ֪
}ISTONE_FUND_TRANSFER_TYPE;

/////////////////////////////////////////////////////////////////////////
///@brief ISTONE_FUND_OPER_STATUS̨ʽ
/////////////////////////////////////////////////////////////////////////
typedef enum ISTONE_FUND_OPER_STATUS {
	ISTONE_FUND_OPER_PROCESSING = 0,	///<XTPյڴ
	ISTONE_FUND_OPER_SUCCESS,			///<ɹ
	ISTONE_FUND_OPER_FAILED,			///<ʧ
	ISTONE_FUND_OPER_SUBMITTED,		///<ύй̨
	ISTONE_FUND_OPER_UNKNOWN			///<δ֪
}ISTONE_FUND_OPER_STATUS;

/////////////////////////////////////////////////////////////////////////
///@brief ISTONE_SPLIT_MERGE_STATUSһֺϲ״̬
/////////////////////////////////////////////////////////////////////////
typedef enum ISTONE_SPLIT_MERGE_STATUS {
	ISTONE_SPLIT_MERGE_STATUS_ALLOW = 0,	///<ֺͺϲ
	ISTONE_SPLIT_MERGE_STATUS_ONLY_SPLIT,	///<ֻ֣ϲ
	ISTONE_SPLIT_MERGE_STATUS_ONLY_MERGE,	///<ֻϲ
	ISTONE_SPLIT_MERGE_STATUS_FORBIDDEN	///<ֺϲ
}ISTONE_SPLIT_MERGE_STATUS;

/////////////////////////////////////////////////////////////////////////
///@brief ISTONE_TBT_TYPEһʻر
/////////////////////////////////////////////////////////////////////////
typedef enum ISTONE_TBT_TYPE {
	ISTONE_TBT_ENTRUST = 1,	///<ί
	ISTONE_TBT_TRADE = 2,		///<ʳɽ
}ISTONE_TBT_TYPE;

/////////////////////////////////////////////////////////////////////////
///@brief ISTONE_OPT_CALL_OR_PUT_TYPEһϹϹ
/////////////////////////////////////////////////////////////////////////
typedef enum ISTONE_OPT_CALL_OR_PUT_TYPE {
	ISTONE_OPT_CALL = 1,	    ///<Ϲ
	ISTONE_OPT_PUT = 2,		///<Ϲ
}ISTONE_OPT_CALL_OR_PUT_TYPE;

/////////////////////////////////////////////////////////////////////////
///@brief ISTONE_OPT_EXERCISE_TYPE_TYPEһȨʽ
/////////////////////////////////////////////////////////////////////////
typedef enum ISTONE_OPT_EXERCISE_TYPE_TYPE {
	ISTONE_OPT_EXERCISE_TYPE_EUR = 1,	    ///<ŷʽ
	ISTONE_OPT_EXERCISE_TYPE_AME = 2,		///<ʽ
}ISTONE_OPT_EXERCISE_TYPE_TYPE;

/////////////////////////////////////////////////////////////////////////
///@brief ISTONE_POSITION_DIRECTION_TYPEһֲַ
/////////////////////////////////////////////////////////////////////////
typedef enum ISTONE_POSITION_DIRECTION_TYPE {
	ISTONE_POSITION_DIRECTION_NET = 0,	    ///<
	ISTONE_POSITION_DIRECTION_LONG,		///<ࣨȨΪȨ
	ISTONE_POSITION_DIRECTION_SHORT,       ///<գȨΪ񷽣
	ISTONE_POSITION_DIRECTION_COVERED,     ///<ңȨΪ񷽣
}ISTONE_POSITION_DIRECTION_TYPE;

/////////////////////////////////////////////////////////////////////////
///@brief ISTONE_CRD_CASH_REPAY_STATUSһȯֱӻ״̬
/////////////////////////////////////////////////////////////////////////
typedef enum ISTONE_CRD_CR_STATUS {
	ISTONE_CRD_CR_INIT = 0,        ///< ʼδ״̬
	ISTONE_CRD_CR_SUCCESS,         ///< ѳɹ״̬
	ISTONE_CRD_CR_FAILED,          ///< ʧ״̬
} ISTONE_CRD_CR_STATUS;


/////////////////////////////////////////////////////////////////////////
///TXTPTradeTypeTypeǳɽ
/////////////////////////////////////////////////////////////////////////
typedef char TXTPTradeTypeType;

///ͨɽ
#define ISTONE_TRDT_COMMON '0'
///ֽ
#define ISTONE_TRDT_CASH '1'
///һгɽ
#define ISTONE_TRDT_PRIMARY '2'
///гʽɽ
#define ISTONE_TRDT_CROSS_MKT_CASH '3'


/////////////////////////////////////////////////////////////////////////
///TXTPOrderTypeTypeǱ
/////////////////////////////////////////////////////////////////////////
typedef char TXTPOrderTypeType;

///
#define ISTONE_ORDT_Normal '0'
///
#define ISTONE_ORDT_DeriveFromQuote '1'
///
#define ISTONE_ORDT_DeriveFromCombination '2'
///ϱ
#define ISTONE_ORDT_Combination '3'
///
#define ISTONE_ORDT_ConditionalOrder '4'
///
#define ISTONE_ORDT_Swap '5'


#pragma pack()

namespace istone
{
	namespace mdapi
	{
		//֤
		#define ISTONE_EI_SSE "SSE"
		//
		#define ISTONE_EI_SZSE "SZSE"

		/////////////////////////////////////////////////////////////////////////
		///TIStoneOrderSysIDTypeһ
		/////////////////////////////////////////////////////////////////////////
		typedef char TIStoneOrderSysIDType[31];

		/////////////////////////////////////////////////////////////////////////
		///TIStoneTradeIDTypeһɽ
		/////////////////////////////////////////////////////////////////////////
		typedef char TIStoneTradeIDType[21];

		/////////////////////////////////////////////////////////////////////////
		///TIStoneUserIDTypeһû
		/////////////////////////////////////////////////////////////////////////
		typedef char TIStoneUserIDType[16];

		/////////////////////////////////////////////////////////////////////////
		///TIStoneParticipantIDTypeһԱ
		/////////////////////////////////////////////////////////////////////////
		typedef char TIStoneParticipantIDType[11];

		/////////////////////////////////////////////////////////////////////////
		///TIStoneIPAddressTypeһIPַ
		/////////////////////////////////////////////////////////////////////////
		typedef char TIStoneIPAddressType[30];
		typedef char TIStoneIPAddressListType[300];

		/////////////////////////////////////////////////////////////////////////
		///TIStoneMacAddressTypeһMacַ
		/////////////////////////////////////////////////////////////////////////
		typedef char TIStoneMacAddressType[30];

		/////////////////////////////////////////////////////////////////////////
		///TIStoneInstrumentNameTypeһԼ
		/////////////////////////////////////////////////////////////////////////
		typedef char TIStoneInstrumentNameType[21];

		/////////////////////////////////////////////////////////////////////////
		///TIStoneBranchIDTypeһӪҵ
		/////////////////////////////////////////////////////////////////////////
		typedef char TIStoneBranchIDType[7];

		/////////////////////////////////////////////////////////////////////////
		///TIStoneInstrumentIDTypeһԼ
		/////////////////////////////////////////////////////////////////////////
		typedef char TIStoneInstrumentIDType[31];

		/////////////////////////////////////////////////////////////////////////
		///TIStoneIdentifiedCardNoTypeһ֤
		/////////////////////////////////////////////////////////////////////////
		typedef char TIStoneExchangeInstIDType[31];

		/////////////////////////////////////////////////////////////////////////
		///TIStoneIdentifiedCardNoTypeһ֤
		/////////////////////////////////////////////////////////////////////////
		typedef char TIStoneIdentifiedCardNoType[51];

		/////////////////////////////////////////////////////////////////////////
		///TIStoneIdentifiedCardTypeTypeһ֤
		/////////////////////////////////////////////////////////////////////////
		typedef char TIStoneIdentifiedCardTypeType[16];

		/////////////////////////////////////////////////////////////////////////
		///TIStoneExchangeIDTypeһ()ͨ
		/////////////////////////////////////////////////////////////////////////
		typedef char TIStoneExchangeIDType[11];

		/////////////////////////////////////////////////////////////////////////
		///TIStoneExchangeNameTypeһ()
		/////////////////////////////////////////////////////////////////////////
		typedef char TIStoneExchangeNameType[31];

		/////////////////////////////////////////////////////////////////////////
		///TIStoneDateTypeһ
		/////////////////////////////////////////////////////////////////////////
		typedef char TIStoneDateType[9];

		/////////////////////////////////////////////////////////////////////////
		///TIStoneTimeTypeһʱ
		/////////////////////////////////////////////////////////////////////////
		typedef char TIStoneTimeType[9];

		/////////////////////////////////////////////////////////////////////////
		///TIStoneClientTypeTypeһͻ
		/////////////////////////////////////////////////////////////////////////
		typedef char TIStoneClientTypeType;

		/////////////////////////////////////////////////////////////////////////
		///TIStoneClientNameTypeһͻ
		/////////////////////////////////////////////////////////////////////////
		typedef char TIStoneClientNameType[81];

		/////////////////////////////////////////////////////////////////////////
		///TIStoneClientIDTypeһͻ
		/////////////////////////////////////////////////////////////////////////
		typedef char TIStoneClientIDType[19];

		/////////////////////////////////////////////////////////////////////////
		///TIStoneIdCardTypeTypeһ֤
		/////////////////////////////////////////////////////////////////////////
		typedef char TIStoneIdCardTypeType[16];

		/////////////////////////////////////////////////////////////////////////
		///TIStoneAccountIDTypeһʽʺ
		/////////////////////////////////////////////////////////////////////////
		typedef char TIStoneAccountIDType[13];

		/////////////////////////////////////////////////////////////////////////
		///TIStoneSeatIDTypeһϯλ
		/////////////////////////////////////////////////////////////////////////
		typedef char TIStoneSeatIDType[13];

		/////////////////////////////////////////////////////////////////////////
		///TIStoneProductNameTypeһƷ
		/////////////////////////////////////////////////////////////////////////
		typedef char TIStoneProductNameType[41];

		/////////////////////////////////////////////////////////////////////////
		///TIStoneOrderLocalIDTypeһر
		/////////////////////////////////////////////////////////////////////////
		typedef char TIStoneOrderLocalIDType[13];

		/////////////////////////////////////////////////////////////////////////
		///TIStoneInvestorIDTypeһͶ߱
		/////////////////////////////////////////////////////////////////////////
		typedef char TIStoneInvestorIDType[19];

		/////////////////////////////////////////////////////////////////////////
		///TIStoneInvestUnitIDTypeһͶߵԪ
		/////////////////////////////////////////////////////////////////////////
		typedef char TIStoneInvestUnitIDType[19];

		/////////////////////////////////////////////////////////////////////////
		///TIStoneUserNameTypeһû
		/////////////////////////////////////////////////////////////////////////
		typedef char TIStoneUserNameType[31];

		/////////////////////////////////////////////////////////////////////////
		///TIStonePasswordTypeһ
		/////////////////////////////////////////////////////////////////////////
		typedef char TIStonePasswordType[41];

		/////////////////////////////////////////////////////////////////////////
		///TIStoneAbstractTypeһϢժҪ
		/////////////////////////////////////////////////////////////////////////
		typedef char TIStoneAbstractType[81];

		/////////////////////////////////////////////////////////////////////////
		///TIStoneComeFromTypeһϢԴ
		/////////////////////////////////////////////////////////////////////////
		typedef char TIStoneComeFromType[21];

		/////////////////////////////////////////////////////////////////////////
		///TIStoneContentTypeһϢ
		/////////////////////////////////////////////////////////////////////////
		typedef char TIStoneContentType[501];

		/////////////////////////////////////////////////////////////////////////
		///TIStoneURLLinkTypeһWEBַ
		/////////////////////////////////////////////////////////////////////////
		typedef char TIStoneURLLinkType[201];

		/////////////////////////////////////////////////////////////////////////
		///TIStoneProductInfoTypeһƷϢ
		/////////////////////////////////////////////////////////////////////////
		typedef char TIStoneProductInfoType[41];

		/////////////////////////////////////////////////////////////////////////
		///TIStoneProtocolInfoTypeһЭϢ
		/////////////////////////////////////////////////////////////////////////
		typedef char TIStoneProtocolInfoType[41];

		/////////////////////////////////////////////////////////////////////////
		///TIStoneBusinessUnitTypeһҵԪ
		/////////////////////////////////////////////////////////////////////////
		typedef char TIStoneBusinessUnitType[21];

		/////////////////////////////////////////////////////////////////////////
		///TIStoneTradingSystemNameTypeһϵͳ
		/////////////////////////////////////////////////////////////////////////
		typedef char TIStoneTradingSystemNameType[61];

		/////////////////////////////////////////////////////////////////////////
		///TIStoneBrokerIDTypeһ͹˾
		/////////////////////////////////////////////////////////////////////////
		typedef char TIStoneBrokerIDType[11];

		/////////////////////////////////////////////////////////////////////////
		///TIStoneCustomTypeһûԶ
		/////////////////////////////////////////////////////////////////////////
		typedef char TIStoneCustomType[65];

		/////////////////////////////////////////////////////////////////////////
		///TIStoneTradingDayTypeһ
		/////////////////////////////////////////////////////////////////////////
		typedef char TIStoneTradingDayType[9];

		/////////////////////////////////////////////////////////////////////////
		///TIStoneDepartmentTypeһӪҵ
		/////////////////////////////////////////////////////////////////////////
		typedef char TIStoneDepartmentType[41];

		/////////////////////////////////////////////////////////////////////////
		///TIStoneGrantFuncSetTypeһȨܺ
		/////////////////////////////////////////////////////////////////////////
		typedef char TIStoneGrantFuncSetType[5];

		/////////////////////////////////////////////////////////////////////////
		///TIStoneProductIDTypeһƷֱ
		/////////////////////////////////////////////////////////////////////////
		typedef char TIStoneProductIDType[31];

		/////////////////////////////////////////////////////////////////////////
		///TIStoneAccountSeqNoTypeһʽˮ
		/////////////////////////////////////////////////////////////////////////
		typedef char TIStoneAccountSeqNoType[21];

		/////////////////////////////////////////////////////////////////////////
		///TIStoneSettlementGroupIDTypeһ
		/////////////////////////////////////////////////////////////////////////
		typedef char TIStoneSettlementGroupIDType[9];

		/////////////////////////////////////////////////////////////////////////
		///TIStoneBankIDTypeһд
		/////////////////////////////////////////////////////////////////////////
		typedef char TIStoneBankIDType[4];

		/////////////////////////////////////////////////////////////////////////
		///TIStoneBankBrchIDTypeһзĴ
		/////////////////////////////////////////////////////////////////////////
		typedef char TIStoneBankBrchIDType[5];

		/////////////////////////////////////////////////////////////////////////
		///TIStoneBankAccountTypeһ˺
		/////////////////////////////////////////////////////////////////////////
		typedef char TIStoneBankAccountType[41];

		/////////////////////////////////////////////////////////////////////////
		///TIStoneNameTypeһ
		/////////////////////////////////////////////////////////////////////////
		typedef char TIStoneNameType[101];

		/////////////////////////////////////////////////////////////////////////
		///TIStoneNameTypeһע
		/////////////////////////////////////////////////////////////////////////
		typedef char TIStoneCommentType[101];

		/////////////////////////////////////////////////////////////////////////
		///TIStoneTradeCodeTypeһҵ
		/////////////////////////////////////////////////////////////////////////
		typedef char TIStoneTradeCodeType[7];

		/////////////////////////////////////////////////////////////////////////
		///TIStoneSerialTypeһˮ
		/////////////////////////////////////////////////////////////////////////
		typedef char TIStoneSerialType[13];

		/////////////////////////////////////////////////////////////////////////
		///TIStoneDeviceIDTypeһ־
		/////////////////////////////////////////////////////////////////////////
		typedef char TIStoneDeviceIDType[3];

		/////////////////////////////////////////////////////////////////////////
		///TIStoneBankCodingForFutureTypeһڻ˾б
		/////////////////////////////////////////////////////////////////////////
		typedef char TIStoneBankCodingForFutureType[33];

		/////////////////////////////////////////////////////////////////////////
		///TIStoneErrorMsgTypeһϢ
		/////////////////////////////////////////////////////////////////////////
		typedef char TIStoneErrorMsgType[81];

		/////////////////////////////////////////////////////////////////////////
		///TIStoneMarketIDTypeһг
		/////////////////////////////////////////////////////////////////////////
		typedef char TIStoneMarketIDType[9];

		/////////////////////////////////////////////////////////////////////////
		///TIStoneNewsTypeTypeһ
		/////////////////////////////////////////////////////////////////////////
		typedef char TIStoneNewsTypeType[3];

		/////////////////////////////////////////////////////////////////////////
		///TIStoneNewsUrgencyTypeһ̶
		/////////////////////////////////////////////////////////////////////////
		typedef char TIStoneNewsUrgencyType;


		/////////////////////////////////////////////////////////////////////////
		///TIStoneInitPasswordTypeһ·ʼ
		/////////////////////////////////////////////////////////////////////////
		typedef char TIStoneInitPasswordType[21];

		/////////////////////////////////////////////////////////////////////////
		///TIStoneAuthSerialNoTypeһȨк
		/////////////////////////////////////////////////////////////////////////
		typedef char TIStoneAuthSerialNoType[21];

		/////////////////////////////////////////////////////////////////////////
		///TIStoneAuthCodeTypeһȨ
		/////////////////////////////////////////////////////////////////////////
		typedef char TIStoneAuthCodeType[21];
	}
}
