#pragma once
#include "IStoneMdApiStruct.h"

#if defined(ISLIB) && defined(WIN32)
#ifdef LIB_MD_API_EXPORT
#define MD_API_EXPORT __declspec(dllexport)
#else
#define MD_API_EXPORT __declspec(dllimport)
#endif
#else
#define MD_API_EXPORT 
#endif

using namespace istone::mdapi;
namespace istone
{
	namespace mdapi
	{
		class IStoneMdSpi
		{
		public:
			///ͻ뽻׺̨ͨʱδ¼ǰ÷á
			virtual void OnFrontConnected() {};

			///ͻ뽻׺̨ͨӶϿʱ÷áAPIԶӣͻ˿ɲ
			///@param nReason ԭ
			///        0x1001 ʧ
			///        0x1002 дʧ
			///        0x2001 ʱ
			///        0x2002 ʧ
			///        0x2003 յ
			virtual void OnFrontDisconnected(int nReason) {};

			///ʱ档ʱδյʱ÷á
			///@param nTimeLapse ϴνձĵʱ
			virtual void OnHeartBeatWarning(int nTimeLapse) {};

			///Ӧ
			virtual void OnRspError(CIStoneRspInfo* pRspInfo, int nRequestID, bool bIsLast) {};

			///û¼Ӧ
			///@param pRspUserLogout	¼ɹʱظϢ
			///@param pRspInfo			¼ɹʱpRspInfoΪգ¼ʧʱpRspInfoشϢ
			virtual void OnRspUserLogin(CIStoneRspUserLogin* pRspUserLogin, CIStoneRspInfo* pRspInfo, int nRequestID, bool bIsLast) {};

			///û˳Ӧ
			///@param pRspUserLogout	˳ɹʱظϢ
			///@param pRspInfo			˳ɹʱpRspInfoΪգ˳ʧʱpRspInfoشϢ
			virtual void OnRspUserLogout(CIStoneRspUserLogout* pRspUserLogout, CIStoneRspInfo* pRspInfo, int nRequestID, bool bIsLast) {};

			///ûȫӦ
			///@param tickType						Ʊ, ͶĿʹ ISTONE_TICKER_TYPE_SPOT | ISTONE_TICKER_TYPE_INDEX ʽġ
			///        ISTONE_TICKER_TYPE_SPOT		<ͨƱ<ծȯ<
			///        ISTONE_TICKER_TYPE_INDEX		<ָ
			///        ISTONE_TICKER_TYPE_OPTION	<Ȩ
			///@param exchangeType					ͣ ཻʹ ISTONE_EXCHANGE_SH | ISTONE_EXCHANGE_SZ ʽġ
			///        ISTONE_EXCHANGE_SH			<֤
			///        ISTONE_EXCHANGE_SZ			<֤
			virtual void OnRspSubAllMarketData(int tickType, int exchangeID, int nRequestID, bool isSuccess) {};

			///ûȫ˶Ӧ
			///@param tickType						Ʊ, ͶĿʹ ISTONE_TICKER_TYPE_SPOT | ISTONE_TICKER_TYPE_INDEX ʽġ
			///        ISTONE_TICKER_TYPE_SPOT		<ͨƱ<ծȯ<
			///        ISTONE_TICKER_TYPE_INDEX		<ָ
			///        ISTONE_TICKER_TYPE_OPTION	<Ȩ
			///@param exchangeType					ͣ ཻʹ ISTONE_EXCHANGE_SH | ISTONE_EXCHANGE_SZ ʽġ
			///        ISTONE_EXCHANGE_SH			<֤
			///        ISTONE_EXCHANGE_SZ			<֤
			virtual void OnRspUnSubAllMarketData(int tickType, int exchangeID, int nRequestID, bool isSuccess) {};

			///ûȫӦ
			///@param tickType						Ʊ, ͶĿʹ ISTONE_TICKER_TYPE_SPOT | ISTONE_TICKER_TYPE_INDEX ʽġ
			///        ISTONE_TICKER_TYPE_SPOT		<ͨƱ<ծȯ<
			///        ISTONE_TICKER_TYPE_INDEX		<ָ
			///        ISTONE_TICKER_TYPE_OPTION	<Ȩ
			///@param exchangeType					ͣ ཻʹ ISTONE_EXCHANGE_SH | ISTONE_EXCHANGE_SZ ʽġ
			///        ISTONE_EXCHANGE_SH			<֤
			///        ISTONE_EXCHANGE_SZ			<֤
			virtual void OnRspSubAllTickByTick(int exchangeID, int nRequestID, bool isSuccess) {};

			///ûȫ˶Ӧ
			///@param tickType						Ʊ, ͶĿʹ ISTONE_TICKER_TYPE_SPOT | ISTONE_TICKER_TYPE_INDEX ʽġ
			///        ISTONE_TICKER_TYPE_SPOT		<ͨƱ<ծȯ<
			///        ISTONE_TICKER_TYPE_INDEX		<ָ
			///        ISTONE_TICKER_TYPE_OPTION	<Ȩ
			///@param exchangeType					ͣ ཻʹ ISTONE_EXCHANGE_SH | ISTONE_EXCHANGE_SZ ʽġ
			///        ISTONE_EXCHANGE_SH			<֤
			///        ISTONE_EXCHANGE_SZ			<֤
			virtual void OnRspUnSubAllTickByTick(int exchangeID, int nRequestID, bool isSuccess) {};

			///û鶩Ӧ
			///@param ppInstrumentID	Ʊ
			///@param nCount			Ʊ
			virtual void OnRspSubMarketData(char* tickers[], int count, int nRequestID, bool bIsSuccess) {};

			///û˶Ӧ
			///@param ppInstrumentID	Ʊ
			///@param nCount			Ʊ
			virtual void OnRspUnSubMarketData(char* tickers[], int count, int nRequestID, bool bIsSuccess) {};

			///û鶩Ӧ
			///@param ppInstrumentID	Ʊ
			///@param nCount			Ʊ
			virtual void OnRspSubTickByTick(char* tickers[], int count, int nRequestID, bool bIsSuccess) {};

			///û˶Ӧ
			///@param ppInstrumentID	Ʊ
			///@param nCount			Ʊ
			virtual void OnRspUnSubTickByTick(char* tickers[], int count, int nRequestID, bool bIsSuccess) {};

			///֪ͨ
			virtual void OnRtnDepthMarketData(CIStoneDepthMarketData* data) {};

			///֪ͨ
			virtual void OnRtnTickByTick(CIStoneTickByTick* data) {};

			///֪ͨ
			virtual void OnRtnOrderBook(CIStoneOrderBook* data) {};

			///ûӦ
			///@param ppInstrumentID	Ʊ
			///@param nCount			Ʊ
			virtual void OnRspSubOrderBook(char* tickers[], int count, int nRequestID, bool bIsSuccess) {};

			///û˶Ӧ
			///@param ppInstrumentID	Ʊ
			///@param nCount			Ʊ
			virtual void OnRspUnSubOrderBook(char* tickers[], int count, int nRequestID, bool bIsSuccess) {};
		};

		class MD_API_EXPORT IStoneMdApi
		{
		public:
			///MduserApi
			///@param pszFlowPath ϢļĿ¼ĬΪǰĿ¼
			///@return UserApi
			static IStoneMdApi* CreateMdUserApi(const char* pszFlowPath = "");

			///ȡAPIİ汾Ϣ
			///@retrun ȡİ汾
			static const char* GetVersion();

			///ɾӿڶ
			///@remark ʹñӿڶʱ,øúɾӿڶ
			virtual void Release() = 0;

			///ʼ
			///@remark ʼл,ֻеú,ӿڲſʼ
			virtual int Init() = 0;

			///ȴӿ߳̽
			///@return ߳˳
			virtual int Join() = 0;

			///ȡǰ
			///@retrun ȡĽ
			///@remark ֻе¼ɹ,ܵõȷĽ
			virtual const char* GetTradingDay() = 0;

			///עǰûַ
			///@param pszFrontAddressǰûַ
			///@remark ַĸʽΪprotocol://ipaddress:port磺tcp://127.0.0.1:17001 
			///@remark tcpЭ飬127.0.0.1ַ17001˿ںš
			virtual void RegisterFront(const char* pszFrontAddress) = 0;

			///ע鲥ַ
			///@param pMutilcastAddr鲥ַ
			///@remark ַĸʽΪprotocol://ipaddress:port磺udp://224.0.0.1:17002 
			///@remark udpЭ飬224.0.0.1鲥ַ17001鲥˿ں
			virtual void RegisterFpgaFront(const char* pMutilcastAddr) = 0;

			///עǰõıصַ
			///@param localTcpAddrǰõıַʱϵͳԶʶ
			///@remark ַĸʽΪprotocol://ipaddress:port磺tcp://127.0.0.1:17001 
			///@remark tcpЭ飬127.0.0.1ַ17001˿ںš
			virtual void RegisterTcpLocalAddr(const char* localTcpAddr) = 0;

			///ע鲥ıصַ
			///@param localAddr鲥ıַʱϵͳԶʶ
			///@remark ַĸʽΪipaddress磺127.0.0.1 
			///@remark 127.0.0.1鲥ıַ
			virtual void RegisterUdpLocalAddr(const char* localAddr) = 0;

			///עʹefviudp豸
			///@param device豸 "ens1"
			virtual void RegisterEfviDevice(const char* device) = 0;

			///עصӿ
			///@param pSpi Իصӿʵ
			virtual void RegisterSpi(IStoneMdSpi* pSpi) = 0;

			///ʱʱ䡣
			///@param timeout ʱʱ(),Сʱʱ䲻С10  
			virtual void SetHeartbeatTimeout(uint32_t timeout) = 0;

			///û¼
			///@param pReqUserLogin ¼Ϣ, UserID  Password ΪֶΣδѡֶ 
			virtual int ReqUserLogin(CIStoneReqUserLogin* pReqUserLogin, int nRequestID) = 0;

			///û˳
			///@param pReqUserLogin ˳Ϣ, UserID ΪֶΣδѡֶ 
			virtual int ReqUserLogout(CIStoneReqUserLogout* pReqUserLogout, int nRequestID) = 0;

			///ĹƱ
			///@param tickType						Ʊ, ͶĿʹ ISTONE_TICKER_TYPE_SPOT | ISTONE_TICKER_TYPE_INDEX ʽġ
			///        ISTONE_TICKER_TYPE_SPOT		<ͨƱ<ծȯ<
			///        ISTONE_TICKER_TYPE_INDEX		<ָ
			///        ISTONE_TICKER_TYPE_OPTION	<Ȩ
			///@param exchangeType					ͣ ཻʹ ISTONE_EXCHANGE_SH | ISTONE_EXCHANGE_SZ ʽġ
			///        ISTONE_EXCHANGE_SH			<֤
			///        ISTONE_EXCHANGE_SZ			<֤
			virtual int SubAllMarketData(int tickType, int exchangeID, int nRequestID) = 0;

			///˶Ʊ
			///@param tickType						Ʊ, ͶĿʹ ISTONE_TICKER_TYPE_SPOT | ISTONE_TICKER_TYPE_INDEX ʽġ
			///        ISTONE_TICKER_TYPE_SPOT		<ͨƱ<ծȯ<
			///        ISTONE_TICKER_TYPE_INDEX		<ָ
			///        ISTONE_TICKER_TYPE_OPTION	<Ȩ
			///@param exchangeType					ͣ ཻʹ ISTONE_EXCHANGE_SH | ISTONE_EXCHANGE_SZ ʽġ
			///        ISTONE_EXCHANGE_SH			<֤
			///        ISTONE_EXCHANGE_SZ			<֤
			virtual int UnSubAllMarketData(int tickType, int exchangeID, int nRequestID) = 0;

			///ĹƱ
			///@param tickType						Ʊ, ͶĿʹ ISTONE_TICKER_TYPE_SPOT | ISTONE_TICKER_TYPE_INDEX ʽġ
			///        ISTONE_TICKER_TYPE_SPOT		<ͨƱ<ծȯ<
			///        ISTONE_TICKER_TYPE_INDEX		<ָ
			///        ISTONE_TICKER_TYPE_OPTION	<Ȩ
			///@param exchangeType					ͣ ཻʹ ISTONE_EXCHANGE_SH | ISTONE_EXCHANGE_SZ ʽġ
			///        ISTONE_EXCHANGE_SH			<֤
			///        ISTONE_EXCHANGE_SZ			<֤
			virtual int SubAllTickByTick(int exchangeID, int nRequestID) = 0;

			///˶Ʊ
			///@param tickType						Ʊ, ͶĿʹ ISTONE_TICKER_TYPE_SPOT | ISTONE_TICKER_TYPE_INDEX ʽġ
			///        ISTONE_TICKER_TYPE_SPOT		<ͨƱ<ծȯ<
			///        ISTONE_TICKER_TYPE_INDEX		<ָ
			///        ISTONE_TICKER_TYPE_OPTION	<Ȩ
			///@param exchangeType					ͣ ཻʹ ISTONE_EXCHANGE_SH | ISTONE_EXCHANGE_SZ ʽġ
			///        ISTONE_EXCHANGE_SH			<֤
			///        ISTONE_EXCHANGE_SZ			<֤
			virtual int UnSubAllTickByTick(int exchangeID, int nRequestID) = 0;

			///ĺԼ
			///@param ppInstrumentID	Ʊ
			///@param nCount			Ʊ
			virtual int SubMarketData(char* ppInstrumentID[], int nCount, int nRequestID) = 0;

			///˶Լ
			///@param ppInstrumentID	Ʊ
			///@param nCount			Ʊ
			virtual int UnSubMarketData(char* ppInstrumentID[], int nCount, int nRequestID) = 0;

			///ĺԼ
			///@param ppInstrumentID	Ʊ
			///@param nCount			Ʊ
			virtual int SubTickByTick(char* ppInstrumentID[], int nCount, int nRequestID) = 0;

			///˶Լ
			///@param ppInstrumentID	Ʊ
			///@param nCount			Ʊ
			virtual int UnSubTickByTick(char* ppInstrumentID[], int nCount, int nRequestID) = 0;

			///йƱ
			///@param exchangeID ID,Ŀǰ֧   1֤  2֤
			virtual int SubAllOrderBook(int exchangeID, int nRequestID) = 0;

			///˶йƱ
			///@param exchangeID ID,Ŀǰ֧   1֤  2֤
			virtual int UnSubAllOrderBook(int exchangeID, int nRequestID) = 0;

			///Ķ
			///@param ppInstrumentID	Ʊ
			///@param nCount			Ʊ
			virtual int SubOrderBook(char* ppInstrumentID[], int nCount, int nRequestID) = 0;

			///˶
			///@param ppInstrumentID	Ʊ
			///@param nCount			Ʊ
			virtual int UnSubOrderBook(char* ppInstrumentID[], int nCount, int nRequestID) = 0;

		protected:
			~IStoneMdApi() {};
		};
	}
}
