#pragma once
#include "IStoneApiDataType.h"

namespace istone
{
	namespace mdapi
	{
		///û¼
		struct CIStoneReqUserLogin
		{
			char	TradingDay[ISTONE_TRADING_DAY_LEN];		//
			char	UserID[ISTONE_USERID_LEN];				//û
			char	Password[ISTONE_USER_PW_LEN];			//
			char	UserProductInfo[41];					//û˲ƷϢ
			char	IPAddress[30];							//IPַ
			char	MacAddress[30];							//Macַ
		};

		///û¼Ӧ
		struct CIStoneRspUserLogin
		{
			char	TradingDay[ISTONE_TRADING_DAY_LEN];		//
			char	UserID[ISTONE_USERID_LEN];				//û
			int		MaxUserOrderLocalID;					//û󱾵ر
			char	LoginTime[ISTONE_TIMESTAMP_LEN];		//¼ɹʱ
			ISTONE_USERS_TYPE    userType;                  //û
		};

		///ûǳ
		struct CIStoneReqUserLogout
		{
			char	UserID[ISTONE_USERID_LEN];				//û
		};

		///ûǳӦ
		struct CIStoneRspUserLogout
		{
			char	UserID[ISTONE_USERID_LEN];				//û
		};

		///ûĿӦ
		struct CIStoneSubParams
		{
			int TickType;					//Ʊ
			int ExchangeType;				//
		};

		///ûӦ
		struct CIStoneRspSubTickByTick 
		{
			int16_t SubAllFlag;								//ȫ
			ISTONE_EXCHANGE_TYPE ExchangeID;				// 
			char	Ticker[ISTONE_TICKER_LEN];				//Լ
		};
		///ûӦ
		struct CIStoneRspUnSubTickByTick
		{
			int16_t UnSubAllFlag;								//ȫ
			ISTONE_EXCHANGE_TYPE ExchangeID;				// 
			char	Ticker[ISTONE_TICKER_LEN];				//Լ		
		};


		///ӦϢ
		struct CIStoneRspInfo
		{
			int	Tid;										//ҵID
			int	ErrorID;									//
			TIStoneErrorMsgType	ErrorMsg;					//Ϣ
		};

		enum ISTONE_MARKETDATA_TYPE 
		{
			ISTONE_MARKETDATA_ACTUAL = 0,					// ֻ(Ʊ//ծȯ)
			ISTONE_MARKETDATA_OPTION = 1,					// Ȩ
		};

		///ʵʱѯ
		struct CIStoneQryMarketData
		{
			ISTONE_EXCHANGE_TYPE	ExchangeID;		//
			char	Ticker[ISTONE_TICKER_LEN];		//Լ
		};

		struct CIStoneSpecificTicker
		{
			ISTONE_EXCHANGE_TYPE ExchangeID;				// 
			char	Ticker[ISTONE_TICKER_LEN];				//Լ
		};

		///Ʊծȯȶ
		struct CIStoneMarketDataStockExData 
		{
			///ί(SH,SZ)
			int64_t TotalBidQty;
			///ί(SH,SZ)
			int64_t TotalAskQty;
			///Ȩƽί۸(SH,SZ)
			double MaBidPrice;
			///Ȩƽί۸(SH,SZ)
			double MaAskPrice;
			///ծȯȨƽί۸(SH)
			double MaBondBidPrice;
			///ծȯȨƽί۸(SH)
			double MaBondAskPrice;
			///ծȯ(SH)
			double YieldToMaturity;
			///ʵʱοֵ(SH,SZ)
			double Iopv;
			///ETF깺(SH)
			int32_t EtfBuyCount;
			///ETFر(SH)
			int32_t EtfSellCount;
			///ETF깺(SH)
			double EtfBuyQty;
			///ETF깺(SH)
			double EtfBuyMoney;
			///ETF(SH)
			double EtfSellQty;
			///ETFؽ(SH)
			double EtfSellMoney;
			///Ȩִ֤е(SH)
			double TotalWarrantExecQty;
			///Ȩ֤ͣ۸Ԫ(SH)
			double WarrantLowerPrice;
			///Ȩ֤ͣ۸Ԫ(SH)
			double WarrantUpperPrice;
			///볷(SH)
			int32_t CancelBuyCount;
			///(SH)
			int32_t CancelSellCount;
			///볷(SH)
			double CancelBuyQty;
			///(SH)
			double CancelSellQty;
			///볷(SH)
			double CancelBuyMoney;
			///(SH)
			double CancelSellMoney;
			///ܱ(SH)
			int64_t TotalBuyCount;
			///ܱ(SH)
			int64_t TotalSellCount;
			///ίгɽȴʱ(SH)
			int32_t DurationAfterBuy;
			///ίгɽȴʱ(SH)
			int32_t DurationAfterSell;
			///ίмλ(SH)
			int32_t NumBidOrders;
			///ίмλ(SH)
			int32_t NumAskOrders;

			///T-1վֵ(SZ)
			double PreIopv;
			///Ԥ
			int64_t R1;
			///Ԥ
			int64_t R2;
		};

		// Ȩ
		struct CIStoneMarketDataOptionExData 
		{
			///жϲο(SH)
			double  AuctionPrice;
			///жϼϾƥ(SH)
			int64_t AuctionQty;
			///ѯʱ(SH)
			int64_t LastEnquiryTime;
		};

		///һ50ί
		struct CIStoneTickerBid1
		{
			uint32_t			Bid1NumOfOrders;			// һλίб
			uint8_t				Bid1NoOrders;				// һλʾίб
			uint32_t			Bid1Orders[50];				// һ50ί
			uint32_t			Ask1NumOfOrders;			// һλίб
			uint8_t				Ask1NoOrders;				// һλʾίб
			uint32_t			Ask1Orders[50];				// һ50ί
		};

		///
		struct CIStoneDepthMarketData
		{
			//
			ISTONE_EXCHANGE_TYPE ExchangeID;
			/// Լ
			ISTONE_TICKER_TYPE TickerType;
			///Լ루Ϣո'\0'β
			char	Ticker[ISTONE_TICKER_LEN];

			///¼
			double	LastPrice;
			///
			double	PreClosePrice;
			///
			double	OpenPrice;
			///߼
			double	HighestPrice;
			///ͼ
			double	LowestPrice;
			///
			double	ClosePrice;

			// Ȩ
			///ճֲ()(Ŀǰδд)
			int64_t PreOpenInterest;
			///ֲ()
			int64_t	OpenInterest;
			///ս
			double	PreSettlementPrice;
			///ս
			double	SettlementPrice;

			///ʵ
			double	PreDelta;
			///ʵ
			double	CurrDelta;
			///ͣ
			double	UpperLimitPrice;
			///ͣ
			double	LowerLimitPrice;

			/// ʱ࣬ʽΪYYYYMMDDHHMMSSsss
			int64_t DateTime;

			// 
			///Ϊܳɽλɣ뽻һ£
			int64_t		Qty;
			///ɽΪܳɽλԪ뽻һ£
			double	Turnover;
			///վ=(turnover/qty)
			double	AvgPrice;

			// 
			///ʮ
			double Bid[10];
			///ʮ
			double	Ask[10];
			///ʮ
			int64_t	BidQty[10];
			///ʮ
			int64_t	AskQty[10];
			///ɽ
			int64_t TradesCount;
			///ǰ״̬˵
			char TickerStatus[8];

			//һ50ί
			CIStoneTickerBid1 tickBid1;

			///union
			ISTONE_MARKETDATA_TYPE DataType;
			// 
			///
			union {
				CIStoneMarketDataStockExData  Stk;
				CIStoneMarketDataOptionExData Opt;
			};
			///Ԥ
			int32_t R4;
		};

		///Ʊ龲̬Ϣ
		struct CIStoneQuoteStaticInfo 
		{
			///
			ISTONE_EXCHANGE_TYPE ExchangeID;
			///Լ루Ϣո'\0'β
			char    Ticker[ISTONE_TICKER_LEN];
			/// Լ
			char    TickerName[ISTONE_TICKER_NAME_LEN];
			/// Լ
			ISTONE_TICKER_TYPE TickerType;
			///
			double  PreClosePrice;
			///ͣ
			double  UpperLimitPrice;
			///ͣ
			double  LowerLimitPrice;
			///С䶯λ
			double  PriceTick;
			/// ԼС()
			int32_t  BuyQtyUnit;
			/// ԼС()
			int32_t SellQtyUnit;
		};


		///
		struct CIStoneOrderBook 
		{
			///
			ISTONE_EXCHANGE_TYPE ExchangeID;
			///Լ루Ϣո'\0'β
			char    Ticker[ISTONE_TICKER_LEN];

			///¼
			double LastPrice;
			///Ϊܳɽ
			int64_t Qty;
			///ɽΪܳɽ
			double  Turnover;
			///ɽ
			int64_t TradesCount;

			// 
			///ʮ
			double Bid[10];
			///ʮ
			double  Ask[10];
			///ʮ
			int64_t BidQty[10];
			///ʮ
			int64_t AskQty[10];
			/// ʱ
			int64_t DataTime;

			///ʮӦк
			string bidSeq[10];
			string askSeq[10];
		};

		////////////////////////////////// 


		///ί()
		struct CIStoneTickByTickEntrust 
		{
			///Ƶ
			int32_t ChannalNo;
			///ί(ͬһchannel_noΨһ1ʼ)
			int64_t Seq;
			///ίм۸
			double  Price;
			///ί
			int64_t Qty;
			///'1':; '2':; 'G':; 'F':
			char  Side;
			///: '1': м; '2': ޼; 'U': 
			char OrdType;
		};

		///ʳɽ
		struct CIStoneTickByTickTrade 
		{
			///Ƶ
			int32_t ChannalNo;
			///ί(ͬһchannel_noΨһ1ʼ)
			int64_t Seq;
			///ɽ۸
			double Price;
			///ɽ
			int64_t Qty;
			///ɽ(Ͻ)
			double Money;
			///򷽶
			int64_t BidNo;
			///
			int64_t AskNo;
			/// SH: ̱ʶ('B':; 'S':; 'N':δ֪)
			/// SZ: ɽʶ('4':; 'F':ɽ)
			char TradeFlag;
		};

		///Ϣ
		struct CIStoneTickByTick 
		{
			///
			ISTONE_EXCHANGE_TYPE ExchangeID;
			///Լ루Ϣո'\0'β
			char Ticker[ISTONE_TICKER_LEN];
			///Ԥ
			int64_t Seq;
			///ίʱ or ɽʱ
			int64_t DataTime;
			///ί or ɽ
			ISTONE_TBT_TYPE Type;

			union {
				CIStoneTickByTickEntrust Entrust;
				CIStoneTickByTickTrade   Trade;
			};
		};

		///ѯϢ
		struct CIStoneTickerPriceInfo 
		{
			///
			ISTONE_EXCHANGE_TYPE ExchangeID;
			///Լ루Ϣո'\0'β
			char Ticker[ISTONE_TICKER_LEN];
			///¼
			double LastPrice;
		};
	}
}
