#ifndef __KSGOLDTRADEAPI__H__
#define __KSGOLDTRADEAPI__H__

#ifdef KSGOLDTRADERAPI_EXPORTS
#define KSGOLDTRADERAPI_API __declspec(dllexport)
#else
#ifdef WIN32
#define KSGOLDTRADERAPI_API __declspec(dllimport)
#else 
#define KSGOLDTRADERAPI_API
#endif
#endif

#include "KSGoldUserApiStructEx.h"

namespace KSGoldTradeAPI
{

class CKSGoldTraderSpi
{
public:
	///ͻ뽻׺̨ͨʱ÷á
	///ֶʱҲô˷
	///@param nResult ؽ
	///        0x1001 
	///        0x1002 ɹ
	virtual void OnFrontConnected(int nResult) {};
	
	///ͻ뽻׺̨ͨӶϿʱ÷áAPIԶӣͻ˿ɲ
	///@param nReason ԭ
	///        0x1001 ʧ
	///        0x1002 дʧ
	///        0x2001 ʱ
	///        0x2002 ʧ
	///        0x2003 յ
	virtual void OnFrontDisconnected(int nReason) {};
	
	///¼Ӧ
	virtual void OnRspUserLogin(CThostFtdcRspUserLoginField *pRspUserLogin, CThostFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};
	
	///ǳӦ
	virtual void OnRspUserLogout(CThostFtdcUserLogoutField *pUserLogout, CThostFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};
	
	//г״̬֪ͨ
	virtual void OnNtyMktStatus(CThostFtdcMarketStatusField *pfldMktStatus){};
	
	///Լ״̬֪ͨ
	virtual void OnRtnInstrumentStatus(CThostFtdcInstrumentStatusField *pInstrumentStatus){};
	
	///ѯԼӦ
	virtual void OnRspQryInstrument(CThostFtdcInstrumentField *pInstrument, CThostFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};
	
	//ѯƷӦ
	virtual void OnRspReqQryVarietyCode(CThostFtdcRspVarietyCodeField *pVarietyCode, CThostFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///¼Ӧ
	virtual void OnRspOrderInsert(CThostFtdcRspInputOrderField *pRspInputOrder, CThostFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};
	
	///ETFϹӦ
	virtual void OnRspETFSubscriptionOrderInsert(CThostFtdcETFTradeDetailField *pETFSubscriptionOrderInsert, CThostFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast){};

	///ETF깺Ӧ
	virtual void OnRspETFPurchaseOrderInsert(CThostFtdcETFTradeDetailField *pETFSubscriptionOrderInsert, CThostFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast){};

	///ETFӦ
	virtual void OnRspETFRedeemInsert(CThostFtdcETFTradeDetailField *pETFSubscriptionOrderInsert, CThostFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast){};

	///ETF˻Ӧ
	virtual void OnRspETFAccountBinding(CThostFtdcETFBindingStatusField *pETFAccountBinding, CThostFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast){};

	///ETF˻Ӧ
	virtual void OnRspETFAccountUnbinding(CThostFtdcETFBindingStatusField *pETFAccountUnbinding, CThostFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast){};

	///֪ͨ
	virtual void OnRtnOrder(CThostFtdcOrderField *pOrder) {};
	
	///ǿ֪ͨ
	virtual void OnForceLogout(CThostFtdcUserLogoutField *pLogout) {};

	//ETF˻󶨽״̬֪ͨ
	virtual void OnRtnETFAccountBindingStatus(CThostFtdcETFBindingStatusField * pETFBindgingStatus) {};

	//ETF걨״̬֪ͨ
	virtual void OnRtnETFOrder(CThostFtdcETFTradeDetailField *pEtfTradeDetail){};
	
	///Ӧ
	virtual void OnRspOrderAction(CThostFtdcRspInputOrderActionField *pRspInputOrderAction, CThostFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///Ӧ
	virtual void OnRspError(CThostFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///ɽ֪ͨ
	virtual void OnRtnTrade(CThostFtdcTradeField *pTrade) {};
	
	///ѯʽ˻Ӧ
	virtual void OnRspQryTradingAccount(CThostFtdcTradingAccountField *pTradingAccount, CThostFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};
	
	///ʷʽѯ
	virtual void OnRspQryHisCapital(CThostFtdcRspHisCapitalField *pHisCapital, CThostFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///ѯӦ
	virtual void OnRspQryOrder(CThostFtdcOrderField *pOrder, CThostFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};
	
	///ѯɽӦ
	virtual void OnRspQryTrade(CThostFtdcTradeField *pTrade, CThostFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};
	
	///ѯͶֲ߳Ӧ
	virtual void OnRspQryInvestorPosition(CThostFtdcInvestorPositionField *pInvestorPosition, CThostFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};
	
	///ѯͻӦ
	virtual void OnRspQryClientStorage(CThostFtdcStorageField *pStorage, CThostFtdcRspInfoField *pRspInfo,int nRequestID,bool bIsLast){};
	
	///\֤ʲѯӦ
	virtual void OnRspQryCostMarginFeeRate(CThostFtdcRspCostMarginFeeField *pCostMarginFee, CThostFtdcRspInfoField *pRspInfo,int nRequestID, bool bIsLast){};
	
	///ίӦ
	virtual void OnRspConditionOrderInsert(CThostFtdcRspConditionOrderField *pConditionOrder, CThostFtdcRspInfoField *pRspInfo,int nRequestID, bool bIsLast){};
	
	///Ӧ
	virtual void OnRspConditionOrderAction(CThostFtdcRspConditionActionOrderField *pConditionActionOrder, CThostFtdcRspInfoField *pRspInfo,int nRequestID, bool bIsLast){};
	
	///ίвѯӦ
	virtual void OnRspQryConditionOrder(CThostFtdcRspConditionOrderQryField *pConditionOrderQry, CThostFtdcRspInfoField *pRspInfo,int nRequestID, bool bIsLast){};
	
	///ɽѯӦ
	virtual void OnRspQryConditionOrderTrade(CThostFtdcRspConditionOrderMatchField *pConditionOrderMatch, CThostFtdcRspInfoField *pRspInfo,int nRequestID, bool bIsLast){};

	///ͻỰϢͨòѯӦ
	virtual void OnRspQryClientSessionInfo(CThostFtdcRspClientSessionField *pClientSessionField, CThostFtdcRspInfoField *pRspInfo,int nRequestID, bool bIsLast){};

	///ѯϢӦ
	virtual void OnRspQryQuotation(CThostFtdcDepthMarketDataField *pDepthMarketData, CThostFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast){};	

	///ѯͶֲ߳ϸӦ
	virtual void OnRspQryInvestorPositionDetail(CThostFtdcInvestorPositionDetailField *pInvestorPositionDetail, CThostFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast){};

	///ETF꽻ײѯӦ
	virtual void OnRspQryETFradeDetail(CThostFtdcETFTradeDetailField *pQryETFTradeDetail, CThostFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast){};

	///ETF嵥ѯ
	virtual void OnRspQryETFPcfDetail(CThostFtdcETFPcfDetailField *pQryETFpcfDetail, CThostFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast){};

	///޸Ӧ
	virtual void OnRspModifyPassword(CThostFtdcModifyPasswordRsqField *pRsqModifyPassword,CThostFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast){};
	
	///гӦ
	virtual void OnRspB0CMoneyIO(CThostFtdcBOCMoneyIORspField *pRspBOCMoneyIO,CThostFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast){};


};

class KSGOLDTRADERAPI_API CKSGoldTraderApi
{
public:
	///TraderApi
	///@param pszFlowPath ļĿ¼ĬΪǰĿ¼
	///@return UserApi
	static CKSGoldTraderApi *CreateGoldTraderApi(const char *pszFlowPath = "");
	
	///ɾӿڶ
	///@remark ʹñӿڶʱ,øúɾӿڶ
	virtual void Release() = 0;
	
	///ʼ
	///@remark ʼл,ֻеú,ӿڲſʼ
	virtual bool Init() = 0;
	
	///עǰûַ
	///@param pszFrontAddressǰûַ
	///@remark ַĸʽΪprotocol://ipaddress:port磺tcp://127.0.0.1:17001 
	///@remark tcpЭ飬127.0.0.1ַ17001˿ںš
	virtual void RegisterFront(char *pszFrontAddress) = 0;
	
	///˽
	///@param nResumeType ˽شʽ  
	///        KS_TERT_RESTART: ӱտʼش
	///        KS_TERT_RESUME : ϴյ,ʱ
	///        KS_TERT_QUICK  : ֻ͵¼˽
	///@remark ÷ҪInitǰáĬKS_TERT_RESTART
	virtual void SubscribePrivateTopic(KS_TE_RESUME_TYPE nResumeType) = 0;

	///Ĺ
	///@param nResumeType شʽ  
	///        KS_TERT_RESTART: ӱտʼش
	///        KS_TERT_RESUME : ϴյ,ʱ
	///        KS_TERT_QUICK  : ֻ͵¼󹫹
	///@remark ÷ҪInitǰáĬKS_TERT_RESTART
	virtual void SubscribePublicTopic(KS_TE_RESUME_TYPE nResumeType) = 0;

	///עAPIصӿ
	///@param pGeneralSpi Իصӿʵ
	virtual void RegisterSpi(CKSGoldTraderSpi *pGeneralSpi) = 0;	
	
	///ȴӿ߳̽
	///@return ߳˳
	virtual int Join() = 0;
	
	///û¼
	virtual int ReqUserLogin(CThostFtdcReqUserLoginField *pReqUserLoginField, int nRequestID) = 0;
	
	///ûǳ
	virtual int ReqUserLogout(CThostFtdcUserLogoutField *pUserLogout, int nRequestID) = 0;
	
	///ѯԼ
	virtual int ReqQryInstrument(CThostFtdcQryInstrumentField *pQryInstrument, int nRequestID) = 0;

	///ѯƷ
	virtual int ReqQryVarietyCode(CThostFtdcQryVarietyCodeField *pQryVarietyCode, int nRequestID) = 0;
	
	///µ
	virtual int ReqOrderInsert(CThostFtdcInputOrderField *pInputOrder, int nRequestID) = 0;
	
	///()
	virtual int ReqOrderAction(CThostFtdcInputOrderActionField *pInputOrderAction, int nRequestID) = 0;
	
	///ѯֲ
	virtual int ReqQryInvestorPosition(CThostFtdcQryInvestorPositionField *pInvestorPosition, int nRequestID) = 0;
	
	///ѯʽ
	virtual int ReqQryTradingAccount(CThostFtdcQryTradingAccountField *pQryTradingAccount, int nRequestID) = 0;
	
	///ɽѯ
	virtual int ReqQryTrade(CThostFtdcQryTradeField *pQryTrade, int nRequestID) = 0;
	
	///ίвѯ
	virtual int ReqQryOrder(CThostFtdcQryOrderField *pQryOrder, int nRequestID) = 0;
	
	///ѯͻ
	virtual int ReqQryStorage(CThostFtdcQryStorageField *pfldStorage, int nRequestID) =0;
	
	//\֤ʲѯ
	virtual int ReqQryCostMarginFeeRate(CThostFtdcQryCostMarginFeeField *pQryCostMarginFee, int nRequestID) = 0;
	
	///ί
	virtual int ReqConditionOrderInsert(CThostFtdcConditionOrderField *pConditionOrder, int nRequestID) = 0;
	
	///
	virtual int ReqConditionOrderAction(CThostFtdcConditionActionOrderField *pConditionActionOrder, int nRequestID) = 0;
	
	///ίвѯ
	virtual int ReqQryConditionOrder(CThostFtdcConditionOrderQryField *pConditionOrderQry, int nRequestID) = 0;
	
	///ɽѯ
	virtual int ReqQryConditionOrderTrade(CThostFtdcConditionOrderMatchField *pConditionOrderMatch, int nRequestID) = 0;

	///ͻỰϢͨòѯ
	virtual int ReqQryClientSessionInfo(CThostFtdcQryClientSessionField *pQryClientSession, int nRequestID) = 0;
	
	///ѯϢ
	virtual int ReqQryQuotation(CThostFtdcQryQuotationField *pQryQuotation, int nRequestID) = 0;

	///ѯͶֲ߳ϸ
	virtual int ReqQryInvestorPositionDetail(CThostFtdcQryInvestorPositionDetailField *pQryInvestorPositionDetail, int nRequestID) = 0;

	///޸
	virtual int ReqModifyPassword(CThostFtdcModifyPasswordField *pModifyPasswordFieldl, int nRequestID) = 0;

    ///ѯͻʷʽ
	virtual int ReqQryHisCapital(CThostFtdcQryHisCapitalField *pQryHisCapital,int nRequestID) = 0;

	///ETFϹ
	virtual int ReqETFSubScription(CThostFtdcSubScriptionField *pEtfSubScription,int nRequestID) = 0;

    ///ETF깺
	virtual int ReqETFApplyForPurchase(CThostFtdcApplyForPurchaseField *pEtfApplyForPurchase,int nRequestID) = 0;

	///ETF
	virtual int ReqETFRedeem(CThostFtdcRedeemField *pETFRedeem,int nRequestID)=0;

	///ETF˻
	virtual int ReqETFAccountBinding(CThostFtdcETFBingingField *pETFAccountBinding,int nRequestID)=0;

	///ETF˻
	virtual int ReqETFAccountUnbinding(CThostFtdcETFUnBingingField *pETFAccountUnBinding,int nRequestID)=0;

	///ETF꽻ײѯ
	virtual int ReqETFTradeDetail(CThostFtdcQryETFTradeDetailField *pQryETFTradeDetail,int nRequestID) = 0;
 
	///ETF嵥ѯ
	virtual int ReqETFPcfDetail(CThostFtdcQryETFPcfDetailField *pQryETFPcfDetail,int nRequestID) = 0;

	///г
	virtual int ReqBOCMoneyIO(CThostFtdcBOCMoneyIOField *pBOCMoneyIO, int nRequestID) = 0;


	protected:
		~CKSGoldTraderApi();
};

}  //end of namespace KSGoldTradeAPI

#endif   //__KSGOLDTRADEAPI__H__




