/*************************
*ժҪϻڻϵͳ
*ļNhMdApi.h
*      ˿ͻ˽ӿ
*ߣϻڻ
*ʱ䣺20130604
**************************/

#ifndef __CNH_MD_API_H__
#define __CNH_MD_API_H__

#ifdef WIN32
#define MD_API_EXPORT __declspec(dllexport)
#else
#define MD_API_EXPORT
#endif

#include "NHUserApiStruct.h"
#include "NHUserApiErrCode.h"

class CNhMdSpi
{
public:
	///ͻؽͨʱδ¼ǰ÷á
	virtual void OnFrontConnected(){};
	
	///ͻͨӶϿʱ÷á
	virtual void OnFrontDisConnected(){};

	///ʱ档ʱδյʱ÷á
	/* \param nTimeLapse ϴνձĵʱ
	****************************************/
	virtual void OnHeartBeatWarning(int nTimeLapse){};

	/***************************************
	/* \fn    OnRspError
	/* \brief Ӧ
	/* \param ERRORMSGINFO_t & req,ӦϢ
	/* \param TSequenceIDType nRequestIDrequestĴΪӦIDΪ0
	/* \return void
	****************************************/
	virtual void OnRspError(ERRORMSGINFO_t &pRspInfo,TSequenceIDType nRequestID) {};

	///֪ͨ
	virtual void OnRtnMarketData(STKMarketData_t &pData) {};

	/***************************************
	/* \fn    OnRspUtpLogin
	/* \brief ¼ϻͳһƽ̨UTPʱӦ
	/* \param RspUtpLoginField_t & req
	/* \param TSequenceIDType nRequestID
	/* \return void
	****************************************/
	virtual void OnRspUtpLogin(const RspUtpLoginField_t& rsp,TSequenceIDType nRequestID){};
	
	/***************************************
	/* \fn    OnRspUtpLogout
	/* \brief ¼ϻͳһƽ̨UTPʱӦ
	/* \param RspUtpLogoutField_t & req
	/* \param TSequenceIDType nRequestID
	/* \return void
	****************************************/
	virtual void OnRspUtpLogout(const RspUtpLogoutField_t& rsp,TSequenceIDType nRequestID){};
	
	/***************************************
	/* \fn    OnRspSubscribe
	/* \brief ʱӦ
	/* \param RspSubscribeField_t & req
	/* \param TSequenceIDType nRequestID
	/* \return void
	****************************************/
	virtual void OnRspSubscribe(const RspSubscribeField_t& rsp,TSequenceIDType nRequestID){};
	
	/***************************************
	/* \fn    OnRspUnSubscribe
	/* \brief ȡʱӦ
	/* \param RspUnSubscribeField_t & req
	/* \param TSequenceIDType nRequestID
	/* \return void
	****************************************/
	virtual void OnRspUnSubscribe(const RspUnSubscribeField_t& rsp,TSequenceIDType nRequestID){};

	/***************************************
	* \fn    OnRspQryExchange
	* \brief ѯʱӦ
	* \param RspQryExchangeField_t & rsp
	* \param TSequenceIDType nRequestID
	* \return void
	****************************************/
	virtual void OnRspQryExchange(const RspQryExchangeField_t& rsp,TSequenceIDType nRequestID){};

	/***************************************
	* \fn    OnRspQryInstrument
	* \brief ѯԼʱӦ
	* \param RspQryInstrumentField_t & rsp
	* \param TSequenceIDType nRequestID
	* \return void
	****************************************/
	virtual void OnRspQryInstrument(const RspQryInstrumentField_t& rsp,TSequenceIDType nRequestID){};
};

class MD_API_EXPORT CNhMdApi
{
public:
	/***************************************
	/* \brief MdApi
	/* \return UserApi
	****************************************/
	static CNhMdApi *CreateMdApi();

	/***************************************
	/* \brief ɾӿڶ
	/* \remark ʹñӿڶʱ,øúɾӿڶ
	****************************************/
	virtual void Release() = 0;

	/***************************************
	/* \brief ʼ
	/* \remark ʼл,ֻеú,ӿڲſʼ
	****************************************/
	virtual void Init() = 0;

	/***************************************
	/* \brief ȡϵͳ汾
	/* \param nMajorVersion 汾
	/* \param nMinorVersion Ӱ汾
	/* \return ϵͳʶַ
	****************************************/
	virtual const char *GetVersion(int &nMajorVersion, int &nMinorVersion) = 0;

	/***************************************
	/* \brief עǰûַ
	/* \param pszFrontAddressǰûַ
	/* \remark ַĸʽΪprotocol://ipaddress:port磺tcp://127.0.0.1:17001 
	/* \remark tcpЭ飬127.0.0.1ַ17001˿ںš
	****************************************/
	virtual void RegisterFront(char *pszFrontAddress) = 0;

	/***************************************
	/* \brief עַַ(δʹ)
	/* \param pszNsAddressַַ
	/* \remark ַĸʽΪprotocol://ipaddress:port磺tcp://127.0.0.1:12001 
	/* \remark tcpЭ飬127.0.0.1ַ12001˿ںš
	/* \remark RegisterNameServerRegisterFront
	****************************************/
	virtual void RegisterNameServer(char *pszNsAddress) = 0;
	
	/***************************************
	/*עصӿ
	/* \param pSpi Իصӿʵ
	****************************************/
	virtual void RegisterSpi(CNhMdSpi *pSpi) = 0;

	/***************************************
	/* \brief ʱʱ䡣
	/* \param timeout ʱʱ()  
	****************************************/
	virtual void SetHeartbeatTimeout(unsigned int timeout) = 0;
	
	/***************************************
	/* \fn    UtpLoginRequest
	/* \brief ͵¼ϻͳһƽ̨UTP
	/* \param TSequenceIDType nRequestID 
	/* \return 0:ɹʧ,سɹֻͳɹ
	/*			 ڶӦصм
	****************************************/
	virtual int ReqUtpLogin(ReqUtpLoginField_t& req, TSequenceIDType nRequestID) = 0;

	/***************************************
	* \fn    UtpLogoutRequest
	* \brief ͵ǳϻͳһƽ̨UTP
	* \param TSequenceIDType nRequestID 
	* \return 0:ɹʧ,سɹֻͳɹ
	*			 ڶӦصм
	****************************************/
	virtual int ReqUtpLogout(TSequenceIDType nRequestID) = 0;

	/***************************************
	* \fn    SubscribeRequest
	* \brief Ͷ,ݶĳɹԺϿҪ¶
	* \ûɹlogoutԺϵͳԶȡеϢ
	* \param ReqSubscribeField_t & req
	* \param TSequenceIDType nRequestID 
	* \return 0:ɹʧ,سɹֻͳɹ
	*			 ڶӦصм
	****************************************/
	virtual int ReqSubscribe(ReqSubscribeField_t& req,TSequenceIDType nRequestID) = 0;

	/***************************************
	* \fn    UnSubscribeRequest
	* \brief ȡ
	* \param ReqUnSubscribeField_t & req
	* \param TSequenceIDType nRequestID 
	* \return 0:ɹʧ,سɹֻͳɹ
	*			 ڶӦصм
	****************************************/
	virtual int ReqUnSubscribe(ReqUnSubscribeField_t& req,TSequenceIDType nRequestID) = 0;

	/***************************************
	* \fn    AuthUserPassworRequest(÷ʱδ)
	* \brief û֤
	* \param ReqAuthUserPassworField_t & req
	* \param TSequenceIDType nRequestID 
	* \return 0:ɹʧ,سɹֻͳɹ
	*			 ڶӦصм
	****************************************/
	virtual int ReqAuthUserPasswor(ReqAuthUserPassworField_t& req,TSequenceIDType nRequestID) = 0;
		
	/***************************************
	* \fn    ReqQryExchange
	* \brief Ͳѯ
	* \param ReqQryExchangeField_t & req
	* \param TSequenceIDType nRequestID 
	* \return 0:ɹʧ,سɹֻͳɹ
	*			 ڶӦصм
	****************************************/
	virtual int ReqQryExchange(const ReqQryExchangeField_t& req,TSequenceIDType nRequestID) = 0;
	
	/***************************************
	* \fn    ReqQryInstrument
	* \brief ͲѯԼ
	* \param ReqQryInstrumentField_t & req
	* \param TSequenceIDType nRequestID 
	* \return 0:ɹʧ,سɹֻͳɹ
	*			 ڶӦصм
	****************************************/
	virtual int ReqQryInstrument(const ReqQryInstrumentField_t& req,TSequenceIDType nRequestID) = 0;
protected:
	~CNhMdApi();
};

#endif
