
#if !defined(NH_STOCKTRADERAPI_H)
#define NH_STOCKTRADERAPI_H

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "NhStockUserApiStruct.h"

#if defined(WIN32)
#ifdef LIB_TRADER_API_EXPORT
#define TRADER_API_EXPORT __declspec(dllexport)
#else
#define TRADER_API_EXPORT __declspec(dllimport)
#endif
#else
#define TRADER_API_EXPORT __attribute__ ((visibility("default")))
#endif

namespace nhtd
{
	class CNhStockTraderSpi
	{
	public:
		///ͻ뽻׺̨ͨʱδ¼ǰ÷á
		virtual void OnFrontConnected() {};

		///ͻ뽻׺̨ͨӶϿʱ÷áAPIԶӣͻ˿ɲ
		///@param nReason ԭ
		///        0x1001 ʧ
		///        0x1002 дʧ
		///        0x2001 ʱ
		///        0x2002 ʧ
		///        0x2003 յ
		virtual void OnFrontDisconnected(int nReason) {};

		///ʱ档ʱδյʱ÷á
		///@param nTimeLapse ϴνձĵʱ
		virtual void OnHeartBeatWarning(int nTimeLapse) {};

		///Ļصʼ֪ͨAPIյһĺȵñȻǸĻصǱĻص֪ͨ
		///@param nTopicID 루˽ȣ
		///@param nSequenceNo 
		virtual void OnPackageStart(int nTopicID, int nSequenceNo) {};

		///Ļص֪ͨAPIյһĺȵñĻصʼ֪ͨȻǸĻصñ
		///@param nTopicID 루˽ȣ
		///@param nSequenceNo 
		virtual void OnPackageEnd(int nTopicID, int nSequenceNo) {};

		///Ӧ
		virtual void OnRspSubscribeTopic(CStockFtdcDisseminationField *pDissemination, CStockFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

		///û¼Ӧ
		virtual void OnRspUserLogin(CStockFtdcRspUserLoginField *pRspUserLogin, CStockFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

		///û˳Ӧ
		virtual void OnRspUserLogout(CStockFtdcRspUserLogoutField *pRspUserLogout, CStockFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

		///û޸Ӧ
		virtual void OnRspUserPasswordUpdate(CStockFtdcUserPasswordUpdateField *pUserPasswordUpdate, CStockFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

		///ƱӦ
		virtual void OnRspStockInsert(CStockFtdcStockInsertRspField *pStockInsert, CStockFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

		///ƱӦ
		virtual void OnRspStockCancel(CStockFtdcStockCancelRspField *pStockCancel, CStockFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

		///ȨӦ
		virtual void OnRspOptionsInsert(CStockFtdcOptionsInsertRspField *pOptionsInsert, CStockFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

		///ȨӦ
		virtual void OnRspOptionsCancel(CStockFtdcOptionsCancelRspField *pOptionsCancel, CStockFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

		///ȨӦ
		virtual void OnRspQuoteInsert(CStockFtdcQuoteInsertRspField *pQuoteInsert, CStockFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

		///ȨӦ
		virtual void OnRspForQuote(CStockFtdcForQuoteRspField *pForQuote, CStockFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

		///ѯӦ
		virtual void OnRspQuoteCancel(CStockFtdcQuoteCancelRspField *pQuoteCancel, CStockFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

		///֤ȯӦ
		virtual void OnRspStockLock(CStockFtdcStockLockRspField *pStockLock, CStockFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

		///ȨӦ
		virtual void OnRspExercise(CStockFtdcExerciseRspField *pExercise, CStockFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

		///ȨӦ
		virtual void OnRspExerciseCancel(CStockFtdcExerciseCancelRspField *pExercise, CStockFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

		///ԱʽѯӦ
		virtual void OnRspQryPartAccount(CStockFtdcRspPartAccountField *pRspPartAccount, CStockFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

		///ƱѯӦ
		virtual void OnRspQryStockOrder(CStockFtdcRspQryStockOrderField *pOrder, CStockFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

		///ȨѯӦ
		virtual void OnRspQryOptionsOrder(CStockFtdcRspQryOptionsOrderField *pOrder, CStockFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

		///۲ѯӦ
		virtual void OnRspQryQuoteOrder(CStockFtdcRspQryQuoteOrderField *pQuote, CStockFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

		///ƱɽѯӦ
		virtual void OnRspQryStockTrade(CStockFtdcStockTradeField *pTrade, CStockFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

		///ȨɽѯӦ
		virtual void OnRspQryOptionsTrade(CStockFtdcOptionsTradeField *pTrade, CStockFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

		///ֲֲѯӦ
		virtual void OnRspQryPosition(CStockFtdcRspPositionField *pPosition, CStockFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

		///ѯӦ
		virtual void OnRspQryTopic(CStockFtdcDisseminationField *pDissemination, CStockFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

		//ƱѯӦ
		virtual void OnRspQryStock(CStockFtdcRspQryStockField *pStock, CStockFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

		//ȨѯӦ
		virtual void OnRspQryOptions(CStockFtdcRspQryOptionsField *pOptions, CStockFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

		///Ȩίлر
		virtual void OnRtnOptionsOrder(CStockFtdcOptionsOrderField *pOrder) {};

		///Ʊίлر
		virtual void OnRtnStockOrder(CStockFtdcStockOrderField *pOrder) {};

		///ۻر
		virtual void OnRtnQuoteOrder(CStockFtdcQuoteOrderField *pQuote) {};

		///Ȩɽر
		virtual void OnRtnOptionsTrade(CStockFtdcOptionsTradeField *pTrade) {};

		///Ʊɽر
		virtual void OnRtnStockTrade(CStockFtdcStockTradeField *pTrade) {};

		///Ȩر
		virtual void OnRtnExercise(CStockFtdcExerciseRtnField *pExercise) {};

		///ѯϢӦ
		virtual void OnRspQryRate(CStockFtdcRspQryRateField *pRate, CStockFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

		///ԱͻѯӦ
		virtual void OnRspQryClient(CStockFtdcRspClientField *pRspClient, CStockFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

		///ͻ֤ѯӦ
		virtual void OnRspQryClientMargin(CStockFtdcRspQryClientMarginField *pRspMargin, CStockFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

		///ѯȨӦ
		virtual void OnRspQryExercise(CStockFtdcExerciseRtnField *pExercise, CStockFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

		///֪ͨ
		virtual void OnRtnWithdrawDeposit(CStockFtdcWithdrawDepositRtnField *pWithdrawDeposit) {};

		///ͻ
		virtual void OnRspMarginCombAction(CStockFtdcMarginCombActionRspField *pMarginCombAction, CStockFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};
		
		///ͻ֪ͨ
		virtual void OnRtnMarginCombAction(CStockFtdcMarginCombActionRtnField *pMarginCombAction) {};

		///ϳֲֲѯӦ
		virtual void OnRspQrySseCombPosition(CStockFtdcCombPositionRspField *pPosi, CStockFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};
		
		///ȨӦ
		virtual void OnRspCombExercise(CStockFtdcCombExerciseRspField *pExercise, CStockFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};
	};

	class TRADER_API_EXPORT CNhStockTraderApi
	{
	public:
		///TraderApi
	///@param pszFlowPath ϢļĿ¼ĬΪд
	///@return UserApi
		static CNhStockTraderApi *CreateFtdcTraderApi(const char *pszFlowPath = "");

		///ȡϵͳ汾
		///@param nMajorVersion 汾
		///@param nMinorVersion Ӱ汾
		///@return ϵͳʶַ
		static const char *GetVersion(int &nMajorVersion, int &nMinorVersion);

		///ɾӿڶ
		///@remark ʹñӿڶʱ,øúɾӿڶ
		virtual void Release() = 0;

		///ʼ
		///@param localIpͨtcpdirectͽݣΪͽݵip
		///@param netWorkCardͨtcpdirectͽݣΪͽݵ
		///@remark ʼл,ֻеú,ӿڲſʼ
		virtual void Init(const char *localIp = "", const char *netWorkCard = "") = 0;

		///ȡǰ
		///@retrun ȡĽ
		///@remark ֻе¼ɹ,ܵõȷĽ
		virtual const char *GetTradingDay() = 0;

		///עǰûַ
		///@param pszFrontAddressǰûַ
		///@remark ַĸʽΪprotocol://ipaddress:port磺tcp://127.0.0.1:17001
		///@remark tcpЭ飬127.0.0.1ַ17001˿ںš
		virtual void RegisterFront(char *pszFrontAddress) = 0;

		///עصӿ
		///@param pSpi Իصӿʵ
		virtual void RegisterSpi(CNhStockTraderSpi *pSpi) = 0;

		///˽
		///@param nResumeType ˽شʽ
		///        TERT_RESTART:ӱտʼش
		///        TERT_RESUME:ϴյ
		///        TERT_QUICK:ֻ͵¼˽
		///@remark ÷ҪInitǰá򲻻յ˽ݡ
		virtual void SubscribePrivateTopic(SZSE_TE_RESUME_TYPE nResumeType) = 0;

		///Ĺ
		///@param nResumeType شʽ
		///        TERT_RESTART:ӱտʼش
		///        TERT_RESUME:ϴյ
		///        TERT_QUICK:ֻ͵¼󹫹
		///@remark ÷ҪInitǰá򲻻յݡ
		virtual void SubscribePublicTopic(SZSE_TE_RESUME_TYPE nResumeType) = 0;

		///ĽԱ
		///@param nResumeType Աشʽ
		///        TERT_RESTART:ӱտʼش
		///        TERT_RESUME:ϴյ
		///        TERT_QUICK:ֻ͵¼Ա
		///@remark ÷ҪInitǰá򲻻յԱݡ
		virtual void SubscribeUserTopic(SZSE_TE_RESUME_TYPE nResumeType) = 0;

		///ʱʱ䡣
		///@param timeout ʱʱ()
		virtual void SetHeartbeatTimeout(unsigned int timeout) = 0;

		///
		virtual int ReqSubscribeTopic(CStockFtdcDisseminationField *pDissemination, int nRequestID) = 0;

		///û¼
		virtual int ReqUserLogin(CStockFtdcReqUserLoginField *pReqUserLogin, int nRequestID) = 0;

		///û˳
		virtual int ReqUserLogout(CStockFtdcReqUserLogoutField *pReqUserLogout, int nRequestID) = 0;

		///û޸
		virtual int ReqUserPasswordUpdate(CStockFtdcUserPasswordUpdateField *pUserPasswordUpdate, int nRequestID) = 0;

		///Ʊ
		virtual int ReqStockInsert(CStockFtdcStockInsertReqField *pStockInsert, int nRequestID) = 0;

		///Ʊ
		virtual int ReqStockCancel(CStockFtdcStockCancelReqField *pStockCancel, int nRequestID) = 0;

		///֤ȯ
		virtual int ReqStockLock(CStockFtdcStockLockReqField *pStockLock, int nRequestID) = 0;

		///Ȩ
		virtual int ReqOptionsInsert(CStockFtdcOptionsInsertReqField *pOptionsInsert, int nRequestID) = 0;

		///Ȩ
		virtual int ReqOptionsCancel(CStockFtdcOptionsCancelReqField *pOptionsCancel, int nRequestID) = 0;

		///Ȩ
		virtual int ReqQuoteInsert(CStockFtdcQuoteInsertReqField *pQuoteInsert, int nRequestID) = 0;

		///Ȩ
		virtual int ReqQuoteCancel(CStockFtdcQuoteCancelReqField *pQuoteCancel, int nRequestID) = 0;

		///ѯ
		virtual int ReqForQuote(CStockFtdcForQuoteReqField *pForQuote, int nRequestID) = 0;

		///Ȩ
		virtual int ReqExercise(CStockFtdcExerciseReqField *pExercise, int nRequestID) = 0;

		///Ȩ
		virtual int ReqExerciseCancel(CStockFtdcExerciseCancelReqField *pExerciseCancel, int nRequestID) = 0;

		///ʽѯ
		virtual int ReqQryPartAccount(CStockFtdcQryPartAccountField *pQryPartAccount, int nRequestID) = 0;

		///Ʊѯ
		virtual int ReqQryStockOrder(CStockFtdcQryStockOrderField *pQryOrder, int nRequestID) = 0;

		///Ȩѯ
		virtual int ReqQryOptionsOrder(CStockFtdcQryOptionsOrderField *pQryOrder, int nRequestID) = 0;

		///۲ѯ
		virtual int ReqQryQuoteOrder(CStockFtdcQryQuoteOrderField *pQryQuote, int nRequestID) = 0;

		///Ʊɽѯ
		virtual int ReqQryStockTrade(CStockFtdcQryStockTradeField *pQryTrade, int nRequestID) = 0;

		///Ȩɽѯ
		virtual int ReqQryOptionsTrade(CStockFtdcQryOptionsTradeField *pQryTrade, int nRequestID) = 0;

		///ֲֲѯ
		virtual int ReqQryPosition(CStockFtdcQryPositionField *pQryPosition, int nRequestID) = 0;

		///ѯ
		virtual int ReqQryTopic(CStockFtdcDisseminationField *pDissemination, int nRequestID) = 0;

		//Ʊѯ
		virtual int ReqQryStock(CStockFtdcQryStockField *pStock, int nRequestID) = 0;

		//Ȩѯ
		virtual int ReqQryOptions(CStockFtdcQryOptionsField *pOptions, int nRequestID) = 0;

		///ѯϢӦ
		virtual int ReqQryRate(CStockFtdcQryRateField *pRate, int nRequestID) = 0;

		///Աͻѯ
		virtual int ReqQryClient(int nRequestID) = 0;

		///ѯ֤
		virtual int ReqQryClientMargin(CStockFtdcQryClientMarginField *pRate, int nRequestID) = 0;

		//Ȩѯ
		virtual int ReqQryExercise(CStockFtdcQryExerciseField *pExercise, int nRequestID) = 0;

		///ͻ
		virtual int ReqMarginCombAction(CStockFtdcMarginCombActionField *pMarginCombAction, int nRequestID) = 0;

		///Ͻϳֲֲѯ
		virtual int ReqQrySseCombPosition(CStockFtdcCombPositionField *pPosi, int nRequestID) = 0;

		///Ȩ
		virtual int ReqCombExercise(CStockFtdcCombExerciseReqField *pExercise, int nRequestID) = 0;
	protected:
		~CNhStockTraderApi(){};
	};
}
#endif
