//ϵͳ
#ifdef WIN32
#include "pch.h"
#endif

#include "vnsip.h"
#include "pybind11/pybind11.h"
#include "isipuix.h"


using namespace pybind11;
using namespace api;



///-------------------------------------------------------------------------------------
///C++ SPIĻصʵ
///-------------------------------------------------------------------------------------

//APIļ̳ʵ
class MdApi : public CSipMdSpi
{
private:
	ISIPUIX_EXPORT CSipMdApi* api;      //API
    bool active = false;                //״̬
	bool logging = false;

public:
    MdApi()
    {
    };

    ~MdApi()
    {
        if (this->active)
        {
            this->exit();
        }
    };

    //-------------------------------------------------------------------------------------
    //APIص
    //-------------------------------------------------------------------------------------

	virtual void OnLog(int32_t level, const char *source, const char *slog);
	/*!
	\brief ¼ɹص涩
	\param chn ͨ,һͨʱΪ0,Ϊ1ʼ
	*/

	/*!
	\brief Ͽʱص
	\param chn ͨš
	*/
	virtual void OnDisconnect(int32_t chn);

	/*
	\brief 鶩Ļص
	\param errmsg 洢errcodeϢerrstrĽṹ壬errcodeֵΪ0ɹֵΪ룬Ϣ洢errstrַ
	\param errmsg ṹеchannelmktypedatatypeʶ֤ȯcodesʧܵĶӦͨг͡
	*/
	virtual void OnSubscribe(ErrMsg *errmsg);

	/*
	\brief ˶ص
	\param errmsg 洢errcodeϢerrstrĽṹ壬errcodeֵΪ0ɹֵΪ룬Ϣ洢errstrַ
	\param errmsg ṹеchannelmktypedatatypeʶ֤ȯcodes˶ʧܵĶӦͨг͡
	*/
	virtual void OnUnSubscribe(ErrMsg *errmsg);

	/*!
	\brief L2ݻص
	\param mktype ĵг
	\param code ĵ֤ȯ
	\param dataL2 L2ṹ
	*/
	virtual void OnDepthMarketData(MKtype mk_type, char *code, Stock_MarketData *dataL2);

	/*!
	\brief L1ݻص
	\param mktype ĵг
	\param code ĵ֤ȯ
	\param dataL1 L1ṹ
	*/
	virtual void OnMarketData(MKtype mk_type, char *code, StockMarketDataL1 *dataL1);

	/*!
	\brief ָص
	\param mktype ĵг
	\param code ĵ֤ȯ
	\param stockindex ָṹ
	*/
	virtual void OnIndexData(MKtype mk_type, char *code, Stock_IndexData *stockindex);


	/*!
	\brief ίжݻص
	\param mktype ĵг
	\param code ĵ֤ȯ
	\param orderqueue ίжݽṹ
	*/
	virtual void OnOrderQueue(MKtype mk_type, char *code, StockOrderQueue *orderqueue);

	/*!
	\brief Ͻʳɽݻص
	\param code ĵ֤ȯ
	\param steptrade Ͻݽṹ
	*/
	virtual void OnSHTrade(char *code, t_SH_StockStepTrade *steptrade);

	/*!
	\brief ʳɽݻص
	\param code ĵ֤ȯ
	\param steptrade ݽṹ
	*/
	virtual void OnSZTrade(char *code, T_SZ_STEPTRADE *steptrade);

	/*!
	\brief ίݻص
	\param code ĵ֤ȯ
	\param steptrade ݽṹ
	*/
	virtual void OnSZOrder(char *code, T_SZ_STEPORDER *steporder);

	/*!
	\brief ϽϢص
	\param code ĵ֤ȯ
	\param baseinfodata ϽϢݽṹ
	*/
	virtual void OnSHBaseInfo(char *code, T_SH_BaseInfo *baseinfodata);

	virtual void OnSZBaseInfo(char *code, t_SZ_BaseInfo *baseinfodata) ;

	/*!
	\brief K߻ص
	\param mktype ĵг
	\param code ĵ֤ȯ
	\param kline Kݽṹ
	*/
	virtual void OnKline(MKtype mk_type, char *code, T_Kline *kline);


	/*!
	\brief ETFչݻص
	\param mktype ĵг
	\param code ĵ֤ȯ
	\param etfextdata ETFչݽṹ
	*/
	virtual void OnEtfExtData(MKtype mk_type, char *code, T_ETFEXTENDS *etfextdata);
    //-------------------------------------------------------------------------------------
    //dataصֵ
    //errorصĴֵ
    //idid
    //lastǷΪ󷵻
    //i
    //-------------------------------------------------------------------------------------
	virtual void onLog(int level, string source, string slog) {};

	virtual void onDisconnect(int chn) {};

	virtual void onSubscribe(const dict &error) {};

	virtual void onUnSubscribe(const dict &error) {};

	virtual void onDepthMarketData(int mk_type, string code, const dict &data) {};

	virtual void onMarketData(int mk_type, string code, const dict &data) {};

	virtual void onIndexData(int mk_type, string code, const dict &data) {};

	virtual void onOrderQueue(int mk_type, string code, const dict &data) {};

	virtual void onSHTrade(string code, const dict &data) {};

	virtual void onSZTrade(string code, const dict &data) {};

	virtual void onSZOrder(string code, const dict &data) {};

	virtual void onSHBaseInfo(string code, const dict &data) {};

	virtual void onSZBaseInfo(string code, const dict &data) {};

	virtual void onKline(int mk_type, string code, const dict &data) {};

	virtual void onEtfExtData(int mk_type, string code, const dict &data) {};


    //-------------------------------------------------------------------------------------
    //req:ֵ
    //-------------------------------------------------------------------------------------
	int createMdApi(string sjson, bool logging);

	int login();

	int stop();

	void release();

	int exit();

	int subscribeDepthMarketData(int mk_type, string code);

	int subscribeMarketData(int mk_type, string code);

	int subscribeIndexData(int mk_type, string code);

	int unSubscribeDepthMarketData(int mk_type, string code);

	int unSubscribeMarketData(int mk_type, string code);

	int unSubscribeIndexData(int mk_type, string code);

	int subscribeOrderQueue(int mk_type, string code);

	int unSubscribeOrderQueue(int mk_type, string code);

	int subscribeStepTrade(int mk_type, string code);

	int unSubscribeStepTrade(int mk_type, string code);

	int subscribeStepOrder(int mk_type, string code);

	int unSubscribeStepOrder(int mk_type, string code);

	int subscribeBaseInfo(int mk_type);

	int unSubscribeBaseInfo(int mk_type, string code);

	int subscribeKline(int mk_type, string code);

	int unSubscribeKline(int mk_type, string code);

	int subscribeFutures(int mk_type, string code);

	int unSubscribeFutures(int mk_type, string code);

	int subscribeEtfExt(int mk_type, string code);

	int unSubscribeEtfExt(int mk_type, string code);
};
