#ifndef TESTSEQUENCEDATA_H
#define TESTSEQUENCEDATA_H

namespace RCSB {

static const char * _refSequenceA[] = {
"PHE","ASN","LEU","ASP","VAL","ASP","SER","PRO","ALA","GLU","TYR","SER","GLY",
"PRO","GLU","GLY","SER","TYR","PHE","GLY","PHE","ALA","VAL","ASP","PHE","PHE",
"VAL","PRO","SER","ALA","SER","SER","ARG","MET","PHE","LEU","LEU","VAL","GLY",
"ALA","PRO","LYS","ALA","ASN","THR","THR","GLN","PRO","GLY","ILE","VAL","GLU",
"GLY","GLY","GLN","VAL","LEU","LYS","CYS","ASP","TRP","SER","SER","THR","ARG",
"ARG","CYS","GLN","PRO","ILE","GLU","PHE","ASP","ALA","THR","GLY","ASN","ARG",
"ASP","TYR","ALA","LYS","ASP","ASP","PRO","LEU","GLU","PHE","LYS","SER","HIS",
"GLN","TRP","PHE","GLY","ALA","SER","VAL","ARG","SER","LYS","GLN","ASP","LYS",
"ILE","LEU","ALA","CYS","ALA","PRO","LEU","TYR","HIS","TRP","ARG","THR","GLU",
"MET","LYS","GLN","GLU","ARG","GLU","PRO","VAL","GLY","THR","CYS","PHE","LEU",
"GLN","ASP","GLY","THR","LYS","THR","VAL","GLU","TYR","ALA","PRO","CYS","ARG",
"SER","GLN","ASP","ILE","ASP","ALA","ASP","GLY","GLN","GLY","PHE","CYS","GLN",
"GLY","GLY","PHE","SER","ILE","ASP","PHE","THR","LYS","ALA","ASP","ARG","VAL",
"LEU","LEU","GLY","GLY","PRO","GLY","SER","PHE","TYR","TRP","GLN","GLY","GLN",
"LEU","ILE","SER","ASP","GLN","VAL","ALA","GLU","ILE","VAL","SER","LYS","TYR",
"ASP","PRO","ASN","VAL","TYR","SER","ILE","LYS","TYR","ASN","ASN","GLN","LEU",
"ALA","THR","ARG","THR","ALA","GLN","ALA","ILE","PHE","ASP","ASP","SER","TYR",
"LEU","GLY","TYR","SER","VAL","ALA","VAL","GLY","ASP","PHE","ASN","GLY","ASP",
"GLY","ILE","ASP","ASP","PHE","VAL","SER","GLY","VAL","PRO","ARG","ALA","ALA",
"ARG","THR","LEU","GLY","MET","VAL","TYR","ILE","TYR","ASP","GLY","LYS","ASN",
"MET","SER","SER","LEU","TYR","ASN","PHE","THR","GLY","GLU","GLN","MET","ALA",
"ALA","TYR","PHE","GLY","PHE","SER","VAL","ALA","ALA","THR","ASP","ILE","ASN",
"GLY","ASP","ASP","TYR","ALA","ASP","VAL","PHE","ILE","GLY","ALA","PRO","LEU",
"PHE","MET","ASP","ARG","GLY","SER","ASP","GLY","LYS","LEU","GLN","GLU","VAL",
"GLY","GLN","VAL","SER","VAL","SER","LEU","GLN","ARG","ALA","SER","GLY","ASP",
"PHE","GLN","THR","THR","LYS","LEU","ASN","GLY","PHE","GLU","VAL","PHE","ALA",
"ARG","PHE","GLY","SER","ALA","ILE","ALA","PRO","LEU","GLY","ASP","LEU","ASP",
"GLN","ASP","GLY","PHE","ASN","ASP","ILE","ALA","ILE","ALA","ALA","PRO","TYR",
"GLY","GLY","GLU","ASP","LYS","LYS","GLY","ILE","VAL","TYR","ILE","PHE","ASN",
"GLY","ARG","SER","THR","GLY","LEU","ASN","ALA","VAL","PRO","SER","GLN","ILE",
"LEU","GLU","GLY","GLN","TRP","ALA","ALA","ARG","SER","MET","PRO","PRO","SER",
"PHE","GLY","TYR","SER","MET","LYS","GLY","ALA","THR","ASP","ILE","ASP","LYS",
"ASN","GLY","TYR","PRO","ASP","LEU","ILE","VAL","GLY","ALA","PHE","GLY","VAL",
"ASP","ARG","ALA","ILE","LEU","TYR","ARG","ALA","ARG","PRO","VAL","ILE","THR",
"VAL","ASN","ALA","GLY","LEU","GLU","VAL","TYR","PRO","SER","ILE","LEU","ASN",
"GLN","ASP","ASN","LYS","THR","CYS","SER","LEU","PRO","GLY","THR","ALA","LEU",
"LYS","VAL","SER","CYS","PHE","ASN","VAL","ARG","PHE","CYS","LEU","LYS","ALA",
"ASP","GLY","LYS","GLY","VAL","LEU","PRO","ARG","LYS","LEU","ASN","PHE","GLN",
"VAL","GLU","LEU","LEU","LEU","ASP","LYS","LEU","LYS","GLN","LYS","GLY","ALA",
"ILE","ARG","ARG","ALA","LEU","PHE","LEU","TYR","SER","ARG","SER","PRO","SER",
"HIS","SER","LYS","ASN","MET","THR","ILE","SER","ARG","GLY","GLY","LEU","MET",
"GLN","CYS","GLU","GLU","LEU","ILE","ALA","TYR","LEU","ARG","ASP","GLU","SER",
"GLU","PHE","ARG","ASP","LYS","LEU","THR","PRO","ILE","THR","ILE","PHE","MET",
"GLU","TYR","ARG","LEU","ASP","TYR","ARG","THR","ALA","ALA","ASP","THR","THR",
"GLY","LEU","GLN","PRO","ILE","LEU","ASN","GLN","PHE","THR","PRO","ALA","ASN",
"ILE","SER","ARG","GLN","ALA","HIS","ILE","LEU","LEU","ASP","CYS","GLY","GLU",
"ASP","ASN","VAL","CYS","LYS","PRO","LYS","LEU","GLU","VAL","SER","VAL","ASP",
"SER","ASP","GLN","LYS","LYS","ILE","TYR","ILE","GLY","ASP","ASP","ASN","PRO",
"LEU","THR","LEU","ILE","VAL","LYS","ALA","GLN","ASN","GLN","GLY","GLU","GLY",
"ALA","TYR","GLU","ALA","GLU","LEU","ILE","VAL","SER","ILE","PRO","LEU","GLN",
"ALA","ASP","PHE","ILE","GLY","VAL","VAL","ARG","ASN","ASN","GLU","ALA","LEU",
"ALA","ARG","LEU","SER","CYS","ALA","PHE","LYS","THR","GLU","ASN","GLN","THR",
"ARG","GLN","VAL","VAL","CYS","ASP","LEU","GLY","ASN","PRO","MET","LYS","ALA",
"GLY","THR","GLN","LEU","LEU","ALA","GLY","LEU","ARG","PHE","SER","VAL","HIS",
"GLN","GLN","SER","GLU","MET","ASP","THR","SER","VAL","LYS","PHE","ASP","LEU",
"GLN","ILE","GLN","SER","SER","ASN","LEU","PHE","ASP","LYS","VAL","SER","PRO",
"VAL","VAL","SER","HIS","LYS","VAL","ASP","LEU","ALA","VAL","LEU","ALA","ALA",
"VAL","GLU","ILE","ARG","GLY","VAL","SER","SER","PRO","ASP","HIS","VAL","PHE",
"LEU","PRO","ILE","PRO","ASN","TRP","GLU","HIS","LYS","GLU","ASN","PRO","GLU",
"THR","GLU","GLU","ASP","VAL","GLY","PRO","VAL","VAL","GLN","HIS","ILE","TYR",
"GLU","LEU","ARG","ASN","ASN","GLY","PRO","SER","SER","PHE","SER","LYS","ALA",
"MET","LEU","HIS","LEU","GLN","TRP","PRO","TYR","LYS","TYR","ASN","ASN","ASN",
"THR","LEU","LEU","TYR","ILE","LEU","HIS","TYR","ASP","ILE","ASP","GLY","PRO",
"MET","ASN","CYS","THR","SER","ASP","MET","GLU","ILE","ASN","PRO","LEU","ARG",
"ILE","LYS","ILE","SER","SER","LEU","GLN","THR","THR","GLU","LYS","ASN","ASP",
"THR","VAL","ALA","GLY","GLN","GLY","GLU","ARG","ASP","HIS","LEU","ILE","THR",
"LYS","ARG","ASP","LEU","ALA","LEU","SER","GLU","GLY","ASP","ILE","HIS","THR",
"LEU","GLY","CYS","GLY","VAL","ALA","GLN","CYS","LEU","LYS","ILE","VAL","CYS",
"GLN","VAL","GLY","ARG","LEU","ASP","ARG","GLY","LYS","SER","ALA","ILE","LEU",
"TYR","VAL","LYS","SER","LEU","LEU","TRP","THR","GLU","THR","PHE","MET","ASN",
"LYS","GLU","ASN","GLN","ASN","HIS","SER","TYR","SER","LEU","LYS","SER","SER",
"ALA","SER","PHE","ASN","VAL","ILE","GLU","PHE","PRO","TYR","LYS","ASN","LEU",
"PRO","ILE","GLU","ASP","ILE","THR","ASN","SER","THR","LEU","VAL","THR","THR",
"ASN","VAL","THR","TRP","GLY","ILE","GLN","PRO","ALA","PRO","MET","PRO","VAL",
"PRO","VAL","TRP","VAL","ILE",""};

 static const char * _authSequenceA[] = {"HIS","HIS","HIS",
"ALA","ALA","LEU","ASP","VAL","ASP","SER","PRO","ALA","GLU","TYR","SER","GLY",
"PRO","GLU","GLY","SER","TYR","PHE","GLY","PHE","ALA","VAL","ASP","PHE","PHE",
"VAL","PRO","SER","ALA","SER","SER","ARG","MET","PHE","LEU","LEU","VAL","GLY",
"ALA","PRO","LYS","ALA","ASN","THR","THR","GLN","PRO","GLY","ILE","VAL","GLU",
"GLY","GLY","GLN","VAL","LEU","LYS","CYS","ASP","TRP","SER","SER","THR","ARG",
"ARG","CYS","GLN","PRO","ILE","GLU","PHE","ASP","ALA","THR","GLY","ASN","ARG",
"ASP","TYR","ALA","LYS","ASP","ASP","PRO","LEU","GLU","PHE","LYS","SER","HIS",
"GLN","TRP","PHE","GLY","ALA","SER","VAL","ARG","SER","LYS","GLN","ASP","LYS",
"ILE","LEU","ALA","CYS","ALA","PRO","LEU","TYR","HIS","TRP","ARG","THR","GLU",
"MET","LYS","GLN","GLU","ARG","GLU","PRO","VAL","GLY","THR","CYS","PHE","LEU",
"GLN","ASP","GLY","THR","LYS","THR","VAL","GLU","TYR","ALA","PRO","CYS","ARG",
"SER","GLN","ASP","ILE","ASP","ALA","ASP","GLY","GLN","GLY","PHE","CYS","GLN",
"GLY","GLY","PHE","SER","ILE","ASP","PHE","THR","LYS","ALA","ASP","ARG","VAL",
"LEU","LEU","GLY","GLY","PRO","GLY","SER","PHE","TYR","TRP","GLN","GLY","GLN",
"LEU","ILE","SER","ASP","GLN","VAL","ALA","GLU","ILE","VAL","SER","LYS","TYR",
"ASP","PRO","ASN","VAL","TYR","SER","ILE","LYS","TYR","ASN","ASN","GLN","LEU",
"ALA","THR","ARG","THR","ALA","GLN","ALA","ILE","PHE","ASP","ASP","SER","TYR",
"LEU","GLY","TYR","SER","VAL","ALA","VAL","GLY","ASP","PHE","ASN","GLY","ASP",
"GLY","ILE","ASP","ASP","PHE","VAL","SER","GLY","VAL","PRO","ARG","ALA","ALA",
"ARG","THR","LEU","GLY","MET","VAL","TYR","ILE","TYR","ASP","GLY","LYS","ASN",
"MET","SER","SER","LEU","TYR","ASN","PHE","THR","GLY","GLU","GLN","MET","ALA",
"ALA","TYR","PHE","GLY","PHE","SER","VAL","ALA","ALA","THR","ASP","ILE","ASN",
"GLY","ASP","ASP","TYR","ALA","ASP","VAL","PHE","ILE","GLY","ALA","PRO","LEU",
"PHE","MET","ASP","ARG","GLY","SER","ASP","GLY","LYS","LEU","GLN","GLU","VAL",
"GLY","GLN","VAL","SER","VAL","SER","LEU","GLN","ARG","ALA","SER","GLY","ASP",
"PHE","GLN","THR","THR","LYS","LEU","ASN","GLY","PHE","GLU","VAL","PHE","ALA",
"ARG","PHE","GLY","SER","ALA","ILE","ALA","PRO","LEU","GLY","ASP","LEU","ASP",
"GLN","ASP","GLY","PHE","ASN","ASP","ILE","ALA","ILE","ALA","ALA","PRO","TYR",
"GLY","GLY","GLU","ASP","LYS","LYS","GLY","ILE","VAL","TYR","ILE","PHE","ASN",
"GLY","ARG","SER","THR","GLY","LEU","ASN","ALA","VAL","PRO","SER","GLN","ILE",
"LEU","GLU","GLY","GLN","TRP","ALA","ALA","ARG","SER","MET","PRO","PRO","SER",
"PHE","GLY","TYR","SER","MET","LYS","GLY","ALA","THR","ASP","ILE","ASP","LYS",
"ASN","GLY","TYR","PRO","ASP","LEU","ILE","VAL","GLY","ALA","PHE","GLY","VAL",
"ASP","ARG","ALA","ILE","LEU","TYR","ARG","ALA","ARG","PRO","VAL","ILE","THR",
"VAL","ASN","ALA","GLY","LEU","GLU","VAL","TYR","PRO","SER","ILE","LEU","ASN",
"GLN","ASP","ASN","LYS","THR","CYS","SER","LEU","PRO","GLY","THR","ALA","LEU",
"LYS","VAL","SER","CYS","PHE","ASN","VAL","ARG","PHE","CYS","LEU","LYS","ALA",
"ASP","GLY","LYS","GLY","VAL","LEU","PRO","ARG","LYS","LEU","ASN","PHE","GLN",
"VAL","GLU","LEU","LEU","LEU","ASP","LYS","LEU","LYS","GLN","LYS","GLY","ALA",
"ILE","ARG","ARG","ALA","LEU","PHE","LEU","TYR","SER","ARG","SER","PRO","SER",
"HIS","SER","LYS","ASN","MET","THR","ILE","SER","ARG","GLY","GLY","LEU","MET",
"GLN","CYS","GLU","GLU","LEU","ILE","ALA","TYR","LEU","ARG","ASP","GLU","SER",
"GLU","PHE","ARG","ASP","LYS","LEU","THR","PRO","ILE","THR","ILE","PHE","MET",
"GLU","TYR","ARG","LEU","ASP","TYR","ARG","THR","ALA","ALA","ASP","THR","THR",
"GLY","LEU","GLN","PRO","ILE","LEU","ASN","GLN","PHE","THR","PRO","ALA","ASN",
"ILE","SER","ARG","GLN","ALA","HIS","ILE","LEU","LEU","ASP","CYS","GLY","GLU",
"ASP","ASN","VAL","CYS","LYS","PRO","LYS","LEU","GLU","VAL","SER","VAL","ASP",
"SER","ASP","GLN","LYS","LYS","ILE","TYR","ILE","GLY","ASP","ASP","ASN","PRO",
"LEU","THR","LEU","ILE","VAL","LYS","ALA","GLN","ASN","GLN","GLY","GLU","GLY",
"ALA","TYR","GLU","ALA","GLU","LEU","ILE","VAL","SER","ILE","PRO","LEU","GLN",
"ALA","ASP","PHE","ILE","GLY","VAL","VAL","ARG","ASN","ASN","GLU","ALA","LEU",
"ALA","ARG","LEU","SER","CYS","ALA","PHE","LYS","THR","GLU","ASN","GLN","THR",
"ARG","GLN","VAL","VAL","CYS","ASP","LEU","GLY","ASN","PRO","MET","LYS","ALA",
"GLY","THR","GLN","LEU","LEU","ALA","GLY","LEU","ARG","PHE","SER","VAL","HIS",
"GLN","GLN","SER","GLU","MET","ASP","THR","SER","VAL","LYS","PHE","ASP","LEU",
"GLN","ILE","GLN","SER","SER","ASN","LEU","PHE","ASP","LYS","VAL","SER","PRO",
"VAL","VAL","SER","HIS","LYS","VAL","ASP","LEU","ALA","VAL","LEU","ALA","ALA",
"VAL","GLU","ILE","ARG","GLY","VAL","SER","SER","PRO","ASP","HIS","VAL","PHE",
"LEU","PRO","ILE","PRO","ASN","TRP","GLU","HIS","LYS","GLU","ASN","PRO","GLU",
"THR","GLU","GLU","ASP","VAL","GLY","PRO","VAL","VAL","GLN","HIS","ILE","TYR",
"GLU","LEU","ARG","ASN","ASN","GLY","PRO","SER","SER","PHE","SER","LYS","ALA",
"MET","LEU","HIS","LEU","GLN","TRP","PRO","TYR","LYS","TYR","ASN","ASN","ASN",
"THR","LEU","LEU","TYR","ILE","LEU","HIS","TYR","ASP","ILE","ASP","GLY","PRO",
"MET","ASN","CYS","THR","SER","ASP","MET","GLU","ILE","ASN","PRO","LEU","ARG",
"ILE","LYS","ILE","SER","SER","LEU","GLN","THR","THR","GLU","LYS","ASN","ASP",
"THR","VAL","ALA","GLY","GLN","GLY","GLU","ARG","ASP","HIS","LEU","ILE","THR",
"LYS","ARG","ASP","LEU","ALA","LEU","SER","GLU","GLY","ASP","ILE","HIS","THR",
"LEU","GLY","CYS","GLY","VAL","ALA","GLN","CYS","LEU","LYS","ILE","VAL","CYS",
"GLN","VAL","GLY","ARG","LEU","ASP","ARG","GLY","LYS","SER","ALA","ILE","LEU",
"TYR","VAL","LYS","SER","LEU","LEU","TRP","THR","GLU","THR","PHE","MET","ASN",
"LYS","GLU","ASN","GLN","ASN","HIS","SER","TYR","SER","LEU","LYS","SER","SER",
"ALA","SER","PHE","ASN","VAL","ILE","GLU","PHE","PRO","TYR","LYS","ASN","LEU",
"PRO","ILE","GLU","ASP","ILE","THR","ASN","SER","THR","LEU","VAL","THR","THR",
"ASN","VAL","THR","TRP","GLY","ILE","GLN","PRO","ALA","PRO","MET","PRO","VAL",
"PRO","VAL","TRP","VAL","ILE",""};

#if 0
static const char * _refSequenceB[]  = {
"GLY","PRO","ASN","ILE","LYS","ARG","CYS","THR","GLY","VAL","SER","SER","CYS",
"GLN","GLN","CYS","LEU","ALA","VAL","SER","PRO","MET","CYS","ALA","TRP","CYS",
"SER","ASP","GLU","ALA","LEU","PRO","LEU","GLY","SER","PRO","ARG","CYS","ASP",
"LEU","LYS","GLU","ASN","LEU","LEU","LYS","ASP","ASN","CYS","ALA","PRO","GLU",
"SER","ILE","GLU","PHE","PRO","VAL","SER","GLU","ALA","ARG","VAL","LEU","GLU",
"ASP","ARG","PRO","LEU","SER","ASP","LYS","GLY","SER","GLY","ASP","SER","SER",
"GLN","VAL","THR","GLN","VAL","SER","PRO","GLN","ARG","ILE","ALA","LEU","ARG",
"LEU","ARG","PRO","ASP","ASP","SER","LYS","ASN","PHE","SER","ILE","GLN","VAL",
"ARG","GLN","VAL","GLU","ASP","TYR","PRO","VAL","ASP","ILE","TYR","TYR","LEU",
"MET","ASP","LEU","SER","TYR","SER","MET","LYS","ASP","ASP","LEU","TRP","SER",
"ILE","GLN","ASN","LEU","GLY","THR","LYS","LEU","ALA","THR","GLN","MET","ARG",
"LYS","LEU","THR","SER","ASN","LEU","ARG","ILE","GLY","PHE","GLY","ALA","PHE",
"VAL","ASP","LYS","PRO","VAL","SER","PRO","TYR","MET","TYR","ILE","SER","PRO",
"PRO","GLU","ALA","LEU","GLU","ASN","PRO","CYS","TYR","ASP","MET","LYS","THR",
"THR","CYS","LEU","PRO","MET","PHE","GLY","TYR","LYS","HIS","VAL","LEU","THR",
"LEU","THR","ASP","GLN","VAL","THR","ARG","PHE","ASN","GLU","GLU","VAL","LYS",
"LYS","GLN","SER","VAL","SER","ARG","ASN","ARG","ASP","ALA","PRO","GLU","GLY",
"GLY","PHE","ASP","ALA","ILE","MET","GLN","ALA","THR","VAL","CYS","ASP","GLU",
"LYS","ILE","GLY","TRP","ARG","ASN","ASP","ALA","SER","HIS","LEU","LEU","VAL",
"PHE","THR","THR","ASP","ALA","LYS","THR","HIS","ILE","ALA","LEU","ASP","GLY",
"ARG","LEU","ALA","GLY","ILE","VAL","GLN","PRO","ASN","ASP","GLY","GLN","CYS",
"HIS","VAL","GLY","SER","ASP","ASN","HIS","TYR","SER","ALA","SER","THR","THR",
"MET","ASP","TYR","PRO","SER","LEU","GLY","LEU","MET","THR","GLU","LYS","LEU",
"SER","GLN","LYS","ASN","ILE","ASN","LEU","ILE","PHE","ALA","VAL","THR","GLU",
"ASN","VAL","VAL","ASN","LEU","TYR","GLN","ASN","TYR","SER","GLU","LEU","ILE",
"PRO","GLY","THR","THR","VAL","GLY","VAL","LEU","SER","MET","ASP","SER","SER",
"ASN","VAL","LEU","GLN","LEU","ILE","VAL","ASP","ALA","TYR","GLY","LYS","ILE",
"ARG","SER","LYS","VAL","GLU","LEU","GLU","VAL","ARG","ASP","LEU","PRO","GLU",
"GLU","LEU","SER","LEU","SER","PHE","ASN","ALA","THR","CYS","LEU","ASN","ASN",
"GLU","VAL","ILE","PRO","GLY","LEU","LYS","SER","CYS","MET","GLY","LEU","LYS",
"ILE","GLY","ASP","THR","VAL","SER","PHE","SER","ILE","GLU","ALA","LYS","VAL",
"ARG","GLY","CYS","PRO","GLN","GLU","LYS","GLU","LYS","SER","PHE","THR","ILE",
"LYS","PRO","VAL","GLY","PHE","LYS","ASP","SER","LEU","ILE","VAL","GLN","VAL",
"THR","PHE","ASP","CYS","ASP","CYS","ALA","CYS","GLN","ALA","GLN","ALA","GLU",
"PRO","ASN","SER","HIS","ARG","CYS","ASN","ASN","GLY","ASN","GLY","THR","PHE",
"GLU","CYS","GLY","VAL","CYS","ARG","CYS","GLY","PRO","GLY","TRP","LEU","GLY",
"SER","GLN","CYS","GLU","CYS","SER","GLU","GLU","ASP","TYR","ARG","PRO","SER",
"GLN","GLN","ASP","GLU","CYS","SER","PRO","ARG","GLU","GLY","GLN","PRO","VAL",
"CYS","SER","GLN","ARG","GLY","GLU","CYS","LEU","CYS","GLY","GLN","CYS","VAL",
"CYS","HIS","SER","SER","ASP","PHE","GLY","LYS","ILE","THR","GLY","LYS","TYR",
"CYS","GLU","CYS","ASP","ASP","PHE","SER","CYS","VAL","ARG","TYR","LYS","GLY",
"GLU","MET","CYS","SER","GLY","HIS","GLY","GLN","CYS","SER","CYS","GLY","ASP",
"CYS","LEU","CYS","ASP","SER","ASP","TRP","THR","GLY","TYR","TYR","CYS","ASN",
"CYS","THR","THR","ARG","THR","ASP","THR","CYS","MET","SER","SER","ASN","GLY",
"LEU","LEU","CYS","SER","GLY","ARG","GLY","LYS","CYS","GLU","CYS","GLY","SER",
"CYS","VAL","CYS","ILE","GLN","PRO","GLY","SER","TYR","GLY","ASP","THR","CYS",
"GLU","LYS","CYS","PRO","THR","CYS","PRO","ASP","ALA","CYS","THR","PHE","LYS",
"LYS","GLU","CYS","VAL","GLU","CYS","LYS","LYS","PHE","ASP","ARG","GLY","ALA",
"LEU","HIS","ASP","GLU","ASN","THR","CYS","ASN","ARG","TYR","CYS","ARG","ASP",
"GLU","ILE","GLU","SER","VAL","LYS","GLU","LEU","LYS","ASP","THR","GLY","LYS",
"ASP","ALA","VAL","ASN","CYS","THR","TYR","LYS","ASN","GLU","ASP","ASP","CYS",
"VAL","VAL","ARG","PHE","GLN","TYR","TYR","GLU","ASP","SER","SER","GLY","LYS",
"SER","ILE","LEU","TYR","VAL","VAL","GLU","GLU","PRO","GLU","CYS","PRO","LYS",
"GLY","PRO","ASP","ILE","LEU","VAL",""};

static const char * _authSequenceB[]  = {
"GLY","PRO","ASN","ILE","ALA","ALA","TRP","GLN","GLY","VAL","SER","SER","CYS",
"GLN","GLN","CYS","LEU","ALA","VAL","SER","PRO","MET","CYS","ALA","TRP","CYS",
"SER","ASP","GLU","ALA","LEU","PRO","LEU","GLY","SER","PRO","ARG","CYS","ASP",
"LEU","LYS","GLU","ASN","LEU","LEU","LYS","ASP","ASN","CYS","ALA","PRO","GLU",
"SER","ILE","GLU","PHE","PRO","VAL","SER","GLU","ALA","ARG","VAL","LEU","GLU",
"ASP","ARG","PRO","LEU","SER","ASP","LYS","GLY","SER","GLY","ASP","SER","SER",
"GLN","VAL","THR","GLN","VAL","SER","PRO","GLN","ARG","ILE","ALA","LEU","ARG",
"LEU","ARG","PRO","ASP","ASP","SER","LYS","ASN","PHE","SER","ILE","GLN","VAL",
"ARG","GLN","VAL","GLU","ASP","TYR","PRO","VAL","ASP","ILE","TYR","TYR","LEU",
"MET","ASP","LEU","SER","TYR","SER","MET","LYS","ASP","ASP","LEU","TRP","SER",
"ILE","GLN","ASN","LEU","GLY","THR","LYS","LEU","ALA","THR","GLN","MET","ARG",
"LYS","LEU","THR","SER","ASN","LEU","ARG","ILE","GLY","PHE","GLY","ALA","PHE",
"VAL","ASP","LYS","PRO","VAL","SER","PRO","TYR","MET","TYR","ILE","SER","PRO",
"PRO","GLU","ALA","LEU","GLU","ASN","PRO","CYS","TYR","ASP","MET","LYS","THR",
"THR","CYS","LEU","PRO","MET","PHE","GLY","TYR","LYS","HIS","VAL","LEU","THR",
"LEU","THR","ASP","GLN","VAL","THR","ARG","PHE","ASN","GLU","GLU","VAL","LYS",
"LYS","GLN","SER","VAL","SER","ARG","ASN","ARG","ASP","ALA","PRO","GLU","GLY",
"GLY","PHE","ASP","ALA","ILE","MET","GLN","ALA","THR","VAL","CYS","ASP","GLU",
"LYS","ILE","GLY","TRP","ARG","ASN","ASP","ALA","SER","HIS","LEU","LEU","VAL",
"PHE","THR","THR","ASP","ALA","LYS","THR","HIS","ILE","ALA","LEU","ASP","GLY",
"ARG","LEU","ALA","GLY","ILE","VAL","GLN","PRO","ASN","ASP","GLY","GLN","CYS",
"HIS","VAL","GLY","SER","ASP","ASN","HIS","TYR","SER","ALA","SER","THR","THR",
"MET","ASP","TYR","PRO","SER","LEU","GLY","LEU","MET","THR","GLU","LYS","LEU",
"SER","GLN","LYS","ASN","ILE","ASN","LEU","ILE","PHE","ALA","VAL","THR","GLU",
"ASN","VAL","VAL","ASN","LEU","TYR","GLN","ASN","TYR","SER","GLU","LEU","ILE",
"PRO","GLY","THR","THR","VAL","GLY","VAL","LEU","SER","MET","ASP","SER","SER",
"ASN","VAL","LEU","GLN","LEU","ILE","VAL","ASP","ALA","TYR","GLY","LYS","ILE",
"ARG","SER","LYS","VAL","GLU","LEU","GLU","VAL","ARG","ASP","LEU","PRO","GLU",
"GLU","LEU","SER","LEU","SER","PHE","ASN","ALA","THR","CYS","LEU","ASN","ASN",
"GLU","VAL","ILE","PRO","GLY","LEU","LYS","SER","CYS","MET","GLY","LEU","LYS",
"ILE","GLY","ASP","THR","VAL","SER","PHE","SER","ILE","GLU","ALA","LYS","VAL",
"ARG","GLY","CYS","PRO","GLN","GLU","LYS","GLU","LYS","SER","PHE","THR","ILE",
"LYS","PRO","VAL","GLY","PHE","LYS","ASP","SER","LEU","ILE","VAL","GLN","VAL",
"THR","PHE","ASP","CYS","ASP","CYS","ALA","CYS","GLN","ALA","GLN","ALA","GLU",
"PRO","ASN","SER","HIS","ARG","CYS","ASN","ASN","GLY","ASN","GLY","THR","PHE",
"GLU","CYS","GLY","VAL","CYS","ARG","CYS","GLY","PRO","GLY","TRP","LEU","GLY",
"SER","GLN","CYS","GLU","CYS","SER","GLU","GLU","ASP","TYR","ARG","PRO","SER",
"GLN","GLN","ASP","GLU","CYS","SER","PRO","ARG","GLU","GLY","GLN","PRO","VAL",
"CYS","SER","GLN","ARG","GLY","GLU","CYS","LEU","CYS","GLY","GLN","CYS","VAL",
"CYS","HIS","SER","SER","ASP","PHE","GLY","LYS","ILE","THR","GLY","LYS","TYR",
"CYS","GLU","CYS","ASP","ASP","PHE","SER","CYS","VAL","ARG","TYR","LYS","GLY",
"GLU","MET","CYS","SER","GLY","HIS","GLY","GLN","CYS","SER","CYS","GLY","ASP",
"CYS","LEU","CYS","ASP","SER","ASP","TRP","THR","GLY","TYR","TYR","CYS","ASN",
"CYS","THR","THR","ARG","THR","ASP","THR","CYS","MET","SER","SER","ASN","GLY",
"LEU","LEU","CYS","SER","GLY","ARG","GLY","LYS","CYS","GLU","CYS","GLY","SER",
"CYS","VAL","CYS","ILE","GLN","PRO","GLY","SER","TYR","GLY","ASP","THR","CYS",
"GLU","LYS","CYS","PRO","THR","CYS","PRO","ASP","ALA","CYS","THR","PHE","LYS",
"LYS","GLU","CYS","VAL","GLU","CYS","LYS","LYS","PHE","ASP","ARG","GLY","ALA",
"LEU","HIS","ASP","GLU","ASN","THR","CYS","ASN","ARG","TYR","CYS","ARG","ASP",
"GLU","ILE","GLU","SER","VAL","LYS","GLU","LEU","LYS","ASP","THR","GLY","LYS",
"ASP","ALA","VAL","ASN","CYS","THR","TYR","LYS","ASN","GLU","ASP","ASP","CYS",
"VAL","VAL","ARG","PHE","GLN","TYR","TYR","GLU","ASP","SER","SER","GLY","LYS",
"SER","ILE","LEU","TYR","VAL","VAL","GLU","GLU","PRO","GLU","CYS","PRO","LYS",
"GLY","PRO","ASP","ILE","LEU","VAL",""};
#endif

// refA Length = 1048 
static const char *_refASequence[] = {
"MET","ALA","PHE","PRO","PRO","ARG","ARG","ARG","LEU","ARG",
"LEU","GLY","PRO","ARG","GLY","LEU","PRO","LEU","LEU","LEU",
"SER","GLY","LEU","LEU","LEU","PRO","LEU","CYS","ARG","ALA",
"PHE","ASN","LEU","ASP","VAL","ASP","SER","PRO","ALA","GLU",
"TYR","SER","GLY","PRO","GLU","GLY","SER","TYR","PHE","GLY",
"PHE","ALA","VAL","ASP","PHE","PHE","VAL","PRO","SER","ALA",
"SER","SER","ARG","MET","PHE","LEU","LEU","VAL","GLY","ALA",
"PRO","LYS","ALA","ASN","THR","THR","GLN","PRO","GLY","ILE",
"VAL","GLU","GLY","GLY","GLN","VAL","LEU","LYS","CYS","ASP",
"TRP","SER","SER","THR","ARG","ARG","CYS","GLN","PRO","ILE",
"GLU","PHE","ASP","ALA","THR","GLY","ASN","ARG","ASP","TYR",
"ALA","LYS","ASP","ASP","PRO","LEU","GLU","PHE","LYS","SER",
"HIS","GLN","TRP","PHE","GLY","ALA","SER","VAL","ARG","SER",
"LYS","GLN","ASP","LYS","ILE","LEU","ALA","CYS","ALA","PRO",
"LEU","TYR","HIS","TRP","ARG","THR","GLU","MET","LYS","GLN",
"GLU","ARG","GLU","PRO","VAL","GLY","THR","CYS","PHE","LEU",
"GLN","ASP","GLY","THR","LYS","THR","VAL","GLU","TYR","ALA",
"PRO","CYS","ARG","SER","GLN","ASP","ILE","ASP","ALA","ASP",
"GLY","GLN","GLY","PHE","CYS","GLN","GLY","GLY","PHE","SER",
"ILE","ASP","PHE","THR","LYS","ALA","ASP","ARG","VAL","LEU",
"LEU","GLY","GLY","PRO","GLY","SER","PHE","TYR","TRP","GLN",
"GLY","GLN","LEU","ILE","SER","ASP","GLN","VAL","ALA","GLU",
"ILE","VAL","SER","LYS","TYR","ASP","PRO","ASN","VAL","TYR",
"SER","ILE","LYS","TYR","ASN","ASN","GLN","LEU","ALA","THR",
"ARG","THR","ALA","GLN","ALA","ILE","PHE","ASP","ASP","SER",
"TYR","LEU","GLY","TYR","SER","VAL","ALA","VAL","GLY","ASP",
"PHE","ASN","GLY","ASP","GLY","ILE","ASP","ASP","PHE","VAL",
"SER","GLY","VAL","PRO","ARG","ALA","ALA","ARG","THR","LEU",
"GLY","MET","VAL","TYR","ILE","TYR","ASP","GLY","LYS","ASN",
"MET","SER","SER","LEU","TYR","ASN","PHE","THR","GLY","GLU",
"GLN","MET","ALA","ALA","TYR","PHE","GLY","PHE","SER","VAL",
"ALA","ALA","THR","ASP","ILE","ASN","GLY","ASP","ASP","TYR",
"ALA","ASP","VAL","PHE","ILE","GLY","ALA","PRO","LEU","PHE",
"MET","ASP","ARG","GLY","SER","ASP","GLY","LYS","LEU","GLN",
"GLU","VAL","GLY","GLN","VAL","SER","VAL","SER","LEU","GLN",
"ARG","ALA","SER","GLY","ASP","PHE","GLN","THR","THR","LYS",
"LEU","ASN","GLY","PHE","GLU","VAL","PHE","ALA","ARG","PHE",
"GLY","SER","ALA","ILE","ALA","PRO","LEU","GLY","ASP","LEU",
"ASP","GLN","ASP","GLY","PHE","ASN","ASP","ILE","ALA","ILE",
"ALA","ALA","PRO","TYR","GLY","GLY","GLU","ASP","LYS","LYS",
"GLY","ILE","VAL","TYR","ILE","PHE","ASN","GLY","ARG","SER",
"THR","GLY","LEU","ASN","ALA","VAL","PRO","SER","GLN","ILE",
"LEU","GLU","GLY","GLN","TRP","ALA","ALA","ARG","SER","MET",
"PRO","PRO","SER","PHE","GLY","TYR","SER","MET","LYS","GLY",
"ALA","THR","ASP","ILE","ASP","LYS","ASN","GLY","TYR","PRO",
"ASP","LEU","ILE","VAL","GLY","ALA","PHE","GLY","VAL","ASP",
"ARG","ALA","ILE","LEU","TYR","ARG","ALA","ARG","PRO","VAL",
"ILE","THR","VAL","ASN","ALA","GLY","LEU","GLU","VAL","TYR",
"PRO","SER","ILE","LEU","ASN","GLN","ASP","ASN","LYS","THR",
"CYS","SER","LEU","PRO","GLY","THR","ALA","LEU","LYS","VAL",
"SER","CYS","PHE","ASN","VAL","ARG","PHE","CYS","LEU","LYS",
"ALA","ASP","GLY","LYS","GLY","VAL","LEU","PRO","ARG","LYS",
"LEU","ASN","PHE","GLN","VAL","GLU","LEU","LEU","LEU","ASP",
"LYS","LEU","LYS","GLN","LYS","GLY","ALA","ILE","ARG","ARG",
"ALA","LEU","PHE","LEU","TYR","SER","ARG","SER","PRO","SER",
"HIS","SER","LYS","ASN","MET","THR","ILE","SER","ARG","GLY",
"GLY","LEU","MET","GLN","CYS","GLU","GLU","LEU","ILE","ALA",
"TYR","LEU","ARG","ASP","GLU","SER","GLU","PHE","ARG","ASP",
"LYS","LEU","THR","PRO","ILE","THR","ILE","PHE","MET","GLU",
"TYR","ARG","LEU","ASP","TYR","ARG","THR","ALA","ALA","ASP",
"THR","THR","GLY","LEU","GLN","PRO","ILE","LEU","ASN","GLN",
"PHE","THR","PRO","ALA","ASN","ILE","SER","ARG","GLN","ALA",
"HIS","ILE","LEU","LEU","ASP","CYS","GLY","GLU","ASP","ASN",
"VAL","CYS","LYS","PRO","LYS","LEU","GLU","VAL","SER","VAL",
"ASP","SER","ASP","GLN","LYS","LYS","ILE","TYR","ILE","GLY",
"ASP","ASP","ASN","PRO","LEU","THR","LEU","ILE","VAL","LYS",
"ALA","GLN","ASN","GLN","GLY","GLU","GLY","ALA","TYR","GLU",
"ALA","GLU","LEU","ILE","VAL","SER","ILE","PRO","LEU","GLN",
"ALA","ASP","PHE","ILE","GLY","VAL","VAL","ARG","ASN","ASN",
"GLU","ALA","LEU","ALA","ARG","LEU","SER","CYS","ALA","PHE",
"LYS","THR","GLU","ASN","GLN","THR","ARG","GLN","VAL","VAL",
"CYS","ASP","LEU","GLY","ASN","PRO","MET","LYS","ALA","GLY",
"THR","GLN","LEU","LEU","ALA","GLY","LEU","ARG","PHE","SER",
"VAL","HIS","GLN","GLN","SER","GLU","MET","ASP","THR","SER",
"VAL","LYS","PHE","ASP","LEU","GLN","ILE","GLN","SER","SER",
"ASN","LEU","PHE","ASP","LYS","VAL","SER","PRO","VAL","VAL",
"SER","HIS","LYS","VAL","ASP","LEU","ALA","VAL","LEU","ALA",
"ALA","VAL","GLU","ILE","ARG","GLY","VAL","SER","SER","PRO",
"ASP","HIS","VAL","PHE","LEU","PRO","ILE","PRO","ASN","TRP",
"GLU","HIS","LYS","GLU","ASN","PRO","GLU","THR","GLU","GLU",
"ASP","VAL","GLY","PRO","VAL","VAL","GLN","HIS","ILE","TYR",
"GLU","LEU","ARG","ASN","ASN","GLY","PRO","SER","SER","PHE",
"SER","LYS","ALA","MET","LEU","HIS","LEU","GLN","TRP","PRO",
"TYR","LYS","TYR","ASN","ASN","ASN","THR","LEU","LEU","TYR",
"ILE","LEU","HIS","TYR","ASP","ILE","ASP","GLY","PRO","MET",
"ASN","CYS","THR","SER","ASP","MET","GLU","ILE","ASN","PRO",
"LEU","ARG","ILE","LYS","ILE","SER","SER","LEU","GLN","THR",
"THR","GLU","LYS","ASN","ASP","THR","VAL","ALA","GLY","GLN",
"GLY","GLU","ARG","ASP","HIS","LEU","ILE","THR","LYS","ARG",
"ASP","LEU","ALA","LEU","SER","GLU","GLY","ASP","ILE","HIS",
"THR","LEU","GLY","CYS","GLY","VAL","ALA","GLN","CYS","LEU",
"LYS","ILE","VAL","CYS","GLN","VAL","GLY","ARG","LEU","ASP",
"ARG","GLY","LYS","SER","ALA","ILE","LEU","TYR","VAL","LYS",
"SER","LEU","LEU","TRP","THR","GLU","THR","PHE","MET","ASN",
"LYS","GLU","ASN","GLN","ASN","HIS","SER","TYR","SER","LEU",
"LYS","SER","SER","ALA","SER","PHE","ASN","VAL","ILE","GLU",
"PHE","PRO","TYR","LYS","ASN","LEU","PRO","ILE","GLU","ASP",
"ILE","THR","ASN","SER","THR","LEU","VAL","THR","THR","ASN",
"VAL","THR","TRP","GLY","ILE","GLN","PRO","ALA","PRO","MET",
"PRO","VAL","PRO","VAL","TRP","VAL","ILE","ILE","LEU","ALA",
"VAL","LEU","ALA","GLY","LEU","LEU","LEU","LEU","ALA","VAL",
"LEU","VAL","PHE","VAL","MET","TYR","ARG","MET","GLY","PHE",
"PHE","LYS","ARG","VAL","ARG","PRO","PRO","GLN","GLU","GLU",
"GLN","GLU","ARG","GLU","GLN","LEU","GLN","PRO","HIS","GLU",
"ASN","GLY","GLU","GLY","ASN","SER","GLU","THR",
""};
// authA Length = 967 
static const char *_authASequence[] = {
"PHE","ASN","LEU","ASP","VAL","ASP","SER","PRO","ALA","GLU",
"TYR","SER","GLY","PRO","GLU","GLY","SER","TYR","PHE","GLY",
"PHE","ALA","VAL","ASP","PHE","PHE","VAL","PRO","SER","ALA",
"SER","SER","ARG","MET","PHE","LEU","LEU","VAL","GLY","ALA",
"PRO","LYS","ALA","ASN","THR","THR","GLN","PRO","GLY","ILE",
"VAL","GLU","GLY","GLY","GLN","VAL","LEU","LYS","CYS","ASP",
"TRP","SER","SER","THR","ARG","ARG","CYS","GLN","PRO","ILE",
"GLU","PHE","ASP","ALA","THR","GLY","ASN","ARG","ASP","TYR",
"ALA","LYS","ASP","ASP","PRO","LEU","GLU","PHE","LYS","SER",
"HIS","GLN","TRP","PHE","GLY","ALA","SER","VAL","ARG","SER",
"LYS","GLN","ASP","LYS","ILE","LEU","ALA","CYS","ALA","PRO",
"LEU","TYR","HIS","TRP","ARG","THR","GLU","MET","LYS","GLN",
"GLU","ARG","GLU","PRO","VAL","GLY","THR","CYS","PHE","LEU",
"GLN","ASP","GLY","THR","LYS","THR","VAL","GLU","TYR","ALA",
"PRO","CYS","ARG","SER","GLN","ASP","ILE","ASP","ALA","ASP",
"GLY","GLN","GLY","PHE","CYS","GLN","GLY","GLY","PHE","SER",
"ILE","ASP","PHE","THR","LYS","ALA","ASP","ARG","VAL","LEU",
"LEU","GLY","GLY","PRO","GLY","SER","PHE","TYR","TRP","GLN",
"GLY","GLN","LEU","ILE","SER","ASP","GLN","VAL","ALA","GLU",
"ILE","VAL","SER","LYS","TYR","ASP","PRO","ASN","VAL","TYR",
"SER","ILE","LYS","TYR","ASN","ASN","GLN","LEU","ALA","THR",
"ARG","THR","ALA","GLN","ALA","ILE","PHE","ASP","ASP","SER",
"TYR","LEU","GLY","TYR","SER","VAL","ALA","VAL","GLY","ASP",
"PHE","ASN","GLY","ASP","GLY","ILE","ASP","ASP","PHE","VAL",
"SER","GLY","VAL","PRO","ARG","ALA","ALA","ARG","THR","LEU",
"GLY","MET","VAL","TYR","ILE","TYR","ASP","GLY","LYS","ASN",
"MET","SER","SER","LEU","TYR","ASN","PHE","THR","GLY","GLU",
"GLN","MET","ALA","ALA","TYR","PHE","GLY","PHE","SER","VAL",
"ALA","ALA","THR","ASP","ILE","ASN","GLY","ASP","ASP","TYR",
"ALA","ASP","VAL","PHE","ILE","GLY","ALA","PRO","LEU","PHE",
"MET","ASP","ARG","GLY","SER","ASP","GLY","LYS","LEU","GLN",
"GLU","VAL","GLY","GLN","VAL","SER","VAL","SER","LEU","GLN",
"ARG","ALA","SER","GLY","ASP","PHE","GLN","THR","THR","LYS",
"LEU","ASN","GLY","PHE","GLU","VAL","PHE","ALA","ARG","PHE",
"GLY","SER","ALA","ILE","ALA","PRO","LEU","GLY","ASP","LEU",
"ASP","GLN","ASP","GLY","PHE","ASN","ASP","ILE","ALA","ILE",
"ALA","ALA","PRO","TYR","GLY","GLY","GLU","ASP","LYS","LYS",
"GLY","ILE","VAL","TYR","ILE","PHE","ASN","GLY","ARG","SER",
"THR","GLY","LEU","ASN","ALA","VAL","PRO","SER","GLN","ILE",
"LEU","GLU","GLY","GLN","TRP","ALA","ALA","ARG","SER","MET",
"PRO","PRO","SER","PHE","GLY","TYR","SER","MET","LYS","GLY",
"ALA","THR","ASP","ILE","ASP","LYS","ASN","GLY","TYR","PRO",
"ASP","LEU","ILE","VAL","GLY","ALA","PHE","GLY","VAL","ASP",
"ARG","ALA","ILE","LEU","TYR","ARG","ALA","ARG","PRO","VAL",
"ILE","THR","VAL","ASN","ALA","GLY","LEU","GLU","VAL","TYR",
"PRO","SER","ILE","LEU","ASN","GLN","ASP","ASN","LYS","THR",
"CYS","SER","LEU","PRO","GLY","THR","ALA","LEU","LYS","VAL",
"SER","CYS","PHE","ASN","VAL","ARG","PHE","CYS","LEU","LYS",
"ALA","ASP","GLY","LYS","GLY","VAL","LEU","PRO","ARG","LYS",
"LEU","ASN","PHE","GLN","VAL","GLU","LEU","LEU","LEU","ASP",
"LYS","LEU","LYS","GLN","LYS","GLY","ALA","ILE","ARG","ARG",
"ALA","LEU","PHE","LEU","TYR","SER","ARG","SER","PRO","SER",
"HIS","SER","LYS","ASN","MET","THR","ILE","SER","ARG","GLY",
"GLY","LEU","MET","GLN","CYS","GLU","GLU","LEU","ILE","ALA",
"TYR","LEU","ARG","ASP","GLU","SER","GLU","PHE","ARG","ASP",
"LYS","LEU","THR","PRO","ILE","THR","ILE","PHE","MET","GLU",
"TYR","ARG","LEU","ASP","TYR","ARG","THR","ALA","ALA","ASP",
"THR","THR","GLY","LEU","GLN","PRO","ILE","LEU","ASN","GLN",
"PHE","THR","PRO","ALA","ASN","ILE","SER","ARG","GLN","ALA",
"HIS","ILE","LEU","LEU","ASP","CYS","GLY","GLU","ASP","ASN",
"VAL","CYS","LYS","PRO","LYS","LEU","GLU","VAL","SER","VAL",
"ASP","SER","ASP","GLN","LYS","LYS","ILE","TYR","ILE","GLY",
"ASP","ASP","ASN","PRO","LEU","THR","LEU","ILE","VAL","LYS",
"ALA","GLN","ASN","GLN","GLY","GLU","GLY","ALA","TYR","GLU",
"ALA","GLU","LEU","ILE","VAL","SER","ILE","PRO","LEU","GLN",
"ALA","ASP","PHE","ILE","GLY","VAL","VAL","ARG","ASN","ASN",
"GLU","ALA","LEU","ALA","ARG","LEU","SER","CYS","ALA","PHE",
"LYS","THR","GLU","ASN","GLN","THR","ARG","GLN","VAL","VAL",
"CYS","ASP","LEU","GLY","ASN","PRO","MET","LYS","ALA","GLY",
"THR","GLN","LEU","LEU","ALA","GLY","LEU","ARG","PHE","SER",
"VAL","HIS","GLN","GLN","SER","GLU","MET","ASP","THR","SER",
"VAL","LYS","PHE","ASP","LEU","GLN","ILE","GLN","SER","SER",
"ASN","LEU","PHE","ASP","LYS","VAL","SER","PRO","VAL","VAL",
"SER","HIS","LYS","VAL","ASP","LEU","ALA","VAL","LEU","ALA",
"ALA","VAL","GLU","ILE","ARG","GLY","VAL","SER","SER","PRO",
"ASP","HIS","VAL","PHE","LEU","PRO","ILE","PRO","ASN","TRP",
"GLU","HIS","LYS","GLU","ASN","PRO","GLU","THR","GLU","GLU",
"ASP","VAL","GLY","PRO","VAL","VAL","GLN","HIS","ILE","TYR",
"GLU","LEU","ARG","ASN","ASN","GLY","PRO","SER","SER","PHE",
"SER","LYS","ALA","MET","LEU","HIS","LEU","GLN","TRP","PRO",
"TYR","LYS","TYR","ASN","ASN","ASN","THR","LEU","LEU","TYR",
"ILE","LEU","HIS","TYR","ASP","ILE","ASP","GLY","PRO","MET",
"ASN","CYS","THR","SER","ASP","MET","GLU","ILE","ASN","PRO",
"LEU","ARG","ILE","LYS","ILE","SER","SER","LEU","GLN","THR",
"THR","GLU","LYS","ASN","ASP","THR","VAL","ALA","GLY","GLN",
"GLY","GLU","ARG","ASP","HIS","LEU","ILE","THR","LYS","ARG",
"ASP","LEU","ALA","LEU","SER","GLU","GLY","ASP","ILE","HIS",
"THR","LEU","GLY","CYS","GLY","VAL","ALA","GLN","CYS","LEU",
"LYS","ILE","VAL","CYS","GLN","VAL","GLY","ARG","LEU","ASP",
"ARG","GLY","LYS","SER","ALA","ILE","LEU","TYR","VAL","LYS",
"SER","LEU","LEU","TRP","THR","GLU","THR","PHE","MET","ASN",
"LYS","GLU","ASN","GLN","ASN","HIS","SER","TYR","SER","LEU",
"LYS","SER","SER","ALA","SER","PHE","ASN","VAL","ILE","GLU",
"PHE","PRO","TYR","LYS","ASN","LEU","PRO","ILE","GLU","ASP",
"ILE","THR","ASN","SER","THR","LEU","VAL","THR","THR","ASN",
"VAL","THR","TRP","GLY","ILE","GLN","PRO","ALA","PRO","MET",
"PRO","VAL","PRO","VAL","TRP","VAL","ILE",
""};
// authAT1 Length = 977 
static const char *_authAT1Sequence[] = {
"PHE","ASN","LEU","ASP","VAL","ASP","SER","PRO","ALA","GLU",
"TYR","SER","GLY","PRO","GLU","GLY","SER","TYR","PHE","GLY",
"PHE","ALA","VAL","ASP","PHE","PHE","VAL","PRO","SER","ALA",
"SER","SER","ARG","MET","PHE","LEU","LEU","VAL","GLY","ALA",
"PRO","LYS","ALA","ASN","THR","THR","GLN","PRO","GLY","ILE",
"VAL","GLU","GLY","PRO","GLY","GLN","VAL","LEU","LYS","CYS",
"ASP","TRP","SER","SER","THR","ARG","ARG","CYS","GLN","PRO",
"ILE","GLU","PHE","ASP","ALA","THR","GLY","ASN","ARG","ASP",
"TYR","ALA","LYS","ASP","ASP","PRO","LEU","GLU","PHE","LYS",
"SER","HIS","GLN","TRP","PHE","GLY","ALA","SER","VAL","ARG",
"SER","LYS","GLN","ASP","LYS","ILE","LEU","ALA","CYS","ALA",
"PRO","LEU","TYR","HIS","TRP","ARG","THR","GLU","MET","LYS",
"GLN","GLU","THR","THR","THR","THR","THR","THR","THR","ARG",
"GLU","PRO","VAL","GLY","THR","CYS","PHE","LEU","GLN","ASP",
"GLY","THR","LYS","THR","VAL","GLU","TYR","ALA","PRO","CYS",
"ARG","SER","GLN","ASP","ILE","ASP","ALA","ASP","GLY","GLN",
"GLY","PHE","CYS","GLN","GLY","GLY","PHE","SER","ILE","ASP",
"PHE","THR","LYS","ALA","ASP","ARG","VAL","LEU","LEU","GLY",
"GLY","PRO","GLY","SER","PHE","TYR","TRP","GLN","GLY","GLN",
"LEU","ILE","SER","ASP","GLN","VAL","ALA","GLU","ILE","VAL",
"SER","LYS","TYR","ASP","PRO","ASN","VAL","TYR","SER","ILE",
"LYS","TYR","ASN","ASN","GLN","LEU","ALA","THR","ARG","THR",
"ALA","GLN","ALA","ILE","PHE","ASP","ASP","SER","TYR","LEU",
"GLY","TYR","SER","VAL","ALA","VAL","GLY","ASP","PHE","ASN",
"GLY","ASP","GLY","ILE","ASP","ASP","PHE","VAL","SER","GLY",
"VAL","PRO","ARG","ALA","ALA","ARG","THR","LEU","GLY","MET",
"VAL","TYR","ILE","TYR","ASP","GLY","LYS","ASN","MET","SER",
"SER","LEU","TYR","ASN","PHE","THR","GLY","GLU","GLN","MET",
"ALA","ALA","TYR","PHE","GLY","PHE","SER","VAL","ALA","ALA",
"THR","ASP","ILE","ASN","GLY","ASP","ASP","TYR","ALA","ASP",
"VAL","PHE","ILE","GLY","ALA","PRO","LEU","PHE","MET","ASP",
"ARG","GLY","SER","ASP","GLY","LYS","LEU","GLN","GLU","VAL",
"GLY","GLN","VAL","SER","VAL","SER","LEU","GLN","ARG","ALA",
"SER","GLY","ASP","PHE","GLN","THR","THR","LYS","LEU","ASN",
"GLY","PHE","GLU","VAL","PHE","ALA","ARG","PHE","GLY","SER",
"ALA","ILE","ALA","PRO","LEU","GLY","ASP","LEU","ASP","GLN",
"ASP","GLY","PHE","ASN","ASP","ILE","ALA","ILE","ALA","ALA",
"PRO","TYR","GLY","GLY","GLU","ASP","LYS","LYS","GLY","ILE",
"VAL","TYR","ILE","PHE","ASN","GLY","ARG","SER","THR","GLY",
"LEU","ASN","ALA","VAL","PRO","SER","GLN","ILE","LEU","GLU",
"GLY","GLN","TRP","ALA","ALA","ARG","SER","MET","PRO","PRO",
"SER","PHE","GLY","TYR","SER","MET","LYS","GLY","ALA","THR",
"ASP","ILE","ASP","LYS","ASN","GLY","TYR","PRO","ASP","LEU",
"ILE","VAL","GLY","ALA","PHE","GLY","VAL","ASP","ARG","ALA",
"ILE","LEU","TYR","ARG","ALA","ARG","PRO","VAL","ILE","THR",
"VAL","ASN","ALA","GLY","LEU","GLU","VAL","TYR","PRO","SER",
"ILE","LEU","ASN","GLN","ASP","ASN","LYS","THR","CYS","SER",
"LEU","PRO","GLY","THR","ALA","LEU","LYS","VAL","SER","CYS",
"PHE","ASN","VAL","ARG","PHE","CYS","LEU","LYS","ALA","ASP",
"GLY","LYS","GLY","VAL","LEU","PRO","ARG","LYS","LEU","ASN",
"PHE","GLN","VAL","GLU","LEU","LEU","LEU","ASP","LYS","LEU",
"LYS","GLN","LYS","GLY","ALA","ILE","ARG","ARG","ALA","LEU",
"PHE","LEU","TYR","SER","ARG","SER","PRO","SER","HIS","SER",
"LYS","ASN","MET","THR","GLY","ILE","SER","ARG","GLY","GLY",
"LEU","MET","GLN","CYS","GLU","GLU","LEU","ILE","ALA","TYR",
"LEU","ARG","ASP","GLU","SER","GLU","PHE","ARG","ASP","LYS",
"LEU","THR","PRO","ILE","THR","ILE","PHE","MET","GLU","TYR",
"ARG","LEU","ASP","TYR","ARG","THR","ALA","ALA","ASP","THR",
"THR","GLY","LEU","GLN","PRO","UNK","ILE","LEU","ASN","GLN",
"PHE","THR","PRO","ALA","ASN","ILE","SER","ARG","GLN","ALA",
"HIS","ILE","LEU","LEU","ASP","CYS","GLY","GLU","ASP","ASN",
"VAL","CYS","LYS","PRO","LYS","LEU","GLU","VAL","SER","VAL",
"ASP","SER","ASP","GLN","LYS","LYS","ILE","TYR","ILE","GLY",
"ASP","ASP","ASN","PRO","LEU","THR","LEU","ILE","VAL","LYS",
"ALA","GLN","ASN","GLN","GLY","GLU","GLY","ALA","TYR","GLU",
"ALA","GLU","LEU","ILE","VAL","SER","ILE","PRO","LEU","GLN",
"ALA","ASP","PHE","ILE","GLY","VAL","VAL","ARG","ASN","ASN",
"GLU","ALA","LEU","ALA","ARG","LEU","SER","CYS","ALA","PHE",
"LYS","THR","GLU","ASN","GLN","THR","ARG","GLN","VAL","VAL",
"CYS","ASP","LEU","GLY","ASN","PRO","MET","LYS","ALA","GLY",
"THR","GLN","LEU","LEU","ALA","GLY","LEU","ARG","PHE","SER",
"VAL","HIS","GLN","GLN","SER","GLU","MET","ASP","THR","SER",
"VAL","LYS","PHE","ASP","LEU","GLN","ILE","GLN","SER","SER",
"ASN","LEU","PHE","ASP","LYS","VAL","SER","PRO","VAL","VAL",
"SER","HIS","LYS","VAL","ASP","LEU","ALA","VAL","LEU","ALA",
"ALA","VAL","GLU","ILE","ARG","GLY","VAL","SER","SER","PRO",
"ASP","HIS","VAL","PHE","LEU","PRO","ILE","PRO","ASN","TRP",
"GLU","HIS","LYS","GLU","ASN","PRO","GLU","THR","GLU","GLU",
"ASP","VAL","GLY","PRO","VAL","VAL","GLN","HIS","ILE","TYR",
"GLU","LEU","ARG","ASN","ASN","GLY","PRO","SER","SER","PHE",
"SER","LYS","ALA","MET","LEU","HIS","LEU","GLN","TRP","PRO",
"TYR","LYS","TYR","ASN","ASN","ASN","THR","LEU","LEU","TYR",
"ILE","LEU","HIS","TYR","ASP","ILE","ASP","GLY","PRO","MET",
"ASN","CYS","THR","SER","ASP","MET","GLU","ILE","ASN","PRO",
"LEU","ARG","ILE","LYS","ILE","SER","SER","LEU","GLN","THR",
"THR","GLU","LYS","ASN","ASP","THR","VAL","ALA","GLY","GLN",
"GLY","GLU","ARG","ASP","HIS","LEU","ILE","THR","LYS","ARG",
"ASP","LEU","ALA","LEU","SER","GLU","GLY","ASP","ILE","HIS",
"THR","LEU","GLY","CYS","GLY","VAL","ALA","GLN","CYS","LEU",
"LYS","ILE","VAL","CYS","GLN","VAL","GLY","ARG","LEU","ASP",
"ARG","GLY","LYS","SER","ALA","ILE","LEU","TYR","VAL","LYS",
"SER","LEU","LEU","TRP","THR","GLU","THR","PHE","MET","ASN",
"LYS","GLU","ASN","GLN","ASN","HIS","SER","TYR","SER","LEU",
"LYS","SER","SER","ALA","SER","PHE","ASN","VAL","ILE","GLU",
"PHE","PRO","TYR","LYS","ASN","LEU","PRO","ILE","GLU","ASP",
"ILE","THR","ASN","SER","THR","LEU","VAL","THR","THR","ASN",
"VAL","THR","TRP","GLY","ILE","GLN","PRO","ALA","PRO","MET",
"PRO","VAL","PRO","VAL","TRP","VAL","ILE",
""};
// authAT2 Length = 970 
static const char *_authAT2Sequence[] = {
"PHE","ASN","LEU","ASP","VAL","ASP","SER","PRO","ALA","GLU",
"TYR","SER","GLY","PRO","GLU","GLY","SER","TYR","PHE","GLY",
"PHE","THR","ALA","VAL","ASP","PHE","PHE","VAL","PRO","SER",
"ALA","SER","SER","ARG","MET","PHE","LEU","LEU","VAL","GLY",
"ALA","PRO","LYS","ALA","ASN","THR","THR","GLN","PRO","GLY",
"ILE","VAL","GLU","GLY","GLY","GLN","VAL","LEU","LYS","CYS",
"ASP","TRP","SER","SER","THR","ARG","ARG","CYS","GLN","PRO",
"ILE","GLU","PHE","ASP","ALA","THR","GLY","ASN","ARG","ASP",
"TYR","ALA","LYS","ASP","ASP","PRO","LEU","GLU","PHE","LYS",
"SER","HIS","GLN","TRP","PHE","GLY","ALA","SER","VAL","ARG",
"SER","LYS","GLN","ASP","LYS","ILE","LEU","ALA","CYS","ALA",
"PRO","LEU","TYR","HIS","TRP","ARG","THR","GLU","MET","LYS",
"GLN","GLU","ARG","GLU","PRO","VAL","GLY","THR","CYS","PHE",
"LEU","GLN","ASP","GLY","THR","LYS","THR","VAL","GLU","TYR",
"ALA","PRO","CYS","ARG","SER","GLN","ASP","ILE","ASP","ALA",
"ASP","GLY","GLN","GLY","PHE","CYS","GLN","GLY","GLY","PHE",
"SER","ILE","ASP","PHE","THR","LYS","ALA","ASP","ARG","VAL",
"LEU","LEU","GLY","GLY","PRO","GLY","SER","PHE","TYR","TRP",
"GLN","GLY","GLN","LEU","ILE","SER","ASP","GLN","VAL","ALA",
"GLU","ILE","VAL","SER","LYS","TYR","ASP","PRO","ASN","VAL",
"TYR","SER","ILE","LYS","TYR","ASN","ASN","GLN","LEU","ALA",
"THR","ARG","THR","ALA","GLN","ALA","ILE","PHE","ASP","ASP",
"SER","TYR","LEU","GLY","TYR","SER","VAL","ALA","VAL","GLY",
"ASP","PHE","ASN","GLY","ASP","GLY","ILE","ASP","ASP","PHE",
"VAL","SER","GLY","VAL","PRO","ARG","ALA","ALA","ARG","THR",
"LEU","GLY","MET","VAL","TYR","ILE","TYR","ASP","GLY","LYS",
"ASN","MET","SER","SER","LEU","TYR","ASN","PHE","THR","GLY",
"GLU","GLN","MET","ALA","ALA","TYR","PHE","GLY","PHE","SER",
"VAL","ALA","ALA","THR","ASP","ILE","ASN","GLY","ASP","ASP",
"TYR","ALA","ASP","VAL","PHE","ILE","GLY","ALA","PRO","LEU",
"PHE","MET","ASP","ARG","GLY","SER","ASP","GLY","LYS","LEU",
"GLN","GLU","VAL","GLY","GLN","VAL","SER","VAL","SER","LEU",
"GLN","ARG","ALA","SER","GLY","ASP","PHE","GLN","THR","THR",
"LYS","LEU","ASN","GLY","PHE","GLU","VAL","PHE","ALA","ARG",
"PHE","GLY","SER","ALA","ILE","ALA","PRO","LEU","GLY","ASP",
"LEU","ASP","GLN","ASP","GLY","PHE","ASN","ASP","ILE","ALA",
"ILE","ALA","ALA","PRO","TYR","GLY","GLY","GLU","ASP","LYS",
"LYS","GLY","ILE","VAL","TYR","ILE","PHE","ASN","GLY","ARG",
"SER","THR","GLY","LEU","ASN","ALA","VAL","PRO","SER","GLN",
"ILE","LEU","GLU","GLY","GLN","TRP","ALA","ALA","ARG","SER",
"MET","PRO","PRO","PRO","SER","PHE","GLY","TYR","SER","MET",
"LYS","GLY","ALA","THR","ASP","ILE","ASP","LYS","ASN","GLY",
"TYR","PRO","ASP","LEU","ILE","VAL","GLY","ALA","PHE","GLY",
"VAL","ASP","ARG","ALA","ILE","LEU","TYR","ARG","ALA","ARG",
"PRO","VAL","ILE","THR","VAL","ASN","ALA","GLY","LEU","GLU",
"VAL","TYR","PRO","SER","ILE","LEU","ASN","GLN","ASP","ASN",
"LYS","THR","CYS","SER","LEU","PRO","GLY","THR","ALA","LEU",
"LYS","VAL","SER","CYS","PHE","ASN","VAL","ARG","PHE","CYS",
"LEU","LYS","ALA","ASP","GLY","LYS","GLY","VAL","LEU","PRO",
"ARG","LYS","LEU","ASN","PHE","GLN","VAL","GLU","LEU","LEU",
"LEU","ASP","LYS","LEU","LYS","GLN","LYS","GLY","ALA","ILE",
"ARG","ARG","ALA","LEU","PHE","LEU","TYR","SER","ARG","SER",
"PRO","SER","HIS","SER","LYS","ASN","MET","THR","ILE","SER",
"ARG","GLY","GLY","LEU","MET","GLN","CYS","GLU","GLU","LEU",
"ILE","ALA","TYR","LEU","ARG","ASP","GLU","SER","GLU","PHE",
"ARG","ASP","LYS","LEU","THR","PRO","ILE","THR","ILE","PHE",
"MET","GLU","TYR","ARG","LEU","ASP","TYR","ARG","THR","ALA",
"ALA","ASP","THR","THR","GLY","LEU","GLN","PRO","ILE","LEU",
"ASN","GLN","PHE","THR","PRO","ALA","ASN","ILE","SER","ARG",
"GLN","ALA","HIS","ILE","LEU","LEU","ASP","CYS","GLY","GLU",
"ASP","ASN","VAL","CYS","LYS","PRO","LYS","LEU","GLU","VAL",
"SER","VAL","ASP","SER","ASP","GLN","LYS","LYS","ILE","TYR",
"ILE","GLY","ASP","ASP","ASN","PRO","LEU","THR","LEU","ILE",
"VAL","LYS","ALA","GLN","ASN","GLN","GLY","GLU","GLY","ALA",
"TYR","GLU","ALA","GLU","LEU","ILE","VAL","SER","ILE","PRO",
"LEU","GLN","ALA","ASP","PHE","ILE","GLY","VAL","VAL","ARG",
"ASN","ASN","GLU","ALA","LEU","ALA","ARG","LEU","SER","CYS",
"ALA","PHE","LYS","THR","GLU","ASN","GLN","THR","ARG","GLN",
"VAL","VAL","CYS","ASP","LEU","GLY","ASN","PRO","MET","LYS",
"ALA","GLY","THR","GLN","LEU","LEU","ALA","GLY","LEU","ARG",
"PHE","SER","VAL","HIS","GLN","GLN","SER","GLU","MET","ASP",
"THR","SER","VAL","LYS","PHE","ASP","LEU","GLN","ILE","GLN",
"SER","SER","ASN","LEU","PHE","ASP","LYS","VAL","SER","PRO",
"VAL","VAL","SER","HIS","LYS","VAL","ASP","LEU","ALA","VAL",
"LEU","ALA","ALA","VAL","GLU","ILE","ARG","GLY","VAL","SER",
"SER","PRO","ASP","HIS","VAL","PHE","LEU","PRO","ILE","PRO",
"ASN","TRP","GLU","HIS","LYS","GLU","ASN","PRO","GLU","THR",
"GLU","GLU","ASP","VAL","GLY","PRO","VAL","VAL","GLN","HIS",
"ILE","TYR","GLU","LEU","ARG","ASN","ASN","GLY","PRO","SER",
"SER","PHE","SER","LYS","ALA","MET","LEU","HIS","LEU","GLN",
"TRP","PRO","TYR","LYS","TYR","ASN","ASN","ASN","THR","LEU",
"LEU","TYR","ILE","LEU","HIS","TYR","ASP","ILE","ASP","GLY",
"PRO","MET","ASN","CYS","THR","SER","ASP","MET","GLU","ILE",
"ASN","PRO","LEU","ARG","ILE","LYS","ILE","SER","SER","LEU",
"GLN","THR","THR","GLU","LYS","ASN","ASP","THR","VAL","ALA",
"GLY","GLN","GLY","GLU","ARG","ASP","HIS","LEU","ILE","THR",
"LYS","ARG","ASP","LEU","ALA","LEU","SER","GLU","GLY","ARG",
"ASP","ILE","HIS","THR","LEU","GLY","CYS","GLY","VAL","ALA",
"GLN","CYS","LEU","LYS","ILE","VAL","CYS","GLN","VAL","GLY",
"ARG","LEU","ASP","ARG","GLY","LYS","SER","ALA","ILE","LEU",
"TYR","VAL","LYS","SER","LEU","LEU","TRP","THR","GLU","THR",
"PHE","MET","ASN","LYS","GLU","ASN","GLN","ASN","HIS","SER",
"TYR","SER","LEU","LYS","SER","SER","ALA","SER","PHE","ASN",
"VAL","ILE","GLU","PHE","PRO","TYR","LYS","ASN","LEU","PRO",
"ILE","GLU","ASP","ILE","THR","ASN","SER","THR","LEU","VAL",
"THR","THR","ASN","VAL","THR","TRP","GLY","ILE","GLN","PRO",
"ALA","PRO","MET","PRO","VAL","PRO","VAL","TRP","VAL","ILE",
""};
// authAT3 Length = 972 
static const char *_authAT3Sequence[] = {
"PHE","ASN","LEU","ASP","VAL","ASP","SER","PRO","ALA","GLU",
"TYR","SER","GLY","PRO","GLU","GLY","SER","TYR","PHE","GLY",
"PHE","ALA","VAL","ASP","PHE","PHE","VAL","PRO","SER","ALA",
"SER","SER","ARG","MET","PHE","LEU","LEU","VAL","GLY","ALA",
"PRO","LYS","ALA","ASN","THR","THR","GLN","PRO","GLY","ILE",
"VAL","GLU","GLY","GLY","GLN","VAL","LEU","LYS","CYS","ASP",
"TRP","SER","SER","THR","ARG","ARG","CYS","GLN","PRO","ILE",
"GLU","PHE","ASP","ALA","THR","GLY","ASN","ARG","ASP","TYR",
"ALA","LYS","ASP","ASP","PRO","LEU","GLU","PHE","LYS","SER",
"HIS","GLN","TRP","PHE","GLY","ALA","SER","VAL","ARG","SER",
"LYS","GLN","ASP","LYS","ILE","LEU","ALA","CYS","ALA","PRO",
"LEU","TYR","HIS","TRP","ARG","THR","GLU","MET","LYS","GLN",
"GLU","ARG","GLU","PRO","VAL","GLY","THR","CYS","PHE","LEU",
"GLN","ASP","GLY","THR","UNK","UNK","UNK","LYS","THR","VAL",
"GLU","TYR","ALA","PRO","CYS","ARG","SER","GLN","ASP","ILE",
"ASP","ALA","ASP","GLY","GLN","GLY","PHE","CYS","GLN","GLY",
"GLY","PHE","SER","ILE","ASP","PHE","THR","LYS","ALA","ASP",
"ARG","VAL","LEU","LEU","GLY","GLY","PRO","GLY","SER","PHE",
"TYR","TRP","GLN","GLY","GLN","LEU","ILE","SER","ASP","GLN",
"VAL","ALA","GLU","ILE","VAL","SER","LYS","TYR","ASP","PRO",
"ASN","VAL","TYR","SER","ILE","LYS","TYR","ASN","ASN","GLN",
"LEU","ALA","THR","ARG","THR","ALA","GLN","ALA","ILE","PHE",
"ASP","ASP","SER","TYR","LEU","GLY","TYR","SER","VAL","ALA",
"VAL","GLY","ASP","PHE","ASN","GLY","ASP","GLY","ILE","ASP",
"ASP","PHE","VAL","SER","GLY","VAL","PRO","ARG","ALA","ALA",
"ARG","THR","LEU","GLY","MET","VAL","TYR","ILE","TYR","ASP",
"GLY","LYS","ASN","MET","SER","SER","LEU","TYR","ASN","PHE",
"THR","GLY","GLU","GLN","MET","ALA","ALA","TYR","PHE","GLY",
"PHE","SER","VAL","ALA","ALA","THR","ASP","ILE","ASN","GLY",
"ASP","ASP","TYR","ALA","ASP","VAL","PHE","ILE","GLY","ALA",
"PRO","LEU","PHE","MET","ASP","ARG","GLY","SER","ASP","GLY",
"LYS","LEU","GLN","GLU","VAL","GLY","GLN","VAL","SER","VAL",
"SER","LEU","GLN","ARG","ALA","SER","GLY","ASP","PHE","GLN",
"THR","THR","LYS","LEU","ASN","GLY","PHE","GLU","VAL","PHE",
"ALA","ARG","PHE","GLY","SER","ALA","ILE","ALA","PRO","LEU",
"GLY","ASP","LEU","ASP","GLN","ASP","GLY","PHE","ASN","ASP",
"ILE","ALA","ILE","ALA","ALA","PRO","TYR","GLY","GLY","GLU",
"ASP","LYS","LYS","GLY","ILE","VAL","TYR","ILE","PHE","ASN",
"GLY","ARG","SER","THR","GLY","LEU","ASN","ALA","VAL","PRO",
"SER","GLN","ILE","LEU","GLU","GLY","GLN","TRP","ALA","ALA",
"ARG","SER","MET","PRO","PRO","SER","PHE","GLY","TYR","SER",
"MET","LYS","GLY","ALA","THR","ASP","ILE","ASP","LYS","ASN",
"GLY","TYR","PRO","ASP","LEU","ILE","VAL","GLY","ALA","PHE",
"GLY","VAL","ASP","ARG","ALA","ILE","LEU","TYR","ARG","ALA",
"ARG","PRO","VAL","ILE","THR","VAL","ASN","ALA","GLY","LEU",
"GLU","VAL","TYR","PRO","SER","LYS","ILE","LEU","ASN","GLN",
"ASP","ASN","LYS","THR","CYS","SER","LEU","PRO","GLY","THR",
"ALA","LEU","LYS","VAL","SER","CYS","PHE","ASN","VAL","ARG",
"PHE","CYS","LEU","LYS","ALA","ASP","GLY","LYS","GLY","VAL",
"LEU","PRO","ARG","LYS","LEU","ASN","PHE","GLN","VAL","GLU",
"LEU","LEU","LEU","ASP","LYS","LEU","LYS","GLN","LYS","GLY",
"ALA","ILE","ARG","ARG","ALA","LEU","PHE","LEU","TYR","SER",
"ARG","SER","PRO","SER","HIS","SER","LYS","ASN","MET","THR",
"ILE","SER","ARG","GLY","GLY","LEU","MET","GLN","CYS","GLU",
"GLU","LEU","ILE","ALA","TYR","LEU","ARG","ASP","GLU","SER",
"GLU","PHE","ARG","ASP","LYS","LEU","THR","PRO","ILE","THR",
"ILE","PHE","MET","GLU","TYR","ARG","LEU","ASP","TYR","ARG",
"THR","ALA","ALA","ASP","THR","THR","GLY","LEU","GLN","PRO",
"ILE","LEU","ASN","GLN","PHE","THR","PRO","ALA","ASN","ILE",
"SER","ARG","GLN","ALA","HIS","ILE","LEU","LEU","ASP","CYS",
"GLY","GLU","ASP","ASN","VAL","CYS","LYS","PRO","LYS","LEU",
"GLU","VAL","SER","VAL","ASP","SER","ASP","GLN","LYS","LYS",
"ILE","TYR","ILE","GLY","ASP","ASP","ASN","PRO","LEU","THR",
"LEU","ILE","VAL","LYS","ALA","GLN","ASN","GLN","GLY","GLU",
"GLY","ALA","TYR","GLU","ALA","GLU","LEU","ILE","VAL","SER",
"ILE","PRO","LEU","GLN","ALA","ASP","PHE","ILE","UNK","GLY",
"VAL","VAL","ARG","ASN","ASN","GLU","ALA","LEU","ALA","ARG",
"LEU","SER","CYS","ALA","PHE","LYS","THR","GLU","ASN","GLN",
"THR","ARG","GLN","VAL","VAL","CYS","ASP","LEU","GLY","ASN",
"PRO","MET","LYS","ALA","GLY","THR","GLN","LEU","LEU","ALA",
"GLY","LEU","ARG","PHE","SER","VAL","HIS","GLN","GLN","SER",
"GLU","MET","ASP","THR","SER","VAL","LYS","PHE","ASP","LEU",
"GLN","ILE","GLN","SER","SER","ASN","LEU","PHE","ASP","LYS",
"VAL","SER","PRO","VAL","VAL","SER","HIS","LYS","VAL","ASP",
"LEU","ALA","VAL","LEU","ALA","ALA","VAL","GLU","ILE","ARG",
"GLY","VAL","SER","SER","PRO","ASP","HIS","VAL","PHE","LEU",
"PRO","ILE","PRO","ASN","TRP","GLU","HIS","LYS","GLU","ASN",
"PRO","GLU","THR","GLU","GLU","ASP","VAL","GLY","PRO","VAL",
"VAL","GLN","HIS","ILE","TYR","GLU","LEU","ARG","ASN","ASN",
"GLY","PRO","SER","SER","PHE","SER","LYS","ALA","MET","LEU",
"HIS","LEU","GLN","TRP","PRO","TYR","LYS","TYR","ASN","ASN",
"ASN","THR","LEU","LEU","TYR","ILE","LEU","HIS","TYR","ASP",
"ILE","ASP","GLY","PRO","MET","ASN","CYS","THR","SER","ASP",
"MET","GLU","ILE","ASN","PRO","LEU","ARG","ILE","LYS","ILE",
"SER","SER","LEU","GLN","THR","THR","GLU","LYS","ASN","ASP",
"THR","VAL","ALA","GLY","GLN","GLY","GLU","ARG","ASP","HIS",
"LEU","ILE","THR","LYS","ARG","ASP","LEU","ALA","LEU","SER",
"GLU","GLY","ASP","ILE","HIS","THR","LEU","GLY","CYS","GLY",
"VAL","ALA","GLN","CYS","LEU","LYS","ILE","VAL","CYS","GLN",
"VAL","GLY","ARG","LEU","ASP","ARG","GLY","LYS","SER","ALA",
"ILE","LEU","TYR","VAL","LYS","SER","LEU","LEU","TRP","THR",
"GLU","THR","PHE","MET","ASN","LYS","GLU","ASN","GLN","ASN",
"HIS","SER","TYR","SER","LEU","LYS","SER","SER","ALA","SER",
"PHE","ASN","VAL","ILE","GLU","PHE","PRO","TYR","LYS","ASN",
"LEU","PRO","ILE","GLU","ASP","ILE","THR","ASN","SER","THR",
"LEU","VAL","THR","THR","ASN","VAL","THR","TRP","GLY","ILE",
"GLN","PRO","ALA","PRO","MET","PRO","VAL","PRO","VAL","TRP",
"VAL","ILE",
""};
// authAT4 Length = 971 
static const char *_authAT4Sequence[] = {
"PHE","ASN","LEU","ASP","VAL","ASP","SER","PRO","ALA","GLU",
"TYR","SER","GLY","PRO","GLU","GLY","SER","TYR","PHE","GLY",
"PHE","ALA","VAL","ASP","PHE","PHE","VAL","PRO","SER","ALA",
"SER","SER","ARG","MET","PHE","LEU","LEU","VAL","GLY","ALA",
"PRO","LYS","ALA","ASN","THR","THR","GLN","PRO","GLY","ILE",
"VAL","GLU","GLY","GLY","GLN","VAL","LEU","LYS","CYS","ASP",
"TRP","SER","SER","THR","ARG","ARG","CYS","GLN","PRO","ILE",
"GLU","PHE","ASP","ALA","THR","GLY","ASN","ARG","ASP","TYR",
"ALA","LYS","ASP","ASP","PRO","LEU","GLU","PHE","LYS","SER",
"HIS","GLN","TRP","PHE","GLY","ALA","SER","VAL","ARG","SER",
"LYS","GLN","ASP","LYS","ILE","LEU","ALA","CYS","ALA","PRO",
"LEU","TYR","HIS","TRP","ARG","THR","GLU","MET","LYS","GLN",
"GLU","ARG","GLU","PRO","VAL","GLY","THR","CYS","PHE","LEU",
"GLN","ASP","GLY","THR","LYS","THR","VAL","GLU","TYR","ALA",
"PRO","CYS","ARG","SER","GLN","ASP","ILE","ASP","ALA","ASP",
"GLY","GLN","GLY","PHE","CYS","GLN","GLY","GLY","PHE","SER",
"ILE","ASP","PHE","THR","LYS","ALA","ASP","ARG","VAL","LEU",
"LEU","GLY","GLY","PRO","GLY","SER","PHE","UNK","TYR","TRP",
"GLN","GLY","GLN","LEU","ILE","SER","ASP","GLN","VAL","ALA",
"GLU","ILE","VAL","SER","LYS","TYR","ASP","PRO","ASN","VAL",
"TYR","SER","ILE","LYS","TYR","ASN","ASN","GLN","LEU","ALA",
"THR","ARG","THR","ALA","GLN","ALA","ILE","PHE","ASP","ASP",
"SER","ASN","TYR","LEU","GLY","TYR","SER","VAL","ALA","VAL",
"GLY","ASP","PHE","ASN","GLY","ASP","GLY","ILE","ASP","ASP",
"PHE","VAL","SER","GLY","VAL","PRO","ARG","ALA","ALA","ARG",
"THR","LEU","GLY","MET","VAL","TYR","ILE","TYR","ASP","GLY",
"LYS","ASN","MET","SER","SER","LEU","TYR","ASN","PHE","THR",
"GLY","GLU","GLN","MET","ALA","ALA","TYR","PHE","GLY","PHE",
"SER","VAL","ALA","ALA","THR","ASP","ILE","ASN","GLY","ASP",
"ASP","TYR","ALA","ASP","VAL","PHE","ILE","GLY","ALA","PRO",
"LEU","PHE","MET","ASP","ARG","GLY","SER","ASP","GLY","LYS",
"LEU","GLN","GLU","VAL","GLY","GLN","VAL","SER","VAL","SER",
"LEU","GLN","ARG","ALA","SER","GLY","ASP","PHE","GLN","THR",
"THR","LYS","LEU","ASN","GLY","PHE","GLU","VAL","PHE","ALA",
"ARG","PHE","GLY","SER","ALA","ILE","ALA","PRO","LEU","GLY",
"ASP","LEU","ASP","GLN","ASP","GLY","PHE","ASN","ASP","ILE",
"ALA","ILE","ALA","ALA","PRO","TYR","GLY","GLY","GLU","ASP",
"LYS","LYS","GLY","ILE","VAL","TYR","ILE","PHE","ASN","GLY",
"ARG","SER","THR","GLY","LEU","ASN","ALA","VAL","PRO","SER",
"GLN","ILE","LEU","GLU","GLY","GLN","TRP","ALA","ALA","ARG",
"SER","MET","PRO","PRO","SER","PHE","GLY","TYR","SER","MET",
"LYS","GLY","ALA","THR","ASP","ILE","ASP","LYS","ASN","GLY",
"TYR","PRO","ASP","LEU","ILE","VAL","GLY","ALA","PHE","GLY",
"VAL","ASP","ARG","ALA","ILE","LEU","TYR","ARG","ALA","ARG",
"PRO","VAL","ILE","THR","VAL","ASN","ALA","GLY","LEU","GLU",
"VAL","TYR","PRO","SER","ILE","LEU","ASN","GLN","ASP","ASN",
"LYS","THR","CYS","SER","LEU","PRO","GLY","THR","ALA","LEU",
"LYS","VAL","SER","CYS","PHE","ASN","VAL","ARG","PHE","CYS",
"LEU","LYS","ALA","ASP","GLY","LYS","GLY","VAL","LEU","PRO",
"ARG","LYS","LEU","ASN","PHE","GLN","VAL","GLU","LEU","LEU",
"LEU","ASP","LYS","LEU","LYS","GLN","LYS","GLY","ALA","ILE",
"ARG","ARG","ALA","LEU","PHE","LEU","TYR","SER","ARG","SER",
"PRO","SER","HIS","SER","LYS","ASN","MET","THR","ILE","SER",
"ARG","GLY","GLY","LEU","MET","GLN","CYS","GLU","GLU","LEU",
"ILE","ALA","TYR","LEU","ARG","ASP","GLU","SER","GLU","PHE",
"ARG","ASP","LYS","LEU","THR","PRO","ILE","THR","ILE","PHE",
"MET","GLU","TYR","ARG","LEU","ASP","TYR","ARG","THR","ALA",
"ALA","ASP","THR","THR","GLY","LEU","GLN","PRO","ILE","LEU",
"ASN","GLN","PHE","THR","PRO","ALA","ASN","ILE","SER","ARG",
"GLN","ALA","HIS","ILE","LEU","LEU","ASP","CYS","GLY","GLU",
"ASP","ASN","VAL","CYS","LYS","PRO","LYS","LEU","GLU","VAL",
"SER","VAL","ASP","SER","ASP","GLN","LYS","LYS","ILE","TYR",
"ILE","GLY","ASP","ASP","ASN","PRO","LEU","THR","LEU","ILE",
"VAL","LYS","ALA","GLN","ASN","GLN","GLY","GLU","GLY","ALA",
"TYR","GLU","ALA","GLU","LEU","ILE","VAL","SER","ILE","PRO",
"LEU","GLN","ALA","ASP","PHE","ILE","GLY","VAL","VAL","ARG",
"ASN","ASN","GLU","ALA","LEU","ALA","ARG","LEU","SER","CYS",
"ALA","PHE","LYS","THR","GLU","ASN","GLN","THR","ARG","GLN",
"VAL","VAL","CYS","ASP","LEU","GLY","ASN","PRO","MET","LYS",
"ALA","GLY","THR","GLN","LEU","LEU","ALA","GLY","LEU","ARG",
"PHE","SER","VAL","HIS","GLN","GLN","SER","GLU","MET","ASP",
"THR","SER","GLN","VAL","LYS","PHE","ASP","LEU","GLN","ILE",
"GLN","SER","SER","ASN","LEU","PHE","ASP","LYS","VAL","SER",
"PRO","VAL","VAL","SER","HIS","LYS","VAL","ASP","LEU","ALA",
"VAL","LEU","ALA","ALA","VAL","GLU","ILE","ARG","GLY","VAL",
"SER","SER","PRO","ASP","HIS","VAL","PHE","LEU","PRO","ILE",
"PRO","ASN","TRP","GLU","HIS","LYS","GLU","ASN","PRO","GLU",
"THR","GLU","GLU","ASP","VAL","GLY","PRO","VAL","VAL","GLN",
"HIS","ILE","TYR","GLU","LEU","ARG","ASN","ASN","GLY","PRO",
"SER","SER","PHE","SER","LYS","ALA","MET","LEU","HIS","LEU",
"GLN","TRP","PRO","TYR","LYS","TYR","ASN","ASN","ASN","THR",
"LEU","LEU","TYR","ILE","LEU","HIS","TYR","ASP","ILE","ASP",
"GLY","PRO","MET","ASN","CYS","THR","SER","ASP","MET","GLU",
"ILE","ASN","PRO","LEU","ARG","ILE","LYS","ILE","SER","SER",
"LEU","GLN","THR","THR","GLU","LYS","ASN","ASP","THR","VAL",
"ALA","GLY","GLN","GLY","GLU","ARG","ASP","HIS","LEU","ILE",
"THR","LYS","ARG","ASP","LEU","ALA","LEU","SER","GLU","GLY",
"ASP","ILE","HIS","THR","LEU","GLY","CYS","GLY","VAL","ALA",
"GLN","CYS","LEU","LYS","ILE","VAL","CYS","GLN","VAL","GLY",
"ARG","LEU","ASP","ARG","GLY","LYS","SER","ALA","ILE","LEU",
"TYR","VAL","LYS","SER","LEU","LEU","TRP","THR","GLU","THR",
"PHE","MET","ASN","TRP","LYS","GLU","ASN","GLN","ASN","HIS",
"SER","TYR","SER","LEU","LYS","SER","SER","ALA","SER","PHE",
"ASN","VAL","ILE","GLU","PHE","PRO","TYR","LYS","ASN","LEU",
"PRO","ILE","GLU","ASP","ILE","THR","ASN","SER","THR","LEU",
"VAL","THR","THR","ASN","VAL","THR","TRP","GLY","ILE","GLN",
"PRO","ALA","PRO","MET","PRO","VAL","PRO","VAL","TRP","VAL",
"ILE",
""};
// authAT5 Length = 973 
static const char *_authAT5Sequence[] = {
"PHE","ASN","LEU","ASP","VAL","ASP","SER","PRO","ALA","GLU",
"TYR","SER","GLY","PRO","GLU","GLY","SER","TYR","PHE","GLY",
"PHE","ALA","VAL","ASP","PHE","PHE","VAL","PRO","SER","ALA",
"SER","SER","ARG","MET","PHE","LEU","LEU","VAL","GLY","ALA",
"PRO","LYS","ALA","ASN","THR","THR","GLN","PRO","GLY","ILE",
"VAL","GLU","GLY","GLY","GLN","VAL","LEU","LYS","CYS","ASP",
"TRP","SER","SER","THR","ARG","ARG","CYS","GLN","PRO","ILE",
"GLU","PHE","ASP","ALA","THR","GLY","ASN","ARG","ASP","TYR",
"ALA","LYS","ASP","ASP","PRO","LEU","GLU","PHE","LYS","SER",
"HIS","GLN","TRP","PHE","GLY","ALA","SER","VAL","ARG","SER",
"LYS","GLN","ASP","LYS","ILE","LEU","ALA","CYS","ALA","PRO",
"LEU","TYR","HIS","TRP","ARG","THR","GLU","MET","LYS","GLN",
"GLU","ARG","GLU","PRO","VAL","GLY","THR","CYS","PHE","LEU",
"GLN","ASP","GLY","THR","LYS","THR","VAL","GLU","TYR","ALA",
"PRO","CYS","ARG","SER","GLN","ASP","ILE","ASP","ALA","ASP",
"GLY","GLN","GLY","PHE","CYS","GLN","GLY","GLY","PHE","SER",
"ILE","ASP","PHE","THR","LYS","ALA","ASP","ARG","VAL","LEU",
"LEU","GLY","GLY","PRO","GLY","SER","PHE","TYR","TRP","GLN",
"GLY","GLN","LEU","ILE","SER","ASP","GLN","VAL","ALA","GLU",
"ILE","VAL","SER","LYS","TYR","ASP","PRO","ASN","VAL","TYR",
"SER","ILE","LYS","TYR","ASN","ASN","GLN","LEU","ALA","THR",
"ARG","THR","ALA","GLN","ALA","ILE","PHE","ASP","ASP","SER",
"TYR","LEU","GLY","TYR","SER","VAL","ALA","VAL","GLY","ASP",
"PHE","ASN","GLY","ASP","GLY","SER","ILE","ASP","ASP","PHE",
"VAL","SER","GLY","VAL","PRO","ARG","ALA","ALA","ARG","THR",
"LEU","GLY","MET","VAL","TYR","ILE","TYR","ASP","GLY","LYS",
"ASN","MET","SER","SER","LEU","TYR","ASN","PHE","THR","GLY",
"GLU","GLN","MET","ALA","ALA","TYR","PHE","GLY","PHE","SER",
"VAL","ALA","ALA","THR","ASP","ILE","ASN","GLY","ASP","ASP",
"TYR","ALA","ASP","VAL","PHE","ILE","GLY","ALA","PRO","LEU",
"PHE","MET","ASP","ARG","GLY","SER","ASP","GLY","LYS","LEU",
"GLN","GLU","VAL","GLY","GLN","VAL","SER","VAL","SER","LEU",
"GLN","ARG","ALA","SER","GLY","ASP","PHE","GLN","THR","THR",
"LYS","LEU","ASN","GLY","PHE","GLU","VAL","PHE","ALA","ARG",
"PHE","GLY","SER","ALA","ILE","ALA","PRO","LEU","GLY","ASP",
"LEU","ASP","GLN","ASP","GLY","PHE","ASN","ASP","ILE","ALA",
"ILE","ALA","ALA","PRO","TYR","GLY","GLY","GLU","ASP","LYS",
"LYS","GLY","ILE","VAL","TYR","ILE","PHE","ASN","GLY","ARG",
"SER","THR","GLY","LEU","ASN","ALA","VAL","PRO","SER","GLN",
"ILE","LEU","GLU","GLY","GLN","TRP","ALA","ALA","ARG","SER",
"MET","PRO","PRO","SER","PHE","GLY","TYR","SER","MET","LYS",
"GLY","ALA","THR","ASP","ILE","ASP","LYS","ASN","GLY","TYR",
"PRO","ASP","LEU","ILE","VAL","GLY","ALA","PHE","GLY","VAL",
"ASP","ARG","ALA","ILE","LEU","TYR","ARG","ALA","ARG","PRO",
"VAL","ILE","THR","VAL","ASN","ALA","GLY","LEU","GLU","VAL",
"TYR","PRO","SER","ILE","LEU","ASN","GLN","ASP","ASN","LYS",
"THR","CYS","SER","LEU","PRO","GLY","THR","ALA","LEU","LYS",
"VAL","SER","CYS","PHE","ASN","VAL","ARG","PHE","CYS","LEU",
"LYS","ALA","ASP","GLY","LYS","GLY","VAL","LEU","PRO","ARG",
"LYS","LEU","ASN","PHE","GLN","VAL","GLU","LEU","LEU","LEU",
"ASP","LYS","LEU","LYS","GLN","LYS","GLY","ALA","ILE","ARG",
"ARG","ALA","LEU","PHE","LEU","TYR","SER","ARG","SER","PRO",
"SER","HIS","SER","LYS","ASN","MET","THR","ILE","SER","ARG",
"GLY","GLY","LEU","MET","GLN","CYS","GLU","GLU","LEU","ILE",
"ALA","TYR","LEU","ARG","ASP","GLU","SER","GLU","PHE","ARG",
"ASP","LYS","LEU","THR","PRO","ILE","THR","ILE","PHE","MET",
"GLU","TYR","ARG","LEU","ASP","TYR","ARG","THR","ALA","ALA",
"ASP","THR","THR","GLY","LEU","GLN","PRO","ILE","LEU","ASN",
"GLN","PHE","THR","PRO","ALA","ASN","ILE","SER","ARG","GLN",
"ALA","HIS","ILE","LEU","LEU","ASP","CYS","GLY","GLU","ASP",
"ASN","VAL","CYS","LYS","PRO","LYS","LEU","GLU","VAL","SER",
"VAL","ASP","SER","ASP","GLN","LYS","LYS","ILE","TYR","ILE",
"GLY","ASP","ASP","ASN","PRO","LEU","THR","LEU","ILE","VAL",
"LYS","ALA","GLN","ASN","GLN","GLY","GLU","GLY","ALA","TYR",
"GLU","ALA","GLU","LEU","ILE","VAL","SER","ILE","PRO","LEU",
"GLN","ALA","ASP","PHE","ILE","GLY","VAL","VAL","ARG","ASN",
"ASN","GLU","ALA","LEU","ALA","ARG","LEU","SER","CYS","ALA",
"PHE","LYS","THR","GLU","ASN","GLN","THR","ARG","GLN","VAL",
"VAL","CYS","ASP","LEU","GLY","ASN","PRO","MET","LYS","ALA",
"GLY","THR","GLN","LEU","LEU","ALA","GLY","LEU","ARG","PHE",
"SER","VAL","HIS","GLN","GLN","SER","GLU","MET","ASP","THR",
"SER","VAL","LYS","PHE","ASP","LEU","GLN","ILE","GLN","SER",
"SER","ASN","LEU","PHE","ASP","LYS","VAL","SER","PRO","VAL",
"VAL","SER","HIS","LYS","VAL","ASP","LEU","ALA","VAL","LEU",
"ALA","ALA","VAL","GLU","ILE","ARG","GLY","VAL","SER","SER",
"PRO","ASP","HIS","VAL","PHE","LEU","PRO","ILE","PRO","ASN",
"TRP","GLU","HIS","LYS","GLU","ASN","PRO","GLU","THR","GLU",
"GLU","ASP","VAL","GLY","PRO","VAL","VAL","GLN","HIS","ILE",
"TYR","GLU","LEU","ARG","ASN","ASN","GLY","PRO","SER","SER",
"PHE","SER","LYS","ALA","MET","LEU","HIS","LEU","GLN","TRP",
"PRO","TYR","LYS","TYR","ASN","ASN","ASN","THR","LEU","LEU",
"TYR","ILE","LEU","HIS","TYR","ASP","ILE","ASP","GLY","PRO",
"MET","ASN","CYS","THR","SER","ASP","MET","GLU","ILE","ASN",
"PRO","LEU","ARG","ILE","LYS","ILE","SER","SER","LEU","GLN",
"THR","THR","GLU","LYS","ASN","ASP","THR","VAL","ALA","GLY",
"GLN","GLY","GLU","ARG","ASP","HIS","LEU","ILE","THR","LYS",
"ARG","ASP","LEU","ALA","LEU","SER","GLU","GLY","ASP","ILE",
"HIS","THR","LEU","GLY","CYS","GLY","VAL","ALA","GLN","CYS",
"LEU","LYS","ILE","VAL","CYS","GLN","VAL","GLY","ARG","LEU",
"ASP","ARG","GLY","LYS","SER","ALA","ILE","LEU","TYR","VAL",
"LYS","SER","LEU","LEU","TRP","THR","GLU","THR","PHE","MET",
"ASN","LYS","GLU","ASN","GLN","ASN","HIS","SER","TYR","SER",
"LEU","LYS","SER","SER","ALA","SER","PHE","ASN","VAL","ILE",
"GLU","PHE","PRO","TYR","LYS","ASN","LEU","PRO","ILE","UNK",
"UNK","UNK","UNK","UNK","GLU","ASP","ILE","THR","ASN","SER",
"THR","LEU","VAL","THR","THR","ASN","VAL","THR","TRP","GLY",
"ILE","GLN","PRO","ALA","PRO","MET","PRO","VAL","PRO","VAL",
"TRP","VAL","ILE",
""};
// authAT6 Length = 972 
static const char *_authAT6Sequence[] = {
"PHE","ASN","LEU","ASP","VAL","ASP","GLN","GLN","GLN","GLN",
"SER","PRO","ALA","GLU","TYR","SER","GLY","PRO","GLU","GLY",
"SER","TYR","PHE","GLY","PHE","ALA","VAL","ASP","PHE","PHE",
"VAL","PRO","SER","ALA","SER","SER","ARG","MET","PHE","LEU",
"LEU","VAL","GLY","ALA","PRO","LYS","ALA","ASN","THR","THR",
"GLN","PRO","GLY","ILE","VAL","GLU","GLY","GLY","GLN","VAL",
"LEU","LYS","CYS","ASP","TRP","SER","SER","THR","ARG","ARG",
"CYS","GLN","PRO","ILE","GLU","PHE","ASP","ALA","THR","GLY",
"ASN","ARG","ASP","TYR","ALA","LYS","ASP","ASP","PRO","LEU",
"GLU","PHE","LYS","SER","HIS","GLN","TRP","PHE","GLY","ALA",
"SER","VAL","ARG","SER","LYS","GLN","ASP","LYS","ILE","LEU",
"ALA","CYS","ALA","PRO","LEU","TYR","HIS","TRP","ARG","THR",
"GLU","MET","LYS","GLN","GLU","ARG","GLU","PRO","VAL","GLY",
"THR","CYS","PHE","LEU","GLN","ASP","GLY","THR","LYS","THR",
"VAL","GLU","TYR","ALA","PRO","CYS","ARG","SER","GLN","ASP",
"ILE","ASP","ALA","ASP","GLY","GLN","GLY","PHE","CYS","GLN",
"GLY","GLY","PHE","SER","ILE","ASP","PHE","THR","LYS","ALA",
"ASP","ARG","VAL","LEU","LEU","GLY","GLY","PRO","GLY","SER",
"PHE","TYR","TRP","GLN","GLY","GLN","LEU","ILE","SER","ASP",
"GLN","VAL","ALA","GLU","ILE","VAL","SER","LYS","TYR","ASP",
"PRO","ASN","VAL","TYR","SER","ILE","LYS","TYR","ASN","ASN",
"GLN","LEU","ALA","THR","ARG","THR","ALA","GLN","ALA","ILE",
"PHE","ASP","ASP","SER","TYR","LEU","GLY","TYR","SER","VAL",
"ALA","VAL","GLY","ASP","PHE","ASN","GLY","ASP","GLY","ILE",
"ASP","ASP","PHE","VAL","SER","GLY","VAL","PRO","ARG","ALA",
"ALA","ARG","THR","LEU","GLY","MET","VAL","TYR","ILE","TYR",
"ASP","GLY","LYS","ASN","MET","SER","SER","LEU","TYR","ASN",
"PHE","THR","GLY","GLU","GLN","MET","ALA","ALA","TYR","PHE",
"GLY","PHE","SER","VAL","ALA","ALA","THR","ASP","ILE","ASN",
"GLY","ASP","ASP","TYR","ALA","ASP","VAL","PHE","ILE","GLY",
"ALA","PRO","LEU","PHE","MET","ASP","ARG","GLY","SER","ASP",
"GLY","LYS","LEU","GLN","GLU","VAL","GLY","GLN","VAL","SER",
"VAL","SER","LEU","GLN","ARG","ALA","SER","GLY","ASP","PHE",
"GLN","THR","THR","LYS","LEU","ASN","GLY","PHE","GLU","VAL",
"PHE","ALA","ARG","PHE","GLY","SER","ALA","ILE","ALA","PRO",
"LEU","GLY","ASP","LEU","ASP","GLN","ASP","GLY","PHE","ASN",
"ASP","ILE","ALA","ILE","ALA","ALA","PRO","TYR","GLY","GLY",
"GLU","ASP","LYS","LYS","GLY","ILE","VAL","TYR","ILE","PHE",
"ASN","GLY","ARG","SER","THR","GLY","LEU","ASN","ALA","VAL",
"PRO","SER","GLN","ILE","LEU","GLU","GLY","GLN","TRP","ALA",
"ALA","ARG","SER","MET","PRO","PRO","SER","PHE","GLY","TYR",
"SER","MET","LYS","GLY","ALA","THR","ASP","ILE","ASP","LYS",
"ASN","GLY","TYR","PRO","ASP","LEU","ILE","VAL","GLY","ALA",
"PHE","GLY","VAL","ASP","ARG","ALA","ILE","LEU","TYR","ARG",
"ALA","ARG","PRO","VAL","ILE","THR","VAL","ASN","ALA","GLY",
"LEU","GLU","VAL","TYR","PRO","SER","ILE","LEU","ASN","GLN",
"ASP","ASN","LYS","THR","CYS","SER","LEU","PRO","GLY","THR",
"ALA","LEU","LYS","VAL","SER","CYS","PHE","ASN","VAL","ARG",
"PHE","CYS","LEU","LYS","ALA","ASP","GLY","LYS","GLY","VAL",
"LEU","PRO","ARG","LYS","LEU","ASN","PHE","GLN","VAL","GLU",
"LEU","LEU","LEU","ASP","LYS","LEU","LYS","GLN","LYS","GLY",
"ALA","ILE","ARG","ARG","ALA","LEU","PHE","LEU","TYR","SER",
"ARG","SER","PRO","SER","HIS","SER","LYS","ASN","MET","THR",
"ILE","SER","ARG","GLY","GLY","LEU","MET","GLN","CYS","GLU",
"GLU","LEU","ILE","ALA","TYR","LEU","ARG","ASP","GLU","SER",
"GLU","PHE","ARG","ASP","LYS","LEU","THR","PRO","ILE","THR",
"ILE","PHE","MET","GLU","TYR","ARG","LEU","ASP","TYR","ARG",
"THR","ALA","ALA","ASP","THR","THR","GLY","LEU","GLN","PRO",
"ILE","LEU","ASN","GLN","PHE","THR","PRO","ALA","ASN","ILE",
"SER","ARG","GLN","ALA","HIS","ILE","LEU","LEU","ASP","CYS",
"GLY","GLU","ASP","ASN","VAL","CYS","LYS","PRO","LYS","LEU",
"GLU","VAL","SER","VAL","ASP","SER","ASP","GLN","LYS","LYS",
"ILE","TYR","ILE","GLY","ASP","ASP","ASN","PRO","LEU","THR",
"LEU","ILE","VAL","LYS","ALA","GLN","ASN","GLN","GLY","GLU",
"GLY","ALA","TYR","GLU","ALA","GLU","LEU","ILE","VAL","SER",
"ILE","PRO","LEU","GLN","ALA","ASP","PHE","ILE","GLY","VAL",
"VAL","ARG","ASN","ASN","GLU","ALA","LEU","ALA","ARG","LEU",
"SER","CYS","ALA","PHE","LYS","THR","GLU","ASN","GLN","THR",
"ARG","GLN","VAL","VAL","CYS","ASP","LEU","GLY","ASN","PRO",
"MET","LYS","ALA","GLY","THR","GLN","LEU","LEU","ALA","GLY",
"LEU","ARG","PHE","SER","VAL","HIS","GLN","GLN","SER","GLU",
"MET","ASP","THR","SER","VAL","LYS","PHE","ASP","LEU","GLN",
"ILE","GLN","SER","SER","ASN","LEU","PHE","ASP","LYS","VAL",
"SER","PRO","VAL","VAL","SER","HIS","LYS","VAL","ASP","LEU",
"ALA","VAL","LEU","ALA","ALA","VAL","GLU","ILE","ARG","GLY",
"VAL","SER","SER","PRO","ASP","HIS","VAL","PHE","LEU","PRO",
"ILE","PRO","ASN","TRP","GLU","HIS","LYS","GLU","ASN","PRO",
"GLU","THR","GLU","GLU","ASP","VAL","GLY","PRO","VAL","VAL",
"GLN","HIS","ILE","TYR","GLU","LEU","ARG","ASN","ASN","GLY",
"PRO","SER","SER","PHE","SER","LYS","ALA","MET","LEU","HIS",
"LEU","GLN","TRP","PRO","TYR","LYS","TYR","ASN","ASN","ASN",
"THR","LEU","LEU","TYR","ILE","LEU","HIS","TYR","ASP","ILE",
"ASP","GLY","PRO","MET","ASN","CYS","THR","SER","ASP","MET",
"GLU","ILE","ASN","PRO","LEU","ARG","ILE","LYS","ILE","SER",
"SER","LEU","GLN","THR","THR","GLU","LYS","ASN","ASP","THR",
"VAL","ALA","GLY","GLN","GLY","GLU","ARG","ASP","HIS","LEU",
"ILE","THR","LYS","ARG","ASP","LEU","ALA","LEU","SER","GLU",
"GLY","ASP","ILE","HIS","THR","LEU","GLY","CYS","GLY","VAL",
"ALA","GLN","CYS","LEU","LYS","ILE","VAL","CYS","GLN","VAL",
"GLY","ARG","LEU","ASP","ARG","GLY","LYS","SER","ALA","ILE",
"LEU","TYR","VAL","LYS","SER","LEU","LEU","TRP","THR","GLU",
"THR","PHE","MET","ASN","LYS","GLU","ASN","GLN","ASN","HIS",
"SER","TYR","SER","LEU","LYS","SER","SER","ALA","SER","PHE",
"ASN","VAL","ILE","GLU","GLY","PHE","PRO","TYR","LYS","ASN",
"LEU","PRO","ILE","GLU","ASP","ILE","THR","ASN","SER","THR",
"LEU","VAL","THR","THR","ASN","VAL","THR","TRP","GLY","ILE",
"GLN","PRO","ALA","PRO","MET","PRO","VAL","PRO","VAL","TRP",
"VAL","ILE",
""};
// authAT7 Length = 974 
static const char *_authAT7Sequence[] = {
"PHE","ASN","LEU","ASP","VAL","ASP","SER","PRO","ALA","GLU",
"TYR","SER","GLY","PRO","GLU","GLY","SER","TYR","PHE","GLY",
"PHE","ALA","VAL","ASP","PHE","PHE","VAL","PRO","SER","ALA",
"SER","SER","ARG","MET","PHE","LEU","LEU","VAL","GLY","ALA",
"PRO","LYS","ALA","ASN","THR","THR","GLN","PRO","GLY","ILE",
"VAL","GLU","GLY","GLY","GLN","VAL","LEU","LYS","CYS","ASP",
"TRP","SER","SER","THR","ARG","ARG","CYS","GLN","PRO","ILE",
"GLU","PHE","ASP","ALA","THR","GLY","ASN","ARG","ASP","TYR",
"ALA","LYS","ASP","ASP","PRO","LEU","GLU","PHE","LYS","SER",
"HIS","GLN","TRP","PHE","GLY","ALA","SER","VAL","ARG","SER",
"LYS","GLN","ASP","LYS","ILE","LEU","ALA","CYS","ALA","PRO",
"LEU","TYR","HIS","TRP","ARG","THR","GLU","MET","LYS","GLN",
"GLU","ARG","GLU","PRO","VAL","GLY","THR","CYS","PHE","LEU",
"GLN","ASP","GLY","THR","LYS","THR","VAL","GLU","TYR","ALA",
"PRO","CYS","ARG","SER","GLN","ASP","ILE","ASP","ALA","ASP",
"GLY","GLN","GLY","PHE","CYS","GLN","GLY","GLY","PHE","SER",
"ILE","ASP","PHE","THR","LYS","ALA","ASP","ARG","VAL","LEU",
"LEU","GLY","GLY","PRO","GLY","SER","PHE","TYR","TRP","GLN",
"GLY","GLN","LEU","ILE","SER","ASP","GLN","VAL","ALA","GLU",
"ILE","VAL","SER","LYS","TYR","ASP","PRO","ASN","VAL","TYR",
"SER","ILE","LYS","TYR","ASN","ASN","GLN","LEU","ALA","THR",
"ARG","THR","ALA","GLN","ALA","ILE","PHE","ASP","ASP","SER",
"TYR","LEU","GLY","TYR","SER","VAL","ALA","VAL","GLY","ASP",
"PHE","ASN","GLY","ASP","GLY","ILE","ASP","ASP","PHE","VAL",
"SER","GLY","VAL","PRO","ARG","ALA","ALA","ARG","THR","LEU",
"GLY","MET","VAL","TYR","ILE","TYR","ASP","GLY","LYS","ASN",
"MET","SER","SER","LEU","TYR","ASN","PHE","THR","GLY","GLU",
"GLN","MET","ALA","ALA","TYR","PHE","GLY","PHE","SER","VAL",
"ALA","ALA","THR","ASP","ILE","ASN","GLY","ASP","ASP","TYR",
"ALA","ASP","VAL","PHE","ILE","GLY","ALA","PRO","LEU","PHE",
"MET","ASP","ARG","GLY","SER","ASP","GLY","LYS","LEU","GLN",
"GLU","VAL","GLY","GLN","VAL","SER","VAL","SER","LEU","GLN",
"ARG","ALA","SER","GLY","ASP","PHE","GLN","THR","THR","LYS",
"LEU","ASN","GLY","PHE","GLU","VAL","PHE","ALA","ARG","PHE",
"GLY","SER","ALA","ILE","ALA","PRO","LEU","GLY","ASP","LEU",
"ASP","GLN","ASP","GLY","PHE","ASN","ASP","ILE","ALA","ILE",
"ALA","ALA","PRO","TYR","GLY","GLY","GLU","ASP","LYS","LYS",
"GLY","ILE","VAL","TYR","ILE","PHE","ASN","GLY","ARG","SER",
"THR","GLY","LEU","ASN","ALA","VAL","PRO","SER","GLN","ILE",
"LEU","GLU","GLY","GLN","TRP","ALA","ALA","ARG","SER","MET",
"PRO","PRO","SER","PHE","GLY","SER","SER","SER","SER","SER",
"SER","TYR","SER","MET","LYS","GLY","ALA","THR","ASP","ILE",
"ASP","LYS","ASN","GLY","TYR","PRO","ASP","LEU","ILE","VAL",
"GLY","ALA","PHE","GLY","VAL","ASP","ARG","ALA","ILE","LEU",
"TYR","ARG","ALA","ARG","PRO","VAL","ILE","THR","VAL","ASN",
"ALA","GLY","LEU","GLU","VAL","TYR","PRO","SER","ILE","LEU",
"ASN","GLN","ASP","ASN","LYS","THR","CYS","SER","LEU","PRO",
"GLY","THR","ALA","LEU","LYS","VAL","SER","CYS","PHE","ASN",
"VAL","ARG","PHE","CYS","LEU","LYS","ALA","ASP","GLY","LYS",
"GLY","VAL","LEU","PRO","ARG","LYS","LEU","ASN","PHE","GLN",
"VAL","GLU","LEU","LEU","LEU","ASP","LYS","LEU","LYS","GLN",
"LYS","GLY","ALA","ILE","ARG","ARG","ALA","LEU","PHE","LEU",
"TYR","SER","ARG","SER","PRO","SER","HIS","SER","LYS","ASN",
"MET","THR","ILE","SER","ARG","GLY","GLY","LEU","MET","GLN",
"CYS","GLU","GLU","LEU","ILE","ALA","TYR","LEU","ARG","ASP",
"GLU","SER","GLU","PHE","ARG","ASP","LYS","LEU","THR","PRO",
"ILE","THR","ILE","PHE","MET","GLU","TYR","ARG","LEU","ASP",
"TYR","ARG","THR","ALA","ALA","ASP","THR","THR","GLY","LEU",
"GLN","PRO","ILE","LEU","ASN","GLN","PHE","THR","PRO","ALA",
"ASN","ILE","SER","ARG","GLN","ALA","HIS","ILE","LEU","LEU",
"ASP","CYS","GLY","GLU","ASP","ASN","VAL","CYS","LYS","PRO",
"LYS","LEU","GLU","VAL","SER","VAL","ASP","SER","ASP","GLN",
"LYS","LYS","ILE","TYR","ILE","GLY","ASP","ASP","ASN","PRO",
"LEU","THR","LEU","ILE","VAL","LYS","ALA","GLN","ASN","GLN",
"GLY","GLU","GLY","ALA","TYR","GLU","ALA","GLU","LEU","ILE",
"VAL","SER","ILE","PRO","LEU","GLN","ALA","ASP","PHE","ILE",
"GLY","VAL","VAL","ARG","ASN","ASN","GLU","ALA","LEU","ALA",
"ARG","LEU","SER","CYS","ALA","PHE","LYS","THR","GLU","ASN",
"GLN","THR","ARG","GLN","VAL","VAL","CYS","ASP","LEU","GLY",
"ASN","PRO","MET","LYS","ALA","GLY","THR","GLN","LEU","LEU",
"ALA","GLY","LEU","ARG","PHE","SER","VAL","HIS","GLN","GLN",
"SER","GLU","MET","ASP","THR","SER","VAL","LYS","PHE","ASP",
"LEU","GLN","ILE","GLN","SER","SER","ASN","LEU","PHE","ASP",
"LYS","VAL","SER","PRO","VAL","VAL","SER","HIS","LYS","VAL",
"ASP","LEU","ALA","VAL","LEU","ALA","ALA","VAL","GLU","ILE",
"ARG","GLY","GLU","VAL","SER","SER","PRO","ASP","HIS","VAL",
"PHE","LEU","PRO","ILE","PRO","ASN","TRP","GLU","HIS","LYS",
"GLU","ASN","PRO","GLU","THR","GLU","GLU","ASP","VAL","GLY",
"PRO","VAL","VAL","GLN","HIS","ILE","TYR","GLU","LEU","ARG",
"ASN","ASN","GLY","PRO","SER","SER","PHE","SER","LYS","ALA",
"MET","LEU","HIS","LEU","GLN","TRP","PRO","TYR","LYS","TYR",
"ASN","ASN","ASN","THR","LEU","LEU","TYR","ILE","LEU","HIS",
"TYR","ASP","ILE","ASP","GLY","PRO","MET","ASN","CYS","THR",
"SER","ASP","MET","GLU","ILE","ASN","PRO","LEU","ARG","ILE",
"LYS","ILE","SER","SER","LEU","GLN","THR","THR","GLU","LYS",
"ASN","ASP","THR","VAL","ALA","GLY","GLN","GLY","GLU","ARG",
"ASP","HIS","LEU","ILE","THR","LYS","ARG","ASP","LEU","ALA",
"LEU","SER","GLU","GLY","ASP","ILE","HIS","THR","LEU","GLY",
"CYS","GLY","VAL","ALA","GLN","CYS","LEU","LYS","ILE","VAL",
"CYS","GLN","VAL","GLY","ARG","LEU","ASP","ARG","GLY","LYS",
"SER","ALA","ILE","LEU","TYR","VAL","LYS","SER","LEU","LEU",
"TRP","THR","GLU","THR","PHE","MET","ASN","LYS","GLU","ASN",
"GLN","ASN","HIS","SER","TYR","SER","LEU","LYS","SER","SER",
"ALA","SER","PHE","ASN","VAL","ILE","GLU","PHE","PRO","TYR",
"LYS","ASN","LEU","PRO","ILE","GLU","ASP","ILE","THR","ASN",
"SER","THR","LEU","VAL","THR","THR","ASN","VAL","THR","TRP",
"GLY","ILE","GLN","PRO","ALA","PRO","MET","PRO","VAL","PRO",
"VAL","TRP","VAL","ILE",
""};
// authAT8 Length = 970 
static const char *_authAT8Sequence[] = {
"PHE","ASN","LEU","ASP","VAL","ASP","SER","PRO","ALA","GLU",
"TYR","SER","GLY","PRO","GLU","GLY","SER","TYR","PHE","GLY",
"PHE","ALA","VAL","ASP","PHE","PHE","VAL","PRO","SER","ALA",
"SER","SER","ARG","MET","PHE","LEU","LEU","VAL","GLY","ALA",
"PRO","LYS","ALA","ASN","THR","THR","GLN","PRO","GLY","ILE",
"VAL","GLU","GLY","GLY","GLN","VAL","LEU","LYS","CYS","ASP",
"TRP","SER","SER","THR","ARG","ARG","CYS","GLN","PRO","ILE",
"GLU","PHE","ASP","ALA","THR","GLY","ASN","ARG","ASP","TYR",
"ALA","LYS","ASP","ASP","PRO","LEU","GLU","PHE","LYS","SER",
"HIS","GLN","TRP","PHE","GLY","ALA","SER","VAL","ARG","SER",
"LYS","GLN","ASP","LYS","ILE","LEU","ALA","CYS","ALA","PRO",
"LEU","TYR","HIS","TRP","ARG","THR","GLU","MET","LYS","GLN",
"GLU","ARG","GLU","PRO","VAL","GLY","THR","CYS","PHE","LEU",
"GLN","ASP","GLY","THR","LYS","THR","VAL","GLU","TYR","ALA",
"PRO","CYS","ARG","SER","GLN","ASP","ILE","ASP","ALA","ASP",
"GLY","GLN","GLY","PHE","CYS","GLN","GLY","GLY","PHE","SER",
"ILE","ASP","PHE","THR","LYS","ALA","ASP","ARG","VAL","LEU",
"LEU","GLY","GLY","PRO","GLY","SER","PHE","TYR","TRP","GLN",
"GLY","GLN","LEU","ILE","SER","ASP","GLN","VAL","ALA","GLU",
"ILE","VAL","SER","LYS","TYR","ASP","PRO","ASN","VAL","TYR",
"SER","ILE","LYS","TYR","ASN","ASN","GLN","LEU","ALA","THR",
"ARG","THR","ALA","GLN","ALA","ILE","PHE","ASP","ASP","SER",
"TYR","LEU","GLY","TYR","SER","VAL","ALA","VAL","GLY","ASP",
"PHE","ASN","GLY","ASP","GLY","ILE","ASP","ASP","PHE","VAL",
"SER","GLY","VAL","PRO","ARG","ALA","ALA","ARG","THR","LEU",
"GLY","MET","VAL","TYR","ILE","ASX","TYR","ASP","GLY","LYS",
"ASN","MET","SER","SER","LEU","TYR","ASN","PHE","THR","GLY",
"GLU","GLN","MET","ALA","ALA","TYR","PHE","GLY","PHE","SER",
"VAL","ALA","ALA","THR","ASP","ILE","ASN","GLY","ASP","ASP",
"TYR","ALA","ASP","VAL","PHE","ILE","GLY","ALA","PRO","LEU",
"PHE","MET","ASP","ARG","GLY","SER","ASP","GLY","LYS","LEU",
"GLN","GLU","VAL","GLY","GLN","VAL","SER","VAL","SER","LEU",
"GLN","ARG","ALA","SER","GLY","ASP","PHE","GLN","THR","THR",
"LYS","LEU","ASN","GLY","PHE","GLU","VAL","PHE","ALA","ARG",
"PHE","GLY","SER","ALA","ILE","ALA","PRO","LEU","GLY","ASP",
"LEU","ASP","GLN","ASP","GLY","PHE","ASN","ASP","ILE","ALA",
"ILE","ALA","ALA","PRO","TYR","GLY","GLY","GLU","ASP","LYS",
"LYS","GLY","ILE","VAL","TYR","ILE","PHE","ASN","GLY","ARG",
"SER","THR","GLY","LEU","ASN","ALA","VAL","PRO","SER","GLN",
"ILE","LEU","GLU","GLY","GLN","TRP","ALA","ALA","ARG","SER",
"MET","PRO","PRO","SER","PHE","GLY","TYR","SER","MET","LYS",
"GLY","ALA","THR","ASP","ILE","ASP","LYS","ASN","GLY","TYR",
"PRO","ASP","LEU","ILE","VAL","GLY","ALA","PHE","GLY","VAL",
"ASP","ARG","ALA","ILE","LEU","TYR","ARG","ALA","ARG","PRO",
"VAL","ILE","THR","VAL","ASN","ALA","GLY","LEU","GLU","VAL",
"TYR","PRO","SER","ILE","LEU","ASN","GLN","ASP","ASN","LYS",
"THR","CYS","SER","LEU","PRO","GLY","THR","ALA","LEU","LYS",
"VAL","SER","CYS","PHE","ASN","VAL","ARG","PHE","CYS","LEU",
"LYS","ALA","ASP","GLY","LYS","GLY","VAL","LEU","PRO","ARG",
"LYS","LEU","ASN","PHE","GLN","VAL","GLU","LEU","LEU","LEU",
"ASP","LYS","LEU","LYS","GLN","LYS","GLY","ALA","ILE","ARG",
"ARG","ALA","LEU","PHE","LEU","TYR","SER","ARG","SER","PRO",
"SER","HIS","SER","LYS","ASN","MET","THR","ILE","SER","ARG",
"GLY","GLY","LEU","MET","GLN","CYS","GLU","GLU","LEU","ILE",
"ALA","TYR","LEU","ARG","ASP","GLU","SER","GLU","PHE","ARG",
"ASP","LYS","LEU","THR","PRO","ILE","THR","ILE","PHE","MET",
"GLU","TYR","ARG","LEU","ASP","TYR","ARG","THR","ALA","ALA",
"ASP","THR","THR","GLY","LEU","GLN","PRO","ILE","LEU","ASN",
"GLN","PHE","THR","PRO","ALA","ASN","ILE","SER","ARG","GLN",
"ALA","HIS","ILE","LEU","LEU","ASP","CYS","GLY","GLU","ASP",
"ASN","VAL","CYS","LYS","PRO","LYS","LEU","GLU","VAL","SER",
"VAL","ASP","SER","ASP","GLN","LYS","LYS","ILE","TYR","ILE",
"GLY","ASP","ASP","ASN","PRO","LEU","THR","LEU","ILE","VAL",
"LYS","ALA","GLN","ASN","GLN","GLY","GLU","GLY","ALA","TYR",
"GLU","ALA","GLU","LEU","ILE","VAL","SER","ILE","PRO","LEU",
"GLN","ALA","ASP","PHE","ILE","GLY","VAL","VAL","ARG","ASN",
"ASN","GLU","ALA","LEU","ALA","ARG","LEU","SER","CYS","ALA",
"PHE","LYS","THR","GLU","ASN","GLN","THR","ARG","GLN","VAL",
"VAL","CYS","ASP","LEU","GLY","ASN","PRO","MET","LYS","ALA",
"GLY","THR","GLN","LEU","LEU","ALA","GLY","LEU","ARG","PHE",
"SER","VAL","HIS","GLN","GLN","SER","GLU","MET","ASP","THR",
"SER","VAL","LYS","PHE","ASP","LEU","GLN","ILE","GLN","SER",
"SER","ASN","LEU","PHE","ASP","LYS","VAL","SER","PRO","VAL",
"VAL","SER","HIS","LYS","VAL","ASP","LEU","ALA","VAL","LEU",
"ALA","ALA","VAL","GLU","ILE","ARG","GLY","VAL","SER","SER",
"PRO","ASP","HIS","VAL","PHE","MET","LEU","PRO","SER","ILE",
"PRO","ASN","TRP","GLU","HIS","LYS","GLU","ASN","PRO","GLU",
"THR","GLU","GLU","ASP","VAL","GLY","PRO","VAL","VAL","GLN",
"HIS","ILE","TYR","GLU","LEU","ARG","ASN","ASN","GLY","PRO",
"SER","SER","PHE","SER","LYS","ALA","MET","LEU","HIS","LEU",
"GLN","TRP","PRO","TYR","LYS","TYR","ASN","ASN","ASN","THR",
"LEU","LEU","TYR","ILE","LEU","HIS","TYR","ASP","ILE","ASP",
"GLY","PRO","MET","ASN","CYS","THR","SER","ASP","MET","GLU",
"ILE","ASN","PRO","LEU","ARG","ILE","LYS","ILE","SER","SER",
"LEU","GLN","THR","THR","GLU","LYS","ASN","ASP","THR","VAL",
"ALA","GLY","GLN","GLY","GLU","ARG","ASP","HIS","LEU","ILE",
"THR","LYS","ARG","ASP","LEU","ALA","LEU","SER","GLU","GLY",
"ASP","ILE","HIS","THR","LEU","GLY","CYS","GLY","VAL","ALA",
"GLN","CYS","LEU","LYS","ILE","VAL","CYS","GLN","VAL","GLY",
"ARG","LEU","ASP","ARG","GLY","LYS","SER","ALA","ILE","LEU",
"TYR","VAL","LYS","SER","LEU","LEU","TRP","THR","GLU","THR",
"PHE","MET","ASN","LYS","GLU","ASN","GLN","ASN","HIS","SER",
"TYR","SER","LEU","LYS","SER","SER","ALA","SER","PHE","ASN",
"VAL","ILE","GLU","PHE","PRO","TYR","LYS","ASN","LEU","PRO",
"ILE","GLU","ASP","ILE","THR","ASN","SER","THR","LEU","VAL",
"THR","THR","ASN","VAL","THR","TRP","GLY","ILE","GLN","PRO",
"ALA","PRO","MET","PRO","VAL","PRO","VAL","TRP","VAL","ILE",
""};
// authAT9 Length = 980 
static const char *_authAT9Sequence[] = {
"PHE","ASN","LEU","ASP","VAL","ASP","SER","PRO","ALA","GLU",
"TYR","SER","GLY","PRO","GLU","GLY","SER","TYR","PHE","GLY",
"PHE","ALA","VAL","ASP","PHE","PHE","VAL","PRO","SER","ALA",
"SER","SER","ARG","MET","PHE","LEU","LEU","VAL","GLY","ALA",
"PRO","LYS","ALA","ASN","THR","THR","GLN","PRO","GLY","MET",
"ILE","VAL","GLU","GLY","GLY","GLN","VAL","LEU","LYS","CYS",
"ASP","TRP","SER","SER","THR","ARG","ARG","CYS","GLN","PRO",
"ILE","GLU","PHE","ASP","ALA","THR","GLY","ASN","ARG","ASP",
"TYR","ALA","LYS","ASP","ASP","PRO","LEU","GLU","PHE","LYS",
"SER","HIS","GLN","TRP","PHE","GLY","ALA","SER","VAL","ARG",
"SER","LYS","GLN","ASP","LYS","ILE","LEU","ALA","CYS","ALA",
"PRO","LEU","TYR","HIS","TRP","ARG","THR","GLU","MET","LYS",
"GLN","GLU","ARG","GLU","PRO","VAL","GLY","THR","CYS","PHE",
"LEU","GLN","ASP","GLY","THR","LYS","THR","VAL","GLU","TYR",
"ALA","PRO","CYS","ARG","SER","GLN","ASP","ILE","ASP","ALA",
"ASP","GLY","GLN","GLY","PHE","CYS","GLN","GLY","GLY","PHE",
"SER","ILE","ASP","PHE","THR","LYS","ALA","ASP","ARG","VAL",
"LEU","LEU","GLY","GLY","PRO","GLY","SER","PHE","TYR","TRP",
"GLN","GLY","GLN","LEU","ILE","SER","ASP","GLN","VAL","ALA",
"GLU","ILE","VAL","SER","LYS","TYR","ASP","PRO","ASN","VAL",
"TYR","SER","ILE","LYS","TYR","ASN","ASN","GLN","LEU","ALA",
"THR","ARG","THR","ALA","GLN","ALA","ILE","PHE","ASP","ASP",
"SER","TYR","LEU","GLY","TYR","SER","VAL","ALA","VAL","GLY",
"ASP","PHE","ASN","GLY","ASP","GLY","ILE","ASP","ASP","PHE",
"VAL","SER","GLY","VAL","PRO","ARG","ALA","ALA","ARG","THR",
"LEU","GLY","MET","VAL","TYR","ILE","TYR","ASP","GLY","LYS",
"ASN","MET","SER","SER","LEU","TYR","ASN","PHE","THR","GLY",
"GLU","GLN","MET","ALA","ALA","TYR","PHE","GLY","PHE","SER",
"VAL","ALA","ALA","THR","ASP","ILE","ASN","GLY","ASP","ASP",
"TYR","ALA","ASP","VAL","PHE","ILE","GLY","ALA","PRO","LEU",
"PHE","MET","ASP","ARG","GLY","SER","ASP","GLY","LYS","LEU",
"GLN","GLU","VAL","GLY","GLN","VAL","SER","VAL","SER","LEU",
"GLN","ARG","ALA","SER","GLY","ASP","PHE","GLN","THR","THR",
"LYS","LEU","ASN","GLY","PHE","GLU","VAL","PHE","ALA","ARG",
"PHE","GLY","TRP","TRP","TRP","TRP","TRP","TRP","TRP","TRP",
"TRP","SER","ALA","ILE","ALA","PRO","LEU","GLY","ASP","LEU",
"ASP","GLN","ASP","GLY","PHE","ASN","ASP","ILE","ALA","ILE",
"ALA","ALA","PRO","TYR","GLY","GLY","GLU","ASP","LYS","LYS",
"GLY","ILE","VAL","TYR","ILE","PHE","ASN","GLY","ARG","SER",
"THR","GLY","LEU","ASN","ALA","VAL","PRO","SER","GLN","ILE",
"LEU","GLU","GLY","GLN","TRP","ALA","ALA","ARG","SER","MET",
"PRO","PRO","SER","PHE","GLY","TYR","SER","MET","LYS","GLY",
"ALA","THR","ASP","ILE","ASP","LYS","ASN","GLY","TYR","PRO",
"ASP","LEU","ILE","VAL","GLY","ALA","PHE","GLY","VAL","ASP",
"ARG","ALA","ILE","LEU","TYR","ARG","ALA","ARG","PRO","VAL",
"ILE","THR","VAL","ASN","ALA","GLY","LEU","GLU","VAL","TYR",
"PRO","SER","ILE","LEU","ASN","GLN","ASP","ASN","LYS","THR",
"CYS","SER","LEU","PRO","GLY","THR","ALA","LEU","LYS","VAL",
"SER","CYS","PHE","ASN","VAL","ARG","PHE","CYS","LEU","LYS",
"ALA","ASP","GLY","LYS","GLY","VAL","LEU","PRO","ARG","LYS",
"LEU","ASN","PHE","GLN","VAL","GLU","LEU","LEU","LEU","ASP",
"LYS","LEU","LYS","GLN","LYS","GLY","ALA","ILE","ARG","ARG",
"ALA","LEU","PHE","LEU","TYR","SER","ARG","SER","PRO","SER",
"HIS","SER","LYS","ASN","MET","THR","ILE","SER","ARG","GLY",
"GLY","LEU","MET","GLN","CYS","GLU","GLU","LEU","ILE","ALA",
"TYR","LEU","ARG","ASP","GLU","SER","GLU","PHE","ARG","ASP",
"LYS","LEU","THR","PRO","ILE","THR","ILE","PHE","MET","GLU",
"TYR","ARG","LEU","ASP","TYR","ARG","THR","ALA","ALA","ASP",
"THR","THR","GLY","LEU","GLN","PRO","ILE","LEU","ASN","GLN",
"PHE","THR","PRO","ALA","ASN","ILE","SER","ARG","GLN","ALA",
"HIS","ILE","LEU","LEU","ASP","CYS","GLY","GLU","ASP","ASN",
"VAL","CYS","LYS","PRO","LYS","LEU","GLU","VAL","SER","VAL",
"ASP","SER","ASP","GLN","LYS","LYS","ILE","TYR","ILE","GLY",
"ASP","ASP","ASN","PRO","LEU","THR","LEU","ILE","VAL","LYS",
"ALA","GLN","ASN","GLN","GLY","GLU","GLY","ALA","TYR","GLU",
"ALA","GLU","LEU","ILE","VAL","SER","ILE","PRO","LEU","GLN",
"ALA","ASP","PHE","ILE","GLY","VAL","VAL","ARG","ASN","ASN",
"GLU","ALA","LEU","ALA","ARG","LEU","SER","CYS","ALA","PHE",
"LYS","THR","GLU","ASN","GLN","THR","ARG","GLU","GLN","VAL",
"VAL","CYS","ASP","LEU","GLY","ASN","PRO","MET","LYS","ALA",
"GLY","THR","GLN","LEU","LEU","ALA","GLY","LEU","ARG","PHE",
"SER","VAL","PRO","HIS","GLN","GLN","SER","GLU","MET","ASP",
"THR","SER","VAL","LYS","PHE","ASP","LEU","GLN","ILE","GLN",
"SER","SER","ASN","LEU","PHE","ASP","LYS","VAL","SER","PRO",
"VAL","VAL","SER","HIS","LYS","VAL","ASP","LEU","ALA","VAL",
"LEU","ALA","ALA","VAL","GLU","ILE","ARG","GLY","VAL","SER",
"SER","PRO","ASP","HIS","VAL","PHE","LEU","PRO","ILE","PRO",
"ASN","TRP","GLU","HIS","LYS","GLU","ASN","PRO","GLU","THR",
"GLU","GLU","ASP","VAL","GLY","PRO","VAL","VAL","GLN","HIS",
"ILE","TYR","GLU","LEU","ARG","ASN","ASN","GLY","PRO","SER",
"SER","PHE","SER","LYS","ALA","MET","LEU","HIS","LEU","GLN",
"TRP","PRO","TYR","LYS","TYR","ASN","ASN","ASN","THR","LEU",
"LEU","TYR","ILE","LEU","HIS","TYR","ASP","ILE","ASP","GLY",
"PRO","MET","ASN","CYS","THR","SER","ASP","MET","GLU","ILE",
"ASN","PRO","LEU","ARG","ILE","LYS","ILE","SER","GLN","SER",
"LEU","GLN","THR","THR","GLU","LYS","ASN","ASP","THR","VAL",
"ALA","GLY","GLN","GLY","GLU","ARG","ASP","HIS","LEU","ILE",
"THR","LYS","ARG","ASP","LEU","ALA","LEU","SER","GLU","GLY",
"ASP","ILE","HIS","THR","LEU","GLY","CYS","GLY","VAL","ALA",
"GLN","CYS","LEU","LYS","ILE","VAL","CYS","GLN","VAL","GLY",
"ARG","LEU","ASP","ARG","GLY","LYS","SER","ALA","ILE","LEU",
"TYR","VAL","LYS","SER","LEU","LEU","TRP","THR","GLU","THR",
"PHE","MET","ASN","LYS","GLU","ASN","GLN","ASN","HIS","SER",
"TYR","SER","LEU","LYS","SER","SER","ALA","SER","PHE","ASN",
"VAL","ILE","GLU","PHE","PRO","TYR","LYS","ASN","LEU","PRO",
"ILE","GLU","ASP","ILE","THR","ASN","SER","THR","LEU","VAL",
"THR","THR","ASN","VAL","THR","TRP","GLY","ILE","GLN","PRO",
"ALA","PRO","MET","PRO","VAL","PRO","VAL","TRP","VAL","ILE",
""};
// authAT10 Length = 967 
static const char *_authAT10Sequence[] = {
"PHE","ASN","LEU","ASP","VAL","ASP","SER","PRO","ALA","GLU",
"TYR","SER","GLY","PRO","GLU","GLY","SER","TYR","PHE","GLY",
"PHE","ALA","VAL","ASP","PHE","PHE","VAL","PRO","SER","ALA",
"SER","SER","ARG","MET","PHE","LEU","LEU","VAL","GLY","ALA",
"PRO","LYS","ALA","ASN","THR","THR","GLN","PRO","GLY","ILE",
"VAL","GLU","GLY","GLY","GLN","VAL","LEU","LYS","CYS","ASP",
"TRP","SER","SER","THR","ARG","ARG","CYS","GLN","PRO","ILE",
"GLU","PHE","ASP","ALA","THR","GLY","ASN","ARG","ASP","TYR",
"ALA","LYS","ASP","ASP","PRO","LEU","GLU","PHE","LYS","SER",
"HIS","GLN","TRP","PHE","GLY","ALA","SER","VAL","ARG","SER",
"LYS","GLN","ASP","LYS","ILE","LEU","ALA","CYS","ALA","PRO",
"LEU","TYR","HIS","TRP","ARG","THR","GLU","MET","LYS","GLN",
"GLU","ARG","GLU","PRO","VAL","GLY","THR","CYS","PHE","LEU",
"GLN","ASP","GLY","THR","LYS","THR","VAL","GLU","TYR","ALA",
"PRO","CYS","ARG","SER","GLN","ASP","ILE","ASP","ALA","ASP",
"GLY","GLN","GLY","PHE","CYS","GLN","GLY","GLY","PHE","SER",
"ILE","ASP","PHE","THR","LYS","ALA","ASP","ARG","VAL","LEU",
"LEU","GLY","GLY","PRO","GLY","SER","PHE","TYR","TRP","GLN",
"GLY","GLN","LEU","ILE","SER","ASP","GLN","VAL","ALA","GLU",
"ILE","VAL","SER","LYS","TYR","ASP","PRO","ASN","VAL","TYR",
"SER","ILE","LYS","TYR","ASN","ASN","GLN","LEU","ALA","THR",
"ARG","THR","ALA","GLN","ALA","ILE","PHE","ASP","ASP","SER",
"TYR","LEU","GLY","TYR","SER","VAL","ALA","VAL","GLY","ASP",
"PHE","ASN","GLY","ASP","GLY","ILE","ASP","ASP","PHE","VAL",
"SER","GLY","VAL","PRO","ARG","ALA","ALA","ARG","THR","LEU",
"GLY","MET","VAL","TYR","ILE","TYR","ASP","GLY","LYS","ASN",
"MET","SER","SER","LEU","TYR","ASN","PHE","THR","GLY","GLU",
"GLN","MET","ALA","ALA","TYR","PHE","GLY","PHE","SER","VAL",
"ALA","ALA","THR","ASP","ILE","ASN","GLY","ASP","ASP","TYR",
"ALA","ASP","VAL","PHE","ILE","GLY","ALA","PRO","LEU","PHE",
"MET","ASP","ARG","GLY","SER","ASP","GLY","LYS","LEU","GLN",
"GLU","VAL","GLY","GLN","VAL","SER","VAL","SER","LEU","GLN",
"ARG","ALA","SER","GLY","ASP","PHE","GLN","THR","THR","LYS",
"LEU","ASN","GLY","PHE","GLU","VAL","PHE","ALA","ARG","PHE",
"GLY","SER","ALA","ILE","ALA","PRO","LEU","GLY","ASP","LEU",
"ASP","GLN","ASP","GLY","PHE","ASN","ASP","ILE","ALA","ILE",
"ALA","ALA","PRO","TYR","GLY","GLY","GLU","ASP","LYS","LYS",
"GLY","ILE","VAL","TYR","ILE","PHE","ASN","GLY","ARG","SER",
"THR","GLY","LEU","ASN","ALA","VAL","PRO","SER","GLN","ILE",
"LEU","GLU","GLY","GLN","TRP","ALA","ALA","ARG","SER","MET",
"PRO","PRO","SER","PHE","GLY","TYR","SER","MET","LYS","GLY",
"ALA","THR","ASP","ILE","ASP","LYS","ASN","GLY","TYR","PRO",
"ASP","LEU","ILE","VAL","GLY","ALA","PHE","GLY","VAL","ASP",
"ARG","ALA","ILE","LEU","TYR","ARG","ALA","ARG","PRO","VAL",
"ILE","THR","VAL","ASN","ALA","GLY","LEU","GLU","VAL","TYR",
"PRO","SER","ILE","LEU","ASN","GLN","ASP","ASN","LYS","THR",
"CYS","SER","LEU","PRO","GLY","THR","ALA","LEU","LYS","VAL",
"SER","CYS","PHE","ASN","VAL","ARG","PHE","CYS","LEU","LYS",
"ALA","ASP","GLY","LYS","GLY","VAL","LEU","PRO","ARG","LYS",
"LEU","ASN","PHE","GLN","VAL","GLU","LEU","LEU","LEU","ASP",
"LYS","LEU","LYS","GLN","LYS","GLY","ALA","ILE","ARG","ARG",
"ALA","LEU","PHE","LEU","TYR","SER","ARG","SER","PRO","SER",
"HIS","SER","LYS","ASN","MET","THR","ILE","SER","ARG","GLY",
"GLY","LEU","MET","GLN","CYS","GLU","GLU","LEU","ILE","ALA",
"TYR","LEU","ARG","ASP","GLU","SER","GLU","PHE","ARG","ASP",
"LYS","LEU","THR","PRO","ILE","THR","ILE","PHE","MET","GLU",
"TYR","ARG","LEU","ASP","TYR","ARG","THR","ALA","ALA","ASP",
"THR","THR","GLY","LEU","GLN","PRO","ILE","LEU","ASN","GLN",
"PHE","THR","PRO","ALA","ASN","ILE","SER","ARG","GLN","ALA",
"HIS","ILE","LEU","LEU","ASP","CYS","GLY","GLU","ASP","ASN",
"VAL","CYS","LYS","PRO","LYS","LEU","GLU","VAL","SER","VAL",
"ASP","SER","ASP","GLN","LYS","LYS","ILE","TYR","ILE","GLY",
"ASP","ASP","ASN","PRO","LEU","THR","LEU","ILE","VAL","LYS",
"ALA","GLN","ASN","GLN","GLY","GLU","GLY","ALA","TYR","GLU",
"ALA","GLU","LEU","ILE","VAL","SER","ILE","PRO","LEU","GLN",
"ALA","ASP","PHE","ILE","GLY","VAL","VAL","ARG","ASN","ASN",
"GLU","ALA","LEU","ALA","ARG","LEU","SER","CYS","ALA","PHE",
"LYS","THR","GLU","ASN","GLN","THR","ARG","GLN","VAL","VAL",
"CYS","ASP","LEU","GLY","ASN","PRO","MET","LYS","ALA","GLY",
"THR","GLN","LEU","LEU","ALA","GLY","LEU","ARG","PHE","SER",
"VAL","HIS","GLN","GLN","SER","GLU","MET","ASP","THR","SER",
"VAL","LYS","PHE","ASP","LEU","GLN","ILE","GLN","SER","SER",
"ASN","LEU","PHE","ASP","LYS","VAL","SER","PRO","VAL","VAL",
"SER","HIS","LYS","VAL","ASP","LEU","ALA","VAL","LEU","ALA",
"ALA","VAL","GLU","ILE","ARG","GLY","VAL","SER","SER","PRO",
"ASP","HIS","VAL","PHE","LEU","PRO","ILE","PRO","ASN","TRP",
"GLU","HIS","LYS","GLU","ASN","PRO","GLU","THR","GLU","GLU",
"ASP","VAL","GLY","PRO","VAL","VAL","GLN","HIS","ILE","TYR",
"GLU","LEU","ARG","ASN","ASN","GLY","PRO","SER","SER","PHE",
"SER","LYS","ALA","MET","LEU","HIS","LEU","GLN","TRP","PRO",
"TYR","LYS","TYR","ASN","ASN","ASN","THR","LEU","LEU","TYR",
"ILE","LEU","HIS","TYR","ASP","ILE","ASP","GLY","PRO","MET",
"ASN","CYS","THR","SER","ASP","MET","GLU","ILE","ASN","PRO",
"LEU","ARG","ILE","LYS","ILE","SER","SER","LEU","GLN","THR",
"THR","GLU","LYS","ASN","ASP","THR","VAL","ALA","GLY","GLN",
"GLY","GLU","ARG","ASP","HIS","LEU","ILE","THR","LYS","ARG",
"ASP","LEU","ALA","LEU","SER","GLU","GLY","ASP","ILE","HIS",
"THR","LEU","GLY","CYS","GLY","VAL","ALA","GLN","CYS","LEU",
"LYS","ILE","VAL","CYS","GLN","VAL","GLY","ARG","LEU","ASP",
"ARG","GLY","LYS","SER","ALA","ILE","LEU","TYR","VAL","LYS",
"SER","LEU","LEU","TRP","THR","GLU","THR","PHE","MET","ASN",
"LYS","GLU","ASN","GLN","ASN","HIS","SER","TYR","SER","LEU",
"LYS","SER","SER","ALA","SER","PHE","ASN","VAL","ILE","GLU",
"PHE","PRO","TYR","LYS","ASN","LEU","PRO","ILE","GLU","ASP",
"ILE","THR","ASN","SER","THR","LEU","VAL","THR","THR","ASN",
"VAL","THR","TRP","GLY","ILE","GLN","PRO","ALA","PRO","MET",
"PRO","VAL","PRO","VAL","TRP","VAL","ILE",
""};

}
#endif
