#include <stdio.h>
#include <stdlib.h>

#include "PseudoMultiAlign.h"

/*
#define NUM_A 30
static const char *seq_a[NUM_A] = { "A", "A", "A", "G", "C", "A", "A", "G", "C", "G", "G", "G", "C", "C", "G", "C", "A", "C", "G", "C", "G",
                                    "G", "C", "C", "C", "G", "C", "A", "A", "A" };
static const char *idx_a[NUM_A] = { "0", "1", "2", "3", "4", "5", "6", "7", "8", "9","10","11","12","13","14","15","16","17","18","19","20",
                                   "21","22","23","24","25","26","27","28","29" };
#define NUM_B 17
static const char *seq_b[NUM_B] = { "A", "A", "A", "G", "C", "A", "G", "C", "G", "G", "C", "C", "G", "C", "A", "A", "A" };
static const char *idx_b[NUM_B] = { "0", "1", "2", "3", "4", "5", "6", "7", "8", "9","10","11","12","13","14","15","16" };
static const char *links[NUM_B] = { "1", "1", "1", "1", "1", "0", "1", "1", "1", "0", "1", "1", "1", "1", "1", "1", "1" };
static const char *numbs[NUM_B] = {  "648", "649", "650", "651", "652", "652A", "652C", "652D", "652E", "652F", "652S", "652T", "652U", "652V",
                                     "653", "654", "655" };
*/


#define NUM_A  312 

static const char *seq_a[NUM_A][2] = {
     { "MET", "1" },
     { "GLY", "2" },
     { "GLY", "3" },
     { "ILE", "4" },
     { "ARG", "5" },
     { "GLU", "6" },
     { "LYS", "7" },
     { "LYS", "8" },
     { "ALA", "9" },
     { "GLU", "10" },
     { "TYR", "11" },
     { "PHE", "12" },
     { "ALA", "13" },
     { "LYS", "14" },
     { "LEU", "15" },
     { "ARG", "16" },
     { "GLU", "17" },
     { "TYR", "18" },
     { "LEU", "19" },
     { "GLU", "20" },
     { "GLU", "21" },
     { "TYR", "22" },
     { "LYS", "23" },
     { "SER", "24" },
     { "LEU", "25" },
     { "PHE", "26" },
     { "VAL", "27" },
     { "VAL", "28" },
     { "GLY", "29" },
     { "VAL", "30" },
     { "ASP", "31" },
     { "ASN", "32" },
     { "VAL", "33" },
     { "SER", "34" },
     { "SER", "35" },
     { "GLN", "36" },
     { "GLN", "37" },
     { "MET", "38" },
     { "HIS", "39" },
     { "GLU", "40" },
     { "VAL", "41" },
     { "ARG", "42" },
     { "LYS", "43" },
     { "GLU", "44" },
     { "LEU", "45" },
     { "ARG", "46" },
     { "GLY", "47" },
     { "ARG", "48" },
     { "ALA", "49" },
     { "VAL", "50" },
     { "VAL", "51" },
     { "LEU", "52" },
     { "MET", "53" },
     { "GLY", "54" },
     { "LYS", "55" },
     { "ASN", "56" },
     { "THR", "57" },
     { "MET", "58" },
     { "VAL", "59" },
     { "ARG", "60" },
     { "ARG", "61" },
     { "ALA", "62" },
     { "ILE", "63" },
     { "ARG", "64" },
     { "GLY", "65" },
     { "PHE", "66" },
     { "LEU", "67" },
     { "SER", "68" },
     { "ASP", "69" },
     { "LEU", "70" },
     { "PRO", "71" },
     { "ASP", "72" },
     { "PHE", "73" },
     { "GLU", "74" },
     { "LYS", "75" },
     { "LEU", "76" },
     { "LEU", "77" },
     { "PRO", "78" },
     { "PHE", "79" },
     { "VAL", "80" },
     { "LYS", "81" },
     { "GLY", "82" },
     { "ASN", "83" },
     { "VAL", "84" },
     { "GLY", "85" },
     { "PHE", "86" },
     { "VAL", "87" },
     { "PHE", "88" },
     { "THR", "89" },
     { "ASN", "90" },
     { "GLU", "91" },
     { "PRO", "92" },
     { "LEU", "93" },
     { "THR", "94" },
     { "GLU", "95" },
     { "ILE", "96" },
     { "LYS", "97" },
     { "ASN", "98" },
     { "VAL", "99" },
     { "ILE", "100" },
     { "VAL", "101" },
     { "SER", "102" },
     { "ASN", "103" },
     { "ARG", "104" },
     { "VAL", "105" },
     { "ALA", "106" },
     { "ALA", "107" },
     { "PRO", "108" },
     { "ALA", "109" },
     { "ARG", "110" },
     { "ALA", "111" },
     { "GLY", "112" },
     { "ALA", "113" },
     { "VAL", "114" },
     { "ALA", "115" },
     { "PRO", "116" },
     { "GLU", "117" },
     { "ASP", "118" },
     { "ILE", "119" },
     { "TRP", "120" },
     { "VAL", "121" },
     { "ARG", "122" },
     { "ALA", "123" },
     { "VAL", "124" },
     { "ASN", "125" },
     { "THR", "126" },
     { "GLY", "127" },
     { "MET", "128" },
     { "GLU", "129" },
     { "PRO", "130" },
     { "GLY", "131" },
     { "LYS", "132" },
     { "THR", "133" },
     { "SER", "134" },
     { "PHE", "135" },
     { "PHE", "136" },
     { "GLN", "137" },
     { "ALA", "138" },
     { "LEU", "139" },
     { "GLY", "140" },
     { "VAL", "141" },
     { "PRO", "142" },
     { "THR", "143" },
     { "LYS", "144" },
     { "ILE", "145" },
     { "ALA", "146" },
     { "ARG", "147" },
     { "GLY", "148" },
     { "THR", "149" },
     { "ILE", "150" },
     { "GLU", "151" },
     { "ILE", "152" },
     { "VAL", "153" },
     { "SER", "154" },
     { "ASP", "155" },
     { "VAL", "156" },
     { "LYS", "157" },
     { "VAL", "158" },
     { "VAL", "159" },
     { "ASP", "160" },
     { "ALA", "161" },
     { "GLY", "162" },
     { "ASN", "163" },
     { "LYS", "164" },
     { "VAL", "165" },
     { "GLY", "166" },
     { "GLN", "167" },
     { "SER", "168" },
     { "GLU", "169" },
     { "ALA", "170" },
     { "SER", "171" },
     { "LEU", "172" },
     { "LEU", "173" },
     { "ASN", "174" },
     { "LEU", "175" },
     { "LEU", "176" },
     { "ASN", "177" },
     { "ILE", "178" },
     { "SER", "179" },
     { "PRO", "180" },
     { "PHE", "181" },
     { "THR", "182" },
     { "PHE", "183" },
     { "GLY", "184" },
     { "LEU", "185" },
     { "THR", "186" },
     { "VAL", "187" },
     { "VAL", "188" },
     { "GLN", "189" },
     { "VAL", "190" },
     { "TYR", "191" },
     { "ASP", "192" },
     { "ASN", "193" },
     { "GLY", "194" },
     { "GLN", "195" },
     { "VAL", "196" },
     { "PHE", "197" },
     { "PRO", "198" },
     { "SER", "199" },
     { "SER", "200" },
     { "ILE", "201" },
     { "LEU", "202" },
     { "ASP", "203" },
     { "ILE", "204" },
     { "THR", "205" },
     { "ASP", "206" },
     { "GLU", "207" },
     { "GLU", "208" },
     { "LEU", "209" },
     { "VAL", "210" },
     { "SER", "211" },
     { "HIS", "212" },
     { "PHE", "213" },
     { "VAL", "214" },
     { "SER", "215" },
     { "ALA", "216" },
     { "VAL", "217" },
     { "SER", "218" },
     { "THR", "219" },
     { "ILE", "220" },
     { "ALA", "221" },
     { "SER", "222" },
     { "ILE", "223" },
     { "SER", "224" },
     { "LEU", "225" },
     { "ALA", "226" },
     { "ILE", "227" },
     { "GLY", "228" },
     { "TYR", "229" },
     { "PRO", "230" },
     { "THR", "231" },
     { "LEU", "232" },
     { "PRO", "233" },
     { "SER", "234" },
     { "VAL", "235" },
     { "GLY", "236" },
     { "HIS", "237" },
     { "THR", "238" },
     { "LEU", "239" },
     { "ILE", "240" },
     { "ASN", "241" },
     { "ASN", "242" },
     { "TYR", "243" },
     { "LYS", "244" },
     { "ASP", "245" },
     { "LEU", "246" },
     { "LEU", "247" },
     { "ALA", "248" },
     { "VAL", "249" },
     { "ALA", "250" },
     { "ILE", "251" },
     { "ALA", "252" },
     { "ALA", "253" },
     { "SER", "254" },
     { "TYR", "255" },
     { "HIS", "256" },
     { "TYR", "257" },
     { "PRO", "258" },
     { "GLU", "259" },
     { "ILE", "260" },
     { "GLU", "261" },
     { "ASP", "262" },
     { "LEU", "263" },
     { "VAL", "264" },
     { "ASP", "265" },
     { "ARG", "266" },
     { "ILE", "267" },
     { "GLU", "268" },
     { "ASN", "269" },
     { "PRO", "270" },
     { "GLU", "271" },
     { "LYS", "272" },
     { "TYR", "273" },
     { "ALA", "274" },
     { "ALA", "275" },
     { "ALA", "276" },
     { "ALA", "277" },
     { "PRO", "278" },
     { "ALA", "279" },
     { "ALA", "280" },
     { "THR", "281" },
     { "SER", "282" },
     { "ALA", "283" },
     { "ALA", "284" },
     { "SER", "285" },
     { "GLY", "286" },
     { "ASP", "287" },
     { "ALA", "288" },
     { "ALA", "289" },
     { "PRO", "290" },
     { "ALA", "291" },
     { "GLU", "292" },
     { "GLU", "293" },
     { "ALA", "294" },
     { "ALA", "295" },
     { "ALA", "296" },
     { "GLU", "297" },
     { "GLU", "298" },
     { "GLU", "299" },
     { "GLU", "300" },
     { "GLU", "301" },
     { "SER", "302" },
     { "ASP", "303" },
     { "ASP", "304" },
     { "ASP", "305" },
     { "MET", "306" },
     { "GLY", "307" },
     { "PHE", "308" },
     { "GLY", "309" },
     { "LEU", "310" },
     { "PHE", "311" },
     { "ASP", "312" }
};

#define NUM_B  121

static const char *seq_b[NUM_B][3] = {
     { "GLY", "3", "1" },
     { "ILE", "4", "1" },
     { "ARG", "5", "1" },
     { "GLU", "6", "1" },
     { "LYS", "7", "1" },
     { "LYS", "8", "1" },
     { "ALA", "9", "1" },
     { "GLU", "10", "1" },
     { "TYR", "11", "1" },
     { "PHE", "12", "1" },
     { "ALA", "13", "1" },
     { "LYS", "14", "1" },
     { "LEU", "15", "1" },
     { "ARG", "16", "1" },
     { "GLU", "17", "1" },
     { "TYR", "18", "1" },
     { "LEU", "19", "1" },
     { "GLU", "20", "1" },
     { "GLU", "21", "1" },
     { "TYR", "22", "1" },
     { "LYS", "23", "1" },
     { "SER", "24", "1" },
     { "LEU", "25", "1" },
     { "PHE", "26", "1" },
     { "VAL", "27", "1" },
     { "VAL", "28", "1" },
     { "GLY", "29", "1" },
     { "VAL", "30", "1" },
     { "ASP", "31", "1" },
     { "ASN", "32", "1" },
     { "VAL", "33", "1" },
     { "SER", "34", "1" },
     { "SER", "35", "1" },
     { "GLN", "36", "1" },
     { "GLN", "37", "1" },
     { "MET", "38", "1" },
     { "HIS", "39", "1" },
     { "GLU", "40", "1" },
     { "VAL", "41", "1" },
     { "ARG", "42", "1" },
     { "LYS", "43", "1" },
     { "GLU", "44", "1" },
     { "LEU", "45", "1" },
     { "ARG", "46", "1" },
     { "GLY", "47", "1" },
     { "ARG", "48", "1" },
     { "ALA", "49", "1" },
     { "VAL", "50", "1" },
     { "VAL", "51", "1" },
     { "LEU", "52", "1" },
     { "MET", "53", "1" },
     { "GLY", "54", "1" },
     { "LYS", "55", "1" },
     { "ASN", "56", "1" },
     { "THR", "57", "1" },
     { "MET", "58", "1" },
     { "VAL", "59", "1" },
     { "ARG", "60", "1" },
     { "ARG", "61", "1" },
     { "ALA", "62", "1" },
     { "ILE", "63", "1" },
     { "ARG", "64", "1" },
     { "GLY", "65", "1" },
     { "PHE", "66", "1" },
     { "LEU", "67", "1" },
     { "SER", "68", "1" },
     { "ASP", "69", "1" },
     { "LEU", "70", "1" },
     { "PRO", "71", "1" },
     { "ASP", "72", "1" },
     { "PHE", "73", "1" },
     { "GLU", "74", "1" },
     { "LYS", "75", "1" },
     { "LEU", "76", "1" },
     { "LEU", "77", "1" },
     { "PRO", "78", "1" },
     { "PHE", "79", "1" },
     { "VAL", "80", "1" },
     { "LYS", "81", "1" },
     { "GLY", "82", "1" },
     { "ASN", "83", "1" },
     { "VAL", "84", "1" },
     { "GLY", "85", "1" },
     { "PHE", "86", "1" },
     { "VAL", "87", "1" },
     { "PHE", "88", "1" },
     { "THR", "89", "1" },
     { "ASN", "90", "1" },
     { "GLU", "91", "1" },
     { "PRO", "92", "1" },
     { "LEU", "93", "1" },
     { "THR", "94", "1" },
     { "GLU", "95", "1" },
     { "ILE", "96", "1" },
     { "LYS", "97", "1" },
     { "ASN", "98", "1" },
     { "VAL", "99", "1" },
     { "ILE", "100", "1" },
     { "VAL", "101", "1" },
     { "SER", "102", "1" },
     { "ASN", "103", "1" },
     { "ARG", "104", "1" },
     { "VAL", "105", "1" },
     { "ALA", "106", "1" },
     { "ALA", "107", "0" },
     { "GLY", "184", "1" },
     { "LEU", "185", "1" },
     { "THR", "186", "1" },
     { "VAL", "187", "1" },
     { "VAL", "188", "1" },
     { "GLN", "189", "1" },
     { "VAL", "190", "1" },
     { "TYR", "191", "1" },
     { "ASP", "192", "1" },
     { "ASN", "193", "1" },
     { "GLY", "194", "1" },
     { "GLN", "195", "1" },
     { "VAL", "196", "1" },
     { "PHE", "197", "1" },
     { "PRO", "198", "1" },
     { "SER", "199", "1" }
};

using namespace RCSB;

int main(int argc, char *argv[])
{
       std::vector<std::string> data;
       std::vector<std::vector<std::string> > authSeqs, coordSeqs;
       char buff[10];

       authSeqs.clear();
/*
       for (int i = 0; i < NUM_A; ++i) {
            data.clear();
            data.push_back(seq_a[i]);
            data.push_back(idx_a[i]);
            authSeqs.push_back(data);
       }
*/
       for (int i = 0; i < NUM_A; ++i) {
            sprintf(buff, "%d", i);
            data.clear();
            data.push_back(seq_a[i][0]);
            data.push_back(buff);
            authSeqs.push_back(data);
       }

       coordSeqs.clear();
/*
       for (int i = 0; i < NUM_B; ++i) {
            sprintf(buff, "%d", i);
            printf("buff=%s-\n", buff);
            data.clear();
            data.push_back(seq_b[i]);
            data.push_back(idx_b[i]);
            data.push_back(links[i]);
            data.push_back(numbs[i]);
            coordSeqs.push_back(data);
       }
*/
       for (int i = 0; i < NUM_B; ++i) {
            sprintf(buff, "%d", i);
            data.clear();
            data.push_back(seq_b[i][0]);
            data.push_back(buff);
            data.push_back(seq_b[i][2]);
            data.push_back(seq_b[i][1]);
            coordSeqs.push_back(data);
       }

       PseudoMultiAlign pa = PseudoMultiAlign();
       pa.setAuthSequence(authSeqs);
       pa.addAlignSequence(coordSeqs);

       std::vector<std::vector<int> > idxList = pa.getAlignIndices();
       for (unsigned int i = 0; i < idxList.size(); ++i) {
            // for (unsigned int j = 0; j < idxList[i].size(); ++j) printf(" %6d", idxList[i][j]);
            // printf("\n");
            std::string resA = "";
            std::string numA = "";
            if (idxList[i][0] >= 0) {
                 resA = seq_a[idxList[i][0]][0];
                 numA = seq_a[idxList[i][0]][1];
                 // numA = idx_a[idxList[i][0]];
            }
            std::string resB = "";
            std::string numB = "";
            if (idxList[i][1] >= 0) {
                 resB = seq_b[idxList[i][1]][0];
                 numB = seq_b[idxList[i][1]][1];
                 // numB = numbs[idxList[i][1]];
            }
            printf(" %6d %4s %4s --- %6d %4s %4s\n", idxList[i][0], resA.c_str(), numA.c_str(), idxList[i][1], resB.c_str(), numB.c_str());
       }

       return 0;
}

