SEPARATOR = "\u200b"

# list of constants needed for KCC and feature generation

# consonant and independent vowels
KHCONST = set(u"កខគឃងចឆជឈញដឋឌឍណតថទធនបផពភមយរលវឝឞសហឡអឣឤឥឦឧឨឩឪឫឬឭឮឯឰឱឲឳ")
KHVOWEL = set(u"឴឵ាិីឹឺុូួើឿៀេែៃោៅ\u17c6\u17c7\u17c8")

# subscript, diacritics
KHSUB = set(u"្")
# MUUSIKATOAN, TRIISAP, BANTOC,ROBAT,
KHDIAC = set(u"\u17c9\u17ca\u17cb\u17cc\u17cd\u17ce\u17cf\u17d0")
KHSYM = set("៕។៛ៗ៚៙៘,.? ")  # add space
KHNUMBER = set(u"០១២៣៤៥៦៧៨៩0123456789")  # remove 0123456789
# lunar date:  U+19E0 to U+19FF ᧠...᧿
KHLUNAR = set("᧠᧡᧢᧣᧤᧥᧦᧧᧨᧩᧪᧫᧬᧭᧮᧯᧰᧱᧲᧳᧴᧵᧶᧷᧸᧹᧺᧻᧼᧽᧾᧿")

EN = set(u"abcdefghijklmnopqrstuvwxyz0123456789")

# E=English, C=Consonant, W=wowel, N=number, O=Other, S=subcript, D=Diacritic, NS=no_space(same E)
# roll up to: NS, C, W, S, D
NS = "NS"

mistokenized_dict = {
    "អា\u200bខោន\u200b": "អាខោន\u200b",
    "\u200bឱវា\u200bទ": "\u200bឱវាទ",
    "នៅ\u200bសប្តា\u200bហ៏\u200b": "នៅ\u200bសប្តាហ៏\u200b",
    "សាយ\u200b \u200bមក\u200bរា": "សាយ\u200b \u200bមករា",
    "រោង\u200bកុន": "រោងកុន",
    "ដេី\u200bមជ្រៃ": "ដេីមជ្រៃ",
    "\u200bដេី\u200bម\u200b": "\u200bដេីម\u200b",
    "មន្ទី\u200bពេទ្យ": "មន្ទីពេទ្យ",
    "ជាដរាបត\u200bទៅ": "ជា\u200bដរាប\u200bតទៅ",
    "ដេី\u200bម្បី\u200b": "ដេីម្បី\u200b",
    "ធ្វេី\u200bការកាត់\u200bយក": "ធ្វេីការ\u200bកាត់\u200bយក",
    "ភូមិ\u200bផ្សារ\u200bដី\u200bហុយ": "ភូមិ\u200bផ្សារដីហុយ",
    "ប្រតិបត្តិការបង្ក្រាប": "ប្រតិបត្តិការ\u200bបង្ក្រាប",
    "health\u200b.\u200bcom\u200b.\u200bkh": "health.com.kh",
    "ពួយ\u200b \u200bច័ន្ទ\u200bសុគុណ": "ពួយ\u200b \u200bច័ន្ទសុគុណ",
    "ភូមិ\u200b \u200bថ្ម\u200bដា": "ភូមិ\u200b \u200bថ្មដា",
    "សង្កាត់\u200b \u200bបឹង\u200bកន្សែង": "សង្កាត់\u200b \u200bបឹងកន្សែង",
    "ក្រុង\u200b \u200bបាន\u200bលុង": "ក្រុង\u200b \u200bបានលុង",
    "នុត\u200b \u200bសុគន្ធ\u200b \u200bផាន់\u200bនី": "នុត\u200b \u200bសុគន្ធ\u200b \u200bផាន់នី",
    "កាក\u200bបាត\u200bក្រហម": "កាកបាត\u200bក្រហម",
    "ស្រុក\u200b \u200bកំពង់ត្រា\u200bច": "ស្រុក\u200b \u200bកំពង់ត្រាច",
    "ឃុំ\u200b \u200bថ្ម\u200bកែវ": "ឃុំ\u200b \u200bថ្មកែវ",
    "ស្រុក\u200b \u200bអង្គរ\u200bជ័យ": "ស្រុក\u200b \u200bអង្គរជ័យ",
    "កោះ\u200bតា\u200bកូវ ឃុំ\u200bឬ\u200bស្សី": "កោះ\u200bតាកូវ ឃុំ\u200bឬស្សី",
    "ម៉ាក\u200b \u200bសែន\u200bសូនីតា": "ម៉ាក\u200b \u200bសែនសូនីតា",
    "ជា\u200b \u200bដេី\u200bម\u200b \u200bនោះ": "ជា\u200b \u200bដេីម\u200b \u200bនោះ",
    "ដេី\u200bម្បី\u200b \u200bជ្រាប": "ដេីម្បី\u200b \u200bជ្រាប",
    "ក\u200bរករណី": "ករ\u200bករណី",
    "ទោ\u200bចក្រ\u200bយានយន្ត": "ទោចក្រយានយន្ត",
    "ឃុំ\u200b \u200bអន្លង់\u200bវិល": "ឃុំ\u200b \u200bអន្លង់វិល",
    "\u200bពោធ៍\u200bសាត់": "\u200bពោធ៍សាត់",
    "ណាក់\u200b \u200bស្រី\u200bណា": "ណាក់\u200b \u200bស្រីណា",
    "ពិធីការ\u200bនីមួយ": "ពិធីការនី\u200bមួយ",
    "តូរុន\u200bតូ": "តូរុនតូ",
    "ដាយ\u200bណូស័រ": "ដាយណូស័រ",
    "ហ្គារ៉ាល់\u200bហូស": "ហ្គារ៉ាល់ហូស",
    "ខេមរៈ\u200b \u200bសិរី\u200bមន្ត": "ខេមរៈ\u200b \u200bសិរីមន្ត",
    "ឱម\u200b \u200bយ៉ិន\u200bទៀង": "ឱម\u200b \u200bយ៉ិនទៀង",
    "មហា\u200bលាប": "មហាលាប",
    "ការចាប់អារម្ម\u200bណ៏\u200b": "ការចាប់អារម្មណ៏\u200b",
    "វ៉ិច\u200bទ័រ\u200b": "វ៉ិចទ័រ\u200b",
    "សុវណ្ណ\u200b \u200bឬ\u200bទ្ធី": "សុវណ្ណ\u200b \u200bឬទ្ធី",
    "ខាន់\u200b \u200bចាន់\u200bសុផល": "ខាន់\u200b \u200bចាន់សុផល",
    "ទំនួលខុសត្រូវ\u200b": "ទំនួល\u200bខុសត្រូវ\u200b",
    "ឯ\u200bណេះ": "ឯណេះ",
    "ហេយ៍\u200bវ៉ិន": "ហេយ៍វ៉ិន",
    "សុខ\u200b \u200bពេញ\u200bវុធ": "សុខ\u200b \u200bពេញវុធ",
    "វ៉ុល\u200bកា": "វ៉ុលកា",
    "ជា\u200bម\u200b \u200bហុី\u200bម": "ជាម\u200b \u200bហុីម",
    "\u200bការ\u200bប្រកាស\u200b": "\u200bការប្រកាស\u200b",
    "អនុ\u200bប្រធាន": "អនុប្រធាន",
    "កិច្ចខិតខំប្រឹងប្រែង": "កិច្ច\u200bខិតខំ\u200bប្រឹងប្រែង",
    "សស្អាត": "ស\u200bស្អាត",
    "ហាន់\u200b \u200bជី\u200bអ៊ុន": "ហាន់\u200b \u200bជីអ៊ុន",
    "ស៊ុន\u200b \u200bចាន់\u200bថុល": "ស៊ុន\u200b \u200bចាន់ថុល",
    "លីន\u200bដា\u200b": "លីនដា\u200b",
    "យានយន្តបន្ទាប់ពី": "យានយន្ត\u200bបន្ទាប់ពី",
    "ព្រៃ\u200bស្អាក\u200bស្រុក\u200bអន្លង់\u200bវែង": "ព្រៃស្អាក\u200bស្រុក\u200bអន្លង់វែង",
    "\u200bប៉ា\u200bកុង\u200b": "\u200bប៉ាកុង\u200b",
    "ឈើ\u200b \u200bអុស\u200bក្រាក់": "ឈើ\u200b \u200bអុសក្រាក់",
    "រតនៈ\u200bគីរី\u200b": "រតនៈគីរី\u200b",
    "ឯក\u200bឧត្តម": "ឯកឧត្តម",
    "ឱម\u200b \u200bយិន\u200bទៀង": "ឱម\u200b \u200bយិនទៀង",
    "\u200bចំដែនដី\u200b": "\u200bចំ\u200bដែនដី\u200b",
    "ឱវា\u200bទ": "ឱវាទ",
    "អ៊ិន\u200bវេស\u200bមិន": "អ៊ិនវេសមិន",
    "សហគម\u200bន៏": "សហគមន៏",
    "\u200bគ្រូ\u200bសារ\u200b": "\u200bគ្រូសារ\u200b",
    "សុផុនពេល\u200bសួរ": "សុផុន\u200bពេល\u200bសួរ",
    "ស្រុក\u200bកែវ\u200bសីម៉ា": "ស្រុក\u200bកែវសីម៉ា",
    "ហាន់\u200bជ័យ": "ហាន់ជ័យ",
    "បូរី\u200b \u200bស\u200bចនសុន": "បូរីស\u200b \u200bចនសុន",
    "បូរី\u200b \u200bស\u200bចន\u200bសុន": "បូរីស\u200b \u200bចនសុន",
    "បូរីស\u200b \u200bចន\u200bសុន": "បូរីស\u200b \u200bចនសុន",
    "អំណ\u200bរ\u200bគុណ": "អំណរ\u200bគុណ",
    "ផលប៉ះពាល់\u200b": "ផល\u200bប៉ះពាល់\u200b",
    "អ្នកវិនិយោគ\u200b": "អ្នក\u200bវិនិយោគ\u200b",
    "ភូមិ\u200b \u200bស្រះ\u200bជ្រៃ\u200b": "ភូមិ\u200b \u200bស្រះជ្រៃ\u200b",
    "ឃុំ\u200b \u200bបន្ទាយ\u200bឆ្មា\u200b": "ឃុំ\u200b \u200bបន្ទាយឆ្មា\u200b",
    "ស្រុក\u200b \u200bថ្ម\u200bពួក\u200b": "ស្រុក\u200b \u200bថ្មពួក\u200b",
    "ទ្វីត\u200bធឺ": "ទ្វីតធឺ",
    "\u200bធំ\u200bដុំ": "\u200bធំដុំ",
    "\u200bរួមមាន\u200b": "\u200bរួម\u200bមាន\u200b",
    "គុយ\u200bវ៉ែត": "គុយវ៉ែត",
    "ងងុយគេង": "ងងុយ\u200bគេង",
    "ស\u200bម\u200b \u200bរង្ស៊ី": "សម\u200b \u200bរង្ស៊ី",
    "សោ\u200b \u200bចាន់\u200bដេត": "សោ\u200b \u200bចាន់ដេត",
    "ជាលាយលក្ខណ៍អក្សរ": "ជា\u200bលាយលក្ខណ៍\u200bអក្សរ",
    "ផលិតកម្មវិធី": "ផលិតកម្ម\u200bវិធី",
    "\u200bសាជាថ្មី\u200b": "\u200bសា\u200bជា\u200bថ្មី\u200b",
    "ឧកញ៉ា\u200bស្រី\u200b \u200bចាន់\u200bថន": "ឧកញ៉ា\u200b \u200bស្រី\u200b \u200bចាន់ថន",
    "ភូមិ\u200b \u200bព្រៃ\u200bល្វា": "ភូមិ\u200b \u200bព្រៃល្វា",
    "សង្កាត់\u200b \u200bចោម\u200bចៅ ": "សង្កាត់\u200b \u200bចោមចៅ",
    "ខណ្ឌ\u200b \u200bពោធិ៍\u200bសែន": "ខណ្ឌ\u200b \u200bពោធិ៍សែន",
    "ឃុំ\u200b \u200bព្រែក\u200bតា\u200bមាក់": "ឃុំ\u200b \u200bព្រែកតាមាក់",
    "\u200bបាត់បង្ក": "\u200bបាត់\u200bបង្ក",
    "កើតមានឡើង": "កើត\u200bមាន\u200bឡើង",
    "លូក\u200bលាន់": "លូកលាន់",
    "លោក\u200b \u200bជិន\u200b \u200bម៉ាលី\u200bន": "លោក\u200b \u200bជិន\u200b \u200bម៉ាលីន",
    "អ្នករាយការណ៍": "អ្នក\u200bរាយការណ៍",
    "គង់\u200b \u200bរ៉ៃ\u200bយ៉ា": "គង់\u200b \u200bរ៉ៃយ៉ា",
    "លោក\u200b \u200bសួង\u200b \u200bនាគ\u200bព័ន្ធ": "លោក\u200b \u200bសួង\u200b \u200bនាគព័ន្ធ",
    "ធ្វើទុក្ខបុកម្នេញ": "ធ្វើ\u200bទុក្ខបុកម្នេញ",
    "បោះបង់ចោល": "បោះបង់\u200bចោល",
    "ខ្លួនឯង": "ខ្លួន\u200bឯង",
    "សប្បាយចិត្ត": "សប្បាយ\u200bចិត្ត",
    "មើលទៅ": "មើល\u200bទៅ",
    "សោយសុខ": "សោយ\u200bសុខ",
    "ទៅលើ": "ទៅ\u200bលើ",
    "ឃុំខ្លួន": "ឃុំ\u200bខ្លួន",
    "ជាប់ឃុំ": "ជាប់\u200bឃុំ",
    "លោក\u200b \u200bហេង\u200b \u200bដូន\u200bនី": "លោក\u200b \u200bហេង\u200b \u200bដូននី",
    "លោក\u200b \u200bកែម\u200b \u200bគិម\u200bស្រន់": "លោក\u200b \u200bកែម\u200b \u200bគិមស្រន់",
    "ស្រុក\u200b \u200bវាល\u200bវែង": "ស្រុក\u200b \u200bវាលវែង",
    "ចោទប្រកាន់តែ": "ចោទប្រកាន់\u200bតែ",
    "ឈិញ\u200b \u200bស៊ី\u200bថា": "ឈិញ\u200b \u200bស៊ីថា",
    "ដាក់ពាក្យបណ្តឹង": "ដាក់\u200bពាក្យ\u200bបណ្តឹង",
    "ម៉ាក\u200b \u200bណូ\u200bគា": "ម៉ាក\u200b \u200bណូគា",
    "ធូ\u200b \u200bស្រី\u200bទូច": "ធូ\u200b \u200bស្រីទូច",
    "ម៉ូតូកង់\u200bបី": "ម៉ូតូ\u200bកង់\u200bបី",
    "ឃុំ មង់\u200bរៀវ": "ឃុំ មង់រៀវ",
    "លោក\u200b \u200bជា\u200b \u200bចាន់\u200bតូ": "លោក\u200b \u200bជា\u200b \u200bចាន់តូ",
    "ស៊ែ\u200bស្វី\u200bច": "ស៊ែ\u200bស្វីច",
    "ប្រតិបត្តិការផ្ទេរ": "ប្រតិបត្តិការ\u200bផ្ទេរ",
    "បញ្ជាការស្រាល": "បញ្ជាការ\u200bស្រាល",
    "F\u200b-\u200b16": "F-16",
    "C\u200b-\u200b17": "C-17",
    "គោលនយោបាយ": "គោល\u200bនយោបាយ",
    "ហាន\u200b \u200bសុខ\u200bន": "ហាន\u200b \u200bសុខន",
    "ខៀវ\u200b \u200bទេ\u200bព": "ខៀវ\u200b \u200bទេព",
    "កាញារី\u200bទ្ធ": "កាញារីទ្ធ",
    "ជី\u200bហែ": "ជីហែ",
    "វិទ្យាល័យ\u200b \u200bជី\u200bហែរ": "វិទ្យាល័យ\u200b \u200bជីហែរ",
    "ស្រុកោះ\u200bកោះ\u200bសូទិន": "ស្រុកោះ\u200bកោះសូទិន",
    "ជំរុញឲ្យ": "ជំរុញ\u200bឲ្យ",
    "ការបាក់ទឹកចិត្ត": "ការបាក់\u200bទឹកចិត្ត",
    "ហង់ ជួន\u200bណារីតា": "ហង់ ជួនណារីតា",
    "ជាទីមោទនៈ": "ជា\u200bទី\u200bមោទនៈ",
    "សឿ សុជា\u200bតា": "សឿ សុជាតា",
    "ហង់\u200b \u200bជួន\u200bណារ៉ុន": "ហង់\u200b \u200bជួនណារ៉ុន",
    "ក\u200bសាង\u200bធនធាន": "កសាង\u200bធនធាន",
    "ស្នង\u200bឬ\u200bស្សី": "ស្នង\u200bឬស្សី",
    "ខៀវ\u200b \u200bកាញារី\u200bទ្ធ": "ខៀវ\u200b \u200bកាញារីទ្ធ",
    "ត្រេន\u200b \u200bដី\u200bង": "ត្រេនដីង",
    "ទៅវិញទៅមក": "ទៅ\u200bវិញ\u200bទៅ\u200bមក",
    "ក្ដី\u200bស្រមៃ": "ក្ដីស្រមៃ",
    "ឬ\u200bស្សីកែវ": "ឬស្សីកែវ",
    "អេង\u200b \u200bសុវណ្ណ\u200bតារា": "អេង\u200b \u200bសុវណ្ណតារា",
    "កុង\u200bទីន\u200bរ័": "កុងទីនរ័",
    "ជាបន្តបន្ទាប់": "ជា\u200bបន្តបន្ទាប់",
    "ចលត័ជាប្រចាំ": "ចលត័\u200bជា\u200bប្រចាំ",
    "ឃុំ\u200bដី\u200bឥដ្ឋ": "ឃុំ\u200bដីឥដ្ឋ",
    "វី\u200bដែ\u200bអូ": "វីដែអូ",
    "ត្រី\u200bខ\u200b": "ត្រីខ\u200b",
    "ទឹក\u200bត្រី\u200b": "ទឹកត្រី\u200b",
    "បង្ខំឲ្យ": "បង្ខំ\u200bឲ្យ",
    "ស្ដុក\u200bប្រវឹក": "ស្ដុកប្រវឹក",
    "វាល\u200bរិញ\u200b": "វាលរិញ\u200b",
    "ណៃ\u200b \u200bវង្ស\u200bដា": "ណៃ\u200b \u200bវង្សដា",
    "លោក\u200b \u200bឃ\u200bន \u200bជឺ ": "លោក\u200b \u200bឃន\u200b \u200bជឺ ",
    "បុត\u200b \u200bចាន់\u200bណា": "បុត\u200b \u200bចាន់ណា",
    "ឯ\u200bម\u200b \u200bច័ន្ទ\u200bមក\u200bរា": "ឯម\u200b \u200bច័ន្ទមករា",
    "សង់\u200bដ្រី\u200bន\u200b \u200bឌុយ\u200bរី": "សង់ដ្រីន\u200b \u200bឌុយរី",
    "សោម \u200bពុទ្ធ\u200bតារា": "សោម \u200bពុទ្ធតារា",
    "ម៉ៅ\u200b ច័ន្ទ\u200bមធុរិទ្ធ": "ម៉ៅ\u200b ច័ន្ទមធុរិទ្ធ",
    "បូពិន្ទ\u200b ណា\u200bរ័ត្ន": "បូពិន្ទ\u200b ណារ័ត្ន",
    "ជា\u200b \u200bប៊ុន\u200bហេង": "ជា\u200b \u200bប៊ុនហេង",
    "ណារិក\u200bដ្រា\u200b \u200bមូឌី": "ណារិកដ្រា\u200b \u200bមូឌី",
    "ស្រុក\u200bព្រៃ\u200bនប់": "ស្រុក\u200bព្រៃនប់",
    "ខណ្ឌ\u200bចំការ\u200bមន": "ខណ្ឌ\u200bចំការមន",
    "ខណ្ឌ\u200bពោធិ៍\u200bសែន\u200bជ័យ": "ខណ្ឌ\u200bពោធិ៍សែនជ័យ",
    "សង្កាត់\u200bទឹក\u200bល្អក់": "សង្កាត់\u200bទឹកល្អក់",
    "សង្កាត់\u200bផ្សារ\u200bថ្មី": "សង្កាត់\u200bផ្សារថ្មី",
    "សង្កាត់\u200bជ្រោយ\u200bចង្វារ": "សង្កាត់\u200bជ្រោយចង្វារ",
    "សង្កាត់\u200bវាល\u200bវង់": "សង្កាត់\u200bវាលវង់",
    "សង្កាត់\u200bកោះ\u200bដាច់": "សង្កាត់\u200bកោះដាច់",
    "សង្កាត់\u200bចាក់អង្រែ\u200bលើ": "សង្កាត់\u200bចាក់អង្រែលើ",
    "សង្កាត់\u200bទន្លេ\u200bបាសាក់": "សង្កាត់\u200bទន្លេបាសាក់",
    "ឃុំ\u200bត្រពាំង\u200bជោ": "ឃុំ\u200bត្រពាំងជោ",
    "ឃុំ\u200bក្រាំង\u200bល្វា": "ឃុំ\u200bក្រាំងល្វា",
    "ឃុំ\u200bដូន\u200bសរ": "ឃុំ\u200bដូនសរ",
    "ឃុំ\u200bអូរ\u200bតាប៉ោង": "ឃុំ\u200bអូរតាប៉ោង",
    "ឃុំ\u200bក្បាល\u200bដំរី": "ឃុំ\u200bក្បាលដំរី",
    "ឃុំ\u200bត្រពាំង\u200bគង": "ឃុំត្រពាំងគង",
    "ភូមិ\u200bច្រក\u200bទៀក": "ភូមិ\u200bច្រកទៀក",
    "ភូមិ\u200bខ្សាច់\u200bស": "ភូមិ\u200bខ្សាច់ស",
    "ភូមិ\u200bអូរ\u200bត្រូន": "ភូមិ\u200bអូរត្រូន",
    "ភូមិ\u200bថ្ម\u200bធំ": "ភូមិ\u200bថ្មធំ",
    "ភូមិ\u200bចំការ\u200bដូង": "ភូមិ\u200bចំការដូង",
    "ភូមិ\u200bព្រៃ\u200bផ្តៅ": "ភូមិ\u200bព្រៃផ្តៅ",
    "ភូមិ\u200bបឹង\u200bវែង": "ភូមិ\u200bបឹងវែង",
    "\u200b \u200b.\u200b \u200bcom\u200b": ".com\u200b",
    "ចូ\u200b \u200bបាយ\u200bដិន": "ចូ\u200b \u200bបាយដិន",
    "\u200bណាន់\u200bស៊ី\u200b": "\u200bណាន់ស៊ី\u200b",
    "លោក\u200bត្រាំតទៅទៀត": "លោក\u200bត្រាំ\u200bតទៅទៀត",
}
