# Generated by Django 3.2.15 on 2022-08-26 09:02

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import resolwe.observers.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("contenttypes", "0002_remove_content_type_name"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="Observer",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("object_id", models.PositiveIntegerField(null=True)),
                (
                    "change_type",
                    models.PositiveSmallIntegerField(
                        choices=[(1, "CREATE"), (2, "UPDATE"), (3, "DELETE")]
                    ),
                ),
                (
                    "content_type",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="contenttypes.contenttype",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="Subscription",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True)),
                ("session_id", models.CharField(max_length=100)),
                (
                    "subscription_id",
                    models.UUIDField(
                        default=resolwe.observers.models.get_random_uuid,
                        editable=False,
                        unique=True,
                    ),
                ),
                (
                    "observers",
                    models.ManyToManyField(
                        related_name="subscriptions", to="observers.Observer"
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
        ),
        migrations.AddIndex(
            model_name="subscription",
            index=models.Index(
                fields=["session_id"], name="observers_s_session_d8c2db_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="observer",
            index=models.Index(
                fields=["object_id"], name="observers_o_object__f89e17_idx"
            ),
        ),
        migrations.AlterUniqueTogether(
            name="observer",
            unique_together={("content_type", "object_id", "change_type")},
        ),
    ]
