import { Construct } from 'constructs';
import { ArchiverProperties } from './archiverProperties';
export declare class Archiver extends Construct {
    props: ArchiverProperties;
    constructor(scope: Construct, id: string, props: ArchiverProperties);
    /**
     *Create the S3 bucket that will later store the repositories.
     *
     * @private
     * @return {*}
     * @memberof Archiver
     */
    private createArchiveBucket;
    /**
     * Creates for each backup configuration a separate CodeBuild project
     *
     * @private
     * @param {s3.Bucket} bucket
     * @memberof Archiver
     */
    private createProjects;
    /**
     * Create a CodeBuild project
     *
     * @private
     * @param {BackupConfiguration} element
     * @param {cdk.aws_s3.Bucket} bucket
     * @return {*}
     * @memberof Archiver
     */
    private createProject;
    private createBatchConfiguration;
}
export interface BatchListElement {
    readonly identifier: string;
    readonly env: Object;
}
