# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['enelvo',
 'enelvo.candidate_generation',
 'enelvo.candidate_scoring',
 'enelvo.metrics',
 'enelvo.preprocessing',
 'enelvo.preprocessing.tokenizer',
 'enelvo.utils']

package_data = \
{'': ['*'],
 'enelvo': ['resources/corr-lexicons/*',
            'resources/embeddings/*',
            'resources/lexicons/*'],
 'enelvo.metrics': ['enelvo/metrics/*'],
 'enelvo.preprocessing.tokenizer': ['lexicons/*']}

install_requires = \
['editdistance==0.5.3',
 'emoji==1.2.0',
 'gensim==3.8.3',
 'numpy==1.19.5',
 'tabulate==0.8.7']

setup_kwargs = {
    'name': 'enelvo',
    'version': '0.0.1.dev1612181269',
    'description': 'A flexible normalizer for user-generated content http://thalesbertaglia.com/enelvo',
    'long_description': '<h1 align="center">\n  <br>\n  <a href="http://thalesbertaglia.com/enelvo"><img src="https://github.com/tfcbertaglia/enelvo/raw/master/enelvo-logo.png" alt="Enelvo" width="400"></a>\n</h1>\n\n<h4 align="center">A flexible normaliser for user-generated content in Portuguese.</h4>\n\n<p align="center">\n<a href="https://travis-ci.org/thalesbertaglia/enelvo"><img alt="Build Status" src="https://travis-ci.org/thalesbertaglia/enelvo.svg?branch=master"></a>\n<a href=\'https://coveralls.io/github/thalesbertaglia/enelvo?branch=master\'><img src=\'https://coveralls.io/repos/github/thalesbertaglia/enelvo/badge.svg?branch=master\' alt=\'Coverage Status\' /></a>\n<a href="https://github.com/psf/black"><img alt="Code style: black" src="https://img.shields.io/badge/code%20style-black-000000.svg"></a>\n</p>\n\nEnelvo is a tool for normalising noisy words in user-generated content written in Portuguese -- such as tweets, blog posts, and product reviews. It is capable of identifying and normalising spelling mistakes, internet slang, acronyms, proper nouns, and others.\n\nThe tool was developed as part of my master\'s project. You can find more details about how it works in my [dissertation](http://www.teses.usp.br/teses/disponiveis/55/55134/tde-10112017-170919/en.php) (in Portuguese) or in [this paper](http://anthology.aclweb.org/W/W16/W16-3916.pdf) (in English). For more information in Portuguese, please visit the [project website](http://thalesbertaglia.com/enelvo).\n\n## Citing\nIf you use Enelvo or any code from Enelvo in your research work, you are kindly asked to acknowledge the use of the tool in your publications.\n>Bertaglia, Thales Felipe Costa, and Maria das Graças Volpe Nunes. "Exploring Word Embeddings for Unsupervised Textual User-Generated Content Normalization." Proceedings of the 2nd Workshop on Noisy User-generated Text (WNUT). 2016.\n\nBibTeX:\n```\n@inproceedings{bertaglia2016exploring,\n  title={Exploring Word Embeddings for Unsupervised Textual User-Generated Content Normalization},\n  author={Bertaglia, Thales Felipe Costa and Nunes, Maria das Gra{\\c{c}}as Volpe},\n  booktitle={Proceedings of the 2nd Workshop on Noisy User-generated Text (WNUT)},\n  pages={112--120},\n  year={2016}\n}\n```\n\n\n## Getting Started\nYou can install Enelvo using `pip` by running:\n```bash\npip3 install --user enelvo \n```\nTo make sure that the installation was successful, run:\n```bash\npython3 -m enelvo --input in.txt --output out.txt\n```\nIf eveything went correctly, ``out.txt`` will be written -- containing the normalised version of ``in.txt``.\n\nThere is also a [REST-based microservice](https://github.com/staticdev/enelvo-microservice) for Enelvo, developed by Thiago D\'Ávila. Instructions can be found on the [repository page](https://github.com/staticdev/enelvo-microservice).\n\n## Running\nYou can use the tool, with the most simple configuration, by running:\n```bash\npython3 -m enelvo --input in.txt --output out.txt\n```\n\nThere are two **required** arguments: ``--input`` (path to the input file or folder) and ``--output`` (path+file name or just path, if the input is a folder to which Enelvo will write the output). Enelvo considers that each line in the input file is a sentence, so format it accordingly. Use option ``-h`` to see the full list of arguments and their explanation.\n\nIf your input is a folder/directory, you need to use the flag -F. Each output file will be written to the directory specified in ``--output``, as ``original_file_name + .normalized``.\n\nYou can also run Enelvo in **interactive mode**. In this case, you will be able to type in sentences and their normalised version will be displayed in real-time. To use interactive mode, just run:\n```bash\npython3 -m enelvo --interactive\n```\n\nEach of the arguments and their usage will be explained in the following section.\n\n## Arguments\nThere are some arguments that allow you to personalise how Enelvo works. You can find the details by adding ``-h`` or ``--help`` when running the tool. The main ones are:\n\n|                       &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**Option**&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;                       \t|                  **Default**                  \t|                                                    **Description**                                                   \t|\n|:------------------------------------------------------:\t|:---------------------------------------------:\t|:--------------------------------------------------------------------------------------------------------------------:\t|\n| ``-h, --help``                                         \t|                       -                       \t| Displays list of commands.                                                                                           \t|\n| ``-l, --lex LEX_FILE``                                 \t| ``unitex-full-clean+enelvo-ja-corrigido.txt`` \t| Changes the lexicon of words considered correct.                                                                     \t|\n| ``-F, --folder``                                 \t      |                       - \t                      | Sets input as a folder.                                                                     \t                        | \n| ``-iglst, --ignore-list LIST_FILE``                    \t|                    ``None``                   \t| Sets a list of words that will be ignored by the normaliser.                                                         \t|\n| ``-fclst, --force-list LIST_FILE``                     \t|                    ``None``                   \t| Sets a list of words (and optionally their corrections) that will always be processed by the normaliser.             \t|\n| ``-t, --tokenizer readable``                           \t|                  ``regular``                  \t| Changes tokeniser configuration. A ``readable`` tokeniser does not replace entities (hashtags, number etc) for tags. \t|\n| ``-cpns, --capitalize-pns``                            \t|                       -                       \t| Capitalises proper nouns (e.g. maria -> Maria).                                                                      \t|\n| ``-cacs, --capitalize-acs``                            \t|                       -                       \t| Capitalises acronyms (e.g bbb -> BBB).                                                                               \t|\n| ``-cinis, --capitalize-inis``                          \t|                       -                       \t| Capitalises initials in a sentence.                                                                                  \t|\n| ``-sn, --sanitize``                                    \t|                       -                       \t| Removes punctuation, emojis, and emoticons from all sentences.                                                       \t|\n\n\nThe following sections will explain each one more thoroughly.\n\n### Changing the Lexicon\nArgument ``-l`` or ``--lex`` lets you choose the lexicon of words considered correct -- i.e, this argument sets the language dictionary. The input must be the full file path (e.g. ``../some/folder/dict-pt.txt``).\n\n### Ignore and Force Lists\nUnfortunately, the language lexicons we use are not perfect. Sometimes they contain words that are not in fact correct, therefore preventing them from being normalised. They also sometimes don\'t contain words that are correct, thus wrongly marking them as noise.\nIn order to ease this problem, Enelvo implements **ignore** and **force** lists.\n\nAn ignore list is a list of words that will *always* be considered **correct** -- even if not contained in the language lexicon. To use it, add ``-iglst path_to_list`` or ``-ignore-list path_to_list``. The input must be the full path file and the file must contain a single word per line.\n\nA force list is a list of words that will *always* be considered **noisy** -- even if contained in the language lexicon. Thus, these words will alway be normalised. To use it, add ``-fclst path_to_list`` or ``-force-list path_to_list``. The input must be the full path file and the file must contain a single word per line.\n\nFor the force list, you can also force a correction. To do so, just write the word and its correction separated by a comma. You can mix both formats, for example:\n```bash\nvc\nq,que\noq, o que\nkk\netc\n```\nLines containing a comma will assume that the word after the comma is a forced correction. Other lines will just force the word to be corrected regularly by the normaliser.\n\n### Changing the Tokeniser\nBy default, the tokeniser used in Enelvo replaces some entities with pre-defined tags. Twitter usernames become ``USERNAME``, numbers (including dates, phone numbers etc) -> ``NUMBER``, URLs -> ``URL``, Twitter hashtags -> ``HASHTAG``, emojis -> ``EMOJI`` etc.\n\nIf you want to keep the tokens as they are (so no replacement tags), use ``-t readable`` or ``--tokenizer readable``.\n\n### Capitalising Entities\nEnelvo can capitalise different entities using lexicons. In order to do so, you just need to set a flag for each entity that you want to capitalise.\n\nTo capitalise proper nouns, set ``-cpns`` or ``--capitalize-pns``.\n\nTo capitalise acronyms, set ``-cacs`` or ``--capitalize-acs``.\n\nTo capitalise initials (first letter after punctuation or at the beggining of a sentence), set ``-cinis`` or ``--capitalize-inis``.\n\n### Cleaning the Text\nEnelvo also provides some methods for "cleaning" the text. If you want to remove punctuation, emojis, and emoticons from all sentences, simply set ``-sn``or ``--sanitize``.\n\n### Other Arguments\nThere are some other arguments used to control the internal functioning of the normalisation methods (like thresholds etc). Use ``-h`` or ``--help`` to see further details.\n\n## What Else?\nEverything described here is related to using Enelvo as a *tool*. However, it can be personalised and configured way further when used as an API/library. It is possible to generate and score candidates using a lot of different metrics and methods -- you can even use your own metrics! The easiest way of doing this is using the **Normaliser** class. Have a look at ``example.py`` and ``normaliser.py`` to understand how to start. The code is reasonably well-commented, so it shouldn\'t be too difficult to understand what is happening.\n\nIf you have any questions, comments, suggestions or problems with Enelvo, please feel free to [contact me](http://thalesbertaglia.com).\n\n## Acknowledgements\nMany people were fundamental in carrying out this project (and my master\'s in general), so I would like to thank some of them:\n\nGraça Nunes, Henrico Brum, Rafael Martins, Raphael Silva, and Thiago Pardo, who devoted a (big) portion of their valuable time to annotate the corpus that served as the basis for this project.\n\nMarcos Treviso for helping me organise and implement many parts os this project, and for teaching me a great deal of what I know about NLP.\n\nCarolina Coimbra and Thiago D\'Ávila, for being the first ones to use Enelvo, for reporting many bugs, and for suggesting valuable improvements to the tool.\n\nAll my fellow labmates from NILC for helping throughout my whole master\'s.\n\nThank you all! ❤️\n',
    'author': 'Thales Bertaglia',
    'author_email': 'contact@thalesbertaglia.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/thalesbertaglia/enelvo',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
