# SPDX-License-Identifier: GPL-2.0-or-later OR AGPL-3.0-or-later OR CERN-OHL-S-2.0+
import os
from textwrap import dedent

from pdkmaster.io.export import coriolis
from c4m.pdk import freepdk45

coriotechdir = os.environ["CORIOLIS_TECH_DIR"]
gen = coriolis.CoriolisGenerator(freepdk45.tech)

with open(f"{coriotechdir}/techno.py", "w") as f:
    f.write(dedent("""
        # Autogenerated file
        # SPDX-License-Identifier: GPL-2.0-or-later OR AGPL-3.0-or-later OR CERN-OHL-S-2.0+
    """))
    f.write(gen())
    print("Coriolis technology file written")

with open(f"{coriotechdir}/__init__.py", "w") as f_init:
    f_init.write("from .techno import *\n")
    for lib in freepdk45.__libs__:
        f_init.write(f"from .{lib.name} import setup as {lib.name}_setup\n")
        with open(f"{coriotechdir}/{lib.name}.py", "w") as f_lib:
            f_lib.write(gen(lib))
        print(f"Coriolis {lib.name} library file written")

    f_init.write(
        "\n__lib_setups__ = [{}]".format(
            ",".join(f"{lib.name}.setup" for lib in freepdk45.__libs__)
        )
    )

with open(f"{coriotechdir}/FlexLib_fix.py", "w") as f_fix:
    f_fix.write(dedent("""
        from Hurricane import Net

        def fix(lib):
            for cell in lib.getCells():
                for net in cell.getNets():
                    if net.getName() == 'vdd':
                        net.setType( Net.Type.POWER )
                        net.setDirection( Net.Direction.IN )
                    elif net.getName() == 'vss':
                        net.setType( Net.Type.GROUND )
                        net.setDirection( Net.Direction.IN )
                    elif net.getName() == 'ck':
                        net.setType( Net.Type.CLOCK )
                        net.setDirection( Net.Direction.IN )
                    elif net.getName() == 'nq' or net.getName() == "q":
                        net.setDirection( Net.Direction.OUT )
                    else:
                        net.setDirection( Net.Direction.IN )
    """[1:]))