# SPDX-License-Identifier: GPL-2.0-or-later OR AGPL-3.0-or-later OR CERN-OHL-S-2.0+
import os
from textwrap import dedent

try:
    from c4m import flexcell
except:
    print("Failed to load flexcell")
    exit(20)


with open(os.environ["FLEXCELL_MAKEFILE"], "w") as f:
    f.write(dedent(f"""
        # Autogenerated file
        # SPDX-License-Identifier: GPL-2.0-or-later OR AGPL-3.0-or-later OR CERN-OHL-S-2.0+
        FLEXCELL_PATH := {flexcell.__path__[0]}
    """[1:]))
