/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import net.sf.mpxj.CalendarType;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.Day;
import net.sf.mpxj.DayType;
import net.sf.mpxj.Duration;
import net.sf.mpxj.ProjectCalendarDays;
import net.sf.mpxj.ProjectCalendarException;
import net.sf.mpxj.ProjectCalendarHours;
import net.sf.mpxj.ProjectCalendarWeek;
import net.sf.mpxj.ProjectEntityWithUniqueID;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.RecurringData;
import net.sf.mpxj.Resource;
import net.sf.mpxj.Task;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.TimeUnitDefaultsContainer;
import net.sf.mpxj.common.DateHelper;
import net.sf.mpxj.common.NumberHelper;

public final class ProjectCalendar
extends ProjectCalendarDays
implements ProjectEntityWithUniqueID,
TimeUnitDefaultsContainer {
    private ProjectCalendar m_parent;
    private final ProjectFile m_projectFile;
    private Integer m_uniqueID = 0;
    private final List<ProjectCalendarException> m_exceptions = new ArrayList<ProjectCalendarException>();
    private final List<ProjectCalendarException> m_expandedExceptions = new ArrayList<ProjectCalendarException>();
    private boolean m_exceptionsSorted;
    private boolean m_weeksSorted;
    private final Map<DateRange, Long> m_workingDateCache = new WeakHashMap<DateRange, Long>();
    private final Map<Date, Date> m_startTimeCache = new WeakHashMap<Date, Date>();
    private Date m_getDateLastStartDate;
    private double m_getDateLastRemainingMinutes;
    private Date m_getDateLastResult;
    private final ArrayList<ProjectCalendarWeek> m_workWeeks = new ArrayList();
    private Integer m_calendarMinutesPerDay;
    private Integer m_calendarMinutesPerWeek;
    private Integer m_calendarMinutesPerMonth;
    private Integer m_calendarMinutesPerYear;
    private CalendarType m_type = CalendarType.GLOBAL;
    private boolean m_personal;
    public static final String DEFAULT_BASE_CALENDAR_NAME = "Standard";
    private static final int MAX_NONWORKING_DAYS = 1000;
    private static final ProjectCalendarHours EMPTY_DATE_RANGES = new ProjectCalendarHours(){};

    public ProjectCalendar(ProjectFile file) {
        this.m_projectFile = file;
        if (file.getProjectConfig().getAutoCalendarUniqueID()) {
            this.setUniqueID(file.getProjectConfig().getNextCalendarUniqueID());
        }
    }

    @Override
    public Integer getMinutesPerDay() {
        Integer result = this.m_calendarMinutesPerDay;
        if (result == null) {
            result = this.m_parent == null ? this.getParentFile().getProjectProperties().getMinutesPerDay() : this.m_parent.getMinutesPerDay();
        }
        return result;
    }

    @Override
    public Integer getMinutesPerWeek() {
        Integer result = this.m_calendarMinutesPerWeek;
        if (result == null) {
            result = this.m_parent == null ? this.getParentFile().getProjectProperties().getMinutesPerWeek() : this.m_parent.getMinutesPerWeek();
        }
        return result;
    }

    @Override
    public Integer getMinutesPerMonth() {
        Integer result = this.m_calendarMinutesPerMonth;
        if (result == null) {
            result = this.m_parent == null ? this.getParentFile().getProjectProperties().getMinutesPerMonth() : this.m_parent.getMinutesPerMonth();
        }
        return result;
    }

    @Override
    public Integer getMinutesPerYear() {
        Integer result = this.m_calendarMinutesPerYear;
        if (result == null) {
            result = this.m_parent == null ? this.getParentFile().getProjectProperties().getMinutesPerYear() : this.m_parent.getMinutesPerYear();
        }
        return result;
    }

    @Override
    public Integer getDaysPerMonth() {
        return this.getParentFile().getProjectProperties().getDaysPerMonth();
    }

    @Deprecated
    public void setMinutesPerDay(Integer minutes) {
        this.setCalendarMinutesPerDay(minutes);
    }

    public void setCalendarMinutesPerDay(Integer minutes) {
        this.m_calendarMinutesPerDay = minutes;
    }

    public Integer getCalendarMinutesPerDay() {
        return this.m_calendarMinutesPerDay;
    }

    @Deprecated
    public void setMinutesPerWeek(Integer minutes) {
        this.setCalendarMinutesPerWeek(minutes);
    }

    public void setCalendarMinutesPerWeek(Integer minutes) {
        this.m_calendarMinutesPerWeek = minutes;
    }

    public Integer getCalendarMinutesPerWeek() {
        return this.m_calendarMinutesPerWeek;
    }

    @Deprecated
    public void setMinutesPerMonth(Integer minutes) {
        this.setCalendarMinutesPerMonth(minutes);
    }

    public void setCalendarMinutesPerMonth(Integer minutes) {
        this.m_calendarMinutesPerMonth = minutes;
    }

    public Integer getCalendarMinutesPerMonth() {
        return this.m_calendarMinutesPerMonth;
    }

    @Deprecated
    public void setMinutesPerYear(Integer minutes) {
        this.setCalendarMinutesPerYear(minutes);
    }

    public void setCalendarMinutesPerYear(Integer minutes) {
        this.m_calendarMinutesPerYear = minutes;
    }

    public Integer getCalendarMinutesPerYear() {
        return this.m_calendarMinutesPerYear;
    }

    public ProjectCalendarWeek addWorkWeek() {
        ProjectCalendarWeek week = new ProjectCalendarWeek();
        this.m_workWeeks.add(week);
        this.m_weeksSorted = false;
        this.clearWorkingDateCache();
        return week;
    }

    public void removeWorkWeek(ProjectCalendarWeek week) {
        this.m_workWeeks.remove(week);
        this.clearWorkingDateCache();
    }

    public void clearWorkWeeks() {
        this.m_workWeeks.clear();
        this.m_weeksSorted = false;
        this.clearWorkingDateCache();
    }

    public List<ProjectCalendarWeek> getWorkWeeks() {
        return Collections.unmodifiableList(this.m_workWeeks);
    }

    public ProjectCalendarException addCalendarException(Date date) {
        return this.addCalendarException(date, date, null);
    }

    public ProjectCalendarException addCalendarException(Date fromDate, Date toDate) {
        return this.addCalendarException(fromDate, toDate, null);
    }

    public ProjectCalendarException addCalendarException(RecurringData recurringData) {
        return this.addCalendarException(null, null, recurringData);
    }

    private ProjectCalendarException addCalendarException(Date fromDate, Date toDate, RecurringData recurringData) {
        ProjectCalendarException bce = new ProjectCalendarException(fromDate, toDate, recurringData);
        this.m_exceptions.add(bce);
        this.m_expandedExceptions.clear();
        this.m_exceptionsSorted = false;
        this.clearWorkingDateCache();
        return bce;
    }

    public void removeCalendarException(ProjectCalendarException exception) {
        this.m_exceptions.remove(exception);
        this.m_expandedExceptions.clear();
        this.clearWorkingDateCache();
    }

    public void clearCalendarExceptions() {
        this.m_exceptions.clear();
        this.m_expandedExceptions.clear();
        this.m_exceptionsSorted = false;
        this.clearWorkingDateCache();
    }

    public List<ProjectCalendarException> getCalendarExceptions() {
        this.sortExceptions();
        return Collections.unmodifiableList(this.m_exceptions);
    }

    public List<ProjectCalendarException> getExpandedCalendarExceptions() {
        this.populateExpandedExceptions();
        return Collections.unmodifiableList(this.m_expandedExceptions);
    }

    @Override
    public ProjectCalendarHours addCalendarHours(Day day) {
        this.clearWorkingDateCache();
        return super.addCalendarHours(day);
    }

    @Override
    public void removeCalendarHours(Day day) {
        this.clearWorkingDateCache();
        super.removeCalendarHours(day);
    }

    public void setParent(ProjectCalendar calendar) {
        if (calendar != this) {
            this.m_parent = calendar;
            Arrays.stream(Day.values()).filter(d -> this.getCalendarDayType((Day)d) == null).forEach(d -> this.setCalendarDayType((Day)d, DayType.DEFAULT));
            this.clearWorkingDateCache();
        }
    }

    public ProjectCalendar getParent() {
        return this.m_parent;
    }

    public Duration getDuration(Date startDate, Date endDate) {
        Calendar cal = DateHelper.popCalendar(startDate);
        int days = this.getDaysInRange(startDate, endDate);
        int duration = 0;
        Day day = Day.getInstance(cal.get(7));
        while (days > 0) {
            if (this.isWorkingDate(cal.getTime(), day)) {
                ++duration;
            }
            --days;
            day = day.getNextDay();
            cal.set(6, cal.get(6) + 1);
        }
        DateHelper.pushCalendar(cal);
        return Duration.getInstance(duration, TimeUnit.DAYS);
    }

    public Date getStartTime(Date date) {
        Date result = this.m_startTimeCache.get(date);
        if (result == null) {
            ProjectCalendarHours ranges = this.getRanges(date, null, null);
            result = ranges == null ? this.getParentFile().getProjectProperties().getDefaultStartTime() : ranges.get(0).getStart();
            result = DateHelper.getCanonicalTime(result);
            this.m_startTimeCache.put(new Date(date.getTime()), result);
        }
        return result;
    }

    public Date getFinishTime(Date date) {
        Date result = null;
        if (date != null) {
            ProjectCalendarHours ranges = this.getRanges(date, null, null);
            if (ranges == null) {
                result = this.getParentFile().getProjectProperties().getDefaultEndTime();
                result = DateHelper.getCanonicalTime(result);
            } else {
                Date rangeStart = ranges.get(0).getStart();
                Date rangeFinish = ranges.get(ranges.size() - 1).getEnd();
                Date startDay = DateHelper.getDayStartDate(rangeStart);
                Date finishDay = DateHelper.getDayStartDate(rangeFinish);
                result = DateHelper.getCanonicalTime(rangeFinish);
                if (startDay != null && finishDay != null && startDay.getTime() != finishDay.getTime()) {
                    result = DateHelper.addDays(result, 1);
                }
            }
        }
        return result;
    }

    public Date getDate(Date startDate, Duration duration, boolean returnNextWorkStart) {
        ProjectProperties properties = this.getParentFile().getProjectProperties();
        double remainingMinutes = NumberHelper.round(duration.convertUnits(TimeUnit.MINUTES, properties).getDuration(), 2.0);
        Date getDateLastStartDate = this.m_getDateLastStartDate;
        double getDateLastRemainingMinutes = this.m_getDateLastRemainingMinutes;
        this.m_getDateLastStartDate = startDate;
        this.m_getDateLastRemainingMinutes = remainingMinutes;
        if (this.m_getDateLastResult != null && DateHelper.compare(startDate, getDateLastStartDate) == 0 && remainingMinutes >= getDateLastRemainingMinutes) {
            startDate = this.m_getDateLastResult;
            remainingMinutes -= getDateLastRemainingMinutes;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(startDate);
        Calendar endCal = Calendar.getInstance();
        while (remainingMinutes > 0.0) {
            Date currentDate = cal.getTime();
            endCal.setTime(currentDate);
            endCal.add(6, 1);
            Date currentDateEnd = DateHelper.getDayStartDate(endCal.getTime());
            double currentDateWorkingMinutes = this.getWork(currentDate, currentDateEnd, TimeUnit.MINUTES).getDuration();
            if (remainingMinutes > currentDateWorkingMinutes) {
                Day day;
                remainingMinutes = NumberHelper.round(remainingMinutes - currentDateWorkingMinutes, 2.0);
                int nonWorkingDayCount = 0;
                do {
                    cal.add(6, 1);
                    day = Day.getInstance(cal.get(7));
                    if (++nonWorkingDayCount <= 1000) continue;
                    cal.setTime(startDate);
                    cal.add(6, 1);
                    remainingMinutes = 0.0;
                    break;
                } while (!this.isWorkingDate(cal.getTime(), day));
                Date startTime = this.getStartTime(cal.getTime());
                DateHelper.setTime(cal, startTime);
                continue;
            }
            ProjectCalendarHours ranges = this.getRanges(cal.getTime(), cal, null);
            Date endTime = null;
            Date currentDateStartTime = DateHelper.getCanonicalTime(currentDate);
            boolean firstRange = true;
            for (DateRange range : ranges) {
                Date rangeStart = range.getStart();
                Date rangeEnd = range.getEnd();
                if (rangeStart == null || rangeEnd == null) continue;
                Date canonicalRangeEnd = DateHelper.getCanonicalTime(rangeEnd);
                Date canonicalRangeStart = DateHelper.getCanonicalTime(rangeStart);
                Date rangeStartDay = DateHelper.getDayStartDate(rangeStart);
                Date rangeEndDay = DateHelper.getDayStartDate(rangeEnd);
                if (rangeStartDay.getTime() != rangeEndDay.getTime()) {
                    canonicalRangeEnd = DateHelper.addDays(canonicalRangeEnd, 1);
                }
                if (firstRange && canonicalRangeEnd.getTime() < currentDateStartTime.getTime()) continue;
                if (firstRange && canonicalRangeStart.getTime() < currentDateStartTime.getTime()) {
                    canonicalRangeStart = currentDateStartTime;
                }
                firstRange = false;
                double rangeMinutes = canonicalRangeEnd.getTime() - canonicalRangeStart.getTime();
                if (remainingMinutes > (rangeMinutes /= 60000.0)) {
                    remainingMinutes = NumberHelper.round(remainingMinutes - rangeMinutes, 2.0);
                    continue;
                }
                if (Duration.durationValueEquals(remainingMinutes, rangeMinutes)) {
                    endTime = canonicalRangeEnd;
                    if (rangeStartDay.getTime() != rangeEndDay.getTime()) {
                        cal.add(6, 1);
                    }
                } else {
                    endTime = new Date((long)((double)canonicalRangeStart.getTime() + remainingMinutes * 60000.0));
                    returnNextWorkStart = false;
                }
                remainingMinutes = 0.0;
                break;
            }
            DateHelper.setTime(cal, endTime);
        }
        this.m_getDateLastResult = cal.getTime();
        if (returnNextWorkStart) {
            this.updateToNextWorkStart(cal);
        }
        return cal.getTime();
    }

    public Date getStartDate(Date finishDate, Duration duration) {
        ProjectProperties properties = this.getParentFile().getProjectProperties();
        Date projectStartDate = properties.getStartDate();
        if (projectStartDate == null) {
            Calendar cal = DateHelper.popCalendar(new Date());
            cal.add(6, -365);
            projectStartDate = cal.getTime();
            DateHelper.pushCalendar(cal);
        }
        long projectStart = projectStartDate.getTime();
        double remainingMinutes = NumberHelper.round(duration.convertUnits(TimeUnit.MINUTES, properties).getDuration(), 2.0);
        Calendar cal = Calendar.getInstance();
        cal.setTime(finishDate);
        Calendar startCal = Calendar.getInstance();
        while (remainingMinutes > 0.0) {
            Date currentDate = cal.getTime();
            startCal.setTime(currentDate);
            startCal.add(6, -1);
            Date currentDateEnd = DateHelper.getDayEndDate(startCal.getTime());
            double currentDateWorkingMinutes = this.getWork(currentDateEnd, currentDate, TimeUnit.MINUTES).getDuration();
            if (remainingMinutes > currentDateWorkingMinutes) {
                Day day;
                remainingMinutes = NumberHelper.round(remainingMinutes - currentDateWorkingMinutes, 2.0);
                do {
                    if (cal.getTimeInMillis() < projectStart) {
                        return null;
                    }
                    cal.add(6, -1);
                    day = Day.getInstance(cal.get(7));
                } while (!this.isWorkingDate(cal.getTime(), day));
                Date finishTime = this.getFinishTime(cal.getTime());
                DateHelper.setTime(cal, finishTime);
                continue;
            }
            ProjectCalendarHours ranges = this.getRanges(cal.getTime(), cal, null);
            Date startTime = null;
            Date currentDateFinishTime = DateHelper.getCanonicalTime(currentDate);
            boolean firstRange = true;
            for (int i = ranges.size() - 1; i >= 0; --i) {
                DateRange range = ranges.get(i);
                Date rangeStart = range.getStart();
                Date rangeEnd = range.getEnd();
                if (rangeStart == null || rangeEnd == null) continue;
                Date canonicalRangeEnd = DateHelper.getCanonicalTime(rangeEnd);
                Date canonicalRangeStart = DateHelper.getCanonicalTime(rangeStart);
                Date rangeStartDay = DateHelper.getDayStartDate(rangeStart);
                Date rangeEndDay = DateHelper.getDayStartDate(rangeEnd);
                if (rangeStartDay.getTime() != rangeEndDay.getTime()) {
                    canonicalRangeEnd = DateHelper.addDays(canonicalRangeEnd, 1);
                }
                if (firstRange && canonicalRangeStart.getTime() > currentDateFinishTime.getTime()) continue;
                if (firstRange && canonicalRangeEnd.getTime() > currentDateFinishTime.getTime()) {
                    canonicalRangeEnd = currentDateFinishTime;
                }
                firstRange = false;
                double rangeMinutes = canonicalRangeEnd.getTime() - canonicalRangeStart.getTime();
                if (remainingMinutes > (rangeMinutes /= 60000.0)) {
                    remainingMinutes = NumberHelper.round(remainingMinutes - rangeMinutes, 2.0);
                    continue;
                }
                startTime = Duration.durationValueEquals(remainingMinutes, rangeMinutes) ? canonicalRangeStart : new Date((long)((double)canonicalRangeEnd.getTime() - remainingMinutes * 60000.0));
                remainingMinutes = 0.0;
                break;
            }
            DateHelper.setTime(cal, startTime);
        }
        return cal.getTime();
    }

    private void updateToNextWorkStart(Calendar cal) {
        Date originalDate = cal.getTime();
        ProjectCalendarHours ranges = this.getRanges(originalDate, cal, null);
        if (ranges != null) {
            Date calTime = DateHelper.getCanonicalTime(cal.getTime());
            Date startTime = null;
            for (DateRange range : ranges) {
                Date rangeStart = DateHelper.getCanonicalTime(range.getStart());
                Date rangeEnd = DateHelper.getCanonicalTime(range.getEnd());
                Date rangeStartDay = DateHelper.getDayStartDate(range.getStart());
                Date rangeEndDay = DateHelper.getDayStartDate(range.getEnd());
                if (rangeStartDay.getTime() != rangeEndDay.getTime()) {
                    rangeEnd = DateHelper.addDays(rangeEnd, 1);
                }
                if (calTime.getTime() >= rangeEnd.getTime()) continue;
                if (calTime.getTime() > rangeStart.getTime()) {
                    startTime = calTime;
                    break;
                }
                startTime = rangeStart;
                break;
            }
            if (startTime == null) {
                Day day;
                int nonWorkingDayCount = 0;
                do {
                    cal.set(6, cal.get(6) + 1);
                    day = Day.getInstance(cal.get(7));
                    if (++nonWorkingDayCount <= 1000) continue;
                    cal.setTime(originalDate);
                    break;
                } while (!this.isWorkingDate(cal.getTime(), day));
                startTime = this.getStartTime(cal.getTime());
            }
            DateHelper.setTime(cal, startTime);
        }
    }

    private void updateToPreviousWorkFinish(Calendar cal) {
        Date originalDate = cal.getTime();
        ProjectCalendarHours ranges = this.getRanges(originalDate, cal, null);
        if (ranges != null) {
            Date calTime = DateHelper.getCanonicalTime(cal.getTime());
            Date finishTime = null;
            for (DateRange range : ranges) {
                Date rangeEnd = DateHelper.getCanonicalTime(range.getEnd());
                Date rangeStartDay = DateHelper.getDayStartDate(range.getStart());
                Date rangeEndDay = DateHelper.getDayStartDate(range.getEnd());
                if (rangeStartDay.getTime() != rangeEndDay.getTime()) {
                    rangeEnd = DateHelper.addDays(rangeEnd, 1);
                }
                if (calTime.getTime() < rangeEnd.getTime()) continue;
                finishTime = rangeEnd;
                break;
            }
            if (finishTime == null) {
                Day day;
                int nonWorkingDayCount = 0;
                do {
                    cal.set(6, cal.get(6) - 1);
                    day = Day.getInstance(cal.get(7));
                    if (++nonWorkingDayCount <= 1000) continue;
                    cal.setTime(originalDate);
                    break;
                } while (!this.isWorkingDate(cal.getTime(), day));
                finishTime = this.getFinishTime(cal.getTime());
            }
            DateHelper.setTime(cal, finishTime);
        }
    }

    public Date getNextWorkStart(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        this.updateToNextWorkStart(cal);
        return cal.getTime();
    }

    public Date getPreviousWorkFinish(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        this.updateToPreviousWorkFinish(cal);
        return cal.getTime();
    }

    public DayType getDayType(Day day) {
        DayType result = this.getCalendarDayType(day);
        if (result == DayType.DEFAULT) {
            result = this.m_parent == null ? (day == Day.SATURDAY || day == Day.SUNDAY ? DayType.NON_WORKING : DayType.WORKING) : this.m_parent.getDayType(day);
        }
        return result;
    }

    public boolean isWorkingDay(Day day) {
        return this.getDayType(day) == DayType.WORKING;
    }

    public boolean isWorkingDate(Date date) {
        Calendar cal = DateHelper.popCalendar(date);
        Day day = Day.getInstance(cal.get(7));
        DateHelper.pushCalendar(cal);
        return this.isWorkingDate(date, day);
    }

    private boolean isWorkingDate(Date date, Day day) {
        ProjectCalendarHours ranges = this.getRanges(date, null, day);
        return ranges.size() != 0;
    }

    private int getDaysInRange(Date startDate, Date endDate) {
        int result;
        Calendar cal = DateHelper.popCalendar(endDate);
        int endDateYear = cal.get(1);
        int endDateDayOfYear = cal.get(6);
        cal.setTime(startDate);
        if (endDateYear == cal.get(1)) {
            result = endDateDayOfYear - cal.get(6) + 1;
        } else {
            result = 0;
            do {
                result += cal.getActualMaximum(6) - cal.get(6) + 1;
                cal.roll(1, 1);
                cal.set(6, 1);
            } while (cal.get(1) < endDateYear);
            result += endDateDayOfYear;
        }
        DateHelper.pushCalendar(cal);
        return result;
    }

    public ProjectCalendarHours getHours(Day day) {
        ProjectCalendarHours result = this.getCalendarHours(day);
        if (result == null) {
            result = this.m_parent.getHours(day);
        }
        return result;
    }

    @Override
    public void setUniqueID(Integer uniqueID) {
        this.getParentFile().getCalendars().clearUniqueIDMap();
        this.m_uniqueID = uniqueID;
    }

    @Override
    public Integer getUniqueID() {
        return this.m_uniqueID;
    }

    public List<Task> getTasks() {
        return Collections.unmodifiableList(this.getParentFile().getTasks().stream().filter(t -> this.m_uniqueID.equals(t.getCalendarUniqueID())).collect(Collectors.toList()));
    }

    public List<Resource> getResources() {
        return Collections.unmodifiableList(this.getParentFile().getResources().stream().filter(r -> this.m_uniqueID.equals(r.getCalendarUniqueID())).collect(Collectors.toList()));
    }

    @Deprecated
    public Resource getResource() {
        return this.getResources().stream().findFirst().orElse(null);
    }

    public int getResourceCount() {
        return (int)this.getParentFile().getResources().stream().filter(r -> this.m_uniqueID.equals(r.getCalendarUniqueID())).count();
    }

    @Deprecated
    public void setResource(Resource resource) {
    }

    public void remove() {
        this.getParentFile().removeCalendar(this);
    }

    public ProjectCalendarException getException(Date date) {
        if (date == null) {
            return null;
        }
        ProjectCalendarException exception = null;
        this.populateExpandedExceptions();
        if (!this.m_expandedExceptions.isEmpty()) {
            int low = 0;
            int high = this.m_expandedExceptions.size() - 1;
            long targetDate = date.getTime();
            while (low <= high) {
                int mid = low + high >>> 1;
                ProjectCalendarException midVal = this.m_expandedExceptions.get(mid);
                int cmp = DateHelper.compare(midVal.getFromDate(), midVal.getToDate(), targetDate);
                if (cmp > 0) {
                    low = mid + 1;
                    continue;
                }
                if (cmp < 0) {
                    high = mid - 1;
                    continue;
                }
                exception = midVal;
                break;
            }
        }
        if (exception == null && this.m_parent != null) {
            exception = this.m_parent.getException(date);
        }
        return exception;
    }

    public ProjectCalendarWeek getWorkWeek(Date date) {
        if (date == null) {
            return null;
        }
        ProjectCalendarWeek week = null;
        if (!this.m_workWeeks.isEmpty()) {
            this.sortWorkWeeks();
            int low = 0;
            int high = this.m_workWeeks.size() - 1;
            long targetDate = date.getTime();
            while (low <= high) {
                int mid = low + high >>> 1;
                ProjectCalendarWeek midVal = this.m_workWeeks.get(mid);
                int cmp = DateHelper.compare(midVal.getDateRange().getStart(), midVal.getDateRange().getEnd(), targetDate);
                if (cmp > 0) {
                    low = mid + 1;
                    continue;
                }
                if (cmp < 0) {
                    high = mid - 1;
                    continue;
                }
                week = midVal;
                break;
            }
        }
        if (week == null && this.m_parent != null) {
            week = this.m_parent.getWorkWeek(date);
        }
        return week;
    }

    public Duration getWork(Day day, TimeUnit format) {
        ProjectCalendarHours ranges = this.getRanges(null, null, day);
        return this.convertFormat(this.getTotalTime(ranges), format);
    }

    public Duration getWork(Date date, TimeUnit format) {
        ProjectCalendarHours ranges = this.getRanges(date, null, null);
        return this.convertFormat(this.getTotalTime(ranges), format);
    }

    public Duration getWork(Date startDate, Date endDate, TimeUnit format) {
        DateRange range = new DateRange(startDate, endDate);
        Long cachedResult = this.m_workingDateCache.get(range);
        long totalTime = 0L;
        if (cachedResult == null) {
            boolean invert = false;
            if (startDate.getTime() > endDate.getTime()) {
                invert = true;
                Date temp = startDate;
                startDate = endDate;
                endDate = temp;
            }
            Date canonicalStartDate = DateHelper.getDayStartDate(startDate);
            Date canonicalEndDate = DateHelper.getDayStartDate(endDate);
            if (canonicalStartDate.getTime() == canonicalEndDate.getTime()) {
                ProjectCalendarHours ranges = this.getRanges(startDate, null, null);
                if (ranges.size() != 0) {
                    totalTime = this.getTotalTime(ranges, startDate, endDate);
                }
            } else {
                ProjectCalendarHours ranges;
                Date currentDate = startDate;
                Calendar cal = Calendar.getInstance();
                cal.setTime(startDate);
                Day day = Day.getInstance(cal.get(7));
                while (!this.isWorkingDate(currentDate, day) && currentDate.getTime() < canonicalEndDate.getTime()) {
                    cal.add(6, 1);
                    currentDate = cal.getTime();
                    day = day.getNextDay();
                }
                if (currentDate.getTime() < canonicalEndDate.getTime()) {
                    totalTime += this.getTotalTime(this.getRanges(currentDate, null, day), currentDate, true);
                    while (true) {
                        cal.add(6, 1);
                        currentDate = cal.getTime();
                        day = day.getNextDay();
                        if (currentDate.getTime() >= canonicalEndDate.getTime()) break;
                        ranges = this.getRanges(currentDate, null, day);
                        if (ranges.size() == 0) continue;
                        totalTime += this.getTotalTime(ranges);
                    }
                }
                if ((ranges = this.getRanges(endDate, null, day)).size() != 0) {
                    totalTime += this.getTotalTime(ranges, DateHelper.getDayStartDate(endDate), endDate);
                }
            }
            if (invert) {
                totalTime = -totalTime;
            }
            this.m_workingDateCache.put(range, totalTime);
        } else {
            totalTime = cachedResult;
        }
        return this.convertFormat(totalTime, format);
    }

    private Duration convertFormat(long totalTime, TimeUnit format) {
        double duration = totalTime;
        switch (format) {
            case MINUTES: 
            case ELAPSED_MINUTES: {
                duration /= 60000.0;
                break;
            }
            case HOURS: 
            case ELAPSED_HOURS: {
                duration /= 3600000.0;
                break;
            }
            case DAYS: {
                double minutesPerDay = NumberHelper.getDouble(this.getMinutesPerDay());
                if (minutesPerDay != 0.0) {
                    duration /= minutesPerDay * 60.0 * 1000.0;
                    break;
                }
                duration = 0.0;
                break;
            }
            case WEEKS: {
                double minutesPerWeek = NumberHelper.getDouble(this.getMinutesPerWeek());
                if (minutesPerWeek != 0.0) {
                    duration /= minutesPerWeek * 60.0 * 1000.0;
                    break;
                }
                duration = 0.0;
                break;
            }
            case MONTHS: {
                double daysPerMonth = this.getParentFile().getProjectProperties().getDaysPerMonth().doubleValue();
                double minutesPerDay = NumberHelper.getDouble(this.getMinutesPerDay());
                if (daysPerMonth != 0.0 && minutesPerDay != 0.0) {
                    duration /= daysPerMonth * minutesPerDay * 60.0 * 1000.0;
                    break;
                }
                duration = 0.0;
                break;
            }
            case ELAPSED_DAYS: {
                duration /= 8.64E7;
                break;
            }
            case ELAPSED_WEEKS: {
                duration /= 6.048E8;
                break;
            }
            case ELAPSED_MONTHS: {
                duration /= 2.592E9;
                break;
            }
            default: {
                throw new IllegalArgumentException("TimeUnit " + format + " not supported");
            }
        }
        return Duration.getInstance(duration, format);
    }

    private long getTotalTime(ProjectCalendarHours exception, Date date, boolean after) {
        long currentTime = DateHelper.getCanonicalTime(date).getTime();
        long total = 0L;
        for (DateRange range : exception) {
            total += this.getTime(range.getStart(), range.getEnd(), currentTime, after);
        }
        return total;
    }

    private long getTotalTime(ProjectCalendarHours exception) {
        long total = 0L;
        for (DateRange range : exception) {
            total += this.getTime(range.getStart(), range.getEnd());
        }
        return total;
    }

    private long getTotalTime(ProjectCalendarHours hours, Date startDate, Date endDate) {
        long total = 0L;
        if (startDate.getTime() != endDate.getTime()) {
            Date start = DateHelper.getCanonicalTime(startDate);
            Date end = DateHelper.getCanonicalTime(endDate);
            for (DateRange range : hours) {
                Date rangeStart = range.getStart();
                Date rangeEnd = range.getEnd();
                if (rangeStart == null || rangeEnd == null) continue;
                Date canoncialRangeStart = DateHelper.getCanonicalTime(rangeStart);
                Date canonicalRangeEnd = DateHelper.getCanonicalTime(rangeEnd);
                Date startDay = DateHelper.getDayStartDate(rangeStart);
                Date finishDay = DateHelper.getDayStartDate(rangeEnd);
                if (startDay.getTime() != finishDay.getTime()) {
                    canonicalRangeEnd = DateHelper.addDays(canonicalRangeEnd, 1);
                }
                if (canoncialRangeStart.getTime() == canonicalRangeEnd.getTime() && rangeEnd.getTime() > rangeStart.getTime()) {
                    total += 86400000L;
                    continue;
                }
                total += this.getTime(start, end, canoncialRangeStart, canonicalRangeEnd);
            }
        }
        return total;
    }

    private long getTime(Date start, Date end, long target, boolean after) {
        long total = 0L;
        if (start != null && end != null) {
            int diff;
            Date startTime = DateHelper.getCanonicalTime(start);
            Date endTime = DateHelper.getCanonicalTime(end);
            Date startDay = DateHelper.getDayStartDate(start);
            Date finishDay = DateHelper.getDayStartDate(end);
            if (startDay.getTime() != finishDay.getTime()) {
                endTime = DateHelper.addDays(endTime, 1);
            }
            if ((diff = DateHelper.compare(startTime, endTime, target)) == 0) {
                total = after ? endTime.getTime() - target : target - startTime.getTime();
            } else if (after && diff < 0 || !after && diff > 0) {
                total = endTime.getTime() - startTime.getTime();
            }
        }
        return total;
    }

    private long getTime(Date start, Date end) {
        long total = 0L;
        if (start != null && end != null) {
            Date startTime = DateHelper.getCanonicalTime(start);
            Date endTime = DateHelper.getCanonicalTime(end);
            Date startDay = DateHelper.getDayStartDate(start);
            Date finishDay = DateHelper.getDayStartDate(end);
            if (startDay.getTime() != finishDay.getTime()) {
                endTime = DateHelper.addDays(endTime, 1);
            }
            total = endTime.getTime() - startTime.getTime();
        }
        return total;
    }

    private long getTime(Date start1, Date end1, Date start2, Date end2) {
        long end;
        long start;
        long total = 0L;
        if (start1 != null && end1 != null && start2 != null && end2 != null && (start = Math.max(start1.getTime(), start2.getTime())) < (end = Math.min(end1.getTime(), end2.getTime()))) {
            total = end - start;
        }
        return total;
    }

    public List<ProjectCalendar> getDerivedCalendars() {
        return Collections.unmodifiableList(this.m_projectFile.getCalendars().stream().filter(c -> c.m_parent != null && this.m_uniqueID.equals(c.m_parent.m_uniqueID)).collect(Collectors.toList()));
    }

    public String toString() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(os);
        pw.println("[ProjectCalendar");
        pw.println("   ID=" + this.m_uniqueID);
        pw.println("   name=" + this.getName());
        pw.println("   baseCalendarName=" + (this.m_parent == null ? "" : this.m_parent.getName()));
        for (Day day : Day.values()) {
            pw.println("   [Day " + day);
            pw.println("      type=" + this.getCalendarDayType(day));
            pw.println("      hours=" + this.getHours(day));
            pw.println("   ]");
        }
        if (!this.m_exceptions.isEmpty()) {
            pw.println("   [Exceptions=");
            for (ProjectCalendarException ex : this.m_exceptions) {
                pw.println("      " + ex.toString());
            }
            pw.println("   ]");
        }
        if (!this.m_workWeeks.isEmpty()) {
            pw.println("   [WorkWeeks=");
            for (ProjectCalendarWeek week : this.m_workWeeks) {
                pw.println("      " + week.toString());
            }
            pw.println("   ]");
        }
        pw.println("]");
        pw.flush();
        return os.toString();
    }

    @Deprecated
    public ProjectCalendar(ProjectFile file, ProjectCalendar taskCalendar, ProjectCalendar resourceCalendar) {
        this.m_projectFile = file;
        block0: for (int i = 1; i <= 7; ++i) {
            Day day;
            this.setWorkingDay(day, taskCalendar.isWorkingDay(day = Day.getInstance(i)) && resourceCalendar.isWorkingDay(day));
            ProjectCalendarHours hours = this.addCalendarHours(day);
            int taskIndex = 0;
            int resourceIndex = 0;
            ProjectCalendarHours taskHours = taskCalendar.getHours(day);
            ProjectCalendarHours resourceHours = resourceCalendar.getHours(day);
            while (taskHours.size() > taskIndex) {
                Date end;
                DateRange range1 = taskHours.get(taskIndex);
                if (resourceHours.size() <= resourceIndex) continue block0;
                DateRange range2 = resourceHours.get(resourceIndex);
                Date start1 = range1.getStart();
                Date start2 = range2.getStart();
                Date end1 = range1.getEnd();
                Date end2 = range2.getEnd();
                Date start = start1.compareTo(start2) > 0 ? start1 : start2;
                if (end1.compareTo(end2) < 0) {
                    end = end1;
                    ++taskIndex;
                } else {
                    end = end2;
                    ++resourceIndex;
                }
                if (end == null || end.compareTo(start) <= 0) continue;
                hours.add(new DateRange(start, end));
            }
        }
        this.m_exceptions.addAll(taskCalendar.getCalendarExceptions());
        this.m_exceptions.addAll(resourceCalendar.getCalendarExceptions());
        this.m_expandedExceptions.clear();
        this.m_exceptionsSorted = false;
        this.m_workWeeks.addAll(taskCalendar.getWorkWeeks());
        this.m_workWeeks.addAll(resourceCalendar.getWorkWeeks());
        this.m_weeksSorted = false;
    }

    @Deprecated
    public void copy(ProjectCalendar cal) {
        this.setName(cal.getName());
        this.setParent(cal.getParent());
        this.m_calendarMinutesPerDay = cal.m_calendarMinutesPerDay;
        this.m_calendarMinutesPerWeek = cal.m_calendarMinutesPerWeek;
        this.m_calendarMinutesPerMonth = cal.m_calendarMinutesPerMonth;
        this.m_calendarMinutesPerYear = cal.m_calendarMinutesPerYear;
        for (ProjectCalendarException ex : cal.m_exceptions) {
            ProjectCalendarException copyException = this.addCalendarException(ex.getFromDate(), ex.getToDate());
            for (DateRange range : ex) {
                copyException.add(new DateRange(range.getStart(), range.getEnd()));
            }
        }
        for (Day day : Day.values()) {
            this.setCalendarDayType(day, cal.getCalendarDayType(day));
            ProjectCalendarHours hours = this.getCalendarHours(day);
            if (hours == null) continue;
            ProjectCalendarHours copyHours = cal.addCalendarHours(day);
            for (DateRange range : hours) {
                copyHours.add(new DateRange(range.getStart(), range.getEnd()));
            }
        }
    }

    private void clearWorkingDateCache() {
        this.m_workingDateCache.clear();
        this.m_startTimeCache.clear();
        this.m_getDateLastResult = null;
        this.getDerivedCalendars().forEach(ProjectCalendar::clearWorkingDateCache);
    }

    private ProjectCalendarHours getRanges(Date date, Calendar cal, Day day) {
        ProjectCalendarHours ranges = this.getException(date);
        if (ranges != null) {
            return ranges;
        }
        ProjectCalendarDays week = this.getWorkWeek(date);
        if (week == null) {
            week = this;
        }
        if (day == null) {
            if (cal == null) {
                cal = Calendar.getInstance();
                cal.setTime(date);
            }
            day = Day.getInstance(cal.get(7));
        }
        switch (week.getCalendarDayType(day)) {
            case NON_WORKING: {
                ranges = EMPTY_DATE_RANGES;
                break;
            }
            case WORKING: {
                ranges = week.getCalendarHours(day);
                break;
            }
            case DEFAULT: {
                ranges = this.m_parent == null ? EMPTY_DATE_RANGES : this.m_parent.getHours(day);
            }
        }
        return ranges;
    }

    private void sortExceptions() {
        if (!this.m_exceptionsSorted) {
            Collections.sort(this.m_exceptions);
            this.m_exceptionsSorted = true;
        }
    }

    private void populateExpandedExceptions() {
        if (!this.m_exceptions.isEmpty() && this.m_expandedExceptions.isEmpty()) {
            for (ProjectCalendarException exception : this.m_exceptions) {
                this.m_expandedExceptions.addAll(exception.getExpandedExceptions());
            }
            Collections.sort(this.m_expandedExceptions);
        }
    }

    private void sortWorkWeeks() {
        if (!this.m_weeksSorted) {
            Collections.sort(this.m_workWeeks);
            this.m_weeksSorted = true;
        }
    }

    public final ProjectFile getParentFile() {
        return this.m_projectFile;
    }

    public boolean isDerived() {
        return this.m_parent != null;
    }

    public CalendarType getType() {
        return this.m_type;
    }

    public void setType(CalendarType type) {
        if (type != null) {
            this.m_type = type;
        }
    }

    public boolean getPersonal() {
        return this.m_personal;
    }

    public void setPersonal(boolean personal) {
        this.m_personal = personal;
    }
}

