/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.asta;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.sql.DataSource;
import net.sf.mpxj.DayType;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.asta.AstaReader;
import net.sf.mpxj.asta.Row;
import net.sf.mpxj.common.AutoCloseableHelper;
import net.sf.mpxj.common.JdbcOdbcHelper;
import net.sf.mpxj.reader.AbstractProjectFileReader;

public final class AstaDatabaseReader
extends AbstractProjectFileReader {
    private AstaReader m_reader;
    private Integer m_projectID;
    private DataSource m_dataSource;
    private Connection m_connection;
    private boolean m_allocatedConnection;

    public Map<Integer, String> listProjects() throws MPXJException {
        try {
            HashMap<Integer, String> result = new HashMap<Integer, String>();
            List<Row> rows = this.getRows("select projid, short_name from project_summary");
            for (Row row : rows) {
                Integer id = row.getInteger("PROJID");
                String name = row.getString("SHORT_NAME");
                result.put(id, name);
            }
            return result;
        }
        catch (SQLException ex) {
            throw new MPXJException("Error reading file", ex);
        }
    }

    public ProjectFile read() throws MPXJException {
        try {
            this.m_reader = new AstaReader();
            ProjectFile project = this.m_reader.getProject();
            this.addListenersToProject(project);
            this.processProjectProperties();
            this.processCalendars();
            this.processResources();
            this.processTasks();
            this.processPredecessors();
            this.processAssignments();
            this.m_reader = null;
            ProjectFile projectFile = project;
            return projectFile;
        }
        catch (SQLException ex) {
            throw new MPXJException("Error reading file", ex);
        }
        finally {
            if (this.m_allocatedConnection) {
                AutoCloseableHelper.closeQuietly(this.m_connection);
            }
        }
    }

    private void processProjectProperties() throws SQLException {
        List<Row> projectSummaryRows = this.getRows("select * from project_summary where projid=?", this.m_projectID);
        List<Row> progressPeriodRows = this.getRows("select * from progress_period where projid=?", this.m_projectID);
        List<Row> userSettingsRows = this.getRows("select * from userr where projid=?", this.m_projectID);
        Row projectSummary = projectSummaryRows.isEmpty() ? null : projectSummaryRows.get(0);
        Row userSettings = userSettingsRows.isEmpty() ? null : userSettingsRows.get(0);
        List<Row> progressPeriods = progressPeriodRows.isEmpty() ? null : progressPeriodRows;
        this.m_reader.processProjectProperties(projectSummary, userSettings, progressPeriods);
    }

    private void processCalendars() throws SQLException {
        List<Row> rows = this.getRows("select * from exceptionn");
        Map<Integer, DayType> exceptionMap = this.m_reader.createExceptionTypeMap(rows);
        rows = this.getRows("select * from work_pattern");
        Map<Integer, Row> workPatternMap = this.m_reader.createWorkPatternMap(rows);
        rows = this.getRows("select * from work_pattern_assignment");
        Map<Integer, List<Row>> workPatternAssignmentMap = this.m_reader.createWorkPatternAssignmentMap(rows);
        rows = this.getRows("select * from exception_assignment order by exception_assignmentid, ordf");
        Map<Integer, List<Row>> exceptionAssignmentMap = this.m_reader.createExceptionAssignmentMap(rows);
        rows = this.getRows("select * from time_entry order by time_entryid, ordf");
        Map<Integer, List<Row>> timeEntryMap = this.m_reader.createTimeEntryMap(rows);
        rows = this.getRows("select * from calendar where projid=? order by calendarid", this.m_projectID);
        for (Row row : rows) {
            this.m_reader.processCalendar(row, workPatternMap, workPatternAssignmentMap, exceptionAssignmentMap, timeEntryMap, exceptionMap);
        }
        this.m_reader.getProject().getProjectConfig().updateUniqueCounters();
    }

    private void processResources() throws SQLException {
        List<Row> permanentRows = this.getRows("select * from permanent_resource where projid=? order by permanent_resourceid", this.m_projectID);
        List<Row> consumableRows = this.getRows("select * from consumable_resource where projid=? order by consumable_resourceid", this.m_projectID);
        this.m_reader.processResources(permanentRows, consumableRows);
    }

    private void processTasks() throws SQLException {
        List<Row> bars = this.getRows("select * from bar where projid=?", this.m_projectID);
        List<Row> expandedTasks = this.getRows("select * from expanded_task where projid=?", this.m_projectID);
        List<Row> tasks = this.getRows("select * from task where projid=?", this.m_projectID);
        List<Row> milestones = this.getRows("select * from milestone where projid=?", this.m_projectID);
        this.m_reader.processTasks(bars, expandedTasks, tasks, milestones);
    }

    private void processPredecessors() throws SQLException {
        List<Row> rows = this.getRows("select * from link where projid=? order by linkid", this.m_projectID);
        List<Row> completedSections = this.getRows("select * from task_completed_section where projid=?", this.m_projectID);
        this.m_reader.processPredecessors(rows, completedSections);
    }

    private void processAssignments() throws SQLException {
        List<Row> permanentAssignments = this.getRows("select * from permanent_schedul_allocation inner join perm_resource_skill on permanent_schedul_allocation.allocatiop_of = perm_resource_skill.perm_resource_skillid where permanent_schedul_allocation.projid=? order by permanent_schedul_allocation.permanent_schedul_allocationid", this.m_projectID);
        this.m_reader.processAssignments(permanentAssignments);
    }

    public void setProjectID(int projectID) {
        this.m_projectID = projectID;
    }

    public void setDataSource(DataSource dataSource) {
        this.m_dataSource = dataSource;
    }

    public void setConnection(Connection connection) {
        this.m_connection = connection;
    }

    @Override
    public ProjectFile read(File file) throws MPXJException {
        try {
            this.m_connection = this.getDatabaseConnection(file);
            this.m_projectID = 0;
            ProjectFile projectFile = this.read();
            return projectFile;
        }
        finally {
            AutoCloseableHelper.closeQuietly(this.m_connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ProjectFile> readAll(File file) throws MPXJException {
        try {
            this.m_connection = this.getDatabaseConnection(file);
            ArrayList<ProjectFile> result = new ArrayList<ProjectFile>();
            Set<Integer> ids = this.listProjects().keySet();
            Object object = ids.iterator();
            while (object.hasNext()) {
                Integer id;
                this.m_projectID = id = object.next();
                result.add(this.read());
            }
            object = result;
            return object;
        }
        finally {
            AutoCloseableHelper.closeQuietly(this.m_connection);
        }
    }

    private Connection getDatabaseConnection(File file) throws MPXJException {
        try {
            String url = JdbcOdbcHelper.getMicrosoftAccessJdbcUrl(file);
            Properties props = new Properties();
            props.put("charSet", "Cp1252");
            return DriverManager.getConnection(url, props);
        }
        catch (SQLException ex) {
            throw new MPXJException("Failed to create connection", ex);
        }
    }

    /*
     * Exception decompiling
     */
    private List<Row> getRows(String sql) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private List<Row> getRows(String sql, Integer var) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void allocateConnection() throws SQLException {
        if (this.m_connection == null) {
            this.m_connection = this.m_dataSource.getConnection();
            this.m_allocatedConnection = true;
        }
    }
}

