/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.explorer;

import com.jgoodies.binding.beans.PropertyAdapter;
import java.awt.Component;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;
import net.sf.mpxj.explorer.FileSaverModel;

public class FileSaverView {
    protected final JFileChooser m_fileChooser = new JFileChooser();
    private final Component m_parent;
    private final FileSaverModel m_model;

    public FileSaverView(Component parent, FileSaverModel model) {
        this.m_parent = parent;
        this.m_model = model;
        PropertyAdapter adapter = new PropertyAdapter((Object)this.m_model, "showDialog", true);
        adapter.addValueChangeListener(evt -> this.openFileChooser());
        PropertyAdapter extensionsAdaptor = new PropertyAdapter((Object)this.m_model, "extensions", true);
        extensionsAdaptor.addValueChangeListener(evt -> this.setFileFilter());
    }

    protected void openFileChooser() {
        if (this.m_model.getShowDialog()) {
            if (this.m_fileChooser.showSaveDialog(this.m_parent) == 0) {
                FileNameExtensionFilter filter = (FileNameExtensionFilter)this.m_fileChooser.getFileFilter();
                String description = filter.getDescription();
                this.m_model.setType(description.substring(0, description.indexOf(32)));
                this.m_model.setFile(null);
                this.m_model.setFile(this.m_fileChooser.getSelectedFile());
            }
            this.m_model.setShowDialog(false);
        }
    }

    protected void setFileFilter() {
        this.m_fileChooser.setAcceptAllFileFilterUsed(false);
        String[] extensions = this.m_model.getExtensions();
        for (int extensionIndex = 0; extensionIndex < extensions.length; extensionIndex += 2) {
            this.m_fileChooser.setFileFilter(new FileNameExtensionFilter(extensions[extensionIndex].toUpperCase() + " File", extensions[extensionIndex + 1]));
        }
    }
}

