/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.json;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayDeque;
import java.util.Date;
import java.util.Deque;
import java.util.List;
import java.util.stream.Collectors;

public class JsonStreamWriter {
    private final StringBuilder m_buffer = new StringBuilder();
    private final OutputStreamWriter m_writer;
    private final Deque<Boolean> m_firstNameValuePair = new ArrayDeque<Boolean>();
    private boolean m_pretty;
    private String m_indent = "";
    private final DateFormat m_timestampFormat = new SimpleDateFormat("\"yyyy-MM-dd'T'HH:mm:ss.S\"");
    private final DateFormat m_dateFormat = new SimpleDateFormat("\"yyyy-MM-dd\"");
    private final DateFormat m_timeFormat = new SimpleDateFormat("\"HH:mm\"");
    private static final String INDENT = "  ";

    public JsonStreamWriter(OutputStream stream, Charset encoding) {
        this.m_writer = new OutputStreamWriter(stream, encoding);
        this.m_firstNameValuePair.push(Boolean.TRUE);
    }

    public boolean getPretty() {
        return this.m_pretty;
    }

    public void setPretty(boolean pretty) {
        this.m_pretty = pretty;
    }

    public void flush() throws IOException {
        this.m_writer.flush();
    }

    public void writeStartObject(String name) throws IOException {
        this.writeComma();
        this.writeNewLineIndent();
        if (name != null) {
            this.writeName(name);
            this.writeNewLineIndent();
        }
        this.m_writer.write("{");
        this.increaseIndent();
    }

    public void writeList(String name, List<Object> values) throws IOException {
        this.writeComma();
        this.writeNewLineIndent();
        this.writeName(name);
        this.m_writer.write(" [");
        this.m_writer.write(values.stream().map(Object::toString).collect(Collectors.joining(",")));
        this.m_writer.write("]");
    }

    public void writeStartList(String name) throws IOException {
        this.writeComma();
        this.writeNewLineIndent();
        this.writeName(name);
        this.writeNewLineIndent();
        this.m_writer.write("[");
        this.increaseIndent();
    }

    public void writeEndObject() throws IOException {
        this.decreaseIndent();
        this.m_writer.write("}");
    }

    public void writeEndList() throws IOException {
        this.decreaseIndent();
        this.m_writer.write("]");
    }

    public void writeNameValuePair(String name, String value) throws IOException {
        this.internalWriteNameValuePair(name, this.escapeString(value));
    }

    public void writeNameValuePair(String name, int value) throws IOException {
        this.internalWriteNameValuePair(name, Integer.toString(value));
    }

    public void writeNameValuePair(String name, long value) throws IOException {
        this.internalWriteNameValuePair(name, Long.toString(value));
    }

    public void writeNameValuePair(String name, double value) throws IOException {
        this.internalWriteNameValuePair(name, Double.toString(value));
    }

    public void writeNameValuePair(String name, boolean value) throws IOException {
        this.internalWriteNameValuePair(name, value ? "true" : "false");
    }

    public void writeNameValuePair(String name, Date value) throws IOException {
        this.internalWriteNameValuePair(name, this.m_timestampFormat.format(value));
    }

    public void writeNameValuePairAsDate(String name, Date value) throws IOException {
        this.internalWriteNameValuePair(name, this.m_dateFormat.format(value));
    }

    public void writeNameValuePairAsTime(String name, Date value) throws IOException {
        this.internalWriteNameValuePair(name, this.m_timeFormat.format(value));
    }

    private void internalWriteNameValuePair(String name, String value) throws IOException {
        this.writeComma();
        this.writeNewLineIndent();
        this.writeName(name);
        if (this.m_pretty) {
            this.m_writer.write(32);
        }
        this.m_writer.write(value);
    }

    private String escapeString(String value) {
        this.m_buffer.setLength(0);
        this.m_buffer.append('\"');
        block9: for (int index = 0; index < value.length(); ++index) {
            char c = value.charAt(index);
            switch (c) {
                case '\"': {
                    this.m_buffer.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    this.m_buffer.append("\\\\");
                    continue block9;
                }
                case '\b': {
                    this.m_buffer.append("\\b");
                    continue block9;
                }
                case '\f': {
                    this.m_buffer.append("\\f");
                    continue block9;
                }
                case '\n': {
                    this.m_buffer.append("\\n");
                    continue block9;
                }
                case '\r': {
                    this.m_buffer.append("\\r");
                    continue block9;
                }
                case '\t': {
                    this.m_buffer.append("\\t");
                    continue block9;
                }
                default: {
                    if (c <= '\u001f') continue block9;
                    this.m_buffer.append(c);
                }
            }
        }
        this.m_buffer.append('\"');
        return this.m_buffer.toString();
    }

    private void writeComma() throws IOException {
        if (this.m_firstNameValuePair.peek().booleanValue()) {
            this.m_firstNameValuePair.pop();
            this.m_firstNameValuePair.push(Boolean.FALSE);
        } else {
            this.m_writer.write(44);
        }
    }

    private void writeNewLineIndent() throws IOException {
        if (this.m_pretty && !this.m_indent.isEmpty()) {
            this.m_writer.write(10);
            this.m_writer.write(this.m_indent);
        }
    }

    private void writeName(String name) throws IOException {
        this.m_writer.write(this.escapeString(name));
        this.m_writer.write(":");
    }

    private void increaseIndent() {
        this.m_firstNameValuePair.push(Boolean.TRUE);
        if (this.m_pretty) {
            this.m_indent = this.m_indent + INDENT;
        }
    }

    private void decreaseIndent() throws IOException {
        if (this.m_pretty) {
            this.m_writer.write(10);
            this.m_indent = this.m_indent.substring(0, this.m_indent.length() - INDENT.length());
            this.m_writer.write(this.m_indent);
        }
        this.m_firstNameValuePair.pop();
    }
}

