/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.sdef;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import net.sf.mpxj.Duration;
import net.sf.mpxj.EventManager;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectCalendarException;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.Relation;
import net.sf.mpxj.Task;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.common.BooleanHelper;
import net.sf.mpxj.common.DateHelper;
import net.sf.mpxj.common.NumberHelper;
import net.sf.mpxj.common.ProjectCalendarHelper;
import net.sf.mpxj.sdef.SDEFmethods;
import net.sf.mpxj.writer.AbstractProjectWriter;

public final class SDEFWriter
extends AbstractProjectWriter {
    private ProjectFile m_projectFile;
    private EventManager m_eventManager;
    private OutputStreamWriter m_writer;
    private StringBuilder m_buffer;
    private Charset m_charset = StandardCharsets.US_ASCII;
    private final Format m_formatter = new SimpleDateFormat("ddMMMyy");
    private static final int MAX_EXCEPTIONS_PER_RECORD = 15;

    public void setCharset(Charset charset) {
        if (charset != null) {
            this.m_charset = charset;
        }
    }

    public Charset getCharset() {
        return this.m_charset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(ProjectFile projectFile, OutputStream out) throws IOException {
        this.m_projectFile = projectFile;
        this.m_eventManager = projectFile.getEventManager();
        this.m_writer = new OutputStreamWriter(out, this.m_charset);
        this.m_buffer = new StringBuilder();
        try {
            List<ProjectCalendar> calendars = this.m_projectFile.getTasks().stream().map(Task::getEffectiveCalendar).distinct().map(ProjectCalendarHelper::createTemporaryFlattenedCalendar).collect(Collectors.toList());
            this.writeFileCreationRecord();
            this.writeProjectProperties(this.m_projectFile.getProjectProperties());
            this.writeCalendars(calendars);
            this.writeExceptions(calendars);
            this.writeTasks(this.m_projectFile.getTasks());
            this.writePredecessors(this.m_projectFile.getTasks());
            this.writeProgress(this.m_projectFile.getTasks());
            this.m_writer.write("END\n");
            this.m_writer.flush();
        }
        finally {
            this.m_writer = null;
            this.m_projectFile = null;
            this.m_buffer = null;
        }
    }

    private void writeFileCreationRecord() throws IOException {
        this.m_writer.write("VOLM  1\n");
    }

    private void writeProjectProperties(ProjectProperties record) throws IOException {
        Date dataDate = record.getStatusDate() == null ? this.m_projectFile.getProjectProperties().getCurrentDate() : record.getStatusDate();
        Date startDate = record.getStartDate();
        Date finishDate = record.getFinishDate();
        this.m_buffer.setLength(0);
        this.m_buffer.append("PROJ ");
        this.m_buffer.append(this.formatDate(dataDate)).append(" ");
        this.m_buffer.append(SDEFmethods.lset(record.getManager(), 4)).append(" ");
        this.m_buffer.append(SDEFmethods.lset(record.getProjectTitle(), 48)).append(" ");
        this.m_buffer.append(SDEFmethods.lset(record.getSubject(), 36)).append(" ");
        this.m_buffer.append("P ");
        this.m_buffer.append(SDEFmethods.lset(record.getKeywords(), 7));
        this.m_buffer.append(this.formatDate(startDate)).append(" ");
        this.m_buffer.append(this.formatDate(finishDate));
        this.m_buffer.append("\n");
        this.m_writer.write(this.m_buffer.toString());
    }

    private void writeCalendars(List<ProjectCalendar> records) throws IOException {
        for (ProjectCalendar record : records) {
            this.m_buffer.setLength(0);
            this.m_buffer.append("CLDR ");
            this.m_buffer.append(SDEFmethods.lset(record.getUniqueID().toString(), 2));
            String workDays = SDEFmethods.workDays(record);
            this.m_buffer.append(SDEFmethods.lset(workDays, 8));
            this.m_buffer.append(SDEFmethods.lset(record.getName(), 30));
            this.m_buffer.append("\n");
            this.m_writer.write(this.m_buffer.toString());
        }
    }

    private void writeExceptions(List<ProjectCalendar> records) throws IOException {
        for (ProjectCalendar record : records) {
            List<ProjectCalendarException> expandedExceptions = ProjectCalendarHelper.getExpandedExceptionsWithWorkWeeks(record);
            if (!expandedExceptions.isEmpty()) {
                ArrayList<String> formattedExceptions = new ArrayList<String>();
                String recordPrefix = "HOLI " + SDEFmethods.lset(record.getUniqueID().toString(), 2);
                for (ProjectCalendarException ex : expandedExceptions) {
                    this.generateCalendarExceptions(ex, formattedExceptions);
                }
                int startIndex = 0;
                while (startIndex < formattedExceptions.size()) {
                    int endIndex = Math.min(startIndex + 15, formattedExceptions.size());
                    this.m_writer.write(recordPrefix);
                    this.m_writer.write(String.join((CharSequence)" ", formattedExceptions.subList(startIndex, endIndex)));
                    this.m_writer.write("\n");
                    startIndex = endIndex;
                }
            }
            this.m_eventManager.fireCalendarWrittenEvent(record);
        }
    }

    private void generateCalendarExceptions(ProjectCalendarException record, List<String> formattedExceptions) {
        Calendar stepDay = DateHelper.popCalendar(record.getFromDate());
        Calendar lastDay = DateHelper.popCalendar(record.getToDate());
        while (stepDay.compareTo(lastDay) <= 0) {
            formattedExceptions.add(this.formatDate(stepDay.getTime()));
            stepDay.add(5, 1);
        }
        DateHelper.pushCalendar(stepDay);
        DateHelper.pushCalendar(lastDay);
    }

    private void writeTask(Task record) throws IOException {
        this.m_buffer.setLength(0);
        if (!record.getSummary()) {
            String formattedConstraintDate;
            String conType;
            this.m_buffer.append("ACTV ");
            this.m_buffer.append(this.getActivityID(record)).append(" ");
            this.m_buffer.append(SDEFmethods.lset(record.getName(), 30)).append(" ");
            Duration dd = record.getDuration();
            if (dd == null) {
                dd = Duration.getInstance(0, TimeUnit.DAYS);
            }
            if (dd.getUnits() != TimeUnit.DAYS) {
                dd = dd.convertUnits(TimeUnit.DAYS, this.m_projectFile.getProjectProperties());
            }
            Double days = dd.getDuration() + 0.5;
            Integer est = days.intValue();
            this.m_buffer.append(SDEFmethods.rset(est.toString(), 3)).append(" ");
            Date conDate = record.getConstraintDate();
            if (conDate == null) {
                conType = "   ";
                formattedConstraintDate = "       ";
            } else {
                formattedConstraintDate = this.m_formatter.format(conDate).toUpperCase();
                switch (record.getConstraintType()) {
                    case AS_LATE_AS_POSSIBLE: 
                    case MUST_FINISH_ON: 
                    case FINISH_NO_EARLIER_THAN: 
                    case FINISH_NO_LATER_THAN: {
                        conType = "LF ";
                        break;
                    }
                    default: {
                        conType = "ES ";
                    }
                }
            }
            this.m_buffer.append(formattedConstraintDate).append(" ");
            this.m_buffer.append(conType);
            this.m_buffer.append(SDEFmethods.lset(record.getEffectiveCalendar().getUniqueID().toString(), 1)).append(" ");
            this.m_buffer.append(BooleanHelper.getBoolean(record.getHammockCode()) ? "Y " : "  ");
            this.m_buffer.append(SDEFmethods.rset(this.formatNumber(record.getWorkersPerDay()), 3)).append(" ");
            this.m_buffer.append(SDEFmethods.lset(record.getResponsibilityCode(), 4)).append(" ");
            this.m_buffer.append(SDEFmethods.lset(record.getWorkAreaCode(), 4)).append(" ");
            this.m_buffer.append(SDEFmethods.lset(record.getModOrClaimNumber(), 6)).append(" ");
            this.m_buffer.append(SDEFmethods.lset(record.getBidItem(), 6)).append(" ");
            this.m_buffer.append(SDEFmethods.lset(record.getPhaseOfWork(), 2)).append(" ");
            this.m_buffer.append(SDEFmethods.lset(record.getCategoryOfWork(), 1)).append(" ");
            this.m_buffer.append(SDEFmethods.lset(record.getFeatureOfWork(), 30));
            this.m_buffer.append("\n");
            this.m_writer.write(this.m_buffer.toString());
            this.m_eventManager.fireTaskWrittenEvent(record);
        }
    }

    private void writeTasks(List<Task> tasks) throws IOException {
        for (Task task : tasks) {
            this.writeTask(task);
        }
    }

    private void writePredecessors(List<Task> tasks) throws IOException {
        for (Task task : tasks) {
            this.writeTaskPredecessors(task);
        }
    }

    private void writeTaskPredecessors(Task record) throws IOException {
        this.m_buffer.setLength(0);
        if (!record.getSummary() && !record.getPredecessors().isEmpty()) {
            List<Relation> predecessors = record.getPredecessors();
            for (Relation pred : predecessors) {
                this.m_buffer.setLength(0);
                this.m_buffer.append("PRED ");
                this.m_buffer.append(this.getActivityID(pred.getSourceTask())).append(" ");
                this.m_buffer.append(this.getActivityID(pred.getTargetTask())).append(" ");
                String type = "C";
                if (!pred.getType().toString().equals("FS")) {
                    type = pred.getType().toString().substring(0, 1);
                }
                this.m_buffer.append(type).append(" ");
                Duration dd = pred.getLag();
                double duration = dd.getDuration();
                duration = duration < 0.0 ? (duration -= 0.5) : (duration += 0.5);
                if (dd.getUnits() != TimeUnit.DAYS) {
                    dd = Duration.convertUnits(duration, dd.getUnits(), TimeUnit.DAYS, this.m_projectFile.getProjectProperties());
                }
                Double days = dd.getDuration();
                Integer est = days.intValue();
                this.m_buffer.append(SDEFmethods.rset(est.toString(), 4));
                this.m_buffer.append("\n");
                this.m_writer.write(this.m_buffer.toString());
            }
        }
    }

    private void writePROG(Task record) throws IOException {
        this.m_buffer.setLength(0);
        if (!record.getSummary()) {
            String floatValue;
            int floatSign;
            Duration dd;
            this.m_buffer.append("PROG ");
            this.m_buffer.append(this.getActivityID(record)).append(" ");
            Date temp = record.getActualStart();
            if (temp == null) {
                this.m_buffer.append("        ");
            } else {
                this.m_buffer.append(this.m_formatter.format(record.getActualStart()).toUpperCase()).append(" ");
            }
            temp = record.getActualFinish();
            if (temp == null) {
                this.m_buffer.append("        ");
            } else {
                this.m_buffer.append(this.m_formatter.format(record.getActualFinish()).toUpperCase()).append(" ");
            }
            Duration duration = dd = record.getRemainingDuration() == null ? Duration.getInstance(0, TimeUnit.DAYS) : record.getRemainingDuration();
            if (dd.getUnits() != TimeUnit.DAYS) {
                dd = dd.convertUnits(TimeUnit.DAYS, this.m_projectFile.getProjectProperties());
            }
            Double days = dd.getDuration() + 0.5;
            Integer est = days.intValue();
            this.m_buffer.append(SDEFmethods.rset(est.toString(), 3)).append(" ");
            DecimalFormat twoDec = new DecimalFormat("#0.00");
            this.m_buffer.append(SDEFmethods.rset(twoDec.format(NumberHelper.getDouble(record.getCost())), 12)).append(" ");
            this.m_buffer.append(SDEFmethods.rset(twoDec.format(NumberHelper.getDouble(record.getActualCost())), 12)).append(" ");
            this.m_buffer.append(SDEFmethods.rset(twoDec.format(NumberHelper.getDouble(record.getStoredMaterial())), 12)).append(" ");
            this.m_buffer.append(this.formatDate(record.getEarlyStart())).append(" ");
            this.m_buffer.append(this.formatDate(record.getEarlyFinish())).append(" ");
            this.m_buffer.append(this.formatDate(record.getLateStart())).append(" ");
            this.m_buffer.append(this.formatDate(record.getLateFinish())).append(" ");
            if (record.getActualFinish() == null) {
                dd = record.getTotalSlack();
                if (dd.getUnits() != TimeUnit.DAYS) {
                    dd = dd.convertUnits(TimeUnit.DAYS, this.m_projectFile.getProjectProperties());
                }
                floatSign = (est = Integer.valueOf((days = Double.valueOf(dd.getDuration() + 0.5)).intValue())) >= 0 ? 43 : 45;
                est = Math.abs(days.intValue());
                floatValue = est.toString();
            } else {
                floatSign = 32;
                floatValue = "";
            }
            this.m_buffer.append((char)floatSign).append(" ");
            this.m_buffer.append(SDEFmethods.rset(floatValue, 3));
            this.m_buffer.append("\n");
            this.m_writer.write(this.m_buffer.toString());
            this.m_eventManager.fireTaskWrittenEvent(record);
        }
    }

    private void writeProgress(List<Task> tasks) throws IOException {
        for (Task task : tasks) {
            this.writePROG(task);
        }
    }

    private String formatDate(Date date) {
        String result = date == null ? "       " : this.m_formatter.format(date).toUpperCase();
        return result;
    }

    private String formatNumber(Number value) {
        String result = value == null ? "" : value.toString();
        return result;
    }

    private String getActivityID(Task task) {
        String activityID = task.getActivityID();
        activityID = activityID == null ? SDEFmethods.rset(String.valueOf(NumberHelper.getInt(task.getUniqueID())), 10) : SDEFmethods.lset(activityID, 10);
        return activityID;
    }
}

