/*
 * Decompiled with CFR 0.152.
 */
package dev.botcity.botcity_document_processing.parser;

import dev.botcity.botcity_document_processing.parser.DataTypeMatcher;
import dev.botcity.botcity_document_processing.parser.Entry;
import java.awt.Point;
import java.awt.Polygon;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class DocumentParser {
    private List<Entry> entries = new ArrayList<Entry>();
    private static String LICENSE_MESSAGE = "\n######\n# This is a proprietary library. It was not possible to verify your BotCity license or it was not possible to reach http://%s\n######";

    public static void main(String[] args) {
        System.out.println("hello");
    }

    public void clear() {
        this.entries.clear();
    }

    public void loadEntries(Object entries) {
        List listEntries = (List)entries;
        for (Object[] entry : listEntries) {
            Entry e = new Entry();
            e.setText((String)entry[0]);
            e.p1 = new Point((Integer)entry[1], (Integer)entry[2]);
            e.p2 = new Point((Integer)entry[3], (Integer)entry[4]);
            e.p3 = new Point((Integer)entry[5], (Integer)entry[6]);
            e.p4 = new Point((Integer)entry[7], (Integer)entry[8]);
            if (entry.length == 10) {
                e.setPage((int)((Integer)entry[9]));
            }
            this.addEntry(e);
        }
    }

    public void addEntry(Entry e) {
        e.setIndex(this.entries.size());
        this.entries.add(e);
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    public Entry getFirstEntry() {
        if (this.entries.size() > 0) {
            return this.entries.get(0);
        }
        return null;
    }

    public Entry getLastEntry() {
        if (this.entries.size() > 0) {
            return this.entries.get(this.entries.size() - 1);
        }
        return null;
    }

    public void setEntries(List<Entry> entries) {
        this.entries = entries;
    }

    public Entry getFirstEntryContains(String text) {
        return this.getFirstEntryContains(1, text);
    }

    public Entry getFirstEntryContains(int startPosition, String text) {
        for (int i = startPosition; i < this.entries.size(); ++i) {
            Entry entry = this.entries.get(i);
            if (!entry.getText().toLowerCase().contains(text.toLowerCase())) continue;
            return entry;
        }
        return null;
    }

    public Entry getFirstEntryContains(String text, Entry entry) {
        if (entry == null) {
            return null;
        }
        return this.getFirstEntryContains(Math.min(entry.getIndex() + 1, this.entries.size() - 1), text);
    }

    public String getFullText() {
        StringBuilder text = new StringBuilder();
        for (int i = 0; i < this.entries.size(); ++i) {
            text.append(this.entries.get(i).getText() + " ");
        }
        return text.toString();
    }

    public Entry getFirstEntry(String text) {
        return this.getFirstEntry(text, 0);
    }

    public Entry getFirstEntry(String text, Entry entry) {
        if (entry == null) {
            return null;
        }
        return this.getFirstEntry(text, Math.min(entry.getIndex() + 1, this.entries.size() - 1));
    }

    public Entry getFirstEntry(String text, int startPosition) {
        String[] texts = text.split(" ");
        Entry first = null;
        int firstIndex = 0;
        int current = 0;
        for (int i = startPosition; i < this.entries.size(); ++i) {
            Entry entry = this.entries.get(i);
            if (entry.getText().toLowerCase().equals(texts[current].toLowerCase())) {
                if (current == 0) {
                    first = entry;
                    firstIndex = i;
                }
                if (++current != texts.length) continue;
                return this.combinedEntries(firstIndex, firstIndex + (texts.length - 1));
            }
            i -= current;
            current = 0;
            first = null;
        }
        return null;
    }

    public Entry getFirstEntryContainsSubstring(int startPosition, String text) {
        String[] texts = text.split(" ");
        Entry first = null;
        int firstIndex = 0;
        int current = 0;
        for (int i = startPosition; i < this.entries.size(); ++i) {
            boolean condition;
            Entry entry = this.entries.get(i);
            boolean bl = condition = current == 0 ? entry.getText().toLowerCase().contains(texts[current].toLowerCase()) : entry.getText().toLowerCase().equals(texts[current].toLowerCase());
            if (condition) {
                if (current == 0) {
                    first = entry;
                    firstIndex = i;
                }
                if (++current != texts.length) continue;
                return this.combinedEntries(firstIndex, firstIndex + (texts.length - 1));
            }
            i -= current;
            current = 0;
            first = null;
        }
        return null;
    }

    public Entry getFirstEntryContainsSubstring(String text) {
        return this.getFirstEntryContainsSubstring(1, text);
    }

    public Entry getFirstEntryContainsSubstring(String ... textPossibilities) {
        return this.getFirstEntryContainsSubstring(1, textPossibilities);
    }

    public Entry getFirstEntryContainsSubstring(int startIndex, String ... textPossibilities) {
        int firstIndex = -1;
        Entry firstEntry = null;
        for (String text : textPossibilities) {
            Entry entry = this.getFirstEntryContainsSubstring(startIndex, text);
            if (entry == null || firstIndex != -1 && entry.getIndex() >= firstIndex) continue;
            firstIndex = entry.getIndex();
            firstEntry = entry;
        }
        return firstEntry;
    }

    public Entry getFirstSeparatedEntry(String text) {
        String[] texts = text.split(" ");
        Object first = null;
        boolean firstIndex = false;
        int current = 0;
        Entry[] matchedEntries = new Entry[texts.length];
        for (int i = 0; i < this.entries.size(); ++i) {
            Entry entry = this.entries.get(i);
            String entryText = entry.getText().toLowerCase();
            if (current > 0 && entryText.equals(texts[0].toLowerCase())) {
                current = 0;
                continue;
            }
            if (!entryText.equals(texts[current].toLowerCase())) continue;
            matchedEntries[current] = entry;
            if (++current != texts.length) continue;
            return this.combinedEntries(matchedEntries);
        }
        return null;
    }

    public Entry getSeparatedEntryAtIndex(int matchingIndex, String ... textPossibilities) {
        for (String text : textPossibilities) {
            Entry entry = this.getSeparatedEntryAtIndex(text, matchingIndex);
            if (entry == null) continue;
            return entry;
        }
        return null;
    }

    public Entry getSeparatedEntryAtIndex(String text, int matchingIndex) {
        String[] texts = text.split(" ");
        int currMatchingIndex = 0;
        int current = 0;
        Entry[] matchedEntries = new Entry[texts.length];
        for (int i = 0; i < this.entries.size(); ++i) {
            Entry entry = this.entries.get(i);
            if (!entry.getText().toLowerCase().equals(texts[current].toLowerCase())) continue;
            matchedEntries[current] = entry;
            if (++current != texts.length) continue;
            if (++currMatchingIndex < matchingIndex) {
                matchedEntries = new Entry[texts.length];
                current = 0;
                currMatchingIndex = 0;
                continue;
            }
            return this.combinedEntries(matchedEntries);
        }
        return null;
    }

    public Entry getFirstEntry(String ... textPossibilities) {
        return this.getFirstEntry(0, textPossibilities);
    }

    public Entry getFirstEntry(Entry startEntry, String ... textPossibilities) {
        if (startEntry == null) {
            return null;
        }
        return this.getFirstEntry(Math.min(startEntry.getIndex() + 1, this.entries.size() - 1), textPossibilities);
    }

    public Entry getFirstEntry(int startIndex, String ... textPossibilities) {
        int firstIndex = -1;
        Entry firstEntry = null;
        for (String text : textPossibilities) {
            Entry entry = this.getFirstEntry(text, startIndex);
            if (entry == null || firstIndex != -1 && entry.getIndex() >= firstIndex) continue;
            firstIndex = entry.getIndex();
            firstEntry = entry;
        }
        return firstEntry;
    }

    public Entry getFirstSuitableEntry(String ... textPossibilities) {
        for (String text : textPossibilities) {
            Entry entry = this.getFirstEntry(text);
            if (entry == null) continue;
            return entry;
        }
        return null;
    }

    public Entry getSecondEntry(String text) {
        String[] texts = text.split(" ");
        Entry first = null;
        int firstIndex = 0;
        int current = 0;
        int count = 0;
        for (int i = 0; i < this.entries.size(); ++i) {
            Entry entry = this.entries.get(i);
            if (entry.getText().toLowerCase().equals(texts[current].toLowerCase())) {
                if (++count == 2) {
                    first = entry;
                    firstIndex = i;
                }
                if (count > 1) {
                    ++current;
                }
                if (current != texts.length) continue;
                return this.combinedEntries(firstIndex, firstIndex + (texts.length - 1));
            }
            i -= current;
            current = 0;
            first = null;
        }
        return null;
    }

    public Entry getSecondEntry(String ... textPossibilities) {
        for (String text : textPossibilities) {
            Entry entry = this.getSecondEntry(text);
            if (entry == null) continue;
            return entry;
        }
        return null;
    }

    public Entry getFirstSeparatedEntry(String ... textPossibilities) {
        for (String text : textPossibilities) {
            Entry entry = this.getFirstSeparatedEntry(text);
            if (entry == null) continue;
            return entry;
        }
        return null;
    }

    public Entry combinedEntries(int start, int end) {
        String text = "";
        int x1 = -1;
        int x2 = -1;
        int y1 = -1;
        int y2 = 1;
        for (int i = start; i <= end; ++i) {
            Entry e = this.entries.get(i);
            text = text + e.getText();
            if (x1 == -1 || e.p1.x < x1) {
                x1 = e.p1.x;
            }
            if (x2 == -1 || e.p2.x > x2) {
                x2 = e.p2.x;
            }
            if (y1 == -1 || e.p1.y < y1) {
                y1 = e.p1.y;
            }
            if (y2 != -1 && e.p4.y <= y2) continue;
            y2 = e.p4.y;
        }
        Entry entry = new Entry();
        entry.setIndex(end);
        entry.setText(text);
        entry.p1 = new Point(x1, y1);
        entry.p2 = new Point(x2, y1);
        entry.p3 = new Point(x2, y2);
        entry.p4 = new Point(x1, y2);
        return entry;
    }

    public Entry combinedEntries(Entry[] entries) {
        String text = "";
        int x1 = -1;
        int x2 = -1;
        int y1 = -1;
        int y2 = 1;
        for (Entry e : entries) {
            text = text + e.getText();
            if (x1 == -1 || e.p1.x < x1) {
                x1 = e.p1.x;
            }
            if (x2 == -1 || e.p2.x > x2) {
                x2 = e.p2.x;
            }
            if (y1 == -1 || e.p1.y < y1) {
                y1 = e.p1.y;
            }
            if (y2 != -1 && e.p4.y <= y2) continue;
            y2 = e.p4.y;
        }
        Entry entry = new Entry();
        entry.setIndex(entries[0].getIndex());
        entry.setText(text);
        entry.p1 = new Point(x1, y1);
        entry.p2 = new Point(x2, y1);
        entry.p3 = new Point(x2, y2);
        entry.p4 = new Point(x1, y2);
        return entry;
    }

    public String readBelow(Entry entry, double marginLeft, double marginRight, double marginBottom, int lineHeight) {
        return this.readBelow(entry, marginLeft, marginRight, marginBottom, lineHeight, null);
    }

    public String readBelow(Entry entry, double marginLeft, double marginRight, double marginBottom, int lineHeight, DataType dataType) {
        return this.readArea(new Point(entry.p4.x - (int)((double)entry.getWidth() * marginLeft), entry.p4.y), new Point(entry.p3.x + (int)((double)entry.getWidth() * marginRight), entry.p3.y), new Point(entry.p3.x + (int)((double)entry.getWidth() * marginRight), entry.p3.y + (int)((double)entry.getHeight() * marginBottom)), new Point(entry.p4.x - (int)((double)entry.getWidth() * marginLeft), entry.p4.y + (int)((double)entry.getHeight() * marginBottom)), lineHeight, dataType);
    }

    public String readBelow(Entry entry, double marginLeft, double marginRight, double marginBottom) {
        return this.readArea(new Point(entry.p4.x - (int)((double)entry.getWidth() * marginLeft), entry.p4.y), new Point(entry.p3.x + (int)((double)entry.getWidth() * marginRight), entry.p3.y), new Point(entry.p3.x + (int)((double)entry.getWidth() * marginRight), entry.p3.y + (int)((double)entry.getHeight() * marginBottom)), new Point(entry.p4.x - (int)((double)entry.getWidth() * marginLeft), entry.p4.y + (int)((double)entry.getHeight() * marginBottom)));
    }

    public String readBelow(Entry entry, double marginLeft, double marginRight, double marginBottom, DataType datatype) {
        return this.readArea(new Point(entry.p4.x - (int)((double)entry.getWidth() * marginLeft), entry.p4.y), new Point(entry.p3.x + (int)((double)entry.getWidth() * marginRight), entry.p3.y), new Point(entry.p3.x + (int)((double)entry.getWidth() * marginRight), entry.p3.y + (int)((double)entry.getHeight() * marginBottom)), new Point(entry.p4.x - (int)((double)entry.getWidth() * marginLeft), entry.p4.y + (int)((double)entry.getHeight() * marginBottom)), datatype);
    }

    public String readBelow(Entry entry, double marginLeft, double marginRight, Entry bottomReference, int lineHeight, DataType dataType) {
        return this.readArea(new Point(entry.p4.x - (int)((double)entry.getWidth() * marginLeft), entry.p4.y), new Point(entry.p3.x + (int)((double)entry.getWidth() * marginRight), entry.p3.y), new Point(entry.p3.x + (int)((double)entry.getWidth() * marginRight), bottomReference.p1.y), new Point(entry.p4.x - (int)((double)entry.getWidth() * marginLeft), bottomReference.p1.y), lineHeight, dataType);
    }

    public String readBelow(Entry entry, double marginLeft, Entry rightReference, Entry bottomReference, int lineHeight, DataType dataType) {
        return this.readArea(new Point(entry.p4.x - (int)((double)entry.getWidth() * marginLeft), entry.p4.y), new Point(rightReference.p1.x, entry.p3.y), new Point(rightReference.p1.x, bottomReference.p1.y), new Point(entry.p4.x - (int)((double)entry.getWidth() * marginLeft), bottomReference.p1.y), lineHeight, dataType);
    }

    public String readBelowWithOffset(Entry entry, double marginLeft, double marginRight, double marginBottom, double offset) {
        return this.readArea(new Point(entry.p4.x - (int)((double)entry.getWidth() * marginLeft), entry.p4.y + (int)((double)entry.getHeight() * offset)), new Point(entry.p3.x + (int)((double)entry.getWidth() * marginRight), entry.p3.y + (int)((double)entry.getHeight() * offset)), new Point(entry.p3.x + (int)((double)entry.getWidth() * marginRight), entry.p3.y + (int)((double)entry.getHeight() * marginBottom)), new Point(entry.p4.x - (int)((double)entry.getWidth() * marginLeft), entry.p4.y + (int)((double)entry.getHeight() * marginBottom)));
    }

    public String readNext(Entry entry, double marginRight, double marginTop, double marginBottom) {
        return this.readNext(entry, marginRight, marginTop, marginBottom, null);
    }

    public String readNext(Entry entry, double marginRight, double marginTop, double marginBottom, DataType dataType) {
        return this.readNext(entry, marginRight, marginTop, marginBottom, dataType, false);
    }

    public String readNext(Entry entry, double marginRight, double marginTop, double marginBottom, DataType dataType, boolean handwritten) {
        return this.readArea(new Point(entry.p2.x, entry.p2.y - (int)((double)entry.getHeight() * marginTop)), new Point(entry.p2.x + (int)((double)entry.getWidth() * marginRight), entry.p2.y - (int)((double)entry.getHeight() * marginTop)), new Point(entry.p3.x + (int)((double)entry.getWidth() * marginRight), entry.p3.y + (int)((double)entry.getHeight() * marginBottom)), new Point(entry.p3.x, entry.p3.y + (int)((double)entry.getHeight() * marginBottom)), dataType, handwritten);
    }

    public String readAbove(Entry entry, double marginLeft, double marginRight, double marginTop) {
        return this.readBelow(entry, marginLeft, marginRight, -marginTop);
    }

    public String readAround(Entry entry, double marginLeft, double marginRight, double marginTop, double marginBottom) {
        Point topLeft = new Point(entry.p1.x - (int)(marginLeft * (double)entry.getWidth()), entry.p1.y - (int)(marginTop * (double)entry.getHeight()));
        Point topRight = new Point(entry.p2.x + (int)(marginRight * (double)entry.getWidth()), entry.p2.y - (int)(marginTop * (double)entry.getHeight()));
        Point bottomRight = new Point(topRight.x, entry.p4.y + (int)(marginBottom * (double)entry.getHeight()));
        Point bottomLeft = new Point(topLeft.x, entry.p3.y + (int)(marginBottom * (double)entry.getHeight()));
        return this.readArea(topLeft, topRight, bottomRight, bottomLeft);
    }

    public String readNextWithSlope(Entry entry, double marginLeft, double marginRight, double marginTop, double marginBottom, double rateOfChangeY) {
        int width = entry.getWidth();
        int height = entry.getHeight();
        int offL = (int)((double)width * marginLeft);
        int offR = (int)((double)width * marginRight);
        int offT = (int)((double)height * marginTop);
        int offB = (int)((double)height * marginBottom);
        return this.readArea(new Point(entry.p2.x + offL, (int)((double)entry.p2.y + rateOfChangeY * (double)width - (double)offT + rateOfChangeY * (double)offL)), new Point(entry.p2.x + offR, (int)((double)entry.p2.y + rateOfChangeY * (double)width - (double)offT + rateOfChangeY * (double)offR)), new Point(entry.p3.x + offR, (int)((double)entry.p3.y + rateOfChangeY * (double)width + (double)offB + rateOfChangeY * (double)offR)), new Point(entry.p3.x + offL, (int)((double)entry.p3.y + rateOfChangeY * (double)width + (double)offB + rateOfChangeY * (double)offL)));
    }

    public String readArea(Point p1, Point p2, Point p3, Point p4) {
        return this.readArea(p1, p2, p3, p4, false, null, false);
    }

    public String readArea(Point p1, Point p2, Point p3, Point p4, DataType dataType, boolean handwriten) {
        return this.readArea(p1, p2, p3, p4, false, dataType, handwriten);
    }

    public String readArea(Point p1, Point p2, Point p3, Point p4, boolean debug, DataType dataType, boolean handwriten) {
        String ret = "";
        if (debug) {
            System.out.println("######### trying to read (" + p1.x + "," + p1.y + "), (" + p2.x + "," + p2.y + "),(" + p3.x + "," + p3.y + "),(" + p4.x + "," + p4.y + ")");
        }
        Polygon polygon = new Polygon();
        polygon.addPoint(p1.x, p1.y);
        polygon.addPoint(p2.x, p2.y);
        polygon.addPoint(p3.x, p3.y);
        polygon.addPoint(p4.x, p4.y);
        Entry lastEntry = null;
        for (Entry entry : this.entries) {
            String separation = handwriten ? "" : " ";
            if (handwriten && lastEntry != null && (double)(entry.p1.x - lastEntry.p2.x) > (double)entry.getHeight() * 0.8) {
                separation = " ";
            }
            if (!polygon.contains(entry.p1) || !polygon.contains(entry.p2) || !polygon.contains(entry.p3) || !polygon.contains(entry.p4)) continue;
            ret = ret + separation + entry.getText();
            lastEntry = entry;
        }
        if (dataType != null) {
            return DataTypeMatcher.match(ret.trim(), dataType);
        }
        return ret.trim();
    }

    public String readArea(Point p1, Point p2, Point p3, Point p4, int lineHeight, DataType dataType) {
        return this.readArea(p1, p2, p3, p4, lineHeight, false, dataType);
    }

    public String readArea(Point p1, Point p2, Point p3, Point p4, int lineHeight) {
        return this.readArea(p1, p2, p3, p4, lineHeight, false, null);
    }

    public String readArea(Point p1, Point p2, Point p3, Point p4, DataType dataType) {
        return this.readArea(p1, p2, p3, p4, false, dataType, false);
    }

    public String readArea(Point p1, Point p2, Point p3, Point p4, int lineHeight, boolean debug, DataType dataType) {
        String ret = "";
        if (debug) {
            System.out.println("######### trying to read (" + p1.x + "," + p1.y + "), (" + p2.x + "," + p2.y + "),(" + p3.x + "," + p3.y + "),(" + p4.x + "," + p4.y + ")");
        }
        Polygon polygon = new Polygon();
        polygon.addPoint(p1.x, p1.y);
        polygon.addPoint(p2.x, p2.y);
        polygon.addPoint(p3.x, p3.y);
        polygon.addPoint(p4.x, p4.y);
        int currY = -1;
        for (Entry entry : this.entries) {
            String pre;
            if (!polygon.contains(entry.p1) || !polygon.contains(entry.p2) || !polygon.contains(entry.p3) || !polygon.contains(entry.p4)) continue;
            if (currY != -1 && entry.p1.y > currY + lineHeight) {
                pre = "\n";
                currY = entry.p1.y;
            } else {
                pre = " ";
            }
            if (currY == -1) {
                currY = entry.p1.y;
            }
            ret = ret + pre + entry.getText();
        }
        if (dataType != null) {
            return DataTypeMatcher.match(ret.trim(), dataType);
        }
        return ret.trim();
    }

    public String readAreaLineOriented(Point p1, Point p2, Point p3, Point p4) {
        return this.readAreaLineOriented(p1, p2, p3, p4, 0, null);
    }

    public String readAreaLineOriented(Point p1, Point p2, Point p3, Point p4, int lineHeight) {
        return this.readAreaLineOriented(p1, p2, p3, p4, lineHeight, null);
    }

    public String readAreaLineOriented(Point p1, Point p2, Point p3, Point p4, final int lineHeight, DataType dataType) {
        Polygon polygon = new Polygon();
        polygon.addPoint(p1.x, p1.y);
        polygon.addPoint(p2.x, p2.y);
        polygon.addPoint(p3.x, p3.y);
        polygon.addPoint(p4.x, p4.y);
        ArrayList<Entry> l = new ArrayList<Entry>();
        int currY = -1;
        for (Entry entry : this.entries) {
            if (!polygon.contains(entry.p1) || !polygon.contains(entry.p2) || !polygon.contains(entry.p3) || !polygon.contains(entry.p4)) continue;
            l.add(entry);
        }
        Collections.sort(l, new Comparator<Entry>(){

            @Override
            public int compare(Entry e1, Entry e2) {
                if (e1.p1.x < e2.p1.x) {
                    if (e1.p1.y < e2.p4.y + lineHeight) {
                        return -1;
                    }
                    return 1;
                }
                if (e1.p4.y < e2.p1.y - lineHeight) {
                    return -1;
                }
                return 1;
            }
        });
        String ret = "";
        for (Entry e : l) {
            ret = ret + " " + e.getText();
        }
        ret = ret.trim();
        if (dataType != null) {
            return DataTypeMatcher.match(ret.trim(), dataType);
        }
        return ret.trim();
    }

    public String read(Entry entry, double p1DiffX, double p1DiffY, double p3DiffX, double p3DiffY, Integer lineHeight, DataType dataType) {
        int x1 = (int)((double)entry.p1.x + (double)entry.getWidth() * p1DiffX);
        int y1 = (int)((double)entry.p1.y + (double)entry.getHeight() * p1DiffY);
        int x2 = (int)((double)x1 + (double)entry.getWidth() * p3DiffX);
        int y2 = (int)((double)y1 + (double)entry.getHeight() * p3DiffY);
        Point p1 = new Point(x1, y1);
        Point p2 = new Point(x2, y1);
        Point p3 = new Point(x2, y2);
        Point p4 = new Point(x1, y2);
        if (lineHeight != null) {
            return this.readArea(p1, p2, p3, p4, lineHeight, dataType);
        }
        return this.readArea(p1, p2, p3, p4, dataType);
    }

    public String read(Entry entry, double p1DiffX, double p1DiffY, double p3DiffX, double p3DiffY) {
        return this.read(entry, p1DiffX, p1DiffY, p3DiffX, p3DiffY, null, null);
    }

    public String read(Entry entry, double p1DiffX, double p1DiffY, double p3DiffX, double p3DiffY, int lineHeight) {
        return this.read(entry, p1DiffX, p1DiffY, p3DiffX, p3DiffY, lineHeight, null);
    }

    public String read(Entry entry, double p1DiffX, double p1DiffY, double p3DiffX, double p3DiffY, DataType dataType) {
        return this.read(entry, p1DiffX, p1DiffY, p3DiffX, p3DiffY, null, dataType);
    }

    public static enum DataType {
        NUMBER,
        YEAR,
        PHONE,
        DATE,
        DATE_MMM_YYYY,
        DATE_DD_MMM_YYYYY,
        CITY,
        STATE,
        EMAIL,
        TEXT;

    }
}

