/*
 * Decompiled with CFR 0.152.
 */
package dev.botcity.botcity_document_processing.pdf;

import dev.botcity.botcity_document_processing.parser.DocumentParser;
import dev.botcity.botcity_document_processing.parser.Entry;
import java.awt.Point;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.io.RandomAccessFile;
import org.apache.pdfbox.io.RandomAccessRead;
import org.apache.pdfbox.pdfparser.PDFParser;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.text.PDFTextStripper;
import org.apache.pdfbox.text.TextPosition;

public class PdfReader
extends PDFTextStripper {
    private DocumentParser reading;
    private int currentPageInReadingMode;

    public DocumentParser readFile(File file) throws FileNotFoundException, IOException {
        this.reading = new DocumentParser();
        this.read(file);
        return this.reading;
    }

    public float getPageWidth() {
        return this.getCurrentPage().getMediaBox().getWidth();
    }

    public float getPageHeight() {
        return this.getCurrentPage().getMediaBox().getHeight();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String read(File file) throws FileNotFoundException, IOException {
        if (this.reading != null) {
            this.reading.clear();
        }
        PDDocument pdDoc = null;
        COSDocument cosDoc = null;
        RandomAccessFile f = null;
        String ret = "";
        try {
            f = new RandomAccessFile(file, "r");
            PDFParser parser = new PDFParser((RandomAccessRead)f);
            parser.parse();
            cosDoc = parser.getDocument();
            pdDoc = new PDDocument(cosDoc);
            int page = 1;
            while (true) {
                this.currentPageInReadingMode = ++page;
                this.setStartPage(page);
                this.setEndPage(page);
                String str = this.getText(pdDoc);
                if (!str.equals("")) continue;
                break;
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (pdDoc != null) {
                pdDoc.close();
            }
            if (cosDoc != null) {
                cosDoc.close();
            }
            if (f != null && !f.isClosed()) {
                f.close();
            }
        }
        return ret;
    }

    private void handleNonAscii(List<TextPosition> textPositions) {
        for (int i = 0; i < textPositions.size(); ++i) {
            if (textPositions.get(i).getCharacterCodes()[0] != 1831 && textPositions.get(i).getCharacterCodes()[0] != 64257 && textPositions.get(i).getCharacterCodes()[0] != 64258) continue;
            textPositions.add(i, textPositions.get(i));
            ++i;
        }
    }

    protected void writeString(String text, List<TextPosition> textPositions) throws IOException {
        this.handleNonAscii(textPositions);
        if (this.reading != null) {
            List<List<TextPosition>> listListPositions = this.splitWords(text, textPositions);
            for (List<TextPosition> listPositions : listListPositions) {
                Entry e = this.loadEntry(listPositions);
                if (e.getText().equals("")) continue;
                this.reading.addEntry(e);
            }
        }
        this.output.write(text);
    }

    private Entry loadEntry(List<TextPosition> listPositions) {
        Entry ret = new Entry();
        ret.setPage(this.currentPageInReadingMode - 1);
        ret.p1 = new Point(-1, -1);
        ret.p3 = new Point(-1, -1);
        ret.setText(this.listTextPositionToText(listPositions));
        int startY = (int)listPositions.get(0).getPageHeight() * (this.currentPageInReadingMode - 1);
        float ascent = 0.0f;
        for (TextPosition tp : listPositions) {
            if (tp.getUnicode().equals(" ")) continue;
            int x = (int)tp.getX();
            int x_w = (int)(tp.getX() + tp.getWidth());
            try {
                ascent = tp.getFont().getFontDescriptor().getAscent() / 1000.0f * tp.getFontSize();
            }
            catch (NullPointerException ex) {
                continue;
            }
            int y_h = (int)tp.getY();
            int y = (int)tp.getY() - (int)((double)ascent / 2.0);
            if ((double)tp.getFontSize() == 1.0) {
                int char_fontsize = (int)tp.getFontSizeInPt();
                int font_size = (int)((double)(ascent * (float)char_fontsize) / 2.0);
                y = (int)tp.getY() - font_size;
            }
            if (ret.p1.x == -1 || ret.p1.x > x) {
                ret.p1.x = x;
            }
            if (ret.p1.y == -1 || ret.p1.y > y) {
                ret.p1.y = y;
            }
            if (ret.p3.x == -1 || ret.p3.x < x_w) {
                ret.p3.x = x_w;
            }
            if (ret.p3.y != -1 && ret.p3.y >= y_h) continue;
            ret.p3.y = y_h;
        }
        ret.p1.y += startY;
        ret.p3.y += startY;
        ret.p2 = new Point(ret.p3.x, ret.p1.y);
        ret.p4 = new Point(ret.p1.x, ret.p3.y);
        return ret;
    }

    private String listTextPositionToText(List<TextPosition> textPositions) {
        StringBuilder builder = new StringBuilder();
        for (TextPosition tp : textPositions) {
            if (tp.getUnicode().equals(" ")) continue;
            builder.append(tp.getUnicode());
        }
        return builder.toString().trim();
    }

    private List<List<TextPosition>> splitWords(String text, List<TextPosition> textPositions) {
        List<TextPosition> l;
        int i;
        ArrayList<List<TextPosition>> ret = new ArrayList<List<TextPosition>>();
        int start = 0;
        TextPosition lastPos = null;
        for (i = 0; i < text.length(); ++i) {
            if (i >= textPositions.size()) {
                --i;
                break;
            }
            if ((text.charAt(i) == ' ' || text.charAt(i) == '\u00a0' || lastPos != null && !this.validDistance(lastPos, textPositions.get(i))) && start != i) {
                l = textPositions.subList(start, i);
                ret.add(l);
                start = i;
            }
            lastPos = textPositions.get(i);
        }
        if (start != i) {
            l = textPositions.subList(start, i);
            ret.add(l);
        }
        return ret;
    }

    private boolean validDistance(TextPosition tp1, TextPosition tp2) {
        double p1x = tp1.getX() + tp1.getIndividualWidths()[0];
        double p1y = tp1.getY();
        double p2x = tp2.getX();
        double p2y = tp2.getY();
        double height = tp1.getFontSize();
        return Point.distance(p1x, p1y, p2x, p2y) < height;
    }

    public void loadEntries(Object entries) {
        List listEntries = (List)entries;
        for (Object[] entry : listEntries) {
            Entry e = new Entry();
            e.setText((String)entry[0]);
            e.p1 = new Point((Integer)entry[1], (Integer)entry[2]);
            e.p2 = new Point((Integer)entry[3], (Integer)entry[4]);
            e.p3 = new Point((Integer)entry[5], (Integer)entry[6]);
            e.p4 = new Point((Integer)entry[7], (Integer)entry[8]);
            this.reading.addEntry(e);
        }
    }
}

