# Copyright (c) 2017-2021 Digital Asset (Switzerland) GmbH and/or its affiliates. All rights reserved.
# SPDX-License-Identifier: Apache-2.0
# fmt: off

from typing import (
    Any as __Any,
    Dict as __Map,
    List as __List,
    Literal as __Literal,
    NoReturn as __Void,
    Optional as __Optional,
    Sequence as __Sequence,
    Tuple as __Tuple,
    overload,
)

from google.protobuf.descriptor import FieldDescriptor as __FieldDescriptor
from google.protobuf.message import Message as __Message

from .event_pb2 import CreatedEvent
from .trace_context_pb2 import TraceContext
from .transaction_filter_pb2 import TransactionFilter

__all__ = [
    "GetActiveContractsRequest",
    "GetActiveContractsResponse",
]

class GetActiveContractsRequest(__Message):
    ledger_id: str
    filter: TransactionFilter
    verbose: bool
    trace_context: TraceContext
    def __init__(self, *, ledger_id: __Optional[str] = ..., filter: __Optional[TransactionFilter] = ..., verbose: __Optional[bool] = ..., trace_context: __Optional[TraceContext] = ...): ...
    def __eq__(self, other_msg: __Optional[__Any]) -> bool: ...
    def __str__(self) -> str: ...
    def __unicode__(self) -> str: ...
    def MergeFrom(self, other_msg: GetActiveContractsRequest) -> None: ...
    def Clear(self) -> None: ...
    def SetInParent(self) -> None: ...
    def IsInitialized(self) -> bool: ...
    def MergeFromString(self, serialized: bytes) -> int: ...
    def SerializeToString(self, *, deterministic: bool = ...) -> bytes: ...
    def SerializePartialToString(self, *, deterministic: bool = ...) -> bytes: ...
    def ListFields(self) -> __Sequence[__Tuple[__FieldDescriptor, __Any]]: ...
    def HasField(self, field_name: __Literal["ledger_id", "filter", "verbose", "trace_context"]) -> bool: ...
    def ClearField(self, field_name: __Literal["ledger_id", "filter", "verbose", "trace_context"]) -> None: ...
    def WhichOneof(self, oneof_group: __Void) -> __Void: ...
    def HasExtension(self, extension_handle: __Any) -> bool: ...
    def ClearExtension(self, extension_handle: __Any) -> None: ...
    def UnknownFields(self) -> __Any: ...
    def DiscardUnknownFields(self) -> None: ...
    def ByteSize(self) -> int: ...
    def _SetListener(self, message_listener: __Any) -> None: ...

class GetActiveContractsResponse(__Message):
    offset: str
    workflow_id: str
    active_contracts: __List[CreatedEvent]
    trace_context: TraceContext
    def __init__(self, *, offset: __Optional[str] = ..., workflow_id: __Optional[str] = ..., active_contracts: __Optional[__Sequence[CreatedEvent]] = ..., trace_context: __Optional[TraceContext] = ...): ...
    def __eq__(self, other_msg: __Optional[__Any]) -> bool: ...
    def __str__(self) -> str: ...
    def __unicode__(self) -> str: ...
    def MergeFrom(self, other_msg: GetActiveContractsResponse) -> None: ...
    def Clear(self) -> None: ...
    def SetInParent(self) -> None: ...
    def IsInitialized(self) -> bool: ...
    def ParseFromString(self, serialized: bytes) -> int: ...
    def MergeFromString(self, serialized: bytes) -> int: ...
    def SerializeToString(self, *, deterministic: bool = ...) -> bytes: ...
    def SerializePartialToString(self, *, deterministic: bool = ...) -> bytes: ...
    def ListFields(self) -> __Sequence[__Tuple[__FieldDescriptor, __Any]]: ...
    def HasField(self, field_name: __Literal["offset", "workflow_id", "active_contracts", "trace_context"]) -> bool: ...
    def ClearField(self, field_name: __Literal["offset", "workflow_id", "active_contracts", "trace_context"]) -> None: ...
    def WhichOneof(self, oneof_group: __Void) -> __Void: ...
    def HasExtension(self, extension_handle: __Any) -> bool: ...
    def ClearExtension(self, extension_handle: __Any) -> None: ...
    def UnknownFields(self) -> __Any: ...
    def DiscardUnknownFields(self) -> None: ...
    def ByteSize(self) -> int: ...
    def _SetListener(self, message_listener: __Any) -> None: ...
