# Copyright (c) 2017-2021 Digital Asset (Switzerland) GmbH and/or its affiliates. All rights reserved.
# SPDX-License-Identifier: Apache-2.0
# fmt: off

from typing import (
    Any as __Any,
    Dict as __Map,
    List as __List,
    Literal as __Literal,
    NoReturn as __Void,
    Optional as __Optional,
    Sequence as __Sequence,
    Tuple as __Tuple,
    overload,
)

from google.protobuf.descriptor import FieldDescriptor as __FieldDescriptor
from google.protobuf.message import Message as __Message
from google.protobuf.wrappers_pb2 import StringValue

from .......prim import Party
from .value_pb2 import Identifier, Record, Value

__all__ = [
    "Event",
    "CreatedEvent",
    "ArchivedEvent",
    "ExercisedEvent",
]

class Event(__Message):
    created: CreatedEvent
    archived: ArchivedEvent
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, *, created: CreatedEvent = ...): ...
    @overload
    def __init__(self, *, archived: ArchivedEvent = ...): ...
    def __eq__(self, other_msg: __Optional[__Any]) -> bool: ...
    def __str__(self) -> str: ...
    def __unicode__(self) -> str: ...
    def MergeFrom(self, other_msg: Event) -> None: ...
    def Clear(self) -> None: ...
    def SetInParent(self) -> None: ...
    def IsInitialized(self) -> bool: ...
    def MergeFromString(self, serialized: bytes) -> int: ...
    def SerializeToString(self, *, deterministic: bool = ...) -> bytes: ...
    def SerializePartialToString(self, *, deterministic: bool = ...) -> bytes: ...
    def ListFields(self) -> __Sequence[__Tuple[__FieldDescriptor, __Any]]: ...
    def HasField(self, field_name: __Literal["event", "created", "archived"]) -> bool: ...
    def ClearField(self, field_name: __Literal["event", "created", "archived"]) -> None: ...
    def WhichOneof(self, oneof_group: __Literal["event"]) -> __Literal[None, "created", "archived"]: ...
    def HasExtension(self, extension_handle: __Any) -> bool: ...
    def ClearExtension(self, extension_handle: __Any) -> None: ...
    def UnknownFields(self) -> __Any: ...
    def DiscardUnknownFields(self) -> None: ...
    def ByteSize(self) -> int: ...
    def _SetListener(self, message_listener: __Any) -> None: ...

class CreatedEvent(__Message):
    event_id: str
    contract_id: str
    template_id: Identifier
    contract_key: Value
    create_arguments: Record
    witness_parties: __List[Party]
    signatories: __List[Party]
    observers: __List[Party]
    agreement_text: StringValue
    def __init__(self, *, event_id: __Optional[str] = ..., contract_id: __Optional[str] = ..., template_id: __Optional[Identifier] = ..., contract_key: __Optional[Value] = ..., create_arguments: __Optional[Record] = ..., witness_parties: __Optional[__Sequence[Party]] = ..., signatories: __Optional[__Sequence[Party]] = ..., observers: __Optional[__Sequence[Party]] = ..., agreement_text: StringValue = ...): ...
    def __eq__(self, other_msg: __Optional[__Any]) -> bool: ...
    def __str__(self) -> str: ...
    def __unicode__(self) -> str: ...
    def MergeFrom(self, other_msg: CreatedEvent) -> None: ...
    def Clear(self) -> None: ...
    def SetInParent(self) -> None: ...
    def IsInitialized(self) -> bool: ...
    def MergeFromString(self, serialized: bytes) -> int: ...
    def SerializeToString(self, *, deterministic: bool = ...) -> bytes: ...
    def SerializePartialToString(self, *, deterministic: bool = ...) -> bytes: ...
    def ListFields(self) -> __Sequence[__Tuple[__FieldDescriptor, __Any]]: ...
    def HasField(self, field_name: __Literal["event_id", "contract_id", "template_id", "contract_key", "create_arguments", "witness_parties", "signatories", "observers", "agreement_text"]) -> bool: ...
    def ClearField(self, field_name: __Literal["event_id", "contract_id", "template_id", "contract_key", "create_arguments", "witness_parties", "signatories", "observers", "agreement_text"]) -> None: ...
    def WhichOneof(self, oneof_group: __Void) -> __Void: ...
    def HasExtension(self, extension_handle: __Any) -> bool: ...
    def ClearExtension(self, extension_handle: __Any) -> None: ...
    def UnknownFields(self) -> __Any: ...
    def DiscardUnknownFields(self) -> None: ...
    def ByteSize(self) -> int: ...
    def _SetListener(self, message_listener: __Any) -> None: ...

class ArchivedEvent(__Message):
    event_id: str
    contract_id: str
    template_id: Identifier
    witness_parties: __List[Party]
    def __init__(self, *, event_id: __Optional[str] = ..., contract_id: __Optional[str] = ..., template_id: __Optional[Identifier] = ..., witness_parties: __Optional[__Sequence[Party]] = ...): ...
    def __eq__(self, other_msg: __Optional[__Any]) -> bool: ...
    def __str__(self) -> str: ...
    def __unicode__(self) -> str: ...
    def MergeFrom(self, other_msg: ArchivedEvent) -> None: ...
    def Clear(self) -> None: ...
    def SetInParent(self) -> None: ...
    def IsInitialized(self) -> bool: ...
    def MergeFromString(self, serialized: bytes) -> int: ...
    def SerializeToString(self, *, deterministic: bool = ...) -> bytes: ...
    def SerializePartialToString(self, *, deterministic: bool = ...) -> bytes: ...
    def ListFields(self) -> __Sequence[__Tuple[__FieldDescriptor, __Any]]: ...
    def HasField(self, field_name: __Literal["event_id", "contract_id", "template_id", "witness_parties"]) -> bool: ...
    def ClearField(self, field_name: __Literal["event_id", "contract_id", "template_id", "witness_parties"]) -> None: ...
    def WhichOneof(self, oneof_group: __Void) -> __Void: ...
    def HasExtension(self, extension_handle: __Any) -> bool: ...
    def ClearExtension(self, extension_handle: __Any) -> None: ...
    def UnknownFields(self) -> __Any: ...
    def DiscardUnknownFields(self) -> None: ...
    def ByteSize(self) -> int: ...
    def _SetListener(self, message_listener: __Any) -> None: ...

class ExercisedEvent(__Message):
    event_id: str
    contract_id: str
    template_id: Identifier
    choice: str
    choice_argument: Value
    acting_parties: __List[Party]
    consuming: bool
    witness_parties: __List[Party]
    child_event_ids: __List[str]
    exercise_result: Value
    def __init__(self, *, event_id: __Optional[str] = ..., contract_id: __Optional[str] = ..., template_id: __Optional[Identifier] = ..., choice: __Optional[str] = ..., choice_argument: __Optional[Value] = ..., acting_parties: __Optional[__Sequence[Party]] = ..., consuming: __Optional[bool] = ..., witness_parties: __Optional[__Sequence[Party]] = ..., child_event_ids: __Optional[__Sequence[str]] = ..., exercise_result: __Optional[Value] = ...): ...
    def __eq__(self, other_msg: __Optional[__Any]) -> bool: ...
    def __str__(self) -> str: ...
    def __unicode__(self) -> str: ...
    def MergeFrom(self, other_msg: ExercisedEvent) -> None: ...
    def Clear(self) -> None: ...
    def SetInParent(self) -> None: ...
    def IsInitialized(self) -> bool: ...
    def MergeFromString(self, serialized: bytes) -> int: ...
    def SerializeToString(self, *, deterministic: bool = ...) -> bytes: ...
    def SerializePartialToString(self, *, deterministic: bool = ...) -> bytes: ...
    def ListFields(self) -> __Sequence[__Tuple[__FieldDescriptor, __Any]]: ...
    def HasField(self, field_name: __Literal["event_id", "contract_id", "template_id", "choice", "choice_argument", "acting_parties", "consuming", "witness_parties", "child_event_ids", "exercise_result"]) -> bool: ...
    def ClearField(self, field_name: __Literal["event_id", "contract_id", "template_id", "choice", "choice_argument", "acting_parties", "consuming", "witness_parties", "child_event_ids", "exercise_result"]) -> None: ...
    def WhichOneof(self, oneof_group: __Void) -> __Void: ...
    def HasExtension(self, extension_handle: __Any) -> bool: ...
    def ClearExtension(self, extension_handle: __Any) -> None: ...
    def UnknownFields(self) -> __Any: ...
    def DiscardUnknownFields(self) -> None: ...
    def ByteSize(self) -> int: ...
    def _SetListener(self, message_listener: __Any) -> None: ...
