# Copyright (c) 2017-2021 Digital Asset (Switzerland) GmbH and/or its affiliates. All rights reserved.
# SPDX-License-Identifier: Apache-2.0
# fmt: off

from typing import (
    Any as __Any,
    ClassVar as __ClassVar,
    Dict as __Map,
    List as __List,
    Literal as __Literal,
    NoReturn as __Void,
    Optional as __Optional,
    Sequence as __Sequence,
    Tuple as __Tuple,
    overload,
)

from google.protobuf.descriptor import FieldDescriptor as __FieldDescriptor
from google.protobuf.internal.enum_type_wrapper import EnumTypeWrapper as __EnumTypeWrapper
from google.protobuf.message import Message as __Message

__all__ = [
    "LedgerOffset",
]

class LedgerOffset(__Message):
    absolute: str
    boundary: __Literal[0, 1]
    def __init__(self, *, absolute: __Optional[str] = ..., boundary: __Optional[__Literal[0, 1]] = ...): ...
    def __eq__(self, other_msg: __Optional[__Any]) -> bool: ...
    def __str__(self) -> str: ...
    def __unicode__(self) -> str: ...
    def MergeFrom(self, other_msg: LedgerOffset) -> None: ...
    def Clear(self) -> None: ...
    def SetInParent(self) -> None: ...
    def IsInitialized(self) -> bool: ...
    def MergeFromString(self, serialized: bytes) -> int: ...
    def SerializeToString(self, *, deterministic: bool = ...) -> bytes: ...
    def SerializePartialToString(self, *, deterministic: bool = ...) -> bytes: ...
    def ListFields(self) -> __Sequence[__Tuple[__FieldDescriptor, __Any]]: ...
    def HasField(self, field_name: __Literal["value", "absolute", "boundary"]) -> bool: ...
    def ClearField(self, field_name: __Literal["value", "absolute", "boundary"]) -> None: ...
    def WhichOneof(self, oneof_group: __Literal["value"]) -> __Literal[None, "absolute", "boundary"]: ...
    def HasExtension(self, extension_handle: __Any) -> bool: ...
    def ClearExtension(self, extension_handle: __Any) -> None: ...
    def UnknownFields(self) -> __Any: ...
    def DiscardUnknownFields(self) -> None: ...
    def ByteSize(self) -> int: ...
    def _SetListener(self, message_listener: __Any) -> None: ...

    class LedgerBoundary(__EnumTypeWrapper):
        @overload
        def Name(self, number: __Literal[0]) -> __Literal["LEDGER_BEGIN"]: ...
        @overload
        def Name(self, number: __Literal[1]) -> __Literal["LEDGER_END"]: ...
        @overload
        def Value(self, name: __Literal["LEDGER_BEGIN"]) -> __Literal[0]: ...
        @overload
        def Value(self, name: __Literal["LEDGER_END"]) -> __Literal[1]: ...

    LEDGER_BEGIN: __ClassVar[__Literal[0]] = ...
    LEDGER_END: __ClassVar[__Literal[1]] = ...
