# Copyright (c) 2017-2021 Digital Asset (Switzerland) GmbH and/or its affiliates. All rights reserved.
# SPDX-License-Identifier: Apache-2.0
# fmt: off

from typing import (
    Any as __Any,
    Dict as __Map,
    List as __List,
    Literal as __Literal,
    Mapping as __Mapping,
    NoReturn as __Void,
    Optional as __Optional,
    Sequence as __Sequence,
    Tuple as __Tuple,
    overload,
)

from google.protobuf.descriptor import FieldDescriptor as __FieldDescriptor
from google.protobuf.internal.enum_type_wrapper import EnumTypeWrapper as __EnumTypeWrapper
from google.protobuf.message import Message as __Message

from .......damlast.daml_lf_1 import PackageRef
from .trace_context_pb2 import TraceContext

__all__ = [
    "ListPackagesRequest",
    "ListPackagesResponse",
    "GetPackageRequest",
    "GetPackageResponse",
    "GetPackageStatusRequest",
    "GetPackageStatusResponse",
    "HashFunction",
    "SHA256",
    "PackageStatus",
    "UNKNOWN",
    "REGISTERED",
]

class ListPackagesRequest(__Message):
    ledger_id: str
    trace_context: TraceContext
    def __init__(self, *, ledger_id: __Optional[str] = ..., trace_context: __Optional[TraceContext] = ...): ...
    def __eq__(self, other_msg: __Optional[__Any]) -> bool: ...
    def __str__(self) -> str: ...
    def __unicode__(self) -> str: ...
    def MergeFrom(self, other_msg: ListPackagesRequest) -> None: ...
    def Clear(self) -> None: ...
    def SetInParent(self) -> None: ...
    def IsInitialized(self) -> bool: ...
    def MergeFromString(self, serialized: bytes) -> int: ...
    def SerializeToString(self, *, deterministic: bool = ...) -> bytes: ...
    def SerializePartialToString(self, *, deterministic: bool = ...) -> bytes: ...
    def ListFields(self) -> __Sequence[__Tuple[__FieldDescriptor, __Any]]: ...
    def HasField(self, field_name: __Literal["ledger_id", "trace_context"]) -> bool: ...
    def ClearField(self, field_name: __Literal["ledger_id", "trace_context"]) -> None: ...
    def WhichOneof(self, oneof_group: __Void) -> __Void: ...
    def HasExtension(self, extension_handle: __Any) -> bool: ...
    def ClearExtension(self, extension_handle: __Any) -> None: ...
    def UnknownFields(self) -> __Any: ...
    def DiscardUnknownFields(self) -> None: ...
    def ByteSize(self) -> int: ...
    def _SetListener(self, message_listener: __Any) -> None: ...

class ListPackagesResponse(__Message):
    package_ids: __List[PackageRef]
    def __init__(self, *, package_ids: __Optional[__Sequence[PackageRef]] = ...): ...
    def __eq__(self, other_msg: __Optional[__Any]) -> bool: ...
    def __str__(self) -> str: ...
    def __unicode__(self) -> str: ...
    def MergeFrom(self, other_msg: ListPackagesResponse) -> None: ...
    def Clear(self) -> None: ...
    def SetInParent(self) -> None: ...
    def IsInitialized(self) -> bool: ...
    def MergeFromString(self, serialized: bytes) -> int: ...
    def SerializeToString(self, *, deterministic: bool = ...) -> bytes: ...
    def SerializePartialToString(self, *, deterministic: bool = ...) -> bytes: ...
    def ListFields(self) -> __Sequence[__Tuple[__FieldDescriptor, __Any]]: ...
    def HasField(self, field_name: __Literal["package_ids"]) -> bool: ...
    def ClearField(self, field_name: __Literal["package_ids"]) -> None: ...
    def WhichOneof(self, oneof_group: __Void) -> __Void: ...
    def HasExtension(self, extension_handle: __Any) -> bool: ...
    def ClearExtension(self, extension_handle: __Any) -> None: ...
    def UnknownFields(self) -> __Any: ...
    def DiscardUnknownFields(self) -> None: ...
    def ByteSize(self) -> int: ...
    def _SetListener(self, message_listener: __Any) -> None: ...

class GetPackageRequest(__Message):
    ledger_id: str
    package_id: PackageRef
    trace_context: TraceContext
    def __init__(self, *, ledger_id: __Optional[str] = ..., package_id: __Optional[PackageRef] = ..., trace_context: __Optional[TraceContext] = ...): ...
    def __eq__(self, other_msg: __Optional[__Any]) -> bool: ...
    def __str__(self) -> str: ...
    def __unicode__(self) -> str: ...
    def MergeFrom(self, other_msg: GetPackageRequest) -> None: ...
    def Clear(self) -> None: ...
    def SetInParent(self) -> None: ...
    def IsInitialized(self) -> bool: ...
    def MergeFromString(self, serialized: bytes) -> int: ...
    def SerializeToString(self, *, deterministic: bool = ...) -> bytes: ...
    def SerializePartialToString(self, *, deterministic: bool = ...) -> bytes: ...
    def ListFields(self) -> __Sequence[__Tuple[__FieldDescriptor, __Any]]: ...
    def HasField(self, field_name: __Literal["ledger_id", "package_id", "trace_context"]) -> bool: ...
    def ClearField(self, field_name: __Literal["ledger_id", "package_id", "trace_context"]) -> None: ...
    def WhichOneof(self, oneof_group: __Void) -> __Void: ...
    def HasExtension(self, extension_handle: __Any) -> bool: ...
    def ClearExtension(self, extension_handle: __Any) -> None: ...
    def UnknownFields(self) -> __Any: ...
    def DiscardUnknownFields(self) -> None: ...
    def ByteSize(self) -> int: ...
    def _SetListener(self, message_listener: __Any) -> None: ...

class GetPackageResponse(__Message):
    hash_function: __Literal[0]
    archive_payload: bytes
    hash: PackageRef
    def __init__(self, *, hash_function: __Optional[__Literal[0]] = ..., archive_payload: __Optional[bytes] = ..., hash: __Optional[PackageRef] = ...): ...
    def __eq__(self, other_msg: __Optional[__Any]) -> bool: ...
    def __str__(self) -> str: ...
    def __unicode__(self) -> str: ...
    def MergeFrom(self, other_msg: GetPackageResponse) -> None: ...
    def Clear(self) -> None: ...
    def SetInParent(self) -> None: ...
    def IsInitialized(self) -> bool: ...
    def MergeFromString(self, serialized: bytes) -> int: ...
    def SerializeToString(self, *, deterministic: bool = ...) -> bytes: ...
    def SerializePartialToString(self, *, deterministic: bool = ...) -> bytes: ...
    def ListFields(self) -> __Sequence[__Tuple[__FieldDescriptor, __Any]]: ...
    def HasField(self, field_name: __Literal["hash_function", "archive_payload", "hash"]) -> bool: ...
    def ClearField(self, field_name: __Literal["hash_function", "archive_payload", "hash"]) -> None: ...
    def WhichOneof(self, oneof_group: __Void) -> __Void: ...
    def HasExtension(self, extension_handle: __Any) -> bool: ...
    def ClearExtension(self, extension_handle: __Any) -> None: ...
    def UnknownFields(self) -> __Any: ...
    def DiscardUnknownFields(self) -> None: ...
    def ByteSize(self) -> int: ...
    def _SetListener(self, message_listener: __Any) -> None: ...

class GetPackageStatusRequest(__Message):
    ledger_id: str
    package_id: PackageRef
    trace_context: TraceContext
    def __init__(self, *, ledger_id: __Optional[str] = ..., package_id: __Optional[PackageRef] = ..., trace_context: __Optional[TraceContext] = ...): ...
    def __eq__(self, other_msg: __Optional[__Any]) -> bool: ...
    def __str__(self) -> str: ...
    def __unicode__(self) -> str: ...
    def MergeFrom(self, other_msg: GetPackageStatusRequest) -> None: ...
    def Clear(self) -> None: ...
    def SetInParent(self) -> None: ...
    def IsInitialized(self) -> bool: ...
    def MergeFromString(self, serialized: bytes) -> int: ...
    def SerializeToString(self, *, deterministic: bool = ...) -> bytes: ...
    def SerializePartialToString(self, *, deterministic: bool = ...) -> bytes: ...
    def ListFields(self) -> __Sequence[__Tuple[__FieldDescriptor, __Any]]: ...
    def HasField(self, field_name: __Literal["ledger_id", "package_id", "trace_context"]) -> bool: ...
    def ClearField(self, field_name: __Literal["ledger_id", "package_id", "trace_context"]) -> None: ...
    def WhichOneof(self, oneof_group: __Void) -> __Void: ...
    def HasExtension(self, extension_handle: __Any) -> bool: ...
    def ClearExtension(self, extension_handle: __Any) -> None: ...
    def UnknownFields(self) -> __Any: ...
    def DiscardUnknownFields(self) -> None: ...
    def ByteSize(self) -> int: ...
    def _SetListener(self, message_listener: __Any) -> None: ...

class GetPackageStatusResponse(__Message):
    package_status: __Literal[0, 1]
    def __init__(self, *, package_status: __Optional[__Literal[0, 1]] = ...): ...
    def __eq__(self, other_msg: __Optional[__Any]) -> bool: ...
    def __str__(self) -> str: ...
    def __unicode__(self) -> str: ...
    def MergeFrom(self, other_msg: GetPackageStatusResponse) -> None: ...
    def Clear(self) -> None: ...
    def SetInParent(self) -> None: ...
    def IsInitialized(self) -> bool: ...
    def MergeFromString(self, serialized: bytes) -> int: ...
    def SerializeToString(self, *, deterministic: bool = ...) -> bytes: ...
    def SerializePartialToString(self, *, deterministic: bool = ...) -> bytes: ...
    def ListFields(self) -> __Sequence[__Tuple[__FieldDescriptor, __Any]]: ...
    def HasField(self, field_name: __Literal["package_status"]) -> bool: ...
    def ClearField(self, field_name: __Literal["package_status"]) -> None: ...
    def WhichOneof(self, oneof_group: __Void) -> __Void: ...
    def HasExtension(self, extension_handle: __Any) -> bool: ...
    def ClearExtension(self, extension_handle: __Any) -> None: ...
    def UnknownFields(self) -> __Any: ...
    def DiscardUnknownFields(self) -> None: ...
    def ByteSize(self) -> int: ...
    def _SetListener(self, message_listener: __Any) -> None: ...

class HashFunction(__EnumTypeWrapper):
    @overload
    def Name(self, number: __Literal[0]) -> __Literal["SHA256"]: ...
    @overload
    def Value(self, name: __Literal["SHA256"]) -> __Literal[0]: ...

SHA256: __Literal[0] = ...

class PackageStatus(__EnumTypeWrapper):
    @overload
    def Name(self, number: __Literal[0]) -> __Literal["UNKNOWN"]: ...
    @overload
    def Name(self, number: __Literal[1]) -> __Literal["REGISTERED"]: ...
    @overload
    def Value(self, name: __Literal["UNKNOWN"]) -> __Literal[0]: ...
    @overload
    def Value(self, name: __Literal["REGISTERED"]) -> __Literal[1]: ...

UNKNOWN: __Literal[0] = ...
REGISTERED: __Literal[1] = ...
