# Copyright (c) 2017-2021 Digital Asset (Switzerland) GmbH and/or its affiliates. All rights reserved.
# SPDX-License-Identifier: Apache-2.0
# fmt: off

from typing import (
    Any as __Any,
    Dict as __Map,
    List as __List,
    Literal as __Literal,
    Mapping as __Mapping,
    NoReturn as __Void,
    Optional as __Optional,
    Sequence as __Sequence,
    Tuple as __Tuple,
    overload,
)

from google.protobuf.descriptor import FieldDescriptor as __FieldDescriptor
from google.protobuf.message import Message as __Message
from google.protobuf.timestamp_pb2 import Timestamp

from .event_pb2 import CreatedEvent, Event, ExercisedEvent
from .trace_context_pb2 import TraceContext

__all__ = [
    "TransactionTree",
    "TreeEvent",
    "Transaction",
]

class TransactionTree(__Message):
    transaction_id: str
    command_id: str
    workflow_id: str
    effective_at: Timestamp
    offset: str
    events_by_id: __Map[str, TreeEvent]
    root_event_ids: __List[str]
    trace_context: TraceContext
    def __init__(self, *, transaction_id: __Optional[str] = ..., command_id: __Optional[str] = ..., workflow_id: __Optional[str] = ..., effective_at: __Optional[Timestamp] = ..., offset: __Optional[str] = ..., events_by_id: __Optional[__Mapping[str, TreeEvent]] = ..., root_event_ids: __Optional[__Sequence[str]] = ..., trace_context: __Optional[TraceContext] = ...): ...
    def __eq__(self, other_msg: __Optional[__Any]) -> bool: ...
    def __str__(self) -> str: ...
    def __unicode__(self) -> str: ...
    def MergeFrom(self, other_msg: TransactionTree) -> None: ...
    def Clear(self) -> None: ...
    def SetInParent(self) -> None: ...
    def IsInitialized(self) -> bool: ...
    def MergeFromString(self, serialized: bytes) -> int: ...
    def SerializeToString(self, *, deterministic: bool = ...) -> bytes: ...
    def SerializePartialToString(self, *, deterministic: bool = ...) -> bytes: ...
    def ListFields(self) -> __Sequence[__Tuple[__FieldDescriptor, __Any]]: ...
    def HasField(self, field_name: __Literal["transaction_id", "command_id", "workflow_id", "effective_at", "offset", "events_by_id", "root_event_ids", "trace_context"]) -> bool: ...
    def ClearField(self, field_name: __Literal["transaction_id", "command_id", "workflow_id", "effective_at", "offset", "events_by_id", "root_event_ids", "trace_context"]) -> None: ...
    def WhichOneof(self, oneof_group: __Void) -> __Void: ...
    def HasExtension(self, extension_handle: __Any) -> bool: ...
    def ClearExtension(self, extension_handle: __Any) -> None: ...
    def UnknownFields(self) -> __Any: ...
    def DiscardUnknownFields(self) -> None: ...
    def ByteSize(self) -> int: ...
    def _SetListener(self, message_listener: __Any) -> None: ...

class TreeEvent(__Message):
    created: CreatedEvent
    exercised: ExercisedEvent
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, *, created: CreatedEvent = ...): ...
    @overload
    def __init__(self, *, exercised: ExercisedEvent = ...): ...
    def __eq__(self, other_msg: __Optional[__Any]) -> bool: ...
    def __str__(self) -> str: ...
    def __unicode__(self) -> str: ...
    def MergeFrom(self, other_msg: TreeEvent) -> None: ...
    def Clear(self) -> None: ...
    def SetInParent(self) -> None: ...
    def IsInitialized(self) -> bool: ...
    def MergeFromString(self, serialized: bytes) -> int: ...
    def SerializeToString(self, *, deterministic: bool = ...) -> bytes: ...
    def SerializePartialToString(self, *, deterministic: bool = ...) -> bytes: ...
    def ListFields(self) -> __Sequence[__Tuple[__FieldDescriptor, __Any]]: ...
    def HasField(self, field_name: __Literal["kind", "created", "exercised"]) -> bool: ...
    def ClearField(self, field_name: __Literal["kind", "created", "exercised"]) -> None: ...
    def WhichOneof(self, oneof_group: __Literal["kind"]) -> __Literal[None, "created", "exercised"]: ...
    def HasExtension(self, extension_handle: __Any) -> bool: ...
    def ClearExtension(self, extension_handle: __Any) -> None: ...
    def UnknownFields(self) -> __Any: ...
    def DiscardUnknownFields(self) -> None: ...
    def ByteSize(self) -> int: ...
    def _SetListener(self, message_listener: __Any) -> None: ...

class Transaction(__Message):
    transaction_id: str
    command_id: str
    workflow_id: str
    effective_at: Timestamp
    events: __List[Event]
    offset: str
    trace_context: TraceContext
    def __init__(self, *, transaction_id: __Optional[str] = ..., command_id: __Optional[str] = ..., workflow_id: __Optional[str] = ..., effective_at: __Optional[Timestamp] = ..., events: __Optional[__Sequence[Event]] = ..., offset: __Optional[str] = ..., trace_context: __Optional[TraceContext] = ...): ...
    def __eq__(self, other_msg: __Optional[__Any]) -> bool: ...
    def __str__(self) -> str: ...
    def __unicode__(self) -> str: ...
    def MergeFrom(self, other_msg: Transaction) -> None: ...
    def Clear(self) -> None: ...
    def SetInParent(self) -> None: ...
    def IsInitialized(self) -> bool: ...
    def MergeFromString(self, serialized: bytes) -> int: ...
    def SerializeToString(self, *, deterministic: bool = ...) -> bytes: ...
    def SerializePartialToString(self, *, deterministic: bool = ...) -> bytes: ...
    def ListFields(self) -> __Sequence[__Tuple[__FieldDescriptor, __Any]]: ...
    def HasField(self, field_name: __Literal["transaction_id", "command_id", "workflow_id", "effective_at", "events", "offset", "trace_context"]) -> bool: ...
    def ClearField(self, field_name: __Literal["transaction_id", "command_id", "workflow_id", "effective_at", "events", "offset", "trace_context"]) -> None: ...
    def WhichOneof(self, oneof_group: __Void) -> __Void: ...
    def HasExtension(self, extension_handle: __Any) -> bool: ...
    def ClearExtension(self, extension_handle: __Any) -> None: ...
    def UnknownFields(self) -> __Any: ...
    def DiscardUnknownFields(self) -> None: ...
    def ByteSize(self) -> int: ...
    def _SetListener(self, message_listener: __Any) -> None: ...
