# Copyright (c) 2017-2021 Digital Asset (Switzerland) GmbH and/or its affiliates. All rights reserved.
# SPDX-License-Identifier: Apache-2.0
# fmt: off

from typing import (
    Any as __Any,
    Dict as __Map,
    List as _List,
    Literal as __Literal,
    NoReturn as __Void,
    Optional as __Optional,
    Sequence as __Sequence,
    Tuple as __Tuple,
    TypeVar as __TypeVar,
    overload,
)

from google.protobuf.descriptor import FieldDescriptor as __FieldDescriptor
from google.protobuf.empty_pb2 import Empty
from google.protobuf.message import Message as __Message

from .......damlast.daml_lf_1 import PackageRef
from .......prim import Party

__all__ = [
    "Value",
    "Record",
    "RecordField",
    "Identifier",
    "Variant",
    "Enum",
    "List",
    "Optional",
    "Map",
    "Enum",
    "GenMap",
]

T = __TypeVar("T")

class __List(_List[T]):
    def add(self) -> T: ...

class Value(__Message):
    record: Record
    variant: Variant
    contract_id: str
    list: List
    int64: int
    numeric: str
    text: str
    timestamp: float
    party: Party
    bool: bool
    unit: Empty
    date: int
    optional: Optional
    map: Map
    enum: Enum
    gen_map: GenMap
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, *, record: Record = ...): ...
    @overload
    def __init__(self, *, variant: Variant = ...): ...
    @overload
    def __init__(self, *, contract_id: str = ...): ...
    @overload
    def __init__(self, *, list: List = ...): ...
    @overload
    def __init__(self, *, int64: int = ...): ...
    @overload
    def __init__(self, *, numeric: str = ...): ...
    @overload
    def __init__(self, *, text: str = ...): ...
    @overload
    def __init__(self, *, timestamp: float = ...): ...
    @overload
    def __init__(self, *, party: Party = ...): ...
    @overload
    def __init__(self, *, bool: bool = ...): ...
    @overload
    def __init__(self, *, unit: Empty = ...): ...
    @overload
    def __init__(self, *, date: int = ...): ...
    @overload
    def __init__(self, *, optional: Optional = ...): ...
    @overload
    def __init__(self, *, map: Map = ...): ...
    @overload
    def __init__(self, *, enum: Enum = ...): ...
    @overload
    def __init__(self, *, gen_map: GenMap = ...): ...
    def __eq__(self, other_msg: __Optional[__Any]) -> bool: ...
    def __str__(self) -> str: ...
    def __unicode__(self) -> str: ...
    def MergeFrom(self, other_msg: Value) -> None: ...
    def Clear(self) -> None: ...
    def SetInParent(self) -> None: ...
    def IsInitialized(self) -> bool: ...
    def ParseFromString(self, serialized: bytes) -> int: ...
    def MergeFromString(self, serialized: bytes) -> int: ...
    def SerializeToString(self, *, deterministic: bool = ...) -> bytes: ...
    def SerializePartialToString(self, *, deterministic: bool = ...) -> bytes: ...
    def ListFields(self) -> __Sequence[__Tuple[__FieldDescriptor, __Any]]: ...
    def HasField(self, field_name: __Literal["Sum", "record", "variant", "contract_id", "list", "int64", "numeric", "text", "timestamp", "party", "bool", "unit", "date", "optional,", "map", "enum", "gen_map"]) -> bool: ...
    def ClearField(self, field_name: __Literal["Sum", "record", "variant", "contract_id", "list", "int64", "numeric", "text", "timestamp", "party", "bool", "unit", "date", "optional,", "map", "enum", "gen_map"]) -> None: ...
    def WhichOneof(self, oneof_group: __Literal["Sum"]) -> __Literal[None, "record", "variant", "contract_id", "list", "int64", "numeric", "text", "timestamp", "party", "bool", "unit", "date", "optional,", "map", "enum", "gen_map"]: ...
    def HasExtension(self, extension_handle: __Any) -> bool: ...
    def ClearExtension(self, extension_handle: __Any) -> None: ...
    def UnknownFields(self) -> __Any: ...
    def DiscardUnknownFields(self) -> None: ...
    def ByteSize(self) -> int: ...
    def _SetListener(self, message_listener: __Any) -> None: ...

class Record(__Message):
    record_id: Identifier
    fields: __List[RecordField]
    def __init__(self, *, record_id: __Optional[Identifier] = ..., fields: __Optional[__Sequence[RecordField]] = ...): ...
    def __eq__(self, other_msg: __Optional[__Any]) -> bool: ...
    def __str__(self) -> str: ...
    def __unicode__(self) -> str: ...
    def MergeFrom(self, other_msg: Record) -> None: ...
    def Clear(self) -> None: ...
    def SetInParent(self) -> None: ...
    def IsInitialized(self) -> bool: ...
    def ParseFromString(self, serialized: bytes) -> int: ...
    def MergeFromString(self, serialized: bytes) -> int: ...
    def SerializeToString(self, *, deterministic: bool = ...) -> bytes: ...
    def SerializePartialToString(self, *, deterministic: bool = ...) -> bytes: ...
    def ListFields(self) -> __Sequence[__Tuple[__FieldDescriptor, __Any]]: ...
    def HasField(self, field_name: __Literal["record_id", "fields"]) -> bool: ...
    def ClearField(self, field_name: __Literal["record_id", "fields"]) -> None: ...
    def WhichOneof(self, oneof_group: __Void) -> __Void: ...
    def HasExtension(self, extension_handle: __Any) -> bool: ...
    def ClearExtension(self, extension_handle: __Any) -> None: ...
    def UnknownFields(self) -> __Any: ...
    def DiscardUnknownFields(self) -> None: ...
    def ByteSize(self) -> int: ...
    def _SetListener(self, message_listener: __Any) -> None: ...

class RecordField(__Message):
    label: str
    value: Value
    def __init__(self, *, label: __Optional[str] = ..., value: __Optional[Value] = ...): ...
    def __eq__(self, other_msg: __Optional[__Any]) -> bool: ...
    def __str__(self) -> str: ...
    def __unicode__(self) -> str: ...
    def MergeFrom(self, other_msg: RecordField) -> None: ...
    def Clear(self) -> None: ...
    def SetInParent(self) -> None: ...
    def IsInitialized(self) -> bool: ...
    def ParseFromString(self, serialized: bytes) -> int: ...
    def MergeFromString(self, serialized: bytes) -> int: ...
    def SerializeToString(self, *, deterministic: bool = ...) -> bytes: ...
    def SerializePartialToString(self, *, deterministic: bool = ...) -> bytes: ...
    def ListFields(self) -> __Sequence[__Tuple[__FieldDescriptor, __Any]]: ...
    def HasField(self, field_name: __Literal["label", "value"]) -> bool: ...
    def ClearField(self, field_name: __Literal["label", "value"]) -> None: ...
    def WhichOneof(self, oneof_group: __Void) -> __Void: ...
    def HasExtension(self, extension_handle: __Any) -> bool: ...
    def ClearExtension(self, extension_handle: __Any) -> None: ...
    def UnknownFields(self) -> __Any: ...
    def DiscardUnknownFields(self) -> None: ...
    def ByteSize(self) -> int: ...
    def _SetListener(self, message_listener: __Any) -> None: ...

class Identifier(__Message):
    package_id: PackageRef
    module_name: str
    entity_name: str
    def __init__(self, *, package_id: __Optional[PackageRef] = ..., module_name: __Optional[str] = ..., entity_name: __Optional[str] = ...): ...
    def __eq__(self, other_msg: __Optional[__Any]) -> bool: ...
    def __str__(self) -> str: ...
    def __unicode__(self) -> str: ...
    def MergeFrom(self, other_msg: Identifier) -> None: ...
    def Clear(self) -> None: ...
    def SetInParent(self) -> None: ...
    def IsInitialized(self) -> bool: ...
    def ParseFromString(self, serialized: bytes) -> int: ...
    def MergeFromString(self, serialized: bytes) -> int: ...
    def SerializeToString(self, *, deterministic: bool = ...) -> bytes: ...
    def SerializePartialToString(self, *, deterministic: bool = ...) -> bytes: ...
    def ListFields(self) -> __Sequence[__Tuple[__FieldDescriptor, __Any]]: ...
    def HasField(self, field_name: __Literal["package_id", "module_name", "entity_name"]) -> bool: ...
    def ClearField(self, field_name: __Literal["package_id", "module_name", "entity_name"]) -> None: ...
    def WhichOneof(self, oneof_group: __Void) -> __Void: ...
    def HasExtension(self, extension_handle: __Any) -> bool: ...
    def ClearExtension(self, extension_handle: __Any) -> None: ...
    def UnknownFields(self) -> __Any: ...
    def DiscardUnknownFields(self) -> None: ...
    def ByteSize(self) -> int: ...
    def _SetListener(self, message_listener: __Any) -> None: ...

class Variant(__Message):
    variant_id: Identifier
    constructor: str
    value: Value
    def __init__(self, *, variant_id: __Optional[Identifier] = ..., constructor: __Optional[str] = ..., value: __Optional[Value] = ...): ...
    def __eq__(self, other_msg: __Optional[__Any]) -> bool: ...
    def __str__(self) -> str: ...
    def __unicode__(self) -> str: ...
    def MergeFrom(self, other_msg: Variant) -> None: ...
    def Clear(self) -> None: ...
    def SetInParent(self) -> None: ...
    def IsInitialized(self) -> bool: ...
    def ParseFromString(self, serialized: bytes) -> int: ...
    def MergeFromString(self, serialized: bytes) -> int: ...
    def SerializeToString(self, *, deterministic: bool = ...) -> bytes: ...
    def SerializePartialToString(self, *, deterministic: bool = ...) -> bytes: ...
    def ListFields(self) -> __Sequence[__Tuple[__FieldDescriptor, __Any]]: ...
    def HasField(self, field_name: __Literal["variant_id", "constructor", "value"]) -> bool: ...
    def ClearField(self, field_name: __Literal["variant_id", "constructor", "value"]) -> None: ...
    def WhichOneof(self, oneof_group: __Void) -> __Void: ...
    def HasExtension(self, extension_handle: __Any) -> bool: ...
    def ClearExtension(self, extension_handle: __Any) -> None: ...
    def UnknownFields(self) -> __Any: ...
    def DiscardUnknownFields(self) -> None: ...
    def ByteSize(self) -> int: ...
    def _SetListener(self, message_listener: __Any) -> None: ...

class Enum(__Message):
    enum_id: Identifier
    constructor: str
    def __init__(self, *, enum_id: __Optional[Identifier] = ..., constructor: __Optional[str] = ...): ...
    def __eq__(self, other_msg: __Optional[__Any]) -> bool: ...
    def __str__(self) -> str: ...
    def __unicode__(self) -> str: ...
    def MergeFrom(self, other_msg: Enum) -> None: ...
    def Clear(self) -> None: ...
    def SetInParent(self) -> None: ...
    def IsInitialized(self) -> bool: ...
    def ParseFromString(self, serialized: bytes) -> int: ...
    def MergeFromString(self, serialized: bytes) -> int: ...
    def SerializeToString(self, *, deterministic: bool = ...) -> bytes: ...
    def SerializePartialToString(self, *, deterministic: bool = ...) -> bytes: ...
    def ListFields(self) -> __Sequence[__Tuple[__FieldDescriptor, __Any]]: ...
    def HasField(self, field_name: __Literal["enum_id", "constructor"]) -> bool: ...
    def ClearField(self, field_name: __Literal["enum_id", "constructor"]) -> None: ...
    def WhichOneof(self, oneof_group: __Void) -> __Void: ...
    def HasExtension(self, extension_handle: __Any) -> bool: ...
    def ClearExtension(self, extension_handle: __Any) -> None: ...
    def UnknownFields(self) -> __Any: ...
    def DiscardUnknownFields(self) -> None: ...
    def ByteSize(self) -> int: ...
    def _SetListener(self, message_listener: __Any) -> None: ...

class List(__Message):
    elements: __List[Value]
    def __init__(self, *, elements: __Optional[__Sequence[Value]] = ...): ...
    def __eq__(self, other_msg: __Optional[__Any]) -> bool: ...
    def __str__(self) -> str: ...
    def __unicode__(self) -> str: ...
    def MergeFrom(self, other_msg: List) -> None: ...
    def Clear(self) -> None: ...
    def SetInParent(self) -> None: ...
    def IsInitialized(self) -> bool: ...
    def ParseFromString(self, serialized: bytes) -> int: ...
    def MergeFromString(self, serialized: bytes) -> int: ...
    def SerializeToString(self, *, deterministic: bool = ...) -> bytes: ...
    def SerializePartialToString(self, *, deterministic: bool = ...) -> bytes: ...
    def ListFields(self) -> __Sequence[__Tuple[__FieldDescriptor, __Any]]: ...
    def HasField(self, field_name: __Literal["elements"]) -> bool: ...
    def ClearField(self, field_name: __Literal["elements"]) -> None: ...
    def WhichOneof(self, oneof_group: __Void) -> __Void: ...
    def HasExtension(self, extension_handle: __Any) -> bool: ...
    def ClearExtension(self, extension_handle: __Any) -> None: ...
    def UnknownFields(self) -> __Any: ...
    def DiscardUnknownFields(self) -> None: ...
    def ByteSize(self) -> int: ...
    def _SetListener(self, message_listener: __Any) -> None: ...

class Optional(__Message):
    value: Value
    def __init__(self, *, value: __Optional[Value] = ...): ...
    def __eq__(self, other_msg: __Optional[__Any]) -> bool: ...
    def __str__(self) -> str: ...
    def __unicode__(self) -> str: ...
    def MergeFrom(self, other_msg: Optional) -> None: ...
    def Clear(self) -> None: ...
    def SetInParent(self) -> None: ...
    def IsInitialized(self) -> bool: ...
    def ParseFromString(self, serialized: bytes) -> int: ...
    def MergeFromString(self, serialized: bytes) -> int: ...
    def SerializeToString(self, *, deterministic: bool = ...) -> bytes: ...
    def SerializePartialToString(self, *, deterministic: bool = ...) -> bytes: ...
    def ListFields(self) -> __Sequence[__Tuple[__FieldDescriptor, __Any]]: ...
    def HasField(self, field_name: __Literal["value"]) -> bool: ...
    def ClearField(self, field_name: __Literal["value"]) -> None: ...
    def WhichOneof(self, oneof_group: __Void) -> __Void: ...
    def HasExtension(self, extension_handle: __Any) -> bool: ...
    def ClearExtension(self, extension_handle: __Any) -> None: ...
    def UnknownFields(self) -> __Any: ...
    def DiscardUnknownFields(self) -> None: ...
    def ByteSize(self) -> int: ...
    def _SetListener(self, message_listener: __Any) -> None: ...

class Map(__Message):
    entries: __List[Map.Entry]
    def __init__(self, *, entries: __Optional[__Sequence[Map.Entry]] = ...): ...
    def __eq__(self, other_msg: __Optional[__Any]) -> bool: ...
    def __str__(self) -> str: ...
    def __unicode__(self) -> str: ...
    def MergeFrom(self, other_msg: Map) -> None: ...
    def Clear(self) -> None: ...
    def SetInParent(self) -> None: ...
    def IsInitialized(self) -> bool: ...
    def ParseFromString(self, serialized: bytes) -> int: ...
    def MergeFromString(self, serialized: bytes) -> int: ...
    def SerializeToString(self, *, deterministic: bool = ...) -> bytes: ...
    def SerializePartialToString(self, *, deterministic: bool = ...) -> bytes: ...
    def ListFields(self) -> __Sequence[__Tuple[__FieldDescriptor, __Any]]: ...
    def HasField(self, field_name: __Literal["entries"]) -> bool: ...
    def ClearField(self, field_name: __Literal["entries"]) -> None: ...
    def WhichOneof(self, oneof_group: __Void) -> __Void: ...
    def HasExtension(self, extension_handle: __Any) -> bool: ...
    def ClearExtension(self, extension_handle: __Any) -> None: ...
    def UnknownFields(self) -> __Any: ...
    def DiscardUnknownFields(self) -> None: ...
    def ByteSize(self) -> int: ...
    def _SetListener(self, message_listener: __Any) -> None: ...
    class Entry(__Message):
        key: str
        value: Value
        def __init__(self, *, key: __Optional[str] = ..., value: __Optional[Value] = ...): ...
        def __eq__(self, other_msg: __Optional[__Any]) -> bool: ...
        def __str__(self) -> str: ...
        def __unicode__(self) -> str: ...
        def MergeFrom(self, other_msg: Map.Entry) -> None: ...
        def Clear(self) -> None: ...
        def SetInParent(self) -> None: ...
        def IsInitialized(self) -> bool: ...
        def ParseFromString(self, serialized: bytes) -> int: ...
        def MergeFromString(self, serialized: bytes) -> int: ...
        def SerializeToString(self, *, deterministic: bool = ...) -> bytes: ...
        def SerializePartialToString(self, *, deterministic: bool = ...) -> bytes: ...
        def ListFields(self) -> __Sequence[__Tuple[__FieldDescriptor, __Any]]: ...
        def HasField(self, field_name: __Literal["key", "value"]) -> bool: ...
        def ClearField(self, field_name: __Literal["key", "value"]) -> None: ...
        def WhichOneof(self, oneof_group: __Void) -> __Void: ...
        def HasExtension(self, extension_handle: __Any) -> bool: ...
        def ClearExtension(self, extension_handle: __Any) -> None: ...
        def UnknownFields(self) -> __Any: ...
        def DiscardUnknownFields(self) -> None: ...
        def ByteSize(self) -> int: ...
        def _SetListener(self, message_listener: __Any) -> None: ...

class GenMap(__Message):
    entries: __List[Entry]
    def __init__(self, *, entries: __Optional[__Sequence[GenMap.Entry]] = ...): ...
    def __eq__(self, other_msg: __Optional[__Any]) -> bool: ...
    def __str__(self) -> str: ...
    def __unicode__(self) -> str: ...
    def MergeFrom(self, other_msg: GenMap) -> None: ...
    def Clear(self) -> None: ...
    def SetInParent(self) -> None: ...
    def IsInitialized(self) -> bool: ...
    def ParseFromString(self, serialized: bytes) -> int: ...
    def MergeFromString(self, serialized: bytes) -> int: ...
    def SerializeToString(self, *, deterministic: bool = ...) -> bytes: ...
    def SerializePartialToString(self, *, deterministic: bool = ...) -> bytes: ...
    def ListFields(self) -> __Sequence[__Tuple[__FieldDescriptor, __Any]]: ...
    def HasField(self, field_name: __Literal["entries"]) -> bool: ...
    def ClearField(self, field_name: __Literal["entries"]) -> None: ...
    def WhichOneof(self, oneof_group: __Void) -> __Void: ...
    def HasExtension(self, extension_handle: __Any) -> bool: ...
    def ClearExtension(self, extension_handle: __Any) -> None: ...
    def UnknownFields(self) -> __Any: ...
    def DiscardUnknownFields(self) -> None: ...
    def ByteSize(self) -> int: ...
    def _SetListener(self, message_listener: __Any) -> None: ...
    class Entry(__Message):
        key: Value
        value: Value
        def __init__(self, *, key: __Optional[Value] = ..., value: __Optional[Value] = ...): ...
        def __eq__(self, other_msg: __Optional[__Any]) -> bool: ...
        def __str__(self) -> str: ...
        def __unicode__(self) -> str: ...
        def MergeFrom(self, other_msg: GenMap.Entry) -> None: ...
        def Clear(self) -> None: ...
        def SetInParent(self) -> None: ...
        def IsInitialized(self) -> bool: ...
        def ParseFromString(self, serialized: bytes) -> int: ...
        def MergeFromString(self, serialized: bytes) -> int: ...
        def SerializeToString(self, *, deterministic: bool = ...) -> bytes: ...
        def SerializePartialToString(self, *, deterministic: bool = ...) -> bytes: ...
        def ListFields(self) -> __Sequence[__Tuple[__FieldDescriptor, __Any]]: ...
        def HasField(self, field_name: __Literal["key", "value"]) -> bool: ...
        def ClearField(self, field_name: __Literal["key", "value"]) -> None: ...
        def WhichOneof(self, oneof_group: __Void) -> __Void: ...
        def HasExtension(self, extension_handle: __Any) -> bool: ...
        def ClearExtension(self, extension_handle: __Any) -> None: ...
        def UnknownFields(self) -> __Any: ...
        def DiscardUnknownFields(self) -> None: ...
        def ByteSize(self) -> int: ...
        def _SetListener(self, message_listener: __Any) -> None: ...
