# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['cosmpy',
 'cosmpy.aerial',
 'cosmpy.aerial.client',
 'cosmpy.aerial.contract',
 'cosmpy.auth',
 'cosmpy.bank',
 'cosmpy.common',
 'cosmpy.cosmwasm',
 'cosmpy.crypto',
 'cosmpy.distribution',
 'cosmpy.evidence',
 'cosmpy.gov',
 'cosmpy.ibc',
 'cosmpy.ibc.applications.transfer',
 'cosmpy.ibc.core.channel',
 'cosmpy.ibc.core.client',
 'cosmpy.ibc.core.connection',
 'cosmpy.mint',
 'cosmpy.params',
 'cosmpy.protos',
 'cosmpy.protos.confio',
 'cosmpy.protos.cosmos',
 'cosmpy.protos.cosmos.auth',
 'cosmpy.protos.cosmos.auth.v1beta1',
 'cosmpy.protos.cosmos.authz',
 'cosmpy.protos.cosmos.authz.v1beta1',
 'cosmpy.protos.cosmos.bank',
 'cosmpy.protos.cosmos.bank.v1beta1',
 'cosmpy.protos.cosmos.base',
 'cosmpy.protos.cosmos.base.abci',
 'cosmpy.protos.cosmos.base.abci.v1beta1',
 'cosmpy.protos.cosmos.base.kv',
 'cosmpy.protos.cosmos.base.kv.v1beta1',
 'cosmpy.protos.cosmos.base.query',
 'cosmpy.protos.cosmos.base.query.v1beta1',
 'cosmpy.protos.cosmos.base.reflection',
 'cosmpy.protos.cosmos.base.reflection.v1beta1',
 'cosmpy.protos.cosmos.base.reflection.v2alpha1',
 'cosmpy.protos.cosmos.base.snapshots',
 'cosmpy.protos.cosmos.base.snapshots.v1beta1',
 'cosmpy.protos.cosmos.base.store',
 'cosmpy.protos.cosmos.base.store.v1beta1',
 'cosmpy.protos.cosmos.base.tendermint',
 'cosmpy.protos.cosmos.base.tendermint.v1beta1',
 'cosmpy.protos.cosmos.base.v1beta1',
 'cosmpy.protos.cosmos.capability',
 'cosmpy.protos.cosmos.capability.v1beta1',
 'cosmpy.protos.cosmos.crisis',
 'cosmpy.protos.cosmos.crisis.v1beta1',
 'cosmpy.protos.cosmos.crypto',
 'cosmpy.protos.cosmos.crypto.ed25519',
 'cosmpy.protos.cosmos.crypto.multisig',
 'cosmpy.protos.cosmos.crypto.multisig.v1beta1',
 'cosmpy.protos.cosmos.crypto.secp256k1',
 'cosmpy.protos.cosmos.crypto.secp256r1',
 'cosmpy.protos.cosmos.distribution',
 'cosmpy.protos.cosmos.distribution.v1beta1',
 'cosmpy.protos.cosmos.evidence',
 'cosmpy.protos.cosmos.evidence.v1beta1',
 'cosmpy.protos.cosmos.feegrant',
 'cosmpy.protos.cosmos.feegrant.v1beta1',
 'cosmpy.protos.cosmos.genutil',
 'cosmpy.protos.cosmos.genutil.v1beta1',
 'cosmpy.protos.cosmos.gov',
 'cosmpy.protos.cosmos.gov.v1beta1',
 'cosmpy.protos.cosmos.mint',
 'cosmpy.protos.cosmos.mint.v1beta1',
 'cosmpy.protos.cosmos.params',
 'cosmpy.protos.cosmos.params.v1beta1',
 'cosmpy.protos.cosmos.slashing',
 'cosmpy.protos.cosmos.slashing.v1beta1',
 'cosmpy.protos.cosmos.staking',
 'cosmpy.protos.cosmos.staking.v1beta1',
 'cosmpy.protos.cosmos.tx',
 'cosmpy.protos.cosmos.tx.signing',
 'cosmpy.protos.cosmos.tx.signing.v1beta1',
 'cosmpy.protos.cosmos.tx.v1beta1',
 'cosmpy.protos.cosmos.upgrade',
 'cosmpy.protos.cosmos.upgrade.v1beta1',
 'cosmpy.protos.cosmos.vesting',
 'cosmpy.protos.cosmos.vesting.v1beta1',
 'cosmpy.protos.cosmos_proto',
 'cosmpy.protos.cosmwasm',
 'cosmpy.protos.cosmwasm.wasm',
 'cosmpy.protos.cosmwasm.wasm.v1',
 'cosmpy.protos.gogoproto',
 'cosmpy.protos.google',
 'cosmpy.protos.google.api',
 'cosmpy.protos.google.protobuf',
 'cosmpy.protos.ibc',
 'cosmpy.protos.ibc.applications',
 'cosmpy.protos.ibc.applications.transfer',
 'cosmpy.protos.ibc.applications.transfer.v1',
 'cosmpy.protos.ibc.applications.transfer.v2',
 'cosmpy.protos.ibc.core',
 'cosmpy.protos.ibc.core.channel',
 'cosmpy.protos.ibc.core.channel.v1',
 'cosmpy.protos.ibc.core.client',
 'cosmpy.protos.ibc.core.client.v1',
 'cosmpy.protos.ibc.core.commitment',
 'cosmpy.protos.ibc.core.commitment.v1',
 'cosmpy.protos.ibc.core.connection',
 'cosmpy.protos.ibc.core.connection.v1',
 'cosmpy.protos.ibc.core.port',
 'cosmpy.protos.ibc.core.port.v1',
 'cosmpy.protos.ibc.core.types',
 'cosmpy.protos.ibc.core.types.v1',
 'cosmpy.protos.ibc.lightclients',
 'cosmpy.protos.ibc.lightclients.localhost',
 'cosmpy.protos.ibc.lightclients.localhost.v1',
 'cosmpy.protos.ibc.lightclients.solomachine',
 'cosmpy.protos.ibc.lightclients.solomachine.v1',
 'cosmpy.protos.ibc.lightclients.solomachine.v2',
 'cosmpy.protos.ibc.lightclients.tendermint',
 'cosmpy.protos.ibc.lightclients.tendermint.v1',
 'cosmpy.protos.tendermint',
 'cosmpy.protos.tendermint.abci',
 'cosmpy.protos.tendermint.crypto',
 'cosmpy.protos.tendermint.libs',
 'cosmpy.protos.tendermint.libs.bits',
 'cosmpy.protos.tendermint.p2p',
 'cosmpy.protos.tendermint.types',
 'cosmpy.protos.tendermint.version',
 'cosmpy.slashing',
 'cosmpy.staking',
 'cosmpy.tendermint',
 'cosmpy.tx',
 'cosmpy.upgrade']

package_data = \
{'': ['*']}

install_requires = \
['bech32',
 'bip-utils',
 'blspy',
 'ecdsa',
 'google-api-python-client',
 'grpcio==1.47.0',
 'jsonschema>=4.16.0,<5.0.0',
 'protobuf>=3.19.4,<4',
 'requests']

setup_kwargs = {
    'name': 'cosmpy',
    'version': '0.6.0',
    'description': 'A library for interacting with the cosmos networks',
    'long_description': '<h1 align="center">\n    <b>CosmPy</b>\n</h1>\n\n<p align="center">\n  <a href="https://pypi.org/project/cosmpy/">\n    <img alt="PyPI" src="https://img.shields.io/pypi/v/cosmpy">\n  </a>\n  <a href="https://pypi.org/project/cosmpy/">\n    <img alt="PyPI - Python Version" src="https://img.shields.io/pypi/pyversions/cosmpy">\n  </a>\n  <a>\n    <img alt="PyPI - Wheel" src="https://img.shields.io/pypi/wheel/cosmpy">\n  </a>\n  <a href="https://github.com/fetchai/cosmpy/blob/master/LICENSE">\n    <img alt="License" src="https://img.shields.io/pypi/l/cosmpy">\n  </a>\n</p>\n<p align="center">\n  <a href="https://github.com/fetchai/cosmpy/actions/workflows/workflow.yml">\n    <img alt="AEA framework sanity checks and tests" src="https://github.com/fetchai/cosmpy/actions/workflows/workflow.yml/badge.svg">\n  </a>\n  <a href="https://github.com/fetchai/cosmpy/actions/workflows/workflow.yml">\n    <img alt="Contributor Covenant" src="https://img.shields.io/badge/Contributor%20Covenant-2.1-4baaaa.svg">\n  </a>\n</p>\n\n<p align="center">\nA python library for interacting with cosmos based blockchain networks\n</p>\n\n## Installing\n\nTo install the library use:\n\n```bash\npip3 install cosmpy\n```\n\n## Getting Started\n\nBelow is a simple example for querying an account\'s balances:\n\n```python\nfrom cosmpy.aerial.client import LedgerClient, NetworkConfig\n\n# connect to Fetch.ai network using default parameters\nledger_client = LedgerClient(NetworkConfig.fetchai_mainnet())\n\nalice: str = \'fetch12q5gw9l9d0yyq2th77x6pjsesczpsly8h5089x\'\nbalances = ledger_client.query_bank_all_balances(alice)\n\n# show all coin balances\nfor coin in balances:\n  print(f\'{coin.amount}{coin.denom}\')\n```\n\n## Documentation\n\nBefore running this command make sure your development environment is set up. Check [Development setup](https://github.com/fetchai/cosmpy/blob/master/DEVELOPING.md#development-setup) for more details.\n\nTo see the documentation:\n\n```bash\nmake docs-live\n```\n\nThen navigate to the following URL in your browser:\n<!-- markdown-link-check-disable-next-line -->\n[http://127.0.0.1:8000/cosmpy/](http://127.0.0.1:8000/cosmpy/)\n\n## Examples\n\nUnder the `examples` directory, you can find examples of basic ledger interactions using `cosmpy` e.g. transferring tokens, staking, deploying and interacting with a smart contract, and performing atomic swaps.\n\n## To contribute\n\nPlease see [CONTRIBUTING](https://github.com/fetchai/cosmpy/blob/master/CONTRIBUTING.md) and [DEVELOPING](https://github.com/fetchai/cosmpy/blob/master/DEVELOPING.md) guides.\n\n## Extra Resources\n\n* [GitHub Repo](https://github.com/fetchai/cosmpy)\n* [Bug Reports](https://github.com/fetchai/cosmpy/issues)\n* [Discussions](https://github.com/fetchai/cosmpy/discussions)\n* [Getting Started](https://docs.fetch.ai/CosmPy/)\n',
    'author': 'Fetch.AI Limited',
    'author_email': 'None',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'None',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
