import { InstanceType } from '@aws-cdk/aws-ec2';
import * as cdk from '@aws-cdk/core';
import { BaseOS } from './scheduler';
/**
 * @experimental
 */
export interface WorkloadProps {
    /**
     * (experimental) S3 bucket with your SOCA installer.
     *
     * Name of your S3 Bucket where you uploaded your install files.
     *
     * @default - solutions-reference
     * @experimental
     */
    readonly s3InstallBucket?: string;
    /**
     * (experimental) Name of the S3 folder where you uploaded SOCA.
     *
     * @default - scale-out-computing-on-aws/v2.5.0
     * @experimental
     */
    readonly s3InstallFolder?: string;
    /**
     * (experimental) Linux distribution.
     *
     * @default - amazonlinux2
     * @experimental
     */
    readonly linuxDistribution?: BaseOS;
    /**
     * (experimental) Custom AMI if available.
     *
     * @default - no custom AMI
     * @experimental
     */
    readonly customAmi?: string;
    /**
     * (experimental) Instance type for your master host(scheduler).
     *
     * @default - m5.xlarge
     * @experimental
     */
    readonly instanceType?: InstanceType;
    /**
     * (experimental) VPC Cidr for the new VPC.
     *
     * @default - 10.0.0.0/16
     * @experimental
     */
    readonly vpcCidr?: string;
    /**
     * (experimental) Default IP(s) allowed to directly SSH into the scheduler and access ElasticSearch.
     *
     * 0.0.0.0/0 means
     * ALL INTERNET access. You probably want to change it with your own IP/subnet (x.x.x.x/32 for your own
     * ip or x.x.x.x/24 for range. Replace x.x.x.x with your own PUBLIC IP. You can get your public IP using
     * tools such as https://ifconfig.co/). Make sure to keep it restrictive!
     *
     * @default - not to add any client IP Cidr address
     * @experimental
     */
    readonly clientIpCidr?: string;
    /**
     * (experimental) Default SSH pem keys used to SSH into the scheduler.
     *
     * @experimental
     */
    readonly sshKeyName?: string;
    /**
     * (experimental) Username for your default LDAP user.
     *
     * @default - 'ldapUserName'
     * @experimental
     */
    readonly ldapUserName?: string;
    /**
     * (experimental) Password for your default LDAP user.
     *
     * @default - 'ldapUserPassword!123'
     * @experimental
     */
    readonly ldapUserPassword?: string;
}
/**
 * @experimental
 */
export declare class Workload extends cdk.Construct {
    /**
     * @experimental
     */
    constructor(scope: cdk.Construct, id: string, props?: WorkloadProps);
}
