## pySIPFENN
[![PyPI version](https://badge.fury.io/py/pysipfenn.svg)](https://badge.fury.io/py/pysipfenn)
[![Python 3.9](https://img.shields.io/badge/python-3.9-blue.svg)](https://www.python.org/downloads/release/python-390/)
[![Python 3.10](https://img.shields.io/badge/python-3.10-blue.svg)](https://www.python.org/downloads/release/python-3100/)

This repository contains 
**py**(**S**tructure-**I**nformed **P**rediction of 
**F**ormation **E**nergy using **N**eural **N**etworks) software 
package allowing efficient predictions of the energetics of 
atomic configurations. The underlying methodology and implementation
is given in

- Adam M. Krajewski, Jonathan W. Siegel, Jinchao Xu, Zi-Kui Liu,
Extensible Structure-Informed Prediction of Formation Energy with improved accuracy and usability employing neural networks,
Computational Materials Science,
Volume 208,
2022,
111254
(https://doi.org/10.1016/j.commatsci.2022.111254)

While functionalities are similar to the software released along the 
paper, this package contains improved methods for featurizing atomic 
configurations. Notably, all of them are now written completely in 
Python, removing reliance on Java and making extensions of the software
much easier thanks to improved readability. A fuller description of capabilities is given at PSU Phases 
Research Lab webpage under _phaseslab.com/sipfenn_.

