# mypy-boto3-cloudwatch

[![PyPI - mypy-boto3-cloudwatch](https://img.shields.io/pypi/v/mypy-boto3-cloudwatch.svg?color=blue)](https://pypi.org/project/mypy-boto3-cloudwatch)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-cloudwatch.svg?color=blue)](https://pypi.org/project/mypy-boto3-cloudwatch)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.CloudWatch 1.17.16](https://boto3.amazonaws.com/v1/documentation/api/1.17.16/reference/services/cloudwatch.html#CloudWatch) service
compatible with
[VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright)
and other tools.

Generated by [mypy-boto3-buider 4.4.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-cloudwatch](#mypy-boto3-cloudwatch)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Service Resource annotations](#service-resource-annotations)
    - [Other resources annotations](#other-resources-annotations)
    - [Collections annotations](#collections-annotations)
    - [Typed dictionations](#typed-dictionations)

## How to install

Install `boto3-stubs` for `CloudWatch` service.

```bash
python -m pip install boto3-stubs[cloudwatch]
```

## Usage

### VSCode

- Install [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[cloudwatch]` in your environment: `python -m pip install 'boto3-stubs[cloudwatch]'`

Both type checking and auto-complete should work for `CloudWatch` service.
No explicit type annotations required, write your `boto3` code as usual.

### PyCharm

- Install `boto-stubs[cloudwatch]` in your environment: `python -m pip install 'boto3-stubs[cloudwatch]'`

Both type checking and auto-complete should work for `CloudWatch` service.
No explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed `boto3-stubs` submodules.

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything should work.

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[cloudwatch]` in your environment: `python -m pip install 'boto3-stubs[cloudwatch]'`
- Run `mypy` as usual

Type checking should work for `CloudWatch` service.
No explicit type annotations required, write your `boto3` code as usual.

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[cloudwatch]` in your environment: `python -m pip install 'boto3-stubs[cloudwatch]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `CloudWatch` service.
No explicit type annotations required, write your `boto3` code as usual.

## Explicit type annotations

### Client annotations

`CloudWatchClient` provides annotations for `boto3.client("cloudwatch")`.

```python
import boto3

from mypy_boto3_cloudwatch import CloudWatchClient

client: CloudWatchClient = boto3.client("cloudwatch")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: CloudWatchClient = session.client("cloudwatch")
```

### Paginators annotations

`mypy_boto3_cloudwatch.paginator` module contains type annotations for all paginators.

```python
from mypy_boto3_cloudwatch import CloudWatchClient
from mypy_boto3_cloudwatch.paginator import (
    DescribeAlarmHistoryPaginator,
    DescribeAlarmsPaginator,
    GetMetricDataPaginator,
    ListDashboardsPaginator,
    ListMetricsPaginator,
)

client: CloudWatchClient = boto3.client("cloudwatch")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
describe_alarm_history_paginator: DescribeAlarmHistoryPaginator = client.get_paginator("describe_alarm_history")
describe_alarms_paginator: DescribeAlarmsPaginator = client.get_paginator("describe_alarms")
get_metric_data_paginator: GetMetricDataPaginator = client.get_paginator("get_metric_data")
list_dashboards_paginator: ListDashboardsPaginator = client.get_paginator("list_dashboards")
list_metrics_paginator: ListMetricsPaginator = client.get_paginator("list_metrics")
```


### Waiters annotations

`mypy_boto3_cloudwatch.waiter` module contains type annotations for all waiters.

```python
from mypy_boto3_cloudwatch import CloudWatchClient
from mypy_boto3_cloudwatch.waiter import (
    AlarmExistsWaiter,
    CompositeAlarmExistsWaiter,
)

client: CloudWatchClient = boto3.client("cloudwatch")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
alarm_exists_waiter: AlarmExistsWaiter = client.get_waiter("alarm_exists")
composite_alarm_exists_waiter: CompositeAlarmExistsWaiter = client.get_waiter("composite_alarm_exists")
```


### Service Resource annotations

`CloudWatchServiceResource` provides annotations for `boto3.resource("cloudwatch")`.

```python
from mypy_boto3_cloudwatch import CloudWatchServiceResource

resource: CloudWatchServiceResource = boto3.resource("cloudwatch")

# now resource usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_resource: CloudWatchServiceResource = session.resource("cloudwatch")
```


### Other resources annotations

`mypy_boto3_cloudwatch.service_resource` module contains type annotations for all resources.

```python
from mypy_boto3_cloudwatch import CloudWatchServiceResource
from mypy_boto3_cloudwatch.service_resource import (
    Alarm,
    Metric,
)

resource: CloudWatchServiceResource = boto3.resource("cloudwatch")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
my_alarm: Alarm = resource.Alarm(...)
my_metric: Metric = resource.Metric(...)
```



### Collections annotations

`mypy_boto3_cloudwatch.service_resource` module contains type annotations
for all `CloudWatchServiceResource` collections.

```python
from mypy_boto3_cloudwatch import CloudWatchServiceResource
from mypy_boto3_cloudwatch.service_resource import (
    ServiceResourceAlarmsCollection,
    ServiceResourceMetricsCollection,
)

resource: CloudWatchServiceResource = boto3.resource("cloudwatch")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
alarms: cloudwatch_resources.ServiceResourceAlarmsCollection = resource.alarms
metrics: cloudwatch_resources.ServiceResourceMetricsCollection = resource.metrics
```




### Typed dictionations

`mypy_boto3_cloudwatch.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_cloudwatch.type_defs import (
    AlarmHistoryItemTypeDef,
    AnomalyDetectorConfigurationTypeDef,
    AnomalyDetectorTypeDef,
    CompositeAlarmTypeDef,
    DashboardEntryTypeDef,
    DashboardValidationMessageTypeDef,
    DatapointTypeDef,
    DimensionTypeDef,
    InsightRuleContributorDatapointTypeDef,
    InsightRuleContributorTypeDef,
    InsightRuleMetricDatapointTypeDef,
    InsightRuleTypeDef,
    MessageDataTypeDef,
    MetricAlarmTypeDef,
    MetricDataQueryTypeDef,
    MetricDataResultTypeDef,
    MetricStatTypeDef,
    MetricTypeDef,
    PartialFailureTypeDef,
    RangeTypeDef,
    ResponseMetadata,
    StatisticSetTypeDef,
    TagTypeDef,
    DeleteInsightRulesOutputTypeDef,
    DescribeAlarmHistoryOutputTypeDef,
    DescribeAlarmsForMetricOutputTypeDef,
    DescribeAlarmsOutputTypeDef,
    DescribeAnomalyDetectorsOutputTypeDef,
    DescribeInsightRulesOutputTypeDef,
    DimensionFilterTypeDef,
    DisableInsightRulesOutputTypeDef,
    EnableInsightRulesOutputTypeDef,
    GetDashboardOutputTypeDef,
    GetInsightRuleReportOutputTypeDef,
    GetMetricDataOutputTypeDef,
    GetMetricStatisticsOutputTypeDef,
    GetMetricWidgetImageOutputTypeDef,
    LabelOptionsTypeDef,
    ListDashboardsOutputTypeDef,
    ListMetricsOutputTypeDef,
    ListTagsForResourceOutputTypeDef,
    MetricDatumTypeDef,
    PaginatorConfigTypeDef,
    PutDashboardOutputTypeDef,
    WaiterConfigTypeDef,
)

def get_structure() -> AlarmHistoryItemTypeDef:
    return {
      ...
    }
```
