/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, { enumerable: true, get: getter });
/******/ 		}
/******/ 	};
/******/
/******/ 	// define __esModule on exports
/******/ 	__webpack_require__.r = function(exports) {
/******/ 		if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 			Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 		}
/******/ 		Object.defineProperty(exports, '__esModule', { value: true });
/******/ 	};
/******/
/******/ 	// create a fake namespace object
/******/ 	// mode & 1: value is a module id, require it
/******/ 	// mode & 2: merge all properties of value into the ns
/******/ 	// mode & 4: return value when already ns object
/******/ 	// mode & 8|1: behave like require
/******/ 	__webpack_require__.t = function(value, mode) {
/******/ 		if(mode & 1) value = __webpack_require__(value);
/******/ 		if(mode & 8) return value;
/******/ 		if((mode & 4) && typeof value === 'object' && value && value.__esModule) return value;
/******/ 		var ns = Object.create(null);
/******/ 		__webpack_require__.r(ns);
/******/ 		Object.defineProperty(ns, 'default', { enumerable: true, value: value });
/******/ 		if(mode & 2 && typeof value != 'string') for(var key in value) __webpack_require__.d(ns, key, function(key) { return value[key]; }.bind(null, key));
/******/ 		return ns;
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = "./email_signals/src/ts/signal_change_form.ts");
/******/ })
/************************************************************************/
/******/ ({

/***/ "./email_signals/src/ts/components/auto_complete_input.ts":
/*!****************************************************************!*\
  !*** ./email_signals/src/ts/components/auto_complete_input.ts ***!
  \****************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
var __values = (undefined && undefined.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var dropdownListID = function (input) {
    var id = input.id;
    if (!id) {
        id = input.name;
    }
    return id + 'autocomplete-list';
};
var autocomplete = function (input, options) {
    var currentFocus = -1;
    var inputID = dropdownListID(input);
    input.addEventListener("input", function (event) {
        var e_1, _a;
        var value = event.target.value;
        closeAllLists();
        if (!value) {
            return;
        }
        var listDiv = document.createElement("DIV");
        listDiv.setAttribute("id", inputID);
        listDiv.setAttribute("class", "autocomplete-items");
        var parentNode = input.parentNode;
        parentNode.appendChild(listDiv);
        parentNode.style.overflow = 'unset';
        try {
            for (var options_1 = __values(options), options_1_1 = options_1.next(); !options_1_1.done; options_1_1 = options_1.next()) {
                var option = options_1_1.value;
                if (option.substr(0, value.length).toUpperCase() === value.toUpperCase()) {
                    var itemDiv = document.createElement("DIV");
                    itemDiv.innerHTML = "<strong>" + option.substr(0, value.length) + "</strong>";
                    itemDiv.innerHTML += option.substr(value.length);
                    itemDiv.innerHTML += "<input type=\"hidden\" value=\"".concat(option, "\">");
                    itemDiv.addEventListener("click", function (e) {
                        input.value = e.target.querySelector("input").value;
                        closeAllLists();
                    });
                    ;
                    listDiv.appendChild(itemDiv);
                }
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (options_1_1 && !options_1_1.done && (_a = options_1.return)) _a.call(options_1);
            }
            finally { if (e_1) throw e_1.error; }
        }
    });
    input.addEventListener("keydown", function (event) {
        var listOptions = document.getElementById(inputID);
        if (listOptions) {
            listOptions = listOptions.getElementsByTagName("div");
        }
        if (event.key == 'ArrowDown') {
            currentFocus++;
            addActive(listOptions);
        }
        else if (event.key == 'ArrowUp') {
            currentFocus--;
            addActive(listOptions);
        }
        else if (event.key == 'Enter') {
            event.preventDefault();
            if (currentFocus > -1) {
                if (listOptions[currentFocus]) {
                    listOptions[currentFocus].click();
                }
            }
        }
    });
    var addActive = function (listOptions) {
        removeActive(listOptions);
        if (currentFocus >= listOptions.length) {
            currentFocus = 0;
        }
        if (currentFocus < 0) {
            currentFocus = (listOptions.length - 1);
        }
        listOptions[currentFocus].classList.add("autocomplete-active");
    };
    var removeActive = function (listOptions) {
        for (var i = 0; i < listOptions.length; i++) {
            listOptions[i].classList.remove("autocomplete-active");
        }
    };
    var closeAllLists = function () {
        var lists = document.getElementsByClassName("autocomplete-items");
        for (var i = 0; i < lists.length; i++) {
            lists[i].parentNode.removeChild(lists[i]);
        }
    };
    document.addEventListener("click", closeAllLists);
};
/* harmony default export */ __webpack_exports__["default"] = (autocomplete);


/***/ }),

/***/ "./email_signals/src/ts/signal_change_form.ts":
/*!****************************************************!*\
  !*** ./email_signals/src/ts/signal_change_form.ts ***!
  \****************************************************/
/*! no exports provided */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _components_auto_complete_input__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./components/auto_complete_input */ "./email_signals/src/ts/components/auto_complete_input.ts");
var __read = (undefined && undefined.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (undefined && undefined.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};

var getAddNewRowBtn = function () {
    var newRowBtn = document.querySelectorAll('.add-row a');
    if (!newRowBtn.length) {
        newRowBtn = document.querySelectorAll('.grp-add-handler');
    }
    if (!newRowBtn.length) {
        console.warn('Could not find add new row button.');
    }
    return newRowBtn;
};
var ParamInputs = (function () {
    function ParamInputs() {
        var _this = this;
        this.inputsRegistry = {};
        this.deleteBtnsRegistry = new Set();
        this.inputRows = function () { return +document.querySelector('#id_constraints-TOTAL_FORMS').value; };
        this.addInput = function (input) {
            _this.inputsRegistry[input.name] = input;
        };
        this.deleteInput = function (input) {
            delete _this.inputsRegistry[input.name];
        };
        this.getInput = function (name) {
            return _this.inputsRegistry[name];
        };
        this.inputList = function () {
            return Object.values(_this.inputsRegistry);
        };
        this.flushRegistry = function () {
            _this.inputsRegistry = {};
            _this.deleteBtnsRegistry = new Set();
        };
        this.registerDeleteBtns = function () {
            var deleteBtns = document.querySelectorAll('.inline-deletelink');
            for (var i = 0; i < deleteBtns.length; i++) {
                var btn = deleteBtns[i];
                if (!_this.deleteBtnsRegistry.has(btn)) {
                    _this.deleteBtnsRegistry.add(btn);
                    btn.addEventListener('click', _this.rebuildAll);
                }
            }
        };
        this.addInputsToRegistry = function () {
            for (var i = 0; i < _this.inputRows(); i++) {
                var param_1 = document.querySelector("#id_constraints-".concat(i, "-param_1"));
                var param_2 = document.querySelector("#id_constraints-".concat(i, "-param_2"));
                if (param_1) {
                    _this.addInput(param_1);
                }
                if (param_2) {
                    _this.addInput(param_2);
                }
            }
        };
        this.setDeleteBtnEventListeners = function () {
            _this.deleteBtnsRegistry.forEach(function (btn) {
                btn.removeEventListener('click', _this.rebuildAll);
                btn.addEventListener('click', _this.rebuildAll);
            });
        };
        this.setNewRowEventListener = function () {
            var addNewRowBtn = getAddNewRowBtn();
            if (!addNewRowBtn) {
                console.warn('Could not find the add new row button. Auto complete feature will not work.');
                return;
            }
            addNewRowBtn.forEach(function (btn) { return btn.addEventListener('click', _this.rebuildAll); });
        };
        this.rebuildAll = function () {
            _this.flushRegistry();
            _this.addInputsToRegistry();
            _this.registerDeleteBtns();
            _this.setDeleteBtnEventListeners();
        };
        this.setNewRowEventListener();
        this.rebuildAll();
    }
    return ParamInputs;
}());
var ContentTypeSetup = (function () {
    function ContentTypeSetup(inputElems) {
        var _this = this;
        this.CONTENT_TYPE_SELECT_ELEM = document.getElementById('id_content_type');
        this.MODEL_ATTRS_API_URL = document.getElementById('model_attrs_api_url').value;
        this.inputOptions = [];
        this.setInputOptions = function () {
            return _this.callApi()
                .then(function (data) {
                _this.inputOptions = _this.getAvailableInputs(data);
                _this.inputElems().forEach(function (input) {
                    Object(_components_auto_complete_input__WEBPACK_IMPORTED_MODULE_0__["default"])(input, _this.inputOptions);
                });
            });
        };
        this.getContentTypeId = function () { return _this.CONTENT_TYPE_SELECT_ELEM.value; };
        this.callApi = function () {
            var url = _this.MODEL_ATTRS_API_URL.replace('<content_type_id>', _this.getContentTypeId());
            return fetch(url)
                .then(function (response) { return response.json(); })
                .then(function (data) { return data; });
        };
        this.getAvailableInputs = function (all_inputs, prefix) {
            if (prefix === void 0) { prefix = null; }
            var options = [];
            for (var key in all_inputs) {
                var _prefix = prefix ? "".concat(prefix, ".").concat(key) : key;
                options.push(_prefix);
                if (Object.keys(all_inputs[key]).length) {
                    options.push.apply(options, __spreadArray([], __read(_this.getAvailableInputs(all_inputs[key], _prefix)), false));
                }
            }
            return options;
        };
        this.hasModelAttrsUrl = this.MODEL_ATTRS_API_URL.length > 0;
        this.inputElems = inputElems;
        this.setInputOptions();
    }
    ContentTypeSetup.prototype.setUpEventListener = function () {
        var _this = this;
        if (!this.hasModelAttrsUrl)
            return;
        this.CONTENT_TYPE_SELECT_ELEM.addEventListener('change', this.setInputOptions);
        var newRowBtn = getAddNewRowBtn();
        if (newRowBtn) {
            newRowBtn.forEach(function (btn) { return btn.addEventListener('click', _this.setInputOptions); });
        }
    };
    return ContentTypeSetup;
}());
setTimeout(function () {
    var paramInputs = new ParamInputs();
    new ContentTypeSetup(paramInputs.inputList).setUpEventListener();
}, 500);


/***/ })

/******/ });
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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