#!/usr/bin/env python3
#
# GlobalChem - Chemicals From Biomass
#
# -----------------------------------

class ChemicalsFromBioMass(object):

    def __init__(self):

        self.name = 'chemicals_from_biomass'

    @staticmethod
    def get_smiles():

        '''

        Missing Entries:
             '8:2 chlorinated polyfluorinated ether sulfonic acid': '',

        '''

        smiles = {
            'synthesis gas': '[C-]#[O+].[HH]',
            'ethane': 'CC',
            'ethylene': 'C=C',
            'propylene': 'CC=C',
            '1,3-butadiene': 'C=CC=C',
            'butene': 'CCC=C',
            'butane': 'CCCC',
            'dicyclopentadiene': 'C1C=CC2C1C3CC2C=C3',
            'isoprene': 'CC(=C)C=C',
            'pentene': 'CCCC=C',
            'piperylene': 'CC=CC=C',
            'benzene': 'C1=CC=CC=C1',
            'toluene': 'CC1=CC=CC=C1',
            'p-xylene': 'CC1=CC=C(C=C1)C',
            'o-xylene': 'CC1=CC=CC=C1C',
            'm-xylene': 'CC1=CC(=CC=C1)C',
            'glycerol': 'C(C(CO)O)O',
        }

        return smiles

    @staticmethod
    def get_smarts():

        smarts = {
            'synthesis gas':'[#6-]#[#8+].[HH]',
            'ethane':'[#6]-[#6]',
            'ethylene':'[#6]=[#6]',
            'propylene':'[#6]-[#6]=[#6]',
            '1,3-butadiene':'[#6]=[#6]-[#6]=[#6]',
            'butene':'[#6]-[#6]-[#6]=[#6]',
            'butane':'[#6]-[#6]-[#6]-[#6]',
            'dicyclopentadiene':'[#6]1-[#6]=[#6]-[#6]2-[#6]-1-[#6]1-[#6]-[#6]-2-[#6]=[#6]-1',
            'isoprene':'[#6]-[#6](=[#6])-[#6]=[#6]',
            'pentene':'[#6]-[#6]-[#6]-[#6]=[#6]',
            'piperylene':'[#6]-[#6]=[#6]-[#6]=[#6]',
            'benzene':'[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'toluene':'[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'p-xylene':'[#6]-[#6]1:[#6]:[#6]:[#6](:[#6]:[#6]:1)-[#6]',
            'o-xylene':'[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1-[#6]',
            'm-xylene':'[#6]-[#6]1:[#6]:[#6](:[#6]:[#6]:[#6]:1)-[#6]',
            'glycerol':'[#6](-[#6](-[#6]-[#8])-[#8])-[#8]',
        }

        return smarts

    @staticmethod
    def get_bit_vector():

        bit_vector = {
            'synthesis gas':'00000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010100000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000',
            'ethane':'00000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000',
            'ethylene':'00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000',
            'propylene':'00000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000001001000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000',
            '1,3-butadiene':'00000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000',
            'butene':'00000000000000000000000000000000010000000000000000000000000000000000000000000000100000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000101000000000000000000000000000000000000000000000000000000000000000000000000000000000',
            'butane':'00000000000000000000000000000000010000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000',
            'dicyclopentadiene':'00001000000000000000000000000000100000000000000000000000000100000000000000000000000000100000000000000000100000100000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000001000000000000000001000000000000000000000000000000000000000000000000000000000000000000011000000000000000000000000000100100000000000000000000000000000000000000000010010000000000000000000000000000000000000000000000000000000000000000000000000100000000000010000010000',
            'isoprene':'00000000000000000000000000000000010000000000000000000000000000000000000000000000001000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000010000000000000000000000000000000000000000000000000000000001000010',
            'pentene':'00000010000000000000000000000000010000001000000000000000000000000000000000000000100000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000010000000000000000000000000000000000000000000000010000000000000000010000000000000000000000000000000000000000100000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000',
            'piperylene':'00000000000000000001000000000000010000000000000000000000000000000000000000000000000000000000000000000000000001000000000010000000000000000000000000000000000000000000000000000000000000100000000010000000000000001000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000100000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000',
            'benzene':'00000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000',
            'toluene':'00000000000000000000000000000001010000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000010000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000001000000000000000000100000000000000000000000000010000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000',
            'p-xylene':'00000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000001000000000000000000001000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000001000000000000000000100000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000',
            'o-xylene':'00000000000000000000000000000000010000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000010000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000100000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000100000000',
            'm-xylene':'00000000000000010000000000000001010000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000001000000000000000000100000010000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000',
            'glycerol':'01000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000100000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000001100000000000000000001000000000',
        }

        return bit_vector
