#!/usr/bin/env python3
#
# GlobalChem - Phase 2 Hetereocyclic Rings
#
# ----------------------------------------

class Phase2HetereoCyclicRings(object):

    def __init__(self):

        self.name = 'phase2_hetereo_cyclic_rings'

    @staticmethod
    def get_smiles():

        smiles = {
            'pyridine': 'C1=CC=NC=C1',
            'indole': 'C12=CC=CC=C1C=CN2',
            'imidazole': 'C1=CN=CN1',
            'thiazol-2-amine': 'NC1=NC=CS1',
            'tetrazole': 'C1=NN=NN1',
            '1,2,4-triazole': 'C1=NC=NN1',
            'thiophene': 'C1=CC=CS1',
            'cytosine': 'O=C1N=C(N)C=CN1',
            'adenine': 'NC1=NC=NC2=C1N=CN2',
            '5-methylindole': 'CC1=CC=C2C(C=CN2)=C1',
            'isocaffeine': 'O=C(N1C)NC2=C(N=CN2)C1=O',
            'tetrazolethiol': 'SN1N=NN=C1',
            '3-methylisoxazole': 'C1=CC=NO1',
            '1-methylimidazole': 'CN1C=NC=C1',
            '2-methylimidazole': 'CC1=NC=CN1',
            'guanine': 'NC(N1)=NC2=C(N=CN2)C1=O',
            'quinoline': 'C12=CC=CC=C1N=CC=C2',
            'furan': 'C1=CC=CO1',
            'tosufloxacin': 'NC1=C(F)C=C2C(NC=C(C(O)=O)C2=O)=N1'
        }

        return smiles

    @staticmethod
    def get_smarts():

        smarts = {
            'pyridine': '[#6]1:[#6]:[#6]:[#7]:[#6]:[#6]:1',
            'indole': '[#6]12:[#6]:[#6]:[#6]:[#6]:[#6]:1:[#6]:[#6]:[#7H]:2',
            'imidazole': '[#6]1:[#6]:[#7]:[#6]:[#7H]:1',
            'thiazol-2-amine': '[#7]-[#6]1:[#7]:[#6]:[#6]:[#16]:1',
            'tetrazole': '[#6]1:[#7]:[#7]:[#7]:[#7H]:1',
            '1,2,4-triazole': '[#6]1:[#7]:[#6]:[#7]:[#7H]:1',
            'thiophene': '[#6]1:[#6]:[#6]:[#6]:[#16]:1',
            'cytosine': '[#8]=[#6]1:[#7]:[#6](-[#7]):[#6]:[#6]:[#7H]:1',
            'adenine': '[#7]-[#6]1:[#7]:[#6]:[#7]:[#6]2:[#6]:1:[#7]:[#6]:[#7H]:2',
            '5-methylindole': '[#6]-[#6]1:[#6]:[#6]:[#6]2:[#6](:[#6]:[#6]:[#7H]:2):[#6]:1',
            'isocaffeine': '[#8]=[#6]1:[#7](-[#6]):[#6](:[#6]2:[#6](:[#7H]:1):[#7H]:[#6]:[#7]:2)=[#8]',
            'tetrazolethiol': '[#16]-[#7]1:[#7]:[#7]:[#7]:[#6]:1',
            '3-methylisoxazole': '[#6]1:[#6]:[#6]:[#7]:[#8]:1',
            '1-methylimidazole': '[#6]-[#7]1:[#6]:[#7]:[#6]:[#6]:1',
            '2-methylimidazole': '[#6]-[#6]1:[#7]:[#6]:[#6]:[#7H]:1',
            'guanine': '[#7]-[#6]1:[#7H]:[#6](:[#6]2:[#6](:[#7]:1):[#7H]:[#6]:[#7]:2)=[#8]',
            'quinoline': '[#6]12:[#6]:[#6]:[#6]:[#6]:[#6]:1:[#7]:[#6]:[#6]:[#6]:2',
            'furan': '[#6]1:[#6]:[#6]:[#6]:[#8]:1',
            'tosufloxacin': '[#7]-[#6]1:[#6](-[#9]):[#6]:[#6]2:[#6](:[#7H]:[#6]:[#6](-[#6](-[#8])=[#8]):[#6]:2=[#8]):[#7]:1',
        }

        return smarts

    @staticmethod
    def get_bit_vector():

        bit_vector = {
            'pyridine': '00000000000000000000000000000000000000000000000000000000000000001001000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000001000000000000000000000000000000000000000010000100000100000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000',
            'indole': '00000000001000000000000000000000000000000000000000000000000000011000000000000000000000000010000000000000000000000000000100000000000000000000000000000000000000000000000000000001000000000000000000000001000000000000001000000000000000000000000000000001000000000000000000000000000000000000000000000010000000000000000000000001000000100000000001000000000000000000100000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000010000000000000000100000000000000000000000000000',
            'imidazole': '00000000000000000000000000000000000000000000000000000000000000000001000000000000000000000010000000000000100000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000001000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000010000001000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000100100000000000000000000000000',
            'thiazol-2-amine': '00000000000000100000000000000001000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000100000000010000001000000000000000000100000000000000000000010000000000010010000000000000000000000000000000000100001000000000000000000000000000000000000000000000000000000000000000000000000000000',
            'tetrazole': '00000000000000000000000000001000000000000000000000000000000000000000000000000000100000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010010000000000000010000000000000000000000000000000000000000001000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000010000000000000000000000001000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001',
            '1,2,4-triazole': '00000000000000000000000000000000000000000000000000000000000000000001000000000000000010000010000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000001000000000000000000000000000000000000000010000000000000000001000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000010000000000000000001000',
            'thiophene': '00000000000000100000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000001000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000',
            'cytosine': '00000000000000000000000000000000000000000000000000000000000000100000000000000000000000000010000000000000000000000000000000000000100000000010000000010000000000000000000000000000000000000000000000000001000000001000001000000000000000000000000000000000000000010010000000000000000000000000000000000010000000000000000000100001000000000000000001000000000000000000100000000000000000000010000000000000000010000000000000000000000000001000000001000000000000000000000000000000000000000000000000100000000000000000000000000000',
            'adenine': '00000000000000000000000000000000000010000000000000000000000000000000000000000000000000000010000000000000000000000000000100000000100000000000000000010000000000000000000000000000000000000000100000000000010000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000010001000000000000000000000001000000000000001000000000000000000100000000000000000000010000000000000000000000000000000000000000000000000100001010000000000000010000000000000000000010000000000000000110000000000000000000000',
            '5-methylindole': '00000000001000000000000000100000010000000000000000000000000000000000000000000000000000000010000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000010000000000001000000000000001000000000000000000001000000000000000000000000000000000000000000000000000100000010000000000000000000000001000000100000000001000000000000000000100000010000000000000000000000000000000000000001000000000000100000000000000000000000000000000000000000000000010000000000000000100000000000000000010000000000',
            'isocaffeine': '00000001000000000000000000000000010000000000000000001000000000000000000000000000000000000010000000000000000000000000000001000000000010000010000000000000000000000000000000000000001000000000100000000000010000000100000000000000000000000000000100000010000000000000000000000000000000000000000000000010000000000000000010100000001000000000000001000000000000000000100000000000000000000010001000000000000000000000000000000000000000010000100000000000000000000000000000000000000000010000000000000100000000000000000010000010',
            'tetrazolethiol': '00000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000100000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000010000000000000001000000000001000000000000001000000000000000001000000000000000000000000000000000100000000000000000000000000000000000000000000000010000001000000000000000000000000000000000000000010000000000000000000000100000000000000000010010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000',
            '3-methylisoxazole': '00000000001000000000000000000000000000000000000000010000000000001000000000000000000000000000100000000000000000000000000000000000000000000000000010000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000010000001000000000000000000010000000000000001000010000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000',
            '1-methylimidazole': '00000000000000000000000000000000010000000000000000000000000000000001000000000100000000000000000000000000000000000000001101000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000011000001000000000000000000000000000000000000000010000000000000000000000000000000000000000010010000000000000010000000000000000000000000000000000000000000000000000000000000000000000000',
            '2-methylimidazole': '00000000000000000000000000000000010000000000000000000000000000000000000000000000000000010010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000100010000001000001000000000000100000000000000000000010000000000000000000000000000000000001000000000000100000000000000000000000000000000000000000000000000000100100000000000000000000000000',
            'guanine': '00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000001000000000001000000100000000010000000010000000000000000000000000000000000000100100000000000010000000100000000000000000000000000001000000000000000000000000000000000000000000000000000000010001000000000000000100001001000000000001001000000000000000000100000000000000000000010000000000000000000000000000000000000000000000000100001000000010000000000000000000000000000010000000000000000000000000000000000001000',
            'quinoline': '00000000000000000001000000000000000000000000000000000000000000011000000001000000000000000000000000000100000000000001000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000001000000000010000001000000000000000000100000001000000000000010000000000000000000000000000000000000000000000000100000000000000000001000000000000000000000000000000000000000000000000000000000000000',
            'furan': '00000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000011000000000000000000000100000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000',
            'tosufloxacin': '00000000100001000000000100000000000000000000000000000000010000000000000000000000000001000010000000000000000000000000000000000000100000000010000000010000000000000000000000000000000000000001000001000000000000000000000100000000000000000000000000000000000000000000000000000000000000000001000000000011000000001000100000100001000000000000010001000001100000000000100000010000000000000010010000000100100000000000000010000000000000000000000001010000000000000000000110000000000000000010000000000000000000000000000000000000',
        }

        return bit_vector