from enum import Enum
from ..base import District, Province, VietNamDivisionType


class ProvinceEnum(Enum):
    """
    Province Enum type, which is convenient for fast looking up Province by its numeric code.

    We cannot use tuple syntax here, because Enum cannot set member attributes from tuple syntax
    if one field is string.
    """

    P_1 = Province("Thành phố Hà Nội", 1, VietNamDivisionType.THANH_PHO_TRUNG_UONG, "thanh_pho_ha_noi", 24)
    P_2 = Province("Tỉnh Hà Giang", 2, VietNamDivisionType.TINH, "tinh_ha_giang", 219)
    P_4 = Province("Tỉnh Cao Bằng", 4, VietNamDivisionType.TINH, "tinh_cao_bang", 206)
    P_6 = Province("Tỉnh Bắc Kạn", 6, VietNamDivisionType.TINH, "tinh_bac_kan", 209)
    P_8 = Province("Tỉnh Tuyên Quang", 8, VietNamDivisionType.TINH, "tinh_tuyen_quang", 207)
    P_10 = Province("Tỉnh Lào Cai", 10, VietNamDivisionType.TINH, "tinh_lao_cai", 214)
    P_11 = Province("Tỉnh Điện Biên", 11, VietNamDivisionType.TINH, "tinh_dien_bien", 215)
    P_12 = Province("Tỉnh Lai Châu", 12, VietNamDivisionType.TINH, "tinh_lai_chau", 213)
    P_14 = Province("Tỉnh Sơn La", 14, VietNamDivisionType.TINH, "tinh_son_la", 212)
    P_15 = Province("Tỉnh Yên Bái", 15, VietNamDivisionType.TINH, "tinh_yen_bai", 216)
    P_17 = Province("Tỉnh Hoà Bình", 17, VietNamDivisionType.TINH, "tinh_hoa_binh", 218)
    P_19 = Province("Tỉnh Thái Nguyên", 19, VietNamDivisionType.TINH, "tinh_thai_nguyen", 208)
    P_20 = Province("Tỉnh Lạng Sơn", 20, VietNamDivisionType.TINH, "tinh_lang_son", 205)
    P_22 = Province("Tỉnh Quảng Ninh", 22, VietNamDivisionType.TINH, "tinh_quang_ninh", 203)
    P_24 = Province("Tỉnh Bắc Giang", 24, VietNamDivisionType.TINH, "tinh_bac_giang", 204)
    P_25 = Province("Tỉnh Phú Thọ", 25, VietNamDivisionType.TINH, "tinh_phu_tho", 210)
    P_26 = Province("Tỉnh Vĩnh Phúc", 26, VietNamDivisionType.TINH, "tinh_vinh_phuc", 211)
    P_27 = Province("Tỉnh Bắc Ninh", 27, VietNamDivisionType.TINH, "tinh_bac_ninh", 222)
    P_30 = Province("Tỉnh Hải Dương", 30, VietNamDivisionType.TINH, "tinh_hai_duong", 220)
    P_31 = Province("Thành phố Hải Phòng", 31, VietNamDivisionType.THANH_PHO_TRUNG_UONG, "thanh_pho_hai_phong", 225)
    P_33 = Province("Tỉnh Hưng Yên", 33, VietNamDivisionType.TINH, "tinh_hung_yen", 221)
    P_34 = Province("Tỉnh Thái Bình", 34, VietNamDivisionType.TINH, "tinh_thai_binh", 227)
    P_35 = Province("Tỉnh Hà Nam", 35, VietNamDivisionType.TINH, "tinh_ha_nam", 226)
    P_36 = Province("Tỉnh Nam Định", 36, VietNamDivisionType.TINH, "tinh_nam_dinh", 228)
    P_37 = Province("Tỉnh Ninh Bình", 37, VietNamDivisionType.TINH, "tinh_ninh_binh", 229)
    P_38 = Province("Tỉnh Thanh Hóa", 38, VietNamDivisionType.TINH, "tinh_thanh_hoa", 237)
    P_40 = Province("Tỉnh Nghệ An", 40, VietNamDivisionType.TINH, "tinh_nghe_an", 238)
    P_42 = Province("Tỉnh Hà Tĩnh", 42, VietNamDivisionType.TINH, "tinh_ha_tinh", 239)
    P_44 = Province("Tỉnh Quảng Bình", 44, VietNamDivisionType.TINH, "tinh_quang_binh", 232)
    P_45 = Province("Tỉnh Quảng Trị", 45, VietNamDivisionType.TINH, "tinh_quang_tri", 233)
    P_46 = Province("Tỉnh Thừa Thiên Huế", 46, VietNamDivisionType.TINH, "tinh_thua_thien_hue", 234)
    P_48 = Province("Thành phố Đà Nẵng", 48, VietNamDivisionType.THANH_PHO_TRUNG_UONG, "thanh_pho_da_nang", 236)
    P_49 = Province("Tỉnh Quảng Nam", 49, VietNamDivisionType.TINH, "tinh_quang_nam", 235)
    P_51 = Province("Tỉnh Quảng Ngãi", 51, VietNamDivisionType.TINH, "tinh_quang_ngai", 255)
    P_52 = Province("Tỉnh Bình Định", 52, VietNamDivisionType.TINH, "tinh_binh_dinh", 256)
    P_54 = Province("Tỉnh Phú Yên", 54, VietNamDivisionType.TINH, "tinh_phu_yen", 257)
    P_56 = Province("Tỉnh Khánh Hòa", 56, VietNamDivisionType.TINH, "tinh_khanh_hoa", 258)
    P_58 = Province("Tỉnh Ninh Thuận", 58, VietNamDivisionType.TINH, "tinh_ninh_thuan", 259)
    P_60 = Province("Tỉnh Bình Thuận", 60, VietNamDivisionType.TINH, "tinh_binh_thuan", 252)
    P_62 = Province("Tỉnh Kon Tum", 62, VietNamDivisionType.TINH, "tinh_kon_tum", 260)
    P_64 = Province("Tỉnh Gia Lai", 64, VietNamDivisionType.TINH, "tinh_gia_lai", 269)
    P_66 = Province("Tỉnh Đắk Lắk", 66, VietNamDivisionType.TINH, "tinh_dak_lak", 262)
    P_67 = Province("Tỉnh Đắk Nông", 67, VietNamDivisionType.TINH, "tinh_dak_nong", 261)
    P_68 = Province("Tỉnh Lâm Đồng", 68, VietNamDivisionType.TINH, "tinh_lam_dong", 263)
    P_70 = Province("Tỉnh Bình Phước", 70, VietNamDivisionType.TINH, "tinh_binh_phuoc", 271)
    P_72 = Province("Tỉnh Tây Ninh", 72, VietNamDivisionType.TINH, "tinh_tay_ninh", 276)
    P_74 = Province("Tỉnh Bình Dương", 74, VietNamDivisionType.TINH, "tinh_binh_duong", 274)
    P_75 = Province("Tỉnh Đồng Nai", 75, VietNamDivisionType.TINH, "tinh_dong_nai", 251)
    P_77 = Province("Tỉnh Bà Rịa - Vũng Tàu", 77, VietNamDivisionType.TINH, "tinh_ba_ria_vung_tau", 254)
    P_79 = Province("Thành phố Hồ Chí Minh", 79, VietNamDivisionType.THANH_PHO_TRUNG_UONG, "thanh_pho_ho_chi_minh", 28)
    P_80 = Province("Tỉnh Long An", 80, VietNamDivisionType.TINH, "tinh_long_an", 272)
    P_82 = Province("Tỉnh Tiền Giang", 82, VietNamDivisionType.TINH, "tinh_tien_giang", 273)
    P_83 = Province("Tỉnh Bến Tre", 83, VietNamDivisionType.TINH, "tinh_ben_tre", 275)
    P_84 = Province("Tỉnh Trà Vinh", 84, VietNamDivisionType.TINH, "tinh_tra_vinh", 294)
    P_86 = Province("Tỉnh Vĩnh Long", 86, VietNamDivisionType.TINH, "tinh_vinh_long", 270)
    P_87 = Province("Tỉnh Đồng Tháp", 87, VietNamDivisionType.TINH, "tinh_dong_thap", 277)
    P_89 = Province("Tỉnh An Giang", 89, VietNamDivisionType.TINH, "tinh_an_giang", 296)
    P_91 = Province("Tỉnh Kiên Giang", 91, VietNamDivisionType.TINH, "tinh_kien_giang", 297)
    P_92 = Province("Thành phố Cần Thơ", 92, VietNamDivisionType.THANH_PHO_TRUNG_UONG, "thanh_pho_can_tho", 292)
    P_93 = Province("Tỉnh Hậu Giang", 93, VietNamDivisionType.TINH, "tinh_hau_giang", 293)
    P_94 = Province("Tỉnh Sóc Trăng", 94, VietNamDivisionType.TINH, "tinh_soc_trang", 299)
    P_95 = Province("Tỉnh Bạc Liêu", 95, VietNamDivisionType.TINH, "tinh_bac_lieu", 291)
    P_96 = Province("Tỉnh Cà Mau", 96, VietNamDivisionType.TINH, "tinh_ca_mau", 290)


class ProvinceDEnum(Enum):
    """
    Province Enum type, whose member name is more descriptive, with province name.

    It helps developer have more idea what Province he is selecting.
    """

    HA_NOI = ProvinceEnum.P_1.value
    HA_GIANG = ProvinceEnum.P_2.value
    CAO_BANG = ProvinceEnum.P_4.value
    BAC_KAN = ProvinceEnum.P_6.value
    TUYEN_QUANG = ProvinceEnum.P_8.value
    LAO_CAI = ProvinceEnum.P_10.value
    DIEN_BIEN = ProvinceEnum.P_11.value
    LAI_CHAU = ProvinceEnum.P_12.value
    SON_LA = ProvinceEnum.P_14.value
    YEN_BAI = ProvinceEnum.P_15.value
    HOA_BINH = ProvinceEnum.P_17.value
    THAI_NGUYEN = ProvinceEnum.P_19.value
    LANG_SON = ProvinceEnum.P_20.value
    QUANG_NINH = ProvinceEnum.P_22.value
    BAC_GIANG = ProvinceEnum.P_24.value
    PHU_THO = ProvinceEnum.P_25.value
    VINH_PHUC = ProvinceEnum.P_26.value
    BAC_NINH = ProvinceEnum.P_27.value
    HAI_DUONG = ProvinceEnum.P_30.value
    HAI_PHONG = ProvinceEnum.P_31.value
    HUNG_YEN = ProvinceEnum.P_33.value
    THAI_BINH = ProvinceEnum.P_34.value
    HA_NAM = ProvinceEnum.P_35.value
    NAM_DINH = ProvinceEnum.P_36.value
    NINH_BINH = ProvinceEnum.P_37.value
    THANH_HOA = ProvinceEnum.P_38.value
    NGHE_AN = ProvinceEnum.P_40.value
    HA_TINH = ProvinceEnum.P_42.value
    QUANG_BINH = ProvinceEnum.P_44.value
    QUANG_TRI = ProvinceEnum.P_45.value
    THUA_THIEN_HUE = ProvinceEnum.P_46.value
    DA_NANG = ProvinceEnum.P_48.value
    QUANG_NAM = ProvinceEnum.P_49.value
    QUANG_NGAI = ProvinceEnum.P_51.value
    BINH_DINH = ProvinceEnum.P_52.value
    PHU_YEN = ProvinceEnum.P_54.value
    KHANH_HOA = ProvinceEnum.P_56.value
    NINH_THUAN = ProvinceEnum.P_58.value
    BINH_THUAN = ProvinceEnum.P_60.value
    KON_TUM = ProvinceEnum.P_62.value
    GIA_LAI = ProvinceEnum.P_64.value
    DAK_LAK = ProvinceEnum.P_66.value
    DAK_NONG = ProvinceEnum.P_67.value
    LAM_DONG = ProvinceEnum.P_68.value
    BINH_PHUOC = ProvinceEnum.P_70.value
    TAY_NINH = ProvinceEnum.P_72.value
    BINH_DUONG = ProvinceEnum.P_74.value
    DONG_NAI = ProvinceEnum.P_75.value
    BA_RIA_VUNG_TAU = ProvinceEnum.P_77.value
    HO_CHI_MINH = ProvinceEnum.P_79.value
    LONG_AN = ProvinceEnum.P_80.value
    TIEN_GIANG = ProvinceEnum.P_82.value
    BEN_TRE = ProvinceEnum.P_83.value
    TRA_VINH = ProvinceEnum.P_84.value
    VINH_LONG = ProvinceEnum.P_86.value
    DONG_THAP = ProvinceEnum.P_87.value
    AN_GIANG = ProvinceEnum.P_89.value
    KIEN_GIANG = ProvinceEnum.P_91.value
    CAN_THO = ProvinceEnum.P_92.value
    HAU_GIANG = ProvinceEnum.P_93.value
    SOC_TRANG = ProvinceEnum.P_94.value
    BAC_LIEU = ProvinceEnum.P_95.value
    CA_MAU = ProvinceEnum.P_96.value


class DistrictEnum(Enum):
    """
    District Enum type, which is convenient for fast looking up District by its numeric code.
    """

    D_1 = District("Quận Ba Đình", 1, VietNamDivisionType.QUAN, "quan_ba_dinh", 1)
    D_2 = District("Quận Hoàn Kiếm", 2, VietNamDivisionType.QUAN, "quan_hoan_kiem", 1)
    D_3 = District("Quận Tây Hồ", 3, VietNamDivisionType.QUAN, "quan_tay_ho", 1)
    D_4 = District("Quận Long Biên", 4, VietNamDivisionType.QUAN, "quan_long_bien", 1)
    D_5 = District("Quận Cầu Giấy", 5, VietNamDivisionType.QUAN, "quan_cau_giay", 1)
    D_6 = District("Quận Đống Đa", 6, VietNamDivisionType.QUAN, "quan_dong_da", 1)
    D_7 = District("Quận Hai Bà Trưng", 7, VietNamDivisionType.QUAN, "quan_hai_ba_trung", 1)
    D_8 = District("Quận Hoàng Mai", 8, VietNamDivisionType.QUAN, "quan_hoang_mai", 1)
    D_9 = District("Quận Thanh Xuân", 9, VietNamDivisionType.QUAN, "quan_thanh_xuan", 1)
    D_16 = District("Huyện Sóc Sơn", 16, VietNamDivisionType.HUYEN, "huyen_soc_son", 1)
    D_17 = District("Huyện Đông Anh", 17, VietNamDivisionType.HUYEN, "huyen_dong_anh", 1)
    D_18 = District("Huyện Gia Lâm", 18, VietNamDivisionType.HUYEN, "huyen_gia_lam", 1)
    D_19 = District("Quận Nam Từ Liêm", 19, VietNamDivisionType.QUAN, "quan_nam_tu_liem", 1)
    D_20 = District("Huyện Thanh Trì", 20, VietNamDivisionType.HUYEN, "huyen_thanh_tri", 1)
    D_21 = District("Quận Bắc Từ Liêm", 21, VietNamDivisionType.QUAN, "quan_bac_tu_liem", 1)
    D_250 = District("Huyện Mê Linh", 250, VietNamDivisionType.HUYEN, "huyen_me_linh", 1)
    D_268 = District("Quận Hà Đông", 268, VietNamDivisionType.QUAN, "quan_ha_dong", 1)
    D_269 = District("Thị xã Sơn Tây", 269, VietNamDivisionType.THI_XA, "thi_xa_son_tay", 1)
    D_271 = District("Huyện Ba Vì", 271, VietNamDivisionType.HUYEN, "huyen_ba_vi", 1)
    D_272 = District("Huyện Phúc Thọ", 272, VietNamDivisionType.HUYEN, "huyen_phuc_tho", 1)
    D_273 = District("Huyện Đan Phượng", 273, VietNamDivisionType.HUYEN, "huyen_dan_phuong", 1)
    D_274 = District("Huyện Hoài Đức", 274, VietNamDivisionType.HUYEN, "huyen_hoai_duc", 1)
    D_275 = District("Huyện Quốc Oai", 275, VietNamDivisionType.HUYEN, "huyen_quoc_oai", 1)
    D_276 = District("Huyện Thạch Thất", 276, VietNamDivisionType.HUYEN, "huyen_thach_that", 1)
    D_277 = District("Huyện Chương Mỹ", 277, VietNamDivisionType.HUYEN, "huyen_chuong_my", 1)
    D_278 = District("Huyện Thanh Oai", 278, VietNamDivisionType.HUYEN, "huyen_thanh_oai", 1)
    D_279 = District("Huyện Thường Tín", 279, VietNamDivisionType.HUYEN, "huyen_thuong_tin", 1)
    D_280 = District("Huyện Phú Xuyên", 280, VietNamDivisionType.HUYEN, "huyen_phu_xuyen", 1)
    D_281 = District("Huyện Ứng Hòa", 281, VietNamDivisionType.HUYEN, "huyen_ung_hoa", 1)
    D_282 = District("Huyện Mỹ Đức", 282, VietNamDivisionType.HUYEN, "huyen_my_duc", 1)
    D_24 = District("Thành phố Hà Giang", 24, VietNamDivisionType.THANH_PHO, "thanh_pho_ha_giang", 2)
    D_26 = District("Huyện Đồng Văn", 26, VietNamDivisionType.HUYEN, "huyen_dong_van", 2)
    D_27 = District("Huyện Mèo Vạc", 27, VietNamDivisionType.HUYEN, "huyen_meo_vac", 2)
    D_28 = District("Huyện Yên Minh", 28, VietNamDivisionType.HUYEN, "huyen_yen_minh", 2)
    D_29 = District("Huyện Quản Bạ", 29, VietNamDivisionType.HUYEN, "huyen_quan_ba", 2)
    D_30 = District("Huyện Vị Xuyên", 30, VietNamDivisionType.HUYEN, "huyen_vi_xuyen", 2)
    D_31 = District("Huyện Bắc Mê", 31, VietNamDivisionType.HUYEN, "huyen_bac_me", 2)
    D_32 = District("Huyện Hoàng Su Phì", 32, VietNamDivisionType.HUYEN, "huyen_hoang_su_phi", 2)
    D_33 = District("Huyện Xín Mần", 33, VietNamDivisionType.HUYEN, "huyen_xin_man", 2)
    D_34 = District("Huyện Bắc Quang", 34, VietNamDivisionType.HUYEN, "huyen_bac_quang", 2)
    D_35 = District("Huyện Quang Bình", 35, VietNamDivisionType.HUYEN, "huyen_quang_binh", 2)
    D_40 = District("Thành phố Cao Bằng", 40, VietNamDivisionType.THANH_PHO, "thanh_pho_cao_bang", 4)
    D_42 = District("Huyện Bảo Lâm", 42, VietNamDivisionType.HUYEN, "huyen_bao_lam", 4)
    D_43 = District("Huyện Bảo Lạc", 43, VietNamDivisionType.HUYEN, "huyen_bao_lac", 4)
    D_45 = District("Huyện Hà Quảng", 45, VietNamDivisionType.HUYEN, "huyen_ha_quang", 4)
    D_47 = District("Huyện Trùng Khánh", 47, VietNamDivisionType.HUYEN, "huyen_trung_khanh", 4)
    D_48 = District("Huyện Hạ Lang", 48, VietNamDivisionType.HUYEN, "huyen_ha_lang", 4)
    D_49 = District("Huyện Quảng Hòa", 49, VietNamDivisionType.HUYEN, "huyen_quang_hoa", 4)
    D_51 = District("Huyện Hoà An", 51, VietNamDivisionType.HUYEN, "huyen_hoa_an", 4)
    D_52 = District("Huyện Nguyên Bình", 52, VietNamDivisionType.HUYEN, "huyen_nguyen_binh", 4)
    D_53 = District("Huyện Thạch An", 53, VietNamDivisionType.HUYEN, "huyen_thach_an", 4)
    D_58 = District("Thành Phố Bắc Kạn", 58, VietNamDivisionType.THANH_PHO, "thanh_pho_bac_kan", 6)
    D_60 = District("Huyện Pác Nặm", 60, VietNamDivisionType.HUYEN, "huyen_pac_nam", 6)
    D_61 = District("Huyện Ba Bể", 61, VietNamDivisionType.HUYEN, "huyen_ba_be", 6)
    D_62 = District("Huyện Ngân Sơn", 62, VietNamDivisionType.HUYEN, "huyen_ngan_son", 6)
    D_63 = District("Huyện Bạch Thông", 63, VietNamDivisionType.HUYEN, "huyen_bach_thong", 6)
    D_64 = District("Huyện Chợ Đồn", 64, VietNamDivisionType.HUYEN, "huyen_cho_don", 6)
    D_65 = District("Huyện Chợ Mới", 65, VietNamDivisionType.HUYEN, "huyen_cho_moi", 6)
    D_66 = District("Huyện Na Rì", 66, VietNamDivisionType.HUYEN, "huyen_na_ri", 6)
    D_70 = District("Thành phố Tuyên Quang", 70, VietNamDivisionType.THANH_PHO, "thanh_pho_tuyen_quang", 8)
    D_71 = District("Huyện Lâm Bình", 71, VietNamDivisionType.HUYEN, "huyen_lam_binh", 8)
    D_72 = District("Huyện Na Hang", 72, VietNamDivisionType.HUYEN, "huyen_na_hang", 8)
    D_73 = District("Huyện Chiêm Hóa", 73, VietNamDivisionType.HUYEN, "huyen_chiem_hoa", 8)
    D_74 = District("Huyện Hàm Yên", 74, VietNamDivisionType.HUYEN, "huyen_ham_yen", 8)
    D_75 = District("Huyện Yên Sơn", 75, VietNamDivisionType.HUYEN, "huyen_yen_son", 8)
    D_76 = District("Huyện Sơn Dương", 76, VietNamDivisionType.HUYEN, "huyen_son_duong", 8)
    D_80 = District("Thành phố Lào Cai", 80, VietNamDivisionType.THANH_PHO, "thanh_pho_lao_cai", 10)
    D_82 = District("Huyện Bát Xát", 82, VietNamDivisionType.HUYEN, "huyen_bat_xat", 10)
    D_83 = District("Huyện Mường Khương", 83, VietNamDivisionType.HUYEN, "huyen_muong_khuong", 10)
    D_84 = District("Huyện Si Ma Cai", 84, VietNamDivisionType.HUYEN, "huyen_si_ma_cai", 10)
    D_85 = District("Huyện Bắc Hà", 85, VietNamDivisionType.HUYEN, "huyen_bac_ha", 10)
    D_86 = District("Huyện Bảo Thắng", 86, VietNamDivisionType.HUYEN, "huyen_bao_thang", 10)
    D_87 = District("Huyện Bảo Yên", 87, VietNamDivisionType.HUYEN, "huyen_bao_yen", 10)
    D_88 = District("Thị xã Sa Pa", 88, VietNamDivisionType.THI_XA, "thi_xa_sa_pa", 10)
    D_89 = District("Huyện Văn Bàn", 89, VietNamDivisionType.HUYEN, "huyen_van_ban", 10)
    D_94 = District("Thành phố Điện Biên Phủ", 94, VietNamDivisionType.THANH_PHO, "thanh_pho_dien_bien_phu", 11)
    D_95 = District("Thị xã Mường Lay", 95, VietNamDivisionType.THI_XA, "thi_xa_muong_lay", 11)
    D_96 = District("Huyện Mường Nhé", 96, VietNamDivisionType.HUYEN, "huyen_muong_nhe", 11)
    D_97 = District("Huyện Mường Chà", 97, VietNamDivisionType.HUYEN, "huyen_muong_cha", 11)
    D_98 = District("Huyện Tủa Chùa", 98, VietNamDivisionType.HUYEN, "huyen_tua_chua", 11)
    D_99 = District("Huyện Tuần Giáo", 99, VietNamDivisionType.HUYEN, "huyen_tuan_giao", 11)
    D_100 = District("Huyện Điện Biên", 100, VietNamDivisionType.HUYEN, "huyen_dien_bien", 11)
    D_101 = District("Huyện Điện Biên Đông", 101, VietNamDivisionType.HUYEN, "huyen_dien_bien_dong", 11)
    D_102 = District("Huyện Mường Ảng", 102, VietNamDivisionType.HUYEN, "huyen_muong_ang", 11)
    D_103 = District("Huyện Nậm Pồ", 103, VietNamDivisionType.HUYEN, "huyen_nam_po", 11)
    D_105 = District("Thành phố Lai Châu", 105, VietNamDivisionType.THANH_PHO, "thanh_pho_lai_chau", 12)
    D_106 = District("Huyện Tam Đường", 106, VietNamDivisionType.HUYEN, "huyen_tam_duong", 12)
    D_107 = District("Huyện Mường Tè", 107, VietNamDivisionType.HUYEN, "huyen_muong_te", 12)
    D_108 = District("Huyện Sìn Hồ", 108, VietNamDivisionType.HUYEN, "huyen_sin_ho", 12)
    D_109 = District("Huyện Phong Thổ", 109, VietNamDivisionType.HUYEN, "huyen_phong_tho", 12)
    D_110 = District("Huyện Than Uyên", 110, VietNamDivisionType.HUYEN, "huyen_than_uyen", 12)
    D_111 = District("Huyện Tân Uyên", 111, VietNamDivisionType.HUYEN, "huyen_tan_uyen", 12)
    D_112 = District("Huyện Nậm Nhùn", 112, VietNamDivisionType.HUYEN, "huyen_nam_nhun", 12)
    D_116 = District("Thành phố Sơn La", 116, VietNamDivisionType.THANH_PHO, "thanh_pho_son_la", 14)
    D_118 = District("Huyện Quỳnh Nhai", 118, VietNamDivisionType.HUYEN, "huyen_quynh_nhai", 14)
    D_119 = District("Huyện Thuận Châu", 119, VietNamDivisionType.HUYEN, "huyen_thuan_chau", 14)
    D_120 = District("Huyện Mường La", 120, VietNamDivisionType.HUYEN, "huyen_muong_la", 14)
    D_121 = District("Huyện Bắc Yên", 121, VietNamDivisionType.HUYEN, "huyen_bac_yen", 14)
    D_122 = District("Huyện Phù Yên", 122, VietNamDivisionType.HUYEN, "huyen_phu_yen", 14)
    D_123 = District("Huyện Mộc Châu", 123, VietNamDivisionType.HUYEN, "huyen_moc_chau", 14)
    D_124 = District("Huyện Yên Châu", 124, VietNamDivisionType.HUYEN, "huyen_yen_chau", 14)
    D_125 = District("Huyện Mai Sơn", 125, VietNamDivisionType.HUYEN, "huyen_mai_son", 14)
    D_126 = District("Huyện Sông Mã", 126, VietNamDivisionType.HUYEN, "huyen_song_ma", 14)
    D_127 = District("Huyện Sốp Cộp", 127, VietNamDivisionType.HUYEN, "huyen_sop_cop", 14)
    D_128 = District("Huyện Vân Hồ", 128, VietNamDivisionType.HUYEN, "huyen_van_ho", 14)
    D_132 = District("Thành phố Yên Bái", 132, VietNamDivisionType.THANH_PHO, "thanh_pho_yen_bai", 15)
    D_133 = District("Thị xã Nghĩa Lộ", 133, VietNamDivisionType.THI_XA, "thi_xa_nghia_lo", 15)
    D_135 = District("Huyện Lục Yên", 135, VietNamDivisionType.HUYEN, "huyen_luc_yen", 15)
    D_136 = District("Huyện Văn Yên", 136, VietNamDivisionType.HUYEN, "huyen_van_yen", 15)
    D_137 = District("Huyện Mù Căng Chải", 137, VietNamDivisionType.HUYEN, "huyen_mu_cang_chai", 15)
    D_138 = District("Huyện Trấn Yên", 138, VietNamDivisionType.HUYEN, "huyen_tran_yen", 15)
    D_139 = District("Huyện Trạm Tấu", 139, VietNamDivisionType.HUYEN, "huyen_tram_tau", 15)
    D_140 = District("Huyện Văn Chấn", 140, VietNamDivisionType.HUYEN, "huyen_van_chan", 15)
    D_141 = District("Huyện Yên Bình", 141, VietNamDivisionType.HUYEN, "huyen_yen_binh", 15)
    D_148 = District("Thành phố Hòa Bình", 148, VietNamDivisionType.THANH_PHO, "thanh_pho_hoa_binh", 17)
    D_150 = District("Huyện Đà Bắc", 150, VietNamDivisionType.HUYEN, "huyen_da_bac", 17)
    D_152 = District("Huyện Lương Sơn", 152, VietNamDivisionType.HUYEN, "huyen_luong_son", 17)
    D_153 = District("Huyện Kim Bôi", 153, VietNamDivisionType.HUYEN, "huyen_kim_boi", 17)
    D_154 = District("Huyện Cao Phong", 154, VietNamDivisionType.HUYEN, "huyen_cao_phong", 17)
    D_155 = District("Huyện Tân Lạc", 155, VietNamDivisionType.HUYEN, "huyen_tan_lac", 17)
    D_156 = District("Huyện Mai Châu", 156, VietNamDivisionType.HUYEN, "huyen_mai_chau", 17)
    D_157 = District("Huyện Lạc Sơn", 157, VietNamDivisionType.HUYEN, "huyen_lac_son", 17)
    D_158 = District("Huyện Yên Thủy", 158, VietNamDivisionType.HUYEN, "huyen_yen_thuy", 17)
    D_159 = District("Huyện Lạc Thủy", 159, VietNamDivisionType.HUYEN, "huyen_lac_thuy", 17)
    D_164 = District("Thành phố Thái Nguyên", 164, VietNamDivisionType.THANH_PHO, "thanh_pho_thai_nguyen", 19)
    D_165 = District("Thành phố Sông Công", 165, VietNamDivisionType.THANH_PHO, "thanh_pho_song_cong", 19)
    D_167 = District("Huyện Định Hóa", 167, VietNamDivisionType.HUYEN, "huyen_dinh_hoa", 19)
    D_168 = District("Huyện Phú Lương", 168, VietNamDivisionType.HUYEN, "huyen_phu_luong", 19)
    D_169 = District("Huyện Đồng Hỷ", 169, VietNamDivisionType.HUYEN, "huyen_dong_hy", 19)
    D_170 = District("Huyện Võ Nhai", 170, VietNamDivisionType.HUYEN, "huyen_vo_nhai", 19)
    D_171 = District("Huyện Đại Từ", 171, VietNamDivisionType.HUYEN, "huyen_dai_tu", 19)
    D_172 = District("Thị xã Phổ Yên", 172, VietNamDivisionType.THI_XA, "thi_xa_pho_yen", 19)
    D_173 = District("Huyện Phú Bình", 173, VietNamDivisionType.HUYEN, "huyen_phu_binh", 19)
    D_178 = District("Thành phố Lạng Sơn", 178, VietNamDivisionType.THANH_PHO, "thanh_pho_lang_son", 20)
    D_180 = District("Huyện Tràng Định", 180, VietNamDivisionType.HUYEN, "huyen_trang_dinh", 20)
    D_181 = District("Huyện Bình Gia", 181, VietNamDivisionType.HUYEN, "huyen_binh_gia", 20)
    D_182 = District("Huyện Văn Lãng", 182, VietNamDivisionType.HUYEN, "huyen_van_lang", 20)
    D_183 = District("Huyện Cao Lộc", 183, VietNamDivisionType.HUYEN, "huyen_cao_loc", 20)
    D_184 = District("Huyện Văn Quan", 184, VietNamDivisionType.HUYEN, "huyen_van_quan", 20)
    D_185 = District("Huyện Bắc Sơn", 185, VietNamDivisionType.HUYEN, "huyen_bac_son", 20)
    D_186 = District("Huyện Hữu Lũng", 186, VietNamDivisionType.HUYEN, "huyen_huu_lung", 20)
    D_187 = District("Huyện Chi Lăng", 187, VietNamDivisionType.HUYEN, "huyen_chi_lang", 20)
    D_188 = District("Huyện Lộc Bình", 188, VietNamDivisionType.HUYEN, "huyen_loc_binh", 20)
    D_189 = District("Huyện Đình Lập", 189, VietNamDivisionType.HUYEN, "huyen_dinh_lap", 20)
    D_193 = District("Thành phố Hạ Long", 193, VietNamDivisionType.THANH_PHO, "thanh_pho_ha_long", 22)
    D_194 = District("Thành phố Móng Cái", 194, VietNamDivisionType.THANH_PHO, "thanh_pho_mong_cai", 22)
    D_195 = District("Thành phố Cẩm Phả", 195, VietNamDivisionType.THANH_PHO, "thanh_pho_cam_pha", 22)
    D_196 = District("Thành phố Uông Bí", 196, VietNamDivisionType.THANH_PHO, "thanh_pho_uong_bi", 22)
    D_198 = District("Huyện Bình Liêu", 198, VietNamDivisionType.HUYEN, "huyen_binh_lieu", 22)
    D_199 = District("Huyện Tiên Yên", 199, VietNamDivisionType.HUYEN, "huyen_tien_yen", 22)
    D_200 = District("Huyện Đầm Hà", 200, VietNamDivisionType.HUYEN, "huyen_dam_ha", 22)
    D_201 = District("Huyện Hải Hà", 201, VietNamDivisionType.HUYEN, "huyen_hai_ha", 22)
    D_202 = District("Huyện Ba Chẽ", 202, VietNamDivisionType.HUYEN, "huyen_ba_che", 22)
    D_203 = District("Huyện Vân Đồn", 203, VietNamDivisionType.HUYEN, "huyen_van_don", 22)
    D_205 = District("Thị xã Đông Triều", 205, VietNamDivisionType.THI_XA, "thi_xa_dong_trieu", 22)
    D_206 = District("Thị xã Quảng Yên", 206, VietNamDivisionType.THI_XA, "thi_xa_quang_yen", 22)
    D_207 = District("Huyện Cô Tô", 207, VietNamDivisionType.HUYEN, "huyen_co_to", 22)
    D_213 = District("Thành phố Bắc Giang", 213, VietNamDivisionType.THANH_PHO, "thanh_pho_bac_giang", 24)
    D_215 = District("Huyện Yên Thế", 215, VietNamDivisionType.HUYEN, "huyen_yen_the", 24)
    D_216 = District("Huyện Tân Yên", 216, VietNamDivisionType.HUYEN, "huyen_tan_yen", 24)
    D_217 = District("Huyện Lạng Giang", 217, VietNamDivisionType.HUYEN, "huyen_lang_giang", 24)
    D_218 = District("Huyện Lục Nam", 218, VietNamDivisionType.HUYEN, "huyen_luc_nam", 24)
    D_219 = District("Huyện Lục Ngạn", 219, VietNamDivisionType.HUYEN, "huyen_luc_ngan", 24)
    D_220 = District("Huyện Sơn Động", 220, VietNamDivisionType.HUYEN, "huyen_son_dong", 24)
    D_221 = District("Huyện Yên Dũng", 221, VietNamDivisionType.HUYEN, "huyen_yen_dung", 24)
    D_222 = District("Huyện Việt Yên", 222, VietNamDivisionType.HUYEN, "huyen_viet_yen", 24)
    D_223 = District("Huyện Hiệp Hòa", 223, VietNamDivisionType.HUYEN, "huyen_hiep_hoa", 24)
    D_227 = District("Thành phố Việt Trì", 227, VietNamDivisionType.THANH_PHO, "thanh_pho_viet_tri", 25)
    D_228 = District("Thị xã Phú Thọ", 228, VietNamDivisionType.THI_XA, "thi_xa_phu_tho", 25)
    D_230 = District("Huyện Đoan Hùng", 230, VietNamDivisionType.HUYEN, "huyen_doan_hung", 25)
    D_231 = District("Huyện Hạ Hoà", 231, VietNamDivisionType.HUYEN, "huyen_ha_hoa", 25)
    D_232 = District("Huyện Thanh Ba", 232, VietNamDivisionType.HUYEN, "huyen_thanh_ba", 25)
    D_233 = District("Huyện Phù Ninh", 233, VietNamDivisionType.HUYEN, "huyen_phu_ninh", 25)
    D_234 = District("Huyện Yên Lập", 234, VietNamDivisionType.HUYEN, "huyen_yen_lap", 25)
    D_235 = District("Huyện Cẩm Khê", 235, VietNamDivisionType.HUYEN, "huyen_cam_khe", 25)
    D_236 = District("Huyện Tam Nông", 236, VietNamDivisionType.HUYEN, "huyen_tam_nong", 25)
    D_237 = District("Huyện Lâm Thao", 237, VietNamDivisionType.HUYEN, "huyen_lam_thao", 25)
    D_238 = District("Huyện Thanh Sơn", 238, VietNamDivisionType.HUYEN, "huyen_thanh_son", 25)
    D_239 = District("Huyện Thanh Thuỷ", 239, VietNamDivisionType.HUYEN, "huyen_thanh_thuy", 25)
    D_240 = District("Huyện Tân Sơn", 240, VietNamDivisionType.HUYEN, "huyen_tan_son", 25)
    D_243 = District("Thành phố Vĩnh Yên", 243, VietNamDivisionType.THANH_PHO, "thanh_pho_vinh_yen", 26)
    D_244 = District("Thành phố Phúc Yên", 244, VietNamDivisionType.THANH_PHO, "thanh_pho_phuc_yen", 26)
    D_246 = District("Huyện Lập Thạch", 246, VietNamDivisionType.HUYEN, "huyen_lap_thach", 26)
    D_247 = District("Huyện Tam Dương", 247, VietNamDivisionType.HUYEN, "huyen_tam_duong", 26)
    D_248 = District("Huyện Tam Đảo", 248, VietNamDivisionType.HUYEN, "huyen_tam_dao", 26)
    D_249 = District("Huyện Bình Xuyên", 249, VietNamDivisionType.HUYEN, "huyen_binh_xuyen", 26)
    D_251 = District("Huyện Yên Lạc", 251, VietNamDivisionType.HUYEN, "huyen_yen_lac", 26)
    D_252 = District("Huyện Vĩnh Tường", 252, VietNamDivisionType.HUYEN, "huyen_vinh_tuong", 26)
    D_253 = District("Huyện Sông Lô", 253, VietNamDivisionType.HUYEN, "huyen_song_lo", 26)
    D_256 = District("Thành phố Bắc Ninh", 256, VietNamDivisionType.THANH_PHO, "thanh_pho_bac_ninh", 27)
    D_258 = District("Huyện Yên Phong", 258, VietNamDivisionType.HUYEN, "huyen_yen_phong", 27)
    D_259 = District("Huyện Quế Võ", 259, VietNamDivisionType.HUYEN, "huyen_que_vo", 27)
    D_260 = District("Huyện Tiên Du", 260, VietNamDivisionType.HUYEN, "huyen_tien_du", 27)
    D_261 = District("Thị xã Từ Sơn", 261, VietNamDivisionType.THI_XA, "thi_xa_tu_son", 27)
    D_262 = District("Huyện Thuận Thành", 262, VietNamDivisionType.HUYEN, "huyen_thuan_thanh", 27)
    D_263 = District("Huyện Gia Bình", 263, VietNamDivisionType.HUYEN, "huyen_gia_binh", 27)
    D_264 = District("Huyện Lương Tài", 264, VietNamDivisionType.HUYEN, "huyen_luong_tai", 27)
    D_288 = District("Thành phố Hải Dương", 288, VietNamDivisionType.THANH_PHO, "thanh_pho_hai_duong", 30)
    D_290 = District("Thành phố Chí Linh", 290, VietNamDivisionType.THANH_PHO, "thanh_pho_chi_linh", 30)
    D_291 = District("Huyện Nam Sách", 291, VietNamDivisionType.HUYEN, "huyen_nam_sach", 30)
    D_292 = District("Thị xã Kinh Môn", 292, VietNamDivisionType.THI_XA, "thi_xa_kinh_mon", 30)
    D_293 = District("Huyện Kim Thành", 293, VietNamDivisionType.HUYEN, "huyen_kim_thanh", 30)
    D_294 = District("Huyện Thanh Hà", 294, VietNamDivisionType.HUYEN, "huyen_thanh_ha", 30)
    D_295 = District("Huyện Cẩm Giàng", 295, VietNamDivisionType.HUYEN, "huyen_cam_giang", 30)
    D_296 = District("Huyện Bình Giang", 296, VietNamDivisionType.HUYEN, "huyen_binh_giang", 30)
    D_297 = District("Huyện Gia Lộc", 297, VietNamDivisionType.HUYEN, "huyen_gia_loc", 30)
    D_298 = District("Huyện Tứ Kỳ", 298, VietNamDivisionType.HUYEN, "huyen_tu_ky", 30)
    D_299 = District("Huyện Ninh Giang", 299, VietNamDivisionType.HUYEN, "huyen_ninh_giang", 30)
    D_300 = District("Huyện Thanh Miện", 300, VietNamDivisionType.HUYEN, "huyen_thanh_mien", 30)
    D_303 = District("Quận Hồng Bàng", 303, VietNamDivisionType.QUAN, "quan_hong_bang", 31)
    D_304 = District("Quận Ngô Quyền", 304, VietNamDivisionType.QUAN, "quan_ngo_quyen", 31)
    D_305 = District("Quận Lê Chân", 305, VietNamDivisionType.QUAN, "quan_le_chan", 31)
    D_306 = District("Quận Hải An", 306, VietNamDivisionType.QUAN, "quan_hai_an", 31)
    D_307 = District("Quận Kiến An", 307, VietNamDivisionType.QUAN, "quan_kien_an", 31)
    D_308 = District("Quận Đồ Sơn", 308, VietNamDivisionType.QUAN, "quan_do_son", 31)
    D_309 = District("Quận Dương Kinh", 309, VietNamDivisionType.QUAN, "quan_duong_kinh", 31)
    D_311 = District("Huyện Thuỷ Nguyên", 311, VietNamDivisionType.HUYEN, "huyen_thuy_nguyen", 31)
    D_312 = District("Huyện An Dương", 312, VietNamDivisionType.HUYEN, "huyen_an_duong", 31)
    D_313 = District("Huyện An Lão", 313, VietNamDivisionType.HUYEN, "huyen_an_lao", 31)
    D_314 = District("Huyện Kiến Thuỵ", 314, VietNamDivisionType.HUYEN, "huyen_kien_thuy", 31)
    D_315 = District("Huyện Tiên Lãng", 315, VietNamDivisionType.HUYEN, "huyen_tien_lang", 31)
    D_316 = District("Huyện Vĩnh Bảo", 316, VietNamDivisionType.HUYEN, "huyen_vinh_bao", 31)
    D_317 = District("Huyện Cát Hải", 317, VietNamDivisionType.HUYEN, "huyen_cat_hai", 31)
    D_318 = District("Huyện Bạch Long Vĩ", 318, VietNamDivisionType.HUYEN, "huyen_bach_long_vi", 31)
    D_323 = District("Thành phố Hưng Yên", 323, VietNamDivisionType.THANH_PHO, "thanh_pho_hung_yen", 33)
    D_325 = District("Huyện Văn Lâm", 325, VietNamDivisionType.HUYEN, "huyen_van_lam", 33)
    D_326 = District("Huyện Văn Giang", 326, VietNamDivisionType.HUYEN, "huyen_van_giang", 33)
    D_327 = District("Huyện Yên Mỹ", 327, VietNamDivisionType.HUYEN, "huyen_yen_my", 33)
    D_328 = District("Thị xã Mỹ Hào", 328, VietNamDivisionType.THI_XA, "thi_xa_my_hao", 33)
    D_329 = District("Huyện Ân Thi", 329, VietNamDivisionType.HUYEN, "huyen_an_thi", 33)
    D_330 = District("Huyện Khoái Châu", 330, VietNamDivisionType.HUYEN, "huyen_khoai_chau", 33)
    D_331 = District("Huyện Kim Động", 331, VietNamDivisionType.HUYEN, "huyen_kim_dong", 33)
    D_332 = District("Huyện Tiên Lữ", 332, VietNamDivisionType.HUYEN, "huyen_tien_lu", 33)
    D_333 = District("Huyện Phù Cừ", 333, VietNamDivisionType.HUYEN, "huyen_phu_cu", 33)
    D_336 = District("Thành phố Thái Bình", 336, VietNamDivisionType.THANH_PHO, "thanh_pho_thai_binh", 34)
    D_338 = District("Huyện Quỳnh Phụ", 338, VietNamDivisionType.HUYEN, "huyen_quynh_phu", 34)
    D_339 = District("Huyện Hưng Hà", 339, VietNamDivisionType.HUYEN, "huyen_hung_ha", 34)
    D_340 = District("Huyện Đông Hưng", 340, VietNamDivisionType.HUYEN, "huyen_dong_hung", 34)
    D_341 = District("Huyện Thái Thụy", 341, VietNamDivisionType.HUYEN, "huyen_thai_thuy", 34)
    D_342 = District("Huyện Tiền Hải", 342, VietNamDivisionType.HUYEN, "huyen_tien_hai", 34)
    D_343 = District("Huyện Kiến Xương", 343, VietNamDivisionType.HUYEN, "huyen_kien_xuong", 34)
    D_344 = District("Huyện Vũ Thư", 344, VietNamDivisionType.HUYEN, "huyen_vu_thu", 34)
    D_347 = District("Thành phố Phủ Lý", 347, VietNamDivisionType.THANH_PHO, "thanh_pho_phu_ly", 35)
    D_349 = District("Thị xã Duy Tiên", 349, VietNamDivisionType.THI_XA, "thi_xa_duy_tien", 35)
    D_350 = District("Huyện Kim Bảng", 350, VietNamDivisionType.HUYEN, "huyen_kim_bang", 35)
    D_351 = District("Huyện Thanh Liêm", 351, VietNamDivisionType.HUYEN, "huyen_thanh_liem", 35)
    D_352 = District("Huyện Bình Lục", 352, VietNamDivisionType.HUYEN, "huyen_binh_luc", 35)
    D_353 = District("Huyện Lý Nhân", 353, VietNamDivisionType.HUYEN, "huyen_ly_nhan", 35)
    D_356 = District("Thành phố Nam Định", 356, VietNamDivisionType.THANH_PHO, "thanh_pho_nam_dinh", 36)
    D_358 = District("Huyện Mỹ Lộc", 358, VietNamDivisionType.HUYEN, "huyen_my_loc", 36)
    D_359 = District("Huyện Vụ Bản", 359, VietNamDivisionType.HUYEN, "huyen_vu_ban", 36)
    D_360 = District("Huyện Ý Yên", 360, VietNamDivisionType.HUYEN, "huyen_y_yen", 36)
    D_361 = District("Huyện Nghĩa Hưng", 361, VietNamDivisionType.HUYEN, "huyen_nghia_hung", 36)
    D_362 = District("Huyện Nam Trực", 362, VietNamDivisionType.HUYEN, "huyen_nam_truc", 36)
    D_363 = District("Huyện Trực Ninh", 363, VietNamDivisionType.HUYEN, "huyen_truc_ninh", 36)
    D_364 = District("Huyện Xuân Trường", 364, VietNamDivisionType.HUYEN, "huyen_xuan_truong", 36)
    D_365 = District("Huyện Giao Thủy", 365, VietNamDivisionType.HUYEN, "huyen_giao_thuy", 36)
    D_366 = District("Huyện Hải Hậu", 366, VietNamDivisionType.HUYEN, "huyen_hai_hau", 36)
    D_369 = District("Thành phố Ninh Bình", 369, VietNamDivisionType.THANH_PHO, "thanh_pho_ninh_binh", 37)
    D_370 = District("Thành phố Tam Điệp", 370, VietNamDivisionType.THANH_PHO, "thanh_pho_tam_diep", 37)
    D_372 = District("Huyện Nho Quan", 372, VietNamDivisionType.HUYEN, "huyen_nho_quan", 37)
    D_373 = District("Huyện Gia Viễn", 373, VietNamDivisionType.HUYEN, "huyen_gia_vien", 37)
    D_374 = District("Huyện Hoa Lư", 374, VietNamDivisionType.HUYEN, "huyen_hoa_lu", 37)
    D_375 = District("Huyện Yên Khánh", 375, VietNamDivisionType.HUYEN, "huyen_yen_khanh", 37)
    D_376 = District("Huyện Kim Sơn", 376, VietNamDivisionType.HUYEN, "huyen_kim_son", 37)
    D_377 = District("Huyện Yên Mô", 377, VietNamDivisionType.HUYEN, "huyen_yen_mo", 37)
    D_380 = District("Thành phố Thanh Hóa", 380, VietNamDivisionType.THANH_PHO, "thanh_pho_thanh_hoa", 38)
    D_381 = District("Thị xã Bỉm Sơn", 381, VietNamDivisionType.THI_XA, "thi_xa_bim_son", 38)
    D_382 = District("Thành phố Sầm Sơn", 382, VietNamDivisionType.THANH_PHO, "thanh_pho_sam_son", 38)
    D_384 = District("Huyện Mường Lát", 384, VietNamDivisionType.HUYEN, "huyen_muong_lat", 38)
    D_385 = District("Huyện Quan Hóa", 385, VietNamDivisionType.HUYEN, "huyen_quan_hoa", 38)
    D_386 = District("Huyện Bá Thước", 386, VietNamDivisionType.HUYEN, "huyen_ba_thuoc", 38)
    D_387 = District("Huyện Quan Sơn", 387, VietNamDivisionType.HUYEN, "huyen_quan_son", 38)
    D_388 = District("Huyện Lang Chánh", 388, VietNamDivisionType.HUYEN, "huyen_lang_chanh", 38)
    D_389 = District("Huyện Ngọc Lặc", 389, VietNamDivisionType.HUYEN, "huyen_ngoc_lac", 38)
    D_390 = District("Huyện Cẩm Thủy", 390, VietNamDivisionType.HUYEN, "huyen_cam_thuy", 38)
    D_391 = District("Huyện Thạch Thành", 391, VietNamDivisionType.HUYEN, "huyen_thach_thanh", 38)
    D_392 = District("Huyện Hà Trung", 392, VietNamDivisionType.HUYEN, "huyen_ha_trung", 38)
    D_393 = District("Huyện Vĩnh Lộc", 393, VietNamDivisionType.HUYEN, "huyen_vinh_loc", 38)
    D_394 = District("Huyện Yên Định", 394, VietNamDivisionType.HUYEN, "huyen_yen_dinh", 38)
    D_395 = District("Huyện Thọ Xuân", 395, VietNamDivisionType.HUYEN, "huyen_tho_xuan", 38)
    D_396 = District("Huyện Thường Xuân", 396, VietNamDivisionType.HUYEN, "huyen_thuong_xuan", 38)
    D_397 = District("Huyện Triệu Sơn", 397, VietNamDivisionType.HUYEN, "huyen_trieu_son", 38)
    D_398 = District("Huyện Thiệu Hóa", 398, VietNamDivisionType.HUYEN, "huyen_thieu_hoa", 38)
    D_399 = District("Huyện Hoằng Hóa", 399, VietNamDivisionType.HUYEN, "huyen_hoang_hoa", 38)
    D_400 = District("Huyện Hậu Lộc", 400, VietNamDivisionType.HUYEN, "huyen_hau_loc", 38)
    D_401 = District("Huyện Nga Sơn", 401, VietNamDivisionType.HUYEN, "huyen_nga_son", 38)
    D_402 = District("Huyện Như Xuân", 402, VietNamDivisionType.HUYEN, "huyen_nhu_xuan", 38)
    D_403 = District("Huyện Như Thanh", 403, VietNamDivisionType.HUYEN, "huyen_nhu_thanh", 38)
    D_404 = District("Huyện Nông Cống", 404, VietNamDivisionType.HUYEN, "huyen_nong_cong", 38)
    D_405 = District("Huyện Đông Sơn", 405, VietNamDivisionType.HUYEN, "huyen_dong_son", 38)
    D_406 = District("Huyện Quảng Xương", 406, VietNamDivisionType.HUYEN, "huyen_quang_xuong", 38)
    D_407 = District("Thị xã Nghi Sơn", 407, VietNamDivisionType.THI_XA, "thi_xa_nghi_son", 38)
    D_412 = District("Thành phố Vinh", 412, VietNamDivisionType.THANH_PHO, "thanh_pho_vinh", 40)
    D_413 = District("Thị xã Cửa Lò", 413, VietNamDivisionType.THI_XA, "thi_xa_cua_lo", 40)
    D_414 = District("Thị xã Thái Hoà", 414, VietNamDivisionType.THI_XA, "thi_xa_thai_hoa", 40)
    D_415 = District("Huyện Quế Phong", 415, VietNamDivisionType.HUYEN, "huyen_que_phong", 40)
    D_416 = District("Huyện Quỳ Châu", 416, VietNamDivisionType.HUYEN, "huyen_quy_chau", 40)
    D_417 = District("Huyện Kỳ Sơn", 417, VietNamDivisionType.HUYEN, "huyen_ky_son", 40)
    D_418 = District("Huyện Tương Dương", 418, VietNamDivisionType.HUYEN, "huyen_tuong_duong", 40)
    D_419 = District("Huyện Nghĩa Đàn", 419, VietNamDivisionType.HUYEN, "huyen_nghia_dan", 40)
    D_420 = District("Huyện Quỳ Hợp", 420, VietNamDivisionType.HUYEN, "huyen_quy_hop", 40)
    D_421 = District("Huyện Quỳnh Lưu", 421, VietNamDivisionType.HUYEN, "huyen_quynh_luu", 40)
    D_422 = District("Huyện Con Cuông", 422, VietNamDivisionType.HUYEN, "huyen_con_cuong", 40)
    D_423 = District("Huyện Tân Kỳ", 423, VietNamDivisionType.HUYEN, "huyen_tan_ky", 40)
    D_424 = District("Huyện Anh Sơn", 424, VietNamDivisionType.HUYEN, "huyen_anh_son", 40)
    D_425 = District("Huyện Diễn Châu", 425, VietNamDivisionType.HUYEN, "huyen_dien_chau", 40)
    D_426 = District("Huyện Yên Thành", 426, VietNamDivisionType.HUYEN, "huyen_yen_thanh", 40)
    D_427 = District("Huyện Đô Lương", 427, VietNamDivisionType.HUYEN, "huyen_do_luong", 40)
    D_428 = District("Huyện Thanh Chương", 428, VietNamDivisionType.HUYEN, "huyen_thanh_chuong", 40)
    D_429 = District("Huyện Nghi Lộc", 429, VietNamDivisionType.HUYEN, "huyen_nghi_loc", 40)
    D_430 = District("Huyện Nam Đàn", 430, VietNamDivisionType.HUYEN, "huyen_nam_dan", 40)
    D_431 = District("Huyện Hưng Nguyên", 431, VietNamDivisionType.HUYEN, "huyen_hung_nguyen", 40)
    D_432 = District("Thị xã Hoàng Mai", 432, VietNamDivisionType.THI_XA, "thi_xa_hoang_mai", 40)
    D_436 = District("Thành phố Hà Tĩnh", 436, VietNamDivisionType.THANH_PHO, "thanh_pho_ha_tinh", 42)
    D_437 = District("Thị xã Hồng Lĩnh", 437, VietNamDivisionType.THI_XA, "thi_xa_hong_linh", 42)
    D_439 = District("Huyện Hương Sơn", 439, VietNamDivisionType.HUYEN, "huyen_huong_son", 42)
    D_440 = District("Huyện Đức Thọ", 440, VietNamDivisionType.HUYEN, "huyen_duc_tho", 42)
    D_441 = District("Huyện Vũ Quang", 441, VietNamDivisionType.HUYEN, "huyen_vu_quang", 42)
    D_442 = District("Huyện Nghi Xuân", 442, VietNamDivisionType.HUYEN, "huyen_nghi_xuan", 42)
    D_443 = District("Huyện Can Lộc", 443, VietNamDivisionType.HUYEN, "huyen_can_loc", 42)
    D_444 = District("Huyện Hương Khê", 444, VietNamDivisionType.HUYEN, "huyen_huong_khe", 42)
    D_445 = District("Huyện Thạch Hà", 445, VietNamDivisionType.HUYEN, "huyen_thach_ha", 42)
    D_446 = District("Huyện Cẩm Xuyên", 446, VietNamDivisionType.HUYEN, "huyen_cam_xuyen", 42)
    D_447 = District("Huyện Kỳ Anh", 447, VietNamDivisionType.HUYEN, "huyen_ky_anh", 42)
    D_448 = District("Huyện Lộc Hà", 448, VietNamDivisionType.HUYEN, "huyen_loc_ha", 42)
    D_449 = District("Thị xã Kỳ Anh", 449, VietNamDivisionType.THI_XA, "thi_xa_ky_anh", 42)
    D_450 = District("Thành Phố Đồng Hới", 450, VietNamDivisionType.THANH_PHO, "thanh_pho_dong_hoi", 44)
    D_452 = District("Huyện Minh Hóa", 452, VietNamDivisionType.HUYEN, "huyen_minh_hoa", 44)
    D_453 = District("Huyện Tuyên Hóa", 453, VietNamDivisionType.HUYEN, "huyen_tuyen_hoa", 44)
    D_454 = District("Huyện Quảng Trạch", 454, VietNamDivisionType.HUYEN, "huyen_quang_trach", 44)
    D_455 = District("Huyện Bố Trạch", 455, VietNamDivisionType.HUYEN, "huyen_bo_trach", 44)
    D_456 = District("Huyện Quảng Ninh", 456, VietNamDivisionType.HUYEN, "huyen_quang_ninh", 44)
    D_457 = District("Huyện Lệ Thủy", 457, VietNamDivisionType.HUYEN, "huyen_le_thuy", 44)
    D_458 = District("Thị xã Ba Đồn", 458, VietNamDivisionType.THI_XA, "thi_xa_ba_don", 44)
    D_461 = District("Thành phố Đông Hà", 461, VietNamDivisionType.THANH_PHO, "thanh_pho_dong_ha", 45)
    D_462 = District("Thị xã Quảng Trị", 462, VietNamDivisionType.THI_XA, "thi_xa_quang_tri", 45)
    D_464 = District("Huyện Vĩnh Linh", 464, VietNamDivisionType.HUYEN, "huyen_vinh_linh", 45)
    D_465 = District("Huyện Hướng Hóa", 465, VietNamDivisionType.HUYEN, "huyen_huong_hoa", 45)
    D_466 = District("Huyện Gio Linh", 466, VietNamDivisionType.HUYEN, "huyen_gio_linh", 45)
    D_467 = District("Huyện Đa Krông", 467, VietNamDivisionType.HUYEN, "huyen_da_krong", 45)
    D_468 = District("Huyện Cam Lộ", 468, VietNamDivisionType.HUYEN, "huyen_cam_lo", 45)
    D_469 = District("Huyện Triệu Phong", 469, VietNamDivisionType.HUYEN, "huyen_trieu_phong", 45)
    D_470 = District("Huyện Hải Lăng", 470, VietNamDivisionType.HUYEN, "huyen_hai_lang", 45)
    D_471 = District("Huyện Cồn Cỏ", 471, VietNamDivisionType.HUYEN, "huyen_con_co", 45)
    D_474 = District("Thành phố Huế", 474, VietNamDivisionType.THANH_PHO, "thanh_pho_hue", 46)
    D_476 = District("Huyện Phong Điền", 476, VietNamDivisionType.HUYEN, "huyen_phong_dien", 46)
    D_477 = District("Huyện Quảng Điền", 477, VietNamDivisionType.HUYEN, "huyen_quang_dien", 46)
    D_478 = District("Huyện Phú Vang", 478, VietNamDivisionType.HUYEN, "huyen_phu_vang", 46)
    D_479 = District("Thị xã Hương Thủy", 479, VietNamDivisionType.THI_XA, "thi_xa_huong_thuy", 46)
    D_480 = District("Thị xã Hương Trà", 480, VietNamDivisionType.THI_XA, "thi_xa_huong_tra", 46)
    D_481 = District("Huyện A Lưới", 481, VietNamDivisionType.HUYEN, "huyen_a_luoi", 46)
    D_482 = District("Huyện Phú Lộc", 482, VietNamDivisionType.HUYEN, "huyen_phu_loc", 46)
    D_483 = District("Huyện Nam Đông", 483, VietNamDivisionType.HUYEN, "huyen_nam_dong", 46)
    D_490 = District("Quận Liên Chiểu", 490, VietNamDivisionType.QUAN, "quan_lien_chieu", 48)
    D_491 = District("Quận Thanh Khê", 491, VietNamDivisionType.QUAN, "quan_thanh_khe", 48)
    D_492 = District("Quận Hải Châu", 492, VietNamDivisionType.QUAN, "quan_hai_chau", 48)
    D_493 = District("Quận Sơn Trà", 493, VietNamDivisionType.QUAN, "quan_son_tra", 48)
    D_494 = District("Quận Ngũ Hành Sơn", 494, VietNamDivisionType.QUAN, "quan_ngu_hanh_son", 48)
    D_495 = District("Quận Cẩm Lệ", 495, VietNamDivisionType.QUAN, "quan_cam_le", 48)
    D_497 = District("Huyện Hòa Vang", 497, VietNamDivisionType.HUYEN, "huyen_hoa_vang", 48)
    D_498 = District("Huyện Hoàng Sa", 498, VietNamDivisionType.HUYEN, "huyen_hoang_sa", 48)
    D_502 = District("Thành phố Tam Kỳ", 502, VietNamDivisionType.THANH_PHO, "thanh_pho_tam_ky", 49)
    D_503 = District("Thành phố Hội An", 503, VietNamDivisionType.THANH_PHO, "thanh_pho_hoi_an", 49)
    D_504 = District("Huyện Tây Giang", 504, VietNamDivisionType.HUYEN, "huyen_tay_giang", 49)
    D_505 = District("Huyện Đông Giang", 505, VietNamDivisionType.HUYEN, "huyen_dong_giang", 49)
    D_506 = District("Huyện Đại Lộc", 506, VietNamDivisionType.HUYEN, "huyen_dai_loc", 49)
    D_507 = District("Thị xã Điện Bàn", 507, VietNamDivisionType.THI_XA, "thi_xa_dien_ban", 49)
    D_508 = District("Huyện Duy Xuyên", 508, VietNamDivisionType.HUYEN, "huyen_duy_xuyen", 49)
    D_509 = District("Huyện Quế Sơn", 509, VietNamDivisionType.HUYEN, "huyen_que_son", 49)
    D_510 = District("Huyện Nam Giang", 510, VietNamDivisionType.HUYEN, "huyen_nam_giang", 49)
    D_511 = District("Huyện Phước Sơn", 511, VietNamDivisionType.HUYEN, "huyen_phuoc_son", 49)
    D_512 = District("Huyện Hiệp Đức", 512, VietNamDivisionType.HUYEN, "huyen_hiep_duc", 49)
    D_513 = District("Huyện Thăng Bình", 513, VietNamDivisionType.HUYEN, "huyen_thang_binh", 49)
    D_514 = District("Huyện Tiên Phước", 514, VietNamDivisionType.HUYEN, "huyen_tien_phuoc", 49)
    D_515 = District("Huyện Bắc Trà My", 515, VietNamDivisionType.HUYEN, "huyen_bac_tra_my", 49)
    D_516 = District("Huyện Nam Trà My", 516, VietNamDivisionType.HUYEN, "huyen_nam_tra_my", 49)
    D_517 = District("Huyện Núi Thành", 517, VietNamDivisionType.HUYEN, "huyen_nui_thanh", 49)
    D_518 = District("Huyện Phú Ninh", 518, VietNamDivisionType.HUYEN, "huyen_phu_ninh", 49)
    D_519 = District("Huyện Nông Sơn", 519, VietNamDivisionType.HUYEN, "huyen_nong_son", 49)
    D_522 = District("Thành phố Quảng Ngãi", 522, VietNamDivisionType.THANH_PHO, "thanh_pho_quang_ngai", 51)
    D_524 = District("Huyện Bình Sơn", 524, VietNamDivisionType.HUYEN, "huyen_binh_son", 51)
    D_525 = District("Huyện Trà Bồng", 525, VietNamDivisionType.HUYEN, "huyen_tra_bong", 51)
    D_527 = District("Huyện Sơn Tịnh", 527, VietNamDivisionType.HUYEN, "huyen_son_tinh", 51)
    D_528 = District("Huyện Tư Nghĩa", 528, VietNamDivisionType.HUYEN, "huyen_tu_nghia", 51)
    D_529 = District("Huyện Sơn Hà", 529, VietNamDivisionType.HUYEN, "huyen_son_ha", 51)
    D_530 = District("Huyện Sơn Tây", 530, VietNamDivisionType.HUYEN, "huyen_son_tay", 51)
    D_531 = District("Huyện Minh Long", 531, VietNamDivisionType.HUYEN, "huyen_minh_long", 51)
    D_532 = District("Huyện Nghĩa Hành", 532, VietNamDivisionType.HUYEN, "huyen_nghia_hanh", 51)
    D_533 = District("Huyện Mộ Đức", 533, VietNamDivisionType.HUYEN, "huyen_mo_duc", 51)
    D_534 = District("Thị xã Đức Phổ", 534, VietNamDivisionType.THI_XA, "thi_xa_duc_pho", 51)
    D_535 = District("Huyện Ba Tơ", 535, VietNamDivisionType.HUYEN, "huyen_ba_to", 51)
    D_536 = District("Huyện Lý Sơn", 536, VietNamDivisionType.HUYEN, "huyen_ly_son", 51)
    D_540 = District("Thành phố Quy Nhơn", 540, VietNamDivisionType.THANH_PHO, "thanh_pho_quy_nhon", 52)
    D_542 = District("Huyện An Lão", 542, VietNamDivisionType.HUYEN, "huyen_an_lao", 52)
    D_543 = District("Thị xã Hoài Nhơn", 543, VietNamDivisionType.THI_XA, "thi_xa_hoai_nhon", 52)
    D_544 = District("Huyện Hoài Ân", 544, VietNamDivisionType.HUYEN, "huyen_hoai_an", 52)
    D_545 = District("Huyện Phù Mỹ", 545, VietNamDivisionType.HUYEN, "huyen_phu_my", 52)
    D_546 = District("Huyện Vĩnh Thạnh", 546, VietNamDivisionType.HUYEN, "huyen_vinh_thanh", 52)
    D_547 = District("Huyện Tây Sơn", 547, VietNamDivisionType.HUYEN, "huyen_tay_son", 52)
    D_548 = District("Huyện Phù Cát", 548, VietNamDivisionType.HUYEN, "huyen_phu_cat", 52)
    D_549 = District("Thị xã An Nhơn", 549, VietNamDivisionType.THI_XA, "thi_xa_an_nhon", 52)
    D_550 = District("Huyện Tuy Phước", 550, VietNamDivisionType.HUYEN, "huyen_tuy_phuoc", 52)
    D_551 = District("Huyện Vân Canh", 551, VietNamDivisionType.HUYEN, "huyen_van_canh", 52)
    D_555 = District("Thành phố Tuy Hoà", 555, VietNamDivisionType.THANH_PHO, "thanh_pho_tuy_hoa", 54)
    D_557 = District("Thị xã Sông Cầu", 557, VietNamDivisionType.THI_XA, "thi_xa_song_cau", 54)
    D_558 = District("Huyện Đồng Xuân", 558, VietNamDivisionType.HUYEN, "huyen_dong_xuan", 54)
    D_559 = District("Huyện Tuy An", 559, VietNamDivisionType.HUYEN, "huyen_tuy_an", 54)
    D_560 = District("Huyện Sơn Hòa", 560, VietNamDivisionType.HUYEN, "huyen_son_hoa", 54)
    D_561 = District("Huyện Sông Hinh", 561, VietNamDivisionType.HUYEN, "huyen_song_hinh", 54)
    D_562 = District("Huyện Tây Hoà", 562, VietNamDivisionType.HUYEN, "huyen_tay_hoa", 54)
    D_563 = District("Huyện Phú Hoà", 563, VietNamDivisionType.HUYEN, "huyen_phu_hoa", 54)
    D_564 = District("Thị xã Đông Hòa", 564, VietNamDivisionType.THI_XA, "thi_xa_dong_hoa", 54)
    D_568 = District("Thành phố Nha Trang", 568, VietNamDivisionType.THANH_PHO, "thanh_pho_nha_trang", 56)
    D_569 = District("Thành phố Cam Ranh", 569, VietNamDivisionType.THANH_PHO, "thanh_pho_cam_ranh", 56)
    D_570 = District("Huyện Cam Lâm", 570, VietNamDivisionType.HUYEN, "huyen_cam_lam", 56)
    D_571 = District("Huyện Vạn Ninh", 571, VietNamDivisionType.HUYEN, "huyen_van_ninh", 56)
    D_572 = District("Thị xã Ninh Hòa", 572, VietNamDivisionType.THI_XA, "thi_xa_ninh_hoa", 56)
    D_573 = District("Huyện Khánh Vĩnh", 573, VietNamDivisionType.HUYEN, "huyen_khanh_vinh", 56)
    D_574 = District("Huyện Diên Khánh", 574, VietNamDivisionType.HUYEN, "huyen_dien_khanh", 56)
    D_575 = District("Huyện Khánh Sơn", 575, VietNamDivisionType.HUYEN, "huyen_khanh_son", 56)
    D_576 = District("Huyện Trường Sa", 576, VietNamDivisionType.HUYEN, "huyen_truong_sa", 56)
    D_582 = District(
        "Thành phố Phan Rang-Tháp Chàm", 582, VietNamDivisionType.THANH_PHO, "thanh_pho_phan_rang_thap_cham", 58
    )
    D_584 = District("Huyện Bác Ái", 584, VietNamDivisionType.HUYEN, "huyen_bac_ai", 58)
    D_585 = District("Huyện Ninh Sơn", 585, VietNamDivisionType.HUYEN, "huyen_ninh_son", 58)
    D_586 = District("Huyện Ninh Hải", 586, VietNamDivisionType.HUYEN, "huyen_ninh_hai", 58)
    D_587 = District("Huyện Ninh Phước", 587, VietNamDivisionType.HUYEN, "huyen_ninh_phuoc", 58)
    D_588 = District("Huyện Thuận Bắc", 588, VietNamDivisionType.HUYEN, "huyen_thuan_bac", 58)
    D_589 = District("Huyện Thuận Nam", 589, VietNamDivisionType.HUYEN, "huyen_thuan_nam", 58)
    D_593 = District("Thành phố Phan Thiết", 593, VietNamDivisionType.THANH_PHO, "thanh_pho_phan_thiet", 60)
    D_594 = District("Thị xã La Gi", 594, VietNamDivisionType.THI_XA, "thi_xa_la_gi", 60)
    D_595 = District("Huyện Tuy Phong", 595, VietNamDivisionType.HUYEN, "huyen_tuy_phong", 60)
    D_596 = District("Huyện Bắc Bình", 596, VietNamDivisionType.HUYEN, "huyen_bac_binh", 60)
    D_597 = District("Huyện Hàm Thuận Bắc", 597, VietNamDivisionType.HUYEN, "huyen_ham_thuan_bac", 60)
    D_598 = District("Huyện Hàm Thuận Nam", 598, VietNamDivisionType.HUYEN, "huyen_ham_thuan_nam", 60)
    D_599 = District("Huyện Tánh Linh", 599, VietNamDivisionType.HUYEN, "huyen_tanh_linh", 60)
    D_600 = District("Huyện Đức Linh", 600, VietNamDivisionType.HUYEN, "huyen_duc_linh", 60)
    D_601 = District("Huyện Hàm Tân", 601, VietNamDivisionType.HUYEN, "huyen_ham_tan", 60)
    D_602 = District("Huyện Phú Quí", 602, VietNamDivisionType.HUYEN, "huyen_phu_qui", 60)
    D_608 = District("Thành phố Kon Tum", 608, VietNamDivisionType.THANH_PHO, "thanh_pho_kon_tum", 62)
    D_610 = District("Huyện Đắk Glei", 610, VietNamDivisionType.HUYEN, "huyen_dak_glei", 62)
    D_611 = District("Huyện Ngọc Hồi", 611, VietNamDivisionType.HUYEN, "huyen_ngoc_hoi", 62)
    D_612 = District("Huyện Đắk Tô", 612, VietNamDivisionType.HUYEN, "huyen_dak_to", 62)
    D_613 = District("Huyện Kon Plông", 613, VietNamDivisionType.HUYEN, "huyen_kon_plong", 62)
    D_614 = District("Huyện Kon Rẫy", 614, VietNamDivisionType.HUYEN, "huyen_kon_ray", 62)
    D_615 = District("Huyện Đắk Hà", 615, VietNamDivisionType.HUYEN, "huyen_dak_ha", 62)
    D_616 = District("Huyện Sa Thầy", 616, VietNamDivisionType.HUYEN, "huyen_sa_thay", 62)
    D_617 = District("Huyện Tu Mơ Rông", 617, VietNamDivisionType.HUYEN, "huyen_tu_mo_rong", 62)
    D_618 = District("Huyện Ia H' Drai", 618, VietNamDivisionType.HUYEN, "huyen_ia_h_drai", 62)
    D_622 = District("Thành phố Pleiku", 622, VietNamDivisionType.THANH_PHO, "thanh_pho_pleiku", 64)
    D_623 = District("Thị xã An Khê", 623, VietNamDivisionType.THI_XA, "thi_xa_an_khe", 64)
    D_624 = District("Thị xã Ayun Pa", 624, VietNamDivisionType.THI_XA, "thi_xa_ayun_pa", 64)
    D_625 = District("Huyện KBang", 625, VietNamDivisionType.HUYEN, "huyen_kbang", 64)
    D_626 = District("Huyện Đăk Đoa", 626, VietNamDivisionType.HUYEN, "huyen_dak_doa", 64)
    D_627 = District("Huyện Chư Păh", 627, VietNamDivisionType.HUYEN, "huyen_chu_pah", 64)
    D_628 = District("Huyện Ia Grai", 628, VietNamDivisionType.HUYEN, "huyen_ia_grai", 64)
    D_629 = District("Huyện Mang Yang", 629, VietNamDivisionType.HUYEN, "huyen_mang_yang", 64)
    D_630 = District("Huyện Kông Chro", 630, VietNamDivisionType.HUYEN, "huyen_kong_chro", 64)
    D_631 = District("Huyện Đức Cơ", 631, VietNamDivisionType.HUYEN, "huyen_duc_co", 64)
    D_632 = District("Huyện Chư Prông", 632, VietNamDivisionType.HUYEN, "huyen_chu_prong", 64)
    D_633 = District("Huyện Chư Sê", 633, VietNamDivisionType.HUYEN, "huyen_chu_se", 64)
    D_634 = District("Huyện Đăk Pơ", 634, VietNamDivisionType.HUYEN, "huyen_dak_po", 64)
    D_635 = District("Huyện Ia Pa", 635, VietNamDivisionType.HUYEN, "huyen_ia_pa", 64)
    D_637 = District("Huyện Krông Pa", 637, VietNamDivisionType.HUYEN, "huyen_krong_pa", 64)
    D_638 = District("Huyện Phú Thiện", 638, VietNamDivisionType.HUYEN, "huyen_phu_thien", 64)
    D_639 = District("Huyện Chư Pưh", 639, VietNamDivisionType.HUYEN, "huyen_chu_puh", 64)
    D_643 = District("Thành phố Buôn Ma Thuột", 643, VietNamDivisionType.THANH_PHO, "thanh_pho_buon_ma_thuot", 66)
    D_644 = District("Thị xã Buôn Hồ", 644, VietNamDivisionType.THI_XA, "thi_xa_buon_ho", 66)
    D_645 = District("Huyện Ea H'leo", 645, VietNamDivisionType.HUYEN, "huyen_ea_hleo", 66)
    D_646 = District("Huyện Ea Súp", 646, VietNamDivisionType.HUYEN, "huyen_ea_sup", 66)
    D_647 = District("Huyện Buôn Đôn", 647, VietNamDivisionType.HUYEN, "huyen_buon_don", 66)
    D_648 = District("Huyện Cư M'gar", 648, VietNamDivisionType.HUYEN, "huyen_cu_mgar", 66)
    D_649 = District("Huyện Krông Búk", 649, VietNamDivisionType.HUYEN, "huyen_krong_buk", 66)
    D_650 = District("Huyện Krông Năng", 650, VietNamDivisionType.HUYEN, "huyen_krong_nang", 66)
    D_651 = District("Huyện Ea Kar", 651, VietNamDivisionType.HUYEN, "huyen_ea_kar", 66)
    D_652 = District("Huyện M'Đrắk", 652, VietNamDivisionType.HUYEN, "huyen_mdrak", 66)
    D_653 = District("Huyện Krông Bông", 653, VietNamDivisionType.HUYEN, "huyen_krong_bong", 66)
    D_654 = District("Huyện Krông Pắc", 654, VietNamDivisionType.HUYEN, "huyen_krong_pac", 66)
    D_655 = District("Huyện Krông A Na", 655, VietNamDivisionType.HUYEN, "huyen_krong_a_na", 66)
    D_656 = District("Huyện Lắk", 656, VietNamDivisionType.HUYEN, "huyen_lak", 66)
    D_657 = District("Huyện Cư Kuin", 657, VietNamDivisionType.HUYEN, "huyen_cu_kuin", 66)
    D_660 = District("Thành phố Gia Nghĩa", 660, VietNamDivisionType.THANH_PHO, "thanh_pho_gia_nghia", 67)
    D_661 = District("Huyện Đăk Glong", 661, VietNamDivisionType.HUYEN, "huyen_dak_glong", 67)
    D_662 = District("Huyện Cư Jút", 662, VietNamDivisionType.HUYEN, "huyen_cu_jut", 67)
    D_663 = District("Huyện Đắk Mil", 663, VietNamDivisionType.HUYEN, "huyen_dak_mil", 67)
    D_664 = District("Huyện Krông Nô", 664, VietNamDivisionType.HUYEN, "huyen_krong_no", 67)
    D_665 = District("Huyện Đắk Song", 665, VietNamDivisionType.HUYEN, "huyen_dak_song", 67)
    D_666 = District("Huyện Đắk R'Lấp", 666, VietNamDivisionType.HUYEN, "huyen_dak_rlap", 67)
    D_667 = District("Huyện Tuy Đức", 667, VietNamDivisionType.HUYEN, "huyen_tuy_duc", 67)
    D_672 = District("Thành phố Đà Lạt", 672, VietNamDivisionType.THANH_PHO, "thanh_pho_da_lat", 68)
    D_673 = District("Thành phố Bảo Lộc", 673, VietNamDivisionType.THANH_PHO, "thanh_pho_bao_loc", 68)
    D_674 = District("Huyện Đam Rông", 674, VietNamDivisionType.HUYEN, "huyen_dam_rong", 68)
    D_675 = District("Huyện Lạc Dương", 675, VietNamDivisionType.HUYEN, "huyen_lac_duong", 68)
    D_676 = District("Huyện Lâm Hà", 676, VietNamDivisionType.HUYEN, "huyen_lam_ha", 68)
    D_677 = District("Huyện Đơn Dương", 677, VietNamDivisionType.HUYEN, "huyen_don_duong", 68)
    D_678 = District("Huyện Đức Trọng", 678, VietNamDivisionType.HUYEN, "huyen_duc_trong", 68)
    D_679 = District("Huyện Di Linh", 679, VietNamDivisionType.HUYEN, "huyen_di_linh", 68)
    D_680 = District("Huyện Bảo Lâm", 680, VietNamDivisionType.HUYEN, "huyen_bao_lam", 68)
    D_681 = District("Huyện Đạ Huoai", 681, VietNamDivisionType.HUYEN, "huyen_da_huoai", 68)
    D_682 = District("Huyện Đạ Tẻh", 682, VietNamDivisionType.HUYEN, "huyen_da_teh", 68)
    D_683 = District("Huyện Cát Tiên", 683, VietNamDivisionType.HUYEN, "huyen_cat_tien", 68)
    D_688 = District("Thị xã Phước Long", 688, VietNamDivisionType.THI_XA, "thi_xa_phuoc_long", 70)
    D_689 = District("Thành phố Đồng Xoài", 689, VietNamDivisionType.THANH_PHO, "thanh_pho_dong_xoai", 70)
    D_690 = District("Thị xã Bình Long", 690, VietNamDivisionType.THI_XA, "thi_xa_binh_long", 70)
    D_691 = District("Huyện Bù Gia Mập", 691, VietNamDivisionType.HUYEN, "huyen_bu_gia_map", 70)
    D_692 = District("Huyện Lộc Ninh", 692, VietNamDivisionType.HUYEN, "huyen_loc_ninh", 70)
    D_693 = District("Huyện Bù Đốp", 693, VietNamDivisionType.HUYEN, "huyen_bu_dop", 70)
    D_694 = District("Huyện Hớn Quản", 694, VietNamDivisionType.HUYEN, "huyen_hon_quan", 70)
    D_695 = District("Huyện Đồng Phú", 695, VietNamDivisionType.HUYEN, "huyen_dong_phu", 70)
    D_696 = District("Huyện Bù Đăng", 696, VietNamDivisionType.HUYEN, "huyen_bu_dang", 70)
    D_697 = District("Huyện Chơn Thành", 697, VietNamDivisionType.HUYEN, "huyen_chon_thanh", 70)
    D_698 = District("Huyện Phú Riềng", 698, VietNamDivisionType.HUYEN, "huyen_phu_rieng", 70)
    D_703 = District("Thành phố Tây Ninh", 703, VietNamDivisionType.THANH_PHO, "thanh_pho_tay_ninh", 72)
    D_705 = District("Huyện Tân Biên", 705, VietNamDivisionType.HUYEN, "huyen_tan_bien", 72)
    D_706 = District("Huyện Tân Châu", 706, VietNamDivisionType.HUYEN, "huyen_tan_chau", 72)
    D_707 = District("Huyện Dương Minh Châu", 707, VietNamDivisionType.HUYEN, "huyen_duong_minh_chau", 72)
    D_708 = District("Huyện Châu Thành", 708, VietNamDivisionType.HUYEN, "huyen_chau_thanh", 72)
    D_709 = District("Thị xã Hòa Thành", 709, VietNamDivisionType.THI_XA, "thi_xa_hoa_thanh", 72)
    D_710 = District("Huyện Gò Dầu", 710, VietNamDivisionType.HUYEN, "huyen_go_dau", 72)
    D_711 = District("Huyện Bến Cầu", 711, VietNamDivisionType.HUYEN, "huyen_ben_cau", 72)
    D_712 = District("Thị xã Trảng Bàng", 712, VietNamDivisionType.THI_XA, "thi_xa_trang_bang", 72)
    D_718 = District("Thành phố Thủ Dầu Một", 718, VietNamDivisionType.THANH_PHO, "thanh_pho_thu_dau_mot", 74)
    D_719 = District("Huyện Bàu Bàng", 719, VietNamDivisionType.HUYEN, "huyen_bau_bang", 74)
    D_720 = District("Huyện Dầu Tiếng", 720, VietNamDivisionType.HUYEN, "huyen_dau_tieng", 74)
    D_721 = District("Thị xã Bến Cát", 721, VietNamDivisionType.THI_XA, "thi_xa_ben_cat", 74)
    D_722 = District("Huyện Phú Giáo", 722, VietNamDivisionType.HUYEN, "huyen_phu_giao", 74)
    D_723 = District("Thị xã Tân Uyên", 723, VietNamDivisionType.THI_XA, "thi_xa_tan_uyen", 74)
    D_724 = District("Thành phố Dĩ An", 724, VietNamDivisionType.THANH_PHO, "thanh_pho_di_an", 74)
    D_725 = District("Thành phố Thuận An", 725, VietNamDivisionType.THANH_PHO, "thanh_pho_thuan_an", 74)
    D_726 = District("Huyện Bắc Tân Uyên", 726, VietNamDivisionType.HUYEN, "huyen_bac_tan_uyen", 74)
    D_731 = District("Thành phố Biên Hòa", 731, VietNamDivisionType.THANH_PHO, "thanh_pho_bien_hoa", 75)
    D_732 = District("Thành phố Long Khánh", 732, VietNamDivisionType.THANH_PHO, "thanh_pho_long_khanh", 75)
    D_734 = District("Huyện Tân Phú", 734, VietNamDivisionType.HUYEN, "huyen_tan_phu", 75)
    D_735 = District("Huyện Vĩnh Cửu", 735, VietNamDivisionType.HUYEN, "huyen_vinh_cuu", 75)
    D_736 = District("Huyện Định Quán", 736, VietNamDivisionType.HUYEN, "huyen_dinh_quan", 75)
    D_737 = District("Huyện Trảng Bom", 737, VietNamDivisionType.HUYEN, "huyen_trang_bom", 75)
    D_738 = District("Huyện Thống Nhất", 738, VietNamDivisionType.HUYEN, "huyen_thong_nhat", 75)
    D_739 = District("Huyện Cẩm Mỹ", 739, VietNamDivisionType.HUYEN, "huyen_cam_my", 75)
    D_740 = District("Huyện Long Thành", 740, VietNamDivisionType.HUYEN, "huyen_long_thanh", 75)
    D_741 = District("Huyện Xuân Lộc", 741, VietNamDivisionType.HUYEN, "huyen_xuan_loc", 75)
    D_742 = District("Huyện Nhơn Trạch", 742, VietNamDivisionType.HUYEN, "huyen_nhon_trach", 75)
    D_747 = District("Thành phố Vũng Tàu", 747, VietNamDivisionType.THANH_PHO, "thanh_pho_vung_tau", 77)
    D_748 = District("Thành phố Bà Rịa", 748, VietNamDivisionType.THANH_PHO, "thanh_pho_ba_ria", 77)
    D_750 = District("Huyện Châu Đức", 750, VietNamDivisionType.HUYEN, "huyen_chau_duc", 77)
    D_751 = District("Huyện Xuyên Mộc", 751, VietNamDivisionType.HUYEN, "huyen_xuyen_moc", 77)
    D_752 = District("Huyện Long Điền", 752, VietNamDivisionType.HUYEN, "huyen_long_dien", 77)
    D_753 = District("Huyện Đất Đỏ", 753, VietNamDivisionType.HUYEN, "huyen_dat_do", 77)
    D_754 = District("Thị xã Phú Mỹ", 754, VietNamDivisionType.THI_XA, "thi_xa_phu_my", 77)
    D_755 = District("Huyện Côn Đảo", 755, VietNamDivisionType.HUYEN, "huyen_con_dao", 77)
    D_760 = District("Quận 1", 760, VietNamDivisionType.QUAN, "quan_1", 79)
    D_761 = District("Quận 12", 761, VietNamDivisionType.QUAN, "quan_12", 79)
    D_764 = District("Quận Gò Vấp", 764, VietNamDivisionType.QUAN, "quan_go_vap", 79)
    D_765 = District("Quận Bình Thạnh", 765, VietNamDivisionType.QUAN, "quan_binh_thanh", 79)
    D_766 = District("Quận Tân Bình", 766, VietNamDivisionType.QUAN, "quan_tan_binh", 79)
    D_767 = District("Quận Tân Phú", 767, VietNamDivisionType.QUAN, "quan_tan_phu", 79)
    D_768 = District("Quận Phú Nhuận", 768, VietNamDivisionType.QUAN, "quan_phu_nhuan", 79)
    D_769 = District("Thành phố Thủ Đức", 769, VietNamDivisionType.THANH_PHO, "thanh_pho_thu_duc", 79)
    D_770 = District("Quận 3", 770, VietNamDivisionType.QUAN, "quan_3", 79)
    D_771 = District("Quận 10", 771, VietNamDivisionType.QUAN, "quan_10", 79)
    D_772 = District("Quận 11", 772, VietNamDivisionType.QUAN, "quan_11", 79)
    D_773 = District("Quận 4", 773, VietNamDivisionType.QUAN, "quan_4", 79)
    D_774 = District("Quận 5", 774, VietNamDivisionType.QUAN, "quan_5", 79)
    D_775 = District("Quận 6", 775, VietNamDivisionType.QUAN, "quan_6", 79)
    D_776 = District("Quận 8", 776, VietNamDivisionType.QUAN, "quan_8", 79)
    D_777 = District("Quận Bình Tân", 777, VietNamDivisionType.QUAN, "quan_binh_tan", 79)
    D_778 = District("Quận 7", 778, VietNamDivisionType.QUAN, "quan_7", 79)
    D_783 = District("Huyện Củ Chi", 783, VietNamDivisionType.HUYEN, "huyen_cu_chi", 79)
    D_784 = District("Huyện Hóc Môn", 784, VietNamDivisionType.HUYEN, "huyen_hoc_mon", 79)
    D_785 = District("Huyện Bình Chánh", 785, VietNamDivisionType.HUYEN, "huyen_binh_chanh", 79)
    D_786 = District("Huyện Nhà Bè", 786, VietNamDivisionType.HUYEN, "huyen_nha_be", 79)
    D_787 = District("Huyện Cần Giờ", 787, VietNamDivisionType.HUYEN, "huyen_can_gio", 79)
    D_794 = District("Thành phố Tân An", 794, VietNamDivisionType.THANH_PHO, "thanh_pho_tan_an", 80)
    D_795 = District("Thị xã Kiến Tường", 795, VietNamDivisionType.THI_XA, "thi_xa_kien_tuong", 80)
    D_796 = District("Huyện Tân Hưng", 796, VietNamDivisionType.HUYEN, "huyen_tan_hung", 80)
    D_797 = District("Huyện Vĩnh Hưng", 797, VietNamDivisionType.HUYEN, "huyen_vinh_hung", 80)
    D_798 = District("Huyện Mộc Hóa", 798, VietNamDivisionType.HUYEN, "huyen_moc_hoa", 80)
    D_799 = District("Huyện Tân Thạnh", 799, VietNamDivisionType.HUYEN, "huyen_tan_thanh", 80)
    D_800 = District("Huyện Thạnh Hóa", 800, VietNamDivisionType.HUYEN, "huyen_thanh_hoa", 80)
    D_801 = District("Huyện Đức Huệ", 801, VietNamDivisionType.HUYEN, "huyen_duc_hue", 80)
    D_802 = District("Huyện Đức Hòa", 802, VietNamDivisionType.HUYEN, "huyen_duc_hoa", 80)
    D_803 = District("Huyện Bến Lức", 803, VietNamDivisionType.HUYEN, "huyen_ben_luc", 80)
    D_804 = District("Huyện Thủ Thừa", 804, VietNamDivisionType.HUYEN, "huyen_thu_thua", 80)
    D_805 = District("Huyện Tân Trụ", 805, VietNamDivisionType.HUYEN, "huyen_tan_tru", 80)
    D_806 = District("Huyện Cần Đước", 806, VietNamDivisionType.HUYEN, "huyen_can_duoc", 80)
    D_807 = District("Huyện Cần Giuộc", 807, VietNamDivisionType.HUYEN, "huyen_can_giuoc", 80)
    D_808 = District("Huyện Châu Thành", 808, VietNamDivisionType.HUYEN, "huyen_chau_thanh", 80)
    D_815 = District("Thành phố Mỹ Tho", 815, VietNamDivisionType.THANH_PHO, "thanh_pho_my_tho", 82)
    D_816 = District("Thị xã Gò Công", 816, VietNamDivisionType.THI_XA, "thi_xa_go_cong", 82)
    D_817 = District("Thị xã Cai Lậy", 817, VietNamDivisionType.THI_XA, "thi_xa_cai_lay", 82)
    D_818 = District("Huyện Tân Phước", 818, VietNamDivisionType.HUYEN, "huyen_tan_phuoc", 82)
    D_819 = District("Huyện Cái Bè", 819, VietNamDivisionType.HUYEN, "huyen_cai_be", 82)
    D_820 = District("Huyện Cai Lậy", 820, VietNamDivisionType.HUYEN, "huyen_cai_lay", 82)
    D_821 = District("Huyện Châu Thành", 821, VietNamDivisionType.HUYEN, "huyen_chau_thanh", 82)
    D_822 = District("Huyện Chợ Gạo", 822, VietNamDivisionType.HUYEN, "huyen_cho_gao", 82)
    D_823 = District("Huyện Gò Công Tây", 823, VietNamDivisionType.HUYEN, "huyen_go_cong_tay", 82)
    D_824 = District("Huyện Gò Công Đông", 824, VietNamDivisionType.HUYEN, "huyen_go_cong_dong", 82)
    D_825 = District("Huyện Tân Phú Đông", 825, VietNamDivisionType.HUYEN, "huyen_tan_phu_dong", 82)
    D_829 = District("Thành phố Bến Tre", 829, VietNamDivisionType.THANH_PHO, "thanh_pho_ben_tre", 83)
    D_831 = District("Huyện Châu Thành", 831, VietNamDivisionType.HUYEN, "huyen_chau_thanh", 83)
    D_832 = District("Huyện Chợ Lách", 832, VietNamDivisionType.HUYEN, "huyen_cho_lach", 83)
    D_833 = District("Huyện Mỏ Cày Nam", 833, VietNamDivisionType.HUYEN, "huyen_mo_cay_nam", 83)
    D_834 = District("Huyện Giồng Trôm", 834, VietNamDivisionType.HUYEN, "huyen_giong_trom", 83)
    D_835 = District("Huyện Bình Đại", 835, VietNamDivisionType.HUYEN, "huyen_binh_dai", 83)
    D_836 = District("Huyện Ba Tri", 836, VietNamDivisionType.HUYEN, "huyen_ba_tri", 83)
    D_837 = District("Huyện Thạnh Phú", 837, VietNamDivisionType.HUYEN, "huyen_thanh_phu", 83)
    D_838 = District("Huyện Mỏ Cày Bắc", 838, VietNamDivisionType.HUYEN, "huyen_mo_cay_bac", 83)
    D_842 = District("Thành phố Trà Vinh", 842, VietNamDivisionType.THANH_PHO, "thanh_pho_tra_vinh", 84)
    D_844 = District("Huyện Càng Long", 844, VietNamDivisionType.HUYEN, "huyen_cang_long", 84)
    D_845 = District("Huyện Cầu Kè", 845, VietNamDivisionType.HUYEN, "huyen_cau_ke", 84)
    D_846 = District("Huyện Tiểu Cần", 846, VietNamDivisionType.HUYEN, "huyen_tieu_can", 84)
    D_847 = District("Huyện Châu Thành", 847, VietNamDivisionType.HUYEN, "huyen_chau_thanh", 84)
    D_848 = District("Huyện Cầu Ngang", 848, VietNamDivisionType.HUYEN, "huyen_cau_ngang", 84)
    D_849 = District("Huyện Trà Cú", 849, VietNamDivisionType.HUYEN, "huyen_tra_cu", 84)
    D_850 = District("Huyện Duyên Hải", 850, VietNamDivisionType.HUYEN, "huyen_duyen_hai", 84)
    D_851 = District("Thị xã Duyên Hải", 851, VietNamDivisionType.THI_XA, "thi_xa_duyen_hai", 84)
    D_855 = District("Thành phố Vĩnh Long", 855, VietNamDivisionType.THANH_PHO, "thanh_pho_vinh_long", 86)
    D_857 = District("Huyện Long Hồ", 857, VietNamDivisionType.HUYEN, "huyen_long_ho", 86)
    D_858 = District("Huyện Mang Thít", 858, VietNamDivisionType.HUYEN, "huyen_mang_thit", 86)
    D_859 = District("Huyện Vũng Liêm", 859, VietNamDivisionType.HUYEN, "huyen_vung_liem", 86)
    D_860 = District("Huyện Tam Bình", 860, VietNamDivisionType.HUYEN, "huyen_tam_binh", 86)
    D_861 = District("Thị xã Bình Minh", 861, VietNamDivisionType.THI_XA, "thi_xa_binh_minh", 86)
    D_862 = District("Huyện Trà Ôn", 862, VietNamDivisionType.HUYEN, "huyen_tra_on", 86)
    D_863 = District("Huyện Bình Tân", 863, VietNamDivisionType.HUYEN, "huyen_binh_tan", 86)
    D_866 = District("Thành phố Cao Lãnh", 866, VietNamDivisionType.THANH_PHO, "thanh_pho_cao_lanh", 87)
    D_867 = District("Thành phố Sa Đéc", 867, VietNamDivisionType.THANH_PHO, "thanh_pho_sa_dec", 87)
    D_868 = District("Thành phố Hồng Ngự", 868, VietNamDivisionType.THANH_PHO, "thanh_pho_hong_ngu", 87)
    D_869 = District("Huyện Tân Hồng", 869, VietNamDivisionType.HUYEN, "huyen_tan_hong", 87)
    D_870 = District("Huyện Hồng Ngự", 870, VietNamDivisionType.HUYEN, "huyen_hong_ngu", 87)
    D_871 = District("Huyện Tam Nông", 871, VietNamDivisionType.HUYEN, "huyen_tam_nong", 87)
    D_872 = District("Huyện Tháp Mười", 872, VietNamDivisionType.HUYEN, "huyen_thap_muoi", 87)
    D_873 = District("Huyện Cao Lãnh", 873, VietNamDivisionType.HUYEN, "huyen_cao_lanh", 87)
    D_874 = District("Huyện Thanh Bình", 874, VietNamDivisionType.HUYEN, "huyen_thanh_binh", 87)
    D_875 = District("Huyện Lấp Vò", 875, VietNamDivisionType.HUYEN, "huyen_lap_vo", 87)
    D_876 = District("Huyện Lai Vung", 876, VietNamDivisionType.HUYEN, "huyen_lai_vung", 87)
    D_877 = District("Huyện Châu Thành", 877, VietNamDivisionType.HUYEN, "huyen_chau_thanh", 87)
    D_883 = District("Thành phố Long Xuyên", 883, VietNamDivisionType.THANH_PHO, "thanh_pho_long_xuyen", 89)
    D_884 = District("Thành phố Châu Đốc", 884, VietNamDivisionType.THANH_PHO, "thanh_pho_chau_doc", 89)
    D_886 = District("Huyện An Phú", 886, VietNamDivisionType.HUYEN, "huyen_an_phu", 89)
    D_887 = District("Thị xã Tân Châu", 887, VietNamDivisionType.THI_XA, "thi_xa_tan_chau", 89)
    D_888 = District("Huyện Phú Tân", 888, VietNamDivisionType.HUYEN, "huyen_phu_tan", 89)
    D_889 = District("Huyện Châu Phú", 889, VietNamDivisionType.HUYEN, "huyen_chau_phu", 89)
    D_890 = District("Huyện Tịnh Biên", 890, VietNamDivisionType.HUYEN, "huyen_tinh_bien", 89)
    D_891 = District("Huyện Tri Tôn", 891, VietNamDivisionType.HUYEN, "huyen_tri_ton", 89)
    D_892 = District("Huyện Châu Thành", 892, VietNamDivisionType.HUYEN, "huyen_chau_thanh", 89)
    D_893 = District("Huyện Chợ Mới", 893, VietNamDivisionType.HUYEN, "huyen_cho_moi", 89)
    D_894 = District("Huyện Thoại Sơn", 894, VietNamDivisionType.HUYEN, "huyen_thoai_son", 89)
    D_899 = District("Thành phố Rạch Giá", 899, VietNamDivisionType.THANH_PHO, "thanh_pho_rach_gia", 91)
    D_900 = District("Thành phố Hà Tiên", 900, VietNamDivisionType.THANH_PHO, "thanh_pho_ha_tien", 91)
    D_902 = District("Huyện Kiên Lương", 902, VietNamDivisionType.HUYEN, "huyen_kien_luong", 91)
    D_903 = District("Huyện Hòn Đất", 903, VietNamDivisionType.HUYEN, "huyen_hon_dat", 91)
    D_904 = District("Huyện Tân Hiệp", 904, VietNamDivisionType.HUYEN, "huyen_tan_hiep", 91)
    D_905 = District("Huyện Châu Thành", 905, VietNamDivisionType.HUYEN, "huyen_chau_thanh", 91)
    D_906 = District("Huyện Giồng Riềng", 906, VietNamDivisionType.HUYEN, "huyen_giong_rieng", 91)
    D_907 = District("Huyện Gò Quao", 907, VietNamDivisionType.HUYEN, "huyen_go_quao", 91)
    D_908 = District("Huyện An Biên", 908, VietNamDivisionType.HUYEN, "huyen_an_bien", 91)
    D_909 = District("Huyện An Minh", 909, VietNamDivisionType.HUYEN, "huyen_an_minh", 91)
    D_910 = District("Huyện Vĩnh Thuận", 910, VietNamDivisionType.HUYEN, "huyen_vinh_thuan", 91)
    D_911 = District("Thành phố Phú Quốc", 911, VietNamDivisionType.THANH_PHO, "thanh_pho_phu_quoc", 91)
    D_912 = District("Huyện Kiên Hải", 912, VietNamDivisionType.HUYEN, "huyen_kien_hai", 91)
    D_913 = District("Huyện U Minh Thượng", 913, VietNamDivisionType.HUYEN, "huyen_u_minh_thuong", 91)
    D_914 = District("Huyện Giang Thành", 914, VietNamDivisionType.HUYEN, "huyen_giang_thanh", 91)
    D_916 = District("Quận Ninh Kiều", 916, VietNamDivisionType.QUAN, "quan_ninh_kieu", 92)
    D_917 = District("Quận Ô Môn", 917, VietNamDivisionType.QUAN, "quan_o_mon", 92)
    D_918 = District("Quận Bình Thuỷ", 918, VietNamDivisionType.QUAN, "quan_binh_thuy", 92)
    D_919 = District("Quận Cái Răng", 919, VietNamDivisionType.QUAN, "quan_cai_rang", 92)
    D_923 = District("Quận Thốt Nốt", 923, VietNamDivisionType.QUAN, "quan_thot_not", 92)
    D_924 = District("Huyện Vĩnh Thạnh", 924, VietNamDivisionType.HUYEN, "huyen_vinh_thanh", 92)
    D_925 = District("Huyện Cờ Đỏ", 925, VietNamDivisionType.HUYEN, "huyen_co_do", 92)
    D_926 = District("Huyện Phong Điền", 926, VietNamDivisionType.HUYEN, "huyen_phong_dien", 92)
    D_927 = District("Huyện Thới Lai", 927, VietNamDivisionType.HUYEN, "huyen_thoi_lai", 92)
    D_930 = District("Thành phố Vị Thanh", 930, VietNamDivisionType.THANH_PHO, "thanh_pho_vi_thanh", 93)
    D_931 = District("Thành phố Ngã Bảy", 931, VietNamDivisionType.THANH_PHO, "thanh_pho_nga_bay", 93)
    D_932 = District("Huyện Châu Thành A", 932, VietNamDivisionType.HUYEN, "huyen_chau_thanh_a", 93)
    D_933 = District("Huyện Châu Thành", 933, VietNamDivisionType.HUYEN, "huyen_chau_thanh", 93)
    D_934 = District("Huyện Phụng Hiệp", 934, VietNamDivisionType.HUYEN, "huyen_phung_hiep", 93)
    D_935 = District("Huyện Vị Thuỷ", 935, VietNamDivisionType.HUYEN, "huyen_vi_thuy", 93)
    D_936 = District("Huyện Long Mỹ", 936, VietNamDivisionType.HUYEN, "huyen_long_my", 93)
    D_937 = District("Thị xã Long Mỹ", 937, VietNamDivisionType.THI_XA, "thi_xa_long_my", 93)
    D_941 = District("Thành phố Sóc Trăng", 941, VietNamDivisionType.THANH_PHO, "thanh_pho_soc_trang", 94)
    D_942 = District("Huyện Châu Thành", 942, VietNamDivisionType.HUYEN, "huyen_chau_thanh", 94)
    D_943 = District("Huyện Kế Sách", 943, VietNamDivisionType.HUYEN, "huyen_ke_sach", 94)
    D_944 = District("Huyện Mỹ Tú", 944, VietNamDivisionType.HUYEN, "huyen_my_tu", 94)
    D_945 = District("Huyện Cù Lao Dung", 945, VietNamDivisionType.HUYEN, "huyen_cu_lao_dung", 94)
    D_946 = District("Huyện Long Phú", 946, VietNamDivisionType.HUYEN, "huyen_long_phu", 94)
    D_947 = District("Huyện Mỹ Xuyên", 947, VietNamDivisionType.HUYEN, "huyen_my_xuyen", 94)
    D_948 = District("Thị xã Ngã Năm", 948, VietNamDivisionType.THI_XA, "thi_xa_nga_nam", 94)
    D_949 = District("Huyện Thạnh Trị", 949, VietNamDivisionType.HUYEN, "huyen_thanh_tri", 94)
    D_950 = District("Thị xã Vĩnh Châu", 950, VietNamDivisionType.THI_XA, "thi_xa_vinh_chau", 94)
    D_951 = District("Huyện Trần Đề", 951, VietNamDivisionType.HUYEN, "huyen_tran_de", 94)
    D_954 = District("Thành phố Bạc Liêu", 954, VietNamDivisionType.THANH_PHO, "thanh_pho_bac_lieu", 95)
    D_956 = District("Huyện Hồng Dân", 956, VietNamDivisionType.HUYEN, "huyen_hong_dan", 95)
    D_957 = District("Huyện Phước Long", 957, VietNamDivisionType.HUYEN, "huyen_phuoc_long", 95)
    D_958 = District("Huyện Vĩnh Lợi", 958, VietNamDivisionType.HUYEN, "huyen_vinh_loi", 95)
    D_959 = District("Thị xã Giá Rai", 959, VietNamDivisionType.THI_XA, "thi_xa_gia_rai", 95)
    D_960 = District("Huyện Đông Hải", 960, VietNamDivisionType.HUYEN, "huyen_dong_hai", 95)
    D_961 = District("Huyện Hoà Bình", 961, VietNamDivisionType.HUYEN, "huyen_hoa_binh", 95)
    D_964 = District("Thành phố Cà Mau", 964, VietNamDivisionType.THANH_PHO, "thanh_pho_ca_mau", 96)
    D_966 = District("Huyện U Minh", 966, VietNamDivisionType.HUYEN, "huyen_u_minh", 96)
    D_967 = District("Huyện Thới Bình", 967, VietNamDivisionType.HUYEN, "huyen_thoi_binh", 96)
    D_968 = District("Huyện Trần Văn Thời", 968, VietNamDivisionType.HUYEN, "huyen_tran_van_thoi", 96)
    D_969 = District("Huyện Cái Nước", 969, VietNamDivisionType.HUYEN, "huyen_cai_nuoc", 96)
    D_970 = District("Huyện Đầm Dơi", 970, VietNamDivisionType.HUYEN, "huyen_dam_doi", 96)
    D_971 = District("Huyện Năm Căn", 971, VietNamDivisionType.HUYEN, "huyen_nam_can", 96)
    D_972 = District("Huyện Phú Tân", 972, VietNamDivisionType.HUYEN, "huyen_phu_tan", 96)
    D_973 = District("Huyện Ngọc Hiển", 973, VietNamDivisionType.HUYEN, "huyen_ngoc_hien", 96)


class DistrictDEnum(Enum):
    """
    District Enum type, whose member name is more descriptive, with district name.

    It helps developer have more idea what District he is selecting.
    """

    BA_DINH_HN = DistrictEnum.D_1.value
    HOAN_KIEM_HN = DistrictEnum.D_2.value
    TAY_HO_HN = DistrictEnum.D_3.value
    LONG_BIEN_HN = DistrictEnum.D_4.value
    CAU_GIAY_HN = DistrictEnum.D_5.value
    DONG_DA_HN = DistrictEnum.D_6.value
    HAI_BA_TRUNG_HN = DistrictEnum.D_7.value
    HOANG_MAI_HN = DistrictEnum.D_8.value
    THANH_XUAN_HN = DistrictEnum.D_9.value
    SOC_SON_HN = DistrictEnum.D_16.value
    DONG_ANH_HN = DistrictEnum.D_17.value
    GIA_LAM_HN = DistrictEnum.D_18.value
    NAM_TU_LIEM_HN = DistrictEnum.D_19.value
    THANH_TRI_HN = DistrictEnum.D_20.value
    BAC_TU_LIEM_HN = DistrictEnum.D_21.value
    ME_LINH_HN = DistrictEnum.D_250.value
    HA_DONG_HN = DistrictEnum.D_268.value
    SON_TAY_HN = DistrictEnum.D_269.value
    BA_VI_HN = DistrictEnum.D_271.value
    PHUC_THO_HN = DistrictEnum.D_272.value
    DAN_PHUONG_HN = DistrictEnum.D_273.value
    HOAI_DUC_HN = DistrictEnum.D_274.value
    QUOC_OAI_HN = DistrictEnum.D_275.value
    THACH_THAT_HN = DistrictEnum.D_276.value
    CHUONG_MY_HN = DistrictEnum.D_277.value
    THANH_OAI_HN = DistrictEnum.D_278.value
    THUONG_TIN_HN = DistrictEnum.D_279.value
    PHU_XUYEN_HN = DistrictEnum.D_280.value
    UNG_HOA_HN = DistrictEnum.D_281.value
    MY_DUC_HN = DistrictEnum.D_282.value
    HA_GIANG_HG = DistrictEnum.D_24.value
    DONG_VAN_HG = DistrictEnum.D_26.value
    MEO_VAC_HG = DistrictEnum.D_27.value
    YEN_MINH_HG = DistrictEnum.D_28.value
    QUAN_BA_HG = DistrictEnum.D_29.value
    VI_XUYEN_HG = DistrictEnum.D_30.value
    BAC_ME_HG = DistrictEnum.D_31.value
    HOANG_SU_PHI_HG = DistrictEnum.D_32.value
    XIN_MAN_HG = DistrictEnum.D_33.value
    BAC_QUANG_HG = DistrictEnum.D_34.value
    QUANG_BINH_HG = DistrictEnum.D_35.value
    CAO_BANG_CB = DistrictEnum.D_40.value
    BAO_LAM_CB = DistrictEnum.D_42.value
    BAO_LAC_CB = DistrictEnum.D_43.value
    HA_QUANG_CB = DistrictEnum.D_45.value
    TRUNG_KHANH_CB = DistrictEnum.D_47.value
    HA_LANG_CB = DistrictEnum.D_48.value
    QUANG_HOA_CB = DistrictEnum.D_49.value
    HOA_AN_CB = DistrictEnum.D_51.value
    NGUYEN_BINH_CB = DistrictEnum.D_52.value
    THACH_AN_CB = DistrictEnum.D_53.value
    BAC_KAN_BK = DistrictEnum.D_58.value
    PAC_NAM_BK = DistrictEnum.D_60.value
    BA_BE_BK = DistrictEnum.D_61.value
    NGAN_SON_BK = DistrictEnum.D_62.value
    BACH_THONG_BK = DistrictEnum.D_63.value
    CHO_DON_BK = DistrictEnum.D_64.value
    CHO_MOI_BK = DistrictEnum.D_65.value
    NA_RI_BK = DistrictEnum.D_66.value
    TUYEN_QUANG_TQ = DistrictEnum.D_70.value
    LAM_BINH_TQ = DistrictEnum.D_71.value
    NA_HANG_TQ = DistrictEnum.D_72.value
    CHIEM_HOA_TQ = DistrictEnum.D_73.value
    HAM_YEN_TQ = DistrictEnum.D_74.value
    YEN_SON_TQ = DistrictEnum.D_75.value
    SON_DUONG_TQ = DistrictEnum.D_76.value
    LAO_CAI_LC = DistrictEnum.D_80.value
    BAT_XAT_LC = DistrictEnum.D_82.value
    MUONG_KHUONG_LC = DistrictEnum.D_83.value
    SI_MA_CAI_LC = DistrictEnum.D_84.value
    BAC_HA_LC = DistrictEnum.D_85.value
    BAO_THANG_LC = DistrictEnum.D_86.value
    BAO_YEN_LC = DistrictEnum.D_87.value
    SA_PA_LC = DistrictEnum.D_88.value
    VAN_BAN_LC = DistrictEnum.D_89.value
    DIEN_BIEN_PHU_DB = DistrictEnum.D_94.value
    MUONG_LAY_DB = DistrictEnum.D_95.value
    MUONG_NHE_DB = DistrictEnum.D_96.value
    MUONG_CHA_DB = DistrictEnum.D_97.value
    TUA_CHUA_DB = DistrictEnum.D_98.value
    TUAN_GIAO_DB = DistrictEnum.D_99.value
    DIEN_BIEN_DB = DistrictEnum.D_100.value
    DIEN_BIEN_DONG_DB = DistrictEnum.D_101.value
    MUONG_ANG_DB = DistrictEnum.D_102.value
    NAM_PO_DB = DistrictEnum.D_103.value
    LAI_CHAU_LC = DistrictEnum.D_105.value
    TAM_DUONG_LC = DistrictEnum.D_106.value
    MUONG_TE_LC = DistrictEnum.D_107.value
    SIN_HO_LC = DistrictEnum.D_108.value
    PHONG_THO_LC = DistrictEnum.D_109.value
    THAN_UYEN_LC = DistrictEnum.D_110.value
    TAN_UYEN_LC = DistrictEnum.D_111.value
    NAM_NHUN_LC = DistrictEnum.D_112.value
    SON_LA_SL = DistrictEnum.D_116.value
    QUYNH_NHAI_SL = DistrictEnum.D_118.value
    THUAN_CHAU_SL = DistrictEnum.D_119.value
    MUONG_LA_SL = DistrictEnum.D_120.value
    BAC_YEN_SL = DistrictEnum.D_121.value
    PHU_YEN_SL = DistrictEnum.D_122.value
    MOC_CHAU_SL = DistrictEnum.D_123.value
    YEN_CHAU_SL = DistrictEnum.D_124.value
    MAI_SON_SL = DistrictEnum.D_125.value
    SONG_MA_SL = DistrictEnum.D_126.value
    SOP_COP_SL = DistrictEnum.D_127.value
    VAN_HO_SL = DistrictEnum.D_128.value
    YEN_BAI_YB = DistrictEnum.D_132.value
    NGHIA_LO_YB = DistrictEnum.D_133.value
    LUC_YEN_YB = DistrictEnum.D_135.value
    VAN_YEN_YB = DistrictEnum.D_136.value
    MU_CANG_CHAI_YB = DistrictEnum.D_137.value
    TRAN_YEN_YB = DistrictEnum.D_138.value
    TRAM_TAU_YB = DistrictEnum.D_139.value
    VAN_CHAN_YB = DistrictEnum.D_140.value
    YEN_BINH_YB = DistrictEnum.D_141.value
    HOA_BINH_HB = DistrictEnum.D_148.value
    DA_BAC_HB = DistrictEnum.D_150.value
    LUONG_SON_HB = DistrictEnum.D_152.value
    KIM_BOI_HB = DistrictEnum.D_153.value
    CAO_PHONG_HB = DistrictEnum.D_154.value
    TAN_LAC_HB = DistrictEnum.D_155.value
    MAI_CHAU_HB = DistrictEnum.D_156.value
    LAC_SON_HB = DistrictEnum.D_157.value
    YEN_THUY_HB = DistrictEnum.D_158.value
    LAC_THUY_HB = DistrictEnum.D_159.value
    THAI_NGUYEN_TN = DistrictEnum.D_164.value
    SONG_CONG_TN = DistrictEnum.D_165.value
    DINH_HOA_TN = DistrictEnum.D_167.value
    PHU_LUONG_TN = DistrictEnum.D_168.value
    DONG_HY_TN = DistrictEnum.D_169.value
    VO_NHAI_TN = DistrictEnum.D_170.value
    DAI_TU_TN = DistrictEnum.D_171.value
    PHO_YEN_TN = DistrictEnum.D_172.value
    PHU_BINH_TN = DistrictEnum.D_173.value
    LANG_SON_LS = DistrictEnum.D_178.value
    TRANG_DINH_LS = DistrictEnum.D_180.value
    BINH_GIA_LS = DistrictEnum.D_181.value
    VAN_LANG_LS = DistrictEnum.D_182.value
    CAO_LOC_LS = DistrictEnum.D_183.value
    VAN_QUAN_LS = DistrictEnum.D_184.value
    BAC_SON_LS = DistrictEnum.D_185.value
    HUU_LUNG_LS = DistrictEnum.D_186.value
    CHI_LANG_LS = DistrictEnum.D_187.value
    LOC_BINH_LS = DistrictEnum.D_188.value
    DINH_LAP_LS = DistrictEnum.D_189.value
    HA_LONG_QN = DistrictEnum.D_193.value
    MONG_CAI_QN = DistrictEnum.D_194.value
    CAM_PHA_QN = DistrictEnum.D_195.value
    UONG_BI_QN = DistrictEnum.D_196.value
    BINH_LIEU_QN = DistrictEnum.D_198.value
    TIEN_YEN_QN = DistrictEnum.D_199.value
    DAM_HA_QN = DistrictEnum.D_200.value
    HAI_HA_QN = DistrictEnum.D_201.value
    BA_CHE_QN = DistrictEnum.D_202.value
    VAN_DON_QN = DistrictEnum.D_203.value
    DONG_TRIEU_QN = DistrictEnum.D_205.value
    QUANG_YEN_QN = DistrictEnum.D_206.value
    CO_TO_QN = DistrictEnum.D_207.value
    BAC_GIANG_BG = DistrictEnum.D_213.value
    YEN_THE_BG = DistrictEnum.D_215.value
    TAN_YEN_BG = DistrictEnum.D_216.value
    LANG_GIANG_BG = DistrictEnum.D_217.value
    LUC_NAM_BG = DistrictEnum.D_218.value
    LUC_NGAN_BG = DistrictEnum.D_219.value
    SON_DONG_BG = DistrictEnum.D_220.value
    YEN_DUNG_BG = DistrictEnum.D_221.value
    VIET_YEN_BG = DistrictEnum.D_222.value
    HIEP_HOA_BG = DistrictEnum.D_223.value
    VIET_TRI_PT = DistrictEnum.D_227.value
    PHU_THO_PT = DistrictEnum.D_228.value
    DOAN_HUNG_PT = DistrictEnum.D_230.value
    HA_HOA_PT = DistrictEnum.D_231.value
    THANH_BA_PT = DistrictEnum.D_232.value
    PHU_NINH_PT = DistrictEnum.D_233.value
    YEN_LAP_PT = DistrictEnum.D_234.value
    CAM_KHE_PT = DistrictEnum.D_235.value
    TAM_NONG_PT = DistrictEnum.D_236.value
    LAM_THAO_PT = DistrictEnum.D_237.value
    THANH_SON_PT = DistrictEnum.D_238.value
    THANH_THUY_PT = DistrictEnum.D_239.value
    TAN_SON_PT = DistrictEnum.D_240.value
    VINH_YEN_VP = DistrictEnum.D_243.value
    PHUC_YEN_VP = DistrictEnum.D_244.value
    LAP_THACH_VP = DistrictEnum.D_246.value
    TAM_DUONG_VP = DistrictEnum.D_247.value
    TAM_DAO_VP = DistrictEnum.D_248.value
    BINH_XUYEN_VP = DistrictEnum.D_249.value
    YEN_LAC_VP = DistrictEnum.D_251.value
    VINH_TUONG_VP = DistrictEnum.D_252.value
    SONG_LO_VP = DistrictEnum.D_253.value
    BAC_NINH_BN = DistrictEnum.D_256.value
    YEN_PHONG_BN = DistrictEnum.D_258.value
    QUE_VO_BN = DistrictEnum.D_259.value
    TIEN_DU_BN = DistrictEnum.D_260.value
    TU_SON_BN = DistrictEnum.D_261.value
    THUAN_THANH_BN = DistrictEnum.D_262.value
    GIA_BINH_BN = DistrictEnum.D_263.value
    LUONG_TAI_BN = DistrictEnum.D_264.value
    HAI_DUONG_HD = DistrictEnum.D_288.value
    CHI_LINH_HD = DistrictEnum.D_290.value
    NAM_SACH_HD = DistrictEnum.D_291.value
    KINH_MON_HD = DistrictEnum.D_292.value
    KIM_THANH_HD = DistrictEnum.D_293.value
    THANH_HA_HD = DistrictEnum.D_294.value
    CAM_GIANG_HD = DistrictEnum.D_295.value
    BINH_GIANG_HD = DistrictEnum.D_296.value
    GIA_LOC_HD = DistrictEnum.D_297.value
    TU_KY_HD = DistrictEnum.D_298.value
    NINH_GIANG_HD = DistrictEnum.D_299.value
    THANH_MIEN_HD = DistrictEnum.D_300.value
    HONG_BANG_HP = DistrictEnum.D_303.value
    NGO_QUYEN_HP = DistrictEnum.D_304.value
    LE_CHAN_HP = DistrictEnum.D_305.value
    HAI_AN_HP = DistrictEnum.D_306.value
    KIEN_AN_HP = DistrictEnum.D_307.value
    DO_SON_HP = DistrictEnum.D_308.value
    DUONG_KINH_HP = DistrictEnum.D_309.value
    THUY_NGUYEN_HP = DistrictEnum.D_311.value
    AN_DUONG_HP = DistrictEnum.D_312.value
    AN_LAO_HP = DistrictEnum.D_313.value
    KIEN_THUY_HP = DistrictEnum.D_314.value
    TIEN_LANG_HP = DistrictEnum.D_315.value
    VINH_BAO_HP = DistrictEnum.D_316.value
    CAT_HAI_HP = DistrictEnum.D_317.value
    BACH_LONG_VI_HP = DistrictEnum.D_318.value
    HUNG_YEN_HY = DistrictEnum.D_323.value
    VAN_LAM_HY = DistrictEnum.D_325.value
    VAN_GIANG_HY = DistrictEnum.D_326.value
    YEN_MY_HY = DistrictEnum.D_327.value
    MY_HAO_HY = DistrictEnum.D_328.value
    AN_THI_HY = DistrictEnum.D_329.value
    KHOAI_CHAU_HY = DistrictEnum.D_330.value
    KIM_DONG_HY = DistrictEnum.D_331.value
    TIEN_LU_HY = DistrictEnum.D_332.value
    PHU_CU_HY = DistrictEnum.D_333.value
    THAI_BINH_TB = DistrictEnum.D_336.value
    QUYNH_PHU_TB = DistrictEnum.D_338.value
    HUNG_HA_TB = DistrictEnum.D_339.value
    DONG_HUNG_TB = DistrictEnum.D_340.value
    THAI_THUY_TB = DistrictEnum.D_341.value
    TIEN_HAI_TB = DistrictEnum.D_342.value
    KIEN_XUONG_TB = DistrictEnum.D_343.value
    VU_THU_TB = DistrictEnum.D_344.value
    PHU_LY_HN = DistrictEnum.D_347.value
    DUY_TIEN_HN = DistrictEnum.D_349.value
    KIM_BANG_HN = DistrictEnum.D_350.value
    THANH_LIEM_HN = DistrictEnum.D_351.value
    BINH_LUC_HN = DistrictEnum.D_352.value
    LY_NHAN_HN = DistrictEnum.D_353.value
    NAM_DINH_ND = DistrictEnum.D_356.value
    MY_LOC_ND = DistrictEnum.D_358.value
    VU_BAN_ND = DistrictEnum.D_359.value
    Y_YEN_ND = DistrictEnum.D_360.value
    NGHIA_HUNG_ND = DistrictEnum.D_361.value
    NAM_TRUC_ND = DistrictEnum.D_362.value
    TRUC_NINH_ND = DistrictEnum.D_363.value
    XUAN_TRUONG_ND = DistrictEnum.D_364.value
    GIAO_THUY_ND = DistrictEnum.D_365.value
    HAI_HAU_ND = DistrictEnum.D_366.value
    NINH_BINH_NB = DistrictEnum.D_369.value
    TAM_DIEP_NB = DistrictEnum.D_370.value
    NHO_QUAN_NB = DistrictEnum.D_372.value
    GIA_VIEN_NB = DistrictEnum.D_373.value
    HOA_LU_NB = DistrictEnum.D_374.value
    YEN_KHANH_NB = DistrictEnum.D_375.value
    KIM_SON_NB = DistrictEnum.D_376.value
    YEN_MO_NB = DistrictEnum.D_377.value
    THANH_HOA_TH = DistrictEnum.D_380.value
    BIM_SON_TH = DistrictEnum.D_381.value
    SAM_SON_TH = DistrictEnum.D_382.value
    MUONG_LAT_TH = DistrictEnum.D_384.value
    QUAN_HOA_TH = DistrictEnum.D_385.value
    BA_THUOC_TH = DistrictEnum.D_386.value
    QUAN_SON_TH = DistrictEnum.D_387.value
    LANG_CHANH_TH = DistrictEnum.D_388.value
    NGOC_LAC_TH = DistrictEnum.D_389.value
    CAM_THUY_TH = DistrictEnum.D_390.value
    THACH_THANH_TH = DistrictEnum.D_391.value
    HA_TRUNG_TH = DistrictEnum.D_392.value
    VINH_LOC_TH = DistrictEnum.D_393.value
    YEN_DINH_TH = DistrictEnum.D_394.value
    THO_XUAN_TH = DistrictEnum.D_395.value
    THUONG_XUAN_TH = DistrictEnum.D_396.value
    TRIEU_SON_TH = DistrictEnum.D_397.value
    THIEU_HOA_TH = DistrictEnum.D_398.value
    HOANG_HOA_TH = DistrictEnum.D_399.value
    HAU_LOC_TH = DistrictEnum.D_400.value
    NGA_SON_TH = DistrictEnum.D_401.value
    NHU_XUAN_TH = DistrictEnum.D_402.value
    NHU_THANH_TH = DistrictEnum.D_403.value
    NONG_CONG_TH = DistrictEnum.D_404.value
    DONG_SON_TH = DistrictEnum.D_405.value
    QUANG_XUONG_TH = DistrictEnum.D_406.value
    NGHI_SON_TH = DistrictEnum.D_407.value
    VINH_NA = DistrictEnum.D_412.value
    CUA_LO_NA = DistrictEnum.D_413.value
    THAI_HOA_NA = DistrictEnum.D_414.value
    QUE_PHONG_NA = DistrictEnum.D_415.value
    QUY_CHAU_NA = DistrictEnum.D_416.value
    KY_SON_NA = DistrictEnum.D_417.value
    TUONG_DUONG_NA = DistrictEnum.D_418.value
    NGHIA_DAN_NA = DistrictEnum.D_419.value
    QUY_HOP_NA = DistrictEnum.D_420.value
    QUYNH_LUU_NA = DistrictEnum.D_421.value
    CON_CUONG_NA = DistrictEnum.D_422.value
    TAN_KY_NA = DistrictEnum.D_423.value
    ANH_SON_NA = DistrictEnum.D_424.value
    DIEN_CHAU_NA = DistrictEnum.D_425.value
    YEN_THANH_NA = DistrictEnum.D_426.value
    DO_LUONG_NA = DistrictEnum.D_427.value
    THANH_CHUONG_NA = DistrictEnum.D_428.value
    NGHI_LOC_NA = DistrictEnum.D_429.value
    NAM_DAN_NA = DistrictEnum.D_430.value
    HUNG_NGUYEN_NA = DistrictEnum.D_431.value
    HOANG_MAI_NA = DistrictEnum.D_432.value
    HA_TINH_HT = DistrictEnum.D_436.value
    HONG_LINH_HT = DistrictEnum.D_437.value
    HUONG_SON_HT = DistrictEnum.D_439.value
    DUC_THO_HT = DistrictEnum.D_440.value
    VU_QUANG_HT = DistrictEnum.D_441.value
    NGHI_XUAN_HT = DistrictEnum.D_442.value
    CAN_LOC_HT = DistrictEnum.D_443.value
    HUONG_KHE_HT = DistrictEnum.D_444.value
    THACH_HA_HT = DistrictEnum.D_445.value
    CAM_XUYEN_HT = DistrictEnum.D_446.value
    HUYEN_KY_ANH_HT = DistrictEnum.D_447.value
    LOC_HA_HT = DistrictEnum.D_448.value
    KY_ANH_HT = DistrictEnum.D_449.value
    DONG_HOI_QB = DistrictEnum.D_450.value
    MINH_HOA_QB = DistrictEnum.D_452.value
    TUYEN_HOA_QB = DistrictEnum.D_453.value
    QUANG_TRACH_QB = DistrictEnum.D_454.value
    BO_TRACH_QB = DistrictEnum.D_455.value
    QUANG_NINH_QB = DistrictEnum.D_456.value
    LE_THUY_QB = DistrictEnum.D_457.value
    BA_DON_QB = DistrictEnum.D_458.value
    DONG_HA_QT = DistrictEnum.D_461.value
    QUANG_TRI_QT = DistrictEnum.D_462.value
    VINH_LINH_QT = DistrictEnum.D_464.value
    HUONG_HOA_QT = DistrictEnum.D_465.value
    GIO_LINH_QT = DistrictEnum.D_466.value
    DA_KRONG_QT = DistrictEnum.D_467.value
    CAM_LO_QT = DistrictEnum.D_468.value
    TRIEU_PHONG_QT = DistrictEnum.D_469.value
    HAI_LANG_QT = DistrictEnum.D_470.value
    CON_CO_QT = DistrictEnum.D_471.value
    HUE_TTH = DistrictEnum.D_474.value
    PHONG_DIEN_TTH = DistrictEnum.D_476.value
    QUANG_DIEN_TTH = DistrictEnum.D_477.value
    PHU_VANG_TTH = DistrictEnum.D_478.value
    HUONG_THUY_TTH = DistrictEnum.D_479.value
    HUONG_TRA_TTH = DistrictEnum.D_480.value
    A_LUOI_TTH = DistrictEnum.D_481.value
    PHU_LOC_TTH = DistrictEnum.D_482.value
    NAM_DONG_TTH = DistrictEnum.D_483.value
    LIEN_CHIEU_DN = DistrictEnum.D_490.value
    THANH_KHE_DN = DistrictEnum.D_491.value
    HAI_CHAU_DN = DistrictEnum.D_492.value
    SON_TRA_DN = DistrictEnum.D_493.value
    NGU_HANH_SON_DN = DistrictEnum.D_494.value
    CAM_LE_DN = DistrictEnum.D_495.value
    HOA_VANG_DN = DistrictEnum.D_497.value
    HOANG_SA_DN = DistrictEnum.D_498.value
    TAM_KY_QN = DistrictEnum.D_502.value
    HOI_AN_QN = DistrictEnum.D_503.value
    TAY_GIANG_QN = DistrictEnum.D_504.value
    DONG_GIANG_QN = DistrictEnum.D_505.value
    DAI_LOC_QN = DistrictEnum.D_506.value
    DIEN_BAN_QN = DistrictEnum.D_507.value
    DUY_XUYEN_QN = DistrictEnum.D_508.value
    QUE_SON_QN = DistrictEnum.D_509.value
    NAM_GIANG_QN = DistrictEnum.D_510.value
    PHUOC_SON_QN = DistrictEnum.D_511.value
    HIEP_DUC_QN = DistrictEnum.D_512.value
    THANG_BINH_QN = DistrictEnum.D_513.value
    TIEN_PHUOC_QN = DistrictEnum.D_514.value
    BAC_TRA_MY_QN = DistrictEnum.D_515.value
    NAM_TRA_MY_QN = DistrictEnum.D_516.value
    NUI_THANH_QN = DistrictEnum.D_517.value
    PHU_NINH_QN = DistrictEnum.D_518.value
    NONG_SON_QN = DistrictEnum.D_519.value
    QUANG_NGAI_QN = DistrictEnum.D_522.value
    BINH_SON_QN = DistrictEnum.D_524.value
    TRA_BONG_QN = DistrictEnum.D_525.value
    SON_TINH_QN = DistrictEnum.D_527.value
    TU_NGHIA_QN = DistrictEnum.D_528.value
    SON_HA_QN = DistrictEnum.D_529.value
    SON_TAY_QN = DistrictEnum.D_530.value
    MINH_LONG_QN = DistrictEnum.D_531.value
    NGHIA_HANH_QN = DistrictEnum.D_532.value
    MO_DUC_QN = DistrictEnum.D_533.value
    DUC_PHO_QN = DistrictEnum.D_534.value
    BA_TO_QN = DistrictEnum.D_535.value
    LY_SON_QN = DistrictEnum.D_536.value
    QUY_NHON_BD = DistrictEnum.D_540.value
    AN_LAO_BD = DistrictEnum.D_542.value
    HOAI_NHON_BD = DistrictEnum.D_543.value
    HOAI_AN_BD = DistrictEnum.D_544.value
    PHU_MY_BD = DistrictEnum.D_545.value
    VINH_THANH_BD = DistrictEnum.D_546.value
    TAY_SON_BD = DistrictEnum.D_547.value
    PHU_CAT_BD = DistrictEnum.D_548.value
    AN_NHON_BD = DistrictEnum.D_549.value
    TUY_PHUOC_BD = DistrictEnum.D_550.value
    VAN_CANH_BD = DistrictEnum.D_551.value
    TUY_HOA_PY = DistrictEnum.D_555.value
    SONG_CAU_PY = DistrictEnum.D_557.value
    DONG_XUAN_PY = DistrictEnum.D_558.value
    TUY_AN_PY = DistrictEnum.D_559.value
    SON_HOA_PY = DistrictEnum.D_560.value
    SONG_HINH_PY = DistrictEnum.D_561.value
    TAY_HOA_PY = DistrictEnum.D_562.value
    PHU_HOA_PY = DistrictEnum.D_563.value
    DONG_HOA_PY = DistrictEnum.D_564.value
    NHA_TRANG_KH = DistrictEnum.D_568.value
    CAM_RANH_KH = DistrictEnum.D_569.value
    CAM_LAM_KH = DistrictEnum.D_570.value
    VAN_NINH_KH = DistrictEnum.D_571.value
    NINH_HOA_KH = DistrictEnum.D_572.value
    KHANH_VINH_KH = DistrictEnum.D_573.value
    DIEN_KHANH_KH = DistrictEnum.D_574.value
    KHANH_SON_KH = DistrictEnum.D_575.value
    TRUONG_SA_KH = DistrictEnum.D_576.value
    PHAN_RANG_THAP_CHAM_NT = DistrictEnum.D_582.value
    BAC_AI_NT = DistrictEnum.D_584.value
    NINH_SON_NT = DistrictEnum.D_585.value
    NINH_HAI_NT = DistrictEnum.D_586.value
    NINH_PHUOC_NT = DistrictEnum.D_587.value
    THUAN_BAC_NT = DistrictEnum.D_588.value
    THUAN_NAM_NT = DistrictEnum.D_589.value
    PHAN_THIET_BT = DistrictEnum.D_593.value
    LA_GI_BT = DistrictEnum.D_594.value
    TUY_PHONG_BT = DistrictEnum.D_595.value
    BAC_BINH_BT = DistrictEnum.D_596.value
    HAM_THUAN_BAC_BT = DistrictEnum.D_597.value
    HAM_THUAN_NAM_BT = DistrictEnum.D_598.value
    TANH_LINH_BT = DistrictEnum.D_599.value
    DUC_LINH_BT = DistrictEnum.D_600.value
    HAM_TAN_BT = DistrictEnum.D_601.value
    PHU_QUI_BT = DistrictEnum.D_602.value
    KON_TUM_KT = DistrictEnum.D_608.value
    DAK_GLEI_KT = DistrictEnum.D_610.value
    NGOC_HOI_KT = DistrictEnum.D_611.value
    DAK_TO_KT = DistrictEnum.D_612.value
    KON_PLONG_KT = DistrictEnum.D_613.value
    KON_RAY_KT = DistrictEnum.D_614.value
    DAK_HA_KT = DistrictEnum.D_615.value
    SA_THAY_KT = DistrictEnum.D_616.value
    TU_MO_RONG_KT = DistrictEnum.D_617.value
    IA_H_DRAI_KT = DistrictEnum.D_618.value
    PLEIKU_GL = DistrictEnum.D_622.value
    AN_KHE_GL = DistrictEnum.D_623.value
    AYUN_PA_GL = DistrictEnum.D_624.value
    KBANG_GL = DistrictEnum.D_625.value
    DAK_DOA_GL = DistrictEnum.D_626.value
    CHU_PAH_GL = DistrictEnum.D_627.value
    IA_GRAI_GL = DistrictEnum.D_628.value
    MANG_YANG_GL = DistrictEnum.D_629.value
    KONG_CHRO_GL = DistrictEnum.D_630.value
    DUC_CO_GL = DistrictEnum.D_631.value
    CHU_PRONG_GL = DistrictEnum.D_632.value
    CHU_SE_GL = DistrictEnum.D_633.value
    DAK_PO_GL = DistrictEnum.D_634.value
    IA_PA_GL = DistrictEnum.D_635.value
    KRONG_PA_GL = DistrictEnum.D_637.value
    PHU_THIEN_GL = DistrictEnum.D_638.value
    CHU_PUH_GL = DistrictEnum.D_639.value
    BUON_MA_THUOT_DL = DistrictEnum.D_643.value
    BUON_HO_DL = DistrictEnum.D_644.value
    EA_HLEO_DL = DistrictEnum.D_645.value
    EA_SUP_DL = DistrictEnum.D_646.value
    BUON_DON_DL = DistrictEnum.D_647.value
    CU_MGAR_DL = DistrictEnum.D_648.value
    KRONG_BUK_DL = DistrictEnum.D_649.value
    KRONG_NANG_DL = DistrictEnum.D_650.value
    EA_KAR_DL = DistrictEnum.D_651.value
    MDRAK_DL = DistrictEnum.D_652.value
    KRONG_BONG_DL = DistrictEnum.D_653.value
    KRONG_PAC_DL = DistrictEnum.D_654.value
    KRONG_A_NA_DL = DistrictEnum.D_655.value
    LAK_DL = DistrictEnum.D_656.value
    CU_KUIN_DL = DistrictEnum.D_657.value
    GIA_NGHIA_DN = DistrictEnum.D_660.value
    DAK_GLONG_DN = DistrictEnum.D_661.value
    CU_JUT_DN = DistrictEnum.D_662.value
    DAK_MIL_DN = DistrictEnum.D_663.value
    KRONG_NO_DN = DistrictEnum.D_664.value
    DAK_SONG_DN = DistrictEnum.D_665.value
    DAK_RLAP_DN = DistrictEnum.D_666.value
    TUY_DUC_DN = DistrictEnum.D_667.value
    DA_LAT_LD = DistrictEnum.D_672.value
    BAO_LOC_LD = DistrictEnum.D_673.value
    DAM_RONG_LD = DistrictEnum.D_674.value
    LAC_DUONG_LD = DistrictEnum.D_675.value
    LAM_HA_LD = DistrictEnum.D_676.value
    DON_DUONG_LD = DistrictEnum.D_677.value
    DUC_TRONG_LD = DistrictEnum.D_678.value
    DI_LINH_LD = DistrictEnum.D_679.value
    BAO_LAM_LD = DistrictEnum.D_680.value
    DA_HUOAI_LD = DistrictEnum.D_681.value
    DA_TEH_LD = DistrictEnum.D_682.value
    CAT_TIEN_LD = DistrictEnum.D_683.value
    PHUOC_LONG_BP = DistrictEnum.D_688.value
    DONG_XOAI_BP = DistrictEnum.D_689.value
    BINH_LONG_BP = DistrictEnum.D_690.value
    BU_GIA_MAP_BP = DistrictEnum.D_691.value
    LOC_NINH_BP = DistrictEnum.D_692.value
    BU_DOP_BP = DistrictEnum.D_693.value
    HON_QUAN_BP = DistrictEnum.D_694.value
    DONG_PHU_BP = DistrictEnum.D_695.value
    BU_DANG_BP = DistrictEnum.D_696.value
    CHON_THANH_BP = DistrictEnum.D_697.value
    PHU_RIENG_BP = DistrictEnum.D_698.value
    TAY_NINH_TN = DistrictEnum.D_703.value
    TAN_BIEN_TN = DistrictEnum.D_705.value
    TAN_CHAU_TN = DistrictEnum.D_706.value
    DUONG_MINH_CHAU_TN = DistrictEnum.D_707.value
    CHAU_THANH_TN = DistrictEnum.D_708.value
    HOA_THANH_TN = DistrictEnum.D_709.value
    GO_DAU_TN = DistrictEnum.D_710.value
    BEN_CAU_TN = DistrictEnum.D_711.value
    TRANG_BANG_TN = DistrictEnum.D_712.value
    THU_DAU_MOT_BD = DistrictEnum.D_718.value
    BAU_BANG_BD = DistrictEnum.D_719.value
    DAU_TIENG_BD = DistrictEnum.D_720.value
    BEN_CAT_BD = DistrictEnum.D_721.value
    PHU_GIAO_BD = DistrictEnum.D_722.value
    TAN_UYEN_BD = DistrictEnum.D_723.value
    DI_AN_BD = DistrictEnum.D_724.value
    THUAN_AN_BD = DistrictEnum.D_725.value
    BAC_TAN_UYEN_BD = DistrictEnum.D_726.value
    BIEN_HOA_DN = DistrictEnum.D_731.value
    LONG_KHANH_DN = DistrictEnum.D_732.value
    TAN_PHU_DN = DistrictEnum.D_734.value
    VINH_CUU_DN = DistrictEnum.D_735.value
    DINH_QUAN_DN = DistrictEnum.D_736.value
    TRANG_BOM_DN = DistrictEnum.D_737.value
    THONG_NHAT_DN = DistrictEnum.D_738.value
    CAM_MY_DN = DistrictEnum.D_739.value
    LONG_THANH_DN = DistrictEnum.D_740.value
    XUAN_LOC_DN = DistrictEnum.D_741.value
    NHON_TRACH_DN = DistrictEnum.D_742.value
    VUNG_TAU_BRVT = DistrictEnum.D_747.value
    BA_RIA_BRVT = DistrictEnum.D_748.value
    CHAU_DUC_BRVT = DistrictEnum.D_750.value
    XUYEN_MOC_BRVT = DistrictEnum.D_751.value
    LONG_DIEN_BRVT = DistrictEnum.D_752.value
    DAT_DO_BRVT = DistrictEnum.D_753.value
    PHU_MY_BRVT = DistrictEnum.D_754.value
    CON_DAO_BRVT = DistrictEnum.D_755.value
    QUAN_1_HCM = DistrictEnum.D_760.value
    QUAN_12_HCM = DistrictEnum.D_761.value
    GO_VAP_HCM = DistrictEnum.D_764.value
    BINH_THANH_HCM = DistrictEnum.D_765.value
    TAN_BINH_HCM = DistrictEnum.D_766.value
    TAN_PHU_HCM = DistrictEnum.D_767.value
    PHU_NHUAN_HCM = DistrictEnum.D_768.value
    THU_DUC_HCM = DistrictEnum.D_769.value
    QUAN_3_HCM = DistrictEnum.D_770.value
    QUAN_10_HCM = DistrictEnum.D_771.value
    QUAN_11_HCM = DistrictEnum.D_772.value
    QUAN_4_HCM = DistrictEnum.D_773.value
    QUAN_5_HCM = DistrictEnum.D_774.value
    QUAN_6_HCM = DistrictEnum.D_775.value
    QUAN_8_HCM = DistrictEnum.D_776.value
    BINH_TAN_HCM = DistrictEnum.D_777.value
    QUAN_7_HCM = DistrictEnum.D_778.value
    CU_CHI_HCM = DistrictEnum.D_783.value
    HOC_MON_HCM = DistrictEnum.D_784.value
    BINH_CHANH_HCM = DistrictEnum.D_785.value
    NHA_BE_HCM = DistrictEnum.D_786.value
    CAN_GIO_HCM = DistrictEnum.D_787.value
    TAN_AN_LA = DistrictEnum.D_794.value
    KIEN_TUONG_LA = DistrictEnum.D_795.value
    TAN_HUNG_LA = DistrictEnum.D_796.value
    VINH_HUNG_LA = DistrictEnum.D_797.value
    MOC_HOA_LA = DistrictEnum.D_798.value
    TAN_THANH_LA = DistrictEnum.D_799.value
    THANH_HOA_LA = DistrictEnum.D_800.value
    DUC_HUE_LA = DistrictEnum.D_801.value
    DUC_HOA_LA = DistrictEnum.D_802.value
    BEN_LUC_LA = DistrictEnum.D_803.value
    THU_THUA_LA = DistrictEnum.D_804.value
    TAN_TRU_LA = DistrictEnum.D_805.value
    CAN_DUOC_LA = DistrictEnum.D_806.value
    CAN_GIUOC_LA = DistrictEnum.D_807.value
    CHAU_THANH_LA = DistrictEnum.D_808.value
    MY_THO_TG = DistrictEnum.D_815.value
    GO_CONG_TG = DistrictEnum.D_816.value
    CAI_LAY_TG = DistrictEnum.D_817.value
    TAN_PHUOC_TG = DistrictEnum.D_818.value
    CAI_BE_TG = DistrictEnum.D_819.value
    HUYEN_CAI_LAY_TG = DistrictEnum.D_820.value
    CHAU_THANH_TG = DistrictEnum.D_821.value
    CHO_GAO_TG = DistrictEnum.D_822.value
    GO_CONG_TAY_TG = DistrictEnum.D_823.value
    GO_CONG_DONG_TG = DistrictEnum.D_824.value
    TAN_PHU_DONG_TG = DistrictEnum.D_825.value
    BEN_TRE_BT = DistrictEnum.D_829.value
    CHAU_THANH_BT = DistrictEnum.D_831.value
    CHO_LACH_BT = DistrictEnum.D_832.value
    MO_CAY_NAM_BT = DistrictEnum.D_833.value
    GIONG_TROM_BT = DistrictEnum.D_834.value
    BINH_DAI_BT = DistrictEnum.D_835.value
    BA_TRI_BT = DistrictEnum.D_836.value
    THANH_PHU_BT = DistrictEnum.D_837.value
    MO_CAY_BAC_BT = DistrictEnum.D_838.value
    TRA_VINH_TV = DistrictEnum.D_842.value
    CANG_LONG_TV = DistrictEnum.D_844.value
    CAU_KE_TV = DistrictEnum.D_845.value
    TIEU_CAN_TV = DistrictEnum.D_846.value
    CHAU_THANH_TV = DistrictEnum.D_847.value
    CAU_NGANG_TV = DistrictEnum.D_848.value
    TRA_CU_TV = DistrictEnum.D_849.value
    HUYEN_DUYEN_HAI_TV = DistrictEnum.D_850.value
    DUYEN_HAI_TV = DistrictEnum.D_851.value
    VINH_LONG_VL = DistrictEnum.D_855.value
    LONG_HO_VL = DistrictEnum.D_857.value
    MANG_THIT_VL = DistrictEnum.D_858.value
    VUNG_LIEM_VL = DistrictEnum.D_859.value
    TAM_BINH_VL = DistrictEnum.D_860.value
    BINH_MINH_VL = DistrictEnum.D_861.value
    TRA_ON_VL = DistrictEnum.D_862.value
    BINH_TAN_VL = DistrictEnum.D_863.value
    CAO_LANH_DT = DistrictEnum.D_866.value
    SA_DEC_DT = DistrictEnum.D_867.value
    HONG_NGU_DT = DistrictEnum.D_868.value
    TAN_HONG_DT = DistrictEnum.D_869.value
    HUYEN_HONG_NGU_DT = DistrictEnum.D_870.value
    TAM_NONG_DT = DistrictEnum.D_871.value
    THAP_MUOI_DT = DistrictEnum.D_872.value
    HUYEN_CAO_LANH_DT = DistrictEnum.D_873.value
    THANH_BINH_DT = DistrictEnum.D_874.value
    LAP_VO_DT = DistrictEnum.D_875.value
    LAI_VUNG_DT = DistrictEnum.D_876.value
    CHAU_THANH_DT = DistrictEnum.D_877.value
    LONG_XUYEN_AG = DistrictEnum.D_883.value
    CHAU_DOC_AG = DistrictEnum.D_884.value
    AN_PHU_AG = DistrictEnum.D_886.value
    TAN_CHAU_AG = DistrictEnum.D_887.value
    PHU_TAN_AG = DistrictEnum.D_888.value
    CHAU_PHU_AG = DistrictEnum.D_889.value
    TINH_BIEN_AG = DistrictEnum.D_890.value
    TRI_TON_AG = DistrictEnum.D_891.value
    CHAU_THANH_AG = DistrictEnum.D_892.value
    CHO_MOI_AG = DistrictEnum.D_893.value
    THOAI_SON_AG = DistrictEnum.D_894.value
    RACH_GIA_KG = DistrictEnum.D_899.value
    HA_TIEN_KG = DistrictEnum.D_900.value
    KIEN_LUONG_KG = DistrictEnum.D_902.value
    HON_DAT_KG = DistrictEnum.D_903.value
    TAN_HIEP_KG = DistrictEnum.D_904.value
    CHAU_THANH_KG = DistrictEnum.D_905.value
    GIONG_RIENG_KG = DistrictEnum.D_906.value
    GO_QUAO_KG = DistrictEnum.D_907.value
    AN_BIEN_KG = DistrictEnum.D_908.value
    AN_MINH_KG = DistrictEnum.D_909.value
    VINH_THUAN_KG = DistrictEnum.D_910.value
    PHU_QUOC_KG = DistrictEnum.D_911.value
    KIEN_HAI_KG = DistrictEnum.D_912.value
    U_MINH_THUONG_KG = DistrictEnum.D_913.value
    GIANG_THANH_KG = DistrictEnum.D_914.value
    NINH_KIEU_CT = DistrictEnum.D_916.value
    O_MON_CT = DistrictEnum.D_917.value
    BINH_THUY_CT = DistrictEnum.D_918.value
    CAI_RANG_CT = DistrictEnum.D_919.value
    THOT_NOT_CT = DistrictEnum.D_923.value
    VINH_THANH_CT = DistrictEnum.D_924.value
    CO_DO_CT = DistrictEnum.D_925.value
    PHONG_DIEN_CT = DistrictEnum.D_926.value
    THOI_LAI_CT = DistrictEnum.D_927.value
    VI_THANH_HG = DistrictEnum.D_930.value
    NGA_BAY_HG = DistrictEnum.D_931.value
    CHAU_THANH_A_HG = DistrictEnum.D_932.value
    CHAU_THANH_HG = DistrictEnum.D_933.value
    PHUNG_HIEP_HG = DistrictEnum.D_934.value
    VI_THUY_HG = DistrictEnum.D_935.value
    HUYEN_LONG_MY_HG = DistrictEnum.D_936.value
    LONG_MY_HG = DistrictEnum.D_937.value
    SOC_TRANG_ST = DistrictEnum.D_941.value
    CHAU_THANH_ST = DistrictEnum.D_942.value
    KE_SACH_ST = DistrictEnum.D_943.value
    MY_TU_ST = DistrictEnum.D_944.value
    CU_LAO_DUNG_ST = DistrictEnum.D_945.value
    LONG_PHU_ST = DistrictEnum.D_946.value
    MY_XUYEN_ST = DistrictEnum.D_947.value
    NGA_NAM_ST = DistrictEnum.D_948.value
    THANH_TRI_ST = DistrictEnum.D_949.value
    VINH_CHAU_ST = DistrictEnum.D_950.value
    TRAN_DE_ST = DistrictEnum.D_951.value
    BAC_LIEU_BL = DistrictEnum.D_954.value
    HONG_DAN_BL = DistrictEnum.D_956.value
    PHUOC_LONG_BL = DistrictEnum.D_957.value
    VINH_LOI_BL = DistrictEnum.D_958.value
    GIA_RAI_BL = DistrictEnum.D_959.value
    DONG_HAI_BL = DistrictEnum.D_960.value
    HOA_BINH_BL = DistrictEnum.D_961.value
    CA_MAU_CM = DistrictEnum.D_964.value
    U_MINH_CM = DistrictEnum.D_966.value
    THOI_BINH_CM = DistrictEnum.D_967.value
    TRAN_VAN_THOI_CM = DistrictEnum.D_968.value
    CAI_NUOC_CM = DistrictEnum.D_969.value
    DAM_DOI_CM = DistrictEnum.D_970.value
    NAM_CAN_CM = DistrictEnum.D_971.value
    PHU_TAN_CM = DistrictEnum.D_972.value
    NGOC_HIEN_CM = DistrictEnum.D_973.value
