# Generated by Django 4.0.7 on 2022-08-08 16:09

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):

    replaces = [
        ("standingssync", "0001_initial-new"),
        ("standingssync", "0002_add_war_targets"),
        ("standingssync", "0003_war_target_labels"),
        ("standingssync", "0004_remove_old_eve_entity"),
        ("standingssync", "0005_add_new_eve_entity"),
    ]

    initial = True

    dependencies = [
        ("eveonline", "0015_factions"),
        ("eveuniverse", "0007_evetype_description"),
        ("authentication", "0019_merge_20211026_0919"),
    ]

    operations = [
        migrations.CreateModel(
            name="SyncManager",
            fields=[
                ("version_hash", models.CharField(default="", max_length=32)),
                ("last_sync", models.DateTimeField(default=None, null=True)),
                (
                    "alliance",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.CASCADE,
                        primary_key=True,
                        related_name="+",
                        serialize=False,
                        to="eveonline.eveallianceinfo",
                    ),
                ),
                (
                    "last_error",
                    models.IntegerField(
                        choices=[
                            (0, "No error"),
                            (1, "Invalid token"),
                            (2, "Expired token"),
                            (3, "Insufficient permissions"),
                            (4, "No character set for fetching alliance contacts"),
                            (5, "ESI API is currently unavailable"),
                            (99, "Unknown error"),
                        ],
                        default=0,
                    ),
                ),
                (
                    "character_ownership",
                    models.OneToOneField(
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="authentication.characterownership",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="SyncedCharacter",
            fields=[
                ("version_hash", models.CharField(default="", max_length=32)),
                ("last_sync", models.DateTimeField(default=None, null=True)),
                (
                    "character_ownership",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.CASCADE,
                        primary_key=True,
                        serialize=False,
                        to="authentication.characterownership",
                    ),
                ),
                (
                    "last_error",
                    models.IntegerField(
                        choices=[
                            (0, "No error"),
                            (1, "Invalid token"),
                            (2, "Expired token"),
                            (3, "Insufficient permissions"),
                            (5, "ESI API is currently unavailable"),
                            (99, "Unknown error"),
                        ],
                        default=0,
                    ),
                ),
                ("has_war_targets_label", models.BooleanField(default=None, null=True)),
                (
                    "manager",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="synced_characters",
                        to="standingssync.syncmanager",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="EveWar",
            fields=[
                ("id", models.PositiveIntegerField(primary_key=True, serialize=False)),
                ("declared", models.DateTimeField()),
                (
                    "finished",
                    models.DateTimeField(db_index=True, default=None, null=True),
                ),
                ("is_mutual", models.BooleanField()),
                ("is_open_for_allies", models.BooleanField()),
                ("retracted", models.DateTimeField(default=None, null=True)),
                (
                    "started",
                    models.DateTimeField(db_index=True, default=None, null=True),
                ),
                (
                    "aggressor",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to="eveuniverse.eveentity",
                    ),
                ),
                (
                    "allies",
                    models.ManyToManyField(
                        related_name="+", to="eveuniverse.eveentity"
                    ),
                ),
                (
                    "defender",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to="eveuniverse.eveentity",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="EveContact",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("standing", models.FloatField()),
                ("is_war_target", models.BooleanField()),
                (
                    "eve_entity",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to="eveuniverse.eveentity",
                    ),
                ),
                (
                    "manager",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="contacts",
                        to="standingssync.syncmanager",
                    ),
                ),
            ],
        ),
        migrations.AddConstraint(
            model_name="evecontact",
            constraint=models.UniqueConstraint(
                fields=("manager", "eve_entity"), name="fk_eve_contact"
            ),
        ),
    ]
