# Generated by Django 3.2.10 on 2022-01-27 16:15

import django.core.serializers.json
from django.db import migrations, models
import django.db.models.deletion
import nautobot.extras.models.statuses
import taggit.managers
import uuid


class Migration(migrations.Migration):

    dependencies = [
        ("extras", "0013_default_fallback_value_computedfield"),
        ("dcim", "0005_device_local_context_schema"),
        ("nautobot_device_lifecycle_mgmt", "0005_software_reporting"),
    ]

    operations = [
        migrations.CreateModel(
            name="CVELCM",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False, unique=True
                    ),
                ),
                ("created", models.DateField(auto_now_add=True, null=True)),
                ("last_updated", models.DateTimeField(auto_now=True, null=True)),
                (
                    "_custom_field_data",
                    models.JSONField(blank=True, default=dict, encoder=django.core.serializers.json.DjangoJSONEncoder),
                ),
                ("name", models.CharField(max_length=16, unique=True)),
                ("published_date", models.DateField()),
                ("link", models.URLField()),
                ("description", models.CharField(blank=True, max_length=255, null=True)),
                ("severity", models.CharField(default="None", max_length=50)),
                ("cvss", models.FloatField(blank=True, null=True)),
                ("cvss_v2", models.FloatField(blank=True, null=True)),
                ("cvss_v3", models.FloatField(blank=True, null=True)),
                ("fix", models.CharField(blank=True, max_length=255, null=True)),
                ("comments", models.TextField(blank=True)),
                (
                    "status",
                    nautobot.extras.models.statuses.StatusField(
                        blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, to="extras.status"
                    ),
                ),
                ("tags", taggit.managers.TaggableManager(through="extras.TaggedItem", to="extras.Tag")),
            ],
            options={
                "verbose_name": "CVE",
                "ordering": ("severity", "name"),
            },
        ),
        migrations.CreateModel(
            name="VulnerabilityLCM",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False, unique=True
                    ),
                ),
                ("created", models.DateField(auto_now_add=True, null=True)),
                ("last_updated", models.DateTimeField(auto_now=True, null=True)),
                (
                    "_custom_field_data",
                    models.JSONField(blank=True, default=dict, encoder=django.core.serializers.json.DjangoJSONEncoder),
                ),
                (
                    "cve",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="nautobot_device_lifecycle_mgmt.cvelcm",
                    ),
                ),
                (
                    "device",
                    models.ForeignKey(
                        blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to="dcim.device"
                    ),
                ),
                (
                    "inventory_item",
                    models.ForeignKey(
                        blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to="dcim.inventoryitem"
                    ),
                ),
                (
                    "software",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="nautobot_device_lifecycle_mgmt.softwarelcm",
                    ),
                ),
                (
                    "status",
                    nautobot.extras.models.statuses.StatusField(
                        blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, to="extras.status"
                    ),
                ),
                ("tags", taggit.managers.TaggableManager(through="extras.TaggedItem", to="extras.Tag")),
            ],
            options={
                "verbose_name": "Vulnerability",
                "verbose_name_plural": "Vulnerabilities",
            },
        ),
    ]
