#
# this code is auto generated by other program
# DO NOT modify this
#

import json
from urllib import parse

import requests
from aiohttp import ClientSession

from .base import DtkBase
from .dt_resp_v2 import *


class DelsJdKitPromotionUnionConvertArgs(BaseModel):
    unionId: str = Field(..., title=f"""推客的联盟ID""")

    materialId: str = Field(..., title=f"""推广物料url，例如活动链接、商品链接等；不支持仅传入skuid""")

    positionId: Optional[str] = Field(
        None, title=f"""新增推广位id （不填的话，默认生成一个唯一此接口推广位-名称：微信手Q短链接"""
    )

    childPid: Optional[str] = Field(None, title=f""" 联盟子推客身份标识（不能传入接口调用者自己的pid）""")

    subUnionId: Optional[str] = Field(
        None, title=f"""子渠道标识，您可自定义传入字母、数字或下划线，最多支持80个字符，该参数会在订单行查询接口中展示"""
    )

    couponUrl: Optional[str] = Field(
        None, title=f"""优惠券领取链接，在使用优惠券、商品二合一功能时入参，且materialId须为商品详情页链接"""
    )

    chainType: Optional[str] = Field(
        None, title=f"""转链类型，默认短链，短链有效期60天1：长链2：短链 3：长链+短链，"""
    )

    giftCouponKey: Optional[str] = Field(None, title=f"""礼金批次号""")


class DelsJdOrderGetOfficialOrderListArgs(BaseModel):
    pageNo: Optional[str] = Field(None, title=f"""页码（默认为1）""")

    pageSize: Optional[str] = Field(None, title=f"""每页记录条数，默认100""")

    type: str = Field(..., title=f"""订单时间查询类型(1：下单时间，2：完成时间（购买用户确认收货时间），3：更新时间""")

    childUnionId: Optional[str] = Field(
        None, title=f"""子推客unionID，传入该值可查询子推客的订单，注意不可和key同时传入。（需联系运营开通PID权限才能拿到数据）"""
    )

    startTime: str = Field(
        ..., title=f"""开始时间 格式yyyy-MM-dd HH:mm:ss，与endTime间隔不超过1小时"""
    )

    endTime: str = Field(
        ..., title=f"""结束时间 格式yyyy-MM-dd HH:mm:ss，与startTime间隔不超过1小时"""
    )

    key: str = Field(
        ...,
        title=f"""工具商传入推客的授权key，可帮助该推客查询订单，注意不可和childUnionid同时传入。（需联系运营开通工具商权限才能拿到数据，请在京东联盟->我的工具->我的API->领取授权KEY中获取key）""",
    )


class GoodsGetHistoryLowPriceListArgs(BaseModel):
    pageSize: str = Field(..., title=f"""每页返回条数，每页条数支持输入10,20，50,100。默认50条""")

    pageId: str = Field(..., title=f"""分页id：常规分页方式，请直接传入对应页码（比如：1,2,3……）""")

    cids: Optional[str] = Field(
        None, title=f"""大淘客的一级分类id，如果需要传多个，以英文逗号相隔，如：”1,2,3”。"""
    )

    sort: str = Field(
        ...,
        title=f"""排序方式，默认为0，0-综合排序，1-商品上架时间从高到低，2-销量从高到低，3-领券量从高到低，4-佣金比例从高到低，5-价格（券后价）从高到低，6-价格（券后价）从低到高""",
    )


class DelanysMediaVideoGetGoodsListArgs(BaseModel):
    cid: str = Field(..., title=f"""短视频分类id""")

    pageId: str = Field(..., title=f"""分页id：常规分页方式，请直接传入对应页码（比如：1,2,3……）""")

    pageSize: str = Field(..., title=f"""每页记录条数：10，20，50，100""")


class DelanysBrandGetGoodsListArgs(BaseModel):
    brandId: str = Field(..., title=f"""品牌id""")

    pageId: str = Field(
        ..., title=f"""分页id：常规分页方式，请直接传入对应页码（比如：1,2,3……） 第一页时会携带品牌信息数据"""
    )

    pageSize: str = Field(..., title=f"""每页记录条数（每页支持最大记录条数100）""")


class DelanysBrandGetColumnListArgs(BaseModel):
    cid: str = Field(..., title=f"""大淘客分类id""")

    pageId: str = Field(..., title=f"""分页id：常规分页方式，请直接传入对应页码（比如：1,2,3……）""")

    pageSize: str = Field(..., title=f""" 每页记录条数（每页记录最大支持50，如果参数大于50时取50作为每页记录条数）""")


class CommentGetCommentListArgs(BaseModel):
    id: str = Field(..., title=f"""大淘客商品id（id和goodsid其中一个必填）""")

    goodsId: Optional[str] = Field(None, title=f"""淘宝商品id（id和goodsid其中一个必填）""")

    type: Optional[str] = Field(None, title=f"""默认：0-全部  评论类型：0-全部；1-含图；2-含视频；""")


class DelsShopConvertArgs(BaseModel):
    sellerId: str = Field(..., title=f"""店铺id""")

    pid: str = Field(..., title=f"""推广位id""")

    relationId: Optional[str] = Field(None, title=f"""渠道id""")

    shopName: str = Field(..., title=f"""店铺名称，用于返回淘口令""")


class SubdivisionGetRankListArgs(BaseModel):
    subdivisionId: str = Field(..., title=f"""细分类目榜分类id（从商品详情获取）""")


class GoodsSuperDiscountGoodsArgs(BaseModel):
    pageSize: str = Field(..., title=f"""每页返回条数，每页条数支持输入10,20，50,100。默认50条""")

    pageId: str = Field(..., title=f"""分页id：常规分页方式，请直接传入对应页码（比如：1,2,3……）""")

    cids: Optional[str] = Field(
        None, title=f"""大淘客的一级分类id，如果需要传多个，以英文逗号相隔，如：”1,2,3”。"""
    )

    sort: str = Field(
        ...,
        title=f"""排序方式，默认为0，0-综合排序，1-商品上架时间从高到低，2-销量从高到低，3-领券量从高到低，4-佣金比例从高到低，5-价格（券后价）从高到低，6-价格（券后价）从低到高""",
    )


class GoodsGetHalfPriceDayArgs(BaseModel):
    sessions: str = Field(..., title=f""" 默认为当前场次，场次输入格式，例如02、08、12、13""")


class DelsMergeRedEnvelopesArgs(BaseModel):
    merchantType: str = Field(..., title=f"""（1-淘宝红包，2京东红包，3-拼多多红包）""")

    pid: Optional[str] = Field(
        None,
        title=f"""推广位ID（大淘客账号下已授权淘宝账号的任一pid，若未填写，则默认使用创建应用时绑定的pid；其中京东pid为联盟子推客身份标识（不能传入接口调用者自己的pid）""",
    )

    unionId: str = Field(..., title=f"""选择京东红包时需要填入京东联盟ID（在京东联盟后台个人中心）。其他类型不用传""")


class GoodsPriceTrendArgs(BaseModel):
    id: str = Field(..., title=f"""在大淘客的在线商品id（已下架的商品id不支持）""")

    goodsId: Optional[str] = Field(None, title=f"""淘宝商品id""")


class GoodsLivematerialGoodsListArgs(BaseModel):
    date: Optional[str] = Field(
        None, title=f"""选择某一天的直播商品数据，默认返回全部参与过直播，且未下架的商品。时间格式：2020-09-16"""
    )

    sort: Optional[str] = Field(
        None,
        title=f"""排序方式，默认为0，0-综合排序，1-商品上架时间从高到低，2-销量从高到低，3-领券量从高到低，4-佣金比例从高到低，5-价格（券后价）从高到低，6-价格（券后价）从低到高""",
    )


class GoodsExplosiveGoodsListArgs(BaseModel):
    pageId: str = Field(..., title=f"""分页id：常规分页方式，请直接传入对应页码（比如：1,2,3……）""")

    pageSize: str = Field(..., title=f"""每页返回条数，每页条数支持输入10,20，50,100。默认50条""")

    PriceCid: Optional[str] = Field(
        None, title=f"""价格区间，1表示10~20元区；2表示20~40元区；3表示40元以上区；默认为1"""
    )

    cids: Optional[str] = Field(
        None,
        title=f"""大淘客的一级分类id，如果需要传多个，以英文逗号相隔，如：”1,2,3”。1 -女装，2 -母婴，3 -美妆，4 -居家日用，5 -鞋品，6 -美食，7 -文娱车品，8 -数码家电，9 -男装，10 -内衣，11 -箱包，12 -配饰，13 -户外运动，14 -家装家纺。不填默认全部""",
    )


class TbServiceParseContentArgs(BaseModel):
    content: str = Field(
        ...,
        title=f"""包含淘口令、链接的文本。优先解析淘口令，再按序解析每个链接，直至解出有效信息。*如果淘口令失效或者不支持的类型的情况，会按顺序解析链接。如果存在解析失败，请再试一次*""",
    )


class GoodsExclusiveGoodsListArgs(BaseModel):
    pageSize: str = Field(..., title=f"""每页返回条数，每页条数支持输入10,20，50,100。默认50条""")

    pageId: str = Field(..., title=f"""分页id：常规分页方式，请直接传入对应页码（比如：1,2,3……）""")

    cids: Optional[str] = Field(
        None, title=f"""大淘客的一级分类id，如果需要传多个，以英文逗号相隔，如：”1,2,3”。"""
    )

    sort: Optional[str] = Field(
        None,
        title=f"""排序方式，默认为0，0-综合排序，1-商品上架时间从高到低，2-销量从高到低，3-领券量从高到低，4-佣金比例从高到低，5-价格（券后价）从高到低，6-价格（券后价）从低到高""",
    )


class TbServiceActivityLinkArgs(BaseModel):
    promotionSceneId: str = Field(
        ..., title=f"""联盟官方活动ID，从联盟官方活动页获取或从*大淘客官方活动推广接口获取*"""
    )

    pid: Optional[str] = Field(None, title=f"""推广pid，默认为在”我的应用“添加的pid""")

    relationId: Optional[str] = Field(
        None, title=f"""渠道id将会和传入的pid进行验证，验证通过将正常转链，请确认填入的渠道id是正确的"""
    )

    unionId: Optional[str] = Field(
        None, title=f"""自定义输入串，英文和数字组成，长度不能大于12个字符，区分不同的推广渠道"""
    )


class TbServiceTwdToTwdArgs(BaseModel):
    content: str = Field(..., title=f"""支持包含文本的淘口令，但最好是一个单独淘口令""")

    pid: Optional[str] = Field(
        None, title=f"""推广位ID，用户可自由填写当前大淘客账号下已授权淘宝账号的任一pid，若未填写，则默认使用创建应用时绑定的pid"""
    )

    channelId: Optional[str] = Field(
        None, title=f"""渠道id将会和传入的pid进行验证，验证通过将正常转链，请确认填入的渠道id是正确的"""
    )

    special_id: Optional[str] = Field(None, title=f"""会员运营ID""")

    external_id: Optional[str] = Field(None, title=f"""淘宝客外部用户标记，如自身系统账户ID；微信ID等""")


class GoodsFirstOrderGiftMoneyArgs(BaseModel):
    pageSize: str = Field(..., title=f"""每页返回条数，每页条数支持输入10,20，50,100,200""")

    pageId: str = Field(..., title=f"""分页id：常规分页方式，请直接传入对应页码（比如：1,2,3……）""")

    cids: Optional[str] = Field(
        None,
        title=f"""大淘客的一级分类id，如果需要传多个，以英文逗号相隔，如：”1,2,3”。1 -女装，2 -母婴，3 -美妆，4 -居家日用，5 -鞋品，6 -美食，7 -文娱车品，8 -数码家电，9 -男装，10 -内衣，11 -箱包，12 -配饰，13 -户外运动，14 -家装家纺""",
    )

    sort: Optional[str] = Field(
        None,
        title=f"""排序方式，默认为0，0-综合排序，1-商品上架时间从高到低，2-销量从高到低，3-领券量从高到低，4-佣金比例从高到低，5-价格（券后价）从高到低，6-价格（券后价）从低到高""",
    )

    keyWord: Optional[str] = Field(None, title=f"""输入关键词搜索*(新增字段)*""")

    goodsType: Optional[str] = Field(
        None, title=f"""商品类型1表示大淘客商品2表示联盟商品。默认为1 *（2020.11.4新增字段）*"""
    )


class TbServiceCreatTaokoulingArgs(BaseModel):
    text: str = Field(..., title=f"""口令弹框内容，长度大于5个字符""")

    url: str = Field(
        ...,
        title=f"""口令跳转目标页，如：https://uland.taobao.com/，*必须以https开头*，可以是二合一链接、长链接、短链接等各种淘宝高佣链接；支持渠道备案链接。* 该参数需要进行Urlencode编码后传入*""",
    )

    logo: Optional[str] = Field(None, title=f"""口令弹框logoURL""")

    userId: Optional[str] = Field(None, title=f"""生成口令的淘宝用户ID，非必传参数""")


class TbServiceGetOrderDetailsArgs(BaseModel):
    positionIndex: Optional[str] = Field(
        None, title=f"""位点，第一页数据返回里面有个这个字段，查第二页的数据的时候就传过去"""
    )

    pageSize: Optional[str] = Field(None, title=f"""页大小，默认20，1~100""")

    memberType: Optional[str] = Field(None, title=f"""推广者角色类型,2:二方，3:三方，不传，表示所有角色""")

    tkStatus: Optional[str] = Field(
        None, title=f"""淘客订单状态，12-付款，13-关闭，14-确认收货，3-结算成功;不传，表示所有状态"""
    )

    endTime: str = Field(
        ...,
        title=f"""订单查询结束时间，订单开始时间至订单结束时间，*中间时间段日常要求不超过3个小时，但如618、双11、年货节等大促期间预估时间段不可超过20分钟，超过会提示错误，调用时请务必注意时间段的选择，以保证亲能正常调用！*  时间格式：YYYY-MM-DD HH:MM:SS""",
    )

    startTime: str = Field(..., title=f"""订单查询开始时间。时间格式：YYYY-MM-DD HH:MM:SS""")

    jumpType: Optional[str] = Field(
        None, title=f"""跳转类型，当向前或者向后翻页必须提供,-1: 向前翻页,1：向后翻页"""
    )

    pageNo: Optional[str] = Field(None, title=f"""第几页，默认1，1~100""")

    orderScene: Optional[str] = Field(
        None, title=f"""场景订单场景类型，1:常规订单，2:渠道订单，3:会员运营订单，默认为1"""
    )

    queryType: str = Field(
        ..., title=f"""查询时间类型，1：按照订单淘客创建时间查询，2:按照订单淘客付款时间查询，3:按照订单淘客结算时间查询"""
    )


class TbServiceParseTaokoulingArgs(BaseModel):
    content: str = Field(
        ..., title=f"""包含淘口令的文本。* 若文本中有多个淘口令，仅解析第一个。（目前仅支持商品口令和二合一券口令）* """
    )


class TbServiceGetPrivilegeLinkArgs(BaseModel):
    goodsId: str = Field(..., title=f"""淘宝商品id""")

    couponId: Optional[str] = Field(
        None,
        title=f"""商品的优惠券ID，一个商品在联盟可能有多个优惠券，可通过填写该参数的方式选择使用的优惠券，请确认优惠券ID正确，否则无法正常跳转""",
    )

    pid: Optional[str] = Field(
        None, title=f"""推广位ID，用户可自由填写当前大淘客账号下已授权淘宝账号的任一pid，若未填写，则默认使用创建应用时绑定的pid"""
    )

    channelId: Optional[str] = Field(
        None,
        title=f"""渠道id将会和传入的pid进行验证，验证通过将正常转链，请确认填入的渠道id是正确的 *channelId对应联盟的relationId*""",
    )

    specialId: Optional[str] = Field(None, title=f"""会员运营id""")

    externalId: Optional[str] = Field(None, title=f"""淘宝客外部用户标记，如自身系统账户ID；微信ID等""")

    rebateType: Optional[str] = Field(None, title=f"""付定返红包，0.不使用付定返红包，1.参与付定返红包""")


class GoodsNineOpGoodsListArgs(BaseModel):
    pageId: str = Field(..., title=f"""分页id：常规分页方式，请直接传入对应页码（比如：1,2,3……）""")

    pageSize: str = Field(..., title=f"""每页条数：默认为20，最大值100""")

    nineCid: str = Field(
        ..., title=f"""9.9精选的类目id，分类id请求详情：*-1-精选，1 -5.9元区，2 -9.9元区，3 -19.9元区（调整字段）*"""
    )


class CategoryDdqGoodsListArgs(BaseModel):
    roundTime: Optional[str] = Field(
        None, title=f"""默认为当前场次，场次时间输入方式：yyyy-mm-dd hh:mm:ss"""
    )


class GoodsGetRankingListArgs(BaseModel):
    rankType: str = Field(
        ..., title=f"""榜单类型，1.实时榜 2.全天榜 3.热推榜 4.复购榜 5.热词飙升榜 6.热词排行榜 7.综合热搜榜"""
    )

    cid: Optional[str] = Field(None, title=f"""大淘客一级类目id，仅对实时榜单、全天榜单有效""")

    pageSize: Optional[str] = Field(None, title=f"""每页条数返回条数（支持10,20.50，默认返回20条）""")

    pageId: Optional[str] = Field(
        None, title=f"""分页id：常规分页方式，请直接传入对应页码（比如：1,2,3……）。*超过200条，分页返回为空*"""
    )


class GoodsFriendsCircleListArgs(BaseModel):
    pageSize: Optional[str] = Field(
        None, title=f"""每页条数，默认为100，若小于10，则按10条处理，每页条数仅支持输入10,50,100"""
    )

    pageId: str = Field(..., title=f"""分页id，默认为1，支持传统的页码分页方式""")

    sort: Optional[str] = Field(
        None,
        title=f"""排序方式，默认为0，0-综合排序，1-商品上架时间从高到低，2-销量从高到低，3-领券量从高到低，4-佣金比例从高到低，5-价格（券后价）从高到低，6-价格（券后价）从低到高""",
    )

    subcid: Optional[str] = Field(
        None,
        title=f"""大淘客的二级类目id，通过超级分类API获取。仅允许传一个二级id，当一级类目id和二级类目id同时传入时，会自动忽略二级类目id""",
    )

    pre: Optional[str] = Field(None, title=f"""是否预告商品，1-预告商品，0-所有商品，不填默认为0""")

    freeshipRemoteDistrict: Optional[str] = Field(
        None, title=f"""偏远地区包邮，1-是，0-非偏远地区，不填默认所有商品"""
    )

    goodsId: Optional[str] = Field(
        None, title=f"""大淘客id或淘宝id，查询单个商品是否有朋友圈文案，如果有，则返回商品信息及朋友圈文案，如果没有，显示10006错误 """
    )

    cid: Optional[str] = Field(None, title=f"""大淘客的一级分类id，如6、4""")


class GoodsTopicGoodsListArgs(BaseModel):
    pageId: str = Field(
        ...,
        title=f"""分页id，默认为1，支持传统的页码分页方式和scroll_id分页方式，根据用户自身需求传入值。示例1：商品入库，则首次传入1，后续传入接口第一次返回的pageid，接口将持续返回符合条件的完整商品列表，该方式可以避免入库商品重复；示例2：根据pagesize和totalNum计算出总页数，按照需求返回指定页的商品（该方式可能在临近页取到重复商品）""",
    )

    pageSize: Optional[str] = Field(None, title=f"""每页条数，默认为100，大于100按100处理""")

    topicId: str = Field(..., title=f"""专辑id，通过精选专辑API获取的活动id""")


class CategoryGetTbTopicListArgs(BaseModel):
    pageId: str = Field(..., title=f"""分页id，支持传统的页码分页方式""")

    pageSize: Optional[str] = Field(None, title=f"""每页条数，默认为20""")

    type: Optional[str] = Field(None, title=f"""输出的端口类型：0.全部（默认），1.PC，2.无线""")

    channelID: Optional[str] = Field(None, title=f"""阿里妈妈上申请的渠道id""")


class TbServiceGetBrandListArgs(BaseModel):
    pageId: str = Field(..., title=f"""页码""")

    pageSize: Optional[str] = Field(None, title=f"""每页条数，默认为20，最大值100""")


class GoodsSearchSuggestionArgs(BaseModel):
    keyWords: str = Field(..., title=f"""关键词""")

    type: str = Field(..., title=f"""当前搜索API类型：1.大淘客搜索 2.联盟搜索 3.超级搜索""")


class GoodsListSuperGoodsArgs(BaseModel):
    pageId: str = Field(..., title=f"""请求的页码，默认参数1""")

    pageSize: str = Field(..., title=f"""每页条数，默认为20，最大值100""")

    keyWords: str = Field(..., title=f"""关键词搜索""")

    type: str = Field(..., title=f"""搜索类型：0-综合结果，1-大淘客商品，2-联盟商品""")

    tmall: Optional[str] = Field(None, title=f"""是否天猫商品：1-天猫商品，0-所有商品，不填默认为0""")

    haitao: Optional[str] = Field(None, title=f"""是否海淘商品：1-海淘商品，0-所有商品，不填默认为0""")

    sort: Optional[str] = Field(
        None,
        title=f"""排序字段信息 销量（total_sales） 价格（price），排序_des（降序），排序_asc（升序），示例：升序查询销量total_sales_asc""",
    )

    specialId: Optional[str] = Field(None, title=f"""会员运营id""")

    channelId: Optional[str] = Field(
        None,
        title=f"""渠道id将会和传入的pid进行验证，验证通过将正常转链，请确认填入的渠道id是正确的*channelId对应联盟的relationId*""",
    )


class GoodsListSimilerGoodsByOpenArgs(BaseModel):
    id: str = Field(..., title=f"""大淘客的商品id""")

    size: Optional[str] = Field(None, title=f"""每页条数，默认10 ， 最大值100""")


class GoodsGetGoodsListArgs(BaseModel):
    pageId: str = Field(
        ...,
        title=f"""默认为1，支持传统的页码分页方式和scroll_id分页方式，根据用户自身需求传入值。示例1：商品入库，则首次传入1，后续传入接口返回的pageid，接口将持续返回符合条件的完整商品列表，该方式可以避免入口商品重复；示例2：根据pagesize和totalNum计算出总页数，按照需求返回指定页的商品（该方式可能在临近页取到重复商品）""",
    )

    pageSize: Optional[str] = Field(
        None, title=f"""每页条数，默认为100，最大值200，若小于10，则按10条处理，每页条数仅支持输入10,50,100,200"""
    )

    sort: Optional[str] = Field(
        None,
        title=f"""排序方式，默认为0，0-综合排序，1-商品上架时间从高到低，2-销量从高到低，3-领券量从高到低，4-佣金比例从高到低，5-价格（券后价）从高到低，6-价格（券后价）从低到高""",
    )

    cids: Optional[str] = Field(
        None,
        title=f"""大淘客的一级分类id，如果需要传多个，以英文逗号相隔，如：”1,2,3”。当一级类目id和二级类目id同时传入时，会自动忽略二级类目id""",
    )

    subcid: Optional[str] = Field(
        None,
        title=f"""大淘客的二级类目id，通过超级分类API获取。仅允许传一个二级id，当一级类目id和二级类目id同时传入时，会自动忽略二级类目id""",
    )

    juHuaSuan: Optional[str] = Field(None, title=f"""1-聚划算商品，0-所有商品，不填默认为0""")

    taoQiangGou: Optional[str] = Field(None, title=f"""1-淘抢购商品，0-所有商品，不填默认为0""")

    tmall: Optional[str] = Field(None, title=f"""1-天猫商品， 0-非天猫商品，不填默认所有商品""")

    tchaoshi: Optional[str] = Field(None, title=f"""1-天猫超市商品， 0-所有商品，不填默认为0""")

    goldSeller: Optional[str] = Field(None, title=f"""1-金牌卖家商品，0-所有商品，不填默认为0""")

    haitao: Optional[str] = Field(None, title=f"""1-海淘商品， 0-所有商品，不填默认为0""")

    pre: Optional[str] = Field(None, title=f"""1-预告商品，0-所有商品，不填默认为0""")

    brand: Optional[str] = Field(None, title=f"""1-品牌商品，0-所有商品，不填默认为0""")

    brandIds: Optional[str] = Field(
        None,
        title=f"""当brand传入0时，再传入brandIds可能无法获取结果。品牌id可以传多个，以英文逗号隔开，如：”345,321,323”""",
    )

    priceLowerLimit: Optional[str] = Field(None, title=f"""价格（券后价）下限""")

    priceUpperLimit: Optional[str] = Field(None, title=f"""价格（券后价）上限""")

    commissionRateLowerLimit: Optional[str] = Field(None, title=f"""最低佣金比率""")

    monthSalesLowerLimit: Optional[str] = Field(None, title=f"""最低月销量""")

    specialId: Optional[str] = Field(
        None, title=f"""商品卖点，1.拍多件活动；2.多买多送；3.限量抢购；4.额外满减；6.买商品礼赠"""
    )

    freeshipRemoteDistrict: Optional[str] = Field(
        None, title=f"""偏远地区包邮，1-是，0-非偏远地区，不填默认所有商品"""
    )

    couponPriceLowerLimit: Optional[str] = Field(None, title=f"""最低优惠券面额""")

    preSale: Optional[str] = Field(
        None, title=f"""1-活动预售商品，0-所有商品，不填默认为0。*（10.30新增字段）*"""
    )


class GoodsGetGoodsDetailsArgs(BaseModel):
    id: str = Field(..., title=f"""大淘客商品id，请求时id或goodsId必填其中一个，若均填写，将优先查找当前单品id""")

    goodsId: Optional[str] = Field(
        None, title=f"""淘宝商品id，id或goodsId必填其中一个，若均填写，将优先查找当前单品id"""
    )


class GoodsGetDtkSearchGoodsArgs(BaseModel):
    pageId: str = Field(
        ...,
        title=f"""分页id，默认为1，支持传统的页码分页方式和scroll_id分页方式，根据用户自身需求传入值。示例1：商品入库，则首次传入1，后续传入接口返回的pageid，接口将持续返回符合条件的完整商品列表，该方式可以避免入口商品重复；示例2：根据pagesize和totalNum计算出总页数，按照需求返回指定页的商品（该方式可能在临近页取到重复商品）""",
    )

    pageSize: str = Field(
        ..., title=f"""每页条数，默认为100，最大值200，若小于10，则按10条处理，每页条数仅支持输入10,50,100,200"""
    )

    keyWords: str = Field(..., title=f"""关键词搜索""")

    cids: Optional[str] = Field(
        None,
        title=f"""大淘客的一级分类id，如果需要传多个，以英文逗号相隔，如：”1,2,3”。当一级类目id和二级类目id同时传入时，会自动忽略二级类目id，一级分类id请求详情：1 -女装，2 -母婴，3 -美妆，4 -居家日用，5 -鞋品，6 -美食，7 -文娱车品，8 -数码家电，9 -男装，10 -内衣，11 -箱包，12 -配饰，13 -户外运动，14 -家装家纺""",
    )

    subcid: Optional[str] = Field(
        None,
        title=f"""大淘客的二级类目id，通过超级分类API获取。仅允许传一个二级id，当一级类目id和二级类目id同时传入时，会自动忽略二级类目id""",
    )

    juHuaSuan: Optional[str] = Field(None, title=f"""是否聚划算，1-聚划算商品，0-所有商品，不填默认为0""")

    taoQiangGou: Optional[str] = Field(None, title=f"""是否淘抢购，1-淘抢购商品，0-所有商品，不填默认为0""")

    tmall: Optional[str] = Field(None, title=f"""是否天猫商品，1-天猫商品，0-非天猫商品，不填默认为所有商品""")

    tchaoshi: Optional[str] = Field(None, title=f"""是否天猫超市商品，1-天猫超市商品，0-所有商品，不填默认为0""")

    goldSeller: Optional[str] = Field(None, title=f"""是否金牌卖家，1-金牌卖家，0-所有商品，不填默认为0""")

    haitao: Optional[str] = Field(None, title=f"""是否海淘商品，1-海淘商品，0-所有商品，不填默认为0""")

    brand: Optional[str] = Field(None, title=f"""是否品牌商品，1-品牌商品，0-所有商品，不填默认为0""")

    brandIds: Optional[str] = Field(
        None,
        title=f"""品牌id，当brand传入0时，再传入brandIds将获取不到结果。品牌id可以传多个，以英文逗号隔开，如：”345,321,323”""",
    )

    priceLowerLimit: Optional[str] = Field(None, title=f"""价格（券后价）下限""")

    priceUpperLimit: Optional[str] = Field(None, title=f"""价格（券后价）上限""")

    commissionRateLowerLimit: Optional[str] = Field(None, title=f"""最低佣金比率""")

    sort: Optional[str] = Field(
        None,
        title=f"""排序字段，默认为0，0-综合排序，1-商品上架时间从新到旧，2-销量从高到低，3-领券量从高到低，4-佣金比例从高到低，5-价格（券后价）从高到低，6-价格（券后价）从低到高""",
    )

    freeshipRemoteDistrict: Optional[str] = Field(
        None, title=f"""偏远地区包邮，1-是，0-非偏远地区，不填默认所有商品"""
    )

    couponPriceLowerLimit: Optional[str] = Field(None, title=f"""最低优惠券面额""")

    monthSalesLowerLimit: Optional[str] = Field(None, title=f"""最低月销量""")


class GoodsPullGoodsByTimeArgs(BaseModel):
    pageId: str = Field(
        ...,
        title=f"""分页id，默认为1，支持传统的页码分页方式和scroll_id分页方式，根据用户自身需求传入值。示例1：商品入库，则首次传入1，后续传入接口返回的pageid，接口将持续返回符合条件的完整商品列表，该方式可以避免入口商品重复；示例2：根据pagesize和totalNum计算出总页数，按照需求返回指定页的商品（该方式可能在临近页取到重复商品）""",
    )

    pageSize: Optional[str] = Field(
        None, title=f"""每页条数，默认为100，最大值200，若小于10，则按10条处理，每页条数仅支持输入10,50,100,200"""
    )

    cid: Optional[str] = Field(
        None, title=f"""大淘客的一级分类id。当一级类目id和二级类目id同时传入时，会自动忽略二级类目id"""
    )

    subcid: Optional[str] = Field(
        None,
        title=f"""大淘客的二级类目id，通过超级分类API获取。仅允许传一个二级id，当一级类目id和二级类目id同时传入时，会自动忽略二级类目id""",
    )

    pre: Optional[str] = Field(None, title=f"""是否预告商品，1-预告商品，0-所有商品，不填默认为0""")

    sort: Optional[str] = Field(
        None,
        title=f"""排序方式，默认为0，0-综合排序，1-商品上架时间从新到旧，2-销量从高到低，3-领券量从高到低，4-佣金比例从高到低，5-价格（券后价）从高到低，6-价格（券后价）从低到高""",
    )

    startTime: Optional[str] = Field(
        None, title=f"""开始时间，格式为yy-mm-dd hh:mm:ss，商品下架的时间大于等于开始时间"""
    )

    endTime: Optional[str] = Field(None, title=f"""结束时间，默认为请求的时间，商品下架的时间小于等于结束时间""")

    freeshipRemoteDistrict: Optional[str] = Field(
        None, title=f"""偏远地区包邮，1-是，0-非偏远地区，不填默认所有商品"""
    )


class GoodsGetStaleGoodsByTimeArgs(BaseModel):
    pageId: str = Field(
        ...,
        title=f"""分页id，默认为1，支持传统的页码分页方式和scroll_id分页方式，根据用户自身需求传入值。示例1：商品入库，则首次传入1，后续传入接口返回的pageid，接口将持续返回符合条件的完整商品列表，该方式可以避免入口商品重复；示例2：根据pagesize和totalNum计算出总页数，按照需求返回指定页的商品（该方式可能在临近页取到重复商品）""",
    )

    pageSize: Optional[str] = Field(None, title=f"""""")

    startTime: Optional[str] = Field(None, title=f"""""")

    endTime: Optional[str] = Field(
        None, title=f"""结束时间，默认为请求的时间，商品下架的时间小于等于结束时间，结束时间需要在当日"""
    )


class GoodsGetNewestGoodsArgs(BaseModel):
    pageId: str = Field(
        ...,
        title=f"""分页id，默认为1，支持传统的页码分页方式和scroll_id分页方式，根据用户自身需求传入值。示例1：商品入库，则首次传入1，后续传入接口返回的pageid，接口将持续返回符合条件的完整商品列表，该方式可以避免入口商品重复；示例2：根据pagesize和totalNum计算出总页数，按照需求返回指定页的商品（该方式可能在临近页取到重复商品）""",
    )

    pageSize: str = Field(
        ..., title=f"""每页条数，默认为100，最大值200，若小于10，则按10条处理，每页条数仅支持输入10,50,100,200"""
    )

    startTime: Optional[str] = Field(
        None, title=f"""商品上架开始时间，请求格式：yyyy-MM-dd HH:mm:ss"""
    )

    endTime: Optional[str] = Field(None, title=f"""商品上架结束时间，请求格式：yyyy-MM-dd HH:mm:ss""")

    cids: Optional[str] = Field(
        None,
        title=f"""大淘客的一级分类id，如果需要传多个，以英文逗号相隔，如：”1,2,3”。当一级类目id和二级类目id同时传入时，会自动忽略二级类目id，1 -女装，2 -母婴，3 -美妆，4 -居家日用，5 -鞋品，6 -美食，7 -文娱车品，8 -数码家电，9 -男装，10 -内衣，11 -箱包，12 -配饰，13 -户外运动，14 -家装家纺""",
    )

    subcid: Optional[str] = Field(
        None,
        title=f"""大淘客的二级类目id，通过超级分类API获取。仅允许传一个二级id，当一级类目id和二级类目id同时传入时，会自动忽略二级类目id""",
    )

    juHuaSuan: Optional[str] = Field(None, title=f"""1-聚划算商品，0-所有商品，不填默认为0""")

    taoQiangGou: Optional[str] = Field(None, title=f"""1-淘抢购商品，0-所有商品，不填默认为0""")

    tmall: Optional[str] = Field(None, title=f"""1-天猫商品，0-非天猫商品，不填默认全部商品""")

    tchaoshi: Optional[str] = Field(None, title=f"""1-天猫超市商品，0-所有商品，不填默认为0""")

    goldSeller: Optional[str] = Field(None, title=f"""1-金牌卖家，0-所有商品，不填默认为0""")

    haitao: Optional[str] = Field(None, title=f"""1-海淘，0-所有商品，不填默认为0""")

    brand: Optional[str] = Field(None, title=f"""1-品牌，0-所有商品，不填默认为0""")

    brandIds: Optional[str] = Field(
        None,
        title=f"""品牌id，当brand传入0时，再传入brandIds将获取不到结果。品牌id可以传多个，以英文逗号隔开，如：”345,321,323”""",
    )

    priceLowerLimit: Optional[str] = Field(None, title=f"""价格（券后价）下限""")

    priceUpperLimit: Optional[str] = Field(None, title=f"""价格（券后价）上限""")

    couponPriceLowerLimit: Optional[str] = Field(None, title=f"""最低优惠券面额""")

    commissionRateLowerLimit: Optional[str] = Field(None, title=f"""最低佣金比率""")

    monthSalesLowerLimit: Optional[str] = Field(None, title=f"""最低月销量""")

    sort: Optional[str] = Field(
        None,
        title=f"""排序字段，默认为0，0-综合排序，1-商品上架时间从新到旧，2-销量从高到低，3-领券量从高到低，4-佣金比例从高到低，5-价格（券后价）从高到低，6-价格（券后价）从低到高""",
    )

    preSale: Optional[str] = Field(
        None, title=f"""1-活动预售商品，0-所有商品，不填默认为0。*（2020.10.30号新增字段）*"""
    )


class TbServiceGetTbServiceArgs(BaseModel):
    pageNo: str = Field(..., title=f"""第几页，默认1""")

    pageSize: str = Field(..., title=f"""每页条数， 默认20，范围值1~100""")

    keyWords: str = Field(..., title=f"""查询词""")

    sort: Optional[str] = Field(
        None,
        title=f"""排序指标：销量（total_sales），淘客佣金比率（tk_rate）， 累计推广量（tk_total_sales），总支出佣金（tk_total_commi），价格（price）,排序方式：排序_des（降序），排序_asc（升序）,示例：升序查询销量：total_sales_asc""",
    )

    source: Optional[str] = Field(
        None,
        title=f"""是否商城商品，设置为1表示该商品是属于淘宝商城商品，设置为非1或不设置表示不判断这个属性（和overseas字段冲突，若已请求source，请勿再请求overseas）""",
    )

    overseas: Optional[str] = Field(
        None,
        title=f"""是否海外商品，设置为1表示该商品是属于海外商品，设置为非1或不设置表示不判断这个属性（和source字段冲突，若已请求overseas，请勿再请求source）""",
    )

    endPrice: Optional[str] = Field(None, title=f"""折扣价范围上限，单位：元""")

    startPrice: Optional[str] = Field(None, title=f"""折扣价范围下限，单位：元""")

    startTkRate: Optional[str] = Field(None, title=f"""媒体淘客佣金比率下限，如：1234表示12.34%""")

    endTkRate: Optional[str] = Field(None, title=f"""商品筛选-淘客佣金比率上限，如：1234表示12.34%""")

    hasCoupon: Optional[str] = Field(
        None, title=f"""是否有优惠券，设置为true表示该商品有优惠券，设置为false或不设置表示不判断这个属性"""
    )

    specialId: Optional[str] = Field(None, title=f"""会员运营id""")

    channelId: Optional[str] = Field(
        None,
        title=f"""渠道id将会和传入的pid进行验证，验证通过将正常转链，请确认填入的渠道id是正确的*channelId对应联盟的relationId*""",
    )


class GoodsGetCollectionListArgs(BaseModel):
    pageId: str = Field(
        ...,
        title=f"""默认为1，支持传统的页码分页方式和scroll_id分页方式，根据用户自身需求传入值。示例1：商品入库，则首次传入1，后续传入接口返回的pageid，接口将持续返回符合条件的完整商品列表，该方式可以避免入口商品重复；示例2：根据pagesize和totalNum计算出总页数，按照需求返回指定页的商品（该方式可能在临近页取到重复商品）""",
    )

    pageSize: Optional[str] = Field(
        None, title=f"""每页条数，默认为100，最大值200，若小于10，则按10条处理，每页条数仅支持输入10,50,100,200"""
    )

    cid: Optional[str] = Field(
        None,
        title=f"""商品在大淘客的一级分类id，如果需要传多个，以英文逗号相隔，如：”1,2,3”。当一级类目id和二级类目id同时传入时，会自动忽略二级类目id，1 -女装，2 -母婴，3 -美妆，4 -居家日用，5 -鞋品，6 -美食，7 -文娱车品，8 -数码家电，9 -男装，10 -内衣，11 -箱包，12 -配饰，13 -户外运动，14 -家装家纺""",
    )

    trailerType: Optional[str] = Field(
        None, title=f"""是否返回预告商品，1为预告商品，0为在线商品，不填则全部商品"""
    )

    sort: Optional[str] = Field(
        None,
        title=f"""排序字段，默认为0，0-综合排序，1-商品上架时间从高到低，2-销量从高到低，3-领券量从高到低，4-佣金比例从高到低，5-价格（券后价）从高到低，6-价格（券后价）从低到高""",
    )

    collectionTimeOrder: Optional[str] = Field(None, title=f"""加入收藏时间""")


class GoodsGetOwnerGoodsArgs(BaseModel):
    pageId: str = Field(
        ...,
        title=f"""分页id，默认为1，支持传统的页码分页方式和scroll_id分页方式，根据用户自身需求传入值。示例1：商品入库，则首次传入1，后续传入接口返回的pageid，接口将持续返回符合条件的完整商品列表，该方式可以避免入口商品重复；示例2：根据pagesize和totalNum计算出总页数，按照需求返回指定页的商品（该方式可能在临近页取到重复商品）""",
    )

    pageSize: str = Field(
        ..., title=f"""每页条数，默认为100，最大值200，若小于10，则按10条处理，每页条数仅支持输入10,50,100,200"""
    )

    online: Optional[str] = Field(None, title=f"""是否下架，默认为1,1-未下架商品，0-已下架商品""")

    startTime: Optional[str] = Field(
        None, title=f"""商品提交开始时间，请求格式：yyyy-MM-dd HH:mm:ss"""
    )

    endTime: Optional[str] = Field(None, title=f"""商品上架结束时间，请求格式：yyyy-MM-dd HH:mm:ss""")

    sort: Optional[str] = Field(
        None,
        title=f"""排序字段，默认为0，0-综合排序，1-商品上架时间从新到旧，2-销量从高到低，3-领券量从高到低，4-佣金比例从高到低，5-价格（券后价）从高到低，6-价格（券后价）从低到高""",
    )


class GoodsActivityGoodsListArgs(BaseModel):
    pageId: str = Field(
        ...,
        title=f"""分页id，默认为1，支持传统的页码分页方式和scroll_id分页方式，根据用户自身需求传入值。示例1：商品入库，则首次传入1，后续传入接口第一次返回的pageid，接口将持续返回符合条件的完整商品列表，该方式可以避免入库商品重复；示例2：根据pagesize和totalNum计算出总页数，按照需求返回指定页的商品（该方式可能在临近页取到重复商品）""",
    )

    pageSize: Optional[str] = Field(None, title=f"""每页条数，默认为100，大于100按100处理""")

    activityId: str = Field(..., title=f"""通过热门活动API获取的活动id""")

    cid: Optional[str] = Field(
        None,
        title=f"""大淘客一级分类ID：1 -女装，2 -母婴，3 -美妆，4 -居家日用，5 -鞋品，6 -美食，7 -文娱车品，8 -数码家电，9 -男装，10 -内衣，11 -箱包，12 -配饰，13 -户外运动，14 -家装家纺""",
    )

    subcid: Optional[str] = Field(
        None, title=f"""大淘客二级分类ID：可通过超级分类接口获取二级分类id，当同时传入一级分类id和二级分类id时，以一级分类id为准"""
    )

    freeshipRemoteDistrict: Optional[str] = Field(None, title=f"""偏远地区包邮：1.是，0.否""")


class GoodsJdOneDollarPurchaseArgs(BaseModel):
    pageSize: str = Field(..., title=f"""每页返回条数，每页条数支持输入10,20，50,100。默认50条""")

    pageId: str = Field(..., title=f"""分页id：常规分页方式，请直接传入对应页码（比如：1,2,3……）""")

    cids: Optional[str] = Field(
        None, title=f"""大淘客的一级分类id，如果需要传多个，以英文逗号相隔，如：”1,2,3”。"""
    )

    sort: str = Field(..., title=f"""排序方式，默认为0，0-综合排序，5-价格（券后价）从高到低，6-价格（券后价）从低到高""")

    subsidy: Optional[str] = Field(None, title=f"""礼金类型（3-三元区；5-五元区）默认为三元区*（新增字段）*""")


class DelsJdOrderOuterGetOrderListArgs(BaseModel):
    orderTimeType: str = Field(
        ..., title=f"""订单时间类型：(1：下单时间，2：完成时间（购买用户确认收货时间），3：更新时间"""
    )

    startTime: str = Field(
        ..., title=f"""开始时间 格式yyyy-MM-dd HH:mm:ss，与endTime间隔不超过30天"""
    )

    endTime: str = Field(
        ..., title=f"""结束时间 格式yyyy-MM-dd HH:mm:ss，与startTime间隔不超过30天"""
    )

    pageId: Optional[str] = Field(None, title=f"""分页id，默认为1，支持scroll翻页查询""")

    pageSize: Optional[str] = Field(None, title=f"""每页记录条数，最大支持200""")

    code: Optional[str] = Field(None, title=f"""自定义标识，用于区分下游推广渠道*（如果没有做代理返利模式，可不传）*""")


class DelsJdKitOuterPromotionUnionConvertArgs(BaseModel):
    code: str = Field(..., title=f"""自定义标识，用于区分下游推广渠道。*只能由数字和字符串组成且字符串长度在5-16之间*""")

    materialId: str = Field(..., title=f"""使用【京东一元购】接口返回的*jumpURL*字段""")

    chainType: Optional[str] = Field(
        None, title=f"""转链类型，默认短链，短链有效期60天       1：长链2：短链3：长链+短链"""
    )


class DtkSync(DtkBase):
    def __init__(self, **kwargs):
        super().__init__(**kwargs)
        self._session = requests.Session()

    def _do_request(self, url: str, version: str, merge_args: dict) -> Optional[dict]:
        data = self.merge_args(merge_args, version)
        query = parse.urlencode(data)
        resp: requests.Response = self._session.get(f"{url}?{query}")
        if resp.ok:
            return resp.json()
        return None

    def dels_jd_kit_promotion_union_convert(
        self, args: DelsJdKitPromotionUnionConvertArgs
    ) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=52
        """
        url = "https://openapi.dataoke.com/api/dels/jd/kit/promotion-union-convert"
        version = "v1.0.0"
        return self._do_request(url, version, args.dict())

    def dels_jd_order_get_official_order_list(
        self, args: DelsJdOrderGetOfficialOrderListArgs
    ) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=51
        """
        url = "https://openapi.dataoke.com/api/dels/jd/order/get-official-order-list"
        version = "v1.0.0"
        return self._do_request(url, version, args.dict())

    def goods_get_history_low_price_list(
        self, args: GoodsGetHistoryLowPriceListArgs
    ) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=48
        """
        url = "https://openapi.dataoke.com/api/goods/get-history-low-price-list"
        version = "v1.0.0"
        return self._do_request(url, version, args.dict())

    def delanys_media_video_get_goods_list(
        self, args: DelanysMediaVideoGetGoodsListArgs
    ) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=46
        """
        url = "https://openapi.dataoke.com/api/delanys/media/video/get-goods-list"
        version = "v1.0.0"
        return self._do_request(url, version, args.dict())

    def delanys_media_video_get_category_list(self) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=47
        """
        url = "https://openapi.dataoke.com/api/delanys/media/video/get-category-list"
        version = "v1.0.0"
        return self._do_request(url, version, dict())

    def delanys_brand_get_goods_list(
        self, args: DelanysBrandGetGoodsListArgs
    ) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=45
        """
        url = "https://openapi.dataoke.com/api/delanys/brand/get-goods-list"
        version = "v1.0.0"
        return self._do_request(url, version, args.dict())

    def delanys_brand_get_column_list(
        self, args: DelanysBrandGetColumnListArgs
    ) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=44
        """
        url = "https://openapi.dataoke.com/api/delanys/brand/get-column-list"
        version = "v1.0.0"
        return self._do_request(url, version, args.dict())

    def comment_get_comment_list(
        self, args: CommentGetCommentListArgs
    ) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=43
        """
        url = "https://openapi.dataoke.com/api/comment/get-comment-list"
        version = "v1.0.0"
        return self._do_request(url, version, args.dict())

    def dels_shop_convert(self, args: DelsShopConvertArgs) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=42
        """
        url = "https://openapi.dataoke.com/api/dels/shop/convert"
        version = "v1.0.0"
        return self._do_request(url, version, args.dict())

    def subdivision_get_rank_list(
        self, args: SubdivisionGetRankListArgs
    ) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=41
        """
        url = "https://openapi.dataoke.com/api/subdivision/get-rank-list"
        version = "v1.0.0"
        return self._do_request(url, version, args.dict())

    def goods_super_discount_goods(
        self, args: GoodsSuperDiscountGoodsArgs
    ) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=39
        """
        url = "https://openapi.dataoke.com/api/goods/super-discount-goods"
        version = "v1.0.0"
        return self._do_request(url, version, args.dict())

    def goods_get_half_price_day(
        self, args: GoodsGetHalfPriceDayArgs
    ) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=38
        """
        url = "https://openapi.dataoke.com/api/goods/get-half-price-day"
        version = "v1.0.0"
        return self._do_request(url, version, args.dict())

    def dels_merge_red_envelopes(
        self, args: DelsMergeRedEnvelopesArgs
    ) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=37
        """
        url = "https://openapi.dataoke.com/api/dels/merge-red-envelopes"
        version = "v1.0.0"
        return self._do_request(url, version, args.dict())

    def goods_price_trend(self, args: GoodsPriceTrendArgs) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=36
        """
        url = "https://openapi.dataoke.com/api/goods/price-trend"
        version = "v1.0.0"
        return self._do_request(url, version, args.dict())

    def goods_liveMaterial_goods_list(
        self, args: GoodsLivematerialGoodsListArgs
    ) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=35
        """
        url = "https://openapi.dataoke.com/api/goods/liveMaterial-goods-list"
        version = "v1.0.0"
        return self._do_request(url, version, args.dict())

    def goods_explosive_goods_list(
        self, args: GoodsExplosiveGoodsListArgs
    ) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=34
        """
        url = "https://openapi.dataoke.com/api/goods/explosive-goods-list"
        version = "v1.0.0"
        return self._do_request(url, version, args.dict())

    def tb_service_parse_content(
        self, args: TbServiceParseContentArgs
    ) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=33
        """
        url = "https://openapi.dataoke.com/api/tb-service/parse-content"
        version = "v1.0.0"
        return self._do_request(url, version, args.dict())

    def goods_exclusive_goods_list(
        self, args: GoodsExclusiveGoodsListArgs
    ) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=32
        """
        url = "https://openapi.dataoke.com/api/goods/exclusive-goods-list"
        version = "v1.0.0"
        return self._do_request(url, version, args.dict())

    def tb_service_activity_link(
        self, args: TbServiceActivityLinkArgs
    ) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=31
        """
        url = "https://openapi.dataoke.com/api/tb-service/activity-link"
        version = "v1.0.0"
        return self._do_request(url, version, args.dict())

    def tb_service_twd_to_twd(self, args: TbServiceTwdToTwdArgs) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=30
        """
        url = "https://openapi.dataoke.com/api/tb-service/twd-to-twd"
        version = "v1.0.0"
        return self._do_request(url, version, args.dict())

    def goods_first_order_gift_money(
        self, args: GoodsFirstOrderGiftMoneyArgs
    ) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=29
        """
        url = "https://openapi.dataoke.com/api/goods/first-order-gift-money"
        version = "v1.1.0"
        return self._do_request(url, version, args.dict())

    def tb_service_creat_taokouling(
        self, args: TbServiceCreatTaokoulingArgs
    ) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=28
        """
        url = "https://openapi.dataoke.com/api/tb-service/creat-taokouling"
        version = "v1.0.0"
        return self._do_request(url, version, args.dict())

    def tb_service_get_order_details(
        self, args: TbServiceGetOrderDetailsArgs
    ) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=27
        """
        url = "https://openapi.dataoke.com/api/tb-service/get-order-details"
        version = "v1.0.0"
        return self._do_request(url, version, args.dict())

    def tb_service_parse_taokouling(
        self, args: TbServiceParseTaokoulingArgs
    ) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=26
        """
        url = "https://openapi.dataoke.com/api/tb-service/parse-taokouling"
        version = "v1.0.0"
        return self._do_request(url, version, args.dict())

    def tb_service_get_privilege_link(
        self, args: TbServiceGetPrivilegeLinkArgs
    ) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=7
        """
        url = "https://openapi.dataoke.com/api/tb-service/get-privilege-link"
        version = "v1.3.1"
        return self._do_request(url, version, args.dict())

    def goods_nine_op_goods_list(
        self, args: GoodsNineOpGoodsListArgs
    ) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=15
        """
        url = "https://openapi.dataoke.com/api/goods/nine/op-goods-list"
        version = "v2.0.0"
        return self._do_request(url, version, args.dict())

    def category_ddq_goods_list(self, args: CategoryDdqGoodsListArgs) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=23
        """
        url = "https://openapi.dataoke.com/api/category/ddq-goods-list"
        version = "v1.2.1"
        return self._do_request(url, version, args.dict())

    def goods_get_ranking_list(self, args: GoodsGetRankingListArgs) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=6
        """
        url = "https://openapi.dataoke.com/api/goods/get-ranking-list"
        version = "v1.3.0"
        return self._do_request(url, version, args.dict())

    def goods_friends_circle_list(
        self, args: GoodsFriendsCircleListArgs
    ) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=25
        """
        url = "https://openapi.dataoke.com/api/goods/friends-circle-list"
        version = "v1.3.0"
        return self._do_request(url, version, args.dict())

    def goods_topic_catalogue(self) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=21
        """
        url = "https://openapi.dataoke.com/api/goods/topic/catalogue"
        version = "v1.1.0"
        return self._do_request(url, version, dict())

    def goods_topic_goods_list(self, args: GoodsTopicGoodsListArgs) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=22
        """
        url = "https://openapi.dataoke.com/api/goods/topic/goods-list"
        version = "v1.2.2"
        return self._do_request(url, version, args.dict())

    def category_get_tb_topic_list(
        self, args: CategoryGetTbTopicListArgs
    ) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=24
        """
        url = "https://openapi.dataoke.com/api/category/get-tb-topic-list"
        version = "v1.2.0"
        return self._do_request(url, version, args.dict())

    def tb_service_get_brand_list(
        self, args: TbServiceGetBrandListArgs
    ) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=17
        """
        url = "https://openapi.dataoke.com/api/tb-service/get-brand-list"
        version = "v1.1.2"
        return self._do_request(url, version, args.dict())

    def goods_search_suggestion(
        self, args: GoodsSearchSuggestionArgs
    ) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=18
        """
        url = "https://openapi.dataoke.com/api/goods/search-suggestion"
        version = "v1.0.2"
        return self._do_request(url, version, args.dict())

    def goods_list_super_goods(self, args: GoodsListSuperGoodsArgs) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=14
        """
        url = "https://openapi.dataoke.com/api/goods/list-super-goods"
        version = "v1.3.0"
        return self._do_request(url, version, args.dict())

    def goods_list_similer_goods_by_open(
        self, args: GoodsListSimilerGoodsByOpenArgs
    ) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=16
        """
        url = "https://openapi.dataoke.com/api/goods/list-similer-goods-by-open"
        version = "v1.2.2"
        return self._do_request(url, version, args.dict())

    def goods_get_goods_list(self, args: GoodsGetGoodsListArgs) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=5
        """
        url = "https://openapi.dataoke.com/api/goods/get-goods-list"
        version = "v1.2.4"
        return self._do_request(url, version, args.dict())

    def goods_get_goods_details(self, args: GoodsGetGoodsDetailsArgs) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=8
        """
        url = "https://openapi.dataoke.com/api/goods/get-goods-details"
        version = "v1.2.3"
        return self._do_request(url, version, args.dict())

    def goods_get_dtk_search_goods(
        self, args: GoodsGetDtkSearchGoodsArgs
    ) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=9
        """
        url = "https://openapi.dataoke.com/api/goods/get-dtk-search-goods"
        version = "v2.1.2"
        return self._do_request(url, version, args.dict())

    def goods_pull_goods_by_time(
        self, args: GoodsPullGoodsByTimeArgs
    ) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=12
        """
        url = "https://openapi.dataoke.com/api/goods/pull-goods-by-time"
        version = "v1.2.3"
        return self._do_request(url, version, args.dict())

    def category_get_top100(self) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=4
        """
        url = "https://openapi.dataoke.com/api/category/get-top100"
        version = "v1.0.1"
        return self._do_request(url, version, dict())

    def goods_get_stale_goods_by_time(
        self, args: GoodsGetStaleGoodsByTimeArgs
    ) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=11
        """
        url = "https://openapi.dataoke.com/api/goods/get-stale-goods-by-time"
        version = "v1.0.1"
        return self._do_request(url, version, args.dict())

    def goods_get_newest_goods(self, args: GoodsGetNewestGoodsArgs) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=3
        """
        url = "https://openapi.dataoke.com/api/goods/get-newest-goods"
        version = "v1.2.0"
        return self._do_request(url, version, args.dict())

    def category_get_super_category(self) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=10
        """
        url = "https://openapi.dataoke.com/api/category/get-super-category"
        version = "v1.1.0"
        return self._do_request(url, version, dict())

    def tb_service_get_tb_service(
        self, args: TbServiceGetTbServiceArgs
    ) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=13
        """
        url = "https://openapi.dataoke.com/api/tb-service/get-tb-service"
        version = "v2.1.0"
        return self._do_request(url, version, args.dict())

    def goods_get_collection_list(
        self, args: GoodsGetCollectionListArgs
    ) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=1
        """
        url = "https://openapi.dataoke.com/api/goods/get-collection-list"
        version = "v1.0.1"
        return self._do_request(url, version, args.dict())

    def goods_get_owner_goods(self, args: GoodsGetOwnerGoodsArgs) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=2
        """
        url = "https://openapi.dataoke.com/api/goods/get-owner-goods"
        version = "v1.0.1"
        return self._do_request(url, version, args.dict())

    def goods_activity_goods_list(
        self, args: GoodsActivityGoodsListArgs
    ) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=20
        """
        url = "https://openapi.dataoke.com/api/goods/activity/goods-list"
        version = "v1.2.2"
        return self._do_request(url, version, args.dict())

    def goods_activity_catalogue(self) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=19
        """
        url = "https://openapi.dataoke.com/api/goods/activity/catalogue"
        version = "v1.1.0"
        return self._do_request(url, version, dict())

    def goods_jd_one_dollar_purchase(
        self, args: GoodsJdOneDollarPurchaseArgs
    ) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=40
        """
        url = "https://openapi.dataoke.com/api/goods/jd-one-dollar-purchase"
        version = "v1.0.1"
        return self._do_request(url, version, args.dict())

    def dels_jd_order_outer_get_order_list(
        self, args: DelsJdOrderOuterGetOrderListArgs
    ) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=50
        """
        url = "https://openapi.dataoke.com/api/dels/jd/order/outer/get-order-list"
        version = "v1.0.0"
        return self._do_request(url, version, args.dict())

    def dels_jd_kit_outer_promotion_union_convert(
        self, args: DelsJdKitOuterPromotionUnionConvertArgs
    ) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=49
        """
        url = (
            "https://openapi.dataoke.com/api/dels/jd/kit/outer/promotion-union-convert"
        )
        version = "v1.0.0"
        return self._do_request(url, version, args.dict())


class DtkAsync(DtkBase):
    def __init__(self, **kwargs):
        super().__init__(**kwargs)
        self._session = ClientSession()

    async def _do_request(
        self, url: str, version: str, merge_args: dict
    ) -> Optional[dict]:
        data = self.merge_args(merge_args, version)
        query = parse.urlencode(data)
        async with self._session.get(f"{url}?{query}") as resp:
            if 200 <= resp.status < 300:
                text = await resp.text()
                return json.loads(text)
            return None

    async def dels_jd_kit_promotion_union_convert(
        self, args: DelsJdKitPromotionUnionConvertArgs
    ) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=52
        """
        url = "https://openapi.dataoke.com/api/dels/jd/kit/promotion-union-convert"
        version = "v1.0.0"
        return await self._do_request(url, version, args.dict())

    async def dels_jd_order_get_official_order_list(
        self, args: DelsJdOrderGetOfficialOrderListArgs
    ) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=51
        """
        url = "https://openapi.dataoke.com/api/dels/jd/order/get-official-order-list"
        version = "v1.0.0"
        return await self._do_request(url, version, args.dict())

    async def goods_get_history_low_price_list(
        self, args: GoodsGetHistoryLowPriceListArgs
    ) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=48
        """
        url = "https://openapi.dataoke.com/api/goods/get-history-low-price-list"
        version = "v1.0.0"
        return await self._do_request(url, version, args.dict())

    async def delanys_media_video_get_goods_list(
        self, args: DelanysMediaVideoGetGoodsListArgs
    ) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=46
        """
        url = "https://openapi.dataoke.com/api/delanys/media/video/get-goods-list"
        version = "v1.0.0"
        return await self._do_request(url, version, args.dict())

    async def delanys_media_video_get_category_list(self) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=47
        """
        url = "https://openapi.dataoke.com/api/delanys/media/video/get-category-list"
        version = "v1.0.0"
        return await self._do_request(url, version, dict())

    async def delanys_brand_get_goods_list(
        self, args: DelanysBrandGetGoodsListArgs
    ) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=45
        """
        url = "https://openapi.dataoke.com/api/delanys/brand/get-goods-list"
        version = "v1.0.0"
        return await self._do_request(url, version, args.dict())

    async def delanys_brand_get_column_list(
        self, args: DelanysBrandGetColumnListArgs
    ) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=44
        """
        url = "https://openapi.dataoke.com/api/delanys/brand/get-column-list"
        version = "v1.0.0"
        return await self._do_request(url, version, args.dict())

    async def comment_get_comment_list(
        self, args: CommentGetCommentListArgs
    ) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=43
        """
        url = "https://openapi.dataoke.com/api/comment/get-comment-list"
        version = "v1.0.0"
        return await self._do_request(url, version, args.dict())

    async def dels_shop_convert(self, args: DelsShopConvertArgs) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=42
        """
        url = "https://openapi.dataoke.com/api/dels/shop/convert"
        version = "v1.0.0"
        return await self._do_request(url, version, args.dict())

    async def subdivision_get_rank_list(
        self, args: SubdivisionGetRankListArgs
    ) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=41
        """
        url = "https://openapi.dataoke.com/api/subdivision/get-rank-list"
        version = "v1.0.0"
        return await self._do_request(url, version, args.dict())

    async def goods_super_discount_goods(
        self, args: GoodsSuperDiscountGoodsArgs
    ) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=39
        """
        url = "https://openapi.dataoke.com/api/goods/super-discount-goods"
        version = "v1.0.0"
        return await self._do_request(url, version, args.dict())

    async def goods_get_half_price_day(
        self, args: GoodsGetHalfPriceDayArgs
    ) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=38
        """
        url = "https://openapi.dataoke.com/api/goods/get-half-price-day"
        version = "v1.0.0"
        return await self._do_request(url, version, args.dict())

    async def dels_merge_red_envelopes(
        self, args: DelsMergeRedEnvelopesArgs
    ) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=37
        """
        url = "https://openapi.dataoke.com/api/dels/merge-red-envelopes"
        version = "v1.0.0"
        return await self._do_request(url, version, args.dict())

    async def goods_price_trend(self, args: GoodsPriceTrendArgs) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=36
        """
        url = "https://openapi.dataoke.com/api/goods/price-trend"
        version = "v1.0.0"
        return await self._do_request(url, version, args.dict())

    async def goods_liveMaterial_goods_list(
        self, args: GoodsLivematerialGoodsListArgs
    ) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=35
        """
        url = "https://openapi.dataoke.com/api/goods/liveMaterial-goods-list"
        version = "v1.0.0"
        return await self._do_request(url, version, args.dict())

    async def goods_explosive_goods_list(
        self, args: GoodsExplosiveGoodsListArgs
    ) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=34
        """
        url = "https://openapi.dataoke.com/api/goods/explosive-goods-list"
        version = "v1.0.0"
        return await self._do_request(url, version, args.dict())

    async def tb_service_parse_content(
        self, args: TbServiceParseContentArgs
    ) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=33
        """
        url = "https://openapi.dataoke.com/api/tb-service/parse-content"
        version = "v1.0.0"
        return await self._do_request(url, version, args.dict())

    async def goods_exclusive_goods_list(
        self, args: GoodsExclusiveGoodsListArgs
    ) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=32
        """
        url = "https://openapi.dataoke.com/api/goods/exclusive-goods-list"
        version = "v1.0.0"
        return await self._do_request(url, version, args.dict())

    async def tb_service_activity_link(
        self, args: TbServiceActivityLinkArgs
    ) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=31
        """
        url = "https://openapi.dataoke.com/api/tb-service/activity-link"
        version = "v1.0.0"
        return await self._do_request(url, version, args.dict())

    async def tb_service_twd_to_twd(
        self, args: TbServiceTwdToTwdArgs
    ) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=30
        """
        url = "https://openapi.dataoke.com/api/tb-service/twd-to-twd"
        version = "v1.0.0"
        return await self._do_request(url, version, args.dict())

    async def goods_first_order_gift_money(
        self, args: GoodsFirstOrderGiftMoneyArgs
    ) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=29
        """
        url = "https://openapi.dataoke.com/api/goods/first-order-gift-money"
        version = "v1.1.0"
        return await self._do_request(url, version, args.dict())

    async def tb_service_creat_taokouling(
        self, args: TbServiceCreatTaokoulingArgs
    ) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=28
        """
        url = "https://openapi.dataoke.com/api/tb-service/creat-taokouling"
        version = "v1.0.0"
        return await self._do_request(url, version, args.dict())

    async def tb_service_get_order_details(
        self, args: TbServiceGetOrderDetailsArgs
    ) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=27
        """
        url = "https://openapi.dataoke.com/api/tb-service/get-order-details"
        version = "v1.0.0"
        return await self._do_request(url, version, args.dict())

    async def tb_service_parse_taokouling(
        self, args: TbServiceParseTaokoulingArgs
    ) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=26
        """
        url = "https://openapi.dataoke.com/api/tb-service/parse-taokouling"
        version = "v1.0.0"
        return await self._do_request(url, version, args.dict())

    async def tb_service_get_privilege_link(
        self, args: TbServiceGetPrivilegeLinkArgs
    ) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=7
        """
        url = "https://openapi.dataoke.com/api/tb-service/get-privilege-link"
        version = "v1.3.1"
        return await self._do_request(url, version, args.dict())

    async def goods_nine_op_goods_list(
        self, args: GoodsNineOpGoodsListArgs
    ) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=15
        """
        url = "https://openapi.dataoke.com/api/goods/nine/op-goods-list"
        version = "v2.0.0"
        return await self._do_request(url, version, args.dict())

    async def category_ddq_goods_list(
        self, args: CategoryDdqGoodsListArgs
    ) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=23
        """
        url = "https://openapi.dataoke.com/api/category/ddq-goods-list"
        version = "v1.2.1"
        return await self._do_request(url, version, args.dict())

    async def goods_get_ranking_list(
        self, args: GoodsGetRankingListArgs
    ) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=6
        """
        url = "https://openapi.dataoke.com/api/goods/get-ranking-list"
        version = "v1.3.0"
        return await self._do_request(url, version, args.dict())

    async def goods_friends_circle_list(
        self, args: GoodsFriendsCircleListArgs
    ) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=25
        """
        url = "https://openapi.dataoke.com/api/goods/friends-circle-list"
        version = "v1.3.0"
        return await self._do_request(url, version, args.dict())

    async def goods_topic_catalogue(self) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=21
        """
        url = "https://openapi.dataoke.com/api/goods/topic/catalogue"
        version = "v1.1.0"
        return await self._do_request(url, version, dict())

    async def goods_topic_goods_list(
        self, args: GoodsTopicGoodsListArgs
    ) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=22
        """
        url = "https://openapi.dataoke.com/api/goods/topic/goods-list"
        version = "v1.2.2"
        return await self._do_request(url, version, args.dict())

    async def category_get_tb_topic_list(
        self, args: CategoryGetTbTopicListArgs
    ) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=24
        """
        url = "https://openapi.dataoke.com/api/category/get-tb-topic-list"
        version = "v1.2.0"
        return await self._do_request(url, version, args.dict())

    async def tb_service_get_brand_list(
        self, args: TbServiceGetBrandListArgs
    ) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=17
        """
        url = "https://openapi.dataoke.com/api/tb-service/get-brand-list"
        version = "v1.1.2"
        return await self._do_request(url, version, args.dict())

    async def goods_search_suggestion(
        self, args: GoodsSearchSuggestionArgs
    ) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=18
        """
        url = "https://openapi.dataoke.com/api/goods/search-suggestion"
        version = "v1.0.2"
        return await self._do_request(url, version, args.dict())

    async def goods_list_super_goods(
        self, args: GoodsListSuperGoodsArgs
    ) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=14
        """
        url = "https://openapi.dataoke.com/api/goods/list-super-goods"
        version = "v1.3.0"
        return await self._do_request(url, version, args.dict())

    async def goods_list_similer_goods_by_open(
        self, args: GoodsListSimilerGoodsByOpenArgs
    ) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=16
        """
        url = "https://openapi.dataoke.com/api/goods/list-similer-goods-by-open"
        version = "v1.2.2"
        return await self._do_request(url, version, args.dict())

    async def goods_get_goods_list(self, args: GoodsGetGoodsListArgs) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=5
        """
        url = "https://openapi.dataoke.com/api/goods/get-goods-list"
        version = "v1.2.4"
        return await self._do_request(url, version, args.dict())

    async def goods_get_goods_details(
        self, args: GoodsGetGoodsDetailsArgs
    ) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=8
        """
        url = "https://openapi.dataoke.com/api/goods/get-goods-details"
        version = "v1.2.3"
        return await self._do_request(url, version, args.dict())

    async def goods_get_dtk_search_goods(
        self, args: GoodsGetDtkSearchGoodsArgs
    ) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=9
        """
        url = "https://openapi.dataoke.com/api/goods/get-dtk-search-goods"
        version = "v2.1.2"
        return await self._do_request(url, version, args.dict())

    async def goods_pull_goods_by_time(
        self, args: GoodsPullGoodsByTimeArgs
    ) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=12
        """
        url = "https://openapi.dataoke.com/api/goods/pull-goods-by-time"
        version = "v1.2.3"
        return await self._do_request(url, version, args.dict())

    async def category_get_top100(self) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=4
        """
        url = "https://openapi.dataoke.com/api/category/get-top100"
        version = "v1.0.1"
        return await self._do_request(url, version, dict())

    async def goods_get_stale_goods_by_time(
        self, args: GoodsGetStaleGoodsByTimeArgs
    ) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=11
        """
        url = "https://openapi.dataoke.com/api/goods/get-stale-goods-by-time"
        version = "v1.0.1"
        return await self._do_request(url, version, args.dict())

    async def goods_get_newest_goods(
        self, args: GoodsGetNewestGoodsArgs
    ) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=3
        """
        url = "https://openapi.dataoke.com/api/goods/get-newest-goods"
        version = "v1.2.0"
        return await self._do_request(url, version, args.dict())

    async def category_get_super_category(self) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=10
        """
        url = "https://openapi.dataoke.com/api/category/get-super-category"
        version = "v1.1.0"
        return await self._do_request(url, version, dict())

    async def tb_service_get_tb_service(
        self, args: TbServiceGetTbServiceArgs
    ) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=13
        """
        url = "https://openapi.dataoke.com/api/tb-service/get-tb-service"
        version = "v2.1.0"
        return await self._do_request(url, version, args.dict())

    async def goods_get_collection_list(
        self, args: GoodsGetCollectionListArgs
    ) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=1
        """
        url = "https://openapi.dataoke.com/api/goods/get-collection-list"
        version = "v1.0.1"
        return await self._do_request(url, version, args.dict())

    async def goods_get_owner_goods(
        self, args: GoodsGetOwnerGoodsArgs
    ) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=2
        """
        url = "https://openapi.dataoke.com/api/goods/get-owner-goods"
        version = "v1.0.1"
        return await self._do_request(url, version, args.dict())

    async def goods_activity_goods_list(
        self, args: GoodsActivityGoodsListArgs
    ) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=20
        """
        url = "https://openapi.dataoke.com/api/goods/activity/goods-list"
        version = "v1.2.2"
        return await self._do_request(url, version, args.dict())

    async def goods_activity_catalogue(self) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=19
        """
        url = "https://openapi.dataoke.com/api/goods/activity/catalogue"
        version = "v1.1.0"
        return await self._do_request(url, version, dict())

    async def goods_jd_one_dollar_purchase(
        self, args: GoodsJdOneDollarPurchaseArgs
    ) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=40
        """
        url = "https://openapi.dataoke.com/api/goods/jd-one-dollar-purchase"
        version = "v1.0.1"
        return await self._do_request(url, version, args.dict())

    async def dels_jd_order_outer_get_order_list(
        self, args: DelsJdOrderOuterGetOrderListArgs
    ) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=50
        """
        url = "https://openapi.dataoke.com/api/dels/jd/order/outer/get-order-list"
        version = "v1.0.0"
        return await self._do_request(url, version, args.dict())

    async def dels_jd_kit_outer_promotion_union_convert(
        self, args: DelsJdKitOuterPromotionUnionConvertArgs
    ) -> Optional[dict]:
        """
        doc: https://www.dataoke.com/pmc/api-d.html?id=49
        """
        url = (
            "https://openapi.dataoke.com/api/dels/jd/kit/outer/promotion-union-convert"
        )
        version = "v1.0.0"
        return await self._do_request(url, version, args.dict())
