# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['zurich']

package_data = \
{'': ['*']}

install_requires = \
['aiohttp>=3.0.0', 'yarl>=1.6.0']

setup_kwargs = {
    'name': 'zurich',
    'version': '0.1.1',
    'description': 'Asynchronous Python client providing Open Data information of Zurich (Switzerland)',
    'long_description': '<!-- Banner -->\n![alt Banner of the odp Zurich package](https://raw.githubusercontent.com/klaasnicolaas/python-zurich/main/assets/header_zurich-min.png)\n\n<!-- PROJECT SHIELDS -->\n[![GitHub Release][releases-shield]][releases]\n[![Python Versions][python-versions-shield]][pypi]\n![Project Stage][project-stage-shield]\n![Project Maintenance][maintenance-shield]\n[![License][license-shield]](LICENSE)\n\n[![GitHub Activity][commits-shield]][commits-url]\n[![PyPi Downloads][downloads-shield]][downloads-url]\n[![GitHub Last Commit][last-commit-shield]][commits-url]\n[![Stargazers][stars-shield]][stars-url]\n[![Issues][issues-shield]][issues-url]\n\n[![Code Quality][code-quality-shield]][code-quality]\n[![Build Status][build-shield]][build-url]\n[![Typing Status][typing-shield]][typing-url]\n\n[![Maintainability][maintainability-shield]][maintainability-url]\n[![Code Coverage][codecov-shield]][codecov-url]\n\nAsynchronous Python client for the open datasets of Zurich (Switzerland).\n\n## About\n\nA python package with which you can retrieve data from the Open Data Platform of Zurich via [their API][api]. This package was initially created to only retrieve parking data from the API, but the code base is made in such a way that it is easy to extend for other datasets from the same platform.\n\n## Installation\n\n```bash\npip install zurich\n```\n\n## Datasets\n\nYou can read the following datasets with this package:\n\n- [Parking spaces for disabled / Behindertenparkplätze][disabled_parkings] (413 locations)\n\n<details>\n    <summary>Click here to get more details</summary>\n\n### Disabled parkings\n\n| Variable | Type | Description |\n| :------- | :--- | :---------- |\n| `spot_id` | int | The ID of the parking spot |\n| `address` | str | The address of the parking spot |\n| `longitude` | float | The longitude of the parking spot |\n| `latitude` | float | The latitude of the parking spot |\n</details>\n\n## Example\n\n```python\nimport asyncio\n\nfrom zurich import ODPZurich\n\n\nasync def main() -> None:\n    """Show example on using the Open Data API client."""\n    async with ODPZurich() as client:\n        disabled_parkings = await client.disabled_parkings()\n        print(disabled_parkings)\n\n\nif __name__ == "__main__":\n    asyncio.run(main())\n```\n\n## Use cases\n\n[NIPKaart.nl][nipkaart]\n\nA website that provides insight into where disabled parking spaces are, based\non data from users and municipalities. Operates mainly in the Netherlands, but\nalso has plans to process data from abroad.\n\n## Contributing\n\nThis is an active open-source project. We are always open to people who want to\nuse the code or contribute to it.\n\nWe\'ve set up a separate document for our\n[contribution guidelines](CONTRIBUTING.md).\n\nThank you for being involved! :heart_eyes:\n\n## Setting up development environment\n\nThis Python project is fully managed using the [Poetry][poetry] dependency\nmanager.\n\nYou need at least:\n\n- Python 3.9+\n- [Poetry][poetry-install]\n\nInstall all packages, including all development requirements:\n\n```bash\npoetry install\n```\n\nPoetry creates by default an virtual environment where it installs all\nnecessary pip packages, to enter or exit the venv run the following commands:\n\n```bash\npoetry shell\nexit\n```\n\nSetup the pre-commit check, you must run this inside the virtual environment:\n\n```bash\npre-commit install\n```\n\n*Now you\'re all set to get started!*\n\nAs this repository uses the [pre-commit][pre-commit] framework, all changes\nare linted and tested with each commit. You can run all checks and tests\nmanually, using the following command:\n\n```bash\npoetry run pre-commit run --all-files\n```\n\nTo run just the Python tests:\n\n```bash\npoetry run pytest\n```\n\n## License\n\nMIT License\n\nCopyright (c) 2022-2023 Klaas Schoute\n\nPermission is hereby granted, free of charge, to any person obtaining a copy\nof this software and associated documentation files (the "Software"), to deal\nin the Software without restriction, including without limitation the rights\nto use, copy, modify, merge, publish, distribute, sublicense, and/or sell\ncopies of the Software, and to permit persons to whom the Software is\nfurnished to do so, subject to the following conditions:\n\nThe above copyright notice and this permission notice shall be included in all\ncopies or substantial portions of the Software.\n\nTHE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\nIMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\nFITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\nAUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\nLIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,\nOUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE\nSOFTWARE.\n\n[api]: https://data.stadt-zuerich.ch/\n[disabled_parkings]: https://data.stadt-zuerich.ch/dataset/geo_behindertenparkplaetze\n[nipkaart]: https://www.nipkaart.nl\n\n<!-- MARKDOWN LINKS & IMAGES -->\n[build-shield]: https://github.com/klaasnicolaas/python-zurich/actions/workflows/tests.yaml/badge.svg\n[build-url]: https://github.com/klaasnicolaas/python-zurich/actions/workflows/tests.yaml\n[code-quality-shield]: https://github.com/klaasnicolaas/python-zurich/actions/workflows/codeql.yaml/badge.svg\n[code-quality]: https://github.com/klaasnicolaas/python-zurich/actions/workflows/codeql.yaml\n[commits-shield]: https://img.shields.io/github/commit-activity/y/klaasnicolaas/python-zurich.svg\n[commits-url]: https://github.com/klaasnicolaas/python-zurich/commits/main\n[codecov-shield]: https://codecov.io/gh/klaasnicolaas/python-zurich/branch/main/graph/badge.svg?token=CLytQU0E0f\n[codecov-url]: https://codecov.io/gh/klaasnicolaas/python-zurich\n[downloads-shield]: https://img.shields.io/pypi/dm/zurich\n[downloads-url]: https://pypistats.org/packages/zurich\n[issues-shield]: https://img.shields.io/github/issues/klaasnicolaas/python-zurich.svg\n[issues-url]: https://github.com/klaasnicolaas/python-zurich/issues\n[license-shield]: https://img.shields.io/github/license/klaasnicolaas/python-zurich.svg\n[last-commit-shield]: https://img.shields.io/github/last-commit/klaasnicolaas/python-zurich.svg\n[maintenance-shield]: https://img.shields.io/maintenance/yes/2023.svg\n[maintainability-shield]: https://api.codeclimate.com/v1/badges/b4c705c4b91ea931d411/maintainability\n[maintainability-url]: https://codeclimate.com/github/klaasnicolaas/python-zurich/maintainability\n[project-stage-shield]: https://img.shields.io/badge/project%20stage-experimental-yellow.svg\n[pypi]: https://pypi.org/project/zurich/\n[python-versions-shield]: https://img.shields.io/pypi/pyversions/zurich\n[typing-shield]: https://github.com/klaasnicolaas/python-zurich/actions/workflows/typing.yaml/badge.svg\n[typing-url]: https://github.com/klaasnicolaas/python-zurich/actions/workflows/typing.yaml\n[releases-shield]: https://img.shields.io/github/release/klaasnicolaas/python-zurich.svg\n[releases]: https://github.com/klaasnicolaas/python-zurich/releases\n[stars-shield]: https://img.shields.io/github/stars/klaasnicolaas/python-zurich.svg\n[stars-url]: https://github.com/klaasnicolaas/python-zurich/stargazers\n\n[poetry-install]: https://python-poetry.org/docs/#installation\n[poetry]: https://python-poetry.org\n[pre-commit]: https://pre-commit.com\n',
    'author': 'Klaas Schoute',
    'author_email': 'hello@student-techlife.com',
    'maintainer': 'Klaas Schoute',
    'maintainer_email': 'hello@student-techlife.com',
    'url': 'https://github.com/klaasnicolaas/python-zurich',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.9,<4.0',
}


setup(**setup_kwargs)
